#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

// Movecall Moji configuration

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE  16000
#define AUDIO_OUTPUT_SAMPLE_RATE 16000

#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_4 //MCLK
#define AUDIO_I2S_GPIO_WS GPIO_NUM_7  //LRCK
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_5 //SCLK
#define AUDIO_I2S_GPIO_DIN  GPIO_NUM_6 //DOUT
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_8  //DIN

#define AUDIO_CODEC_PA_PIN       GPIO_NUM_1
#define AUDIO_CODEC_I2C_SDA_PIN  GPIO_NUM_16
#define AUDIO_CODEC_I2C_SCL_PIN  GPIO_NUM_15
#define AUDIO_CODEC_ES8311_ADDR  ES8311_CODEC_DEFAULT_ADDR

#define BUILTIN_LED_GPIO        GPIO_NUM_2
#define BOOT_BUTTON_GPIO        GPIO_NUM_0


#define DISPLAY_WIDTH   240
#define DISPLAY_HEIGHT  320
#define DISPLAY_MIRROR_X true
#define DISPLAY_MIRROR_Y false
#define DISPLAY_SWAP_XY false
#define DISPLAY_INVERT_COLOR    true
#define DISPLAY_RGB_ORDER LCD_RGB_ENDIAN_BGR
#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT false
#define DISPLAY_SPI_MODE 0

#define DISPLAY_BACKLIGHT_PIN GPIO_NUM_45


#define DISPLAY_CLK_PIN    GPIO_NUM_12
#define DISPLAY_MOSI_PIN    GPIO_NUM_11
#define DISPLAY_MISO_PIN    GPIO_NUM_13
#define DISPLAY_CS_PIN      GPIO_NUM_10
#define DISPLAY_DC_PIN      GPIO_NUM_46
//#define DISPLAY_SPI_RESET_PIN   GPIO_NUM_EN
#define DISPLAY_RST_PIN GPIO_NUM_NC
// #define LCD_RGB_ELEMENT_ORDER_BGR   GPIO_NUM_42
#define DISPLAY_SPI_SCLK_HZ     (40 * 1000 * 1000)

#define TP_PIN_NUM_TP_RST   (GPIO_NUM_18)
#define TP_PIN_NUM_TP_INT   (GPIO_NUM_17)


// 电量检测相关引脚定义
#define BATTERY_ADC_PIN         GPIO_NUM_9  // 电池电压检测ADC引脚
#define BATTERY_CHARGING_PIN    GPIO_NUM_NC // 充电状态检测引脚

#endif // _BOARD_CONFIG_H_
