#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#define AUDIO_INPUT_SAMPLE_RATE 24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_19
#define AUDIO_I2S_GPIO_WS GPIO_NUM_22
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_20
#define AUDIO_I2S_GPIO_DIN GPIO_NUM_21
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_23

#define AUDIO_CODEC_PA_PIN GPIO_NUM_NC
#define AUDIO_CODEC_I2C_SDA_PIN GPIO_NUM_8
#define AUDIO_CODEC_I2C_SCL_PIN GPIO_NUM_7
#define AUDIO_CODEC_ES8311_ADDR ES8311_CODEC_DEFAULT_ADDR

#define I2C_ADDRESS         ESP_IO_EXPANDER_I2C_TCA9554_ADDRESS_000
#define BOOT_BUTTON_GPIO GPIO_NUM_9

#define EXAMPLE_PIN_NUM_LCD_CS GPIO_NUM_5
#define EXAMPLE_PIN_NUM_LCD_PCLK GPIO_NUM_0
#define EXAMPLE_PIN_NUM_LCD_DATA0 GPIO_NUM_1
#define EXAMPLE_PIN_NUM_LCD_DATA1 GPIO_NUM_2
#define EXAMPLE_PIN_NUM_LCD_DATA2 GPIO_NUM_3
#define EXAMPLE_PIN_NUM_LCD_DATA3 GPIO_NUM_4
#define EXAMPLE_PIN_NUM_LCD_RST GPIO_NUM_NC
#define DISPLAY_WIDTH 368
#define DISPLAY_HEIGHT 448
#define DISPLAY_MIRROR_X false
#define DISPLAY_MIRROR_Y false
#define DISPLAY_SWAP_XY false

#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0

#define DISPLAY_BACKLIGHT_PIN GPIO_NUM_NC
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT false
#endif // _BOARD_CONFIG_H_
