#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>
#include <driver/spi_master.h>

#define AUDIO_INPUT_SAMPLE_RATE 24000
#define AUDIO_OUTPUT_SAMPLE_RATE 24000

#define AUDIO_INPUT_REFERENCE    true

#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_19
#define AUDIO_I2S_GPIO_WS GPIO_NUM_22
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_20
#define AUDIO_I2S_GPIO_DIN GPIO_NUM_21
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_23

#define AUDIO_CODEC_PA_PIN      GPIO_NUM_0
#define AUDIO_CODEC_I2C_SDA_PIN GPIO_NUM_7
#define AUDIO_CODEC_I2C_SCL_PIN GPIO_NUM_8
#define AUDIO_CODEC_ES8311_ADDR ES8311_CODEC_DEFAULT_ADDR
#define AUDIO_CODEC_ES7210_ADDR  ES7210_CODEC_DEFAULT_ADDR

#define BOOT_BUTTON_GPIO        GPIO_NUM_9
#define PWR_BUTTON_GPIO         GPIO_NUM_18

#define DISPLAY_SPI_MODE        SPI2_HOST
#define DISPLAY_CS_PIN          GPIO_NUM_5
#define DISPLAY_MOSI_PIN        GPIO_NUM_2
#define DISPLAY_MISO_PIN        GPIO_NUM_NC
#define DISPLAY_CLK_PIN         GPIO_NUM_1
#define DISPLAY_DC_PIN          GPIO_NUM_3
#define DISPLAY_RST_PIN         GPIO_NUM_4

#define DISPLAY_TOUCH_INT_PIN   GPIO_NUM_11
#define DISPLAY_TOUCH_RST_PIN   GPIO_NUM_NC

#define DISPLAY_WIDTH           240
#define DISPLAY_HEIGHT          284
#define DISPLAY_MIRROR_X        false
#define DISPLAY_MIRROR_Y        false
#define DISPLAY_SWAP_XY         false

#define DISPLAY_OFFSET_X        0
#define DISPLAY_OFFSET_Y        0

#define DISPLAY_BACKLIGHT_PIN   GPIO_NUM_6
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT false

#endif // _BOARD_CONFIG_H_
