/*******************************************************************************
 * Size: 14 px
 * Bpp: 1
 * Opts: --force-fast-kern-format --no-compress --no-prefilter --font ttf/noto-basic.ttf --format lvgl --lv-include lvgl.h --bpp 1 -o src/font_noto_basic_14_1.c --size 14 -r 0x0-0xfffff
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef FONT_NOTO_BASIC_14_1
#define FONT_NOTO_BASIC_14_1 1
#endif

#if FONT_NOTO_BASIC_14_1

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */
    0x0,

    /* U+0021 "!" */
    0xfe, 0xc0,

    /* U+0022 "\"" */
    0x99, 0x99,

    /* U+0023 "#" */
    0x12, 0x9, 0x4, 0x8f, 0xf1, 0x21, 0x23, 0xfc,
    0x48, 0x24, 0x12, 0x0,

    /* U+0024 "$" */
    0x11, 0xf9, 0x24, 0xf0, 0xe1, 0xc5, 0x17, 0xe1,
    0x4,

    /* U+0025 "%" */
    0x61, 0x24, 0x89, 0x22, 0x50, 0x95, 0x9a, 0x90,
    0xa4, 0x49, 0x12, 0x48, 0x60,

    /* U+0026 "&" */
    0x38, 0x11, 0x4, 0x41, 0xb0, 0x30, 0x16, 0x28,
    0xd2, 0x1c, 0xc7, 0x1f, 0x60,

    /* U+0027 "'" */
    0xf0,

    /* U+0028 "(" */
    0x69, 0x49, 0x24, 0x91, 0x26,

    /* U+0029 ")" */
    0xc9, 0x12, 0x49, 0x25, 0x2c,

    /* U+002A "*" */
    0x20, 0x8a, 0xde, 0x71, 0x60, 0x0,

    /* U+002B "+" */
    0x10, 0x20, 0x47, 0xf1, 0x2, 0x4, 0x0,

    /* U+002C "," */
    0xe8,

    /* U+002D "-" */
    0xe0,

    /* U+002E "." */
    0xc0,

    /* U+002F "/" */
    0x8, 0xc4, 0x22, 0x11, 0x88, 0x46, 0x0,

    /* U+0030 "0" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x60, 0xc1, 0x44,
    0x70,

    /* U+0031 "1" */
    0x37, 0x51, 0x11, 0x11, 0x11,

    /* U+0032 "2" */
    0x79, 0x8, 0x10, 0x20, 0xc1, 0x4, 0x10, 0x41,
    0xfc,

    /* U+0033 "3" */
    0x7a, 0x10, 0x43, 0x30, 0x30, 0x41, 0xf, 0xe0,

    /* U+0034 "4" */
    0x4, 0x18, 0x51, 0xa2, 0x48, 0xb1, 0x7f, 0x4,
    0x8,

    /* U+0035 "5" */
    0x7b, 0xc, 0x3e, 0xc, 0x10, 0x41, 0xb, 0xc0,

    /* U+0036 "6" */
    0x39, 0x8, 0x2e, 0xce, 0x18, 0x61, 0x4d, 0xe0,

    /* U+0037 "7" */
    0xfe, 0xc, 0x10, 0x60, 0x83, 0x4, 0x8, 0x20,
    0x40,

    /* U+0038 "8" */
    0x79, 0xa, 0x16, 0x67, 0x89, 0xa0, 0xc1, 0xc6,
    0xf8,

    /* U+0039 "9" */
    0x7b, 0x28, 0x61, 0x8d, 0xd0, 0x43, 0x9, 0xc0,

    /* U+003A ":" */
    0xc3,

    /* U+003B ";" */
    0x50, 0x1, 0x60,

    /* U+003C "<" */
    0x2, 0x18, 0xc6, 0xe, 0x3, 0x1, 0x80,

    /* U+003D "=" */
    0xfc, 0x0, 0x3f,

    /* U+003E ">" */
    0x80, 0xc0, 0xe0, 0x60, 0xce, 0x30, 0x0,

    /* U+003F "?" */
    0xf0, 0x42, 0x33, 0x21, 0x0, 0x42, 0x0,

    /* U+0040 "@" */
    0x1f, 0x6, 0x19, 0x3d, 0x6c, 0x99, 0x13, 0x22,
    0x64, 0x4c, 0x76, 0x40, 0xc, 0x0, 0x7c, 0x0,

    /* U+0041 "A" */
    0x8, 0xe, 0x5, 0x2, 0x82, 0x61, 0x11, 0xfc,
    0x82, 0x41, 0x40, 0xc0,

    /* U+0042 "B" */
    0xfd, 0xe, 0xc, 0x3f, 0x90, 0xe0, 0xc1, 0x87,
    0xf8,

    /* U+0043 "C" */
    0x3e, 0xc3, 0x4, 0x8, 0x10, 0x20, 0x60, 0x60,
    0x7c,

    /* U+0044 "D" */
    0xfc, 0x86, 0x83, 0x81, 0x81, 0x81, 0x81, 0x82,
    0x86, 0xf8,

    /* U+0045 "E" */
    0xfc, 0x21, 0xf, 0xc2, 0x10, 0x87, 0xc0,

    /* U+0046 "F" */
    0xfc, 0x21, 0xf, 0xc2, 0x10, 0x84, 0x0,

    /* U+0047 "G" */
    0x1f, 0x60, 0x40, 0x80, 0x87, 0x81, 0x81, 0xc1,
    0x61, 0x3f,

    /* U+0048 "H" */
    0x81, 0x81, 0x81, 0x81, 0xff, 0x81, 0x81, 0x81,
    0x81, 0x81,

    /* U+0049 "I" */
    0xe9, 0x24, 0x92, 0x5c,

    /* U+004A "J" */
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xe0,

    /* U+004B "K" */
    0x85, 0x1a, 0x65, 0x8e, 0x1e, 0x24, 0x44, 0x8d,
    0xc,

    /* U+004C "L" */
    0x84, 0x21, 0x8, 0x42, 0x10, 0x87, 0xc0,

    /* U+004D "M" */
    0xc0, 0xf0, 0x3a, 0x16, 0x85, 0xb1, 0x64, 0x99,
    0x26, 0x39, 0x8c, 0x63, 0x10,

    /* U+004E "N" */
    0xc1, 0xc1, 0xa1, 0xb1, 0x91, 0x89, 0x8d, 0x85,
    0x83, 0x83,

    /* U+004F "O" */
    0x3e, 0x31, 0xb0, 0x70, 0x18, 0xc, 0x6, 0x3,
    0x83, 0x61, 0x1f, 0x0,

    /* U+0050 "P" */
    0xfa, 0x38, 0x61, 0x8f, 0xe8, 0x20, 0x82, 0x0,

    /* U+0051 "Q" */
    0x3e, 0x31, 0xb0, 0x70, 0x18, 0xc, 0x6, 0x3,
    0x83, 0x61, 0x1f, 0x1, 0x80, 0x60, 0x18,

    /* U+0052 "R" */
    0xf9, 0x1a, 0x14, 0x28, 0xdf, 0x26, 0x44, 0x85,
    0x8,

    /* U+0053 "S" */
    0x7e, 0x18, 0x20, 0x60, 0x60, 0x41, 0x7, 0xe0,

    /* U+0054 "T" */
    0xfe, 0x20, 0x40, 0x81, 0x2, 0x4, 0x8, 0x10,
    0x20,

    /* U+0055 "U" */
    0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81,
    0x42, 0x3c,

    /* U+0056 "V" */
    0x81, 0x41, 0x43, 0x62, 0x26, 0x24, 0x34, 0x1c,
    0x18, 0x18,

    /* U+0057 "W" */
    0xc2, 0x1a, 0x28, 0x91, 0x44, 0x8a, 0x26, 0xd3,
    0x14, 0x50, 0xa2, 0x85, 0x14, 0x38, 0xe0, 0x82,
    0x0,

    /* U+0058 "X" */
    0x43, 0x62, 0x24, 0x1c, 0x18, 0x18, 0x34, 0x26,
    0x42, 0xc3,

    /* U+0059 "Y" */
    0x83, 0x8d, 0x11, 0x42, 0x82, 0x4, 0x8, 0x10,
    0x20,

    /* U+005A "Z" */
    0xfe, 0xc, 0x30, 0x41, 0x86, 0x8, 0x30, 0xc1,
    0xfc,

    /* U+005B "[" */
    0xf2, 0x49, 0x24, 0x92, 0x4e,

    /* U+005C "\\" */
    0xc2, 0x10, 0xc2, 0x10, 0x42, 0x18, 0x40,

    /* U+005D "]" */
    0xe4, 0x92, 0x49, 0x24, 0x9e,

    /* U+005E "^" */
    0x20, 0xc3, 0x12, 0x4a, 0x18, 0x40,

    /* U+005F "_" */
    0xfc,

    /* U+0060 "`" */
    0xb4,

    /* U+0061 "a" */
    0x78, 0x10, 0x5f, 0xc6, 0x18, 0xdd,

    /* U+0062 "b" */
    0x81, 0x2, 0x5, 0xcc, 0x50, 0x60, 0xc1, 0x83,
    0x8a, 0xe0,

    /* U+0063 "c" */
    0x3d, 0x8, 0x20, 0x82, 0x4, 0xf,

    /* U+0064 "d" */
    0x2, 0x4, 0x9, 0xd4, 0x70, 0x60, 0xc1, 0x82,
    0x8c, 0xe8,

    /* U+0065 "e" */
    0x79, 0x38, 0x7f, 0x82, 0x4, 0x4f,

    /* U+0066 "f" */
    0x3a, 0x11, 0xe4, 0x21, 0x8, 0x42, 0x10,

    /* U+0067 "g" */
    0x3a, 0x8e, 0xc, 0x18, 0x30, 0x51, 0xbd, 0x2,
    0x6, 0x1f, 0xe0,

    /* U+0068 "h" */
    0x82, 0x8, 0x2e, 0xc6, 0x18, 0x61, 0x86, 0x18,
    0x40,

    /* U+0069 "i" */
    0x9f, 0xe0,

    /* U+006A "j" */
    0x20, 0x12, 0x49, 0x24, 0x92, 0x70,

    /* U+006B "k" */
    0x82, 0x8, 0x22, 0x92, 0xce, 0x3c, 0x92, 0x68,
    0xc0,

    /* U+006C "l" */
    0xff, 0xe0,

    /* U+006D "m" */
    0xb9, 0xd8, 0xc6, 0x10, 0xc2, 0x18, 0x43, 0x8,
    0x61, 0xc, 0x21,

    /* U+006E "n" */
    0xbb, 0x18, 0x61, 0x86, 0x18, 0x61,

    /* U+006F "o" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x51, 0x1c,

    /* U+0070 "p" */
    0xb9, 0x8a, 0xc, 0x18, 0x30, 0x71, 0x5c, 0x81,
    0x2, 0x4, 0x0,

    /* U+0071 "q" */
    0x3a, 0x8e, 0xc, 0x18, 0x30, 0x51, 0x9d, 0x2,
    0x4, 0x8, 0x10,

    /* U+0072 "r" */
    0xbc, 0x88, 0x88, 0x88,

    /* U+0073 "s" */
    0x7c, 0x60, 0xc1, 0x84, 0x3e,

    /* U+0074 "t" */
    0x42, 0x3e, 0x84, 0x21, 0x8, 0x41, 0xc0,

    /* U+0075 "u" */
    0x86, 0x18, 0x61, 0x86, 0x18, 0xdd,

    /* U+0076 "v" */
    0x82, 0x8d, 0x12, 0x22, 0xc5, 0xa, 0x8,

    /* U+0077 "w" */
    0xc4, 0x69, 0x49, 0x29, 0x25, 0x26, 0xac, 0x63,
    0xc, 0x61, 0x8c,

    /* U+0078 "x" */
    0x46, 0xc8, 0xa0, 0xc1, 0x85, 0x99, 0x23,

    /* U+0079 "y" */
    0x87, 0x89, 0x12, 0x26, 0x85, 0xa, 0x8, 0x10,
    0x60, 0x86, 0x0,

    /* U+007A "z" */
    0xf8, 0xc4, 0x42, 0x23, 0x1f,

    /* U+007B "{" */
    0x19, 0x8, 0x42, 0x13, 0x4, 0x21, 0x8, 0x41,
    0x80,

    /* U+007C "|" */
    0xff, 0xfe,

    /* U+007D "}" */
    0xc1, 0x8, 0x42, 0x10, 0x64, 0x21, 0x8, 0x4c,
    0x0,

    /* U+007E "~" */
    0xf3, 0x3c,

    /* U+00A1 "¡" */
    0xdf, 0xc0,

    /* U+00A2 "¢" */
    0x3d, 0x8, 0x20, 0x82, 0x8, 0x11, 0x3c, 0x40,

    /* U+00A3 "£" */
    0x3c, 0x81, 0x2, 0xf, 0x88, 0x10, 0x20, 0x41,
    0xfc,

    /* U+00A4 "¤" */
    0xff, 0x38, 0x61, 0xcf, 0xf0,

    /* U+00A5 "¥" */
    0x82, 0x89, 0x11, 0x42, 0x8f, 0x84, 0x3e, 0x10,
    0x20,

    /* U+00A6 "¦" */
    0xf8, 0x3e,

    /* U+00A7 "§" */
    0x7c, 0x20, 0xe9, 0xc7, 0x26, 0x8, 0x7c,

    /* U+00A8 "¨" */
    0x90,

    /* U+00A9 "©" */
    0x1e, 0x18, 0x44, 0xea, 0x61, 0x90, 0x64, 0x19,
    0x6, 0x41, 0x4e, 0x98, 0x61, 0xe0,

    /* U+00AA "ª" */
    0xe1, 0x79, 0xf0,

    /* U+00AB "«" */
    0x25, 0xbd, 0xb6, 0x68, 0x90,

    /* U+00AC "¬" */
    0xfe, 0x4, 0x8, 0x10,

    /* U+00AD "­" */
    0xe0,

    /* U+00AE "®" */
    0x1e, 0x18, 0x45, 0xca, 0x49, 0x92, 0x67, 0x19,
    0x46, 0x49, 0x52, 0x98, 0x61, 0xe0,

    /* U+00AF "¯" */
    0xfe,

    /* U+00B0 "°" */
    0x74, 0x63, 0x17, 0x0,

    /* U+00B1 "±" */
    0x10, 0x20, 0x47, 0xf1, 0x2, 0x4, 0x0, 0xfe,

    /* U+00B2 "²" */
    0xf1, 0x12, 0x4f,

    /* U+00B3 "³" */
    0xf1, 0x61, 0x1e,

    /* U+00B4 "´" */
    0x78,

    /* U+00B5 "µ" */
    0x86, 0x18, 0x61, 0x86, 0x18, 0xfd, 0x82, 0x8,
    0x20,

    /* U+00B6 "¶" */
    0x7f, 0xf7, 0xef, 0xdf, 0xbf, 0x5e, 0x85, 0xa,
    0x14, 0x28, 0x50, 0xa0,

    /* U+00B7 "·" */
    0xc0,

    /* U+00B8 "¸" */
    0x48, 0xf0,

    /* U+00B9 "¹" */
    0x74, 0x92, 0x40,

    /* U+00BA "º" */
    0x69, 0x99, 0x60,

    /* U+00BB "»" */
    0x93, 0x66, 0xdb, 0x5a, 0x40,

    /* U+00BC "¼" */
    0x61, 0x28, 0x42, 0x20, 0x90, 0x24, 0x8a, 0x60,
    0xa8, 0x4a, 0x27, 0xc8, 0x20,

    /* U+00BD "½" */
    0x61, 0x28, 0x82, 0x20, 0x90, 0x25, 0xca, 0x11,
    0x4, 0x42, 0x21, 0x18, 0xf0,

    /* U+00BE "¾" */
    0xe1, 0x4, 0x41, 0x21, 0x88, 0x14, 0x5, 0x2e,
    0x98, 0x2a, 0x12, 0x84, 0xf2, 0x8,

    /* U+00BF "¿" */
    0x10, 0x80, 0x21, 0x11, 0x10, 0x84, 0x1e,

    /* U+00C0 "À" */
    0x10, 0x4, 0x0, 0x0, 0x0, 0x80, 0xe0, 0x50,
    0x28, 0x26, 0x11, 0x1f, 0xc8, 0x24, 0x14, 0xc,

    /* U+00C1 "Á" */
    0x4, 0x6, 0x2, 0x0, 0x0, 0x80, 0xe0, 0x50,
    0x28, 0x26, 0x11, 0x1f, 0xc8, 0x24, 0x14, 0xc,

    /* U+00C2 "Â" */
    0x18, 0xa, 0x8, 0x80, 0x0, 0x80, 0xe0, 0x50,
    0x28, 0x26, 0x11, 0x1f, 0xc8, 0x24, 0x14, 0xc,

    /* U+00C3 "Ã" */
    0x3e, 0x0, 0x0, 0x1, 0x1, 0xc0, 0xa0, 0x50,
    0x4c, 0x22, 0x3f, 0x90, 0x48, 0x28, 0x18,

    /* U+00C4 "Ä" */
    0x24, 0x0, 0x0, 0x3, 0x1, 0x81, 0xe0, 0x90,
    0x4c, 0x62, 0x3f, 0x30, 0xd0, 0x28, 0x10,

    /* U+00C5 "Å" */
    0x1c, 0xa, 0x5, 0x3, 0x80, 0xc0, 0xa0, 0x50,
    0x64, 0x22, 0x1f, 0x90, 0x48, 0x2c, 0x18,

    /* U+00C6 "Æ" */
    0xf, 0xe1, 0x40, 0x68, 0x9, 0x3, 0x3e, 0x44,
    0x1f, 0x82, 0x10, 0xc2, 0x10, 0x7c,

    /* U+00C7 "Ç" */
    0x3e, 0xc3, 0x4, 0x8, 0x10, 0x20, 0x60, 0x60,
    0x7c, 0x20, 0x60, 0x43, 0x0,

    /* U+00C8 "È" */
    0x61, 0x4, 0xf, 0xc2, 0x10, 0xfc, 0x21, 0x8,
    0x7c,

    /* U+00C9 "É" */
    0x11, 0x88, 0xf, 0xc2, 0x10, 0xfc, 0x21, 0x8,
    0x7c,

    /* U+00CA "Ê" */
    0x32, 0xa2, 0xf, 0xc2, 0x10, 0xfc, 0x21, 0x8,
    0x7c,

    /* U+00CB "Ë" */
    0x48, 0x0, 0x3f, 0x82, 0x8, 0x3e, 0x82, 0x8,
    0x20, 0xfc,

    /* U+00CC "Ì" */
    0x88, 0xe, 0x92, 0x49, 0x25, 0xc0,

    /* U+00CD "Í" */
    0x29, 0xe, 0x92, 0x49, 0x25, 0xc0,

    /* U+00CE "Î" */
    0x22, 0xa2, 0x7, 0x10, 0x84, 0x21, 0x8, 0x42,
    0x38,

    /* U+00CF "Ï" */
    0xa0, 0x74, 0x92, 0x49, 0x2e,

    /* U+00D0 "Ð" */
    0x7e, 0x21, 0x90, 0x68, 0x1f, 0x8a, 0x5, 0x2,
    0x82, 0x43, 0x3e, 0x0,

    /* U+00D1 "Ñ" */
    0x3c, 0x0, 0x0, 0xc1, 0xc1, 0xa1, 0xb1, 0x91,
    0x89, 0x8d, 0x85, 0x83, 0x83,

    /* U+00D2 "Ò" */
    0x10, 0x4, 0x1, 0x0, 0x3, 0xe3, 0x1b, 0x7,
    0x1, 0x80, 0xc0, 0x60, 0x38, 0x36, 0x11, 0xf0,

    /* U+00D3 "Ó" */
    0x4, 0x6, 0x2, 0x0, 0x3, 0xe3, 0x1b, 0x7,
    0x1, 0x80, 0xc0, 0x60, 0x38, 0x36, 0x11, 0xf0,

    /* U+00D4 "Ô" */
    0x18, 0xa, 0x8, 0x80, 0x3, 0xe3, 0x1b, 0x7,
    0x1, 0x80, 0xc0, 0x60, 0x38, 0x36, 0x11, 0xf0,

    /* U+00D5 "Õ" */
    0x3a, 0x17, 0x0, 0x0, 0x3, 0xe3, 0x1b, 0x7,
    0x1, 0x80, 0xc0, 0x60, 0x38, 0x36, 0x11, 0xf0,

    /* U+00D6 "Ö" */
    0x14, 0x0, 0x0, 0x7, 0xc6, 0x36, 0xe, 0x3,
    0x1, 0x80, 0xc0, 0x70, 0x6c, 0x23, 0xe0,

    /* U+00D7 "×" */
    0x85, 0x23, 0xc, 0x4a, 0x10,

    /* U+00D8 "Ø" */
    0x3f, 0x31, 0xb0, 0xf0, 0x98, 0x8c, 0xc6, 0x43,
    0xc3, 0x61, 0x3f, 0x0,

    /* U+00D9 "Ù" */
    0x30, 0x18, 0x8, 0x0, 0x81, 0x81, 0x81, 0x81,
    0x81, 0x81, 0x81, 0x81, 0x42, 0x3c,

    /* U+00DA "Ú" */
    0xc, 0x8, 0x10, 0x0, 0x81, 0x81, 0x81, 0x81,
    0x81, 0x81, 0x81, 0x81, 0x42, 0x3c,

    /* U+00DB "Û" */
    0x18, 0x3c, 0x42, 0x0, 0x81, 0x81, 0x81, 0x81,
    0x81, 0x81, 0x81, 0x81, 0x42, 0x3c,

    /* U+00DC "Ü" */
    0x24, 0x0, 0x0, 0x81, 0x81, 0x81, 0x81, 0x81,
    0x81, 0x81, 0x81, 0x42, 0x3c,

    /* U+00DD "Ý" */
    0x8, 0x20, 0x40, 0x8, 0x38, 0xd1, 0x14, 0x28,
    0x20, 0x40, 0x81, 0x2, 0x0,

    /* U+00DE "Þ" */
    0x83, 0xe8, 0xe1, 0x86, 0x18, 0xbc, 0x82, 0x0,

    /* U+00DF "ß" */
    0x79, 0xa, 0x14, 0x49, 0x12, 0x23, 0x43, 0x83,
    0x6, 0xf0,

    /* U+00E0 "à" */
    0x20, 0x40, 0x1e, 0x4, 0x17, 0xf1, 0x86, 0x37,
    0x40,

    /* U+00E1 "á" */
    0x8, 0x40, 0x1e, 0x4, 0x17, 0xf1, 0x86, 0x37,
    0x40,

    /* U+00E2 "â" */
    0x31, 0xa0, 0x1e, 0x4, 0x17, 0xf1, 0x86, 0x37,
    0x40,

    /* U+00E3 "ã" */
    0x7c, 0x7, 0x81, 0x5, 0xfc, 0x61, 0x8d, 0xd0,

    /* U+00E4 "ä" */
    0x48, 0x7, 0x81, 0x5, 0xfc, 0x61, 0x8d, 0xd0,

    /* U+00E5 "å" */
    0x38, 0xa3, 0x80, 0x78, 0x10, 0x5f, 0xc6, 0x18,
    0xdd,

    /* U+00E6 "æ" */
    0x7b, 0xc0, 0xcc, 0x10, 0xbf, 0xfc, 0x41, 0x8,
    0x23, 0x8b, 0x9f,

    /* U+00E7 "ç" */
    0x3d, 0x8, 0x20, 0x82, 0x4, 0xf, 0x10, 0x60,
    0x8c,

    /* U+00E8 "è" */
    0x60, 0xc0, 0x1e, 0x4e, 0x1f, 0xe0, 0x81, 0x13,
    0xc0,

    /* U+00E9 "é" */
    0x18, 0x40, 0x1e, 0x4e, 0x1f, 0xe0, 0x81, 0x13,
    0xc0,

    /* U+00EA "ê" */
    0x31, 0x20, 0x1e, 0x4e, 0x1f, 0xe0, 0x81, 0x13,
    0xc0,

    /* U+00EB "ë" */
    0x48, 0x7, 0x93, 0x87, 0xf8, 0x20, 0x44, 0xf0,

    /* U+00EC "ì" */
    0x91, 0x55, 0x54,

    /* U+00ED "í" */
    0x62, 0xaa, 0xa8,

    /* U+00EE "î" */
    0x22, 0x80, 0x42, 0x10, 0x84, 0x21, 0x8,

    /* U+00EF "ï" */
    0xa1, 0x24, 0x92, 0x48,

    /* U+00F0 "ð" */
    0x34, 0x31, 0xb0, 0x27, 0xb8, 0xe0, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+00F1 "ñ" */
    0x78, 0xb, 0xb1, 0x86, 0x18, 0x61, 0x86, 0x10,

    /* U+00F2 "ò" */
    0x20, 0x20, 0x1, 0xc4, 0x50, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+00F3 "ó" */
    0xc, 0x20, 0x1, 0xc4, 0x50, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+00F4 "ô" */
    0x38, 0xd8, 0x1, 0xc4, 0x50, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+00F5 "õ" */
    0x7c, 0x0, 0xe2, 0x28, 0x30, 0x60, 0xc1, 0x44,
    0x70,

    /* U+00F6 "ö" */
    0x28, 0x0, 0xe2, 0x28, 0x30, 0x60, 0xc1, 0x44,
    0x70,

    /* U+00F7 "÷" */
    0x10, 0x20, 0x7, 0xf0, 0x2, 0x4, 0x0,

    /* U+00F8 "ø" */
    0x3e, 0x8e, 0x2c, 0xdb, 0x34, 0x71, 0x7c,

    /* U+00F9 "ù" */
    0x60, 0xc0, 0x21, 0x86, 0x18, 0x61, 0x86, 0x37,
    0x40,

    /* U+00FA "ú" */
    0x18, 0x40, 0x21, 0x86, 0x18, 0x61, 0x86, 0x37,
    0x40,

    /* U+00FB "û" */
    0x31, 0x20, 0x21, 0x86, 0x18, 0x61, 0x86, 0x37,
    0x40,

    /* U+00FC "ü" */
    0x48, 0x8, 0x61, 0x86, 0x18, 0x61, 0x8d, 0xd0,

    /* U+00FD "ý" */
    0x8, 0x20, 0x4, 0x3c, 0x48, 0x91, 0x34, 0x28,
    0x50, 0x40, 0x83, 0x4, 0x30, 0x0,

    /* U+00FE "þ" */
    0x81, 0x2, 0x5, 0xcc, 0x50, 0x60, 0xc1, 0x83,
    0x8a, 0xe4, 0x8, 0x10, 0x20, 0x0,

    /* U+00FF "ÿ" */
    0x24, 0x0, 0x42, 0x42, 0x66, 0x24, 0x24, 0x3c,
    0x18, 0x18, 0x18, 0x10, 0x30, 0xe0,

    /* U+0103 "ă" */
    0x49, 0xe0, 0x1e, 0x4, 0x17, 0xf1, 0x86, 0x37,
    0x40,

    /* U+0105 "ą" */
    0x79, 0x10, 0x41, 0x7e, 0x18, 0xdd, 0x4, 0x20,
    0x83,

    /* U+0107 "ć" */
    0x18, 0x40, 0xf, 0x42, 0x8, 0x20, 0x81, 0x3,
    0xc0,

    /* U+010C "Č" */
    0x24, 0x38, 0x20, 0x3, 0xec, 0x30, 0x40, 0x81,
    0x2, 0x6, 0x6, 0x7, 0xc0,

    /* U+010D "č" */
    0x48, 0xc0, 0xf, 0x42, 0x8, 0x20, 0x81, 0x3,
    0xc0,

    /* U+010F "ď" */
    0x2, 0x81, 0x40, 0x87, 0x44, 0x64, 0x12, 0x9,
    0x4, 0x82, 0x23, 0xe, 0x80,

    /* U+0110 "Đ" */
    0x7e, 0x21, 0x90, 0x68, 0x1f, 0x8a, 0x5, 0x2,
    0x82, 0x43, 0x3e, 0x0,

    /* U+0111 "đ" */
    0x2, 0x3f, 0x2, 0x3a, 0x46, 0x82, 0x82, 0x82,
    0x82, 0x46, 0x3a,

    /* U+0119 "ę" */
    0x79, 0x28, 0x61, 0xfe, 0x4, 0xf, 0x8, 0x20,
    0x83,

    /* U+011B "ě" */
    0x48, 0xc0, 0x1e, 0x4e, 0x1f, 0xe0, 0x81, 0x13,
    0xc0,

    /* U+011F "ğ" */
    0x44, 0x88, 0xe1, 0xd4, 0x70, 0x60, 0xc1, 0x82,
    0x8d, 0xe8, 0x10, 0x30, 0xff, 0x0,

    /* U+0131 "ı" */
    0xff,

    /* U+013E "ľ" */
    0xb6, 0x49, 0x24, 0x92, 0x0,

    /* U+0141 "Ł" */
    0x41, 0x4, 0x10, 0x71, 0x8c, 0x10, 0x41, 0xf0,

    /* U+0142 "ł" */
    0x49, 0x26, 0xf2, 0x49, 0x0,

    /* U+0151 "ő" */
    0x2c, 0x90, 0x1, 0xc4, 0x50, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+0159 "ř" */
    0x96, 0xb, 0xc8, 0x88, 0x88, 0x80,

    /* U+015B "ś" */
    0x11, 0x0, 0xf8, 0xc1, 0x83, 0x8, 0x7c,

    /* U+015E "Ş" */
    0x7e, 0x18, 0x20, 0x60, 0x60, 0x41, 0x7, 0xe2,
    0xc, 0x11, 0x80,

    /* U+015F "ş" */
    0x7c, 0x60, 0xc1, 0x84, 0x3e, 0x21, 0x84, 0xc0,

    /* U+0161 "š" */
    0x53, 0x80, 0xf8, 0xc1, 0x83, 0x8, 0x7c,

    /* U+0165 "ť" */
    0x5, 0x14, 0x3e, 0x41, 0x4, 0x10, 0x41, 0x3,
    0x80,

    /* U+016F "ů" */
    0x38, 0xa3, 0x80, 0x86, 0x18, 0x61, 0x86, 0x18,
    0xdd,

    /* U+017A "ź" */
    0x11, 0x1, 0xf1, 0x88, 0x84, 0x46, 0x3e,

    /* U+017C "ż" */
    0x20, 0x1, 0xf1, 0x88, 0xc4, 0x46, 0x3e,

    /* U+017E "ž" */
    0x51, 0x81, 0xf1, 0x88, 0x84, 0x46, 0x3e,

    /* U+01B0 "ư" */
    0x1, 0xc2, 0xa1, 0x90, 0x88, 0x44, 0x22, 0x11,
    0x18, 0x74, 0x0,

    /* U+0219 "ș" */
    0x7c, 0x60, 0xc1, 0x84, 0x3e, 0x0, 0x8, 0x40,

    /* U+021B "ț" */
    0x47, 0xd0, 0x84, 0x21, 0x8, 0x38, 0x0, 0x42,
    0x0,

    /* U+0388 "Έ" */
    0x4f, 0xa4, 0x2, 0x1, 0x0, 0xf8, 0x40, 0x20,
    0x10, 0x8, 0x7, 0xc0,

    /* U+0391 "Α" */
    0x8, 0xe, 0x5, 0x2, 0x82, 0x61, 0x11, 0xfc,
    0x82, 0x41, 0x40, 0xc0,

    /* U+0392 "Β" */
    0xfd, 0xe, 0xc, 0x3f, 0x90, 0xe0, 0xc1, 0x87,
    0xf8,

    /* U+0393 "Γ" */
    0xfc, 0x21, 0x8, 0x42, 0x10, 0x84, 0x0,

    /* U+0395 "Ε" */
    0xfc, 0x21, 0xf, 0xc2, 0x10, 0x87, 0xc0,

    /* U+0397 "Η" */
    0x81, 0x81, 0x81, 0x81, 0xff, 0x81, 0x81, 0x81,
    0x81, 0x81,

    /* U+039B "Λ" */
    0x8, 0xc, 0x5, 0x6, 0x82, 0x41, 0x11, 0x88,
    0x86, 0x41, 0x40, 0x80,

    /* U+039C "Μ" */
    0xc0, 0xf0, 0x3a, 0x16, 0x85, 0xb1, 0x64, 0x99,
    0x26, 0x39, 0x8c, 0x63, 0x10,

    /* U+039D "Ν" */
    0xc1, 0xc1, 0xa1, 0xb1, 0x91, 0x89, 0x8d, 0x85,
    0x83, 0x83,

    /* U+039F "Ο" */
    0x3e, 0x31, 0xb0, 0x70, 0x18, 0xc, 0x6, 0x3,
    0x83, 0x61, 0x1f, 0x0,

    /* U+03A0 "Π" */
    0xff, 0x6, 0xc, 0x18, 0x30, 0x60, 0xc1, 0x83,
    0x4,

    /* U+03A3 "Σ" */
    0xfe, 0x81, 0x81, 0x81, 0x82, 0xc, 0x30, 0xc1,
    0xfc,

    /* U+03A4 "Τ" */
    0xfe, 0x20, 0x40, 0x81, 0x2, 0x4, 0x8, 0x10,
    0x20,

    /* U+03A6 "Φ" */
    0x4, 0x7, 0xf1, 0x11, 0x42, 0x18, 0x43, 0x8,
    0x61, 0xa, 0x26, 0x3f, 0x80, 0x80,

    /* U+03A7 "Χ" */
    0x43, 0x62, 0x24, 0x1c, 0x18, 0x18, 0x34, 0x26,
    0x42, 0xc3,

    /* U+03AC "ά" */
    0x8, 0x18, 0x0, 0x3a, 0x46, 0x82, 0x82, 0x82,
    0x82, 0x46, 0x3b,

    /* U+03AD "έ" */
    0x18, 0x40, 0x1f, 0x82, 0x7, 0x20, 0x82, 0x7,
    0x80,

    /* U+03AE "ή" */
    0x30, 0x80, 0x2e, 0xc6, 0x18, 0x61, 0x86, 0x18,
    0x41, 0x4, 0x10, 0x40,

    /* U+03AF "ί" */
    0x50, 0x49, 0x24, 0x91, 0x80,

    /* U+03B1 "α" */
    0x3a, 0x46, 0x82, 0x82, 0x82, 0x82, 0x46, 0x3b,

    /* U+03B2 "β" */
    0x79, 0x9a, 0x14, 0x28, 0xd6, 0x23, 0x41, 0x83,
    0xf, 0xf4, 0x8, 0x10, 0x20, 0x0,

    /* U+03B3 "γ" */
    0xc2, 0x85, 0xb, 0x12, 0x44, 0x8e, 0x8, 0x10,
    0x20, 0x40,

    /* U+03B4 "δ" */
    0x3c, 0xc1, 0x81, 0x83, 0xc8, 0xa0, 0xc1, 0x83,
    0x8c, 0xe0,

    /* U+03B5 "ε" */
    0x7c, 0x20, 0xe8, 0x42, 0xf,

    /* U+03B6 "ζ" */
    0xf8, 0x44, 0x46, 0x22, 0x10, 0x86, 0x1c, 0x10,
    0x84,

    /* U+03B7 "η" */
    0xbb, 0x18, 0x61, 0x86, 0x18, 0x61, 0x4, 0x10,
    0x41,

    /* U+03B8 "θ" */
    0x38, 0x8a, 0xc, 0x18, 0x3f, 0xe0, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+03B9 "ι" */
    0x92, 0x49, 0x23,

    /* U+03BA "κ" */
    0x8a, 0x4b, 0x38, 0xe2, 0x49, 0xa3,

    /* U+03BB "λ" */
    0xe0, 0x40, 0x40, 0x83, 0x85, 0xa, 0x36, 0x44,
    0x8b, 0x8,

    /* U+03BC "μ" */
    0x85, 0xa, 0x14, 0x28, 0x50, 0xa3, 0x7b, 0x81,
    0x2, 0x4, 0x0,

    /* U+03BD "ν" */
    0x42, 0x85, 0x9, 0x12, 0x44, 0x86, 0xc,

    /* U+03BE "ξ" */
    0x79, 0x10, 0x84, 0x1d, 0x10, 0x84, 0x1c, 0x30,
    0x84,

    /* U+03BF "ο" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x51, 0x1c,

    /* U+03C0 "π" */
    0xff, 0x91, 0x8, 0x84, 0x42, 0x21, 0x10, 0x88,
    0x47,

    /* U+03C1 "ρ" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x61, 0x7c, 0x81,
    0x2, 0x4, 0x0,

    /* U+03C2 "ς" */
    0x7a, 0x21, 0x8, 0x43, 0xe, 0x8, 0x42,

    /* U+03C3 "σ" */
    0x3f, 0x44, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38,

    /* U+03C4 "τ" */
    0xfc, 0x82, 0x8, 0x20, 0x82, 0x7,

    /* U+03C5 "υ" */
    0x86, 0x18, 0x61, 0x86, 0x18, 0x9c,

    /* U+03C6 "φ" */
    0x8, 0x4, 0x2, 0x3, 0x86, 0xb6, 0x4e, 0x23,
    0x11, 0x88, 0xa4, 0xdf, 0xc1, 0x0, 0x80, 0x40,
    0x20,

    /* U+03C7 "χ" */
    0xc3, 0x42, 0x26, 0x24, 0x38, 0x18, 0x18, 0x38,
    0x2c, 0x64, 0x46, 0x83,

    /* U+03C8 "ψ" */
    0x8, 0x8, 0x8, 0x89, 0x89, 0x89, 0x89, 0x89,
    0x89, 0x4a, 0x3e, 0x8, 0x8, 0x8, 0x8,

    /* U+03C9 "ω" */
    0x41, 0x40, 0x60, 0x31, 0x18, 0x8c, 0x47, 0x66,
    0xee,

    /* U+03CC "ό" */
    0x8, 0x30, 0x1, 0xc4, 0x50, 0x60, 0xc1, 0x82,
    0x88, 0xe0,

    /* U+03CD "ύ" */
    0x18, 0x40, 0x21, 0x86, 0x18, 0x61, 0x87, 0x37,
    0x80,

    /* U+03CE "ώ" */
    0x4, 0x4, 0x0, 0x8, 0x28, 0xc, 0x6, 0x23,
    0x11, 0x88, 0xec, 0xdd, 0xc0,

    /* U+0406 "І" */
    0xff, 0xc0,

    /* U+0408 "Ј" */
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0xe0,

    /* U+0410 "А" */
    0x8, 0xe, 0x5, 0x2, 0x82, 0x61, 0x11, 0xfc,
    0x82, 0x41, 0x40, 0xc0,

    /* U+0411 "Б" */
    0xfe, 0x8, 0x20, 0xfa, 0x38, 0x61, 0x8f, 0xe0,

    /* U+0412 "В" */
    0xfd, 0xe, 0xc, 0x3f, 0x90, 0xe0, 0xc1, 0x87,
    0xf8,

    /* U+0413 "Г" */
    0xfc, 0x21, 0x8, 0x42, 0x10, 0x84, 0x0,

    /* U+0417 "З" */
    0xf8, 0x10, 0x43, 0x70, 0x30, 0x41, 0xf, 0xe0,

    /* U+0418 "И" */
    0x83, 0x83, 0x85, 0x89, 0x89, 0x91, 0xa1, 0xa1,
    0xc1, 0x81,

    /* U+041A "К" */
    0x85, 0x1a, 0x64, 0x8f, 0x12, 0x26, 0x44, 0x85,
    0xc,

    /* U+041C "М" */
    0xc0, 0xf0, 0x3a, 0x16, 0x85, 0xb1, 0x64, 0x99,
    0x26, 0x39, 0x8c, 0x63, 0x10,

    /* U+041D "Н" */
    0x81, 0x81, 0x81, 0x81, 0xff, 0x81, 0x81, 0x81,
    0x81, 0x81,

    /* U+041E "О" */
    0x3e, 0x31, 0xb0, 0x70, 0x18, 0xc, 0x6, 0x3,
    0x83, 0x63, 0x1f, 0x0,

    /* U+041F "П" */
    0xff, 0x6, 0xc, 0x18, 0x30, 0x60, 0xc1, 0x83,
    0x4,

    /* U+0420 "Р" */
    0xfa, 0x38, 0x61, 0x8f, 0xe8, 0x20, 0x82, 0x0,

    /* U+0421 "С" */
    0x3f, 0x60, 0xc0, 0x80, 0x80, 0x80, 0x80, 0xc0,
    0x61, 0x3f,

    /* U+0422 "Т" */
    0xfe, 0x20, 0x40, 0x81, 0x2, 0x4, 0x8, 0x10,
    0x20,

    /* U+0423 "У" */
    0xc1, 0x20, 0x98, 0x84, 0x43, 0x40, 0xa0, 0x70,
    0x10, 0x18, 0x38, 0x0,

    /* U+0427 "Ч" */
    0x83, 0x6, 0xc, 0x18, 0x2f, 0xc0, 0x81, 0x2,
    0x4,

    /* U+0430 "а" */
    0x78, 0x10, 0x5f, 0xc6, 0x18, 0xdd,

    /* U+0431 "б" */
    0x2, 0x7d, 0x4, 0xb, 0x98, 0xa0, 0xc1, 0x83,
    0x5, 0x11, 0xc0,

    /* U+0432 "в" */
    0xfa, 0x18, 0x7e, 0x86, 0x18, 0x7e,

    /* U+0433 "г" */
    0xf8, 0x88, 0x88, 0x88,

    /* U+0434 "д" */
    0x3e, 0x22, 0x22, 0x22, 0x22, 0x22, 0x42, 0xff,
    0x81, 0x81,

    /* U+0435 "е" */
    0x79, 0x38, 0x7f, 0x82, 0x4, 0x4f,

    /* U+0436 "ж" */
    0x44, 0x44, 0x90, 0xd6, 0xf, 0x83, 0x58, 0x49,
    0x19, 0x32, 0x22,

    /* U+0437 "з" */
    0xf8, 0x10, 0x5e, 0x4, 0x18, 0x7e,

    /* U+0438 "и" */
    0x8e, 0x39, 0x65, 0xa6, 0x9c, 0x71,

    /* U+0439 "й" */
    0x48, 0xe0, 0x23, 0x8e, 0x59, 0x69, 0xa7, 0x1c,
    0x40,

    /* U+043A "к" */
    0x8a, 0x69, 0x38, 0x92, 0x68, 0xa3,

    /* U+043B "л" */
    0x3e, 0x44, 0x89, 0x12, 0x24, 0x48, 0xe1,

    /* U+043C "м" */
    0xc3, 0xc3, 0xe7, 0xa5, 0xa5, 0x99, 0x99, 0x99,

    /* U+043D "н" */
    0x86, 0x18, 0x7f, 0x86, 0x18, 0x61,

    /* U+043E "о" */
    0x38, 0x8a, 0xc, 0x18, 0x30, 0x51, 0x1c,

    /* U+043F "п" */
    0xfe, 0x18, 0x61, 0x86, 0x18, 0x61,

    /* U+0440 "р" */
    0xb9, 0x8a, 0xc, 0x18, 0x30, 0x71, 0x5c, 0x81,
    0x2, 0x4, 0x0,

    /* U+0441 "с" */
    0x3d, 0x8, 0x20, 0x82, 0x4, 0xf,

    /* U+0442 "т" */
    0xfc, 0x41, 0x4, 0x10, 0x41, 0x4,

    /* U+0443 "у" */
    0x87, 0x89, 0x12, 0x66, 0x85, 0xa, 0x18, 0x10,
    0x60, 0x86, 0x0,

    /* U+0444 "ф" */
    0x8, 0x4, 0x2, 0x7, 0xc4, 0x94, 0x46, 0x23,
    0x11, 0x88, 0xa4, 0x8f, 0x81, 0x0, 0x80, 0x40,
    0x20,

    /* U+0445 "х" */
    0x46, 0xc8, 0xa0, 0xc3, 0x85, 0x19, 0x63,

    /* U+0446 "ц" */
    0x85, 0xa, 0x14, 0x28, 0x50, 0xa1, 0x7f, 0x2,
    0x4,

    /* U+0447 "ч" */
    0x86, 0x18, 0x61, 0x7c, 0x10, 0x41,

    /* U+0448 "ш" */
    0x84, 0x30, 0x86, 0x10, 0xc2, 0x18, 0x43, 0x8,
    0x61, 0xf, 0xff,

    /* U+0449 "щ" */
    0x84, 0x50, 0x8a, 0x11, 0x42, 0x28, 0x45, 0x8,
    0xa1, 0x17, 0xff, 0x0, 0x20, 0x4,

    /* U+044A "ъ" */
    0xe0, 0x20, 0x20, 0x3e, 0x21, 0x21, 0x21, 0x3e,

    /* U+044B "ы" */
    0x81, 0x81, 0x81, 0xf9, 0x85, 0x85, 0x85, 0xf9,

    /* U+044C "ь" */
    0x82, 0x8, 0x3e, 0x86, 0x18, 0x7e,

    /* U+044E "ю" */
    0x8f, 0x4c, 0xa4, 0x3e, 0x19, 0xc, 0x86, 0x25,
    0x1e,

    /* U+044F "я" */
    0x7e, 0x18, 0x61, 0x7d, 0x94, 0x61,

    /* U+0452 "ђ" */
    0x40, 0x83, 0xe2, 0xe6, 0x28, 0x50, 0xa1, 0x42,
    0x85, 0x8, 0x10, 0x20, 0x43, 0x0,

    /* U+0456 "і" */
    0xbf, 0xc0,

    /* U+0457 "ї" */
    0xa1, 0x24, 0x92, 0x48,

    /* U+0458 "ј" */
    0x20, 0x92, 0x49, 0x24, 0x93, 0x80,

    /* U+0459 "љ" */
    0x3e, 0x4, 0x40, 0x88, 0x11, 0xe2, 0x22, 0x44,
    0x48, 0x8e, 0x1e,

    /* U+045A "њ" */
    0x84, 0x10, 0x82, 0x10, 0x7f, 0xe8, 0x43, 0x8,
    0x61, 0xc, 0x3e,

    /* U+045B "ћ" */
    0x41, 0xf1, 0x2, 0xe6, 0x28, 0x50, 0xa1, 0x42,
    0x85, 0x8,

    /* U+060C "،" */
    0x6c,

    /* U+0622 "آ" */
    0xc5, 0x80, 0x42, 0x10, 0x84, 0x21, 0x8, 0x40,

    /* U+0623 "أ" */
    0xd3, 0x84, 0x92, 0x49, 0x24,

    /* U+0625 "إ" */
    0x49, 0x24, 0x92, 0x48, 0x38, 0xc0,

    /* U+0626 "ئ" */
    0x60, 0x10, 0x65, 0x21, 0x90, 0x84, 0x20, 0xc8,
    0xa, 0x2, 0xc1, 0xf, 0x80,

    /* U+0627 "ا" */
    0xff, 0xc0,

    /* U+0628 "ب" */
    0x0, 0x4, 0x0, 0x60, 0x3, 0x0, 0x1c, 0x1,
    0x9f, 0xf0, 0x0, 0x0, 0x40,

    /* U+0629 "ة" */
    0x78, 0x0, 0x45, 0x46, 0x31, 0x70,

    /* U+062A "ت" */
    0x7, 0x0, 0x0, 0xe0, 0x3, 0x0, 0x18, 0x0,
    0xe0, 0x8, 0xff, 0x80,

    /* U+062B "ث" */
    0x3, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x38, 0x0,
    0xc0, 0x6, 0x0, 0x38, 0x2, 0x3f, 0xe0,

    /* U+062C "ج" */
    0xf8, 0x7, 0x18, 0x20, 0x40, 0x80, 0x8c, 0x80,
    0x80, 0x60, 0x3f,

    /* U+062D "ح" */
    0xf8, 0x7, 0x18, 0x20, 0x40, 0x80, 0x80, 0x80,
    0x80, 0x60, 0x3f,

    /* U+062E "خ" */
    0x8, 0x0, 0x0, 0xf8, 0x7, 0x18, 0x20, 0x40,
    0x80, 0x80, 0x80, 0x80, 0x60, 0x3f,

    /* U+062F "د" */
    0x30, 0x82, 0x10, 0xf8,

    /* U+0630 "ذ" */
    0x60, 0x0, 0x21, 0x4, 0x21, 0xf0,

    /* U+0631 "ر" */
    0x0, 0xc2, 0x10, 0x88, 0xcc,

    /* U+0632 "ز" */
    0x10, 0x0, 0x20, 0x84, 0x21, 0x13, 0x0,

    /* U+0633 "س" */
    0x0, 0x0, 0x0, 0x3, 0x1, 0x11, 0x81, 0x11,
    0x81, 0x91, 0x81, 0xee, 0x81, 0x0, 0x43, 0x0,
    0x3e, 0x0,

    /* U+0634 "ش" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x28, 0x0, 0x0,
    0x0, 0x3, 0x1, 0x11, 0x1, 0x11, 0x81, 0x91,
    0x81, 0xee, 0x81, 0x0, 0xc3, 0x0, 0x3e, 0x0,

    /* U+0635 "ص" */
    0x0, 0x7, 0x0, 0x8c, 0x40, 0x4c, 0x30, 0x3c,
    0x38, 0x17, 0xe4, 0x8, 0x3, 0xc, 0x0, 0x78,
    0x0,

    /* U+0636 "ض" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe0, 0x11, 0x88, 0x9, 0x86, 0x7, 0x87, 0x2,
    0xfc, 0x81, 0x0, 0x61, 0x80, 0xf, 0x0, 0x0,

    /* U+0637 "ط" */
    0x10, 0x2, 0x0, 0x40, 0x8, 0x1, 0x0, 0x27,
    0x85, 0x88, 0xc1, 0x10, 0x7f, 0xf0,

    /* U+0638 "ظ" */
    0x10, 0x2, 0x0, 0x46, 0x8, 0x1, 0x0, 0x27,
    0x85, 0x88, 0xc1, 0x10, 0x7f, 0xf0,

    /* U+0639 "ع" */
    0x71, 0x2, 0x6, 0x47, 0x8, 0x30, 0x40, 0x81,
    0x1, 0x1, 0xf0,

    /* U+063A "غ" */
    0x10, 0x0, 0x3, 0x88, 0x10, 0x32, 0x38, 0x41,
    0x82, 0x4, 0x8, 0x8, 0xf, 0x80,

    /* U+0640 "ـ" */
    0xf0,

    /* U+0641 "ف" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0xe0, 0xd,
    0xc0, 0x46, 0x2, 0x30, 0xf, 0xc0, 0x1b, 0xff,
    0x80,

    /* U+0642 "ق" */
    0x5, 0x0, 0x0, 0x0, 0xe, 0x4, 0xf1, 0x18,
    0x3e, 0x1, 0x80, 0xd0, 0x63, 0xe0,

    /* U+0643 "ك" */
    0x0, 0x20, 0x4, 0x0, 0x83, 0x10, 0x43, 0x4,
    0x61, 0xc, 0x1, 0xc0, 0x67, 0xf0,

    /* U+0644 "ل" */
    0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x81,
    0x81, 0x81, 0x81, 0xc2, 0x3c,

    /* U+0645 "م" */
    0x39, 0x34, 0x41, 0x7e, 0x8, 0x20, 0x82, 0x4,
    0x0,

    /* U+0646 "ن" */
    0x8, 0x0, 0x2, 0x3, 0x81, 0x81, 0x81, 0x81,
    0xc2, 0x3c,

    /* U+0647 "ه" */
    0x18, 0xe, 0x9, 0x84, 0xe2, 0x50, 0xcb, 0xfc,

    /* U+0648 "و" */
    0x76, 0xe3, 0x17, 0x8c, 0xd8,

    /* U+0649 "ى" */
    0x1, 0x80, 0x80, 0x42, 0x10, 0x83, 0x20, 0x28,
    0xb, 0x4, 0x3e, 0x0,

    /* U+064A "ي" */
    0x1, 0x80, 0x80, 0x42, 0x10, 0x83, 0x20, 0x28,
    0xb, 0x4, 0x3e, 0x0, 0x0, 0x0, 0x78,

    /* U+064B "ً" */
    0x1d, 0xc0,

    /* U+064F "ُ" */
    0x35, 0x34,

    /* U+067E "پ" */
    0x0, 0x4, 0x0, 0x60, 0x3, 0x0, 0x1c, 0x1,
    0x9f, 0xf0, 0x0, 0x0, 0x0, 0x7, 0x0, 0x10,
    0x0,

    /* U+0698 "ژ" */
    0x10, 0xa, 0x0, 0x8, 0x21, 0x8, 0x44, 0xc0,
    0x0,

    /* U+06A9 "ک" */
    0x0, 0x30, 0x6, 0x1, 0x80, 0x10, 0x1, 0x88,
    0xc, 0x80, 0x68, 0x2, 0xc0, 0x63, 0xf8,

    /* U+06AF "گ" */
    0x0, 0x0, 0x6, 0x1, 0xb0, 0x26, 0x1, 0x80,
    0x10, 0x1, 0x88, 0xc, 0x80, 0x68, 0x2, 0xc0,
    0x63, 0xf8,

    /* U+06CC "ی" */
    0x1, 0x80, 0x80, 0x42, 0x10, 0x83, 0x20, 0x28,
    0xb, 0x4, 0x3e, 0x0,

    /* U+0901 "ँ" */
    0x24, 0x5c,

    /* U+0902 "ं" */
    0x80,

    /* U+0903 "ः" */
    0xe1, 0x24, 0x12, 0x40,

    /* U+0905 "अ" */
    0x3d, 0xe0, 0x90, 0x12, 0xe, 0x44, 0x78, 0x89,
    0x9, 0x21, 0xe4, 0x0, 0x80,

    /* U+0906 "आ" */
    0x3d, 0xfc, 0x12, 0x60, 0x49, 0x87, 0x26, 0x47,
    0x99, 0x12, 0x62, 0x49, 0x8f, 0x26, 0x0, 0x98,

    /* U+0907 "इ" */
    0xfe, 0x9, 0xf2, 0x4, 0x7, 0x1, 0x22, 0x78,
    0x20, 0x20,

    /* U+0909 "उ" */
    0xff, 0x2, 0x2, 0x6, 0x4c, 0x42, 0x42, 0x22,
    0x1c,

    /* U+090F "ए" */
    0xff, 0x46, 0x46, 0x46, 0x44, 0x4c, 0x30, 0xc,
    0x6, 0x6,

    /* U+0915 "क" */
    0xff, 0xe0, 0x80, 0xf0, 0x23, 0xc4, 0x64, 0x88,
    0x8f, 0x10, 0x26, 0x4, 0x0,

    /* U+0916 "ख" */
    0xff, 0xf1, 0x4, 0x13, 0xc5, 0x44, 0x64, 0x44,
    0x44, 0x23, 0xc1, 0x4, 0xf, 0xc0,

    /* U+0917 "ग" */
    0xff, 0x22, 0x22, 0x22, 0x62, 0x62, 0x2, 0x2,
    0x2,

    /* U+091A "च" */
    0xff, 0x80, 0x80, 0x4f, 0xa3, 0x11, 0x8, 0x7c,
    0x2, 0x1, 0x0,

    /* U+091C "ज" */
    0xff, 0xe0, 0x10, 0x2, 0x27, 0xc4, 0x48, 0x89,
    0x9, 0x20, 0xe4, 0x0, 0x80,

    /* U+091F "ट" */
    0xfe, 0x8, 0x11, 0xe6, 0x8, 0x10, 0x31, 0x3c,

    /* U+0921 "ड" */
    0xff, 0x4, 0x3c, 0x40, 0x40, 0x3c, 0x2, 0x42,
    0x3c,

    /* U+0923 "ण" */
    0xff, 0xd1, 0x24, 0x49, 0x12, 0x44, 0x99, 0x23,
    0x88, 0x2, 0x0, 0x80,

    /* U+0924 "त" */
    0xff, 0x2, 0x2, 0x3e, 0x42, 0x42, 0x42, 0x62,
    0x32,

    /* U+0925 "थ" */
    0xe7, 0xc9, 0x34, 0x86, 0x4e, 0x22, 0x10, 0xf8,
    0x4, 0x2, 0x0,

    /* U+0926 "द" */
    0xff, 0x4, 0x3c, 0x60, 0x40, 0x46, 0x66, 0x3c,
    0x2, 0x2,

    /* U+0927 "ध" */
    0x77, 0x52, 0x52, 0x72, 0x62, 0x42, 0x66, 0x3a,
    0x2,

    /* U+0928 "न" */
    0xff, 0x4, 0x4, 0x4, 0xfc, 0x64, 0x4, 0x4,
    0x4,

    /* U+092A "प" */
    0xff, 0x42, 0x42, 0x42, 0x42, 0x66, 0x3e, 0x2,
    0x2,

    /* U+092B "फ" */
    0xff, 0xe8, 0x81, 0x10, 0x23, 0xc4, 0x64, 0x98,
    0x8f, 0x10, 0x26, 0x4, 0x0,

    /* U+092C "ब" */
    0xff, 0x2, 0x3a, 0x72, 0x52, 0x4a, 0x3e, 0x2,
    0x2,

    /* U+092D "भ" */
    0xe7, 0xc8, 0xb4, 0x42, 0x21, 0x11, 0xf8, 0xc4,
    0x2, 0x1, 0x0,

    /* U+092E "म" */
    0xff, 0x22, 0x22, 0x22, 0x7e, 0x62, 0x2, 0x2,
    0x2,

    /* U+092F "य" */
    0xff, 0x32, 0x12, 0x32, 0x42, 0x66, 0x3e, 0x2,
    0x2,

    /* U+0930 "र" */
    0xfc, 0x20, 0x96, 0x71, 0x83, 0x4, 0x8,

    /* U+0932 "ल" */
    0xff, 0xc0, 0x40, 0x11, 0xfc, 0x4d, 0x12, 0x44,
    0x11, 0x84, 0x31, 0x0,

    /* U+0935 "व" */
    0xff, 0x4, 0x3c, 0x44, 0x44, 0x44, 0x7c, 0x4,
    0x4,

    /* U+0936 "श" */
    0x7b, 0xd2, 0x46, 0xd0, 0xf4, 0x9, 0x1c, 0x43,
    0x10, 0x64, 0x9, 0x0,

    /* U+0937 "ष" */
    0xff, 0x62, 0x52, 0x4a, 0x46, 0x66, 0x3e, 0x2,
    0x2,

    /* U+0938 "स" */
    0xff, 0xc4, 0x41, 0x11, 0x44, 0x7f, 0x10, 0x42,
    0x10, 0x44, 0x19, 0x0,

    /* U+0939 "ह" */
    0xff, 0x4, 0x7c, 0x40, 0x40, 0x3c, 0x46, 0x46,
    0x44, 0x30, 0x18,

    /* U+093C "़" */
    0xc0,

    /* U+093E "ा" */
    0xf4, 0x44, 0x44, 0x44, 0x40,

    /* U+093F "ि" */
    0x3e, 0xc, 0x61, 0x2, 0x20, 0x2f, 0x0, 0x80,
    0x10, 0x2, 0x0, 0x40, 0x8, 0x1, 0x0, 0x20,
    0x4, 0x0,

    /* U+0940 "ी" */
    0x61, 0x22, 0x24, 0x41, 0xe1, 0x2, 0x4, 0x8,
    0x10, 0x20, 0x40, 0x80,

    /* U+0941 "ु" */
    0x1c, 0x85, 0x89, 0xe0,

    /* U+0942 "ू" */
    0x72, 0x28, 0x5d,

    /* U+0943 "ृ" */
    0x68, 0x87,

    /* U+0947 "े" */
    0xe0, 0x84, 0x30,

    /* U+0948 "ै" */
    0xe0, 0xbc, 0x30,

    /* U+0949 "ॉ" */
    0x84, 0xbc, 0x7, 0x90, 0x84, 0x21, 0x8, 0x42,
    0x0,

    /* U+094B "ो" */
    0xc0, 0x82, 0x4, 0x3c, 0x41, 0x4, 0x10, 0x41,
    0x4, 0x10,

    /* U+094D "्" */
    0x60, 0x82,

    /* U+0E01 "ก" */
    0x7a, 0x38, 0x59, 0x86, 0x18, 0x61,

    /* U+0E02 "ข" */
    0xca, 0x53, 0x18, 0xc6, 0x2e,

    /* U+0E04 "ค" */
    0x7b, 0x38, 0x61, 0xf6, 0x18, 0x61,

    /* U+0E07 "ง" */
    0x5c, 0x8d, 0x9, 0x12, 0x24, 0x4d, 0xc,

    /* U+0E08 "จ" */
    0x7a, 0x30, 0x59, 0x24, 0x92, 0xce,

    /* U+0E09 "ฉ" */
    0xf8, 0x30, 0x61, 0x86, 0x18, 0xdd,

    /* U+0E0A "ช" */
    0xca, 0x55, 0x18, 0xc6, 0x2e,

    /* U+0E0B "ซ" */
    0x64, 0x96, 0x91, 0x45, 0x14, 0x4e,

    /* U+0E13 "ณ" */
    0x78, 0x61, 0x1c, 0x45, 0x91, 0x84, 0x61, 0x18,
    0x4f, 0x8d,

    /* U+0E14 "ด" */
    0x7d, 0x8e, 0xc, 0x18, 0x30, 0x70, 0xb9,

    /* U+0E15 "ต" */
    0x7f, 0x26, 0xc, 0x18, 0x30, 0x70, 0xb9,

    /* U+0E16 "ถ" */
    0x7a, 0x38, 0x59, 0x86, 0x18, 0x79,

    /* U+0E17 "ท" */
    0xbb, 0x18, 0x61, 0x86, 0x18, 0x61,

    /* U+0E19 "น" */
    0x86, 0x18, 0x61, 0x86, 0x18, 0xdd,

    /* U+0E1A "บ" */
    0x86, 0x18, 0x61, 0x86, 0x18, 0x5e,

    /* U+0E1B "ป" */
    0x4, 0x10, 0x61, 0x86, 0x18, 0x61, 0x86, 0x17,
    0x80,

    /* U+0E1C "ผ" */
    0xc3, 0x6, 0xc, 0x9a, 0xbd, 0xf1, 0xc1,

    /* U+0E1E "พ" */
    0x99, 0x99, 0x9b, 0xab, 0xe6, 0x66, 0x66, 0x46,

    /* U+0E1F "ฟ" */
    0x1, 0x1, 0x1, 0x91, 0x9b, 0x9b, 0xaa, 0xae,
    0xe6, 0x66, 0x46,

    /* U+0E20 "ภ" */
    0x3c, 0x8d, 0x9, 0x14, 0x28, 0x50, 0xe1,

    /* U+0E21 "ม" */
    0x86, 0x18, 0x61, 0x86, 0x1c, 0x6e,

    /* U+0E22 "ย" */
    0x66, 0x18, 0x59, 0x86, 0x18, 0x5e,

    /* U+0E23 "ร" */
    0x7e, 0x8, 0x1c, 0x1c, 0x10, 0x7e,

    /* U+0E25 "ล" */
    0x7a, 0x10, 0x5f, 0x86, 0x18, 0x5d,

    /* U+0E27 "ว" */
    0xf0, 0x82, 0x10, 0x84, 0x5e,

    /* U+0E2A "ส" */
    0x2, 0xfa, 0x10, 0x27, 0xd0, 0xa1, 0x42, 0x74,

    /* U+0E2B "ห" */
    0x8a, 0x4b, 0xb3, 0x86, 0x18, 0x61,

    /* U+0E2D "อ" */
    0xf8, 0x20, 0x79, 0x86, 0x1c, 0xde,

    /* U+0E2E "ฮ" */
    0x7, 0xf0, 0x81, 0xe6, 0x18, 0x73, 0x78,

    /* U+0E30 "ะ" */
    0x8f, 0x0, 0x8f,

    /* U+0E31 "ั" */
    0x87, 0xc0,

    /* U+0E32 "า" */
    0xe1, 0x11, 0x11, 0x11,

    /* U+0E33 "ำ" */
    0xe0, 0xa0, 0xe0, 0x0, 0xe, 0x1, 0x1, 0x1,
    0x1, 0x1, 0x1, 0x1,

    /* U+0E34 "ิ" */
    0xfc,

    /* U+0E35 "ี" */
    0x7, 0xf0,

    /* U+0E36 "ึ" */
    0xc, 0x1b, 0xf0,

    /* U+0E37 "ื" */
    0x17, 0xf0,

    /* U+0E38 "ุ" */
    0xd4,

    /* U+0E39 "ู" */
    0x4a, 0x5e,

    /* U+0E40 "เ" */
    0xaa, 0xab,

    /* U+0E41 "แ" */
    0x8a, 0x28, 0xa2, 0x8a, 0x28, 0xb3,

    /* U+0E42 "โ" */
    0xfa, 0x10, 0x84, 0x21, 0x8, 0x42, 0x10, 0xc0,

    /* U+0E43 "ใ" */
    0xe1, 0x12, 0x44, 0x44, 0x44, 0x47,

    /* U+0E44 "ไ" */
    0xf9, 0x8, 0x42, 0x10, 0x84, 0x21, 0x8, 0x60,

    /* U+0E47 "็" */
    0xfd, 0x76,

    /* U+0E48 "่" */
    0xe0,

    /* U+0E49 "้" */
    0xc4, 0xf0,

    /* U+0E4C "์" */
    0xf0,

    /* U+1EA1 "ạ" */
    0x78, 0x10, 0x5f, 0xc6, 0x18, 0xdd, 0x0, 0x40,

    /* U+1EA3 "ả" */
    0x30, 0x21, 0x0, 0x78, 0x10, 0x5f, 0xc6, 0x18,
    0xdd,

    /* U+1EA5 "ấ" */
    0x6, 0x69, 0x20, 0x7, 0x80, 0x81, 0x3e, 0xc5,
    0xa, 0x33, 0xa0,

    /* U+1EA7 "ầ" */
    0x80, 0xc4, 0x80, 0x78, 0x10, 0x5f, 0xc6, 0x18,
    0xdd,

    /* U+1EAD "ậ" */
    0x18, 0xd8, 0x3, 0xe0, 0x20, 0x5f, 0xe1, 0x83,
    0xd, 0xe8, 0x1, 0x0,

    /* U+1EAF "ắ" */
    0x8, 0x44, 0x8e, 0x1, 0xe0, 0x41, 0x7f, 0x18,
    0x63, 0x74,

    /* U+1EBB "ẻ" */
    0x30, 0x21, 0x0, 0x79, 0x38, 0x7f, 0x82, 0x4,
    0x4f,

    /* U+1EBD "ẽ" */
    0x78, 0x7, 0x93, 0x87, 0xf8, 0x20, 0x44, 0xf0,

    /* U+1EBF "ế" */
    0x4, 0x69, 0x20, 0x7, 0x89, 0xa1, 0x7e, 0x81,
    0x1, 0x11, 0xe0,

    /* U+1EC3 "ể" */
    0xc, 0x13, 0x12, 0x1, 0xe4, 0xe1, 0xfe, 0x8,
    0x11, 0x3c,

    /* U+1EC7 "ệ" */
    0x31, 0xa0, 0x1e, 0x4e, 0x1f, 0xe0, 0x81, 0x13,
    0xc0, 0x10,

    /* U+1ECB "ị" */
    0x9f, 0xe8,

    /* U+1ED1 "ố" */
    0x2, 0x79, 0xa0, 0x3, 0x88, 0xa0, 0xc1, 0x83,
    0x5, 0x11, 0xc0,

    /* U+1ED3 "ồ" */
    0x80, 0xf1, 0xb0, 0x3, 0x88, 0xa0, 0xc1, 0x83,
    0x5, 0x11, 0xc0,

    /* U+1ED7 "ỗ" */
    0x74, 0xb8, 0xe3, 0x60, 0x7, 0x11, 0x41, 0x83,
    0x6, 0xa, 0x23, 0x80,

    /* U+1ED9 "ộ" */
    0x10, 0x59, 0x1, 0xc4, 0x50, 0x60, 0xc1, 0x82,
    0x88, 0xe0, 0x1, 0x0,

    /* U+1EDB "ớ" */
    0x8, 0x10, 0x1, 0x3d, 0x46, 0x82, 0x82, 0x82,
    0x82, 0x44, 0x38,

    /* U+1EDD "ờ" */
    0x20, 0x10, 0x1, 0x3d, 0x46, 0x82, 0x82, 0x82,
    0x82, 0x44, 0x38,

    /* U+1EDF "ở" */
    0x38, 0x8, 0x10, 0x1, 0x3d, 0x46, 0x82, 0x82,
    0x82, 0x82, 0x44, 0x38,

    /* U+1EE3 "ợ" */
    0x1, 0x3d, 0x46, 0x82, 0x82, 0x82, 0x82, 0x44,
    0x38, 0x0, 0x10,

    /* U+1EE5 "ụ" */
    0x86, 0x18, 0x61, 0x86, 0x18, 0xdd, 0x0, 0x80,

    /* U+1EE7 "ủ" */
    0x30, 0x63, 0x0, 0x86, 0x18, 0x61, 0x86, 0x18,
    0xdd,

    /* U+1EED "ử" */
    0x30, 0x4, 0xc, 0x0, 0x38, 0x54, 0x32, 0x11,
    0x8, 0x84, 0x42, 0x23, 0xe, 0x80,

    /* U+200C "‌" */
    0x0,

    /* U+3001 "、" */
    0x84, 0x20,

    /* U+3002 "。" */
    0x74, 0x63, 0x17, 0x0,

    /* U+3044 "い" */
    0x80, 0x10, 0x12, 0x2, 0x40, 0x28, 0x5, 0x0,
    0xa0, 0x1a, 0x41, 0x48, 0x6, 0x0,

    /* U+3046 "う" */
    0x3f, 0x0, 0x0, 0x7, 0xee, 0x18, 0x4, 0x2,
    0x1, 0x1, 0x3, 0xf, 0x0,

    /* U+3048 "え" */
    0x20, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xf0, 0xc,
    0x2, 0x0, 0xe0, 0x26, 0x8, 0x42, 0xf, 0x80,

    /* U+304A "お" */
    0x10, 0x1, 0xc, 0xfc, 0x61, 0x1, 0x10, 0x1,
    0xfc, 0x30, 0x65, 0x2, 0x90, 0x29, 0x4, 0x73,
    0x80,

    /* U+304B "か" */
    0x18, 0x1, 0x80, 0x10, 0x4f, 0xe6, 0x11, 0x23,
    0x13, 0x21, 0x12, 0x10, 0x41, 0x4, 0x20, 0x8e,
    0x0,

    /* U+304C "が" */
    0x0, 0x1, 0x85, 0x18, 0x21, 0x4, 0xfe, 0x61,
    0x12, 0x31, 0x32, 0x11, 0x21, 0x4, 0x10, 0x42,
    0x8, 0xe0,

    /* U+304D "き" */
    0x8, 0x4, 0xbf, 0xc0, 0x8f, 0xf8, 0x10, 0x9,
    0xe, 0x80, 0x40, 0x30, 0x7, 0xe0,

    /* U+304F "く" */
    0x6, 0x18, 0x61, 0x4, 0x10, 0x30, 0x30, 0x10,
    0x18, 0x18, 0x10,

    /* U+3053 "こ" */
    0x7f, 0x0, 0x0, 0x0, 0x0, 0x4, 0x2, 0x1,
    0x0, 0xc0, 0x3f, 0xc0,

    /* U+3055 "さ" */
    0x0, 0x2, 0x1, 0x3f, 0xe0, 0x20, 0x10, 0x4,
    0xe, 0x81, 0x40, 0x20, 0x18, 0x3, 0xf0,

    /* U+3057 "し" */
    0x80, 0x40, 0x20, 0x10, 0x8, 0x4, 0x2, 0x1,
    0x0, 0x80, 0xc0, 0xf0, 0xcf, 0x80,

    /* U+3059 "す" */
    0x2, 0x0, 0x43, 0xff, 0x81, 0x0, 0xe0, 0x24,
    0x4, 0x80, 0x90, 0xe, 0x0, 0x40, 0x30, 0xc,
    0x0,

    /* U+305B "せ" */
    0x0, 0x81, 0x8, 0x10, 0x81, 0xff, 0xf0, 0x81,
    0x8, 0x10, 0x81, 0x38, 0x10, 0x1, 0x0, 0xf,
    0xc0,

    /* U+305F "た" */
    0x18, 0x1, 0x0, 0xfe, 0x1, 0x0, 0x13, 0xe2,
    0x0, 0x20, 0x2, 0x40, 0x64, 0x4, 0x60, 0xc3,
    0xf0,

    /* U+3060 "だ" */
    0x18, 0x51, 0x5, 0xfe, 0x1, 0x0, 0x13, 0xe2,
    0x0, 0x20, 0x2, 0x40, 0x64, 0x4, 0x60, 0xc3,
    0xe0,

    /* U+3061 "ち" */
    0x10, 0x4, 0x2f, 0xf8, 0x80, 0x20, 0xb, 0xe3,
    0xd, 0x81, 0x0, 0x40, 0x31, 0xf8, 0x0,

    /* U+3063 "っ" */
    0xf, 0xbc, 0x30, 0x4, 0x1, 0x0, 0xc0, 0x60,
    0xe0,

    /* U+3064 "つ" */
    0xf, 0x8e, 0xa, 0x0, 0x80, 0x10, 0x2, 0x0,
    0x40, 0x10, 0xc, 0x1e, 0x0,

    /* U+3066 "て" */
    0xf, 0xfe, 0x60, 0x10, 0x6, 0x0, 0x80, 0x10,
    0x2, 0x0, 0x60, 0x6, 0x0, 0x38,

    /* U+3067 "で" */
    0x1f, 0xee, 0x20, 0x4, 0x20, 0xc6, 0x8, 0x40,
    0x80, 0x8, 0x0, 0xc0, 0x6, 0x0, 0x1c,

    /* U+306A "な" */
    0x8, 0x0, 0xa0, 0xfc, 0xe1, 0x3, 0x10, 0x82,
    0x8, 0x20, 0x84, 0x8, 0xcf, 0x81, 0x8e, 0x19,
    0xa0, 0xf0,

    /* U+306B "に" */
    0x40, 0x18, 0xfa, 0x0, 0x40, 0x8, 0x1, 0x0,
    0x2a, 0x6, 0x40, 0xc8, 0x18, 0xfd, 0x0, 0x0,

    /* U+306E "の" */
    0x1f, 0x8e, 0x99, 0x11, 0xe2, 0x18, 0xc3, 0x10,
    0x62, 0xe, 0x82, 0x71, 0xc0, 0x60,

    /* U+306F "は" */
    0x40, 0x84, 0x8, 0xc0, 0x88, 0xfe, 0x80, 0x88,
    0x8, 0x80, 0x8c, 0x78, 0xc8, 0xec, 0x8b, 0xc7,
    0x0,

    /* U+307E "ま" */
    0x8, 0x4, 0x3f, 0xe1, 0x0, 0x87, 0xfc, 0x20,
    0xf8, 0x8e, 0x44, 0xe2, 0x2e, 0x0,

    /* U+307F "み" */
    0x3f, 0x0, 0x20, 0x6, 0x0, 0x42, 0x3f, 0x24,
    0x8e, 0x98, 0x79, 0x4, 0xe0, 0x80, 0x30,

    /* U+3082 "も" */
    0x18, 0x2, 0x3, 0xf8, 0x8, 0x1, 0x1, 0x21,
    0xbf, 0x98, 0x81, 0x10, 0x22, 0x4, 0x61, 0x7,
    0xc0,

    /* U+308A "り" */
    0x40, 0x9c, 0xa2, 0xc1, 0xc1, 0x81, 0x81, 0x81,
    0x2, 0x6, 0xc, 0x30,

    /* U+308C "れ" */
    0xc, 0x0, 0x20, 0x1, 0xce, 0x1a, 0xc8, 0xc,
    0x20, 0x60, 0x83, 0x82, 0xa, 0x8, 0x48, 0x21,
    0x20, 0x90, 0x83, 0x80,

    /* U+3092 "を" */
    0x8, 0x1, 0x3, 0xfe, 0x8, 0x3, 0xc6, 0xc7,
    0xb1, 0x84, 0x50, 0x12, 0x6, 0x0, 0xc0, 0xf,
    0xe0,

    /* U+3093 "ん" */
    0x4, 0x0, 0xc0, 0x8, 0x1, 0x80, 0x10, 0x2,
    0xe0, 0x32, 0x6, 0x21, 0x42, 0x3c, 0x26, 0x83,
    0xc0,

    /* U+30A2 "ア" */
    0xff, 0xf0, 0x2, 0x4, 0x40, 0x48, 0x5, 0x0,
    0x40, 0x4, 0x0, 0x80, 0x18, 0x3, 0x0,

    /* U+30A3 "ィ" */
    0x0, 0x0, 0xc0, 0xc1, 0x83, 0xc7, 0x20, 0x10,
    0x8, 0x4, 0x2, 0x0,

    /* U+30A4 "イ" */
    0x0, 0x40, 0x18, 0x6, 0x1, 0x80, 0xe0, 0x74,
    0x30, 0x80, 0x10, 0x2, 0x0, 0x40, 0x8, 0x0,

    /* U+30A6 "ウ" */
    0x8, 0x2, 0xf, 0xfe, 0x3, 0x80, 0xa0, 0x28,
    0x8, 0x4, 0x3, 0x1, 0x81, 0xc0, 0x40,

    /* U+30A8 "エ" */
    0x7f, 0xef, 0xfc, 0x10, 0x2, 0x0, 0x40, 0x8,
    0x1, 0x0, 0x20, 0xff, 0xff, 0xfc,

    /* U+30A9 "ォ" */
    0x3, 0x0, 0x61, 0xff, 0xbf, 0xf0, 0x70, 0x1e,
    0xe, 0xc3, 0x98, 0x43, 0x1, 0xe0,

    /* U+30AB "カ" */
    0x8, 0x2, 0x0, 0x83, 0xff, 0x8, 0x46, 0x11,
    0x4, 0x41, 0x20, 0x58, 0x2c, 0x78,

    /* U+30AD "キ" */
    0xc, 0x0, 0x40, 0x7, 0xc7, 0xc0, 0x4, 0x0,
    0x60, 0x7, 0xf7, 0xe0, 0x2, 0x0, 0x20, 0x3,
    0x0, 0x20,

    /* U+30AF "ク" */
    0x4, 0x0, 0x80, 0x3f, 0x8c, 0x33, 0x4, 0xc0,
    0x80, 0x20, 0xc, 0x3, 0x0, 0xc0, 0x70, 0x18,
    0x0,

    /* U+30B0 "グ" */
    0x0, 0x10, 0xc5, 0x8, 0x21, 0xfe, 0x30, 0x46,
    0x4, 0xc0, 0x80, 0x18, 0x1, 0x0, 0x20, 0xc,
    0x3, 0x80, 0x20, 0x0,

    /* U+30B5 "サ" */
    0x10, 0x81, 0x8, 0x10, 0x8f, 0xff, 0x10, 0x81,
    0x8, 0x10, 0x80, 0x8, 0x1, 0x0, 0x30, 0xe,
    0x0, 0x0,

    /* U+30B6 "ザ" */
    0x10, 0xb0, 0x85, 0x44, 0x21, 0xff, 0xe1, 0x8,
    0x8, 0x40, 0x42, 0x0, 0x10, 0x1, 0x0, 0x18,
    0x1, 0x80, 0x0, 0x0,

    /* U+30B7 "シ" */
    0x10, 0x1, 0x80, 0x4, 0x0, 0x0, 0x60, 0x33,
    0x2, 0x0, 0x40, 0x18, 0x3, 0x0, 0xe0, 0x78,
    0x0,

    /* U+30B8 "ジ" */
    0x0, 0x21, 0x85, 0xc, 0x40, 0x0, 0xe0, 0x23,
    0x2, 0x0, 0x40, 0x18, 0x3, 0x0, 0xe0, 0x78,
    0x0,

    /* U+30B9 "ス" */
    0x3f, 0xc0, 0xc, 0x0, 0x80, 0x18, 0x3, 0x0,
    0x30, 0xd, 0x81, 0x8c, 0x30, 0x64, 0x2,

    /* U+30BB "セ" */
    0x10, 0x2, 0x0, 0x41, 0x8f, 0xff, 0x84, 0x21,
    0x4, 0x60, 0x80, 0x10, 0x2, 0x0, 0x3f, 0x0,

    /* U+30BF "タ" */
    0x4, 0x0, 0x80, 0x3f, 0x8c, 0x13, 0x4, 0xd8,
    0x91, 0xa0, 0xc, 0x3, 0xc0, 0xc8, 0x70, 0x18,
    0x0,

    /* U+30C0 "ダ" */
    0x0, 0x0, 0x45, 0x8, 0x21, 0xfe, 0x10, 0x42,
    0x4, 0x48, 0xc8, 0x68, 0x3, 0x0, 0x2c, 0x4,
    0x1, 0x80, 0x20, 0x0,

    /* U+30C3 "ッ" */
    0x8, 0x12, 0x34, 0x49, 0x82, 0x1, 0x0, 0xc0,
    0x60, 0x30, 0x10, 0x0,

    /* U+30C6 "テ" */
    0x3f, 0xc0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf0,
    0x20, 0x6, 0x0, 0x40, 0x4, 0x0, 0x80, 0x30,
    0x0,

    /* U+30C7 "デ" */
    0x0, 0x10, 0x2, 0x8f, 0xe8, 0x0, 0x0, 0x0,
    0x7f, 0xfb, 0xff, 0xc0, 0xc0, 0x4, 0x0, 0x20,
    0x1, 0x0, 0x10, 0x3, 0x0, 0x0,

    /* U+30C8 "ト" */
    0xc0, 0xc0, 0xc0, 0xc0, 0xf0, 0xde, 0xc3, 0xc0,
    0xc0, 0xc0, 0xc0,

    /* U+30C9 "ド" */
    0xc1, 0x62, 0xb0, 0x98, 0xf, 0x6, 0xf3, 0xd,
    0x80, 0xc0, 0x60, 0x30, 0x0,

    /* U+30CB "ニ" */
    0x7f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff,

    /* U+30CD "ネ" */
    0x4, 0x0, 0x81, 0xff, 0x3f, 0xc0, 0x10, 0x6,
    0x1, 0x0, 0xec, 0xe4, 0x60, 0x84, 0x10, 0x2,
    0x0,

    /* U+30D0 "バ" */
    0x0, 0x50, 0x2, 0x19, 0x81, 0x8, 0x10, 0xc3,
    0x4, 0x20, 0x42, 0x6, 0x60, 0x24, 0x2, 0x80,
    0x30,

    /* U+30D5 "フ" */
    0xff, 0xc0, 0x30, 0xc, 0x2, 0x1, 0x80, 0x40,
    0x30, 0x18, 0x18, 0xc, 0x0,

    /* U+30D6 "ブ" */
    0x0, 0xa0, 0x4, 0xff, 0xc0, 0xc, 0x0, 0x80,
    0x8, 0x1, 0x80, 0x10, 0x2, 0x0, 0xc0, 0x38,
    0x2, 0x0,

    /* U+30D7 "プ" */
    0x0, 0x60, 0x9, 0xff, 0xe0, 0x8, 0x1, 0x80,
    0x18, 0x1, 0x0, 0x30, 0x6, 0x0, 0xc0, 0x38,
    0x6, 0x0,

    /* U+30D9 "ベ" */
    0x0, 0x20, 0x89, 0x1c, 0x43, 0x20, 0x61, 0x4,
    0x8, 0x80, 0x40, 0x6, 0x0, 0x30, 0x0,

    /* U+30DE "マ" */
    0xff, 0xf0, 0x2, 0x0, 0x60, 0xc, 0x31, 0x80,
    0xb0, 0x6, 0x0, 0x20, 0x1, 0x0, 0x8,

    /* U+30DF "ミ" */
    0x20, 0x1f, 0x80, 0x60, 0x7, 0x0, 0xf8, 0x4,
    0x0, 0xc0, 0x1f, 0x0, 0xe0,

    /* U+30E0 "ム" */
    0x4, 0x0, 0x40, 0xc, 0x0, 0x80, 0x8, 0x1,
    0x88, 0x10, 0xc1, 0x4, 0x30, 0x2f, 0xfe, 0xe0,
    0x30,

    /* U+30E2 "モ" */
    0x7f, 0xcf, 0xf8, 0x20, 0x4, 0x0, 0x81, 0xff,
    0xc2, 0x0, 0x40, 0x8, 0x1, 0x0, 0x1f, 0x0,

    /* U+30E3 "ャ" */
    0x0, 0xc, 0x1, 0x3d, 0xfa, 0x90, 0x82, 0x40,
    0x80, 0x20, 0xc, 0x1, 0x0,

    /* U+30E5 "ュ" */
    0x7f, 0x0, 0x40, 0x10, 0x4, 0x3, 0x3f, 0xff,
    0xfc,

    /* U+30E7 "ョ" */
    0xff, 0x80, 0xc0, 0x60, 0x37, 0xf8, 0xc, 0x7,
    0xff, 0x1, 0x80,

    /* U+30E9 "ラ" */
    0x7f, 0x80, 0x0, 0x3, 0xff, 0x0, 0xc0, 0x20,
    0x18, 0xc, 0x6, 0xf, 0x0, 0x0,

    /* U+30EA "リ" */
    0x83, 0x6, 0xc, 0x18, 0x30, 0x60, 0x81, 0x4,
    0x10, 0xc0,

    /* U+30EB "ル" */
    0x11, 0x0, 0x88, 0x4, 0x40, 0x22, 0x1, 0x10,
    0x8, 0x80, 0x44, 0x44, 0x26, 0x61, 0xc6, 0xc,
    0x0,

    /* U+30EC "レ" */
    0x80, 0x40, 0x20, 0x10, 0x8, 0xc, 0xe, 0xd,
    0x1c, 0xb8, 0x70, 0x0,

    /* U+30ED "ロ" */
    0xff, 0xf8, 0xf, 0x1, 0xe0, 0x3c, 0x7, 0x80,
    0xf0, 0x1e, 0x3, 0xff, 0xf8, 0xc,

    /* U+30EF "ワ" */
    0xff, 0xe0, 0x18, 0x6, 0x3, 0x80, 0x80, 0x20,
    0x10, 0xc, 0xc, 0xe, 0x0,

    /* U+30F3 "ン" */
    0xc0, 0x4, 0x0, 0x60, 0x80, 0x30, 0x4, 0x1,
    0x0, 0xc0, 0x30, 0x1c, 0x1c, 0x0,

    /* U+30FC "ー" */
    0xff, 0xe0,

    /* U+4E00 "一" */
    0xff, 0xf8,

    /* U+4E0B "下" */
    0xff, 0xff, 0xff, 0x4, 0x0, 0x40, 0x6, 0x0,
    0x58, 0x4, 0x60, 0x42, 0x4, 0x0, 0x40, 0x4,
    0x0, 0x40,

    /* U+4E0D "不" */
    0xff, 0xf0, 0x20, 0x6, 0x0, 0xf0, 0x1f, 0x83,
    0x66, 0x66, 0x3c, 0x61, 0x6, 0x0, 0x60, 0x6,
    0x0, 0x60,

    /* U+4E2D "中" */
    0x2, 0x0, 0x20, 0x2, 0xf, 0xff, 0xc2, 0x1c,
    0x21, 0xc2, 0x1c, 0x21, 0xff, 0xfc, 0x21, 0x2,
    0x0, 0x20, 0x2, 0x0,

    /* U+4E86 "了" */
    0xff, 0xf0, 0x6, 0x0, 0xc0, 0x18, 0x2, 0x0,
    0x20, 0x2, 0x0, 0x20, 0x2, 0x0, 0x20, 0x2,
    0x1, 0xe0,

    /* U+4F3A "伺" */
    0x8, 0x0, 0xff, 0xc4, 0x2, 0x6f, 0xd6, 0x0,
    0xb0, 0x6, 0x9f, 0x24, 0x89, 0x24, 0x49, 0x3e,
    0x49, 0x2, 0x40, 0x12, 0x3, 0x80,

    /* U+4F4E "低" */
    0x10, 0xf0, 0xfa, 0xb, 0x10, 0xd8, 0x86, 0xc4,
    0x57, 0xfc, 0xb1, 0x5, 0x88, 0x2c, 0x21, 0x65,
    0x4b, 0x2a, 0x5c, 0xb0,

    /* U+4F60 "你" */
    0x12, 0x0, 0x48, 0x2, 0x40, 0x9, 0xff, 0x64,
    0x8b, 0xa2, 0x2a, 0x2a, 0x9, 0xa4, 0x24, 0x98,
    0x92, 0x62, 0x88, 0xc8, 0x20, 0x21, 0x80,

    /* U+4FE1 "信" */
    0x10, 0x80, 0x86, 0xb, 0xfe, 0xc0, 0x6, 0x7f,
    0x50, 0x0, 0x9f, 0xc4, 0x0, 0x20, 0x1, 0x3f,
    0x89, 0x4, 0x48, 0x22, 0x7f, 0x0,

    /* U+5019 "候" */
    0x0, 0x0, 0x4f, 0xc2, 0x1, 0xa, 0xfe, 0x69,
    0x1, 0xa4, 0xa, 0xbf, 0x8b, 0x90, 0x2b, 0xf8,
    0xa1, 0x2, 0xa, 0x8, 0x6c, 0x26, 0x8,

    /* U+5099 "備" */
    0x12, 0x40, 0x92, 0xb, 0xfe, 0x44, 0x86, 0xff,
    0xb1, 0x2, 0xbf, 0xc7, 0x92, 0x2f, 0xf1, 0x64,
    0x8b, 0xfc, 0x59, 0x22, 0xcb, 0x0,

    /* U+5145 "充" */
    0x6, 0x0, 0x20, 0xff, 0xf1, 0x80, 0x10, 0x82,
    0xc, 0x40, 0x67, 0xfe, 0x9, 0x1, 0x90, 0x11,
    0x13, 0x11, 0xe1, 0xf0,

    /* U+5148 "先" */
    0x12, 0x0, 0x90, 0xf, 0xfc, 0x44, 0x4, 0x20,
    0x1, 0x3, 0xff, 0xdf, 0xfe, 0x8, 0x80, 0x44,
    0x4, 0x22, 0x61, 0x1e, 0xf, 0x80,

    /* U+5165 "入" */
    0x18, 0x0, 0x60, 0x1, 0x80, 0xc, 0x0, 0x70,
    0x2, 0x80, 0x26, 0x1, 0x10, 0x10, 0x41, 0x83,
    0x18, 0xd, 0x0, 0x20,

    /* U+5173 "关" */
    0x30, 0x41, 0x8, 0x11, 0x87, 0xfe, 0x6, 0x0,
    0x60, 0x6, 0xf, 0xff, 0x6, 0x0, 0xd0, 0x19,
    0x83, 0xc, 0xc0, 0x30,

    /* U+518D "再" */
    0x7f, 0xf0, 0x10, 0x1f, 0xfc, 0xc4, 0x66, 0x23,
    0x3f, 0xf9, 0x88, 0xdf, 0xff, 0xff, 0xfb, 0x1,
    0x98, 0xc, 0xc1, 0xc0,

    /* U+51FA "出" */
    0x4, 0x8, 0x89, 0x11, 0x22, 0x24, 0x44, 0xff,
    0x81, 0x4, 0x23, 0x84, 0x70, 0x8e, 0x11, 0xff,
    0xff, 0xfe,

    /* U+5207 "切" */
    0x20, 0x1, 0x1f, 0xc8, 0x22, 0x79, 0x1e, 0x8,
    0x90, 0x44, 0x82, 0x24, 0x31, 0x3d, 0x9, 0x18,
    0x41, 0x86, 0x18, 0xe0,

    /* U+521D "初" */
    0x0, 0x2, 0x7f, 0x27, 0xff, 0x11, 0x11, 0x12,
    0x11, 0x29, 0x17, 0x31, 0xaa, 0x12, 0x21, 0x26,
    0x12, 0x43, 0x28, 0xe0,

    /* U+5229 "利" */
    0x4, 0x17, 0x81, 0x90, 0x91, 0x9, 0xfe, 0x91,
    0x9, 0x38, 0x93, 0xc9, 0x50, 0x99, 0x1, 0x90,
    0x11, 0x1, 0x10, 0x70,

    /* U+5230 "到" */
    0x0, 0x1f, 0xe1, 0x20, 0x92, 0x49, 0x4c, 0x97,
    0x29, 0x10, 0x91, 0x9, 0xfe, 0x91, 0x9, 0x12,
    0x1f, 0xc1, 0x80, 0x70,

    /* U+52A0 "加" */
    0x20, 0x1, 0x0, 0x8, 0x3f, 0xfd, 0x32, 0x69,
    0x93, 0x4c, 0x9a, 0x64, 0xd3, 0x26, 0x9a, 0x34,
    0xd1, 0xa7, 0x8d, 0xf9, 0xc9, 0x80,

    /* U+52A1 "务" */
    0x8, 0x0, 0xff, 0x9c, 0x18, 0x1b, 0x1, 0xfc,
    0x70, 0x1c, 0x10, 0xf, 0xfe, 0x8, 0x30, 0x41,
    0xc, 0x9, 0x83, 0x80,

    /* U+52B9 "効" */
    0x20, 0x81, 0x8, 0xfc, 0x84, 0xbf, 0x48, 0x98,
    0x49, 0xcc, 0x93, 0x9, 0x11, 0x13, 0x11, 0x29,
    0x14, 0x21, 0x84, 0xf0,

    /* U+52D9 "務" */
    0x0, 0x7, 0xe8, 0x2, 0x7e, 0x6e, 0x61, 0xe,
    0x3e, 0x70, 0xdc, 0x66, 0x90, 0x57, 0xfa, 0x88,
    0xc4, 0x44, 0x26, 0x63, 0x27, 0x0,

    /* U+5316 "化" */
    0x12, 0x1, 0x20, 0x22, 0x36, 0x22, 0x62, 0x4a,
    0x28, 0xa3, 0x2, 0x60, 0x2e, 0x2, 0x21, 0x22,
    0x12, 0x21, 0x23, 0xe0,

    /* U+5347 "升" */
    0x4, 0x81, 0xc8, 0x70, 0x89, 0x8, 0x10, 0x81,
    0x8, 0xff, 0xf1, 0x8, 0x10, 0x83, 0x8, 0x20,
    0x84, 0x8, 0x80, 0x80,

    /* U+5361 "卡" */
    0x4, 0x0, 0x40, 0x7, 0xe0, 0x40, 0x4, 0xf,
    0xff, 0xff, 0xf0, 0x40, 0x4, 0x0, 0x5c, 0x4,
    0x20, 0x40, 0x4, 0x0,

    /* U+53CB "友" */
    0x8, 0x0, 0x80, 0x8, 0xf, 0xff, 0x10, 0x1,
    0xfc, 0x18, 0x43, 0x8c, 0x24, 0x86, 0x30, 0x47,
    0x89, 0xcf, 0x0, 0x10,

    /* U+53D1 "发" */
    0x12, 0x60, 0x91, 0x88, 0x80, 0x7f, 0xf0, 0x60,
    0x2, 0x0, 0x1f, 0xc1, 0x84, 0x1a, 0x61, 0x9a,
    0x18, 0x60, 0x86, 0xc1, 0xc3, 0x80,

    /* U+53EF "可" */
    0xff, 0xf8, 0x1, 0x0, 0x8, 0x7e, 0x42, 0x12,
    0x10, 0x90, 0x84, 0x84, 0x24, 0x3f, 0x21, 0x1,
    0x0, 0x8, 0x1, 0xc0,

    /* U+540E "后" */
    0x0, 0xf3, 0xf8, 0x18, 0x0, 0xc0, 0x7, 0xff,
    0xb0, 0x1, 0x80, 0xf, 0xff, 0x78, 0x1b, 0xc0,
    0xd6, 0x7, 0xbf, 0xf9, 0x81, 0x80,

    /* U+542C "听" */
    0x7, 0xef, 0x70, 0x96, 0x9, 0x7f, 0x97, 0xf9,
    0x64, 0x96, 0x49, 0x64, 0xf6, 0x48, 0x44, 0x4,
    0x40, 0x84,

    /* U+542F "启" */
    0x2, 0x0, 0x10, 0x3f, 0xf2, 0x1, 0x20, 0x13,
    0xff, 0x20, 0x6, 0x0, 0x6f, 0xf6, 0x81, 0x48,
    0x1c, 0xff, 0x88, 0x10,

    /* U+544A "告" */
    0x12, 0x2, 0x20, 0x3f, 0xe4, 0x20, 0x2, 0xf,
    0xff, 0x0, 0x0, 0x0, 0x7f, 0xe6, 0x6, 0x60,
    0x67, 0xfe, 0x60, 0x60,

    /* U+547D "命" */
    0x1, 0x0, 0xc, 0x0, 0x4c, 0x6, 0x18, 0xef,
    0xdc, 0x0, 0x3, 0xcf, 0x89, 0x26, 0x24, 0x98,
    0x92, 0x63, 0xcb, 0x88, 0x20, 0x0, 0x80,

    /* U+54CD "响" */
    0x0, 0xc3, 0xc3, 0xd, 0x7f, 0xf5, 0x3, 0xd4,
    0xef, 0x52, 0xbd, 0x4a, 0xfd, 0x2b, 0xf4, 0xef,
    0x12, 0x30, 0x40, 0xc1, 0x6,

    /* U+554F "問" */
    0xfb, 0xfe, 0x58, 0xfe, 0xff, 0x96, 0x3f, 0xbf,
    0xe0, 0xf, 0x3e, 0x79, 0x13, 0xc8, 0x9e, 0x7c,
    0xf2, 0x7, 0x80, 0xe0,

    /* U+555F "啟" */
    0x0, 0x40, 0x42, 0x1f, 0x90, 0xc4, 0xf6, 0x29,
    0x3f, 0x69, 0x85, 0x4c, 0xa, 0x7e, 0x23, 0x91,
    0x14, 0x98, 0xbc, 0xa5, 0x28, 0x80,

    /* U+5668 "器" */
    0x7d, 0xf2, 0x28, 0x91, 0x44, 0xfb, 0xe0, 0x4c,
    0x7f, 0xfc, 0x63, 0x6, 0xc, 0xfd, 0xfa, 0x28,
    0x91, 0x44, 0xfb, 0xe0,

    /* U+5728 "在" */
    0x8, 0x0, 0x80, 0xff, 0xf1, 0x0, 0x11, 0x2,
    0x10, 0x61, 0xe, 0xff, 0xa1, 0x2, 0x10, 0x21,
    0x2, 0x10, 0x2f, 0xf0,

    /* U+5831 "報" */
    0x10, 0x0, 0x9f, 0x9f, 0xc4, 0x26, 0x2f, 0xf7,
    0x23, 0x80, 0xaf, 0xef, 0xf2, 0x13, 0x57, 0xfb,
    0x84, 0xc8, 0x26, 0xa1, 0x38, 0x80,

    /* U+5907 "备" */
    0x8, 0x0, 0xfe, 0xc, 0x31, 0x9e, 0x0, 0xf0,
    0x3c, 0x7a, 0x0, 0x7, 0xfc, 0x22, 0x21, 0xff,
    0x8, 0x88, 0x7f, 0xc3, 0xfe, 0x0,

    /* U+5927 "大" */
    0x4, 0x0, 0x40, 0x4, 0x0, 0x40, 0xff, 0xf0,
    0x60, 0x6, 0x0, 0x90, 0x9, 0x1, 0x8, 0x30,
    0x4e, 0x3, 0x80, 0x10,

    /* U+5931 "失" */
    0x12, 0x1, 0x90, 0x8, 0x80, 0x7f, 0xe4, 0x20,
    0x61, 0x0, 0x8, 0x1f, 0xff, 0x7, 0x0, 0x28,
    0x2, 0x20, 0x60, 0xce, 0x3, 0xc0, 0x0,

    /* U+597D "好" */
    0x30, 0x0, 0x87, 0xf2, 0x0, 0x9f, 0x84, 0x26,
    0x20, 0x90, 0x84, 0xdf, 0xd3, 0x8, 0x38, 0x20,
    0x60, 0x83, 0x42, 0x18, 0x8, 0x40, 0xe0,

    /* U+59CB "始" */
    0x20, 0x41, 0x4, 0x8, 0x29, 0xfa, 0x24, 0xdf,
    0xa5, 0xc5, 0x20, 0xb, 0x7f, 0x3b, 0x18, 0x98,
    0xce, 0xc6, 0xce, 0x3c, 0x3f, 0x80,

    /* U+5B8C "完" */
    0x4, 0x0, 0x60, 0xff, 0xf8, 0x1, 0xbf, 0xd0,
    0x0, 0xff, 0xff, 0xff, 0x11, 0x1, 0x10, 0x11,
    0x12, 0x11, 0xc1, 0xf0,

    /* U+5B9A "定" */
    0x2, 0x0, 0xc, 0x7, 0xff, 0x90, 0x2, 0x40,
    0x8, 0x7f, 0xc0, 0x30, 0x4, 0xc0, 0x13, 0xf0,
    0xcc, 0x2, 0xb0, 0x19, 0xc0, 0xc3, 0xf8,

    /* U+5BFB "寻" */
    0x7f, 0xc0, 0x4, 0x3f, 0xc0, 0x4, 0x7f, 0xc0,
    0x8, 0xff, 0xf1, 0x8, 0x18, 0x80, 0x88, 0x0,
    0x80, 0x38,

    /* U+5C06 "将" */
    0x10, 0x80, 0x8f, 0xb5, 0x84, 0xe2, 0x43, 0xc,
    0x9, 0x90, 0x50, 0x87, 0xff, 0x70, 0x24, 0x91,
    0x4, 0x48, 0x20, 0x41, 0xe, 0x0,

    /* U+5C07 "將" */
    0x18, 0x82, 0xcf, 0x96, 0x84, 0xb9, 0xc7, 0x9c,
    0xd, 0xd0, 0x70, 0x9f, 0xff, 0x5a, 0x22, 0xd1,
    0x16, 0x48, 0xb0, 0x49, 0x8e, 0x0,

    /* U+5C0B "尋" */
    0x3f, 0xf0, 0x1, 0x87, 0xfc, 0x7f, 0xe0, 0x0,
    0x3e, 0xf9, 0xf4, 0x4c, 0x1c, 0xff, 0xf8, 0x82,
    0x3, 0x10, 0x3, 0x80,

    /* U+5C11 "少" */
    0x2, 0x0, 0x10, 0x4, 0x88, 0x44, 0x42, 0x21,
    0x21, 0x4, 0x8, 0x0, 0x44, 0x0, 0x40, 0xc,
    0x3, 0x81, 0xf0, 0x0,

    /* U+5DF2 "已" */
    0xff, 0xe0, 0x6, 0x0, 0x6c, 0x6, 0xc0, 0x6f,
    0xfe, 0xc0, 0x6c, 0x0, 0xc0, 0x1c, 0x1, 0xc0,
    0x17, 0xfe,

    /* U+5E94 "应" */
    0x1, 0x0, 0x6, 0x7, 0xff, 0x98, 0x0, 0x61,
    0x9, 0xa4, 0x46, 0x49, 0x19, 0x24, 0x64, 0xa1,
    0x90, 0x84, 0x4, 0x17, 0xff, 0x0, 0x0,

    /* U+5EA6 "度" */
    0x1, 0x1, 0xff, 0xf6, 0x42, 0x1f, 0xfe, 0x64,
    0x21, 0x9f, 0x86, 0x0, 0x1f, 0xfc, 0x64, 0x21,
    0xd, 0x4, 0x3c, 0x37, 0xe,

    /* U+5F00 "开" */
    0xff, 0xf1, 0x8, 0x10, 0x81, 0x8, 0x10, 0x8f,
    0xff, 0x10, 0x81, 0x8, 0x20, 0x82, 0x8, 0x40,
    0x88, 0x8,

    /* U+5F0F "式" */
    0x1, 0x40, 0x9, 0x80, 0x45, 0xff, 0xe0, 0x10,
    0x7f, 0x83, 0xfc, 0x2, 0x30, 0x10, 0x80, 0x84,
    0x5, 0xb2, 0xf0, 0x98, 0x3, 0x0,

    /* U+5F55 "录" */
    0x3f, 0xf0, 0x1, 0x8f, 0xfc, 0x0, 0x6f, 0xff,
    0xff, 0xfc, 0x88, 0x42, 0x6c, 0x6, 0x81, 0xd2,
    0x10, 0x8e, 0x1c, 0x0,

    /* U+5F85 "待" */
    0x10, 0x82, 0x8, 0x47, 0xf9, 0x8, 0x2f, 0xf6,
    0xff, 0xe0, 0x2a, 0xff, 0x20, 0x22, 0x22, 0x23,
    0x22, 0x2, 0x20, 0xe0,

    /* U+5F8C "後" */
    0x11, 0x1, 0x11, 0x11, 0x19, 0x3f, 0x2, 0x32,
    0x37, 0xfb, 0x8c, 0x24, 0x7e, 0x2e, 0x61, 0x5e,
    0x8, 0x60, 0x4e, 0xc2, 0xc1, 0x80,

    /* U+5FDC "応" */
    0x3, 0x0, 0x4, 0x7, 0xff, 0xd8, 0x0, 0x61,
    0x81, 0x83, 0x6, 0x20, 0x1a, 0x84, 0x6a, 0x19,
    0xa8, 0x27, 0xa2, 0xd4, 0x89, 0xc3, 0xe0,

    /* U+6001 "态" */
    0x6, 0x0, 0x40, 0xff, 0xf0, 0x60, 0x9, 0x1,
    0x98, 0x34, 0xcc, 0x23, 0x4, 0x5, 0x22, 0x50,
    0x29, 0x5, 0x9f, 0x80,

    /* U+606F "息" */
    0x2, 0x1, 0xff, 0x8, 0x8, 0x7f, 0xc2, 0x2,
    0x1f, 0xf0, 0x80, 0x87, 0xfc, 0x6, 0x2, 0x98,
    0x94, 0x45, 0x20, 0x91, 0xfc, 0x0,

    /* U+60C5 "情" */
    0x20, 0x81, 0x7f, 0xcc, 0x20, 0xef, 0xe6, 0x8,
    0x57, 0xfc, 0x9f, 0xe4, 0xc3, 0x27, 0xf9, 0x30,
    0xc9, 0xfe, 0x4c, 0x32, 0x67, 0x80,

    /* U+614B "態" */
    0x21, 0x4, 0x9e, 0xfd, 0x10, 0x11, 0xfc, 0xef,
    0xd0, 0xcd, 0xef, 0xd1, 0xdd, 0xf0, 0x22, 0x62,
    0x9a, 0x9, 0x1f, 0x80,

    /* U+61C9 "應" */
    0x1, 0x81, 0xff, 0xf6, 0x5a, 0x1a, 0x48, 0x6b,
    0xf9, 0xff, 0xe6, 0xbf, 0x9a, 0xff, 0x6b, 0x1,
    0x83, 0x4, 0xa0, 0x94, 0x8b, 0xd3, 0xe0,

    /* U+6211 "我" */
    0xd, 0x47, 0x89, 0x4, 0x44, 0x22, 0xf, 0xff,
    0x8, 0x80, 0x44, 0x83, 0xb4, 0xf0, 0xc0, 0x84,
    0x4, 0x72, 0x2c, 0xa7, 0x3, 0x0,

    /* U+624B "手" */
    0x1, 0xe3, 0xf0, 0x0, 0x80, 0x4, 0x7, 0xff,
    0x1, 0x0, 0x8, 0x0, 0x40, 0xff, 0xf8, 0x10,
    0x0, 0x80, 0x4, 0x1, 0xe0, 0x0,

    /* U+626B "扫" */
    0x20, 0x1, 0x3f, 0xc9, 0xff, 0xf0, 0x32, 0x1,
    0x90, 0xc, 0xaf, 0xfe, 0x3, 0x20, 0x19, 0x0,
    0xc8, 0x6, 0x4f, 0xfe, 0x1, 0x80,

    /* U+627E "找" */
    0x21, 0x1, 0xb, 0x8, 0x4d, 0xf2, 0x32, 0x7e,
    0x10, 0x80, 0xa2, 0xde, 0x14, 0xa0, 0xc1, 0x6,
    0x8, 0x52, 0x4c, 0xde, 0x43, 0x0,

    /* U+633F "挿" */
    0x20, 0x11, 0x7f, 0x8, 0x21, 0xff, 0xf2, 0x8,
    0x17, 0xfc, 0xb2, 0x7f, 0xff, 0x2c, 0x99, 0x7f,
    0xcb, 0x20, 0x41, 0x6, 0x8, 0x0,

    /* U+6362 "换" */
    0x21, 0x0, 0x8f, 0xc2, 0x66, 0x3f, 0xfc, 0x27,
    0xf0, 0x92, 0x42, 0x49, 0xd, 0x24, 0xef, 0xf8,
    0xbf, 0xe2, 0x34, 0x9, 0x8c, 0x68, 0x8,

    /* U+6383 "掃" */
    0x20, 0x1, 0x1f, 0x88, 0x5, 0xf3, 0xe2, 0x3f,
    0x13, 0xfc, 0xff, 0xff, 0x91, 0xa3, 0xf1, 0x14,
    0x88, 0xa4, 0x45, 0x66, 0x8, 0x0,

    /* U+63A2 "探" */
    0x20, 0x1, 0x3f, 0xc9, 0x3, 0xea, 0xd2, 0x21,
    0x12, 0x44, 0xc2, 0x1d, 0xff, 0xa1, 0xc1, 0x15,
    0x9, 0xa4, 0x59, 0x16, 0x8, 0x0,

    /* U+63A5 "接" */
    0x21, 0x81, 0x4, 0x9, 0xfd, 0xe4, 0x42, 0x14,
    0x17, 0xfc, 0x84, 0x1f, 0xff, 0x22, 0x21, 0x31,
    0x8, 0x70, 0x43, 0xc6, 0xe1, 0x0,

    /* U+63CF "描" */
    0x21, 0x21, 0x9, 0x9, 0xff, 0xf2, 0x42, 0x12,
    0x10, 0x0, 0x9f, 0xe7, 0xd3, 0xe6, 0x99, 0x3f,
    0xc9, 0xa6, 0x4f, 0xf6, 0x61, 0x80,

    /* U+63D2 "插" */
    0x20, 0x31, 0x3e, 0x8, 0x20, 0xe1, 0x7, 0xff,
    0x90, 0x40, 0x9f, 0xe6, 0x93, 0xe4, 0x99, 0x3f,
    0xc9, 0x26, 0x4f, 0xf6, 0x41, 0x80,

    /* U+63DB "換" */
    0x21, 0x0, 0x87, 0xc2, 0x12, 0x3c, 0x90, 0xf7,
    0xf8, 0x88, 0x22, 0x2a, 0x8c, 0xc6, 0xe2, 0x48,
    0x9f, 0xe2, 0x7f, 0x88, 0x48, 0x6e, 0x18,

    /* U+6557 "敗" */
    0x0, 0x3, 0xe8, 0x11, 0x40, 0xfb, 0xf4, 0x51,
    0x23, 0x91, 0xfe, 0x88, 0x94, 0x44, 0xe3, 0xe2,
    0xa, 0x38, 0xcb, 0x44, 0x71, 0x81, 0x0,

    /* U+65B0 "新" */
    0x20, 0x30, 0x8f, 0x3f, 0x40, 0x92, 0x4, 0x90,
    0x7e, 0xfc, 0x44, 0x9f, 0xe4, 0x13, 0x22, 0xd9,
    0x25, 0xc9, 0x24, 0x42, 0x62, 0x0,

    /* U+65E0 "无" */
    0x7f, 0xf0, 0x10, 0x0, 0x80, 0x4, 0x7, 0xff,
    0xbf, 0xfc, 0x14, 0x0, 0xa0, 0xd, 0x0, 0xc8,
    0x4c, 0x43, 0xc3, 0xf0,

    /* U+65F6 "时" */
    0x0, 0x27, 0xe1, 0x33, 0x9, 0x9f, 0xfc, 0xc2,
    0x7f, 0x13, 0x34, 0x99, 0xa4, 0xcc, 0xa6, 0x61,
    0x3f, 0x9, 0x80, 0x40, 0x1e, 0x0,

    /* U+6642 "時" */
    0x0, 0x43, 0xf1, 0xc, 0xff, 0xb3, 0x10, 0xcf,
    0xff, 0xf0, 0x4c, 0xc1, 0x33, 0xfe, 0xcc, 0x13,
    0xf4, 0x4c, 0x9, 0x0, 0x4, 0x0, 0x70,

    /* U+66F4 "更" */
    0xff, 0xf0, 0x10, 0xf, 0xfc, 0x44, 0x23, 0xff,
    0x11, 0x8, 0x88, 0x47, 0xfe, 0x36, 0x0, 0xe0,
    0x7, 0x81, 0xc3, 0xf0,

    /* U+66FF "替" */
    0x20, 0x47, 0xcf, 0x88, 0x11, 0xfb, 0xf3, 0xa,
    0x24, 0xda, 0x0, 0x67, 0xf8, 0x20, 0x41, 0xfe,
    0x8, 0x10, 0x40, 0x83, 0xfc, 0x0,

    /* U+6700 "最" */
    0x3f, 0xe1, 0x1, 0xf, 0xf8, 0x7f, 0xc0, 0x0,
    0x7f, 0xfc, 0x90, 0x7, 0x9e, 0x3c, 0x91, 0x23,
    0x3f, 0xbc, 0xa, 0x30,

    /* U+6709 "有" */
    0xc, 0x0, 0x80, 0xff, 0xf1, 0x0, 0x10, 0x3,
    0xfe, 0x50, 0x69, 0xfe, 0x10, 0x61, 0xfe, 0x10,
    0x61, 0x6, 0x11, 0xc0,

    /* U+670B "朋" */
    0x3d, 0xf9, 0x2c, 0xc9, 0x66, 0x7b, 0xf2, 0x59,
    0x92, 0xcc, 0xf7, 0xec, 0xb3, 0x65, 0x9b, 0x2c,
    0xd1, 0x47, 0x9e, 0x60,

    /* U+670D "服" */
    0x7f, 0xf9, 0x38, 0x64, 0xe1, 0x9f, 0x9c, 0x4f,
    0xf9, 0x3c, 0x27, 0xe8, 0xb3, 0xb4, 0xce, 0x73,
    0x39, 0x88, 0xed, 0x27, 0xc2,

    /* U+671F "期" */
    0x24, 0x0, 0x97, 0xff, 0xf8, 0xc9, 0x63, 0x3d,
    0xfc, 0x96, 0x33, 0xd8, 0xc9, 0x7f, 0xff, 0x8f,
    0xfe, 0x32, 0xd8, 0xd9, 0x43, 0xc1, 0x38,

    /* U+672C "本" */
    0x2, 0x0, 0x10, 0x0, 0x81, 0xff, 0xf0, 0xf0,
    0x5, 0x40, 0x6b, 0x6, 0x4c, 0x62, 0x36, 0xfe,
    0xc0, 0x80, 0x4, 0x0, 0x20, 0x0,

    /* U+673A "机" */
    0x10, 0x0, 0x4f, 0xc1, 0x33, 0x1f, 0xcc, 0x13,
    0x30, 0xcc, 0xc3, 0xb3, 0x15, 0xcc, 0x57, 0x33,
    0x4c, 0xc1, 0x23, 0x45, 0x8d, 0x14, 0x3c,

    /* U+67E5 "查" */
    0x2, 0x0, 0x8, 0x7, 0xff, 0x81, 0xa0, 0xa,
    0x40, 0xc8, 0xc5, 0xfe, 0x84, 0x8, 0x1f, 0xe0,
    0x40, 0x81, 0xfe, 0x0, 0x0, 0x7f, 0xf8,

    /* U+68C0 "检" */
    0x20, 0x82, 0x18, 0x23, 0x4f, 0x26, 0x24, 0x36,
    0xbd, 0x70, 0x6, 0x52, 0xa4, 0xaa, 0x2c, 0x20,
    0x42, 0xff, 0x20, 0x0,

    /* U+691C "検" */
    0x20, 0x81, 0xe, 0x8, 0xd9, 0xff, 0xf2, 0x7f,
    0x10, 0x41, 0xdf, 0xcd, 0x92, 0xa7, 0xf5, 0x6,
    0x8, 0x50, 0x46, 0x42, 0xc1, 0x80,

    /* U+6A21 "模" */
    0x21, 0x21, 0x3f, 0xc8, 0x49, 0xe0, 0x2, 0x3f,
    0x19, 0xf9, 0xef, 0xcd, 0x7e, 0xa0, 0x85, 0x3f,
    0xc8, 0x50, 0x46, 0x62, 0xc1, 0x80,

    /* U+6A5F "機" */
    0x20, 0x81, 0x25, 0xa, 0x75, 0xfd, 0xe2, 0x4a,
    0x17, 0xfd, 0xf2, 0x4d, 0xff, 0xa4, 0x55, 0x33,
    0x8b, 0x58, 0x51, 0xd2, 0x13, 0x80,

    /* U+6AA2 "檢" */
    0x20, 0x81, 0xe, 0x8, 0x99, 0xef, 0xf2, 0x0,
    0x1b, 0xb9, 0xd5, 0x4e, 0xaa, 0xa7, 0x75, 0x11,
    0x9, 0x98, 0x4a, 0xa2, 0x88, 0x80,

    /* U+6B63 "正" */
    0xff, 0xf0, 0x60, 0x6, 0x0, 0x60, 0x26, 0x2,
    0x7e, 0x26, 0x2, 0x60, 0x26, 0x2, 0x60, 0xff,
    0xff, 0xff,

    /* U+6CD5 "法" */
    0x40, 0x81, 0x84, 0x4, 0x20, 0xf, 0xe0, 0x8,
    0x30, 0x40, 0x3f, 0xe0, 0x30, 0x11, 0x1, 0x99,
    0x8, 0x8c, 0xcf, 0xe4, 0x61, 0x80,

    /* U+6D3B "活" */
    0x40, 0x71, 0xfc, 0x0, 0x20, 0x1, 0xc, 0xff,
    0x90, 0x40, 0x2, 0x1, 0xfe, 0x3c, 0x31, 0x61,
    0x9b, 0xc, 0x98, 0x64, 0xff, 0x0,

    /* U+6D41 "流" */
    0x40, 0x81, 0x4, 0x3, 0xfe, 0x4, 0x48, 0x63,
    0x37, 0xf8, 0xa0, 0x20, 0x94, 0x14, 0xa1, 0x25,
    0x9, 0x2a, 0x99, 0x54, 0x83, 0x80,

    /* U+6D4B "测" */
    0x40, 0x9, 0x7c, 0x42, 0x2a, 0x15, 0x50, 0xaa,
    0xb5, 0x54, 0x2a, 0xa1, 0x55, 0x2a, 0xa9, 0x55,
    0x51, 0xc2, 0x8b, 0x15, 0x8b, 0x80,

    /* U+6D4F "浏" */
    0x0, 0x14, 0x41, 0x64, 0x51, 0xf5, 0x2, 0x5d,
    0x25, 0x4a, 0x50, 0x45, 0x26, 0x54, 0xe5, 0x4b,
    0x19, 0x1, 0x0, 0x70,

    /* U+6E2C "測" */
    0x40, 0xb, 0x78, 0x42, 0x52, 0x12, 0x90, 0xf4,
    0xb4, 0xa4, 0xbd, 0x21, 0x29, 0x29, 0x49, 0x7a,
    0x53, 0x2, 0x92, 0x15, 0x3, 0x80,

    /* U+6E80 "満" */
    0x42, 0x43, 0x12, 0x7, 0xfe, 0x4, 0x8c, 0xff,
    0x90, 0x40, 0x3f, 0xe1, 0x13, 0x2a, 0x99, 0x56,
    0xda, 0xf6, 0x94, 0x34, 0x83, 0x80,

    /* U+6E90 "源" */
    0x0, 0x0, 0x9f, 0xf1, 0x44, 0x1, 0x7e, 0x45,
    0x8, 0x97, 0xe0, 0x50, 0x81, 0x42, 0x2d, 0xf8,
    0xf1, 0x2, 0x94, 0x96, 0x93, 0x50, 0xc0,

    /* U+6EE1 "满" */
    0x4, 0x87, 0xff, 0x4, 0x80, 0x0, 0x9f, 0xfc,
    0x48, 0x1f, 0xf1, 0x4b, 0x36, 0xb5, 0x77, 0x59,
    0x39, 0x3, 0x90, 0x70,

    /* U+6EFF "滿" */
    0x42, 0x21, 0x88, 0x81, 0xff, 0x80, 0xf8, 0x43,
    0xe1, 0x82, 0x2, 0xff, 0xc2, 0x23, 0xa, 0xac,
    0xab, 0xb2, 0xdd, 0xd2, 0x23, 0x48, 0x98,

    /* U+6FC0 "激" */
    0x42, 0x21, 0x90, 0x80, 0xfa, 0x2, 0x6f, 0x4f,
    0xc9, 0xbf, 0xa0, 0x42, 0x87, 0xea, 0x24, 0x10,
    0x9e, 0x46, 0x9b, 0x12, 0x5a, 0x53, 0xc4,

    /* U+700F "瀏" */
    0x0, 0x15, 0xb9, 0x7a, 0xd1, 0xad, 0x1c, 0xdc,
    0x55, 0x4b, 0xd1, 0xed, 0x24, 0x55, 0xf5, 0x55,
    0x18, 0x79, 0x18, 0x30,

    /* U+70B9 "点" */
    0x2, 0x0, 0x10, 0x0, 0xfc, 0x4, 0x3, 0xfe,
    0x10, 0x10, 0x80, 0x84, 0x4, 0x3f, 0xe0, 0x0,
    0x9, 0x48, 0x89, 0x2c, 0x49, 0x80,

    /* U+70ED "热" */
    0x21, 0x1, 0x8, 0x3f, 0xf8, 0x42, 0x42, 0x12,
    0x3e, 0x93, 0x8c, 0x84, 0x5d, 0x26, 0x3b, 0x60,
    0xd0, 0x8, 0x92, 0x28, 0x98, 0x80,

    /* U+7121 "無" */
    0x30, 0x1, 0x0, 0x1f, 0xfd, 0xd2, 0x42, 0x92,
    0x7f, 0xf8, 0xa4, 0x85, 0x24, 0xff, 0xff, 0xff,
    0xda, 0x4c, 0x93, 0x2c, 0x88, 0x80,

    /* U+7248 "版" */
    0x48, 0x32, 0x7f, 0x13, 0x80, 0x9c, 0x7, 0xff,
    0xa3, 0x89, 0x1a, 0x4f, 0xd6, 0xce, 0xa6, 0x73,
    0x33, 0x99, 0x19, 0x68, 0xd1, 0x80,

    /* U+72B6 "状" */
    0x10, 0x80, 0x84, 0xb4, 0x24, 0xa1, 0x1, 0x7f,
    0x88, 0x40, 0x43, 0x6, 0x38, 0x51, 0x44, 0x89,
    0x4, 0x88, 0x2c, 0x21, 0xc0, 0x80,

    /* U+72C0 "狀" */
    0x31, 0xb, 0x14, 0xb1, 0x2b, 0x10, 0xff, 0xf3,
    0x10, 0x31, 0xf, 0x18, 0xb2, 0x8b, 0x2c, 0xb6,
    0x4b, 0xc2, 0x38, 0x20,

    /* U+73B0 "现" */
    0xff, 0xf1, 0x20, 0x89, 0x24, 0x49, 0x2f, 0x49,
    0x12, 0x48, 0x92, 0x44, 0x9a, 0x29, 0x43, 0x8a,
    0x60, 0x92, 0x18, 0xf0,

    /* U+73FE "現" */
    0xfb, 0xf1, 0x10, 0x88, 0xfc, 0x44, 0x2f, 0xbf,
    0x11, 0x8, 0x8f, 0xc4, 0x7e, 0x39, 0x46, 0x12,
    0x1, 0x92, 0x18, 0xf0,

    /* U+7528 "用" */
    0x7f, 0xfb, 0x10, 0xd8, 0x86, 0xff, 0xf6, 0x21,
    0xb1, 0xd, 0x88, 0x6f, 0xff, 0x62, 0x1a, 0x10,
    0xf0, 0x87, 0x5, 0xe0,

    /* U+7535 "电" */
    0x4, 0x0, 0x20, 0x3f, 0xfd, 0x88, 0x6c, 0x43,
    0x7f, 0xfb, 0x10, 0xd8, 0x86, 0xff, 0xf6, 0x20,
    0x1, 0x2, 0x8, 0x30, 0x7f, 0x0,

    /* U+767B "登" */
    0x0, 0xf, 0xa4, 0x9, 0x97, 0xa, 0x3f, 0x4c,
    0x3, 0xbf, 0xd2, 0x4, 0x20, 0x43, 0xfc, 0x10,
    0x81, 0x90, 0xff, 0xf0,

    /* U+767C "發" */
    0x0, 0x0, 0xfa, 0xc2, 0x4c, 0xc6, 0xc, 0x7e,
    0xfc, 0x1a, 0x80, 0x7a, 0xf, 0xcf, 0x20, 0x0,
    0xff, 0xc0, 0x4f, 0x1, 0x18, 0x3d, 0x98,

    /* U+7684 "的" */
    0x21, 0x2, 0x10, 0xf9, 0xfc, 0xa1, 0xca, 0x1c,
    0x91, 0xf9, 0x9c, 0x89, 0xc8, 0x5c, 0x81, 0xc8,
    0x1f, 0x83, 0xc0, 0xf0,

    /* U+78BA "確" */
    0x0, 0x87, 0xff, 0xd8, 0x42, 0x86, 0x84, 0x3f,
    0x7f, 0x23, 0x3f, 0xd9, 0xc8, 0x4f, 0xf3, 0xf2,
    0x11, 0xfe, 0xc, 0x0,

    /* U+79D2 "秒" */
    0x0, 0x41, 0xe1, 0x1, 0x5, 0x4, 0x56, 0x7d,
    0x48, 0x49, 0x23, 0xa4, 0xc, 0x16, 0x50, 0x10,
    0x40, 0x81, 0x6, 0x4, 0xe0, 0x16, 0x0,

    /* U+7A0D "稍" */
    0x10, 0x87, 0x14, 0xc8, 0xac, 0x41, 0xf, 0xff,
    0x93, 0xd, 0xd8, 0x6e, 0xff, 0xa6, 0x1d, 0x3f,
    0xc9, 0x86, 0x4c, 0x32, 0x67, 0x80,

    /* U+7B49 "等" */
    0x20, 0x81, 0xff, 0xd4, 0xd0, 0x2, 0x3, 0xff,
    0x0, 0x81, 0xff, 0xef, 0xff, 0x0, 0x43, 0xff,
    0xc6, 0x10, 0x8, 0x80, 0x1c, 0x0,

    /* U+7B54 "答" */
    0x21, 0x3, 0xef, 0xd4, 0x90, 0x24, 0x0, 0x70,
    0xc, 0x61, 0xfe, 0xc0, 0x1, 0x3f, 0xe1, 0x3,
    0x8, 0x18, 0x7f, 0xc0,

    /* U+7CFB "系" */
    0x1, 0xe7, 0xf0, 0xc, 0x1, 0x8, 0x3f, 0x0,
    0x64, 0x18, 0x27, 0xff, 0x42, 0x11, 0x2c, 0x22,
    0x24, 0x21, 0xe, 0x0,

    /* U+7D1A "級" */
    0x20, 0x1, 0x1f, 0x10, 0x48, 0xb2, 0x4f, 0x12,
    0x10, 0xbd, 0x24, 0x5f, 0x36, 0x86, 0xb5, 0x53,
    0x2a, 0x99, 0x5d, 0xea, 0x51, 0x80,

    /* U+7D42 "終" */
    0x0, 0x1, 0x8, 0x8, 0xfc, 0xa4, 0xc9, 0x56,
    0x70, 0x61, 0xc7, 0xa, 0xc6, 0xed, 0x10, 0x86,
    0x2c, 0x1, 0x57, 0xa, 0x6, 0x0, 0x0,

    /* U+7D44 "組" */
    0x10, 0x0, 0x4f, 0xe2, 0x31, 0x8a, 0xc6, 0x53,
    0x19, 0xcf, 0xe2, 0xb1, 0x9e, 0xc6, 0x83, 0xf9,
    0x6c, 0x65, 0xb1, 0xa4, 0xc6, 0x17, 0xfc,

    /* U+7D61 "絡" */
    0x0, 0x1, 0x8, 0x18, 0x7e, 0xa4, 0x69, 0xd2,
    0x70, 0x61, 0x47, 0x9e, 0xc3, 0x87, 0xf5, 0xb0,
    0xad, 0x85, 0x6c, 0x2a, 0x7f, 0x0,

    /* U+7D71 "統" */
    0x20, 0x82, 0x8, 0x57, 0xf9, 0x10, 0xf2, 0x22,
    0x6f, 0x57, 0x1b, 0x94, 0xcb, 0x4b, 0x24, 0xb2,
    0x4a, 0x25, 0xac, 0x70,

    /* U+7D9A "続" */
    0x20, 0x81, 0x3f, 0x94, 0x21, 0x2f, 0xee, 0x7f,
    0x1b, 0xfd, 0x50, 0x3e, 0xa9, 0x1, 0x45, 0x8a,
    0x2c, 0x91, 0x54, 0xa8, 0xc7, 0x0,

    /* U+7DB2 "網" */
    0x10, 0x0, 0x9f, 0xc8, 0x82, 0x55, 0x55, 0xaa,
    0xb9, 0xfc, 0xa9, 0x2f, 0x7f, 0x6a, 0x88, 0x54,
    0x56, 0xbe, 0xa4, 0x10, 0x21, 0x80,

    /* U+7EA7 "级" */
    0x20, 0x1, 0x7f, 0x10, 0x90, 0xa4, 0x89, 0x24,
    0x71, 0x7c, 0x8c, 0x4a, 0x66, 0xe4, 0xa0, 0x27,
    0xd, 0x39, 0x93, 0x60, 0xf1, 0x80,

    /* U+7EC4 "组" */
    0x10, 0x0, 0x4f, 0xc2, 0x31, 0xa, 0xc4, 0x7b,
    0xf2, 0x4c, 0x42, 0x31, 0x12, 0xc4, 0x73, 0xf0,
    0xc, 0x40, 0xb1, 0x3c, 0xc4, 0x7, 0xfc,

    /* U+7EDC "络" */
    0x0, 0x1, 0x8, 0x8, 0xfe, 0x8c, 0x25, 0xd2,
    0x78, 0x60, 0x8f, 0x89, 0xc3, 0xf7, 0xf0, 0x30,
    0x8d, 0x85, 0x8f, 0xe0, 0x61, 0x0,

    /* U+7EDF "统" */
    0x20, 0x81, 0x4, 0x11, 0xff, 0xb2, 0x9, 0x22,
    0x72, 0x19, 0x9f, 0xe8, 0x48, 0xf2, 0x40, 0x12,
    0x4, 0x93, 0xc8, 0x90, 0xc7, 0x80,

    /* U+7F51 "网" */
    0xff, 0xf0, 0x6, 0x22, 0xf6, 0x5a, 0xb3, 0x22,
    0x66, 0x4c, 0xd5, 0xa2, 0xbc, 0x86, 0x0, 0xc0,
    0x70,

    /* U+8046 "聆" */
    0x0, 0x7, 0xc4, 0x36, 0x71, 0xb2, 0x8f, 0xa2,
    0x6e, 0xcf, 0x62, 0x1f, 0xfe, 0xd8, 0x66, 0xc2,
    0x3e, 0xe0, 0x33, 0x1, 0x84, 0x0,

    /* U+807D "聽" */
    0x0, 0x87, 0xe4, 0x32, 0xfd, 0xf7, 0xec, 0xb5,
    0x7d, 0xab, 0xef, 0xc1, 0x7e, 0xe8, 0x2, 0x44,
    0x3a, 0xe4, 0x9a, 0x24, 0x9e, 0x0,

    /* U+80FD "能" */
    0x21, 0x4, 0x92, 0xc9, 0xcf, 0xd0, 0x1, 0x1f,
    0x9f, 0x89, 0xf, 0x92, 0x89, 0xef, 0x90, 0x89,
    0x18, 0x91, 0x99, 0xf0,

    /* U+884C "行" */
    0x10, 0x2, 0x7f, 0x40, 0x9, 0x0, 0x30, 0x2,
    0xff, 0x60, 0x4a, 0x4, 0x20, 0x42, 0x4, 0x20,
    0x42, 0x4, 0x21, 0xc0,

    /* U+898B "見" */
    0x3f, 0xe1, 0x1, 0xf, 0xf8, 0x40, 0x43, 0xfe,
    0x10, 0x10, 0xff, 0x87, 0xfc, 0x9, 0x0, 0x88,
    0x4c, 0x43, 0x83, 0xf0,

    /* U+89BD "覽" */
    0xfd, 0xfb, 0xf9, 0x8c, 0x5f, 0xbe, 0x6a, 0xfd,
    0xf8, 0xff, 0x83, 0xfe, 0x8, 0x8, 0x3f, 0xe0,
    0xff, 0x81, 0x90, 0xb8, 0x3e,

    /* U+89C8 "览" */
    0x8, 0x82, 0x48, 0x12, 0x7e, 0x96, 0x84, 0xa2,
    0x0, 0x0, 0xff, 0x84, 0x4, 0x22, 0x21, 0x11,
    0x9, 0xc0, 0x3a, 0x1f, 0x1f, 0x0,

    /* U+8A0A "訊" */
    0x20, 0x1, 0x3f, 0xbe, 0x4c, 0x2, 0x67, 0x93,
    0x0, 0x99, 0xff, 0xc0, 0x26, 0x79, 0x34, 0x49,
    0xa2, 0x4e, 0xf2, 0x38, 0x11, 0x0,

    /* U+8A2A "訪" */
    0x20, 0x81, 0x4, 0x3f, 0xfd, 0xff, 0xe0, 0x10,
    0x38, 0x80, 0x7, 0xee, 0x23, 0x71, 0x1c, 0x90,
    0xe4, 0x86, 0xe8, 0x28, 0x4f, 0x0,

    /* U+8A2D "設" */
    0x0, 0x1, 0x1e, 0x8, 0x91, 0xb4, 0x87, 0x47,
    0x0, 0x1, 0xdf, 0xc0, 0x84, 0x72, 0x24, 0x9a,
    0x24, 0x60, 0xe7, 0xc8, 0x63, 0x0,

    /* U+8A66 "試" */
    0x20, 0x41, 0x2, 0xbe, 0x10, 0xf, 0xf7, 0x84,
    0x0, 0x21, 0xef, 0x0, 0x28, 0x79, 0x42, 0x49,
    0x12, 0xea, 0xf8, 0x54, 0x1, 0x80,

    /* U+8A71 "話" */
    0x20, 0x71, 0x1e, 0x3e, 0x10, 0x0, 0x87, 0xbf,
    0x80, 0x21, 0xc1, 0xf, 0x7e, 0x8a, 0x14, 0x50,
    0xa2, 0x84, 0xf7, 0xe0,

    /* U+8A8D "認" */
    0x0, 0x1, 0x1f, 0x88, 0xa5, 0xf5, 0x20, 0x69,
    0x3c, 0x88, 0x9, 0xce, 0x10, 0x7b, 0xa4, 0x68,
    0xa3, 0x4c, 0xfa, 0x48, 0x1e, 0x0,

    /* U+8AA4 "誤" */
    0x0, 0x1, 0x3f, 0x81, 0x5, 0xf8, 0x27, 0xff,
    0x0, 0x1, 0xff, 0xc0, 0x10, 0x7f, 0xf4, 0x4c,
    0x22, 0x50, 0xf6, 0xc8, 0x41, 0x0,

    /* U+8AAA "說" */
    0x21, 0x41, 0x11, 0x3e, 0x84, 0x8, 0x17, 0xbf,
    0x1, 0x9, 0xe8, 0x40, 0x7e, 0x79, 0x44, 0x4a,
    0x22, 0x92, 0xf4, 0x98, 0x47, 0x80,

    /* U+8AAD "読" */
    0x20, 0xc1, 0x6, 0x8, 0xff, 0xf1, 0x87, 0xbf,
    0x81, 0xfd, 0xf0, 0x20, 0x25, 0x79, 0x22, 0x49,
    0x12, 0xc8, 0xf4, 0x54, 0x63, 0x80,

    /* U+8ACB "請" */
    0x20, 0x81, 0x3f, 0x80, 0x21, 0xff, 0xe0, 0x8,
    0x3b, 0xb9, 0xef, 0xe0, 0x43, 0x7b, 0xfc, 0x50,
    0xe2, 0xfe, 0xf4, 0x38, 0x27, 0x0,

    /* U+8B66 "警" */
    0x24, 0x43, 0xf4, 0xf, 0xbe, 0xf6, 0xa4, 0xa6,
    0x1f, 0x6c, 0x18, 0x2f, 0xff, 0x1f, 0xe0, 0xff,
    0x7, 0xf8, 0x20, 0x41, 0xfe, 0x0,

    /* U+8BBE "设" */
    0x61, 0xf0, 0x44, 0xc0, 0x33, 0x3c, 0x8e, 0x34,
    0x0, 0xdf, 0xe3, 0x21, 0xc, 0x4c, 0x31, 0xa0,
    0xe3, 0x6, 0x33, 0x1, 0x2,

    /* U+8BBF "访" */
    0x40, 0x81, 0x4, 0x7, 0xfe, 0x1f, 0xf0, 0x30,
    0x71, 0x80, 0x8f, 0xc4, 0x66, 0x23, 0x31, 0x51,
    0x8d, 0x8c, 0xc8, 0x40, 0xce, 0x0,

    /* U+8BD5 "试" */
    0x40, 0x61, 0x2, 0x84, 0x10, 0x1f, 0xfe, 0x4,
    0x13, 0xa0, 0x9d, 0x4, 0x48, 0x22, 0x41, 0x12,
    0xa, 0xea, 0x7e, 0x50, 0x1, 0x0,

    /* U+8BDD "话" */
    0x0, 0x13, 0x3f, 0xc, 0x20, 0x1, 0x0, 0x8,
    0x77, 0xfc, 0x82, 0x4, 0x10, 0x27, 0xf9, 0x30,
    0xcb, 0x86, 0x6c, 0x34, 0x7f, 0x80,

    /* U+8BEF "误" */
    0x63, 0xf9, 0x90, 0xc4, 0x86, 0x7, 0xf7, 0x3f,
    0x99, 0xfc, 0xc1, 0x6, 0xff, 0x30, 0xc1, 0xcd,
    0x8, 0xc4, 0x8, 0x10,

    /* U+8BF4 "说" */
    0x2, 0x33, 0x11, 0xc, 0x58, 0xf, 0xe0, 0x41,
    0x72, 0x8, 0x9f, 0xc4, 0xfe, 0x21, 0x41, 0xa,
    0xe, 0x90, 0xcc, 0x90, 0xc7, 0x80,

    /* U+8BF7 "请" */
    0x40, 0x83, 0x3f, 0x8c, 0x20, 0xf, 0xe0, 0x8,
    0x77, 0xfc, 0x9f, 0xc4, 0xc6, 0x27, 0xf1, 0x71,
    0x8f, 0xfc, 0x4c, 0x60, 0x67, 0x0,

    /* U+8CC7 "資" */
    0x42, 0x1, 0xbf, 0x83, 0x24, 0x63, 0x8c, 0xe3,
    0x1f, 0xf0, 0x80, 0x87, 0xfc, 0x20, 0x21, 0xff,
    0xf, 0xf8, 0x31, 0x8e, 0x3, 0x0,

    /* U+8D25 "败" */
    0x0, 0x83, 0xe4, 0x11, 0x20, 0xab, 0xf5, 0x51,
    0x2a, 0x89, 0x5c, 0x8a, 0x94, 0x54, 0xa2, 0xa2,
    0xa, 0x18, 0x49, 0x6c, 0x71, 0x80,

    /* U+8D44 "资" */
    0x2, 0x3, 0x10, 0xd, 0xfc, 0x3b, 0x20, 0x18,
    0x7b, 0x30, 0x20, 0x47, 0xfc, 0x22, 0x21, 0x11,
    0x9, 0x48, 0x19, 0x8f, 0x3, 0x0,

    /* U+8D85 "超" */
    0x10, 0x0, 0x8f, 0x9f, 0x24, 0x21, 0x2f, 0xdf,
    0x7f, 0x98, 0x47, 0xcb, 0xe2, 0x51, 0x12, 0x88,
    0x9c, 0x7c, 0xa0, 0x8, 0xff, 0x80,

    /* U+8DB3 "足" */
    0x3f, 0xf1, 0x0, 0x88, 0x4, 0x7f, 0xe3, 0xff,
    0x1, 0x0, 0x48, 0x4, 0x7e, 0x32, 0x1, 0xd0,
    0x13, 0x81, 0x87, 0xf0,

    /* U+8DEF "路" */
    0x0, 0x1, 0xe6, 0x4, 0x9f, 0x12, 0xcc, 0x7a,
    0xa0, 0x41, 0x85, 0xe, 0x17, 0xc6, 0x53, 0xf9,
    0x44, 0x65, 0x51, 0x9e, 0x46, 0xc1, 0xf8,

    /* U+8F09 "載" */
    0x11, 0x4f, 0xd2, 0x11, 0xf, 0xff, 0x11, 0x7,
    0xd2, 0xfd, 0x29, 0x54, 0xfd, 0x49, 0x48, 0x79,
    0x9f, 0xfd, 0x14, 0x70,

    /* U+8F7D "载" */
    0x11, 0x8f, 0xfa, 0x11, 0x8f, 0xff, 0x21, 0x82,
    0x8, 0xfe, 0xa4, 0x8a, 0xfe, 0xe0, 0x8c, 0x3e,
    0xdc, 0x9d, 0xb, 0x30,

    /* U+8FBC "込" */
    0x42, 0x1, 0x8, 0x0, 0x60, 0x3, 0x0, 0x18,
    0x71, 0xa0, 0x89, 0x4, 0xcc, 0x2c, 0x33, 0x40,
    0xb6, 0x1, 0x1f, 0xf0,

    /* U+8FDB "进" */
    0x42, 0x44, 0x24, 0x22, 0x40, 0xff, 0x2, 0x4e,
    0x24, 0x2f, 0xf2, 0x24, 0x26, 0x42, 0x44, 0x60,
    0x4d, 0x0, 0x8f, 0xf0,

    /* U+8FDE "连" */
    0x41, 0x0, 0xbf, 0xc0, 0x24, 0x0, 0x90, 0xe7,
    0xf8, 0x81, 0x2, 0x4, 0xb, 0xfe, 0x20, 0x40,
    0x81, 0x5, 0x84, 0x23, 0xfe,

    /* U+9001 "送" */
    0x42, 0x33, 0x11, 0xc, 0x18, 0xf, 0xf0, 0x8,
    0x70, 0x40, 0xbf, 0xe4, 0x38, 0x21, 0x61, 0x11,
    0x99, 0x5, 0xb0, 0x8, 0xff, 0x80,

    /* U+9023 "連" */
    0x40, 0x81, 0xbf, 0xe3, 0x8, 0x3, 0xfc, 0x8,
    0x93, 0xbf, 0xc2, 0x89, 0xb, 0xfc, 0x20, 0x80,
    0xbf, 0xe6, 0x8, 0x36, 0x0, 0x8f, 0xf8,

    /* U+9054 "達" */
    0x0, 0x82, 0x3f, 0x88, 0x20, 0x5f, 0xf0, 0x22,
    0x1, 0x13, 0x97, 0x44, 0xfe, 0x20, 0x81, 0x7f,
    0xc8, 0x20, 0xb0, 0x8, 0xff, 0x80,

    /* U+914D "配" */
    0xfd, 0xff, 0xc3, 0xfc, 0x3d, 0x43, 0xd5, 0xfd,
    0x53, 0xdd, 0x8, 0x50, 0xfd, 0x8, 0x51, 0xfd,
    0x18, 0x5f,

    /* U+91CD "重" */
    0x0, 0x1, 0xff, 0x0, 0x81, 0xff, 0xf0, 0x20,
    0x1f, 0xf8, 0xff, 0xc4, 0x42, 0x3f, 0xf0, 0x10,
    0x1f, 0xfc, 0x4, 0xf, 0xff, 0x80,

    /* U+91CF "量" */
    0x3f, 0xf1, 0xff, 0x8f, 0xfc, 0x0, 0xf, 0xff,
    0x9f, 0xf8, 0x88, 0x47, 0xfe, 0x3f, 0xf0, 0x10,
    0xf, 0xfc, 0xff, 0xf0,

    /* U+932F "錯" */
    0x21, 0x21, 0x89, 0x17, 0xfd, 0x2, 0x47, 0x12,
    0x13, 0xfc, 0x80, 0x1e, 0xfe, 0xae, 0x15, 0xbf,
    0x89, 0x84, 0x7c, 0x2c, 0x7f, 0x0,

    /* U+9519 "错" */
    0x21, 0x22, 0x9, 0x1f, 0xff, 0x2, 0x47, 0x92,
    0x3f, 0xfc, 0x80, 0x1f, 0xfc, 0x26, 0x21, 0x3f,
    0xb, 0x88, 0x7c, 0x46, 0x7e, 0x0,

    /* U+9589 "閉" */
    0xfd, 0xfe, 0x68, 0xff, 0x7f, 0x9a, 0x3f, 0xdf,
    0xe0, 0x8f, 0x7f, 0x78, 0x63, 0xc5, 0x1e, 0x48,
    0xf4, 0x47, 0x8e, 0xe0,

    /* U+958B "開" */
    0xf9, 0xfe, 0x48, 0xfe, 0x7f, 0x92, 0x3f, 0x9f,
    0xe0, 0xf, 0xff, 0x79, 0x23, 0xff, 0xde, 0x48,
    0xf4, 0x47, 0xe2, 0xe0,

    /* U+9593 "間" */
    0xfb, 0xfe, 0x58, 0xfe, 0xff, 0x96, 0x3f, 0xbf,
    0xe0, 0xf, 0x7e, 0x7b, 0x13, 0xdf, 0x9e, 0xc4,
    0xf7, 0xe7, 0xb0, 0xe0,

    /* U+95DC "關" */
    0xff, 0xff, 0xff, 0xf1, 0xc7, 0xff, 0xfc, 0x91,
    0xef, 0xcf, 0x44, 0x79, 0xc3, 0xd2, 0x9e, 0xfc,
    0xf3, 0x87, 0x94, 0xe0,

    /* U+95ED "闭" */
    0x0, 0xb, 0xfc, 0x80, 0x80, 0x98, 0x13, 0x3f,
    0xe0, 0xcc, 0x29, 0x8d, 0x36, 0x26, 0x84, 0xc7,
    0x98, 0x6,

    /* U+95EE "问" */
    0x0, 0x1b, 0xfd, 0x0, 0x80, 0x1b, 0xf3, 0x62,
    0x6c, 0x4d, 0x89, 0xb1, 0x37, 0xe6, 0xc0, 0xc0,
    0x18, 0xe,

    /* U+96FB "電" */
    0x7f, 0xe0, 0x40, 0xff, 0xfb, 0x5d, 0x75, 0xc0,
    0x40, 0x7f, 0xe4, 0x46, 0x7f, 0xe7, 0xfe, 0x44,
    0x10, 0x7f,

    /* U+9759 "静" */
    0x21, 0x3, 0xf7, 0x82, 0x32, 0x3e, 0x90, 0x23,
    0xfb, 0xf2, 0x60, 0x9, 0xbf, 0xfe, 0xfc, 0x9b,
    0x3f, 0xef, 0xc8, 0x33, 0x20, 0xdf, 0x80,

    /* U+975C "靜" */
    0x20, 0x37, 0xfe, 0x8, 0xa3, 0xf5, 0x22, 0x23,
    0x7f, 0xfc, 0x2, 0x7f, 0xff, 0xfc, 0x9e, 0x7f,
    0xff, 0x27, 0x99, 0xd, 0xf8, 0x0,

    /* U+97F3 "音" */
    0x6, 0x7, 0xfe, 0x10, 0xc1, 0x8, 0x10, 0x8f,
    0xff, 0x0, 0x3, 0xfc, 0x20, 0x43, 0xfc, 0x20,
    0x42, 0x4, 0x3f, 0xc0,

    /* U+97FF "響" */
    0x0, 0x1, 0x3d, 0xdd, 0xec, 0x99, 0x53, 0x7a,
    0x9b, 0xdf, 0xc, 0x83, 0x98, 0xff, 0xf8, 0x0,
    0x7, 0xf8, 0x3f, 0xc1, 0xfe, 0x0,

    /* U+AC00 "가" */
    0x0, 0xc0, 0xc, 0xfe, 0xc0, 0x4c, 0x4, 0xc0,
    0xcc, 0x8, 0xf1, 0x8c, 0x30, 0xc6, 0xc, 0x80,
    0xc0, 0xc, 0x0, 0xc0,

    /* U+AC04 "간" */
    0x0, 0xc7, 0xec, 0x4, 0xc0, 0x4c, 0xc, 0xf1,
    0x8c, 0x30, 0xce, 0xc, 0x0, 0xc2, 0x0, 0x20,
    0x2, 0x0, 0x3f, 0xc0,

    /* U+AC10 "감" */
    0x0, 0x47, 0xe4, 0x4, 0x40, 0xc7, 0x8, 0x43,
    0x4, 0xe0, 0x40, 0x0, 0x3f, 0xc2, 0x4, 0x20,
    0x42, 0x4, 0x3f, 0xc0,

    /* U+AC70 "거" */
    0x0, 0x60, 0xf, 0xf9, 0x82, 0x30, 0x46, 0x1f,
    0xc2, 0x18, 0xc3, 0x30, 0x78, 0xc, 0x1, 0x80,
    0x30, 0x6,

    /* U+ACAC "견" */
    0x0, 0xff, 0xb0, 0x4c, 0x1f, 0xc, 0xc6, 0x33,
    0x7f, 0x83, 0x0, 0xc8, 0x32, 0x0, 0x80, 0x3f,
    0xc0,

    /* U+ACB0 "결" */
    0x0, 0xdf, 0x30, 0x7c, 0x23, 0x10, 0xc9, 0xfc,
    0xc, 0xff, 0x0, 0xc0, 0x33, 0xfc, 0x80, 0x3f,
    0xc0,

    /* U+ACBD "경" */
    0x0, 0x6f, 0x8c, 0x11, 0x83, 0xf0, 0x86, 0x37,
    0xd8, 0x1c, 0x3, 0xf, 0x86, 0xc, 0x80, 0x98,
    0x30, 0xf8,

    /* U+ACE0 "고" */
    0xff, 0xc0, 0x18, 0x3, 0x0, 0x60, 0x8c, 0x11,
    0x2, 0x20, 0x40, 0xff, 0xe0,

    /* U+ACF5 "공" */
    0x3f, 0xc0, 0x4, 0x0, 0x40, 0x44, 0x4, 0xf,
    0xff, 0xff, 0xf1, 0xf8, 0x30, 0xc2, 0x6, 0x30,
    0x40, 0xf8,

    /* U+ACFC "과" */
    0x0, 0xc0, 0xc, 0x7f, 0xc0, 0x3c, 0x3, 0xc1,
    0x3c, 0x12, 0xf1, 0x2c, 0x10, 0xcf, 0xfc, 0x0,
    0xc0, 0xc, 0x0, 0xc0,

    /* U+AD6C "구" */
    0x7f, 0xc0, 0x18, 0x3, 0x0, 0x60, 0x9, 0xff,
    0xff, 0xf8, 0x20, 0x4, 0x0, 0x80, 0x10, 0x2,
    0x0,

    /* U+ADF8 "그" */
    0x7f, 0xc0, 0x18, 0x3, 0x0, 0x60, 0xc, 0x1,
    0x0, 0x20, 0x0, 0xff, 0xe0,

    /* U+AE30 "기" */
    0x0, 0x40, 0x1f, 0xe4, 0x19, 0x4, 0x43, 0x10,
    0x84, 0x61, 0x30, 0x78, 0x18, 0x4, 0x1, 0x0,
    0x40,

    /* U+B044 "끄" */
    0x7b, 0xc1, 0x8, 0x21, 0xc, 0x21, 0x4, 0x21,
    0x84, 0x20, 0x0, 0xff, 0xe0,

    /* U+B098 "나" */
    0x0, 0xc0, 0xc, 0x80, 0xc8, 0xc, 0x80, 0xc8,
    0xf, 0x80, 0xc8, 0xc, 0x82, 0xcf, 0xec, 0x0,
    0xc0, 0xc, 0x0, 0xc0,

    /* U+B124 "네" */
    0x0, 0x40, 0xd8, 0x36, 0xd, 0x83, 0x67, 0xd8,
    0x36, 0xd, 0x83, 0x7e, 0xdf, 0x34, 0xd, 0x3,
    0x40,

    /* U+B155 "녕" */
    0x0, 0xe0, 0x38, 0xfe, 0x3, 0x8f, 0xe0, 0x3f,
    0xcf, 0xe3, 0x1f, 0x18, 0x74, 0xd, 0x87, 0x1f,
    0x0,

    /* U+B294 "는" */
    0x60, 0xc, 0x1, 0x80, 0x3f, 0xe0, 0x0, 0x0,
    0x3f, 0xfb, 0x0, 0x60, 0xc, 0x1, 0xff, 0x3f,
    0xe0,

    /* U+B2A5 "능" */
    0x20, 0x4, 0x0, 0x80, 0x1f, 0xe3, 0xfc, 0x0,
    0x3f, 0xf8, 0xf8, 0x20, 0x88, 0x8, 0x83, 0xf,
    0x80,

    /* U+B2C8 "니" */
    0x0, 0x80, 0x60, 0x30, 0x18, 0xc, 0x6, 0x3,
    0x1, 0x82, 0xff, 0x40, 0x20, 0x10, 0x8,

    /* U+B2E4 "다" */
    0x1, 0x80, 0x33, 0xf6, 0x40, 0xc8, 0x19, 0x3,
    0xe0, 0x64, 0xc, 0x81, 0x9f, 0xb3, 0x86, 0x0,
    0xc0, 0x18,

    /* U+B2F5 "답" */
    0x0, 0x9f, 0x12, 0x2, 0x40, 0x78, 0x9, 0x5,
    0x3f, 0xa0, 0x0, 0x40, 0x8f, 0xf1, 0x2, 0x20,
    0x47, 0xf8,

    /* U+B300 "대" */
    0x0, 0x60, 0x6f, 0xed, 0xc1, 0xb8, 0x37, 0x7,
    0xe0, 0xdc, 0x1b, 0x83, 0x7f, 0x6f, 0x8d, 0x81,
    0xb0, 0x6,

    /* U+B3C4 "도" */
    0x7f, 0x88, 0x1, 0x0, 0x20, 0x4, 0x0, 0x80,
    0x1f, 0xf0, 0x20, 0x4, 0x1f, 0xff, 0xff, 0x80,

    /* U+B428 "됨" */
    0x0, 0x5f, 0x94, 0x5, 0x1, 0x7e, 0x44, 0x1f,
    0xf7, 0xe0, 0x0, 0xf, 0xf2, 0x4, 0x81, 0x3f,
    0xc0,

    /* U+B4C8 "듈" */
    0x7f, 0xc8, 0x1, 0xff, 0x0, 0x0, 0x1, 0xff,
    0xc4, 0x43, 0xfe, 0x0, 0xcf, 0xf9, 0x0, 0x3f,
    0xe0,

    /* U+B4DC "드" */
    0x7f, 0xcc, 0x1, 0x80, 0x30, 0x7, 0xfc, 0xff,
    0x80, 0x0, 0x0, 0xff, 0xe0,

    /* U+B4E3 "듣" */
    0x7f, 0xcc, 0x1, 0x80, 0x3f, 0xe0, 0x1, 0xff,
    0xc0, 0x0, 0x0, 0x7f, 0xcc, 0x1, 0x80, 0x3f,
    0xe0,

    /* U+B529 "딩" */
    0x0, 0xfe, 0x60, 0x30, 0x18, 0xc, 0x7, 0xfa,
    0x1, 0x3f, 0x30, 0xd0, 0x2c, 0x33, 0xf0,

    /* U+B808 "레" */
    0x0, 0x40, 0xdf, 0x34, 0x4d, 0x13, 0x7f, 0xd8,
    0x36, 0xd, 0x83, 0x7e, 0xde, 0x34, 0xd, 0x0,
    0x40,

    /* U+B824 "려" */
    0x0, 0xfe, 0x30, 0x8c, 0x3f, 0x8, 0xfe, 0x38,
    0xe, 0x1f, 0x80, 0xff, 0x3f, 0x8c, 0x3, 0x0,
    0xc0,

    /* U+B85C "로" */
    0x7f, 0x80, 0x10, 0x2, 0x3f, 0xc4, 0x0, 0x80,
    0x1f, 0xf3, 0xfe, 0x4, 0x1f, 0xff, 0xff, 0x80,

    /* U+B958 "류" */
    0x7f, 0xc0, 0x19, 0xff, 0x20, 0x4, 0x0, 0xff,
    0xbf, 0xff, 0xff, 0x31, 0x6, 0x20, 0xc4, 0x18,
    0x80,

    /* U+B968 "륨" */
    0x7f, 0x80, 0x11, 0xfe, 0x20, 0x7, 0xfc, 0x0,
    0x3f, 0xf8, 0x88, 0x7f, 0x88, 0x11, 0x2, 0x3f,
    0xc0,

    /* U+B97C "를" */
    0x7f, 0xc0, 0x9, 0xfe, 0x3f, 0xe7, 0xfd, 0xff,
    0xc0, 0x3, 0xfe, 0x0, 0x4f, 0xf9, 0x0, 0x3f,
    0xe0,

    /* U+B9AC "리" */
    0x0, 0x80, 0x7f, 0x20, 0x90, 0x4f, 0xe6, 0x3,
    0x1, 0x80, 0xff, 0x7e, 0x20, 0x10, 0x8,

    /* U+B9D0 "말" */
    0x0, 0x9f, 0x92, 0x12, 0x42, 0x78, 0x49, 0xf9,
    0x0, 0x23, 0xfc, 0x0, 0x80, 0x11, 0xfe, 0x20,
    0x7, 0xfc,

    /* U+BAA8 "모" */
    0x7f, 0xc8, 0x9, 0x1, 0x20, 0x24, 0x4, 0xff,
    0x9f, 0xf0, 0x20, 0x4, 0x1f, 0xff, 0xff, 0x80,

    /* U+BC1C "발" */
    0x0, 0x90, 0x92, 0x12, 0x7e, 0x78, 0x49, 0xf9,
    0x0, 0x20, 0x0, 0x7f, 0x80, 0x11, 0xfe, 0x20,
    0x7, 0xfc,

    /* U+BC30 "배" */
    0x0, 0x60, 0x6e, 0x2d, 0xc5, 0xbf, 0xb7, 0x17,
    0xe2, 0xdc, 0x5b, 0x8b, 0x7f, 0x6c, 0xd, 0x81,
    0xb0, 0x6,

    /* U+BC84 "버" */
    0x0, 0xe3, 0x38, 0xce, 0x33, 0x8c, 0xff, 0xf8,
    0xce, 0x33, 0x8c, 0xff, 0x30, 0xc, 0x3, 0x0,
    0xc0,

    /* U+BCF4 "보" */
    0x40, 0x48, 0x9, 0x1, 0x3f, 0xe4, 0x4, 0xff,
    0x9f, 0xf0, 0x20, 0x4, 0x1f, 0xff, 0xff, 0x80,

    /* U+BCFC "볼" */
    0x40, 0x8f, 0xf1, 0x2, 0x3f, 0xc0, 0x41, 0xff,
    0xff, 0xfb, 0xfc, 0x0, 0x8f, 0xf1, 0x0, 0x3f,
    0xe0,

    /* U+BD80 "부" */
    0x40, 0x88, 0x11, 0xfe, 0x20, 0x47, 0xf8, 0x0,
    0x0, 0x7, 0xff, 0x4, 0x0, 0x80, 0x10, 0x2,
    0x0,

    /* U+BE44 "비" */
    0x0, 0xc2, 0x61, 0x30, 0x98, 0x4f, 0xe6, 0x13,
    0x9, 0x84, 0xfe, 0x40, 0x20, 0x10, 0x8,

    /* U+C0AC "사" */
    0x0, 0xc1, 0xc, 0x10, 0xc1, 0xc, 0x10, 0xc1,
    0xc, 0x38, 0xf2, 0x8c, 0x4c, 0xcc, 0x6c, 0x0,
    0xc0, 0xc, 0x0, 0xc0,

    /* U+C0BD "삽" */
    0x0, 0x41, 0x4, 0x10, 0x41, 0x7, 0x28, 0x46,
    0x64, 0xc2, 0x40, 0x0, 0x20, 0x43, 0xfc, 0x20,
    0x42, 0x4, 0x3f, 0xc0,

    /* U+C0C1 "상" */
    0x0, 0x40, 0x84, 0x8, 0x40, 0x84, 0x18, 0x71,
    0x44, 0x62, 0x44, 0x4, 0x1f, 0x83, 0xc, 0x20,
    0x43, 0xc, 0x1f, 0x80,

    /* U+C0C8 "새" */
    0x0, 0x30, 0x1b, 0x11, 0xb1, 0x1b, 0x11, 0xb1,
    0x1f, 0x39, 0xb2, 0x9b, 0x47, 0xb8, 0x1b, 0x1,
    0xb0, 0x1b, 0x0, 0x30,

    /* U+C11C "서" */
    0x0, 0x30, 0x83, 0x8, 0x30, 0x83, 0x8, 0x31,
    0x9f, 0x14, 0x31, 0x43, 0x22, 0x36, 0x13, 0x0,
    0x30, 0x3, 0x0, 0x30,

    /* U+C124 "설" */
    0x0, 0x44, 0x11, 0x4, 0x4f, 0x28, 0x5b, 0x1c,
    0x64, 0x0, 0x3f, 0xc0, 0x13, 0xfc, 0x80, 0x3f,
    0xc0,

    /* U+C131 "성" */
    0x0, 0x62, 0xc, 0x41, 0x89, 0xf2, 0x86, 0x58,
    0xf1, 0x9c, 0x3, 0xf, 0x86, 0xc, 0x81, 0x98,
    0x30, 0xf8,

    /* U+C138 "세" */
    0x0, 0x20, 0x34, 0x46, 0x88, 0xd1, 0x1a, 0x2f,
    0x4e, 0x69, 0x4d, 0x6d, 0xb8, 0xb4, 0x6, 0x80,
    0xd0, 0x1a,

    /* U+C14B "셋" */
    0x0, 0x21, 0x1a, 0x11, 0xa1, 0x3a, 0x39, 0xa2,
    0x9a, 0xc5, 0xa0, 0x1a, 0x2, 0x0, 0x70, 0xd,
    0xc3, 0x7,

    /* U+C18C "소" */
    0x4, 0x0, 0x80, 0x30, 0x5, 0x3, 0x18, 0xc1,
    0xc1, 0x0, 0x20, 0x4, 0x1f, 0xff, 0xff, 0x80,

    /* U+C18D "속" */
    0x4, 0x1, 0xc0, 0xe6, 0x22, 0x20, 0x41, 0xff,
    0xff, 0xf8, 0x0, 0x7f, 0xc0, 0x8, 0x1, 0x0,
    0x20,

    /* U+C1A1 "송" */
    0x4, 0x1, 0xc0, 0x6c, 0x32, 0x60, 0x41, 0xff,
    0xc0, 0x0, 0x0, 0x3f, 0x88, 0x9, 0x1, 0x1f,
    0xc0,

    /* U+C218 "수" */
    0x4, 0x0, 0x80, 0x28, 0x18, 0xc6, 0xc, 0x0,
    0x3f, 0xff, 0xff, 0x4, 0x0, 0x80, 0x10, 0x2,
    0x0,

    /* U+C2A4 "스" */
    0x4, 0x0, 0x80, 0x30, 0x5, 0x3, 0x10, 0xc1,
    0x80, 0x0, 0x0, 0x0, 0x1f, 0xfc,

    /* U+C2B5 "습" */
    0x4, 0x1, 0x80, 0x6c, 0x30, 0xe0, 0x1, 0xff,
    0xc0, 0x2, 0x6, 0x7f, 0xc8, 0x19, 0x3, 0x3f,
    0xe0,

    /* U+C2DC "시" */
    0x0, 0x21, 0x4, 0x20, 0x84, 0x10, 0x82, 0x38,
    0x45, 0x9, 0xb1, 0x23, 0x28, 0x24, 0x0, 0x80,
    0x10, 0x2,

    /* U+C2E4 "실" */
    0x0, 0x44, 0x11, 0x4, 0xe1, 0x6c, 0x60, 0x90,
    0x0, 0x0, 0x3f, 0xc0, 0x13, 0xfc, 0x80, 0x3f,
    0xc0,

    /* U+C548 "안" */
    0x0, 0xc7, 0x8c, 0xc8, 0xc8, 0x4c, 0x84, 0xf8,
    0x4c, 0x48, 0xc7, 0x8c, 0x0, 0xc2, 0xc, 0x20,
    0x2, 0x0, 0x3f, 0xc0,

    /* U+C5C5 "업" */
    0x0, 0x5e, 0x1c, 0x66, 0x1f, 0x86, 0x71, 0x97,
    0xc4, 0x0, 0x20, 0x4f, 0xf2, 0x4, 0x81, 0x3f,
    0xc0,

    /* U+C5C6 "없" */
    0x0, 0x4f, 0xb, 0x11, 0x43, 0xe8, 0x65, 0x88,
    0x9e, 0x10, 0x0, 0x44, 0x8f, 0x91, 0x17, 0x22,
    0xa7, 0xe2,

    /* U+C5D0 "에" */
    0x0, 0x20, 0x25, 0xe4, 0xa4, 0x98, 0xd3, 0x1e,
    0x63, 0x4c, 0x69, 0x49, 0x2f, 0x24, 0x4, 0x80,
    0x90, 0x2,

    /* U+C5F0 "연" */
    0x0, 0x6f, 0xf, 0x3f, 0xc2, 0x38, 0x47, 0x8,
    0xd2, 0xfb, 0xc3, 0x0, 0x64, 0xc, 0x80, 0x10,
    0x3, 0xfc,

    /* U+C624 "오" */
    0x1f, 0x4, 0x11, 0x1, 0x20, 0x26, 0xc, 0x7f,
    0x7, 0xc0, 0x20, 0x4, 0x1f, 0xff, 0xff, 0x80,

    /* U+C644 "완" */
    0x0, 0xc3, 0xcc, 0x42, 0xc4, 0x2c, 0x42, 0xc3,
    0xcf, 0x8, 0xcf, 0xfc, 0xf8, 0xc3, 0xc, 0x30,
    0x3, 0x0, 0x3f, 0xe0,

    /* U+C694 "요" */
    0x1f, 0x4, 0x31, 0x3, 0x20, 0x24, 0xc, 0x63,
    0x7, 0xc0, 0x88, 0x11, 0x1f, 0xff, 0xff, 0x80,

    /* U+C6A9 "용" */
    0x3f, 0x8, 0x11, 0x82, 0x1f, 0x83, 0x11, 0xff,
    0xff, 0xf8, 0x0, 0x3f, 0x8, 0x11, 0x2, 0x1f,
    0x80,

    /* U+C6B4 "운" */
    0x1f, 0xc, 0x19, 0x1, 0x30, 0x61, 0xf1, 0xff,
    0xff, 0xfa, 0x20, 0x44, 0x8, 0x81, 0xff, 0x3f,
    0xe0,

    /* U+C6CC "워" */
    0x0, 0x67, 0x8d, 0x9, 0xa1, 0x34, 0x26, 0x78,
    0xc0, 0x1f, 0xfb, 0x8, 0x61, 0x7c, 0x21, 0x84,
    0x30, 0x86,

    /* U+C744 "을" */
    0x1f, 0x8c, 0x19, 0x1, 0x1f, 0xc0, 0x1, 0xff,
    0xc0, 0x3, 0xfe, 0x0, 0x4f, 0xf9, 0x0, 0x3f,
    0xe0,

    /* U+C74C "음" */
    0x1f, 0xc, 0x19, 0x1, 0x30, 0x61, 0xf0, 0x0,
    0x3f, 0xf8, 0x0, 0x7f, 0xc8, 0x9, 0x1, 0x3f,
    0xe0,

    /* U+C751 "응" */
    0x1f, 0xc, 0x19, 0x1, 0x30, 0x61, 0xf0, 0x0,
    0x3f, 0xf8, 0x0, 0x3f, 0xc, 0x19, 0x83, 0x1f,
    0xc0,

    /* U+C774 "이" */
    0x0, 0x4c, 0x14, 0x86, 0x11, 0x84, 0x61, 0x18,
    0x46, 0x11, 0x48, 0x5c, 0x10, 0x4, 0x1, 0x0,
    0x40,

    /* U+C778 "인" */
    0x0, 0x5e, 0x1c, 0x86, 0x11, 0x84, 0x61, 0x1c,
    0xc5, 0xe1, 0x0, 0x48, 0x2, 0x0, 0x80, 0x3f,
    0xc0,

    /* U+C785 "입" */
    0x0, 0x5e, 0x1c, 0xc6, 0x11, 0x84, 0x73, 0x17,
    0x84, 0x0, 0x20, 0x4f, 0xf2, 0x4, 0x81, 0x3f,
    0xc0,

    /* U+C7A0 "잠" */
    0x0, 0x4f, 0xe4, 0x10, 0x41, 0x4, 0x38, 0x72,
    0x84, 0x46, 0x48, 0x24, 0x3f, 0xc2, 0x4, 0x20,
    0x42, 0x4, 0x3f, 0xc0,

    /* U+C804 "전" */
    0x0, 0x7f, 0xcf, 0xf9, 0x88, 0x31, 0x3e, 0x50,
    0xdb, 0x1e, 0x13, 0x0, 0x64, 0xc, 0x80, 0x10,
    0x3, 0xfc,

    /* U+C811 "접" */
    0x0, 0x7f, 0x91, 0x4, 0x4f, 0x28, 0x5b, 0x1c,
    0x24, 0x0, 0x20, 0x4f, 0xf2, 0x4, 0x81, 0x3f,
    0xc0,

    /* U+C815 "정" */
    0x0, 0x7f, 0xcc, 0x41, 0x88, 0x33, 0x9e, 0x50,
    0xd1, 0x1e, 0x13, 0xf, 0x86, 0x1c, 0x81, 0x98,
    0x70, 0xf8,

    /* U+C871 "족" */
    0x7f, 0xc0, 0x80, 0x28, 0x18, 0xc4, 0x44, 0x8,
    0x3f, 0xff, 0xff, 0x7f, 0xc0, 0x8, 0x1, 0x0,
    0x20,

    /* U+C8FC "주" */
    0x7f, 0xc0, 0x80, 0x28, 0xd, 0x86, 0xc, 0x0,
    0x3f, 0xff, 0xff, 0x4, 0x0, 0x80, 0x10, 0x2,
    0x0,

    /* U+C911 "중" */
    0x7f, 0xc1, 0xc0, 0x28, 0x38, 0xe0, 0x1, 0xff,
    0xc1, 0x0, 0xf8, 0x7f, 0xc8, 0x9, 0x83, 0xf,
    0x80,

    /* U+C9C0 "지" */
    0x0, 0x2f, 0xe5, 0xfc, 0x84, 0x10, 0x82, 0x10,
    0x47, 0x8, 0xa1, 0x32, 0x2c, 0x34, 0x0, 0x80,
    0x10, 0x2,

    /* U+C9C4 "진" */
    0x0, 0x40, 0x1f, 0xe4, 0x41, 0x10, 0x4e, 0x12,
    0xc7, 0x9, 0x0, 0x48, 0x2, 0x0, 0x80, 0x3f,
    0xc0,

    /* U+CC3E "찾" */
    0x10, 0xcf, 0xec, 0xfe, 0xc1, 0xc, 0x10, 0xf2,
    0x8c, 0x64, 0xcc, 0x2c, 0x0, 0x7, 0xfc, 0xe,
    0x0, 0xb0, 0x31, 0xc4, 0x4,

    /* U+CD08 "초" */
    0x4, 0xf, 0xf9, 0xff, 0x2, 0x0, 0xa0, 0x22,
    0x18, 0x30, 0x20, 0x4, 0x1f, 0xfc,

    /* U+CD5C "최" */
    0x8, 0x2f, 0xe5, 0xfc, 0x84, 0x11, 0x42, 0x6c,
    0x58, 0x48, 0x41, 0x8, 0x3f, 0xf5, 0xf0, 0x80,
    0x10, 0x2,

    /* U+CDA9 "충" */
    0x4, 0xf, 0xf9, 0xff, 0x7, 0x1, 0xb0, 0xc0,
    0xbf, 0xff, 0xff, 0x4, 0x7, 0xf1, 0xff, 0x20,
    0x23, 0xf8,

    /* U+CE5C "친" */
    0x10, 0x7f, 0x9f, 0xe4, 0x41, 0x18, 0x4b, 0x14,
    0x66, 0x1, 0x20, 0x48, 0x2, 0x0, 0x80, 0x3f,
    0xc0,

    /* U+CE74 "카" */
    0x0, 0xc0, 0xc, 0xfc, 0xc0, 0x4c, 0x4, 0xcf,
    0xcc, 0xc8, 0xf1, 0x8c, 0x30, 0xc6, 0xc, 0xc0,
    0xc0, 0xc, 0x0, 0xc0,

    /* U+CE94 "캔" */
    0x0, 0x7f, 0xec, 0x3d, 0x85, 0xbf, 0xbe, 0x66,
    0xd8, 0xde, 0x1b, 0x23, 0x64, 0xc, 0x80, 0x10,
    0x3, 0xfe,

    /* U+CF1C "켜" */
    0x0, 0x60, 0xf, 0xf1, 0x82, 0x30, 0x7f, 0xf8,
    0xc2, 0x18, 0xdf, 0x30, 0x6c, 0xe, 0x1, 0x80,
    0x30, 0x6,

    /* U+D06C "크" */
    0x7f, 0xc0, 0x8, 0x1, 0x3f, 0xe0, 0xc, 0x1,
    0x80, 0x20, 0x0, 0xff, 0xe0,

    /* U+D0DC "태" */
    0x0, 0x60, 0x6f, 0xfd, 0xe1, 0xbc, 0x37, 0xff,
    0xf0, 0xde, 0x1b, 0xc3, 0x7f, 0xef, 0xed, 0x81,
    0xb0, 0x6,

    /* U+D130 "터" */
    0x0, 0x60, 0xf, 0xf9, 0xe0, 0x3c, 0x7, 0xff,
    0xf0, 0x1e, 0x3, 0xc0, 0x7f, 0xcf, 0xf1, 0x80,
    0x30, 0x6,

    /* U+D15C "템" */
    0x0, 0x3f, 0xb7, 0x6, 0xe0, 0xdf, 0xfb, 0x83,
    0x7f, 0x68, 0xc, 0x0, 0x3, 0xfc, 0x40, 0x88,
    0x11, 0xfe,

    /* U+D2B8 "트" */
    0x7f, 0xc8, 0x1, 0x0, 0x3f, 0xc4, 0x0, 0x80,
    0x1f, 0xf3, 0xfe, 0x0, 0x1f, 0xfc,

    /* U+D31F "팟" */
    0x0, 0xc7, 0xec, 0x7e, 0xc2, 0x4c, 0x24, 0xf2,
    0x4c, 0xff, 0xc7, 0x8c, 0x0, 0xc0, 0x20, 0x7,
    0x0, 0xd8, 0x30, 0x60,

    /* U+D328 "패" */
    0x0, 0x7f, 0xef, 0xfd, 0xa5, 0xb4, 0xb6, 0x97,
    0xd2, 0xda, 0x5b, 0x4b, 0x7f, 0xef, 0xed, 0x81,
    0xb0, 0x6,

    /* U+D558 "하" */
    0x1, 0x82, 0x33, 0xfe, 0x7f, 0xc0, 0x18, 0xf3,
    0x21, 0x7c, 0x2c, 0xcd, 0x8f, 0x30, 0x6, 0x0,
    0xc0, 0x18,

    /* U+D55C "한" */
    0x10, 0xc1, 0xc, 0xfe, 0xc0, 0xc, 0x3c, 0xc4,
    0x2f, 0x42, 0xc3, 0xcc, 0x0, 0xc2, 0xc, 0x20,
    0x2, 0x0, 0x3f, 0xe0,

    /* U+D560 "할" */
    0x10, 0x4f, 0xe4, 0x0, 0x43, 0xc7, 0x42, 0x44,
    0x24, 0x3c, 0x40, 0x0, 0x3f, 0xc0, 0x4, 0x3f,
    0xc2, 0x0, 0x3f, 0xe0,

    /* U+D569 "합" */
    0x10, 0x4f, 0xe4, 0x0, 0x41, 0x84, 0x7e, 0x74,
    0x24, 0x42, 0x43, 0xc4, 0x20, 0x42, 0x4, 0x3f,
    0xc2, 0x4, 0x3f, 0xc0,

    /* U+D56B "핫" */
    0x10, 0xc1, 0xc, 0xfe, 0xc0, 0xc, 0x3e, 0xf4,
    0x2c, 0x42, 0xc3, 0xcc, 0x0, 0xc0, 0x20, 0x7,
    0x1, 0xd8, 0x30, 0x60,

    /* U+D588 "했" */
    0x10, 0x30, 0x8d, 0xbf, 0xec, 0x3, 0x63, 0x9f,
    0x22, 0xd9, 0x16, 0xc7, 0x36, 0x0, 0x0, 0x42,
    0x2, 0x30, 0x2b, 0x46, 0x71, 0x80,

    /* U+D654 "화" */
    0x18, 0xc1, 0x8c, 0xfe, 0xc0, 0xc, 0x3c, 0xc4,
    0x2c, 0x42, 0xf3, 0xcc, 0x18, 0xcf, 0xfc, 0xf8,
    0xc0, 0xc, 0x0, 0xc0,

    /* U+D655 "확" */
    0x10, 0x4f, 0xe4, 0x0, 0x43, 0xc4, 0x42, 0x74,
    0x24, 0x3c, 0x4f, 0xf4, 0xe0, 0x40, 0x0, 0x3f,
    0xc0, 0x4, 0x0, 0x40,

    /* U+D658 "환" */
    0x10, 0xcf, 0xec, 0xfe, 0xc3, 0xcc, 0x42, 0xc7,
    0xee, 0x3c, 0xc1, 0xc, 0xff, 0xce, 0xc, 0x20,
    0x3, 0xfc, 0x3f, 0xc0,

    /* U+D65C "활" */
    0x10, 0x5f, 0xc8, 0x1, 0x1e, 0x26, 0x64, 0x78,
    0x84, 0x57, 0xf2, 0x3f, 0xc0, 0x8, 0xff, 0x10,
    0x3, 0xfc,

    /* U+D6C4 "후" */
    0x4, 0x0, 0x83, 0xff, 0x9f, 0x86, 0x18, 0x81,
    0x18, 0x61, 0xf8, 0xff, 0xff, 0xfc, 0x10, 0x2,
    0x0, 0x40,

    /* U+FF01 "！" */
    0xfe, 0xc0,

    /* U+FF0C "，" */
    0x6c, 0xa8,

    /* U+FF1A "：" */
    0xf0, 0x3, 0xc0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 58, .box_w = 1, .box_h = 1, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1, .adv_w = 60, .box_w = 1, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3, .adv_w = 91, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 5, .adv_w = 145, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17, .adv_w = 128, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39, .adv_w = 164, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 52, .adv_w = 50, .box_w = 1, .box_h = 4, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 53, .adv_w = 67, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 58, .adv_w = 67, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 63, .adv_w = 123, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 69, .adv_w = 128, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 76, .adv_w = 60, .box_w = 2, .box_h = 3, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 77, .adv_w = 72, .box_w = 3, .box_h = 1, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 78, .adv_w = 60, .box_w = 1, .box_h = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 79, .adv_w = 83, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 86, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 95, .adv_w = 128, .box_w = 4, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 100, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 109, .adv_w = 128, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 117, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 126, .adv_w = 128, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 134, .adv_w = 128, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 142, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 151, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 160, .adv_w = 128, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 168, .adv_w = 60, .box_w = 1, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 169, .adv_w = 60, .box_w = 2, .box_h = 10, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 172, .adv_w = 128, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 179, .adv_w = 128, .box_w = 6, .box_h = 4, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 182, .adv_w = 128, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 189, .adv_w = 97, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 196, .adv_w = 201, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 212, .adv_w = 143, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 224, .adv_w = 146, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 233, .adv_w = 142, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 242, .adv_w = 164, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 252, .adv_w = 125, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 259, .adv_w = 116, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 266, .adv_w = 163, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 276, .adv_w = 166, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 286, .adv_w = 76, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 290, .adv_w = 61, .box_w = 4, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 297, .adv_w = 139, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 306, .adv_w = 117, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 313, .adv_w = 203, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 326, .adv_w = 170, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 336, .adv_w = 175, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 348, .adv_w = 136, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 356, .adv_w = 175, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 371, .adv_w = 139, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 380, .adv_w = 123, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 388, .adv_w = 125, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 397, .adv_w = 164, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 407, .adv_w = 134, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 417, .adv_w = 208, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 434, .adv_w = 131, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 444, .adv_w = 127, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 453, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 462, .adv_w = 74, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 467, .adv_w = 83, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 474, .adv_w = 74, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 479, .adv_w = 128, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 485, .adv_w = 99, .box_w = 6, .box_h = 1, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 486, .adv_w = 63, .box_w = 2, .box_h = 3, .ofs_x = 1, .ofs_y = 9},
    {.bitmap_index = 487, .adv_w = 126, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 493, .adv_w = 138, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 503, .adv_w = 108, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 509, .adv_w = 138, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 519, .adv_w = 126, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 525, .adv_w = 77, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 532, .adv_w = 138, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 543, .adv_w = 138, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 552, .adv_w = 58, .box_w = 1, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 554, .adv_w = 58, .box_w = 3, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 560, .adv_w = 120, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 569, .adv_w = 58, .box_w = 1, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 571, .adv_w = 209, .box_w = 11, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 582, .adv_w = 138, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 588, .adv_w = 136, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 595, .adv_w = 138, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 606, .adv_w = 138, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 617, .adv_w = 93, .box_w = 4, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 621, .adv_w = 107, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 626, .adv_w = 81, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 633, .adv_w = 138, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 639, .adv_w = 114, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 646, .adv_w = 176, .box_w = 11, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 657, .adv_w = 118, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 664, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 675, .adv_w = 105, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 680, .adv_w = 85, .box_w = 5, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 689, .adv_w = 123, .box_w = 1, .box_h = 15, .ofs_x = 3, .ofs_y = -4},
    {.bitmap_index = 691, .adv_w = 85, .box_w = 5, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 700, .adv_w = 128, .box_w = 7, .box_h = 2, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 702, .adv_w = 60, .box_w = 1, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 704, .adv_w = 128, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 712, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 721, .adv_w = 128, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 726, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 735, .adv_w = 123, .box_w = 1, .box_h = 15, .ofs_x = 3, .ofs_y = -4},
    {.bitmap_index = 737, .adv_w = 115, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 744, .adv_w = 130, .box_w = 4, .box_h = 1, .ofs_x = 2, .ofs_y = 9},
    {.bitmap_index = 745, .adv_w = 186, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 759, .adv_w = 80, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 762, .adv_w = 114, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 767, .adv_w = 128, .box_w = 7, .box_h = 4, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 771, .adv_w = 72, .box_w = 3, .box_h = 1, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 772, .adv_w = 186, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 786, .adv_w = 112, .box_w = 7, .box_h = 1, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 787, .adv_w = 96, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 791, .adv_w = 128, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 799, .adv_w = 78, .box_w = 4, .box_h = 6, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 802, .adv_w = 78, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 805, .adv_w = 63, .box_w = 2, .box_h = 3, .ofs_x = 1, .ofs_y = 9},
    {.bitmap_index = 806, .adv_w = 140, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 815, .adv_w = 147, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 827, .adv_w = 60, .box_w = 1, .box_h = 2, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 828, .adv_w = 50, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 830, .adv_w = 78, .box_w = 3, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 833, .adv_w = 84, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 836, .adv_w = 114, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 841, .adv_w = 167, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 854, .adv_w = 173, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 867, .adv_w = 175, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 881, .adv_w = 97, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 888, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 904, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 920, .adv_w = 143, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 936, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 951, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 966, .adv_w = 143, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 981, .adv_w = 197, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 995, .adv_w = 142, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1008, .adv_w = 125, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1017, .adv_w = 125, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1026, .adv_w = 125, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1035, .adv_w = 125, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1045, .adv_w = 76, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1051, .adv_w = 76, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1057, .adv_w = 76, .box_w = 5, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1066, .adv_w = 76, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1071, .adv_w = 164, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1083, .adv_w = 170, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1096, .adv_w = 175, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1112, .adv_w = 175, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1128, .adv_w = 175, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1144, .adv_w = 175, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1160, .adv_w = 175, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1175, .adv_w = 128, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1180, .adv_w = 175, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1192, .adv_w = 164, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1206, .adv_w = 164, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1220, .adv_w = 164, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1234, .adv_w = 164, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1247, .adv_w = 127, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1260, .adv_w = 136, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1268, .adv_w = 141, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1278, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1287, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1296, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1305, .adv_w = 126, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1313, .adv_w = 126, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1321, .adv_w = 126, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1330, .adv_w = 194, .box_w = 11, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1341, .adv_w = 108, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1350, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1359, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1368, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1377, .adv_w = 126, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1385, .adv_w = 58, .box_w = 2, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1388, .adv_w = 58, .box_w = 2, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1391, .adv_w = 58, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1398, .adv_w = 58, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1402, .adv_w = 136, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1412, .adv_w = 138, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1420, .adv_w = 136, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1430, .adv_w = 136, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1440, .adv_w = 136, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1450, .adv_w = 136, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1459, .adv_w = 136, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1468, .adv_w = 128, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1475, .adv_w = 136, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1482, .adv_w = 138, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1491, .adv_w = 138, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1500, .adv_w = 138, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1509, .adv_w = 138, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1517, .adv_w = 114, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1531, .adv_w = 138, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1545, .adv_w = 114, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1559, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1568, .adv_w = 126, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1577, .adv_w = 108, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1586, .adv_w = 142, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1599, .adv_w = 108, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1608, .adv_w = 138, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1621, .adv_w = 164, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1633, .adv_w = 138, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1644, .adv_w = 126, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1653, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1662, .adv_w = 138, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1676, .adv_w = 58, .box_w = 1, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1677, .adv_w = 58, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1682, .adv_w = 117, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1690, .adv_w = 58, .box_w = 3, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1695, .adv_w = 136, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1705, .adv_w = 93, .box_w = 4, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1711, .adv_w = 107, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1718, .adv_w = 123, .box_w = 6, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1729, .adv_w = 107, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1737, .adv_w = 107, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1744, .adv_w = 81, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1753, .adv_w = 138, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1762, .adv_w = 105, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1769, .adv_w = 105, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1776, .adv_w = 105, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1783, .adv_w = 151, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1794, .adv_w = 107, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1802, .adv_w = 81, .box_w = 5, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 1811, .adv_w = 161, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1823, .adv_w = 143, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1835, .adv_w = 146, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1844, .adv_w = 112, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1851, .adv_w = 125, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1858, .adv_w = 166, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1868, .adv_w = 136, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1880, .adv_w = 203, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1893, .adv_w = 170, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1903, .adv_w = 175, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1915, .adv_w = 164, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1924, .adv_w = 128, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1933, .adv_w = 125, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1942, .adv_w = 189, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1956, .adv_w = 131, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1966, .adv_w = 140, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1977, .adv_w = 105, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1986, .adv_w = 136, .box_w = 6, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1998, .adv_w = 74, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2003, .adv_w = 140, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2011, .adv_w = 137, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2025, .adv_w = 116, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2035, .adv_w = 132, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2045, .adv_w = 105, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2050, .adv_w = 103, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2059, .adv_w = 136, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2068, .adv_w = 133, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2078, .adv_w = 74, .box_w = 3, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2081, .adv_w = 120, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2087, .adv_w = 116, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2097, .adv_w = 140, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2108, .adv_w = 116, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2115, .adv_w = 110, .box_w = 5, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2124, .adv_w = 136, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2131, .adv_w = 146, .box_w = 9, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2140, .adv_w = 134, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2151, .adv_w = 109, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2158, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2166, .adv_w = 110, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2172, .adv_w = 134, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2178, .adv_w = 162, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2195, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2207, .adv_w = 168, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2222, .adv_w = 179, .box_w = 9, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2231, .adv_w = 136, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2241, .adv_w = 134, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2250, .adv_w = 179, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2263, .adv_w = 64, .box_w = 1, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2265, .adv_w = 61, .box_w = 4, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2272, .adv_w = 143, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2284, .adv_w = 138, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2292, .adv_w = 146, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2301, .adv_w = 114, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2308, .adv_w = 129, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2316, .adv_w = 169, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2326, .adv_w = 140, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2335, .adv_w = 203, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2348, .adv_w = 166, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2358, .adv_w = 170, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2370, .adv_w = 164, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2379, .adv_w = 136, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2387, .adv_w = 143, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2397, .adv_w = 125, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2406, .adv_w = 138, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2418, .adv_w = 151, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2427, .adv_w = 125, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2433, .adv_w = 134, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2444, .adv_w = 126, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2450, .adv_w = 98, .box_w = 4, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2454, .adv_w = 136, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2464, .adv_w = 123, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2470, .adv_w = 170, .box_w = 11, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2481, .adv_w = 109, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2487, .adv_w = 139, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2493, .adv_w = 139, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2502, .adv_w = 119, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2508, .adv_w = 131, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2515, .adv_w = 172, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2523, .adv_w = 138, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2529, .adv_w = 133, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2536, .adv_w = 136, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2542, .adv_w = 136, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2553, .adv_w = 110, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2559, .adv_w = 104, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2565, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2576, .adv_w = 165, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2593, .adv_w = 114, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2600, .adv_w = 137, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2609, .adv_w = 132, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2615, .adv_w = 200, .box_w = 11, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2626, .adv_w = 201, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2640, .adv_w = 140, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2648, .adv_w = 170, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2656, .adv_w = 122, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2662, .adv_w = 179, .box_w = 9, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2671, .adv_w = 129, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2677, .adv_w = 139, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2691, .adv_w = 58, .box_w = 1, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2693, .adv_w = 58, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2697, .adv_w = 58, .box_w = 3, .box_h = 14, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 2703, .adv_w = 192, .box_w = 11, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2714, .adv_w = 199, .box_w = 11, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2725, .adv_w = 139, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2735, .adv_w = 73, .box_w = 2, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2736, .adv_w = 53, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2744, .adv_w = 53, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2749, .adv_w = 53, .box_w = 3, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2755, .adv_w = 170, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2768, .adv_w = 53, .box_w = 1, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2770, .adv_w = 222, .box_w = 13, .box_h = 8, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2783, .adv_w = 91, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2789, .adv_w = 222, .box_w = 13, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2801, .adv_w = 222, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2816, .adv_w = 143, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 2827, .adv_w = 143, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 2838, .adv_w = 143, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 2852, .adv_w = 107, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2856, .adv_w = 107, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2862, .adv_w = 82, .box_w = 5, .box_h = 8, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2867, .adv_w = 82, .box_w = 5, .box_h = 11, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2874, .adv_w = 271, .box_w = 16, .box_h = 9, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2892, .adv_w = 271, .box_w = 16, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2916, .adv_w = 293, .box_w = 17, .box_h = 8, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2933, .adv_w = 293, .box_w = 17, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2957, .adv_w = 177, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2971, .adv_w = 177, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2985, .adv_w = 114, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 2996, .adv_w = 114, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 3010, .adv_w = 60, .box_w = 4, .box_h = 1, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3011, .adv_w = 220, .box_w = 13, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3028, .adv_w = 173, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3042, .adv_w = 198, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3056, .adv_w = 156, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3069, .adv_w = 108, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 3078, .adv_w = 153, .box_w = 8, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3088, .adv_w = 151, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3096, .adv_w = 100, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3101, .adv_w = 170, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3113, .adv_w = 170, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 3128, .adv_w = 0, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 3130, .adv_w = 0, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 3132, .adv_w = 222, .box_w = 13, .box_h = 10, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3149, .adv_w = 82, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 3158, .adv_w = 196, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3173, .adv_w = 196, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3191, .adv_w = 170, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3203, .adv_w = 0, .box_w = 5, .box_h = 3, .ofs_x = -5, .ofs_y = 10},
    {.bitmap_index = 3205, .adv_w = 0, .box_w = 1, .box_h = 1, .ofs_x = -2, .ofs_y = 11},
    {.bitmap_index = 3206, .adv_w = 45, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3210, .adv_w = 171, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3223, .adv_w = 229, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3239, .adv_w = 110, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3249, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3258, .adv_w = 124, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3268, .adv_w = 172, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3281, .adv_w = 183, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3295, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3304, .adv_w = 142, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3315, .adv_w = 166, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3328, .adv_w = 113, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3336, .adv_w = 120, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3345, .adv_w = 162, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3357, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3366, .adv_w = 143, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3377, .adv_w = 119, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3387, .adv_w = 138, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3396, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3405, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3414, .adv_w = 173, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3427, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3436, .adv_w = 157, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3447, .adv_w = 134, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3456, .adv_w = 130, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3465, .adv_w = 92, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3472, .adv_w = 152, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3484, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3493, .adv_w = 152, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3505, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3514, .adv_w = 151, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3526, .adv_w = 119, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 3537, .adv_w = 0, .box_w = 2, .box_h = 1, .ofs_x = -5, .ofs_y = -2},
    {.bitmap_index = 3538, .adv_w = 58, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3543, .adv_w = 58, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3561, .adv_w = 58, .box_w = 7, .box_h = 13, .ofs_x = -3, .ofs_y = 0},
    {.bitmap_index = 3573, .adv_w = 0, .box_w = 7, .box_h = 4, .ofs_x = -7, .ofs_y = -4},
    {.bitmap_index = 3577, .adv_w = 0, .box_w = 6, .box_h = 4, .ofs_x = -5, .ofs_y = -4},
    {.bitmap_index = 3580, .adv_w = 0, .box_w = 4, .box_h = 4, .ofs_x = -4, .ofs_y = -4},
    {.bitmap_index = 3582, .adv_w = 0, .box_w = 5, .box_h = 4, .ofs_x = -6, .ofs_y = 9},
    {.bitmap_index = 3585, .adv_w = 0, .box_w = 5, .box_h = 4, .ofs_x = -6, .ofs_y = 9},
    {.bitmap_index = 3588, .adv_w = 58, .box_w = 5, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3597, .adv_w = 58, .box_w = 6, .box_h = 13, .ofs_x = -2, .ofs_y = 0},
    {.bitmap_index = 3607, .adv_w = 0, .box_w = 5, .box_h = 3, .ofs_x = -3, .ofs_y = -4},
    {.bitmap_index = 3609, .adv_w = 134, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3615, .adv_w = 123, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3620, .adv_w = 138, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3626, .adv_w = 120, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3633, .adv_w = 119, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3639, .adv_w = 135, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3645, .adv_w = 123, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3650, .adv_w = 125, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3656, .adv_w = 204, .box_w = 10, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3666, .adv_w = 138, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3673, .adv_w = 142, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3680, .adv_w = 135, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3686, .adv_w = 136, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3692, .adv_w = 137, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3698, .adv_w = 135, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3704, .adv_w = 136, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3713, .adv_w = 145, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3720, .adv_w = 156, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3728, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3739, .adv_w = 135, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3746, .adv_w = 138, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3752, .adv_w = 133, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3758, .adv_w = 109, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3764, .adv_w = 128, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3770, .adv_w = 110, .box_w = 5, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3775, .adv_w = 128, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3783, .adv_w = 131, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3789, .adv_w = 129, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3795, .adv_w = 125, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3802, .adv_w = 76, .box_w = 4, .box_h = 6, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 3805, .adv_w = 0, .box_w = 5, .box_h = 2, .ofs_x = -5, .ofs_y = 9},
    {.bitmap_index = 3807, .adv_w = 91, .box_w = 4, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3811, .adv_w = 91, .box_w = 8, .box_h = 12, .ofs_x = -4, .ofs_y = 0},
    {.bitmap_index = 3823, .adv_w = 0, .box_w = 6, .box_h = 1, .ofs_x = -7, .ofs_y = 9},
    {.bitmap_index = 3824, .adv_w = 0, .box_w = 6, .box_h = 2, .ofs_x = -7, .ofs_y = 9},
    {.bitmap_index = 3826, .adv_w = 0, .box_w = 7, .box_h = 3, .ofs_x = -8, .ofs_y = 9},
    {.bitmap_index = 3829, .adv_w = 0, .box_w = 6, .box_h = 2, .ofs_x = -7, .ofs_y = 9},
    {.bitmap_index = 3831, .adv_w = 0, .box_w = 2, .box_h = 3, .ofs_x = -3, .ofs_y = -4},
    {.bitmap_index = 3832, .adv_w = 0, .box_w = 5, .box_h = 3, .ofs_x = -6, .ofs_y = -4},
    {.bitmap_index = 3834, .adv_w = 66, .box_w = 2, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3836, .adv_w = 127, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3842, .adv_w = 69, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3850, .adv_w = 65, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3856, .adv_w = 68, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3864, .adv_w = 0, .box_w = 5, .box_h = 3, .ofs_x = -6, .ofs_y = 9},
    {.bitmap_index = 3866, .adv_w = 0, .box_w = 1, .box_h = 3, .ofs_x = -2, .ofs_y = 9},
    {.bitmap_index = 3867, .adv_w = 0, .box_w = 4, .box_h = 3, .ofs_x = -5, .ofs_y = 9},
    {.bitmap_index = 3869, .adv_w = 0, .box_w = 3, .box_h = 2, .ofs_x = -4, .ofs_y = 9},
    {.bitmap_index = 3870, .adv_w = 126, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3878, .adv_w = 126, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3887, .adv_w = 126, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3898, .adv_w = 126, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3907, .adv_w = 126, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3919, .adv_w = 126, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3929, .adv_w = 126, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3938, .adv_w = 126, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3946, .adv_w = 126, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3957, .adv_w = 126, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3967, .adv_w = 126, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3977, .adv_w = 58, .box_w = 1, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3979, .adv_w = 136, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3990, .adv_w = 136, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4001, .adv_w = 136, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4013, .adv_w = 136, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4025, .adv_w = 138, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4036, .adv_w = 138, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4047, .adv_w = 138, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4059, .adv_w = 138, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4070, .adv_w = 138, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 4078, .adv_w = 138, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4087, .adv_w = 151, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4101, .adv_w = 0, .box_w = 1, .box_h = 1, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4102, .adv_w = 224, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4104, .adv_w = 224, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4108, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4122, .adv_w = 224, .box_w = 9, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4135, .adv_w = 224, .box_w = 11, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4151, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4168, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4185, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4203, .adv_w = 224, .box_w = 9, .box_h = 12, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 4217, .adv_w = 224, .box_w = 7, .box_h = 12, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 4228, .adv_w = 224, .box_w = 9, .box_h = 10, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4240, .adv_w = 224, .box_w = 9, .box_h = 13, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 4255, .adv_w = 224, .box_w = 9, .box_h = 12, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 4269, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4286, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4303, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4320, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4337, .adv_w = 224, .box_w = 10, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4352, .adv_w = 224, .box_w = 10, .box_h = 7, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4361, .adv_w = 224, .box_w = 11, .box_h = 9, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4374, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4388, .adv_w = 224, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4403, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4421, .adv_w = 224, .box_w = 11, .box_h = 11, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4437, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4451, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4468, .adv_w = 224, .box_w = 9, .box_h = 12, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 4482, .adv_w = 224, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4497, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4514, .adv_w = 224, .box_w = 8, .box_h = 12, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 4526, .adv_w = 224, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4546, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4563, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4580, .adv_w = 224, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4595, .adv_w = 224, .box_w = 9, .box_h = 10, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4607, .adv_w = 224, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4623, .adv_w = 224, .box_w = 10, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4638, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4652, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4666, .adv_w = 224, .box_w = 10, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4680, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4698, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4715, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4735, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4753, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4773, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4790, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4807, .adv_w = 224, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4822, .adv_w = 224, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4838, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4855, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4875, .adv_w = 224, .box_w = 10, .box_h = 9, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4887, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4904, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4926, .adv_w = 224, .box_w = 8, .box_h = 11, .ofs_x = 4, .ofs_y = 0},
    {.bitmap_index = 4937, .adv_w = 224, .box_w = 9, .box_h = 11, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 4950, .adv_w = 224, .box_w = 11, .box_h = 8, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 4961, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 4978, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4995, .adv_w = 224, .box_w = 10, .box_h = 10, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5008, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5026, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5044, .adv_w = 224, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5059, .adv_w = 224, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5074, .adv_w = 224, .box_w = 9, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5087, .adv_w = 224, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5104, .adv_w = 224, .box_w = 11, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5120, .adv_w = 224, .box_w = 10, .box_h = 10, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 5133, .adv_w = 224, .box_w = 10, .box_h = 7, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5142, .adv_w = 224, .box_w = 9, .box_h = 9, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 5153, .adv_w = 224, .box_w = 10, .box_h = 11, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 5167, .adv_w = 224, .box_w = 7, .box_h = 11, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 5177, .adv_w = 224, .box_w = 13, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5194, .adv_w = 224, .box_w = 9, .box_h = 10, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 5206, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5220, .adv_w = 224, .box_w = 10, .box_h = 10, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5233, .adv_w = 224, .box_w = 11, .box_h = 10, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5247, .adv_w = 224, .box_w = 11, .box_h = 1, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 5249, .adv_w = 224, .box_w = 13, .box_h = 1, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 5251, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5269, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5287, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5307, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5325, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5347, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5367, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5390, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5412, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5435, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5457, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5477, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5499, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5519, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5539, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5559, .adv_w = 224, .box_w = 11, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 5577, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5597, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5617, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5637, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5657, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5679, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5699, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5719, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5741, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5761, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5781, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5801, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5821, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5843, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5863, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5885, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5903, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5923, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 5943, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5966, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5987, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6007, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6029, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6049, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6069, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6091, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6113, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6133, .adv_w = 224, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6156, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6179, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6201, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6221, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6244, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6262, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6284, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6306, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6326, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6346, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6364, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6387, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6408, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6426, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6448, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6468, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6488, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6510, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6533, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6553, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6575, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6597, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6617, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6640, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6662, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6684, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6706, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6728, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6750, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6773, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6795, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6817, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6839, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6861, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6883, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6906, .adv_w = 224, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6929, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 6951, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6971, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6993, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7016, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7036, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7058, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7078, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7098, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7118, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7139, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7162, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7184, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7207, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7230, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7250, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7272, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7294, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7316, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7338, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7356, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7378, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7400, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7422, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7444, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7464, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7486, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7508, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7531, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7551, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7574, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7597, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7617, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7639, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7661, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7683, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7705, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7727, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7747, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7767, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7787, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7807, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7829, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7849, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7872, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7892, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7912, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7935, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7957, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7979, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 7999, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8019, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8041, .adv_w = 224, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 8064, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8087, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8109, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8129, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8151, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8173, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8195, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8218, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8240, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8262, .adv_w = 224, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8279, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8301, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8323, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8343, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8363, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8383, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8404, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8426, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8448, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8470, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8492, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8514, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8534, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8556, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8578, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8600, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8622, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8644, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8666, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8687, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8709, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8731, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8753, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8773, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8795, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8817, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8839, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8861, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8883, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8905, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8925, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8948, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8968, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8988, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9008, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9028, .adv_w = 224, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9049, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9071, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9094, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9116, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9134, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9156, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9176, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9198, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9220, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9240, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9260, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9280, .adv_w = 224, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9300, .adv_w = 224, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9318, .adv_w = 224, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9336, .adv_w = 224, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9354, .adv_w = 224, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9377, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9399, .adv_w = 224, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9419, .adv_w = 224, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9441, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9461, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9481, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9501, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9519, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9536, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9553, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9571, .adv_w = 206, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 9584, .adv_w = 206, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9602, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 9622, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9639, .adv_w = 206, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 9652, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9669, .adv_w = 206, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 9682, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9702, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9719, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 9736, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9753, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9770, .adv_w = 206, .box_w = 9, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 9785, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9803, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9821, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9839, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9855, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9872, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9889, .adv_w = 206, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 9902, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9919, .adv_w = 206, .box_w = 9, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 9934, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9951, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 9968, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9984, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10001, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10018, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10035, .adv_w = 206, .box_w = 9, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 10050, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10068, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10084, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10102, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10120, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10137, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10153, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10170, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10187, .adv_w = 206, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10202, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10222, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10242, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10262, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10282, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10302, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10319, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10337, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10355, .adv_w = 206, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10373, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10389, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10406, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10423, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10440, .adv_w = 206, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 10454, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10471, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10489, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10506, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10526, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10543, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10561, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10579, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10597, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10613, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10633, .adv_w = 206, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10649, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10666, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10683, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10701, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10718, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10735, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10752, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10769, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10786, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10803, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10823, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10841, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10858, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10876, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10893, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10910, .adv_w = 206, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10927, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 10945, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10962, .adv_w = 206, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 10983, .adv_w = 206, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 10997, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11015, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11033, .adv_w = 206, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11050, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11070, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11088, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11106, .adv_w = 206, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 11119, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11137, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11155, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11173, .adv_w = 206, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 11187, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11207, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11225, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11243, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11263, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11283, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11303, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11323, .adv_w = 206, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 11345, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11365, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11385, .adv_w = 206, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11405, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11423, .adv_w = 206, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 11441, .adv_w = 224, .box_w = 1, .box_h = 10, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 11443, .adv_w = 224, .box_w = 3, .box_h = 5, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 11445, .adv_w = 224, .box_w = 2, .box_h = 9, .ofs_x = 2, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe,
    0x16, 0x18, 0x1c, 0x2e, 0x3b, 0x3e, 0x3f, 0x4e,
    0x56, 0x58, 0x5b, 0x5c, 0x5e, 0x62, 0x6c, 0x77,
    0x79, 0x7b, 0xad, 0x116, 0x118, 0x285, 0x28e, 0x28f,
    0x290, 0x292, 0x294, 0x298, 0x299, 0x29a, 0x29c, 0x29d,
    0x2a0, 0x2a1, 0x2a3, 0x2a4, 0x2a9, 0x2aa, 0x2ab, 0x2ac
};

static const uint16_t unicode_list_4[] = {
    0x0, 0x1, 0x2, 0x3a, 0x3c, 0x44, 0x45, 0x46,
    0x47, 0x4b, 0x4c, 0x4e, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x5b
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0x1be, 0x1d4, 0x1d5
};

static const uint16_t unicode_list_9[] = {
    0x0, 0x2f, 0x49, 0x5a, 0x60, 0x7d, 0x2b2, 0x2b3,
    0x2b4, 0x2b6, 0x2b7, 0x2b8, 0x2ba, 0x2c0, 0x2c6, 0x2c7,
    0x2c8, 0x2cb, 0x2cd, 0x2d0, 0x2d2, 0x2d4, 0x2d5, 0x2d6,
    0x2d7, 0x2d8, 0x2d9, 0x2db, 0x2dc, 0x2dd, 0x2de, 0x2df,
    0x2e0, 0x2e1, 0x2e3, 0x2e6, 0x2e7, 0x2e8, 0x2e9, 0x2ea,
    0x2ed, 0x2ef, 0x2f0, 0x2f1, 0x2f2, 0x2f3, 0x2f4, 0x2f8,
    0x2f9, 0x2fa, 0x2fc, 0x2fe, 0x7b2, 0x7b3, 0x7b5, 0x7b8,
    0x7b9, 0x7ba, 0x7bb, 0x7bc, 0x7c4, 0x7c5, 0x7c6, 0x7c7,
    0x7c8, 0x7ca, 0x7cb, 0x7cc, 0x7cd, 0x7cf, 0x7d0, 0x7d1,
    0x7d2, 0x7d3, 0x7d4, 0x7d6, 0x7d8, 0x7db, 0x7dc, 0x7de,
    0x7df, 0x7e1, 0x7e2, 0x7e3, 0x7e4, 0x7e5, 0x7e6, 0x7e7,
    0x7e8, 0x7e9, 0x7ea, 0x7f1, 0x7f2, 0x7f3, 0x7f4, 0x7f5,
    0x7f8, 0x7f9, 0x7fa, 0x7fd, 0x1852, 0x1854, 0x1856, 0x1858,
    0x185e, 0x1860, 0x186c, 0x186e, 0x1870, 0x1874, 0x1878, 0x187c,
    0x1882, 0x1884, 0x1888, 0x188a, 0x188c, 0x188e, 0x1890, 0x1894,
    0x1896, 0x1898, 0x189e, 0x19bd, 0x29b2, 0x29b3, 0x29f5, 0x29f7,
    0x29f9, 0x29fb, 0x29fc, 0x29fd, 0x29fe, 0x2a00, 0x2a04, 0x2a06,
    0x2a08, 0x2a0a, 0x2a0c, 0x2a10, 0x2a11, 0x2a12, 0x2a14, 0x2a15,
    0x2a17, 0x2a18, 0x2a1b, 0x2a1c, 0x2a1f, 0x2a20, 0x2a2f, 0x2a30,
    0x2a33, 0x2a3b, 0x2a3d, 0x2a43, 0x2a44, 0x2a53, 0x2a54, 0x2a55,
    0x2a57, 0x2a59, 0x2a5a, 0x2a5c, 0x2a5e, 0x2a60, 0x2a61, 0x2a66,
    0x2a67, 0x2a68, 0x2a69, 0x2a6a, 0x2a6c, 0x2a70, 0x2a71, 0x2a74,
    0x2a77, 0x2a78, 0x2a79, 0x2a7a, 0x2a7c, 0x2a7e, 0x2a81, 0x2a86,
    0x2a87, 0x2a88, 0x2a8a, 0x2a8f, 0x2a90, 0x2a91, 0x2a93, 0x2a94,
    0x2a96, 0x2a98, 0x2a9a, 0x2a9b, 0x2a9c, 0x2a9d, 0x2a9e, 0x2aa0,
    0x2aa4, 0x2aad, 0x47b1, 0x47bc, 0x47be, 0x47de, 0x4837, 0x48eb,
    0x48ff, 0x4911, 0x4992, 0x49ca, 0x4a4a, 0x4af6, 0x4af9, 0x4b16,
    0x4b24, 0x4b3e, 0x4bab, 0x4bb8, 0x4bce, 0x4bda, 0x4be1, 0x4c51,
    0x4c52, 0x4c6a, 0x4c8a, 0x4cc7, 0x4cf8, 0x4d12, 0x4d7c, 0x4d82,
    0x4da0, 0x4dbf, 0x4ddd, 0x4de0, 0x4dfb, 0x4e2e, 0x4e7e, 0x4f00,
    0x4f10, 0x5019, 0x50d9, 0x51e2, 0x52b8, 0x52d8, 0x52e2, 0x532e,
    0x537c, 0x553d, 0x554b, 0x55ac, 0x55b7, 0x55b8, 0x55bc, 0x55c2,
    0x57a3, 0x5845, 0x5857, 0x58b1, 0x58c0, 0x5906, 0x5936, 0x593d,
    0x598d, 0x59b2, 0x5a20, 0x5a76, 0x5afc, 0x5b7a, 0x5bc2, 0x5bfc,
    0x5c1c, 0x5c2f, 0x5cf0, 0x5d13, 0x5d34, 0x5d53, 0x5d56, 0x5d80,
    0x5d83, 0x5d8c, 0x5f08, 0x5f61, 0x5f91, 0x5fa7, 0x5ff3, 0x60a5,
    0x60b0, 0x60b1, 0x60ba, 0x60bc, 0x60be, 0x60d0, 0x60dd, 0x60eb,
    0x6196, 0x6271, 0x62cd, 0x63d2, 0x6410, 0x6453, 0x6514, 0x6686,
    0x66ec, 0x66f2, 0x66fc, 0x6700, 0x67dd, 0x6831, 0x6841, 0x6892,
    0x68b0, 0x6971, 0x69c0, 0x6a6a, 0x6a9e, 0x6ad2, 0x6bf9, 0x6c67,
    0x6c71, 0x6d61, 0x6daf, 0x6ed9, 0x6ee6, 0x702c, 0x702d, 0x7035,
    0x726b, 0x7383, 0x73be, 0x74fa, 0x7505, 0x76ac, 0x76cb, 0x76f3,
    0x76f5, 0x7712, 0x7722, 0x774b, 0x7763, 0x7858, 0x7875, 0x788d,
    0x7890, 0x7902, 0x79f7, 0x7a2e, 0x7aae, 0x81fd, 0x833c, 0x836e,
    0x8379, 0x83bb, 0x83db, 0x83de, 0x8417, 0x8422, 0x843e, 0x8455,
    0x845b, 0x845e, 0x847c, 0x8517, 0x856f, 0x8570, 0x8586, 0x858e,
    0x85a0, 0x85a5, 0x85a8, 0x8678, 0x86d6, 0x86f5, 0x8736, 0x8764,
    0x87a0, 0x88ba, 0x892e, 0x896d, 0x898c, 0x898f, 0x89b2, 0x89d4,
    0x8a05, 0x8afe, 0x8b7e, 0x8b80, 0x8ce0, 0x8eca, 0x8f3a, 0x8f3c,
    0x8f44, 0x8f8d, 0x8f9e, 0x8f9f, 0x90ac, 0x910a, 0x910d, 0x91a4,
    0x91b0, 0xa5b1, 0xa5b5, 0xa5c1, 0xa621, 0xa65d, 0xa661, 0xa66e,
    0xa691, 0xa6a6, 0xa6ad, 0xa71d, 0xa7a9, 0xa7e1, 0xa9f5, 0xaa49,
    0xaad5, 0xab06, 0xac45, 0xac56, 0xac79, 0xac95, 0xaca6, 0xacb1,
    0xad75, 0xadd9, 0xae79, 0xae8d, 0xae94, 0xaeda, 0xb1b9, 0xb1d5,
    0xb20d, 0xb309, 0xb319, 0xb32d, 0xb35d, 0xb381, 0xb459, 0xb5cd,
    0xb5e1, 0xb635, 0xb6a5, 0xb6ad, 0xb731, 0xb7f5, 0xba5d, 0xba6e,
    0xba72, 0xba79, 0xbacd, 0xbad5, 0xbae2, 0xbae9, 0xbafc, 0xbb3d,
    0xbb3e, 0xbb52, 0xbbc9, 0xbc55, 0xbc66, 0xbc8d, 0xbc95, 0xbef9,
    0xbf76, 0xbf77, 0xbf81, 0xbfa1, 0xbfd5, 0xbff5, 0xc045, 0xc05a,
    0xc065, 0xc07d, 0xc0f5, 0xc0fd, 0xc102, 0xc125, 0xc129, 0xc136,
    0xc151, 0xc1b5, 0xc1c2, 0xc1c6, 0xc222, 0xc2ad, 0xc2c2, 0xc371,
    0xc375, 0xc5ef, 0xc6b9, 0xc70d, 0xc75a, 0xc80d, 0xc825, 0xc845,
    0xc8cd, 0xca1d, 0xca8d, 0xcae1, 0xcb0d, 0xcc69, 0xccd0, 0xccd9,
    0xcf09, 0xcf0d, 0xcf11, 0xcf1a, 0xcf1c, 0xcf39, 0xd005, 0xd006,
    0xd009, 0xd00d, 0xd075, 0xf8b2, 0xf8bd, 0xf8cb
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 161, .range_length = 95, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 259, .range_length = 685, .glyph_id_start = 191,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 48, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 945, .range_length = 25, .glyph_id_start = 239,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 972, .range_length = 92, .glyph_id_start = 264,
        .unicode_list = unicode_list_4, .glyph_id_ofs_list = NULL, .list_length = 21, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1072, .range_length = 29, .glyph_id_start = 285,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1102, .range_length = 470, .glyph_id_start = 314,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 12, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1573, .range_length = 22, .glyph_id_start = 326,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1600, .range_length = 12, .glyph_id_start = 348,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1615, .range_length = 63692, .glyph_id_start = 360,
        .unicode_list = unicode_list_9, .glyph_id_ofs_list = NULL, .list_length = 518, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    3, 0, 4, 5, 6, 7, 8, 0,
    9, 10, 0, 11, 12, 0, 13, 14,
    15, 16, 0, 17, 18, 19, 20, 21,
    22, 23, 24, 0, 25, 26, 0, 27,
    28, 0, 29, 30, 31, 32, 33, 34,
    35, 36, 37, 38, 0, 39, 40, 41,
    42, 43, 44, 45, 0, 0, 46, 47,
    48, 49, 50, 51, 0, 52, 0, 53,
    54, 0, 55, 56, 57, 58, 0, 59,
    60, 61, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 2, 3, 4,
    0, 5, 0, 6, 7, 8, 6, 6,
    0, 9, 10, 11, 11, 0, 12, 13,
    14, 15, 0, 0, 16, 17, 18, 19,
    20, 0, 0, 21, 0, 22, 23, 24,
    0, 25, 0, 26, 0, 27, 28, 29,
    30, 31, 31, 32, 33, 34, 34, 0,
    35, 0, 36, 36, 33, 37, 38, 39,
    39, 40, 41, 42, 33, 43, 0, 44,
    45, 0, 46, 0, 47, 48, 0, 0,
    49, 50, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 51, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -13, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -22, 0, 0,
    0, 0, 0, 0, -7, -7, 0, 0,
    0, 0, -7, -11, -7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -4, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -9, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -13, -4, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -13, -16,
    -11, 0, -4, 0, 0, 0, 0, 0,
    0, 0, -9, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -7, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -7,
    -7, 0, 0, 0, 9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -7, -4, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    -16, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -11,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, -13, -7, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -18, -22, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -9, 0,
    2, 2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, -7, -7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -11, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -11, 0, 7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -9,
    -9, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -11, -11, -7, 0, 0, -7, 0,
    -7, -7, 0, 0, 0, -13, -4, 0,
    0, 0, -4, -11, 0, -11, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -16, -9, -9, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -9,
    -7, 0, 0, 0, 0, -4, 0, -4,
    2, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -11, 0, 0, 0, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -9, -9, 0, 0, 0, 0, 0,
    0, 0, -7, 0, -9, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -11, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -9, -7,
    0, -4, -7, 0, 0, 0, 0, 0,
    0, 0, 0, -9, -9, -9, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -9, -9, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -16, 2, 2, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, -7, -7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, -11, -11, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -22, -22, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -11, 0, 0, -11, -11, 0,
    0, -9, 0, -4, 0, 0, 0, 0,
    -9, 0, 0, -4, 0, -16, 0, 0,
    0, -2, 0, -9, -13, -22, -4, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -2, 0,
    -4, -4, 0, 0, 0, -7, 0, -9,
    -4, 0, 0, -4, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, -7, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -11, -11, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -11, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -7, -9, -9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, 0, -7, -20, -18, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -9,
    -9, 0, 0, 0, -7, 0, -9, 0,
    0, 0, -11, 0, 0, 0, 0, -18,
    0, 0, 0, -7, 0, 0, 0, -20,
    -16, -18, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    0, 0, -16, -20, -20, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    -9, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, -16, -18, -16,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    -13, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -7, -7, -7, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, -13, 0, 0, 0, 0, 0, -11,
    -16, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -16,
    -7, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -7, -7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -11, -11, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -11,
    -2, -2, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -11, -7, -7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, 0,
    0, 0, 0, 0, 0, -9, -7, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -16, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    -11, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -7, -9, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 7, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 11,
    0, 2, -9, -9, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -7, 0, 0, 0,
    0, 0, 4, 0, -4, -7, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -7, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -11,
    -7, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -7, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -4, 0, 0, 0,
    0, 0, -11, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -11, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    -13, 0, 0, 0, 0, 0, -11, 0,
    0, 0, 0, 0, -4, -4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, -4, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, -4, 0, 0, 0, 0, 0, -2,
    0, 0, 0, 0, -7, 0, 0, 0,
    0, 0, 0, 0, -11, -13, -9, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -7, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -4, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -4, 0, 0,
    0, 0, 0, 0, 0, 0, -13, -13,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -7, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -11, -13, -13, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -4, 0, 0, 0, 0, -4, 0, -7,
    -7, 0, 0, -4, 0, 0, 0, 0,
    0, 0, 0, -11, -2, -2, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, -13, 0, 0, 0, 0, 0,
    0, -9, -9, 0, 0, 0, 0, 0,
    -4, -4, -4, -11, 0, 0, 0, 0,
    0, -2, -13, -13, 0, 0, -7, 0,
    0, 0, 0, 0, -11, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 61,
    .right_class_cnt     = 51,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 10,
    .bpp = 1,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t font_noto_basic_14_1 = {
#else
lv_font_t font_noto_basic_14_1 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 20,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .fallback = NULL,
    .user_data = NULL
};



#endif /*#if FONT_NOTO_BASIC_14_1*/

