/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: --force-fast-kern-format --no-compress --no-prefilter --font ttf/noto-basic.ttf --format lvgl --lv-include lvgl.h --bpp 4 -o src/font_noto_basic_16_4.c --size 16 -r 0x0-0xfffff
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef FONT_NOTO_BASIC_16_4
#define FONT_NOTO_BASIC_16_4 1
#endif

#if FONT_NOTO_BASIC_16_4

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xaf, 0xa, 0xf0, 0x9e, 0x8, 0xd0, 0x7c, 0x7,
    0xc0, 0x6b, 0x5, 0xa0, 0x24, 0x1, 0x20, 0xcf,
    0x1a, 0xe0,

    /* U+0022 "\"" */
    0xe8, 0xf, 0x7d, 0x70, 0xe6, 0xc5, 0xd, 0x4b,
    0x40, 0xc3, 0x21, 0x2, 0x0,

    /* U+0023 "#" */
    0x0, 0x1, 0xf0, 0xa, 0x70, 0x0, 0x4, 0xe0,
    0xd, 0x40, 0x0, 0x6, 0xb0, 0xf, 0x20, 0x0,
    0x9, 0x90, 0x2f, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xfe, 0x2, 0x2f, 0x42, 0xaa, 0x22, 0x0, 0x3e,
    0x0, 0xd5, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xf5,
    0x12, 0xb8, 0x25, 0xe2, 0x20, 0x0, 0xc5, 0x6,
    0xb0, 0x0, 0x0, 0xf2, 0x8, 0x90, 0x0, 0x1,
    0xf0, 0xb, 0x60, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0xf1, 0x0, 0x0, 0x0, 0xf, 0x10,
    0x0, 0x2, 0xbf, 0xff, 0xe8, 0x0, 0xdc, 0x4f,
    0x46, 0x50, 0xf, 0x60, 0xf1, 0x0, 0x0, 0xbe,
    0x6f, 0x10, 0x0, 0x0, 0x8e, 0xfc, 0x70, 0x0,
    0x0, 0xf, 0x8d, 0xd0, 0x0, 0x0, 0xf1, 0x3f,
    0x30, 0x73, 0x1f, 0x49, 0xf1, 0xe, 0xff, 0xff,
    0xd4, 0x0, 0x1, 0x3f, 0x20, 0x0, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,

    /* U+0025 "%" */
    0x4, 0xef, 0x70, 0x0, 0x1f, 0x20, 0x0, 0xe6,
    0x2f, 0x20, 0x9, 0xa0, 0x0, 0x2f, 0x0, 0xb6,
    0x2, 0xf2, 0x0, 0x3, 0xf0, 0xa, 0x80, 0xa9,
    0x0, 0x0, 0x2f, 0x0, 0xb7, 0x2f, 0x10, 0x0,
    0x0, 0xe5, 0x1f, 0x3b, 0x84, 0xdd, 0x60, 0x5,
    0xff, 0x93, 0xe1, 0xe6, 0x3f, 0x20, 0x0, 0x10,
    0xc7, 0x2f, 0x0, 0xb6, 0x0, 0x0, 0x4e, 0x3,
    0xf0, 0xa, 0x80, 0x0, 0xd, 0x60, 0x2f, 0x0,
    0xb7, 0x0, 0x5, 0xd0, 0x0, 0xe4, 0x1f, 0x30,
    0x0, 0xd5, 0x0, 0x4, 0xde, 0x80,

    /* U+0026 "&" */
    0x0, 0x2c, 0xff, 0x90, 0x0, 0x0, 0x0, 0xdc,
    0x36, 0xf6, 0x0, 0x0, 0x0, 0xf5, 0x0, 0xc9,
    0x0, 0x0, 0x0, 0xe8, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x6f, 0x6d, 0xc0, 0x0, 0x0, 0x0, 0x1e,
    0xfb, 0x0, 0x0, 0x0, 0x3, 0xec, 0xbf, 0x30,
    0x8, 0xc0, 0xd, 0xc0, 0xb, 0xf3, 0xd, 0x80,
    0x2f, 0x50, 0x0, 0xbf, 0x9f, 0x20, 0x1f, 0x60,
    0x0, 0xc, 0xf8, 0x0, 0xb, 0xe5, 0x23, 0x9f,
    0xdf, 0x30, 0x0, 0x9e, 0xfe, 0xa3, 0xb, 0xf3,

    /* U+0027 "'" */
    0xe8, 0xd7, 0xc5, 0xb4, 0x21,

    /* U+0028 "(" */
    0x0, 0x6e, 0x10, 0x1e, 0x60, 0x7, 0xf0, 0x0,
    0xd9, 0x0, 0x1f, 0x50, 0x3, 0xf3, 0x0, 0x5f,
    0x10, 0x5, 0xf1, 0x0, 0x4f, 0x20, 0x2, 0xf4,
    0x0, 0xf, 0x70, 0x0, 0xac, 0x0, 0x4, 0xf3,
    0x0, 0xb, 0xb0, 0x0, 0x18, 0x10,

    /* U+0029 ")" */
    0x3f, 0x30, 0x0, 0x9c, 0x0, 0x2, 0xf4, 0x0,
    0xd, 0x90, 0x0, 0x9d, 0x0, 0x6, 0xf0, 0x0,
    0x4f, 0x10, 0x4, 0xf2, 0x0, 0x5f, 0x10, 0x7,
    0xf0, 0x0, 0xbc, 0x0, 0xf, 0x70, 0x6, 0xf1,
    0x0, 0xd8, 0x0, 0x27, 0x0, 0x0,

    /* U+002A "*" */
    0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x4f, 0x0,
    0x0, 0x28, 0x32, 0xe0, 0x59, 0x3, 0xdf, 0xff,
    0xff, 0xd0, 0x0, 0xc, 0xe8, 0x0, 0x0, 0x7,
    0xe3, 0xf4, 0x0, 0x1, 0xf8, 0xb, 0xd0, 0x0,
    0x1, 0x10, 0x20, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0xf2, 0x0, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0x0, 0xf2, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xf4, 0x2, 0x22, 0xf4, 0x22, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x0,

    /* U+002C "," */
    0x0, 0x0, 0xa, 0xf0, 0xc, 0xa0, 0xf, 0x40,
    0x3e, 0x0,

    /* U+002D "-" */
    0x0, 0x0, 0x5, 0xff, 0xf8, 0x13, 0x33, 0x10,

    /* U+002E "." */
    0x12, 0xc, 0xf1, 0xae, 0x0,

    /* U+002F "/" */
    0x0, 0x0, 0xc9, 0x0, 0x1, 0xf4, 0x0, 0x7,
    0xe0, 0x0, 0xd, 0x80, 0x0, 0x2f, 0x30, 0x0,
    0x8d, 0x0, 0x0, 0xe7, 0x0, 0x3, 0xf2, 0x0,
    0x9, 0xc0, 0x0, 0xe, 0x60, 0x0, 0x4f, 0x10,
    0x0, 0xab, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x5d, 0xfd, 0x60, 0x0, 0x4f, 0x94, 0x7f,
    0x50, 0xc, 0xb0, 0x0, 0x9d, 0x0, 0xf6, 0x0,
    0x4, 0xf2, 0x2f, 0x40, 0x0, 0x2f, 0x43, 0xf3,
    0x0, 0x1, 0xf5, 0x3f, 0x30, 0x0, 0x1f, 0x52,
    0xf4, 0x0, 0x2, 0xf4, 0xf, 0x60, 0x0, 0x4f,
    0x20, 0xbb, 0x0, 0x9, 0xe0, 0x3, 0xf9, 0x47,
    0xf6, 0x0, 0x4, 0xdf, 0xe7, 0x0,

    /* U+0031 "1" */
    0x0, 0x3e, 0xb0, 0x5f, 0xeb, 0x5f, 0x5a, 0xb0,
    0x30, 0xbb, 0x0, 0xb, 0xb0, 0x0, 0xbb, 0x0,
    0xb, 0xb0, 0x0, 0xbb, 0x0, 0xb, 0xb0, 0x0,
    0xbb, 0x0, 0xb, 0xb0, 0x0, 0xbb,

    /* U+0032 "2" */
    0x1, 0x9e, 0xfd, 0x70, 0x0, 0xdc, 0x54, 0x8f,
    0x60, 0x2, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x0, 0x3f, 0x70, 0x0,
    0x0, 0x2e, 0x90, 0x0, 0x0, 0x2e, 0xa0, 0x0,
    0x0, 0x1e, 0xa0, 0x0, 0x0, 0x1d, 0xe6, 0x55,
    0x55, 0x13, 0xff, 0xff, 0xff, 0xf5,

    /* U+0033 "3" */
    0x3, 0xbe, 0xfe, 0x80, 0x0, 0xe9, 0x43, 0x7f,
    0x80, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x17, 0xf4, 0x0, 0x8,
    0xff, 0xe5, 0x0, 0x0, 0x13, 0x48, 0xf8, 0x0,
    0x0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x4f,
    0x30, 0x0, 0x0, 0x8, 0xf1, 0x4b, 0x64, 0x48,
    0xf9, 0x1, 0xae, 0xff, 0xd7, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x4, 0xef,
    0x20, 0x0, 0x1, 0xe8, 0xf2, 0x0, 0x0, 0xab,
    0x2f, 0x20, 0x0, 0x4f, 0x13, 0xf2, 0x0, 0x1e,
    0x50, 0x3f, 0x20, 0xa, 0xb0, 0x3, 0xf2, 0x5,
    0xf2, 0x0, 0x3f, 0x30, 0xaf, 0xff, 0xff, 0xff,
    0xd2, 0x33, 0x33, 0x6f, 0x53, 0x0, 0x0, 0x3,
    0xf2, 0x0, 0x0, 0x0, 0x3f, 0x20,

    /* U+0035 "5" */
    0x5f, 0xff, 0xff, 0x70, 0x6e, 0x55, 0x55, 0x20,
    0x7d, 0x0, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x0,
    0x9a, 0x0, 0x0, 0x0, 0xaf, 0xff, 0xe9, 0x0,
    0x25, 0x33, 0x7f, 0xb0, 0x0, 0x0, 0x6, 0xf2,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x7, 0xf1,
    0xb6, 0x44, 0x8f, 0x80, 0x9d, 0xff, 0xc6, 0x0,

    /* U+0036 "6" */
    0x0, 0x6, 0xcf, 0xf7, 0x0, 0x9, 0xe7, 0x33,
    0x20, 0x4, 0xf2, 0x0, 0x0, 0x0, 0xaa, 0x0,
    0x0, 0x0, 0xe, 0x79, 0xee, 0xa1, 0x0, 0xfe,
    0x83, 0x4d, 0xc0, 0x1f, 0x90, 0x0, 0x3f, 0x31,
    0xf5, 0x0, 0x0, 0xf6, 0xf, 0x60, 0x0, 0xf,
    0x50, 0xac, 0x0, 0x4, 0xf2, 0x2, 0xfa, 0x46,
    0xea, 0x0, 0x3, 0xcf, 0xe9, 0x0,

    /* U+0037 "7" */
    0x4f, 0xff, 0xff, 0xff, 0x61, 0x55, 0x55, 0x58,
    0xf3, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x0, 0x8, 0xe0, 0x0, 0x0,
    0x0, 0xe8, 0x0, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0x4, 0xf3, 0x0,
    0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x2f, 0x50,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x7e, 0xfe, 0x90, 0x0, 0x8f, 0x63, 0x5e,
    0xa0, 0xd, 0x90, 0x0, 0x7f, 0x0, 0xca, 0x0,
    0x8, 0xe0, 0x4, 0xf8, 0x6, 0xf5, 0x0, 0x5,
    0xff, 0xf4, 0x0, 0x2, 0xdc, 0x7d, 0xe3, 0x0,
    0xda, 0x0, 0xa, 0xe1, 0x3f, 0x30, 0x0, 0x1f,
    0x52, 0xf4, 0x0, 0x2, 0xf4, 0xc, 0xd5, 0x24,
    0xdd, 0x0, 0x19, 0xef, 0xe9, 0x10,

    /* U+0039 "9" */
    0x0, 0x8e, 0xfd, 0x50, 0x0, 0x9f, 0x63, 0x7f,
    0x50, 0xf, 0x60, 0x0, 0x8e, 0x3, 0xf3, 0x0,
    0x2, 0xf2, 0x2f, 0x40, 0x0, 0x3f, 0x40, 0xdc,
    0x10, 0x3c, 0xf4, 0x2, 0xcf, 0xfd, 0x6f, 0x30,
    0x0, 0x12, 0x4, 0xf1, 0x0, 0x0, 0x0, 0x9d,
    0x0, 0x0, 0x0, 0x2f, 0x70, 0x2, 0x33, 0x7e,
    0xc0, 0x0, 0x5f, 0xfd, 0x70, 0x0,

    /* U+003A ":" */
    0xae, 0xc, 0xf1, 0x12, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x12, 0xc, 0xf1, 0xae, 0x0,

    /* U+003B ";" */
    0xa, 0xd0, 0xc, 0xf0, 0x1, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd0,
    0xf, 0x80, 0x2f, 0x20, 0x6c, 0x0, 0x0, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x95, 0x0, 0x0, 0x19, 0xfa, 0x10, 0x1, 0x8f,
    0xa2, 0x0, 0x8, 0xe9, 0x20, 0x0, 0x2, 0xfc,
    0x40, 0x0, 0x0, 0x0, 0x7e, 0xd6, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0x91, 0x0, 0x0, 0x0, 0x4b,
    0x50, 0x0, 0x0, 0x0, 0x0,

    /* U+003D "=" */
    0x1f, 0xff, 0xff, 0xff, 0x30, 0x22, 0x22, 0x22,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xf3, 0x2, 0x22, 0x22, 0x22, 0x0,

    /* U+003E ">" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xa2, 0x0, 0x0,
    0x0, 0x19, 0xfa, 0x20, 0x0, 0x0, 0x1, 0x9f,
    0x92, 0x0, 0x0, 0x0, 0x19, 0xf9, 0x10, 0x0,
    0x0, 0x3b, 0xf4, 0x0, 0x5, 0xce, 0x81, 0x0,
    0x8e, 0xd6, 0x0, 0x0, 0x3c, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x4b, 0xef, 0xd5, 0x7, 0x95, 0x49, 0xf3, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x8e, 0x10, 0x0, 0x9e, 0x30, 0x0, 0x6e, 0x20,
    0x0, 0xb, 0x70, 0x0, 0x0, 0x52, 0x0, 0x0,
    0x2, 0x10, 0x0, 0x1, 0xfc, 0x0, 0x0, 0xe,
    0xa0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x4a, 0xef, 0xfc, 0x50, 0x0, 0x0,
    0xa, 0xe7, 0x31, 0x26, 0xdb, 0x0, 0x0, 0xac,
    0x10, 0x0, 0x0, 0x1c, 0x80, 0x4, 0xe1, 0x4,
    0xdf, 0xeb, 0x2, 0xf1, 0xa, 0x80, 0x3f, 0x51,
    0x6e, 0x0, 0xd4, 0xe, 0x30, 0xaa, 0x0, 0x5e,
    0x0, 0xa6, 0xf, 0x10, 0xd6, 0x0, 0x6d, 0x0,
    0xb6, 0xf, 0x10, 0xd6, 0x0, 0x8c, 0x0, 0xd4,
    0xf, 0x30, 0x9c, 0x1, 0xde, 0x4, 0xe0, 0xb,
    0x80, 0x1c, 0xfe, 0x48, 0xfe, 0x30, 0x4, 0xf2,
    0x0, 0x10, 0x0, 0x10, 0x0, 0x0, 0x7f, 0x71,
    0x0, 0x15, 0x30, 0x0, 0x0, 0x4, 0xcf, 0xff,
    0xfc, 0x30, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf5, 0x0, 0x0, 0x0, 0x7, 0xda, 0xb0, 0x0,
    0x0, 0x0, 0xd8, 0x5f, 0x10, 0x0, 0x0, 0x3f,
    0x20, 0xe6, 0x0, 0x0, 0x9, 0xd0, 0x9, 0xc0,
    0x0, 0x0, 0xe8, 0x11, 0x4f, 0x20, 0x0, 0x5f,
    0xff, 0xff, 0xf8, 0x0, 0xb, 0xc4, 0x44, 0x4a,
    0xe0, 0x1, 0xf5, 0x0, 0x0, 0x3f, 0x40, 0x7f,
    0x0, 0x0, 0x0, 0xda, 0xd, 0xa0, 0x0, 0x0,
    0x7, 0xf0,

    /* U+0042 "B" */
    0x7f, 0xff, 0xfd, 0x91, 0x7, 0xf4, 0x44, 0x7f,
    0xd0, 0x7f, 0x0, 0x0, 0x7f, 0x27, 0xf0, 0x0,
    0x6, 0xf1, 0x7f, 0x0, 0x3, 0xd9, 0x7, 0xff,
    0xff, 0xf9, 0x0, 0x7f, 0x33, 0x36, 0xdc, 0x7,
    0xf0, 0x0, 0x2, 0xf6, 0x7f, 0x0, 0x0, 0xf,
    0x87, 0xf0, 0x0, 0x3, 0xf6, 0x7f, 0x44, 0x46,
    0xee, 0x17, 0xff, 0xff, 0xea, 0x20,

    /* U+0043 "C" */
    0x0, 0x3, 0xbe, 0xfe, 0xb4, 0x0, 0x6f, 0xc6,
    0x56, 0xb3, 0x2, 0xfa, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xc6, 0x56, 0x92, 0x0,
    0x5, 0xcf, 0xfe, 0xb1,

    /* U+0044 "D" */
    0x7f, 0xff, 0xfd, 0x91, 0x0, 0x7f, 0x44, 0x58,
    0xee, 0x30, 0x7f, 0x0, 0x0, 0x1d, 0xe0, 0x7f,
    0x0, 0x0, 0x4, 0xf5, 0x7f, 0x0, 0x0, 0x0,
    0xf9, 0x7f, 0x0, 0x0, 0x0, 0xdb, 0x7f, 0x0,
    0x0, 0x0, 0xda, 0x7f, 0x0, 0x0, 0x0, 0xf8,
    0x7f, 0x0, 0x0, 0x4, 0xf4, 0x7f, 0x0, 0x0,
    0x1e, 0xd0, 0x7f, 0x44, 0x58, 0xfe, 0x20, 0x7f,
    0xff, 0xfc, 0x81, 0x0,

    /* U+0045 "E" */
    0x7f, 0xff, 0xff, 0xf7, 0xf4, 0x44, 0x44, 0x7f,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xfa, 0x7f, 0x33, 0x33,
    0x27, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x44, 0x44, 0x47, 0xff,
    0xff, 0xff,

    /* U+0046 "F" */
    0x7f, 0xff, 0xff, 0xf7, 0xf4, 0x44, 0x44, 0x7f,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xa7, 0xf3, 0x33, 0x32, 0x7f, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x2, 0x9d, 0xff, 0xd9, 0x10, 0x5, 0xfd,
    0x75, 0x58, 0xd0, 0x2, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x11,
    0x10, 0xf, 0x80, 0x0, 0x7f, 0xff, 0x70, 0xea,
    0x0, 0x1, 0x44, 0xf7, 0xa, 0xe0, 0x0, 0x0,
    0xf, 0x70, 0x3f, 0x90, 0x0, 0x0, 0xf7, 0x0,
    0x7f, 0xc7, 0x45, 0x7f, 0x70, 0x0, 0x4b, 0xef,
    0xfd, 0xa3,

    /* U+0048 "H" */
    0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f, 0x0, 0x0,
    0x2, 0xf4, 0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f,
    0x0, 0x0, 0x2, 0xf4, 0x7f, 0x11, 0x11, 0x13,
    0xf4, 0x7f, 0xff, 0xff, 0xff, 0xf4, 0x7f, 0x44,
    0x44, 0x45, 0xf4, 0x7f, 0x0, 0x0, 0x2, 0xf4,
    0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f, 0x0, 0x0,
    0x2, 0xf4, 0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f,
    0x0, 0x0, 0x2, 0xf4,

    /* U+0049 "I" */
    0x5f, 0xff, 0xb0, 0x1f, 0x80, 0x0, 0xf6, 0x0,
    0xf, 0x60, 0x0, 0xf6, 0x0, 0xf, 0x60, 0x0,
    0xf6, 0x0, 0xf, 0x60, 0x0, 0xf6, 0x0, 0xf,
    0x60, 0x1, 0xf7, 0x5, 0xff, 0xfb,

    /* U+004A "J" */
    0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0,
    0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0,
    0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0,
    0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x9,
    0xd0, 0x13, 0xea, 0x4f, 0xfd, 0x10, 0x32, 0x0,

    /* U+004B "K" */
    0x7f, 0x0, 0x0, 0x6f, 0x47, 0xf0, 0x0, 0x4f,
    0x60, 0x7f, 0x0, 0x2e, 0x90, 0x7, 0xf0, 0x1d,
    0xb0, 0x0, 0x7f, 0xc, 0xc0, 0x0, 0x7, 0xfa,
    0xf6, 0x0, 0x0, 0x7f, 0xdb, 0xf2, 0x0, 0x7,
    0xf0, 0x1e, 0xc0, 0x0, 0x7f, 0x0, 0x4f, 0x70,
    0x7, 0xf0, 0x0, 0x9f, 0x30, 0x7f, 0x0, 0x0,
    0xdd, 0x7, 0xf0, 0x0, 0x2, 0xf8,

    /* U+004C "L" */
    0x7f, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x55, 0x55, 0x47, 0xff,
    0xff, 0xff,

    /* U+004D "M" */
    0x7f, 0xd0, 0x0, 0x0, 0x5, 0xff, 0x7f, 0xf3,
    0x0, 0x0, 0xb, 0xef, 0x7d, 0xd9, 0x0, 0x0,
    0x1f, 0xaf, 0x7d, 0x8e, 0x0, 0x0, 0x6d, 0x7f,
    0x7d, 0x2f, 0x40, 0x0, 0xc7, 0x7f, 0x7e, 0xc,
    0xa0, 0x2, 0xf2, 0x7f, 0x7e, 0x6, 0xf0, 0x8,
    0xc0, 0x7f, 0x7e, 0x1, 0xf5, 0xe, 0x60, 0x7f,
    0x7e, 0x0, 0xab, 0x4f, 0x10, 0x7f, 0x7e, 0x0,
    0x5f, 0xbb, 0x0, 0x7f, 0x7e, 0x0, 0xe, 0xf5,
    0x0, 0x7f, 0x7e, 0x0, 0x9, 0xe0, 0x0, 0x7f,

    /* U+004E "N" */
    0x7f, 0x80, 0x0, 0x0, 0xb9, 0x7f, 0xf2, 0x0,
    0x0, 0xb9, 0x7d, 0xdc, 0x0, 0x0, 0xb9, 0x7d,
    0x4f, 0x60, 0x0, 0xb9, 0x7d, 0xa, 0xf1, 0x0,
    0xb9, 0x7e, 0x1, 0xfa, 0x0, 0xb9, 0x7e, 0x0,
    0x7f, 0x40, 0xb9, 0x7e, 0x0, 0xd, 0xd0, 0xb9,
    0x7e, 0x0, 0x3, 0xf8, 0xa9, 0x7e, 0x0, 0x0,
    0x9f, 0xd9, 0x7e, 0x0, 0x0, 0x1e, 0xf9, 0x7e,
    0x0, 0x0, 0x6, 0xf9,

    /* U+004F "O" */
    0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0, 0x0, 0x8f,
    0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f, 0xa5, 0x57,
    0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,

    /* U+0050 "P" */
    0x7f, 0xff, 0xfc, 0x50, 0x7f, 0x44, 0x5b, 0xf4,
    0x7f, 0x0, 0x0, 0xdb, 0x7f, 0x0, 0x0, 0xad,
    0x7f, 0x0, 0x0, 0xcb, 0x7f, 0x0, 0x29, 0xf5,
    0x7f, 0xff, 0xfe, 0x60, 0x7f, 0x33, 0x20, 0x0,
    0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,
    0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0, 0x0, 0x8f,
    0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f, 0xa5, 0x57,
    0xee, 0x10, 0x0, 0x5, 0xcf, 0xff, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xed, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x28, 0x50,

    /* U+0052 "R" */
    0x7f, 0xff, 0xfc, 0x50, 0x7, 0xf4, 0x45, 0xbf,
    0x50, 0x7f, 0x0, 0x0, 0xdb, 0x7, 0xf0, 0x0,
    0xa, 0xd0, 0x7f, 0x0, 0x0, 0xcb, 0x7, 0xf0,
    0x1, 0x8f, 0x40, 0x7f, 0xff, 0xfe, 0x40, 0x7,
    0xf3, 0x39, 0xe1, 0x0, 0x7f, 0x0, 0x1e, 0x90,
    0x7, 0xf0, 0x0, 0x6f, 0x30, 0x7f, 0x0, 0x0,
    0xdc, 0x7, 0xf0, 0x0, 0x4, 0xf6,

    /* U+0053 "S" */
    0x0, 0x8e, 0xff, 0xc5, 0x0, 0x9f, 0x85, 0x6a,
    0x60, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0xb, 0xe4, 0x0, 0x0, 0x0, 0x1b,
    0xfd, 0x60, 0x0, 0x0, 0x4, 0xaf, 0xd2, 0x0,
    0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0x8, 0xe0, 0x2b, 0x75, 0x59,
    0xf7, 0x1, 0xae, 0xff, 0xc6, 0x0,

    /* U+0054 "T" */
    0xdf, 0xff, 0xff, 0xff, 0xb4, 0x44, 0x7f, 0x64,
    0x43, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0, 0x4f,
    0x20, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x0, 0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0x20, 0x0,

    /* U+0055 "U" */
    0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0,
    0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e,
    0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3,
    0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0,
    0x0, 0x3, 0xf3, 0x8e, 0x0, 0x0, 0x3, 0xf3,
    0x7f, 0x0, 0x0, 0x4, 0xf2, 0x3f, 0x50, 0x0,
    0xa, 0xe0, 0xa, 0xf8, 0x55, 0xaf, 0x50, 0x0,
    0x8d, 0xff, 0xc4, 0x0,

    /* U+0056 "V" */
    0xda, 0x0, 0x0, 0x1, 0xf6, 0x7f, 0x0, 0x0,
    0x6, 0xf1, 0x2f, 0x50, 0x0, 0xc, 0xb0, 0xd,
    0xa0, 0x0, 0x1f, 0x60, 0x7, 0xf0, 0x0, 0x6f,
    0x10, 0x2, 0xf5, 0x0, 0xcb, 0x0, 0x0, 0xca,
    0x1, 0xf6, 0x0, 0x0, 0x7f, 0x6, 0xf1, 0x0,
    0x0, 0x1f, 0x5b, 0xb0, 0x0, 0x0, 0xc, 0xaf,
    0x50, 0x0, 0x0, 0x6, 0xff, 0x0, 0x0, 0x0,
    0x1, 0xfa, 0x0, 0x0,

    /* U+0057 "W" */
    0xbd, 0x0, 0x0, 0x8f, 0x40, 0x0, 0xf, 0x87,
    0xf1, 0x0, 0xc, 0xf8, 0x0, 0x3, 0xf4, 0x3f,
    0x40, 0x1, 0xfc, 0xd0, 0x0, 0x6f, 0x0, 0xe8,
    0x0, 0x5f, 0x5f, 0x20, 0xa, 0xc0, 0xa, 0xc0,
    0x9, 0xc0, 0xf6, 0x0, 0xe8, 0x0, 0x6f, 0x0,
    0xe8, 0xb, 0xb0, 0x2f, 0x40, 0x2, 0xf4, 0x2f,
    0x30, 0x6f, 0x6, 0xf0, 0x0, 0xe, 0x87, 0xe0,
    0x2, 0xf4, 0xac, 0x0, 0x0, 0xab, 0xaa, 0x0,
    0xd, 0x8d, 0x80, 0x0, 0x6, 0xee, 0x60, 0x0,
    0x8c, 0xf4, 0x0, 0x0, 0x2f, 0xf1, 0x0, 0x4,
    0xff, 0x0, 0x0, 0x0, 0xed, 0x0, 0x0, 0xf,
    0xc0, 0x0,

    /* U+0058 "X" */
    0x6f, 0x30, 0x0, 0xc, 0xb0, 0xc, 0xc0, 0x0,
    0x6f, 0x20, 0x2, 0xf6, 0x1, 0xe8, 0x0, 0x0,
    0x8e, 0x19, 0xd0, 0x0, 0x0, 0xe, 0xbf, 0x40,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x9,
    0xfe, 0x10, 0x0, 0x0, 0x3f, 0x4e, 0x90, 0x0,
    0x0, 0xca, 0x5, 0xf3, 0x0, 0x6, 0xf1, 0x0,
    0xcc, 0x0, 0x1f, 0x70, 0x0, 0x3f, 0x60, 0xad,
    0x0, 0x0, 0x9, 0xe1,

    /* U+0059 "Y" */
    0xbd, 0x0, 0x0, 0xc, 0xc0, 0x3f, 0x50, 0x0,
    0x4f, 0x40, 0xb, 0xd0, 0x0, 0xcc, 0x0, 0x3,
    0xf5, 0x4, 0xf3, 0x0, 0x0, 0xbd, 0xc, 0xb0,
    0x0, 0x0, 0x2f, 0xaf, 0x30, 0x0, 0x0, 0xa,
    0xfb, 0x0, 0x0, 0x0, 0x3, 0xf4, 0x0, 0x0,
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x0, 0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0,
    0x3, 0xf4, 0x0, 0x0,

    /* U+005A "Z" */
    0x3f, 0xff, 0xff, 0xff, 0x61, 0x55, 0x55, 0x5b,
    0xf2, 0x0, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x0,
    0x1e, 0x90, 0x0, 0x0, 0xa, 0xe1, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0xdb, 0x0, 0x0,
    0x0, 0x8f, 0x20, 0x0, 0x0, 0x2f, 0xb5, 0x55,
    0x55, 0x26, 0xff, 0xff, 0xff, 0xf8,

    /* U+005B "[" */
    0xbf, 0xfd, 0xbb, 0x32, 0xba, 0x0, 0xba, 0x0,
    0xba, 0x0, 0xba, 0x0, 0xba, 0x0, 0xba, 0x0,
    0xba, 0x0, 0xba, 0x0, 0xba, 0x0, 0xba, 0x0,
    0xba, 0x0, 0xbf, 0xfd, 0x23, 0x32,

    /* U+005C "\\" */
    0xab, 0x0, 0x0, 0x4f, 0x10, 0x0, 0xe, 0x60,
    0x0, 0x9, 0xc0, 0x0, 0x3, 0xf2, 0x0, 0x0,
    0xe7, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x2f, 0x30,
    0x0, 0xd, 0x90, 0x0, 0x7, 0xe0, 0x0, 0x1,
    0xf4, 0x0, 0x0, 0xca,

    /* U+005D "]" */
    0x9f, 0xff, 0x13, 0x8f, 0x0, 0x6f, 0x0, 0x6f,
    0x0, 0x6f, 0x0, 0x6f, 0x0, 0x6f, 0x0, 0x6f,
    0x0, 0x6f, 0x0, 0x6f, 0x0, 0x6f, 0x0, 0x6f,
    0x0, 0x6f, 0x9f, 0xff, 0x13, 0x32,

    /* U+005E "^" */
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x7f, 0x40,
    0x0, 0x0, 0xe, 0x9c, 0x0, 0x0, 0x5, 0xc0,
    0xd4, 0x0, 0x0, 0xc5, 0x6, 0xc0, 0x0, 0x4e,
    0x0, 0xe, 0x40, 0xb, 0x80, 0x0, 0x6c, 0x2,
    0xf1, 0x0, 0x0, 0xe4,

    /* U+005F "_" */
    0xf, 0xff, 0xff, 0xff, 0x20, 0x11, 0x11, 0x11,
    0x10,

    /* U+0060 "`" */
    0x28, 0x30, 0xa, 0xd0, 0x0, 0xa9,

    /* U+0061 "a" */
    0x1, 0x9e, 0xfe, 0x90, 0x1, 0xb5, 0x37, 0xf6,
    0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0xbb,
    0x2, 0x9d, 0xee, 0xfb, 0xe, 0xc4, 0x11, 0xcb,
    0x3f, 0x30, 0x0, 0xdb, 0x1f, 0x80, 0x18, 0xfb,
    0x6, 0xef, 0xe7, 0x7b,

    /* U+0062 "b" */
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xab, 0x6e, 0xfd, 0x50,
    0xaf, 0xc4, 0x3a, 0xf3, 0xaf, 0x10, 0x0, 0xdb,
    0xad, 0x0, 0x0, 0x9e, 0xac, 0x0, 0x0, 0x8f,
    0xad, 0x0, 0x0, 0x9e, 0xaf, 0x10, 0x0, 0xda,
    0xae, 0xc4, 0x3a, 0xf3, 0xa7, 0x6e, 0xfd, 0x50,

    /* U+0063 "c" */
    0x0, 0x4c, 0xff, 0xb0, 0x4, 0xfa, 0x45, 0x70,
    0xd, 0xb0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0xd, 0xb0, 0x0, 0x0, 0x5, 0xf9, 0x45, 0x90,
    0x0, 0x5c, 0xff, 0xb0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0xe7, 0x0, 0x0, 0x0, 0xe, 0x70, 0x6, 0xef,
    0xd4, 0xe7, 0x6, 0xf8, 0x35, 0xdf, 0x70, 0xdb,
    0x0, 0x3, 0xf7, 0x1f, 0x60, 0x0, 0xf, 0x71,
    0xf5, 0x0, 0x0, 0xe7, 0x1f, 0x60, 0x0, 0xf,
    0x70, 0xdb, 0x0, 0x3, 0xf7, 0x6, 0xf8, 0x35,
    0xdf, 0x70, 0x7, 0xef, 0xd4, 0xb7,

    /* U+0065 "e" */
    0x0, 0x4d, 0xfe, 0x70, 0x0, 0x4f, 0x93, 0x6f,
    0x70, 0xc, 0xc0, 0x0, 0x8e, 0x0, 0xf7, 0x0,
    0x4, 0xf2, 0x1f, 0xff, 0xff, 0xff, 0x30, 0xf7,
    0x22, 0x22, 0x20, 0xc, 0xa0, 0x0, 0x0, 0x0,
    0x4f, 0xa4, 0x46, 0x80, 0x0, 0x4c, 0xff, 0xd7,
    0x0,

    /* U+0066 "f" */
    0x0, 0x5e, 0xfe, 0x0, 0x1f, 0x93, 0x40, 0x3,
    0xf2, 0x0, 0x8, 0xef, 0xff, 0x50, 0x15, 0xf4,
    0x20, 0x0, 0x4f, 0x20, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x4f, 0x20, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x4f, 0x20, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x4f,
    0x20, 0x0,

    /* U+0067 "g" */
    0x0, 0x6e, 0xfd, 0x4b, 0x70, 0x5f, 0x93, 0x5d,
    0xf7, 0xd, 0xb0, 0x0, 0x3f, 0x70, 0xf6, 0x0,
    0x0, 0xf7, 0x1f, 0x50, 0x0, 0xe, 0x70, 0xf6,
    0x0, 0x0, 0xf7, 0xd, 0xb0, 0x0, 0x2f, 0x70,
    0x6f, 0x83, 0x4d, 0xf7, 0x0, 0x7e, 0xfd, 0x4e,
    0x70, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0x2f, 0x50, 0x68, 0x43, 0x5d, 0xd0, 0x3, 0xce,
    0xfe, 0xa2, 0x0,

    /* U+0068 "h" */
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x5d, 0xfe, 0x70,
    0xae, 0xc4, 0x39, 0xf4, 0xaf, 0x10, 0x0, 0xe8,
    0xad, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,

    /* U+0069 "i" */
    0x9b, 0x79, 0x0, 0xac, 0xac, 0xac, 0xac, 0xac,
    0xac, 0xac, 0xac, 0xac,

    /* U+006A "j" */
    0x0, 0x9b, 0x0, 0x79, 0x0, 0x0, 0x0, 0xac,
    0x0, 0xac, 0x0, 0xac, 0x0, 0xac, 0x0, 0xac,
    0x0, 0xac, 0x0, 0xac, 0x0, 0xac, 0x0, 0xac,
    0x0, 0xac, 0x0, 0xac, 0x44, 0xe9, 0xcf, 0xc1,

    /* U+006B "k" */
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x1d, 0xb0,
    0xac, 0x0, 0xcc, 0x0, 0xac, 0xb, 0xd1, 0x0,
    0xab, 0x9e, 0x10, 0x0, 0xae, 0xff, 0x30, 0x0,
    0xae, 0x2c, 0xd0, 0x0, 0xac, 0x2, 0xf9, 0x0,
    0xac, 0x0, 0x5f, 0x50, 0xac, 0x0, 0xa, 0xe1,

    /* U+006C "l" */
    0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac,
    0xac, 0xac, 0xac, 0xac,

    /* U+006D "m" */
    0xa9, 0x6e, 0xfc, 0x33, 0xcf, 0xe8, 0xa, 0xec,
    0x44, 0xde, 0xd6, 0x38, 0xf5, 0xaf, 0x10, 0x4,
    0xf7, 0x0, 0xd, 0x9a, 0xd0, 0x0, 0x3f, 0x40,
    0x0, 0xba, 0xac, 0x0, 0x3, 0xf3, 0x0, 0xb,
    0xaa, 0xc0, 0x0, 0x3f, 0x30, 0x0, 0xba, 0xac,
    0x0, 0x3, 0xf3, 0x0, 0xb, 0xaa, 0xc0, 0x0,
    0x3f, 0x30, 0x0, 0xba, 0xac, 0x0, 0x3, 0xf3,
    0x0, 0xb, 0xa0,

    /* U+006E "n" */
    0xa9, 0x5d, 0xfe, 0x70, 0xae, 0xc5, 0x39, 0xf4,
    0xaf, 0x10, 0x0, 0xe8, 0xad, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9,

    /* U+006F "o" */
    0x0, 0x4c, 0xff, 0xa1, 0x0, 0x4f, 0x94, 0x4c,
    0xe1, 0xd, 0xb0, 0x0, 0x1f, 0x70, 0xf6, 0x0,
    0x0, 0xbb, 0x1f, 0x50, 0x0, 0xa, 0xc0, 0xf6,
    0x0, 0x0, 0xbb, 0xc, 0xb0, 0x0, 0x1f, 0x70,
    0x3f, 0x93, 0x4c, 0xe1, 0x0, 0x4c, 0xff, 0xa2,
    0x0,

    /* U+0070 "p" */
    0xa9, 0x6d, 0xfd, 0x50, 0xae, 0xc4, 0x4a, 0xf4,
    0xaf, 0x10, 0x0, 0xdb, 0xad, 0x0, 0x0, 0x9e,
    0xac, 0x0, 0x0, 0x8f, 0xad, 0x0, 0x0, 0x9e,
    0xaf, 0x10, 0x0, 0xea, 0xaf, 0xc4, 0x3a, 0xf3,
    0xab, 0x6d, 0xfd, 0x40, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x6d, 0xfd, 0x4b, 0x70, 0x5f, 0x83, 0x5d,
    0xf7, 0xd, 0xb0, 0x0, 0x4f, 0x70, 0xf6, 0x0,
    0x0, 0xf7, 0x1f, 0x50, 0x0, 0xe, 0x71, 0xf6,
    0x0, 0x0, 0xf7, 0xd, 0xb0, 0x0, 0x3f, 0x70,
    0x6f, 0x83, 0x5d, 0xf7, 0x0, 0x7e, 0xfd, 0x4e,
    0x70, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0xe, 0x70, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x0, 0xe, 0x70,

    /* U+0072 "r" */
    0xa8, 0x3d, 0xf4, 0xac, 0xe7, 0x51, 0xaf, 0x40,
    0x0, 0xad, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0,

    /* U+0073 "s" */
    0x3, 0xcf, 0xfd, 0x60, 0xfa, 0x33, 0x74, 0x2f,
    0x40, 0x0, 0x0, 0xce, 0x71, 0x0, 0x0, 0x7d,
    0xf9, 0x10, 0x0, 0x5, 0xeb, 0x0, 0x0, 0x7,
    0xe2, 0x94, 0x34, 0xdb, 0x1b, 0xef, 0xe9, 0x10,

    /* U+0074 "t" */
    0x1, 0xd0, 0x0, 0x6, 0xe0, 0x0, 0x8f, 0xff,
    0xf5, 0x19, 0xe2, 0x20, 0x8, 0xe0, 0x0, 0x8,
    0xe0, 0x0, 0x8, 0xe0, 0x0, 0x8, 0xe0, 0x0,
    0x8, 0xe0, 0x0, 0x5, 0xf7, 0x32, 0x0, 0x9f,
    0xf5,

    /* U+0075 "u" */
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xac, 0x0, 0x2, 0xf8, 0x6f, 0x50, 0x2c, 0xf8,
    0x8, 0xef, 0xd6, 0xb8,

    /* U+0076 "v" */
    0xda, 0x0, 0x0, 0x8e, 0x7, 0xf0, 0x0, 0xe,
    0x90, 0x1f, 0x50, 0x3, 0xf3, 0x0, 0xbb, 0x0,
    0x9d, 0x0, 0x6, 0xf1, 0xe, 0x70, 0x0, 0xf,
    0x64, 0xf2, 0x0, 0x0, 0xab, 0x9c, 0x0, 0x0,
    0x4, 0xfe, 0x60, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0,

    /* U+0077 "w" */
    0xbc, 0x0, 0x9, 0xf3, 0x0, 0x2f, 0x47, 0xf0,
    0x0, 0xee, 0x80, 0x6, 0xf0, 0x2f, 0x40, 0x3f,
    0x8c, 0x0, 0xab, 0x0, 0xe7, 0x8, 0xc3, 0xf1,
    0xe, 0x70, 0xa, 0xb0, 0xd7, 0xe, 0x62, 0xf3,
    0x0, 0x6f, 0x2f, 0x30, 0xaa, 0x6e, 0x0, 0x2,
    0xf8, 0xe0, 0x5, 0xea, 0xa0, 0x0, 0xd, 0xe9,
    0x0, 0x1f, 0xf6, 0x0, 0x0, 0x9f, 0x40, 0x0,
    0xcf, 0x20, 0x0,

    /* U+0078 "x" */
    0x3f, 0x50, 0x0, 0xda, 0x0, 0x9e, 0x10, 0x8e,
    0x10, 0x0, 0xda, 0x3f, 0x50, 0x0, 0x3, 0xfe,
    0xa0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x5,
    0xfc, 0xc0, 0x0, 0x1, 0xe8, 0x1f, 0x70, 0x0,
    0xbd, 0x0, 0x6f, 0x20, 0x6f, 0x30, 0x0, 0xbd,
    0x0,

    /* U+0079 "y" */
    0xcb, 0x0, 0x0, 0x8f, 0x6, 0xf1, 0x0, 0xd,
    0x90, 0x1f, 0x60, 0x3, 0xf4, 0x0, 0xac, 0x0,
    0x9e, 0x0, 0x4, 0xf2, 0xe, 0x80, 0x0, 0xe,
    0x83, 0xf2, 0x0, 0x0, 0x8d, 0x8d, 0x0, 0x0,
    0x2, 0xfe, 0x70, 0x0, 0x0, 0xb, 0xf1, 0x0,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x0, 0x3, 0x4c, 0xd0, 0x0, 0x0, 0xcf, 0xc2,
    0x0, 0x0, 0x0,

    /* U+007A "z" */
    0x1f, 0xff, 0xff, 0xc0, 0x22, 0x23, 0xf8, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x5f, 0x30, 0x0, 0x1e,
    0x70, 0x0, 0xa, 0xc0, 0x0, 0x5, 0xf2, 0x0,
    0x1, 0xe9, 0x22, 0x21, 0x6f, 0xff, 0xff, 0xe0,

    /* U+007B "{" */
    0x0, 0x7, 0xd8, 0x0, 0x5f, 0x82, 0x0, 0x9d,
    0x0, 0x0, 0x9c, 0x0, 0x0, 0x9c, 0x0, 0x0,
    0x9c, 0x0, 0x3, 0xe8, 0x0, 0x8f, 0xa0, 0x0,
    0x15, 0xe8, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x9c,
    0x0, 0x0, 0x9c, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0xb, 0xf9, 0x0, 0x0, 0x11,

    /* U+007C "|" */
    0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,
    0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,

    /* U+007D "}" */
    0x7e, 0x80, 0x0, 0x16, 0xf6, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0xbb, 0x0, 0x0,
    0xbb, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x9, 0xfa,
    0x0, 0x6f, 0x62, 0x0, 0xbb, 0x0, 0x0, 0xbb,
    0x0, 0x0, 0xbb, 0x0, 0x3, 0xe9, 0x0, 0x7f,
    0xc1, 0x0, 0x11, 0x0, 0x0,

    /* U+007E "~" */
    0xa, 0xfe, 0x93, 0x5, 0x43, 0x93, 0x5b, 0xff,
    0xe2, 0x0, 0x0, 0x1, 0x20, 0x0,

    /* U+00A1 "¡" */
    0xae, 0xc, 0xf1, 0x12, 0x2, 0x40, 0x6a, 0x6,
    0xa0, 0x7b, 0x8, 0xc0, 0x9d, 0x9, 0xd0, 0xae,
    0xb, 0xf0,

    /* U+00A2 "¢" */
    0x0, 0x7, 0xa0, 0x0, 0x1a, 0xff, 0xe7, 0xc,
    0xe5, 0x36, 0x44, 0xf4, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x5, 0xf2, 0x0, 0x0, 0xe, 0xc2, 0x2, 0x40,
    0x3d, 0xff, 0xf8, 0x0, 0x8, 0xb1, 0x0, 0x0,
    0x7a, 0x0,

    /* U+00A3 "£" */
    0x0, 0x7, 0xef, 0xe9, 0x0, 0x7, 0xf6, 0x36,
    0xa0, 0x0, 0xda, 0x0, 0x0, 0x0, 0xe, 0x80,
    0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0xe,
    0x80, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xb0, 0x0,
    0x2e, 0x92, 0x21, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0x2b, 0xd5, 0x55,
    0x55, 0x27, 0xff, 0xff, 0xff, 0xf9,

    /* U+00A4 "¤" */
    0x3, 0x0, 0x0, 0x3, 0x0, 0xcb, 0xcf, 0xda,
    0xd0, 0x2, 0xf6, 0x14, 0xe5, 0x0, 0x79, 0x0,
    0x7, 0xa0, 0x8, 0x90, 0x0, 0x6a, 0x0, 0x3f,
    0x40, 0x2e, 0x50, 0xb, 0xde, 0xff, 0xcc, 0x0,
    0x50, 0x1, 0x0, 0x50,

    /* U+00A5 "¥" */
    0x8e, 0x0, 0x0, 0xd, 0xa1, 0xe7, 0x0, 0x5,
    0xf1, 0x7, 0xe0, 0x0, 0xd9, 0x0, 0xe, 0x70,
    0x5f, 0x10, 0x0, 0x6e, 0xc, 0x80, 0x0, 0x0,
    0xdb, 0xe0, 0x0, 0x8, 0xff, 0xff, 0xf9, 0x0,
    0x12, 0x3f, 0x52, 0x10, 0x0, 0x2, 0xf4, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0x90, 0x1, 0x23, 0xf5,
    0x21, 0x0, 0x0, 0x2f, 0x40, 0x0,

    /* U+00A6 "¦" */
    0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x4, 0x0,
    0x0, 0x4, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f,

    /* U+00A7 "§" */
    0x2, 0xbf, 0xfe, 0x90, 0xc, 0xb2, 0x24, 0x60,
    0xc, 0xa0, 0x0, 0x0, 0x3, 0xee, 0x82, 0x0,
    0x7, 0xd6, 0xaf, 0x70, 0xe, 0x50, 0x5, 0xf1,
    0xc, 0xb1, 0x2, 0xf1, 0x2, 0xcf, 0x9d, 0x80,
    0x0, 0x3, 0x9f, 0x80, 0x0, 0x0, 0x5, 0xf1,
    0x8, 0x31, 0x2a, 0xe0, 0xb, 0xef, 0xfb, 0x30,

    /* U+00A8 "¨" */
    0x46, 0x4, 0x67, 0xc0, 0x7b,

    /* U+00A9 "©" */
    0x0, 0x1, 0x9d, 0xed, 0xa3, 0x0, 0x0, 0x5,
    0xd6, 0x10, 0x4, 0xc8, 0x0, 0x3, 0xd1, 0x1a,
    0xee, 0x80, 0xb6, 0x0, 0xb4, 0xb, 0xc3, 0x34,
    0x1, 0xe0, 0xe, 0x1, 0xf2, 0x0, 0x0, 0x9,
    0x53, 0xb0, 0x3f, 0x0, 0x0, 0x0, 0x68, 0x3b,
    0x2, 0xf1, 0x0, 0x0, 0x6, 0x80, 0xe0, 0xd,
    0x90, 0x2, 0x0, 0x95, 0xb, 0x50, 0x3d, 0xff,
    0x80, 0x1e, 0x10, 0x3e, 0x20, 0x1, 0x10, 0xb,
    0x70, 0x0, 0x5e, 0x61, 0x0, 0x4d, 0x90, 0x0,
    0x0, 0x19, 0xde, 0xda, 0x40, 0x0,

    /* U+00AA "ª" */
    0xb, 0xdc, 0x40, 0x20, 0x2d, 0x8, 0xcb, 0xe6,
    0xb0, 0x1e, 0x6a, 0x6, 0xe1, 0xcc, 0x7b,

    /* U+00AB "«" */
    0x0, 0x9, 0x10, 0x82, 0x0, 0xbc, 0x8, 0xe1,
    0x8, 0xe1, 0x5f, 0x30, 0x3f, 0x51, 0xf7, 0x0,
    0xb, 0xc0, 0x9e, 0x10, 0x1, 0xe9, 0xc, 0xb0,
    0x0, 0x2d, 0x11, 0xd3, 0x0, 0x0, 0x0, 0x0,

    /* U+00AC "¬" */
    0x3f, 0xff, 0xff, 0xff, 0x50, 0x22, 0x22, 0x22,
    0xd5, 0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x0,
    0x0, 0xd5, 0x0, 0x0, 0x0, 0x2, 0x0,

    /* U+00AD "­" */
    0x0, 0x0, 0x5, 0xff, 0xf8, 0x13, 0x33, 0x10,

    /* U+00AE "®" */
    0x0, 0x1, 0x9d, 0xed, 0xa3, 0x0, 0x0, 0x5,
    0xd6, 0x10, 0x4, 0xc8, 0x0, 0x3, 0xd1, 0x8f,
    0xec, 0x40, 0xb6, 0x0, 0xb4, 0x8, 0xb2, 0x9e,
    0x1, 0xe0, 0xe, 0x0, 0x8b, 0x3, 0xf0, 0x9,
    0x53, 0xb0, 0x8, 0xb0, 0x7e, 0x0, 0x68, 0x3b,
    0x0, 0x8f, 0xff, 0x30, 0x6, 0x80, 0xe0, 0x8,
    0xb3, 0xf4, 0x0, 0x95, 0xb, 0x50, 0x8b, 0x7,
    0xd0, 0x1e, 0x10, 0x3e, 0x25, 0x70, 0x9, 0x5b,
    0x70, 0x0, 0x5e, 0x61, 0x0, 0x4d, 0x90, 0x0,
    0x0, 0x19, 0xde, 0xda, 0x40, 0x0,

    /* U+00AF "¯" */
    0xf, 0xff, 0xff, 0xff, 0xf0, 0x2, 0x22, 0x22,
    0x22, 0x20,

    /* U+00B0 "°" */
    0x3, 0xdf, 0xc2, 0xe, 0x40, 0x7c, 0x1f, 0x0,
    0x1f, 0xe, 0x40, 0x7c, 0x3, 0xdf, 0xc2,

    /* U+00B1 "±" */
    0x0, 0x0, 0xf2, 0x0, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0x0, 0xf2, 0x0, 0x0, 0x0, 0xf,
    0x20, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x40, 0x22,
    0x2f, 0x42, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x2, 0x22, 0x22, 0x22,
    0x3, 0xff, 0xff, 0xff, 0xf5,

    /* U+00B2 "²" */
    0x2b, 0xee, 0x42, 0x40, 0x5d, 0x0, 0x5, 0xc0,
    0x1, 0xd4, 0x1, 0xd5, 0x1, 0xd5, 0x0, 0x9f,
    0xff, 0xe0,

    /* U+00B3 "³" */
    0x4d, 0xee, 0x50, 0x23, 0x5, 0xe0, 0x0, 0x7,
    0xb0, 0x9, 0xef, 0x40, 0x0, 0x3, 0xf1, 0x30,
    0x3, 0xf1, 0x8e, 0xed, 0x50,

    /* U+00B4 "´" */
    0x0, 0x76, 0x7, 0xf3, 0x2e, 0x30,

    /* U+00B5 "µ" */
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xd9,
    0xad, 0x0, 0x1, 0xf9, 0xaf, 0x60, 0x2b, 0xf9,
    0xad, 0xcf, 0xe7, 0x99, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0,

    /* U+00B6 "¶" */
    0x0, 0x9e, 0xff, 0xfe, 0xc0, 0x9f, 0xff, 0xf3,
    0x2c, 0xf, 0xff, 0xff, 0x32, 0xc1, 0xff, 0xff,
    0xf3, 0x2c, 0x1f, 0xff, 0xff, 0x32, 0xc0, 0xff,
    0xff, 0xf3, 0x2c, 0xa, 0xff, 0xff, 0x32, 0xc0,
    0x1b, 0xff, 0xf3, 0x2c, 0x0, 0x0, 0xb, 0x32,
    0xc0, 0x0, 0x0, 0xb3, 0x2c, 0x0, 0x0, 0xb,
    0x32, 0xc0, 0x0, 0x0, 0xb3, 0x2c, 0x0, 0x0,
    0xb, 0x32, 0xc0, 0x0, 0x0, 0xb3, 0x2c, 0x0,
    0x0, 0x4, 0x10, 0x50,

    /* U+00B7 "·" */
    0x11, 0xc, 0xf1, 0xae, 0x0,

    /* U+00B8 "¸" */
    0x0, 0x0, 0xc, 0x30, 0x9, 0xe2, 0x0, 0xd5,
    0xbe, 0xa0,

    /* U+00B9 "¹" */
    0x2, 0xdd, 0x2e, 0x8d, 0x1, 0x4d, 0x0, 0x4d,
    0x0, 0x4d, 0x0, 0x4d, 0x0, 0x4d,

    /* U+00BA "º" */
    0x6, 0xdd, 0x60, 0x3d, 0x0, 0xd3, 0x78, 0x0,
    0x87, 0x78, 0x0, 0x87, 0x3d, 0x0, 0xd3, 0x6,
    0xdd, 0x60,

    /* U+00BB "»" */
    0x19, 0x0, 0x81, 0x0, 0xc, 0xa0, 0xac, 0x0,
    0x1, 0xe7, 0xd, 0xa0, 0x0, 0x5f, 0x22, 0xf5,
    0x0, 0xcb, 0xa, 0xd1, 0x9, 0xd0, 0x7e, 0x20,
    0x2d, 0x20, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+00BC "¼" */
    0x2, 0xdc, 0x0, 0x0, 0x4d, 0x0, 0x3e, 0x9c,
    0x0, 0x0, 0xd5, 0x0, 0x2, 0x5c, 0x0, 0x7,
    0xb0, 0x0, 0x0, 0x5c, 0x0, 0x1e, 0x20, 0x0,
    0x0, 0x5c, 0x0, 0xa9, 0x0, 0x10, 0x0, 0x5c,
    0x3, 0xe1, 0xc, 0xc0, 0x0, 0x5c, 0xc, 0x60,
    0x9c, 0xc0, 0x0, 0x0, 0x5d, 0x4, 0xa6, 0xc0,
    0x0, 0x0, 0xe4, 0x1d, 0x16, 0xc0, 0x0, 0x8,
    0xa0, 0x8f, 0xff, 0xfc, 0x0, 0x2f, 0x20, 0x0,
    0x6, 0xc0, 0x0, 0xb8, 0x0, 0x0, 0x6, 0xc0,

    /* U+00BD "½" */
    0x4, 0xe9, 0x0, 0x0, 0xc6, 0x0, 0x5e, 0xb9,
    0x0, 0x5, 0xd0, 0x0, 0x22, 0x89, 0x0, 0xe,
    0x40, 0x0, 0x0, 0x89, 0x0, 0x8b, 0x0, 0x0,
    0x0, 0x89, 0x1, 0xf2, 0x0, 0x0, 0x0, 0x89,
    0xa, 0x84, 0xde, 0xc2, 0x0, 0x89, 0x3e, 0x3,
    0x20, 0xa9, 0x0, 0x0, 0xc6, 0x0, 0x0, 0x98,
    0x0, 0x6, 0xc0, 0x0, 0x3, 0xe1, 0x0, 0xe,
    0x30, 0x0, 0x3d, 0x30, 0x0, 0x8a, 0x0, 0x3,
    0xd3, 0x0, 0x2, 0xf1, 0x0, 0xd, 0xfe, 0xe9,
    0x0, 0x10, 0x0, 0x1, 0x11, 0x10,

    /* U+00BE "¾" */
    0x4b, 0xcc, 0x30, 0x0, 0x7, 0x90, 0x2, 0x20,
    0x6d, 0x0, 0x2, 0xe1, 0x0, 0x0, 0x8, 0xb0,
    0x0, 0xb7, 0x0, 0x0, 0xaf, 0xf4, 0x0, 0x4d,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0xd, 0x50, 0x10,
    0x3, 0x0, 0x5f, 0x7, 0xb0, 0x4f, 0x60, 0x8e,
    0xfd, 0x51, 0xe2, 0x1b, 0xd6, 0x0, 0x0, 0x0,
    0xa8, 0xb, 0x3d, 0x60, 0x0, 0x0, 0x3e, 0x7,
    0x80, 0xd6, 0x0, 0x0, 0xc, 0x60, 0xef, 0xff,
    0xf5, 0x0, 0x6, 0xc0, 0x0, 0x0, 0xd6, 0x0,
    0x1, 0xe3, 0x0, 0x0, 0xd, 0x60,

    /* U+00BF "¿" */
    0x0, 0xb, 0xd0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x1, 0x10, 0x0, 0x0, 0x34, 0x0, 0x0, 0x8,
    0xa0, 0x0, 0x2, 0xe6, 0x0, 0x3, 0xea, 0x0,
    0x1, 0xe9, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x9,
    0xc0, 0x0, 0x0, 0x6f, 0x51, 0x26, 0x40, 0xaf,
    0xff, 0xe6, 0x0, 0x13, 0x20, 0x0,

    /* U+00C0 "À" */
    0x0, 0x7, 0x60, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x5d, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0,
    0x0, 0x0, 0x7, 0xda, 0xb0, 0x0, 0x0, 0x0,
    0xd8, 0x5f, 0x10, 0x0, 0x0, 0x3f, 0x20, 0xe6,
    0x0, 0x0, 0x9, 0xd0, 0x9, 0xc0, 0x0, 0x0,
    0xe8, 0x11, 0x4f, 0x20, 0x0, 0x5f, 0xff, 0xff,
    0xf8, 0x0, 0xb, 0xc4, 0x44, 0x4a, 0xe0, 0x1,
    0xf5, 0x0, 0x0, 0x3f, 0x40, 0x7f, 0x0, 0x0,
    0x0, 0xda, 0xd, 0xa0, 0x0, 0x0, 0x7, 0xf0,

    /* U+00C1 "Á" */
    0x0, 0x0, 0x3, 0x82, 0x0, 0x0, 0x0, 0x0,
    0xdb, 0x0, 0x0, 0x0, 0x0, 0x8b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0,
    0x0, 0x0, 0x7, 0xda, 0xb0, 0x0, 0x0, 0x0,
    0xd8, 0x5f, 0x10, 0x0, 0x0, 0x3f, 0x20, 0xe6,
    0x0, 0x0, 0x9, 0xd0, 0x9, 0xc0, 0x0, 0x0,
    0xe8, 0x11, 0x4f, 0x20, 0x0, 0x5f, 0xff, 0xff,
    0xf8, 0x0, 0xb, 0xc4, 0x44, 0x4a, 0xe0, 0x1,
    0xf5, 0x0, 0x0, 0x3f, 0x40, 0x7f, 0x0, 0x0,
    0x0, 0xda, 0xd, 0xa0, 0x0, 0x0, 0x7, 0xf0,

    /* U+00C2 "Â" */
    0x0, 0x0, 0x67, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0xe8, 0x0, 0x0, 0x0, 0x4d, 0x21, 0xc7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0,
    0x0, 0x0, 0x7, 0xda, 0xb0, 0x0, 0x0, 0x0,
    0xd8, 0x5f, 0x10, 0x0, 0x0, 0x3f, 0x20, 0xe6,
    0x0, 0x0, 0x9, 0xd0, 0x9, 0xc0, 0x0, 0x0,
    0xe8, 0x11, 0x4f, 0x20, 0x0, 0x5f, 0xff, 0xff,
    0xf8, 0x0, 0xb, 0xc4, 0x44, 0x4a, 0xe0, 0x1,
    0xf5, 0x0, 0x0, 0x3f, 0x40, 0x7f, 0x0, 0x0,
    0x0, 0xda, 0xd, 0xa0, 0x0, 0x0, 0x7, 0xf0,

    /* U+00C3 "Ã" */
    0x0, 0x3e, 0xd5, 0x1d, 0x0, 0x0, 0xb, 0x56,
    0xef, 0x80, 0x0, 0x0, 0x20, 0x0, 0x10, 0x0,
    0x0, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x7d, 0xab, 0x0,
    0x0, 0x0, 0xd, 0x85, 0xf1, 0x0, 0x0, 0x3,
    0xf2, 0xe, 0x60, 0x0, 0x0, 0x9d, 0x0, 0x9c,
    0x0, 0x0, 0xe, 0x81, 0x14, 0xf2, 0x0, 0x5,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xbc, 0x44, 0x44,
    0xae, 0x0, 0x1f, 0x50, 0x0, 0x3, 0xf4, 0x7,
    0xf0, 0x0, 0x0, 0xd, 0xa0, 0xda, 0x0, 0x0,
    0x0, 0x7f, 0x0,

    /* U+00C4 "Ä" */
    0x0, 0x1e, 0x31, 0xe3, 0x0, 0x0, 0x0, 0x81,
    0x8, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x7d, 0xab, 0x0,
    0x0, 0x0, 0xd, 0x85, 0xf1, 0x0, 0x0, 0x3,
    0xf2, 0xe, 0x60, 0x0, 0x0, 0x9d, 0x0, 0x9c,
    0x0, 0x0, 0xe, 0x81, 0x14, 0xf2, 0x0, 0x5,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xbc, 0x44, 0x44,
    0xae, 0x0, 0x1f, 0x50, 0x0, 0x3, 0xf4, 0x7,
    0xf0, 0x0, 0x0, 0xd, 0xa0, 0xda, 0x0, 0x0,
    0x0, 0x7f, 0x0,

    /* U+00C5 "Å" */
    0x0, 0x2, 0xcc, 0x40, 0x0, 0x0, 0x0, 0x94,
    0x2c, 0x0, 0x0, 0x0, 0x9, 0x53, 0xc0, 0x0,
    0x0, 0x0, 0x2e, 0xf3, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x7d, 0xab, 0x0,
    0x0, 0x0, 0xd, 0x85, 0xf1, 0x0, 0x0, 0x3,
    0xf2, 0xe, 0x60, 0x0, 0x0, 0x9d, 0x0, 0x9c,
    0x0, 0x0, 0xe, 0x81, 0x14, 0xf2, 0x0, 0x5,
    0xff, 0xff, 0xff, 0x80, 0x0, 0xbc, 0x44, 0x44,
    0xae, 0x0, 0x1f, 0x50, 0x0, 0x3, 0xf4, 0x7,
    0xf0, 0x0, 0x0, 0xd, 0xa0, 0xda, 0x0, 0x0,
    0x0, 0x7f, 0x0,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x4f, 0x5d, 0xb4, 0x44, 0x40, 0x0,
    0x0, 0xb, 0xb0, 0xda, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf4, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xad, 0x0, 0xda, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x60, 0xd, 0xff, 0xff, 0xd0, 0x0, 0x8, 0xe1,
    0x11, 0xdb, 0x33, 0x33, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xa0, 0x0, 0x0, 0x0, 0x7f, 0x44, 0x44,
    0xda, 0x0, 0x0, 0x0, 0xd, 0x90, 0x0, 0xd,
    0xa0, 0x0, 0x0, 0x5, 0xf2, 0x0, 0x0, 0xdb,
    0x44, 0x44, 0x0, 0xcb, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xf2,

    /* U+00C7 "Ç" */
    0x0, 0x3, 0xbe, 0xfe, 0xb4, 0x0, 0x6f, 0xc6,
    0x56, 0xb3, 0x2, 0xfa, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xc6, 0x56, 0x92, 0x0,
    0x5, 0xcf, 0xfe, 0xb1, 0x0, 0x0, 0xa, 0x60,
    0x0, 0x0, 0x0, 0x7, 0xe5, 0x0, 0x0, 0x0,
    0x0, 0xa8, 0x0, 0x0, 0x0, 0x8e, 0xc1, 0x0,

    /* U+00C8 "È" */
    0x0, 0x84, 0x0, 0x0, 0x8, 0xf2, 0x0, 0x0,
    0x8, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xf7, 0xf4, 0x44, 0x44, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xfa, 0x7f, 0x33, 0x33, 0x27, 0xf0,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x7f, 0x44, 0x44, 0x47, 0xff, 0xff, 0xff,

    /* U+00C9 "É" */
    0x0, 0x0, 0x48, 0x10, 0x0, 0x1f, 0x80, 0x0,
    0xb, 0x80, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xf7, 0xf4, 0x44, 0x44, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xfa, 0x7f, 0x33, 0x33, 0x27, 0xf0,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x7f, 0x44, 0x44, 0x47, 0xff, 0xff, 0xff,

    /* U+00CA "Ê" */
    0x0, 0x7, 0x50, 0x0, 0x9, 0xdf, 0x50, 0x7,
    0xb1, 0x3d, 0x40, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xf7, 0xf4, 0x44, 0x44, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xff, 0xff, 0xfa, 0x7f, 0x33, 0x33, 0x27, 0xf0,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x7f, 0x44, 0x44, 0x47, 0xff, 0xff, 0xff,

    /* U+00CB "Ë" */
    0x3, 0xe1, 0x4e, 0x10, 0x18, 0x1, 0x80, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0x7f, 0x44,
    0x44, 0x47, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xa7,
    0xf3, 0x33, 0x32, 0x7f, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf4, 0x44,
    0x44, 0x7f, 0xff, 0xff, 0xf0,

    /* U+00CC "Ì" */
    0x28, 0x30, 0x0, 0xad, 0x0, 0x0, 0xa9, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xb0, 0x1f, 0x80, 0x0,
    0xf6, 0x0, 0xf, 0x60, 0x0, 0xf6, 0x0, 0xf,
    0x60, 0x0, 0xf6, 0x0, 0xf, 0x60, 0x0, 0xf6,
    0x0, 0xf, 0x60, 0x1, 0xf7, 0x5, 0xff, 0xfb,

    /* U+00CD "Í" */
    0x0, 0x5, 0x70, 0x0, 0x3f, 0x60, 0x0, 0xd6,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xb0, 0x1,
    0xf8, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xf6, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0xf6, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0xf6, 0x0, 0x1, 0xf7, 0x0, 0x5f, 0xff, 0xb0,

    /* U+00CE "Î" */
    0x1, 0x84, 0x0, 0xb, 0xdf, 0x30, 0xa9, 0x5,
    0xd2, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xb0, 0x1,
    0xf8, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xf6, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0xf6, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0xf6, 0x0, 0x1, 0xf7, 0x0, 0x5f, 0xff, 0xb0,

    /* U+00CF "Ï" */
    0x6d, 0x6, 0xd3, 0x70, 0x37, 0x0, 0x0, 0x5,
    0xff, 0xfb, 0x1, 0xf8, 0x0, 0xf, 0x60, 0x0,
    0xf6, 0x0, 0xf, 0x60, 0x0, 0xf6, 0x0, 0xf,
    0x60, 0x0, 0xf6, 0x0, 0xf, 0x60, 0x0, 0xf6,
    0x0, 0x1f, 0x70, 0x5f, 0xff, 0xb0,

    /* U+00D0 "Ð" */
    0x5, 0xff, 0xff, 0xd9, 0x10, 0x0, 0x5f, 0x54,
    0x58, 0xee, 0x30, 0x5, 0xf1, 0x0, 0x1, 0xdd,
    0x0, 0x5f, 0x10, 0x0, 0x4, 0xf5, 0x5, 0xf1,
    0x0, 0x0, 0xf, 0x90, 0x6f, 0x20, 0x0, 0x0,
    0xda, 0x8f, 0xff, 0xff, 0x0, 0xd, 0xa1, 0x7f,
    0x53, 0x30, 0x0, 0xf8, 0x5, 0xf1, 0x0, 0x0,
    0x4f, 0x40, 0x5f, 0x10, 0x0, 0x1d, 0xd0, 0x5,
    0xf5, 0x45, 0x8f, 0xe2, 0x0, 0x5f, 0xff, 0xfc,
    0x70, 0x0,

    /* U+00D1 "Ñ" */
    0x0, 0x3e, 0xd5, 0x1d, 0x0, 0x0, 0xb5, 0x6e,
    0xf7, 0x0, 0x0, 0x20, 0x0, 0x10, 0x0, 0x7f,
    0x80, 0x0, 0x0, 0xb9, 0x7f, 0xf2, 0x0, 0x0,
    0xb9, 0x7d, 0xdc, 0x0, 0x0, 0xb9, 0x7d, 0x4f,
    0x60, 0x0, 0xb9, 0x7d, 0xa, 0xf1, 0x0, 0xb9,
    0x7e, 0x1, 0xfa, 0x0, 0xb9, 0x7e, 0x0, 0x7f,
    0x40, 0xb9, 0x7e, 0x0, 0xd, 0xd0, 0xb9, 0x7e,
    0x0, 0x3, 0xf8, 0xa9, 0x7e, 0x0, 0x0, 0x9f,
    0xd9, 0x7e, 0x0, 0x0, 0x1e, 0xf9, 0x7e, 0x0,
    0x0, 0x6, 0xf9,

    /* U+00D2 "Ò" */
    0x0, 0x0, 0x57, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x3, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0, 0x0, 0x8f,
    0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f, 0xa5, 0x57,
    0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x0, 0x0, 0x18, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xad, 0x10, 0x0, 0x0, 0x0, 0x5, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0, 0x0, 0x8f,
    0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f, 0xa5, 0x57,
    0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x0, 0x5, 0x81, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xdb, 0x0, 0x0, 0x0, 0x2, 0xd4, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0, 0x0, 0x8f,
    0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f, 0xa5, 0x57,
    0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0x1, 0xde, 0x60, 0xc1, 0x0, 0x0, 0x8,
    0x85, 0xdf, 0xa0, 0x0, 0x0, 0x1, 0x0, 0x2,
    0x0, 0x0, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,
    0x0, 0x8f, 0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0,
    0x6, 0xf2, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf7, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0,
    0x2, 0xf6, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0x4, 0xf7, 0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f,
    0xa5, 0x57, 0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe,
    0x91, 0x0,

    /* U+00D6 "Ö" */
    0x0, 0x0, 0xd6, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x73, 0x7, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,
    0x0, 0x8f, 0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0,
    0x6, 0xf2, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xf, 0x80, 0x0, 0x0, 0x0, 0xf7, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0,
    0x2, 0xf6, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0x4, 0xf7, 0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f,
    0xa5, 0x57, 0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe,
    0x91, 0x0,

    /* U+00D7 "×" */
    0x20, 0x0, 0x0, 0x30, 0xbb, 0x0, 0xa, 0xd0,
    0x1d, 0xb0, 0x9e, 0x20, 0x1, 0xde, 0xe2, 0x0,
    0x0, 0x9f, 0xb0, 0x0, 0x8, 0xe4, 0xea, 0x0,
    0x7f, 0x30, 0x2e, 0x90, 0x73, 0x0, 0x2, 0x80,

    /* U+00D8 "Ø" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x5,
    0xcf, 0xfd, 0x9b, 0x90, 0x0, 0x8f, 0xa5, 0x57,
    0xef, 0x30, 0x4, 0xf7, 0x0, 0x2, 0xff, 0xb0,
    0xb, 0xe0, 0x0, 0xc, 0xa6, 0xf2, 0xe, 0xa0,
    0x0, 0x7e, 0x2, 0xf6, 0xf, 0x80, 0x3, 0xf4,
    0x0, 0xf7, 0xf, 0x80, 0xd, 0x80, 0x0, 0xf7,
    0xe, 0xa0, 0x9d, 0x0, 0x2, 0xf6, 0xa, 0xe4,
    0xf2, 0x0, 0x6, 0xf2, 0x4, 0xff, 0x70, 0x0,
    0x1e, 0xb0, 0x0, 0xcf, 0xb6, 0x57, 0xee, 0x20,
    0x3, 0xf6, 0xbf, 0xfe, 0x91, 0x0, 0x0, 0x20,
    0x0, 0x0, 0x0, 0x0,

    /* U+00D9 "Ù" */
    0x0, 0x18, 0x40, 0x0, 0x0, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x3,
    0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0,
    0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3,
    0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0,
    0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x8e,
    0x0, 0x0, 0x3, 0xf3, 0x7f, 0x0, 0x0, 0x4,
    0xf2, 0x3f, 0x50, 0x0, 0xa, 0xe0, 0xa, 0xf8,
    0x55, 0xaf, 0x50, 0x0, 0x8d, 0xff, 0xc4, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x0, 0x4, 0x81, 0x0, 0x0, 0x0, 0x1f,
    0x80, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x3,
    0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0,
    0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3,
    0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0,
    0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x8e,
    0x0, 0x0, 0x3, 0xf3, 0x7f, 0x0, 0x0, 0x4,
    0xf2, 0x3f, 0x50, 0x0, 0xa, 0xe0, 0xa, 0xf8,
    0x55, 0xaf, 0x50, 0x0, 0x8d, 0xff, 0xc4, 0x0,

    /* U+00DB "Û" */
    0x0, 0x0, 0x75, 0x0, 0x0, 0x0, 0xa, 0xdf,
    0x50, 0x0, 0x0, 0x8b, 0x13, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x3,
    0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0,
    0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3,
    0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0,
    0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x8e,
    0x0, 0x0, 0x3, 0xf3, 0x7f, 0x0, 0x0, 0x4,
    0xf2, 0x3f, 0x50, 0x0, 0xa, 0xe0, 0xa, 0xf8,
    0x55, 0xaf, 0x50, 0x0, 0x8d, 0xff, 0xc4, 0x0,

    /* U+00DC "Ü" */
    0x0, 0x4e, 0x4, 0xe0, 0x0, 0x0, 0x28, 0x2,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9e,
    0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3,
    0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0,
    0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0, 0x3, 0xf3,
    0x9e, 0x0, 0x0, 0x3, 0xf3, 0x9e, 0x0, 0x0,
    0x3, 0xf3, 0x8e, 0x0, 0x0, 0x3, 0xf3, 0x7f,
    0x0, 0x0, 0x4, 0xf2, 0x3f, 0x50, 0x0, 0xa,
    0xe0, 0xa, 0xf8, 0x55, 0xaf, 0x50, 0x0, 0x8d,
    0xff, 0xc4, 0x0,

    /* U+00DD "Ý" */
    0x0, 0x0, 0x7, 0x60, 0x0, 0x0, 0x0, 0x6f,
    0x30, 0x0, 0x0, 0x2, 0xe3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x0, 0xc,
    0xc0, 0x3f, 0x50, 0x0, 0x4f, 0x40, 0xb, 0xd0,
    0x0, 0xcc, 0x0, 0x3, 0xf5, 0x4, 0xf3, 0x0,
    0x0, 0xbd, 0xc, 0xb0, 0x0, 0x0, 0x2f, 0xaf,
    0x30, 0x0, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x0,
    0x3, 0xf4, 0x0, 0x0, 0x0, 0x3, 0xf4, 0x0,
    0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x3,
    0xf4, 0x0, 0x0, 0x0, 0x3, 0xf4, 0x0, 0x0,

    /* U+00DE "Þ" */
    0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xfc, 0x50, 0x7f, 0x33, 0x5b, 0xf5,
    0x7f, 0x0, 0x0, 0xdb, 0x7f, 0x0, 0x0, 0xad,
    0x7f, 0x0, 0x0, 0xcb, 0x7f, 0x0, 0x29, 0xf5,
    0x7f, 0xff, 0xfe, 0x60, 0x7f, 0x33, 0x20, 0x0,
    0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,

    /* U+00DF "ß" */
    0x6, 0xdf, 0xfc, 0x50, 0x5, 0xf8, 0x34, 0xaf,
    0x30, 0x9d, 0x0, 0x2, 0xf5, 0xa, 0xc0, 0x0,
    0xad, 0x0, 0xac, 0x0, 0xcc, 0x10, 0xa, 0xc0,
    0x3f, 0x20, 0x0, 0xac, 0x0, 0xdd, 0x30, 0xa,
    0xc0, 0x1, 0xaf, 0x60, 0xac, 0x0, 0x0, 0x7f,
    0x2a, 0xc0, 0x0, 0x0, 0xf5, 0xac, 0x8, 0x43,
    0x8f, 0x3a, 0xc0, 0x9e, 0xfd, 0x60,

    /* U+00E0 "à" */
    0x0, 0x4f, 0x60, 0x0, 0x0, 0x3, 0xe3, 0x0,
    0x0, 0x0, 0x11, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+00E1 "á" */
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x1, 0xd7, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+00E2 "â" */
    0x0, 0xa, 0xf9, 0x0, 0x0, 0xaa, 0x2b, 0x90,
    0x0, 0x20, 0x0, 0x20, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+00E3 "ã" */
    0x0, 0xbf, 0x91, 0x95, 0x4, 0xa3, 0xbf, 0xd0,
    0x1, 0x10, 0x1, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+00E4 "ä" */
    0x0, 0xaa, 0x9, 0x90, 0x0, 0x55, 0x5, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+00E5 "å" */
    0x0, 0x9, 0xd8, 0x0, 0x0, 0x3b, 0xc, 0x20,
    0x0, 0x3b, 0xc, 0x20, 0x0, 0x9, 0xd8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+00E6 "æ" */
    0x3, 0xae, 0xfd, 0x43, 0xcf, 0xe6, 0x0, 0x4,
    0xa4, 0x3a, 0xfe, 0x93, 0x7f, 0x50, 0x0, 0x0,
    0x0, 0xfd, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x8, 0xf0, 0x2, 0xae, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x1e, 0xc4, 0x22, 0xfa, 0x22,
    0x22, 0x20, 0x3f, 0x30, 0x1, 0xfc, 0x0, 0x0,
    0x0, 0x1f, 0xa4, 0x5d, 0x9f, 0xa4, 0x46, 0x60,
    0x5, 0xdf, 0xd6, 0x3, 0xbf, 0xfd, 0x50,

    /* U+00E7 "ç" */
    0x0, 0x4c, 0xff, 0xb0, 0x4, 0xfa, 0x45, 0x70,
    0xd, 0xb0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0xd, 0xb0, 0x0, 0x0, 0x5, 0xf9, 0x45, 0x90,
    0x0, 0x5c, 0xff, 0xb0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x2, 0xad, 0x0, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0xe, 0xe7, 0x0,

    /* U+00E8 "è" */
    0x0, 0x3f, 0x70, 0x0, 0x0, 0x0, 0x3e, 0x40,
    0x0, 0x0, 0x0, 0x12, 0x0, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+00E9 "é" */
    0x0, 0x0, 0x2f, 0x90, 0x0, 0x0, 0xc, 0x80,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+00EA "ê" */
    0x0, 0x9, 0xfa, 0x0, 0x0, 0x9, 0xb2, 0xba,
    0x0, 0x0, 0x20, 0x0, 0x20, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+00EB "ë" */
    0x0, 0x9b, 0x8, 0xa0, 0x0, 0x4, 0x60, 0x46,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+00EC "ì" */
    0xa, 0xe1, 0x0, 0x8, 0xc0, 0x0, 0x1, 0x0,
    0xa, 0xc0, 0x0, 0xac, 0x0, 0xa, 0xc0, 0x0,
    0xac, 0x0, 0xa, 0xc0, 0x0, 0xac, 0x0, 0xa,
    0xc0, 0x0, 0xac, 0x0, 0xa, 0xc0,

    /* U+00ED "í" */
    0x9, 0xe2, 0x6d, 0x20, 0x10, 0x0, 0xac, 0x0,
    0xac, 0x0, 0xac, 0x0, 0xac, 0x0, 0xac, 0x0,
    0xac, 0x0, 0xac, 0x0, 0xac, 0x0, 0xac, 0x0,

    /* U+00EE "î" */
    0x2, 0xef, 0x30, 0x3d, 0x54, 0xd4, 0x0, 0x0,
    0x1, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0,
    0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xac, 0x0,

    /* U+00EF "ï" */
    0x1f, 0x31, 0xf3, 0x8, 0x10, 0x81, 0x0, 0x0,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0,
    0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xac, 0x0,

    /* U+00F0 "ð" */
    0x0, 0x8, 0x30, 0x35, 0x0, 0x0, 0x8f, 0xce,
    0x60, 0x0, 0x7, 0xff, 0xb0, 0x0, 0x3, 0xc3,
    0x2f, 0x70, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x6,
    0xdf, 0xe9, 0xf6, 0x6, 0xf7, 0x34, 0xbf, 0xa0,
    0xe9, 0x0, 0x0, 0xdc, 0x1f, 0x50, 0x0, 0xa,
    0xc1, 0xf5, 0x0, 0x0, 0xab, 0xd, 0x90, 0x0,
    0xe, 0x70, 0x5f, 0x83, 0x4b, 0xe1, 0x0, 0x5c,
    0xff, 0xa2, 0x0,

    /* U+00F1 "ñ" */
    0x5, 0xfd, 0x42, 0xc0, 0xd, 0x37, 0xff, 0x50,
    0x2, 0x0, 0x1, 0x0, 0xa9, 0x5d, 0xfe, 0x70,
    0xae, 0xc5, 0x39, 0xf4, 0xaf, 0x10, 0x0, 0xe8,
    0xad, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,
    0xac, 0x0, 0x0, 0xc9, 0xac, 0x0, 0x0, 0xc9,

    /* U+00F2 "ò" */
    0x0, 0x1d, 0xc0, 0x0, 0x0, 0x0, 0x1c, 0x80,
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+00F3 "ó" */
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x9, 0xb1,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+00F4 "ô" */
    0x0, 0x4, 0xfd, 0x10, 0x0, 0x4, 0xd3, 0x7d,
    0x10, 0x0, 0x20, 0x0, 0x11, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+00F5 "õ" */
    0x0, 0x6f, 0xc3, 0x3b, 0x0, 0xd, 0x37, 0xff,
    0x40, 0x0, 0x20, 0x1, 0x10, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+00F6 "ö" */
    0x0, 0x4e, 0x4, 0xe0, 0x0, 0x2, 0x80, 0x28,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+00F7 "÷" */
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x3f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x50, 0x22,
    0x22, 0x22, 0x20, 0x0, 0x3, 0xe4, 0x0, 0x0,
    0x0, 0x3f, 0x40, 0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xcf, 0xea,
    0xe4, 0x4, 0xf9, 0x45, 0xff, 0x0, 0xdb, 0x0,
    0x6e, 0xf7, 0xf, 0x60, 0x2f, 0x4b, 0xb1, 0xf5,
    0xc, 0x80, 0xac, 0xf, 0x68, 0xd0, 0xb, 0xb0,
    0xcd, 0xf2, 0x1, 0xf7, 0x4, 0xfc, 0x34, 0xce,
    0x10, 0x9c, 0xcf, 0xfa, 0x20, 0x1, 0x10, 0x0,
    0x0, 0x0,

    /* U+00F9 "ù" */
    0x0, 0xbd, 0x0, 0x0, 0x0, 0xa, 0xa0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xac, 0x0, 0x2, 0xf8,
    0x6f, 0x50, 0x2c, 0xf8, 0x8, 0xef, 0xd6, 0xb8,

    /* U+00FA "ú" */
    0x0, 0x0, 0xbd, 0x10, 0x0, 0x8, 0xb1, 0x0,
    0x0, 0x1, 0x0, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xac, 0x0, 0x2, 0xf8,
    0x6f, 0x50, 0x2c, 0xf8, 0x8, 0xef, 0xd6, 0xb8,

    /* U+00FB "û" */
    0x0, 0x4f, 0xe2, 0x0, 0x4, 0xd3, 0x5d, 0x30,
    0x1, 0x0, 0x0, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xac, 0x0, 0x2, 0xf8,
    0x6f, 0x50, 0x2c, 0xf8, 0x8, 0xef, 0xd6, 0xb8,

    /* U+00FC "ü" */
    0x3, 0xf1, 0x3f, 0x10, 0x1, 0x80, 0x18, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xac, 0x0, 0x2, 0xf8,
    0x6f, 0x50, 0x2c, 0xf8, 0x8, 0xef, 0xd6, 0xb8,

    /* U+00FD "ý" */
    0x0, 0x0, 0x9e, 0x20, 0x0, 0x0, 0x6d, 0x20,
    0x0, 0x0, 0x1, 0x0, 0x0, 0xc, 0xb0, 0x0,
    0x8, 0xf0, 0x6f, 0x10, 0x0, 0xd9, 0x1, 0xf6,
    0x0, 0x3f, 0x40, 0xa, 0xc0, 0x9, 0xe0, 0x0,
    0x4f, 0x20, 0xe8, 0x0, 0x0, 0xe8, 0x3f, 0x20,
    0x0, 0x8, 0xd8, 0xd0, 0x0, 0x0, 0x2f, 0xe7,
    0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x34,
    0xcd, 0x0, 0x0, 0xc, 0xfc, 0x20, 0x0, 0x0,

    /* U+00FE "þ" */
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x6d, 0xfd, 0x50,
    0xae, 0xc4, 0x4a, 0xf3, 0xaf, 0x10, 0x0, 0xdb,
    0xad, 0x0, 0x0, 0x9e, 0xac, 0x0, 0x0, 0x8f,
    0xad, 0x0, 0x0, 0x9e, 0xaf, 0x10, 0x0, 0xda,
    0xaf, 0xc4, 0x3a, 0xf3, 0xab, 0x6d, 0xfd, 0x40,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,

    /* U+00FF "ÿ" */
    0x1, 0xe3, 0x1e, 0x30, 0x0, 0x8, 0x10, 0x81,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xb0, 0x0,
    0x8, 0xf0, 0x6f, 0x10, 0x0, 0xd9, 0x1, 0xf6,
    0x0, 0x3f, 0x40, 0xa, 0xc0, 0x9, 0xe0, 0x0,
    0x4f, 0x20, 0xe8, 0x0, 0x0, 0xe8, 0x3f, 0x20,
    0x0, 0x8, 0xd8, 0xd0, 0x0, 0x0, 0x2f, 0xe7,
    0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x34,
    0xcd, 0x0, 0x0, 0xc, 0xfc, 0x20, 0x0, 0x0,

    /* U+0103 "ă" */
    0x0, 0xd2, 0x3, 0xd0, 0x0, 0x5f, 0xff, 0x40,
    0x0, 0x0, 0x20, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+0105 "ą" */
    0x1, 0x9e, 0xfe, 0x90, 0x0, 0x1b, 0x53, 0x7f,
    0x60, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0xb, 0xb0, 0x2, 0x9d, 0xee, 0xfb, 0x0, 0xec,
    0x41, 0x1c, 0xb0, 0x3f, 0x30, 0x0, 0xdb, 0x1,
    0xf8, 0x1, 0x8f, 0xb0, 0x6, 0xef, 0xe7, 0x7b,
    0x0, 0x0, 0x0, 0xc, 0x40, 0x0, 0x0, 0x6,
    0xb0, 0x0, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x0,
    0x3, 0xef, 0x10,

    /* U+0107 "ć" */
    0x0, 0x0, 0x2f, 0x90, 0x0, 0x0, 0xd8, 0x0,
    0x0, 0x0, 0x20, 0x0, 0x0, 0x4c, 0xff, 0xb0,
    0x4, 0xfa, 0x45, 0x70, 0xd, 0xb0, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0x5, 0xf9, 0x45, 0x90, 0x0, 0x5c, 0xff, 0xb0,

    /* U+010C "Č" */
    0x0, 0x4, 0x50, 0x4, 0x50, 0x0, 0x0, 0xd9,
    0x7e, 0x10, 0x0, 0x0, 0x1e, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbe, 0xfe,
    0xb4, 0x0, 0x6f, 0xc6, 0x56, 0xb3, 0x2, 0xfa,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xe,
    0xa0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0,
    0x0, 0x4, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xc6, 0x56, 0x92, 0x0, 0x5, 0xcf, 0xfe, 0xb1,

    /* U+010D "č" */
    0x0, 0xb8, 0x8, 0xc1, 0x0, 0xb, 0xec, 0x0,
    0x0, 0x0, 0x30, 0x0, 0x0, 0x4c, 0xff, 0xb0,
    0x4, 0xfa, 0x45, 0x70, 0xd, 0xb0, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0,
    0x5, 0xf9, 0x45, 0x90, 0x0, 0x5c, 0xff, 0xb0,

    /* U+010F "ď" */
    0x0, 0x0, 0x0, 0xe, 0x77, 0xe0, 0x0, 0x0,
    0x0, 0xe, 0x7a, 0x70, 0x0, 0x0, 0x0, 0xe,
    0x78, 0x0, 0x0, 0x6e, 0xfd, 0x4e, 0x70, 0x0,
    0x6, 0xf8, 0x35, 0xdf, 0x70, 0x0, 0xd, 0xb0,
    0x0, 0x3f, 0x70, 0x0, 0x1f, 0x60, 0x0, 0xf,
    0x70, 0x0, 0x1f, 0x50, 0x0, 0xe, 0x70, 0x0,
    0x1f, 0x60, 0x0, 0xf, 0x70, 0x0, 0xd, 0xb0,
    0x0, 0x3f, 0x70, 0x0, 0x6, 0xf8, 0x35, 0xdf,
    0x70, 0x0, 0x0, 0x7e, 0xfd, 0x4b, 0x70, 0x0,

    /* U+0110 "Đ" */
    0x5, 0xff, 0xff, 0xd9, 0x10, 0x0, 0x5f, 0x54,
    0x58, 0xee, 0x30, 0x5, 0xf1, 0x0, 0x1, 0xdd,
    0x0, 0x5f, 0x10, 0x0, 0x4, 0xf5, 0x5, 0xf1,
    0x0, 0x0, 0xf, 0x90, 0x6f, 0x20, 0x0, 0x0,
    0xda, 0x8f, 0xff, 0xff, 0x0, 0xd, 0xa1, 0x7f,
    0x53, 0x30, 0x0, 0xf8, 0x5, 0xf1, 0x0, 0x0,
    0x4f, 0x40, 0x5f, 0x10, 0x0, 0x1d, 0xd0, 0x5,
    0xf5, 0x45, 0x8f, 0xe2, 0x0, 0x5f, 0xff, 0xfc,
    0x70, 0x0,

    /* U+0111 "đ" */
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x5, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x22, 0x2e, 0x81, 0x0,
    0x7e, 0xfd, 0x4e, 0x70, 0x6, 0xf8, 0x35, 0xdf,
    0x70, 0xd, 0xb0, 0x0, 0x3f, 0x70, 0x1f, 0x70,
    0x0, 0xf, 0x70, 0x1f, 0x50, 0x0, 0xe, 0x70,
    0x1f, 0x60, 0x0, 0xf, 0x70, 0xd, 0xb0, 0x0,
    0x3f, 0x70, 0x6, 0xf8, 0x35, 0xcf, 0x70, 0x0,
    0x7e, 0xfc, 0x4c, 0x70,

    /* U+0119 "ę" */
    0x0, 0x4d, 0xfe, 0x70, 0x0, 0x4f, 0x93, 0x6f,
    0x70, 0xc, 0xc0, 0x0, 0x8e, 0x0, 0xf7, 0x0,
    0x4, 0xf2, 0x1f, 0xff, 0xff, 0xff, 0x30, 0xf7,
    0x22, 0x22, 0x20, 0xc, 0xa0, 0x0, 0x0, 0x0,
    0x4f, 0xa4, 0x46, 0x80, 0x0, 0x4c, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0, 0xc,
    0x50, 0x0, 0x0, 0x0, 0xe5, 0x0, 0x0, 0x0,
    0x7, 0xfa, 0x0,

    /* U+011B "ě" */
    0x0, 0xb8, 0x8, 0xc1, 0x0, 0x0, 0xbe, 0xc0,
    0x0, 0x0, 0x0, 0x31, 0x0, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+011F "ğ" */
    0x0, 0xa6, 0x1, 0xd2, 0x0, 0x3, 0xef, 0xf8,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x6, 0xef,
    0xd4, 0xb7, 0x5, 0xf9, 0x35, 0xdf, 0x70, 0xdb,
    0x0, 0x3, 0xf7, 0xf, 0x60, 0x0, 0xf, 0x71,
    0xf5, 0x0, 0x0, 0xe7, 0xf, 0x60, 0x0, 0xf,
    0x70, 0xdb, 0x0, 0x2, 0xf7, 0x6, 0xf8, 0x34,
    0xdf, 0x70, 0x7, 0xef, 0xd4, 0xe7, 0x0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x2, 0xf5, 0x6,
    0x84, 0x35, 0xdd, 0x0, 0x3c, 0xef, 0xea, 0x20,

    /* U+0131 "ı" */
    0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac,
    0xac,

    /* U+013E "ľ" */
    0xac, 0x1f, 0x4a, 0xc4, 0xd0, 0xac, 0x54, 0xa,
    0xc0, 0x0, 0xac, 0x0, 0xa, 0xc0, 0x0, 0xac,
    0x0, 0xa, 0xc0, 0x0, 0xac, 0x0, 0xa, 0xc0,
    0x0, 0xac, 0x0, 0xa, 0xc0, 0x0,

    /* U+0141 "Ł" */
    0x7, 0xf0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0,
    0x7, 0xf0, 0x54, 0x0, 0x7, 0xfb, 0xf6, 0x0,
    0xa, 0xfa, 0x10, 0x0, 0x9f, 0xf0, 0x0, 0x0,
    0x17, 0xf0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0,
    0x7, 0xf5, 0x55, 0x54, 0x7, 0xff, 0xff, 0xff,

    /* U+0142 "ł" */
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xca, 0x20, 0x0,
    0xcf, 0xe1, 0x5, 0xed, 0x10, 0xc, 0xea, 0x0,
    0x0, 0xca, 0x0, 0x0, 0xca, 0x0, 0x0, 0xca,
    0x0, 0x0, 0xca, 0x0,

    /* U+0151 "ő" */
    0x0, 0xd, 0xa1, 0xf7, 0x0, 0x7, 0xd1, 0x9b,
    0x0, 0x0, 0x91, 0x18, 0x0, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+0159 "ř" */
    0x7b, 0x14, 0xd3, 0x7, 0xee, 0x20, 0x0, 0x21,
    0x0, 0xa8, 0x3d, 0xf4, 0xac, 0xe7, 0x51, 0xaf,
    0x40, 0x0, 0xad, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0,
    0x0, 0xac, 0x0, 0x0,

    /* U+015B "ś" */
    0x0, 0x0, 0xcc, 0x0, 0x0, 0x9b, 0x10, 0x0,
    0x2, 0x0, 0x0, 0x3c, 0xff, 0xd6, 0xf, 0xa3,
    0x37, 0x42, 0xf4, 0x0, 0x0, 0xc, 0xe7, 0x10,
    0x0, 0x7, 0xdf, 0x91, 0x0, 0x0, 0x5e, 0xb0,
    0x0, 0x0, 0x7e, 0x29, 0x43, 0x4d, 0xb1, 0xbe,
    0xfe, 0x91,

    /* U+015E "Ş" */
    0x0, 0x8e, 0xff, 0xc5, 0x0, 0x9f, 0x85, 0x6a,
    0x60, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0xb, 0xe4, 0x0, 0x0, 0x0, 0x1b,
    0xfd, 0x60, 0x0, 0x0, 0x4, 0xaf, 0xd2, 0x0,
    0x0, 0x0, 0x2e, 0xc0, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0x8, 0xe0, 0x2b, 0x75, 0x59,
    0xf7, 0x1, 0xae, 0xff, 0xc6, 0x0, 0x0, 0x8,
    0x80, 0x0, 0x0, 0x0, 0x5d, 0x70, 0x0, 0x0,
    0x0, 0x8a, 0x0, 0x0, 0x6, 0xed, 0x30, 0x0,

    /* U+015F "ş" */
    0x3, 0xcf, 0xfd, 0x60, 0xfa, 0x33, 0x74, 0x2f,
    0x40, 0x0, 0x0, 0xce, 0x71, 0x0, 0x0, 0x7d,
    0xf9, 0x10, 0x0, 0x5, 0xeb, 0x0, 0x0, 0x7,
    0xe2, 0x94, 0x34, 0xdb, 0x1b, 0xef, 0xf9, 0x10,
    0x0, 0xc3, 0x0, 0x0, 0x8, 0xe3, 0x0, 0x0,
    0xc, 0x60, 0x0, 0xae, 0xb0, 0x0,

    /* U+0161 "š" */
    0x7, 0xb1, 0x4d, 0x30, 0x7, 0xee, 0x20, 0x0,
    0x2, 0x10, 0x0, 0x3c, 0xff, 0xd6, 0xf, 0xa3,
    0x37, 0x42, 0xf4, 0x0, 0x0, 0xc, 0xe7, 0x10,
    0x0, 0x7, 0xdf, 0x91, 0x0, 0x0, 0x5e, 0xb0,
    0x0, 0x0, 0x7e, 0x29, 0x43, 0x4d, 0xb1, 0xbe,
    0xfe, 0x91,

    /* U+0165 "ť" */
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x40, 0x2, 0xf0,
    0x4, 0xe0, 0x3, 0x50, 0x8f, 0xff, 0xf5, 0x0,
    0x19, 0xe2, 0x20, 0x0, 0x8, 0xe0, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x8, 0xe0, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x8, 0xe0, 0x0, 0x0,
    0x5, 0xf7, 0x32, 0x0, 0x0, 0x9f, 0xf5, 0x0,

    /* U+016F "ů" */
    0x0, 0x4c, 0xc2, 0x0, 0x0, 0xc2, 0x4a, 0x0,
    0x0, 0xb2, 0x5a, 0x0, 0x0, 0x3c, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xac, 0x0, 0x2, 0xf8,
    0x6f, 0x50, 0x2c, 0xf8, 0x8, 0xef, 0xd6, 0xb8,

    /* U+017A "ź" */
    0x0, 0x0, 0xdb, 0x0, 0x0, 0xb9, 0x0, 0x0,
    0x1, 0x0, 0x1, 0xff, 0xff, 0xfc, 0x2, 0x22,
    0x3f, 0x80, 0x0, 0xa, 0xd0, 0x0, 0x5, 0xf3,
    0x0, 0x1, 0xe7, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x5f, 0x20, 0x0, 0x1e, 0x92, 0x22, 0x16, 0xff,
    0xff, 0xfe,

    /* U+017C "ż" */
    0x0, 0xe, 0x60, 0x0, 0x0, 0xb5, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xfc, 0x2, 0x22,
    0x3f, 0x80, 0x0, 0xa, 0xd0, 0x0, 0x5, 0xf3,
    0x0, 0x1, 0xe7, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x5f, 0x20, 0x0, 0x1e, 0x92, 0x22, 0x16, 0xff,
    0xff, 0xfe,

    /* U+017E "ž" */
    0x8, 0xb1, 0x6d, 0x20, 0x7, 0xfd, 0x10, 0x0,
    0x1, 0x0, 0x1, 0xff, 0xff, 0xfc, 0x2, 0x22,
    0x3f, 0x80, 0x0, 0xa, 0xd0, 0x0, 0x5, 0xf3,
    0x0, 0x1, 0xe7, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x5f, 0x20, 0x0, 0x1e, 0x92, 0x22, 0x16, 0xff,
    0xff, 0xfe,

    /* U+01B0 "ư" */
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x3b, 0xb0, 0x0,
    0xe, 0x8a, 0xd0, 0xbb, 0x0, 0x0, 0xef, 0xc2,
    0xb, 0xb0, 0x0, 0xe, 0x80, 0x0, 0xbb, 0x0,
    0x0, 0xe8, 0x0, 0xb, 0xb0, 0x0, 0xe, 0x80,
    0x0, 0xbb, 0x0, 0x0, 0xe8, 0x0, 0xa, 0xc0,
    0x0, 0x2f, 0x80, 0x0, 0x6f, 0x50, 0x2c, 0xf8,
    0x0, 0x0, 0x8e, 0xfd, 0x6b, 0x80, 0x0,

    /* U+0219 "ș" */
    0x3, 0xcf, 0xfd, 0x60, 0xfa, 0x33, 0x74, 0x2f,
    0x40, 0x0, 0x0, 0xce, 0x71, 0x0, 0x0, 0x7d,
    0xf9, 0x10, 0x0, 0x5, 0xeb, 0x0, 0x0, 0x7,
    0xe2, 0x94, 0x34, 0xdb, 0x1b, 0xef, 0xe9, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x80, 0x0, 0x0,
    0xc7, 0x0, 0x0, 0x1d, 0x0, 0x0,

    /* U+021B "ț" */
    0x0, 0x60, 0x0, 0x5, 0xe0, 0x0, 0x8f, 0xff,
    0xf5, 0x19, 0xe2, 0x20, 0x8, 0xe0, 0x0, 0x8,
    0xe0, 0x0, 0x8, 0xe0, 0x0, 0x8, 0xe0, 0x0,
    0x8, 0xe0, 0x0, 0x5, 0xf7, 0x32, 0x0, 0x9f,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xa, 0x40, 0x0,
    0x2f, 0x10, 0x0, 0x78, 0x0,

    /* U+0388 "Έ" */
    0x3f, 0x60, 0xdf, 0xff, 0xff, 0x98, 0xd0, 0xd,
    0xb4, 0x44, 0x42, 0x94, 0x0, 0xd9, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xda, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0xdb, 0x33, 0x33, 0x10, 0x0,
    0xd, 0x90, 0x0, 0x0, 0x0, 0x0, 0xd9, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xdb, 0x44, 0x44, 0x20, 0x0, 0xd, 0xff,
    0xff, 0xf9,

    /* U+0391 "Α" */
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf5, 0x0, 0x0, 0x0, 0x7, 0xda, 0xb0, 0x0,
    0x0, 0x0, 0xd8, 0x5f, 0x10, 0x0, 0x0, 0x3f,
    0x20, 0xe6, 0x0, 0x0, 0x9, 0xd0, 0x9, 0xc0,
    0x0, 0x0, 0xe8, 0x11, 0x4f, 0x20, 0x0, 0x5f,
    0xff, 0xff, 0xf8, 0x0, 0xb, 0xc4, 0x44, 0x4a,
    0xe0, 0x1, 0xf5, 0x0, 0x0, 0x3f, 0x40, 0x7f,
    0x0, 0x0, 0x0, 0xda, 0xd, 0xa0, 0x0, 0x0,
    0x7, 0xf0,

    /* U+0392 "Β" */
    0x7f, 0xff, 0xfd, 0x91, 0x7, 0xf4, 0x44, 0x7f,
    0xd0, 0x7f, 0x0, 0x0, 0x7f, 0x27, 0xf0, 0x0,
    0x6, 0xf1, 0x7f, 0x0, 0x3, 0xd9, 0x7, 0xff,
    0xff, 0xf9, 0x0, 0x7f, 0x33, 0x36, 0xdc, 0x7,
    0xf0, 0x0, 0x2, 0xf6, 0x7f, 0x0, 0x0, 0xf,
    0x87, 0xf0, 0x0, 0x3, 0xf6, 0x7f, 0x44, 0x46,
    0xee, 0x17, 0xff, 0xff, 0xea, 0x20,

    /* U+0393 "Γ" */
    0x7f, 0xff, 0xff, 0x97, 0xf4, 0x44, 0x42, 0x7f,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0,

    /* U+0395 "Ε" */
    0x7f, 0xff, 0xff, 0xf7, 0xf4, 0x44, 0x44, 0x7f,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xfa, 0x7f, 0x33, 0x33,
    0x27, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x44, 0x44, 0x47, 0xff,
    0xff, 0xff,

    /* U+0397 "Η" */
    0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f, 0x0, 0x0,
    0x2, 0xf4, 0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f,
    0x0, 0x0, 0x2, 0xf4, 0x7f, 0x11, 0x11, 0x13,
    0xf4, 0x7f, 0xff, 0xff, 0xff, 0xf4, 0x7f, 0x44,
    0x44, 0x45, 0xf4, 0x7f, 0x0, 0x0, 0x2, 0xf4,
    0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f, 0x0, 0x0,
    0x2, 0xf4, 0x7f, 0x0, 0x0, 0x2, 0xf4, 0x7f,
    0x0, 0x0, 0x2, 0xf4,

    /* U+039B "Λ" */
    0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x4, 0xff,
    0x10, 0x0, 0x0, 0xa, 0x9e, 0x60, 0x0, 0x0,
    0xf, 0x48, 0xb0, 0x0, 0x0, 0x5f, 0x3, 0xf1,
    0x0, 0x0, 0xba, 0x0, 0xe7, 0x0, 0x1, 0xf4,
    0x0, 0x9c, 0x0, 0x6, 0xf0, 0x0, 0x3f, 0x20,
    0xc, 0xa0, 0x0, 0xe, 0x80, 0x2f, 0x40, 0x0,
    0x9, 0xd0, 0x7e, 0x0, 0x0, 0x4, 0xf3, 0xd9,
    0x0, 0x0, 0x0, 0xe8,

    /* U+039C "Μ" */
    0x7f, 0xd0, 0x0, 0x0, 0x5, 0xff, 0x7f, 0xf3,
    0x0, 0x0, 0xb, 0xef, 0x7d, 0xd9, 0x0, 0x0,
    0x1f, 0xaf, 0x7d, 0x8e, 0x0, 0x0, 0x6d, 0x7f,
    0x7d, 0x2f, 0x40, 0x0, 0xc7, 0x7f, 0x7e, 0xc,
    0xa0, 0x2, 0xf2, 0x7f, 0x7e, 0x6, 0xf0, 0x8,
    0xc0, 0x7f, 0x7e, 0x1, 0xf5, 0xe, 0x60, 0x7f,
    0x7e, 0x0, 0xab, 0x4f, 0x10, 0x7f, 0x7e, 0x0,
    0x5f, 0xbb, 0x0, 0x7f, 0x7e, 0x0, 0xe, 0xf5,
    0x0, 0x7f, 0x7e, 0x0, 0x9, 0xe0, 0x0, 0x7f,

    /* U+039D "Ν" */
    0x7f, 0x80, 0x0, 0x0, 0xb9, 0x7f, 0xf2, 0x0,
    0x0, 0xb9, 0x7d, 0xdc, 0x0, 0x0, 0xb9, 0x7d,
    0x4f, 0x60, 0x0, 0xb9, 0x7d, 0xa, 0xf1, 0x0,
    0xb9, 0x7e, 0x1, 0xfa, 0x0, 0xb9, 0x7e, 0x0,
    0x7f, 0x40, 0xb9, 0x7e, 0x0, 0xd, 0xd0, 0xb9,
    0x7e, 0x0, 0x3, 0xf8, 0xa9, 0x7e, 0x0, 0x0,
    0x9f, 0xd9, 0x7e, 0x0, 0x0, 0x1e, 0xf9, 0x7e,
    0x0, 0x0, 0x6, 0xf9,

    /* U+039F "Ο" */
    0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0, 0x0, 0x8f,
    0xa5, 0x57, 0xee, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x1e, 0xb0, 0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2,
    0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xf7, 0xf, 0x80, 0x0, 0x0,
    0x0, 0xf7, 0xe, 0xa0, 0x0, 0x0, 0x2, 0xf6,
    0xa, 0xe0, 0x0, 0x0, 0x6, 0xf2, 0x4, 0xf7,
    0x0, 0x0, 0x1e, 0xb0, 0x0, 0x9f, 0xa5, 0x57,
    0xee, 0x20, 0x0, 0x5, 0xcf, 0xfe, 0x91, 0x0,

    /* U+03A0 "Π" */
    0x7f, 0xff, 0xff, 0xff, 0xf2, 0x7f, 0x44, 0x44,
    0x48, 0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f,
    0x0, 0x0, 0x4, 0xf2, 0x7f, 0x0, 0x0, 0x4,
    0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f, 0x0,
    0x0, 0x4, 0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2,
    0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f, 0x0, 0x0,
    0x4, 0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f,
    0x0, 0x0, 0x4, 0xf2,

    /* U+03A3 "Σ" */
    0x3f, 0xff, 0xff, 0xff, 0x51, 0xee, 0x55, 0x55,
    0x51, 0x3, 0xf9, 0x0, 0x0, 0x0, 0x6, 0xf5,
    0x0, 0x0, 0x0, 0xa, 0xf3, 0x0, 0x0, 0x0,
    0xd, 0xd0, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x0, 0xda, 0x0, 0x0, 0x0, 0xad, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x2f, 0xa5, 0x55,
    0x55, 0x26, 0xff, 0xff, 0xff, 0xf8,

    /* U+03A4 "Τ" */
    0xdf, 0xff, 0xff, 0xff, 0xb4, 0x44, 0x7f, 0x64,
    0x43, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0, 0x4f,
    0x20, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x0, 0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0x20, 0x0,

    /* U+03A6 "Φ" */
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x2,
    0x9e, 0xff, 0xff, 0xc6, 0x0, 0x3, 0xfd, 0x63,
    0xf9, 0x49, 0xfa, 0x0, 0xcc, 0x0, 0xf, 0x70,
    0x5, 0xf4, 0x1f, 0x60, 0x0, 0xf7, 0x0, 0xe,
    0x92, 0xf4, 0x0, 0xf, 0x70, 0x0, 0xca, 0x1f,
    0x60, 0x0, 0xf7, 0x0, 0xe, 0x90, 0xdc, 0x0,
    0xf, 0x70, 0x4, 0xf4, 0x4, 0xfb, 0x30, 0xf7,
    0x16, 0xfb, 0x0, 0x3, 0xcf, 0xff, 0xff, 0xe8,
    0x0, 0x0, 0x0, 0x12, 0xf8, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0,

    /* U+03A7 "Χ" */
    0x6f, 0x30, 0x0, 0xc, 0xb0, 0xc, 0xc0, 0x0,
    0x6f, 0x20, 0x2, 0xf6, 0x1, 0xe8, 0x0, 0x0,
    0x8e, 0x19, 0xd0, 0x0, 0x0, 0xe, 0xbf, 0x40,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x9,
    0xfe, 0x10, 0x0, 0x0, 0x3f, 0x4e, 0x90, 0x0,
    0x0, 0xca, 0x5, 0xf3, 0x0, 0x6, 0xf1, 0x0,
    0xcc, 0x0, 0x1f, 0x70, 0x0, 0x3f, 0x60, 0xad,
    0x0, 0x0, 0x9, 0xe1,

    /* U+03AC "ά" */
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0x0, 0x86, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xfd, 0x4b,
    0x70, 0x6, 0xf8, 0x35, 0xdf, 0x70, 0xd, 0xb0,
    0x0, 0x4f, 0x70, 0xf, 0x60, 0x0, 0xf, 0x70,
    0x1f, 0x50, 0x0, 0xe, 0x70, 0xf, 0x60, 0x0,
    0xf, 0x70, 0xd, 0xb0, 0x0, 0x3f, 0x70, 0x6,
    0xf8, 0x35, 0xde, 0xb2, 0x0, 0x6e, 0xfc, 0x46,
    0xf8,

    /* U+03AD "έ" */
    0x0, 0x0, 0x8f, 0x20, 0x0, 0xd, 0x80, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xbf,
    0xfd, 0x80, 0xcd, 0x43, 0x68, 0xf, 0x60, 0x0,
    0x0, 0xbb, 0x10, 0x0, 0x1, 0xdf, 0xf6, 0x0,
    0xdb, 0x32, 0x10, 0x4f, 0x30, 0x0, 0x1, 0xfb,
    0x54, 0x57, 0x3, 0xcf, 0xfe, 0x90,

    /* U+03AE "ή" */
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x1f, 0x40, 0x0,
    0x0, 0x4a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa9, 0x7e, 0xfd, 0x50, 0xaf, 0xb2, 0x19, 0xf2,
    0xaf, 0x0, 0x0, 0xf6, 0xad, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0xf7,

    /* U+03AF "ί" */
    0x9, 0xf1, 0xd, 0x80, 0x1c, 0x0, 0x0, 0x0,
    0xbb, 0x0, 0xbb, 0x0, 0xbb, 0x0, 0xbb, 0x0,
    0xbb, 0x0, 0xbb, 0x0, 0xab, 0x0, 0x8f, 0x44,
    0x1b, 0xfe,

    /* U+03B1 "α" */
    0x0, 0x6e, 0xfd, 0x4b, 0x70, 0x6, 0xf8, 0x35,
    0xdf, 0x70, 0xd, 0xb0, 0x0, 0x4f, 0x70, 0xf,
    0x60, 0x0, 0xf, 0x70, 0x1f, 0x50, 0x0, 0xe,
    0x70, 0xf, 0x60, 0x0, 0xf, 0x70, 0xd, 0xb0,
    0x0, 0x3f, 0x70, 0x6, 0xf8, 0x35, 0xde, 0xb2,
    0x0, 0x6e, 0xfc, 0x46, 0xf8,

    /* U+03B2 "β" */
    0x3, 0xbf, 0xfc, 0x30, 0x1e, 0xb4, 0x4d, 0xe0,
    0x7f, 0x0, 0x3, 0xf5, 0x9c, 0x0, 0x0, 0xf6,
    0xac, 0x0, 0x2, 0xf4, 0xac, 0x0, 0xb, 0xb0,
    0xac, 0x2f, 0xfb, 0x10, 0xac, 0x2, 0x38, 0xe2,
    0xac, 0x0, 0x0, 0xbb, 0xac, 0x0, 0x0, 0x8e,
    0xac, 0x0, 0x0, 0xad, 0xaf, 0x83, 0x39, 0xf6,
    0xae, 0xbf, 0xfd, 0x60, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0,

    /* U+03B3 "γ" */
    0xd9, 0x0, 0x0, 0x9c, 0x7e, 0x0, 0x0, 0xab,
    0x2f, 0x40, 0x0, 0xc9, 0xd, 0x90, 0x0, 0xe6,
    0x7, 0xe0, 0x3, 0xf2, 0x2, 0xf3, 0x9, 0xc0,
    0x0, 0xc9, 0x2f, 0x50, 0x0, 0x7e, 0xcb, 0x0,
    0x0, 0x1f, 0xe1, 0x0, 0x0, 0xe, 0x80, 0x0,
    0x0, 0xe, 0x80, 0x0, 0x0, 0xe, 0x80, 0x0,
    0x0, 0x7, 0x40, 0x0,

    /* U+03B4 "δ" */
    0x0, 0x1a, 0xff, 0xd6, 0x0, 0xa, 0xd4, 0x38,
    0xd0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0xa, 0xe2,
    0x0, 0x0, 0x0, 0x1c, 0xf7, 0x0, 0x0, 0x8,
    0xfa, 0xdc, 0x10, 0x8, 0xe3, 0x0, 0xcc, 0x1,
    0xf7, 0x0, 0x2, 0xf5, 0x3f, 0x30, 0x0, 0xd,
    0x84, 0xf3, 0x0, 0x0, 0xe8, 0x1f, 0x80, 0x0,
    0x3f, 0x40, 0x8f, 0x83, 0x5d, 0xc0, 0x0, 0x6d,
    0xfe, 0x91, 0x0,

    /* U+03B5 "ε" */
    0x2, 0xbf, 0xfd, 0x80, 0xcd, 0x43, 0x68, 0xf,
    0x60, 0x0, 0x0, 0xbb, 0x10, 0x0, 0x1, 0xdf,
    0xf6, 0x0, 0xdb, 0x32, 0x10, 0x4f, 0x30, 0x0,
    0x1, 0xfb, 0x54, 0x57, 0x3, 0xcf, 0xfe, 0x90,

    /* U+03B6 "ζ" */
    0xa, 0xff, 0xff, 0xf4, 0x0, 0x11, 0x1a, 0xd0,
    0x0, 0x0, 0x5f, 0x20, 0x0, 0x2, 0xf6, 0x0,
    0x0, 0xc, 0xb0, 0x0, 0x0, 0x8e, 0x10, 0x0,
    0x2, 0xf5, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x0, 0x6, 0xfd, 0x83, 0x0,
    0x0, 0x39, 0xef, 0xc0, 0x0, 0x0, 0x5, 0xf3,
    0x0, 0x0, 0x3, 0xf2, 0x0, 0x0, 0x8, 0xd0,
    0x0, 0x0, 0x1, 0x0,

    /* U+03B7 "η" */
    0xa9, 0x7e, 0xfd, 0x50, 0xaf, 0xb2, 0x19, 0xf2,
    0xaf, 0x0, 0x0, 0xf6, 0xad, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0xf7,

    /* U+03B8 "θ" */
    0x0, 0x3c, 0xfe, 0x80, 0x0, 0x2f, 0xa4, 0x6f,
    0x80, 0x9, 0xe0, 0x0, 0x6f, 0x10, 0xd9, 0x0,
    0x1, 0xf5, 0xf, 0x60, 0x0, 0xe, 0x81, 0xf5,
    0x0, 0x0, 0xd9, 0x1f, 0xff, 0xff, 0xff, 0xa1,
    0xf6, 0x22, 0x22, 0xd9, 0xf, 0x60, 0x0, 0xd,
    0x80, 0xd8, 0x0, 0x0, 0xf5, 0x8, 0xd0, 0x0,
    0x5f, 0x10, 0x1e, 0xa3, 0x5e, 0x90, 0x0, 0x2c,
    0xfe, 0x80, 0x0,

    /* U+03B9 "ι" */
    0xbb, 0x0, 0xbb, 0x0, 0xbb, 0x0, 0xbb, 0x0,
    0xbb, 0x0, 0xbb, 0x0, 0xab, 0x0, 0x8f, 0x44,
    0x1b, 0xfe,

    /* U+03BA "κ" */
    0xad, 0x0, 0x1e, 0xb0, 0xad, 0x0, 0xbd, 0x10,
    0xad, 0x9, 0xf2, 0x0, 0xad, 0x6f, 0x40, 0x0,
    0xae, 0xff, 0x40, 0x0, 0xaf, 0x4b, 0xe1, 0x0,
    0xad, 0x1, 0xea, 0x0, 0xad, 0x0, 0x5f, 0x50,
    0xad, 0x0, 0xa, 0xf1,

    /* U+03BB "λ" */
    0xff, 0xb1, 0x0, 0x0, 0x3, 0x4d, 0xb0, 0x0,
    0x0, 0x0, 0x3f, 0x30, 0x0, 0x0, 0x0, 0xd9,
    0x0, 0x0, 0x0, 0xe, 0xe0, 0x0, 0x0, 0x4,
    0xef, 0x40, 0x0, 0x0, 0xa9, 0xaa, 0x0, 0x0,
    0xf, 0x55, 0xf0, 0x0, 0x5, 0xf0, 0xf, 0x60,
    0x0, 0xab, 0x0, 0xbb, 0x0, 0xf, 0x60, 0x5,
    0xf1, 0x5, 0xf1, 0x0, 0xf, 0x91, 0xbc, 0x0,
    0x0, 0x8f, 0x40,

    /* U+03BC "μ" */
    0xac, 0x0, 0x0, 0xe8, 0xa, 0xc0, 0x0, 0xe,
    0x80, 0xac, 0x0, 0x0, 0xe8, 0xa, 0xc0, 0x0,
    0xe, 0x80, 0xac, 0x0, 0x0, 0xe8, 0xa, 0xc0,
    0x0, 0xf, 0x80, 0xae, 0x0, 0x3, 0xf8, 0xa,
    0xf9, 0x35, 0xde, 0xb2, 0xad, 0xcf, 0xe5, 0x5f,
    0x9a, 0xc0, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x0, 0xa, 0xc0, 0x0, 0x0, 0x0, 0xac, 0x0,
    0x0, 0x0, 0x0,

    /* U+03BD "ν" */
    0xd9, 0x0, 0x0, 0x9c, 0x7e, 0x0, 0x0, 0xab,
    0x2f, 0x40, 0x0, 0xc9, 0xd, 0x90, 0x0, 0xe7,
    0x7, 0xe0, 0x3, 0xf2, 0x2, 0xf3, 0x9, 0xd0,
    0x0, 0xc8, 0x2f, 0x50, 0x0, 0x7e, 0xcb, 0x0,
    0x0, 0x2f, 0xe1, 0x0,

    /* U+03BE "ξ" */
    0xa, 0xff, 0xff, 0xf5, 0x0, 0x8c, 0x62, 0x10,
    0x5, 0xe1, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0,
    0x4, 0xf6, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xf1,
    0x2, 0xe9, 0x32, 0x20, 0xc, 0xa0, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x0,
    0xe, 0xd2, 0x0, 0x0, 0x3, 0xff, 0xb6, 0x10,
    0x0, 0x17, 0xcf, 0xe0, 0x0, 0x0, 0x4, 0xf3,
    0x0, 0x0, 0x3, 0xf2, 0x0, 0x0, 0x9, 0xd0,
    0x0, 0x0, 0x1, 0x0,

    /* U+03BF "ο" */
    0x0, 0x4c, 0xff, 0xa1, 0x0, 0x4f, 0x94, 0x4c,
    0xe1, 0xd, 0xb0, 0x0, 0x1f, 0x70, 0xf6, 0x0,
    0x0, 0xbb, 0x1f, 0x50, 0x0, 0xa, 0xc0, 0xf6,
    0x0, 0x0, 0xbb, 0xc, 0xb0, 0x0, 0x1f, 0x70,
    0x3f, 0x93, 0x4c, 0xe1, 0x0, 0x4c, 0xff, 0xa2,
    0x0,

    /* U+03C0 "π" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0x11, 0x2f, 0x72,
    0x22, 0xf7, 0x20, 0x0, 0xf6, 0x0, 0xf, 0x60,
    0x0, 0xf, 0x60, 0x0, 0xf6, 0x0, 0x0, 0xf6,
    0x0, 0xf, 0x60, 0x0, 0xf, 0x60, 0x0, 0xf6,
    0x0, 0x0, 0xf6, 0x0, 0xf, 0x60, 0x0, 0xf,
    0x60, 0x0, 0xea, 0x30, 0x0, 0xf6, 0x0, 0x6,
    0xfc, 0x0,

    /* U+03C1 "ρ" */
    0x3, 0xcf, 0xea, 0x10, 0x2f, 0xa4, 0x5d, 0xd0,
    0x9d, 0x0, 0x2, 0xf6, 0xc9, 0x0, 0x0, 0xda,
    0xd8, 0x0, 0x0, 0xbb, 0xe8, 0x0, 0x0, 0xda,
    0xe8, 0x0, 0x2, 0xf6, 0xee, 0x73, 0x4d, 0xd0,
    0xeb, 0xcf, 0xfa, 0x10, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0,

    /* U+03C2 "ς" */
    0x0, 0x4c, 0xff, 0xc0, 0x4, 0xfa, 0x45, 0x70,
    0xc, 0xb0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x0,
    0xd, 0xc0, 0x0, 0x0, 0x5, 0xfb, 0x30, 0x0,
    0x0, 0x4d, 0xfe, 0x80, 0x0, 0x0, 0x29, 0xf3,
    0x0, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x3, 0x20,

    /* U+03C3 "σ" */
    0x0, 0x3b, 0xef, 0xff, 0xf5, 0x4, 0xfa, 0x32,
    0xbc, 0x20, 0xc, 0xb0, 0x0, 0x2f, 0x40, 0xf,
    0x60, 0x0, 0xe, 0x80, 0x1f, 0x40, 0x0, 0xc,
    0xa0, 0x1f, 0x60, 0x0, 0xd, 0x80, 0xd, 0xa0,
    0x0, 0x2f, 0x40, 0x5, 0xf8, 0x35, 0xdc, 0x0,
    0x0, 0x5d, 0xfe, 0x90, 0x0,

    /* U+03C4 "τ" */
    0xcf, 0xff, 0xff, 0xf5, 0x12, 0x8f, 0x22, 0x20,
    0x0, 0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x0, 0x6f, 0x0, 0x0, 0x0, 0x3f, 0x93, 0x30,
    0x0, 0x7, 0xef, 0xb0,

    /* U+03C5 "υ" */
    0xba, 0x0, 0x5, 0xf1, 0xba, 0x0, 0x2, 0xf4,
    0xba, 0x0, 0x0, 0xf6, 0xba, 0x0, 0x0, 0xf7,
    0xba, 0x0, 0x0, 0xf7, 0xbb, 0x0, 0x1, 0xf5,
    0xad, 0x0, 0x6, 0xf1, 0x5f, 0x73, 0x6f, 0x90,
    0x8, 0xef, 0xe8, 0x0,

    /* U+03C6 "φ" */
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0x0, 0xe, 0x80, 0x0,
    0x0, 0x0, 0x3, 0xea, 0x20, 0x0, 0x0, 0x6e,
    0xff, 0xff, 0xb1, 0x0, 0x5f, 0x70, 0xe8, 0x2c,
    0xd0, 0xd, 0xa0, 0xe, 0x80, 0x1f, 0x61, 0xf6,
    0x0, 0xe8, 0x0, 0xca, 0x1f, 0x50, 0xe, 0x80,
    0xb, 0xb0, 0xf7, 0x0, 0xe8, 0x0, 0xda, 0xb,
    0xd0, 0xe, 0x80, 0x3f, 0x50, 0x2e, 0xb4, 0xe9,
    0x6e, 0xb0, 0x0, 0x2a, 0xff, 0xfe, 0x70, 0x0,
    0x0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0,

    /* U+03C7 "χ" */
    0x8f, 0x70, 0x0, 0x6, 0xf2, 0x17, 0xf2, 0x0,
    0xe, 0x80, 0x0, 0xd9, 0x0, 0x7e, 0x0, 0x0,
    0x6f, 0x11, 0xe6, 0x0, 0x0, 0xe, 0x88, 0xd0,
    0x0, 0x0, 0x8, 0xff, 0x40, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x1e, 0x9f, 0x50, 0x0, 0x0, 0x9d, 0xa,
    0xd0, 0x0, 0x3, 0xf4, 0x3, 0xf4, 0x0, 0xc,
    0xa0, 0x0, 0xbd, 0x31, 0x6f, 0x20, 0x0, 0x2d,
    0xf5,

    /* U+03C8 "ψ" */
    0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0x0, 0xba,
    0x0, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0,
    0x0, 0xba, 0x0, 0x0, 0xba, 0x0, 0xba, 0x0,
    0xe7, 0xba, 0x0, 0xba, 0x0, 0xba, 0xba, 0x0,
    0xba, 0x0, 0x9c, 0xba, 0x0, 0xba, 0x0, 0x8d,
    0xba, 0x0, 0xba, 0x0, 0x8d, 0xab, 0x0, 0xba,
    0x0, 0xac, 0x7f, 0x10, 0xba, 0x1, 0xf8, 0x1f,
    0xc5, 0xcb, 0x6d, 0xe1, 0x3, 0xbf, 0xff, 0xea,
    0x10, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0x0,
    0xba, 0x0, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0,
    0x0, 0x0, 0xba, 0x0, 0x0,

    /* U+03C9 "ω" */
    0xd, 0x80, 0x0, 0x0, 0xbb, 0x6, 0xf1, 0x0,
    0x0, 0x3, 0xf3, 0xbb, 0x0, 0x0, 0x0, 0xe,
    0x8e, 0x80, 0x4, 0xf1, 0x0, 0xbb, 0xf7, 0x0,
    0x4f, 0x10, 0xa, 0xce, 0x80, 0x4, 0xf1, 0x0,
    0xbb, 0xbb, 0x0, 0x6f, 0x30, 0xe, 0x84, 0xf7,
    0x4d, 0xbb, 0x39, 0xf2, 0x7, 0xef, 0x80, 0xbf,
    0xe5, 0x0,

    /* U+03CC "ό" */
    0x0, 0x0, 0xd, 0xc0, 0x0, 0x0, 0x2, 0xf3,
    0x0, 0x0, 0x0, 0x58, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xff, 0xa1, 0x0, 0x4f,
    0x94, 0x4c, 0xe1, 0xd, 0xb0, 0x0, 0x1f, 0x70,
    0xf6, 0x0, 0x0, 0xbb, 0x1f, 0x50, 0x0, 0xa,
    0xc0, 0xf6, 0x0, 0x0, 0xbb, 0xc, 0xb0, 0x0,
    0x1f, 0x70, 0x3f, 0x93, 0x4c, 0xe1, 0x0, 0x4c,
    0xff, 0xa2, 0x0,

    /* U+03CD "ύ" */
    0x0, 0x3, 0xf7, 0x0, 0x0, 0x8, 0xd0, 0x0,
    0x0, 0x9, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xba, 0x0, 0x5, 0xf1, 0xba, 0x0, 0x2, 0xf4,
    0xba, 0x0, 0x0, 0xf6, 0xba, 0x0, 0x0, 0xf7,
    0xba, 0x0, 0x0, 0xf7, 0xbb, 0x0, 0x1, 0xf5,
    0xad, 0x0, 0x6, 0xf1, 0x5f, 0x73, 0x6f, 0x90,
    0x8, 0xef, 0xe8, 0x0,

    /* U+03CE "ώ" */
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0x0, 0x0, 0xb, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x80,
    0x0, 0x0, 0xbb, 0x6, 0xf1, 0x0, 0x0, 0x3,
    0xf3, 0xbb, 0x0, 0x0, 0x0, 0xe, 0x8e, 0x80,
    0x4, 0xf1, 0x0, 0xbb, 0xf7, 0x0, 0x4f, 0x10,
    0xa, 0xce, 0x80, 0x4, 0xf1, 0x0, 0xbb, 0xbb,
    0x0, 0x6f, 0x30, 0xe, 0x84, 0xf7, 0x4d, 0xbb,
    0x39, 0xf2, 0x7, 0xef, 0x80, 0xbf, 0xe5, 0x0,

    /* U+0406 "І" */
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f,

    /* U+0408 "Ј" */
    0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0,
    0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0,
    0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0,
    0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x9,
    0xd0, 0x13, 0xea, 0x4f, 0xfd, 0x10, 0x32, 0x0,

    /* U+0410 "А" */
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf5, 0x0, 0x0, 0x0, 0x7, 0xda, 0xb0, 0x0,
    0x0, 0x0, 0xd8, 0x5f, 0x10, 0x0, 0x0, 0x3f,
    0x20, 0xe6, 0x0, 0x0, 0x9, 0xd0, 0x9, 0xc0,
    0x0, 0x0, 0xe8, 0x11, 0x4f, 0x20, 0x0, 0x5f,
    0xff, 0xff, 0xf8, 0x0, 0xb, 0xc4, 0x44, 0x4a,
    0xe0, 0x1, 0xf5, 0x0, 0x0, 0x3f, 0x40, 0x7f,
    0x0, 0x0, 0x0, 0xda, 0xd, 0xa0, 0x0, 0x0,
    0x7, 0xf0,

    /* U+0411 "Б" */
    0x7f, 0xff, 0xff, 0xf6, 0x7, 0xf4, 0x44, 0x44,
    0x10, 0x7f, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xd6, 0x0, 0x7f, 0x33, 0x49, 0xf8, 0x7,
    0xf0, 0x0, 0xa, 0xe0, 0x7f, 0x0, 0x0, 0x7f,
    0x7, 0xf0, 0x0, 0xb, 0xe0, 0x7f, 0x44, 0x5a,
    0xf6, 0x7, 0xff, 0xff, 0xc5, 0x0,

    /* U+0412 "В" */
    0x7f, 0xff, 0xfd, 0x91, 0x7, 0xf4, 0x44, 0x7f,
    0xd0, 0x7f, 0x0, 0x0, 0x7f, 0x27, 0xf0, 0x0,
    0x6, 0xf1, 0x7f, 0x0, 0x3, 0xd9, 0x7, 0xff,
    0xff, 0xf9, 0x0, 0x7f, 0x33, 0x36, 0xdc, 0x7,
    0xf0, 0x0, 0x2, 0xf6, 0x7f, 0x0, 0x0, 0xf,
    0x87, 0xf0, 0x0, 0x3, 0xf6, 0x7f, 0x44, 0x46,
    0xee, 0x17, 0xff, 0xff, 0xea, 0x20,

    /* U+0413 "Г" */
    0x7f, 0xff, 0xff, 0xc7, 0xf4, 0x44, 0x43, 0x7f,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0,

    /* U+0417 "З" */
    0x19, 0xdf, 0xfd, 0x70, 0x0, 0xb7, 0x45, 0x9f,
    0x90, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0xa, 0xd0, 0x0, 0x0, 0x17, 0xf5, 0x0, 0xf,
    0xff, 0xe5, 0x0, 0x0, 0x33, 0x48, 0xf8, 0x0,
    0x0, 0x0, 0x6, 0xf2, 0x0, 0x0, 0x0, 0x3f,
    0x40, 0x0, 0x0, 0x8, 0xf2, 0x5a, 0x64, 0x59,
    0xfa, 0x3, 0xbe, 0xff, 0xc7, 0x0,

    /* U+0418 "И" */
    0x7f, 0x0, 0x0, 0x5, 0xf8, 0x7f, 0x0, 0x0,
    0xe, 0xf8, 0x7f, 0x0, 0x0, 0x9e, 0xd8, 0x7f,
    0x0, 0x3, 0xf5, 0xd8, 0x7f, 0x0, 0xc, 0xb0,
    0xd8, 0x7f, 0x0, 0x7f, 0x20, 0xe8, 0x7f, 0x1,
    0xf8, 0x0, 0xe8, 0x7f, 0xa, 0xd0, 0x0, 0xe8,
    0x7f, 0x4f, 0x40, 0x0, 0xe8, 0x7e, 0xea, 0x0,
    0x0, 0xe8, 0x7f, 0xe1, 0x0, 0x0, 0xe8, 0x7f,
    0x60, 0x0, 0x0, 0xe8,

    /* U+041A "К" */
    0x7f, 0x0, 0x0, 0x5f, 0x37, 0xf0, 0x0, 0x1e,
    0x80, 0x7f, 0x0, 0xb, 0xd0, 0x7, 0xf0, 0x5,
    0xf3, 0x0, 0x7f, 0x12, 0xe8, 0x0, 0x7, 0xff,
    0xff, 0x0, 0x0, 0x7f, 0x45, 0xf7, 0x0, 0x7,
    0xf0, 0x9, 0xf1, 0x0, 0x7f, 0x0, 0x1e, 0xb0,
    0x7, 0xf0, 0x0, 0x5f, 0x40, 0x7f, 0x0, 0x0,
    0xbe, 0x7, 0xf0, 0x0, 0x2, 0xf8,

    /* U+041C "М" */
    0x7f, 0xd0, 0x0, 0x0, 0x5, 0xff, 0x7f, 0xf3,
    0x0, 0x0, 0xb, 0xef, 0x7d, 0xd9, 0x0, 0x0,
    0x1f, 0xaf, 0x7d, 0x8e, 0x0, 0x0, 0x6d, 0x7f,
    0x7d, 0x2f, 0x40, 0x0, 0xc7, 0x7f, 0x7e, 0xc,
    0xa0, 0x2, 0xf2, 0x7f, 0x7e, 0x6, 0xf0, 0x8,
    0xc0, 0x7f, 0x7e, 0x1, 0xf5, 0xe, 0x60, 0x7f,
    0x7e, 0x0, 0xab, 0x4f, 0x10, 0x7f, 0x7e, 0x0,
    0x5f, 0xbb, 0x0, 0x7f, 0x7e, 0x0, 0xe, 0xf5,
    0x0, 0x7f, 0x7e, 0x0, 0x9, 0xe0, 0x0, 0x7f,

    /* U+041D "Н" */
    0x7f, 0x0, 0x0, 0x1, 0xf5, 0x7f, 0x0, 0x0,
    0x1, 0xf5, 0x7f, 0x0, 0x0, 0x1, 0xf5, 0x7f,
    0x0, 0x0, 0x1, 0xf5, 0x7f, 0x11, 0x11, 0x12,
    0xf5, 0x7f, 0xff, 0xff, 0xff, 0xf5, 0x7f, 0x44,
    0x44, 0x45, 0xf5, 0x7f, 0x0, 0x0, 0x1, 0xf5,
    0x7f, 0x0, 0x0, 0x1, 0xf5, 0x7f, 0x0, 0x0,
    0x1, 0xf5, 0x7f, 0x0, 0x0, 0x1, 0xf5, 0x7f,
    0x0, 0x0, 0x1, 0xf5,

    /* U+041E "О" */
    0x0, 0x5, 0xcf, 0xfd, 0x70, 0x0, 0x0, 0x9f,
    0xa5, 0x48, 0xfb, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x3f, 0x70, 0xb, 0xd0, 0x0, 0x0, 0xa, 0xe0,
    0xe, 0x90, 0x0, 0x0, 0x6, 0xf1, 0xf, 0x80,
    0x0, 0x0, 0x5, 0xf3, 0xf, 0x80, 0x0, 0x0,
    0x5, 0xf3, 0xe, 0x90, 0x0, 0x0, 0x6, 0xf1,
    0xb, 0xe0, 0x0, 0x0, 0xb, 0xd0, 0x4, 0xf7,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x9f, 0xa5, 0x58,
    0xfb, 0x0, 0x0, 0x5, 0xcf, 0xfd, 0x70, 0x0,

    /* U+041F "П" */
    0x7f, 0xff, 0xff, 0xff, 0xf2, 0x7f, 0x44, 0x44,
    0x47, 0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f,
    0x0, 0x0, 0x4, 0xf2, 0x7f, 0x0, 0x0, 0x4,
    0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f, 0x0,
    0x0, 0x4, 0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2,
    0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f, 0x0, 0x0,
    0x4, 0xf2, 0x7f, 0x0, 0x0, 0x4, 0xf2, 0x7f,
    0x0, 0x0, 0x4, 0xf2,

    /* U+0420 "Р" */
    0x7f, 0xff, 0xfc, 0x50, 0x7f, 0x44, 0x5b, 0xf4,
    0x7f, 0x0, 0x0, 0xdb, 0x7f, 0x0, 0x0, 0xad,
    0x7f, 0x0, 0x0, 0xcb, 0x7f, 0x0, 0x29, 0xf4,
    0x7f, 0xff, 0xfe, 0x50, 0x7f, 0x33, 0x20, 0x0,
    0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,
    0x7f, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x4, 0xbe, 0xfe, 0xb3, 0x0, 0x7f, 0xc6,
    0x56, 0xb3, 0x3, 0xf9, 0x0, 0x0, 0x0, 0xa,
    0xe0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xc6, 0x56, 0xa4, 0x0,
    0x5, 0xcf, 0xfe, 0xb2,

    /* U+0422 "Т" */
    0xdf, 0xff, 0xff, 0xff, 0xb4, 0x44, 0x7f, 0x64,
    0x43, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0, 0x4f,
    0x20, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x0, 0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x4f, 0x20, 0x0, 0x0, 0x4, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0x20, 0x0,

    /* U+0423 "У" */
    0xae, 0x0, 0x0, 0x0, 0xea, 0x3f, 0x60, 0x0,
    0x5, 0xf3, 0xb, 0xd0, 0x0, 0xb, 0xc0, 0x3,
    0xf5, 0x0, 0x2f, 0x50, 0x0, 0xbd, 0x0, 0x9e,
    0x0, 0x0, 0x3f, 0x50, 0xf7, 0x0, 0x0, 0xb,
    0xc6, 0xf1, 0x0, 0x0, 0x3, 0xfe, 0x90, 0x0,
    0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x5, 0x7c, 0xf2, 0x0, 0x0, 0xa,
    0xfd, 0x40, 0x0, 0x0,

    /* U+0427 "Ч" */
    0xca, 0x0, 0x0, 0x3f, 0x3c, 0xa0, 0x0, 0x3,
    0xf3, 0xca, 0x0, 0x0, 0x3f, 0x3c, 0xa0, 0x0,
    0x3, 0xf3, 0xbb, 0x0, 0x0, 0x3f, 0x37, 0xf6,
    0x10, 0x39, 0xf3, 0xa, 0xff, 0xff, 0xdf, 0x30,
    0x1, 0x32, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x3, 0xf3,

    /* U+0430 "а" */
    0x4, 0xbe, 0xfd, 0x60, 0x3, 0x74, 0x37, 0xf4,
    0x0, 0x0, 0x0, 0xc8, 0x1, 0x8d, 0xef, 0xf9,
    0xc, 0xd5, 0x22, 0xd9, 0x3f, 0x40, 0x0, 0xd9,
    0x4f, 0x30, 0x1, 0xf9, 0x1f, 0xb3, 0x4c, 0xd9,
    0x5, 0xdf, 0xd4, 0x89,

    /* U+0431 "б" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xad,
    0xf2, 0x0, 0x5f, 0xea, 0x75, 0x0, 0x2f, 0x70,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0xe7,
    0xaf, 0xfc, 0x30, 0xf, 0xe8, 0x34, 0xcf, 0x12,
    0xfb, 0x0, 0x1, 0xf8, 0x2f, 0x60, 0x0, 0xc,
    0xb1, 0xf6, 0x0, 0x0, 0xbc, 0xf, 0x70, 0x0,
    0xd, 0xa0, 0xac, 0x0, 0x2, 0xf6, 0x2, 0xfa,
    0x35, 0xdd, 0x0, 0x3, 0xcf, 0xfa, 0x10,

    /* U+0432 "в" */
    0xaf, 0xff, 0xfb, 0x20, 0xac, 0x33, 0x4d, 0xd0,
    0xac, 0x0, 0x6, 0xf0, 0xac, 0x0, 0x1c, 0xb0,
    0xaf, 0xff, 0xfd, 0x20, 0xac, 0x22, 0x4b, 0xe1,
    0xac, 0x0, 0x3, 0xf4, 0xac, 0x33, 0x4b, 0xf1,
    0xaf, 0xff, 0xfc, 0x40,

    /* U+0433 "г" */
    0xaf, 0xff, 0xfa, 0xad, 0x33, 0x32, 0xac, 0x0,
    0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xac, 0x0, 0x0, 0xac, 0x0, 0x0,
    0xac, 0x0, 0x0,

    /* U+0434 "д" */
    0x0, 0x8f, 0xff, 0xff, 0x40, 0x0, 0x9c, 0x33,
    0x5f, 0x40, 0x0, 0xaa, 0x0, 0x2f, 0x40, 0x0,
    0xb8, 0x0, 0x2f, 0x40, 0x0, 0xc7, 0x0, 0x2f,
    0x40, 0x0, 0xf5, 0x0, 0x2f, 0x40, 0x3, 0xf1,
    0x0, 0x2f, 0x40, 0x2c, 0xd3, 0x33, 0x5f, 0x61,
    0xdf, 0xff, 0xff, 0xff, 0xf8, 0xd8, 0x0, 0x0,
    0x0, 0xd8, 0xd8, 0x0, 0x0, 0x0, 0xd8, 0x42,
    0x0, 0x0, 0x0, 0x42,

    /* U+0435 "е" */
    0x0, 0x5d, 0xfd, 0x60, 0x0, 0x6f, 0x83, 0x7f,
    0x60, 0xe, 0xa0, 0x0, 0xad, 0x2, 0xf5, 0x0,
    0x6, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0x12, 0xf6,
    0x33, 0x33, 0x30, 0xe, 0x90, 0x0, 0x0, 0x0,
    0x5f, 0x94, 0x46, 0x70, 0x0, 0x5c, 0xff, 0xd6,
    0x0,

    /* U+0436 "ж" */
    0x5f, 0x20, 0x9, 0xc0, 0x0, 0xe8, 0x0, 0xbb,
    0x0, 0x9c, 0x0, 0x9d, 0x0, 0x2, 0xf5, 0x9,
    0xc0, 0x3f, 0x40, 0x0, 0x7, 0xe0, 0x9c, 0xc,
    0xa0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x9, 0xe3, 0xbc, 0x3d, 0xb0, 0x0, 0x3,
    0xf5, 0x9, 0xc0, 0x3f, 0x50, 0x0, 0xdb, 0x0,
    0x9c, 0x0, 0x8e, 0x10, 0x8f, 0x10, 0x9, 0xc0,
    0x0, 0xdb, 0x0,

    /* U+0437 "з" */
    0x2b, 0xef, 0xe9, 0x0, 0x19, 0x43, 0x6f, 0x90,
    0x0, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x3e, 0x70,
    0x3, 0xff, 0xf9, 0x0, 0x0, 0x22, 0x5d, 0xa0,
    0x0, 0x0, 0x7, 0xf0, 0x46, 0x43, 0x5d, 0xd0,
    0x4c, 0xff, 0xea, 0x10,

    /* U+0438 "и" */
    0xac, 0x0, 0x7, 0xf9, 0xac, 0x0, 0x1f, 0xf9,
    0xac, 0x0, 0x9c, 0xc9, 0xac, 0x2, 0xf3, 0xd9,
    0xac, 0xb, 0xa0, 0xd9, 0xab, 0x4f, 0x20, 0xd9,
    0xab, 0xd8, 0x0, 0xd9, 0xaf, 0xe0, 0x0, 0xd9,
    0xaf, 0x60, 0x0, 0xd9,

    /* U+0439 "й" */
    0x5, 0xe1, 0x2f, 0x40, 0x0, 0x9f, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xac, 0x0, 0x7, 0xf9,
    0xac, 0x0, 0x1f, 0xf9, 0xac, 0x0, 0x9c, 0xc9,
    0xac, 0x2, 0xf3, 0xd9, 0xac, 0xb, 0xa0, 0xd9,
    0xab, 0x4f, 0x20, 0xd9, 0xab, 0xd8, 0x0, 0xd9,
    0xaf, 0xe0, 0x0, 0xd9, 0xaf, 0x60, 0x0, 0xd9,

    /* U+043A "к" */
    0xac, 0x0, 0xa, 0xd0, 0xac, 0x0, 0x4f, 0x30,
    0xac, 0x0, 0xd9, 0x0, 0xac, 0x8, 0xe0, 0x0,
    0xaf, 0xff, 0x70, 0x0, 0xad, 0x3a, 0xe1, 0x0,
    0xac, 0x0, 0xea, 0x0, 0xac, 0x0, 0x4f, 0x50,
    0xac, 0x0, 0x9, 0xe1,

    /* U+043B "л" */
    0x0, 0xcf, 0xff, 0xff, 0x0, 0xd, 0x83, 0x38,
    0xf0, 0x0, 0xe5, 0x0, 0x6f, 0x0, 0xf, 0x50,
    0x6, 0xf0, 0x0, 0xf4, 0x0, 0x6f, 0x0, 0x1f,
    0x20, 0x6, 0xf0, 0x3, 0xf0, 0x0, 0x6f, 0x5,
    0xbd, 0x0, 0x6, 0xf0, 0xfe, 0x40, 0x0, 0x6f,
    0x0,

    /* U+043C "м" */
    0xaf, 0x70, 0x0, 0x2, 0xfe, 0xaf, 0xd0, 0x0,
    0x8, 0xfe, 0xab, 0xf4, 0x0, 0xe, 0xbe, 0xaa,
    0xaa, 0x0, 0x5e, 0x6e, 0xaa, 0x4f, 0x10, 0xc8,
    0x6e, 0xaa, 0xd, 0x72, 0xf1, 0x6e, 0xaa, 0x7,
    0xd9, 0xb0, 0x6e, 0xaa, 0x1, 0xff, 0x40, 0x6e,
    0xaa, 0x0, 0xad, 0x0, 0x6e,

    /* U+043D "н" */
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xaf, 0xff, 0xff, 0xf7, 0xad, 0x33, 0x33, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7,

    /* U+043E "о" */
    0x0, 0x5d, 0xfe, 0xa1, 0x0, 0x6f, 0x83, 0x5d,
    0xd0, 0xe, 0xa0, 0x0, 0x2f, 0x62, 0xf5, 0x0,
    0x0, 0xda, 0x3f, 0x40, 0x0, 0xc, 0xb2, 0xf5,
    0x0, 0x0, 0xda, 0xd, 0xa0, 0x0, 0x2f, 0x60,
    0x5f, 0x83, 0x5d, 0xd0, 0x0, 0x5d, 0xfe, 0xa1,
    0x0,

    /* U+043F "п" */
    0xaf, 0xff, 0xff, 0xf5, 0xad, 0x33, 0x34, 0xf5,
    0xac, 0x0, 0x1, 0xf5, 0xac, 0x0, 0x1, 0xf5,
    0xac, 0x0, 0x1, 0xf5, 0xac, 0x0, 0x1, 0xf5,
    0xac, 0x0, 0x1, 0xf5, 0xac, 0x0, 0x1, 0xf5,
    0xac, 0x0, 0x1, 0xf5,

    /* U+0440 "р" */
    0xa9, 0x7e, 0xfd, 0x50, 0xaf, 0xa2, 0x18, 0xf4,
    0xaf, 0x0, 0x0, 0xdb, 0xac, 0x0, 0x0, 0x9e,
    0xac, 0x0, 0x0, 0x8f, 0xad, 0x0, 0x0, 0xae,
    0xaf, 0x10, 0x0, 0xea, 0xaf, 0xc4, 0x3b, 0xf3,
    0xab, 0x6d, 0xfd, 0x40, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x4c, 0xff, 0xc1, 0x5, 0xf9, 0x44, 0x70,
    0xe, 0xa0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x6, 0xf9, 0x44, 0x70,
    0x0, 0x6d, 0xff, 0xc0,

    /* U+0442 "т" */
    0xcf, 0xff, 0xff, 0xf3, 0x23, 0x3f, 0x83, 0x30,
    0x0, 0xf, 0x60, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x0, 0xf, 0x60, 0x0,

    /* U+0443 "у" */
    0xda, 0x0, 0x0, 0x8e, 0x6, 0xf1, 0x0, 0xe,
    0x90, 0x1f, 0x60, 0x3, 0xf3, 0x0, 0xac, 0x0,
    0x9d, 0x0, 0x4, 0xf2, 0xe, 0x80, 0x0, 0xe,
    0x74, 0xf2, 0x0, 0x0, 0x8c, 0x9c, 0x0, 0x0,
    0x2, 0xfe, 0x60, 0x0, 0x0, 0xc, 0xf1, 0x0,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0x0, 0x2f, 0x50,
    0x0, 0x4, 0x5d, 0xd0, 0x0, 0x0, 0xcf, 0xc2,
    0x0, 0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0x6, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0, 0x0,
    0x0, 0x2a, 0xef, 0xfd, 0x81, 0x0, 0x3, 0xfc,
    0x5d, 0xa6, 0xdd, 0x10, 0xd, 0xc0, 0xc, 0x90,
    0x1e, 0x90, 0x2f, 0x60, 0xc, 0x90, 0x9, 0xe0,
    0x3f, 0x40, 0xc, 0x90, 0x7, 0xf0, 0x2f, 0x50,
    0xc, 0x90, 0x9, 0xe0, 0xd, 0xc0, 0xc, 0x90,
    0x1e, 0xa0, 0x3, 0xfc, 0x5d, 0xa6, 0xde, 0x10,
    0x0, 0x2a, 0xef, 0xfe, 0x91, 0x0, 0x0, 0x0,
    0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xc, 0x90, 0x0, 0x0,

    /* U+0445 "х" */
    0x6f, 0x30, 0x1, 0xf8, 0x0, 0xbd, 0x0, 0xad,
    0x0, 0x1, 0xe8, 0x5f, 0x30, 0x0, 0x5, 0xfe,
    0x80, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x8,
    0xfd, 0xa0, 0x0, 0x3, 0xf6, 0x3f, 0x50, 0x0,
    0xdb, 0x0, 0x8e, 0x10, 0x8f, 0x10, 0x0, 0xdb,
    0x0,

    /* U+0446 "ц" */
    0xac, 0x0, 0x1, 0xf5, 0xa, 0xc0, 0x0, 0x1f,
    0x50, 0xac, 0x0, 0x1, 0xf5, 0xa, 0xc0, 0x0,
    0x1f, 0x50, 0xac, 0x0, 0x1, 0xf5, 0xa, 0xc0,
    0x0, 0x1f, 0x50, 0xac, 0x0, 0x1, 0xf5, 0xa,
    0xd3, 0x33, 0x4f, 0x72, 0xaf, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0,
    0xb, 0xa0, 0x0, 0x0, 0x0, 0x33,

    /* U+0447 "ч" */
    0xf, 0x60, 0x0, 0x5f, 0x10, 0xf6, 0x0, 0x5,
    0xf1, 0xf, 0x60, 0x0, 0x5f, 0x10, 0xf6, 0x0,
    0x5, 0xf1, 0xc, 0xd2, 0x2, 0x9f, 0x10, 0x2d,
    0xff, 0xfd, 0xf1, 0x0, 0x2, 0x20, 0x5f, 0x10,
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x5f,
    0x10,

    /* U+0448 "ш" */
    0xbb, 0x0, 0x8, 0xd0, 0x0, 0x6f, 0xbb, 0x0,
    0x8, 0xd0, 0x0, 0x6f, 0xbb, 0x0, 0x8, 0xd0,
    0x0, 0x6f, 0xbb, 0x0, 0x8, 0xd0, 0x0, 0x6f,
    0xbb, 0x0, 0x8, 0xd0, 0x0, 0x6f, 0xbb, 0x0,
    0x8, 0xd0, 0x0, 0x6f, 0xbb, 0x0, 0x8, 0xd0,
    0x0, 0x6f, 0xbc, 0x33, 0x3a, 0xe3, 0x33, 0x8f,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+0449 "щ" */
    0xac, 0x0, 0x9, 0xd0, 0x0, 0x8d, 0x0, 0xac,
    0x0, 0x9, 0xd0, 0x0, 0x8d, 0x0, 0xac, 0x0,
    0x9, 0xd0, 0x0, 0x8d, 0x0, 0xac, 0x0, 0x9,
    0xd0, 0x0, 0x8d, 0x0, 0xac, 0x0, 0x9, 0xd0,
    0x0, 0x8d, 0x0, 0xac, 0x0, 0x9, 0xd0, 0x0,
    0x8d, 0x0, 0xac, 0x0, 0x9, 0xd0, 0x0, 0x8d,
    0x0, 0xad, 0x33, 0x3a, 0xd3, 0x33, 0xae, 0x30,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x50,

    /* U+044A "ъ" */
    0xcf, 0xff, 0x0, 0x0, 0x0, 0x23, 0x8f, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xfb, 0x20, 0x0, 0x6f, 0x33, 0x4c,
    0xe0, 0x0, 0x6f, 0x0, 0x4, 0xf3, 0x0, 0x6f,
    0x0, 0x4, 0xf3, 0x0, 0x6f, 0x33, 0x5d, 0xd0,
    0x0, 0x6f, 0xff, 0xea, 0x20,

    /* U+044B "ы" */
    0xac, 0x0, 0x0, 0x0, 0xac, 0xac, 0x0, 0x0,
    0x0, 0xac, 0xac, 0x0, 0x0, 0x0, 0xac, 0xaf,
    0xff, 0xe9, 0x0, 0xac, 0xac, 0x33, 0x5e, 0xa0,
    0xac, 0xac, 0x0, 0x8, 0xe0, 0xac, 0xac, 0x0,
    0x9, 0xe0, 0xac, 0xad, 0x33, 0x6f, 0x80, 0xac,
    0xaf, 0xff, 0xe8, 0x0, 0xac,

    /* U+044C "ь" */
    0xac, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x0, 0xac,
    0x0, 0x0, 0xa, 0xff, 0xfe, 0x91, 0xac, 0x33,
    0x5e, 0xaa, 0xc0, 0x0, 0x8f, 0xac, 0x0, 0x8,
    0xfa, 0xd3, 0x36, 0xf9, 0xaf, 0xff, 0xe9, 0x0,

    /* U+044E "ю" */
    0xac, 0x0, 0x19, 0xef, 0xc4, 0x0, 0xac, 0x0,
    0xcc, 0x21, 0x7f, 0x30, 0xac, 0x4, 0xf2, 0x0,
    0xb, 0xb0, 0xac, 0x8, 0xe0, 0x0, 0x8, 0xf0,
    0xaf, 0xff, 0xd0, 0x0, 0x7, 0xf0, 0xad, 0x3a,
    0xf0, 0x0, 0x8, 0xf0, 0xac, 0x5, 0xf3, 0x0,
    0xc, 0xb0, 0xac, 0x0, 0xdd, 0x53, 0x9f, 0x30,
    0xac, 0x0, 0x1a, 0xff, 0xc4, 0x0,

    /* U+044F "я" */
    0x2, 0xbf, 0xff, 0xfe, 0xc, 0xd4, 0x33, 0x9e,
    0xf, 0x70, 0x0, 0x8e, 0xd, 0xc2, 0x0, 0x8e,
    0x3, 0xdf, 0xff, 0xfe, 0x0, 0x4f, 0x53, 0x9e,
    0x0, 0xda, 0x0, 0x8e, 0x8, 0xf1, 0x0, 0x8e,
    0x2f, 0x70, 0x0, 0x8e,

    /* U+0452 "ђ" */
    0x5, 0x60, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xfc, 0x0, 0x2, 0xad, 0x22,
    0x20, 0x0, 0x9, 0xc5, 0xdf, 0xd6, 0x0, 0x9e,
    0xd5, 0x39, 0xf3, 0x9, 0xf2, 0x0, 0xe, 0x80,
    0x9e, 0x0, 0x0, 0xc9, 0x9, 0xd0, 0x0, 0xc,
    0x90, 0x9d, 0x0, 0x0, 0xc9, 0x9, 0xd0, 0x0,
    0xc, 0x90, 0x9d, 0x0, 0x0, 0xc9, 0x9, 0xd0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x0, 0xc9, 0x0,
    0x0, 0x0, 0xd, 0x90, 0x0, 0x2, 0x46, 0xf5,
    0x0, 0x0, 0x4f, 0xf9, 0x0,

    /* U+0456 "і" */
    0x9b, 0x79, 0x0, 0xac, 0xac, 0xac, 0xac, 0xac,
    0xac, 0xac, 0xac, 0xac,

    /* U+0457 "ї" */
    0x7b, 0x9a, 0x69, 0x78, 0x0, 0x0, 0xa, 0xc0,
    0xa, 0xc0, 0xa, 0xc0, 0xa, 0xc0, 0xa, 0xc0,
    0xa, 0xc0, 0xa, 0xc0, 0xa, 0xc0, 0xa, 0xc0,

    /* U+0458 "ј" */
    0x0, 0x9b, 0x0, 0x79, 0x0, 0x0, 0x0, 0xac,
    0x0, 0xac, 0x0, 0xac, 0x0, 0xac, 0x0, 0xac,
    0x0, 0xac, 0x0, 0xac, 0x0, 0xac, 0x0, 0xac,
    0x0, 0xac, 0x0, 0xac, 0x44, 0xe9, 0xcf, 0xc1,

    /* U+0459 "љ" */
    0x0, 0xcf, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0xd8, 0x33, 0xad, 0x0, 0x0, 0x0, 0x0, 0xe5,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x0,
    0x8f, 0xff, 0xea, 0x10, 0x0, 0xf4, 0x0, 0x8e,
    0x33, 0x5e, 0xb0, 0x1, 0xf2, 0x0, 0x8d, 0x0,
    0x7, 0xf0, 0x3, 0xf0, 0x0, 0x8d, 0x0, 0x8,
    0xf0, 0x5b, 0xd0, 0x0, 0x8e, 0x55, 0x7f, 0xa0,
    0xfe, 0x40, 0x0, 0x8f, 0xff, 0xe9, 0x0,

    /* U+045A "њ" */
    0xac, 0x0, 0x1, 0xf5, 0x0, 0x0, 0xa, 0xc0,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0xac, 0x0, 0x1,
    0xf5, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x1f, 0x50,
    0x0, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xd7,
    0xa, 0xd3, 0x33, 0x4f, 0x73, 0x38, 0xf5, 0xac,
    0x0, 0x1, 0xf5, 0x0, 0xf, 0x7a, 0xc0, 0x0,
    0x1f, 0x73, 0x38, 0xf4, 0xac, 0x0, 0x1, 0xff,
    0xff, 0xd6, 0x0,

    /* U+045B "ћ" */
    0x5, 0x60, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0x10, 0x2, 0xad, 0x22,
    0x20, 0x0, 0x9, 0xc5, 0xdf, 0xe7, 0x0, 0x9e,
    0xd5, 0x39, 0xf4, 0x9, 0xf2, 0x0, 0xe, 0x90,
    0x9e, 0x0, 0x0, 0xca, 0x9, 0xd0, 0x0, 0xc,
    0xa0, 0x9d, 0x0, 0x0, 0xca, 0x9, 0xd0, 0x0,
    0xc, 0xa0, 0x9d, 0x0, 0x0, 0xca, 0x9, 0xd0,
    0x0, 0xc, 0xa0,

    /* U+060C "،" */
    0x5, 0x12, 0xf2, 0x7e, 0x25, 0xf5,

    /* U+0622 "آ" */
    0x6e, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x42,
    0x0, 0x0, 0xd7, 0x0, 0x0, 0xc8, 0x0, 0x0,
    0xc8, 0x0, 0x0, 0xb8, 0x0, 0x0, 0xb9, 0x0,
    0x0, 0xb9, 0x0, 0x0, 0xaa, 0x0, 0x0, 0xaa,
    0x0, 0x0, 0x9a, 0x0, 0x0, 0x9b, 0x0,

    /* U+0623 "أ" */
    0x5d, 0x60, 0xc2, 0x0, 0x7c, 0xa2, 0x88, 0x30,
    0x4, 0x20, 0xd, 0x70, 0xc, 0x80, 0xc, 0x80,
    0xb, 0x80, 0xb, 0x90, 0xb, 0x90, 0xa, 0xa0,
    0xa, 0xa0, 0x9, 0xa0, 0x9, 0xb0,

    /* U+0625 "إ" */
    0xd, 0x70, 0xc, 0x70, 0xc, 0x80, 0xc, 0x80,
    0xb, 0x90, 0xb, 0x90, 0xa, 0xa0, 0xa, 0xa0,
    0x9, 0xb0, 0x9, 0xb0, 0x8, 0xb0, 0x3, 0x50,
    0x8, 0xd2, 0x1c, 0x0, 0xd, 0x55, 0xd, 0xd7,
    0x1, 0x0,

    /* U+0626 "ئ" */
    0x0, 0x9d, 0x10, 0x0, 0x0, 0x0, 0x2, 0xc0,
    0x0, 0x1, 0xaf, 0xfb, 0x0, 0xd3, 0x30, 0x1e,
    0xc5, 0x54, 0x1, 0xdd, 0x70, 0xac, 0x0, 0x0,
    0x1, 0x20, 0x0, 0xd7, 0x0, 0x0, 0x1f, 0x20,
    0x0, 0x8f, 0xa4, 0x0, 0x6e, 0x0, 0x0, 0x4,
    0xaf, 0xc0, 0x8d, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x6f, 0x10, 0x0, 0x0, 0x9, 0xe0, 0x1e, 0xd6,
    0x21, 0x26, 0xce, 0x30, 0x2, 0xbf, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x33, 0x20, 0x0, 0x0,

    /* U+0627 "ا" */
    0xd7, 0xc7, 0xc8, 0xc8, 0xb9, 0xb9, 0xaa, 0xaa,
    0x9b, 0x9b, 0x8b, 0x35,

    /* U+0628 "ب" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40,
    0x2a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb0,
    0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf0,
    0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf1,
    0x6f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x1d, 0xfb, 0x87, 0x66, 0x66, 0x78, 0xcf, 0x50,
    0x1, 0x7c, 0xef, 0xff, 0xfe, 0xca, 0x61, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,

    /* U+0629 "ة" */
    0x2, 0x71, 0x80, 0x6, 0xe3, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x32, 0x0, 0x0, 0xbe, 0x20, 0x2,
    0xeb, 0xe1, 0xd, 0x70, 0xb9, 0x5e, 0x0, 0x4e,
    0x7c, 0x0, 0x3f, 0x5f, 0x75, 0xcb, 0x8, 0xef,
    0xb1,

    /* U+062A "ت" */
    0x0, 0x0, 0x0, 0x72, 0x54, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe5, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x70,
    0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xc0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x8d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf1,
    0x6f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0xd, 0xfb, 0x87, 0x66, 0x66, 0x78, 0xcf, 0x40,
    0x0, 0x7c, 0xef, 0xff, 0xfe, 0xca, 0x61, 0x0,

    /* U+062B "ث" */
    0x0, 0x0, 0x0, 0xd, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x77, 0x84, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe6, 0xb8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x70,
    0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xc0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x8d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf1,
    0x6f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0xd, 0xfb, 0x87, 0x66, 0x66, 0x78, 0xcf, 0x40,
    0x0, 0x7c, 0xef, 0xff, 0xfe, 0xca, 0x61, 0x0,

    /* U+062C "ج" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xff, 0xc8,
    0x42, 0x10, 0x0, 0x0, 0x4b, 0xff, 0xf2, 0x0,
    0x2, 0xbf, 0xb7, 0x40, 0x0, 0x5f, 0xa2, 0x0,
    0x0, 0x4, 0xf6, 0x0, 0x0, 0x0, 0x1e, 0x80,
    0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0,
    0xb9, 0x0, 0x1e, 0x40, 0x0, 0xd7, 0x0, 0x8,
    0x10, 0x0, 0xc9, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x31, 0x13,
    0x83, 0x0, 0x8e, 0xff, 0xff, 0xc4, 0x0, 0x0,
    0x23, 0x31, 0x0,

    /* U+062D "ح" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xfe, 0x91,
    0x0, 0x0, 0x58, 0x47, 0xef, 0x83, 0x10, 0x0,
    0x0, 0xa, 0xff, 0xf2, 0x0, 0x3, 0xcf, 0xb7,
    0x40, 0x0, 0x8f, 0x81, 0x0, 0x0, 0x8, 0xe3,
    0x0, 0x0, 0x0, 0x3f, 0x40, 0x0, 0x0, 0x0,
    0x9b, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0, 0x0,
    0x0, 0x0, 0xd8, 0x0, 0x0, 0x0, 0x0, 0x9e,
    0x10, 0x0, 0x0, 0x0, 0x1e, 0xe7, 0x31, 0x14,
    0x73, 0x1, 0x9f, 0xff, 0xff, 0xc4, 0x0, 0x0,
    0x23, 0x31, 0x0,

    /* U+062E "خ" */
    0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0, 0x55,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xfe, 0x91, 0x0, 0x0, 0x58, 0x47, 0xef, 0x83,
    0x10, 0x0, 0x0, 0xa, 0xff, 0xf2, 0x0, 0x3,
    0xcf, 0xb7, 0x40, 0x0, 0x8f, 0x81, 0x0, 0x0,
    0x8, 0xe3, 0x0, 0x0, 0x0, 0x3f, 0x40, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0, 0xc8,
    0x0, 0x0, 0x0, 0x0, 0xd8, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0x10, 0x0, 0x0, 0x0, 0x1e, 0xe7,
    0x31, 0x14, 0x73, 0x1, 0x9f, 0xff, 0xff, 0xc4,
    0x0, 0x0, 0x23, 0x31, 0x0,

    /* U+062F "د" */
    0x0, 0x0, 0x50, 0x0, 0x0, 0x3f, 0x50, 0x0,
    0x0, 0x8e, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x8, 0xc0, 0x0, 0x0, 0x7e, 0x1b, 0x65, 0x7e,
    0xa2, 0xae, 0xfe, 0x90,

    /* U+0630 "ذ" */
    0x0, 0x18, 0x0, 0x0, 0x3, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x3,
    0xf5, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x7, 0xe1,
    0xb6, 0x57, 0xea, 0x2a, 0xef, 0xe9, 0x0,

    /* U+0631 "ر" */
    0x0, 0x0, 0x30, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0xd8, 0x0, 0x0, 0x7b, 0x0, 0x0, 0x6c, 0x0,
    0x0, 0xaa, 0x0, 0x3, 0xf3, 0x0, 0x6f, 0x80,
    0x3d, 0xf7, 0x0, 0x8, 0x10, 0x0,

    /* U+0632 "ز" */
    0x0, 0x6, 0x30, 0x0, 0xd, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xe1, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x6c,
    0x0, 0x0, 0x8b, 0x0, 0x1, 0xe5, 0x0, 0x2d,
    0xc0, 0x29, 0xfb, 0x10, 0x1c, 0x50, 0x0,

    /* U+0633 "س" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x33,
    0x0, 0x4, 0x20, 0x1f, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0xd6, 0x0, 0xc7, 0x9, 0x10,
    0x0, 0x0, 0x6f, 0x0, 0x1f, 0x40, 0xb, 0x84,
    0xf0, 0x0, 0x0, 0x3, 0xfa, 0x5a, 0xfa, 0x56,
    0xf4, 0x7d, 0x0, 0x0, 0x0, 0x2f, 0xdf, 0xd6,
    0xdf, 0xe7, 0x6, 0xf0, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xc4, 0x11, 0x38,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2b, 0xff,
    0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x33, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+0634 "ش" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x62, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8b, 0x6e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x14, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x54, 0x0, 0x5,
    0x30, 0x1f, 0x40, 0x0, 0x0, 0x0, 0xa, 0xb0,
    0x0, 0xd6, 0x0, 0xc7, 0xb, 0x10, 0x0, 0x0,
    0x6f, 0x0, 0x1f, 0x40, 0xb, 0x85, 0xf0, 0x0,
    0x0, 0x3, 0xfa, 0x5a, 0xfa, 0x56, 0xf4, 0x8d,
    0x0, 0x0, 0x0, 0x3f, 0xcf, 0xd5, 0xdf, 0xe7,
    0x6, 0xf1, 0x0, 0x0, 0x8, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xc4, 0x11, 0x39, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2b, 0xff, 0xff, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x33,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0635 "ص" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xaf, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x54, 0x0, 0x5, 0xfc, 0x54, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x5, 0xf6, 0x0,
    0x1, 0xf2, 0x1c, 0x10, 0x0, 0x0, 0x5f, 0x23,
    0xf5, 0x0, 0x0, 0x5f, 0x5, 0xf0, 0x0, 0x0,
    0x3, 0xfe, 0xec, 0x55, 0x57, 0xbf, 0x60, 0x8d,
    0x0, 0x0, 0x0, 0x3f, 0x7b, 0xef, 0xff, 0xd9,
    0x30, 0x6, 0xf1, 0x0, 0x0, 0x9, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xd5, 0x11, 0x3a,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0xff, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x33, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0636 "ض" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x64, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1a, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x40, 0x0, 0x5f, 0xc5, 0x4b, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xab, 0x0, 0x5f, 0x60, 0x0,
    0x1f, 0x21, 0xc1, 0x0, 0x0, 0x5, 0xf2, 0x3f,
    0x50, 0x0, 0x5, 0xf0, 0x5f, 0x0, 0x0, 0x0,
    0x3f, 0xee, 0xc5, 0x55, 0x7b, 0xf6, 0x8, 0xd0,
    0x0, 0x0, 0x3, 0xf7, 0xbe, 0xff, 0xfd, 0x93,
    0x0, 0x6f, 0x10, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xed, 0x51, 0x13, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbf,
    0xff, 0xfd, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x13, 0x32, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+0637 "ط" */
    0x0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x0, 0xd,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xd, 0x70, 0x0,
    0x0, 0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x90, 0x4c, 0xff, 0xb1, 0x0, 0xb, 0xa8, 0xfa,
    0x45, 0xea, 0x0, 0xa, 0xfe, 0x30, 0x0, 0x6d,
    0x0, 0xa, 0xe2, 0x0, 0x0, 0xab, 0x45, 0x6f,
    0x84, 0x45, 0x7d, 0xe2, 0x8f, 0xff, 0xff, 0xfe,
    0xc8, 0x10,

    /* U+0638 "ظ" */
    0x0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x0, 0xd,
    0x70, 0x0, 0x45, 0x0, 0x0, 0xd, 0x70, 0x0,
    0x9b, 0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x90, 0x4c, 0xff, 0xb1, 0x0, 0xb, 0xa8, 0xfa,
    0x45, 0xea, 0x0, 0xa, 0xfe, 0x30, 0x0, 0x6d,
    0x0, 0xa, 0xe2, 0x0, 0x0, 0xab, 0x45, 0x6f,
    0x84, 0x45, 0x7d, 0xe2, 0x8f, 0xff, 0xff, 0xfe,
    0xc8, 0x10,

    /* U+0639 "ع" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xcf, 0xf4,
    0x0, 0x0, 0x1f, 0xb4, 0x51, 0x0, 0x0, 0x5e,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x10,
    0x0, 0xd, 0xe7, 0xaf, 0xb0, 0x0, 0x1, 0xef,
    0xc6, 0x20, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x0,
    0x3f, 0x40, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0,
    0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0, 0xc8,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x10, 0x0, 0x0,
    0x0, 0x1e, 0xe6, 0x21, 0x24, 0x80, 0x1, 0xaf,
    0xff, 0xff, 0xb1, 0x0, 0x0, 0x23, 0x20, 0x0,

    /* U+063A "غ" */
    0x0, 0xc, 0x80, 0x0, 0x0, 0x0, 0x6, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xcf, 0xf4, 0x0, 0x0, 0x1f, 0xb4, 0x51, 0x0,
    0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x10, 0x0, 0xd, 0xe7, 0xaf, 0xb0, 0x0,
    0x1, 0xef, 0xc6, 0x20, 0x0, 0x8, 0xf5, 0x0,
    0x0, 0x0, 0x3f, 0x40, 0x0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0,
    0x0, 0xc8, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x10,
    0x0, 0x0, 0x0, 0x1e, 0xe6, 0x21, 0x24, 0x80,
    0x1, 0xaf, 0xff, 0xff, 0xb1, 0x0, 0x0, 0x23,
    0x20, 0x0,

    /* U+0640 "ـ" */
    0x45, 0x55, 0x40, 0xff, 0xff, 0xe0,

    /* U+0641 "ف" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x5e, 0x80,
    0x16, 0x0, 0x0, 0x0, 0x2, 0xf1, 0x6, 0xe0,
    0x5e, 0x0, 0x0, 0x0, 0x3, 0xf4, 0x5, 0xf0,
    0x7d, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xf0,
    0x6f, 0x10, 0x0, 0x0, 0x0, 0x2, 0x37, 0xd0,
    0x1e, 0xe8, 0x54, 0x44, 0x44, 0x44, 0x6e, 0x80,
    0x1, 0x8c, 0xef, 0xff, 0xff, 0xff, 0xea, 0x0,

    /* U+0642 "ق" */
    0x0, 0x0, 0x0, 0x7, 0x26, 0x40, 0x0, 0x0,
    0x0, 0xe, 0x5b, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x2f, 0x77, 0xf3, 0x3, 0x0, 0x0, 0x7c,
    0x0, 0xc8, 0x1f, 0x50, 0x0, 0x8d, 0x10, 0xaa,
    0x5f, 0x0, 0x0, 0x2e, 0xff, 0xf9, 0x8e, 0x0,
    0x0, 0x0, 0x22, 0xd7, 0x6f, 0x20, 0x0, 0x0,
    0x6, 0xf1, 0x1e, 0xe6, 0x21, 0x25, 0xbf, 0x60,
    0x2, 0xbf, 0xff, 0xff, 0xb3, 0x0, 0x0, 0x1,
    0x34, 0x30, 0x0, 0x0,

    /* U+0643 "ك" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0,
    0x0, 0x1, 0x10, 0x6, 0xe0, 0x0, 0x0, 0x0,
    0x5e, 0x50, 0x5, 0xf0, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x4, 0xf0, 0x4, 0x0, 0x0, 0x1d, 0x40,
    0x4, 0xf0, 0x5f, 0x0, 0x3, 0xae, 0x30, 0x3,
    0xf1, 0x7d, 0x0, 0x2, 0x61, 0x0, 0x2, 0xf2,
    0x7f, 0x10, 0x0, 0x0, 0x0, 0x5, 0xf1, 0x1e,
    0xe9, 0x65, 0x55, 0x57, 0xaf, 0x90, 0x1, 0x8c,
    0xef, 0xff, 0xed, 0x94, 0x0,

    /* U+0644 "ل" */
    0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf0, 0x2, 0x0, 0x0, 0x0,
    0x3f, 0x12, 0xf2, 0x0, 0x0, 0x3, 0xf1, 0x6e,
    0x0, 0x0, 0x0, 0x4f, 0x8, 0xd0, 0x0, 0x0,
    0x7, 0xd0, 0x6f, 0x10, 0x0, 0x0, 0xd8, 0x0,
    0xed, 0x51, 0x14, 0xbe, 0x10, 0x1, 0xbf, 0xff,
    0xfb, 0x20, 0x0, 0x0, 0x13, 0x31, 0x0, 0x0,

    /* U+0645 "م" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0xfb, 0x0,
    0x6, 0xf6, 0x5e, 0x90, 0x7, 0x50, 0x5, 0xf0,
    0x0, 0x0, 0x11, 0xf1, 0x5, 0xdf, 0xff, 0xf0,
    0x4f, 0x84, 0x57, 0x70, 0xab, 0x0, 0x0, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0,
    0x7d, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0,
    0xf, 0x40, 0x0, 0x0, 0x4, 0x10, 0x0, 0x0,

    /* U+0646 "ن" */
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xe8, 0x0, 0x30, 0x0, 0x0, 0x9,
    0xd0, 0x2f, 0x20, 0x0, 0x0, 0x4f, 0x16, 0xe0,
    0x0, 0x0, 0x2, 0xf2, 0x8d, 0x0, 0x0, 0x0,
    0x4f, 0x6, 0xf1, 0x0, 0x0, 0xb, 0xb0, 0xe,
    0xd5, 0x11, 0x3b, 0xf3, 0x0, 0x2b, 0xff, 0xff,
    0xc3, 0x0, 0x0, 0x1, 0x33, 0x10, 0x0, 0x0,

    /* U+0647 "ه" */
    0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xb1, 0x0, 0x0, 0x0, 0x3, 0xdf, 0xd2, 0x0,
    0x0, 0x0, 0xd9, 0x4e, 0xe2, 0x0, 0x0, 0x2f,
    0x10, 0xaf, 0xe1, 0x0, 0x1, 0xf3, 0xd, 0x8d,
    0xa0, 0x0, 0xb, 0xc8, 0xf1, 0x5f, 0x4, 0x54,
    0x8f, 0xfb, 0x49, 0xe0, 0x7e, 0xfd, 0x87, 0xdf,
    0xe5, 0x0,

    /* U+0648 "و" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfe, 0x30, 0x8,
    0xd4, 0xbd, 0x0, 0xe5, 0x2, 0xf2, 0xe, 0xa4,
    0x5f, 0x40, 0x5d, 0xfe, 0xf3, 0x0, 0x0, 0x7e,
    0x0, 0x2, 0x8f, 0x50, 0x3e, 0xfd, 0x40, 0x1,
    0x73, 0x0, 0x0,

    /* U+0649 "ى" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xaf, 0xfa, 0x0, 0x0, 0x0, 0x1e,
    0xc5, 0x54, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x1f, 0x20,
    0x0, 0x8f, 0xa4, 0x0, 0x6e, 0x0, 0x0, 0x4,
    0xaf, 0xc0, 0x8d, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x6f, 0x10, 0x0, 0x0, 0x9, 0xe0, 0x1e, 0xd6,
    0x21, 0x26, 0xce, 0x30, 0x2, 0xbf, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x33, 0x20, 0x0, 0x0,

    /* U+064A "ي" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xaf, 0xfa, 0x0, 0x0, 0x0, 0x1e,
    0xc5, 0x54, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x1f, 0x20,
    0x0, 0x8f, 0xa4, 0x0, 0x6e, 0x0, 0x0, 0x4,
    0xaf, 0xc0, 0x8d, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x6f, 0x10, 0x0, 0x0, 0x9, 0xe0, 0x1e, 0xd6,
    0x21, 0x26, 0xce, 0x30, 0x2, 0xbf, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x33, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x71, 0x63, 0x0, 0x0, 0x0, 0x1,
    0xe4, 0xc7, 0x0, 0x0,

    /* U+064B "ً" */
    0x0, 0x1, 0x1, 0x7c, 0xd2, 0x37, 0x35, 0x13,
    0xcd, 0x81, 0x12, 0x0, 0x0,

    /* U+064F "ُ" */
    0x2, 0xca, 0x0, 0x85, 0xb2, 0x2, 0xdc, 0x7,
    0xc8, 0x10,

    /* U+067E "پ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40,
    0x2a, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb0,
    0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf0,
    0x7d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf1,
    0x6f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x1d, 0xfb, 0x87, 0x66, 0x66, 0x78, 0xcf, 0x50,
    0x1, 0x7c, 0xef, 0xff, 0xfe, 0xca, 0x61, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x72, 0x63, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe5, 0xc7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,

    /* U+0698 "ژ" */
    0x0, 0x6, 0x30, 0x0, 0xc, 0x70, 0x0, 0x73,
    0x54, 0x0, 0xd6, 0xb9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xe1, 0x0, 0x0, 0xe7,
    0x0, 0x0, 0x8b, 0x0, 0x0, 0x6c, 0x0, 0x0,
    0x8b, 0x0, 0x1, 0xe5, 0x0, 0x2d, 0xc0, 0x29,
    0xfb, 0x10, 0x1c, 0x50, 0x0,

    /* U+06A9 "ک" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x16, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfd, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xe6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfa, 0x0, 0x0, 0x2a, 0x0, 0x0,
    0x0, 0x2, 0xeb, 0x0, 0x5, 0xe0, 0x0, 0x0,
    0x0, 0x2, 0xe7, 0x0, 0x7d, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xe0, 0x6, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x0, 0x1d, 0xf9, 0x65, 0x55, 0x57,
    0x9e, 0xb0, 0x0, 0x17, 0xce, 0xff, 0xfe, 0xda,
    0x50, 0x0,

    /* U+06AF "گ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xce, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xe7, 0x26, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x92, 0x9f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x38, 0xfd, 0x50, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0x0, 0x0, 0x2a, 0x0, 0x0, 0x0,
    0x2, 0xeb, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0,
    0x2, 0xe7, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xe0, 0x6, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x0, 0x1d, 0xf9, 0x65, 0x55, 0x57, 0x9e,
    0xb0, 0x0, 0x17, 0xce, 0xff, 0xfe, 0xda, 0x50,
    0x0,

    /* U+06CC "ی" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xaf, 0xfa, 0x0, 0x0, 0x0, 0x1e,
    0xc5, 0x54, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x1f, 0x20,
    0x0, 0x8f, 0xa4, 0x0, 0x6e, 0x0, 0x0, 0x4,
    0xaf, 0xc0, 0x8d, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x6f, 0x10, 0x0, 0x0, 0x9, 0xe0, 0x1e, 0xd6,
    0x21, 0x26, 0xce, 0x30, 0x2, 0xbf, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x33, 0x20, 0x0, 0x0,

    /* U+0901 "ँ" */
    0x0, 0x3, 0x0, 0x2, 0xb0, 0xf6, 0x66, 0xe,
    0x73, 0x3e, 0x50, 0x3c, 0xfe, 0x70,

    /* U+0902 "ं" */
    0x42, 0xec, 0x43,

    /* U+0903 "ः" */
    0xff, 0xf7, 0x22, 0x21, 0x7, 0x20, 0x5f, 0x80,
    0x7, 0x20, 0x0, 0x0, 0x7, 0x20, 0x5f, 0x80,
    0x7, 0x20,

    /* U+0905 "अ" */
    0x0, 0x7e, 0xfe, 0x70, 0xaf, 0xff, 0x70, 0x4,
    0x52, 0x5f, 0x31, 0x9d, 0x21, 0x0, 0x0, 0x0,
    0xf4, 0x8, 0xc0, 0x0, 0x0, 0x27, 0xce, 0x11,
    0x8c, 0x0, 0x4b, 0x4, 0xcd, 0xff, 0xff, 0xc0,
    0x2, 0xf3, 0x0, 0x1e, 0x51, 0x8c, 0x0, 0xa,
    0xb0, 0x0, 0xa9, 0x8, 0xc0, 0x0, 0x1e, 0x92,
    0x4e, 0x60, 0x8c, 0x0, 0x0, 0x2c, 0xff, 0x90,
    0x8, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8c,
    0x0,

    /* U+0906 "आ" */
    0x0, 0x7e, 0xfe, 0x70, 0xaf, 0xff, 0xff, 0xff,
    0x90, 0x4, 0x52, 0x5f, 0x31, 0x9d, 0x22, 0x7f,
    0x21, 0x0, 0x0, 0x0, 0xf4, 0x8, 0xc0, 0x5,
    0xf0, 0x0, 0x0, 0x27, 0xce, 0x11, 0x8c, 0x0,
    0x5f, 0x0, 0x4b, 0x4, 0xcd, 0xff, 0xff, 0xc0,
    0x5, 0xf0, 0x2, 0xf3, 0x0, 0x1e, 0x51, 0x8c,
    0x0, 0x5f, 0x0, 0xa, 0xb0, 0x0, 0xa9, 0x8,
    0xc0, 0x5, 0xf0, 0x0, 0x1e, 0x92, 0x4e, 0x60,
    0x8c, 0x0, 0x5f, 0x0, 0x0, 0x2c, 0xff, 0x90,
    0x8, 0xc0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8c, 0x0, 0x5f, 0x0,

    /* U+0907 "इ" */
    0xff, 0xff, 0xff, 0xff, 0x12, 0x22, 0x22, 0xd8,
    0x20, 0x0, 0x1, 0x1d, 0x70, 0x0, 0xaf, 0xff,
    0xf7, 0x0, 0x2f, 0x41, 0x21, 0x0, 0x0, 0xdb,
    0xdf, 0xe5, 0x0, 0x2, 0xa4, 0x18, 0xf0, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x3f, 0x91, 0x3b, 0xe0,
    0x1, 0xbf, 0xfe, 0xa2, 0x0, 0x0, 0x3f, 0x50,
    0x0, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x0, 0x0,
    0x50, 0x0, 0x0,

    /* U+0909 "उ" */
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x22, 0x22, 0x25,
    0xf5, 0x20, 0x0, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x3, 0x4, 0xdf, 0xe0,
    0x0, 0x6e, 0x1, 0x65, 0xf6, 0x0, 0xf, 0x50,
    0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0, 0x6f, 0x0,
    0x0, 0xdb, 0x44, 0xdb, 0x0, 0x0, 0x1a, 0xff,
    0xb1, 0x0,

    /* U+090F "ए" */
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x2c, 0xa2, 0x22,
    0xca, 0x20, 0xb, 0x90, 0x0, 0xb9, 0x0, 0xb,
    0x90, 0x0, 0xb9, 0x0, 0xb, 0x90, 0x0, 0xd8,
    0x0, 0xa, 0xa0, 0xc, 0xf2, 0x0, 0x5, 0xf6,
    0x5, 0x20, 0x0, 0x0, 0x5e, 0xd5, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0xb1, 0x0, 0x0, 0x0, 0x1,
    0xe8, 0x0, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0x41, 0x0,

    /* U+0915 "क" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x82, 0x22,
    0x22, 0x2f, 0x62, 0x22, 0x21, 0x0, 0x0, 0x11,
    0xf5, 0x0, 0x0, 0x0, 0x4d, 0xff, 0x5f, 0x50,
    0x0, 0x0, 0x1f, 0x92, 0x0, 0xfd, 0xff, 0xb0,
    0x3, 0xf1, 0x0, 0xf, 0xb2, 0x2e, 0x70, 0x1f,
    0x81, 0x3b, 0xf5, 0x0, 0xa9, 0x0, 0x4d, 0xff,
    0x9f, 0x50, 0xe, 0x60, 0x0, 0x1, 0x0, 0xf5,
    0x8, 0xd0, 0x0, 0x0, 0x0, 0xf, 0x50, 0x1,
    0x0,

    /* U+0916 "ख" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x22,
    0x2b, 0xb2, 0x23, 0x22, 0xab, 0x20, 0x0, 0x8,
    0xc0, 0x5e, 0xfa, 0xaa, 0x0, 0x2b, 0x5c, 0xa1,
    0xf7, 0x14, 0xaa, 0x0, 0x4f, 0xff, 0x54, 0xf0,
    0x0, 0xaa, 0x0, 0xf, 0xf7, 0x1, 0xf6, 0x13,
    0xda, 0x0, 0x7, 0xd0, 0x0, 0x5e, 0xff, 0xfa,
    0x0, 0x0, 0xbb, 0x10, 0x0, 0x0, 0xaa, 0x0,
    0x0, 0xb, 0xe7, 0x32, 0x37, 0xfa, 0x0, 0x0,
    0x0, 0x5b, 0xef, 0xeb, 0xca, 0x0,

    /* U+0917 "ग" */
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x22, 0xf6, 0x22,
    0xca, 0x20, 0x0, 0xf5, 0x0, 0xb9, 0x0, 0x0,
    0xf5, 0x0, 0xb9, 0x0, 0x2b, 0xf5, 0x0, 0xb9,
    0x0, 0x3f, 0xf5, 0x0, 0xb9, 0x0, 0x9, 0xf4,
    0x0, 0xb9, 0x0, 0x0, 0x10, 0x0, 0xb9, 0x0,
    0x0, 0x0, 0x0, 0xb9, 0x0, 0x0, 0x0, 0x0,
    0xb9, 0x0,

    /* U+091A "च" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x62, 0x22, 0x22,
    0x22, 0xac, 0x20, 0x1, 0x11, 0x11, 0x9, 0xb0,
    0x6, 0xff, 0xff, 0xf2, 0x9b, 0x0, 0x1, 0x7e,
    0x41, 0x9, 0xb0, 0x0, 0xc, 0x80, 0x0, 0x9b,
    0x0, 0x0, 0xad, 0x21, 0x7f, 0xb0, 0x0, 0x1,
    0xbf, 0xfd, 0xdb, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x0,

    /* U+091C "ज" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x12, 0x22,
    0x22, 0x22, 0x22, 0xd8, 0x20, 0x0, 0x0, 0x1,
    0x11, 0x1d, 0x70, 0x3, 0x90, 0x6, 0xff, 0xff,
    0xf7, 0x0, 0x2f, 0x10, 0x2d, 0x81, 0x1d, 0x70,
    0x0, 0xc8, 0x0, 0x3f, 0x10, 0xd7, 0x0, 0x4,
    0xf1, 0x0, 0xf4, 0xd, 0x70, 0x0, 0xa, 0xc2,
    0x4f, 0x30, 0xd7, 0x0, 0x0, 0xa, 0xff, 0x80,
    0xd, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd7,
    0x0,

    /* U+091F "ट" */
    0xff, 0xff, 0xff, 0xff, 0x42, 0x22, 0x22, 0xe7,
    0x20, 0x0, 0x0, 0xe, 0x60, 0x0, 0x19, 0xef,
    0xf6, 0x0, 0xc, 0xd4, 0x11, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x1,
    0xf4, 0x0, 0x0, 0x0, 0xa, 0xe6, 0x35, 0xb8,
    0x0, 0x8, 0xef, 0xe9, 0x10,

    /* U+0921 "ड" */
    0x2f, 0xff, 0xff, 0xff, 0xfb, 0x2, 0x22, 0x22,
    0x4f, 0x41, 0x0, 0x0, 0x1, 0x3f, 0x20, 0x0,
    0x2d, 0xff, 0xff, 0x20, 0x0, 0x7d, 0x11, 0x11,
    0x0, 0x0, 0x4f, 0x9f, 0xfd, 0x20, 0x0, 0x4,
    0x92, 0x2c, 0xa0, 0x3, 0x90, 0x0, 0x7, 0xc0,
    0x4, 0xed, 0x63, 0x5e, 0x90, 0x0, 0x19, 0xdf,
    0xe9, 0x0,

    /* U+0923 "ण" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x2c, 0xa2,
    0x2a, 0xc2, 0x4f, 0x41, 0xb, 0x90, 0x9, 0xb0,
    0x2f, 0x20, 0xb, 0x90, 0x9, 0xb0, 0x2f, 0x20,
    0xb, 0x90, 0x9, 0xb0, 0x2f, 0x20, 0xa, 0x90,
    0xa, 0xb0, 0x2f, 0x20, 0x6, 0xe2, 0x2e, 0x70,
    0x2f, 0x20, 0x0, 0xaf, 0xfb, 0x0, 0x2f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x20,

    /* U+0924 "त" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x22, 0x22, 0x22,
    0xab, 0x20, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x11, 0xab, 0x0, 0x5, 0xdf, 0xff, 0xfb,
    0x0, 0x2f, 0x82, 0x11, 0xab, 0x0, 0x4f, 0x0,
    0x0, 0x9b, 0x0, 0x1f, 0x40, 0x0, 0x9b, 0x0,
    0x7, 0xe2, 0x0, 0x9b, 0x0, 0x0, 0xaa, 0x0,
    0x9b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0925 "थ" */
    0x6, 0xef, 0xa0, 0xbf, 0xff, 0x70, 0xf6, 0x2e,
    0x73, 0xad, 0x42, 0xe, 0x80, 0xa9, 0x8, 0xc0,
    0x0, 0x3b, 0x1e, 0x70, 0x8c, 0x0, 0x3, 0x7e,
    0xc0, 0x8, 0xc0, 0x0, 0xde, 0x60, 0x0, 0x8c,
    0x0, 0x4, 0xf7, 0x12, 0x7f, 0xc0, 0x0, 0x4,
    0xdf, 0xfd, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0,

    /* U+0926 "द" */
    0xff, 0xff, 0xff, 0xff, 0xa2, 0x22, 0x22, 0x7f,
    0x21, 0x0, 0x0, 0x6, 0xf0, 0x0, 0x2a, 0xff,
    0xff, 0x0, 0xd, 0xc4, 0x11, 0x0, 0x1, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0x30, 0x8, 0xc3, 0x0,
    0xbd, 0x41, 0xcf, 0x90, 0x0, 0x9e, 0xff, 0xf2,
    0x0, 0x0, 0x1, 0x1f, 0x40, 0x0, 0x0, 0x0,
    0x98, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0927 "ध" */
    0x7, 0xee, 0xa0, 0xef, 0xff, 0x11, 0xf3, 0xf,
    0x32, 0xe8, 0x20, 0x2f, 0x12, 0xe1, 0xe, 0x60,
    0x0, 0xbb, 0x11, 0x10, 0xe6, 0x0, 0x0, 0xef,
    0xf4, 0xe, 0x60, 0x0, 0x5f, 0x31, 0x0, 0xe6,
    0x0, 0x4, 0xf4, 0x12, 0x8f, 0x60, 0x0, 0x7,
    0xef, 0xfd, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0,

    /* U+0928 "न" */
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x22, 0x22, 0x22,
    0xd8, 0x20, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0,
    0x11, 0x11, 0xd7, 0x0, 0x4f, 0xff, 0xff, 0xf7,
    0x0, 0x3f, 0xf5, 0x11, 0xd7, 0x0, 0x6, 0xd1,
    0x0, 0xd7, 0x0, 0x0, 0x0, 0x0, 0xd7, 0x0,
    0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0xd7, 0x0,

    /* U+092A "प" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x2c, 0xa2, 0x22,
    0xab, 0x20, 0xb, 0x90, 0x0, 0xaa, 0x0, 0xb,
    0x90, 0x0, 0xaa, 0x0, 0xb, 0x90, 0x0, 0xaa,
    0x0, 0x7, 0xe3, 0x15, 0xea, 0x0, 0x0, 0x9f,
    0xfe, 0xea, 0x0, 0x0, 0x0, 0x0, 0xaa, 0x0,
    0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0,
    0xaa, 0x0,

    /* U+092B "फ" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x92, 0xca,
    0x22, 0x2f, 0x72, 0x22, 0x21, 0xb, 0x90, 0x0,
    0xf5, 0x0, 0x0, 0x0, 0xb9, 0x0, 0xf, 0x50,
    0x0, 0x0, 0xb, 0x90, 0x0, 0xfd, 0xff, 0xb1,
    0x0, 0x7e, 0x21, 0x6f, 0xb2, 0x2d, 0x80, 0x0,
    0xbf, 0xfd, 0xf5, 0x0, 0xa9, 0x0, 0x0, 0x0,
    0xf, 0x50, 0xe, 0x70, 0x0, 0x0, 0x0, 0xf5,
    0x8, 0xe0, 0x0, 0x0, 0x0, 0xf, 0x50, 0x2,
    0x0,

    /* U+092C "ब" */
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x22, 0x22, 0x22,
    0xac, 0x20, 0x0, 0x0, 0x12, 0x9b, 0x0, 0x3,
    0xcf, 0xfb, 0x9b, 0x0, 0x1f, 0x9e, 0x50, 0x9b,
    0x0, 0x3f, 0x13, 0xe2, 0x9b, 0x0, 0x1f, 0x81,
    0x7d, 0xeb, 0x0, 0x4, 0xcf, 0xfd, 0xdb, 0x0,
    0x0, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0,
    0x9b, 0x0,

    /* U+092D "भ" */
    0x9, 0xfe, 0x70, 0x9f, 0xff, 0xf7, 0x3f, 0x25,
    0xf2, 0x24, 0xae, 0x42, 0x2f, 0x50, 0xf4, 0x0,
    0x7d, 0x0, 0x5, 0xd4, 0xf5, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0xf5, 0x11, 0x8d, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x1f, 0xf5, 0x11,
    0x8d, 0x0, 0x0, 0x2, 0x91, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0x0,

    /* U+092E "म" */
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x22, 0xf6, 0x22,
    0x4f, 0x41, 0x0, 0xf5, 0x0, 0x2f, 0x20, 0x0,
    0xf5, 0x0, 0x2f, 0x20, 0x0, 0xf5, 0x11, 0x3f,
    0x20, 0x4f, 0xff, 0xff, 0xff, 0x20, 0x1e, 0xf5,
    0x11, 0x3f, 0x20, 0x2, 0x91, 0x0, 0x2f, 0x20,
    0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x0,
    0x2f, 0x20,

    /* U+092F "य" */
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x22, 0x9d, 0x22,
    0x8e, 0x21, 0x0, 0x3f, 0x10, 0x7d, 0x0, 0x0,
    0x9f, 0x0, 0x7d, 0x0, 0x4f, 0xe5, 0x0, 0x7d,
    0x0, 0x1f, 0x40, 0x0, 0x8d, 0x0, 0x9, 0xd3,
    0x16, 0xfd, 0x0, 0x0, 0x9f, 0xfd, 0xbd, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0,
    0x7d, 0x0,

    /* U+0930 "र" */
    0xff, 0xff, 0xff, 0xc2, 0x22, 0x3f, 0x61, 0x0,
    0x0, 0xe5, 0x0, 0x71, 0x2f, 0x40, 0x4f, 0xee,
    0xc0, 0x0, 0xef, 0x80, 0x0, 0x5, 0xe2, 0x0,
    0x0, 0x8, 0xe2, 0x0, 0x0, 0x9, 0xe3, 0x0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,

    /* U+0932 "ल" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x22, 0x22,
    0x22, 0x22, 0xe8, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xe6, 0x0, 0x5, 0xef, 0xe6, 0xcf, 0xf6, 0x0,
    0x1f, 0x81, 0x4f, 0xb2, 0xe6, 0x0, 0x4f, 0x0,
    0x4f, 0x20, 0xe6, 0x0, 0x2f, 0x20, 0x4a, 0x0,
    0xe6, 0x0, 0xc, 0xa0, 0x0, 0x0, 0xe6, 0x0,
    0x2, 0xeb, 0x10, 0x0, 0xe6, 0x0, 0x0, 0x2d,
    0x90, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0935 "व" */
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x22, 0x22, 0x22,
    0xd8, 0x20, 0x0, 0x0, 0x12, 0xd7, 0x0, 0x4,
    0xdf, 0xf8, 0xd7, 0x0, 0x1f, 0x92, 0x0, 0xd7,
    0x0, 0x3f, 0x10, 0x0, 0xd7, 0x0, 0x1f, 0x81,
    0x29, 0xf7, 0x0, 0x4, 0xdf, 0xfc, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0xd7, 0x0,

    /* U+0936 "श" */
    0x3, 0xde, 0xd3, 0x4f, 0xff, 0xf1, 0xb, 0x80,
    0x5e, 0x12, 0xd8, 0x20, 0xa, 0xa1, 0xf, 0x30,
    0xd7, 0x0, 0x2, 0xbf, 0x1f, 0x40, 0xd7, 0x0,
    0x0, 0x0, 0x7f, 0x10, 0xd7, 0x0, 0x28, 0x58,
    0xfa, 0x0, 0xd7, 0x0, 0x8f, 0xff, 0xa0, 0x0,
    0xd7, 0x0, 0x18, 0x8e, 0x40, 0x0, 0xd7, 0x0,
    0x0, 0x5, 0xf3, 0x0, 0xd7, 0x0, 0x0, 0x0,
    0x99, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0937 "ष" */
    0xff, 0xff, 0xff, 0xff, 0xf7, 0x2c, 0xfa, 0x22,
    0x8d, 0x21, 0xb, 0xad, 0x50, 0x7d, 0x0, 0xb,
    0x92, 0xe3, 0x7d, 0x0, 0xb, 0x90, 0x5e, 0x8d,
    0x0, 0x7, 0xe3, 0x1b, 0xfd, 0x0, 0x0, 0x9f,
    0xff, 0xed, 0x0, 0x0, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0,
    0x7d, 0x0,

    /* U+0938 "स" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x22, 0x29,
    0xd2, 0x32, 0xe7, 0x20, 0x0, 0x6, 0xe0, 0x0,
    0xe6, 0x0, 0x4, 0x8, 0xd0, 0x0, 0xe6, 0x0,
    0x4f, 0xdf, 0xb2, 0x13, 0xf6, 0x0, 0x1f, 0xf9,
    0xcf, 0xff, 0xf6, 0x0, 0x8, 0xc0, 0x0, 0x10,
    0xe6, 0x0, 0x0, 0xca, 0x0, 0x0, 0xe6, 0x0,
    0x0, 0x1e, 0xa0, 0x0, 0xe6, 0x0, 0x0, 0x2,
    0xe4, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0939 "ह" */
    0xff, 0xff, 0xff, 0xff, 0xb2, 0x22, 0x22, 0x5f,
    0x31, 0x0, 0x0, 0x14, 0xf1, 0x0, 0x6f, 0xff,
    0xff, 0x10, 0xd, 0x91, 0x11, 0x10, 0x0, 0x7e,
    0xef, 0xfa, 0x0, 0x8, 0xe4, 0x13, 0xd8, 0x0,
    0xd7, 0x0, 0x8, 0xb0, 0xd, 0x80, 0x3, 0xe8,
    0x0, 0x7f, 0x30, 0x2a, 0x0, 0x0, 0x9f, 0x91,
    0x0, 0x0, 0x0, 0x4d, 0xe0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0,

    /* U+093C "़" */
    0x4b, 0x16, 0xf2, 0x0, 0x0,

    /* U+093E "ा" */
    0xff, 0xff, 0x62, 0xac, 0x20, 0x9, 0xb0, 0x0,
    0x9b, 0x0, 0x9, 0xb0, 0x0, 0x9b, 0x0, 0x9,
    0xb0, 0x0, 0x9b, 0x0, 0x9, 0xb0, 0x0, 0x9b,
    0x0,

    /* U+093F "ि" */
    0x2, 0xae, 0xfe, 0xc7, 0x10, 0x0, 0xe, 0xc4,
    0x23, 0x6b, 0xe5, 0x0, 0x2f, 0x30, 0x0, 0x0,
    0x4e, 0x80, 0xe, 0x60, 0x0, 0x0, 0x1, 0xd6,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x2a, 0xc2,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0940 "ी" */
    0xa, 0xff, 0x90, 0x0, 0x6, 0xf4, 0x3c, 0xa0,
    0x0, 0x7c, 0x0, 0x2f, 0x20, 0x3, 0xf1, 0x0,
    0xb7, 0x0, 0x0, 0x0, 0xff, 0xff, 0x60, 0x0,
    0x2, 0xac, 0x20, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x9,
    0xb0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0,
    0x9, 0xb0, 0x0, 0x0, 0x0, 0x9b, 0x0,

    /* U+0941 "ु" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff,
    0x80, 0x1b, 0x30, 0x82, 0x2f, 0x20, 0x9f, 0x82,
    0x15, 0xf2, 0x0, 0x4b, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x10, 0x0,

    /* U+0942 "ू" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfe, 0x70,
    0x0, 0x3f, 0x31, 0x4e, 0x90, 0x3, 0xf3, 0x10,
    0x2f, 0x50, 0x9, 0xff, 0xa0, 0x8d, 0x0, 0x0,
    0x10, 0x1, 0x40,

    /* U+0943 "ृ" */
    0x1, 0x65, 0x0, 0xd, 0xc5, 0x0, 0x3f, 0x0,
    0x0, 0x2f, 0x41, 0x61, 0x7, 0xff, 0xe3, 0x0,
    0x0, 0x0,

    /* U+0947 "े" */
    0x0, 0x0, 0x0, 0x8f, 0xf9, 0x0, 0x12, 0x3d,
    0x60, 0x0, 0x5, 0xd0, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0x52,

    /* U+0948 "ै" */
    0x0, 0x0, 0x0, 0x6f, 0xf8, 0x0, 0x12, 0x2d,
    0x40, 0xaf, 0xe8, 0xc0, 0x22, 0x2a, 0xf2, 0x0,
    0x0, 0x62,

    /* U+0949 "ॉ" */
    0x69, 0x0, 0xc, 0x34, 0xf4, 0x17, 0xf1, 0x7,
    0xef, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0x60, 0x2, 0xac, 0x20, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x9b, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x9b, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x9b,
    0x0,

    /* U+094B "ो" */
    0x5f, 0xfa, 0x0, 0x0, 0x14, 0x3c, 0x90, 0x0,
    0x0, 0x2, 0xf1, 0x0, 0x0, 0x0, 0xc7, 0x0,
    0x0, 0xf, 0xff, 0xf6, 0x0, 0x2, 0xac, 0x20,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x9b, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x9b, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x9b, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x9b, 0x0,

    /* U+094D "्" */
    0x1, 0x0, 0x0, 0xcf, 0xd3, 0x0, 0x12, 0x7f,
    0x30, 0x0, 0x7, 0xd0, 0x0, 0x0, 0x10,

    /* U+0E01 "ก" */
    0x8, 0xef, 0xea, 0x10, 0x9f, 0x63, 0x5d, 0xd0,
    0xea, 0x0, 0x3, 0xf3, 0x4b, 0xd1, 0x2, 0xf4,
    0x5f, 0x70, 0x2, 0xf4, 0xbb, 0x0, 0x2, 0xf4,
    0xca, 0x0, 0x2, 0xf4, 0xca, 0x0, 0x2, 0xf4,
    0xca, 0x0, 0x2, 0xf4,

    /* U+0E02 "ข" */
    0xe, 0xf8, 0x0, 0xf7, 0x3, 0x9e, 0x0, 0xf7,
    0x0, 0xab, 0x0, 0xf7, 0x5, 0xf3, 0x0, 0xf7,
    0xb, 0xb0, 0x0, 0xf7, 0xc, 0xa0, 0x0, 0xf7,
    0xb, 0xb0, 0x0, 0xf7, 0x7, 0xf6, 0x38, 0xf3,
    0x0, 0x8e, 0xfd, 0x60,

    /* U+0E04 "ค" */
    0x6, 0xdf, 0xfc, 0x40, 0x4f, 0x93, 0x4b, 0xf2,
    0x9d, 0x0, 0x0, 0xf7, 0xbb, 0x0, 0x0, 0xe8,
    0xbc, 0xaf, 0x90, 0xe8, 0xbf, 0x93, 0x10, 0xe8,
    0xbd, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8,

    /* U+0E07 "ง" */
    0xd9, 0xe, 0xfc, 0x30, 0x8e, 0x1, 0x2b, 0xf2,
    0x3f, 0x30, 0x0, 0xf8, 0xe, 0x80, 0x0, 0xcb,
    0xa, 0xd0, 0x0, 0xbb, 0x5, 0xf1, 0x0, 0xe9,
    0x0, 0xf6, 0x4, 0xf4, 0x0, 0xbc, 0x5e, 0xb0,
    0x0, 0x6f, 0xe9, 0x0,

    /* U+0E08 "จ" */
    0x2b, 0xef, 0xea, 0x10, 0x59, 0x43, 0x5e, 0xd0,
    0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0xf7,
    0xd, 0xfb, 0x0, 0xe8, 0x2, 0xbb, 0x0, 0xf7,
    0x0, 0xab, 0x3, 0xf4, 0x0, 0xac, 0x4c, 0xd0,
    0x0, 0xaf, 0xfa, 0x10,

    /* U+0E09 "ฉ" */
    0x4b, 0xef, 0xea, 0x10, 0x78, 0x43, 0x5e, 0xd0,
    0x0, 0x0, 0x4, 0xf3, 0x11, 0x0, 0x1, 0xf5,
    0xbb, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xac, 0x0, 0x5, 0xf6, 0x6f, 0x73, 0x6e, 0xf6,
    0x9, 0xef, 0xd4, 0xd6,

    /* U+0E0A "ช" */
    0xe, 0xf8, 0x0, 0xd9, 0x3, 0x9e, 0x2, 0xf6,
    0x0, 0xab, 0x2f, 0xd0, 0x5, 0xf3, 0x2, 0xf5,
    0xb, 0xb0, 0x0, 0xf7, 0xc, 0xa0, 0x0, 0xf7,
    0xb, 0xb0, 0x0, 0xf7, 0x7, 0xf6, 0x38, 0xf3,
    0x0, 0x8e, 0xfd, 0x60,

    /* U+0E0B "ซ" */
    0x4f, 0x2c, 0x40, 0xbb, 0xb, 0xcf, 0x31, 0xe7,
    0x0, 0x9d, 0x1f, 0xe1, 0x5, 0xf3, 0x1, 0xf7,
    0xa, 0xc0, 0x0, 0xd8, 0xb, 0xb0, 0x0, 0xd9,
    0xa, 0xc0, 0x0, 0xe8, 0x6, 0xf6, 0x37, 0xf5,
    0x0, 0x8e, 0xfe, 0x70,

    /* U+0E13 "ณ" */
    0x8, 0xef, 0xe8, 0x0, 0x0, 0x4f, 0x2a, 0xe5,
    0x36, 0xf9, 0x0, 0x4, 0xf2, 0xeb, 0x0, 0x8,
    0xe0, 0x0, 0x4f, 0x23, 0xae, 0x30, 0x7f, 0x0,
    0x4, 0xf2, 0x4f, 0x60, 0x7, 0xf0, 0x0, 0x4f,
    0x2a, 0xc0, 0x0, 0x7f, 0x0, 0x4, 0xf2, 0xac,
    0x0, 0x7, 0xf0, 0x0, 0x8f, 0x2a, 0xe3, 0x0,
    0x3f, 0x93, 0x7d, 0xf2, 0x4e, 0xf2, 0x0, 0x7e,
    0xfb, 0x3f, 0x20,

    /* U+0E14 "ด" */
    0x0, 0x6d, 0xff, 0xc4, 0x0, 0x6f, 0x93, 0x3a,
    0xf2, 0xc, 0xb0, 0x0, 0xf, 0x80, 0xf7, 0x0,
    0x0, 0xd9, 0xf, 0x60, 0x0, 0xd, 0x90, 0xf7,
    0x0, 0x0, 0xd9, 0xd, 0xa0, 0x0, 0xd, 0x90,
    0x7f, 0x73, 0x10, 0xd9, 0x0, 0x8e, 0xf6, 0xd,
    0x90,

    /* U+0E15 "ต" */
    0x1b, 0xfc, 0x9f, 0xe4, 0x9e, 0x4a, 0xc3, 0xcc,
    0xd9, 0x0, 0x10, 0x8d, 0xf7, 0x0, 0x0, 0x8e,
    0xf7, 0x0, 0x0, 0x8e, 0xe8, 0x0, 0x0, 0x8e,
    0xbb, 0x0, 0x0, 0x8e, 0x6f, 0x73, 0x20, 0x8e,
    0x7, 0xef, 0x80, 0x8e,

    /* U+0E16 "ถ" */
    0x8, 0xef, 0xea, 0x20, 0x9f, 0x63, 0x5d, 0xe0,
    0xeb, 0x0, 0x3, 0xf4, 0x3a, 0xe3, 0x1, 0xf5,
    0x4f, 0x60, 0x1, 0xf5, 0xac, 0x0, 0x1, 0xf5,
    0xac, 0x0, 0x1, 0xf5, 0xad, 0x30, 0x1, 0xf5,
    0x4e, 0xf2, 0x1, 0xf5,

    /* U+0E17 "ท" */
    0xa7, 0x8e, 0xfd, 0x50, 0xae, 0xb2, 0x19, 0xf2,
    0xaf, 0x0, 0x0, 0xf6, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7, 0xac, 0x0, 0x0, 0xf7,
    0xac, 0x0, 0x0, 0xf7,

    /* U+0E19 "น" */
    0xbb, 0x0, 0x0, 0xf6, 0xbb, 0x0, 0x0, 0xf6,
    0xbb, 0x0, 0x0, 0xf6, 0xbb, 0x0, 0x0, 0xf6,
    0xbb, 0x0, 0x0, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xad, 0x0, 0x5, 0xf6, 0x6f, 0x83, 0x5e, 0xe6,
    0x8, 0xef, 0xd4, 0xc6,

    /* U+0E1A "บ" */
    0xbb, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xbb, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xbb, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf5,
    0x9d, 0x0, 0x3, 0xf4, 0x4f, 0x83, 0x4c, 0xe0,
    0x6, 0xdf, 0xfc, 0x30,

    /* U+0E1B "ป" */
    0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x1, 0xf6,
    0x0, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xbb, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xbb, 0x0, 0x1, 0xf6, 0xbb, 0x0, 0x1, 0xf6,
    0xbb, 0x0, 0x1, 0xf5, 0x9d, 0x0, 0x2, 0xf4,
    0x4f, 0x83, 0x4c, 0xe0, 0x6, 0xdf, 0xfc, 0x30,

    /* U+0E1C "ผ" */
    0x3e, 0xf2, 0x0, 0x7f, 0x9e, 0x30, 0x0, 0x7f,
    0xac, 0x0, 0x0, 0x7f, 0xac, 0x6, 0xa0, 0x7f,
    0xac, 0x1f, 0xf5, 0x7f, 0xac, 0x9b, 0x5e, 0x7f,
    0xad, 0xf2, 0xc, 0xdf, 0xaf, 0x80, 0x3, 0xff,
    0xae, 0x0, 0x0, 0x9f,

    /* U+0E1E "พ" */
    0x4f, 0x30, 0x2f, 0x40, 0x1f, 0x61, 0xf5, 0x7,
    0xf8, 0x3, 0xf3, 0xe, 0x80, 0xbc, 0xd0, 0x6f,
    0x0, 0xba, 0xf, 0x6f, 0x18, 0xd0, 0x8, 0xd4,
    0xf0, 0xd6, 0xba, 0x0, 0x6e, 0x8a, 0x9, 0xad,
    0x70, 0x3, 0xfd, 0x50, 0x4e, 0xe5, 0x0, 0xf,
    0xf1, 0x0, 0xff, 0x20, 0x0, 0xdc, 0x0, 0xa,
    0xf0, 0x0,

    /* U+0E1F "ฟ" */
    0x0, 0x0, 0x0, 0x0, 0xe, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x34, 0xf2, 0x3, 0xf3, 0x4, 0xf1, 0x1f, 0x50,
    0x8f, 0x70, 0x6e, 0x0, 0xe7, 0xc, 0xcc, 0x8,
    0xc0, 0xc, 0x91, 0xf6, 0xf1, 0xb9, 0x0, 0x9b,
    0x5e, 0xe, 0x5c, 0x70, 0x6, 0xd9, 0x90, 0xa9,
    0xe5, 0x0, 0x4f, 0xd5, 0x5, 0xdf, 0x20, 0x1,
    0xff, 0x0, 0x1f, 0xf0, 0x0, 0xe, 0xb0, 0x0,
    0xbe, 0x0,

    /* U+0E20 "ภ" */
    0x0, 0x8d, 0xfe, 0xa2, 0x0, 0x9f, 0x63, 0x5d,
    0xe0, 0xe, 0xb0, 0x0, 0x3f, 0x40, 0x3a, 0xe3,
    0x1, 0xf5, 0x3, 0xf7, 0x0, 0x1f, 0x50, 0x8e,
    0x0, 0x1, 0xf5, 0x8, 0xe0, 0x0, 0x1f, 0x51,
    0xae, 0x0, 0x1, 0xf5, 0x9f, 0x80, 0x0, 0x1f,
    0x50,

    /* U+0E21 "ม" */
    0x9d, 0x0, 0x0, 0xe8, 0x9d, 0x0, 0x0, 0xe8,
    0x9d, 0x0, 0x0, 0xe8, 0x9d, 0x0, 0x0, 0xe8,
    0x9d, 0x0, 0x0, 0xe8, 0x9e, 0x0, 0x0, 0xe8,
    0x9f, 0x20, 0x0, 0xf7, 0x9e, 0xd5, 0x3a, 0xf3,
    0x99, 0x6d, 0xfe, 0x60,

    /* U+0E22 "ย" */
    0x2c, 0xfe, 0x3, 0xf3, 0xbd, 0x33, 0x3, 0xf3,
    0xe8, 0x0, 0x3, 0xf3, 0xad, 0x10, 0x3, 0xf3,
    0x1d, 0xfb, 0x3, 0xf3, 0x9d, 0x31, 0x3, 0xf3,
    0xd9, 0x0, 0x4, 0xf2, 0xae, 0x52, 0x4c, 0xd0,
    0x1a, 0xef, 0xfb, 0x20,

    /* U+0E23 "ร" */
    0x4, 0xcf, 0xfe, 0x70, 0x1f, 0xa3, 0x35, 0x60,
    0x3f, 0x40, 0x0, 0x0, 0xd, 0xf8, 0x20, 0x0,
    0x1, 0x8e, 0xfc, 0x20, 0x0, 0x0, 0x4d, 0xe0,
    0x0, 0x0, 0x4, 0xf2, 0x19, 0x53, 0x4b, 0xe0,
    0x2a, 0xef, 0xfb, 0x30,

    /* U+0E25 "ล" */
    0x4, 0xbe, 0xfe, 0x90, 0x7, 0x84, 0x36, 0xf8,
    0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0, 0x9d,
    0x2, 0xae, 0xff, 0xfd, 0xe, 0xd5, 0x33, 0xad,
    0x3f, 0x40, 0x0, 0x9d, 0x1f, 0x90, 0x0, 0x9d,
    0x5, 0xdf, 0xf0, 0x9d,

    /* U+0E27 "ว" */
    0x3d, 0xff, 0xb3, 0x2, 0x53, 0x4c, 0xf2, 0x0,
    0x0, 0x1f, 0x90, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x1f,
    0x80, 0x73, 0x4c, 0xf1, 0x2c, 0xff, 0xc3, 0x0,

    /* U+0E2A "ส" */
    0x0, 0x0, 0x0, 0x7, 0x40, 0x4b, 0xef, 0xeb,
    0xf3, 0x7, 0x84, 0x36, 0xf8, 0x0, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x2a,
    0xef, 0xff, 0xd0, 0xe, 0xd5, 0x33, 0xad, 0x3,
    0xf4, 0x0, 0x9, 0xd0, 0x1f, 0x90, 0x0, 0x9d,
    0x0, 0x5d, 0xff, 0x9, 0xd0,

    /* U+0E2B "ห" */
    0x9d, 0x0, 0x1d, 0xc0, 0x9d, 0x0, 0xbc, 0x0,
    0x9d, 0x9, 0xd1, 0x0, 0x9d, 0x7f, 0xfb, 0x30,
    0x9f, 0xe3, 0x4c, 0xe0, 0x9f, 0x30, 0x3, 0xf3,
    0x9d, 0x0, 0x2, 0xf4, 0x9d, 0x0, 0x2, 0xf4,
    0x9d, 0x0, 0x2, 0xf4,

    /* U+0E2D "อ" */
    0x6, 0xcf, 0xfd, 0x60, 0x0, 0x96, 0x33, 0x8f,
    0x60, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x5, 0xf1, 0xf, 0xff, 0x60, 0x4f, 0x20, 0xf7,
    0x21, 0x5, 0xf1, 0xf, 0x80, 0x0, 0x8e, 0x0,
    0x9e, 0x52, 0x6f, 0x80, 0x0, 0x9e, 0xfe, 0x80,
    0x0,

    /* U+0E2E "ฮ" */
    0x0, 0x0, 0x0, 0x6, 0x40, 0x6c, 0xff, 0xd9,
    0xf3, 0x9, 0x63, 0x38, 0xf7, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0x10, 0xff,
    0xf6, 0x4, 0xf2, 0xf, 0x72, 0x10, 0x5f, 0x10,
    0xf8, 0x0, 0x8, 0xe0, 0x9, 0xe5, 0x26, 0xf8,
    0x0, 0x9, 0xef, 0xe8, 0x0,

    /* U+0E30 "ะ" */
    0x1, 0x0, 0x5, 0xf0, 0x0, 0x2e, 0xff, 0xc0,
    0x2, 0x21, 0x0, 0x0, 0x1, 0x30, 0x0, 0x5f,
    0x0, 0x2, 0xef, 0xfc, 0x0, 0x22, 0x10,

    /* U+0E31 "ั" */
    0x1, 0x0, 0x0, 0x3, 0xf1, 0x0, 0x0, 0x1e,
    0xff, 0xff, 0xa0, 0x2, 0x22, 0x21,

    /* U+0E32 "า" */
    0x9e, 0xfd, 0x50, 0x74, 0x3b, 0xf1, 0x0, 0x3,
    0xf3, 0x0, 0x3, 0xf3, 0x0, 0x3, 0xf3, 0x0,
    0x3, 0xf3, 0x0, 0x3, 0xf3, 0x0, 0x3, 0xf3,
    0x0, 0x3, 0xf3,

    /* U+0E33 "ำ" */
    0xa, 0xc9, 0x0, 0x0, 0x0, 0x4, 0xc0, 0xd2,
    0x0, 0x0, 0x0, 0xa, 0xc9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xef, 0xd5, 0x0, 0x0, 0x0, 0x74, 0x3b,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x0, 0x0,
    0x3, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30,

    /* U+0E34 "ิ" */
    0x1c, 0xff, 0xff, 0xf9, 0x2, 0x22, 0x22, 0x21,

    /* U+0E35 "ี" */
    0x0, 0x0, 0x0, 0x43, 0x0, 0x0, 0x0, 0xc9,
    0x1c, 0xff, 0xff, 0xfa, 0x2, 0x22, 0x22, 0x21,

    /* U+0E36 "ึ" */
    0x0, 0x0, 0x9, 0xb4, 0x0, 0x0, 0x2a, 0x1b,
    0x1c, 0xff, 0xfe, 0xa8, 0x2, 0x22, 0x22, 0x20,

    /* U+0E37 "ื" */
    0x0, 0x0, 0x51, 0x33, 0x0, 0x0, 0xe4, 0x99,
    0x1c, 0xff, 0xff, 0xf9, 0x2, 0x22, 0x22, 0x21,

    /* U+0E38 "ุ" */
    0x2, 0x6, 0xf7, 0xb, 0x90, 0xb9,

    /* U+0E39 "ู" */
    0x17, 0x20, 0x54, 0x1e, 0x90, 0xa9, 0x9, 0xb0,
    0xc8, 0x2, 0xdf, 0xc2,

    /* U+0E40 "เ" */
    0x7f, 0x0, 0x7f, 0x0, 0x7f, 0x0, 0x7f, 0x0,
    0x7f, 0x0, 0x7f, 0x0, 0x7f, 0x0, 0x7f, 0x31,
    0x2d, 0xf4,

    /* U+0E41 "แ" */
    0x7f, 0x0, 0x1f, 0x50, 0x7f, 0x0, 0x1f, 0x50,
    0x7f, 0x0, 0x1f, 0x50, 0x7f, 0x0, 0x1f, 0x50,
    0x7f, 0x0, 0x1f, 0x50, 0x7f, 0x0, 0x1f, 0x50,
    0x7f, 0x0, 0x1f, 0x50, 0x7f, 0x31, 0x1f, 0x82,
    0x2d, 0xf4, 0x9, 0xfa,

    /* U+0E42 "โ" */
    0x9f, 0xff, 0xf9, 0x2b, 0xb2, 0x21, 0x4, 0xf2,
    0x0, 0x3, 0xf3, 0x0, 0x4, 0xf4, 0x0, 0x3,
    0xf3, 0x0, 0x3, 0xf3, 0x0, 0x3, 0xf3, 0x0,
    0x3, 0xf3, 0x0, 0x3, 0xf3, 0x0, 0x3, 0xf3,
    0x0, 0x3, 0xf6, 0x10, 0x0, 0xbf, 0x80,

    /* U+0E43 "ใ" */
    0x8f, 0xfa, 0x4, 0x35, 0xf5, 0x0, 0x1f, 0x50,
    0xb, 0xc0, 0x6, 0xf1, 0x0, 0x9c, 0x0, 0xa,
    0xc0, 0x0, 0xac, 0x0, 0xa, 0xc0, 0x0, 0xac,
    0x0, 0xa, 0xc0, 0x0, 0x9e, 0x30, 0x3, 0xef,
    0x20,

    /* U+0E44 "ไ" */
    0xf, 0xff, 0xfa, 0x2, 0x2d, 0xa2, 0x0, 0x3f,
    0x30, 0x0, 0x3f, 0x30, 0x0, 0x4f, 0x40, 0x0,
    0x3f, 0x30, 0x0, 0x3f, 0x30, 0x0, 0x3f, 0x30,
    0x0, 0x3f, 0x30, 0x0, 0x3f, 0x30, 0x0, 0x3f,
    0x30, 0x0, 0x3f, 0x61, 0x0, 0xb, 0xf8,

    /* U+0E47 "็" */
    0x8, 0xff, 0xff, 0x61, 0xf2, 0x0, 0x0, 0x1f,
    0x29, 0x29, 0x50, 0x8f, 0x8e, 0xd2,

    /* U+0E48 "่" */
    0x53, 0xd9, 0xd9, 0xd9,

    /* U+0E49 "้" */
    0xaf, 0x70, 0x0, 0x29, 0xb0, 0x0, 0x9f, 0xff,
    0xf1, 0x22, 0x22, 0x20,

    /* U+0E4C "์" */
    0x1c, 0xff, 0x84, 0xf4, 0x21, 0x4, 0x0, 0x0,

    /* U+1EA1 "ạ" */
    0x1, 0x9e, 0xfe, 0x90, 0x1, 0xb5, 0x37, 0xf6,
    0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0xbb,
    0x2, 0x9d, 0xee, 0xfb, 0xe, 0xc4, 0x11, 0xcb,
    0x3f, 0x30, 0x0, 0xdb, 0x1f, 0x80, 0x18, 0xfb,
    0x6, 0xef, 0xe7, 0x7b, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x0, 0x2, 0xc2, 0x0,

    /* U+1EA3 "ả" */
    0x0, 0xa, 0xe8, 0x0, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xad, 0x0, 0x0, 0x2, 0xd0, 0x0,
    0x0, 0x0, 0x20, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+1EA5 "ấ" */
    0x0, 0x0, 0x0, 0x6, 0x40, 0x0, 0x0, 0x3,
    0xf2, 0x0, 0xb, 0xf9, 0x64, 0x0, 0x9, 0x91,
    0xa7, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0, 0x19,
    0xef, 0xe9, 0x0, 0x1, 0xb5, 0x37, 0xf6, 0x0,
    0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0xbb,
    0x0, 0x29, 0xde, 0xef, 0xb0, 0xe, 0xc4, 0x11,
    0xcb, 0x3, 0xf3, 0x0, 0xd, 0xb0, 0x1f, 0x80,
    0x18, 0xfb, 0x0, 0x6e, 0xfe, 0x77, 0xb0,

    /* U+1EA7 "ầ" */
    0x56, 0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0,
    0x4, 0x5a, 0xfa, 0x0, 0x0, 0x8a, 0x1a, 0x80,
    0x0, 0x10, 0x0, 0x10, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+1EAD "ậ" */
    0x0, 0xa, 0xfa, 0x0, 0x0, 0x9b, 0x2b, 0xa0,
    0x0, 0x20, 0x0, 0x20, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xe2, 0x0,
    0x0, 0x3, 0xc1, 0x0,

    /* U+1EAF "ắ" */
    0x0, 0x0, 0x4f, 0x20, 0x0, 0x0, 0xc4, 0x0,
    0x0, 0xc2, 0x4, 0xb0, 0x0, 0x4f, 0xfe, 0x30,
    0x0, 0x0, 0x20, 0x0, 0x1, 0x9e, 0xfe, 0x90,
    0x1, 0xb5, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0xbb, 0x2, 0x9d, 0xee, 0xfb,
    0xe, 0xc4, 0x11, 0xcb, 0x3f, 0x30, 0x0, 0xdb,
    0x1f, 0x80, 0x18, 0xfb, 0x6, 0xef, 0xe7, 0x7b,

    /* U+1EBB "ẻ" */
    0x0, 0x5, 0xec, 0x10, 0x0, 0x0, 0x0, 0xa7,
    0x0, 0x0, 0x0, 0x6e, 0x40, 0x0, 0x0, 0xc,
    0x40, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x4,
    0xdf, 0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0,
    0xcc, 0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f,
    0x21, 0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22,
    0x22, 0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa,
    0x44, 0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+1EBD "ẽ" */
    0x0, 0xaf, 0x91, 0x86, 0x0, 0x4b, 0x3a, 0xfe,
    0x10, 0x1, 0x10, 0x1, 0x0, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+1EBF "ế" */
    0x0, 0x0, 0x0, 0x5, 0x60, 0x0, 0x0, 0x1,
    0xe4, 0x0, 0x7, 0xfc, 0x56, 0x0, 0x6, 0xb1,
    0x8a, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0, 0x4,
    0xdf, 0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0,
    0xcc, 0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f,
    0x21, 0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22,
    0x22, 0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa,
    0x44, 0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70,

    /* U+1EC3 "ể" */
    0x0, 0x0, 0x0, 0x9a, 0x10, 0x0, 0x0, 0x0,
    0x85, 0x0, 0x0, 0x0, 0x3b, 0x10, 0x0, 0x9f,
    0xb4, 0x30, 0x0, 0x7b, 0x19, 0x90, 0x0, 0x1,
    0x0, 0x1, 0x0, 0x0, 0x4d, 0xfe, 0x70, 0x0,
    0x4f, 0x93, 0x6f, 0x70, 0xc, 0xc0, 0x0, 0x8e,
    0x0, 0xf7, 0x0, 0x4, 0xf2, 0x1f, 0xff, 0xff,
    0xff, 0x30, 0xf7, 0x22, 0x22, 0x20, 0xc, 0xa0,
    0x0, 0x0, 0x0, 0x4f, 0xa4, 0x46, 0x80, 0x0,
    0x4c, 0xff, 0xd7, 0x0,

    /* U+1EC7 "ệ" */
    0x0, 0x9, 0xfb, 0x0, 0x0, 0x8, 0xc2, 0xaa,
    0x0, 0x0, 0x20, 0x0, 0x20, 0x0, 0x4, 0xdf,
    0xe7, 0x0, 0x4, 0xf9, 0x36, 0xf7, 0x0, 0xcc,
    0x0, 0x8, 0xe0, 0xf, 0x70, 0x0, 0x4f, 0x21,
    0xff, 0xff, 0xff, 0xf3, 0xf, 0x72, 0x22, 0x22,
    0x0, 0xca, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x44,
    0x68, 0x0, 0x4, 0xcf, 0xfd, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x70, 0x0, 0x0,
    0x0, 0xb5, 0x0, 0x0,

    /* U+1ECB "ị" */
    0x9b, 0x79, 0x0, 0xac, 0xac, 0xac, 0xac, 0xac,
    0xac, 0xac, 0xac, 0xac, 0x0, 0x9c, 0x79,

    /* U+1ED1 "ố" */
    0x0, 0x0, 0x0, 0x3, 0x70, 0x0, 0x0, 0x0,
    0xd, 0x70, 0x0, 0x5, 0xfe, 0x48, 0x0, 0x0,
    0x3c, 0x26, 0xc0, 0x0, 0x0, 0x10, 0x0, 0x10,
    0x0, 0x0, 0x4c, 0xff, 0xa1, 0x0, 0x4, 0xf9,
    0x44, 0xce, 0x10, 0xd, 0xb0, 0x0, 0x1f, 0x70,
    0xf, 0x60, 0x0, 0xb, 0xb0, 0x1f, 0x50, 0x0,
    0xa, 0xc0, 0xf, 0x60, 0x0, 0xb, 0xb0, 0xc,
    0xb0, 0x0, 0x1f, 0x70, 0x3, 0xf9, 0x34, 0xce,
    0x10, 0x0, 0x4c, 0xff, 0xa2, 0x0,

    /* U+1ED3 "ồ" */
    0x28, 0x10, 0x0, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0x0, 0x1, 0x94, 0xfe, 0x10, 0x0, 0x3, 0xd3,
    0x6c, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xcf, 0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10,
    0xdb, 0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb,
    0xb1, 0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0,
    0xb, 0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9,
    0x34, 0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20,

    /* U+1ED7 "ỗ" */
    0x0, 0x7, 0x61, 0x42, 0x0, 0x8, 0x99, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xe1, 0x0, 0x0, 0x4c, 0x25, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0xff, 0xa1, 0x0,
    0x4f, 0x94, 0x4c, 0xe1, 0xd, 0xb0, 0x0, 0x1f,
    0x70, 0xf6, 0x0, 0x0, 0xbb, 0x1f, 0x50, 0x0,
    0xa, 0xc0, 0xf6, 0x0, 0x0, 0xbb, 0xc, 0xb0,
    0x0, 0x1f, 0x70, 0x3f, 0x93, 0x4c, 0xe1, 0x0,
    0x4c, 0xff, 0xa2, 0x0,

    /* U+1ED9 "ộ" */
    0x0, 0x4, 0xfe, 0x10, 0x0, 0x4, 0xd3, 0x7d,
    0x20, 0x0, 0x20, 0x0, 0x11, 0x0, 0x4, 0xcf,
    0xfa, 0x10, 0x4, 0xf9, 0x44, 0xce, 0x10, 0xdb,
    0x0, 0x1, 0xf7, 0xf, 0x60, 0x0, 0xb, 0xb1,
    0xf5, 0x0, 0x0, 0xac, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0xcb, 0x0, 0x1, 0xf7, 0x3, 0xf9, 0x34,
    0xce, 0x10, 0x4, 0xcf, 0xfa, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x70, 0x0, 0x0,
    0x0, 0xb5, 0x0, 0x0,

    /* U+1EDB "ớ" */
    0x0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x0, 0xa,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x5f,
    0x30, 0x4, 0xcf, 0xfa, 0x19, 0xe0, 0x4, 0xf9,
    0x44, 0xcf, 0xd3, 0x0, 0xdb, 0x0, 0x1, 0xf7,
    0x0, 0xf, 0x60, 0x0, 0xb, 0xb0, 0x1, 0xf5,
    0x0, 0x0, 0xac, 0x0, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0x0, 0xcb, 0x0, 0x1, 0xf7, 0x0, 0x4,
    0xf9, 0x34, 0xce, 0x10, 0x0, 0x4, 0xcf, 0xfa,
    0x20, 0x0,

    /* U+1EDD "ờ" */
    0x0, 0x1d, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1c,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x5f,
    0x30, 0x4, 0xcf, 0xfa, 0x19, 0xe0, 0x4, 0xf9,
    0x44, 0xcf, 0xd3, 0x0, 0xdb, 0x0, 0x1, 0xf7,
    0x0, 0xf, 0x60, 0x0, 0xb, 0xb0, 0x1, 0xf5,
    0x0, 0x0, 0xac, 0x0, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0x0, 0xcb, 0x0, 0x1, 0xf7, 0x0, 0x4,
    0xf9, 0x34, 0xce, 0x10, 0x0, 0x4, 0xcf, 0xfa,
    0x20, 0x0,

    /* U+1EDF "ở" */
    0x0, 0x6, 0xeb, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x30, 0x0,
    0x0, 0x0, 0xd, 0x30, 0x1, 0x51, 0x0, 0x0,
    0x20, 0x0, 0x5f, 0x20, 0x4, 0xcf, 0xfa, 0x1a,
    0xd0, 0x4, 0xf9, 0x44, 0xcf, 0xd2, 0x0, 0xdb,
    0x0, 0x1, 0xf7, 0x0, 0xf, 0x60, 0x0, 0xb,
    0xb0, 0x1, 0xf5, 0x0, 0x0, 0xac, 0x0, 0xf,
    0x60, 0x0, 0xb, 0xb0, 0x0, 0xcb, 0x0, 0x1,
    0xf7, 0x0, 0x4, 0xf9, 0x34, 0xce, 0x10, 0x0,
    0x4, 0xcf, 0xfa, 0x20, 0x0,

    /* U+1EE3 "ợ" */
    0x0, 0x0, 0x0, 0x0, 0x28, 0x20, 0x0, 0x0,
    0x0, 0x5, 0xf2, 0x0, 0x4c, 0xff, 0xa1, 0xac,
    0x0, 0x4f, 0x94, 0x4c, 0xfd, 0x20, 0xd, 0xb0,
    0x0, 0x1f, 0x70, 0x0, 0xf6, 0x0, 0x0, 0xbb,
    0x0, 0x1f, 0x50, 0x0, 0xa, 0xc0, 0x0, 0xf6,
    0x0, 0x0, 0xbb, 0x0, 0xc, 0xb0, 0x0, 0x1f,
    0x70, 0x0, 0x4f, 0x93, 0x4c, 0xe1, 0x0, 0x0,
    0x4c, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd8, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x60, 0x0, 0x0,

    /* U+1EE5 "ụ" */
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xac, 0x0, 0x2, 0xf8, 0x6f, 0x50, 0x2c, 0xf8,
    0x8, 0xef, 0xd6, 0xb8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0x60, 0x0, 0x0, 0xc, 0x40, 0x0,

    /* U+1EE7 "ủ" */
    0x0, 0x3e, 0xc3, 0x0, 0x0, 0x0, 0x99, 0x0,
    0x0, 0x6, 0xe5, 0x0, 0x0, 0xa, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xbb, 0x0, 0x0, 0xe8,
    0xbb, 0x0, 0x0, 0xe8, 0xac, 0x0, 0x2, 0xf8,
    0x6f, 0x50, 0x2c, 0xf8, 0x8, 0xef, 0xd6, 0xb8,

    /* U+1EED "ử" */
    0x0, 0x3e, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xa0, 0x0, 0x0, 0x0, 0x5, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0xa5, 0x0, 0x2, 0x72, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x2b, 0xb0, 0x0, 0xe, 0x9b,
    0xc0, 0xbb, 0x0, 0x0, 0xef, 0xc1, 0xb, 0xb0,
    0x0, 0xe, 0x80, 0x0, 0xbb, 0x0, 0x0, 0xe8,
    0x0, 0xb, 0xb0, 0x0, 0xe, 0x80, 0x0, 0xbb,
    0x0, 0x0, 0xe8, 0x0, 0xa, 0xc0, 0x0, 0x2f,
    0x80, 0x0, 0x6f, 0x50, 0x2c, 0xf8, 0x0, 0x0,
    0x8e, 0xfd, 0x6b, 0x80, 0x0,

    /* U+200C "‌" */

    /* U+3001 "、" */
    0x4, 0x20, 0x0, 0xd, 0xe2, 0x0, 0x1, 0xce,
    0x20, 0x0, 0x1c, 0xe2, 0x0, 0x1, 0xa1,

    /* U+3002 "。" */
    0x3, 0xcd, 0x70, 0xd, 0x20, 0x95, 0x39, 0x0,
    0x39, 0x1d, 0x10, 0x86, 0x4, 0xdd, 0x90,

    /* U+3044 "い" */
    0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70,
    0x0, 0x0, 0x1, 0x92, 0x0, 0xe7, 0x0, 0x0,
    0x0, 0xc, 0xb0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0xd7, 0x0, 0x0, 0x0, 0x0, 0xc9,
    0xc, 0x80, 0x0, 0x0, 0x0, 0x7, 0xe0, 0xb9,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x38, 0xb0, 0x0,
    0x30, 0x0, 0x0, 0xe7, 0x5f, 0x0, 0xa, 0x90,
    0x0, 0xb, 0x91, 0xf6, 0x1, 0xf5, 0x0, 0x0,
    0x64, 0x9, 0xf7, 0xcd, 0x0, 0x0, 0x0, 0x0,
    0x1b, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3046 "う" */
    0x0, 0x26, 0x42, 0x0, 0x0, 0x0, 0x3, 0xcf,
    0xff, 0xfd, 0x70, 0x0, 0x0, 0x1, 0x24, 0x52,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26,
    0x9c, 0xdd, 0x92, 0x3, 0xff, 0xd9, 0x65, 0x6c,
    0xf3, 0x7, 0x10, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xe8, 0x0,
    0x0, 0x0, 0x0, 0xbe, 0x10, 0x0, 0x0, 0x16,
    0xee, 0x30, 0x0, 0x8, 0xcf, 0xf9, 0x10, 0x0,
    0x0, 0x69, 0x50, 0x0, 0x0,

    /* U+3048 "え" */
    0x0, 0x0, 0x63, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xcf, 0xfe, 0xdb, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x13, 0x57, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x33, 0x45, 0x67,
    0x8a, 0x20, 0x0, 0x0, 0xff, 0xed, 0xca, 0xfe,
    0x20, 0x0, 0x0, 0x10, 0x0, 0xa, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcd, 0x8e, 0x80, 0x0, 0x0, 0x0, 0x1c,
    0xb0, 0x7, 0xd0, 0x0, 0x0, 0x1, 0xdc, 0x0,
    0x2, 0xf3, 0x0, 0x0, 0xc, 0xd1, 0x0, 0x0,
    0xbf, 0xde, 0xf7, 0x1, 0x10, 0x0, 0x0, 0x4,
    0x65, 0x41,

    /* U+304A "お" */
    0x0, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x36, 0x50, 0xd8, 0x0, 0x2, 0xed,
    0xdf, 0xff, 0xd6, 0x3, 0xcd, 0x40, 0x4, 0x54,
    0xf5, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0xf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf7,
    0x9b, 0xdd, 0x92, 0x0, 0x0, 0x0, 0x7f, 0xd8,
    0x54, 0x5a, 0xf3, 0x0, 0x1, 0xdc, 0xf3, 0x0,
    0x0, 0xa, 0xb0, 0x0, 0xd9, 0xe, 0x40, 0x0,
    0x0, 0x6d, 0x0, 0x4f, 0x0, 0xe4, 0x0, 0x0,
    0xb, 0xb0, 0x2, 0xf5, 0xe, 0x40, 0x0, 0x2a,
    0xf3, 0x0, 0x5, 0xfe, 0xf2, 0xc, 0xef, 0xc4,
    0x0, 0x0, 0x1, 0x65, 0x0, 0x45, 0x20, 0x0,
    0x0,

    /* U+304B "か" */
    0x0, 0x0, 0x46, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaa, 0x0, 0x0, 0x37, 0x0, 0x0, 0x0,
    0xd, 0x93, 0x30, 0x2, 0xf4, 0x0, 0x9d, 0xef,
    0xff, 0xde, 0xf4, 0x8, 0xd0, 0x4, 0x53, 0x6f,
    0x0, 0xb, 0xb0, 0x1f, 0x50, 0x0, 0x9, 0xb0,
    0x0, 0x7c, 0x0, 0x9d, 0x0, 0x0, 0xe6, 0x0,
    0x7, 0xc0, 0x2, 0xf3, 0x0, 0x4f, 0x10, 0x0,
    0x8b, 0x0, 0x5, 0x0, 0xa, 0xa0, 0x0, 0xb,
    0x90, 0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0xad, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0x3f, 0x50, 0x7f, 0xef, 0x90, 0x0,
    0x0, 0x0, 0x40, 0x1, 0x46, 0x40, 0x0, 0x0,
    0x0,

    /* U+304C "が" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x20,
    0x0, 0x0, 0x6, 0x40, 0x0, 0x3, 0x84, 0xc0,
    0x0, 0x0, 0xd, 0x80, 0x0, 0x0, 0xd3, 0xa3,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x3, 0x74, 0x0,
    0x0, 0x0, 0x2f, 0x54, 0x30, 0x9, 0xd0, 0x0,
    0xd, 0xef, 0xff, 0xed, 0xfd, 0x0, 0xe7, 0x0,
    0x6, 0x42, 0xaa, 0x0, 0x1e, 0x60, 0x6e, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0xc, 0x70, 0xe, 0x70,
    0x0, 0x3, 0xf1, 0x0, 0xc, 0x70, 0x8, 0xe0,
    0x0, 0x9, 0xb0, 0x0, 0xd, 0x50, 0x2, 0x50,
    0x0, 0xf, 0x50, 0x0, 0xf, 0x40, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x3f, 0x10, 0x0, 0x0,
    0x0, 0xe7, 0x1, 0x0, 0xac, 0x0, 0x0, 0x0,
    0x8, 0xe1, 0xc, 0xee, 0xf4, 0x0, 0x0, 0x0,
    0x1, 0x30, 0x2, 0x55, 0x20, 0x0, 0x0, 0x0,

    /* U+304D "き" */
    0x0, 0x0, 0x3, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf3, 0x26, 0x60, 0x1f, 0xee, 0xdd, 0xff,
    0xfc, 0x60, 0x2, 0x33, 0x43, 0x9c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x10, 0x2, 0x36, 0x54,
    0x44, 0x5e, 0xbc, 0xfa, 0x4c, 0xcd, 0xdd, 0xcc,
    0xf7, 0x41, 0x0, 0x0, 0x0, 0x0, 0xe5, 0x0,
    0x1, 0x10, 0x0, 0x12, 0x6e, 0x10, 0xb, 0x90,
    0x0, 0x6d, 0xff, 0x50, 0xf, 0x30, 0x0, 0x0,
    0x2, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf8, 0x53, 0x34, 0x55, 0x0, 0x0, 0x5b,
    0xef, 0xff, 0xe8, 0x0,

    /* U+304F "く" */
    0x0, 0x0, 0x0, 0x37, 0x0, 0x0, 0x0, 0x3e,
    0xc0, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x7f,
    0x70, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0xcd,
    0x20, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x7,
    0xf5, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0,
    0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0x4, 0xfc,
    0x10, 0x0, 0x0, 0x2, 0xed, 0x20, 0x0, 0x0,
    0x2, 0xee, 0x30, 0x0, 0x0, 0x2, 0xc2, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+3053 "こ" */
    0x0, 0x21, 0x0, 0x1, 0x13, 0x10, 0x3, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x0, 0x22, 0x33, 0x33,
    0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xd4, 0x0, 0x0,
    0x2, 0x52, 0x2, 0xcf, 0xfe, 0xef, 0xff, 0xf5,
    0x0, 0x2, 0x56, 0x65, 0x43, 0x0,

    /* U+3055 "さ" */
    0x0, 0x0, 0x0, 0x95, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5e,
    0x14, 0x78, 0x7f, 0xed, 0xdd, 0xef, 0xfe, 0xb6,
    0x13, 0x45, 0x55, 0x4a, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa9, 0x0, 0x0, 0x0, 0x0, 0x12, 0x3f, 0x40,
    0x8, 0xc0, 0x0, 0x7f, 0xff, 0xc0, 0xe, 0x60,
    0x0, 0x0, 0x13, 0x20, 0xf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfb, 0x64, 0x34, 0x58, 0x10, 0x0, 0x3a,
    0xef, 0xff, 0xdb, 0x0,

    /* U+3057 "し" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x0, 0x0,
    0x0, 0x70, 0x3f, 0x20, 0x0, 0x0, 0x8, 0xf2,
    0x1f, 0x60, 0x0, 0x0, 0x9f, 0x60, 0xa, 0xf8,
    0x55, 0x9e, 0xf5, 0x0, 0x0, 0x8e, 0xff, 0xc7,
    0x10, 0x0,

    /* U+3059 "す" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf0, 0x0, 0x0, 0x13, 0x44, 0x55,
    0x59, 0xf6, 0x66, 0x65, 0x6e, 0xed, 0xcc, 0xcc,
    0xfb, 0xbb, 0xca, 0x0, 0x0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xd9, 0x15, 0xf2, 0x0, 0x0,
    0x0, 0x2, 0xf1, 0x0, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xf6, 0x3, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xef, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x39, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x50, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x76, 0x0, 0x0, 0x0,
    0x0,

    /* U+305B "せ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x42, 0x0, 0x0,
    0x0, 0xd, 0x40, 0x0, 0xc, 0x70, 0x0, 0x0,
    0x0, 0xe5, 0x0, 0x0, 0xc6, 0x0, 0x0, 0x0,
    0xe, 0x40, 0x0, 0xc, 0x60, 0x10, 0x0, 0x13,
    0xf9, 0x89, 0xbc, 0xff, 0xff, 0x65, 0xff, 0xef,
    0xc9, 0x86, 0x5d, 0x72, 0x10, 0x12, 0x0, 0xf4,
    0x0, 0x0, 0xd4, 0x0, 0x0, 0x0, 0xf, 0x40,
    0x0, 0xf, 0x30, 0x0, 0x0, 0x0, 0xf4, 0x1,
    0xfe, 0xf1, 0x0, 0x0, 0x0, 0xe, 0x40, 0x2,
    0x32, 0x0, 0x0, 0x0, 0x0, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xb1, 0x0, 0x1,
    0x33, 0x0, 0x0, 0x0, 0x3e, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x2, 0x44, 0x32, 0x10,
    0x0,

    /* U+305F "た" */
    0x0, 0x0, 0x2b, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7e, 0x47, 0x80, 0x0, 0x0, 0x2f, 0xff, 0xff,
    0xec, 0x80, 0x0, 0x0, 0x3, 0x33, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf3, 0x2, 0xde,
    0xee, 0xd3, 0x0, 0x5, 0xe0, 0x1, 0x54, 0x44,
    0x51, 0x0, 0xa, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x10, 0x2e, 0x0, 0x0, 0x0, 0x0, 0xbb,
    0x0, 0x4f, 0x0, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0x3f, 0x50, 0x0, 0x1, 0x9, 0xe0, 0x0, 0x8,
    0xff, 0xee, 0xf8, 0x3, 0x50, 0x0, 0x0, 0x13,
    0x44, 0x30,

    /* U+3060 "だ" */
    0x0, 0x0, 0xa4, 0x0, 0x0, 0x0, 0x81, 0x0,
    0x0, 0xf, 0x40, 0x0, 0x8, 0x66, 0xa0, 0x0,
    0x3, 0xf4, 0x58, 0x0, 0x1e, 0x1a, 0xe, 0xee,
    0xff, 0xfd, 0xb0, 0x0, 0x41, 0x0, 0x34, 0x4b,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x45, 0x66, 0x53, 0x0, 0x0, 0x2f, 0x20,
    0xd, 0xcc, 0xcc, 0xb0, 0x0, 0x6, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x40, 0x9, 0x30,
    0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0xd9, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x0, 0x5f, 0x30, 0x0, 0x6f, 0xfd, 0xef,
    0xf0, 0x2, 0x70, 0x0, 0x0, 0x4, 0x55, 0x43,
    0x0,

    /* U+3061 "ち" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x99,
    0x0, 0x0, 0x0, 0x0, 0x64, 0x3d, 0x95, 0x69,
    0xbe, 0xa0, 0xc, 0xde, 0xfe, 0xcb, 0xa8, 0x62,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb7,
    0x39, 0xcd, 0xc9, 0x20, 0x0, 0x1f, 0xdd, 0x84,
    0x35, 0xbf, 0x20, 0x7, 0xf8, 0x0, 0x0, 0x0,
    0xc9, 0x0, 0x78, 0x0, 0x0, 0x0, 0x9, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xce, 0x10, 0x0, 0xa, 0xcc,
    0xcf, 0xfb, 0x20, 0x0, 0x0, 0x37, 0x76, 0x51,
    0x0, 0x0,

    /* U+3063 "っ" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x4,
    0x8c, 0xff, 0xfb, 0x20, 0x3a, 0xef, 0xa6, 0x21,
    0x3b, 0xe1, 0x2c, 0x60, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xe1, 0x0, 0x0, 0x0, 0x37, 0xde, 0x30,
    0x0, 0x1, 0xef, 0xfd, 0x70, 0x0, 0x0, 0x0,
    0x43, 0x10, 0x0, 0x0,

    /* U+3064 "つ" */
    0x0, 0x0, 0x0, 0x13, 0x54, 0x10, 0x0, 0x0,
    0x4, 0x9d, 0xff, 0xde, 0xfa, 0x10, 0x4a, 0xef,
    0xb6, 0x20, 0x0, 0x3d, 0xc0, 0x7d, 0x71, 0x0,
    0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x17, 0xfd, 0x10, 0x0,
    0x0, 0x58, 0xad, 0xfe, 0x80, 0x0, 0x0, 0x0,
    0x5d, 0xb8, 0x40, 0x0, 0x0,

    /* U+3066 "て" */
    0x0, 0x0, 0x0, 0x0, 0x13, 0x45, 0x60, 0x47,
    0x8a, 0xcd, 0xff, 0xff, 0xfe, 0xd1, 0x8c, 0xa8,
    0x64, 0x3b, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x93, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xef, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x63, 0x0,

    /* U+3067 "で" */
    0x0, 0x0, 0x0, 0x0, 0x23, 0x45, 0x60, 0x47,
    0x9a, 0xcd, 0xff, 0xff, 0xfe, 0xd0, 0x9c, 0xa8,
    0x64, 0x3b, 0xc3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbb, 0x0, 0x11, 0xa0, 0x0, 0x0, 0x5, 0xe1,
    0x0, 0xc3, 0xa6, 0x0, 0x0, 0xc, 0x80, 0x0,
    0x3c, 0x16, 0x0, 0x0, 0xf, 0x40, 0x0, 0x2,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x93, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xef, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x62, 0x0,

    /* U+306A "な" */
    0x0, 0x0, 0x3c, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0x6a, 0x0, 0x50, 0x0, 0x7f, 0xff, 0xfe,
    0xb8, 0x3, 0xed, 0x40, 0x2, 0x26, 0xf0, 0x0,
    0x0, 0x8, 0xf8, 0x0, 0xb, 0x90, 0x0, 0x3b,
    0x0, 0x34, 0x0, 0x3f, 0x20, 0x0, 0x4e, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x6, 0xf2, 0x0, 0x0, 0x2f, 0x0, 0x0, 0x2f,
    0x80, 0x7, 0xde, 0xdf, 0x30, 0x0, 0x29, 0x0,
    0x9c, 0x32, 0x5f, 0xfa, 0x10, 0x0, 0x0, 0xd5,
    0x0, 0x2f, 0x3c, 0xe2, 0x0, 0x0, 0xbc, 0x33,
    0xae, 0x0, 0x80, 0x0, 0x0, 0x1a, 0xef, 0xd4,
    0x0, 0x0,

    /* U+306B "に" */
    0x1, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd0,
    0x0, 0x9e, 0xdd, 0xdd, 0xe0, 0x8, 0xa0, 0x0,
    0x35, 0x66, 0x66, 0x40, 0xb, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x3a, 0x1, 0x60, 0x0, 0x0, 0x0, 0xf,
    0x99, 0x5, 0xd0, 0x0, 0x0, 0x0, 0xe, 0xf4,
    0x6, 0xd0, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x2,
    0xfb, 0x76, 0x67, 0x95, 0xa, 0xb0, 0x0, 0x3a,
    0xde, 0xdd, 0xb4, 0x4, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+306E "の" */
    0x0, 0x0, 0x3, 0x67, 0x62, 0x0, 0x0, 0x0,
    0x4, 0xdf, 0xdf, 0xcf, 0xc2, 0x0, 0x0, 0x7f,
    0x70, 0x7d, 0x1, 0xae, 0x20, 0x5, 0xf4, 0x0,
    0x9b, 0x0, 0xa, 0xc0, 0xe, 0x70, 0x0, 0xd7,
    0x0, 0x2, 0xf3, 0x4f, 0x0, 0x1, 0xf4, 0x0,
    0x0, 0xd7, 0x7c, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0xc8, 0x7c, 0x0, 0xb, 0xa0, 0x0, 0x0, 0xe7,
    0x5f, 0x0, 0x2f, 0x40, 0x0, 0x4, 0xf3, 0xe,
    0xa3, 0xdb, 0x0, 0x0, 0x1d, 0xb0, 0x4, 0xff,
    0xd1, 0x0, 0x6, 0xed, 0x10, 0x0, 0x14, 0x0,
    0xb, 0xff, 0x91, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x51, 0x0, 0x0,

    /* U+306F "は" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x8,
    0xb0, 0x0, 0x0, 0x6, 0xd0, 0x0, 0x0, 0xa8,
    0x0, 0x23, 0x22, 0x8e, 0x46, 0x50, 0xd, 0x60,
    0x9, 0xff, 0xff, 0xfe, 0xc6, 0x0, 0xf3, 0x0,
    0x0, 0x0, 0x6d, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0x5, 0xe0, 0x0, 0x2, 0xf0, 0x0, 0x0,
    0x0, 0x4f, 0x0, 0x0, 0x2f, 0x15, 0x0, 0x1,
    0x24, 0xf0, 0x0, 0x2, 0xf8, 0x70, 0x3d, 0xed,
    0xff, 0x70, 0x0, 0x1f, 0xe1, 0xe, 0x60, 0x3,
    0xfd, 0xe4, 0x0, 0xfc, 0x0, 0xf6, 0x0, 0x7f,
    0x7, 0xe0, 0xc, 0x90, 0x6, 0xfe, 0xef, 0x70,
    0x0, 0x0, 0x33, 0x0, 0x0, 0x34, 0x20, 0x0,
    0x0,

    /* U+307E "ま" */
    0x0, 0x0, 0x2, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf1, 0x0, 0x11, 0xf, 0xed, 0xcc, 0xfd,
    0xef, 0xf5, 0x2, 0x34, 0x57, 0xf5, 0x32, 0x0,
    0x0, 0x0, 0x2, 0xf1, 0x0, 0x0, 0x6, 0x53,
    0x34, 0xf4, 0x56, 0x85, 0xc, 0xde, 0xef, 0xfe,
    0xdc, 0xa4, 0x0, 0x0, 0x1, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf2, 0x0, 0x0, 0x1, 0xaf,
    0xff, 0xfa, 0x30, 0x0, 0xd, 0x91, 0x1, 0xfc,
    0xfb, 0x20, 0x1f, 0x20, 0x0, 0xf4, 0x2c, 0xf5,
    0xd, 0xa3, 0x27, 0xf2, 0x0, 0x98, 0x2, 0xae,
    0xfe, 0x60, 0x0, 0x0,

    /* U+307F "み" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xee, 0xef, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x24, 0x33, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x0, 0x4, 0x20, 0x0, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0xc7, 0x0, 0x0, 0x5b, 0xff,
    0xfe, 0xa5, 0xd, 0x50, 0x0, 0xae, 0x66, 0xf3,
    0x49, 0xee, 0xf4, 0x0, 0x6d, 0x10, 0xb9, 0x0,
    0x0, 0x8f, 0xe5, 0xc, 0x60, 0x2f, 0x20, 0x0,
    0x9, 0xca, 0xe0, 0xd7, 0xb, 0xa0, 0x0, 0x2,
    0xf5, 0x2, 0x7, 0xfe, 0xe1, 0x0, 0x1, 0xdb,
    0x0, 0x0, 0x3, 0x51, 0x0, 0x5, 0xec, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xb7, 0x0, 0x0,
    0x0,

    /* U+3082 "も" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0x0, 0x0, 0x5, 0x20, 0x5d,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xff, 0xdd,
    0xf0, 0x0, 0x0, 0x0, 0x2, 0xbb, 0x54, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x0, 0x0,
    0x0, 0x24, 0x10, 0xd6, 0x0, 0x0, 0x79, 0x0,
    0x4e, 0xff, 0xfe, 0xde, 0xe0, 0x2f, 0x50, 0x0,
    0x14, 0xf7, 0x54, 0x30, 0x8, 0xd0, 0x0, 0x1,
    0xf1, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0xf6, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0x8f, 0x74, 0x47,
    0xee, 0x20, 0x0, 0x0, 0x7, 0xdf, 0xfd, 0x81,
    0x0,

    /* U+308A "り" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x60, 0x0,
    0x0, 0x0, 0xf, 0x30, 0x6c, 0xd8, 0x0, 0x2f,
    0xa, 0xc5, 0x6e, 0xa0, 0x4e, 0x8a, 0x0, 0x3,
    0xf3, 0x6e, 0xd0, 0x0, 0x0, 0xd8, 0x7f, 0x50,
    0x0, 0x0, 0xab, 0x8f, 0x0, 0x0, 0x0, 0x8c,
    0x8d, 0x0, 0x0, 0x0, 0x9b, 0x7d, 0x0, 0x0,
    0x0, 0xc9, 0x24, 0x0, 0x0, 0x2, 0xf4, 0x0,
    0x0, 0x0, 0x1d, 0xc0, 0x0, 0x0, 0x5, 0xed,
    0x10, 0x0, 0x4a, 0xef, 0x90, 0x0, 0x0, 0x2a,
    0x61, 0x0, 0x0,

    /* U+308C "れ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x0, 0x1, 0x43, 0x0, 0x0, 0x6b, 0xce,
    0xf5, 0x1a, 0xfe, 0xf7, 0x0, 0x4, 0x86, 0x8d,
    0x4e, 0x80, 0x9, 0xd0, 0x0, 0x0, 0x7, 0xee,
    0x30, 0x0, 0x6d, 0x0, 0x0, 0x0, 0xde, 0x20,
    0x0, 0x7, 0xb0, 0x0, 0x0, 0xaf, 0x90, 0x0,
    0x0, 0x99, 0x0, 0x0, 0x5f, 0xb9, 0x0, 0x0,
    0xc, 0x70, 0x0, 0x2f, 0x59, 0x90, 0x0, 0x0,
    0xe5, 0x0, 0xc, 0xa0, 0xa9, 0x0, 0x0, 0xf,
    0x40, 0x3, 0x41, 0xa, 0x90, 0x0, 0x0, 0xf9,
    0x5c, 0xa0, 0x0, 0xaa, 0x0, 0x0, 0x8, 0xff,
    0xa1, 0x0, 0x3, 0x30, 0x0, 0x0, 0x1, 0x0,
    0x0,

    /* U+3092 "を" */
    0x0, 0x0, 0xc, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x10, 0x2, 0x30, 0x0, 0x1e, 0xdd,
    0xef, 0xef, 0xff, 0xb0, 0x0, 0x3, 0x45, 0xe7,
    0x32, 0x10, 0x0, 0x0, 0x0, 0x6, 0xd0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x1e, 0xbc, 0xd8, 0x0,
    0x5c, 0xe0, 0x0, 0xcf, 0x73, 0x4f, 0x9d, 0xe8,
    0x20, 0xa, 0xe2, 0x0, 0x4e, 0xe6, 0x0, 0x0,
    0x2e, 0x30, 0xa, 0xfd, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xbc, 0x1a, 0x70, 0x0, 0x0, 0x0, 0x4,
    0xf1, 0xa, 0x80, 0x0, 0x0, 0x0, 0x7, 0xd0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x32,
    0x23, 0x57, 0x0, 0x0, 0x0, 0x5c, 0xff, 0xff,
    0xec, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+3093 "ん" */
    0x0, 0x0, 0x0, 0x51, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xaa,
    0xd9, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfd, 0x67,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0xd,
    0x60, 0x0, 0x15, 0x0, 0x5f, 0x20, 0x0, 0xc7,
    0x0, 0x6, 0xe0, 0xd, 0x90, 0x0, 0xc, 0x70,
    0x0, 0xd8, 0x4, 0xf2, 0x0, 0x0, 0xba, 0x0,
    0xae, 0x0, 0xad, 0x0, 0x0, 0x6, 0xfe, 0xfe,
    0x30, 0x2, 0x30, 0x0, 0x0, 0x4, 0x75, 0x0,
    0x0,

    /* U+30A2 "ア" */
    0x6, 0x44, 0x44, 0x44, 0x44, 0x44, 0x51, 0xf,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0x74, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0xd7,
    0x4, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x3f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x2, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0x90, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xcd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+30A3 "ィ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xc2, 0x0, 0x0, 0x0, 0x0,
    0x2d, 0xd1, 0x0, 0x0, 0x0, 0x4, 0xeb, 0x10,
    0x0, 0x0, 0x2, 0xaf, 0x70, 0x0, 0x0, 0x3,
    0xaf, 0xee, 0x0, 0x0, 0x8, 0xdf, 0xb3, 0x6e,
    0x0, 0x0, 0x7, 0x72, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0,

    /* U+30A4 "イ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x4d, 0xe5, 0x0,
    0x0, 0x0, 0x4, 0xbf, 0xf7, 0x0, 0x0, 0x1,
    0x7d, 0xfa, 0x2e, 0x70, 0x0, 0x6, 0xfe, 0x92,
    0x0, 0xe7, 0x0, 0x0, 0x4, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x74, 0x0, 0x0,

    /* U+30A6 "ウ" */
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x70, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0xe8, 0x33, 0x33, 0x33, 0x33, 0xcb, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0xe8, 0xe6, 0x0, 0x0, 0x0,
    0x2, 0xf4, 0xe6, 0x0, 0x0, 0x0, 0x8, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xae, 0x10, 0x0, 0x0, 0x0, 0xa,
    0xf4, 0x0, 0x0, 0x0, 0x5, 0xdf, 0x40, 0x0,
    0x0, 0x9, 0xef, 0xa1, 0x0, 0x0, 0x0, 0x5,
    0x82, 0x0, 0x0, 0x0,

    /* U+30A8 "エ" */
    0x9, 0x99, 0x99, 0x99, 0x99, 0x99, 0x60, 0x9,
    0xaa, 0xaa, 0xfc, 0xaa, 0xaa, 0x70, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x45, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x52,

    /* U+30A9 "ォ" */
    0x0, 0x0, 0x0, 0xb, 0x50, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x0, 0x5, 0x66, 0x66, 0x6e,
    0xa6, 0x65, 0x9, 0xcc, 0xcc, 0xdf, 0xdc, 0xc9,
    0x0, 0x0, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x0,
    0xb, 0xcc, 0x70, 0x0, 0x0, 0x1, 0xcd, 0x1b,
    0x70, 0x0, 0x0, 0x5e, 0xb1, 0xb, 0x70, 0x0,
    0xb, 0xf8, 0x0, 0xb, 0x70, 0x0, 0x6, 0x30,
    0x2, 0x1c, 0x80, 0x0, 0x0, 0x0, 0xf, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30AB "カ" */
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0xdd, 0xdd, 0xef, 0xdd,
    0xdd, 0xe6, 0x5, 0x55, 0x5a, 0xd5, 0x55, 0x5d,
    0x80, 0x0, 0x0, 0xaa, 0x0, 0x0, 0xc8, 0x0,
    0x0, 0xe, 0x70, 0x0, 0xc, 0x70, 0x0, 0x3,
    0xf2, 0x0, 0x0, 0xd6, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0xf, 0x40, 0x0, 0x2f, 0x50, 0x0, 0x1,
    0xf3, 0x0, 0x1d, 0xc0, 0x0, 0x0, 0x4f, 0x0,
    0x1c, 0xe1, 0x0, 0x21, 0xa, 0xd0, 0xd, 0xe2,
    0x0, 0xb, 0xff, 0xf6, 0x0, 0x21, 0x0, 0x0,
    0x12, 0x31, 0x0,

    /* U+30AD "キ" */
    0x0, 0x0, 0x7, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xc0, 0x14, 0x77, 0x0, 0x1, 0x25, 0x7c,
    0xfe, 0xff, 0xda, 0x0, 0x2f, 0xff, 0xcb, 0xf7,
    0x20, 0x0, 0x0, 0x4, 0x10, 0x0, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0, 0x1,
    0x41, 0x0, 0x0, 0x0, 0xad, 0x8b, 0xef, 0xf4,
    0x17, 0x9b, 0xef, 0xff, 0xb8, 0x63, 0x0, 0x1e,
    0xb8, 0x53, 0x3f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x80,
    0x0, 0x0,

    /* U+30AF "ク" */
    0x0, 0x0, 0x0, 0x82, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x30, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xc4, 0x44, 0x45, 0x10, 0x0, 0x9, 0xfe, 0xee,
    0xee, 0xfc, 0x0, 0x6, 0xf4, 0x0, 0x0, 0xf,
    0x70, 0x6, 0xf6, 0x0, 0x0, 0x6, 0xf1, 0x19,
    0xf6, 0x0, 0x0, 0x0, 0xda, 0x0, 0x93, 0x0,
    0x0, 0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xc1, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0x29,
    0xee, 0x60, 0x0, 0x0, 0x0, 0x3, 0xc7, 0x0,
    0x0, 0x0, 0x0,

    /* U+30B0 "グ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x10,
    0x0, 0x0, 0x0, 0x42, 0x0, 0x4, 0x67, 0x90,
    0x0, 0x0, 0x0, 0xea, 0x0, 0x1, 0xe1, 0xd2,
    0x0, 0x0, 0x7, 0xf3, 0x11, 0x12, 0x73, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x1, 0xdb, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0x1c, 0xd1, 0x0, 0x0, 0xe, 0x80, 0x0,
    0x3, 0xed, 0x10, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x9, 0xa0, 0x0, 0x0, 0x1, 0xe9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xaf, 0xc2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xc5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30B5 "サ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0,
    0x6, 0xe0, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x22, 0x27,
    0xe2, 0x22, 0x27, 0xf2, 0x22, 0xb, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x11, 0x17, 0xe1,
    0x11, 0x16, 0xf1, 0x11, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0,
    0x7, 0xc0, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0xaa, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x91, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B6 "ザ" */
    0x0, 0x0, 0x21, 0x0, 0x0, 0x41, 0x23, 0x60,
    0x0, 0x0, 0xe6, 0x0, 0x1, 0xf3, 0xc2, 0xd0,
    0x0, 0x0, 0xe6, 0x0, 0x1, 0xf3, 0x58, 0x61,
    0x0, 0x0, 0xe6, 0x0, 0x1, 0xf3, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x14, 0x44, 0xf8, 0x44, 0x45, 0xf7, 0x44, 0x20,
    0x0, 0x0, 0xe6, 0x0, 0x1, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x2, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x42, 0x0, 0x9, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xdd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x8f, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0,

    /* U+30B7 "シ" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xaf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xc0, 0x0, 0x0, 0x0, 0x7, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x20, 0x1d, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0xd6, 0x0, 0x7f, 0xa0, 0x0, 0x0, 0xa,
    0xf2, 0x0, 0x2, 0x30, 0x0, 0x0, 0x9f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xdf, 0x40, 0x0, 0x0, 0x0,
    0x1, 0x9f, 0xc2, 0x0, 0x0, 0x0, 0x15, 0xbf,
    0xe6, 0x0, 0x0, 0x0, 0x5, 0xff, 0xc6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x51, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30B8 "ジ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0,
    0x0, 0xca, 0x10, 0x0, 0x2a, 0xc, 0x50, 0x0,
    0x4, 0xde, 0x50, 0x0, 0xb5, 0x3d, 0x0, 0x0,
    0x0, 0x9c, 0x0, 0x3, 0xa0, 0x0, 0x5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x20, 0x4, 0xfd, 0x30,
    0x0, 0x0, 0x0, 0x1e, 0x30, 0x2, 0xbf, 0x60,
    0x0, 0x0, 0xb, 0xe1, 0x0, 0x0, 0x52, 0x0,
    0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3d,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x1, 0x9f, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x4a, 0xfe, 0x60, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B9 "ス" */
    0x0, 0x43, 0x33, 0x33, 0x33, 0x31, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x11,
    0x11, 0x11, 0x16, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x1, 0xe9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbe, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x1c, 0xe2, 0x4f, 0x90, 0x0, 0x0,
    0x4, 0xed, 0x10, 0x4, 0xf9, 0x0, 0x2, 0xaf,
    0xa0, 0x0, 0x0, 0x5f, 0x80, 0x1f, 0xe5, 0x0,
    0x0, 0x0, 0x7, 0xf2, 0x2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x20,

    /* U+30BB "セ" */
    0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x30, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x1, 0xf3, 0x3, 0x69, 0xdf, 0xe0, 0x0, 0x14,
    0x7f, 0xdf, 0xfc, 0x96, 0xf8, 0x0, 0xef, 0xfe,
    0xf8, 0x30, 0x0, 0x7e, 0x0, 0x6, 0x41, 0x1f,
    0x30, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x1, 0xf3,
    0x0, 0x1d, 0xa0, 0x0, 0x0, 0x0, 0x1f, 0x30,
    0x3, 0xb0, 0x0, 0x0, 0x0, 0x1, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x14, 0x20, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0x34, 0x43, 0x21,
    0x0,

    /* U+30BF "タ" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x2, 0xe9, 0x33, 0x33, 0x3f,
    0x80, 0x1, 0xdb, 0x0, 0x0, 0x4, 0xf3, 0x2,
    0xdc, 0x4, 0x10, 0x0, 0xbc, 0x3, 0xfb, 0x0,
    0xcf, 0x60, 0x4f, 0x40, 0x3, 0x0, 0x0, 0x7f,
    0xbd, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xfb, 0xf8, 0x0,
    0x0, 0x0, 0x2d, 0xe3, 0x7, 0x40, 0x0, 0x1,
    0x8f, 0xc1, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30C0 "ダ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0,
    0x0, 0x0, 0x0, 0x33, 0x0, 0x4, 0x58, 0x90,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x1, 0xe1, 0xd2,
    0x0, 0x0, 0x5, 0xf6, 0x33, 0x33, 0xa4, 0x0,
    0x0, 0x0, 0x1e, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0xa, 0xe2, 0x0, 0x0, 0xd, 0x90, 0x0,
    0x1, 0xbe, 0x23, 0x80, 0x0, 0x5f, 0x20, 0x0,
    0xa, 0xd2, 0x4, 0xde, 0x40, 0xda, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfd, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xe3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf7, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0x50, 0x6, 0x0, 0x0,
    0x0, 0x1, 0x8f, 0xd3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30C3 "ッ" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x4f, 0x0, 0x0, 0x93, 0xe, 0x60, 0xe, 0x60,
    0x1, 0xf4, 0x8, 0xc0, 0x8, 0xb0, 0x5, 0xf0,
    0x2, 0xf3, 0x2, 0x60, 0xb, 0x90, 0x0, 0x72,
    0x0, 0x0, 0x3f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xda, 0x0, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0,
    0x0, 0x0, 0x2, 0xde, 0x20, 0x0, 0x0, 0x2,
    0x9f, 0xb1, 0x0, 0x0, 0x0, 0xd, 0xe6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30C6 "テ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x24,
    0x44, 0x44, 0x44, 0x44, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x59, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x96, 0x5a, 0xaa, 0xaa, 0xbf, 0xba, 0xaa,
    0xa6, 0x0, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xab, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xdd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xa1, 0x0, 0x0,
    0x0, 0x0,

    /* U+30C7 "デ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x47, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xd1, 0xd3, 0x0,
    0xcd, 0xdd, 0xdd, 0xdd, 0x89, 0x94, 0x40, 0x5,
    0x55, 0x55, 0x55, 0x53, 0x12, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x69, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x94, 0x6, 0xaa, 0xaa, 0xae,
    0xea, 0xaa, 0xaa, 0x40, 0x0, 0x0, 0x0, 0xba,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2c, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30C8 "ト" */
    0xac, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x0, 0x9b, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x0, 0x9e, 0x72, 0x0, 0x0, 0x9, 0xee,
    0xfc, 0x60, 0x0, 0x9b, 0x5, 0xbf, 0xf9, 0x19,
    0xb0, 0x0, 0x28, 0xf5, 0x9b, 0x0, 0x0, 0x1,
    0x9, 0xb0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x9b, 0x0,
    0x0, 0x0, 0x0,

    /* U+30C9 "ド" */
    0x1d, 0x40, 0x0, 0x2, 0xc0, 0x1f, 0x40, 0x1,
    0xe1, 0xa8, 0x1f, 0x40, 0x0, 0x7a, 0x19, 0x1f,
    0x40, 0x0, 0x6, 0x0, 0x1f, 0x93, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xd7, 0x10, 0x0, 0x1f, 0x44,
    0x9f, 0xfb, 0x30, 0x1f, 0x40, 0x0, 0x7d, 0xe0,
    0x1f, 0x40, 0x0, 0x0, 0x20, 0x1f, 0x40, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0x0,

    /* U+30CB "ニ" */
    0x1, 0x65, 0x55, 0x55, 0x55, 0x54, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x47, 0x66, 0x66, 0x66, 0x66, 0x66, 0x70, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30CD "ネ" */
    0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x4, 0x99,
    0x99, 0xbf, 0x99, 0x98, 0x0, 0x5, 0xaa, 0xaa,
    0xaa, 0xaa, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xef, 0x31, 0x50, 0x0,
    0x0, 0x16, 0xdf, 0xde, 0x6, 0xfc, 0x20, 0x3b,
    0xff, 0x92, 0x6d, 0x0, 0x3c, 0xf7, 0x1b, 0x60,
    0x0, 0x6d, 0x0, 0x0, 0x88, 0x0, 0x0, 0x0,
    0x6d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6d,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x0,

    /* U+30D0 "バ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x29, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3d, 0x1e, 0x10, 0x0,
    0xa, 0x30, 0x8, 0x80, 0xa5, 0x30, 0x0, 0x2,
    0xf3, 0x0, 0x6f, 0x10, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x9, 0xc0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x1f, 0x60, 0x0, 0x0, 0x4f, 0x20, 0x0,
    0x0, 0xad, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0,
    0x4, 0xf3, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x0,
    0xe, 0x90, 0x0, 0xae, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0x0, 0x4f, 0x60, 0x0, 0x0, 0x0, 0x4,
    0xf3, 0x9, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30D5 "フ" */
    0x23, 0x33, 0x33, 0x33, 0x33, 0x30, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x11, 0x11, 0x11, 0x11,
    0x11, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x10, 0x0, 0x0, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x3e, 0xc0, 0x0, 0x0, 0x0,
    0x6, 0xfc, 0x0, 0x0, 0x0, 0x16, 0xdf, 0x90,
    0x0, 0x0, 0x0, 0xdf, 0xb3, 0x0, 0x0, 0x0,
    0x0, 0x12, 0x0, 0x0, 0x0, 0x0,

    /* U+30D6 "ブ" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x5, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x93, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd2, 0x72, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x44, 0x44, 0x44, 0x44,
    0x47, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x4, 0xcf, 0x90,
    0x0, 0x0, 0x0, 0x2, 0xef, 0xd4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x53, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30D7 "プ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4c, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb0, 0xb, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0xa7, 0x44, 0x44, 0x44,
    0x44, 0x47, 0xf7, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x4, 0xbf,
    0xa0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xd4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x53, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30D9 "ベ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x53, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x74, 0x4d, 0x0,
    0x0, 0x0, 0x5, 0xd6, 0x0, 0x3d, 0xa, 0x70,
    0x0, 0x0, 0x4f, 0xcf, 0x80, 0xa, 0x51, 0x0,
    0x0, 0x2, 0xf8, 0x5, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xb0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0xce, 0x10, 0x0, 0x7, 0xf6, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x0,
    0x7, 0x60, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x10,

    /* U+30DE "マ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x24, 0x44,
    0x44, 0x44, 0x44, 0x4a, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdd, 0x0, 0x0, 0x6, 0x10, 0x0, 0xb,
    0xe2, 0x0, 0x0, 0x1c, 0xe3, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0x0, 0xaf, 0x6c, 0xe3, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x0, 0x0,

    /* U+30DF "ミ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfd,
    0xa6, 0x30, 0x0, 0x0, 0x14, 0x7a, 0xef, 0xfb,
    0x60, 0x0, 0x0, 0x0, 0x26, 0xaa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0x96, 0x20, 0x0,
    0x0, 0x3, 0x7b, 0xef, 0xeb, 0x61, 0x0, 0x0,
    0x0, 0x26, 0xae, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xfc, 0x84, 0x0, 0x0, 0x0, 0x25, 0x8c, 0xff,
    0xc8, 0x30, 0x0, 0x0, 0x0, 0x48, 0xdf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x30,

    /* U+30E0 "ム" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x2, 0x40,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x6, 0xf2, 0x0,
    0x0, 0x8, 0xd0, 0x0, 0x0, 0xda, 0x0, 0x0,
    0xe, 0x80, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x4f,
    0x21, 0x35, 0x68, 0xaf, 0xc0, 0x9c, 0xef, 0xff,
    0xfe, 0xdb, 0x99, 0xf4, 0x79, 0x76, 0x42, 0x0,
    0x0, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x32,

    /* U+30E2 "モ" */
    0x0, 0x54, 0x44, 0x44, 0x44, 0x44, 0x20, 0x0,
    0xee, 0xef, 0xfe, 0xee, 0xee, 0x50, 0x0, 0x0,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0xe, 0xee, 0xef, 0xfe, 0xee,
    0xee, 0xe9, 0x5, 0x55, 0x59, 0xf5, 0x55, 0x55,
    0x53, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf6, 0x10, 0x11, 0x30, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x2,
    0x33, 0x32, 0x10,

    /* U+30E3 "ャ" */
    0x0, 0xa, 0x30, 0x0, 0x0, 0x0, 0x0, 0xd,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x8, 0xb0, 0x36,
    0x9c, 0xfa, 0x14, 0x7c, 0xff, 0xeb, 0x87, 0xf3,
    0x6e, 0xb8, 0xf6, 0x0, 0xc, 0x80, 0x0, 0x0,
    0xb9, 0x0, 0xac, 0x0, 0x0, 0x0, 0x7d, 0x5,
    0xd1, 0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x40, 0x0, 0x0,

    /* U+30E5 "ュ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x33, 0x33, 0x33,
    0xad, 0x0, 0x0, 0x0, 0x0, 0x0, 0xab, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf4, 0x0, 0x37, 0x77, 0x77, 0x79, 0xf8, 0x77,
    0x5c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcb,

    /* U+30E7 "ョ" */
    0x6f, 0xff, 0xff, 0xff, 0xf5, 0x13, 0x33, 0x33,
    0x33, 0xe5, 0x0, 0x0, 0x0, 0x0, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0xd5, 0x1f, 0xff, 0xff, 0xff,
    0xf5, 0x3, 0x33, 0x33, 0x33, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0xd5, 0x0, 0x0, 0x0, 0x0, 0xd5,
    0x9f, 0xff, 0xff, 0xff, 0xf5, 0x23, 0x33, 0x33,
    0x33, 0xe5,

    /* U+30E9 "ラ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x1, 0x44, 0x44,
    0x44, 0x44, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x11,
    0x11, 0x11, 0x11, 0x11, 0xca, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x5d, 0xf4, 0x0, 0x0, 0x0, 0x9,
    0xef, 0x91, 0x0, 0x0, 0x0, 0x0, 0x47, 0x10,
    0x0, 0x0, 0x0,

    /* U+30EA "リ" */
    0x0, 0x0, 0x0, 0x0, 0x20, 0x6f, 0x0, 0x0,
    0x0, 0xf6, 0x6e, 0x0, 0x0, 0x0, 0xf6, 0x6e,
    0x0, 0x0, 0x0, 0xf6, 0x6e, 0x0, 0x0, 0x0,
    0xf6, 0x6e, 0x0, 0x0, 0x0, 0xf5, 0x6e, 0x0,
    0x0, 0x0, 0xf5, 0x6e, 0x0, 0x0, 0x2, 0xf3,
    0x5a, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0,
    0xb, 0xc0, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0,
    0x0, 0x19, 0xf8, 0x0, 0x0, 0xa, 0xfe, 0x50,
    0x0, 0x0, 0x4, 0x60, 0x0, 0x0,

    /* U+30EB "ル" */
    0x0, 0xb, 0x90, 0x6, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb9, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0,
    0xb, 0x90, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0xc,
    0x80, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xd6,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0xf, 0x50,
    0x6, 0xe0, 0x0, 0x3, 0x0, 0x2, 0xf3, 0x0,
    0x6e, 0x0, 0x4, 0xf2, 0x0, 0x8e, 0x0, 0x6,
    0xe0, 0x4, 0xf8, 0x0, 0x1f, 0x80, 0x0, 0x6e,
    0x8, 0xf8, 0x0, 0xc, 0xe0, 0x0, 0x6, 0xfd,
    0xf5, 0x0, 0x9, 0xf3, 0x0, 0x0, 0x6f, 0xa1,
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x20, 0x0,
    0x0, 0x0,

    /* U+30EC "レ" */
    0x5e, 0x10, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x0,
    0x0, 0x0, 0x0, 0x61, 0x4f, 0x0, 0x0, 0x0,
    0x6, 0xf4, 0x4f, 0x0, 0x0, 0x0, 0x9f, 0x60,
    0x4f, 0x0, 0x0, 0x4d, 0xe4, 0x0, 0x4f, 0x0,
    0x3b, 0xfb, 0x10, 0x0, 0x4f, 0x8d, 0xfc, 0x40,
    0x0, 0x0, 0x4f, 0xe9, 0x20, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30ED "ロ" */
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xac, 0x55,
    0x55, 0x55, 0x55, 0xbb, 0xaa, 0x0, 0x0, 0x0,
    0x0, 0x9b, 0xaa, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0xaa, 0x0, 0x0, 0x0, 0x0, 0x9b, 0xaa, 0x0,
    0x0, 0x0, 0x0, 0x9b, 0xaa, 0x0, 0x0, 0x0,
    0x0, 0x9b, 0xaa, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0xab, 0x11, 0x11, 0x11, 0x11, 0x9b, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0xac, 0x33, 0x33, 0x33,
    0x33, 0xac, 0x11, 0x0, 0x0, 0x0, 0x0, 0x11,

    /* U+30EF "ワ" */
    0x33, 0x33, 0x33, 0x33, 0x33, 0x30, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0xca, 0xe7, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0xe7, 0x0, 0x0, 0x0, 0x1, 0xf4, 0xe7, 0x0,
    0x0, 0x0, 0x6, 0xf1, 0x31, 0x0, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x0, 0x0, 0x3, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0xc0, 0x0, 0x0, 0x0, 0x2a, 0xfa,
    0x0, 0x0, 0x0, 0xb, 0xfe, 0x50, 0x0, 0x0,
    0x0, 0x3, 0x50, 0x0, 0x0, 0x0,

    /* U+30F3 "ン" */
    0x7, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1, 0xcf,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0,
    0x0, 0x66, 0x0, 0x0, 0x40, 0x0, 0x0, 0x1e,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x4e,
    0xe3, 0x0, 0x0, 0x0, 0x3, 0xbf, 0xb1, 0x0,
    0x0, 0x3, 0x8d, 0xfd, 0x50, 0x0, 0x0, 0x6,
    0xff, 0xa4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30FC "ー" */
    0x9f, 0xee, 0xee, 0xee, 0xee, 0xee, 0xf2, 0x58,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x81,

    /* U+4E00 "一" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x53,

    /* U+4E0B "下" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xef, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x55, 0xee, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x8, 0xfc, 0x10,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x39, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,

    /* U+4E0D "不" */
    0x3, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x30,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x93, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xed, 0x9a, 0xe5, 0x0, 0x0,
    0x0, 0x1, 0xbe, 0x3b, 0x90, 0x6f, 0x90, 0x0,
    0x0, 0x3d, 0xd2, 0xb, 0x90, 0x3, 0xdd, 0x20,
    0x1a, 0xfa, 0x0, 0xb, 0x90, 0x0, 0x1c, 0xe1,
    0x9, 0x40, 0x0, 0xb, 0x90, 0x0, 0x0, 0x50,
    0x0, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0,

    /* U+4E2D "中" */
    0x0, 0x0, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x25, 0x55,
    0x55, 0xf9, 0x55, 0x55, 0x52, 0x7f, 0xdd, 0xdd,
    0xfe, 0xdd, 0xdd, 0xf7, 0x7b, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0xc7, 0x7b, 0x0, 0x0, 0xe6, 0x0,
    0x0, 0xc7, 0x7b, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0xc7, 0x7c, 0x22, 0x22, 0xe7, 0x22, 0x22, 0xd7,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x7b,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0xc6, 0x0, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0,
    0x0, 0x0,

    /* U+4E86 "了" */
    0x3, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x1a, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xeb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5e, 0x0, 0x0, 0x0, 0x0, 0x1, 0x22, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+4F3A "伺" */
    0x0, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xdf, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x6, 0xe1, 0x11, 0x11, 0x11, 0x14, 0xc0, 0x0,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x8f,
    0x3, 0xff, 0xff, 0xff, 0xd3, 0xc0, 0x3f, 0xe0,
    0x2, 0x22, 0x22, 0x21, 0x3c, 0x1e, 0xde, 0x0,
    0x21, 0x11, 0x11, 0x3, 0xc3, 0xd4, 0xe0, 0xf,
    0xff, 0xff, 0xd0, 0x3c, 0x1, 0x3e, 0x0, 0xf2,
    0x0, 0x5d, 0x3, 0xc0, 0x3, 0xe0, 0xf, 0x20,
    0x5, 0xd0, 0x3c, 0x0, 0x3e, 0x0, 0xf3, 0x11,
    0x6d, 0x3, 0xc0, 0x3, 0xe0, 0xf, 0xff, 0xff,
    0xd0, 0x3c, 0x0, 0x3e, 0x0, 0xf2, 0x0, 0x0,
    0x3, 0xc0, 0x3, 0xe0, 0x1, 0x0, 0x0, 0x22,
    0x5c, 0x0, 0x3e, 0x0, 0x0, 0x0, 0xb, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4F4E "低" */
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x2, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x2, 0x6a, 0xef, 0x50,
    0x0, 0x6, 0xe0, 0x8d, 0xfe, 0xdd, 0x41, 0x0,
    0x0, 0xd, 0x60, 0xd7, 0x10, 0x5c, 0x0, 0x0,
    0x0, 0x7f, 0x0, 0xd5, 0x0, 0x4d, 0x0, 0x0,
    0x2, 0xff, 0x0, 0xd5, 0x0, 0x3e, 0x0, 0x0,
    0xc, 0xdf, 0x0, 0xd7, 0x33, 0x5f, 0x33, 0x31,
    0x5e, 0x4f, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xf5,
    0x2, 0x3f, 0x0, 0xd5, 0x0, 0xf, 0x30, 0x0,
    0x0, 0x3f, 0x0, 0xd5, 0x0, 0xc, 0x60, 0x0,
    0x0, 0x3f, 0x0, 0xd5, 0x0, 0xa, 0x90, 0x0,
    0x0, 0x3f, 0x0, 0xd5, 0x2, 0x26, 0xd0, 0x22,
    0x0, 0x3f, 0x0, 0xd5, 0x3, 0xc1, 0xf2, 0x58,
    0x0, 0x3f, 0x0, 0xea, 0xb8, 0xc4, 0xac, 0xc5,
    0x0, 0x3f, 0x5, 0xd8, 0x40, 0x47, 0x1d, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4F60 "你" */
    0x0, 0x0, 0x31, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe5, 0x8, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xe0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x60, 0x3f, 0x65, 0x55, 0x55, 0x62,
    0x0, 0x9f, 0x0, 0xae, 0xcc, 0xfd, 0xcc, 0xf6,
    0x4, 0xff, 0x2, 0xf3, 0x0, 0xf3, 0x0, 0xe3,
    0x2f, 0xbf, 0xb, 0xa0, 0x0, 0xf3, 0x1, 0xf0,
    0x2a, 0x3f, 0x1, 0x17, 0x40, 0xf3, 0x47, 0x0,
    0x0, 0x3f, 0x0, 0xe, 0x40, 0xf3, 0x3f, 0x10,
    0x0, 0x3f, 0x0, 0x4f, 0x0, 0xf3, 0xc, 0x80,
    0x0, 0x3f, 0x0, 0xb8, 0x0, 0xf3, 0x5, 0xe0,
    0x0, 0x3f, 0x4, 0xf1, 0x0, 0xf3, 0x0, 0xf3,
    0x0, 0x3f, 0x5, 0x60, 0x0, 0xf3, 0x0, 0x93,
    0x0, 0x3f, 0x0, 0x0, 0x23, 0xf2, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x0,

    /* U+4FE1 "信" */
    0x0, 0x0, 0x60, 0x0, 0x16, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf0, 0x0, 0xe, 0x60, 0x0, 0x0,
    0x0, 0x9, 0xa0, 0x0, 0x6, 0x80, 0x0, 0x0,
    0x0, 0x1f, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x9f, 0x0, 0x11, 0x11, 0x11, 0x11, 0x10,
    0x3, 0xff, 0x0, 0x44, 0x44, 0x44, 0x44, 0x0,
    0xd, 0xcf, 0x0, 0xab, 0xbb, 0xbb, 0xba, 0x0,
    0x2d, 0x3f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0xde, 0xee, 0xee, 0xed, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x1, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x2f, 0x1, 0xf0, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x2f, 0x1, 0xf0, 0x0, 0x0, 0xf, 0x10,
    0x0, 0x2f, 0x1, 0xf2, 0x22, 0x22, 0x2f, 0x10,
    0x0, 0x2f, 0x1, 0xfd, 0xdd, 0xdd, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5019 "候" */
    0x0, 0x4, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x80, 0xe, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0xb6, 0x0,
    0x0, 0x8c, 0x0, 0x0, 0x0, 0x0, 0xd4, 0x0,
    0x1, 0xf5, 0x3c, 0x7b, 0xbb, 0xbb, 0xfc, 0xb0,
    0x9, 0xf3, 0x4d, 0x35, 0xc5, 0x55, 0x55, 0x50,
    0x3f, 0xf3, 0x4d, 0x3, 0xe1, 0x11, 0x11, 0x0,
    0x79, 0xe3, 0x4d, 0xa, 0xff, 0xff, 0xff, 0x70,
    0x0, 0xe3, 0x4d, 0x4e, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0xe3, 0x4d, 0x34, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0xe3, 0x4d, 0x9f, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xe3, 0x4d, 0x1, 0x16, 0xfa, 0x11, 0x10,
    0x0, 0xe3, 0x1, 0x0, 0x2e, 0x7e, 0x50, 0x0,
    0x0, 0xe3, 0x0, 0x6, 0xe6, 0x3, 0xea, 0x30,
    0x0, 0xe3, 0x0, 0xaa, 0x20, 0x0, 0x18, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5099 "備" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xa0, 0x3, 0xe0, 0x7, 0xb0, 0x0,
    0x0, 0xc, 0x6d, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0x2, 0x25, 0xf2, 0x28, 0xc2, 0x10,
    0x0, 0xad, 0x0, 0x3, 0xe0, 0x7, 0xb0, 0x0,
    0x3, 0xfd, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0xd, 0xdd, 0x2, 0x5f, 0x52, 0x22, 0x22, 0x20,
    0xb, 0x5d, 0x6, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x5d, 0xbf, 0xf5, 0x2, 0xf0, 0x9, 0x80,
    0x0, 0x5d, 0x63, 0xd7, 0x35, 0xf3, 0x3b, 0x80,
    0x0, 0x5d, 0x0, 0xdd, 0xbc, 0xfb, 0xbe, 0x80,
    0x0, 0x5d, 0x0, 0xd5, 0x2, 0xf0, 0x9, 0x80,
    0x0, 0x5d, 0x0, 0xdf, 0xef, 0xfe, 0xef, 0x80,
    0x0, 0x5d, 0x0, 0xd5, 0x2, 0xf0, 0x9, 0x80,
    0x0, 0x5d, 0x0, 0xd5, 0x2, 0xf0, 0xaf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5145 "充" */
    0x0, 0x0, 0x0, 0x6, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xe2, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x3, 0x33, 0x3d, 0xd3, 0x33, 0x43, 0x33, 0x30,
    0x0, 0x0, 0x8f, 0x20, 0x2, 0xf6, 0x0, 0x0,
    0x0, 0x6, 0xf3, 0x0, 0x0, 0x4f, 0x80, 0x0,
    0x0, 0x7f, 0x95, 0x67, 0x88, 0x9c, 0xf8, 0x0,
    0x0, 0xce, 0xde, 0xea, 0xaf, 0xb7, 0x7f, 0x60,
    0x0, 0x0, 0xa, 0xa0, 0xd, 0x60, 0x4, 0x0,
    0x0, 0x0, 0xd, 0x70, 0xd, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x30, 0xd, 0x60, 0x0, 0x61,
    0x0, 0x0, 0xcc, 0x0, 0xd, 0x60, 0x0, 0xe4,
    0x0, 0x3c, 0xe2, 0x0, 0xd, 0x82, 0x23, 0xf2,
    0xb, 0xfa, 0x10, 0x0, 0x7, 0xff, 0xff, 0xa0,
    0x2, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5148 "先" */
    0x0, 0x4, 0x80, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xa, 0x90, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x8c, 0x33, 0x3d, 0x83, 0x33, 0x32, 0x0,
    0x2, 0xf4, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x2, 0x60, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x29, 0x99, 0x99, 0x9e, 0xb9, 0x99, 0x99, 0x60,
    0x29, 0x99, 0xaf, 0xa9, 0x9f, 0xb9, 0x99, 0x60,
    0x0, 0x0, 0x3f, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xc8, 0x0, 0xe, 0x40, 0x0, 0x40,
    0x0, 0x7, 0xf1, 0x0, 0xe, 0x40, 0x1, 0xf0,
    0x1, 0x9f, 0x50, 0x0, 0xe, 0x72, 0x26, 0xd0,
    0x2f, 0xd3, 0x0, 0x0, 0x8, 0xff, 0xff, 0x60,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5165 "入" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xbd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9d, 0x1f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf6, 0x8, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xe0, 0x1, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x60, 0x0, 0x7f, 0x10, 0x0,
    0x0, 0x1, 0xdc, 0x0, 0x0, 0xd, 0xc0, 0x0,
    0x0, 0x1c, 0xe1, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x4, 0xed, 0x20, 0x0, 0x0, 0x0, 0x5f, 0xd2,
    0x1d, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x4, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5173 "关" */
    0x0, 0x0, 0x40, 0x0, 0x0, 0x5, 0x20, 0x0,
    0x0, 0x2, 0xf5, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x33, 0x3c, 0x43, 0x35, 0xf5, 0x33, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x2, 0x33, 0x33, 0x4f, 0xf6, 0x33, 0x33, 0x30,
    0x0, 0x0, 0x0, 0x8f, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf6, 0xd, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x80, 0x1, 0xec, 0x20, 0x0,
    0x1, 0x7e, 0xe5, 0x0, 0x0, 0x1b, 0xfa, 0x30,
    0xd, 0xe8, 0x10, 0x0, 0x0, 0x0, 0x5d, 0xe1,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+518D "再" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0xc, 0xcc, 0xcc, 0xcf, 0xdc, 0xcc, 0xcc, 0x70,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x7c, 0x22, 0x2e, 0x72, 0x22, 0xc7, 0x0,
    0x0, 0x7b, 0x0, 0xe, 0x50, 0x0, 0xb7, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x7c, 0x11, 0x1e, 0x61, 0x11, 0xc7, 0x0,
    0x0, 0x7b, 0x0, 0xe, 0x50, 0x0, 0xb7, 0x0,
    0x4b, 0xde, 0xbb, 0xbf, 0xdb, 0xbb, 0xed, 0xb4,
    0x26, 0xbd, 0x66, 0x66, 0x66, 0x66, 0xda, 0x62,
    0x0, 0x7b, 0x0, 0x0, 0x0, 0x0, 0xb7, 0x0,
    0x0, 0x7b, 0x0, 0x0, 0x1, 0x11, 0xc7, 0x0,
    0x0, 0x7b, 0x0, 0x0, 0x5, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+51FA "出" */
    0x2, 0x20, 0x0, 0xe6, 0x0, 0x1, 0x30, 0x9,
    0x90, 0x0, 0xe6, 0x0, 0x6, 0xe0, 0x9, 0x90,
    0x0, 0xe6, 0x0, 0x6, 0xe0, 0x9, 0x90, 0x0,
    0xe6, 0x0, 0x6, 0xe0, 0x9, 0x90, 0x0, 0xe6,
    0x0, 0x6, 0xe0, 0x9, 0xfd, 0xdd, 0xfe, 0xdd,
    0xde, 0xe0, 0x3, 0x55, 0x55, 0xf9, 0x55, 0x55,
    0x40, 0x27, 0x0, 0x0, 0xe6, 0x0, 0x0, 0x53,
    0x5f, 0x0, 0x0, 0xe6, 0x0, 0x0, 0xc8, 0x5f,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0xc8, 0x5f, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0xc8, 0x5f, 0x0, 0x0,
    0xe6, 0x0, 0x0, 0xc8, 0x5f, 0xdd, 0xdd, 0xfe,
    0xdd, 0xdd, 0xf8, 0x15, 0x55, 0x55, 0x55, 0x55,
    0x55, 0xd8,

    /* U+5207 "切" */
    0x0, 0x3e, 0x0, 0x2, 0x22, 0x22, 0x22, 0x30,
    0x0, 0x3e, 0x0, 0xf, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x3e, 0x0, 0x0, 0x6, 0xd0, 0x0, 0xe4,
    0x0, 0x3f, 0x48, 0xb2, 0x6, 0xc0, 0x0, 0xf4,
    0x2b, 0xef, 0xd9, 0x61, 0x7, 0xb0, 0x0, 0xf3,
    0x17, 0x7e, 0x0, 0x0, 0x8, 0xa0, 0x0, 0xf3,
    0x0, 0x3e, 0x0, 0x0, 0xa, 0x80, 0x1, 0xf2,
    0x0, 0x3e, 0x0, 0x0, 0xd, 0x60, 0x1, 0xf1,
    0x0, 0x3e, 0x0, 0x41, 0x1f, 0x30, 0x2, 0xf0,
    0x0, 0x3f, 0x6d, 0xe3, 0x6e, 0x0, 0x3, 0xf0,
    0x0, 0xaf, 0xd5, 0x0, 0xd7, 0x0, 0x5, 0xe0,
    0x0, 0x64, 0x0, 0x9, 0xe0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x0, 0x9f, 0x30, 0x13, 0x2d, 0x90,
    0x0, 0x0, 0x5, 0xe3, 0x0, 0x4f, 0xfd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+521D "初" */
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf2, 0x0, 0x11, 0x11, 0x11, 0x20, 0x0,
    0x8, 0x80, 0x6e, 0xef, 0xfe, 0xef, 0x71, 0xdd,
    0xdd, 0xd1, 0x0, 0xd5, 0x0, 0xb7, 0x4, 0x44,
    0x9e, 0x0, 0xe, 0x40, 0xc, 0x60, 0x0, 0xd,
    0x60, 0x0, 0xf3, 0x0, 0xc6, 0x0, 0x8, 0xd2,
    0x60, 0x1f, 0x10, 0xd, 0x50, 0x4, 0xfa, 0xc6,
    0x3, 0xf0, 0x0, 0xd5, 0x3, 0xff, 0xfa, 0x0,
    0x6d, 0x0, 0xe, 0x43, 0xf8, 0xe6, 0xe5, 0xa,
    0x90, 0x0, 0xf3, 0x7, 0xe, 0x54, 0x40, 0xf4,
    0x0, 0xf, 0x20, 0x0, 0xe5, 0x0, 0x6e, 0x0,
    0x1, 0xf1, 0x0, 0xe, 0x50, 0x1e, 0x70, 0x0,
    0x4f, 0x0, 0x0, 0xe5, 0xc, 0xc0, 0x12, 0x19,
    0xc0, 0x0, 0xe, 0x53, 0xc1, 0x1, 0xff, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5229 "利" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x47, 0xbf, 0xb0, 0x0, 0x0, 0xe5, 0x2d,
    0xc9, 0xf7, 0x10, 0x4, 0x90, 0xe, 0x50, 0x0,
    0xe, 0x40, 0x0, 0x5d, 0x0, 0xe5, 0x0, 0x0,
    0xe4, 0x0, 0x5, 0xd0, 0xe, 0x53, 0xdd, 0xdf,
    0xed, 0xd4, 0x5d, 0x0, 0xe5, 0x14, 0x48, 0xf7,
    0x44, 0x15, 0xd0, 0xe, 0x50, 0x0, 0xbf, 0x70,
    0x0, 0x5d, 0x0, 0xe5, 0x0, 0x3d, 0xff, 0x80,
    0x5, 0xd0, 0xe, 0x50, 0xd, 0x5e, 0x5c, 0xa0,
    0x5d, 0x0, 0xe5, 0x9, 0xc0, 0xe4, 0x1b, 0x15,
    0xd0, 0xe, 0x56, 0xf2, 0xe, 0x40, 0x0, 0x1,
    0x0, 0xe5, 0x24, 0x0, 0xe4, 0x0, 0x0, 0x0,
    0xe, 0x50, 0x0, 0xe, 0x40, 0x0, 0x0, 0x22,
    0xe5, 0x0, 0x0, 0xe4, 0x0, 0x0, 0x1f, 0xfd,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5230 "到" */
    0xe, 0xff, 0xff, 0xff, 0xf4, 0x0, 0xd, 0x50,
    0x1, 0x7e, 0x12, 0x11, 0xd, 0x30, 0xd5, 0x0,
    0xe, 0x60, 0xa8, 0x0, 0xd3, 0xd, 0x50, 0x8,
    0xc0, 0x1, 0xe3, 0xd, 0x30, 0xd5, 0x4, 0xfa,
    0xac, 0xdf, 0xc0, 0xd3, 0xd, 0x50, 0x2c, 0xa8,
    0x65, 0x3d, 0x2d, 0x30, 0xd5, 0x0, 0x0, 0x3a,
    0x0, 0x0, 0xd3, 0xd, 0x50, 0x1, 0x15, 0xd1,
    0x11, 0xd, 0x30, 0xd5, 0x7, 0xff, 0xff, 0xff,
    0xf0, 0xd3, 0xd, 0x50, 0x0, 0x4, 0xd0, 0x0,
    0xd, 0x30, 0xd5, 0x0, 0x0, 0x4d, 0x0, 0x0,
    0x82, 0xd, 0x50, 0x0, 0x17, 0xea, 0xcf, 0x30,
    0x0, 0xd5, 0xb, 0xef, 0xeb, 0x74, 0x10, 0x2,
    0x2e, 0x40, 0x64, 0x10, 0x0, 0x0, 0x0, 0xef,
    0xc1,

    /* U+52A0 "加" */
    0x0, 0xe, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe4, 0x0, 0x0, 0x44, 0x44, 0x42, 0x3,
    0x3e, 0x73, 0x33, 0x1f, 0xee, 0xef, 0x92, 0xff,
    0xff, 0xff, 0xd1, 0xf1, 0x0, 0xa9, 0x0, 0xf,
    0x30, 0x5c, 0x1f, 0x10, 0xa, 0x90, 0x0, 0xf2,
    0x6, 0xc1, 0xf1, 0x0, 0xa9, 0x0, 0x1f, 0x10,
    0x6c, 0x1f, 0x10, 0xa, 0x90, 0x2, 0xf0, 0x6,
    0xb1, 0xf1, 0x0, 0xa9, 0x0, 0x5d, 0x0, 0x7b,
    0x1f, 0x10, 0xa, 0x90, 0x8, 0xa0, 0x8, 0xa1,
    0xf1, 0x0, 0xa9, 0x0, 0xd6, 0x0, 0x99, 0x1f,
    0x10, 0xa, 0x90, 0x3f, 0x10, 0xb, 0x81, 0xf4,
    0x33, 0xb9, 0xb, 0x91, 0x33, 0xe5, 0x1f, 0xff,
    0xff, 0x94, 0xe1, 0x2f, 0xfb, 0x1, 0xf1, 0x0,
    0xa9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+52A1 "务" */
    0x0, 0x0, 0x0, 0x81, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0xa, 0xf7, 0x11, 0x11, 0x18, 0xe1, 0x0,
    0x3, 0xdd, 0x6e, 0x50, 0x1, 0xad, 0x20, 0x0,
    0x1, 0x70, 0x3, 0xeb, 0x8f, 0x91, 0x0, 0x0,
    0x0, 0x0, 0x37, 0xcf, 0xee, 0x84, 0x10, 0x0,
    0x1a, 0xcf, 0xea, 0x50, 0x4, 0x9d, 0xff, 0xd1,
    0x6, 0x41, 0x0, 0xc, 0x30, 0x0, 0x2, 0x30,
    0x0, 0x44, 0x44, 0x6f, 0x64, 0x44, 0x44, 0x0,
    0x0, 0xcc, 0xcc, 0xee, 0xcc, 0xcc, 0xdd, 0x0,
    0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x8a, 0x0,
    0x0, 0x0, 0x2d, 0x90, 0x0, 0x0, 0xb7, 0x0,
    0x0, 0x39, 0xf8, 0x0, 0x0, 0x2, 0xf3, 0x0,
    0xc, 0xe8, 0x20, 0x0, 0x3f, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52B9 "効" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xe0, 0x0, 0x0, 0x4c, 0x0, 0x0,
    0x2, 0x22, 0xc6, 0x22, 0x10, 0x4c, 0x0, 0x0,
    0xb, 0xcc, 0xcc, 0xcc, 0x50, 0x5c, 0x0, 0x0,
    0x0, 0x29, 0x1, 0x80, 0x3e, 0xff, 0xee, 0xf1,
    0x0, 0xb8, 0x0, 0xc7, 0x3, 0x8c, 0x33, 0xf1,
    0x6, 0xd0, 0x0, 0x2f, 0x30, 0x7a, 0x0, 0xf1,
    0xe, 0x33, 0x5, 0xc7, 0x70, 0x88, 0x0, 0xf0,
    0x0, 0x3e, 0x3b, 0x70, 0x0, 0xb6, 0x1, 0xf0,
    0x0, 0x4, 0xef, 0x10, 0x0, 0xe3, 0x2, 0xf0,
    0x0, 0x0, 0xce, 0x10, 0x2, 0xf0, 0x3, 0xe0,
    0x0, 0x6, 0xea, 0xc0, 0x8, 0xa0, 0x4, 0xd0,
    0x0, 0x4f, 0x40, 0xd3, 0x2f, 0x30, 0x6, 0xc0,
    0x7, 0xf5, 0x0, 0x0, 0xca, 0x1, 0x1a, 0x90,
    0xb, 0x40, 0x0, 0x7, 0xc0, 0xf, 0xfd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52D9 "務" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xb1, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0x60, 0x8b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xe1, 0x4f, 0xff, 0xff,
    0xf1, 0x0, 0x4, 0x14, 0xf4, 0x3e, 0xf4, 0x11,
    0x9a, 0x0, 0x0, 0x6e, 0xe4, 0x8, 0x76, 0xe2,
    0x4f, 0x20, 0x0, 0x0, 0x6d, 0x0, 0x0, 0x9,
    0xef, 0x50, 0x0, 0xf, 0xff, 0xff, 0xfc, 0x4,
    0xcf, 0xfb, 0x40, 0x0, 0x0, 0xce, 0xa, 0xde,
    0xfa, 0x13, 0xcf, 0xc0, 0x0, 0x3f, 0xe0, 0xe5,
    0x71, 0x87, 0x0, 0x33, 0x0, 0xa, 0x9e, 0x3d,
    0x24, 0x4c, 0x94, 0x44, 0x0, 0x4, 0xe4, 0xe1,
    0x36, 0xcd, 0xfc, 0xcd, 0xf2, 0x0, 0xe5, 0x3e,
    0x0, 0x0, 0x7c, 0x0, 0x2f, 0x0, 0x5, 0x3,
    0xe0, 0x0, 0x3f, 0x40, 0x5, 0xe0, 0x0, 0x1,
    0x4e, 0x0, 0x7f, 0x60, 0x11, 0xba, 0x0, 0x0,
    0xcf, 0xa0, 0x8b, 0x20, 0xc, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5316 "化" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8c, 0x0, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf4, 0x0, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xc0, 0x0, 0xf5, 0x0, 0xa, 0x60,
    0x0, 0x5f, 0x60, 0x0, 0xf5, 0x0, 0x7f, 0x40,
    0x2, 0xef, 0x50, 0x0, 0xf5, 0x6, 0xf6, 0x0,
    0x2e, 0xce, 0x50, 0x0, 0xf5, 0x6f, 0x60, 0x0,
    0x3d, 0x1e, 0x50, 0x0, 0xfc, 0xf5, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x2, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x7f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x5b, 0xe5, 0xf5, 0x0, 0x0, 0x40,
    0x0, 0xe, 0x51, 0x0, 0xf5, 0x0, 0x1, 0xf2,
    0x0, 0xe, 0x50, 0x0, 0xf5, 0x0, 0x2, 0xf0,
    0x0, 0xe, 0x50, 0x0, 0xe8, 0x33, 0x39, 0xd0,
    0x0, 0xe, 0x50, 0x0, 0x7f, 0xff, 0xfe, 0x50,

    /* U+5347 "升" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xb0, 0x4f, 0x0, 0x0,
    0x0, 0x15, 0xaf, 0xe8, 0x20, 0x4f, 0x0, 0x0,
    0x8, 0xfc, 0xbe, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x1, 0x0, 0x5d, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x2, 0x22, 0x8d, 0x22, 0x22, 0x6f, 0x22, 0x21,
    0x0, 0x0, 0x8b, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x0, 0xd7, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x4, 0xf2, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x1e, 0x90, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x3, 0xeb, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0xb, 0x80, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5361 "卡" */
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x62, 0x22, 0x21, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x18, 0x88, 0x88, 0x8f, 0xa8, 0x88, 0x88, 0x81,
    0x1a, 0xaa, 0xaa, 0xaf, 0xca, 0xaa, 0xaa, 0xa1,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x68, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x69, 0xfc, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x6, 0xde, 0x30,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x4, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,

    /* U+53CB "友" */
    0x0, 0x0, 0xa, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x2, 0x33, 0x3e, 0x73, 0x33, 0x33, 0x33, 0x30,
    0x0, 0x0, 0x1f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x44, 0x44, 0x44, 0x30, 0x0,
    0x0, 0x0, 0x8f, 0xfe, 0xee, 0xef, 0xf1, 0x0,
    0x0, 0x0, 0xdf, 0x90, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x2, 0xf4, 0xf3, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0x9, 0xb0, 0x7d, 0x10, 0xca, 0x0, 0x0,
    0x0, 0x2f, 0x40, 0xa, 0xdb, 0xd1, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x3, 0xff, 0x70, 0x0, 0x0,
    0xb, 0xe1, 0x2, 0x9f, 0x97, 0xfc, 0x60, 0x0,
    0x1b, 0x31, 0xcf, 0xb3, 0x0, 0x18, 0xef, 0xc1,
    0x0, 0x0, 0x51, 0x0, 0x0, 0x0, 0x3, 0x40,

    /* U+53D1 "发" */
    0x0, 0x0, 0x0, 0x7, 0x40, 0x2, 0x0, 0x0,
    0x0, 0x9, 0xb0, 0xd, 0x70, 0xd, 0x80, 0x0,
    0x0, 0xe, 0x60, 0xf, 0x50, 0x2, 0xe7, 0x0,
    0x0, 0x5e, 0x0, 0x4f, 0x10, 0x0, 0x32, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x43, 0x33, 0xda, 0x33, 0x33, 0x33, 0x30,
    0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x2f, 0xf4, 0x33, 0x36, 0xf2, 0x0,
    0x0, 0x0, 0xbd, 0xaa, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x7, 0xf3, 0x1e, 0x70, 0x9e, 0x10, 0x0,
    0x0, 0x7f, 0x60, 0x3, 0xfb, 0xf3, 0x0, 0x0,
    0x9, 0xf6, 0x0, 0x2, 0xdf, 0xc2, 0x0, 0x0,
    0x1c, 0x30, 0x3, 0xaf, 0x92, 0xaf, 0xa4, 0x0,
    0x0, 0x0, 0xcf, 0x92, 0x0, 0x3, 0x9f, 0xf2,
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+53EF "可" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x1e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xfe, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf3, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x7c, 0x33, 0x34, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x7b, 0x0, 0x1, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x7b, 0x0, 0x1, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x7b, 0x0, 0x1, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xf1, 0x0, 0xf3, 0x0,
    0x0, 0x7c, 0x33, 0x33, 0x30, 0x0, 0xf3, 0x0,
    0x0, 0x35, 0x0, 0x0, 0x0, 0x0, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x14, 0x35, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+540E "后" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0,
    0x0, 0x1, 0x23, 0x56, 0x8a, 0xcf, 0xfc, 0x10,
    0x0, 0x9f, 0xfd, 0xca, 0x97, 0x53, 0x0, 0x0,
    0x0, 0x9a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x9a, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
    0x0, 0x99, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb8, 0x2c, 0xcc, 0xcc, 0xcc, 0xcc, 0x30,
    0x0, 0xc6, 0x3f, 0x55, 0x55, 0x55, 0x5f, 0x40,
    0x0, 0xf4, 0x3f, 0x0, 0x0, 0x0, 0xf, 0x40,
    0x3, 0xf1, 0x3f, 0x0, 0x0, 0x0, 0xf, 0x40,
    0x8, 0xc0, 0x3f, 0x0, 0x0, 0x0, 0xf, 0x40,
    0x1e, 0x60, 0x3f, 0xee, 0xee, 0xee, 0xef, 0x40,
    0x2b, 0x0, 0x3f, 0x44, 0x44, 0x44, 0x4f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+542C "听" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x59, 0xef, 0x40, 0x8f,
    0xff, 0xe0, 0x3e, 0xfc, 0x84, 0x0, 0x9, 0xb3,
    0x6e, 0x3, 0xf0, 0x0, 0x0, 0x0, 0x99, 0x4,
    0xe0, 0x3f, 0x0, 0x0, 0x0, 0x9, 0x90, 0x4e,
    0x3, 0xf4, 0x44, 0x44, 0x41, 0x99, 0x4, 0xe0,
    0x3f, 0xee, 0xef, 0xfe, 0x59, 0x90, 0x4e, 0x3,
    0xf0, 0x0, 0xe4, 0x0, 0x99, 0x4, 0xe0, 0x4f,
    0x0, 0xe, 0x40, 0x9, 0x90, 0x4e, 0x6, 0xd0,
    0x0, 0xe4, 0x0, 0x9f, 0xff, 0xe0, 0x8b, 0x0,
    0xe, 0x40, 0x9, 0xb3, 0x33, 0xc, 0x70, 0x0,
    0xe4, 0x0, 0x44, 0x0, 0x2, 0xf2, 0x0, 0xe,
    0x40, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0xe4,
    0x0, 0x0, 0x0, 0xa, 0x40, 0x0, 0xe, 0x40,
    0x0,

    /* U+542F "启" */
    0x0, 0x0, 0x0, 0x3, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x0, 0x0,
    0x13, 0x22, 0x24, 0xf4, 0x22, 0x22, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x7c,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0xc2, 0x22,
    0x22, 0x22, 0x22, 0x20, 0x0, 0x8a, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0x97, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0xc7, 0x7b, 0x22, 0x22,
    0x22, 0x2f, 0x40, 0xf, 0x37, 0xb0, 0x0, 0x0,
    0x0, 0xf4, 0x5, 0xe0, 0x7b, 0x0, 0x0, 0x0,
    0xf, 0x40, 0xc9, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x2d, 0x10, 0x7b, 0x22, 0x22, 0x22, 0x2f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+544A "告" */
    0x0, 0x5, 0xb0, 0x5, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xa2, 0x26, 0xf2, 0x22, 0x21, 0x0,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x2, 0xe5, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0,
    0x7, 0x90, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0,
    0xa, 0xaa, 0xaa, 0xac, 0xfa, 0xaa, 0xaa, 0xa0,
    0x7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x3f, 0x22, 0x22, 0x22, 0x22, 0xf4, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x3f, 0xdd, 0xdd, 0xdd, 0xdd, 0xf4, 0x0,
    0x0, 0x3f, 0x44, 0x44, 0x44, 0x44, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+547D "命" */
    0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xea, 0xd9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x80, 0x1c, 0xc3, 0x0, 0x0,
    0x0, 0x5d, 0xe6, 0x22, 0x22, 0xbf, 0xa3, 0x0,
    0x4e, 0xe7, 0x6f, 0xff, 0xff, 0xf3, 0xbf, 0xb0,
    0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x20,
    0x1, 0xff, 0xff, 0xb0, 0x8f, 0xff, 0xfa, 0x0,
    0x1, 0xf1, 0x16, 0xc0, 0x8b, 0x22, 0x8b, 0x0,
    0x1, 0xf0, 0x5, 0xc0, 0x8a, 0x0, 0x7b, 0x0,
    0x1, 0xf0, 0x5, 0xc0, 0x8a, 0x0, 0x7b, 0x0,
    0x1, 0xf6, 0x69, 0xc0, 0x8a, 0x0, 0x7b, 0x0,
    0x1, 0xfb, 0xbb, 0x80, 0x8a, 0x4f, 0xf8, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x8a, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8a, 0x0, 0x0, 0x0,

    /* U+54CD "响" */
    0x0, 0x0, 0x0, 0x0, 0x7, 0x50, 0x0, 0x12,
    0x22, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x9f, 0xff,
    0x30, 0x0, 0x6e, 0x0, 0x0, 0x97, 0xd, 0x33,
    0xff, 0xff, 0xff, 0xfe, 0x97, 0xd, 0x33, 0xe1,
    0x11, 0x11, 0x2f, 0x97, 0xd, 0x33, 0xe0, 0x0,
    0x0, 0xf, 0x97, 0xd, 0x33, 0xe0, 0xee, 0xec,
    0xf, 0x97, 0xd, 0x33, 0xe0, 0xd0, 0xe, 0xf,
    0x97, 0xd, 0x33, 0xe0, 0xd0, 0xe, 0xf, 0x97,
    0xd, 0x33, 0xe0, 0xd0, 0xe, 0xf, 0x9f, 0xef,
    0x33, 0xe0, 0xe3, 0x3e, 0xf, 0x99, 0x44, 0x3,
    0xe0, 0xea, 0xa9, 0xf, 0x54, 0x0, 0x3, 0xe0,
    0x80, 0x0, 0xf, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x1, 0x2e, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x6,
    0xfa,

    /* U+554F "問" */
    0x8f, 0xff, 0xff, 0x44, 0xff, 0xff, 0xfa, 0x8a,
    0x0, 0xe, 0x44, 0xd0, 0x0, 0x9a, 0x8b, 0x33,
    0x3f, 0x44, 0xe3, 0x33, 0xba, 0x8e, 0xaa, 0xaf,
    0x44, 0xfa, 0xaa, 0xea, 0x8a, 0x0, 0xe, 0x44,
    0xd0, 0x0, 0x9a, 0x8f, 0xff, 0xff, 0x34, 0xff,
    0xff, 0xfa, 0x8a, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9a, 0x8a, 0x1, 0xfe, 0xee, 0xed, 0x0, 0x9a,
    0x8a, 0x2, 0xf2, 0x22, 0x4f, 0x0, 0x9a, 0x8a,
    0x2, 0xf0, 0x0, 0x3f, 0x0, 0x9a, 0x8a, 0x2,
    0xf0, 0x0, 0x3f, 0x0, 0x9a, 0x8a, 0x2, 0xff,
    0xff, 0xff, 0x0, 0x9a, 0x8a, 0x2, 0xf0, 0x0,
    0x1, 0x33, 0xb9, 0x8a, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+555F "啟" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x11, 0x0, 0x0,
    0x0, 0x1, 0xf2, 0x0, 0x0, 0x98, 0x0, 0x0,
    0x0, 0x0, 0xa9, 0x0, 0x0, 0xc5, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xff, 0x0, 0xf5, 0x33, 0x30,
    0x2, 0xf0, 0x0, 0x1f, 0x5, 0xfe, 0xef, 0xf2,
    0x2, 0xf0, 0x0, 0x1f, 0xa, 0xc0, 0xd, 0x40,
    0x2, 0xff, 0xff, 0xff, 0x2f, 0xf0, 0xf, 0x10,
    0x3, 0xf2, 0x22, 0x22, 0x69, 0xd3, 0x3e, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x0, 0x97, 0x8a, 0x0,
    0x4, 0xdc, 0xff, 0xff, 0x30, 0x4c, 0xd5, 0x0,
    0x6, 0xbd, 0x40, 0xd, 0x30, 0xe, 0xe0, 0x0,
    0x9, 0x9d, 0x30, 0xd, 0x30, 0xd, 0xc0, 0x0,
    0xd, 0x5d, 0x30, 0xd, 0x30, 0x8d, 0xe6, 0x0,
    0x3f, 0x1d, 0xff, 0xff, 0x38, 0xe2, 0x3f, 0x50,
    0x28, 0xd, 0x40, 0xd, 0x8d, 0x20, 0x4, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5668 "器" */
    0x0, 0xff, 0xff, 0xf0, 0x2f, 0xff, 0xff, 0x0,
    0x0, 0xf2, 0x2, 0xf0, 0x2f, 0x0, 0x3f, 0x0,
    0x0, 0xf2, 0x2, 0xf0, 0x2f, 0x0, 0x2f, 0x0,
    0x0, 0xf5, 0x35, 0xf0, 0x2f, 0x33, 0x5f, 0x0,
    0x0, 0xcd, 0xdd, 0xd3, 0x2d, 0xed, 0xdd, 0x0,
    0x0, 0x0, 0x0, 0x8c, 0x0, 0x8c, 0x50, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x2, 0x22, 0x9f, 0x52, 0x26, 0xf7, 0x22, 0x20,
    0x0, 0x3c, 0xd3, 0x0, 0x0, 0x3e, 0xb3, 0x0,
    0x2c, 0xff, 0xee, 0xd0, 0x1e, 0xee, 0xff, 0xd3,
    0x6, 0xf5, 0x24, 0xf0, 0x2f, 0x22, 0x5f, 0x50,
    0x0, 0xf2, 0x2, 0xf0, 0x2f, 0x0, 0x2f, 0x0,
    0x0, 0xf3, 0x3, 0xf0, 0x2f, 0x0, 0x3f, 0x0,
    0x0, 0xff, 0xff, 0xf0, 0x2f, 0xff, 0xff, 0x0,

    /* U+5728 "在" */
    0x0, 0x0, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x2, 0x33, 0x7f, 0x43, 0x33, 0x33, 0x33, 0x30,
    0x0, 0x0, 0xd9, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0x8, 0xe1, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0x4f, 0x60, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x4, 0xff, 0x40, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x2f, 0x8e, 0x40, 0x22, 0x28, 0xc2, 0x22, 0x10,
    0x4, 0xe, 0x40, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0xe, 0x4a, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+5831 "報" */
    0x0, 0x3, 0xe0, 0x0, 0x9f, 0xff, 0xff, 0x80,
    0xa, 0xff, 0xff, 0xf5, 0x99, 0x11, 0x1a, 0x80,
    0x0, 0x14, 0xf1, 0x10, 0x98, 0x0, 0x9, 0x80,
    0x0, 0x3, 0xe0, 0x0, 0x98, 0x2, 0x2a, 0x80,
    0x3f, 0xff, 0xff, 0xfb, 0x98, 0x9, 0xdc, 0x30,
    0x1, 0xc2, 0x16, 0xb0, 0x9a, 0x33, 0x33, 0x20,
    0x0, 0x87, 0x1d, 0x40, 0x9e, 0xe9, 0x9c, 0xc0,
    0xd, 0xff, 0xff, 0xf7, 0x99, 0xe0, 0x9, 0x80,
    0x0, 0x3, 0xe0, 0x0, 0x98, 0xa6, 0xf, 0x30,
    0x0, 0x3, 0xe0, 0x0, 0x98, 0x3e, 0x7d, 0x0,
    0x3f, 0xff, 0xff, 0xfc, 0x98, 0xa, 0xf4, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x98, 0xb, 0xf7, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x99, 0xad, 0x3e, 0x90,
    0x0, 0x2, 0xe0, 0x0, 0x9e, 0xb1, 0x2, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5907 "备" */
    0x0, 0x0, 0x3, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0x91, 0x11, 0x11, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x2d, 0xf9, 0x0, 0x0, 0x9e, 0x20, 0x0,
    0x6, 0xfa, 0x2d, 0xb1, 0x2b, 0xd2, 0x0, 0x0,
    0x1, 0x40, 0x1, 0xbf, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x6b, 0xfb, 0xbf, 0xc7, 0x30, 0x0,
    0x3a, 0xdf, 0xd8, 0x20, 0x2, 0x8c, 0xff, 0xd3,
    0x19, 0x8a, 0x88, 0x88, 0x88, 0x88, 0x96, 0x60,
    0x0, 0x4f, 0x99, 0x9f, 0xb9, 0x99, 0xf3, 0x0,
    0x0, 0x4f, 0x0, 0xd, 0x60, 0x2, 0xf3, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x4f, 0x0, 0xd, 0x60, 0x2, 0xf3, 0x0,
    0x0, 0x4f, 0x88, 0x8e, 0xb8, 0x89, 0xf3, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5927 "大" */
    0x0, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x4, 0x44, 0x44, 0x5f, 0xf6, 0x44, 0x44, 0x40,
    0x0, 0x0, 0x0, 0x5f, 0xd7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xab, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf4, 0x1f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xc0, 0x7, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0x7, 0xf5, 0x0, 0x0, 0x1e, 0xc1, 0x0,
    0x3, 0xcf, 0x50, 0x0, 0x0, 0x2, 0xde, 0x60,
    0x1d, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x19, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5931 "失" */
    0x0, 0x5, 0xb0, 0xb, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xa0, 0xb, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xed, 0xdf, 0xfd, 0xdd, 0xdb, 0x0,
    0x0, 0xac, 0x55, 0x5d, 0xb5, 0x55, 0x54, 0x0,
    0x5, 0xf3, 0x0, 0xb, 0x80, 0x0, 0x0, 0x0,
    0x9, 0x80, 0x0, 0xb, 0x80, 0x0, 0x0, 0x0,
    0x3, 0x33, 0x33, 0x3d, 0x93, 0x33, 0x33, 0x30,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x4f, 0xe5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcb, 0x7d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf2, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x40, 0x2, 0xeb, 0x10, 0x0,
    0x0, 0x7e, 0xd3, 0x0, 0x0, 0x2d, 0xe7, 0x10,
    0x1e, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x7e, 0xf3,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+597D "好" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x22, 0x22, 0x23, 0x0,
    0x0, 0x5d, 0x0, 0x6, 0xff, 0xff, 0xff, 0xb0,
    0x2, 0x9b, 0x23, 0x10, 0x0, 0x0, 0x8e, 0x20,
    0x5f, 0xff, 0xff, 0xe0, 0x0, 0x7, 0xf3, 0x0,
    0x0, 0xf3, 0x8, 0xc0, 0x0, 0x4f, 0x20, 0x0,
    0x3, 0xf0, 0xa, 0x90, 0x0, 0x5e, 0x0, 0x0,
    0x7, 0xb0, 0xe, 0x6d, 0xdd, 0xef, 0xdd, 0xd6,
    0xc, 0x80, 0x3f, 0x14, 0x44, 0x8f, 0x44, 0x42,
    0x7, 0xf9, 0x9c, 0x0, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x2d, 0xf6, 0x0, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0xb, 0xfe, 0x20, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x7f, 0x3b, 0xd0, 0x0, 0x5e, 0x0, 0x0,
    0x19, 0xf4, 0x0, 0x30, 0x11, 0x6e, 0x0, 0x0,
    0x3c, 0x20, 0x0, 0x0, 0x8f, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+59CB "始" */
    0x0, 0x15, 0x0, 0x0, 0x0, 0x50, 0x0, 0x0,
    0x0, 0x4d, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0x6b, 0x0, 0x0, 0xd, 0x70, 0x0, 0x0,
    0x2, 0xa9, 0x23, 0x0, 0x6e, 0x0, 0xd4, 0x0,
    0x4f, 0xff, 0xff, 0x21, 0xe5, 0x0, 0x5e, 0x0,
    0x0, 0xf2, 0xf, 0x1a, 0xb0, 0x1, 0x2d, 0x80,
    0x2, 0xe0, 0x2f, 0x5f, 0xee, 0xff, 0xfe, 0xf1,
    0x6, 0xb0, 0x5c, 0x27, 0x43, 0x20, 0x0, 0xa4,
    0xb, 0x60, 0x99, 0x1, 0x22, 0x22, 0x22, 0x10,
    0xb, 0xd2, 0xd4, 0x9, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x8f, 0xe0, 0x9, 0x80, 0x0, 0xa, 0x70,
    0x0, 0xd, 0xf5, 0x9, 0x80, 0x0, 0xa, 0x70,
    0x0, 0x7e, 0x6f, 0x49, 0x80, 0x0, 0xa, 0x70,
    0x8, 0xf3, 0x6, 0x29, 0xa4, 0x44, 0x4c, 0x70,
    0x1c, 0x30, 0x0, 0x9, 0xec, 0xcc, 0xce, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5B8C "完" */
    0x0, 0x0, 0x0, 0x3a, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x0, 0x0,
    0xb, 0xdd, 0xdd, 0xdf, 0xfd, 0xdd, 0xdd, 0x40,
    0xe, 0x85, 0x55, 0x55, 0x55, 0x55, 0x5f, 0x50,
    0xe, 0x40, 0x0, 0x0, 0x0, 0x0, 0xe, 0x50,
    0xa, 0x39, 0xff, 0xff, 0xff, 0xff, 0x1a, 0x30,
    0x0, 0x1, 0x22, 0x22, 0x22, 0x22, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb1,
    0x6, 0x66, 0x7f, 0x76, 0x6f, 0x86, 0x66, 0x60,
    0x0, 0x0, 0x2f, 0x0, 0xf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0x0, 0xf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xd7, 0x0, 0xf, 0x30, 0x2, 0xf3,
    0x0, 0x4c, 0xc0, 0x0, 0xf, 0x51, 0x16, 0xf2,
    0x1e, 0xe7, 0x0, 0x0, 0xa, 0xff, 0xff, 0xb0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5B9A "定" */
    0x0, 0x0, 0x0, 0xa, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0xc,
    0xdd, 0xdd, 0xde, 0xfd, 0xdd, 0xdd, 0x40, 0xe7,
    0x44, 0x44, 0x44, 0x44, 0x44, 0xf5, 0xe, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x50, 0x92, 0x58,
    0x88, 0x88, 0x88, 0x85, 0x93, 0x0, 0x6, 0xaa,
    0xae, 0xea, 0xaa, 0x70, 0x0, 0x0, 0x10, 0x0,
    0xa9, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0, 0xaf,
    0xff, 0xff, 0x50, 0x0, 0x1f, 0x90, 0xa, 0xb3,
    0x33, 0x31, 0x0, 0x6, 0xef, 0x20, 0xa9, 0x0,
    0x0, 0x0, 0x0, 0xd7, 0x7e, 0x2a, 0x90, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x8f, 0xec, 0x43, 0x33,
    0x33, 0x5f, 0x30, 0x0, 0x39, 0xde, 0xff, 0xff,
    0xa0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5BFB "寻" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf1, 0x0, 0x0,
    0x12, 0x22, 0x22, 0x22, 0x2f, 0x10, 0x0, 0x7,
    0xdd, 0xdd, 0xdd, 0xdd, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x10, 0x0, 0x1e, 0xee,
    0xee, 0xee, 0xee, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xb0, 0x0, 0x1, 0x22, 0x22, 0x22,
    0x22, 0x7f, 0x22, 0x21, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x5a, 0x0, 0x0,
    0x5e, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x0, 0x5,
    0xe0, 0x0, 0x0, 0x0, 0x1, 0xd6, 0x0, 0x5e,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x26, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5C06 "将" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x7, 0xd1, 0x1, 0x0,
    0x0, 0x3, 0xe0, 0x1, 0xaf, 0xff, 0xff, 0xb0,
    0xd, 0x53, 0xe0, 0x7e, 0xa1, 0x0, 0x4f, 0x30,
    0x3, 0xf8, 0xe0, 0x72, 0x8c, 0x17, 0xf5, 0x0,
    0x0, 0x5a, 0xe0, 0x0, 0xc, 0xfd, 0x30, 0x0,
    0x0, 0x3, 0xe0, 0x59, 0xed, 0x60, 0xc3, 0x0,
    0x0, 0x3, 0xe0, 0xa7, 0x30, 0x0, 0xe4, 0x0,
    0x0, 0x1c, 0xe5, 0xdd, 0xdd, 0xdd, 0xfe, 0xd2,
    0x2, 0xdc, 0xe1, 0x45, 0x44, 0x44, 0xf7, 0x40,
    0x1f, 0x83, 0xe0, 0x1e, 0x60, 0x0, 0xe4, 0x0,
    0x5, 0x3, 0xe0, 0x3, 0xf3, 0x0, 0xe4, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x89, 0x0, 0xe4, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x11, 0xf4, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x2, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C07 "將" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x8, 0x90, 0x8a, 0x0, 0x4, 0xe2, 0x0, 0x0,
    0x8, 0x90, 0x8a, 0x0, 0x5f, 0xdd, 0xdf, 0x90,
    0x8, 0x90, 0x8a, 0x1a, 0xc5, 0x60, 0x1f, 0x30,
    0x8, 0x90, 0x8a, 0xb7, 0x40, 0x8c, 0xd8, 0x0,
    0x8, 0xff, 0xfa, 0x1, 0xc7, 0x2e, 0x90, 0x0,
    0x0, 0x21, 0x8a, 0x0, 0x2f, 0xf6, 0x51, 0x0,
    0x0, 0x0, 0x8a, 0x5a, 0xf9, 0x10, 0xe3, 0x0,
    0x5, 0x55, 0xaa, 0x88, 0x32, 0x22, 0xf5, 0x20,
    0x2d, 0xfc, 0xea, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x5, 0xc0, 0x8a, 0x5, 0x40, 0x0, 0xe3, 0x0,
    0x6, 0xa0, 0x8a, 0x3, 0xf4, 0x0, 0xe3, 0x0,
    0x8, 0x80, 0x8a, 0x0, 0x5e, 0x0, 0xe3, 0x0,
    0xc, 0x40, 0x8a, 0x0, 0x3, 0x11, 0xf3, 0x0,
    0x1c, 0x0, 0x8a, 0x0, 0x1, 0xff, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C0B "尋" */
    0x0, 0x4d, 0xdd, 0xdd, 0xdd, 0xdd, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0xb, 0xdd, 0xdd, 0xdd, 0xdd, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0x5d, 0xdd, 0xdd, 0xdd, 0xdd, 0xd1, 0x0,
    0x2, 0x55, 0x55, 0x51, 0x45, 0x55, 0x55, 0x10,
    0x4, 0x9a, 0xf9, 0x92, 0xda, 0x88, 0x8f, 0x40,
    0x0, 0x3, 0xf1, 0x11, 0xd6, 0x22, 0x2e, 0x40,
    0xc, 0xff, 0xec, 0xb6, 0x9b, 0xcf, 0xcb, 0x20,
    0x2, 0x21, 0x11, 0x11, 0x11, 0x3f, 0x21, 0x10,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x2, 0xd8, 0x0, 0x0, 0x2f, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0x90, 0x0, 0x3f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C11 "少" */
    0x0, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x20, 0xe, 0x40, 0x3, 0x20, 0x0,
    0x0, 0xd, 0x60, 0xe, 0x40, 0x8, 0xc0, 0x0,
    0x0, 0x5e, 0x0, 0xe, 0x40, 0x0, 0xd7, 0x0,
    0x0, 0xd6, 0x0, 0xe, 0x40, 0x0, 0x4f, 0x10,
    0x7, 0xd0, 0x0, 0xe, 0x40, 0x0, 0xa, 0xa0,
    0x1e, 0x30, 0x0, 0xe, 0x40, 0x0, 0x2, 0xc0,
    0x0, 0x0, 0x0, 0xe, 0x40, 0x2, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xc, 0x30, 0x1d, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xdb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x9f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x26, 0xbf, 0xb3, 0x0, 0x0, 0x0,
    0x39, 0xbe, 0xfc, 0x82, 0x0, 0x0, 0x0, 0x0,
    0x1a, 0x74, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5DF2 "已" */
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x1,
    0x33, 0x33, 0x33, 0x33, 0x33, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x76,
    0x0, 0x0, 0x0, 0x0, 0xf4, 0x0, 0xa, 0x90,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0xa9, 0x0,
    0x0, 0x0, 0x0, 0xf4, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x0, 0xaa, 0x22, 0x22,
    0x22, 0x22, 0xf3, 0x0, 0xa, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x30, 0xa, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x30, 0xa9, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf1, 0x8, 0xd4, 0x33, 0x33, 0x33, 0x34,
    0xcc, 0x0, 0x1b, 0xef, 0xff, 0xff, 0xff, 0xfc,
    0x20,

    /* U+5E94 "应" */
    0x0, 0x0, 0x0, 0x1, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x33, 0x33, 0x33, 0xe8, 0x33, 0x33, 0x20,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x2, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf1, 0x0, 0x3, 0xa0, 0x0, 0x1d, 0x10,
    0x2, 0xf1, 0xa6, 0x1, 0xf2, 0x0, 0x6e, 0x0,
    0x2, 0xf0, 0x6d, 0x0, 0xc6, 0x0, 0xb9, 0x0,
    0x3, 0xf0, 0x1f, 0x20, 0x8a, 0x1, 0xf3, 0x0,
    0x3, 0xf0, 0xb, 0x80, 0x4e, 0x7, 0xc0, 0x0,
    0x5, 0xe0, 0x6, 0xd0, 0x17, 0xe, 0x50, 0x0,
    0x8, 0xb0, 0x1, 0x40, 0x0, 0x6c, 0x0, 0x0,
    0xb, 0x80, 0x0, 0x0, 0x0, 0xe4, 0x0, 0x0,
    0x1f, 0x3a, 0xdd, 0xdd, 0xde, 0xfd, 0xdd, 0xd2,
    0x4d, 0x3, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5EA6 "度" */
    0x0, 0x0, 0x0, 0x3, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x2, 0xf4, 0x33, 0x83, 0x33, 0x37, 0x43, 0x30,
    0x2, 0xf1, 0x0, 0xf2, 0x0, 0xf, 0x40, 0x0,
    0x2, 0xf9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x2, 0xf1, 0x0, 0xf3, 0x0, 0xf, 0x40, 0x0,
    0x2, 0xf0, 0x0, 0xf2, 0x0, 0xf, 0x40, 0x0,
    0x2, 0xf0, 0x0, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x3, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x5, 0xd2, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x7, 0xb0, 0x6, 0xd1, 0x0, 0x9, 0xd0, 0x0,
    0xb, 0x80, 0x0, 0x7e, 0x64, 0xcc, 0x10, 0x0,
    0xf, 0x40, 0x0, 0x3b, 0xff, 0xd3, 0x0, 0x0,
    0x5e, 0xa, 0xdf, 0xd9, 0x44, 0x9e, 0xfc, 0xa0,
    0x3, 0x3, 0x30, 0x0, 0x0, 0x0, 0x25, 0x40,

    /* U+5F00 "开" */
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x6, 0xcc, 0xdf, 0xcc, 0xcc, 0xdf, 0xcc, 0xb0,
    0x0, 0x0, 0x4e, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x4e, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x2e, 0xee, 0xff, 0xee, 0xee, 0xff, 0xee, 0xe6,
    0x4, 0x44, 0x9d, 0x44, 0x44, 0x8e, 0x44, 0x41,
    0x0, 0x0, 0x9a, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x2f, 0x80, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x4, 0xeb, 0x0, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0xa, 0x90, 0x0, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5F0F "式" */
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x18, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x10, 0xbc, 0x10,
    0x13, 0x33, 0x33, 0x33, 0x5f, 0x53, 0x39, 0x30,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x11, 0xd, 0x60, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xff, 0x4b, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xe5, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x6, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x2, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xe4, 0x1, 0x30, 0xd7, 0x0, 0xc2,
    0x0, 0x3, 0xfc, 0xdf, 0xa0, 0x7e, 0x0, 0xf2,
    0x1d, 0xff, 0xb8, 0x41, 0x0, 0xe, 0xb6, 0xf0,
    0x6, 0x20, 0x0, 0x0, 0x0, 0x2, 0xcf, 0x70,

    /* U+5F55 "录" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x11, 0x11, 0x11, 0x11, 0x17, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x12, 0x22, 0x22, 0x22, 0x29, 0xb0, 0x0,
    0x6, 0x66, 0x66, 0x66, 0x66, 0x6c, 0xc6, 0x50,
    0x1b, 0xbb, 0xbb, 0xbf, 0xdb, 0xbb, 0xbb, 0x90,
    0x0, 0x96, 0x0, 0xd, 0x90, 0x0, 0xb5, 0x0,
    0x0, 0x3d, 0xc2, 0xd, 0xf3, 0x2d, 0xb1, 0x0,
    0x0, 0x0, 0x94, 0x4e, 0xbe, 0xe6, 0x0, 0x0,
    0x0, 0x1, 0x7d, 0xdf, 0x67, 0xe4, 0x0, 0x0,
    0x5, 0xbf, 0xb4, 0xd, 0x60, 0x6f, 0xa2, 0x0,
    0xa, 0x81, 0x0, 0xd, 0x50, 0x2, 0xaf, 0xa0,
    0x0, 0x0, 0x1f, 0xfe, 0x20, 0x0, 0x1, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5F85 "待" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xd0, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x0, 0x4f, 0x50, 0x12, 0x25, 0xf2, 0x22, 0x10,
    0x7, 0xf5, 0x0, 0xcf, 0xff, 0xff, 0xff, 0x90,
    0x1c, 0x30, 0x82, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x0, 0x6, 0xe2, 0x22, 0x26, 0xf2, 0x22, 0x21,
    0x0, 0x3f, 0x4a, 0xdd, 0xdd, 0xdd, 0xfe, 0xd5,
    0x3, 0xff, 0x10, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x4f, 0x9f, 0x11, 0x22, 0x22, 0x23, 0xf4, 0x20,
    0x17, 0xf, 0x18, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0xf, 0x10, 0x17, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0xf, 0x10, 0xb, 0xa0, 0x0, 0xf2, 0x0,
    0x0, 0xf, 0x10, 0x1, 0xe5, 0x0, 0xf2, 0x0,
    0x0, 0xf, 0x10, 0x0, 0x21, 0x12, 0xf2, 0x0,
    0x0, 0xf, 0x10, 0x0, 0x3, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5F8C "後" */
    0x0, 0x1, 0x20, 0x0, 0x2, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x7e, 0x10, 0x0, 0x0,
    0x0, 0x9d, 0x0, 0x6, 0xe2, 0x1, 0x91, 0x0,
    0xa, 0xd1, 0x0, 0x7d, 0x20, 0x4e, 0x70, 0x0,
    0x1a, 0x11, 0xe6, 0xff, 0xff, 0xd3, 0x20, 0x0,
    0x0, 0xc, 0x90, 0x5, 0xd7, 0x1, 0xe5, 0x0,
    0x0, 0x9f, 0x5, 0xdf, 0xaa, 0xab, 0xef, 0x30,
    0x9, 0xff, 0x6, 0x98, 0xdc, 0x43, 0x27, 0xe0,
    0x3f, 0x7f, 0x0, 0x5, 0xf2, 0x0, 0x10, 0x60,
    0x2, 0x3f, 0x0, 0x5f, 0xfe, 0xee, 0xf9, 0x0,
    0x0, 0x3f, 0x8, 0xfc, 0x80, 0x4, 0xf2, 0x0,
    0x0, 0x3f, 0x1a, 0x20, 0xc9, 0x6f, 0x40, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x3f, 0xf7, 0x0, 0x0,
    0x0, 0x3f, 0x2, 0x6c, 0xe7, 0x6d, 0xd7, 0x20,
    0x0, 0x3f, 0x2e, 0xa5, 0x0, 0x0, 0x4a, 0xd2,

    /* U+5FDC "応" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0x33, 0x33, 0x33, 0xd9, 0x33, 0x33, 0x30,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x2, 0xf1, 0x0, 0x3, 0x30, 0x0, 0x0, 0x0,
    0x2, 0xf1, 0x0, 0x7, 0xfa, 0x20, 0x0, 0x0,
    0x2, 0xf1, 0x0, 0x0, 0x1a, 0xf5, 0x0, 0x0,
    0x2, 0xf0, 0x0, 0x3e, 0x0, 0x51, 0x0, 0x0,
    0x2, 0xf0, 0x44, 0x4e, 0x0, 0x0, 0x77, 0x0,
    0x3, 0xf0, 0xa8, 0x4e, 0x0, 0x0, 0x4f, 0x10,
    0x5, 0xd0, 0xd5, 0x4e, 0x0, 0x0, 0xc, 0x80,
    0x7, 0xb2, 0xf1, 0x4e, 0x0, 0x3, 0x65, 0xe0,
    0xb, 0x88, 0xc0, 0x4e, 0x0, 0x5, 0xb0, 0xf4,
    0x1f, 0x37, 0x40, 0x3f, 0x11, 0x19, 0x90, 0x72,
    0x5d, 0x0, 0x0, 0xd, 0xff, 0xfe, 0x30, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6001 "态" */
    0x0, 0x0, 0x0, 0x9, 0xa0, 0x0, 0x0, 0x0,
    0x2, 0x22, 0x22, 0x2d, 0x92, 0x22, 0x22, 0x20,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x5e, 0xb9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd8, 0x2f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xd1, 0x7, 0xf4, 0x0, 0x0,
    0x0, 0x3, 0xcd, 0xad, 0x30, 0x8f, 0x81, 0x0,
    0x7, 0xcf, 0x90, 0x7, 0xf6, 0x4, 0xdf, 0xa1,
    0x9, 0x61, 0x0, 0x18, 0x41, 0x0, 0x5, 0x70,
    0x0, 0x74, 0x86, 0xb, 0xb0, 0x0, 0xb5, 0x0,
    0x0, 0xe4, 0xb8, 0x0, 0xcb, 0x0, 0x5e, 0x0,
    0x4, 0xe0, 0xb8, 0x0, 0x15, 0x8, 0x4d, 0x60,
    0xb, 0x90, 0xa9, 0x11, 0x11, 0x1d, 0x57, 0xc0,
    0x7, 0x10, 0x5e, 0xff, 0xff, 0xfc, 0x2, 0x60,

    /* U+606F "息" */
    0x0, 0x0, 0x0, 0x5, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0xe, 0x30, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x0, 0xe, 0xfe, 0xee, 0xee, 0xef, 0xe0, 0x0,
    0x0, 0xe, 0x30, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x0, 0xe, 0xcb, 0xbb, 0xbb, 0xbc, 0xe0, 0x0,
    0x0, 0xe, 0x53, 0x33, 0x33, 0x36, 0xe0, 0x0,
    0x0, 0xe, 0x41, 0x11, 0x11, 0x15, 0xe0, 0x0,
    0x0, 0xc, 0xee, 0xee, 0xee, 0xee, 0xc0, 0x0,
    0x0, 0x0, 0x10, 0xd, 0x60, 0x0, 0x2, 0x0,
    0x0, 0xe3, 0xd6, 0x2, 0xf5, 0x0, 0x6e, 0x10,
    0x6, 0xd0, 0xd6, 0x0, 0x45, 0x8, 0x3c, 0x90,
    0x1e, 0x60, 0xd8, 0x11, 0x11, 0x2e, 0x34, 0xe0,
    0x5, 0x0, 0x7e, 0xff, 0xff, 0xfb, 0x0, 0x0,

    /* U+60C5 "情" */
    0x0, 0xc4, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0,
    0xc, 0x40, 0xee, 0xee, 0xff, 0xee, 0xe7, 0x1,
    0xcb, 0x50, 0x0, 0xe, 0x40, 0x0, 0x1, 0xcc,
    0x7b, 0x8d, 0xdd, 0xfe, 0xdd, 0xd1, 0x4b, 0xc4,
    0x84, 0x44, 0x4f, 0x74, 0x44, 0x46, 0x8c, 0x45,
    0xaa, 0xaa, 0xaa, 0xaa, 0xa9, 0xa5, 0xc4, 0x0,
    0x33, 0x33, 0x33, 0x32, 0x1, 0xc, 0x40, 0x3f,
    0xcc, 0xcc, 0xcd, 0xd0, 0x0, 0xc4, 0x3, 0xe0,
    0x0, 0x0, 0x5d, 0x0, 0xc, 0x40, 0x3f, 0xdd,
    0xdd, 0xde, 0xd0, 0x0, 0xc4, 0x3, 0xe0, 0x0,
    0x0, 0x4d, 0x0, 0xc, 0x40, 0x3f, 0xee, 0xee,
    0xef, 0xd0, 0x0, 0xc4, 0x3, 0xe0, 0x0, 0x0,
    0x5d, 0x0, 0xc, 0x40, 0x3e, 0x0, 0x4, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+614B "態" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0x71, 0x20, 0xf, 0x20, 0x38, 0x10,
    0x2, 0xd7, 0x4, 0xe3, 0xf, 0xad, 0xb6, 0x0,
    0xe, 0xfe, 0xed, 0xce, 0x2f, 0x50, 0x2, 0x70,
    0x2, 0x21, 0x11, 0x16, 0x1f, 0x74, 0x48, 0xb0,
    0x3, 0xfc, 0xcc, 0xe9, 0x9, 0xcb, 0xbb, 0x30,
    0x3, 0xf9, 0x99, 0xd9, 0xf, 0x20, 0x17, 0x10,
    0x3, 0xe3, 0x33, 0x99, 0xf, 0x8b, 0xe9, 0x20,
    0x3, 0xfc, 0xcc, 0xe9, 0xf, 0x93, 0x0, 0x40,
    0x3, 0xd0, 0x0, 0x89, 0xf, 0x30, 0x3, 0xd0,
    0x3, 0xd0, 0x3d, 0xd6, 0xa, 0xff, 0xff, 0x70,
    0x0, 0x80, 0x72, 0x9, 0xa0, 0x0, 0x2a, 0x0,
    0x6, 0xc0, 0xe4, 0x0, 0xb3, 0x24, 0xe, 0x50,
    0x1e, 0x40, 0xe5, 0x0, 0x0, 0x7b, 0x7, 0xd0,
    0x5, 0x0, 0x8f, 0xff, 0xff, 0xe4, 0x1, 0x40,

    /* U+61C9 "應" */
    0x0, 0x0, 0x0, 0x2, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x4, 0xd0, 0x7, 0x80, 0xc1, 0x69, 0x0, 0x0,
    0x4, 0xd0, 0x2f, 0x26, 0xe9, 0xaf, 0x99, 0x60,
    0x4, 0xd1, 0xde, 0x2f, 0x83, 0x4f, 0x33, 0x20,
    0x4, 0xed, 0xbe, 0xce, 0xdb, 0xbf, 0xbb, 0x30,
    0x4, 0xd6, 0x2e, 0x19, 0xa6, 0x7f, 0x66, 0x10,
    0x4, 0xc0, 0x2e, 0x9, 0xa5, 0x6f, 0x55, 0x10,
    0x5, 0xb0, 0x2e, 0x9, 0xdb, 0xcf, 0xbb, 0xb0,
    0x7, 0xa0, 0x18, 0x5, 0xb5, 0x11, 0x11, 0x10,
    0x9, 0x80, 0x35, 0x25, 0x4c, 0xb1, 0x73, 0x0,
    0xd, 0x40, 0xb8, 0x5a, 0x0, 0x52, 0x4e, 0x20,
    0x2f, 0x17, 0xe1, 0x4b, 0x0, 0x9, 0x77, 0xd0,
    0x4a, 0x8, 0x30, 0x2e, 0xff, 0xfe, 0x20, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6211 "我" */
    0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x36, 0x9d, 0xf9, 0x4f, 0x7, 0x60, 0x0,
    0xe, 0xca, 0xf7, 0x10, 0x3f, 0x2, 0xe8, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x2f, 0x0, 0x2d, 0x40,
    0x0, 0x0, 0xe4, 0x0, 0x1f, 0x10, 0x0, 0x0,
    0x4e, 0xee, 0xff, 0xee, 0xef, 0xfe, 0xee, 0xd0,
    0x13, 0x33, 0xe7, 0x33, 0x3e, 0x73, 0x33, 0x30,
    0x0, 0x0, 0xe4, 0x0, 0xc, 0x70, 0x3d, 0x0,
    0x0, 0x0, 0xe8, 0x7b, 0x29, 0xa0, 0xd7, 0x0,
    0x27, 0xad, 0xfe, 0xa6, 0x16, 0xea, 0xc0, 0x0,
    0x5c, 0x85, 0xe4, 0x0, 0x2, 0xfd, 0x10, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0xb, 0xf8, 0x0, 0x91,
    0x0, 0x0, 0xe4, 0x4, 0xdc, 0x8e, 0x0, 0xe2,
    0x1, 0x22, 0xf4, 0x7f, 0x80, 0xd, 0xb5, 0xf0,
    0x4, 0xff, 0xd1, 0x2, 0x0, 0x2, 0xcf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+624B "手" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x10, 0x0,
    0x12, 0x34, 0x67, 0x9b, 0xdf, 0xe7, 0x0, 0xb,
    0xfe, 0xdb, 0xce, 0x64, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6d, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x2, 0x33, 0x33,
    0x8e, 0x33, 0x33, 0x31, 0x0, 0x0, 0x0, 0x6,
    0xd0, 0x0, 0x0, 0x0, 0x22, 0x22, 0x22, 0x7e,
    0x22, 0x22, 0x22, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x6d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x22, 0x28, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xff, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+626B "扫" */
    0x0, 0xe, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe4, 0x3, 0xaa, 0xaa, 0xaa, 0xa3, 0x2,
    0x2f, 0x62, 0x36, 0x66, 0x66, 0x6d, 0x64, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0xc6, 0x0, 0xe,
    0x40, 0x0, 0x0, 0x0, 0xc, 0x60, 0x0, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0xc6, 0x0, 0xe, 0x55,
    0x2f, 0xff, 0xff, 0xff, 0x61, 0x59, 0xff, 0xd4,
    0x34, 0x44, 0x44, 0xd6, 0x4e, 0xaf, 0x50, 0x0,
    0x0, 0x0, 0xc, 0x60, 0x0, 0xe4, 0x0, 0x0,
    0x0, 0x0, 0xc6, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0xc, 0x60, 0x0, 0xe4, 0x0, 0x11, 0x11,
    0x11, 0xc6, 0x1, 0x1f, 0x40, 0x7f, 0xff, 0xff,
    0xff, 0x60, 0xaf, 0xd1, 0x0, 0x11, 0x11, 0x11,
    0xc6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+627E "找" */
    0x0, 0xf, 0x30, 0x0, 0x7b, 0x7, 0x20, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x6d, 0x6, 0xe3, 0x0,
    0x2, 0x2f, 0x52, 0x0, 0x5e, 0x0, 0x69, 0x0,
    0x4f, 0xff, 0xff, 0x20, 0x5f, 0x56, 0x8a, 0xb0,
    0x0, 0xf, 0x30, 0x9f, 0xff, 0xdb, 0x97, 0x60,
    0x0, 0xf, 0x30, 0x11, 0xf, 0x30, 0x3, 0x0,
    0x0, 0xf, 0x45, 0x10, 0xd, 0x60, 0x3f, 0x10,
    0x4, 0x8f, 0xfc, 0x20, 0xa, 0x90, 0xd8, 0x0,
    0x4e, 0xaf, 0x30, 0x0, 0x7, 0xd9, 0xd0, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x2, 0xfe, 0x20, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x9, 0xf9, 0x0, 0x63,
    0x0, 0xf, 0x30, 0x2, 0xcd, 0x8f, 0x20, 0xa6,
    0x1, 0x1f, 0x20, 0x9f, 0xa1, 0xc, 0xd6, 0xe3,
    0xb, 0xfc, 0x0, 0x33, 0x0, 0x1, 0xbf, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+633F "挿" */
    0x0, 0x0, 0x0, 0x1, 0x23, 0x56, 0x9b, 0x0,
    0x0, 0x2f, 0x0, 0xdf, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x2f, 0x0, 0x8b, 0xaa, 0xf6, 0x42, 0x0,
    0x2, 0x4f, 0x32, 0x33, 0x34, 0xf4, 0x33, 0x30,
    0x4f, 0xff, 0xfb, 0xdd, 0xdd, 0xfd, 0xdd, 0xd3,
    0x0, 0x2f, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0x2, 0xa7, 0x2, 0xf1, 0x8, 0xa0,
    0x1, 0x7f, 0xfa, 0xa9, 0x34, 0xf4, 0x39, 0xa0,
    0x6f, 0xef, 0x40, 0xae, 0xcc, 0xfc, 0xce, 0xa0,
    0x11, 0x2f, 0x0, 0xa7, 0x1, 0xf0, 0x8, 0xa0,
    0x0, 0x2f, 0x0, 0xaf, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x2f, 0x0, 0x76, 0x12, 0xf1, 0x15, 0x60,
    0x2, 0x4f, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0xc, 0xfb, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,

    /* U+6362 "换" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x2, 0xff, 0xff, 0xf7, 0x0,
    0x3, 0x6f, 0x31, 0x1d, 0x80, 0x5, 0xe1, 0x0,
    0x1e, 0xef, 0xe7, 0xde, 0x66, 0x7f, 0x96, 0x0,
    0x0, 0x4e, 0x0, 0x9f, 0x99, 0xf9, 0x9f, 0x20,
    0x0, 0x4e, 0x0, 0x3e, 0x1, 0xf0, 0xf, 0x20,
    0x0, 0x4e, 0x13, 0x3e, 0x1, 0xf0, 0xf, 0x20,
    0x2, 0x9f, 0xfa, 0x3e, 0x3, 0xf0, 0xf, 0x20,
    0x3f, 0xdf, 0x23, 0xbf, 0xac, 0xfa, 0xaf, 0xb2,
    0x1, 0x4e, 0x2, 0x66, 0x6f, 0xf9, 0x66, 0x61,
    0x0, 0x4e, 0x0, 0x0, 0x7d, 0x7c, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x7, 0xe2, 0xa, 0xc1, 0x0,
    0x2, 0x6e, 0x3, 0xcd, 0x20, 0x0, 0xae, 0x60,
    0x9, 0xf9, 0x1d, 0x70, 0x0, 0x0, 0x5, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6383 "掃" */
    0x0, 0x3e, 0x0, 0x2e, 0xee, 0xee, 0xef, 0x20,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0xf, 0x20,
    0x3, 0x5f, 0x32, 0xc, 0xdd, 0xdd, 0xdf, 0x20,
    0x2e, 0xef, 0xea, 0x0, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x3e, 0x0, 0x4f, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x3e, 0x0, 0x33, 0x33, 0x33, 0x33, 0x30,
    0x0, 0x3f, 0x58, 0xfd, 0xdd, 0xfd, 0xdd, 0xf2,
    0x28, 0xcf, 0xc8, 0xe0, 0x2, 0xf0, 0x0, 0xd2,
    0x2a, 0x8e, 0x1, 0x9d, 0xde, 0xfd, 0xde, 0xa1,
    0x0, 0x3e, 0x0, 0x1f, 0x24, 0xf2, 0x2d, 0x30,
    0x0, 0x3e, 0x0, 0x1f, 0x2, 0xf0, 0xd, 0x30,
    0x0, 0x3e, 0x0, 0x1f, 0x2, 0xf0, 0xd, 0x30,
    0x1, 0x4e, 0x0, 0x1f, 0x2, 0xf2, 0xee, 0x10,
    0xc, 0xf9, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0,

    /* U+63A2 "探" */
    0x0, 0x3e, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x3e, 0x0, 0xf1, 0x11, 0x11, 0x12, 0xf0,
    0x2, 0x5f, 0x21, 0xd0, 0x33, 0x6, 0x21, 0xc0,
    0x1f, 0xff, 0xf7, 0x1, 0xe6, 0x7, 0xe2, 0x0,
    0x0, 0x3e, 0x0, 0x2d, 0x90, 0x0, 0x6e, 0x20,
    0x0, 0x3e, 0x0, 0xd8, 0x1, 0x90, 0x8, 0x90,
    0x0, 0x3f, 0x75, 0x0, 0x2, 0xf0, 0x0, 0x0,
    0x6, 0xcf, 0xb6, 0xdd, 0xdd, 0xfd, 0xdd, 0xd1,
    0x1d, 0xae, 0x0, 0x44, 0x5f, 0xfe, 0x44, 0x40,
    0x0, 0x3e, 0x0, 0x0, 0xba, 0xfa, 0x90, 0x0,
    0x0, 0x3e, 0x0, 0x9, 0xc2, 0xf1, 0xe7, 0x0,
    0x0, 0x3e, 0x1, 0xbd, 0x12, 0xf0, 0x2e, 0x80,
    0x0, 0x3e, 0xb, 0xb1, 0x2, 0xf0, 0x2, 0xd3,
    0xa, 0xfa, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63A5 "接" */
    0x0, 0x3e, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x38, 0x88, 0xfb, 0x88, 0x82,
    0x2, 0x5e, 0x21, 0x27, 0xb6, 0x66, 0x9a, 0x61,
    0x1f, 0xff, 0xf7, 0x0, 0xd4, 0x0, 0xb7, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x58, 0x5, 0xd0, 0x0,
    0x0, 0x3e, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x3e, 0x1, 0x0, 0x8, 0x70, 0x0, 0x0,
    0x1, 0x8f, 0xf7, 0x11, 0x2f, 0x41, 0x11, 0x11,
    0x3f, 0xef, 0x33, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x2, 0x3e, 0x0, 0x4, 0xe1, 0x0, 0x9b, 0x0,
    0x0, 0x3e, 0x0, 0xe, 0xd6, 0x14, 0xf3, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x5a, 0xff, 0xa0, 0x0,
    0x1, 0x5e, 0x0, 0x25, 0x9e, 0xd8, 0xed, 0x60,
    0xa, 0xf9, 0x3, 0xeb, 0x83, 0x0, 0x6, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63CF "描" */
    0x0, 0x3e, 0x0, 0x0, 0xe4, 0x0, 0xf1, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0xe4, 0x0, 0xf1, 0x0,
    0x2, 0x5f, 0x25, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x2f, 0xff, 0xf9, 0x0, 0xe4, 0x0, 0xf1, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0xe4, 0x0, 0xf1, 0x0,
    0x0, 0x3e, 0x0, 0x13, 0x43, 0x33, 0x43, 0x20,
    0x0, 0x3e, 0x12, 0x6f, 0xdd, 0xfe, 0xde, 0xa0,
    0x2, 0x8f, 0xf7, 0x6b, 0x0, 0xe3, 0x8, 0xa0,
    0x3f, 0xdf, 0x10, 0x6b, 0x0, 0xe3, 0x8, 0xa0,
    0x1, 0x3e, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x3e, 0x0, 0x6c, 0x11, 0xf4, 0x19, 0xa0,
    0x0, 0x3e, 0x0, 0x6b, 0x0, 0xe3, 0x8, 0xa0,
    0x1, 0x4e, 0x0, 0x6e, 0xbb, 0xfc, 0xbe, 0xa0,
    0xc, 0xf9, 0x0, 0x6d, 0x55, 0x55, 0x5b, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63D2 "插" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x2, 0x45, 0x89, 0xcf, 0x30,
    0x0, 0x4e, 0x0, 0x2d, 0xcb, 0xf8, 0x41, 0x0,
    0x4, 0x7f, 0x42, 0x0, 0x0, 0xe3, 0x0, 0x0,
    0xa, 0xcf, 0xb5, 0xee, 0xee, 0xfe, 0xee, 0xe4,
    0x0, 0x4e, 0x0, 0x33, 0x33, 0xf5, 0x33, 0x30,
    0x0, 0x4e, 0x0, 0x0, 0x40, 0xe3, 0x0, 0x0,
    0x0, 0x4e, 0x1, 0x5e, 0xd3, 0xe6, 0xff, 0xb0,
    0x2, 0x8f, 0xf8, 0x89, 0x0, 0xe3, 0x16, 0xc0,
    0x1f, 0xdf, 0x10, 0x89, 0x0, 0xe3, 0x5, 0xc0,
    0x0, 0x4e, 0x0, 0x8f, 0xf7, 0xe5, 0xff, 0xc0,
    0x0, 0x4e, 0x0, 0x89, 0x10, 0xe3, 0x16, 0xc0,
    0x0, 0x4e, 0x0, 0x89, 0x0, 0xe3, 0x5, 0xc0,
    0x1, 0x6e, 0x0, 0x8d, 0x99, 0xfb, 0x9b, 0xc0,
    0x6, 0xe9, 0x0, 0x8c, 0x77, 0x77, 0x7a, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63DB "換" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc4, 0x0, 0x1, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0xc4, 0x0, 0xb, 0xff, 0xff, 0x20, 0x0,
    0x24, 0xd7, 0x30, 0x8d, 0x0, 0x99, 0x0, 0x0,
    0x6b, 0xec, 0x98, 0xfe, 0xdd, 0xfe, 0xdd, 0x10,
    0x0, 0xc4, 0x6, 0xd4, 0x23, 0x23, 0x2e, 0x10,
    0x0, 0xc4, 0x0, 0xc2, 0x59, 0x3b, 0xe, 0x10,
    0x0, 0xc6, 0x50, 0xc2, 0xd2, 0xb, 0x3e, 0x10,
    0x16, 0xef, 0x90, 0xc9, 0x91, 0x23, 0xae, 0x10,
    0xad, 0xe5, 0x0, 0xc3, 0x8, 0xa0, 0xe, 0x10,
    0x10, 0xc4, 0x29, 0xea, 0x9d, 0xc9, 0x9f, 0x90,
    0x0, 0xc4, 0x17, 0x77, 0x8f, 0xf7, 0x77, 0x70,
    0x0, 0xc4, 0x0, 0x0, 0xba, 0x8b, 0x0, 0x0,
    0x12, 0xd4, 0x1, 0x6d, 0xb0, 0x9, 0xd6, 0x20,
    0x2f, 0xd1, 0x5e, 0xa4, 0x0, 0x0, 0x3a, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6557 "敗" */
    0x0, 0x0, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xe0, 0xe, 0x50, 0x0, 0x0,
    0xc, 0x50, 0x4, 0xe0, 0x2f, 0x10, 0x0, 0x0,
    0xc, 0x50, 0x4, 0xe0, 0x7f, 0x99, 0x99, 0x91,
    0xc, 0xfe, 0xef, 0xe0, 0xdc, 0x99, 0xbf, 0x91,
    0xc, 0x60, 0x4, 0xe4, 0xfa, 0x0, 0x8b, 0x0,
    0xc, 0x50, 0x4, 0xfd, 0xde, 0x0, 0xb8, 0x0,
    0xc, 0xff, 0xff, 0xfd, 0x1f, 0x30, 0xf4, 0x0,
    0xc, 0x50, 0x4, 0xe0, 0xa, 0x85, 0xe0, 0x0,
    0xc, 0x50, 0x4, 0xe0, 0x4, 0xec, 0x90, 0x0,
    0xc, 0xff, 0xff, 0xe0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x83, 0x28, 0x0, 0x1, 0xef, 0x30, 0x0,
    0x3, 0xf2, 0xd, 0x70, 0x1c, 0xca, 0xe2, 0x0,
    0xd, 0x90, 0x3, 0xf5, 0xec, 0x10, 0xce, 0x50,
    0x6d, 0x0, 0x0, 0x2e, 0x90, 0x0, 0x9, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+65B0 "新" */
    0x0, 0x3, 0x60, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x2, 0xf2, 0x0, 0x2, 0x59, 0xdf, 0x30,
    0xf, 0xff, 0xff, 0xff, 0x3f, 0xa7, 0x30, 0x0,
    0x1, 0xb3, 0x12, 0xc1, 0x2f, 0x0, 0x0, 0x0,
    0x0, 0xa7, 0x6, 0xb0, 0x2f, 0x0, 0x0, 0x0,
    0x3, 0x89, 0x3c, 0x83, 0x3f, 0x22, 0x22, 0x20,
    0x3d, 0xdd, 0xfd, 0xdd, 0x6f, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0xf1, 0x0, 0x2f, 0x0, 0xd5, 0x0,
    0x3, 0x33, 0xf4, 0x33, 0x3f, 0x0, 0xd5, 0x0,
    0x2d, 0xdd, 0xfd, 0xdd, 0x5e, 0x0, 0xd5, 0x0,
    0x0, 0x70, 0xf2, 0x60, 0x5c, 0x0, 0xd5, 0x0,
    0x5, 0xc0, 0xf1, 0xd4, 0x7a, 0x0, 0xd5, 0x0,
    0x1d, 0x40, 0xf1, 0x4c, 0xb6, 0x0, 0xd5, 0x0,
    0x5, 0x0, 0xf1, 0x3, 0xf1, 0x0, 0xd5, 0x0,
    0x0, 0x3f, 0xc0, 0x5, 0x80, 0x0, 0xd5, 0x0,

    /* U+65E0 "无" */
    0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x2, 0xdd, 0xdd, 0xdf, 0xed, 0xdd, 0xdd, 0x30,
    0x0, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x20, 0x0, 0x0, 0x0,
    0x1a, 0xaa, 0xaa, 0xbf, 0xaa, 0xaa, 0xaa, 0xa2,
    0x18, 0x88, 0x88, 0xbe, 0xeb, 0x88, 0x88, 0x81,
    0x0, 0x0, 0x0, 0xa9, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf4, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xd0, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x40, 0xd6, 0x0, 0x0, 0x71,
    0x0, 0x3, 0xe9, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0x0, 0x8f, 0x80, 0x0, 0xc9, 0x22, 0x24, 0xf2,
    0x1e, 0xe5, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xa0,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+65F6 "时" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x50, 0x8,
    0xfe, 0xee, 0x50, 0x0, 0x0, 0xe5, 0x0, 0x99,
    0x11, 0xb6, 0x33, 0x33, 0x3e, 0x73, 0x19, 0x90,
    0xb, 0x7f, 0xff, 0xff, 0xff, 0xf4, 0x99, 0x0,
    0xb6, 0x0, 0x0, 0xe, 0x50, 0x9, 0xb4, 0x4c,
    0x61, 0x50, 0x0, 0xe5, 0x0, 0x9e, 0xcc, 0xf6,
    0x2f, 0x40, 0xe, 0x50, 0x9, 0x90, 0xb, 0x60,
    0x6e, 0x10, 0xe5, 0x0, 0x99, 0x0, 0xb6, 0x0,
    0xba, 0xe, 0x50, 0x9, 0x90, 0xb, 0x60, 0x2,
    0x40, 0xe5, 0x0, 0x9f, 0xff, 0xf6, 0x0, 0x0,
    0xe, 0x50, 0x9, 0xa2, 0x22, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x43, 0x0, 0x0, 0x0, 0x32, 0x3e,
    0x50, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+6642 "時" */
    0x9f, 0xff, 0xf2, 0x0, 0xe, 0x40, 0x0, 0x9,
    0x91, 0x1f, 0x35, 0x55, 0xf7, 0x55, 0x30, 0x98,
    0x0, 0xf5, 0xcc, 0xcf, 0xdc, 0xc8, 0x9, 0x80,
    0xf, 0x20, 0x0, 0xe4, 0x0, 0x0, 0x98, 0x0,
    0xf9, 0x88, 0x8f, 0xa8, 0x88, 0x39, 0xff, 0xff,
    0x87, 0x77, 0x77, 0xea, 0x73, 0x99, 0x22, 0xf2,
    0x0, 0x0, 0xd, 0x60, 0x9, 0x80, 0xf, 0x65,
    0x55, 0x55, 0xe9, 0x51, 0x98, 0x0, 0xfc, 0xcc,
    0xcc, 0xcf, 0xdc, 0x39, 0x80, 0xf, 0x26, 0x50,
    0x0, 0xd6, 0x0, 0x9f, 0xff, 0xf2, 0x4f, 0x40,
    0xd, 0x60, 0x9, 0x92, 0x22, 0x0, 0x7e, 0x0,
    0xd6, 0x0, 0x43, 0x0, 0x0, 0x0, 0x41, 0x1d,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+66F4 "更" */
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x7, 0xaa, 0xaa, 0xac, 0xfa, 0xaa, 0xaa, 0xa1,
    0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x4d, 0x0, 0x5, 0xf0, 0x0, 0xf, 0x30,
    0x0, 0x4f, 0xcc, 0xcd, 0xfc, 0xcc, 0xcf, 0x30,
    0x0, 0x4e, 0x33, 0x37, 0xf3, 0x33, 0x3f, 0x30,
    0x0, 0x4d, 0x0, 0x5, 0xe0, 0x0, 0xf, 0x30,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x7, 0x70, 0xb, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf6, 0x4f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x48, 0xed, 0x9e, 0xeb, 0x86, 0x43, 0x21,
    0xa, 0xea, 0x50, 0x0, 0x37, 0xac, 0xdf, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+66FF "替" */
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xf2, 0x8f, 0xff, 0xff, 0x80,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0xe, 0xee, 0xfe, 0xe6, 0xce, 0xef, 0xee, 0xe0,
    0x1, 0x18, 0xf5, 0x10, 0x11, 0xbf, 0xa1, 0x10,
    0x0, 0x1e, 0xaf, 0x50, 0x6, 0xf4, 0xf4, 0x0,
    0x1, 0xca, 0x5, 0xe2, 0xaf, 0x40, 0x5f, 0x60,
    0x1e, 0x94, 0x44, 0x54, 0xc6, 0x44, 0x45, 0xe2,
    0x1, 0xf, 0xcc, 0xcc, 0xcc, 0xcc, 0xf0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,

    /* U+6700 "最" */
    0x0, 0x3f, 0xdd, 0xdd, 0xdd, 0xdd, 0xf4, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x3f, 0xcc, 0xcc, 0xcc, 0xcc, 0xf4, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0xd3, 0x0,
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x2b, 0xed, 0xbb, 0xed, 0xbb, 0xbb, 0xbb, 0xb2,
    0x0, 0xb6, 0x0, 0xa7, 0x1, 0x11, 0x11, 0x0,
    0x0, 0xbf, 0xee, 0xf7, 0xdf, 0xff, 0xff, 0x80,
    0x0, 0xb6, 0x0, 0xa7, 0xe, 0x20, 0x1e, 0x20,
    0x0, 0xbf, 0xee, 0xf7, 0x6, 0xc0, 0xb7, 0x0,
    0x0, 0xb6, 0x0, 0xba, 0x10, 0x9e, 0xa0, 0x0,
    0x2a, 0xef, 0xfe, 0xfd, 0x45, 0xd9, 0xe6, 0x0,
    0x4, 0x31, 0x0, 0xa7, 0xa8, 0x10, 0x18, 0xc1,

    /* U+6709 "有" */
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x22, 0x27, 0xf3, 0x22, 0x22, 0x22, 0x20,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd9, 0x22, 0x22, 0x22, 0x30, 0x0,
    0x0, 0xa, 0xff, 0xee, 0xee, 0xee, 0xf2, 0x0,
    0x0, 0x8e, 0xf4, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x9, 0xe3, 0xee, 0xdd, 0xdd, 0xdd, 0xf2, 0x0,
    0x1b, 0x20, 0xe6, 0x22, 0x22, 0x23, 0xf2, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0xe5, 0x11, 0x11, 0x11, 0xf2, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x1, 0x23, 0xf2, 0x0,
    0x0, 0x0, 0xe4, 0x0, 0x7, 0xfe, 0xb0, 0x0,

    /* U+670B "朋" */
    0x1, 0xff, 0xff, 0xf2, 0x2f, 0xff, 0xff, 0x60,
    0x1f, 0x21, 0x1f, 0x22, 0xf1, 0x11, 0xc6, 0x1,
    0xf1, 0x0, 0xf2, 0x2f, 0x0, 0xb, 0x60, 0x1f,
    0x10, 0xf, 0x22, 0xf0, 0x0, 0xb6, 0x1, 0xff,
    0xff, 0xf2, 0x2f, 0xff, 0xff, 0x60, 0x1f, 0x21,
    0x1f, 0x22, 0xf1, 0x11, 0xc6, 0x1, 0xf0, 0x0,
    0xf2, 0x2f, 0x0, 0xb, 0x60, 0x1f, 0x22, 0x2f,
    0x23, 0xf2, 0x22, 0xc6, 0x2, 0xff, 0xff, 0xf2,
    0x4f, 0xff, 0xff, 0x60, 0x4d, 0x0, 0xf, 0x26,
    0xb0, 0x0, 0xb6, 0x6, 0xb0, 0x0, 0xf2, 0x99,
    0x0, 0xb, 0x60, 0xa7, 0x0, 0xf, 0x2d, 0x50,
    0x0, 0xb6, 0xf, 0x20, 0x11, 0xf5, 0xf0, 0x2,
    0x2c, 0x65, 0xb0, 0xb, 0xfc, 0xa8, 0x0, 0xdf,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+670D "服" */
    0x4, 0xff, 0xff, 0x63, 0xff, 0xff, 0xff, 0x90,
    0x4, 0xd1, 0x1c, 0x63, 0xe2, 0x22, 0x2a, 0x90,
    0x4, 0xd0, 0xb, 0x63, 0xe0, 0x0, 0x9, 0x90,
    0x4, 0xd0, 0xb, 0x63, 0xe0, 0x3, 0x3b, 0x90,
    0x4, 0xfe, 0xef, 0x63, 0xe0, 0x8, 0xca, 0x30,
    0x4, 0xd3, 0x3c, 0x63, 0xf2, 0x22, 0x22, 0x20,
    0x4, 0xc0, 0xb, 0x63, 0xff, 0xff, 0xff, 0xf0,
    0x5, 0xd3, 0x3c, 0x63, 0xe7, 0x90, 0x7, 0xa0,
    0x6, 0xff, 0xff, 0x63, 0xe1, 0xe1, 0xd, 0x50,
    0x7, 0xa0, 0xb, 0x63, 0xe0, 0x99, 0x5d, 0x0,
    0x9, 0x80, 0xb, 0x63, 0xe0, 0x1e, 0xf4, 0x0,
    0xc, 0x50, 0xb, 0x63, 0xe0, 0x1d, 0xf3, 0x0,
    0x1f, 0x11, 0x1c, 0x63, 0xe3, 0xd9, 0x6f, 0x60,
    0x3a, 0x7, 0xfe, 0x23, 0xe9, 0x60, 0x4, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+671F "期" */
    0x0, 0xf1, 0x0, 0xf2, 0x1f, 0xff, 0xff, 0x90,
    0x2f, 0x32, 0x2f, 0x41, 0xf2, 0x11, 0x99, 0x5f,
    0xff, 0xff, 0xff, 0x5f, 0x10, 0x8, 0x90, 0xf,
    0x10, 0xf, 0x21, 0xf2, 0x11, 0x99, 0x0, 0xff,
    0xff, 0xf2, 0x1f, 0xff, 0xff, 0x90, 0xf, 0x10,
    0xf, 0x21, 0xf1, 0x0, 0x89, 0x0, 0xf2, 0x11,
    0xf2, 0x1f, 0x0, 0x8, 0x90, 0xf, 0xee, 0xef,
    0x21, 0xf0, 0x0, 0x89, 0x0, 0xf1, 0x0, 0xf2,
    0x2f, 0xee, 0xef, 0x96, 0xbf, 0xbb, 0xbf, 0xb7,
    0xd0, 0x0, 0x89, 0x36, 0x87, 0x68, 0x66, 0x8b,
    0x0, 0x8, 0x90, 0xd, 0x70, 0xb9, 0x9, 0x80,
    0x0, 0x89, 0xa, 0xc0, 0x1, 0xe5, 0xe3, 0x1,
    0x19, 0x94, 0xd1, 0x0, 0x3, 0x3c, 0x0, 0x9f,
    0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+672C "本" */
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x1e, 0x71, 0x11, 0x11, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x2, 0x22, 0x2a, 0xce, 0xbf, 0x32, 0x22, 0x10,
    0x0, 0x0, 0x1f, 0x4d, 0x6c, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x9c, 0xd, 0x64, 0xf2, 0x0, 0x0,
    0x0, 0x4, 0xf2, 0xd, 0x60, 0xac, 0x0, 0x0,
    0x0, 0x2e, 0x70, 0xd, 0x60, 0x1e, 0xa0, 0x0,
    0x2, 0xea, 0x0, 0xd, 0x60, 0x3, 0xfa, 0x0,
    0x4e, 0xa9, 0xff, 0xff, 0xff, 0xff, 0x5e, 0xc0,
    0x6, 0x2, 0x44, 0x4e, 0x84, 0x44, 0x2, 0x40,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0,

    /* U+673A "机" */
    0x0, 0x4, 0xe0, 0x0, 0xbf, 0xff, 0xf8, 0x0,
    0x0, 0x4, 0xe0, 0x0, 0xb8, 0x22, 0xb8, 0x0,
    0x0, 0x4, 0xe0, 0x0, 0xb7, 0x0, 0xa8, 0x0,
    0xf, 0xff, 0xff, 0xf4, 0xb7, 0x0, 0xa8, 0x0,
    0x2, 0x2a, 0xe2, 0x20, 0xb7, 0x0, 0xa8, 0x0,
    0x0, 0xe, 0xf0, 0x0, 0xb7, 0x0, 0xa8, 0x0,
    0x0, 0x4f, 0xfc, 0x0, 0xb6, 0x0, 0xa8, 0x0,
    0x0, 0xb9, 0xea, 0xb0, 0xc5, 0x0, 0xa8, 0x0,
    0x3, 0xd4, 0xe0, 0xc2, 0xe3, 0x0, 0xa8, 0x0,
    0xd, 0x64, 0xe0, 0x2, 0xf0, 0x0, 0xa8, 0x0,
    0x2c, 0x4, 0xe0, 0x6, 0xc0, 0x0, 0xa8, 0xa,
    0x0, 0x4, 0xe0, 0xd, 0x60, 0x0, 0xa8, 0x1d,
    0x0, 0x4, 0xe0, 0x7d, 0x0, 0x0, 0x9a, 0x4c,
    0x0, 0x4, 0xe0, 0xc3, 0x0, 0x0, 0x5f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+67E5 "查" */
    0x0, 0x0, 0x0, 0x9, 0x90, 0x0, 0x0, 0x0,
    0x3, 0x33, 0x33, 0x3a, 0xa3, 0x33, 0x33, 0x30,
    0x1d, 0xdd, 0xdd, 0xff, 0xff, 0xdd, 0xdd, 0xd1,
    0x0, 0x0, 0x9, 0xca, 0xac, 0x80, 0x0, 0x0,
    0x0, 0x2, 0xcb, 0x9, 0x90, 0x9b, 0x20, 0x0,
    0x2, 0x9e, 0x60, 0x9, 0x90, 0x4, 0xd9, 0x10,
    0x1c, 0x86, 0xbb, 0xbd, 0xdb, 0xbb, 0x55, 0xb1,
    0x0, 0x6, 0xc2, 0x22, 0x22, 0x2c, 0x70, 0x0,
    0x0, 0x6, 0xc1, 0x11, 0x11, 0x1c, 0x70, 0x0,
    0x0, 0x6, 0xfb, 0xbb, 0xbb, 0xbe, 0x70, 0x0,
    0x0, 0x6, 0xc0, 0x0, 0x0, 0xc, 0x70, 0x0,
    0x0, 0x5, 0xdd, 0xdd, 0xdd, 0xdd, 0x60, 0x0,
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,

    /* U+68C0 "检" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x5, 0xd0, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x1e, 0xf5, 0x0, 0x0,
    0x3, 0x4f, 0x31, 0x0, 0xc9, 0x3f, 0x40, 0x0,
    0x3f, 0xff, 0xf9, 0xb, 0xb0, 0x4, 0xf7, 0x0,
    0x0, 0x6f, 0x2, 0xdd, 0x44, 0x44, 0x7e, 0xb1,
    0x0, 0xaf, 0x9b, 0x86, 0xcc, 0xcc, 0xb1, 0xb1,
    0x0, 0xff, 0xc4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xbf, 0x48, 0x55, 0x6, 0x80, 0xc, 0x50,
    0xd, 0x5f, 0x0, 0x4c, 0x3, 0xc0, 0x2e, 0x0,
    0x5c, 0x2f, 0x0, 0xf, 0x10, 0xf0, 0x97, 0x0,
    0x3, 0x2f, 0x0, 0xb, 0x30, 0x81, 0xe0, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x0, 0x8, 0x70, 0x0,
    0x0, 0x2f, 0x6, 0xcc, 0xcc, 0xcf, 0xdc, 0xc0,
    0x0, 0x2f, 0x2, 0x44, 0x44, 0x44, 0x44, 0x40,

    /* U+691C "検" */
    0x0, 0xe, 0x30, 0x0, 0x7, 0xe7, 0x0, 0x0,
    0x0, 0xe, 0x30, 0x0, 0x6d, 0x1b, 0x90, 0x0,
    0x0, 0xe, 0x30, 0x9, 0xd1, 0x0, 0xad, 0x30,
    0x2e, 0xef, 0xfe, 0xee, 0xa9, 0x99, 0x9c, 0xf8,
    0x2, 0x4f, 0x52, 0x33, 0x67, 0xf7, 0x63, 0x12,
    0x0, 0x6f, 0x40, 0x0, 0x1, 0xf1, 0x0, 0x0,
    0x0, 0xbf, 0xd1, 0xcf, 0xef, 0xfe, 0xef, 0xd0,
    0x2, 0xde, 0x9a, 0xc5, 0x1, 0xf0, 0x4, 0xd0,
    0x9, 0x7e, 0x39, 0xc5, 0x1, 0xf0, 0x4, 0xd0,
    0x2e, 0x1e, 0x30, 0xbf, 0xff, 0xff, 0xff, 0xd0,
    0x47, 0xe, 0x30, 0x0, 0x9, 0xed, 0x0, 0x0,
    0x0, 0xe, 0x30, 0x0, 0x6e, 0x2c, 0xa0, 0x0,
    0x0, 0xe, 0x30, 0x2a, 0xe3, 0x1, 0xcd, 0x50,
    0x0, 0xe, 0x34, 0xe7, 0x0, 0x0, 0x6, 0xd6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6A21 "模" */
    0x0, 0x3f, 0x0, 0x0, 0xe3, 0x5, 0xd0, 0x0,
    0x0, 0x3f, 0x2, 0xcc, 0xfd, 0xcd, 0xfc, 0xc1,
    0x2, 0x5f, 0x22, 0x22, 0xe5, 0x26, 0xe2, 0x20,
    0x3f, 0xff, 0xf9, 0x48, 0x98, 0x88, 0x98, 0x20,
    0x0, 0x5f, 0x10, 0x9b, 0x66, 0x66, 0x6f, 0x40,
    0x0, 0x9f, 0xa0, 0x9e, 0xcc, 0xcc, 0xcf, 0x40,
    0x0, 0xef, 0xd4, 0x99, 0x11, 0x11, 0x1e, 0x40,
    0x4, 0xef, 0x5a, 0x9c, 0x88, 0x88, 0x8f, 0x40,
    0xa, 0x9f, 0x1, 0x36, 0x69, 0xe6, 0x66, 0x10,
    0x2e, 0x4f, 0x0, 0x11, 0x19, 0xa1, 0x11, 0x10,
    0x38, 0x3f, 0x9, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x3f, 0x0, 0x0, 0x8d, 0x5e, 0x20, 0x0,
    0x0, 0x3f, 0x0, 0x3b, 0xd2, 0x6, 0xe7, 0x10,
    0x0, 0x3f, 0xa, 0xc6, 0x0, 0x0, 0x2a, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6A5F "機" */
    0x0, 0x3c, 0x0, 0x7, 0x1c, 0x40, 0x55, 0x0,
    0x0, 0x3c, 0x0, 0x1c, 0xb, 0x40, 0xc2, 0x20,
    0x2, 0x5c, 0x20, 0xa4, 0xaa, 0x56, 0xb7, 0xc0,
    0xf, 0xff, 0xf6, 0xfe, 0x79, 0x6c, 0xbf, 0x20,
    0x0, 0x8c, 0x1, 0x2c, 0x68, 0x80, 0x87, 0x90,
    0x0, 0xcf, 0x20, 0xc6, 0xd7, 0xa5, 0xe8, 0xe3,
    0x1, 0xfe, 0xc5, 0xc9, 0xa8, 0xc6, 0xd6, 0x65,
    0x6, 0xbc, 0xb2, 0x3d, 0x2, 0xf0, 0x4e, 0x30,
    0xc, 0x6c, 0x6, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x3c, 0x3c, 0x0, 0x4e, 0x10, 0xa6, 0xa, 0x50,
    0x4, 0x3c, 0x0, 0x9c, 0xd1, 0x5c, 0x7d, 0x0,
    0x0, 0x3c, 0x2, 0xf2, 0x65, 0xf, 0xe1, 0x6,
    0x0, 0x3c, 0x1d, 0x80, 0x5, 0xdb, 0xf6, 0x6b,
    0x0, 0x3c, 0x68, 0x0, 0x6a, 0x20, 0x5d, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6AA2 "檢" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x8e, 0xba, 0x10, 0x0,
    0x2, 0x4f, 0x21, 0x1a, 0xc1, 0x7, 0xe7, 0x0,
    0xf, 0xff, 0xfa, 0xea, 0xaa, 0xaa, 0x7a, 0xf1,
    0x0, 0x5f, 0x0, 0x20, 0x33, 0x33, 0x10, 0x10,
    0x0, 0xaf, 0x70, 0xce, 0xec, 0x3e, 0xee, 0x30,
    0x0, 0xde, 0xc1, 0xe0, 0x1e, 0x3a, 0xc, 0x30,
    0x5, 0xae, 0x55, 0xe0, 0x1e, 0x3a, 0xc, 0x30,
    0xc, 0x4e, 0x0, 0xee, 0xee, 0x3f, 0xef, 0x30,
    0x2d, 0x1e, 0x0, 0x5, 0x50, 0x1, 0x70, 0x0,
    0x3, 0x1e, 0x0, 0xd, 0x60, 0x6, 0xb0, 0x0,
    0x0, 0x1e, 0x0, 0x7d, 0xe5, 0xd, 0xf7, 0x0,
    0x0, 0x1e, 0x7, 0xe1, 0x2a, 0x8b, 0x1c, 0xb0,
    0x0, 0x1e, 0x3d, 0x20, 0x1, 0xc1, 0x0, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6B63 "正" */
    0x2, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x20,
    0x8, 0xee, 0xee, 0xee, 0xfe, 0xee, 0xee, 0x90,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf3, 0x33, 0x33, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf0, 0x0, 0x0, 0x0,
    0x19, 0x9f, 0xb9, 0x9b, 0xf9, 0x99, 0x99, 0x91,
    0x19, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x91,

    /* U+6CD5 "法" */
    0x1, 0xb7, 0x10, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x0, 0x18, 0xe2, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xae, 0xef, 0xfe, 0xee, 0x70,
    0x0, 0x0, 0x0, 0x23, 0x37, 0xf3, 0x33, 0x10,
    0xd, 0xa1, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x2, 0xbf, 0x30, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x0, 0x5, 0x4, 0xbb, 0xbd, 0xfb, 0xbb, 0xb1,
    0x0, 0x0, 0x2, 0x66, 0x6f, 0xb6, 0x66, 0x60,
    0x0, 0x0, 0xa1, 0x0, 0x5f, 0x10, 0x0, 0x0,
    0x0, 0x6, 0xe0, 0x0, 0xd7, 0x4, 0xa0, 0x0,
    0x0, 0xe, 0x60, 0x7, 0xd0, 0x0, 0xd7, 0x0,
    0x0, 0x8d, 0x0, 0x2f, 0x40, 0x23, 0x9f, 0x20,
    0x3, 0xf4, 0x0, 0xdf, 0xef, 0xfd, 0xbc, 0xa0,
    0x4, 0x90, 0x0, 0x66, 0x31, 0x0, 0x2, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6D3B "活" */
    0x0, 0x40, 0x0, 0x0, 0x0, 0x0, 0x37, 0x0,
    0x3, 0xec, 0x30, 0x35, 0x7a, 0xcf, 0xeb, 0x30,
    0x0, 0x8, 0xe0, 0xcb, 0x99, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x1d, 0x70, 0xc, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x4, 0xde, 0x22, 0x33, 0x35, 0xf3, 0x33, 0x31,
    0x0, 0x6, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x0, 0x1, 0x80, 0xbf, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x9, 0xb0, 0xb7, 0x22, 0x22, 0x2e, 0x40,
    0x0, 0x3f, 0x20, 0xb6, 0x0, 0x0, 0xe, 0x40,
    0x0, 0xc9, 0x0, 0xb6, 0x0, 0x0, 0xe, 0x40,
    0x7, 0xe1, 0x0, 0xb9, 0x44, 0x44, 0x4e, 0x40,
    0x7, 0x60, 0x0, 0xbe, 0xcc, 0xcc, 0xcf, 0x40,

    /* U+6D41 "流" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0,
    0x6, 0xd4, 0x0, 0x0, 0xc, 0x60, 0x0, 0x0,
    0x0, 0x6f, 0x64, 0x55, 0x5a, 0xd5, 0x55, 0x50,
    0x0, 0x3, 0x3b, 0xcc, 0xfe, 0xcc, 0xcc, 0xc1,
    0x0, 0x0, 0x0, 0x5, 0xe1, 0x4, 0xb0, 0x0,
    0x1b, 0x40, 0x0, 0x3f, 0x40, 0x0, 0xba, 0x0,
    0x6, 0xeb, 0x6, 0xef, 0xcd, 0xef, 0xff, 0x70,
    0x0, 0x6, 0x4, 0x64, 0x32, 0x10, 0x2, 0xb0,
    0x0, 0x0, 0x0, 0x97, 0xb, 0x40, 0xe2, 0x0,
    0x0, 0x3, 0x90, 0x97, 0xc, 0x40, 0xf3, 0x0,
    0x0, 0xb, 0x90, 0xa7, 0xc, 0x40, 0xf3, 0x0,
    0x0, 0x4f, 0x10, 0xd5, 0xc, 0x40, 0xf3, 0x0,
    0x0, 0xd8, 0x2, 0xf1, 0xc, 0x40, 0xf3, 0x74,
    0x8, 0xe0, 0x1c, 0xa0, 0xc, 0x40, 0xe3, 0x85,
    0x9, 0x50, 0x7c, 0x10, 0x5, 0x20, 0xaf, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6D4B "测" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5d, 0x82, 0xff, 0xff, 0xf2, 0x0, 0x1e, 0x0,
    0x2a, 0x3f, 0x0, 0xd, 0x21, 0xd1, 0xe0, 0x0,
    0x0, 0xf0, 0xd0, 0xd2, 0x1d, 0x1e, 0x4, 0x0,
    0xf, 0xe, 0xd, 0x21, 0xd1, 0xe2, 0xec, 0x20,
    0xf0, 0xe0, 0xd2, 0x1d, 0x1e, 0x0, 0x9a, 0xf,
    0xe, 0xd, 0x21, 0xd1, 0xe0, 0x0, 0x0, 0xf0,
    0xe0, 0xd2, 0x1d, 0x1e, 0x0, 0x0, 0xf, 0xe,
    0xd, 0x21, 0xd1, 0xe0, 0x2, 0xd0, 0xf0, 0xe0,
    0xd2, 0x1d, 0x1e, 0x0, 0x8b, 0xf, 0xe, 0xd,
    0x21, 0xd1, 0xe0, 0xe, 0x50, 0x5, 0xa0, 0x0,
    0x7, 0x1e, 0x4, 0xf0, 0x0, 0xc5, 0xc1, 0x0,
    0x1, 0xe0, 0xc9, 0x0, 0xa9, 0x5, 0xd1, 0x0,
    0x1e, 0x8, 0x20, 0x88, 0x0, 0x8, 0x50, 0xdf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6D4F "浏" */
    0x5, 0x30, 0x0, 0xb2, 0x0, 0x0, 0xd, 0x40,
    0x4e, 0x40, 0x8, 0xb0, 0x2, 0x60, 0xd4, 0x0,
    0x49, 0x68, 0x9b, 0x88, 0x5b, 0xd, 0x40, 0x0,
    0x6, 0x88, 0x9f, 0x85, 0xb0, 0xd4, 0x15, 0x0,
    0x0, 0x3, 0xe0, 0x4b, 0xd, 0x42, 0xd9, 0x3,
    0xd0, 0x7a, 0x4, 0xb0, 0xd4, 0x1, 0xc3, 0x9,
    0xab, 0x60, 0x4b, 0xd, 0x40, 0x0, 0x0, 0xd,
    0xf2, 0x4, 0xb0, 0xd4, 0x0, 0x12, 0x0, 0x7f,
    0x10, 0x4b, 0xd, 0x40, 0x7, 0xb0, 0xc, 0xe9,
    0x4, 0xb0, 0xd4, 0x0, 0xe4, 0x5, 0xe2, 0xf2,
    0x4a, 0xd, 0x40, 0x7d, 0x1, 0xe5, 0x9, 0x80,
    0x0, 0xd4, 0xe, 0x51, 0xd9, 0x0, 0x10, 0x0,
    0x1e, 0x30, 0x40, 0x6, 0x0, 0x0, 0x0, 0x6f,
    0xd1,

    /* U+6E2C "測" */
    0x5, 0xd7, 0xf, 0xff, 0xfe, 0x0, 0x3, 0xe0,
    0x3, 0xc3, 0xf1, 0x13, 0xe1, 0xe0, 0x3e, 0x0,
    0x0, 0xf, 0x0, 0x3e, 0x2f, 0x3, 0xe0, 0x10,
    0x0, 0xff, 0xff, 0xe2, 0xf0, 0x3e, 0x2f, 0xa1,
    0xf, 0x11, 0x4e, 0x2f, 0x3, 0xe0, 0x2b, 0xb0,
    0xf0, 0x3, 0xe2, 0xf0, 0x3e, 0x0, 0x1, 0xf,
    0xee, 0xee, 0x2f, 0x3, 0xe0, 0x0, 0x0, 0xf2,
    0x14, 0xe2, 0xf0, 0x3e, 0x0, 0x9, 0xf, 0x0,
    0x3e, 0x2f, 0x3, 0xe0, 0x6, 0xd0, 0xfd, 0xde,
    0xe2, 0xf0, 0x3e, 0x0, 0xc7, 0x6, 0x73, 0x74,
    0x3, 0x3, 0xe0, 0x3f, 0x10, 0xd7, 0x8, 0xc0,
    0x0, 0x3e, 0xb, 0x90, 0x9c, 0x0, 0xc, 0x61,
    0x25, 0xe0, 0x82, 0x2d, 0x10, 0x0, 0x11, 0x8f,
    0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+6E80 "満" */
    0x8, 0xa4, 0x0, 0xe, 0x30, 0xe, 0x40, 0x0,
    0x0, 0x6e, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x2, 0x2f, 0x42, 0x2f, 0x52, 0x10,
    0x0, 0x0, 0x1, 0x1f, 0x41, 0x1f, 0x41, 0x10,
    0x6d, 0x50, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x1a, 0xfa, 0x0, 0x0, 0xf, 0x30, 0x0, 0x0,
    0x0, 0x45, 0x3, 0x44, 0x4f, 0x64, 0x44, 0x20,
    0x0, 0x0, 0xe, 0xdc, 0xcf, 0xdc, 0xce, 0xa0,
    0x0, 0x5, 0xe, 0x24, 0xd, 0x12, 0x17, 0xa0,
    0x0, 0x3f, 0x1e, 0x2c, 0xd, 0x18, 0x47, 0xa0,
    0x0, 0xb9, 0xe, 0x2c, 0xd, 0x18, 0x47, 0xa0,
    0x4, 0xf1, 0xe, 0x2f, 0xee, 0xef, 0x47, 0xa0,
    0xd, 0x90, 0xe, 0x2b, 0x0, 0x5, 0x27, 0xa0,
    0x9, 0x10, 0xe, 0x20, 0x0, 0x7, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6E90 "源" */
    0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xdd, 0x36, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x9, 0xa6, 0xc1, 0x11, 0x49, 0x11, 0x10,
    0x0, 0x0, 0x6, 0xc0, 0x0, 0x8b, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xc3, 0xff, 0xff, 0xff, 0xd0,
    0xe, 0x70, 0x6, 0xc4, 0xe0, 0x0, 0x3, 0xe0,
    0x4, 0xeb, 0x6, 0xb4, 0xe3, 0x33, 0x35, 0xe0,
    0x0, 0x18, 0x7, 0xb4, 0xfb, 0xbb, 0xbc, 0xe0,
    0x0, 0x0, 0x8, 0xa4, 0xe1, 0x11, 0x14, 0xe0,
    0x0, 0x6, 0x2a, 0x83, 0xdd, 0xdf, 0xdd, 0xc0,
    0x0, 0xf, 0x4d, 0x50, 0x30, 0x3e, 0x4, 0x0,
    0x0, 0x7d, 0x1f, 0x12, 0xf3, 0x3e, 0xb, 0x90,
    0x0, 0xe5, 0x6d, 0xc, 0x80, 0x3e, 0x2, 0xf2,
    0x8, 0xd0, 0xd7, 0x5c, 0x0, 0x3e, 0x0, 0x75,
    0x6, 0x52, 0xb0, 0x0, 0x1f, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6EE1 "满" */
    0x2, 0x91, 0x1, 0x1d, 0x61, 0x1d, 0x51, 0x10,
    0x1, 0x9f, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x4, 0x10, 0xc, 0x50, 0xc, 0x50, 0x0,
    0x0, 0x0, 0x16, 0x68, 0x76, 0x68, 0x76, 0x61,
    0x8, 0x20, 0x3a, 0xaa, 0xfa, 0xaf, 0xaa, 0xa1,
    0x19, 0xf7, 0x0, 0x2, 0xe0, 0x1e, 0x0, 0x0,
    0x0, 0x35, 0xe, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0xe, 0x55, 0xc1, 0x5c, 0x17, 0xb0,
    0x0, 0x8, 0x2e, 0x36, 0xc0, 0x6d, 0x6, 0xb0,
    0x0, 0x2f, 0x3e, 0x3a, 0xd8, 0xad, 0x86, 0xb0,
    0x0, 0x9b, 0xe, 0x6e, 0x17, 0xe2, 0xe8, 0xb0,
    0x2, 0xf3, 0xe, 0xa5, 0xb, 0x80, 0x26, 0xb0,
    0xa, 0xc0, 0xe, 0x30, 0x1, 0x0, 0x6, 0xb0,
    0x6, 0x30, 0xe, 0x30, 0x0, 0x2, 0xde, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6EFF "滿" */
    0x7, 0x81, 0x0, 0x1f, 0x10, 0x4, 0xe0, 0x0,
    0x1, 0x9f, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x1, 0x2, 0x3f, 0x32, 0x25, 0xf2, 0x21,
    0x0, 0x0, 0x0, 0x1f, 0x88, 0x8a, 0xe0, 0x0,
    0x3a, 0x10, 0x0, 0x8, 0x8f, 0x98, 0x70, 0x0,
    0x1b, 0xe4, 0x1, 0x11, 0x1f, 0x31, 0x11, 0x10,
    0x0, 0x63, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x1f, 0x14, 0xe, 0x25, 0x12, 0xd0,
    0x0, 0x7, 0x2f, 0xc, 0xe, 0x25, 0x82, 0xd0,
    0x0, 0x2e, 0x2f, 0xd, 0x5e, 0x27, 0xe3, 0xd0,
    0x0, 0xa8, 0x1f, 0x59, 0xae, 0x4d, 0x79, 0xd0,
    0x3, 0xf1, 0x1f, 0x90, 0x8e, 0x94, 0x1a, 0xd0,
    0xc, 0x80, 0x1f, 0x0, 0xe, 0x20, 0x2, 0xd0,
    0x9, 0x0, 0x1f, 0x0, 0xe, 0x20, 0x9e, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6FC0 "激" */
    0x2, 0x0, 0x0, 0x62, 0x0, 0x16, 0x0, 0x0,
    0xa, 0xb0, 0x1, 0xf2, 0x0, 0x4d, 0x0, 0x0,
    0x0, 0x9b, 0xbe, 0xfe, 0xe2, 0x6a, 0x0, 0x0,
    0x0, 0x1, 0xc3, 0x0, 0xe3, 0xac, 0x88, 0x81,
    0x0, 0x0, 0xce, 0xdd, 0xf3, 0xea, 0x8d, 0xb1,
    0x2d, 0x40, 0xc3, 0x0, 0xe6, 0xf3, 0xb, 0x40,
    0x5, 0xf3, 0xcc, 0xcc, 0xfd, 0xf5, 0xd, 0x20,
    0x0, 0x20, 0x14, 0xb2, 0x29, 0x98, 0xf, 0x0,
    0x0, 0x1, 0x67, 0xf8, 0x65, 0x2c, 0x3c, 0x0,
    0x0, 0x23, 0x9d, 0xa9, 0x97, 0xd, 0x98, 0x0,
    0x0, 0x89, 0xa, 0x53, 0x30, 0x9, 0xf3, 0x0,
    0x0, 0xe3, 0xc, 0xcc, 0xf1, 0x5, 0xf0, 0x0,
    0x6, 0xc0, 0x1d, 0x1, 0xf0, 0xd, 0xd9, 0x0,
    0xd, 0x60, 0xb7, 0x3, 0xe0, 0xaa, 0x2f, 0x60,
    0x1c, 0x8, 0xb0, 0xef, 0x87, 0xc0, 0x4, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+700F "瀏" */
    0x0, 0x0, 0x1, 0x70, 0x0, 0x0, 0x0, 0x0,
    0xa6, 0x9, 0xd7, 0x7f, 0xed, 0x0, 0xd3, 0x2,
    0xe6, 0xd0, 0x20, 0xd0, 0xcc, 0xd, 0x30, 0x2,
    0x2d, 0xc, 0xd, 0x1b, 0xd0, 0xd3, 0x0, 0x0,
    0xd6, 0xe7, 0xa3, 0x9d, 0xd, 0x35, 0x80, 0x1f,
    0x84, 0xb9, 0xd5, 0xd0, 0xd3, 0x1b, 0xb0, 0x20,
    0x8f, 0x71, 0xd, 0xd, 0x30, 0x8, 0x1, 0xaa,
    0x18, 0xb1, 0xd0, 0xd3, 0x0, 0x3, 0xea, 0xaa,
    0xa8, 0x9d, 0xd, 0x30, 0x4, 0x41, 0x2, 0xe2,
    0x10, 0xd0, 0xd3, 0x0, 0xb5, 0xbd, 0xdf, 0xdd,
    0x7d, 0xd, 0x30, 0x2e, 0x0, 0x80, 0xe0, 0xa0,
    0x20, 0xd3, 0x9, 0x80, 0xc, 0x2e, 0x68, 0x0,
    0xd, 0x31, 0xf1, 0x15, 0xa9, 0xfe, 0xdb, 0x0,
    0xd2, 0x5, 0x2, 0x97, 0x54, 0x20, 0x9, 0xfc,
    0x0,

    /* U+70B9 "点" */
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x0, 0x0, 0xb, 0x83, 0x33, 0x33, 0x10,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x29, 0x99, 0x9e, 0xc9, 0x99, 0x92, 0x0,
    0x0, 0x3f, 0x88, 0x88, 0x88, 0x88, 0xf4, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0xe4, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0xe4, 0x0,
    0x0, 0x3f, 0xcc, 0xcc, 0xcc, 0xcc, 0xf4, 0x0,
    0x0, 0x15, 0x55, 0x55, 0x55, 0x55, 0x51, 0x0,
    0x0, 0x28, 0x1, 0x40, 0x16, 0x0, 0x93, 0x0,
    0x0, 0xaa, 0x5, 0xe0, 0xe, 0x30, 0x6e, 0x10,
    0x4, 0xf2, 0x3, 0xf0, 0x9, 0xa0, 0xc, 0xa0,
    0xc, 0x60, 0x1, 0xd1, 0x4, 0xa0, 0x3, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+70ED "热" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xc0, 0x0, 0xb, 0x60, 0x0, 0x0,
    0x2, 0x27, 0xd2, 0x11, 0x1c, 0x71, 0x30, 0x0,
    0xa, 0xff, 0xff, 0xae, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x5, 0xc0, 0x0, 0xd, 0x40, 0xb6, 0x0,
    0x0, 0x5, 0xc2, 0x40, 0xe, 0x30, 0xb6, 0x0,
    0x2, 0x6b, 0xfe, 0x9c, 0x9f, 0x0, 0xb6, 0x0,
    0xe, 0xcb, 0xd0, 0x1, 0xbf, 0x50, 0xb6, 0x0,
    0x0, 0x5, 0xc0, 0x0, 0xda, 0xd8, 0x97, 0x13,
    0x0, 0x5, 0xc0, 0xb, 0xd0, 0x13, 0x7a, 0x4b,
    0x0, 0xef, 0x90, 0x8c, 0x10, 0x0, 0x1e, 0xe6,
    0x0, 0x25, 0x0, 0x10, 0x1, 0x0, 0x44, 0x20,
    0x0, 0x8c, 0x3, 0xe0, 0xc, 0x60, 0x7e, 0x20,
    0x3, 0xf3, 0x1, 0xf1, 0x6, 0xc0, 0xb, 0xc0,
    0xb, 0x70, 0x0, 0xe2, 0x2, 0xc0, 0x1, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7121 "無" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xb6, 0x66, 0x66, 0x66, 0x66, 0x30,
    0x1, 0xcf, 0xcb, 0xfb, 0xbf, 0xbc, 0xfb, 0x70,
    0x1d, 0xaf, 0x21, 0xf0, 0x2e, 0x3, 0xe0, 0x0,
    0x4, 0xe, 0x21, 0xf0, 0x2e, 0x3, 0xe0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x1, 0x2f, 0x43, 0xf2, 0x4f, 0x25, 0xf2, 0x10,
    0x0, 0xe, 0x21, 0xf0, 0x2e, 0x3, 0xe0, 0x0,
    0x0, 0xe, 0x21, 0xf0, 0x2e, 0x3, 0xe0, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x1, 0x22, 0x11, 0x11, 0x11, 0x11, 0x23, 0x10,
    0x0, 0xaa, 0x5, 0x90, 0xe, 0x20, 0x9c, 0x0,
    0x3, 0xf2, 0x4, 0xd0, 0xa, 0x90, 0xd, 0x80,
    0xd, 0x80, 0x3, 0xf0, 0x5, 0xd0, 0x3, 0xf2,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+7248 "版" */
    0x0, 0x0, 0x0, 0x0, 0x12, 0x46, 0x9c, 0xa0,
    0x5, 0xc0, 0x4d, 0x4, 0xfe, 0xcb, 0x86, 0x20,
    0x5, 0xc0, 0x4d, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x5, 0xc0, 0x4d, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x5, 0xd3, 0x7d, 0x35, 0xe0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xa0,
    0x5, 0xc1, 0x11, 0x14, 0xec, 0x52, 0x2a, 0x90,
    0x5, 0xc0, 0x0, 0x4, 0xd8, 0x70, 0xc, 0x50,
    0x5, 0xfd, 0xdd, 0x34, 0xd3, 0xc0, 0x1f, 0x10,
    0x6, 0xc4, 0x4e, 0x45, 0xc0, 0xe2, 0x8b, 0x0,
    0x7, 0xa0, 0xd, 0x47, 0xb0, 0x7b, 0xf4, 0x0,
    0x9, 0x80, 0xd, 0x49, 0x90, 0x1f, 0xb0, 0x0,
    0xd, 0x50, 0xd, 0x4c, 0x50, 0x8f, 0xe2, 0x0,
    0x2f, 0x10, 0xd, 0x5f, 0x3a, 0xe2, 0x8e, 0x50,
    0x39, 0x0, 0xd, 0x7a, 0x6b, 0x10, 0x6, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+72B6 "状" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf2, 0x0, 0x5, 0xd0, 0x52, 0x0,
    0x1, 0x0, 0xf2, 0x0, 0x5, 0xd0, 0x6d, 0x10,
    0xe, 0x50, 0xf2, 0x0, 0x5, 0xd0, 0x9, 0xb0,
    0x3, 0xf4, 0xf2, 0x0, 0x5, 0xd0, 0x0, 0x10,
    0x0, 0x77, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x0, 0xf2, 0x44, 0x49, 0xf5, 0x44, 0x41,
    0x0, 0x1, 0xf2, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x1d, 0xf2, 0x0, 0xc, 0xea, 0x0, 0x0,
    0x3, 0xe9, 0xf2, 0x0, 0x1f, 0x5f, 0x10, 0x0,
    0x3f, 0x70, 0xf2, 0x0, 0x8d, 0xb, 0x80, 0x0,
    0x5, 0x0, 0xf2, 0x2, 0xf5, 0x3, 0xf2, 0x0,
    0x0, 0x0, 0xf2, 0xc, 0xc0, 0x0, 0xad, 0x10,
    0x0, 0x0, 0xf3, 0xce, 0x10, 0x0, 0xc, 0xd3,
    0x0, 0x0, 0xf6, 0xc2, 0x0, 0x0, 0x1, 0xb5,

    /* U+72C0 "狀" */
    0x8, 0x90, 0x5c, 0x0, 0x0, 0xf2, 0xa6, 0x0,
    0x8, 0x90, 0x5c, 0x0, 0x0, 0xf2, 0x2e, 0x40,
    0x8, 0x90, 0x5c, 0x0, 0x0, 0xf2, 0x5, 0xd0,
    0x8, 0x90, 0x5c, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0x8, 0xff, 0xfc, 0x7e, 0xee, 0xff, 0xee, 0xe6,
    0x0, 0x11, 0x6c, 0x24, 0x45, 0xfa, 0x44, 0x42,
    0x0, 0x0, 0x5c, 0x0, 0x2, 0xfa, 0x0, 0x0,
    0x16, 0x66, 0x9c, 0x0, 0x4, 0xfd, 0x0, 0x0,
    0x3b, 0xfc, 0xcc, 0x0, 0x8, 0xbf, 0x20, 0x0,
    0x0, 0xe2, 0x5c, 0x0, 0xe, 0x6a, 0x80, 0x0,
    0x0, 0xf0, 0x5c, 0x0, 0x7e, 0x4, 0xf1, 0x0,
    0x5, 0xd0, 0x5c, 0x3, 0xf5, 0x0, 0xbc, 0x0,
    0xd, 0x70, 0x5c, 0x4e, 0x80, 0x0, 0x1e, 0xc1,
    0x17, 0x0, 0x5c, 0xa7, 0x0, 0x0, 0x1, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+73B0 "现" */
    0x2f, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0x10,
    0x1c, 0xcf, 0xcc, 0x3f, 0x11, 0x11, 0x2f, 0x10,
    0x0, 0xf, 0x20, 0x1f, 0x10, 0x40, 0x1f, 0x10,
    0x0, 0xf, 0x20, 0x1f, 0x12, 0xf0, 0x1f, 0x10,
    0x0, 0xf, 0x20, 0x1f, 0x12, 0xf0, 0x1f, 0x10,
    0xd, 0xff, 0xfd, 0x1f, 0x12, 0xf0, 0x1f, 0x10,
    0x2, 0x2f, 0x52, 0x1f, 0x12, 0xf0, 0x1f, 0x10,
    0x0, 0xf, 0x20, 0x1f, 0x14, 0xe0, 0x1f, 0x10,
    0x0, 0xf, 0x20, 0x8, 0x6, 0xd3, 0x8, 0x0,
    0x0, 0xf, 0x22, 0x10, 0xb, 0xea, 0x0, 0x0,
    0x0, 0x2f, 0xdf, 0x50, 0x3f, 0x8a, 0x0, 0x82,
    0x2d, 0xfd, 0x72, 0x1, 0xe7, 0x7a, 0x0, 0xc3,
    0x17, 0x20, 0x0, 0x2d, 0xa0, 0x6b, 0x0, 0xe1,
    0x0, 0x0, 0x5, 0xf9, 0x0, 0x3e, 0xee, 0xb0,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+73FE "現" */
    0x3f, 0xff, 0xff, 0x4f, 0xff, 0xff, 0xff, 0x50,
    0x2a, 0xaf, 0xba, 0x3f, 0x20, 0x0, 0xd, 0x50,
    0x0, 0xf, 0x20, 0xf, 0x30, 0x0, 0xd, 0x50,
    0x0, 0xf, 0x20, 0xf, 0xee, 0xee, 0xef, 0x50,
    0x3, 0x3f, 0x53, 0xf, 0x20, 0x0, 0xd, 0x50,
    0xd, 0xdf, 0xdd, 0x1f, 0xcc, 0xcc, 0xcf, 0x50,
    0x0, 0xf, 0x20, 0xf, 0x53, 0x33, 0x3d, 0x50,
    0x0, 0xf, 0x20, 0xf, 0x20, 0x0, 0xd, 0x50,
    0x0, 0xf, 0x20, 0xf, 0xff, 0xff, 0xff, 0x50,
    0x0, 0xf, 0xad, 0x70, 0xa7, 0xe, 0x30, 0x0,
    0x4c, 0xfd, 0x84, 0x0, 0xe4, 0xe, 0x30, 0x0,
    0x26, 0x20, 0x0, 0x7, 0xe0, 0xe, 0x30, 0x73,
    0x0, 0x0, 0x1, 0x8f, 0x40, 0xe, 0x40, 0xc4,
    0x0, 0x0, 0x1e, 0xc3, 0x0, 0xa, 0xff, 0xd0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7528 "用" */
    0x0, 0x25, 0x55, 0x55, 0x55, 0x55, 0x55, 0x0,
    0x8, 0xfd, 0xdd, 0xef, 0xdd, 0xdd, 0xf3, 0x0,
    0x8a, 0x0, 0x5, 0xe0, 0x0, 0xf, 0x30, 0x8,
    0xa0, 0x0, 0x5e, 0x0, 0x0, 0xf3, 0x0, 0x8f,
    0xdd, 0xde, 0xfd, 0xdd, 0xdf, 0x30, 0x8, 0xc5,
    0x55, 0x8f, 0x55, 0x55, 0xf3, 0x0, 0x89, 0x0,
    0x5, 0xe0, 0x0, 0xf, 0x30, 0x9, 0x90, 0x0,
    0x5e, 0x0, 0x0, 0xf3, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0xc, 0x83, 0x33, 0x7e,
    0x33, 0x33, 0xf3, 0x0, 0xf3, 0x0, 0x5, 0xe0,
    0x0, 0xf, 0x30, 0x5f, 0x0, 0x0, 0x5e, 0x0,
    0x0, 0xf3, 0xc, 0x80, 0x0, 0x5, 0xe0, 0x11,
    0x2f, 0x23, 0xd1, 0x0, 0x0, 0x4e, 0x8, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+7535 "电" */
    0x0, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0, 0x13,
    0x22, 0x27, 0xf2, 0x22, 0x22, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x30, 0xc8, 0x11, 0x16,
    0xf1, 0x11, 0x1f, 0x30, 0xc7, 0x0, 0x5, 0xe0,
    0x0, 0xf, 0x30, 0xce, 0xdd, 0xde, 0xfd, 0xdd,
    0xdf, 0x30, 0xc9, 0x44, 0x48, 0xf4, 0x44, 0x4f,
    0x30, 0xc7, 0x0, 0x5, 0xe0, 0x0, 0xf, 0x30,
    0xc9, 0x33, 0x37, 0xf3, 0x33, 0x3f, 0x30, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xb7, 0x0,
    0x5, 0xe0, 0x0, 0x0, 0x54, 0x0, 0x0, 0x5,
    0xe0, 0x0, 0x0, 0x8b, 0x0, 0x0, 0x4, 0xf5,
    0x33, 0x34, 0xd7, 0x0, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xc1,

    /* U+767B "登" */
    0x0, 0x0, 0x0, 0x0, 0x52, 0x0, 0x40, 0x0,
    0x6, 0xff, 0xff, 0xf5, 0x9a, 0xb, 0xc0, 0x0,
    0x0, 0x10, 0x4, 0xf1, 0x1f, 0xda, 0x1, 0x30,
    0x2, 0xe6, 0x1e, 0x70, 0x6, 0xf2, 0x2d, 0x80,
    0x0, 0x2d, 0xea, 0x0, 0x0, 0x9d, 0xe6, 0x0,
    0x0, 0x2d, 0xad, 0xff, 0xff, 0xe9, 0xe4, 0x0,
    0x8, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xa2,
    0x3b, 0x39, 0xdd, 0xdd, 0xdd, 0xdd, 0x62, 0x91,
    0x0, 0xa, 0x92, 0x22, 0x22, 0x2d, 0x70, 0x0,
    0x0, 0xa, 0x80, 0x0, 0x0, 0xc, 0x70, 0x0,
    0x0, 0xa, 0xed, 0xdd, 0xdd, 0xdf, 0x70, 0x0,
    0x0, 0x1, 0x5a, 0x22, 0x22, 0x96, 0x10, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x1, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xb, 0x50, 0x8, 0xb0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,

    /* U+767C "發" */
    0x0, 0x0, 0x0, 0x0, 0x80, 0x1, 0x40, 0x0,
    0x0, 0xcf, 0xff, 0xf4, 0xc6, 0x2d, 0x80, 0x0,
    0x0, 0x82, 0x7, 0xd0, 0x2e, 0xe5, 0x6, 0x90,
    0x0, 0x6e, 0x8e, 0x20, 0x4, 0xe5, 0x9d, 0x20,
    0x0, 0x1c, 0xd2, 0x0, 0x0, 0x3e, 0xf3, 0x0,
    0x28, 0xff, 0xdd, 0x80, 0xed, 0xdf, 0xdf, 0xb2,
    0x19, 0x22, 0x28, 0xa0, 0xf1, 0x1a, 0x61, 0x60,
    0x0, 0x23, 0x28, 0xa4, 0xd0, 0x9, 0x60, 0x0,
    0x0, 0xbd, 0xcd, 0x9d, 0x70, 0x6, 0xed, 0x90,
    0x0, 0xd2, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf2, 0x12, 0x19, 0xff, 0xff, 0xf9, 0x0,
    0x1, 0xdd, 0xde, 0x96, 0x82, 0x13, 0xf2, 0x0,
    0x0, 0x0, 0x9, 0x80, 0x7d, 0x8e, 0x50, 0x0,
    0x0, 0x0, 0xd, 0x50, 0x3b, 0xee, 0x60, 0x0,
    0x0, 0x7f, 0xfc, 0x2e, 0xc6, 0x2, 0xb9, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,

    /* U+7684 "的" */
    0x0, 0x17, 0x10, 0x0, 0x53, 0x0, 0x0, 0x0,
    0x5e, 0x0, 0x0, 0xc5, 0x0, 0x0, 0x0, 0x99,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x9f, 0xff, 0xff,
    0x16, 0xff, 0xff, 0xfb, 0x98, 0x11, 0x1f, 0x1c,
    0x71, 0x11, 0x8a, 0x98, 0x0, 0xf, 0x5e, 0x0,
    0x0, 0x89, 0x98, 0x0, 0xf, 0xa7, 0x0, 0x0,
    0x89, 0x99, 0x33, 0x3f, 0x12, 0xe2, 0x0, 0x98,
    0x9e, 0xdd, 0xdf, 0x10, 0x8d, 0x0, 0xa7, 0x98,
    0x0, 0xf, 0x10, 0xd, 0x80, 0xb7, 0x98, 0x0,
    0xf, 0x10, 0x4, 0xe0, 0xc6, 0x98, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xe4, 0x9a, 0x44, 0x4f, 0x10,
    0x0, 0x0, 0xf2, 0x9e, 0xdd, 0xdd, 0x10, 0x1,
    0x16, 0xe0, 0x98, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+78BA "確" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x62, 0x0, 0x0,
    0x17, 0x77, 0x77, 0x0, 0x0, 0xf3, 0x0, 0x0,
    0x1a, 0xbf, 0xaa, 0x9f, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x6b, 0x0, 0x88, 0x2e, 0x64, 0x13, 0xf0,
    0x0, 0x98, 0x0, 0x76, 0x8d, 0x3f, 0x11, 0xb0,
    0x0, 0xd4, 0x0, 0x4, 0xfb, 0x8e, 0xb8, 0x60,
    0x2, 0xfd, 0xdb, 0x4f, 0xe7, 0x7f, 0x97, 0x50,
    0x7, 0xf3, 0x6e, 0xec, 0xc0, 0xe, 0x30, 0x0,
    0xe, 0xf0, 0x3d, 0x16, 0xfe, 0xef, 0xfe, 0x70,
    0x6d, 0xf0, 0x3d, 0x6, 0xc0, 0xe, 0x30, 0x0,
    0x3, 0xf0, 0x3d, 0x6, 0xc0, 0xe, 0x30, 0x0,
    0x0, 0xf0, 0x3d, 0x6, 0xff, 0xff, 0xff, 0x80,
    0x0, 0xfd, 0xdd, 0x6, 0xc0, 0xe, 0x30, 0x0,
    0x0, 0xf2, 0x11, 0x6, 0xe8, 0x8f, 0xa8, 0x81,
    0x0, 0x70, 0x0, 0x6, 0xe7, 0x77, 0x77, 0x71,

    /* U+79D2 "秒" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x48, 0xcf, 0x20, 0x1, 0xf1, 0x0, 0x0,
    0x2e, 0xbf, 0x81, 0x0, 0x1, 0xf1, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x4, 0x71, 0xf1, 0x87, 0x0,
    0x0, 0xd, 0x50, 0x8, 0x91, 0xf1, 0x4e, 0x0,
    0x8f, 0xff, 0xff, 0x8b, 0x61, 0xf1, 0xd, 0x60,
    0x12, 0x4f, 0x82, 0x1f, 0x31, 0xf1, 0x7, 0xc0,
    0x0, 0x8f, 0xe1, 0x4e, 0x1, 0xf1, 0x2, 0xb0,
    0x0, 0xee, 0xbc, 0x37, 0x1, 0xf1, 0x3, 0x0,
    0x7, 0x9d, 0x5d, 0x40, 0x1, 0xf1, 0x3f, 0x10,
    0x2f, 0x2d, 0x52, 0x0, 0x1, 0xe1, 0xc8, 0x0,
    0x99, 0xd, 0x50, 0x0, 0x0, 0xb, 0xc0, 0x0,
    0x10, 0xd, 0x50, 0x0, 0x4, 0xdb, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x26, 0xce, 0x60, 0x0, 0x0,
    0x0, 0xd, 0x52, 0xda, 0x50, 0x0, 0x0, 0x0,

    /* U+7A0D "稍" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x7b, 0xf8, 0x28, 0x0, 0xd4, 0x2, 0xc0,
    0xb, 0x8f, 0x30, 0xd, 0x60, 0xd4, 0xb, 0xa0,
    0x0, 0xe, 0x20, 0x4, 0xe0, 0xd4, 0x5e, 0x10,
    0x0, 0xe, 0x20, 0x0, 0x30, 0xd4, 0x2, 0x0,
    0x5f, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff, 0xa0,
    0x2, 0x6f, 0x52, 0x1f, 0x22, 0x22, 0x28, 0xb0,
    0x0, 0xaf, 0xc0, 0x1f, 0x0, 0x0, 0x7, 0xb0,
    0x0, 0xef, 0xaa, 0x1f, 0xff, 0xff, 0xff, 0xb0,
    0x7, 0x9e, 0x2a, 0x1f, 0x0, 0x0, 0x7, 0xb0,
    0xe, 0x2e, 0x20, 0x1f, 0x11, 0x11, 0x17, 0xb0,
    0x4b, 0xe, 0x20, 0x1f, 0xff, 0xff, 0xff, 0xb0,
    0x1, 0xe, 0x20, 0x1f, 0x0, 0x0, 0x7, 0xb0,
    0x0, 0xe, 0x20, 0x1f, 0x0, 0x1, 0x18, 0xa0,
    0x0, 0xe, 0x20, 0x1f, 0x0, 0xa, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7B49 "等" */
    0x0, 0x5, 0x0, 0x0, 0x4, 0x20, 0x0, 0x0,
    0x0, 0x7e, 0x11, 0x10, 0x2f, 0x41, 0x11, 0x10,
    0x2, 0xff, 0xff, 0xfe, 0xbf, 0xff, 0xff, 0xf3,
    0x1d, 0xa0, 0xe4, 0x9, 0xd1, 0x1e, 0x40, 0x0,
    0x17, 0x0, 0x42, 0x8, 0xb0, 0x4, 0x30, 0x0,
    0x0, 0x9e, 0xee, 0xef, 0xfe, 0xee, 0xeb, 0x0,
    0x0, 0x12, 0x22, 0x29, 0xb2, 0x22, 0x21, 0x0,
    0x14, 0x44, 0x44, 0x4a, 0xc4, 0x44, 0x44, 0x41,
    0x3d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0xdd, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x1, 0x13, 0xd6, 0x11, 0x11, 0x5f, 0x11, 0x10,
    0x0, 0x0, 0x6f, 0x60, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xe1, 0x11, 0x5f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7B54 "答" */
    0x0, 0x6, 0x10, 0x0, 0x4, 0x30, 0x0, 0x0,
    0x0, 0x3f, 0x10, 0x0, 0xd, 0x60, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xfe, 0x5f, 0xff, 0xff, 0xf1,
    0x6, 0xe2, 0xb9, 0x12, 0xe7, 0x2e, 0x71, 0x10,
    0x1e, 0x40, 0x3e, 0x4, 0x90, 0x5, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xe3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf5, 0x5e, 0x91, 0x0, 0x0,
    0x0, 0x3, 0xcd, 0x41, 0x12, 0xbf, 0x82, 0x0,
    0x5, 0xce, 0x9f, 0xff, 0xff, 0xf8, 0xaf, 0xb2,
    0x8, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2, 0x60,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0,
    0x0, 0x9, 0x91, 0x11, 0x11, 0x18, 0xb0, 0x0,
    0x0, 0x9, 0x90, 0x0, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0x9, 0xa3, 0x33, 0x33, 0x39, 0xb0, 0x0,
    0x0, 0x9, 0xfd, 0xdd, 0xdd, 0xde, 0xb0, 0x0,

    /* U+7CFB "系" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x12, 0x34, 0x67, 0x9b, 0xdf, 0xf7, 0x0, 0xe,
    0xed, 0xce, 0xf9, 0x64, 0x20, 0x0, 0x0, 0x0,
    0x5, 0xe4, 0x0, 0x17, 0x0, 0x0, 0x0, 0x8,
    0xd2, 0x0, 0x4e, 0xa0, 0x0, 0x0, 0x1d, 0xfc,
    0xcd, 0xef, 0x60, 0x0, 0x0, 0x0, 0x75, 0x37,
    0xfb, 0x10, 0x92, 0x0, 0x0, 0x0, 0x3b, 0xd4,
    0x0, 0x6, 0xe2, 0x0, 0x4, 0xbf, 0xd8, 0x9a,
    0xbc, 0xdf, 0xd1, 0x0, 0xdc, 0xa9, 0x89, 0xf4,
    0x32, 0xa, 0xb0, 0x0, 0x5, 0x50, 0x4e, 0x3,
    0x80, 0x3, 0x0, 0x4, 0xf5, 0x4, 0xe0, 0x1c,
    0xc1, 0x0, 0x6, 0xf6, 0x0, 0x4e, 0x0, 0xa,
    0xe2, 0x5, 0xf5, 0x1, 0x26, 0xe0, 0x0, 0x9,
    0xd0, 0x1, 0x0, 0x6f, 0xf9, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7D1A "級" */
    0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x40, 0x4f, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x7c, 0x0, 0x28, 0xeb, 0x88, 0xf6, 0x0,
    0x2, 0xe2, 0x1d, 0x10, 0xc5, 0x3, 0xf1, 0x0,
    0xc, 0x70, 0x9b, 0x0, 0xd4, 0x7, 0xc0, 0x0,
    0x4f, 0xcd, 0xf1, 0x0, 0xe4, 0xb, 0x81, 0x10,
    0x6, 0x5f, 0x63, 0x0, 0xf6, 0xf, 0xff, 0xf1,
    0x0, 0xb9, 0x1e, 0x0, 0xfc, 0x0, 0x5, 0xd0,
    0xa, 0xe6, 0x8e, 0x52, 0xfe, 0x30, 0xb, 0x70,
    0x3f, 0xc9, 0x79, 0xa5, 0xd7, 0xc0, 0x2f, 0x10,
    0x1, 0x1, 0x17, 0x8, 0xa0, 0xd6, 0xc8, 0x0,
    0xc, 0x4c, 0x3d, 0x1c, 0x60, 0x4f, 0xe0, 0x0,
    0xe, 0x29, 0x69, 0x7f, 0x10, 0x7f, 0xe2, 0x0,
    0x1f, 0x8, 0x81, 0x8b, 0x1a, 0xe3, 0x9e, 0x50,
    0x39, 0x3, 0x20, 0xe5, 0xeb, 0x20, 0x6, 0xf3,
    0x0, 0x0, 0x0, 0x10, 0x10, 0x0, 0x0, 0x0,

    /* U+7D42 "終" */
    0x0, 0x5, 0x30, 0x0, 0x6, 0x30, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x0, 0x2f, 0x20, 0x0, 0x0,
    0x0, 0x6c, 0x0, 0x0, 0xbf, 0xff, 0xff, 0x20,
    0x1, 0xe3, 0x4d, 0x6, 0xf6, 0x22, 0x8d, 0x0,
    0x9, 0x90, 0xd7, 0x5f, 0x8d, 0x12, 0xe4, 0x0,
    0x4f, 0xef, 0xd0, 0x54, 0x9, 0xcd, 0x80, 0x0,
    0x13, 0x4f, 0x63, 0x0, 0x3, 0xfe, 0x10, 0x0,
    0x1, 0xd6, 0x5a, 0x0, 0x7f, 0x8b, 0xe4, 0x0,
    0x1c, 0xd8, 0xbf, 0x4d, 0xd4, 0x0, 0x7f, 0xb2,
    0x1d, 0xa7, 0x4d, 0x46, 0x9, 0xd5, 0x2, 0x80,
    0x2, 0x4, 0x27, 0x0, 0x0, 0x4d, 0xb0, 0x0,
    0xc, 0x3d, 0x2e, 0x0, 0x10, 0x0, 0x30, 0x0,
    0xe, 0xb, 0x3a, 0x45, 0xfc, 0x61, 0x0, 0x0,
    0x2d, 0x9, 0x53, 0x10, 0x5, 0xbf, 0x92, 0x0,
    0x26, 0x2, 0x0, 0x0, 0x0, 0x2, 0x9e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7D44 "組" */
    0x0, 0x5, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x60, 0x2, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x6d, 0x1, 0x2, 0xf1, 0x11, 0x1e, 0x40,
    0x1, 0xe4, 0xe, 0x32, 0xf0, 0x0, 0xe, 0x40,
    0xa, 0x90, 0x8c, 0x2, 0xf0, 0x0, 0xe, 0x40,
    0x3f, 0xab, 0xf2, 0x2, 0xf5, 0x55, 0x5e, 0x40,
    0xa, 0x8f, 0x61, 0x2, 0xfc, 0xcc, 0xcf, 0x40,
    0x0, 0xb9, 0xe, 0x22, 0xf0, 0x0, 0xe, 0x40,
    0xa, 0xb2, 0x4c, 0x82, 0xf0, 0x0, 0xe, 0x40,
    0x1f, 0xfe, 0xba, 0xd2, 0xf2, 0x22, 0x2e, 0x40,
    0x3, 0x0, 0x4, 0x52, 0xfe, 0xee, 0xef, 0x40,
    0x9, 0x48, 0x5a, 0x52, 0xf0, 0x0, 0xe, 0x40,
    0xd, 0x38, 0x86, 0xa2, 0xf0, 0x0, 0xe, 0x40,
    0xf, 0x6, 0xa1, 0x62, 0xf0, 0x0, 0xe, 0x40,
    0x3b, 0x2, 0x50, 0x9f, 0xff, 0xff, 0xff, 0xf5,

    /* U+7D61 "絡" */
    0x0, 0x4, 0x40, 0x0, 0x4, 0x70, 0x0, 0x0,
    0x0, 0xd, 0x60, 0x0, 0xc, 0x80, 0x0, 0x0,
    0x0, 0x6d, 0x0, 0x0, 0x6f, 0xff, 0xff, 0x70,
    0x0, 0xe4, 0x4e, 0x3, 0xfa, 0x11, 0x4f, 0x20,
    0xa, 0x90, 0xd7, 0x4f, 0x9e, 0x30, 0xc9, 0x0,
    0x4f, 0xff, 0xc0, 0x37, 0x6, 0xea, 0xd0, 0x0,
    0x2, 0x3f, 0x63, 0x0, 0x0, 0xdf, 0x40, 0x0,
    0x1, 0xd6, 0x5a, 0x0, 0x2c, 0xc9, 0xf6, 0x0,
    0x1c, 0xd9, 0xbf, 0x29, 0xf8, 0x0, 0x5e, 0xd3,
    0x1c, 0x96, 0x3c, 0x4c, 0xec, 0xcc, 0xcd, 0xc0,
    0x2, 0x3, 0x28, 0x4, 0xe4, 0x44, 0x4c, 0x70,
    0xc, 0x4c, 0x3e, 0x4, 0xd0, 0x0, 0xb, 0x70,
    0xe, 0x1a, 0x5b, 0x44, 0xd0, 0x0, 0xb, 0x70,
    0x1e, 0x8, 0x66, 0x54, 0xe3, 0x33, 0x3c, 0x70,
    0x39, 0x5, 0x40, 0x4, 0xfd, 0xdd, 0xdf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7D71 "統" */
    0x0, 0x3, 0x10, 0x0, 0x2, 0x30, 0x0, 0x0,
    0x0, 0xd, 0x70, 0x0, 0x5, 0xe0, 0x0, 0x0,
    0x0, 0x5e, 0x0, 0x25, 0x55, 0xf8, 0x55, 0x50,
    0x0, 0xd5, 0x2b, 0x5c, 0xce, 0xec, 0xcc, 0xc0,
    0x8, 0xb0, 0xaa, 0x0, 0x1f, 0x40, 0x81, 0x0,
    0x3f, 0xdd, 0xe1, 0x0, 0xb9, 0x0, 0x9a, 0x0,
    0x17, 0x6f, 0x52, 0x19, 0xf6, 0x78, 0xaf, 0x50,
    0x0, 0xb8, 0x3d, 0x3f, 0xdb, 0x97, 0x67, 0xe0,
    0x9, 0xd4, 0x6f, 0x20, 0x54, 0x6, 0x30, 0x30,
    0x2f, 0xeb, 0x9c, 0x70, 0xb7, 0xc, 0x50, 0x0,
    0x2, 0x0, 0x25, 0x10, 0xc5, 0xc, 0x50, 0x0,
    0xb, 0x3e, 0x3a, 0x0, 0xf3, 0xc, 0x50, 0x10,
    0xe, 0x1d, 0x1e, 0x5, 0xe0, 0xc, 0x50, 0xa4,
    0x1e, 0xb, 0x35, 0x2e, 0x70, 0xc, 0x60, 0xc3,
    0x4a, 0x5, 0x23, 0xf9, 0x0, 0x8, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+7D9A "続" */
    0x0, 0xc, 0x10, 0x0, 0x0, 0xd4, 0x0, 0x0,
    0x0, 0x4c, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xc5, 0x57, 0x0, 0x0, 0xd5, 0x0, 0x0,
    0x5, 0xc0, 0xd4, 0x9, 0x99, 0xfb, 0x99, 0x40,
    0x2e, 0xee, 0xb0, 0x6, 0x66, 0x66, 0x66, 0x20,
    0x39, 0x8f, 0x10, 0x3, 0x33, 0x33, 0x33, 0x30,
    0x0, 0xc5, 0x94, 0x1f, 0xbb, 0xbb, 0xbb, 0xf1,
    0x9, 0xa4, 0xa9, 0x1e, 0x5, 0x3, 0x40, 0xf1,
    0x4f, 0xfb, 0x7d, 0x19, 0x2c, 0x8, 0xa0, 0x91,
    0x2, 0x0, 0x14, 0x0, 0x3c, 0x8, 0xa0, 0x0,
    0x8, 0x6c, 0x4a, 0x0, 0x79, 0x8, 0xa0, 0x0,
    0xb, 0x4b, 0x2d, 0x1, 0xe4, 0x8, 0xa0, 0x72,
    0xf, 0x19, 0x46, 0x2c, 0xc0, 0x8, 0xa0, 0xb4,
    0x2a, 0x2, 0x10, 0xcd, 0x10, 0x5, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+7DB2 "網" */
    0x0, 0x6, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x40, 0x2f, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x7b, 0x0, 0x2e, 0x14, 0x11, 0x41, 0xf1,
    0x1, 0xe2, 0x4d, 0x2e, 0xd, 0x1, 0xd0, 0xf1,
    0xb, 0x70, 0xd6, 0x2e, 0xa, 0x35, 0x80, 0xf1,
    0x4f, 0xac, 0xc0, 0x2e, 0x27, 0x6b, 0x62, 0xf1,
    0x19, 0x9f, 0x20, 0x2e, 0x8b, 0xfb, 0xb5, 0xf1,
    0x0, 0xc6, 0x4a, 0x2e, 0x0, 0xa5, 0x0, 0xf1,
    0xa, 0xd8, 0xaf, 0x3e, 0x8f, 0xff, 0xf4, 0xf1,
    0x2e, 0xa7, 0x5c, 0x7e, 0xf, 0x0, 0x0, 0xf1,
    0x3, 0x14, 0x45, 0x2e, 0xf, 0x0, 0x0, 0xf1,
    0xc, 0x3e, 0x3b, 0x2e, 0xf, 0xff, 0xf4, 0xf1,
    0xe, 0xd, 0x1e, 0x3e, 0x0, 0x0, 0x0, 0xf1,
    0x2d, 0xb, 0x34, 0x3e, 0x0, 0x0, 0x0, 0xf1,
    0x26, 0x2, 0x0, 0x2e, 0x0, 0x0, 0xbf, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7EA7 "级" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x9f, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x6d, 0x0, 0x6b, 0xfd, 0xbc, 0xf1, 0x0,
    0x0, 0xe4, 0x0, 0x0, 0xd5, 0x5, 0xd0, 0x0,
    0x8, 0xa0, 0x1d, 0x10, 0xe4, 0xa, 0x90, 0x0,
    0x4e, 0x33, 0xaa, 0x0, 0xf3, 0xe, 0x50, 0x0,
    0x3f, 0xee, 0xe1, 0x1, 0xf5, 0x2f, 0xff, 0xa0,
    0x1, 0x1e, 0x50, 0x3, 0xfb, 0x0, 0xb, 0x70,
    0x0, 0xb9, 0x26, 0x5, 0xef, 0x20, 0x1f, 0x20,
    0x9, 0xfe, 0xe9, 0x8, 0xa9, 0xa0, 0x8c, 0x0,
    0x3e, 0x83, 0x0, 0xc, 0x71, 0xf6, 0xf4, 0x0,
    0x0, 0x0, 0x49, 0x4f, 0x20, 0x6f, 0xa0, 0x0,
    0x2, 0x8e, 0xe8, 0x8d, 0x0, 0xbf, 0xd1, 0x0,
    0x3f, 0xb5, 0x0, 0xe6, 0x2c, 0xd2, 0xbe, 0x40,
    0x1, 0x0, 0x7, 0xd3, 0xfa, 0x0, 0x8, 0xf2,
    0x0, 0x0, 0x0, 0x10, 0x20, 0x0, 0x0, 0x10,

    /* U+7EC4 "组" */
    0x0, 0x2, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xb0, 0x4, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x1f, 0x30, 0x4, 0xd1, 0x11, 0x2f, 0x20,
    0x0, 0x9a, 0x1, 0x4, 0xd0, 0x0, 0xf, 0x20,
    0x3, 0xe1, 0xc, 0x64, 0xd0, 0x0, 0xf, 0x20,
    0x1d, 0xa6, 0xac, 0x4, 0xfc, 0xcc, 0xcf, 0x20,
    0x1f, 0xcc, 0xf2, 0x4, 0xe5, 0x55, 0x5f, 0x20,
    0x0, 0x1d, 0x50, 0x4, 0xd0, 0x0, 0xf, 0x20,
    0x0, 0xb8, 0x0, 0x4, 0xd0, 0x0, 0xf, 0x20,
    0xb, 0xd7, 0xad, 0x64, 0xe2, 0x22, 0x3f, 0x20,
    0xf, 0xea, 0x63, 0x4, 0xfe, 0xee, 0xef, 0x20,
    0x1, 0x0, 0x0, 0x4, 0xd0, 0x0, 0xf, 0x20,
    0x0, 0x15, 0x8c, 0x54, 0xd0, 0x0, 0xf, 0x20,
    0x1e, 0xfc, 0x84, 0x4, 0xd0, 0x0, 0xf, 0x20,
    0x4, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xf9,

    /* U+7EDC "络" */
    0x0, 0x2, 0x10, 0x0, 0x8, 0x10, 0x0, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x6d, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x30, 0x1, 0xef, 0xff, 0xff, 0x80,
    0x0, 0xaa, 0x0, 0xb, 0xf3, 0x22, 0x4f, 0x30,
    0x3, 0xf1, 0x2d, 0xae, 0xba, 0x0, 0xc8, 0x0,
    0xd, 0xa5, 0xca, 0x72, 0xd, 0x9c, 0xa0, 0x0,
    0x4e, 0xcd, 0xe1, 0x0, 0x7, 0xff, 0x20, 0x0,
    0x0, 0x2e, 0x40, 0x16, 0xdd, 0x48, 0xfa, 0x40,
    0x0, 0xc9, 0x35, 0xcd, 0x60, 0x0, 0x18, 0xe2,
    0x1b, 0xff, 0xd8, 0x8, 0xff, 0xff, 0xff, 0x40,
    0x1b, 0x51, 0x0, 0x8, 0xa2, 0x22, 0x2e, 0x40,
    0x0, 0x0, 0x15, 0x8, 0x90, 0x0, 0xe, 0x40,
    0x3, 0x8c, 0xfc, 0x18, 0x90, 0x0, 0xe, 0x40,
    0x3f, 0xb6, 0x10, 0x8, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x8, 0xa2, 0x22, 0x2e, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7EDF "统" */
    0x0, 0x2, 0x20, 0x0, 0x1, 0x40, 0x0, 0x0,
    0x0, 0xa, 0xb0, 0x0, 0x2, 0xf2, 0x0, 0x0,
    0x0, 0x2f, 0x40, 0x12, 0x22, 0xc7, 0x22, 0x20,
    0x0, 0xab, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xf1,
    0x3, 0xf2, 0x2d, 0x0, 0x1e, 0x60, 0x20, 0x0,
    0x1d, 0x94, 0xca, 0x0, 0xbb, 0x0, 0xd6, 0x0,
    0x4f, 0xef, 0xe1, 0x8, 0xd1, 0x12, 0x7f, 0x10,
    0x1, 0x2f, 0x50, 0x9f, 0xff, 0xfd, 0xcd, 0xa0,
    0x0, 0xc9, 0x0, 0x34, 0xa3, 0x7, 0x31, 0x90,
    0xb, 0xfb, 0xec, 0x0, 0xe4, 0xd, 0x50, 0x0,
    0x2e, 0xa6, 0x30, 0x0, 0xf3, 0xd, 0x50, 0x0,
    0x0, 0x0, 0x2, 0x3, 0xf0, 0xd, 0x50, 0x0,
    0x0, 0x59, 0xed, 0xa, 0xb0, 0xd, 0x50, 0xb2,
    0x3f, 0xd8, 0x30, 0x8f, 0x30, 0xd, 0x60, 0xd2,
    0x3, 0x0, 0xa, 0xe4, 0x0, 0x9, 0xff, 0xc0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7F51 "网" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x16,
    0xd2, 0x22, 0x22, 0x22, 0x22, 0x24, 0xf1, 0x6d,
    0x0, 0x3, 0x80, 0x0, 0x74, 0x2f, 0x16, 0xd3,
    0x40, 0x7a, 0x51, 0xd, 0x42, 0xf1, 0x6d, 0x4e,
    0x2b, 0x78, 0xc0, 0xf1, 0x2f, 0x16, 0xd0, 0x7c,
    0xe3, 0xc, 0xbd, 0x2, 0xf1, 0x6d, 0x0, 0xce,
    0x0, 0x2f, 0x90, 0x2f, 0x16, 0xd0, 0x9, 0xf4,
    0x0, 0xed, 0x2, 0xf1, 0x6d, 0x1, 0xf8, 0xe0,
    0x5d, 0xc7, 0x2f, 0x16, 0xd0, 0x9b, 0xb, 0x3d,
    0x63, 0xf2, 0xf1, 0x6d, 0x4f, 0x20, 0x9, 0xc0,
    0x5, 0x2f, 0x16, 0xda, 0x50, 0x2, 0xd2, 0x0,
    0x2, 0xf1, 0x6d, 0x0, 0x0, 0x0, 0x0, 0x22,
    0x5f, 0x16, 0xd0, 0x0, 0x0, 0x0, 0xb, 0xfe,
    0xa0,

    /* U+8046 "聆" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x45, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xf2, 0x0, 0xc8, 0x0, 0x0,
    0x2b, 0xe8, 0x8f, 0x91, 0x5, 0xee, 0x10, 0x0,
    0x5, 0xb0, 0xf, 0x10, 0xd, 0x58, 0xa0, 0x0,
    0x5, 0xc2, 0x2f, 0x10, 0x9b, 0x0, 0xd7, 0x0,
    0x5, 0xfd, 0xdf, 0x17, 0xe3, 0x70, 0x2e, 0x60,
    0x5, 0xb0, 0xf, 0x4e, 0x20, 0xaa, 0x3, 0xe2,
    0x5, 0xc1, 0x1f, 0x11, 0x0, 0x6, 0x0, 0x0,
    0x5, 0xff, 0xff, 0x11, 0xff, 0xff, 0xff, 0x10,
    0x5, 0xb0, 0xf, 0x10, 0x11, 0x11, 0x9b, 0x0,
    0x5, 0xb0, 0xf, 0x20, 0x0, 0x2, 0xf2, 0x0,
    0x18, 0xd9, 0xbf, 0xf0, 0x46, 0xd, 0x70, 0x0,
    0x3c, 0xa7, 0x5f, 0x10, 0x1b, 0xec, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x10, 0x0, 0x8d, 0x20, 0x0,
    0x0, 0x0, 0xf, 0x10, 0x0, 0x6, 0xa0, 0x0,

    /* U+807D "聽" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x45, 0x0, 0x0,
    0x2c, 0xfa, 0xaf, 0xb1, 0x0, 0x88, 0x0, 0x0,
    0x4, 0xc0, 0xe, 0x3e, 0xff, 0xff, 0xff, 0xf0,
    0x4, 0xe9, 0x9f, 0x30, 0x0, 0xd3, 0x0, 0x0,
    0x4, 0xd4, 0x4e, 0x39, 0xee, 0xff, 0xee, 0xa0,
    0x4, 0xe9, 0x9f, 0x39, 0x56, 0x55, 0x73, 0xb0,
    0x4, 0xd4, 0x4e, 0x39, 0x56, 0x55, 0x73, 0xb0,
    0x18, 0xe7, 0x8f, 0x39, 0xee, 0xee, 0xee, 0xa0,
    0x2b, 0xa8, 0x7f, 0x31, 0x11, 0x11, 0x11, 0x10,
    0xa, 0xaa, 0x6e, 0x5f, 0xff, 0xff, 0xff, 0xf4,
    0x4, 0xb8, 0x3e, 0x30, 0x1, 0xa0, 0x0, 0x0,
    0xb, 0xfe, 0x6e, 0x37, 0x7a, 0x7c, 0xc, 0x30,
    0x0, 0x95, 0xe, 0x3d, 0x4d, 0x7, 0x26, 0xd0,
    0x29, 0xee, 0xbe, 0x9b, 0x3d, 0x0, 0x5a, 0xb5,
    0x16, 0x31, 0xe, 0x52, 0x1d, 0xff, 0xf5, 0x10,

    /* U+80FD "能" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x0, 0x3f, 0x0, 0x0, 0x0,
    0x0, 0x7d, 0xb, 0x70, 0x3f, 0x0, 0x6c, 0x20,
    0x2, 0xf3, 0x3, 0xf2, 0x3f, 0xae, 0xa5, 0x0,
    0xd, 0xff, 0xfe, 0xeb, 0x3f, 0x40, 0x0, 0x0,
    0x3, 0x20, 0x0, 0x16, 0x3f, 0x0, 0x0, 0xc2,
    0x3, 0x88, 0x88, 0x82, 0x2f, 0x54, 0x45, 0xf1,
    0x6, 0xd8, 0x88, 0xf5, 0x9, 0xcc, 0xcc, 0x80,
    0x6, 0xc2, 0x22, 0xe5, 0x2c, 0x0, 0x0, 0x0,
    0x6, 0xfd, 0xdd, 0xf5, 0x3f, 0x0, 0x3a, 0x40,
    0x6, 0xb0, 0x0, 0xe5, 0x3f, 0x7c, 0xd8, 0x10,
    0x6, 0xff, 0xff, 0xf5, 0x3f, 0x72, 0x0, 0x0,
    0x6, 0xb0, 0x0, 0xe5, 0x3f, 0x0, 0x0, 0x94,
    0x6, 0xb0, 0x0, 0xe4, 0x2f, 0x21, 0x11, 0xd4,
    0x6, 0xb0, 0x8f, 0xe2, 0xc, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+884C "行" */
    0x0, 0x2, 0xc2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xa0, 0xf, 0xff, 0xff, 0xff, 0xd0,
    0x2, 0xdb, 0x0, 0x2, 0x22, 0x22, 0x22, 0x20,
    0x2e, 0xb0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x0, 0x9c, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf2, 0x12, 0x22, 0x22, 0x22, 0x20,
    0x0, 0x3f, 0x60, 0xcf, 0xff, 0xff, 0xff, 0xf4,
    0x3, 0xff, 0x40, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x4f, 0x9e, 0x40, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x16, 0xe, 0x40, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x2, 0x27, 0xd0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0xf, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+898B "見" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0xf, 0x21, 0x11, 0x11, 0x12, 0xf1, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x2, 0xf1, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x2, 0xf1, 0x0,
    0x0, 0xf, 0x54, 0x44, 0x44, 0x45, 0xf1, 0x0,
    0x0, 0xf, 0xcb, 0xbb, 0xbb, 0xbc, 0xf1, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x2, 0xf1, 0x0,
    0x0, 0xf, 0xba, 0xaa, 0xaa, 0xab, 0xf1, 0x0,
    0x0, 0x6, 0x6f, 0xa6, 0x6f, 0x86, 0x60, 0x0,
    0x0, 0x0, 0x3f, 0x20, 0xf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xcb, 0x0, 0xf, 0x30, 0x0, 0xc4,
    0x1, 0x6e, 0xd1, 0x0, 0xf, 0x62, 0x22, 0xf3,
    0x1f, 0xd7, 0x0, 0x0, 0xa, 0xff, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+89BD "覽" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x40, 0x0, 0x0,
    0x9, 0xb7, 0x9d, 0x77, 0xc, 0xef, 0xee, 0xe2,
    0x9, 0xa5, 0x7d, 0x53, 0x7d, 0x1e, 0x50, 0x0,
    0x9, 0xb6, 0x66, 0xa9, 0xb2, 0x3, 0xe1, 0x0,
    0x9, 0xdb, 0xbb, 0xd9, 0x3e, 0xdb, 0xeb, 0xc0,
    0x9, 0x81, 0x4c, 0x10, 0x3b, 0x73, 0xb1, 0xc0,
    0x6, 0xbb, 0xbb, 0xbb, 0x3a, 0xaa, 0xa9, 0x80,
    0x0, 0x9, 0xbb, 0xbb, 0xbb, 0xbb, 0xa0, 0x0,
    0x0, 0xd, 0x83, 0x33, 0x33, 0x36, 0xe0, 0x0,
    0x0, 0xd, 0xb8, 0x88, 0x88, 0x8a, 0xe0, 0x0,
    0x0, 0xd, 0xdb, 0xbb, 0xbb, 0xbc, 0xe0, 0x0,
    0x0, 0xd, 0x82, 0x22, 0x22, 0x25, 0xe0, 0x0,
    0x0, 0x7, 0x9d, 0xe9, 0x9f, 0xb9, 0x80, 0x20,
    0x0, 0x1, 0x7e, 0x40, 0xd, 0x50, 0x0, 0xc4,
    0x1c, 0xee, 0x92, 0x0, 0x8, 0xff, 0xff, 0xd0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+89C8 "览" */
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x2f,
    0x0, 0xe4, 0x0, 0xf4, 0x0, 0x0, 0x2f, 0x0,
    0xe4, 0x6, 0xff, 0xff, 0xfe, 0x2f, 0x0, 0xe4,
    0xd, 0x75, 0x82, 0x21, 0x2f, 0x0, 0xe4, 0x9c,
    0x3, 0xf7, 0x0, 0x18, 0x0, 0xe4, 0x31, 0x0,
    0x6f, 0x40, 0x0, 0x0, 0xc3, 0x0, 0x0, 0x8,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0xd4, 0x0, 0x31, 0x0, 0x2f, 0x10, 0x0,
    0xd4, 0x0, 0xe5, 0x0, 0x2f, 0x10, 0x0, 0xd4,
    0x0, 0xf4, 0x0, 0x2f, 0x10, 0x0, 0xd4, 0x5,
    0xfc, 0x70, 0x2f, 0x10, 0x0, 0x0, 0x5f, 0x7c,
    0x80, 0x0, 0x6, 0x1, 0x6c, 0xe5, 0xc, 0x90,
    0x0, 0x4e, 0x8f, 0xc6, 0x0, 0x7, 0xff, 0xff,
    0xf7, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8A0A "訊" */
    0x0, 0x2b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x1f, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x5, 0x40, 0x4, 0x6f, 0x44, 0x5f, 0x10,
    0x1f, 0xff, 0xff, 0xa0, 0x2f, 0x0, 0x1f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x0, 0x1f, 0x10,
    0x5, 0xdd, 0xdd, 0x10, 0x2f, 0x0, 0x1f, 0x10,
    0x0, 0x22, 0x22, 0x0, 0x2f, 0x0, 0x1f, 0x10,
    0x4, 0xbb, 0xbb, 0x5d, 0xef, 0xdd, 0x2f, 0x10,
    0x1, 0x33, 0x33, 0x14, 0x6f, 0x44, 0x1f, 0x10,
    0x1, 0x32, 0x22, 0x0, 0x2f, 0x0, 0xf, 0x20,
    0x7, 0xed, 0xdf, 0x20, 0x2f, 0x0, 0xf, 0x20,
    0x7, 0x80, 0xd, 0x20, 0x2f, 0x0, 0xd, 0x40,
    0x7, 0x80, 0xd, 0x20, 0x2f, 0x0, 0xb, 0x6a,
    0x7, 0xfe, 0xef, 0x20, 0x2f, 0x0, 0x8, 0xcb,
    0x7, 0x81, 0x11, 0x0, 0x2f, 0x0, 0x2, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8A2A "訪" */
    0x0, 0x13, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,
    0x0, 0x2e, 0x10, 0x0, 0x0, 0x98, 0x0, 0x0,
    0x0, 0x9, 0x50, 0x0, 0x0, 0x4d, 0x0, 0x0,
    0xb, 0xbb, 0xbb, 0x7a, 0xaa, 0xbf, 0xaa, 0xa4,
    0x4, 0x44, 0x44, 0x27, 0x7e, 0xa7, 0x77, 0x73,
    0x4, 0xaa, 0xaa, 0x0, 0xc, 0x50, 0x0, 0x0,
    0x1, 0x33, 0x33, 0x0, 0xd, 0x74, 0x44, 0x20,
    0x5, 0xbb, 0xbb, 0x0, 0xe, 0xdd, 0xde, 0xa0,
    0x1, 0x33, 0x33, 0x0, 0xf, 0x10, 0x8, 0x90,
    0x1, 0x32, 0x22, 0x0, 0x3e, 0x0, 0x9, 0x80,
    0x7, 0xed, 0xdf, 0x0, 0x7a, 0x0, 0xa, 0x70,
    0x7, 0x80, 0xf, 0x0, 0xd5, 0x0, 0xb, 0x60,
    0x7, 0x80, 0xf, 0x5, 0xe0, 0x0, 0xd, 0x40,
    0x7, 0xfe, 0xef, 0x3f, 0x50, 0x12, 0x3f, 0x20,
    0x7, 0x81, 0x11, 0xb7, 0x0, 0x6f, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8A2D "設" */
    0x0, 0x16, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x30, 0x0, 0xef, 0xff, 0xf3, 0x0,
    0x0, 0x7, 0x60, 0x0, 0xe4, 0x11, 0xf3, 0x0,
    0x2e, 0xee, 0xee, 0xd0, 0xf2, 0x0, 0xe3, 0x0,
    0x1, 0x11, 0x11, 0x14, 0xf0, 0x0, 0xe3, 0x0,
    0x6, 0xdd, 0xdd, 0x4d, 0x90, 0x0, 0xcd, 0xc1,
    0x1, 0x22, 0x22, 0x7d, 0x10, 0x0, 0x14, 0x40,
    0x2, 0x55, 0x55, 0x23, 0x22, 0x22, 0x23, 0x0,
    0x5, 0xaa, 0xaa, 0x7f, 0xff, 0xff, 0xff, 0x50,
    0x1, 0x32, 0x22, 0x6, 0xb0, 0x0, 0x4e, 0x0,
    0x8, 0xfd, 0xdf, 0x30, 0xe6, 0x1, 0xe6, 0x0,
    0x8, 0x80, 0xe, 0x30, 0x3f, 0x7d, 0xb0, 0x0,
    0x8, 0x80, 0xe, 0x30, 0x9, 0xff, 0x20, 0x0,
    0x8, 0xfe, 0xef, 0x57, 0xdf, 0x8d, 0xf9, 0x40,
    0x8, 0x91, 0x11, 0x9e, 0x81, 0x0, 0x6c, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+8A66 "試" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7a, 0x0, 0x0, 0x0, 0xe, 0x67, 0x0,
    0x0, 0x1e, 0x30, 0x0, 0x0, 0xe, 0x4c, 0x60,
    0x28, 0x8a, 0x88, 0x12, 0x22, 0x2e, 0x64, 0x60,
    0x16, 0x66, 0x66, 0x8f, 0xff, 0xff, 0xff, 0xf3,
    0x5, 0x99, 0x96, 0x0, 0x0, 0xc, 0x50, 0x0,
    0x2, 0x44, 0x43, 0x1, 0x11, 0xc, 0x60, 0x0,
    0x6, 0xbb, 0xb8, 0xbf, 0xff, 0xca, 0x70, 0x0,
    0x2, 0x33, 0x32, 0x0, 0xf1, 0x9, 0x80, 0x0,
    0x1, 0x32, 0x21, 0x0, 0xf1, 0x7, 0xa0, 0x0,
    0x9, 0xed, 0xec, 0x0, 0xf1, 0x5, 0xc0, 0x0,
    0x9, 0x70, 0x5c, 0x0, 0xf1, 0x24, 0xf0, 0x20,
    0x9, 0x70, 0x5c, 0x58, 0xfe, 0xb3, 0xe3, 0xa4,
    0x9, 0xfe, 0xfc, 0x87, 0x30, 0x0, 0x9a, 0xc2,
    0x9, 0x81, 0x10, 0x0, 0x0, 0x0, 0x1e, 0xb0,

    /* U+8A71 "話" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x0, 0xe, 0x50, 0x0, 0x14, 0x7a, 0xee, 0x40,
    0x0, 0x5, 0x80, 0x6, 0xca, 0x9f, 0x20, 0x0,
    0x1f, 0xff, 0xff, 0xb0, 0x0, 0x2e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x0, 0x0,
    0x6, 0xdd, 0xdd, 0x28, 0xbb, 0xcf, 0xbb, 0xb7,
    0x0, 0x22, 0x22, 0x4, 0x66, 0x8f, 0x66, 0x64,
    0x5, 0xbb, 0xbb, 0x20, 0x0, 0x2e, 0x0, 0x0,
    0x1, 0x33, 0x33, 0x0, 0x0, 0x2e, 0x0, 0x0,
    0x1, 0x32, 0x22, 0x1, 0x99, 0xaf, 0x99, 0x50,
    0x7, 0xfd, 0xdf, 0x53, 0xf6, 0x66, 0x6c, 0x80,
    0x7, 0x90, 0xb, 0x53, 0xe0, 0x0, 0x9, 0x80,
    0x7, 0x90, 0xb, 0x53, 0xe0, 0x0, 0x9, 0x80,
    0x7, 0xc7, 0x7d, 0x53, 0xf4, 0x44, 0x4b, 0x80,
    0x7, 0xc8, 0x88, 0x23, 0xfd, 0xdd, 0xdf, 0x80,

    /* U+8A8D "認" */
    0x0, 0x37, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0x50, 0x4, 0x99, 0xbe, 0x9a, 0xe0,
    0x0, 0x5, 0x30, 0x0, 0x71, 0x6a, 0x1, 0xd0,
    0x1f, 0xff, 0xff, 0x92, 0xe0, 0xa7, 0x2, 0xc0,
    0x0, 0x0, 0x0, 0xa, 0x70, 0xf2, 0x3, 0xb0,
    0x6, 0xdd, 0xdd, 0x16, 0x8, 0xb0, 0x5, 0xa0,
    0x1, 0x22, 0x22, 0x0, 0x6f, 0x23, 0x7c, 0x70,
    0x5, 0xbb, 0xbb, 0x18, 0xe3, 0x2, 0x87, 0x0,
    0x1, 0x33, 0x33, 0x1, 0x0, 0xb1, 0x0, 0x0,
    0x1, 0x32, 0x22, 0x0, 0x7, 0x89, 0x6, 0x0,
    0x8, 0xfd, 0xdf, 0x2a, 0x6e, 0xe, 0x28, 0x70,
    0x8, 0x80, 0xd, 0x2e, 0x3e, 0x4, 0x11, 0xe0,
    0x8, 0x80, 0xd, 0x6d, 0x1e, 0x0, 0xb, 0xa5,
    0x8, 0xfe, 0xef, 0x96, 0x1f, 0x11, 0x2d, 0x31,
    0x8, 0x91, 0x11, 0x0, 0xd, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8AA4 "誤" */
    0x0, 0x29, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x4, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x6, 0x50, 0x4, 0xc1, 0x11, 0x15, 0xe0,
    0x1e, 0xee, 0xee, 0x84, 0xc0, 0x0, 0x4, 0xe0,
    0x4, 0x44, 0x44, 0x24, 0xc1, 0x11, 0x15, 0xe0,
    0x4, 0x88, 0x88, 0x4, 0xff, 0xff, 0xff, 0xd0,
    0x2, 0x55, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xbb, 0xbb, 0xa, 0xff, 0xff, 0xff, 0xf1,
    0x1, 0x33, 0x33, 0x0, 0x0, 0x5b, 0x0, 0x0,
    0x3, 0x76, 0x66, 0x11, 0x11, 0x8a, 0x11, 0x10,
    0x8, 0xda, 0xaf, 0x6f, 0xff, 0xff, 0xff, 0xfa,
    0x8, 0x80, 0xe, 0x20, 0x1, 0xff, 0x20, 0x0,
    0x8, 0x80, 0xe, 0x20, 0xb, 0xb7, 0xd1, 0x0,
    0x8, 0xfe, 0xef, 0x25, 0xdd, 0x10, 0xae, 0x50,
    0x8, 0x91, 0x11, 0x3f, 0x91, 0x0, 0x7, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8AAA "說" */
    0x0, 0x31, 0x0, 0x0, 0x10, 0x3, 0x10, 0x0,
    0x0, 0x8b, 0x0, 0x0, 0xc5, 0x7, 0x90, 0x0,
    0x0, 0xd, 0x10, 0x5, 0xd0, 0x0, 0xe3, 0x0,
    0x6b, 0xbb, 0xbb, 0x2e, 0x40, 0x0, 0x5e, 0x10,
    0x24, 0x44, 0x45, 0xda, 0x11, 0x11, 0x1a, 0xe0,
    0x8, 0x99, 0x95, 0x7e, 0xff, 0xff, 0xff, 0x40,
    0x4, 0x44, 0x42, 0xe, 0x20, 0x0, 0x3f, 0x0,
    0xa, 0xbb, 0xb6, 0xe, 0x20, 0x0, 0x3f, 0x0,
    0x3, 0x33, 0x32, 0xe, 0x87, 0x77, 0x9f, 0x0,
    0x3, 0x22, 0x21, 0xb, 0xee, 0xcf, 0xdb, 0x0,
    0xe, 0xed, 0xea, 0x0, 0x89, 0xe, 0x30, 0x0,
    0xe, 0x10, 0x6a, 0x0, 0xc6, 0xe, 0x30, 0x0,
    0xe, 0x10, 0x6a, 0x3, 0xf1, 0xe, 0x30, 0xb0,
    0xe, 0xfe, 0xfa, 0x4e, 0x80, 0xe, 0x41, 0xf0,
    0xe, 0x21, 0x12, 0xe6, 0x0, 0xb, 0xff, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8AAD "読" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x89, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0,
    0x0, 0x1d, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xf2,
    0x4b, 0xbb, 0xbb, 0x0, 0x0, 0xba, 0x0, 0x0,
    0x13, 0x33, 0x33, 0xa, 0xbb, 0xee, 0xbb, 0x60,
    0x9, 0xdd, 0xd6, 0x6, 0x77, 0x77, 0x77, 0x30,
    0x2, 0x22, 0x21, 0x49, 0x99, 0x99, 0x99, 0x91,
    0x3, 0x44, 0x42, 0x6e, 0xbb, 0xbb, 0xbb, 0xf2,
    0x8, 0xbb, 0xb5, 0x6a, 0x15, 0x1, 0x50, 0xf2,
    0x2, 0x32, 0x21, 0x24, 0x3d, 0x3, 0xe0, 0x60,
    0xc, 0xed, 0xea, 0x0, 0x5d, 0x3, 0xe0, 0x0,
    0xc, 0x40, 0x7a, 0x0, 0x9a, 0x3, 0xe0, 0x0,
    0xc, 0x40, 0x7a, 0x1, 0xf5, 0x3, 0xe0, 0x74,
    0xc, 0xfe, 0xfa, 0x2d, 0xb0, 0x3, 0xe0, 0xa5,
    0xc, 0x51, 0x11, 0xdb, 0x0, 0x1, 0xef, 0xe1,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+8ACB "請" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0x40, 0x9, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0x5, 0x30, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0x92, 0xbb, 0xcf, 0xbb, 0xb2,
    0x1, 0x11, 0x11, 0x0, 0x33, 0x5f, 0x33, 0x30,
    0x6, 0xdd, 0xdd, 0x1c, 0xcc, 0xdf, 0xcc, 0xc9,
    0x1, 0x22, 0x22, 0x2, 0x22, 0x22, 0x22, 0x22,
    0x5, 0xbb, 0xbb, 0x1, 0xee, 0xee, 0xef, 0x80,
    0x1, 0x33, 0x33, 0x1, 0xf0, 0x0, 0x9, 0x90,
    0x1, 0x32, 0x22, 0x1, 0xf8, 0x88, 0x8c, 0x90,
    0x7, 0xfd, 0xdf, 0x21, 0xf7, 0x77, 0x7c, 0x90,
    0x7, 0x80, 0xd, 0x21, 0xf8, 0x88, 0x8c, 0x90,
    0x7, 0x80, 0xd, 0x21, 0xf3, 0x33, 0x3a, 0x90,
    0x7, 0xfe, 0xef, 0x21, 0xf0, 0x0, 0x9, 0x80,
    0x7, 0x91, 0x11, 0x1, 0xf0, 0x0, 0xfe, 0x50,

    /* U+8B66 "警" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x1c, 0xdf, 0xce, 0xec, 0x52, 0xe0, 0x0, 0x0,
    0x0, 0x96, 0x2, 0x30, 0xb, 0xed, 0xef, 0xd2,
    0x3, 0xfb, 0xaa, 0xba, 0x8e, 0xa0, 0x8a, 0x0,
    0x2e, 0xda, 0xa6, 0x5b, 0x60, 0xba, 0xe1, 0x0,
    0x5, 0xc0, 0x59, 0x79, 0x0, 0x9f, 0xc1, 0x0,
    0x2, 0xea, 0xab, 0xd6, 0x4e, 0x91, 0x7e, 0xb1,
    0x1, 0x21, 0x14, 0x5b, 0x93, 0x11, 0x12, 0x50,
    0x9, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x90,
    0x0, 0xa, 0xbb, 0xbb, 0xbb, 0xbb, 0xb0, 0x0,
    0x0, 0x3, 0x44, 0x44, 0x44, 0x44, 0x30, 0x0,
    0x0, 0x7, 0x88, 0x88, 0x88, 0x88, 0x70, 0x0,
    0x0, 0xb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb1, 0x0,
    0x0, 0xf, 0x10, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0xf, 0xcb, 0xbb, 0xbb, 0xbb, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BBE "设" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xba, 0x0, 0x2, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x1e, 0x90, 0x2, 0xf1, 0x11, 0xf2, 0x0,
    0x0, 0x2, 0xd0, 0x2, 0xf0, 0x0, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xc0, 0x0, 0xf2, 0x0,
    0x3, 0x33, 0x0, 0x2e, 0x50, 0x0, 0xf7, 0x52,
    0x3f, 0xff, 0x24, 0xf9, 0x0, 0x0, 0x7b, 0xb3,
    0x0, 0xf, 0x20, 0x62, 0x22, 0x22, 0x23, 0x0,
    0x0, 0xf, 0x20, 0xdf, 0xff, 0xff, 0xff, 0x60,
    0x0, 0xf, 0x20, 0x1e, 0x30, 0x0, 0x3f, 0x10,
    0x0, 0xf, 0x20, 0x7, 0xd0, 0x0, 0xd7, 0x0,
    0x0, 0xf, 0x24, 0x0, 0xbb, 0x1b, 0xb0, 0x0,
    0x0, 0xf, 0xbe, 0x10, 0xd, 0xfc, 0x0, 0x0,
    0x0, 0x4f, 0xc1, 0x3, 0xaf, 0xcf, 0x92, 0x0,
    0x0, 0x89, 0x3, 0xdf, 0x92, 0x3, 0xbf, 0xd3,
    0x0, 0x0, 0x0, 0x50, 0x0, 0x0, 0x2, 0x60,

    /* U+8BBF "访" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x40, 0x0, 0x0,
    0x0, 0xb9, 0x0, 0x0, 0x3, 0xf1, 0x0, 0x0,
    0x0, 0x2e, 0x90, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x2, 0xb0, 0xaa, 0xaa, 0xda, 0xaa, 0xa2,
    0x0, 0x0, 0x0, 0x88, 0xdc, 0x88, 0x88, 0x82,
    0x17, 0x77, 0x20, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0x3b, 0xbf, 0x60, 0x0, 0xc8, 0x11, 0x12, 0x0,
    0x0, 0xc, 0x60, 0x0, 0xdf, 0xff, 0xff, 0x30,
    0x0, 0xc, 0x60, 0x0, 0xe4, 0x0, 0xf, 0x20,
    0x0, 0xc, 0x60, 0x1, 0xf2, 0x0, 0xf, 0x10,
    0x0, 0xc, 0x60, 0x14, 0xe0, 0x0, 0x1f, 0x0,
    0x0, 0xc, 0x9d, 0x69, 0xa0, 0x0, 0x3f, 0x0,
    0x0, 0xe, 0xf6, 0x1f, 0x40, 0x0, 0x5d, 0x0,
    0x0, 0x7d, 0x20, 0xbb, 0x0, 0x21, 0xab, 0x0,
    0x0, 0x1, 0x3, 0xd1, 0x0, 0xff, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BD5 "试" */
    0x0, 0x83, 0x0, 0x0, 0x0, 0x4f, 0x39, 0x0,
    0x0, 0x6f, 0x30, 0x0, 0x0, 0x3f, 0xc, 0x70,
    0x0, 0x6, 0xd0, 0x0, 0x0, 0x3f, 0x1, 0x90,
    0x0, 0x0, 0x6, 0xdd, 0xdd, 0xef, 0xdd, 0xd4,
    0x3, 0x33, 0x2, 0x44, 0x44, 0x5f, 0x54, 0x41,
    0x3f, 0xff, 0x20, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf, 0x20, 0x8a, 0xaa, 0x4f, 0x30, 0x0,
    0x0, 0xf, 0x20, 0x69, 0xf8, 0x3d, 0x50, 0x0,
    0x0, 0xf, 0x20, 0x2, 0xe0, 0xc, 0x70, 0x0,
    0x0, 0xf, 0x20, 0x2, 0xe0, 0x9, 0x90, 0x0,
    0x0, 0xf, 0x26, 0x12, 0xe2, 0x46, 0xd0, 0x63,
    0x0, 0xf, 0xdd, 0x7a, 0xff, 0x92, 0xf2, 0xa5,
    0x0, 0x7f, 0x70, 0xc8, 0x40, 0x0, 0xcd, 0xf2,
    0x0, 0x23, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BDD "话" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x1, 0xc2, 0x0, 0x2, 0x46, 0x9c, 0xfe, 0x30,
    0x0, 0x9e, 0x20, 0xef, 0xdb, 0xf7, 0x20, 0x0,
    0x0, 0xa, 0x80, 0x0, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf3, 0x0, 0x0,
    0x3, 0x33, 0x0, 0x55, 0x55, 0xf7, 0x55, 0x52,
    0x3f, 0xff, 0x21, 0xdd, 0xdd, 0xfe, 0xdd, 0xd5,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x2b, 0xbb, 0xfc, 0xbb, 0x50,
    0x0, 0xf, 0x20, 0x4f, 0x66, 0x66, 0x6d, 0x80,
    0x0, 0xf, 0x39, 0x4f, 0x0, 0x0, 0xc, 0x80,
    0x0, 0xf, 0xeb, 0x4f, 0x0, 0x0, 0xc, 0x80,
    0x0, 0x5f, 0x70, 0x4f, 0x44, 0x44, 0x4d, 0x80,
    0x0, 0x75, 0x0, 0x4f, 0xdd, 0xdd, 0xdf, 0x80,

    /* U+8BEF "误" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf5, 0x0, 0x2f, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x7f, 0x40, 0x2f, 0x11, 0x11, 0x1d, 0x40,
    0x0, 0x9, 0xb0, 0x2f, 0x0, 0x0, 0xd, 0x40,
    0x0, 0x0, 0x10, 0x2f, 0x33, 0x33, 0x3e, 0x40,
    0x13, 0x33, 0x0, 0x2d, 0xdd, 0xdd, 0xdd, 0x40,
    0x2a, 0xaf, 0x20, 0x1, 0x11, 0x11, 0x11, 0x0,
    0x0, 0xf, 0x20, 0x9f, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0xf, 0x20, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x11, 0x14, 0xf1, 0x11, 0x10,
    0x0, 0xf, 0x21, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x0, 0xf, 0x24, 0x0, 0xc, 0xf8, 0x0, 0x0,
    0x0, 0xf, 0xbe, 0x10, 0x6f, 0x4f, 0x50, 0x0,
    0x0, 0x5f, 0xa1, 0x18, 0xf4, 0x5, 0xf8, 0x10,
    0x0, 0x26, 0x3, 0xfb, 0x30, 0x0, 0x3d, 0xf3,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x20,

    /* U+8BF4 "说" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0xa2, 0x0, 0xe, 0x40, 0x0, 0xd6, 0x0,
    0x0, 0x8e, 0x20, 0x7, 0xd0, 0x4, 0xf1, 0x0,
    0x0, 0x8, 0xd0, 0x0, 0xd2, 0xc, 0x90, 0x0,
    0x0, 0x0, 0x20, 0xef, 0xff, 0xff, 0xff, 0x0,
    0x13, 0x33, 0x0, 0xe4, 0x11, 0x11, 0x4f, 0x0,
    0x4f, 0xff, 0x40, 0xe4, 0x0, 0x0, 0x4f, 0x0,
    0x0, 0xf, 0x40, 0xe6, 0x33, 0x33, 0x6f, 0x0,
    0x0, 0xf, 0x40, 0xcd, 0xfe, 0xef, 0xdc, 0x0,
    0x0, 0xf, 0x40, 0x0, 0xf4, 0x3f, 0x0, 0x0,
    0x0, 0xf, 0x41, 0x1, 0xf2, 0x3f, 0x0, 0x0,
    0x0, 0xf, 0x8e, 0x45, 0xe0, 0x3f, 0x0, 0x0,
    0x0, 0x1f, 0xf6, 0xd, 0x80, 0x3f, 0x0, 0xa3,
    0x0, 0xad, 0x31, 0xbd, 0x0, 0x2f, 0x22, 0xe3,
    0x0, 0x31, 0xe, 0xb1, 0x0, 0xd, 0xff, 0xd0,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BF7 "请" */
    0x0, 0x80, 0x0, 0x0, 0x2, 0xf0, 0x0, 0x0,
    0x0, 0xbd, 0x10, 0xde, 0xef, 0xfe, 0xee, 0xc0,
    0x0, 0xa, 0xa0, 0x0, 0x3, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x10, 0x6d, 0xde, 0xfd, 0xdd, 0x50,
    0x13, 0x33, 0x0, 0x11, 0x14, 0xf1, 0x11, 0x10,
    0x5f, 0xff, 0x34, 0xaa, 0xaa, 0xaa, 0xaa, 0xa3,
    0x0, 0xe, 0x30, 0x3, 0x33, 0x33, 0x33, 0x0,
    0x0, 0xe, 0x30, 0x3f, 0xcc, 0xcc, 0xcf, 0x20,
    0x0, 0xe, 0x30, 0x3e, 0x0, 0x0, 0xf, 0x20,
    0x0, 0xe, 0x30, 0x3f, 0xdd, 0xdd, 0xdf, 0x20,
    0x0, 0xe, 0x35, 0x3e, 0x0, 0x0, 0xf, 0x20,
    0x0, 0xf, 0xdd, 0x4f, 0xee, 0xee, 0xef, 0x20,
    0x0, 0x5f, 0x90, 0x3e, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x35, 0x0, 0x3e, 0x0, 0xe, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8CC7 "資" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x3, 0xb6, 0x10, 0x8, 0xa0, 0x0, 0x1, 0x0,
    0x0, 0x4a, 0xe3, 0x5f, 0xde, 0xdd, 0xdf, 0x90,
    0x0, 0x0, 0x13, 0xe2, 0xb, 0xa0, 0x4e, 0x10,
    0x1, 0x59, 0xd4, 0x3, 0xba, 0xaa, 0x31, 0x0,
    0x1e, 0xb6, 0x13, 0xdc, 0x50, 0x4, 0xcc, 0x60,
    0x0, 0x1d, 0xdd, 0xed, 0xdd, 0xdd, 0xd6, 0x10,
    0x0, 0x1f, 0x10, 0x0, 0x0, 0x0, 0xe4, 0x0,
    0x0, 0x1f, 0xcc, 0xcc, 0xcc, 0xcc, 0xf4, 0x0,
    0x0, 0x1f, 0x10, 0x0, 0x0, 0x0, 0xe4, 0x0,
    0x0, 0x1f, 0xcc, 0xcc, 0xcc, 0xcc, 0xf4, 0x0,
    0x0, 0x1f, 0x10, 0x0, 0x0, 0x0, 0xe4, 0x0,
    0x0, 0x1c, 0xcd, 0xcc, 0xcc, 0xdc, 0xc3, 0x0,
    0x0, 0x3, 0x9e, 0x30, 0x2, 0xdb, 0x50, 0x0,
    0x9, 0xfc, 0x60, 0x0, 0x0, 0x4, 0xae, 0x80,
    0x2, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1, 0x10,

    /* U+8D25 "败" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x50, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xe0, 0x9, 0x80, 0x0, 0x0,
    0xc, 0x41, 0x13, 0xe0, 0xd, 0x40, 0x0, 0x0,
    0xc, 0x31, 0x42, 0xe0, 0x2f, 0x87, 0x77, 0x70,
    0xc, 0x34, 0xc2, 0xe0, 0x7d, 0xaa, 0xbe, 0x90,
    0xc, 0x34, 0xc2, 0xe0, 0xd4, 0x0, 0x5a, 0x0,
    0xc, 0x34, 0xc2, 0xe6, 0xf6, 0x0, 0x87, 0x0,
    0xc, 0x34, 0xc2, 0xe7, 0x9b, 0x0, 0xc4, 0x0,
    0xc, 0x34, 0xc2, 0xe0, 0xe, 0x21, 0xf0, 0x0,
    0xc, 0x36, 0xb2, 0xe0, 0x7, 0xa7, 0xa0, 0x0,
    0x9, 0x29, 0x81, 0xa0, 0x0, 0xef, 0x30, 0x0,
    0x0, 0xe, 0x68, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0x0, 0x9b, 0xd, 0x50, 0x6, 0xe9, 0xd1, 0x0,
    0x9, 0xe1, 0x3, 0xe2, 0x9e, 0x20, 0x9e, 0x50,
    0x3b, 0x10, 0x0, 0x44, 0xb1, 0x0, 0x5, 0xa0,

    /* U+8D44 "资" */
    0x0, 0x0, 0x0, 0x1, 0x30, 0x0, 0x0, 0x0,
    0x4, 0xa3, 0x0, 0xa, 0x90, 0x0, 0x0, 0x0,
    0x1, 0x7e, 0xb1, 0x4f, 0xff, 0xfe, 0xef, 0x90,
    0x0, 0x0, 0x74, 0xe5, 0x8, 0xb0, 0x1f, 0x30,
    0x0, 0x0, 0x17, 0x60, 0x1f, 0xe3, 0x37, 0x0,
    0x2, 0x6b, 0xf7, 0x2, 0xd8, 0x4e, 0x60, 0x0,
    0x1f, 0xb6, 0x12, 0x8e, 0x70, 0x2, 0xcd, 0x70,
    0x0, 0x0, 0x4, 0x82, 0x0, 0x0, 0x4, 0x60,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x1f, 0x42, 0x25, 0x62, 0x22, 0xf4, 0x0,
    0x0, 0x1f, 0x10, 0xa, 0x80, 0x0, 0xf4, 0x0,
    0x0, 0x1f, 0x10, 0x1f, 0x30, 0x0, 0xf4, 0x0,
    0x0, 0x8, 0x1, 0xca, 0x7e, 0x93, 0x61, 0x0,
    0x0, 0x2, 0x8e, 0xa0, 0x3, 0x9f, 0xd6, 0x0,
    0xb, 0xfe, 0x93, 0x0, 0x0, 0x0, 0x6d, 0xb0,
    0x3, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8D85 "超" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xd0, 0x0, 0xaa, 0xdd, 0xaa, 0xf3,
    0x3, 0x47, 0xe4, 0x41, 0x0, 0xb7, 0x0, 0xf2,
    0xa, 0xcd, 0xfc, 0xc4, 0x0, 0xf3, 0x0, 0xf1,
    0x0, 0x4, 0xd0, 0x0, 0x8, 0xd0, 0x2, 0xf0,
    0x16, 0x69, 0xe6, 0x64, 0x5f, 0x42, 0x69, 0xd0,
    0x1a, 0xaa, 0xfa, 0xaa, 0xf6, 0x1, 0x88, 0x20,
    0x1, 0x21, 0xf0, 0x0, 0x39, 0x99, 0x99, 0x80,
    0x5, 0xc1, 0xf1, 0x10, 0x4e, 0x66, 0x69, 0xe0,
    0x5, 0xb1, 0xff, 0xf7, 0x4d, 0x0, 0x5, 0xe0,
    0x6, 0xd1, 0xf0, 0x0, 0x4d, 0x0, 0x5, 0xe0,
    0x8, 0xf5, 0xf0, 0x0, 0x4f, 0xdd, 0xde, 0xe0,
    0xb, 0xce, 0xf0, 0x0, 0x2, 0x22, 0x22, 0x20,
    0xe, 0x38, 0xf9, 0x53, 0x22, 0x22, 0x22, 0x22,
    0x5e, 0x0, 0x3a, 0xdf, 0xff, 0xff, 0xff, 0xf9,
    0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8DB3 "足" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x4e, 0x22, 0x22, 0x22, 0x22, 0x6e, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x0,
    0x0, 0x4f, 0x55, 0x55, 0x55, 0x55, 0x9e, 0x0,
    0x0, 0x3c, 0xcc, 0xce, 0xfc, 0xcc, 0xcb, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xd0, 0x8, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xa0, 0x8, 0xff, 0xff, 0xff, 0x20,
    0x0, 0xd, 0xc0, 0x8, 0xc3, 0x33, 0x33, 0x0,
    0x0, 0x3f, 0xe5, 0x8, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xba, 0x4f, 0x58, 0xb0, 0x0, 0x0, 0x0,
    0x5, 0xf2, 0x5, 0xff, 0xd4, 0x32, 0x22, 0x21,
    0xe, 0x50, 0x0, 0x17, 0xbe, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8DEF "路" */
    0x0, 0x0, 0x0, 0x0, 0x6, 0x40, 0x0, 0x0,
    0xc, 0xff, 0xff, 0x70, 0xf, 0x40, 0x0, 0x0,
    0xc, 0x50, 0x9, 0x70, 0x7f, 0xff, 0xff, 0x10,
    0xc, 0x40, 0x9, 0x71, 0xe9, 0x11, 0x9c, 0x0,
    0xc, 0x50, 0x9, 0x7b, 0xce, 0x12, 0xf4, 0x0,
    0xc, 0xff, 0xff, 0xcd, 0x18, 0xcc, 0xa0, 0x0,
    0x0, 0x6, 0xb0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x6, 0x26, 0xb0, 0x0, 0x1c, 0xdc, 0xc2, 0x0,
    0xc, 0x36, 0xeb, 0x76, 0xea, 0x0, 0x9f, 0x81,
    0xc, 0x36, 0xc5, 0x9e, 0xfc, 0xcc, 0xce, 0xd2,
    0xc, 0x36, 0xb0, 0x3, 0xf4, 0x44, 0x4e, 0x40,
    0xc, 0x36, 0xb0, 0x13, 0xe0, 0x0, 0xe, 0x40,
    0xc, 0x59, 0xed, 0xc3, 0xe0, 0x0, 0xe, 0x40,
    0x6f, 0xfe, 0xa5, 0x13, 0xf3, 0x33, 0x3e, 0x40,
    0x47, 0x30, 0x0, 0x3, 0xfe, 0xee, 0xef, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8F09 "載" */
    0x0, 0x3, 0xe0, 0x0, 0x3d, 0xa, 0x30, 0x1,
    0xff, 0xff, 0xff, 0xe3, 0xe0, 0x3e, 0x40, 0x0,
    0x3, 0xe0, 0x0, 0x2e, 0x0, 0x34, 0xc, 0xee,
    0xef, 0xee, 0xee, 0xfe, 0xee, 0xe3, 0x12, 0x24,
    0xe2, 0x22, 0x3f, 0x22, 0x22, 0x6, 0xee, 0xff,
    0xee, 0xe3, 0xf1, 0xa, 0x60, 0x1, 0x14, 0xe1,
    0x11, 0xe, 0x31, 0xf1, 0x1, 0xea, 0xbf, 0xaa,
    0xe0, 0xc5, 0x7b, 0x0, 0x1e, 0x78, 0xe7, 0x7e,
    0x9, 0x9e, 0x30, 0x1, 0xd4, 0x5d, 0x44, 0xe0,
    0x6f, 0xb0, 0x0, 0x1d, 0xbc, 0xfb, 0xbc, 0x6,
    0xf2, 0x3, 0x0, 0x0, 0x3d, 0x0, 0x3, 0xfe,
    0x60, 0x95, 0x9e, 0xef, 0xfe, 0xef, 0xf7, 0x5e,
    0x5d, 0x30, 0x0, 0x3d, 0x0, 0xa5, 0x0, 0x8f,
    0xb0,

    /* U+8F7D "载" */
    0x0, 0x0, 0x4e, 0x0, 0x4, 0xd0, 0x92, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xa4, 0xe0, 0x6e, 0x30,
    0x0, 0x0, 0x4e, 0x0, 0x3, 0xe0, 0x5, 0x20,
    0x1d, 0xdd, 0xef, 0xdd, 0xdd, 0xfd, 0xdd, 0xd2,
    0x2, 0x24, 0xc2, 0x22, 0x24, 0xf2, 0x22, 0x20,
    0x0, 0x8, 0xc0, 0x0, 0x1, 0xf1, 0x9, 0x40,
    0xe, 0xff, 0xff, 0xff, 0xf4, 0xf3, 0x1f, 0x20,
    0x0, 0x7c, 0x5, 0x30, 0x0, 0xd5, 0x7c, 0x0,
    0x2, 0xf6, 0x4c, 0x94, 0x30, 0xb8, 0xe5, 0x0,
    0x3, 0xdc, 0xcf, 0xec, 0xc0, 0x8f, 0xc0, 0x0,
    0x0, 0x0, 0xa, 0x70, 0x0, 0x5f, 0x40, 0x20,
    0x7, 0x9a, 0xbf, 0xfe, 0xd5, 0xdf, 0x50, 0x95,
    0x7, 0x65, 0x3b, 0x70, 0x1c, 0xb7, 0xe4, 0xd3,
    0x0, 0x0, 0xa, 0x70, 0x8a, 0x0, 0x9f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8FBC "込" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xd1, 0x0, 0x6, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x10, 0x1, 0xca, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x60, 0x0, 0x1e, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf2, 0x0, 0x0,
    0x2, 0x22, 0x0, 0x0, 0x7d, 0xa8, 0x0, 0x0,
    0x3f, 0xff, 0x30, 0x0, 0xd7, 0x4d, 0x0, 0x0,
    0x0, 0xf, 0x30, 0x4, 0xf1, 0xe, 0x50, 0x0,
    0x0, 0xf, 0x30, 0xd, 0x80, 0x8, 0xd0, 0x0,
    0x0, 0xf, 0x30, 0xbd, 0x0, 0x1, 0xeb, 0x10,
    0x0, 0xf, 0x3b, 0xd1, 0x0, 0x0, 0x2e, 0xe0,
    0x0, 0x9f, 0x92, 0x10, 0x0, 0x0, 0x0, 0x40,
    0xc, 0xb1, 0x8d, 0x74, 0x32, 0x23, 0x34, 0x62,
    0x1b, 0x0, 0x3, 0x9c, 0xde, 0xed, 0xdd, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8FDB "进" */
    0x5, 0xa0, 0x0, 0x4, 0xe0, 0x4, 0xe0, 0x0,
    0x1, 0xda, 0x0, 0x4, 0xe0, 0x4, 0xe0, 0x0,
    0x0, 0x1e, 0x72, 0x57, 0xf5, 0x58, 0xf5, 0x50,
    0x0, 0x2, 0x7, 0xde, 0xfd, 0xde, 0xfd, 0xd0,
    0x0, 0x0, 0x0, 0x4, 0xe0, 0x4, 0xe0, 0x0,
    0x17, 0x77, 0x10, 0x4, 0xe0, 0x4, 0xe0, 0x0,
    0x2b, 0xbf, 0x32, 0x47, 0xf4, 0x47, 0xf4, 0x41,
    0x0, 0xf, 0x36, 0xde, 0xfd, 0xde, 0xfd, 0xd4,
    0x0, 0xf, 0x30, 0xa, 0x90, 0x4, 0xe0, 0x0,
    0x0, 0xf, 0x30, 0x1f, 0x40, 0x4, 0xe0, 0x0,
    0x0, 0xf, 0x31, 0xcc, 0x0, 0x4, 0xe0, 0x0,
    0x0, 0x8f, 0x91, 0xb2, 0x0, 0x4, 0xd0, 0x0,
    0xb, 0xc2, 0x9d, 0x52, 0x0, 0x0, 0x12, 0x43,
    0x2e, 0x10, 0x4, 0xbf, 0xff, 0xff, 0xff, 0xf5,
    0x1, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+8FDE "连" */
    0x0, 0x20, 0x0, 0x0, 0x63, 0x0, 0x0, 0x0,
    0x5, 0xe2, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0xe, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0xd, 0x41, 0x1c, 0x91, 0x11, 0x11, 0x10,
    0x0, 0x0, 0x0, 0x3f, 0x10, 0xe2, 0x0, 0x0,
    0x1, 0x11, 0x0, 0xc8, 0x0, 0xf2, 0x0, 0x0,
    0x4f, 0xff, 0x3, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x3f, 0x0, 0x32, 0x23, 0xf5, 0x22, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0x0, 0x3f, 0xb, 0xcc, 0xcc, 0xfd, 0xcc, 0xc0,
    0x0, 0x3f, 0x4, 0x55, 0x55, 0xf7, 0x55, 0x50,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0x1, 0xbf, 0x60, 0x0, 0x0, 0xf2, 0x0, 0x0,
    0x1d, 0xb4, 0xdc, 0x63, 0x22, 0x63, 0x34, 0x64,
    0x3d, 0x0, 0x7, 0xcf, 0xff, 0xff, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+9001 "送" */
    0x0, 0x10, 0x0, 0x12, 0x0, 0x0, 0x31, 0x0,
    0x7, 0xd1, 0x0, 0x5d, 0x0, 0x1, 0xf4, 0x0,
    0x0, 0xbb, 0x0, 0xc, 0x70, 0x8, 0xb0, 0x0,
    0x0, 0xd, 0x44, 0x7a, 0x97, 0x7f, 0x97, 0x30,
    0x0, 0x0, 0x6, 0xaa, 0xaf, 0xca, 0xaa, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0,
    0x3f, 0xff, 0x0, 0x0, 0xd, 0x60, 0x0, 0x0,
    0x1, 0x4f, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x3f, 0x1, 0x11, 0x3f, 0xb1, 0x11, 0x10,
    0x0, 0x3f, 0x0, 0x0, 0x9c, 0xcb, 0x0, 0x0,
    0x0, 0x3f, 0x0, 0x6, 0xf3, 0xc, 0xb0, 0x0,
    0x0, 0x3f, 0x1, 0xaf, 0x40, 0x0, 0xcb, 0x0,
    0x1, 0xbf, 0x49, 0xb2, 0x0, 0x0, 0x1a, 0x10,
    0x2e, 0xa5, 0xea, 0x53, 0x21, 0x22, 0x34, 0x51,
    0x4c, 0x0, 0x18, 0xdf, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x10, 0x0, 0x0,

    /* U+9023 "連" */
    0x4, 0x90, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x1, 0xd8, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x1e, 0x30, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0x1, 0x2, 0xee, 0xef, 0xee, 0xee, 0x0,
    0x2, 0x22, 0x3, 0xe0, 0xe, 0x40, 0x1f, 0x10,
    0x4f, 0xff, 0x3, 0xfe, 0xef, 0xee, 0xef, 0x10,
    0x0, 0x3f, 0x3, 0xe0, 0xe, 0x40, 0x1f, 0x10,
    0x0, 0x3f, 0x3, 0xfd, 0xdf, 0xdd, 0xdf, 0x10,
    0x0, 0x3f, 0x0, 0x11, 0x1f, 0x41, 0x11, 0x0,
    0x0, 0x3f, 0x5b, 0xbb, 0xbf, 0xcb, 0xbb, 0xb0,
    0x0, 0x3f, 0x36, 0x66, 0x6f, 0x86, 0x66, 0x60,
    0x1, 0xcf, 0x30, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x1d, 0x95, 0xe9, 0x42, 0x15, 0x22, 0x23, 0x52,
    0x4c, 0x0, 0x19, 0xdf, 0xff, 0xff, 0xff, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x10, 0x0, 0x0,

    /* U+9054 "達" */
    0x3, 0x30, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x6, 0xf3, 0x6, 0xee, 0xef, 0xee, 0xec, 0x0,
    0x0, 0x6e, 0x10, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x0, 0x4, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x3e, 0x0, 0xa, 0x80, 0x0,
    0x3, 0x32, 0x7, 0x7e, 0x97, 0x8f, 0x87, 0x50,
    0x3d, 0xdf, 0x5, 0x55, 0x5f, 0x85, 0x55, 0x30,
    0x0, 0x3f, 0x6, 0xbb, 0xbf, 0xcb, 0xbb, 0x0,
    0x0, 0x3f, 0x2, 0x33, 0x3f, 0x63, 0x33, 0x0,
    0x0, 0x3f, 0x16, 0x66, 0x6f, 0x86, 0x66, 0x50,
    0x0, 0x3f, 0x3b, 0xbb, 0xbf, 0xcb, 0xbb, 0x80,
    0x0, 0xbf, 0x50, 0x0, 0xe, 0x40, 0x0, 0x0,
    0xb, 0xa2, 0xc9, 0x30, 0x2, 0x0, 0x2, 0x30,
    0x2d, 0x0, 0x7, 0xdf, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x10, 0x0, 0x0,

    /* U+914D "配" */
    0x1f, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xf2,
    0x0, 0x9, 0x4c, 0x10, 0x2, 0x22, 0x22, 0xf2,
    0x0, 0x9, 0x4c, 0x10, 0x0, 0x0, 0x0, 0xf2,
    0x7, 0xef, 0xef, 0xea, 0x0, 0x0, 0x0, 0xf2,
    0x8, 0x88, 0x5c, 0x5b, 0x0, 0x0, 0x0, 0xf2,
    0x8, 0x77, 0x3b, 0x3b, 0x1b, 0xbb, 0xbb, 0xf2,
    0x8, 0x79, 0x2b, 0x3b, 0x2f, 0x76, 0x66, 0xf2,
    0x8, 0x9b, 0xb, 0xcb, 0x2f, 0x10, 0x0, 0x91,
    0x8, 0xa3, 0x0, 0x3b, 0x2f, 0x10, 0x0, 0x0,
    0x8, 0x93, 0x33, 0x5b, 0x2f, 0x10, 0x0, 0x0,
    0x8, 0xdb, 0xbb, 0xcb, 0x2f, 0x10, 0x0, 0x22,
    0x8, 0x70, 0x0, 0x3b, 0x2f, 0x10, 0x0, 0x7b,
    0x8, 0xfe, 0xee, 0xfb, 0x1f, 0x42, 0x22, 0xb8,
    0x8, 0x80, 0x0, 0x3b, 0xa, 0xff, 0xff, 0xe2,

    /* U+91CD "重" */
    0x0, 0x0, 0x1, 0x23, 0x46, 0x8a, 0x60, 0x0,
    0x5f, 0xff, 0xff, 0xfc, 0xb9, 0x73, 0x0, 0x0,
    0x21, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x9, 0xdd,
    0xdd, 0xde, 0xfd, 0xdd, 0xdd, 0xd6, 0x12, 0x22,
    0x22, 0x6f, 0x22, 0x22, 0x22, 0x10, 0x3d, 0xdd,
    0xde, 0xfd, 0xdd, 0xdc, 0x0, 0x4, 0xe0, 0x0,
    0x4e, 0x0, 0x4, 0xe0, 0x0, 0x4f, 0xcc, 0xcd,
    0xfc, 0xcc, 0xde, 0x0, 0x4, 0xe0, 0x0, 0x4e,
    0x0, 0x4, 0xe0, 0x0, 0x4f, 0xcc, 0xcd, 0xfc,
    0xcc, 0xde, 0x0, 0x0, 0x11, 0x11, 0x5f, 0x11,
    0x11, 0x10, 0x0, 0x7c, 0xcc, 0xcd, 0xfc, 0xcc,
    0xcc, 0x60, 0x1, 0x33, 0x33, 0x6f, 0x33, 0x33,
    0x31, 0x0, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90,

    /* U+91CF "量" */
    0x0, 0x2f, 0xbb, 0xbb, 0xbb, 0xbb, 0xf2, 0x0,
    0x0, 0x2f, 0x66, 0x66, 0x66, 0x66, 0xf2, 0x0,
    0x0, 0x2f, 0x55, 0x55, 0x55, 0x55, 0xf2, 0x0,
    0x0, 0x2f, 0xbb, 0xbb, 0xbb, 0xbb, 0xf2, 0x0,
    0x15, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x51,
    0x18, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x81,
    0x0, 0x5c, 0xcc, 0xcc, 0xcc, 0xcc, 0xc7, 0x0,
    0x0, 0x7b, 0x22, 0x2b, 0xa2, 0x22, 0xa9, 0x0,
    0x0, 0x7d, 0x77, 0x7c, 0xc7, 0x77, 0xc9, 0x0,
    0x0, 0x7e, 0xaa, 0xae, 0xda, 0xaa, 0xd9, 0x0,
    0x0, 0x1, 0x11, 0x1a, 0x91, 0x11, 0x10, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x9, 0x90, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+932F "錯" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x40, 0x0, 0x6a, 0x0, 0xe2, 0x0,
    0x0, 0x8e, 0xd4, 0x1, 0x7b, 0x11, 0xf4, 0x10,
    0x7, 0xe2, 0x4e, 0x8a, 0xff, 0xff, 0xff, 0x80,
    0x7f, 0x95, 0x56, 0x40, 0x6a, 0x0, 0xe2, 0x0,
    0x49, 0xcf, 0xda, 0x0, 0x6a, 0x0, 0xe2, 0x0,
    0x0, 0xe, 0x20, 0x1f, 0xff, 0xff, 0xff, 0xf0,
    0x28, 0x8f, 0x98, 0x21, 0x11, 0x11, 0x11, 0x10,
    0x14, 0x4e, 0x64, 0x13, 0xff, 0xff, 0xff, 0x50,
    0x9, 0xe, 0x2b, 0x4, 0xd1, 0x11, 0x1f, 0x60,
    0xb, 0x1e, 0x2d, 0x4, 0xd0, 0x0, 0x1f, 0x60,
    0x8, 0x5e, 0x69, 0x4, 0xff, 0xff, 0xff, 0x60,
    0x4, 0x3e, 0x46, 0x24, 0xd0, 0x0, 0xf, 0x60,
    0x26, 0xaf, 0xfd, 0x34, 0xd3, 0x33, 0x4f, 0x60,
    0x4b, 0x74, 0x0, 0x4, 0xfc, 0xcc, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+9519 "错" */
    0x0, 0x77, 0x0, 0x0, 0x79, 0x2, 0xf0, 0x0,
    0x0, 0xe7, 0x44, 0x11, 0x8a, 0x14, 0xf1, 0x10,
    0x9, 0xed, 0xdd, 0x3d, 0xff, 0xff, 0xff, 0xc0,
    0x5e, 0x10, 0x0, 0x0, 0x79, 0x2, 0xf0, 0x0,
    0x8, 0xcc, 0xcc, 0x0, 0x79, 0x2, 0xf0, 0x0,
    0x3, 0x8f, 0x98, 0x4f, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0xe, 0x30, 0x1, 0x11, 0x11, 0x11, 0x10,
    0x4, 0x4f, 0x64, 0x14, 0x99, 0x99, 0x99, 0x20,
    0x2d, 0xdf, 0xdd, 0x48, 0xc7, 0x77, 0x7f, 0x40,
    0x0, 0xe, 0x30, 0x8, 0x90, 0x0, 0x1f, 0x40,
    0x0, 0xe, 0x30, 0x8, 0xff, 0xff, 0xff, 0x40,
    0x0, 0xe, 0x49, 0x18, 0x90, 0x0, 0xf, 0x40,
    0x0, 0x1f, 0xf9, 0x8, 0xb3, 0x33, 0x3f, 0x40,
    0x0, 0x69, 0x10, 0x8, 0xec, 0xcc, 0xcf, 0x40,

    /* U+9589 "閉" */
    0x9f, 0xee, 0xef, 0x44, 0xfe, 0xee, 0xfa, 0x9a,
    0x0, 0xe, 0x44, 0xf0, 0x0, 0x9a, 0x9e, 0xbb,
    0xbf, 0x44, 0xfb, 0xbb, 0xea, 0x9b, 0x33, 0x3e,
    0x44, 0xf3, 0x33, 0xaa, 0x9a, 0x0, 0xe, 0x44,
    0xf0, 0x0, 0x9a, 0x9f, 0xee, 0xee, 0x34, 0xfe,
    0xee, 0xfa, 0x9a, 0x0, 0x0, 0x2, 0x80, 0x0,
    0x9a, 0x9a, 0x2, 0x33, 0x36, 0xd3, 0x31, 0x9a,
    0x9a, 0xa, 0xcc, 0xcf, 0xfc, 0xc4, 0x9a, 0x9a,
    0x0, 0x0, 0x7e, 0xd0, 0x0, 0x9a, 0x9a, 0x0,
    0x8, 0xd5, 0xd0, 0x0, 0x9a, 0x9a, 0x3, 0xcb,
    0x14, 0xd0, 0x0, 0x9a, 0x9a, 0x1c, 0x60, 0x4,
    0xd0, 0x33, 0xaa, 0x9a, 0x0, 0x1, 0xef, 0x90,
    0xef, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+958B "開" */
    0x9f, 0xee, 0xef, 0x54, 0xfe, 0xee, 0xfa, 0x99,
    0x0, 0xc, 0x54, 0xd0, 0x0, 0x8a, 0x9e, 0xcc,
    0xcf, 0x54, 0xfc, 0xcc, 0xea, 0x9a, 0x11, 0x1c,
    0x54, 0xd1, 0x11, 0x9a, 0x9a, 0x11, 0x1c, 0x54,
    0xd0, 0x0, 0x8a, 0x9f, 0xdd, 0xdd, 0x44, 0xee,
    0xee, 0xfa, 0x99, 0x4, 0x55, 0x55, 0x55, 0x40,
    0x8a, 0x99, 0x9, 0xbf, 0xbb, 0xfb, 0xa0, 0x8a,
    0x99, 0x0, 0x2e, 0x0, 0xf2, 0x0, 0x8a, 0x99,
    0x2d, 0xdf, 0xdd, 0xfd, 0xd3, 0x8a, 0x99, 0x3,
    0x5e, 0x33, 0xf4, 0x30, 0x8a, 0x99, 0x0, 0x79,
    0x0, 0xf2, 0x0, 0x8a, 0x99, 0x2, 0xe2, 0x0,
    0xf2, 0x22, 0xaa, 0x99, 0xa, 0x50, 0x0, 0xf2,
    0x9f, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+9593 "間" */
    0x9f, 0xee, 0xef, 0x44, 0xfe, 0xee, 0xfa, 0x9a,
    0x0, 0xf, 0x44, 0xd0, 0x0, 0x9a, 0x9e, 0xbb,
    0xbf, 0x44, 0xfb, 0xbb, 0xea, 0x9b, 0x33, 0x3f,
    0x44, 0xe3, 0x33, 0xaa, 0x9a, 0x0, 0xf, 0x44,
    0xd0, 0x0, 0x9a, 0x9f, 0xee, 0xee, 0x34, 0xee,
    0xee, 0xfa, 0x9a, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9a, 0x9a, 0x1, 0xff, 0xff, 0xff, 0x0, 0x9a,
    0x9a, 0x1, 0xf0, 0x0, 0x2f, 0x0, 0x9a, 0x9a,
    0x1, 0xfd, 0xdd, 0xef, 0x0, 0x9a, 0x9a, 0x1,
    0xf1, 0x11, 0x3f, 0x0, 0x9a, 0x9a, 0x1, 0xf0,
    0x0, 0x2f, 0x0, 0x9a, 0x9a, 0x1, 0xff, 0xff,
    0xfe, 0x33, 0xaa, 0x9a, 0x1, 0xc0, 0x0, 0x0,
    0xef, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+95DC "關" */
    0x9f, 0xee, 0xef, 0x45, 0xfe, 0xee, 0xfb, 0x98,
    0x0, 0xe, 0x45, 0xd0, 0x0, 0x7b, 0x9e, 0xdd,
    0xdf, 0x45, 0xfd, 0xdd, 0xeb, 0x98, 0x0, 0xe,
    0x45, 0xd0, 0x0, 0x7b, 0x9f, 0xee, 0xef, 0x45,
    0xfe, 0xee, 0xfb, 0x98, 0x1, 0xc0, 0x0, 0x95,
    0x0, 0x7b, 0x98, 0xb, 0x59, 0x34, 0xb4, 0x90,
    0x7b, 0x98, 0x3b, 0xf8, 0xa, 0xdd, 0x20, 0x7b,
    0x98, 0x2c, 0xab, 0x67, 0xe7, 0xd0, 0x7b, 0x98,
    0x29, 0x45, 0x8a, 0x72, 0x81, 0x7b, 0x98, 0xd,
    0x7, 0x78, 0x60, 0xd0, 0x7b, 0x98, 0xd, 0xcd,
    0x68, 0xdc, 0xd0, 0x7b, 0x98, 0x0, 0x2d, 0x28,
    0x60, 0x72, 0x8b, 0x98, 0x2, 0xc4, 0x8, 0x60,
    0xf, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+95ED "闭" */
    0x7, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xc0, 0x5f, 0xff, 0xff, 0xff, 0xf9, 0x0, 0xe7,
    0x2, 0x22, 0x22, 0x22, 0xa9, 0x1, 0x41, 0x0,
    0x0, 0x41, 0x0, 0x99, 0x5d, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x99, 0x5d, 0x2, 0x22, 0x22, 0xf7,
    0x21, 0x99, 0x5d, 0xf, 0xff, 0xff, 0xff, 0xf8,
    0x99, 0x5d, 0x0, 0x0, 0x1e, 0xf5, 0x0, 0x99,
    0x5d, 0x0, 0x0, 0xbb, 0xe5, 0x0, 0x99, 0x5d,
    0x0, 0xb, 0xc0, 0xe5, 0x0, 0x99, 0x5d, 0x2,
    0xcc, 0x0, 0xe5, 0x0, 0x99, 0x5d, 0x5f, 0x80,
    0x0, 0xe5, 0x0, 0x99, 0x5d, 0x13, 0x1, 0x22,
    0xf4, 0x0, 0x99, 0x5d, 0x0, 0x2, 0xff, 0xc1,
    0x12, 0xa9, 0x5d, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xe4,

    /* U+95EE "问" */
    0x7, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xd1, 0x5f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xbc,
    0x12, 0x22, 0x22, 0x22, 0xb8, 0x1, 0x7, 0x0,
    0x0, 0x0, 0x0, 0xb8, 0x4e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb8, 0x4e, 0x0, 0x7d, 0xcc, 0xcc,
    0x0, 0xb8, 0x4e, 0x0, 0x9a, 0x44, 0x6f, 0x0,
    0xb8, 0x4e, 0x0, 0x97, 0x0, 0x3f, 0x0, 0xb8,
    0x4e, 0x0, 0x97, 0x0, 0x3f, 0x0, 0xb8, 0x4e,
    0x0, 0x97, 0x0, 0x3f, 0x0, 0xb8, 0x4e, 0x0,
    0x9f, 0xff, 0xff, 0x0, 0xb8, 0x4e, 0x0, 0x98,
    0x22, 0x22, 0x0, 0xb8, 0x4e, 0x0, 0x11, 0x0,
    0x0, 0x0, 0xb8, 0x4e, 0x0, 0x0, 0x0, 0x0,
    0x22, 0xc8, 0x4e, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+96FB "電" */
    0x7, 0x99, 0x99, 0xec, 0x99, 0x99, 0x70, 0x0,
    0x0, 0x0, 0xc, 0x60, 0x0, 0x0, 0x0, 0xce,
    0xee, 0xee, 0xff, 0xee, 0xee, 0xeb, 0xe, 0x22,
    0x22, 0xc, 0x61, 0x22, 0x15, 0xc0, 0xe2, 0x9a,
    0xa4, 0xc6, 0x7a, 0xa6, 0x5c, 0x3, 0x3a, 0xaa,
    0x4c, 0x68, 0xaa, 0xa2, 0x30, 0x0, 0x11, 0x10,
    0x84, 0x11, 0x11, 0x0, 0x0, 0x5f, 0xee, 0xee,
    0xee, 0xee, 0xe6, 0x0, 0x6, 0xa0, 0x0, 0xd5,
    0x0, 0xd, 0x70, 0x0, 0x6f, 0xdd, 0xdf, 0xed,
    0xdd, 0xf7, 0x0, 0x6, 0xa0, 0x0, 0xd5, 0x0,
    0xd, 0x70, 0x0, 0x6f, 0xee, 0xef, 0xfe, 0xee,
    0xf7, 0x62, 0x5, 0x80, 0x0, 0xd6, 0x0, 0x0,
    0xd, 0x40, 0x0, 0x0, 0x7, 0xef, 0xff, 0xff,
    0xb0,

    /* U+9759 "静" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0xd, 0xee, 0xfe, 0xea, 0xe, 0xff, 0xf6, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x89, 0x3, 0xf1, 0x0,
    0x8, 0xde, 0xfd, 0xda, 0xe3, 0x3d, 0x82, 0x10,
    0x0, 0x3, 0xe0, 0x2, 0xff, 0xff, 0xff, 0x80,
    0x2e, 0xee, 0xee, 0xec, 0x11, 0xd5, 0x1a, 0x80,
    0x1, 0x33, 0x33, 0x32, 0x33, 0xd7, 0x3a, 0x91,
    0x6, 0xeb, 0xbc, 0xf9, 0xdd, 0xfe, 0xde, 0xe6,
    0x6, 0xb2, 0x23, 0xf0, 0x0, 0xc5, 0x9, 0x80,
    0x6, 0xeb, 0xbb, 0xf0, 0x66, 0xe9, 0x6c, 0x80,
    0x6, 0xb2, 0x23, 0xf0, 0xaa, 0xec, 0xad, 0x80,
    0x6, 0xeb, 0xbc, 0xf0, 0x0, 0xc5, 0x0, 0x0,
    0x6, 0xa0, 0x1, 0xf0, 0x1, 0xd4, 0x0, 0x0,
    0x6, 0xa0, 0x7f, 0xb0, 0x9f, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+975C "靜" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x35, 0x79, 0xdf, 0x50,
    0xd, 0xee, 0xfe, 0xeb, 0xa9, 0xa5, 0x21, 0x40,
    0x0, 0x3, 0xe0, 0x4, 0xa0, 0xc4, 0x6, 0xc0,
    0x8, 0xde, 0xfd, 0xd5, 0xe2, 0x79, 0xd, 0x40,
    0x3, 0x35, 0xf3, 0x32, 0x85, 0x44, 0x5c, 0x10,
    0x2a, 0xaa, 0xaa, 0xa9, 0xcc, 0xfc, 0xce, 0x80,
    0x1, 0x33, 0x33, 0x30, 0x0, 0xe3, 0x9, 0x80,
    0x6, 0xeb, 0xbc, 0xf7, 0x88, 0xfa, 0x8d, 0xc3,
    0x6, 0xb2, 0x23, 0xf6, 0x77, 0xf9, 0x7c, 0xb3,
    0x6, 0xeb, 0xbb, 0xf0, 0x0, 0xe4, 0x9, 0x80,
    0x6, 0xb2, 0x23, 0xf0, 0xff, 0xff, 0xff, 0x80,
    0x6, 0xeb, 0xbc, 0xf0, 0x0, 0xe3, 0x3, 0x30,
    0x6, 0xa0, 0x1, 0xf0, 0x0, 0xe3, 0x0, 0x0,
    0x6, 0xa0, 0x7f, 0xb0, 0x9f, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+97F3 "音" */
    0x0, 0x0, 0x0, 0x6, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x11, 0xb6, 0x11, 0x11, 0x4d, 0x31, 0x0,
    0x0, 0x0, 0x8c, 0x0, 0x0, 0x9c, 0x0, 0x0,
    0x2, 0x22, 0x5f, 0x22, 0x22, 0xf6, 0x22, 0x20,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0xe, 0x51, 0x11, 0x11, 0x13, 0xf1, 0x0,
    0x0, 0xe, 0x50, 0x0, 0x0, 0x3, 0xf1, 0x0,
    0x0, 0xe, 0xfe, 0xee, 0xee, 0xef, 0xf1, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x0, 0x2, 0xf1, 0x0,
    0x0, 0xe, 0x40, 0x0, 0x0, 0x3, 0xf1, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+97FF "響" */
    0x0, 0x5, 0x0, 0x7, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xa6, 0x64, 0xfb, 0xbe, 0x5f, 0xee, 0xf1,
    0x9, 0xa7, 0xa3, 0xc0, 0xa, 0x5f, 0x16, 0x90,
    0x7, 0xcb, 0x16, 0xfb, 0xbe, 0x5f, 0x1d, 0x20,
    0x8, 0xe8, 0xba, 0xe7, 0x7c, 0x5f, 0x14, 0xc0,
    0x6, 0x58, 0xd4, 0xd4, 0x8f, 0x2f, 0x10, 0xb4,
    0x1, 0x9d, 0x19, 0xfd, 0xa8, 0xaf, 0x5d, 0xc1,
    0xd, 0x80, 0x2, 0x19, 0xa0, 0x8, 0x0, 0x0,
    0x0, 0x6d, 0xdf, 0xdd, 0xdd, 0xee, 0xda, 0x0,
    0x0, 0x0, 0x2e, 0x20, 0x1, 0xe3, 0x0, 0x0,
    0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd2,
    0x0, 0x6, 0x77, 0x77, 0x77, 0x77, 0x70, 0x0,
    0x0, 0xd, 0x64, 0x44, 0x44, 0x45, 0xf0, 0x0,
    0x0, 0xd, 0xba, 0xaa, 0xaa, 0xaa, 0xf0, 0x0,
    0x0, 0xd, 0xcb, 0xbb, 0xbb, 0xbb, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+AC00 "가" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x5e, 0xee, 0xee, 0xf4, 0x5, 0xf0, 0x0, 0x1,
    0x33, 0x33, 0x4f, 0x30, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf0, 0x5, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x8c, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x70, 0x5, 0xf2, 0x20, 0x0, 0x0, 0x7,
    0xe1, 0x0, 0x5f, 0xff, 0x40, 0x0, 0x4, 0xf6,
    0x0, 0x5, 0xf0, 0x0, 0x0, 0x4, 0xf9, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x8, 0xf9, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0xc, 0xe5, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0,

    /* U+AC04 "간" */
    0x1, 0x11, 0x11, 0x12, 0x0, 0x5f, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0xf5, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xe0, 0x5, 0xf0, 0x0, 0x0, 0x0,
    0x2, 0xf6, 0x0, 0x5f, 0xff, 0x10, 0x0, 0x2,
    0xeb, 0x0, 0x5, 0xf2, 0x20, 0x0, 0x7, 0xfa,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x9e, 0xe6, 0x0,
    0x0, 0x5, 0xf0, 0x0, 0x9, 0x60, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x93, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0,
    0x13, 0x0, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0,

    /* U+AC10 "감" */
    0x1, 0x11, 0x11, 0x12, 0x0, 0x4f, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xf4, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x10, 0x4f, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xb0, 0x4, 0xff, 0xf2, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0x4f, 0x32, 0x0, 0x0, 0x2a,
    0xf5, 0x0, 0x4, 0xf0, 0x0, 0x5, 0xaf, 0xc2,
    0x0, 0x0, 0x4f, 0x0, 0x0, 0xda, 0x40, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x1f, 0x30, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x1f, 0x41, 0x11, 0x11, 0x5f,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0,

    /* U+AC70 "거" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x5e, 0xee,
    0xee, 0xf3, 0x0, 0x9b, 0x13, 0x33, 0x34, 0xf2,
    0x0, 0x9b, 0x0, 0x0, 0x4, 0xf0, 0x0, 0x9b,
    0x0, 0x0, 0x8, 0xc0, 0x0, 0x9b, 0x0, 0x0,
    0xe, 0x73, 0x33, 0xab, 0x0, 0x0, 0x7f, 0x1e,
    0xee, 0xfb, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x9b,
    0x0, 0x3e, 0xa0, 0x0, 0x0, 0x9b, 0x7, 0xf9,
    0x0, 0x0, 0x0, 0x9b, 0xbe, 0x50, 0x0, 0x0,
    0x0, 0x9b, 0x21, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9b,

    /* U+ACAC "견" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x3, 0xee,
    0xee, 0xef, 0x50, 0x9, 0xb0, 0x2, 0x22, 0x23,
    0xf6, 0x22, 0xab, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x1e, 0x80, 0x0, 0x9b,
    0x0, 0x0, 0x1c, 0xc0, 0x0, 0x9, 0xb0, 0x0,
    0x5e, 0xc1, 0x6f, 0xff, 0xfb, 0x5, 0xcf, 0x70,
    0x0, 0x11, 0x1a, 0xb0, 0x77, 0x10, 0x0, 0x0,
    0x0, 0x9b, 0x0, 0x3, 0x70, 0x0, 0x0, 0x9,
    0xb0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x56, 0x0,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xf1,

    /* U+ACB0 "결" */
    0xf, 0xff, 0xff, 0xf6, 0x0, 0x7e, 0x0, 0x11,
    0x11, 0x2f, 0x51, 0x18, 0xe0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0xc9, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0xad, 0x12, 0x22, 0x8e,
    0x0, 0x3, 0xcd, 0x23, 0xee, 0xef, 0xe0, 0x5c,
    0xf8, 0x0, 0x0, 0x0, 0x7e, 0x4, 0x61, 0x22,
    0x22, 0x22, 0x24, 0x70, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0x5d, 0xdd, 0xdd, 0xdd, 0xee, 0x0,
    0x6, 0xe2, 0x22, 0x22, 0x22, 0x20, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfa, 0xaa,
    0xaa, 0xaa, 0xa3,

    /* U+ACBD "경" */
    0x0, 0x11, 0x11, 0x13, 0x0, 0xa, 0xb0, 0x3c,
    0xcc, 0xcc, 0xf5, 0x0, 0xab, 0x0, 0x0, 0x0,
    0x2f, 0xdc, 0xce, 0xb0, 0x0, 0x0, 0x8, 0xd4,
    0x44, 0xbb, 0x0, 0x0, 0x4, 0xf5, 0x0, 0xa,
    0xb0, 0x0, 0x6, 0xf8, 0x5c, 0xcc, 0xeb, 0x0,
    0x5c, 0xe5, 0x2, 0x55, 0x5c, 0xb0, 0xce, 0x81,
    0x0, 0x0, 0x0, 0xab, 0x1, 0x0, 0x0, 0x13,
    0x31, 0x2, 0x20, 0x0, 0x7, 0xef, 0xee, 0xfe,
    0x70, 0x0, 0x8, 0xe4, 0x0, 0x0, 0x4e, 0x80,
    0x0, 0xc9, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x6,
    0xf7, 0x31, 0x13, 0x7f, 0x60, 0x0, 0x4, 0xae,
    0xff, 0xea, 0x40,

    /* U+ACE0 "고" */
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x12, 0x22, 0x22, 0x22, 0x2f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x20,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x1, 0xf3, 0x0,
    0x1f, 0x40, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x3f,
    0x20, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x5f, 0x0,
    0x0, 0x0, 0x1, 0xf3, 0x0, 0x13, 0x0, 0x0,
    0x0, 0x1, 0xf3, 0x0, 0x0, 0x0, 0x2e, 0xee,
    0xee, 0xfe, 0xee, 0xee, 0xec, 0x3, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x33,

    /* U+ACF5 "공" */
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x1, 0x11, 0x11, 0x11, 0x1f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x41, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0xe6, 0x0,
    0x28, 0x0, 0x28, 0x88, 0x88, 0xfb, 0x88, 0x88,
    0x86, 0x29, 0x99, 0x99, 0x99, 0x99, 0x99, 0x97,
    0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xbf, 0xfe, 0xfe, 0xa2, 0x0, 0x0, 0x7f,
    0x61, 0x0, 0x2, 0x8f, 0x20, 0x0, 0xb9, 0x0,
    0x0, 0x0, 0xe, 0x60, 0x0, 0x6f, 0x73, 0x10,
    0x14, 0xaf, 0x20, 0x0, 0x4, 0xad, 0xff, 0xfd,
    0x92, 0x0,

    /* U+ACFC "과" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x7d, 0xdd, 0xdd, 0xea, 0x7, 0xe0, 0x0, 0x1,
    0x33, 0x33, 0x3a, 0xb0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9b, 0x7, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xa0, 0x7e, 0x0, 0x0, 0x0, 0x15,
    0x0, 0xb9, 0x7, 0xe3, 0x30, 0x0, 0x4, 0xf0,
    0xc, 0x80, 0x7f, 0xff, 0x20, 0x0, 0x4f, 0x0,
    0xc5, 0x7, 0xe0, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x12,
    0x37, 0xe0, 0x0, 0x4e, 0xef, 0xff, 0xff, 0xd8,
    0x7e, 0x0, 0x0, 0x33, 0x32, 0x10, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x0,

    /* U+AD6C "구" */
    0x0, 0x1, 0x11, 0x11, 0x11, 0x12, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x30, 0x1, 0x11, 0x11, 0x11, 0x11, 0x6f,
    0x21, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0,
    0x0, 0x0,

    /* U+ADF8 "그" */
    0x0, 0xbe, 0xee, 0xee, 0xee, 0xff, 0x10, 0x0,
    0x22, 0x22, 0x22, 0x22, 0x5f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x77, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22,

    /* U+AE30 "기" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x5e,
    0xee, 0xee, 0xf5, 0x0, 0x7e, 0x1, 0x33, 0x33,
    0x3f, 0x50, 0x7, 0xe0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0xd, 0x80, 0x0, 0x7e, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x7, 0xe0, 0x0, 0x4,
    0xf6, 0x0, 0x0, 0x7e, 0x0, 0x5, 0xf9, 0x0,
    0x0, 0x7, 0xe0, 0x1a, 0xf8, 0x0, 0x0, 0x0,
    0x7e, 0xc, 0xd4, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7e,

    /* U+B044 "끄" */
    0x2, 0xdd, 0xdd, 0x75, 0xdd, 0xdd, 0x50, 0x0,
    0x44, 0x4d, 0x81, 0x44, 0x4e, 0x60, 0x0, 0x0,
    0xc, 0x80, 0x0, 0xe, 0x60, 0x0, 0x0, 0xd,
    0x70, 0x0, 0xf, 0x50, 0x0, 0x0, 0xf, 0x50,
    0x0, 0xf, 0x40, 0x0, 0x0, 0x2f, 0x30, 0x0,
    0x1f, 0x30, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x4f,
    0x10, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x23, 0x0, 0x0, 0x24, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11,

    /* U+B098 "나" */
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x5, 0xf0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x5, 0xf0, 0x0, 0x6e, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0x31, 0x6e, 0x0, 0x0, 0x0, 0x5, 0xfd,
    0xd4, 0x6e, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0,
    0x6e, 0x0, 0x0, 0x2, 0x15, 0xf0, 0x0, 0x7f,
    0xbb, 0xce, 0xff, 0x65, 0xf0, 0x0, 0x26, 0x65,
    0x43, 0x10, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0,

    /* U+B124 "네" */
    0x0, 0x0, 0x0, 0x0, 0xf4, 0x1f, 0x34, 0xa0,
    0x0, 0x0, 0xf, 0x41, 0xf3, 0x6e, 0x0, 0x0,
    0x0, 0xf4, 0x1f, 0x36, 0xe0, 0x0, 0x0, 0xf,
    0x41, 0xf3, 0x6e, 0x0, 0x2, 0x22, 0xf4, 0x1f,
    0x36, 0xe0, 0x3, 0xff, 0xff, 0x41, 0xf3, 0x6e,
    0x0, 0x0, 0x0, 0xf4, 0x1f, 0x36, 0xe0, 0x0,
    0x0, 0xf, 0x41, 0xf3, 0x6e, 0x0, 0x0, 0x0,
    0xf4, 0x1f, 0x37, 0xf9, 0x9b, 0xcc, 0xf, 0x41,
    0xf3, 0x39, 0x98, 0x75, 0x20, 0xf4, 0x1f, 0x30,
    0x0, 0x0, 0x0, 0xf, 0x41, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xf4, 0x1f, 0x30, 0x0, 0x0, 0x0,
    0xb, 0x31, 0xf3,

    /* U+B155 "녕" */
    0x5f, 0x0, 0x0, 0x0, 0x0, 0xab, 0x5f, 0x0,
    0x0, 0x8c, 0xcc, 0xeb, 0x5f, 0x0, 0x0, 0x34,
    0x44, 0xbb, 0x5f, 0x0, 0x0, 0x0, 0x0, 0xab,
    0x5f, 0x0, 0x0, 0xaf, 0xff, 0xfb, 0x5f, 0x0,
    0x0, 0x1, 0x11, 0xab, 0x6f, 0x77, 0x89, 0xbd,
    0x20, 0xab, 0x3a, 0xaa, 0x98, 0x74, 0x0, 0xab,
    0x0, 0x0, 0x1, 0x22, 0x10, 0x67, 0x0, 0x8,
    0xef, 0xde, 0xfd, 0x70, 0x0, 0xad, 0x30, 0x0,
    0x4, 0xe7, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x9b,
    0x0, 0x8e, 0x62, 0x11, 0x37, 0xf6, 0x0, 0x5,
    0xbe, 0xff, 0xea, 0x40,

    /* U+B294 "는" */
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xee, 0xee,
    0xee, 0xee, 0x50, 0x0, 0x13, 0x33, 0x33, 0x33,
    0x33, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x0,
    0x35, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8c,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8d, 0x44, 0x44,
    0x44, 0x44, 0x20, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0x70,

    /* U+B2A5 "능" */
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x1, 0x11, 0x11, 0x11,
    0x11, 0x0, 0x3, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdc,
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xbe, 0xff, 0xfe, 0x92, 0x0, 0x0, 0x5f,
    0x72, 0x0, 0x3, 0xae, 0x10, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x4f, 0x83, 0x10,
    0x14, 0xbe, 0x0, 0x0, 0x3, 0xad, 0xff, 0xfc,
    0x81, 0x0,

    /* U+B2C8 "니" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x4f, 0x0,
    0x0, 0x0, 0x0, 0xe6, 0x4f, 0x0, 0x0, 0x0,
    0x0, 0xe6, 0x4f, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x4f, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x4f, 0x0,
    0x0, 0x0, 0x0, 0xe6, 0x4f, 0x0, 0x0, 0x0,
    0x0, 0xe6, 0x4f, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x4f, 0x0, 0x0, 0x14, 0x40, 0xe6, 0x4f, 0xcd,
    0xef, 0xfe, 0x90, 0xe6, 0x15, 0x55, 0x42, 0x10,
    0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe6,

    /* U+B2E4 "다" */
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x5f,
    0xff, 0xff, 0xf4, 0x5, 0xf0, 0x0, 0x6e, 0x22,
    0x22, 0x20, 0x5, 0xf0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x5, 0xf0, 0x0, 0x6e, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x5,
    0xf4, 0x41, 0x6e, 0x0, 0x0, 0x0, 0x5, 0xfc,
    0xc4, 0x6e, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x7f,
    0x88, 0x9a, 0xbd, 0x65, 0xf0, 0x0, 0x39, 0x99,
    0x87, 0x64, 0x15, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0,

    /* U+B2F5 "답" */
    0x1, 0x11, 0x11, 0x10, 0x2, 0xf2, 0x0, 0x6f,
    0xff, 0xff, 0xe0, 0x2, 0xf2, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x2, 0xf2, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xf4, 0x6e, 0x0, 0x0, 0x0,
    0x2, 0xf4, 0x20, 0x6e, 0x0, 0x1, 0x25, 0x22,
    0xf2, 0x0, 0x7f, 0xff, 0xff, 0xfd, 0x42, 0xf2,
    0x0, 0x2, 0x21, 0x10, 0x0, 0x0, 0x61, 0x0,
    0x0, 0xb4, 0x0, 0x0, 0x1, 0xc2, 0x0, 0x0,
    0xf5, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0xf6, 0x11,
    0x11, 0x14, 0xf2, 0x0, 0x0, 0xf6, 0x11, 0x11,
    0x13, 0xf2, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x0,

    /* U+B300 "대" */
    0x0, 0x0, 0x0, 0xb, 0x80, 0x6d, 0x34, 0x44,
    0x41, 0xb, 0x80, 0x6d, 0xee, 0xdd, 0xd6, 0xb,
    0x80, 0x6d, 0xe6, 0x0, 0x0, 0xb, 0x80, 0x6d,
    0xe6, 0x0, 0x0, 0xb, 0x80, 0x6d, 0xe6, 0x0,
    0x0, 0xb, 0xa3, 0x8d, 0xe6, 0x0, 0x0, 0xb,
    0xfe, 0xfd, 0xe6, 0x0, 0x0, 0xb, 0x80, 0x6d,
    0xe6, 0x0, 0x0, 0xb, 0x80, 0x6d, 0xfb, 0x89,
    0xac, 0x4b, 0x80, 0x6d, 0x89, 0x98, 0x75, 0x1b,
    0x80, 0x6d, 0x0, 0x0, 0x0, 0xb, 0x80, 0x6d,
    0x0, 0x0, 0x0, 0xb, 0x80, 0x6d, 0x0, 0x0,
    0x0, 0x7, 0x60, 0x6d,

    /* U+B3C4 "도" */
    0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x77,
    0x77, 0x77, 0x77, 0x40, 0x0, 0x4, 0x99, 0x9b,
    0xfa, 0x99, 0x95, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x10,
    0x0, 0x0, 0x0, 0xbb, 0xbb, 0xbc, 0xfb, 0xbb,
    0xbb, 0xb0, 0x6, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x0,

    /* U+B428 "됨" */
    0x0, 0xef, 0xff, 0xff, 0xf0, 0xe, 0x60, 0xe,
    0x71, 0x11, 0x11, 0x0, 0xe6, 0x0, 0xe6, 0x0,
    0x0, 0x0, 0xe, 0x60, 0xf, 0x82, 0x22, 0x22,
    0x0, 0xe6, 0x0, 0xff, 0xff, 0xff, 0xf2, 0xe,
    0x60, 0x0, 0x2, 0xf3, 0x0, 0x0, 0xe6, 0x0,
    0x0, 0x2f, 0x31, 0x35, 0xe, 0x61, 0xee, 0xef,
    0xff, 0xed, 0xa0, 0xe6, 0x2, 0x22, 0x11, 0x0,
    0x0, 0xb, 0x40, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0xe, 0x72, 0x22, 0x22, 0x2e, 0x60,
    0x0, 0xe6, 0x0, 0x0, 0x0, 0xe6, 0x0, 0xe,
    0x71, 0x11, 0x11, 0x1e, 0x60, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xf6,

    /* U+B4C8 "듈" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0,
    0x4f, 0x21, 0x11, 0x11, 0x11, 0x0, 0x0, 0x4f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa9,
    0x99, 0x99, 0x99, 0x30, 0x0, 0x17, 0x77, 0x77,
    0x77, 0x77, 0x20, 0x3, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x32, 0x2e, 0xee, 0xff, 0xee, 0xef, 0xfe,
    0xec, 0x0, 0x0, 0x7d, 0x0, 0xe, 0x60, 0x0,
    0x0, 0x4a, 0xdf, 0xaa, 0xaf, 0xca, 0x20, 0x0,
    0x25, 0x55, 0x55, 0x55, 0x6f, 0x30, 0x0, 0x2,
    0x22, 0x22, 0x22, 0x4f, 0x30, 0x0, 0x6f, 0xdd,
    0xdd, 0xdd, 0xdd, 0x20, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xd0,

    /* U+B4DC "드" */
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x8c, 0x22, 0x22, 0x22, 0x22, 0x0, 0x0, 0x8c,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x77, 0x77, 0x77,
    0x77, 0x30, 0x0, 0x59, 0x99, 0x99, 0x99, 0x99,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22,

    /* U+B4E3 "듣" */
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x7d, 0x11, 0x11, 0x11, 0x11, 0x0, 0x0, 0x7d,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x1, 0x11, 0x11, 0x11,
    0x11, 0x0, 0x3, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x2e, 0xee, 0xee, 0xee, 0xee, 0xee, 0xed,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x8d,
    0x22, 0x22, 0x22, 0x22, 0x0, 0x0, 0x8c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0x70,

    /* U+B529 "딩" */
    0x1, 0x11, 0x11, 0x10, 0x0, 0xe7, 0x5f, 0xff,
    0xff, 0xf7, 0x0, 0xe7, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x5f, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x5f, 0x0,
    0x0, 0x1, 0x30, 0xe7, 0x5f, 0xdd, 0xde, 0xff,
    0xb0, 0xe7, 0x14, 0x44, 0x32, 0x10, 0x0, 0xe7,
    0x0, 0x0, 0x1, 0x22, 0x0, 0xc6, 0x0, 0x19,
    0xff, 0xde, 0xfc, 0x40, 0x0, 0xcc, 0x20, 0x0,
    0x6, 0xf4, 0x0, 0xf6, 0x0, 0x0, 0x0, 0xe7,
    0x0, 0xae, 0x62, 0x11, 0x3a, 0xf2, 0x0, 0x6,
    0xce, 0xff, 0xd9, 0x20,

    /* U+B808 "레" */
    0x0, 0x0, 0x0, 0x8, 0xb0, 0x5e, 0xcd, 0xdd,
    0xd2, 0x8, 0xb0, 0x5e, 0x33, 0x34, 0xf3, 0x8,
    0xb0, 0x5e, 0x0, 0x1, 0xf3, 0x8, 0xb0, 0x5e,
    0x0, 0x1, 0xf4, 0x4a, 0xb0, 0x5e, 0xde, 0xee,
    0xf7, 0xde, 0xb0, 0x5e, 0xe7, 0x22, 0x20, 0x8,
    0xb0, 0x5e, 0xe5, 0x0, 0x0, 0x8, 0xb0, 0x5e,
    0xe5, 0x0, 0x0, 0x8, 0xb0, 0x5e, 0xfa, 0x78,
    0xac, 0x38, 0xb0, 0x5e, 0x9a, 0x99, 0x75, 0x18,
    0xb0, 0x5e, 0x0, 0x0, 0x0, 0x8, 0xb0, 0x5e,
    0x0, 0x0, 0x0, 0x8, 0xb0, 0x5e, 0x0, 0x0,
    0x0, 0x4, 0x50, 0x5e,

    /* U+B824 "려" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd7, 0xbc, 0xcc,
    0xcc, 0x40, 0x0, 0xd7, 0x33, 0x33, 0x3f, 0x60,
    0x0, 0xd7, 0x0, 0x0, 0xe, 0x6a, 0xff, 0xf7,
    0x0, 0x0, 0xe, 0x61, 0x22, 0xe7, 0xbd, 0xdd,
    0xdf, 0x60, 0x0, 0xd7, 0xe9, 0x44, 0x44, 0x10,
    0x0, 0xd7, 0xe7, 0x0, 0x0, 0xc, 0xff, 0xf7,
    0xe7, 0x0, 0x0, 0x1, 0x22, 0xe7, 0xe9, 0x45,
    0x67, 0x85, 0x0, 0xd7, 0xbd, 0xdc, 0xba, 0x94,
    0x0, 0xd7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd7,

    /* U+B85C "로" */
    0x0, 0x2, 0x22, 0x22, 0x22, 0x22, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe6, 0x0, 0x0, 0x5f,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x6, 0xe1,
    0x11, 0x11, 0x11, 0x10, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf7, 0x77,
    0x77, 0x77, 0x76, 0x0, 0x0, 0x4a, 0xaa, 0xbf,
    0xba, 0xaa, 0x80, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x20,
    0x0, 0x0, 0x0, 0xaa, 0xaa, 0xab, 0xfb, 0xaa,
    0xaa, 0xa0, 0x7, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x0,

    /* U+B958 "류" */
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x11, 0x11, 0x11, 0x11, 0xb8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0x80, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x6e,
    0x11, 0x11, 0x11, 0x11, 0x0, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x0, 0x29, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x31, 0x77, 0x7c, 0xe7, 0x77,
    0xbf, 0x77, 0x72, 0x0, 0x0, 0x9c, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x0, 0x9, 0xc0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x9, 0xc0, 0x0, 0x6e, 0x0,
    0x0,

    /* U+B968 "륨" */
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x14,
    0x44, 0x44, 0x44, 0x4f, 0x50, 0x0, 0x6f, 0xcc,
    0xcc, 0xcc, 0xcc, 0x30, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x1, 0x12, 0x22, 0x22, 0x22, 0x22,
    0x11, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x8b, 0x0, 0xe, 0x60, 0x0, 0x0,
    0x28, 0xce, 0x88, 0x8f, 0xb8, 0x20, 0x0, 0x5f,
    0x88, 0x88, 0x88, 0x8f, 0x50, 0x0, 0x5f, 0x0,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x5f, 0x11, 0x11,
    0x11, 0x1f, 0x50, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0x50,

    /* U+B97C "를" */
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x30, 0x0, 0x7e,
    0xee, 0xee, 0xee, 0xef, 0x30, 0x0, 0x8c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0x88, 0x88,
    0x88, 0x88, 0x40, 0x0, 0x36, 0x66, 0x66, 0x66,
    0x66, 0x30, 0x4, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x2b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xba,
    0x0, 0x12, 0x22, 0x22, 0x22, 0x22, 0x0, 0x0,
    0x8d, 0xdd, 0xdd, 0xdd, 0xdf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x9f, 0xee,
    0xee, 0xee, 0xee, 0x40, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xee, 0xee, 0xee,
    0xee, 0xa0,

    /* U+B9AC "리" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x6f, 0xff,
    0xff, 0xf4, 0x0, 0xe7, 0x2, 0x22, 0x23, 0xf4,
    0x0, 0xe7, 0x0, 0x0, 0x1, 0xf4, 0x0, 0xe7,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0xe7, 0x5f, 0xff,
    0xff, 0xf4, 0x0, 0xe7, 0x6f, 0x22, 0x22, 0x20,
    0x0, 0xe7, 0x6f, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0x6f, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x6f, 0x67,
    0x78, 0x9b, 0xc0, 0xe7, 0x4b, 0xaa, 0x99, 0x75,
    0x30, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe7,

    /* U+B9D0 "말" */
    0x6f, 0xff, 0xff, 0xf4, 0x1, 0xf4, 0x0, 0x6e,
    0x11, 0x11, 0xf4, 0x1, 0xf4, 0x0, 0x6e, 0x0,
    0x0, 0xf4, 0x1, 0xf5, 0x10, 0x6e, 0x0, 0x0,
    0xf4, 0x1, 0xff, 0xf2, 0x6e, 0x0, 0x0, 0xf4,
    0x1, 0xf4, 0x0, 0x6f, 0xee, 0xee, 0xf4, 0x1,
    0xf4, 0x0, 0x12, 0x22, 0x22, 0x20, 0x1, 0xf4,
    0x0, 0x0, 0x11, 0x11, 0x11, 0x11, 0x30, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0xcd,
    0xdd, 0xdd, 0xdd, 0xf4, 0x0, 0x0, 0xe7, 0x22,
    0x22, 0x22, 0x20, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0,

    /* U+BAA8 "모" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x3f, 0x10, 0x0, 0xe6, 0x0,
    0x0, 0x0, 0x3f, 0x10, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x3f, 0x10, 0x0, 0xe6, 0x0, 0x0, 0x0,
    0x3f, 0x10, 0x0, 0xe9, 0x44, 0x44, 0x44, 0x6f,
    0x10, 0x0, 0xac, 0xcc, 0xdf, 0xcc, 0xcc, 0x10,
    0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x3b, 0xbb, 0xbb,
    0xdf, 0xbb, 0xbb, 0xb9, 0x16, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x65,

    /* U+BC1C "발" */
    0x6e, 0x0, 0x0, 0xf5, 0x1, 0xf4, 0x0, 0x6e,
    0x0, 0x0, 0xf5, 0x1, 0xf4, 0x0, 0x6f, 0xaa,
    0xaa, 0xf5, 0x1, 0xf5, 0x10, 0x6f, 0x77, 0x77,
    0xf5, 0x1, 0xff, 0xf2, 0x6e, 0x0, 0x0, 0xf5,
    0x1, 0xf4, 0x0, 0x6e, 0x22, 0x22, 0xf5, 0x1,
    0xf4, 0x0, 0x5e, 0xee, 0xee, 0xe4, 0x1, 0xf4,
    0x0, 0x0, 0x11, 0x11, 0x11, 0x11, 0x51, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0xbc,
    0xcc, 0xcc, 0xcc, 0xf4, 0x0, 0x0, 0xe8, 0x33,
    0x33, 0x33, 0x30, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0,

    /* U+BC30 "배" */
    0x0, 0x0, 0x0, 0x9, 0xa0, 0x7d, 0x93, 0x0,
    0x48, 0x9, 0xa0, 0x7d, 0xe5, 0x0, 0x6d, 0x9,
    0xa0, 0x7d, 0xe5, 0x0, 0x6d, 0x9, 0xa0, 0x7d,
    0xe6, 0x11, 0x7d, 0x9, 0xa0, 0x7d, 0xef, 0xff,
    0xfd, 0x9, 0xc4, 0x9d, 0xe5, 0x0, 0x6d, 0x9,
    0xfd, 0xed, 0xe5, 0x0, 0x6d, 0x9, 0xa0, 0x7d,
    0xe5, 0x0, 0x6d, 0x9, 0xa0, 0x7d, 0xe8, 0x33,
    0x8d, 0x9, 0xa0, 0x7d, 0xcd, 0xdd, 0xdb, 0x9,
    0xa0, 0x7d, 0x0, 0x0, 0x0, 0x9, 0xa0, 0x7d,
    0x0, 0x0, 0x0, 0x9, 0xa0, 0x7d, 0x0, 0x0,
    0x0, 0x7, 0x70, 0x7d,

    /* U+BC84 "버" */
    0x12, 0x0, 0x0, 0x21, 0x0, 0x6e, 0x6e, 0x0,
    0x0, 0xd7, 0x0, 0x6e, 0x6e, 0x0, 0x0, 0xd7,
    0x0, 0x6e, 0x6e, 0x0, 0x0, 0xd7, 0x0, 0x6e,
    0x6f, 0x77, 0x77, 0xe7, 0x0, 0x6e, 0x6f, 0xaa,
    0xaa, 0xff, 0xff, 0xfe, 0x6e, 0x0, 0x0, 0xd8,
    0x22, 0x7e, 0x6e, 0x0, 0x0, 0xd7, 0x0, 0x6e,
    0x6e, 0x0, 0x0, 0xd7, 0x0, 0x6e, 0x6f, 0x44,
    0x44, 0xe7, 0x0, 0x6e, 0x5d, 0xdd, 0xdd, 0xd5,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6e,

    /* U+BCF4 "보" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe7, 0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0xee, 0xdd,
    0xdd, 0xdd, 0xef, 0x20, 0x0, 0xe9, 0x33, 0x33,
    0x33, 0x6f, 0x20, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0x3f, 0x20, 0x0, 0xe7, 0x0, 0x0, 0x0, 0x3f,
    0x20, 0x0, 0xed, 0xbb, 0xbb, 0xbb, 0xcf, 0x20,
    0x0, 0x56, 0x66, 0xaf, 0x66, 0x66, 0x0, 0x0,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x3b, 0xbb, 0xbb,
    0xdf, 0xbb, 0xbb, 0xb9, 0x16, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x65,

    /* U+BCFC "볼" */
    0x4, 0xf0, 0x0, 0x0, 0x0, 0xf5, 0x0, 0x4,
    0xfd, 0xdd, 0xdd, 0xdd, 0xf5, 0x0, 0x4, 0xf2,
    0x22, 0x22, 0x22, 0xf5, 0x0, 0x4, 0xf4, 0x44,
    0x44, 0x44, 0xf5, 0x0, 0x3, 0xcc, 0xcd, 0xfd,
    0xcc, 0xc4, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x0,
    0x0, 0x0, 0xdd, 0xdd, 0xdd, 0xfd, 0xdd, 0xdd,
    0xd1, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30,
    0x5, 0xcc, 0xcc, 0xcc, 0xcc, 0xc5, 0x0, 0x1,
    0x33, 0x33, 0x33, 0x33, 0xe6, 0x0, 0x0, 0x11,
    0x11, 0x11, 0x11, 0xe6, 0x0, 0x6, 0xfe, 0xee,
    0xee, 0xee, 0xe5, 0x0, 0x6, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0,

    /* U+BD80 "부" */
    0x0, 0x6e, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x6f, 0xee, 0xee, 0xee, 0xef, 0x60, 0x0, 0x6,
    0xf3, 0x33, 0x33, 0x33, 0xf6, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x6, 0xf4,
    0x44, 0x44, 0x44, 0xf6, 0x0, 0x0, 0x5d, 0xdd,
    0xdd, 0xdd, 0xdd, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x0, 0x99, 0x99, 0x9a, 0xfa,
    0x99, 0x99, 0x90, 0x0, 0x0, 0x0, 0x3f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf2, 0x0, 0x0,
    0x0,

    /* U+BE44 "비" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x5c, 0x0,
    0x0, 0xc5, 0x0, 0xe6, 0x6f, 0x0, 0x0, 0xe6,
    0x0, 0xe6, 0x6f, 0x0, 0x0, 0xe6, 0x0, 0xe6,
    0x6f, 0x11, 0x11, 0xe6, 0x0, 0xe6, 0x6f, 0xff,
    0xff, 0xf6, 0x0, 0xe6, 0x6f, 0x0, 0x0, 0xe6,
    0x0, 0xe6, 0x6f, 0x0, 0x0, 0xe6, 0x0, 0xe6,
    0x6f, 0x0, 0x0, 0xe6, 0x0, 0xe6, 0x6f, 0x22,
    0x22, 0xe6, 0x0, 0xe6, 0x5f, 0xff, 0xff, 0xf5,
    0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe6,

    /* U+C0AC "사" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x0, 0x5, 0xa0, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0x7d, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x7, 0xd0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0x0,
    0x7e, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0xa,
    0xf1, 0x0, 0x5, 0xf3, 0x31, 0x0, 0x1, 0xfe,
    0x70, 0x0, 0x5f, 0xff, 0x50, 0x0, 0x8c, 0x5e,
    0x10, 0x5, 0xf0, 0x0, 0x0, 0x4f, 0x40, 0xcb,
    0x0, 0x5f, 0x0, 0x0, 0x5f, 0x80, 0x2, 0xec,
    0x15, 0xf0, 0x0, 0xc, 0x80, 0x0, 0x2, 0xa0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0,

    /* U+C0BD "삽" */
    0x0, 0x0, 0xaa, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0xa, 0xa0, 0x0, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0,
    0x1f, 0xf3, 0x0, 0x4, 0xff, 0xf2, 0x0, 0x9,
    0xc9, 0xc0, 0x0, 0x4f, 0x32, 0x0, 0x7, 0xf3,
    0x1d, 0xc2, 0x4, 0xf0, 0x0, 0x1c, 0xf4, 0x0,
    0x1b, 0xe0, 0x4f, 0x0, 0x0, 0x61, 0x0, 0x0,
    0x1, 0x3, 0xa0, 0x0, 0x0, 0x1a, 0x20, 0x0,
    0x0, 0x3a, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x0,
    0x4, 0xf0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x1, 0xf4, 0x11, 0x11, 0x15,
    0xf0, 0x0, 0x0, 0x1f, 0x41, 0x11, 0x11, 0x5f,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0,

    /* U+C0C1 "상" */
    0x0, 0x0, 0xba, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0x0, 0x4, 0xf4, 0x40, 0x0, 0x6,
    0xee, 0x60, 0x0, 0x4f, 0xdd, 0x20, 0x1, 0xe6,
    0x5f, 0x40, 0x4, 0xf0, 0x0, 0x3, 0xeb, 0x0,
    0x8f, 0x80, 0x4f, 0x0, 0x1, 0xfa, 0x0, 0x0,
    0x59, 0x4, 0xf0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x2a, 0xef, 0xff,
    0xd9, 0x10, 0x0, 0x0, 0x1f, 0xa3, 0x0, 0x3,
    0xbd, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0x3,
    0xf2, 0x0, 0x0, 0x1e, 0xa4, 0x11, 0x14, 0xcd,
    0x0, 0x0, 0x0, 0x19, 0xdf, 0xff, 0xc8, 0x10,
    0x0,

    /* U+C0C8 "새" */
    0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0xf4, 0x0,
    0x2, 0xf1, 0x0, 0x5e, 0x0, 0xf4, 0x0, 0x2,
    0xf2, 0x0, 0x5e, 0x0, 0xf4, 0x0, 0x2, 0xf2,
    0x0, 0x5e, 0x0, 0xf4, 0x0, 0x3, 0xf2, 0x0,
    0x5e, 0x0, 0xf4, 0x0, 0x5, 0xf4, 0x0, 0x5e,
    0x33, 0xf4, 0x0, 0x9, 0xf8, 0x0, 0x5f, 0xee,
    0xf4, 0x0, 0xe, 0x8e, 0x0, 0x5e, 0x0, 0xf4,
    0x0, 0x8d, 0xd, 0x90, 0x5e, 0x0, 0xf4, 0x5,
    0xf4, 0x4, 0xf8, 0x6e, 0x0, 0xf4, 0x1f, 0x70,
    0x0, 0x5a, 0x5e, 0x0, 0xf4, 0x2, 0x0, 0x0,
    0x0, 0x5e, 0x0, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x5e, 0x0, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x4a,
    0x0, 0xf4,

    /* U+C11C "서" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x4f,
    0x10, 0x0, 0xa, 0xb0, 0x0, 0x4, 0xf1, 0x0,
    0x0, 0xab, 0x0, 0x0, 0x5f, 0x20, 0x22, 0x2b,
    0xb0, 0x0, 0x8, 0xf5, 0xf, 0xff, 0xfb, 0x0,
    0x0, 0xde, 0xa0, 0x0, 0xa, 0xb0, 0x0, 0x5f,
    0x3f, 0x30, 0x0, 0xab, 0x0, 0x2e, 0x70, 0xad,
    0x10, 0xa, 0xb0, 0x3e, 0xb0, 0x0, 0xdd, 0x20,
    0xab, 0xa, 0xa0, 0x0, 0x1, 0xa2, 0xa, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xab,

    /* U+C124 "설" */
    0x0, 0x0, 0x9c, 0x0, 0x0, 0x9, 0xd0, 0x0,
    0x0, 0x9c, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0,
    0xbe, 0x0, 0x9d, 0xde, 0xd0, 0x0, 0x2, 0xfe,
    0x60, 0x34, 0x4a, 0xd0, 0x0, 0xc, 0xb4, 0xf4,
    0x0, 0x9, 0xd0, 0x3, 0xce, 0x10, 0x6f, 0xa1,
    0x9, 0xd0, 0xa, 0xa1, 0x0, 0x2, 0x80, 0x9,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x4,
    0xcc, 0xcc, 0xcc, 0xce, 0xd0, 0x0, 0x6, 0xf3,
    0x33, 0x33, 0x33, 0x30, 0x0, 0x6, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xf7,

    /* U+C131 "성" */
    0x0, 0x0, 0x8c, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0x8, 0xc0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x9d,
    0x0, 0x12, 0x2b, 0xb0, 0x0, 0xd, 0xf2, 0xb,
    0xff, 0xfb, 0x0, 0x4, 0xfc, 0xa0, 0x0, 0xa,
    0xb0, 0x1, 0xe8, 0x2f, 0x70, 0x0, 0xab, 0x4,
    0xeb, 0x0, 0x4f, 0xb1, 0xa, 0xb0, 0xd9, 0x0,
    0x0, 0x27, 0x0, 0xab, 0x0, 0x0, 0x0, 0x12,
    0x21, 0x3, 0x40, 0x0, 0x8, 0xef, 0xde, 0xfd,
    0x70, 0x0, 0x9, 0xd3, 0x0, 0x0, 0x4e, 0x70,
    0x0, 0xd7, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x8,
    0xe6, 0x21, 0x13, 0x7f, 0x60, 0x0, 0x5, 0xbe,
    0xff, 0xea, 0x40,

    /* U+C138 "세" */
    0x0, 0x0, 0x0, 0x0, 0xf, 0x42, 0xf1, 0x0,
    0x2, 0xf1, 0x0, 0xf, 0x42, 0xf1, 0x0, 0x3,
    0xf1, 0x0, 0xf, 0x42, 0xf1, 0x0, 0x3, 0xf1,
    0x0, 0xf, 0x42, 0xf1, 0x0, 0x3, 0xf2, 0x0,
    0xf, 0x42, 0xf1, 0x0, 0x5, 0xf4, 0x6f, 0xff,
    0x42, 0xf1, 0x0, 0xa, 0xf9, 0x1, 0x1f, 0x42,
    0xf1, 0x0, 0x1f, 0x6f, 0x10, 0xf, 0x42, 0xf1,
    0x0, 0xab, 0xb, 0xb0, 0xf, 0x42, 0xf1, 0x8,
    0xf2, 0x2, 0xeb, 0xf, 0x42, 0xf1, 0x1e, 0x40,
    0x0, 0x28, 0xf, 0x42, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x42, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x42, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x22, 0xf1,

    /* U+C14B "셋" */
    0x0, 0x3, 0xf1, 0x0, 0x1f, 0x24, 0xf0, 0x0,
    0x3, 0xf1, 0x0, 0x1f, 0x24, 0xf0, 0x0, 0x3,
    0xf1, 0x0, 0x1f, 0x24, 0xf0, 0x0, 0x6, 0xf4,
    0x5f, 0xff, 0x24, 0xf0, 0x0, 0xd, 0xdb, 0x2,
    0x4f, 0x24, 0xf0, 0x0, 0x8e, 0x2f, 0x60, 0x1f,
    0x24, 0xf0, 0x8, 0xf4, 0x5, 0xf8, 0x1f, 0x24,
    0xf0, 0xa, 0x40, 0x0, 0x34, 0x1f, 0x24, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x6, 0xe0, 0x3, 0xd0, 0x0, 0x0,
    0x0, 0xa, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xbc, 0x10, 0x0, 0x0, 0x0, 0x29, 0xf5,
    0xb, 0xe5, 0x0, 0x0, 0x1c, 0xfa, 0x20, 0x0,
    0x6e, 0xe7, 0x0, 0x5, 0x10, 0x0, 0x0, 0x0,
    0x32,

    /* U+C18C "소" */
    0x0, 0x0, 0x0, 0x14, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x8, 0xe7,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x30, 0x9f,
    0x50, 0x0, 0x2, 0x8e, 0xd3, 0x0, 0x7, 0xfc,
    0x50, 0x5, 0xc6, 0x0, 0x13, 0x0, 0x29, 0xc0,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x2c, 0xcc, 0xcc,
    0xdf, 0xcc, 0xcc, 0xcb, 0x16, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x65,

    /* U+C18D "속" */
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x70, 0xcd, 0x40, 0x0, 0x2, 0xaf, 0xd4, 0x2,
    0x7, 0xfd, 0x80, 0x0, 0x83, 0x0, 0x5f, 0x0,
    0x5, 0x60, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,
    0x34, 0x44, 0x44, 0x44, 0x44, 0x10, 0x0, 0x9c,
    0xcc, 0xcc, 0xcc, 0xdf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x40,

    /* U+C1A1 "송" */
    0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x80, 0xbd, 0x40, 0x0, 0x2, 0x9e, 0xe5, 0x1,
    0x7, 0xfd, 0x80, 0x0, 0x84, 0x0, 0x4f, 0x0,
    0x6, 0x70, 0x0, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0,
    0x2, 0x8b, 0xdd, 0xca, 0x60, 0x0, 0x0, 0x3f,
    0xa5, 0x33, 0x36, 0xcd, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x4f, 0x83, 0x10,
    0x13, 0xae, 0x10, 0x0, 0x3, 0xad, 0xff, 0xfd,
    0x82, 0x0,

    /* U+C218 "수" */
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0xd3, 0xf8, 0x0, 0x0, 0x0, 0x17, 0xec, 0x10,
    0x4e, 0xc5, 0x0, 0x5, 0xfd, 0x60, 0x0, 0x1,
    0x9f, 0xf0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0,
    0x0, 0x0,

    /* U+C2A4 "스" */
    0x0, 0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe6,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x30, 0x9f,
    0x40, 0x0, 0x2, 0x7e, 0xd3, 0x0, 0x7, 0xfb,
    0x50, 0x5, 0xd6, 0x0, 0x0, 0x0, 0x29, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x2, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22,

    /* U+C2B5 "습" */
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf9, 0xe3, 0x0, 0x0, 0x0, 0x4, 0xbe,
    0x40, 0x7f, 0x93, 0x0, 0x3, 0xfd, 0x70, 0x0,
    0x2, 0x9e, 0xe0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdc, 0x3, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x0, 0x57, 0x0, 0x0, 0x0, 0x19, 0x10, 0x0,
    0x8c, 0x0, 0x0, 0x0, 0x2f, 0x30, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x8c, 0x11,
    0x11, 0x11, 0x3f, 0x30, 0x0, 0x8c, 0x11, 0x11,
    0x11, 0x3f, 0x30, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xff, 0x30,

    /* U+C2DC "시" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0,
    0x2, 0xd1, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x3f,
    0x10, 0x0, 0x6, 0xe0, 0x0, 0x3, 0xf1, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x6,
    0xe0, 0x0, 0x7, 0xf6, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0xdd, 0xc0, 0x0, 0x6, 0xe0, 0x0, 0x6f,
    0x2f, 0x50, 0x0, 0x6e, 0x0, 0x3f, 0x70, 0x6f,
    0x40, 0x6, 0xe0, 0x5e, 0xb0, 0x0, 0x9f, 0x70,
    0x6e, 0xb, 0x90, 0x0, 0x0, 0x66, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6e,

    /* U+C2E4 "실" */
    0x0, 0x0, 0x8e, 0x0, 0x0, 0xe, 0x60, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0xe6, 0x0, 0x0, 0xaf,
    0x10, 0x0, 0xe, 0x60, 0x0, 0x1f, 0xf8, 0x0,
    0x0, 0xe6, 0x0, 0xb, 0xb6, 0xf4, 0x0, 0xe,
    0x60, 0x2c, 0xe1, 0x9, 0xf7, 0x0, 0xe6, 0x1f,
    0xc2, 0x0, 0x6, 0xe1, 0xe, 0x60, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x73, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe6, 0x0, 0xa, 0xcc, 0xcc, 0xcc, 0xcf, 0x60,
    0x0, 0xe9, 0x44, 0x44, 0x44, 0x41, 0x0, 0xe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff,

    /* U+C548 "안" */
    0x0, 0x2, 0x20, 0x0, 0x5, 0xf0, 0x0, 0x7,
    0xff, 0xfd, 0x30, 0x5, 0xf0, 0x0, 0x6f, 0x40,
    0x1a, 0xe1, 0x5, 0xf0, 0x0, 0xd8, 0x0, 0x0,
    0xe6, 0x5, 0xf0, 0x0, 0xe6, 0x0, 0x0, 0xc8,
    0x5, 0xff, 0xf1, 0xca, 0x0, 0x1, 0xf5, 0x5,
    0xf2, 0x20, 0x3f, 0x94, 0x5d, 0xc0, 0x5, 0xf0,
    0x0, 0x3, 0xbe, 0xd8, 0x0, 0x5, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x72, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0xf4,
    0x0, 0x0, 0x1, 0x40, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x0,

    /* U+C5C5 "업" */
    0x5, 0xcf, 0xe9, 0x10, 0x0, 0x6e, 0x5f, 0x72,
    0x4c, 0xc0, 0x0, 0x6e, 0xc8, 0x0, 0x1, 0xf4,
    0x0, 0x6e, 0xf4, 0x0, 0x0, 0xdf, 0xff, 0xfe,
    0xd7, 0x0, 0x0, 0xf6, 0x22, 0x8e, 0x6f, 0x50,
    0x1b, 0xd0, 0x0, 0x6e, 0x7, 0xef, 0xfc, 0x20,
    0x0, 0x6e, 0x0, 0x2, 0x10, 0x0, 0x0, 0x25,
    0x0, 0x5b, 0x0, 0x0, 0x0, 0x5b, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x6e, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x6e, 0x11, 0x11, 0x11, 0x7e,
    0x0, 0x6e, 0x11, 0x11, 0x11, 0x7e, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xfe,

    /* U+C5C6 "없" */
    0x5, 0xdf, 0xe8, 0x0, 0x0, 0xdb, 0x0, 0x5f,
    0x72, 0x3c, 0xa0, 0x0, 0xdb, 0x0, 0xd8, 0x0,
    0x1, 0xf2, 0x0, 0xdb, 0x0, 0xf4, 0x0, 0x0,
    0xdf, 0xff, 0xfb, 0x0, 0xd7, 0x0, 0x0, 0xf4,
    0x22, 0xeb, 0x0, 0x6f, 0x50, 0x2b, 0xb0, 0x0,
    0xdb, 0x0, 0x6, 0xef, 0xfa, 0x0, 0x0, 0xdb,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x43, 0x0,
    0x7, 0x80, 0xb, 0x40, 0xf, 0x50, 0x0, 0x9,
    0xa0, 0xe, 0x50, 0xf, 0x50, 0x0, 0x9, 0xff,
    0xff, 0x50, 0x2f, 0x80, 0x0, 0x9, 0xa0, 0xe,
    0x50, 0x9d, 0xf1, 0x0, 0x9, 0xa0, 0xe, 0x58,
    0xf2, 0xad, 0x30, 0x9, 0xff, 0xff, 0x8e, 0x30,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+C5D0 "에" */
    0x0, 0x0, 0x0, 0x0, 0xf, 0x42, 0xf1, 0x0,
    0x7f, 0xf6, 0x0, 0xf, 0x42, 0xf1, 0x4, 0xf6,
    0x6f, 0x30, 0xf, 0x42, 0xf1, 0xb, 0x90, 0x9,
    0xa0, 0xf, 0x42, 0xf1, 0xe, 0x50, 0x5, 0xe0,
    0xf, 0x42, 0xf1, 0xf, 0x30, 0x4, 0xfd, 0xdf,
    0x42, 0xf1, 0xf, 0x30, 0x4, 0xf4, 0x4f, 0x42,
    0xf1, 0xe, 0x50, 0x5, 0xe0, 0xf, 0x42, 0xf1,
    0xb, 0x90, 0x9, 0xa0, 0xf, 0x42, 0xf1, 0x4,
    0xf5, 0x5f, 0x40, 0xf, 0x42, 0xf1, 0x0, 0x7f,
    0xf7, 0x0, 0xf, 0x42, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x42, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x42, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x12, 0xf1,

    /* U+C5F0 "연" */
    0x0, 0x2, 0x10, 0x0, 0x0, 0xab, 0x0, 0x7f,
    0xff, 0xc2, 0x0, 0xa, 0xb0, 0x7e, 0x30, 0xa,
    0xff, 0xff, 0xfb, 0xd, 0x60, 0x0, 0xe, 0x72,
    0x2b, 0xb0, 0xf4, 0x0, 0x0, 0xd7, 0x0, 0xab,
    0xc, 0x90, 0x0, 0x1f, 0xa8, 0x8d, 0xb0, 0x4f,
    0x83, 0x5d, 0xd9, 0x99, 0xdb, 0x0, 0x4b, 0xed,
    0x80, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xab, 0x0, 0x2, 0x60, 0x0, 0x0, 0xa,
    0xb0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x45, 0x0,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xf4,

    /* U+C624 "오" */
    0x0, 0x0, 0x0, 0x23, 0x10, 0x0, 0x0, 0x0,
    0x2, 0xbf, 0xed, 0xfe, 0x70, 0x0, 0x0, 0x3f,
    0x92, 0x0, 0x4, 0xdb, 0x0, 0x0, 0xba, 0x0,
    0x0, 0x0, 0x1f, 0x50, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0xc, 0x80, 0x0, 0xc9, 0x0, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x4f, 0x70, 0x0, 0x2, 0xcd,
    0x0, 0x0, 0x4, 0xdf, 0xcb, 0xdf, 0xa1, 0x0,
    0x0, 0x0, 0x2, 0x8f, 0x41, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x2b, 0xbb, 0xbb,
    0xdf, 0xbb, 0xbb, 0xba, 0x16, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x65,

    /* U+C644 "완" */
    0x0, 0x2a, 0xff, 0xc5, 0x0, 0x5f, 0x0, 0x0,
    0x1e, 0x92, 0x15, 0xf5, 0x5, 0xf0, 0x0, 0x5,
    0xe0, 0x0, 0x9, 0xb0, 0x5f, 0x0, 0x0, 0x5e,
    0x0, 0x0, 0x9b, 0x5, 0xf0, 0x0, 0x1, 0xea,
    0x21, 0x6f, 0x50, 0x5f, 0x88, 0x0, 0x2, 0xaf,
    0xfc, 0x50, 0x5, 0xfa, 0xa1, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x5f, 0x0, 0x1, 0x66, 0x6a, 0xf8,
    0x9b, 0xb5, 0xf0, 0x0, 0x1b, 0xba, 0xa9, 0x86,
    0x42, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0x2e, 0x30, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0,

    /* U+C694 "요" */
    0x0, 0x0, 0x0, 0x22, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x2a, 0xfe, 0xdf, 0xe9, 0x10, 0x0, 0x0,
    0x3f, 0x92, 0x0, 0x3, 0xbe, 0x20, 0x0, 0xb,
    0xa0, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0xb, 0xa0,
    0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x2e, 0xa3,
    0x0, 0x4, 0xbe, 0x10, 0x0, 0x0, 0x1f, 0xff,
    0xef, 0xff, 0x10, 0x0, 0x0, 0x0, 0xf6, 0x11,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x6,
    0xe0, 0x0, 0x2, 0xbb, 0xbf, 0xdb, 0xbb, 0xdf,
    0xbb, 0xb1, 0x16, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x0,

    /* U+C6A9 "용" */
    0x0, 0x4, 0xad, 0xff, 0xec, 0x70, 0x0, 0x0,
    0x6f, 0x83, 0x10, 0x15, 0xdc, 0x0, 0x0, 0xba,
    0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x8e, 0x50,
    0x0, 0x2, 0xbe, 0x0, 0x0, 0x7, 0xff, 0xdd,
    0xef, 0xb2, 0x0, 0x0, 0x0, 0xf5, 0x22, 0x1e,
    0x60, 0x0, 0x0, 0x0, 0xf4, 0x0, 0xe, 0x60,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0,
    0x2, 0x9c, 0xee, 0xda, 0x60, 0x0, 0x0, 0x4f,
    0x84, 0x22, 0x36, 0xdb, 0x0, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x5f, 0x72, 0x0,
    0x14, 0xdc, 0x0, 0x0, 0x4, 0xae, 0xff, 0xec,
    0x70, 0x0,

    /* U+C6B4 "운" */
    0x0, 0x2, 0x9d, 0xff, 0xec, 0x70, 0x0, 0x0,
    0x3f, 0xb4, 0x11, 0x26, 0xec, 0x0, 0x0, 0xbc,
    0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0xac, 0x0,
    0x0, 0x0, 0x2f, 0x40, 0x0, 0x3f, 0xb5, 0x22,
    0x37, 0xeb, 0x0, 0x0, 0x1, 0x8c, 0xee, 0xdb,
    0x60, 0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x3f, 0x10, 0x0, 0x0, 0x0,
    0x35, 0x0, 0x3f, 0x10, 0x0, 0x0, 0x0, 0x9c,
    0x0, 0x3e, 0x10, 0x0, 0x0, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x44, 0x44,
    0x44, 0x44, 0x20, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0x70,

    /* U+C6CC "워" */
    0x0, 0x8, 0xef, 0xe8, 0x0, 0xa, 0xb0, 0xb,
    0xc3, 0x3, 0xd9, 0x0, 0xab, 0x1, 0xf3, 0x0,
    0x4, 0xf0, 0xa, 0xb0, 0x2f, 0x20, 0x0, 0x3f,
    0x0, 0xab, 0x0, 0xda, 0x0, 0x1c, 0xb0, 0xa,
    0xb0, 0x1, 0xbf, 0xef, 0xb1, 0x0, 0xab, 0x0,
    0x0, 0x12, 0x10, 0x0, 0xa, 0xb1, 0x77, 0x77,
    0x89, 0xab, 0xd4, 0xab, 0x1a, 0xaa, 0xbf, 0x86,
    0x53, 0xa, 0xb0, 0x0, 0x4, 0xf0, 0x1, 0x22,
    0xbb, 0x0, 0x0, 0x4f, 0x0, 0xde, 0xef, 0xb0,
    0x0, 0x4, 0xf0, 0x0, 0x0, 0xab, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0xab,

    /* U+C744 "을" */
    0x0, 0x4, 0xad, 0xff, 0xfd, 0x92, 0x0, 0x0,
    0x6f, 0x72, 0x0, 0x3, 0xaf, 0x20, 0x0, 0xbb,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x6f, 0x72,
    0x0, 0x3, 0xaf, 0x20, 0x0, 0x4, 0xbe, 0xff,
    0xfd, 0x92, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x0, 0x8e, 0xee, 0xee, 0xee, 0xee, 0x20, 0x0,
    0x12, 0x22, 0x22, 0x22, 0x3f, 0x30, 0x0, 0x13,
    0x33, 0x33, 0x33, 0x4f, 0x30, 0x0, 0x8f, 0xcc,
    0xcc, 0xcc, 0xcc, 0x20, 0x0, 0x8c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0x90,

    /* U+C74C "음" */
    0x0, 0x2, 0x9d, 0xff, 0xfc, 0x81, 0x0, 0x0,
    0x3f, 0xa4, 0x10, 0x15, 0xce, 0x10, 0x0, 0xab,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x9d, 0x0,
    0x0, 0x0, 0x1f, 0x50, 0x0, 0x2d, 0xd7, 0x54,
    0x58, 0xeb, 0x0, 0x0, 0x0, 0x6a, 0xbc, 0xb9,
    0x40, 0x0, 0x2, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x21, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x9c,
    0x22, 0x22, 0x22, 0x2f, 0x50, 0x0, 0x9b, 0x0,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x9c, 0x11, 0x11,
    0x11, 0x1f, 0x50, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0x50,

    /* U+C751 "응" */
    0x0, 0x2, 0x9d, 0xff, 0xfc, 0x70, 0x0, 0x0,
    0x3f, 0xa4, 0x10, 0x15, 0xcd, 0x10, 0x0, 0xac,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0xac, 0x0,
    0x0, 0x0, 0x1f, 0x50, 0x0, 0x2e, 0xc6, 0x33,
    0x47, 0xec, 0x0, 0x0, 0x1, 0x7b, 0xdd, 0xca,
    0x50, 0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x8c, 0xee, 0xdb, 0x71, 0x0, 0x0, 0x3f,
    0x94, 0x21, 0x25, 0xbe, 0x10, 0x0, 0x9c, 0x0,
    0x0, 0x0, 0xf, 0x40, 0x0, 0x4f, 0x83, 0x10,
    0x14, 0xae, 0x10, 0x0, 0x3, 0xad, 0xff, 0xfd,
    0x81, 0x0,

    /* U+C774 "이" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0xe6, 0x2, 0xcf,
    0xfa, 0x0, 0x0, 0xe6, 0xd, 0xb2, 0x3d, 0xa0,
    0x0, 0xe6, 0x6f, 0x0, 0x3, 0xf2, 0x0, 0xe6,
    0xaa, 0x0, 0x0, 0xe6, 0x0, 0xe6, 0xc8, 0x0,
    0x0, 0xc8, 0x0, 0xe6, 0xb8, 0x0, 0x0, 0xc7,
    0x0, 0xe6, 0x9b, 0x0, 0x0, 0xe5, 0x0, 0xe6,
    0x5f, 0x10, 0x4, 0xf1, 0x0, 0xe6, 0xc, 0xc4,
    0x5e, 0x80, 0x0, 0xe6, 0x1, 0xaf, 0xe8, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe6,

    /* U+C778 "인" */
    0x0, 0x2, 0x20, 0x0, 0x0, 0xe7, 0x0, 0x6e,
    0xff, 0xe5, 0x0, 0xe, 0x70, 0x5f, 0x50, 0x7,
    0xf4, 0x0, 0xe7, 0xc, 0x90, 0x0, 0xb, 0xa0,
    0xe, 0x70, 0xd7, 0x0, 0x0, 0x8c, 0x0, 0xe7,
    0xa, 0xb0, 0x0, 0xd, 0x90, 0xe, 0x70, 0x2f,
    0xa4, 0x5b, 0xe1, 0x0, 0xe7, 0x0, 0x2a, 0xed,
    0x91, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x5, 0x60, 0x0, 0x0, 0xe,
    0x70, 0x0, 0xab, 0x0, 0x0, 0x0, 0x83, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xf1,

    /* U+C785 "입" */
    0x3, 0xcf, 0xfb, 0x30, 0x0, 0xe7, 0x3f, 0x92,
    0x3a, 0xf2, 0x0, 0xe7, 0xba, 0x0, 0x0, 0xc9,
    0x0, 0xe7, 0xd7, 0x0, 0x0, 0x8c, 0x0, 0xe7,
    0xc9, 0x0, 0x0, 0xba, 0x0, 0xe7, 0x5f, 0x60,
    0x8, 0xf3, 0x0, 0xe7, 0x5, 0xef, 0xfd, 0x40,
    0x0, 0xe7, 0x0, 0x1, 0x10, 0x0, 0x0, 0xb5,
    0x0, 0x88, 0x0, 0x0, 0x0, 0xb5, 0x0, 0xab,
    0x0, 0x0, 0x0, 0xe7, 0x0, 0xaf, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0xab, 0x11, 0x11, 0x11, 0xe7,
    0x0, 0xab, 0x11, 0x11, 0x11, 0xe7, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xf7,

    /* U+C7A0 "잠" */
    0x3, 0x33, 0x33, 0x33, 0x30, 0x4f, 0x0, 0x0,
    0xcd, 0xdf, 0xfd, 0xdb, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0xab, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0,
    0xd, 0xe0, 0x0, 0x4, 0xfd, 0xd2, 0x0, 0x4,
    0xfe, 0x60, 0x0, 0x4f, 0x44, 0x0, 0x2, 0xe8,
    0x5f, 0x60, 0x4, 0xf0, 0x0, 0x8, 0xfa, 0x0,
    0x6f, 0xc0, 0x4f, 0x0, 0x0, 0xb6, 0x0, 0x0,
    0x25, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x1f, 0x30, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0x1f, 0x41, 0x11, 0x11, 0x5f,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0,

    /* U+C804 "전" */
    0x1, 0x11, 0x11, 0x11, 0x10, 0xb, 0xa0, 0xb,
    0xff, 0xff, 0xff, 0xe0, 0xb, 0xa0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0xb, 0xa0, 0x0, 0x0, 0x9e,
    0x0, 0x12, 0x2c, 0xa0, 0x0, 0x0, 0xef, 0x30,
    0x9f, 0xff, 0xa0, 0x0, 0x7, 0xe8, 0xc0, 0x0,
    0xb, 0xa0, 0x0, 0x6f, 0x60, 0xcb, 0x10, 0xb,
    0xa0, 0xb, 0xf7, 0x0, 0x1b, 0xe0, 0xb, 0xa0,
    0x6, 0x30, 0x0, 0x0, 0x20, 0xb, 0xa0, 0x0,
    0x2, 0x60, 0x0, 0x0, 0xb, 0xa0, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x5, 0x40, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xf4,

    /* U+C811 "접" */
    0xb, 0xff, 0xff, 0xff, 0xf2, 0x6, 0xe0, 0x9d,
    0xde, 0xfd, 0xdd, 0x10, 0x6e, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x6, 0xe0, 0x0, 0xc, 0xf2, 0x5,
    0xff, 0xfe, 0x0, 0x5, 0xfa, 0xb0, 0x2, 0x27,
    0xe0, 0x4, 0xf8, 0xd, 0xc2, 0x0, 0x6e, 0xa,
    0xf9, 0x0, 0x1b, 0xf3, 0x6, 0xe0, 0x74, 0x0,
    0x0, 0x2, 0x0, 0x26, 0x0, 0x4, 0xa0, 0x0,
    0x0, 0x4, 0xa0, 0x0, 0x6e, 0x0, 0x0, 0x0,
    0x6e, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x6e, 0x11, 0x11, 0x11, 0x7e, 0x0, 0x6,
    0xe1, 0x11, 0x11, 0x17, 0xe0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xfe,

    /* U+C815 "정" */
    0x2, 0x22, 0x22, 0x22, 0x20, 0xa, 0xb0, 0xae,
    0xef, 0xfe, 0xee, 0x0, 0xab, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0xa, 0xb0, 0x0, 0xa, 0xf0, 0x1,
    0x44, 0xbb, 0x0, 0x0, 0xff, 0x50, 0x6d, 0xdf,
    0xb0, 0x0, 0x9d, 0x6e, 0x20, 0x0, 0xab, 0x0,
    0x9f, 0x30, 0xae, 0x60, 0xa, 0xb0, 0xde, 0x40,
    0x0, 0x7e, 0x10, 0xab, 0x4, 0x10, 0x0, 0x12,
    0x20, 0x6, 0x60, 0x0, 0x8, 0xef, 0xee, 0xfd,
    0x70, 0x0, 0x9, 0xd3, 0x0, 0x0, 0x4e, 0x70,
    0x0, 0xd7, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x8,
    0xe6, 0x20, 0x12, 0x7f, 0x60, 0x0, 0x5, 0xbe,
    0xff, 0xea, 0x40,

    /* U+C871 "족" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x88, 0x88, 0xcf, 0xa8, 0x88, 0x50, 0x0, 0x0,
    0x0, 0xdf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3c,
    0xc3, 0xf9, 0x10, 0x0, 0x2, 0x8c, 0xf8, 0x12,
    0x2b, 0xfb, 0x70, 0x1, 0x95, 0x10, 0x5f, 0x0,
    0x27, 0x80, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x21, 0x0,
    0x23, 0x33, 0x33, 0x33, 0x33, 0x0, 0x0, 0x9d,
    0xdd, 0xdd, 0xdd, 0xdf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x40,

    /* U+C8FC "주" */
    0x0, 0x55, 0x55, 0x55, 0x55, 0x55, 0x30, 0x0,
    0xbb, 0xbb, 0xdf, 0xcb, 0xbb, 0x70, 0x0, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x81,
    0xdc, 0x20, 0x0, 0x2, 0x8d, 0xe6, 0x0, 0x9,
    0xfb, 0x60, 0x1, 0x95, 0x0, 0x0, 0x0, 0x17,
    0x80, 0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0,
    0x0, 0x0,

    /* U+C911 "중" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x88, 0x88, 0xcf, 0xa8, 0x88, 0x60, 0x0, 0x0,
    0x0, 0xdf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2c,
    0xc3, 0xea, 0x10, 0x0, 0x2, 0x8c, 0xf9, 0x0,
    0x2b, 0xfb, 0x70, 0x1, 0x96, 0x10, 0x0, 0x0,
    0x27, 0x80, 0x17, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x76, 0x1a, 0xaa, 0xaa, 0xbf, 0xaa, 0xaa, 0xa9,
    0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x8b, 0xef, 0xdb, 0x60, 0x0, 0x0, 0x3f,
    0xa5, 0x32, 0x36, 0xcd, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x4f, 0x83, 0x10,
    0x13, 0xae, 0x10, 0x0, 0x3, 0xad, 0xff, 0xfd,
    0x81, 0x0,

    /* U+C9C0 "지" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x59,
    0x99, 0x99, 0x99, 0x50, 0x6e, 0x5, 0x88, 0xaf,
    0x88, 0x84, 0x6, 0xe0, 0x0, 0x4, 0xf1, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x6,
    0xe0, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0xbf, 0x90, 0x0, 0x6, 0xe0, 0x0, 0x3f,
    0x5f, 0x20, 0x0, 0x6e, 0x0, 0xd, 0x90, 0x9d,
    0x10, 0x6, 0xe0, 0x1c, 0xd0, 0x0, 0xbe, 0x50,
    0x6e, 0xd, 0xc1, 0x0, 0x0, 0x89, 0x6, 0xe0,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6e,

    /* U+C9C4 "진" */
    0x1, 0x11, 0x11, 0x11, 0x10, 0x6, 0xe0, 0xa,
    0xff, 0xff, 0xff, 0xf6, 0x6, 0xe0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x6f,
    0x10, 0x0, 0x6, 0xe0, 0x0, 0x0, 0xaf, 0x60,
    0x0, 0x6, 0xe0, 0x0, 0x3, 0xf7, 0xe1, 0x0,
    0x6, 0xe0, 0x0, 0x3e, 0x90, 0x9e, 0x30, 0x6,
    0xe0, 0x8, 0xfa, 0x0, 0x8, 0xf8, 0x6, 0xe0,
    0x5, 0x50, 0x0, 0x0, 0x21, 0x6, 0xe0, 0x0,
    0x3, 0x60, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x3, 0x80, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xf5,

    /* U+CC3E "찾" */
    0x0, 0x0, 0x8c, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x68, 0x8c, 0xe8, 0x88, 0x5, 0xf0, 0x0, 0x5,
    0x66, 0xcd, 0x66, 0x60, 0x5f, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x5, 0xfe, 0xe1, 0x0, 0x1,
    0xff, 0x50, 0x0, 0x5f, 0x33, 0x0, 0x1, 0xca,
    0x5f, 0x50, 0x5, 0xf0, 0x0, 0x8, 0xeb, 0x0,
    0x6f, 0xc1, 0x5f, 0x0, 0x0, 0x96, 0x0, 0x0,
    0x15, 0x5, 0xf0, 0x0, 0x0, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x0, 0x0, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xbf, 0x40,
    0x0, 0x0, 0x0, 0x2, 0x8f, 0x80, 0x6f, 0x93,
    0x0, 0x0, 0x8, 0xfa, 0x30, 0x0, 0x2a, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+CD08 "초" */
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x11, 0x5f, 0x11, 0x11, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x6f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf8, 0xf3,
    0x0, 0x0, 0x0, 0x2, 0xaf, 0x40, 0x8f, 0x70,
    0x0, 0x3, 0xcf, 0xb2, 0x0, 0x5, 0xdf, 0xb0,
    0x0, 0x62, 0x0, 0x5f, 0x0, 0x3, 0x50, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x2b, 0xbb, 0xbb,
    0xcf, 0xbb, 0xbb, 0xba, 0x16, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66,

    /* U+CD5C "최" */
    0x0, 0x0, 0x1f, 0x40, 0x0, 0xe, 0x60, 0x15,
    0x55, 0xf7, 0x55, 0x30, 0xe6, 0x4, 0xcc, 0xcf,
    0xdc, 0xc7, 0xe, 0x60, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0x9f, 0xc0, 0x0, 0xe,
    0x60, 0x0, 0x5f, 0x3d, 0xa0, 0x0, 0xe6, 0x2,
    0xaf, 0x50, 0x2d, 0xd5, 0xe, 0x60, 0x5b, 0x30,
    0x92, 0x7, 0x60, 0xe6, 0x0, 0x0, 0x1f, 0x40,
    0x0, 0xe, 0x60, 0x0, 0x1, 0xf4, 0x1, 0x31,
    0xe6, 0xd, 0xdd, 0xef, 0xff, 0xec, 0x3e, 0x60,
    0x44, 0x33, 0x21, 0x0, 0x0, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe6,

    /* U+CDA9 "충" */
    0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0,
    0x8a, 0xaa, 0xbf, 0xaa, 0xaa, 0x60, 0x0, 0x56,
    0x66, 0xaf, 0x86, 0x66, 0x30, 0x0, 0x0, 0x1,
    0xdf, 0xa0, 0x0, 0x0, 0x0, 0x2, 0x7e, 0xa2,
    0xdd, 0x61, 0x0, 0x3, 0xee, 0xa4, 0x0, 0x5,
    0xbf, 0xd0, 0x1, 0x31, 0x11, 0x11, 0x11, 0x11,
    0x31, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x47, 0xaf, 0x86, 0x20, 0x0, 0x0, 0x2d,
    0xd9, 0x76, 0x79, 0xeb, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x5f, 0x72, 0x0,
    0x13, 0x9f, 0x10, 0x0, 0x4, 0xae, 0xff, 0xfd,
    0x92, 0x0,

    /* U+CE5C "친" */
    0x0, 0x1, 0xf3, 0x0, 0x0, 0x6e, 0x2, 0x44,
    0x4f, 0x64, 0x41, 0x6, 0xe0, 0x7c, 0xcc, 0xfd,
    0xcc, 0x30, 0x6e, 0x0, 0x0, 0x1f, 0x30, 0x0,
    0x6, 0xe0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0xcc, 0xe1, 0x0, 0x6, 0xe0, 0x0,
    0xad, 0xc, 0xc1, 0x0, 0x6e, 0x4, 0xde, 0x20,
    0x1c, 0xf6, 0x6, 0xe0, 0x79, 0x10, 0x0, 0x6,
    0x20, 0x6e, 0x0, 0x2, 0x40, 0x0, 0x0, 0x6,
    0xe0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x4a, 0x0,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xf5,

    /* U+CE74 "카" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xf4, 0x5, 0xf0, 0x0, 0x0,
    0x22, 0x22, 0x3f, 0x30, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf1, 0x5, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x5f, 0x0, 0x0, 0x9b, 0xcd,
    0xef, 0x90, 0x5, 0xf2, 0x20, 0x7, 0x86, 0x57,
    0xf3, 0x0, 0x5f, 0xff, 0x40, 0x0, 0x0, 0xda,
    0x0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0xbd, 0x10,
    0x0, 0x5f, 0x0, 0x0, 0x2, 0xde, 0x20, 0x0,
    0x5, 0xf0, 0x0, 0x8, 0xfb, 0x10, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x65, 0x0, 0x0, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0,

    /* U+CE94 "캔" */
    0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0xf4, 0x5,
    0xff, 0xff, 0xf4, 0x5e, 0x0, 0xf4, 0x0, 0x11,
    0x13, 0xf2, 0x5e, 0x0, 0xf4, 0x2, 0x34, 0x59,
    0xe0, 0x5e, 0x0, 0xf4, 0xd, 0xdb, 0x9f, 0x90,
    0x5f, 0xff, 0xf4, 0x0, 0x0, 0x7f, 0x10, 0x5e,
    0x22, 0xf4, 0x0, 0x7, 0xf4, 0x0, 0x5e, 0x0,
    0xf4, 0x4, 0xde, 0x30, 0x0, 0x5e, 0x0, 0xf4,
    0x8, 0x70, 0x0, 0x0, 0x5e, 0x0, 0xf4, 0x0,
    0x5, 0xc0, 0x0, 0x5e, 0x0, 0xf4, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x0, 0x71, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+CF1C "켜" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x3f, 0xff,
    0xff, 0xf4, 0x0, 0x7e, 0x2, 0x22, 0x23, 0xf3,
    0x0, 0x7e, 0x0, 0x0, 0x3, 0xf3, 0x22, 0x8e,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xfe, 0xac, 0xde,
    0xff, 0x90, 0x0, 0x7e, 0x66, 0x43, 0x6f, 0x20,
    0x0, 0x7e, 0x0, 0x1, 0xda, 0x2, 0x22, 0x8e,
    0x0, 0xc, 0xd1, 0x5f, 0xff, 0xfe, 0x2, 0xde,
    0x20, 0x0, 0x0, 0x7e, 0x7f, 0xc1, 0x0, 0x0,
    0x0, 0x7e, 0x76, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+D06C "크" */
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x12, 0x22, 0x22, 0x22, 0x2f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x40, 0x0, 0x9a, 0xbb, 0xcd,
    0xde, 0xff, 0x30, 0x0, 0x67, 0x65, 0x43, 0x22,
    0x3f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22,

    /* U+D0DC "태" */
    0x0, 0x0, 0x0, 0x5, 0xe0, 0xf, 0x47, 0xcc,
    0xcc, 0xc1, 0x5e, 0x0, 0xf4, 0xab, 0x44, 0x44,
    0x5, 0xe0, 0xf, 0x4a, 0xa0, 0x0, 0x0, 0x5e,
    0x0, 0xf4, 0xaa, 0x0, 0x0, 0x5, 0xe0, 0xf,
    0x4a, 0xd9, 0x99, 0x70, 0x5e, 0x33, 0xf4, 0xad,
    0x88, 0x87, 0x5, 0xfe, 0xef, 0x4a, 0xa0, 0x0,
    0x0, 0x5e, 0x0, 0xf4, 0xaa, 0x0, 0x0, 0x5,
    0xe0, 0xf, 0x4a, 0xc7, 0x78, 0xa7, 0x5e, 0x0,
    0xf4, 0x6b, 0xaa, 0x97, 0x35, 0xe0, 0xf, 0x40,
    0x0, 0x0, 0x0, 0x5e, 0x0, 0xf4, 0x0, 0x0,
    0x0, 0x5, 0xe0, 0xf, 0x40, 0x0, 0x0, 0x0,
    0x4a, 0x0, 0xf4,

    /* U+D130 "터" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x8f, 0xff,
    0xff, 0xf2, 0x0, 0x9b, 0x8d, 0x22, 0x22, 0x20,
    0x0, 0x9b, 0x8c, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0x8c, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x8f, 0xff,
    0xff, 0x89, 0xff, 0xfb, 0x8c, 0x11, 0x11, 0x1,
    0x22, 0xab, 0x8c, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0x8c, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x8d, 0x66,
    0x67, 0x9b, 0x10, 0x9b, 0x6b, 0xbb, 0xa9, 0x86,
    0x0, 0x9b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9b,

    /* U+D15C "템" */
    0x12, 0x22, 0x21, 0x0, 0xf4, 0x4f, 0x8f, 0xff,
    0xfe, 0x0, 0xf4, 0x4f, 0x8b, 0x0, 0x0, 0x0,
    0xf4, 0x4f, 0x8c, 0x33, 0x31, 0x56, 0xf4, 0x4f,
    0x8f, 0xdd, 0xd4, 0xab, 0xf4, 0x4f, 0x8b, 0x0,
    0x0, 0x0, 0xf4, 0x4f, 0x9e, 0xaa, 0xbc, 0xa0,
    0xf4, 0x4f, 0x37, 0x76, 0x64, 0x10, 0xf4, 0x4f,
    0x0, 0x0, 0x0, 0x0, 0x51, 0x3b, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x8d, 0x22, 0x22,
    0x22, 0x6f, 0x0, 0x8c, 0x0, 0x0, 0x0, 0x4f,
    0x0, 0x8d, 0x11, 0x11, 0x11, 0x5f, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff,

    /* U+D2B8 "트" */
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x8d, 0x11, 0x11, 0x11, 0x11, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x8d, 0x11, 0x11,
    0x11, 0x11, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8e, 0x66, 0x66, 0x66, 0x66,
    0x20, 0x0, 0x5a, 0xaa, 0xaa, 0xaa, 0xaa, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22,

    /* U+D31F "팟" */
    0x1, 0x11, 0x11, 0x11, 0x10, 0x5f, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xfc, 0x5, 0xf0, 0x0, 0x0,
    0x5f, 0x0, 0xe5, 0x0, 0x5f, 0x0, 0x0, 0x5,
    0xf0, 0xe, 0x50, 0x5, 0xf2, 0x20, 0x0, 0x5f,
    0x0, 0xe5, 0x0, 0x5f, 0xff, 0x10, 0x5, 0xf0,
    0xe, 0x50, 0x5, 0xf0, 0x0, 0x17, 0xaf, 0x88,
    0xfc, 0xc7, 0x5f, 0x0, 0x0, 0xaa, 0xa9, 0x87,
    0x64, 0x15, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x10, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf5,
    0x2, 0x90, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x2, 0x9f, 0x70, 0x4f, 0xb4,
    0x0, 0x0, 0x9, 0xfb, 0x30, 0x0, 0x19, 0xfd,
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0,

    /* U+D328 "패" */
    0x0, 0x0, 0x0, 0x0, 0x6d, 0x7, 0xd1, 0x66,
    0x66, 0x66, 0x36, 0xd0, 0x7d, 0x1b, 0xfc, 0xbf,
    0xc5, 0x6d, 0x7, 0xd0, 0xe, 0x40, 0xe4, 0x6,
    0xd0, 0x7d, 0x0, 0xe4, 0xe, 0x40, 0x6d, 0x7,
    0xd0, 0xe, 0x40, 0xe4, 0x6, 0xe3, 0x9d, 0x0,
    0xe4, 0xe, 0x40, 0x6f, 0xef, 0xd0, 0xe, 0x40,
    0xe4, 0x6, 0xd0, 0x7d, 0x0, 0xe4, 0xe, 0x40,
    0x6d, 0x7, 0xd2, 0x7f, 0xa8, 0xfc, 0x96, 0xd0,
    0x7d, 0x3a, 0xa9, 0x97, 0x63, 0x6d, 0x7, 0xd0,
    0x0, 0x0, 0x0, 0x6, 0xd0, 0x7d, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0x7, 0xd0, 0x0, 0x0, 0x0,
    0x4, 0x90, 0x7d,

    /* U+D558 "하" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0x6, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0xe,
    0xee, 0xff, 0xee, 0xe6, 0x6e, 0x0, 0x0, 0x22,
    0x22, 0x22, 0x22, 0x16, 0xe0, 0x0, 0x0, 0x4,
    0x88, 0x40, 0x0, 0x6e, 0x0, 0x0, 0x9, 0xfa,
    0xaf, 0x90, 0x6, 0xf2, 0x20, 0x3, 0xf3, 0x0,
    0x3f, 0x40, 0x6f, 0xff, 0x40, 0x7c, 0x0, 0x0,
    0xc7, 0x6, 0xe0, 0x0, 0x6, 0xe0, 0x0, 0xe,
    0x60, 0x6e, 0x0, 0x0, 0xe, 0xa2, 0x2a, 0xe1,
    0x6, 0xe0, 0x0, 0x0, 0x2b, 0xff, 0xb2, 0x0,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe0,
    0x0,

    /* U+D55C "한" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x88, 0x8b, 0xf8, 0x88, 0x45, 0xf0, 0x0, 0x8,
    0x88, 0x88, 0x88, 0x84, 0x5f, 0x0, 0x0, 0x0,
    0x48, 0x85, 0x0, 0x5, 0xf0, 0x0, 0x0, 0xbf,
    0xba, 0xec, 0x0, 0x5f, 0x44, 0x0, 0x4f, 0x20,
    0x1, 0xe6, 0x5, 0xfd, 0xd1, 0x5, 0xf0, 0x0,
    0xd, 0x70, 0x5f, 0x0, 0x0, 0x1e, 0xa4, 0x39,
    0xf2, 0x5, 0xf0, 0x0, 0x0, 0x19, 0xdd, 0xa2,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0,

    /* U+D560 "할" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0xee, 0xef, 0xfe, 0xee, 0x74, 0xf0, 0x0, 0x2,
    0x23, 0x66, 0x42, 0x21, 0x4f, 0x0, 0x0, 0x9,
    0xea, 0x9d, 0xb0, 0x4, 0xff, 0xf2, 0x4, 0xf1,
    0x0, 0xe, 0x60, 0x4f, 0x32, 0x0, 0x4f, 0x10,
    0x0, 0xe6, 0x4, 0xf0, 0x0, 0x0, 0xaf, 0xba,
    0xeb, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x24, 0x52,
    0x0, 0x2, 0x90, 0x0, 0x0, 0x2c, 0xcc, 0xcc,
    0xcc, 0xcc, 0x0, 0x0, 0x0, 0x33, 0x33, 0x33,
    0x37, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x2, 0xfe, 0xee, 0xee, 0xee,
    0xe0, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0,

    /* U+D569 "합" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0xcc, 0xcd, 0xfc, 0xcc, 0x64, 0xf0, 0x0, 0x5,
    0x55, 0x55, 0x55, 0x52, 0x4f, 0x0, 0x0, 0x2,
    0xad, 0xda, 0x30, 0x4, 0xf5, 0x50, 0x1, 0xfa,
    0x44, 0x8f, 0x30, 0x4f, 0xcc, 0x20, 0x5f, 0x0,
    0x0, 0xd7, 0x4, 0xf0, 0x0, 0x2, 0xf6, 0x0,
    0x4f, 0x40, 0x4f, 0x0, 0x0, 0x5, 0xdf, 0xfe,
    0x60, 0x4, 0xf0, 0x0, 0x0, 0x3, 0x20, 0x0,
    0x0, 0x3a, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x4, 0xf0, 0x0, 0x0, 0x1f, 0xee, 0xee, 0xee,
    0xef, 0x0, 0x0, 0x1, 0xf7, 0x22, 0x22, 0x26,
    0xf0, 0x0, 0x0, 0x1f, 0x61, 0x11, 0x11, 0x5f,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0,

    /* U+D56B "핫" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0x99, 0x9c, 0xf9, 0x99, 0x45, 0xf0, 0x0, 0x7,
    0x77, 0x77, 0x77, 0x73, 0x5f, 0x0, 0x0, 0x1,
    0x8c, 0xc9, 0x30, 0x5, 0xf0, 0x0, 0x1, 0xeb,
    0x44, 0x9f, 0x30, 0x5f, 0xff, 0x20, 0x5f, 0x0,
    0x0, 0xc9, 0x5, 0xf1, 0x10, 0x3, 0xf4, 0x0,
    0x2e, 0x60, 0x5f, 0x0, 0x0, 0x6, 0xfe, 0xdf,
    0x90, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x23, 0x0,
    0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf5,
    0x4, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x2, 0x9f, 0x70, 0x3e, 0xc4,
    0x0, 0x0, 0x9, 0xfa, 0x20, 0x0, 0x18, 0xee,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0,

    /* U+D588 "했" */
    0x0, 0x5, 0xe0, 0x0, 0x7d, 0x5, 0xe0, 0x3,
    0xaa, 0xcf, 0xaa, 0x97, 0xd0, 0x5e, 0x0, 0x26,
    0x66, 0x66, 0x66, 0x7d, 0x5, 0xe0, 0x0, 0x5,
    0xbc, 0x92, 0x7, 0xd2, 0x7e, 0x0, 0x6, 0xe7,
    0x5a, 0xe1, 0x7f, 0xff, 0xe0, 0x0, 0xb7, 0x0,
    0xd, 0x57, 0xd0, 0x5e, 0x0, 0x9, 0xb0, 0x3,
    0xf3, 0x7d, 0x5, 0xe0, 0x0, 0x1b, 0xfe, 0xf7,
    0x7, 0xd0, 0x5e, 0x0, 0x0, 0x1, 0x20, 0x0,
    0x48, 0x4, 0xc0, 0x0, 0x0, 0x4, 0xa0, 0x0,
    0xc, 0x20, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x3,
    0xf5, 0x0, 0x0, 0x0, 0x1e, 0xf5, 0x0, 0xae,
    0xc0, 0x0, 0x0, 0x3d, 0x95, 0xe3, 0x7e, 0x2d,
    0xb1, 0x0, 0x2f, 0x80, 0x8, 0xfe, 0x30, 0x1b,
    0xc0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0,
    0x0,

    /* U+D654 "화" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x6f, 0x0, 0x0,
    0x66, 0x6a, 0xf6, 0x66, 0x36, 0xf0, 0x0, 0x9,
    0x99, 0x99, 0x99, 0x95, 0x6f, 0x0, 0x0, 0x0,
    0x7b, 0xc9, 0x10, 0x6, 0xf0, 0x0, 0x0, 0xbd,
    0x54, 0xae, 0x10, 0x6f, 0x0, 0x0, 0x2f, 0x20,
    0x0, 0xd6, 0x6, 0xf1, 0x10, 0x2, 0xf2, 0x0,
    0xd, 0x70, 0x6f, 0xff, 0x30, 0xb, 0xd5, 0x4a,
    0xe1, 0x6, 0xf0, 0x0, 0x0, 0x7, 0xdf, 0x92,
    0x0, 0x6f, 0x0, 0x0, 0x0, 0x6, 0xe0, 0x0,
    0x6, 0xf0, 0x0, 0x2a, 0xaa, 0xcf, 0xcd, 0xed,
    0x6f, 0x0, 0x1, 0x87, 0x77, 0x65, 0x31, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf0,
    0x0,

    /* U+D655 "확" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0xde, 0xef, 0xfe, 0xee, 0x65, 0xf0, 0x0, 0x1,
    0x13, 0x77, 0x51, 0x10, 0x5f, 0x0, 0x0, 0x8,
    0xe8, 0x8c, 0xd1, 0x5, 0xf0, 0x0, 0x1, 0xf3,
    0x0, 0xd, 0x70, 0x5f, 0xff, 0x10, 0xe, 0x80,
    0x4, 0xf4, 0x5, 0xf2, 0x20, 0x0, 0x2a, 0xef,
    0xc5, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6, 0xe0,
    0x13, 0x45, 0xf0, 0x0, 0x2e, 0xee, 0xff, 0xff,
    0xd9, 0x5f, 0x0, 0x0, 0x32, 0x22, 0x10, 0x0,
    0x1, 0x60, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x16,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0,

    /* U+D658 "환" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xe0, 0x0, 0x5, 0xf0, 0x0, 0xb,
    0xdd, 0xef, 0xdd, 0xd5, 0x5f, 0x0, 0x0, 0x23,
    0x34, 0x53, 0x33, 0x15, 0xf0, 0x0, 0x0, 0x5e,
    0xdc, 0xe9, 0x0, 0x5f, 0x0, 0x0, 0xf, 0x50,
    0x1, 0xe6, 0x5, 0xf2, 0x20, 0x1, 0xf4, 0x0,
    0xe, 0x60, 0x5f, 0xff, 0x10, 0x6, 0xec, 0xbe,
    0xa0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0x10,
    0x1, 0x5f, 0x0, 0x2, 0xaa, 0xad, 0xfc, 0xef,
    0xc5, 0xf0, 0x0, 0x17, 0x66, 0x55, 0x32, 0x0,
    0x5f, 0x0, 0x0, 0x1, 0xd2, 0x0, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x2, 0xf7, 0x55, 0x55, 0x55, 0x52,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0,

    /* U+D65C "활" */
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x5f, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0x65, 0xf0, 0x0, 0x0,
    0x5, 0x88, 0x72, 0x0, 0x5f, 0x0, 0x0, 0xd,
    0xb6, 0x69, 0xf3, 0x5, 0xf5, 0x50, 0x1, 0xf4,
    0x0, 0xd, 0x70, 0x5f, 0xcc, 0x10, 0x7, 0xed,
    0xde, 0xa1, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x7f,
    0x1, 0x23, 0x5f, 0x0, 0x2, 0xee, 0xef, 0xfe,
    0xdb, 0x85, 0xf0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x28, 0x0, 0x0, 0x5, 0xee, 0xee, 0xee,
    0xef, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0x5, 0xfe, 0xee, 0xee, 0xee,
    0xe0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfd, 0xdd, 0xdd, 0xdd, 0xd7,
    0x0,

    /* U+D6C4 "후" */
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x5,
    0xbb, 0xbb, 0xdf, 0xbb, 0xbb, 0xb1, 0x2, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x50, 0x0, 0x1, 0x7b,
    0xdd, 0xca, 0x50, 0x0, 0x0, 0x1e, 0xc5, 0x22,
    0x37, 0xe9, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0x2f, 0x81, 0x0, 0x2, 0xcc,
    0x0, 0x0, 0x4, 0xbf, 0xed, 0xee, 0x91, 0x0,
    0x0, 0x0, 0x0, 0x12, 0x10, 0x0, 0x0, 0x2d,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdc, 0x4, 0x44,
    0x44, 0x7f, 0x44, 0x44, 0x43, 0x0, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x0,
    0x0, 0x0,

    /* U+FF01 "！" */
    0x1f, 0xa1, 0xfa, 0xf, 0x90, 0xf8, 0xe, 0x70,
    0xe7, 0xd, 0x60, 0xc5, 0x1, 0x0, 0x0, 0x1f,
    0x92, 0xfa, 0x0, 0x0,

    /* U+FF0C "，" */
    0x1c, 0xa0, 0x4f, 0xf3, 0x5, 0xf3, 0x3, 0xe0,
    0x5e, 0x40, 0x52, 0x0,

    /* U+FF1A "：" */
    0x1, 0x10, 0x1f, 0xf1, 0x1f, 0xf1, 0x1, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x30, 0x2f, 0xf2, 0x1e, 0xe1, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 67, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 69, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18, .adv_w = 104, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 31, .adv_w = 165, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 91, .adv_w = 146, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 154, .adv_w = 213, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 232, .adv_w = 187, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 304, .adv_w = 58, .box_w = 2, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 309, .adv_w = 77, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 347, .adv_w = 77, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 385, .adv_w = 141, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 421, .adv_w = 146, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 457, .adv_w = 69, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 467, .adv_w = 82, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 475, .adv_w = 69, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 480, .adv_w = 95, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 516, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 570, .adv_w = 146, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 600, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 654, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 708, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 762, .adv_w = 146, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 810, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 864, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 918, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 972, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1026, .adv_w = 69, .box_w = 3, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1040, .adv_w = 69, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1064, .adv_w = 146, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1109, .adv_w = 146, .box_w = 9, .box_h = 5, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 1132, .adv_w = 146, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 1177, .adv_w = 111, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1219, .adv_w = 230, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1317, .adv_w = 164, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1383, .adv_w = 166, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1437, .adv_w = 162, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1497, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1557, .adv_w = 142, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1599, .adv_w = 133, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1641, .adv_w = 186, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1707, .adv_w = 190, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1767, .adv_w = 87, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1797, .adv_w = 70, .box_w = 5, .box_h = 16, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 1837, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1891, .adv_w = 134, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1933, .adv_w = 232, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2005, .adv_w = 195, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2065, .adv_w = 200, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2137, .adv_w = 155, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2185, .adv_w = 200, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2275, .adv_w = 159, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2329, .adv_w = 141, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2383, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2437, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2497, .adv_w = 154, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2557, .adv_w = 238, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2647, .adv_w = 150, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2707, .adv_w = 145, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2767, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2821, .adv_w = 84, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2851, .adv_w = 95, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2887, .adv_w = 84, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2917, .adv_w = 146, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 2953, .adv_w = 114, .box_w = 9, .box_h = 2, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2962, .adv_w = 72, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 2968, .adv_w = 144, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3004, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3052, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3088, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3142, .adv_w = 144, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3183, .adv_w = 88, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3225, .adv_w = 157, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3284, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3332, .adv_w = 66, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3344, .adv_w = 66, .box_w = 4, .box_h = 16, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 3376, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3424, .adv_w = 66, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3436, .adv_w = 239, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3495, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3531, .adv_w = 155, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3572, .adv_w = 157, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 3624, .adv_w = 157, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 3683, .adv_w = 106, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3710, .adv_w = 123, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3742, .adv_w = 92, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3775, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3811, .adv_w = 130, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3852, .adv_w = 201, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3911, .adv_w = 135, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3952, .adv_w = 131, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4011, .adv_w = 120, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4043, .adv_w = 97, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4088, .adv_w = 141, .box_w = 2, .box_h = 16, .ofs_x = 3, .ofs_y = -4},
    {.bitmap_index = 4104, .adv_w = 97, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4149, .adv_w = 146, .box_w = 9, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4163, .adv_w = 69, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4181, .adv_w = 146, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4223, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4277, .adv_w = 146, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 4313, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4367, .adv_w = 141, .box_w = 2, .box_h = 16, .ofs_x = 3, .ofs_y = -4},
    {.bitmap_index = 4383, .adv_w = 131, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4431, .adv_w = 148, .box_w = 5, .box_h = 2, .ofs_x = 2, .ofs_y = 10},
    {.bitmap_index = 4436, .adv_w = 213, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4514, .adv_w = 91, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 4529, .adv_w = 130, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4561, .adv_w = 146, .box_w = 9, .box_h = 5, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4584, .adv_w = 82, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 4592, .adv_w = 213, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4670, .adv_w = 128, .box_w = 10, .box_h = 2, .ofs_x = -1, .ofs_y = 12},
    {.bitmap_index = 4680, .adv_w = 110, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 4695, .adv_w = 146, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4740, .adv_w = 90, .box_w = 5, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 4758, .adv_w = 90, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 4779, .adv_w = 72, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4785, .adv_w = 159, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4837, .adv_w = 168, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4905, .adv_w = 69, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 4910, .adv_w = 58, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4920, .adv_w = 90, .box_w = 4, .box_h = 7, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 4934, .adv_w = 96, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 4952, .adv_w = 130, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4984, .adv_w = 191, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5056, .adv_w = 197, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5134, .adv_w = 200, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5212, .adv_w = 111, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5258, .adv_w = 164, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5346, .adv_w = 164, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5434, .adv_w = 164, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5522, .adv_w = 164, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5605, .adv_w = 164, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5688, .adv_w = 164, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5771, .adv_w = 226, .box_w = 15, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5861, .adv_w = 162, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5941, .adv_w = 142, .box_w = 7, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5997, .adv_w = 142, .box_w = 7, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6053, .adv_w = 142, .box_w = 7, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6109, .adv_w = 142, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6162, .adv_w = 87, .box_w = 5, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6202, .adv_w = 87, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6250, .adv_w = 87, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6298, .adv_w = 87, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6336, .adv_w = 187, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6402, .adv_w = 195, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6477, .adv_w = 200, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6573, .adv_w = 200, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6669, .adv_w = 200, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6765, .adv_w = 200, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6855, .adv_w = 200, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6945, .adv_w = 146, .box_w = 8, .box_h = 8, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 6977, .adv_w = 200, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7061, .adv_w = 187, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7141, .adv_w = 187, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7221, .adv_w = 187, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7301, .adv_w = 187, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7376, .adv_w = 145, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7456, .adv_w = 155, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7504, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7558, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7606, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7654, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7702, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7750, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7798, .adv_w = 144, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7854, .adv_w = 221, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7917, .adv_w = 123, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7969, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8023, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8077, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8131, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8185, .adv_w = 66, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8215, .adv_w = 66, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8239, .adv_w = 66, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8275, .adv_w = 66, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8311, .adv_w = 155, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8370, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8418, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8472, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8526, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8580, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8634, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8688, .adv_w = 146, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 8724, .adv_w = 155, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8774, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8822, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8870, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8918, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8966, .adv_w = 131, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9038, .adv_w = 157, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9102, .adv_w = 131, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9174, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9222, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9281, .adv_w = 123, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9329, .adv_w = 162, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9409, .adv_w = 123, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9457, .adv_w = 157, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9529, .adv_w = 187, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9595, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9655, .adv_w = 144, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9714, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9768, .adv_w = 157, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 9840, .adv_w = 66, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9849, .adv_w = 66, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9879, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9927, .adv_w = 66, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9963, .adv_w = 155, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10017, .adv_w = 106, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10053, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10095, .adv_w = 141, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10167, .adv_w = 123, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10213, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10255, .adv_w = 92, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10303, .adv_w = 158, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10359, .adv_w = 120, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10401, .adv_w = 120, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10443, .adv_w = 120, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10485, .adv_w = 173, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10540, .adv_w = 123, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10586, .adv_w = 92, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 10631, .adv_w = 184, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10697, .adv_w = 164, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10763, .adv_w = 166, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10817, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10859, .adv_w = 142, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10901, .adv_w = 190, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10961, .adv_w = 156, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11021, .adv_w = 232, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11093, .adv_w = 195, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11153, .adv_w = 200, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11225, .adv_w = 187, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11285, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11339, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11393, .adv_w = 216, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11471, .adv_w = 150, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11531, .adv_w = 159, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11596, .adv_w = 120, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11642, .adv_w = 156, .box_w = 8, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 11710, .adv_w = 85, .box_w = 4, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11736, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11781, .adv_w = 157, .box_w = 8, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 11849, .adv_w = 132, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 11901, .adv_w = 151, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11960, .adv_w = 120, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11992, .adv_w = 118, .box_w = 8, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12060, .adv_w = 156, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12112, .adv_w = 152, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12171, .adv_w = 85, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12189, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12225, .adv_w = 133, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12284, .adv_w = 160, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12343, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12379, .adv_w = 125, .box_w = 8, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12447, .adv_w = 155, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12488, .adv_w = 167, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12538, .adv_w = 154, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 12590, .adv_w = 125, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12642, .adv_w = 157, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12687, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12723, .adv_w = 153, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12759, .adv_w = 186, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12853, .adv_w = 152, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 12918, .adv_w = 192, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 13003, .adv_w = 205, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13053, .adv_w = 155, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13112, .adv_w = 153, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13164, .adv_w = 205, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13236, .adv_w = 73, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13248, .adv_w = 70, .box_w = 5, .box_h = 16, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 13288, .adv_w = 163, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13354, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13408, .adv_w = 166, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13462, .adv_w = 130, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13504, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13558, .adv_w = 194, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13618, .adv_w = 160, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13672, .adv_w = 232, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13744, .adv_w = 190, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13804, .adv_w = 195, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13876, .adv_w = 188, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13936, .adv_w = 155, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13984, .adv_w = 164, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14044, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14098, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14158, .adv_w = 172, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14212, .adv_w = 142, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14248, .adv_w = 153, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14311, .adv_w = 144, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14347, .adv_w = 112, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14374, .adv_w = 155, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14434, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14475, .adv_w = 194, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14534, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14570, .adv_w = 159, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14606, .adv_w = 159, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14654, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14690, .adv_w = 150, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14731, .adv_w = 197, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14776, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14812, .adv_w = 152, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14853, .adv_w = 155, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14889, .adv_w = 156, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 14941, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14977, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15013, .adv_w = 130, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15072, .adv_w = 189, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15174, .adv_w = 131, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15215, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 15269, .adv_w = 151, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15310, .adv_w = 229, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15364, .adv_w = 230, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 15448, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15493, .adv_w = 194, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15538, .adv_w = 140, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15570, .adv_w = 205, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15624, .adv_w = 148, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15660, .adv_w = 158, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 15737, .adv_w = 66, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15749, .adv_w = 66, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15773, .adv_w = 66, .box_w = 4, .box_h = 16, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 15805, .adv_w = 220, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15868, .adv_w = 228, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15927, .adv_w = 159, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15986, .adv_w = 84, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15992, .adv_w = 60, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 16031, .adv_w = 60, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16061, .adv_w = 61, .box_w = 4, .box_h = 17, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 16095, .adv_w = 195, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 16167, .adv_w = 61, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 16179, .adv_w = 254, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16259, .adv_w = 104, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16292, .adv_w = 254, .box_w = 16, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16364, .adv_w = 254, .box_w = 16, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16444, .adv_w = 164, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 16519, .adv_w = 164, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 16594, .adv_w = 164, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 16679, .adv_w = 122, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16707, .adv_w = 122, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16746, .adv_w = 94, .box_w = 6, .box_h = 10, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 16776, .adv_w = 94, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 16815, .adv_w = 310, .box_w = 19, .box_h = 11, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 16920, .adv_w = 310, .box_w = 19, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17063, .adv_w = 334, .box_w = 21, .box_h = 11, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17179, .adv_w = 334, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17326, .adv_w = 202, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17392, .adv_w = 202, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17458, .adv_w = 130, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 17538, .adv_w = 130, .box_w = 10, .box_h = 18, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 17628, .adv_w = 69, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17634, .adv_w = 252, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17722, .adv_w = 198, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17806, .adv_w = 226, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17883, .adv_w = 178, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 17971, .adv_w = 124, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 18027, .adv_w = 175, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18099, .adv_w = 172, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18149, .adv_w = 114, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18184, .adv_w = 195, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18256, .adv_w = 195, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -7},
    {.bitmap_index = 18340, .adv_w = 0, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 18353, .adv_w = 0, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 18363, .adv_w = 254, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 18459, .adv_w = 94, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 18504, .adv_w = 225, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18594, .adv_w = 225, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18699, .adv_w = 195, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18771, .adv_w = 0, .box_w = 7, .box_h = 4, .ofs_x = -6, .ofs_y = 11},
    {.bitmap_index = 18785, .adv_w = 0, .box_w = 2, .box_h = 3, .ofs_x = -3, .ofs_y = 11},
    {.bitmap_index = 18788, .adv_w = 52, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 18806, .adv_w = 196, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18871, .adv_w = 262, .box_w = 17, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18956, .adv_w = 126, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 19015, .adv_w = 140, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19065, .adv_w = 142, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19125, .adv_w = 197, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19190, .adv_w = 209, .box_w = 14, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19260, .adv_w = 144, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19310, .adv_w = 163, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19365, .adv_w = 190, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19430, .adv_w = 129, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19475, .adv_w = 137, .box_w = 10, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19525, .adv_w = 185, .box_w = 12, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19585, .adv_w = 146, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19640, .adv_w = 164, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19695, .adv_w = 136, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19749, .adv_w = 157, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19804, .adv_w = 142, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19854, .adv_w = 145, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19904, .adv_w = 197, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19969, .adv_w = 146, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20019, .adv_w = 180, .box_w = 12, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20079, .adv_w = 153, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20129, .adv_w = 148, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20179, .adv_w = 105, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20218, .adv_w = 174, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20284, .adv_w = 142, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20334, .adv_w = 174, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20400, .adv_w = 148, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20450, .adv_w = 173, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20516, .adv_w = 136, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 20575, .adv_w = 0, .box_w = 3, .box_h = 3, .ofs_x = -6, .ofs_y = -4},
    {.bitmap_index = 20580, .adv_w = 66, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20605, .adv_w = 66, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20689, .adv_w = 66, .box_w = 9, .box_h = 14, .ofs_x = -4, .ofs_y = 0},
    {.bitmap_index = 20752, .adv_w = 0, .box_w = 9, .box_h = 6, .ofs_x = -8, .ofs_y = -5},
    {.bitmap_index = 20779, .adv_w = 0, .box_w = 9, .box_h = 6, .ofs_x = -6, .ofs_y = -5},
    {.bitmap_index = 20806, .adv_w = 0, .box_w = 6, .box_h = 6, .ofs_x = -5, .ofs_y = -5},
    {.bitmap_index = 20824, .adv_w = 0, .box_w = 6, .box_h = 6, .ofs_x = -7, .ofs_y = 9},
    {.bitmap_index = 20842, .adv_w = 0, .box_w = 6, .box_h = 6, .ofs_x = -7, .ofs_y = 9},
    {.bitmap_index = 20860, .adv_w = 66, .box_w = 7, .box_h = 14, .ofs_x = -2, .ofs_y = 0},
    {.bitmap_index = 20909, .adv_w = 66, .box_w = 8, .box_h = 14, .ofs_x = -3, .ofs_y = 0},
    {.bitmap_index = 20965, .adv_w = 0, .box_w = 6, .box_h = 5, .ofs_x = -3, .ofs_y = -5},
    {.bitmap_index = 20980, .adv_w = 154, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21016, .adv_w = 140, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21052, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21088, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21124, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21160, .adv_w = 155, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21196, .adv_w = 141, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21232, .adv_w = 142, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21268, .adv_w = 233, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21327, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21368, .adv_w = 163, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21404, .adv_w = 154, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21440, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21476, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21512, .adv_w = 155, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21548, .adv_w = 155, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21596, .adv_w = 166, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21632, .adv_w = 178, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21682, .adv_w = 175, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21748, .adv_w = 154, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21789, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21825, .adv_w = 152, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21861, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21897, .adv_w = 146, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21933, .adv_w = 126, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21965, .adv_w = 146, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22010, .adv_w = 150, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22046, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22087, .adv_w = 143, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22132, .adv_w = 87, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22155, .adv_w = 0, .box_w = 7, .box_h = 4, .ofs_x = -6, .ofs_y = 9},
    {.bitmap_index = 22169, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22196, .adv_w = 104, .box_w = 11, .box_h = 13, .ofs_x = -5, .ofs_y = 0},
    {.bitmap_index = 22268, .adv_w = 0, .box_w = 8, .box_h = 2, .ofs_x = -9, .ofs_y = 9},
    {.bitmap_index = 22276, .adv_w = 0, .box_w = 8, .box_h = 4, .ofs_x = -9, .ofs_y = 9},
    {.bitmap_index = 22292, .adv_w = 0, .box_w = 8, .box_h = 4, .ofs_x = -9, .ofs_y = 9},
    {.bitmap_index = 22308, .adv_w = 0, .box_w = 8, .box_h = 4, .ofs_x = -9, .ofs_y = 9},
    {.bitmap_index = 22324, .adv_w = 0, .box_w = 3, .box_h = 4, .ofs_x = -4, .ofs_y = -4},
    {.bitmap_index = 22330, .adv_w = 0, .box_w = 6, .box_h = 4, .ofs_x = -7, .ofs_y = -4},
    {.bitmap_index = 22342, .adv_w = 76, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22360, .adv_w = 145, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22396, .adv_w = 79, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22435, .adv_w = 74, .box_w = 5, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22468, .adv_w = 78, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 22507, .adv_w = 0, .box_w = 7, .box_h = 4, .ofs_x = -8, .ofs_y = 10},
    {.bitmap_index = 22521, .adv_w = 0, .box_w = 2, .box_h = 4, .ofs_x = -3, .ofs_y = 10},
    {.bitmap_index = 22525, .adv_w = 0, .box_w = 6, .box_h = 4, .ofs_x = -6, .ofs_y = 9},
    {.bitmap_index = 22537, .adv_w = 0, .box_w = 5, .box_h = 3, .ofs_x = -5, .ofs_y = 9},
    {.bitmap_index = 22545, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22593, .adv_w = 144, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22649, .adv_w = 144, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22712, .adv_w = 144, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22768, .adv_w = 144, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22828, .adv_w = 144, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22884, .adv_w = 144, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22947, .adv_w = 144, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23001, .adv_w = 144, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23064, .adv_w = 144, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23132, .adv_w = 144, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23200, .adv_w = 66, .box_w = 2, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 23215, .adv_w = 155, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23285, .adv_w = 155, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23348, .adv_w = 155, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23416, .adv_w = 155, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23484, .adv_w = 158, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23550, .adv_w = 158, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23616, .adv_w = 158, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23693, .adv_w = 158, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23770, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 23818, .adv_w = 158, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23874, .adv_w = 173, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23951, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23951, .adv_w = 256, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23966, .adv_w = 256, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23981, .adv_w = 256, .box_w = 13, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24066, .adv_w = 256, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24143, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 24241, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 24346, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 24451, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 24571, .adv_w = 256, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24655, .adv_w = 256, .box_w = 9, .box_h = 15, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 24723, .adv_w = 256, .box_w = 12, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24801, .adv_w = 256, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24885, .adv_w = 256, .box_w = 12, .box_h = 15, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 24975, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25080, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 25185, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25283, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25388, .adv_w = 256, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25486, .adv_w = 256, .box_w = 12, .box_h = 10, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 25546, .adv_w = 256, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25623, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25714, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25805, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 25903, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26001, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26092, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26197, .adv_w = 256, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 26281, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26386, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26491, .adv_w = 256, .box_w = 10, .box_h = 15, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 26566, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26679, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 26784, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26889, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26980, .adv_w = 256, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 27052, .adv_w = 256, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 27143, .adv_w = 256, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 27227, .adv_w = 256, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 27304, .adv_w = 256, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 27376, .adv_w = 256, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 27467, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 27565, .adv_w = 256, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 27656, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27784, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 27897, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28009, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 28107, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 28212, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 28303, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28408, .adv_w = 256, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 28506, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 28634, .adv_w = 256, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 28706, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 28804, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 28917, .adv_w = 256, .box_w = 9, .box_h = 13, .ofs_x = 5, .ofs_y = 0},
    {.bitmap_index = 28976, .adv_w = 256, .box_w = 10, .box_h = 13, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 29041, .adv_w = 256, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 29118, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 29216, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 29329, .adv_w = 256, .box_w = 12, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 29407, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 29512, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 29610, .adv_w = 256, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29706, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 29797, .adv_w = 256, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 29874, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 29972, .adv_w = 256, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 30063, .adv_w = 256, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 30135, .adv_w = 256, .box_w = 12, .box_h = 9, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 30189, .adv_w = 256, .box_w = 10, .box_h = 10, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 30239, .adv_w = 256, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 30330, .adv_w = 256, .box_w = 10, .box_h = 14, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 30400, .adv_w = 256, .box_w = 15, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 30498, .adv_w = 256, .box_w = 12, .box_h = 13, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 30576, .adv_w = 256, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 30648, .adv_w = 256, .box_w = 12, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 30726, .adv_w = 256, .box_w = 13, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 30811, .adv_w = 256, .box_w = 14, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 30825, .adv_w = 256, .box_w = 16, .box_h = 2, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 30841, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 30953, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 31065, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 31163, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 31268, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31388, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31516, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 31636, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31764, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31892, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32020, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32148, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32268, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32396, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32524, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32644, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 32742, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32862, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32982, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33102, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 33207, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33320, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33448, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33576, .adv_w = 256, .box_w = 17, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33712, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 33832, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33960, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 34072, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34192, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34320, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34440, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34568, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 34681, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34801, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34921, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35041, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 35146, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 35251, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35379, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35491, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35611, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35731, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35859, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35979, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36099, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36227, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36355, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36483, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36603, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 36716, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36844, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36972, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37092, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37212, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 37317, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37445, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37573, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37693, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 37805, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37933, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38061, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 38181, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38309, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 38421, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 38541, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38654, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 38774, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38902, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39030, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 39150, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39263, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39383, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 39503, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39631, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 39743, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39863, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39983, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40103, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40231, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40359, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40487, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 40607, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40727, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 40840, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 40953, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41073, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41185, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41297, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41417, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41530, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41650, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41763, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41875, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41995, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 42107, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 42227, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42347, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42467, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42587, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42715, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 42827, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42947, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 43067, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43195, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43315, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 43420, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43533, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43653, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43781, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43901, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44021, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44149, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 44262, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44382, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44510, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44638, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44766, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 44886, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45006, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45126, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45246, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45359, .adv_w = 256, .box_w = 14, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 45457, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 45577, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45705, .adv_w = 256, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 45817, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 45937, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 46057, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46185, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46313, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 46433, .adv_w = 256, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 46553, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46681, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46809, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 46929, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47057, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47185, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47305, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47433, .adv_w = 256, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47569, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 47689, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47817, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47945, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 48050, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 48170, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 48290, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48418, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48546, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48666, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48794, .adv_w = 256, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 48906, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49034, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49162, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49290, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 49410, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 49530, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49658, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49786, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49914, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50042, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 50162, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50290, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50418, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50546, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50666, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 50786, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50914, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51042, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51162, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51290, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 51410, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51538, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51666, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51786, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51914, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 52019, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52139, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52267, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52387, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52515, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52643, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52763, .adv_w = 256, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52883, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 52995, .adv_w = 256, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 53108, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 53220, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 53348, .adv_w = 256, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 53460, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 53565, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 53670, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 53775, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 53880, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 53985, .adv_w = 256, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 54097, .adv_w = 256, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 54202, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54330, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54458, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54586, .adv_w = 256, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54714, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 54819, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 54924, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55029, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 55113, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 55204, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 55295, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55386, .adv_w = 236, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 55470, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55568, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55673, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55771, .adv_w = 236, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 55855, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55946, .adv_w = 236, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 56030, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56128, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56219, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56303, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 56401, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 56499, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56583, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56681, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56779, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56863, .adv_w = 236, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 56961, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57052, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57150, .adv_w = 236, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57234, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57332, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 57416, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 57500, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 57584, .adv_w = 236, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57682, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57787, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57885, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57983, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58067, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58165, .adv_w = 236, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58256, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58354, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58438, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58522, .adv_w = 236, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58613, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58711, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 58816, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 58900, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59005, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59110, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59215, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59313, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59404, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59502, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59593, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59691, .adv_w = 236, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 59796, .adv_w = 236, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 59887, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 59985, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60083, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60181, .adv_w = 236, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 60272, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60370, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60461, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60552, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 60650, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 60734, .adv_w = 236, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 60839, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60937, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 61028, .adv_w = 236, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 61119, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61224, .adv_w = 236, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 61322, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61420, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61518, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61609, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61707, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61805, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 61903, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 61987, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 62078, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 62162, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62267, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62365, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62456, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62547, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62645, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62743, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62841, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 62932, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 63030, .adv_w = 236, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 63143, .adv_w = 236, .box_w = 14, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 63234, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 63325, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 63423, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 63514, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 63619, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 63717, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 63801, .adv_w = 236, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 63885, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 63976, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 64060, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 64144, .adv_w = 236, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 64228, .adv_w = 236, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 64341, .adv_w = 236, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64432, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64537, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64642, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64747, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64852, .adv_w = 236, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 64965, .adv_w = 236, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 65078, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 65183, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 65288, .adv_w = 236, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 65401, .adv_w = 236, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 65506, .adv_w = 236, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 65604, .adv_w = 256, .box_w = 3, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 65624, .adv_w = 256, .box_w = 4, .box_h = 6, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 65636, .adv_w = 256, .box_w = 4, .box_h = 12, .ofs_x = 2, .ofs_y = -1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe,
    0x16, 0x18, 0x1c, 0x2e, 0x3b, 0x3e, 0x3f, 0x4e,
    0x56, 0x58, 0x5b, 0x5c, 0x5e, 0x62, 0x6c, 0x77,
    0x79, 0x7b, 0xad, 0x116, 0x118, 0x285, 0x28e, 0x28f,
    0x290, 0x292, 0x294, 0x298, 0x299, 0x29a, 0x29c, 0x29d,
    0x2a0, 0x2a1, 0x2a3, 0x2a4, 0x2a9, 0x2aa, 0x2ab, 0x2ac
};

static const uint16_t unicode_list_4[] = {
    0x0, 0x1, 0x2, 0x3a, 0x3c, 0x44, 0x45, 0x46,
    0x47, 0x4b, 0x4c, 0x4e, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x5b
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0x1be, 0x1d4, 0x1d5
};

static const uint16_t unicode_list_9[] = {
    0x0, 0x2f, 0x49, 0x5a, 0x60, 0x7d, 0x2b2, 0x2b3,
    0x2b4, 0x2b6, 0x2b7, 0x2b8, 0x2ba, 0x2c0, 0x2c6, 0x2c7,
    0x2c8, 0x2cb, 0x2cd, 0x2d0, 0x2d2, 0x2d4, 0x2d5, 0x2d6,
    0x2d7, 0x2d8, 0x2d9, 0x2db, 0x2dc, 0x2dd, 0x2de, 0x2df,
    0x2e0, 0x2e1, 0x2e3, 0x2e6, 0x2e7, 0x2e8, 0x2e9, 0x2ea,
    0x2ed, 0x2ef, 0x2f0, 0x2f1, 0x2f2, 0x2f3, 0x2f4, 0x2f8,
    0x2f9, 0x2fa, 0x2fc, 0x2fe, 0x7b2, 0x7b3, 0x7b5, 0x7b8,
    0x7b9, 0x7ba, 0x7bb, 0x7bc, 0x7c4, 0x7c5, 0x7c6, 0x7c7,
    0x7c8, 0x7ca, 0x7cb, 0x7cc, 0x7cd, 0x7cf, 0x7d0, 0x7d1,
    0x7d2, 0x7d3, 0x7d4, 0x7d6, 0x7d8, 0x7db, 0x7dc, 0x7de,
    0x7df, 0x7e1, 0x7e2, 0x7e3, 0x7e4, 0x7e5, 0x7e6, 0x7e7,
    0x7e8, 0x7e9, 0x7ea, 0x7f1, 0x7f2, 0x7f3, 0x7f4, 0x7f5,
    0x7f8, 0x7f9, 0x7fa, 0x7fd, 0x1852, 0x1854, 0x1856, 0x1858,
    0x185e, 0x1860, 0x186c, 0x186e, 0x1870, 0x1874, 0x1878, 0x187c,
    0x1882, 0x1884, 0x1888, 0x188a, 0x188c, 0x188e, 0x1890, 0x1894,
    0x1896, 0x1898, 0x189e, 0x19bd, 0x29b2, 0x29b3, 0x29f5, 0x29f7,
    0x29f9, 0x29fb, 0x29fc, 0x29fd, 0x29fe, 0x2a00, 0x2a04, 0x2a06,
    0x2a08, 0x2a0a, 0x2a0c, 0x2a10, 0x2a11, 0x2a12, 0x2a14, 0x2a15,
    0x2a17, 0x2a18, 0x2a1b, 0x2a1c, 0x2a1f, 0x2a20, 0x2a2f, 0x2a30,
    0x2a33, 0x2a3b, 0x2a3d, 0x2a43, 0x2a44, 0x2a53, 0x2a54, 0x2a55,
    0x2a57, 0x2a59, 0x2a5a, 0x2a5c, 0x2a5e, 0x2a60, 0x2a61, 0x2a66,
    0x2a67, 0x2a68, 0x2a69, 0x2a6a, 0x2a6c, 0x2a70, 0x2a71, 0x2a74,
    0x2a77, 0x2a78, 0x2a79, 0x2a7a, 0x2a7c, 0x2a7e, 0x2a81, 0x2a86,
    0x2a87, 0x2a88, 0x2a8a, 0x2a8f, 0x2a90, 0x2a91, 0x2a93, 0x2a94,
    0x2a96, 0x2a98, 0x2a9a, 0x2a9b, 0x2a9c, 0x2a9d, 0x2a9e, 0x2aa0,
    0x2aa4, 0x2aad, 0x47b1, 0x47bc, 0x47be, 0x47de, 0x4837, 0x48eb,
    0x48ff, 0x4911, 0x4992, 0x49ca, 0x4a4a, 0x4af6, 0x4af9, 0x4b16,
    0x4b24, 0x4b3e, 0x4bab, 0x4bb8, 0x4bce, 0x4bda, 0x4be1, 0x4c51,
    0x4c52, 0x4c6a, 0x4c8a, 0x4cc7, 0x4cf8, 0x4d12, 0x4d7c, 0x4d82,
    0x4da0, 0x4dbf, 0x4ddd, 0x4de0, 0x4dfb, 0x4e2e, 0x4e7e, 0x4f00,
    0x4f10, 0x5019, 0x50d9, 0x51e2, 0x52b8, 0x52d8, 0x52e2, 0x532e,
    0x537c, 0x553d, 0x554b, 0x55ac, 0x55b7, 0x55b8, 0x55bc, 0x55c2,
    0x57a3, 0x5845, 0x5857, 0x58b1, 0x58c0, 0x5906, 0x5936, 0x593d,
    0x598d, 0x59b2, 0x5a20, 0x5a76, 0x5afc, 0x5b7a, 0x5bc2, 0x5bfc,
    0x5c1c, 0x5c2f, 0x5cf0, 0x5d13, 0x5d34, 0x5d53, 0x5d56, 0x5d80,
    0x5d83, 0x5d8c, 0x5f08, 0x5f61, 0x5f91, 0x5fa7, 0x5ff3, 0x60a5,
    0x60b0, 0x60b1, 0x60ba, 0x60bc, 0x60be, 0x60d0, 0x60dd, 0x60eb,
    0x6196, 0x6271, 0x62cd, 0x63d2, 0x6410, 0x6453, 0x6514, 0x6686,
    0x66ec, 0x66f2, 0x66fc, 0x6700, 0x67dd, 0x6831, 0x6841, 0x6892,
    0x68b0, 0x6971, 0x69c0, 0x6a6a, 0x6a9e, 0x6ad2, 0x6bf9, 0x6c67,
    0x6c71, 0x6d61, 0x6daf, 0x6ed9, 0x6ee6, 0x702c, 0x702d, 0x7035,
    0x726b, 0x7383, 0x73be, 0x74fa, 0x7505, 0x76ac, 0x76cb, 0x76f3,
    0x76f5, 0x7712, 0x7722, 0x774b, 0x7763, 0x7858, 0x7875, 0x788d,
    0x7890, 0x7902, 0x79f7, 0x7a2e, 0x7aae, 0x81fd, 0x833c, 0x836e,
    0x8379, 0x83bb, 0x83db, 0x83de, 0x8417, 0x8422, 0x843e, 0x8455,
    0x845b, 0x845e, 0x847c, 0x8517, 0x856f, 0x8570, 0x8586, 0x858e,
    0x85a0, 0x85a5, 0x85a8, 0x8678, 0x86d6, 0x86f5, 0x8736, 0x8764,
    0x87a0, 0x88ba, 0x892e, 0x896d, 0x898c, 0x898f, 0x89b2, 0x89d4,
    0x8a05, 0x8afe, 0x8b7e, 0x8b80, 0x8ce0, 0x8eca, 0x8f3a, 0x8f3c,
    0x8f44, 0x8f8d, 0x8f9e, 0x8f9f, 0x90ac, 0x910a, 0x910d, 0x91a4,
    0x91b0, 0xa5b1, 0xa5b5, 0xa5c1, 0xa621, 0xa65d, 0xa661, 0xa66e,
    0xa691, 0xa6a6, 0xa6ad, 0xa71d, 0xa7a9, 0xa7e1, 0xa9f5, 0xaa49,
    0xaad5, 0xab06, 0xac45, 0xac56, 0xac79, 0xac95, 0xaca6, 0xacb1,
    0xad75, 0xadd9, 0xae79, 0xae8d, 0xae94, 0xaeda, 0xb1b9, 0xb1d5,
    0xb20d, 0xb309, 0xb319, 0xb32d, 0xb35d, 0xb381, 0xb459, 0xb5cd,
    0xb5e1, 0xb635, 0xb6a5, 0xb6ad, 0xb731, 0xb7f5, 0xba5d, 0xba6e,
    0xba72, 0xba79, 0xbacd, 0xbad5, 0xbae2, 0xbae9, 0xbafc, 0xbb3d,
    0xbb3e, 0xbb52, 0xbbc9, 0xbc55, 0xbc66, 0xbc8d, 0xbc95, 0xbef9,
    0xbf76, 0xbf77, 0xbf81, 0xbfa1, 0xbfd5, 0xbff5, 0xc045, 0xc05a,
    0xc065, 0xc07d, 0xc0f5, 0xc0fd, 0xc102, 0xc125, 0xc129, 0xc136,
    0xc151, 0xc1b5, 0xc1c2, 0xc1c6, 0xc222, 0xc2ad, 0xc2c2, 0xc371,
    0xc375, 0xc5ef, 0xc6b9, 0xc70d, 0xc75a, 0xc80d, 0xc825, 0xc845,
    0xc8cd, 0xca1d, 0xca8d, 0xcae1, 0xcb0d, 0xcc69, 0xccd0, 0xccd9,
    0xcf09, 0xcf0d, 0xcf11, 0xcf1a, 0xcf1c, 0xcf39, 0xd005, 0xd006,
    0xd009, 0xd00d, 0xd075, 0xf8b2, 0xf8bd, 0xf8cb
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 161, .range_length = 95, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 259, .range_length = 685, .glyph_id_start = 191,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 48, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 945, .range_length = 25, .glyph_id_start = 239,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 972, .range_length = 92, .glyph_id_start = 264,
        .unicode_list = unicode_list_4, .glyph_id_ofs_list = NULL, .list_length = 21, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1072, .range_length = 29, .glyph_id_start = 285,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1102, .range_length = 470, .glyph_id_start = 314,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 12, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1573, .range_length = 22, .glyph_id_start = 326,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1600, .range_length = 12, .glyph_id_start = 348,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1615, .range_length = 63692, .glyph_id_start = 360,
        .unicode_list = unicode_list_9, .glyph_id_ofs_list = NULL, .list_length = 518, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    3, 0, 4, 5, 6, 7, 8, 0,
    9, 10, 0, 11, 12, 0, 13, 14,
    15, 16, 0, 17, 18, 19, 20, 21,
    22, 23, 24, 0, 25, 26, 0, 27,
    28, 0, 29, 30, 31, 32, 33, 34,
    35, 36, 37, 38, 0, 39, 40, 41,
    42, 43, 44, 45, 0, 0, 46, 47,
    48, 49, 50, 51, 0, 52, 0, 53,
    54, 0, 55, 56, 57, 58, 0, 59,
    60, 61, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 2, 3, 4,
    0, 5, 0, 6, 7, 8, 6, 6,
    0, 9, 10, 11, 11, 0, 12, 13,
    14, 15, 0, 0, 16, 17, 18, 19,
    20, 0, 0, 21, 0, 22, 23, 24,
    0, 25, 0, 26, 0, 27, 28, 29,
    30, 31, 31, 32, 33, 34, 34, 0,
    35, 0, 36, 36, 33, 37, 38, 39,
    39, 40, 41, 42, 33, 43, 0, 44,
    45, 0, 46, 0, 47, 48, 0, 0,
    49, 50, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 51, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -26, 0, 0,
    0, 0, 0, 0, -8, -8, 0, 0,
    0, 0, -8, -13, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -15, -5, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -15, -18,
    -13, 0, -5, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    -8, 0, 0, 0, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -8, -5, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    -18, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, -15, -8, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -20, -26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -18, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -8, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, -13, -8, 0, 0, -8, 0,
    -8, -8, 0, 0, 0, -15, -5, 0,
    0, 0, -5, -13, 0, -13, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -18, -10, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -8, 0, 0, 0, 0, -5, 0, -5,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, -10, 0, 0, 0, 0, 0,
    0, 0, -8, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, -8,
    0, -5, -8, 0, 0, 0, 0, 0,
    0, 0, 0, -10, -10, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, -10, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -18, 3, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, -8, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, -13, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -26, -26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -13, 0, 0, -13, -13, 0,
    0, -10, 0, -5, 0, 0, 0, 0,
    -10, 0, 0, -5, 0, -18, 0, 0,
    0, -3, 0, -10, -15, -26, -5, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -5, -5, 0, 0, 0, -8, 0, -10,
    -5, 0, 0, -5, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, -8, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -13, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -13, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, -10, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, 0, -8, -23, -20, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -10, 0, 0, 0, -8, 0, -10, 0,
    0, 0, -13, 0, 0, 0, 0, -20,
    0, 0, 0, -8, 0, 0, 0, -23,
    -18, -20, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, -18, -23, -23, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    -10, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, -18, -20, -18,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    -15, -5, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, -8, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, -15, 0, 0, 0, 0, 0, -13,
    -18, 0, 0, 0, 0, 0, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -18,
    -8, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -8, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -13, -13, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    -3, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -13, -8, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, 0, 0, 0, 0, -10, -8, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -18, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    -13, -5, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, -10, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 13,
    0, 3, -10, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, 5, 0, -5, -8, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    -8, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -13, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -13, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15,
    -15, 0, 0, 0, 0, 0, -13, 0,
    0, 0, 0, 0, -5, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, -5, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -5, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, 0, 0, -13, -15, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, -15, -15,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -13, -15, -15, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, -5, 0, -8,
    -8, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, -13, -3, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, -15, 0, 0, 0, 0, 0,
    0, -10, -10, 0, 0, 0, 0, 0,
    -5, -5, -5, -13, 0, 0, 0, 0,
    0, -3, -15, -15, 0, 0, -8, 0,
    0, 0, 0, 0, -13, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 61,
    .right_class_cnt     = 51,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 10,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t font_noto_basic_16_4 = {
#else
lv_font_t font_noto_basic_16_4 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 23,          /*The maximum line height required by the font*/
    .base_line = 7,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .fallback = NULL,
    .user_data = NULL
};



#endif /*#if FONT_NOTO_BASIC_16_4*/

