/*******************************************************************************
 * Size: 20 px
 * Bpp: 4
 * Opts: --force-fast-kern-format --no-compress --no-prefilter --font ttf/noto-basic.ttf --format lvgl --lv-include lvgl.h --bpp 4 -o src/font_noto_basic_20_4.c --size 20 -r 0x0-0xfffff
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef FONT_NOTO_BASIC_20_4
#define FONT_NOTO_BASIC_20_4 1
#endif

#if FONT_NOTO_BASIC_20_4

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x5f, 0xb4, 0xfb, 0x4f, 0xa3, 0xf9, 0x2f, 0x81,
    0xf8, 0x1f, 0x70, 0xf6, 0xf, 0x50, 0xe4, 0x4,
    0x12, 0xa6, 0x8f, 0xe4, 0xf9,

    /* U+0022 "\"" */
    0xaf, 0x20, 0xfd, 0x9f, 0x10, 0xeb, 0x8f, 0x0,
    0xda, 0x6e, 0x0, 0xc9, 0x5d, 0x0, 0xb8, 0x2,
    0x0, 0x11,

    /* U+0023 "#" */
    0x0, 0x0, 0x2f, 0x40, 0xd, 0x80, 0x0, 0x0,
    0x5, 0xf1, 0x0, 0xf5, 0x0, 0x0, 0x0, 0x8e,
    0x0, 0x3f, 0x20, 0x0, 0x1, 0x1c, 0xb1, 0x17,
    0xf1, 0x10, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x34, 0x5f, 0x74, 0x4e, 0xa4, 0x41, 0x0,
    0x4, 0xf1, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x3f, 0x30, 0x0, 0x1, 0x1a, 0xc1, 0x16,
    0xf2, 0x10, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x24, 0x5f, 0x84, 0x4d, 0xb4, 0x43, 0x0,
    0x3, 0xf2, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x6f,
    0x0, 0x3f, 0x30, 0x0, 0x0, 0xa, 0xc0, 0x6,
    0xf0, 0x0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xf5,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xeb, 0x60, 0x3f,
    0xe9, 0xfa, 0xae, 0x90, 0xaf, 0x20, 0xf5, 0x0,
    0x0, 0xbf, 0x0, 0xf5, 0x0, 0x0, 0x8f, 0x91,
    0xf5, 0x0, 0x0, 0xc, 0xff, 0xf9, 0x10, 0x0,
    0x0, 0x5b, 0xff, 0xfa, 0x10, 0x0, 0x0, 0xf9,
    0xbf, 0xd0, 0x0, 0x0, 0xf5, 0x9, 0xf4, 0x0,
    0x0, 0xf5, 0x7, 0xf4, 0x86, 0x20, 0xf7, 0x6e,
    0xe0, 0xcf, 0xff, 0xff, 0xfd, 0x30, 0x4, 0x78,
    0xf9, 0x30, 0x0, 0x0, 0x0, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x72, 0x0, 0x0,

    /* U+0025 "%" */
    0x0, 0xaf, 0xe8, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x8, 0xf5, 0x7f, 0x50, 0x0, 0x5f, 0x30, 0x0,
    0xd, 0x90, 0xc, 0xb0, 0x0, 0xea, 0x0, 0x0,
    0xf, 0x70, 0x9, 0xd0, 0x7, 0xf1, 0x0, 0x0,
    0xf, 0x70, 0x9, 0xe0, 0x1f, 0x80, 0x0, 0x0,
    0xe, 0x90, 0xb, 0xc0, 0x9e, 0x2c, 0xfe, 0x40,
    0x9, 0xe2, 0x3f, 0x73, 0xf5, 0xbd, 0x4a, 0xf1,
    0x1, 0xdf, 0xfc, 0xb, 0xc1, 0xf6, 0x1, 0xf6,
    0x0, 0x2, 0x20, 0x4f, 0x33, 0xf3, 0x0, 0xd9,
    0x0, 0x0, 0x0, 0xda, 0x4, 0xf3, 0x0, 0xda,
    0x0, 0x0, 0x7, 0xf2, 0x3, 0xf3, 0x0, 0xd9,
    0x0, 0x0, 0x1e, 0x80, 0x0, 0xf6, 0x0, 0xf6,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0xac, 0x18, 0xf1,
    0x0, 0x2, 0xf6, 0x0, 0x0, 0x1b, 0xfd, 0x40,

    /* U+0026 "&" */
    0x0, 0x4c, 0xff, 0xc4, 0x0, 0x0, 0x0, 0x3,
    0xfe, 0x88, 0xef, 0x30, 0x0, 0x0, 0x8, 0xf3,
    0x0, 0x4f, 0x80, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x5f, 0x70, 0x0, 0x0, 0x2, 0xfc, 0x2, 0xee,
    0x10, 0x0, 0x0, 0x0, 0x6f, 0xdf, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xfe, 0x10, 0x0, 0x3,
    0x20, 0xc, 0xf9, 0x7f, 0xd1, 0x0, 0x4f, 0x80,
    0x8f, 0x80, 0x6, 0xfd, 0x10, 0x9f, 0x30, 0xef,
    0x0, 0x0, 0x6f, 0xd4, 0xfc, 0x0, 0xef, 0x0,
    0x0, 0x5, 0xff, 0xf3, 0x0, 0xbf, 0x40, 0x0,
    0x2, 0xef, 0xe2, 0x0, 0x3f, 0xf9, 0x67, 0xaf,
    0xe8, 0xfe, 0x20, 0x3, 0xae, 0xff, 0xc7, 0x0,
    0x5f, 0xe2,

    /* U+0027 "'" */
    0xaf, 0x29, 0xf1, 0x8f, 0x6, 0xe0, 0x5d, 0x0,
    0x20,

    /* U+0028 "(" */
    0x0, 0xa, 0xf2, 0x0, 0x5f, 0x70, 0x0, 0xde,
    0x0, 0x4, 0xf8, 0x0, 0x9, 0xf3, 0x0, 0xd,
    0xe0, 0x0, 0xf, 0xc0, 0x0, 0x2f, 0xa0, 0x0,
    0x3f, 0x90, 0x0, 0x3f, 0x90, 0x0, 0x1f, 0xa0,
    0x0, 0xf, 0xd0, 0x0, 0xc, 0xf0, 0x0, 0x7,
    0xf5, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x9f, 0x20,
    0x0, 0x1e, 0xb0, 0x0, 0x3, 0x81,

    /* U+0029 ")" */
    0x1f, 0xa0, 0x0, 0x6, 0xf5, 0x0, 0x0, 0xed,
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x3f, 0x90, 0x0,
    0xe, 0xd0, 0x0, 0xc, 0xf0, 0x0, 0xa, 0xf2,
    0x0, 0x9, 0xf3, 0x0, 0x9, 0xf3, 0x0, 0xa,
    0xf1, 0x0, 0xd, 0xf0, 0x0, 0xf, 0xc0, 0x0,
    0x5f, 0x70, 0x0, 0xbf, 0x10, 0x2, 0xfa, 0x0,
    0xb, 0xe1, 0x0, 0x18, 0x30, 0x0,

    /* U+002A "*" */
    0x0, 0x0, 0x7f, 0x60, 0x0, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x1, 0x0, 0x3f, 0x20, 0x1,
    0x0, 0xfd, 0x85, 0xf5, 0x8d, 0xf0, 0x1b, 0xcd,
    0xff, 0xfd, 0xcb, 0x10, 0x0, 0x1e, 0xed, 0x0,
    0x0, 0x0, 0xa, 0xf3, 0xfa, 0x0, 0x0, 0x6,
    0xf9, 0x9, 0xf6, 0x0, 0x0, 0x4d, 0x20, 0x2d,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0xc5, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0x11, 0x12, 0xf7, 0x11,
    0x10, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44, 0x44,
    0xf9, 0x44, 0x41, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0,

    /* U+002C "," */
    0x3, 0xfb, 0x6, 0xf7, 0x9, 0xf2, 0xd, 0xb0,
    0x1f, 0x50,

    /* U+002D "-" */
    0x19, 0x99, 0x95, 0x3f, 0xff, 0xfa,

    /* U+002E "." */
    0x2a, 0x68, 0xfe, 0x4f, 0x90,

    /* U+002F "/" */
    0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x1f, 0xa0,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x0, 0xde, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x9, 0xf2, 0x0,
    0x0, 0xe, 0xc0, 0x0, 0x0, 0x5f, 0x60, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x0,
    0x7, 0xf4, 0x0, 0x0, 0xd, 0xd0, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x7, 0xdf, 0xea, 0x10, 0x0, 0xa, 0xfc,
    0x8a, 0xfe, 0x10, 0x4, 0xfa, 0x0, 0x4, 0xfa,
    0x0, 0x9f, 0x20, 0x0, 0xc, 0xf0, 0xd, 0xe0,
    0x0, 0x0, 0x8f, 0x30, 0xfc, 0x0, 0x0, 0x6,
    0xf6, 0xf, 0xb0, 0x0, 0x0, 0x5f, 0x70, 0xfb,
    0x0, 0x0, 0x5, 0xf7, 0xf, 0xc0, 0x0, 0x0,
    0x6f, 0x60, 0xce, 0x0, 0x0, 0x8, 0xf4, 0x9,
    0xf2, 0x0, 0x0, 0xcf, 0x10, 0x3f, 0xa0, 0x0,
    0x4f, 0xb0, 0x0, 0x9f, 0xc8, 0xaf, 0xf2, 0x0,
    0x0, 0x7d, 0xff, 0xa2, 0x0,

    /* U+0031 "1" */
    0x0, 0x2, 0xdf, 0x10, 0x5, 0xff, 0xf1, 0x9,
    0xfa, 0x9f, 0x10, 0xb7, 0x9, 0xf1, 0x0, 0x0,
    0xaf, 0x10, 0x0, 0xa, 0xf1, 0x0, 0x0, 0xaf,
    0x10, 0x0, 0xa, 0xf1, 0x0, 0x0, 0xaf, 0x10,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0xa, 0xf1, 0x0, 0x0, 0xaf, 0x10, 0x0, 0xa,
    0xf1,

    /* U+0032 "2" */
    0x0, 0x4a, 0xef, 0xea, 0x20, 0x0, 0x8f, 0xe9,
    0x8a, 0xff, 0x20, 0x3, 0x70, 0x0, 0x5, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x0, 0x0, 0x1e, 0xd0, 0x0, 0x0,
    0x0, 0x1d, 0xf2, 0x0, 0x0, 0x0, 0x1c, 0xf3,
    0x0, 0x0, 0x0, 0x1d, 0xf3, 0x0, 0x0, 0x0,
    0x1d, 0xe3, 0x0, 0x0, 0x0, 0x1d, 0xe2, 0x0,
    0x0, 0x0, 0xe, 0xfc, 0xaa, 0xaa, 0xaa, 0x40,
    0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+0033 "3" */
    0x0, 0x6c, 0xff, 0xeb, 0x40, 0x0, 0xbf, 0xc8,
    0x79, 0xff, 0x50, 0x2, 0x20, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xd0, 0x0, 0x0,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0x78, 0x9d, 0xe8,
    0x0, 0x0, 0xe, 0xff, 0xfb, 0x60, 0x0, 0x0,
    0x0, 0x14, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x10, 0x0, 0x0, 0x0, 0x9, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x30, 0x0, 0x0,
    0x3f, 0xe0, 0x1f, 0xd9, 0x88, 0xbf, 0xf4, 0x0,
    0x7c, 0xef, 0xfd, 0x92, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x0, 0x3f, 0xf0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0xf0, 0x0, 0x0, 0x0, 0xb, 0xdb,
    0xf0, 0x0, 0x0, 0x0, 0x7f, 0x3b, 0xf0, 0x0,
    0x0, 0x3, 0xf7, 0xb, 0xf0, 0x0, 0x0, 0xd,
    0xb0, 0xb, 0xf0, 0x0, 0x0, 0xae, 0x10, 0xb,
    0xf0, 0x0, 0x6, 0xf4, 0x0, 0xb, 0xf0, 0x0,
    0x2f, 0x80, 0x0, 0xb, 0xf0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x59, 0x99, 0x99, 0x9e,
    0xf9, 0x90, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0,

    /* U+0035 "5" */
    0xe, 0xff, 0xff, 0xff, 0x40, 0xf, 0xd9, 0x99,
    0x99, 0x20, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x2f,
    0x70, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x0, 0x5f, 0xef, 0xfe, 0xb3, 0x0, 0x2b, 0xa8,
    0x8b, 0xff, 0x50, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0xa, 0xf3, 0x0, 0x0, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x0, 0xa, 0xf2, 0x30,
    0x0, 0x0, 0x4f, 0xc0, 0xbe, 0xa8, 0x8b, 0xfe,
    0x20, 0x4b, 0xef, 0xfd, 0x81, 0x0,

    /* U+0036 "6" */
    0x0, 0x5, 0xbe, 0xff, 0x50, 0x0, 0xbf, 0xd8,
    0x77, 0x30, 0x9, 0xf6, 0x0, 0x0, 0x0, 0x2f,
    0x90, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x1, 0x0,
    0x0, 0xbf, 0x2b, 0xff, 0xf9, 0x0, 0xde, 0xe9,
    0x55, 0xaf, 0xb0, 0xef, 0x60, 0x0, 0xa, 0xf3,
    0xee, 0x0, 0x0, 0x4, 0xf7, 0xcf, 0x0, 0x0,
    0x4, 0xf7, 0x9f, 0x30, 0x0, 0x6, 0xf5, 0x2f,
    0xc0, 0x0, 0x1d, 0xf1, 0x7, 0xfd, 0x89, 0xef,
    0x60, 0x0, 0x5c, 0xff, 0xc5, 0x0,

    /* U+0037 "7" */
    0x2f, 0xff, 0xff, 0xff, 0xff, 0x71, 0x99, 0x99,
    0x99, 0x9c, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xde,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0,
    0x0, 0xc, 0xf1, 0x0, 0x0, 0x0, 0x4, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0x0, 0x3f, 0xa0, 0x0, 0x0, 0x0, 0xa, 0xf3,
    0x0, 0x0, 0x0, 0x2, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0x1f, 0xc0,
    0x0, 0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0x0,
    0x1, 0xfd, 0x0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x19, 0xef, 0xfc, 0x50, 0x0, 0x1e, 0xfa,
    0x78, 0xef, 0x60, 0x7, 0xf6, 0x0, 0x1, 0xee,
    0x0, 0x8f, 0x20, 0x0, 0xc, 0xf0, 0x5, 0xf8,
    0x0, 0x2, 0xfb, 0x0, 0xa, 0xfa, 0x25, 0xec,
    0x10, 0x0, 0x8, 0xff, 0xfb, 0x0, 0x0, 0x7,
    0xfc, 0x7c, 0xfb, 0x10, 0x7, 0xf8, 0x0, 0x5,
    0xfd, 0x0, 0xed, 0x0, 0x0, 0x7, 0xf5, 0xf,
    0xb0, 0x0, 0x0, 0x5f, 0x60, 0xdf, 0x20, 0x0,
    0xa, 0xf3, 0x4, 0xfe, 0x86, 0x7c, 0xfa, 0x0,
    0x3, 0xae, 0xff, 0xc6, 0x0,

    /* U+0039 "9" */
    0x1, 0x9e, 0xfe, 0x91, 0x0, 0x1e, 0xfa, 0x8a,
    0xfe, 0x10, 0xaf, 0x40, 0x0, 0x3f, 0xa0, 0xed,
    0x0, 0x0, 0x9, 0xf1, 0xfc, 0x0, 0x0, 0x6,
    0xf4, 0xde, 0x0, 0x0, 0xa, 0xf6, 0x7f, 0xb3,
    0x13, 0xae, 0xf6, 0x8, 0xff, 0xff, 0x97, 0xf5,
    0x0, 0x3, 0x41, 0x9, 0xf3, 0x0, 0x0, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0x0, 0x4f, 0x90, 0x0,
    0x0, 0x3, 0xef, 0x20, 0x9, 0x78, 0xbf, 0xf4,
    0x0, 0xd, 0xff, 0xd9, 0x10, 0x0,

    /* U+003A ":" */
    0x4f, 0x98, 0xfe, 0x2b, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2a, 0x68, 0xfe, 0x4f,
    0x90,

    /* U+003B ";" */
    0x5, 0xf9, 0x9, 0xfd, 0x2, 0xb5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf9, 0x9, 0xf4, 0xd, 0xe0,
    0xf, 0x80, 0x3e, 0x20,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xc6, 0x0, 0x0, 0x4, 0xcf, 0xc2, 0x0,
    0x4, 0xcf, 0xb3, 0x0, 0x4, 0xcf, 0xa3, 0x0,
    0x0, 0xcf, 0x92, 0x0, 0x0, 0x0, 0xbf, 0xd6,
    0x0, 0x0, 0x0, 0x2, 0x9f, 0xf8, 0x20, 0x0,
    0x0, 0x1, 0x7e, 0xfb, 0x40, 0x0, 0x0, 0x0,
    0x5c, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x43,

    /* U+003D "=" */
    0x12, 0x22, 0x22, 0x22, 0x20, 0xef, 0xff, 0xff,
    0xff, 0xf4, 0x45, 0x55, 0x55, 0x55, 0x51, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x12, 0x22, 0x22, 0x22,
    0x20, 0xef, 0xff, 0xff, 0xff, 0xf4, 0x44, 0x44,
    0x44, 0x44, 0x41,

    /* U+003E ">" */
    0x10, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x10, 0x0,
    0x0, 0x0, 0x9f, 0xf7, 0x0, 0x0, 0x0, 0x1,
    0x8f, 0xe7, 0x0, 0x0, 0x0, 0x1, 0x7e, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0xe4, 0x0, 0x0,
    0x3, 0xaf, 0xe4, 0x0, 0x5, 0xcf, 0xc5, 0x0,
    0x28, 0xef, 0xa3, 0x0, 0x0, 0xff, 0x82, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x28, 0xdf, 0xfd, 0x70, 0x8, 0xfb, 0x99, 0xdf,
    0xa0, 0x11, 0x0, 0x0, 0xcf, 0x10, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x0, 0xbf, 0x50, 0x0, 0x1, 0xdf, 0x40, 0x0,
    0x0, 0xce, 0x20, 0x0, 0x0, 0x2f, 0x60, 0x0,
    0x0, 0x2, 0xc2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xb4, 0x0, 0x0, 0x0, 0xaf,
    0xc0, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x28, 0xce, 0xff, 0xd8, 0x20, 0x0,
    0x0, 0x8, 0xfe, 0x96, 0x56, 0x9e, 0xf7, 0x0,
    0x0, 0xbf, 0x60, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x8, 0xf3, 0x1, 0x9e, 0xfe, 0xc4, 0x8, 0xf2,
    0x1f, 0x80, 0xd, 0xe6, 0x47, 0xf6, 0x0, 0xe8,
    0x7f, 0x10, 0x7f, 0x30, 0x2, 0xf5, 0x0, 0xab,
    0xac, 0x0, 0xcd, 0x0, 0x3, 0xf5, 0x0, 0x9c,
    0xca, 0x0, 0xdb, 0x0, 0x4, 0xf4, 0x0, 0xab,
    0xd9, 0x0, 0xbd, 0x0, 0x8, 0xf4, 0x0, 0xe8,
    0xcb, 0x0, 0x6f, 0x60, 0x3e, 0xd9, 0x8, 0xf2,
    0x8e, 0x0, 0xa, 0xff, 0xf5, 0x3f, 0xfe, 0x40,
    0x3f, 0x60, 0x0, 0x13, 0x0, 0x1, 0x20, 0x0,
    0x9, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xb5, 0x21, 0x13, 0x7c, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xff, 0xff, 0xe9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x23, 0x31, 0x0, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0xa, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x9f, 0x30, 0x0, 0x0, 0x0, 0xd, 0xd1, 0xf9,
    0x0, 0x0, 0x0, 0x3, 0xf7, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x10, 0x5f, 0x60, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0xec, 0x0, 0x0, 0x6, 0xf5,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x3f, 0xc9, 0x99, 0x99, 0xef,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x7, 0xf6, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0xaf, 0x2c, 0xf0, 0x0, 0x0,
    0x0, 0x4, 0xf9,

    /* U+0042 "B" */
    0x1f, 0xff, 0xff, 0xec, 0x81, 0x1, 0xfe, 0x88,
    0x9a, 0xef, 0xe0, 0x1f, 0xb0, 0x0, 0x0, 0xbf,
    0x51, 0xfb, 0x0, 0x0, 0x7, 0xf6, 0x1f, 0xb0,
    0x0, 0x0, 0xbf, 0x21, 0xfd, 0x88, 0x89, 0xde,
    0x50, 0x1f, 0xff, 0xff, 0xff, 0x92, 0x1, 0xfb,
    0x0, 0x1, 0x5e, 0xf3, 0x1f, 0xb0, 0x0, 0x0,
    0x3f, 0xb1, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x1f,
    0xb0, 0x0, 0x0, 0x1f, 0xd1, 0xfb, 0x0, 0x0,
    0x9, 0xf9, 0x1f, 0xe8, 0x88, 0x9d, 0xfd, 0x11,
    0xff, 0xff, 0xff, 0xd8, 0x10,

    /* U+0043 "C" */
    0x0, 0x3, 0x9d, 0xff, 0xeb, 0x50, 0x0, 0x8f,
    0xfc, 0x99, 0xbf, 0xb0, 0x7, 0xfd, 0x30, 0x0,
    0x0, 0x10, 0x1f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfd, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xfc, 0xa9, 0xbe, 0x70, 0x0, 0x5,
    0xbe, 0xff, 0xeb, 0x30,

    /* U+0044 "D" */
    0x1f, 0xff, 0xff, 0xec, 0x70, 0x0, 0x1, 0xfe,
    0x88, 0x9a, 0xef, 0xe3, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x6f, 0xf2, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0x6f, 0xb0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xef,
    0x11, 0xfb, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x1f,
    0xb0, 0x0, 0x0, 0x0, 0x8f, 0x51, 0xfb, 0x0,
    0x0, 0x0, 0x8, 0xf5, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xaf, 0x31, 0xfb, 0x0, 0x0, 0x0, 0xe,
    0xf0, 0x1f, 0xb0, 0x0, 0x0, 0x8, 0xf9, 0x1,
    0xfb, 0x0, 0x0, 0x8, 0xfe, 0x10, 0x1f, 0xe8,
    0x89, 0xbf, 0xfd, 0x20, 0x1, 0xff, 0xff, 0xfe,
    0xb6, 0x0, 0x0,

    /* U+0045 "E" */
    0x1f, 0xff, 0xff, 0xff, 0xe1, 0xfe, 0x99, 0x99,
    0x98, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfe,
    0x99, 0x99, 0x95, 0x1f, 0xff, 0xff, 0xff, 0x91,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xe9,
    0x99, 0x99, 0x81, 0xff, 0xff, 0xff, 0xfe,

    /* U+0046 "F" */
    0x1f, 0xff, 0xff, 0xff, 0xe1, 0xfe, 0x99, 0x99,
    0x98, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0x1f, 0xe9, 0x99, 0x99, 0x51,
    0xff, 0xff, 0xff, 0xf8, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x1, 0x7c, 0xef, 0xfd, 0xa4, 0x0, 0x5,
    0xff, 0xea, 0x9a, 0xcf, 0x90, 0x5, 0xfe, 0x50,
    0x0, 0x0, 0x11, 0x0, 0xef, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x10, 0x0, 0x8, 0x99, 0x99, 0xc, 0xf1, 0x0,
    0x0, 0xdf, 0xff, 0xf1, 0xaf, 0x30, 0x0, 0x0,
    0x0, 0xbf, 0x17, 0xf8, 0x0, 0x0, 0x0, 0xb,
    0xf1, 0x1f, 0xf1, 0x0, 0x0, 0x0, 0xbf, 0x10,
    0x8f, 0xd3, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x9f,
    0xfd, 0xa9, 0x9b, 0xff, 0x10, 0x0, 0x3a, 0xdf,
    0xff, 0xda, 0x60,

    /* U+0048 "H" */
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x1f, 0xe9, 0x99, 0x99, 0x99, 0xfd,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd,

    /* U+0049 "I" */
    0x3f, 0xff, 0xff, 0x2, 0xbf, 0x81, 0x0, 0x8f,
    0x40, 0x0, 0x8f, 0x40, 0x0, 0x8f, 0x40, 0x0,
    0x8f, 0x40, 0x0, 0x8f, 0x40, 0x0, 0x8f, 0x40,
    0x0, 0x8f, 0x40, 0x0, 0x8f, 0x40, 0x0, 0x8f,
    0x40, 0x0, 0x8f, 0x40, 0x2, 0xaf, 0x81, 0x3f,
    0xff, 0xff,

    /* U+004A "J" */
    0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2,
    0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0,
    0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa,
    0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2,
    0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0,
    0x2, 0xfa, 0x0, 0x2, 0xf9, 0x0, 0x7, 0xf7,
    0x6a, 0xbf, 0xe1, 0x7f, 0xfb, 0x20,

    /* U+004B "K" */
    0x1f, 0xb0, 0x0, 0x0, 0x6f, 0xa0, 0x1f, 0xb0,
    0x0, 0x5, 0xfb, 0x0, 0x1f, 0xb0, 0x0, 0x4f,
    0xc0, 0x0, 0x1f, 0xb0, 0x3, 0xfd, 0x10, 0x0,
    0x1f, 0xb0, 0x2e, 0xd1, 0x0, 0x0, 0x1f, 0xb1,
    0xde, 0x20, 0x0, 0x0, 0x1f, 0xcd, 0xfc, 0x0,
    0x0, 0x0, 0x1f, 0xfd, 0xbf, 0x80, 0x0, 0x0,
    0x1f, 0xd1, 0xd, 0xf4, 0x0, 0x0, 0x1f, 0xb0,
    0x2, 0xfe, 0x10, 0x0, 0x1f, 0xb0, 0x0, 0x6f,
    0xc0, 0x0, 0x1f, 0xb0, 0x0, 0xa, 0xf8, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0xdf, 0x40, 0x1f, 0xb0,
    0x0, 0x0, 0x2f, 0xe1,

    /* U+004C "L" */
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xe9,
    0x99, 0x99, 0x91, 0xff, 0xff, 0xff, 0xff,

    /* U+004D "M" */
    0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf3,
    0x1f, 0xef, 0x20, 0x0, 0x0, 0x1, 0xff, 0xf3,
    0x1f, 0x9f, 0x80, 0x0, 0x0, 0x6, 0xfa, 0xf3,
    0x1f, 0x9a, 0xe0, 0x0, 0x0, 0xc, 0xc8, 0xf3,
    0x1f, 0x94, 0xf5, 0x0, 0x0, 0x3f, 0x69, 0xf3,
    0x1f, 0x90, 0xeb, 0x0, 0x0, 0x9f, 0x19, 0xf3,
    0x1f, 0x90, 0x8f, 0x10, 0x0, 0xfa, 0x9, 0xf3,
    0x1f, 0x90, 0x2f, 0x70, 0x5, 0xf3, 0x9, 0xf3,
    0x1f, 0x90, 0xd, 0xd0, 0xc, 0xd0, 0x9, 0xf3,
    0x1f, 0x90, 0x7, 0xf3, 0x2f, 0x70, 0x9, 0xf3,
    0x1f, 0x90, 0x1, 0xfa, 0x8f, 0x10, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0xbf, 0xeb, 0x0, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0x5f, 0xf4, 0x0, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0xe, 0xe0, 0x0, 0x9, 0xf3,

    /* U+004E "N" */
    0x1f, 0xf5, 0x0, 0x0, 0x0, 0x6f, 0x41, 0xff,
    0xe1, 0x0, 0x0, 0x6, 0xf4, 0x1f, 0xdf, 0x90,
    0x0, 0x0, 0x6f, 0x41, 0xf8, 0xbf, 0x40, 0x0,
    0x6, 0xf4, 0x1f, 0x92, 0xfd, 0x0, 0x0, 0x6f,
    0x41, 0xf9, 0x6, 0xf8, 0x0, 0x6, 0xf4, 0x1f,
    0x90, 0xc, 0xf3, 0x0, 0x6f, 0x41, 0xf9, 0x0,
    0x2f, 0xc0, 0x6, 0xf4, 0x1f, 0x90, 0x0, 0x7f,
    0x70, 0x6f, 0x41, 0xf9, 0x0, 0x0, 0xcf, 0x26,
    0xf4, 0x1f, 0x90, 0x0, 0x2, 0xfb, 0x5f, 0x41,
    0xf9, 0x0, 0x0, 0x7, 0xfb, 0xf4, 0x1f, 0x90,
    0x0, 0x0, 0xc, 0xff, 0x41, 0xf9, 0x0, 0x0,
    0x0, 0x3f, 0xf4,

    /* U+004F "O" */
    0x0, 0x5, 0xbe, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf4, 0x0, 0x9, 0xfc,
    0x10, 0x0, 0x4, 0xef, 0x30, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0xd, 0xf1, 0xaf, 0x30, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x8,
    0xf6, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x8, 0xf6,
    0xaf, 0x40, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x2f, 0xe0,
    0x0, 0x0, 0x0, 0x5f, 0xb0, 0x9, 0xfc, 0x10,
    0x0, 0x4, 0xff, 0x30, 0x0, 0xaf, 0xfb, 0x9a,
    0xdf, 0xf5, 0x0, 0x0, 0x4, 0xbe, 0xff, 0xd9,
    0x20, 0x0,

    /* U+0050 "P" */
    0x1f, 0xff, 0xff, 0xd9, 0x20, 0x1, 0xfe, 0x88,
    0x9d, 0xff, 0x30, 0x1f, 0xb0, 0x0, 0x6, 0xfc,
    0x1, 0xfb, 0x0, 0x0, 0xe, 0xf0, 0x1f, 0xb0,
    0x0, 0x0, 0xcf, 0x1, 0xfb, 0x0, 0x0, 0x1f,
    0xd0, 0x1f, 0xb0, 0x1, 0x5d, 0xf6, 0x1, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x1f, 0xe9, 0x88, 0x51,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x5, 0xbe, 0xff, 0xd8, 0x20, 0x0, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf5, 0x0, 0x9, 0xfc,
    0x10, 0x0, 0x4, 0xef, 0x30, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0xd, 0xf1, 0xaf, 0x30, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x8,
    0xf6, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x8, 0xf6,
    0xaf, 0x40, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x2f, 0xe0,
    0x0, 0x0, 0x0, 0x5f, 0xb0, 0x9, 0xfc, 0x10,
    0x0, 0x4, 0xff, 0x20, 0x0, 0xaf, 0xfb, 0x9a,
    0xdf, 0xf4, 0x0, 0x0, 0x4, 0xbe, 0xff, 0xfa,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfe, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x30,

    /* U+0052 "R" */
    0x1f, 0xff, 0xff, 0xea, 0x30, 0x0, 0x1f, 0xe9,
    0x99, 0xcf, 0xf5, 0x0, 0x1f, 0xb0, 0x0, 0x4,
    0xfd, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0xdf, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0xdf, 0x0, 0x1f, 0xb0,
    0x0, 0x4, 0xfb, 0x0, 0x1f, 0xe8, 0x89, 0xbf,
    0xd1, 0x0, 0x1f, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x1f, 0xb0, 0x2, 0xfc, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x8f, 0x60, 0x0, 0x1f, 0xb0, 0x0, 0xe,
    0xf1, 0x0, 0x1f, 0xb0, 0x0, 0x6, 0xfa, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0xdf, 0x30, 0x1f, 0xb0,
    0x0, 0x0, 0x3f, 0xd0,

    /* U+0053 "S" */
    0x2, 0x9e, 0xff, 0xd9, 0x30, 0x2f, 0xfc, 0x9a,
    0xcf, 0x70, 0xaf, 0x60, 0x0, 0x1, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x0, 0x3f, 0xe6, 0x0, 0x0, 0x0, 0x4, 0xdf,
    0xe9, 0x20, 0x0, 0x0, 0x5, 0xaf, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0x90, 0x0, 0x0, 0x0,
    0xe, 0xf0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x30,
    0x0, 0x0, 0x4f, 0xc0, 0xfe, 0xb9, 0x9c, 0xff,
    0x30, 0x7c, 0xef, 0xfd, 0x92, 0x0,

    /* U+0054 "T" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x99, 0x9b,
    0xfc, 0x99, 0x98, 0x0, 0x0, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x70, 0x0, 0x0, 0x0, 0x5, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x70, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0,
    0x0, 0x5, 0xf7, 0x0, 0x0,

    /* U+0055 "U" */
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x2f, 0xa0,
    0x0, 0x0, 0x0, 0xfc, 0xf, 0xe0, 0x0, 0x0,
    0x4, 0xf9, 0x9, 0xf9, 0x0, 0x0, 0x1d, 0xf3,
    0x1, 0xdf, 0xea, 0x9b, 0xff, 0x70, 0x0, 0x7,
    0xcf, 0xfe, 0xa3, 0x0,

    /* U+0056 "V" */
    0xdf, 0x10, 0x0, 0x0, 0x1, 0xfd, 0x7f, 0x60,
    0x0, 0x0, 0x7, 0xf7, 0x1f, 0xc0, 0x0, 0x0,
    0xc, 0xf1, 0xb, 0xf2, 0x0, 0x0, 0x2f, 0xb0,
    0x5, 0xf7, 0x0, 0x0, 0x8f, 0x50, 0x0, 0xfd,
    0x0, 0x0, 0xdf, 0x0, 0x0, 0xaf, 0x30, 0x3,
    0xfa, 0x0, 0x0, 0x4f, 0x90, 0x9, 0xf4, 0x0,
    0x0, 0xe, 0xe0, 0xe, 0xe0, 0x0, 0x0, 0x8,
    0xf4, 0x4f, 0x80, 0x0, 0x0, 0x2, 0xf9, 0x9f,
    0x20, 0x0, 0x0, 0x0, 0xdd, 0xdd, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xf1, 0x0, 0x0,

    /* U+0057 "W" */
    0xaf, 0x40, 0x0, 0x0, 0xdf, 0x40, 0x0, 0x0,
    0xaf, 0x35, 0xf8, 0x0, 0x0, 0x2f, 0xf9, 0x0,
    0x0, 0xe, 0xe0, 0x1f, 0xc0, 0x0, 0x7, 0xfb,
    0xe0, 0x0, 0x3, 0xfa, 0x0, 0xdf, 0x0, 0x0,
    0xbd, 0x5f, 0x30, 0x0, 0x7f, 0x60, 0x8, 0xf4,
    0x0, 0x1f, 0x91, 0xf8, 0x0, 0xb, 0xf1, 0x0,
    0x4f, 0x80, 0x5, 0xf4, 0xc, 0xd0, 0x0, 0xfd,
    0x0, 0x0, 0xfd, 0x0, 0xaf, 0x0, 0x7f, 0x20,
    0x3f, 0x90, 0x0, 0xb, 0xf1, 0xe, 0xb0, 0x3,
    0xf7, 0x7, 0xf4, 0x0, 0x0, 0x7f, 0x53, 0xf6,
    0x0, 0xe, 0xc0, 0xbf, 0x0, 0x0, 0x3, 0xf9,
    0x8f, 0x20, 0x0, 0x9f, 0x1f, 0xc0, 0x0, 0x0,
    0xe, 0xcb, 0xd0, 0x0, 0x5, 0xf8, 0xf7, 0x0,
    0x0, 0x0, 0xaf, 0xe9, 0x0, 0x0, 0xf, 0xdf,
    0x30, 0x0, 0x0, 0x6, 0xff, 0x40, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x1f, 0xf0, 0x0,
    0x0, 0x6, 0xfa, 0x0, 0x0,

    /* U+0058 "X" */
    0x4f, 0xb0, 0x0, 0x0, 0xd, 0xe1, 0xa, 0xf5,
    0x0, 0x0, 0x8f, 0x40, 0x1, 0xee, 0x10, 0x3,
    0xfa, 0x0, 0x0, 0x5f, 0x90, 0xd, 0xe1, 0x0,
    0x0, 0xa, 0xf4, 0x7f, 0x50, 0x0, 0x0, 0x1,
    0xee, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf6, 0x0, 0x0,
    0x0, 0x5, 0xf7, 0xdf, 0x10, 0x0, 0x0, 0x1e,
    0xc0, 0x3f, 0xb0, 0x0, 0x0, 0xaf, 0x30, 0x9,
    0xf5, 0x0, 0x4, 0xf9, 0x0, 0x0, 0xee, 0x10,
    0xe, 0xe0, 0x0, 0x0, 0x5f, 0xa0, 0x9f, 0x40,
    0x0, 0x0, 0xb, 0xf5,

    /* U+0059 "Y" */
    0xbf, 0x30, 0x0, 0x0, 0xd, 0xf1, 0x2f, 0xb0,
    0x0, 0x0, 0x6f, 0x70, 0x9, 0xf4, 0x0, 0x0,
    0xee, 0x0, 0x1, 0xfc, 0x0, 0x7, 0xf5, 0x0,
    0x0, 0x8f, 0x40, 0x1e, 0xd0, 0x0, 0x0, 0xe,
    0xd0, 0x8f, 0x40, 0x0, 0x0, 0x6, 0xf7, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x90, 0x0, 0x0,

    /* U+005A "Z" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0x70, 0x99, 0x99,
    0x99, 0x9f, 0xf5, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0x0, 0x0, 0x0, 0x1, 0xee, 0x10, 0x0, 0x0,
    0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x0, 0x1f, 0xe1, 0x0, 0x0, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x30, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x0, 0x0, 0x2f, 0xfa, 0x99, 0x99, 0x99, 0x63,
    0xff, 0xff, 0xff, 0xff, 0xfa,

    /* U+005B "[" */
    0x6f, 0xff, 0xf1, 0x6f, 0x97, 0x70, 0x6f, 0x50,
    0x0, 0x6f, 0x50, 0x0, 0x6f, 0x50, 0x0, 0x6f,
    0x50, 0x0, 0x6f, 0x50, 0x0, 0x6f, 0x50, 0x0,
    0x6f, 0x50, 0x0, 0x6f, 0x50, 0x0, 0x6f, 0x50,
    0x0, 0x6f, 0x50, 0x0, 0x6f, 0x50, 0x0, 0x6f,
    0x50, 0x0, 0x6f, 0x50, 0x0, 0x6f, 0x62, 0x20,
    0x6f, 0xff, 0xf1, 0x25, 0x55, 0x50,

    /* U+005C "\\" */
    0x9f, 0x10, 0x0, 0x0, 0x3f, 0x70, 0x0, 0x0,
    0xd, 0xd0, 0x0, 0x0, 0x7, 0xf4, 0x0, 0x0,
    0x1, 0xfa, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x5f, 0x60, 0x0, 0x0, 0xe, 0xc0, 0x0,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x0, 0xde, 0x0, 0x0, 0x0, 0x7f, 0x50,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0xa, 0xf1,

    /* U+005D "]" */
    0x8f, 0xff, 0xf3, 0x77, 0xdf, 0x0, 0xb, 0xf0,
    0x0, 0xbf, 0x0, 0xb, 0xf0, 0x0, 0xbf, 0x0,
    0xb, 0xf0, 0x0, 0xbf, 0x0, 0xb, 0xf0, 0x0,
    0xbf, 0x0, 0xb, 0xf0, 0x0, 0xbf, 0x0, 0xb,
    0xf0, 0x0, 0xbf, 0x0, 0xb, 0xf1, 0x22, 0xcf,
    0x8f, 0xff, 0xf2, 0x55, 0x54,

    /* U+005E "^" */
    0x0, 0x0, 0x3f, 0x40, 0x0, 0x0, 0x0, 0xb,
    0xfc, 0x0, 0x0, 0x0, 0x3, 0xf6, 0xf4, 0x0,
    0x0, 0x0, 0xac, 0xa, 0xd0, 0x0, 0x0, 0x2f,
    0x50, 0x2f, 0x50, 0x0, 0x9, 0xd0, 0x0, 0xad,
    0x0, 0x1, 0xf7, 0x0, 0x2, 0xf6, 0x0, 0x8e,
    0x0, 0x0, 0xa, 0xe0, 0xf, 0x80, 0x0, 0x0,
    0x2f, 0x60,

    /* U+005F "_" */
    0x1, 0x11, 0x11, 0x11, 0x10, 0xf, 0xff, 0xff,
    0xff, 0xfe, 0x3, 0x33, 0x33, 0x33, 0x33,

    /* U+0060 "`" */
    0x1e, 0xf3, 0x0, 0x2e, 0xd0, 0x0, 0x2d, 0x90,

    /* U+0061 "a" */
    0x0, 0x4a, 0xef, 0xfc, 0x40, 0x0, 0xbe, 0x97,
    0x9f, 0xf2, 0x0, 0x20, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0x6b, 0xef, 0xff, 0xf9, 0x8, 0xfc,
    0x53, 0x35, 0xf9, 0xf, 0xe0, 0x0, 0x3, 0xf9,
    0xf, 0xc0, 0x0, 0x8, 0xf9, 0xb, 0xf8, 0x45,
    0xad, 0xf9, 0x1, 0xae, 0xfe, 0x90, 0xc9,

    /* U+0062 "b" */
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x76,
    0xdf, 0xfa, 0x20, 0x4, 0xfc, 0xf9, 0x8a, 0xfe,
    0x20, 0x4f, 0xf2, 0x0, 0x5, 0xfa, 0x4, 0xfa,
    0x0, 0x0, 0xe, 0xf0, 0x4f, 0x80, 0x0, 0x0,
    0xbf, 0x24, 0xf7, 0x0, 0x0, 0xa, 0xf3, 0x4f,
    0x80, 0x0, 0x0, 0xbf, 0x24, 0xfb, 0x0, 0x0,
    0xe, 0xf0, 0x4f, 0xf2, 0x0, 0x6, 0xfa, 0x4,
    0xfb, 0xf9, 0x7a, 0xfe, 0x20, 0x4f, 0x16, 0xdf,
    0xfa, 0x20, 0x0,

    /* U+0063 "c" */
    0x0, 0x5c, 0xff, 0xd8, 0x9, 0xfe, 0x99, 0xc9,
    0x4f, 0xb0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x5f, 0xb0, 0x0, 0x0, 0xa, 0xfd, 0x98, 0xbb,
    0x0, 0x6c, 0xff, 0xd7,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x8e, 0xfe, 0x82,
    0xf9, 0xb, 0xfc, 0x78, 0xdc, 0xf9, 0x5f, 0xb0,
    0x0, 0xd, 0xf9, 0xbf, 0x30, 0x0, 0x6, 0xf9,
    0xdf, 0x0, 0x0, 0x3, 0xf9, 0xee, 0x0, 0x0,
    0x2, 0xf9, 0xdf, 0x0, 0x0, 0x2, 0xf9, 0xbf,
    0x30, 0x0, 0x5, 0xf9, 0x6f, 0xa0, 0x0, 0xc,
    0xf9, 0xc, 0xfc, 0x78, 0xdb, 0xf9, 0x0, 0x8e,
    0xfe, 0x80, 0xe9,

    /* U+0065 "e" */
    0x0, 0x6d, 0xff, 0xb4, 0x0, 0x9, 0xfb, 0x78,
    0xdf, 0x50, 0x4f, 0x80, 0x0, 0x1e, 0xe0, 0xaf,
    0x21, 0x11, 0x1a, 0xf3, 0xdf, 0xff, 0xff, 0xff,
    0xf4, 0xef, 0x44, 0x44, 0x44, 0x41, 0xdf, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x0,
    0x4f, 0xd1, 0x0, 0x0, 0x20, 0x8, 0xfe, 0x98,
    0x9d, 0xc0, 0x0, 0x5b, 0xff, 0xeb, 0x50,

    /* U+0066 "f" */
    0x0, 0x7, 0xdf, 0xe7, 0x0, 0x6f, 0xd7, 0x84,
    0x0, 0xbf, 0x10, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x6d, 0xff, 0xff, 0xa0, 0x46, 0xef, 0x66, 0x30,
    0x0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0xdf, 0x0, 0x0,

    /* U+0067 "g" */
    0x0, 0x8e, 0xfe, 0x80, 0xe9, 0xb, 0xfc, 0x89,
    0xeb, 0xf9, 0x5f, 0xb0, 0x0, 0xd, 0xf9, 0xaf,
    0x30, 0x0, 0x6, 0xf9, 0xdf, 0x0, 0x0, 0x2,
    0xf9, 0xee, 0x0, 0x0, 0x2, 0xf9, 0xdf, 0x0,
    0x0, 0x2, 0xf9, 0xaf, 0x30, 0x0, 0x5, 0xf9,
    0x5f, 0xa0, 0x0, 0xb, 0xf9, 0xb, 0xfc, 0x78,
    0xdc, 0xf9, 0x0, 0x8e, 0xfe, 0x82, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x5,
    0xf7, 0x2, 0x0, 0x0, 0xc, 0xf3, 0x1f, 0xc9,
    0x78, 0xdf, 0xa0, 0x8, 0xce, 0xff, 0xc7, 0x0,

    /* U+0068 "h" */
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x0, 0x0, 0x4f, 0x75, 0xcf, 0xfc,
    0x40, 0x4f, 0xcf, 0xa8, 0x9f, 0xf2, 0x4f, 0xf3,
    0x0, 0x5, 0xf9, 0x4f, 0xb0, 0x0, 0x0, 0xfb,
    0x4f, 0x80, 0x0, 0x0, 0xfb, 0x4f, 0x70, 0x0,
    0x0, 0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb, 0x4f,
    0x70, 0x0, 0x0, 0xfb, 0x4f, 0x70, 0x0, 0x0,
    0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb, 0x4f, 0x70,
    0x0, 0x0, 0xfb,

    /* U+0069 "i" */
    0x4f, 0x65, 0xf8, 0x3, 0x0, 0x0, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f,
    0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x70,

    /* U+006A "j" */
    0x0, 0x4, 0xf6, 0x0, 0x5, 0xf8, 0x0, 0x0,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7,
    0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4,
    0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0,
    0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7,
    0x0, 0x4, 0xf7, 0x0, 0x6, 0xf6, 0x18, 0x8e,
    0xf2, 0x1e, 0xfd, 0x50,

    /* U+006B "k" */
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x5f,
    0xb0, 0x4f, 0x70, 0x4, 0xfc, 0x0, 0x4f, 0x70,
    0x3f, 0xd1, 0x0, 0x4f, 0x72, 0xed, 0x10, 0x0,
    0x4f, 0x7d, 0xf2, 0x0, 0x0, 0x4f, 0xff, 0xf7,
    0x0, 0x0, 0x4f, 0xd2, 0xdf, 0x30, 0x0, 0x4f,
    0x70, 0x3f, 0xd0, 0x0, 0x4f, 0x70, 0x7, 0xfa,
    0x0, 0x4f, 0x70, 0x0, 0xbf, 0x60, 0x4f, 0x70,
    0x0, 0x1e, 0xf2,

    /* U+006C "l" */
    0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f,
    0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x70,

    /* U+006D "m" */
    0x4f, 0x35, 0xdf, 0xea, 0x10, 0x8e, 0xfe, 0x80,
    0x4, 0xfb, 0xf9, 0x8c, 0xfc, 0xbe, 0x98, 0xdf,
    0x80, 0x4f, 0xf2, 0x0, 0xc, 0xfd, 0x0, 0x1,
    0xee, 0x4, 0xfa, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0xb, 0xf0, 0x4f, 0x80, 0x0, 0x7, 0xf4, 0x0,
    0x0, 0xaf, 0x14, 0xf7, 0x0, 0x0, 0x7f, 0x40,
    0x0, 0xa, 0xf1, 0x4f, 0x70, 0x0, 0x7, 0xf4,
    0x0, 0x0, 0xaf, 0x14, 0xf7, 0x0, 0x0, 0x7f,
    0x40, 0x0, 0xa, 0xf1, 0x4f, 0x70, 0x0, 0x7,
    0xf4, 0x0, 0x0, 0xaf, 0x14, 0xf7, 0x0, 0x0,
    0x7f, 0x40, 0x0, 0xa, 0xf1, 0x4f, 0x70, 0x0,
    0x7, 0xf4, 0x0, 0x0, 0xaf, 0x10,

    /* U+006E "n" */
    0x4f, 0x34, 0xcf, 0xfc, 0x40, 0x4f, 0xbf, 0xa8,
    0xaf, 0xf2, 0x4f, 0xf3, 0x0, 0x5, 0xf9, 0x4f,
    0xb0, 0x0, 0x0, 0xfb, 0x4f, 0x80, 0x0, 0x0,
    0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb, 0x4f, 0x70,
    0x0, 0x0, 0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb,
    0x4f, 0x70, 0x0, 0x0, 0xfb, 0x4f, 0x70, 0x0,
    0x0, 0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb,

    /* U+006F "o" */
    0x0, 0x6c, 0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8,
    0x8c, 0xfa, 0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5,
    0xa, 0xf3, 0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0,
    0x0, 0x0, 0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc,
    0xf0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa,
    0xf5, 0x0, 0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0,
    0x5c, 0xff, 0xc6, 0x0, 0x0,

    /* U+0070 "p" */
    0x4f, 0x35, 0xdf, 0xfa, 0x20, 0x4, 0xfb, 0xf9,
    0x8a, 0xfe, 0x20, 0x4f, 0xf2, 0x0, 0x6, 0xfa,
    0x4, 0xfa, 0x0, 0x0, 0xe, 0xf0, 0x4f, 0x70,
    0x0, 0x0, 0xbf, 0x24, 0xf7, 0x0, 0x0, 0xa,
    0xf3, 0x4f, 0x80, 0x0, 0x0, 0xbf, 0x24, 0xfb,
    0x0, 0x0, 0xe, 0xf0, 0x4f, 0xf2, 0x0, 0x7,
    0xfa, 0x4, 0xfc, 0xf9, 0x7a, 0xfe, 0x10, 0x4f,
    0x65, 0xdf, 0xfa, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x8e, 0xfe, 0x80, 0xe9, 0xb, 0xfc, 0x78,
    0xdb, 0xf9, 0x5f, 0xb0, 0x0, 0xd, 0xf9, 0xaf,
    0x30, 0x0, 0x6, 0xf9, 0xdf, 0x0, 0x0, 0x3,
    0xf9, 0xee, 0x0, 0x0, 0x2, 0xf9, 0xdf, 0x0,
    0x0, 0x2, 0xf9, 0xbf, 0x30, 0x0, 0x5, 0xf9,
    0x6f, 0xa0, 0x0, 0xc, 0xf9, 0xc, 0xfc, 0x78,
    0xdc, 0xf9, 0x0, 0x8e, 0xfe, 0x82, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9,

    /* U+0072 "r" */
    0x4f, 0x32, 0xcf, 0xd4, 0xf6, 0xfd, 0xa8, 0x4f,
    0xf8, 0x0, 0x4, 0xfd, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,

    /* U+0073 "s" */
    0x7, 0xdf, 0xfd, 0xa2, 0x9f, 0xb7, 0x7a, 0xf2,
    0xfc, 0x0, 0x0, 0x0, 0xee, 0x20, 0x0, 0x0,
    0x5f, 0xfa, 0x30, 0x0, 0x2, 0x9f, 0xfd, 0x40,
    0x0, 0x0, 0x6e, 0xf4, 0x0, 0x0, 0x2, 0xfa,
    0x10, 0x0, 0x2, 0xf9, 0xeb, 0x87, 0x8e, 0xf3,
    0x7d, 0xff, 0xeb, 0x30,

    /* U+0074 "t" */
    0x0, 0x44, 0x0, 0x0, 0xb, 0x90, 0x0, 0x1,
    0xf9, 0x0, 0x6, 0xff, 0xff, 0xfb, 0x47, 0xfb,
    0x66, 0x40, 0x2f, 0x90, 0x0, 0x2, 0xf9, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0x2, 0xf9, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x1f,
    0xc0, 0x0, 0x0, 0xcf, 0xa7, 0x70, 0x2, 0xbf,
    0xfa,

    /* U+0075 "u" */
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f,
    0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1,
    0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x2, 0xfa, 0x6f, 0x60, 0x0, 0x4, 0xfa,
    0x4f, 0xa0, 0x0, 0xa, 0xfa, 0xd, 0xf8, 0x45,
    0xad, 0xfa, 0x1, 0xae, 0xfe, 0x91, 0xda,

    /* U+0076 "v" */
    0xdf, 0x10, 0x0, 0x0, 0xef, 0x7, 0xf6, 0x0,
    0x0, 0x3f, 0x90, 0x1f, 0xc0, 0x0, 0x9, 0xf3,
    0x0, 0xbf, 0x10, 0x0, 0xed, 0x0, 0x5, 0xf7,
    0x0, 0x4f, 0x70, 0x0, 0xf, 0xc0, 0xa, 0xf1,
    0x0, 0x0, 0x9f, 0x20, 0xfc, 0x0, 0x0, 0x3,
    0xf7, 0x5f, 0x60, 0x0, 0x0, 0xd, 0xca, 0xf0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0x0,
    0x2, 0xff, 0x40, 0x0, 0x0,

    /* U+0077 "w" */
    0xaf, 0x20, 0x0, 0x3f, 0xf0, 0x0, 0x6, 0xf5,
    0x6f, 0x60, 0x0, 0x8f, 0xf4, 0x0, 0xa, 0xf1,
    0x1f, 0xa0, 0x0, 0xdb, 0xf9, 0x0, 0xe, 0xd0,
    0xd, 0xe0, 0x2, 0xf7, 0xbe, 0x0, 0x3f, 0x80,
    0x9, 0xf2, 0x7, 0xf2, 0x7f, 0x20, 0x7f, 0x40,
    0x5, 0xf6, 0xc, 0xd0, 0x2f, 0x70, 0xbf, 0x0,
    0x0, 0xfa, 0x1f, 0x80, 0xe, 0xc0, 0xfb, 0x0,
    0x0, 0xce, 0x5f, 0x30, 0x9, 0xf4, 0xf7, 0x0,
    0x0, 0x8f, 0xae, 0x0, 0x4, 0xfb, 0xf3, 0x0,
    0x0, 0x3f, 0xf9, 0x0, 0x0, 0xff, 0xe0, 0x0,
    0x0, 0xf, 0xf4, 0x0, 0x0, 0xbf, 0xa0, 0x0,

    /* U+0078 "x" */
    0x2f, 0xd0, 0x0, 0x4, 0xfa, 0x0, 0x6f, 0x80,
    0x1, 0xee, 0x10, 0x0, 0xbf, 0x30, 0x9f, 0x40,
    0x0, 0x1, 0xfd, 0x4f, 0x90, 0x0, 0x0, 0x5,
    0xff, 0xd0, 0x0, 0x0, 0x0, 0xe, 0xf7, 0x0,
    0x0, 0x0, 0x8, 0xfe, 0xf2, 0x0, 0x0, 0x3,
    0xfb, 0x2f, 0xc0, 0x0, 0x0, 0xde, 0x10, 0x7f,
    0x70, 0x0, 0x9f, 0x50, 0x0, 0xcf, 0x30, 0x4f,
    0xa0, 0x0, 0x2, 0xfd, 0x0,

    /* U+0079 "y" */
    0xcf, 0x10, 0x0, 0x0, 0xdf, 0x6, 0xf7, 0x0,
    0x0, 0x3f, 0xa0, 0xf, 0xd0, 0x0, 0x9, 0xf4,
    0x0, 0x9f, 0x30, 0x0, 0xee, 0x0, 0x3, 0xf8,
    0x0, 0x4f, 0x80, 0x0, 0xd, 0xe0, 0x9, 0xf2,
    0x0, 0x0, 0x7f, 0x40, 0xed, 0x0, 0x0, 0x1,
    0xfa, 0x4f, 0x70, 0x0, 0x0, 0xa, 0xe9, 0xf1,
    0x0, 0x0, 0x0, 0x4f, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xef, 0x50, 0x0, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x20, 0x0, 0x0, 0x67, 0xbf, 0x90,
    0x0, 0x0, 0xb, 0xfe, 0x80, 0x0, 0x0, 0x0,

    /* U+007A "z" */
    0xe, 0xff, 0xff, 0xff, 0x70, 0x56, 0x66, 0x6c,
    0xf5, 0x0, 0x0, 0x3, 0xfa, 0x0, 0x0, 0x0,
    0xde, 0x10, 0x0, 0x0, 0x9f, 0x50, 0x0, 0x0,
    0x4f, 0xa0, 0x0, 0x0, 0x1e, 0xe0, 0x0, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x5, 0xf9, 0x0, 0x0,
    0x1, 0xef, 0x66, 0x66, 0x63, 0x3f, 0xff, 0xff,
    0xff, 0xa0,

    /* U+007B "{" */
    0x0, 0x0, 0x7d, 0xe0, 0x0, 0x8f, 0xd7, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0xfb, 0x0, 0x0, 0x1f, 0xb0,
    0x1, 0x3b, 0xf5, 0x0, 0x7f, 0xe4, 0x0, 0x2,
    0x6d, 0xf3, 0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0xf, 0xb0, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0xf, 0xc0, 0x0, 0x0, 0xbf, 0x82,
    0x0, 0x2, 0xcf, 0xf0, 0x0, 0x0, 0x24,

    /* U+007C "|" */
    0x3f, 0x33, 0xf3, 0x3f, 0x33, 0xf3, 0x3f, 0x33,
    0xf3, 0x3f, 0x33, 0xf3, 0x3f, 0x33, 0xf3, 0x3f,
    0x33, 0xf3, 0x3f, 0x33, 0xf3, 0x3f, 0x33, 0xf3,
    0x3f, 0x33, 0xf3, 0x3f, 0x33, 0xf3,

    /* U+007D "}" */
    0x5f, 0xb3, 0x0, 0x0, 0x28, 0xff, 0x20, 0x0,
    0x0, 0x4f, 0x80, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x1f, 0xa0, 0x0, 0x0, 0xb, 0xf7, 0x30,
    0x0, 0x0, 0x9f, 0xf0, 0x0, 0x8, 0xfa, 0x60,
    0x0, 0x1f, 0xb0, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x3, 0xcf, 0x40, 0x0,
    0x5f, 0xf7, 0x0, 0x0, 0x14, 0x0, 0x0, 0x0,

    /* U+007E "~" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xc7,
    0x33, 0x86, 0xe7, 0x57, 0xdf, 0xff, 0xe3, 0x10,
    0x0, 0x1, 0x44, 0x0,

    /* U+00A1 "¡" */
    0x4f, 0x98, 0xfe, 0x2a, 0x60, 0x0, 0x4, 0x10,
    0xf4, 0xf, 0x50, 0xf5, 0x1f, 0x62, 0xf7, 0x3f,
    0x84, 0xf9, 0x4f, 0x95, 0xfa, 0x6f, 0xb0,

    /* U+00A2 "¢" */
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x1, 0x9e, 0xff,
    0xd5, 0x1, 0xef, 0xb8, 0x9d, 0x50, 0xaf, 0x70,
    0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x2, 0xfb,
    0x0, 0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x2,
    0xfa, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0,
    0x0, 0xaf, 0x60, 0x0, 0x0, 0x2, 0xef, 0xb8,
    0x9c, 0x80, 0x1, 0x9e, 0xff, 0xc4, 0x0, 0x0,
    0x4f, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x0,

    /* U+00A3 "£" */
    0x0, 0x1, 0x9e, 0xff, 0xc7, 0x0, 0x0, 0xcf,
    0xb7, 0x8b, 0xd0, 0x0, 0x4f, 0x90, 0x0, 0x0,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x0, 0x0, 0x16, 0xf6, 0x11, 0x10,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0x70, 0x1, 0x48,
    0xf8, 0x44, 0x41, 0x0, 0x0, 0x6f, 0x60, 0x0,
    0x0, 0x0, 0x6, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x40, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x0,
    0x0, 0x0, 0x3d, 0xfb, 0x99, 0x99, 0x99, 0x65,
    0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+00A4 "¤" */
    0x14, 0x0, 0x0, 0x0, 0x40, 0x8f, 0x7c, 0xfe,
    0x8c, 0xe0, 0xc, 0xfa, 0x57, 0xef, 0x30, 0xd,
    0xa0, 0x0, 0x3f, 0x40, 0x2f, 0x30, 0x0, 0xc,
    0x90, 0x2f, 0x20, 0x0, 0xb, 0x90, 0xf, 0x70,
    0x0, 0x1f, 0x60, 0xa, 0xf6, 0x13, 0xcf, 0x10,
    0x6f, 0xbf, 0xff, 0xdf, 0xc0, 0x37, 0x1, 0x32,
    0x3, 0x80,

    /* U+00A5 "¥" */
    0x6f, 0x60, 0x0, 0x0, 0xe, 0xd0, 0xd, 0xe0,
    0x0, 0x0, 0x7f, 0x40, 0x4, 0xf6, 0x0, 0x1,
    0xea, 0x0, 0x0, 0xbe, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x2f, 0x60, 0x1f, 0x80, 0x0, 0x0, 0x9,
    0xe0, 0x8e, 0x0, 0x0, 0x0, 0x1, 0xf8, 0xf6,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x33, 0x5f, 0xa3, 0x32, 0x0, 0x0, 0x0,
    0x3f, 0x90, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x33, 0x5f, 0xa3, 0x32, 0x0,
    0x0, 0x0, 0x2f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x0,

    /* U+00A6 "¦" */
    0x3f, 0x33, 0xf3, 0x3f, 0x33, 0xf3, 0x3f, 0x33,
    0xf3, 0x3f, 0x32, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2a, 0x23, 0xf3, 0x3f, 0x33, 0xf3,
    0x3f, 0x33, 0xf3, 0x3f, 0x33, 0xf3,

    /* U+00A7 "§" */
    0x5, 0xcf, 0xfe, 0xb5, 0x5f, 0xb6, 0x57, 0xb6,
    0x9f, 0x10, 0x0, 0x0, 0x5f, 0xb2, 0x0, 0x0,
    0x8, 0xff, 0xb5, 0x0, 0x1e, 0xb7, 0xcf, 0xc1,
    0x8e, 0x0, 0x4, 0xfb, 0xae, 0x0, 0x0, 0x9e,
    0x5f, 0xc3, 0x0, 0xcb, 0x5, 0xdf, 0xcc, 0xe2,
    0x0, 0x5, 0xbf, 0xe3, 0x0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x0, 0xde, 0xca, 0x75, 0x6b, 0xf8,
    0x6c, 0xff, 0xfc, 0x60,

    /* U+00A8 "¨" */
    0xd, 0xa0, 0x2e, 0x60, 0xda, 0x2, 0xf6,

    /* U+00A9 "©" */
    0x0, 0x0, 0x6, 0xbe, 0xed, 0x93, 0x0, 0x0,
    0x0, 0x4, 0xec, 0x62, 0x23, 0x8e, 0xa0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x1, 0xbc, 0x0,
    0x0, 0xe6, 0x0, 0x7e, 0xff, 0xb0, 0xc, 0x80,
    0x6, 0xc0, 0x7, 0xf9, 0x45, 0x80, 0x3, 0xf1,
    0xc, 0x60, 0xf, 0xb0, 0x0, 0x0, 0x0, 0xd6,
    0xf, 0x20, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x99,
    0xf, 0x10, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x7a,
    0xf, 0x20, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x89,
    0xc, 0x50, 0x1f, 0x80, 0x0, 0x0, 0x0, 0xb7,
    0x8, 0xb0, 0x9, 0xf5, 0x12, 0x50, 0x2, 0xf2,
    0x1, 0xf5, 0x0, 0xbf, 0xff, 0xb0, 0xb, 0xb0,
    0x0, 0x5f, 0x40, 0x1, 0x32, 0x0, 0x9e, 0x10,
    0x0, 0x6, 0xf9, 0x30, 0x1, 0x5d, 0xd2, 0x0,
    0x0, 0x0, 0x29, 0xef, 0xff, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,

    /* U+00AA "ª" */
    0x7, 0xde, 0xc5, 0x0, 0x64, 0x28, 0xf0, 0x0,
    0x0, 0x1f, 0x20, 0x6c, 0xee, 0xf2, 0x3f, 0x30,
    0x1f, 0x25, 0xf1, 0x8, 0xf2, 0xc, 0xfe, 0x8e,
    0x20, 0x1, 0x0, 0x0,

    /* U+00AB "«" */
    0x0, 0x0, 0x40, 0x0, 0x40, 0x0, 0xa, 0xf2,
    0xa, 0xf2, 0x0, 0x7f, 0x60, 0x8f, 0x60, 0x5,
    0xf9, 0x5, 0xf9, 0x0, 0x1f, 0xd0, 0x2f, 0xd0,
    0x0, 0xa, 0xf4, 0xa, 0xf4, 0x0, 0x0, 0xcf,
    0x20, 0xce, 0x20, 0x0, 0x1e, 0xd1, 0x1e, 0xd0,
    0x0, 0x3, 0xa1, 0x3, 0xa1,

    /* U+00AC "¬" */
    0x22, 0x22, 0x22, 0x22, 0x20, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x44, 0x44, 0x44, 0x44, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x41,

    /* U+00AD "­" */
    0x19, 0x99, 0x95, 0x3f, 0xff, 0xfa,

    /* U+00AE "®" */
    0x0, 0x0, 0x6, 0xbe, 0xed, 0x93, 0x0, 0x0,
    0x0, 0x4, 0xec, 0x62, 0x23, 0x8e, 0xa0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x1, 0xbc, 0x0,
    0x0, 0xe6, 0x6, 0xff, 0xfe, 0x60, 0xc, 0x80,
    0x6, 0xc0, 0x6, 0xf4, 0x4b, 0xf2, 0x3, 0xf1,
    0xc, 0x60, 0x6, 0xf1, 0x4, 0xf4, 0x0, 0xd6,
    0xf, 0x20, 0x6, 0xf1, 0x1a, 0xf1, 0x0, 0x99,
    0xf, 0x10, 0x6, 0xff, 0xff, 0x50, 0x0, 0x7a,
    0xf, 0x20, 0x6, 0xf4, 0x9f, 0x20, 0x0, 0x89,
    0xc, 0x50, 0x6, 0xf1, 0xe, 0xa0, 0x0, 0xb7,
    0x8, 0xb0, 0x6, 0xf1, 0x7, 0xf3, 0x2, 0xf2,
    0x1, 0xf5, 0x6, 0xf1, 0x0, 0xdc, 0xb, 0xb0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x9e, 0x10,
    0x0, 0x6, 0xf9, 0x30, 0x1, 0x5d, 0xd2, 0x0,
    0x0, 0x0, 0x29, 0xef, 0xff, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,

    /* U+00AF "¯" */
    0x1, 0x11, 0x11, 0x11, 0x11, 0x10, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+00B0 "°" */
    0x8, 0xef, 0xc3, 0x7, 0xe5, 0x39, 0xf1, 0xd7,
    0x0, 0xe, 0x6d, 0x70, 0x0, 0xe6, 0x9d, 0x20,
    0x6f, 0x20, 0xbf, 0xff, 0x50, 0x0, 0x12, 0x0,
    0x0,

    /* U+00B1 "±" */
    0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x11,
    0x12, 0xf7, 0x11, 0x10, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x44, 0x44, 0xf9, 0x44, 0x41, 0x0, 0x0,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xc5,
    0x0, 0x0, 0x77, 0x77, 0x77, 0x77, 0x72, 0xff,
    0xff, 0xff, 0xff, 0xf6,

    /* U+00B2 "²" */
    0x8, 0xef, 0xd4, 0x2, 0xd5, 0x3b, 0xe0, 0x0,
    0x0, 0x4f, 0x10, 0x0, 0x8, 0xe0, 0x0, 0x3,
    0xf5, 0x0, 0x3, 0xf7, 0x0, 0x3, 0xe8, 0x0,
    0x3, 0xeb, 0x44, 0x40, 0x8f, 0xff, 0xff, 0x20,

    /* U+00B3 "³" */
    0x2a, 0xef, 0xd4, 0x4, 0xb4, 0x2b, 0xf0, 0x0,
    0x0, 0x4f, 0x20, 0x0, 0xa, 0xd0, 0x5, 0xff,
    0xf4, 0x0, 0x2, 0x39, 0xf2, 0x0, 0x0, 0xf,
    0x66, 0x52, 0x29, 0xf2, 0x6d, 0xff, 0xc5, 0x0,

    /* U+00B4 "´" */
    0x0, 0x9f, 0x80, 0x4f, 0xa0, 0x1e, 0x80, 0x0,

    /* U+00B5 "µ" */
    0x4f, 0x70, 0x0, 0x0, 0xfc, 0x4f, 0x70, 0x0,
    0x0, 0xfc, 0x4f, 0x70, 0x0, 0x0, 0xfc, 0x4f,
    0x70, 0x0, 0x0, 0xfc, 0x4f, 0x70, 0x0, 0x0,
    0xfc, 0x4f, 0x70, 0x0, 0x0, 0xfc, 0x4f, 0x70,
    0x0, 0x0, 0xfc, 0x4f, 0x70, 0x0, 0x3, 0xfc,
    0x4f, 0xb0, 0x0, 0x9, 0xfc, 0x4f, 0xfa, 0x45,
    0x9e, 0xfc, 0x4f, 0xad, 0xff, 0xa2, 0xcc, 0x4f,
    0x60, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0,

    /* U+00B6 "¶" */
    0x2, 0xae, 0xff, 0xff, 0xff, 0x1e, 0xff, 0xff,
    0xc2, 0x4f, 0x8f, 0xff, 0xff, 0xc0, 0x3f, 0xcf,
    0xff, 0xff, 0xc0, 0x3f, 0xef, 0xff, 0xff, 0xc0,
    0x3f, 0xef, 0xff, 0xff, 0xc0, 0x3f, 0xcf, 0xff,
    0xff, 0xc0, 0x3f, 0x8f, 0xff, 0xff, 0xc0, 0x3f,
    0x1e, 0xff, 0xff, 0xc0, 0x3f, 0x1, 0x9d, 0xdd,
    0xc0, 0x3f, 0x0, 0x0, 0x6, 0xc0, 0x3f, 0x0,
    0x0, 0x6, 0xc0, 0x3f, 0x0, 0x0, 0x6, 0xc0,
    0x3f, 0x0, 0x0, 0x6, 0xc0, 0x3f, 0x0, 0x0,
    0x6, 0xc0, 0x3f, 0x0, 0x0, 0x6, 0xc0, 0x3f,
    0x0, 0x0, 0x6, 0xc0, 0x3f, 0x0, 0x0, 0x3,
    0x70, 0x19,

    /* U+00B7 "·" */
    0x2a, 0x68, 0xfe, 0x4f, 0x90,

    /* U+00B8 "¸" */
    0x4, 0xb0, 0x0, 0xcd, 0x50, 0x1, 0x8f, 0x20,
    0x5, 0xf2, 0xbf, 0xf8, 0x1, 0x20, 0x0,

    /* U+00B9 "¹" */
    0x0, 0x6f, 0xc0, 0xaf, 0xcc, 0xb, 0x29, 0xc0,
    0x0, 0xac, 0x0, 0xa, 0xc0, 0x0, 0xac, 0x0,
    0xa, 0xc0, 0x0, 0xac, 0x0, 0xa, 0xc0,

    /* U+00BA "º" */
    0x2, 0xbe, 0xd7, 0x0, 0xd9, 0x24, 0xe6, 0x3f,
    0x0, 0x8, 0xc5, 0xe0, 0x0, 0x6e, 0x4f, 0x0,
    0x7, 0xd0, 0xe7, 0x1, 0xd7, 0x3, 0xdf, 0xf9,
    0x0, 0x0, 0x10, 0x0,

    /* U+00BB "»" */
    0x3, 0x10, 0x3, 0x10, 0x0, 0xe, 0xc0, 0x1e,
    0xc0, 0x0, 0x3, 0xfa, 0x4, 0xfa, 0x0, 0x0,
    0x6f, 0x80, 0x6f, 0x70, 0x0, 0xa, 0xf4, 0xb,
    0xf3, 0x0, 0x2f, 0xc0, 0x2f, 0xc0, 0x0, 0xde,
    0x11, 0xde, 0x10, 0xb, 0xf3, 0xb, 0xf2, 0x0,
    0x9, 0x50, 0x9, 0x40, 0x0,

    /* U+00BC "¼" */
    0x0, 0x19, 0x70, 0x0, 0x0, 0x9, 0x50, 0x0,
    0x4e, 0xfb, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x1f,
    0x7a, 0xb0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x10,
    0xbb, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x3f, 0x40, 0x0, 0x0, 0x0, 0xbb,
    0x0, 0xc, 0xa0, 0x0, 0x0, 0x0, 0xb, 0xb0,
    0x6, 0xf2, 0x2, 0xb5, 0x0, 0x0, 0xbb, 0x1,
    0xe7, 0x0, 0xcf, 0x80, 0x0, 0xb, 0xb0, 0x9d,
    0x0, 0x6a, 0xf8, 0x0, 0x0, 0x0, 0x3f, 0x40,
    0x2e, 0x1f, 0x80, 0x0, 0x0, 0xc, 0xb0, 0xc,
    0x70, 0xf8, 0x0, 0x0, 0x6, 0xf2, 0x7, 0xc0,
    0xf, 0x80, 0x0, 0x1, 0xe8, 0x0, 0xef, 0xff,
    0xff, 0xb0, 0x0, 0x9d, 0x0, 0x2, 0x33, 0x3f,
    0x92, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0xf8,
    0x0,

    /* U+00BD "½" */
    0x1, 0xaf, 0x80, 0x0, 0x0, 0xad, 0x0, 0x3,
    0xea, 0xe8, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x4,
    0xe, 0x80, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x8, 0xe1, 0x0, 0x0, 0x0, 0xe,
    0x80, 0x2, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xe8,
    0x0, 0xbc, 0x4c, 0xfe, 0x80, 0x0, 0xe, 0x80,
    0x5f, 0x2c, 0xa3, 0x6f, 0x50, 0x0, 0xe8, 0xe,
    0x80, 0x10, 0x0, 0xe8, 0x0, 0x9, 0x49, 0xe0,
    0x0, 0x0, 0x1f, 0x60, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xcb, 0x0, 0x0,
    0x9, 0xe2, 0x0, 0x0, 0x6f, 0x20, 0x0, 0x8,
    0xe2, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x7, 0xe3,
    0x0, 0x0, 0xa, 0xd0, 0x0, 0x1, 0xff, 0xff,
    0xf8, 0x0, 0x31, 0x0, 0x0, 0x3, 0x33, 0x33,
    0x10,

    /* U+00BE "¾" */
    0x3b, 0xef, 0xd5, 0x0, 0x0, 0x3, 0xf4, 0x0,
    0x16, 0x10, 0x8f, 0x10, 0x0, 0xc, 0xb0, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x6, 0xff, 0xf4, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x23, 0xaf, 0x10, 0xa, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x50, 0x4f, 0x30, 0x5b, 0x20,
    0x53, 0x0, 0x8f, 0x20, 0xd9, 0x1, 0xef, 0x30,
    0x8f, 0xff, 0xf6, 0x8, 0xe0, 0xb, 0x9f, 0x30,
    0x0, 0x22, 0x0, 0x2f, 0x50, 0x6c, 0x4f, 0x30,
    0x0, 0x0, 0x0, 0xcb, 0x2, 0xe2, 0x4f, 0x30,
    0x0, 0x0, 0x6, 0xf2, 0xb, 0x80, 0x4f, 0x30,
    0x0, 0x0, 0x1f, 0x70, 0x2f, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0xad, 0x0, 0x3, 0x33, 0x6f, 0x51,
    0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x4f, 0x30,

    /* U+00BF "¿" */
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0x2f, 0xf4,
    0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x68, 0x0, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0,
    0x3, 0xee, 0x10, 0x0, 0x4, 0xfd, 0x20, 0x0,
    0x1, 0xed, 0x10, 0x0, 0x0, 0x6f, 0x50, 0x0,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x3, 0x0, 0xdf, 0xb9, 0xae, 0xf3, 0x1,
    0xae, 0xfe, 0xb6, 0x0,

    /* U+00C0 "À" */
    0x0, 0x1, 0xef, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xd8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf9, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x3f, 0x70, 0xbf, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x6f,
    0x50, 0x0, 0x8f, 0x20, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x3, 0xfc, 0x99, 0x99, 0x9e,
    0xf0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x7f, 0x60,
    0xf, 0xc0, 0x0, 0x0, 0x1, 0xfc, 0x6, 0xf6,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0xcf, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x90,

    /* U+00C1 "Á" */
    0x0, 0x0, 0x0, 0x2f, 0xe2, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf9, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x3f, 0x70, 0xbf, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x6f,
    0x50, 0x0, 0x8f, 0x20, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x3, 0xfc, 0x99, 0x99, 0x9e,
    0xf0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x7f, 0x60,
    0xf, 0xc0, 0x0, 0x0, 0x1, 0xfc, 0x6, 0xf6,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0xcf, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x90,

    /* U+00C2 "Â" */
    0x0, 0x0, 0x1d, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xe9, 0xf7, 0x0, 0x0, 0x0, 0xb, 0xc1,
    0x5, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf9, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x3f, 0x70, 0xbf, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x6f,
    0x50, 0x0, 0x8f, 0x20, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x3, 0xfc, 0x99, 0x99, 0x9e,
    0xf0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x7f, 0x60,
    0xf, 0xc0, 0x0, 0x0, 0x1, 0xfc, 0x6, 0xf6,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0xcf, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x90,

    /* U+00C3 "Ã" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x8f, 0xfa, 0x35, 0xe0, 0x0, 0x0, 0x2f, 0x67,
    0xef, 0xf6, 0x0, 0x0, 0x1, 0x30, 0x0, 0x32,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf9, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x1f,
    0x90, 0x0, 0x0, 0x0, 0x3f, 0x70, 0xbf, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x6f,
    0x50, 0x0, 0x8f, 0x20, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x3, 0xfc, 0x99, 0x99, 0x9e,
    0xf0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x7f, 0x60,
    0xf, 0xc0, 0x0, 0x0, 0x1, 0xfc, 0x6, 0xf6,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0xcf, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x90,

    /* U+00C4 "Ä" */
    0x0, 0x4, 0xf4, 0x8, 0xe1, 0x0, 0x0, 0x0,
    0x4f, 0x40, 0x8e, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x9f, 0x30, 0x0, 0x0, 0x0, 0xd,
    0xd1, 0xf9, 0x0, 0x0, 0x0, 0x3, 0xf7, 0xb,
    0xf0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x5f, 0x60,
    0x0, 0x0, 0xf, 0xb0, 0x0, 0xec, 0x0, 0x0,
    0x6, 0xf5, 0x0, 0x8, 0xf2, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x3f, 0xc9, 0x99,
    0x99, 0xef, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x7,
    0xf6, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x1f, 0xc0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0xaf, 0x2c, 0xf0,
    0x0, 0x0, 0x0, 0x4, 0xf9,

    /* U+00C5 "Å" */
    0x0, 0x0, 0x2c, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xa, 0x80, 0xc6, 0x0, 0x0, 0x0, 0x0, 0xd3,
    0x9, 0x80, 0x0, 0x0, 0x0, 0xa, 0x80, 0xc6,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x9f, 0x30, 0x0, 0x0, 0x0, 0xd,
    0xd1, 0xf9, 0x0, 0x0, 0x0, 0x3, 0xf7, 0xb,
    0xf0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x5f, 0x60,
    0x0, 0x0, 0xf, 0xb0, 0x0, 0xec, 0x0, 0x0,
    0x6, 0xf5, 0x0, 0x8, 0xf2, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x3f, 0xc9, 0x99,
    0x99, 0xef, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x7,
    0xf6, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x1f, 0xc0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0xaf, 0x2c, 0xf0,
    0x0, 0x0, 0x0, 0x4, 0xf9,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0xe, 0xe9, 0xfe, 0x99,
    0x99, 0x93, 0x0, 0x0, 0x0, 0x7f, 0x50, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf6,
    0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xe0, 0x0, 0xfe, 0x99, 0x99, 0x90, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xde, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf9, 0x99, 0x99, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x10, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x0, 0x0,
    0x0, 0xfe, 0x99, 0x99, 0x94, 0xc, 0xf1, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xf6,

    /* U+00C7 "Ç" */
    0x0, 0x3, 0x9d, 0xff, 0xeb, 0x50, 0x0, 0x8f,
    0xfc, 0x99, 0xbf, 0xb0, 0x7, 0xfd, 0x30, 0x0,
    0x0, 0x10, 0x1f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfd, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xfc, 0xa9, 0xbe, 0x70, 0x0, 0x5,
    0xbe, 0xff, 0xeb, 0x30, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x60, 0x0, 0x0, 0x0,
    0x12, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x7f, 0xe8,
    0x0, 0x0,

    /* U+00C8 "È" */
    0x0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0x5f, 0x80,
    0x0, 0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xfe, 0x1f, 0xe9, 0x99, 0x99, 0x81,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xe9, 0x99,
    0x99, 0x51, 0xff, 0xff, 0xff, 0xf9, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfe, 0x99, 0x99,
    0x98, 0x1f, 0xff, 0xff, 0xff, 0xe0,

    /* U+00C9 "É" */
    0x0, 0x0, 0x5, 0xfc, 0x0, 0x0, 0x1, 0xed,
    0x10, 0x0, 0x0, 0xbc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xfe, 0x1f, 0xe9, 0x99, 0x99, 0x81,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xe9, 0x99,
    0x99, 0x51, 0xff, 0xff, 0xff, 0xf9, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfe, 0x99, 0x99,
    0x98, 0x1f, 0xff, 0xff, 0xff, 0xe0,

    /* U+00CA "Ê" */
    0x0, 0x3, 0xff, 0x50, 0x0, 0x2, 0xec, 0xbf,
    0x30, 0x1, 0xd9, 0x0, 0x8e, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xfe, 0x1f, 0xe9, 0x99, 0x99, 0x81,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xe9, 0x99,
    0x99, 0x51, 0xff, 0xff, 0xff, 0xf9, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfe, 0x99, 0x99,
    0x98, 0x1f, 0xff, 0xff, 0xff, 0xe0,

    /* U+00CB "Ë" */
    0x0, 0x8e, 0x10, 0xcb, 0x0, 0x8, 0xe1, 0xc,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xe1, 0xfe,
    0x99, 0x99, 0x98, 0x1f, 0xb0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfe, 0x99, 0x99, 0x95, 0x1f, 0xff, 0xff,
    0xff, 0x91, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0x1f, 0xe9, 0x99, 0x99, 0x81, 0xff, 0xff, 0xff,
    0xfe,

    /* U+00CC "Ì" */
    0x1e, 0xf3, 0x0, 0x2, 0xed, 0x0, 0x0, 0x2d,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0x2, 0xbf, 0x81, 0x0, 0x8f, 0x40,
    0x0, 0x8f, 0x40, 0x0, 0x8f, 0x40, 0x0, 0x8f,
    0x40, 0x0, 0x8f, 0x40, 0x0, 0x8f, 0x40, 0x0,
    0x8f, 0x40, 0x0, 0x8f, 0x40, 0x0, 0x8f, 0x40,
    0x0, 0x8f, 0x40, 0x2, 0xaf, 0x81, 0x3f, 0xff,
    0xff,

    /* U+00CD "Í" */
    0x0, 0x1, 0xff, 0x20, 0x0, 0xbf, 0x30, 0x0,
    0x6e, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xf0, 0x2, 0xbf, 0x81,
    0x0, 0x8, 0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x8,
    0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x8, 0xf4, 0x0,
    0x0, 0x8f, 0x40, 0x0, 0x2a, 0xf8, 0x10, 0x3f,
    0xff, 0xff, 0x0,

    /* U+00CE "Î" */
    0x0, 0xdf, 0xa0, 0x0, 0xbe, 0x8f, 0x80, 0xac,
    0x20, 0x4e, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xf0, 0x2, 0xbf, 0x81,
    0x0, 0x8, 0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x8,
    0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x8, 0xf4, 0x0,
    0x0, 0x8f, 0x40, 0x0, 0x2a, 0xf8, 0x10, 0x3f,
    0xff, 0xff, 0x0,

    /* U+00CF "Ï" */
    0x4f, 0x50, 0x7e, 0x13, 0xf5, 0x7, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0x0, 0x2b, 0xf8, 0x10, 0x0, 0x8f, 0x40,
    0x0, 0x8, 0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x8,
    0xf4, 0x0, 0x0, 0x8f, 0x40, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x8, 0xf4, 0x0,
    0x2, 0xaf, 0x81, 0x3, 0xff, 0xff, 0xf0,

    /* U+00D0 "Ð" */
    0x0, 0xef, 0xff, 0xfe, 0xc7, 0x0, 0x0, 0x0,
    0xef, 0x88, 0x9a, 0xef, 0xe3, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x6, 0xff, 0x20, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x6f, 0xb0, 0x0, 0xee, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0xee, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x6f, 0xff, 0xff, 0xf7, 0x0, 0x8,
    0xf5, 0x39, 0xff, 0x99, 0x93, 0x0, 0x8, 0xf5,
    0x0, 0xee, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0,
    0xee, 0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0xee,
    0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0xee, 0x0,
    0x0, 0x8, 0xfe, 0x10, 0x0, 0xef, 0x88, 0x9b,
    0xff, 0xd2, 0x0, 0x0, 0xef, 0xff, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+00D1 "Ñ" */
    0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x5f, 0xfb, 0x43, 0xe2, 0x0, 0x0, 0xe, 0x86,
    0xcf, 0xfa, 0x0, 0x0, 0x0, 0x40, 0x0, 0x33,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x6, 0xf4, 0x1f,
    0xfe, 0x10, 0x0, 0x0, 0x6f, 0x41, 0xfd, 0xf9,
    0x0, 0x0, 0x6, 0xf4, 0x1f, 0x8b, 0xf4, 0x0,
    0x0, 0x6f, 0x41, 0xf9, 0x2f, 0xd0, 0x0, 0x6,
    0xf4, 0x1f, 0x90, 0x6f, 0x80, 0x0, 0x6f, 0x41,
    0xf9, 0x0, 0xcf, 0x30, 0x6, 0xf4, 0x1f, 0x90,
    0x2, 0xfc, 0x0, 0x6f, 0x41, 0xf9, 0x0, 0x7,
    0xf7, 0x6, 0xf4, 0x1f, 0x90, 0x0, 0xc, 0xf2,
    0x6f, 0x41, 0xf9, 0x0, 0x0, 0x2f, 0xb5, 0xf4,
    0x1f, 0x90, 0x0, 0x0, 0x7f, 0xbf, 0x41, 0xf9,
    0x0, 0x0, 0x0, 0xcf, 0xf4, 0x1f, 0x90, 0x0,
    0x0, 0x3, 0xff, 0x40,

    /* U+00D2 "Ò" */
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xd8,
    0x10, 0x0, 0x0, 0xaf, 0xfb, 0x9a, 0xdf, 0xf4,
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x4, 0xef, 0x30,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0xaf, 0x30,
    0x0, 0x0, 0x0, 0x9, 0xf4, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x8, 0xf6, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x7f, 0x70, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x9, 0xfc, 0x10, 0x0, 0x4, 0xff, 0x30, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf5, 0x0, 0x0, 0x4,
    0xbe, 0xff, 0xd9, 0x20, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xd8,
    0x10, 0x0, 0x0, 0xaf, 0xfb, 0x9a, 0xdf, 0xf4,
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x4, 0xef, 0x30,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0xaf, 0x30,
    0x0, 0x0, 0x0, 0x9, 0xf4, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x8, 0xf6, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x7f, 0x70, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x9, 0xfc, 0x10, 0x0, 0x4, 0xff, 0x30, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf5, 0x0, 0x0, 0x4,
    0xbe, 0xff, 0xd9, 0x20, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x0, 0x7, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x9d, 0xd1, 0x0, 0x0, 0x0, 0x4,
    0xe6, 0x1, 0xbc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xd8,
    0x10, 0x0, 0x0, 0xaf, 0xfb, 0x9a, 0xdf, 0xf4,
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x4, 0xef, 0x30,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0xaf, 0x30,
    0x0, 0x0, 0x0, 0x9, 0xf4, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x8, 0xf6, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x7f, 0x70, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x9, 0xfc, 0x10, 0x0, 0x4, 0xff, 0x30, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf5, 0x0, 0x0, 0x4,
    0xbe, 0xff, 0xd9, 0x20, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xef, 0xd5, 0x2c, 0x50, 0x0, 0x0, 0xa,
    0xa5, 0xbf, 0xfd, 0x0, 0x0, 0x0, 0x3, 0x10,
    0x2, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xd8,
    0x10, 0x0, 0x0, 0xaf, 0xfb, 0x9a, 0xdf, 0xf4,
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x4, 0xef, 0x30,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0xaf, 0x30,
    0x0, 0x0, 0x0, 0x9, 0xf4, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x8, 0xf6, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x7f, 0x70, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x9, 0xfc, 0x10, 0x0, 0x4, 0xff, 0x30, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf5, 0x0, 0x0, 0x4,
    0xbe, 0xff, 0xd9, 0x20, 0x0,

    /* U+00D6 "Ö" */
    0x0, 0x0, 0xcb, 0x1, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0xcb, 0x1, 0xe7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xd8,
    0x10, 0x0, 0x0, 0xaf, 0xfb, 0x9a, 0xdf, 0xf4,
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x4, 0xef, 0x30,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0xaf, 0x30,
    0x0, 0x0, 0x0, 0x9, 0xf4, 0xcf, 0x20, 0x0,
    0x0, 0x0, 0x8, 0xf6, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x7f, 0x70, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x2f, 0xe0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x9, 0xfc, 0x10, 0x0, 0x4, 0xff, 0x30, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf5, 0x0, 0x0, 0x4,
    0xbe, 0xff, 0xd9, 0x20, 0x0,

    /* U+00D7 "×" */
    0x4, 0x0, 0x0, 0x1, 0x30, 0x7f, 0x50, 0x0,
    0x1d, 0xd0, 0xa, 0xf5, 0x1, 0xde, 0x20, 0x0,
    0xaf, 0x6d, 0xe2, 0x0, 0x0, 0xb, 0xfe, 0x20,
    0x0, 0x0, 0x1d, 0xff, 0x50, 0x0, 0x1, 0xdf,
    0x3b, 0xf5, 0x0, 0x1d, 0xf3, 0x0, 0xbf, 0x40,
    0x6f, 0x30, 0x0, 0xb, 0xc0, 0x1, 0x0, 0x0,
    0x0, 0x10,

    /* U+00D8 "Ø" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x5, 0xbe, 0xff, 0xc8, 0x6f, 0x40, 0x0, 0xaf,
    0xfb, 0x9a, 0xdf, 0xfc, 0x0, 0x9, 0xfc, 0x10,
    0x0, 0xd, 0xff, 0x20, 0x2f, 0xe0, 0x0, 0x0,
    0x8f, 0x9f, 0xb0, 0x7f, 0x70, 0x0, 0x4, 0xf8,
    0xd, 0xf1, 0xaf, 0x30, 0x0, 0x1e, 0xb0, 0x9,
    0xf4, 0xcf, 0x20, 0x0, 0xce, 0x10, 0x8, 0xf6,
    0xcf, 0x20, 0x8, 0xf4, 0x0, 0x8, 0xf6, 0xaf,
    0x40, 0x4f, 0x70, 0x0, 0xa, 0xf4, 0x7f, 0x71,
    0xeb, 0x0, 0x0, 0xd, 0xf1, 0x1f, 0xec, 0xe1,
    0x0, 0x0, 0x5f, 0xb0, 0x8, 0xff, 0x50, 0x0,
    0x4, 0xff, 0x30, 0x4, 0xff, 0xfb, 0x9a, 0xdf,
    0xf5, 0x0, 0xd, 0xc4, 0xae, 0xff, 0xd9, 0x20,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+00D9 "Ù" */
    0x0, 0x1, 0xef, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x2f, 0xa0, 0x0, 0x0,
    0x0, 0xfc, 0xf, 0xe0, 0x0, 0x0, 0x4, 0xf9,
    0x9, 0xf9, 0x0, 0x0, 0x1d, 0xf3, 0x1, 0xdf,
    0xea, 0x9b, 0xff, 0x70, 0x0, 0x7, 0xcf, 0xfe,
    0xa3, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x0, 0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0xce, 0x30, 0x0, 0x0, 0x0, 0x8, 0xd2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x2f, 0xa0, 0x0, 0x0,
    0x0, 0xfc, 0xf, 0xe0, 0x0, 0x0, 0x4, 0xf9,
    0x9, 0xf9, 0x0, 0x0, 0x1d, 0xf3, 0x1, 0xdf,
    0xea, 0x9b, 0xff, 0x70, 0x0, 0x7, 0xcf, 0xfe,
    0xa3, 0x0,

    /* U+00DB "Û" */
    0x0, 0x0, 0x1e, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xce, 0x9f, 0x60, 0x0, 0x0, 0xb, 0xc1, 0x5,
    0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x2f, 0xa0, 0x0, 0x0,
    0x0, 0xfc, 0xf, 0xe0, 0x0, 0x0, 0x4, 0xf9,
    0x9, 0xf9, 0x0, 0x0, 0x1d, 0xf3, 0x1, 0xdf,
    0xea, 0x9b, 0xff, 0x70, 0x0, 0x7, 0xcf, 0xfe,
    0xa3, 0x0,

    /* U+00DC "Ü" */
    0x0, 0x5, 0xf4, 0x8, 0xe0, 0x0, 0x0, 0x5,
    0xf3, 0x8, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xfc, 0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0xfc, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0xfc, 0x2f, 0xa0, 0x0, 0x0,
    0x0, 0xfc, 0xf, 0xe0, 0x0, 0x0, 0x4, 0xf9,
    0x9, 0xf9, 0x0, 0x0, 0x1d, 0xf3, 0x1, 0xdf,
    0xea, 0x9b, 0xff, 0x70, 0x0, 0x7, 0xcf, 0xfe,
    0xa3, 0x0,

    /* U+00DD "Ý" */
    0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0, 0x0,
    0x7, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0xd, 0xf1, 0x2f, 0xb0, 0x0, 0x0,
    0x6f, 0x70, 0x9, 0xf4, 0x0, 0x0, 0xee, 0x0,
    0x1, 0xfc, 0x0, 0x7, 0xf5, 0x0, 0x0, 0x8f,
    0x40, 0x1e, 0xd0, 0x0, 0x0, 0xe, 0xd0, 0x8f,
    0x40, 0x0, 0x0, 0x6, 0xf7, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0,

    /* U+00DE "Þ" */
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xd9, 0x20,
    0x1, 0xfe, 0x99, 0xad, 0xff, 0x30, 0x1f, 0xb0,
    0x0, 0x7, 0xfb, 0x1, 0xfb, 0x0, 0x0, 0xe,
    0xf0, 0x1f, 0xb0, 0x0, 0x0, 0xcf, 0x11, 0xfb,
    0x0, 0x0, 0xe, 0xf0, 0x1f, 0xb0, 0x0, 0x8,
    0xf9, 0x1, 0xfe, 0x88, 0xad, 0xfd, 0x10, 0x1f,
    0xff, 0xff, 0xc7, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x0,

    /* U+00DF "ß" */
    0x0, 0x7d, 0xff, 0xea, 0x20, 0x0, 0xbf, 0xc8,
    0x7a, 0xfe, 0x10, 0x2f, 0xb0, 0x0, 0x7, 0xf6,
    0x4, 0xf7, 0x0, 0x0, 0x7f, 0x50, 0x4f, 0x70,
    0x0, 0x4f, 0xc0, 0x4, 0xf7, 0x0, 0x6f, 0xa0,
    0x0, 0x4f, 0x70, 0xf, 0xc0, 0x0, 0x4, 0xf7,
    0x0, 0xfe, 0x20, 0x0, 0x4f, 0x70, 0x5, 0xff,
    0x50, 0x4, 0xf7, 0x0, 0x3, 0xdf, 0x90, 0x4f,
    0x70, 0x0, 0x0, 0xaf, 0x64, 0xf7, 0x0, 0x0,
    0x1, 0xfb, 0x4f, 0x70, 0x0, 0x0, 0x1f, 0xa4,
    0xf7, 0xd, 0xa7, 0x7d, 0xf4, 0x4f, 0x70, 0x7d,
    0xff, 0xc5, 0x0,

    /* U+00E0 "à" */
    0x0, 0xb, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc,
    0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2, 0x0, 0x20,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x6b, 0xef,
    0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0xf,
    0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9, 0x1, 0xae,
    0xfe, 0x90, 0xc9,

    /* U+00E1 "á" */
    0x0, 0x0, 0x0, 0xdf, 0x50, 0x0, 0x0, 0x8,
    0xf6, 0x0, 0x0, 0x0, 0x3d, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc,
    0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2, 0x0, 0x20,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x6b, 0xef,
    0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0xf,
    0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9, 0x1, 0xae,
    0xfe, 0x90, 0xc9,

    /* U+00E2 "â" */
    0x0, 0x0, 0xaf, 0xd0, 0x0, 0x0, 0x9, 0xf7,
    0xeb, 0x0, 0x0, 0x6c, 0x30, 0x1b, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc,
    0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2, 0x0, 0x20,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x6b, 0xef,
    0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0xf,
    0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9, 0x1, 0xae,
    0xfe, 0x90, 0xc9,

    /* U+00E3 "ã" */
    0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x7e, 0xff,
    0xff, 0xe1, 0x0, 0x46, 0x65, 0x54, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc,
    0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2, 0x0, 0x20,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x6b, 0xef,
    0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0xf,
    0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9, 0x1, 0xae,
    0xfe, 0x90, 0xc9,

    /* U+00E4 "ä" */
    0x0, 0x1e, 0x80, 0x4f, 0x40, 0x0, 0x1e, 0x80,
    0x4f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4a, 0xef, 0xfc, 0x40, 0x0, 0xbe, 0x97, 0x9f,
    0xf2, 0x0, 0x20, 0x0, 0x7, 0xf7, 0x0, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x6b, 0xef, 0xff, 0xf9, 0x8, 0xfc, 0x53,
    0x35, 0xf9, 0xf, 0xe0, 0x0, 0x3, 0xf9, 0xf,
    0xc0, 0x0, 0x8, 0xf9, 0xb, 0xf8, 0x45, 0xad,
    0xf9, 0x1, 0xae, 0xfe, 0x90, 0xc9,

    /* U+00E5 "å" */
    0x0, 0x1, 0xbf, 0xd3, 0x0, 0x0, 0x7, 0xa0,
    0x8b, 0x0, 0x0, 0x8, 0xa0, 0x7b, 0x0, 0x0,
    0x1, 0xdf, 0xe3, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x4a, 0xef, 0xfc, 0x40, 0x0, 0xbe,
    0x97, 0x9f, 0xf2, 0x0, 0x20, 0x0, 0x7, 0xf7,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x6b, 0xef, 0xff, 0xf9, 0x8,
    0xfc, 0x53, 0x35, 0xf9, 0xf, 0xe0, 0x0, 0x3,
    0xf9, 0xf, 0xc0, 0x0, 0x8, 0xf9, 0xb, 0xf8,
    0x45, 0xad, 0xf9, 0x1, 0xae, 0xfe, 0x90, 0xc9,

    /* U+00E6 "æ" */
    0x0, 0x6b, 0xef, 0xe9, 0x2, 0xbf, 0xfc, 0x40,
    0x0, 0xe, 0xb8, 0x7a, 0xfb, 0xed, 0x87, 0xdf,
    0x50, 0x0, 0x0, 0x0, 0x9, 0xfd, 0x0, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x11, 0x7f, 0x91, 0x11,
    0x1a, 0xf3, 0x0, 0x5c, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x7f, 0xd7, 0x44, 0x9f, 0x94,
    0x44, 0x44, 0x41, 0xe, 0xf1, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x0, 0x9f,
    0xb0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x2f,
    0xef, 0x40, 0x0, 0x2, 0x0, 0x9f, 0xc8, 0xaf,
    0xb1, 0xef, 0xa8, 0x9d, 0xc0, 0x0, 0x9e, 0xfe,
    0x70, 0x1, 0xae, 0xfe, 0xb5, 0x0,

    /* U+00E7 "ç" */
    0x0, 0x5c, 0xff, 0xd8, 0x9, 0xfe, 0x99, 0xc9,
    0x4f, 0xb0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x5f, 0xb0, 0x0, 0x0, 0xa, 0xfd, 0x98, 0xbb,
    0x0, 0x6c, 0xff, 0xd7, 0x0, 0x1, 0xf1, 0x0,
    0x0, 0x5, 0xfd, 0x20, 0x0, 0x0, 0xe, 0x90,
    0x0, 0x1, 0x3e, 0x80, 0x0, 0x4f, 0xfa, 0x0,

    /* U+00E8 "è" */
    0x0, 0xaf, 0x80, 0x0, 0x0, 0x0, 0xa, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4,
    0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80,
    0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3,
    0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44,
    0x44, 0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0,
    0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b,
    0xff, 0xeb, 0x50,

    /* U+00E9 "é" */
    0x0, 0x0, 0xc, 0xf6, 0x0, 0x0, 0x0, 0x7f,
    0x70, 0x0, 0x0, 0x2, 0xd5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4,
    0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80,
    0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3,
    0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44,
    0x44, 0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0,
    0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b,
    0xff, 0xeb, 0x50,

    /* U+00EA "ê" */
    0x0, 0x9, 0xfd, 0x10, 0x0, 0x0, 0x7f, 0x8e,
    0xc0, 0x0, 0x5, 0xd3, 0x1, 0xab, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4,
    0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80,
    0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3,
    0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44,
    0x44, 0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0,
    0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b,
    0xff, 0xeb, 0x50,

    /* U+00EB "ë" */
    0x0, 0xe9, 0x3, 0xf5, 0x0, 0x0, 0xe9, 0x3,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xff, 0xb4, 0x0, 0x9, 0xfb, 0x78, 0xdf,
    0x50, 0x4f, 0x80, 0x0, 0x1e, 0xe0, 0xaf, 0x21,
    0x11, 0x1a, 0xf3, 0xdf, 0xff, 0xff, 0xff, 0xf4,
    0xef, 0x44, 0x44, 0x44, 0x41, 0xdf, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x0, 0x4f,
    0xd1, 0x0, 0x0, 0x20, 0x8, 0xfe, 0x98, 0x9d,
    0xc0, 0x0, 0x5b, 0xff, 0xeb, 0x50,

    /* U+00EC "ì" */
    0xb, 0xf6, 0x0, 0xb, 0xf2, 0x0, 0x8, 0xa0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x4, 0xf7, 0x0,
    0x4f, 0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70, 0x4,
    0xf7, 0x0, 0x4f, 0x70, 0x4, 0xf7, 0x0, 0x4f,
    0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70,

    /* U+00ED "í" */
    0x0, 0xdf, 0x40, 0x9f, 0x40, 0x3c, 0x30, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x4, 0xf7, 0x0, 0x4f,
    0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70, 0x4, 0xf7,
    0x0, 0x4f, 0x70, 0x4, 0xf7, 0x0, 0x4f, 0x70,
    0x4, 0xf7, 0x0, 0x4f, 0x70, 0x0,

    /* U+00EE "î" */
    0x0, 0xbf, 0xc0, 0x0, 0xae, 0x6e, 0xb0, 0x6a,
    0x10, 0x1a, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4, 0xf7,
    0x0, 0x0, 0x4f, 0x70, 0x0,

    /* U+00EF "ï" */
    0x1e, 0x70, 0x4f, 0x41, 0xe7, 0x4, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x4, 0xf7,
    0x0,

    /* U+00F0 "ð" */
    0x0, 0x1c, 0x60, 0x8, 0x60, 0x0, 0x1, 0xbf,
    0xce, 0xe6, 0x0, 0x0, 0x3, 0xef, 0xf3, 0x0,
    0x0, 0x8, 0xfc, 0x5f, 0xe1, 0x0, 0x0, 0x35,
    0x0, 0x4f, 0x90, 0x0, 0x0, 0x1, 0x10, 0x9f,
    0x10, 0x1, 0x9f, 0xff, 0xe8, 0xf7, 0x0, 0xcf,
    0xa5, 0x59, 0xff, 0xb0, 0x7f, 0x70, 0x0, 0x6,
    0xfe, 0xc, 0xf1, 0x0, 0x0, 0xe, 0xf0, 0xee,
    0x0, 0x0, 0x0, 0xcf, 0xd, 0xe0, 0x0, 0x0,
    0xd, 0xe0, 0xbf, 0x10, 0x0, 0x1, 0xfb, 0x5,
    0xfa, 0x0, 0x0, 0x8f, 0x50, 0x9, 0xfc, 0x87,
    0xbf, 0xa0, 0x0, 0x6, 0xcf, 0xfc, 0x70, 0x0,

    /* U+00F1 "ñ" */
    0x0, 0x0, 0x1, 0x11, 0x0, 0x1, 0xcf, 0xff,
    0xff, 0x90, 0x2, 0x56, 0x65, 0x43, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x34, 0xcf, 0xfc,
    0x40, 0x4f, 0xbf, 0xa8, 0xaf, 0xf2, 0x4f, 0xf3,
    0x0, 0x5, 0xf9, 0x4f, 0xb0, 0x0, 0x0, 0xfb,
    0x4f, 0x80, 0x0, 0x0, 0xfb, 0x4f, 0x70, 0x0,
    0x0, 0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb, 0x4f,
    0x70, 0x0, 0x0, 0xfb, 0x4f, 0x70, 0x0, 0x0,
    0xfb, 0x4f, 0x70, 0x0, 0x0, 0xfb, 0x4f, 0x70,
    0x0, 0x0, 0xfb,

    /* U+00F2 "ò" */
    0x0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x4d, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0,

    /* U+00F3 "ó" */
    0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0x2,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0,

    /* U+00F4 "ô" */
    0x0, 0x4, 0xff, 0x50, 0x0, 0x0, 0x3, 0xfb,
    0xaf, 0x40, 0x0, 0x1, 0xd7, 0x0, 0x7d, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0,

    /* U+00F5 "õ" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x2d, 0xff,
    0xff, 0xf7, 0x0, 0x2, 0x56, 0x65, 0x42, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0,

    /* U+00F6 "ö" */
    0x0, 0x9e, 0x0, 0xcb, 0x0, 0x0, 0x8, 0xe0,
    0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xcf, 0xfd, 0x60, 0x0, 0x9, 0xfd,
    0x88, 0xcf, 0xa0, 0x4, 0xfb, 0x0, 0x0, 0xaf,
    0x50, 0xaf, 0x30, 0x0, 0x1, 0xfc, 0xd, 0xf0,
    0x0, 0x0, 0xd, 0xf0, 0xee, 0x0, 0x0, 0x0,
    0xcf, 0xd, 0xf0, 0x0, 0x0, 0xd, 0xf0, 0xaf,
    0x30, 0x0, 0x1, 0xfc, 0x3, 0xfb, 0x0, 0x0,
    0xaf, 0x50, 0x8, 0xfd, 0x88, 0xcf, 0xa0, 0x0,
    0x5, 0xcf, 0xfc, 0x60, 0x0,

    /* U+00F7 "÷" */
    0x0, 0x0, 0x62, 0x0, 0x0, 0x0, 0x6, 0xfc,
    0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x11,
    0x10, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x44, 0x44,
    0x44, 0x44, 0x42, 0x0, 0x0, 0x62, 0x0, 0x0,
    0x0, 0x6, 0xfc, 0x0, 0x0, 0x0, 0x3, 0xf8,
    0x0, 0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x6, 0xcf,
    0xfc, 0x7f, 0x60, 0x9, 0xfd, 0x88, 0xdf, 0xe0,
    0x4, 0xfb, 0x0, 0x9, 0xff, 0x50, 0xaf, 0x30,
    0x5, 0xf8, 0xfb, 0xd, 0xf0, 0x1, 0xeb, 0xe,
    0xf0, 0xee, 0x0, 0xce, 0x10, 0xcf, 0xd, 0xf0,
    0x8f, 0x30, 0xd, 0xf0, 0xaf, 0x7f, 0x80, 0x1,
    0xfc, 0x3, 0xff, 0xc0, 0x0, 0xaf, 0x60, 0xd,
    0xfd, 0x88, 0xcf, 0xb0, 0x4, 0xf8, 0xcf, 0xfc,
    0x70, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+00F9 "ù" */
    0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0, 0x3, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x2b, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x1,
    0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x2, 0xfa, 0x6f,
    0x60, 0x0, 0x4, 0xfa, 0x4f, 0xa0, 0x0, 0xa,
    0xfa, 0xd, 0xf8, 0x45, 0xad, 0xfa, 0x1, 0xae,
    0xfe, 0x91, 0xda,

    /* U+00FA "ú" */
    0x0, 0x0, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x1e,
    0xc1, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x1,
    0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x2, 0xfa, 0x6f,
    0x60, 0x0, 0x4, 0xfa, 0x4f, 0xa0, 0x0, 0xa,
    0xfa, 0xd, 0xf8, 0x45, 0xad, 0xfa, 0x1, 0xae,
    0xfe, 0x91, 0xda,

    /* U+00FB "û" */
    0x0, 0x2, 0xff, 0x70, 0x0, 0x0, 0x2e, 0xb8,
    0xf6, 0x0, 0x0, 0xb7, 0x0, 0x4c, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x1,
    0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x2, 0xfa, 0x6f,
    0x60, 0x0, 0x4, 0xfa, 0x4f, 0xa0, 0x0, 0xa,
    0xfa, 0xd, 0xf8, 0x45, 0xad, 0xfa, 0x1, 0xae,
    0xfe, 0x91, 0xda,

    /* U+00FC "ü" */
    0x0, 0x7e, 0x20, 0xbd, 0x0, 0x0, 0x7f, 0x20,
    0xac, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1,
    0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x2, 0xfa, 0x6f, 0x60, 0x0, 0x4, 0xfa, 0x4f,
    0xa0, 0x0, 0xa, 0xfa, 0xd, 0xf8, 0x45, 0xad,
    0xfa, 0x1, 0xae, 0xfe, 0x91, 0xda,

    /* U+00FD "ý" */
    0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0x2,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x98, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x10,
    0x0, 0x0, 0xdf, 0x6, 0xf7, 0x0, 0x0, 0x3f,
    0xa0, 0xf, 0xd0, 0x0, 0x9, 0xf4, 0x0, 0x9f,
    0x30, 0x0, 0xee, 0x0, 0x3, 0xf8, 0x0, 0x4f,
    0x80, 0x0, 0xd, 0xe0, 0x9, 0xf2, 0x0, 0x0,
    0x7f, 0x40, 0xed, 0x0, 0x0, 0x1, 0xfa, 0x4f,
    0x70, 0x0, 0x0, 0xa, 0xe9, 0xf1, 0x0, 0x0,
    0x0, 0x4f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x50, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0,
    0x0, 0x3, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0x0, 0x0, 0x67, 0xbf, 0x90, 0x0, 0x0,
    0xb, 0xfe, 0x80, 0x0, 0x0, 0x0,

    /* U+00FE "þ" */
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x75,
    0xdf, 0xfa, 0x20, 0x4, 0xfc, 0xfa, 0x8a, 0xfe,
    0x20, 0x4f, 0xf2, 0x0, 0x5, 0xfa, 0x4, 0xfb,
    0x0, 0x0, 0xe, 0xf0, 0x4f, 0x80, 0x0, 0x0,
    0xbf, 0x24, 0xf7, 0x0, 0x0, 0xa, 0xf3, 0x4f,
    0x80, 0x0, 0x0, 0xbf, 0x24, 0xfb, 0x0, 0x0,
    0xe, 0xf0, 0x4f, 0xf2, 0x0, 0x5, 0xfa, 0x4,
    0xfc, 0xf9, 0x7a, 0xfe, 0x10, 0x4f, 0x65, 0xdf,
    0xfa, 0x20, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,

    /* U+00FF "ÿ" */
    0x0, 0x8e, 0x10, 0xcb, 0x0, 0x0, 0x8, 0xe1,
    0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf1, 0x0, 0x0, 0xd, 0xf0, 0x6f, 0x70,
    0x0, 0x3, 0xfa, 0x0, 0xfd, 0x0, 0x0, 0x9f,
    0x40, 0x9, 0xf3, 0x0, 0xe, 0xe0, 0x0, 0x3f,
    0x80, 0x4, 0xf8, 0x0, 0x0, 0xde, 0x0, 0x9f,
    0x20, 0x0, 0x7, 0xf4, 0xe, 0xd0, 0x0, 0x0,
    0x1f, 0xa4, 0xf7, 0x0, 0x0, 0x0, 0xae, 0x9f,
    0x10, 0x0, 0x0, 0x4, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0xe, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x0, 0x6, 0x7b, 0xf9,
    0x0, 0x0, 0x0, 0xbf, 0xe8, 0x0, 0x0, 0x0,
    0x0,

    /* U+0103 "ă" */
    0x0, 0x6d, 0x32, 0x3b, 0x90, 0x0, 0xc, 0xff,
    0xfd, 0x10, 0x0, 0x0, 0x34, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc,
    0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2, 0x0, 0x20,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x6b, 0xef,
    0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0xf,
    0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9, 0x1, 0xae,
    0xfe, 0x90, 0xc9,

    /* U+0105 "ą" */
    0x0, 0x4a, 0xef, 0xfc, 0x40, 0x0, 0xb, 0xe9,
    0x79, 0xff, 0x20, 0x0, 0x20, 0x0, 0x7, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0x6, 0xbe, 0xff, 0xff,
    0x90, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0x0, 0xfe,
    0x0, 0x0, 0x3f, 0x90, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0x0, 0xbf, 0x84, 0x5a, 0xdf, 0x90, 0x1,
    0xae, 0xfe, 0x90, 0xc9, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0x30, 0x0, 0x0, 0x0, 0xd, 0x80, 0x0,
    0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x83, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xe1,

    /* U+0107 "ć" */
    0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x7f, 0x60,
    0x0, 0x2, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5c, 0xff, 0xd8, 0x9, 0xfe, 0x99, 0xc9,
    0x4f, 0xb0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xee, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x5f, 0xb0, 0x0, 0x0, 0xa, 0xfd, 0x98, 0xbb,
    0x0, 0x6c, 0xff, 0xd7,

    /* U+010C "Č" */
    0x0, 0x7, 0xe3, 0x2, 0xda, 0x0, 0x0, 0x0,
    0x8f, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0xa, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x9d, 0xff, 0xeb, 0x50, 0x0, 0x8f, 0xfc, 0x99,
    0xbf, 0xb0, 0x7, 0xfd, 0x30, 0x0, 0x0, 0x10,
    0x1f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xfd, 0x20, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0xfc, 0xa9, 0xbe, 0x70, 0x0, 0x5, 0xbe, 0xff,
    0xeb, 0x30,

    /* U+010D "č" */
    0x6, 0xe5, 0x2, 0xcb, 0x0, 0x6, 0xf9, 0xeb,
    0x0, 0x0, 0x8, 0xec, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5c, 0xff, 0xd8, 0x0, 0x9f,
    0xe9, 0x9c, 0x90, 0x4f, 0xb0, 0x0, 0x0, 0xa,
    0xf3, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x0, 0x0, 0x0, 0xaf, 0xd9, 0x8b, 0xb0, 0x0,
    0x6c, 0xff, 0xd7, 0x0,

    /* U+010F "ď" */
    0x0, 0x0, 0x0, 0x2, 0xf9, 0xf, 0xa0, 0x0,
    0x0, 0x0, 0x2f, 0x94, 0xf4, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x8c, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x92, 0x10, 0x0, 0x8e, 0xfe, 0x82, 0xf9, 0x0,
    0x0, 0xbf, 0xc7, 0x8d, 0xcf, 0x90, 0x0, 0x5f,
    0xb0, 0x0, 0xd, 0xf9, 0x0, 0xb, 0xf3, 0x0,
    0x0, 0x6f, 0x90, 0x0, 0xdf, 0x0, 0x0, 0x3,
    0xf9, 0x0, 0xe, 0xe0, 0x0, 0x0, 0x2f, 0x90,
    0x0, 0xdf, 0x0, 0x0, 0x2, 0xf9, 0x0, 0xb,
    0xf3, 0x0, 0x0, 0x5f, 0x90, 0x0, 0x6f, 0xa0,
    0x0, 0xc, 0xf9, 0x0, 0x0, 0xcf, 0xc7, 0x8d,
    0xbf, 0x90, 0x0, 0x0, 0x8e, 0xfe, 0x80, 0xe9,
    0x0, 0x0,

    /* U+0110 "Đ" */
    0x0, 0xef, 0xff, 0xfe, 0xc7, 0x0, 0x0, 0x0,
    0xef, 0x88, 0x9a, 0xef, 0xe3, 0x0, 0x0, 0xee,
    0x0, 0x0, 0x6, 0xff, 0x20, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x6f, 0xb0, 0x0, 0xee, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0xee, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x6f, 0xff, 0xff, 0xf7, 0x0, 0x8,
    0xf5, 0x39, 0xff, 0x99, 0x93, 0x0, 0x8, 0xf5,
    0x0, 0xee, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0,
    0xee, 0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0xee,
    0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0xee, 0x0,
    0x0, 0x8, 0xfe, 0x10, 0x0, 0xef, 0x88, 0x9b,
    0xff, 0xd2, 0x0, 0x0, 0xef, 0xff, 0xfe, 0xb5,
    0x0, 0x0,

    /* U+0111 "đ" */
    0x0, 0x0, 0x11, 0x13, 0xf9, 0x10, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x1, 0x44, 0x45,
    0xfb, 0x40, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x0, 0x8e, 0xfe, 0x82, 0xf9, 0x0, 0xc, 0xfc,
    0x78, 0xdc, 0xf9, 0x0, 0x6f, 0xb0, 0x0, 0xc,
    0xf9, 0x0, 0xbf, 0x30, 0x0, 0x6, 0xf9, 0x0,
    0xdf, 0x0, 0x0, 0x3, 0xf9, 0x0, 0xef, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0xdf, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0xbf, 0x30, 0x0, 0x5, 0xf9, 0x0,
    0x6f, 0xa0, 0x0, 0xc, 0xf9, 0x0, 0xc, 0xfc,
    0x78, 0xdb, 0xf9, 0x0, 0x0, 0x8e, 0xfe, 0x80,
    0xe9, 0x0,

    /* U+0119 "ę" */
    0x0, 0x6d, 0xff, 0xb2, 0x0, 0x9, 0xfc, 0x78,
    0xff, 0x20, 0x4f, 0xb0, 0x0, 0x3f, 0xb0, 0xaf,
    0x30, 0x0, 0xc, 0xf1, 0xdf, 0x21, 0x11, 0x1a,
    0xf3, 0xef, 0xff, 0xff, 0xff, 0xf4, 0xdf, 0x44,
    0x44, 0x44, 0x41, 0xaf, 0x20, 0x0, 0x0, 0x0,
    0x4f, 0xb0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x98,
    0x9c, 0xc0, 0x0, 0x5b, 0xff, 0xff, 0x80, 0x0,
    0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0x5, 0xf1,
    0x0, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0x20, 0x0, 0x0, 0x2, 0xdf, 0x90,

    /* U+011B "ě" */
    0x6, 0xe5, 0x2, 0xcc, 0x0, 0x0, 0x6f, 0x9e,
    0xb0, 0x0, 0x0, 0x8, 0xec, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4,
    0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80,
    0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3,
    0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44,
    0x44, 0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0,
    0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b,
    0xff, 0xeb, 0x50,

    /* U+011F "ğ" */
    0x1, 0xf0, 0x0, 0x2f, 0x0, 0x0, 0xd8, 0x23,
    0xba, 0x0, 0x0, 0x4f, 0xff, 0xd1, 0x0, 0x0,
    0x1, 0x43, 0x0, 0x0, 0x0, 0x8e, 0xfe, 0x80,
    0xe9, 0xb, 0xfc, 0x89, 0xeb, 0xf9, 0x5f, 0xb0,
    0x0, 0xd, 0xf9, 0xaf, 0x30, 0x0, 0x6, 0xf9,
    0xdf, 0x0, 0x0, 0x2, 0xf9, 0xee, 0x0, 0x0,
    0x2, 0xf9, 0xdf, 0x0, 0x0, 0x2, 0xf9, 0xaf,
    0x30, 0x0, 0x5, 0xf9, 0x5f, 0xa0, 0x0, 0xb,
    0xf9, 0xb, 0xfc, 0x78, 0xdc, 0xf9, 0x0, 0x8e,
    0xfe, 0x82, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x5, 0xf7, 0x2, 0x0, 0x0,
    0xc, 0xf3, 0x1f, 0xc9, 0x78, 0xdf, 0xa0, 0x8,
    0xce, 0xff, 0xc7, 0x0,

    /* U+0131 "ı" */
    0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f,
    0x70,

    /* U+013E "ľ" */
    0x4f, 0x71, 0xfa, 0x4f, 0x74, 0xf3, 0x4f, 0x78,
    0xb0, 0x4f, 0x72, 0x10, 0x4f, 0x70, 0x0, 0x4f,
    0x70, 0x0, 0x4f, 0x70, 0x0, 0x4f, 0x70, 0x0,
    0x4f, 0x70, 0x0, 0x4f, 0x70, 0x0, 0x4f, 0x70,
    0x0, 0x4f, 0x70, 0x0, 0x4f, 0x70, 0x0, 0x4f,
    0x70, 0x0, 0x4f, 0x70, 0x0,

    /* U+0141 "Ł" */
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x1, 0xfb, 0x8, 0xc0, 0x0, 0x1, 0xfe,
    0xef, 0x80, 0x0, 0x4, 0xff, 0xa2, 0x0, 0x0,
    0x7f, 0xfb, 0x0, 0x0, 0x0, 0x26, 0xfb, 0x0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x1, 0xfe, 0x99, 0x99,
    0x99, 0x1, 0xff, 0xff, 0xff, 0xff,

    /* U+0142 "ł" */
    0x0, 0x7f, 0x50, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x7f, 0x50, 0x0, 0x7, 0xf5, 0x0, 0x0, 0x7f,
    0x50, 0x0, 0x7, 0xf5, 0x10, 0x0, 0x7f, 0xbf,
    0x10, 0x7, 0xff, 0x70, 0x9, 0xff, 0x50, 0x0,
    0xbb, 0xf5, 0x0, 0x0, 0x7f, 0x50, 0x0, 0x7,
    0xf5, 0x0, 0x0, 0x7f, 0x50, 0x0, 0x7, 0xf5,
    0x0, 0x0, 0x7f, 0x50, 0x0,

    /* U+0151 "ő" */
    0x0, 0x1f, 0xd0, 0x8f, 0x60, 0x0, 0x9, 0xf3,
    0x1f, 0xa0, 0x0, 0x3, 0xf4, 0xa, 0xb0, 0x0,
    0x0, 0x12, 0x0, 0x30, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0,

    /* U+0159 "ř" */
    0x4f, 0x60, 0x1b, 0xd0, 0x5, 0xf9, 0xdc, 0x10,
    0x0, 0x6e, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x32, 0xcf, 0xd0, 0x4f, 0x6f, 0xda, 0x80,
    0x4f, 0xf8, 0x0, 0x0, 0x4f, 0xd0, 0x0, 0x0,
    0x4f, 0x80, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0,

    /* U+015B "ś" */
    0x0, 0x0, 0xaf, 0x70, 0x0, 0x5, 0xf8, 0x0,
    0x0, 0x1d, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xdf, 0xfd, 0xa2, 0x9f, 0xb7, 0x7a, 0xf2,
    0xfc, 0x0, 0x0, 0x0, 0xee, 0x20, 0x0, 0x0,
    0x5f, 0xfa, 0x30, 0x0, 0x2, 0x9f, 0xfd, 0x40,
    0x0, 0x0, 0x6e, 0xf4, 0x0, 0x0, 0x2, 0xfa,
    0x10, 0x0, 0x2, 0xf9, 0xeb, 0x87, 0x8e, 0xf3,
    0x7d, 0xff, 0xeb, 0x30,

    /* U+015E "Ş" */
    0x2, 0x9e, 0xff, 0xd9, 0x30, 0x2f, 0xfc, 0x9a,
    0xcf, 0x70, 0xaf, 0x60, 0x0, 0x1, 0x0, 0xcf,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0,
    0x0, 0x3f, 0xe6, 0x0, 0x0, 0x0, 0x4, 0xdf,
    0xe9, 0x20, 0x0, 0x0, 0x5, 0xaf, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0x90, 0x0, 0x0, 0x0,
    0xe, 0xf0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x30,
    0x0, 0x0, 0x4f, 0xc0, 0xfe, 0xb9, 0x9c, 0xff,
    0x30, 0x7c, 0xef, 0xfd, 0x92, 0x0, 0x0, 0x9,
    0x90, 0x0, 0x0, 0x0, 0xc, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0x22, 0x9f,
    0x0, 0x0, 0x0, 0xdf, 0xd4, 0x0, 0x0,

    /* U+015F "ş" */
    0x7, 0xdf, 0xfd, 0xa2, 0x9f, 0xb7, 0x7a, 0xf2,
    0xfc, 0x0, 0x0, 0x0, 0xee, 0x20, 0x0, 0x0,
    0x5f, 0xfa, 0x30, 0x0, 0x2, 0x9f, 0xfd, 0x40,
    0x0, 0x0, 0x6e, 0xf4, 0x0, 0x0, 0x2, 0xfa,
    0x10, 0x0, 0x2, 0xf9, 0xeb, 0x87, 0x8e, 0xf3,
    0x7d, 0xff, 0xfb, 0x30, 0x0, 0xe, 0x40, 0x0,
    0x0, 0x3e, 0xd3, 0x0, 0x0, 0x0, 0xcb, 0x0,
    0x0, 0x22, 0xda, 0x0, 0x2, 0xff, 0xb1, 0x0,

    /* U+0161 "š" */
    0x4f, 0x60, 0x1b, 0xd0, 0x5, 0xf9, 0xdc, 0x10,
    0x0, 0x6e, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xdf, 0xfd, 0xa2, 0x9f, 0xb7, 0x7a, 0xf2,
    0xfc, 0x0, 0x0, 0x0, 0xee, 0x20, 0x0, 0x0,
    0x5f, 0xfa, 0x30, 0x0, 0x2, 0x9f, 0xfd, 0x40,
    0x0, 0x0, 0x6e, 0xf4, 0x0, 0x0, 0x2, 0xfa,
    0x10, 0x0, 0x2, 0xf9, 0xeb, 0x87, 0x8e, 0xf3,
    0x7d, 0xff, 0xeb, 0x30,

    /* U+0165 "ť" */
    0x0, 0x0, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x0,
    0x9, 0xe0, 0x0, 0x99, 0x0, 0xd, 0x60, 0x0,
    0xf9, 0x0, 0x3, 0x0, 0x6e, 0xff, 0xff, 0xb0,
    0x0, 0x47, 0xfb, 0x66, 0x40, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xa7, 0x70, 0x0, 0x0, 0x2b,
    0xff, 0xa0, 0x0,

    /* U+016F "ů" */
    0x0, 0x5, 0xef, 0x90, 0x0, 0x0, 0xe, 0x41,
    0xd4, 0x0, 0x0, 0xf, 0x30, 0xd4, 0x0, 0x0,
    0x6, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f,
    0x50, 0x0, 0x2, 0xfa, 0x6f, 0x60, 0x0, 0x4,
    0xfa, 0x4f, 0xa0, 0x0, 0xa, 0xfa, 0xd, 0xf8,
    0x45, 0xad, 0xfa, 0x1, 0xae, 0xfe, 0x91, 0xda,

    /* U+017A "ź" */
    0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x7, 0xf6,
    0x0, 0x0, 0x2, 0xc4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0x70, 0x56,
    0x66, 0x6c, 0xf5, 0x0, 0x0, 0x3, 0xfa, 0x0,
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x1e, 0xe0,
    0x0, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x1, 0xef, 0x66, 0x66, 0x63, 0x3f,
    0xff, 0xff, 0xff, 0xa0,

    /* U+017C "ż" */
    0x0, 0x2, 0xe8, 0x0, 0x0, 0x0, 0x3f, 0xa0,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0x70, 0x56,
    0x66, 0x6c, 0xf5, 0x0, 0x0, 0x3, 0xfa, 0x0,
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x1e, 0xe0,
    0x0, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x1, 0xef, 0x66, 0x66, 0x63, 0x3f,
    0xff, 0xff, 0xff, 0xa0,

    /* U+017E "ž" */
    0x5, 0xe5, 0x2, 0xcb, 0x0, 0x5, 0xfa, 0xfa,
    0x0, 0x0, 0x6, 0xca, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0x70, 0x56,
    0x66, 0x6c, 0xf5, 0x0, 0x0, 0x3, 0xfa, 0x0,
    0x0, 0x0, 0xde, 0x10, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x1e, 0xe0,
    0x0, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x1, 0xef, 0x66, 0x66, 0x63, 0x3f,
    0xff, 0xff, 0xff, 0xa0,

    /* U+01B0 "ư" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf0, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x4f, 0x90, 0x6f, 0x50, 0x0,
    0x1, 0xff, 0xfd, 0x10, 0x6f, 0x50, 0x0, 0x1,
    0xfd, 0x50, 0x0, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x0, 0x0, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x0, 0x0,
    0x6f, 0x50, 0x0, 0x2, 0xfa, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x4, 0xfa, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0xb, 0xfa, 0x0, 0x0, 0xd, 0xf8, 0x45,
    0xad, 0xfa, 0x0, 0x0, 0x1, 0xae, 0xfe, 0x91,
    0xda, 0x0, 0x0,

    /* U+0219 "ș" */
    0x7, 0xdf, 0xfd, 0xa2, 0x9f, 0xb7, 0x7a, 0xf2,
    0xfc, 0x0, 0x0, 0x0, 0xee, 0x20, 0x0, 0x0,
    0x5f, 0xfa, 0x30, 0x0, 0x2, 0x9f, 0xfd, 0x40,
    0x0, 0x0, 0x6e, 0xf4, 0x0, 0x0, 0x2, 0xfa,
    0x10, 0x0, 0x2, 0xf9, 0xeb, 0x87, 0x8e, 0xf3,
    0x7d, 0xff, 0xeb, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x30, 0x0, 0x0, 0xc, 0xe0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x5d, 0x0, 0x0,

    /* U+021B "ț" */
    0x0, 0x44, 0x0, 0x0, 0xe, 0x90, 0x0, 0x6d,
    0xff, 0xff, 0xb4, 0x7f, 0xb6, 0x64, 0x2, 0xf9,
    0x0, 0x0, 0x2f, 0x90, 0x0, 0x2, 0xf9, 0x0,
    0x0, 0x2f, 0x90, 0x0, 0x2, 0xf9, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x1, 0xfc, 0x0, 0x0, 0xc,
    0xfa, 0x77, 0x0, 0x2b, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x31, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0xe5, 0x0,

    /* U+0388 "Έ" */
    0xf, 0xf1, 0xc, 0xff, 0xff, 0xff, 0xf3, 0x4f,
    0x80, 0xc, 0xf9, 0x99, 0x99, 0x91, 0x9e, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0x53, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9, 0x99,
    0x99, 0x70, 0x0, 0x0, 0xc, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9,
    0x99, 0x99, 0x91, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xf3,

    /* U+0391 "Α" */
    0x0, 0x0, 0xa, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x9f, 0x30, 0x0, 0x0, 0x0, 0xd, 0xd1, 0xf9,
    0x0, 0x0, 0x0, 0x3, 0xf7, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x10, 0x5f, 0x60, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0xec, 0x0, 0x0, 0x6, 0xf5,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x3f, 0xc9, 0x99, 0x99, 0xef,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x7, 0xf6, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0xaf, 0x2c, 0xf0, 0x0, 0x0,
    0x0, 0x4, 0xf9,

    /* U+0392 "Β" */
    0x1f, 0xff, 0xff, 0xec, 0x81, 0x1, 0xfe, 0x88,
    0x9a, 0xef, 0xe0, 0x1f, 0xb0, 0x0, 0x0, 0xbf,
    0x51, 0xfb, 0x0, 0x0, 0x7, 0xf6, 0x1f, 0xb0,
    0x0, 0x0, 0xbf, 0x21, 0xfd, 0x88, 0x89, 0xde,
    0x50, 0x1f, 0xff, 0xff, 0xff, 0x92, 0x1, 0xfb,
    0x0, 0x1, 0x5e, 0xf3, 0x1f, 0xb0, 0x0, 0x0,
    0x3f, 0xb1, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x1f,
    0xb0, 0x0, 0x0, 0x1f, 0xd1, 0xfb, 0x0, 0x0,
    0x9, 0xf9, 0x1f, 0xe8, 0x88, 0x9d, 0xfd, 0x11,
    0xff, 0xff, 0xff, 0xd8, 0x10,

    /* U+0393 "Γ" */
    0x1f, 0xff, 0xff, 0xff, 0x81, 0xfe, 0x99, 0x99,
    0x94, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,

    /* U+0395 "Ε" */
    0x1f, 0xff, 0xff, 0xff, 0xe1, 0xfe, 0x99, 0x99,
    0x98, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfe,
    0x99, 0x99, 0x95, 0x1f, 0xff, 0xff, 0xff, 0x91,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xe9,
    0x99, 0x99, 0x81, 0xff, 0xff, 0xff, 0xfe,

    /* U+0397 "Η" */
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x1f, 0xe9, 0x99, 0x99, 0x99, 0xfd,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xfd, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xfd, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xfd,

    /* U+039B "Λ" */
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0xad,
    0xbd, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x96, 0xf3,
    0x0, 0x0, 0x0, 0x6, 0xf3, 0x1f, 0x90, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x2f, 0x80, 0x5, 0xf5, 0x0, 0x0, 0x8, 0xf2,
    0x0, 0xf, 0xb0, 0x0, 0x0, 0xec, 0x0, 0x0,
    0xaf, 0x10, 0x0, 0x4f, 0x60, 0x0, 0x4, 0xf7,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0xe, 0xd0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x9f, 0x30, 0x7f, 0x50,
    0x0, 0x0, 0x3, 0xf9, 0xd, 0xf0, 0x0, 0x0,
    0x0, 0xe, 0xf0,

    /* U+039C "Μ" */
    0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf3,
    0x1f, 0xef, 0x20, 0x0, 0x0, 0x1, 0xff, 0xf3,
    0x1f, 0x9f, 0x80, 0x0, 0x0, 0x6, 0xfa, 0xf3,
    0x1f, 0x9a, 0xe0, 0x0, 0x0, 0xc, 0xc8, 0xf3,
    0x1f, 0x94, 0xf5, 0x0, 0x0, 0x3f, 0x69, 0xf3,
    0x1f, 0x90, 0xeb, 0x0, 0x0, 0x9f, 0x19, 0xf3,
    0x1f, 0x90, 0x8f, 0x10, 0x0, 0xfa, 0x9, 0xf3,
    0x1f, 0x90, 0x2f, 0x70, 0x5, 0xf3, 0x9, 0xf3,
    0x1f, 0x90, 0xd, 0xd0, 0xc, 0xd0, 0x9, 0xf3,
    0x1f, 0x90, 0x7, 0xf3, 0x2f, 0x70, 0x9, 0xf3,
    0x1f, 0x90, 0x1, 0xfa, 0x8f, 0x10, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0xbf, 0xeb, 0x0, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0x5f, 0xf4, 0x0, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0xe, 0xe0, 0x0, 0x9, 0xf3,

    /* U+039D "Ν" */
    0x1f, 0xf5, 0x0, 0x0, 0x0, 0x6f, 0x41, 0xff,
    0xe1, 0x0, 0x0, 0x6, 0xf4, 0x1f, 0xdf, 0x90,
    0x0, 0x0, 0x6f, 0x41, 0xf8, 0xbf, 0x40, 0x0,
    0x6, 0xf4, 0x1f, 0x92, 0xfd, 0x0, 0x0, 0x6f,
    0x41, 0xf9, 0x6, 0xf8, 0x0, 0x6, 0xf4, 0x1f,
    0x90, 0xc, 0xf3, 0x0, 0x6f, 0x41, 0xf9, 0x0,
    0x2f, 0xc0, 0x6, 0xf4, 0x1f, 0x90, 0x0, 0x7f,
    0x70, 0x6f, 0x41, 0xf9, 0x0, 0x0, 0xcf, 0x26,
    0xf4, 0x1f, 0x90, 0x0, 0x2, 0xfb, 0x5f, 0x41,
    0xf9, 0x0, 0x0, 0x7, 0xfb, 0xf4, 0x1f, 0x90,
    0x0, 0x0, 0xc, 0xff, 0x41, 0xf9, 0x0, 0x0,
    0x0, 0x3f, 0xf4,

    /* U+039F "Ο" */
    0x0, 0x5, 0xbe, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0xaf, 0xfb, 0x9a, 0xdf, 0xf4, 0x0, 0x9, 0xfc,
    0x10, 0x0, 0x4, 0xef, 0x30, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0xd, 0xf1, 0xaf, 0x30, 0x0, 0x0, 0x0,
    0x9, 0xf4, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x8,
    0xf6, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x8, 0xf6,
    0xaf, 0x40, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x2f, 0xe0,
    0x0, 0x0, 0x0, 0x5f, 0xb0, 0x9, 0xfc, 0x10,
    0x0, 0x4, 0xff, 0x30, 0x0, 0xaf, 0xfb, 0x9a,
    0xdf, 0xf5, 0x0, 0x0, 0x4, 0xbe, 0xff, 0xd9,
    0x20, 0x0,

    /* U+03A0 "Π" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x1f, 0xe9,
    0x99, 0x99, 0x9a, 0xfa, 0x1f, 0xb0, 0x0, 0x0,
    0x2, 0xfa, 0x1f, 0xb0, 0x0, 0x0, 0x2, 0xfa,
    0x1f, 0xb0, 0x0, 0x0, 0x2, 0xfa, 0x1f, 0xb0,
    0x0, 0x0, 0x2, 0xfa, 0x1f, 0xb0, 0x0, 0x0,
    0x2, 0xfa, 0x1f, 0xb0, 0x0, 0x0, 0x2, 0xfa,
    0x1f, 0xb0, 0x0, 0x0, 0x2, 0xfa, 0x1f, 0xb0,
    0x0, 0x0, 0x2, 0xfa, 0x1f, 0xb0, 0x0, 0x0,
    0x2, 0xfa, 0x1f, 0xb0, 0x0, 0x0, 0x2, 0xfa,
    0x1f, 0xb0, 0x0, 0x0, 0x2, 0xfa, 0x1f, 0xb0,
    0x0, 0x0, 0x2, 0xfa,

    /* U+03A3 "Σ" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0x60, 0xef, 0xc9,
    0x99, 0x99, 0x94, 0x3, 0xfe, 0x20, 0x0, 0x0,
    0x0, 0x5, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x7,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x9, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xf4, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x1, 0xde, 0x10,
    0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0x0,
    0x9f, 0x50, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x0, 0x2f, 0xf9, 0x99, 0x99, 0x99, 0x63,
    0xff, 0xff, 0xff, 0xff, 0xfa,

    /* U+03A4 "Τ" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x99, 0x9b,
    0xfc, 0x99, 0x98, 0x0, 0x0, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x70, 0x0, 0x0, 0x0, 0x5, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x70, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0,
    0x0, 0x5, 0xf7, 0x0, 0x0,

    /* U+03A6 "Φ" */
    0x0, 0x0, 0x0, 0x7f, 0x50, 0x0, 0x0, 0x0,
    0x2, 0x8d, 0xff, 0xff, 0xfc, 0x81, 0x0, 0x6,
    0xff, 0xc9, 0xbf, 0xb9, 0xcf, 0xf4, 0x3, 0xfe,
    0x30, 0x7, 0xf5, 0x0, 0x4f, 0xf2, 0xaf, 0x40,
    0x0, 0x7f, 0x50, 0x0, 0x6f, 0x8e, 0xf0, 0x0,
    0x7, 0xf5, 0x0, 0x1, 0xfc, 0xfd, 0x0, 0x0,
    0x7f, 0x50, 0x0, 0xf, 0xde, 0xf0, 0x0, 0x7,
    0xf5, 0x0, 0x1, 0xfc, 0xaf, 0x50, 0x0, 0x7f,
    0x50, 0x0, 0x7f, 0x72, 0xfe, 0x30, 0x7, 0xf5,
    0x0, 0x5f, 0xe1, 0x5, 0xff, 0xc9, 0xbf, 0xa9,
    0xdf, 0xe3, 0x0, 0x2, 0x8d, 0xff, 0xff, 0xec,
    0x71, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x0,

    /* U+03A7 "Χ" */
    0x4f, 0xb0, 0x0, 0x0, 0xd, 0xe1, 0xa, 0xf5,
    0x0, 0x0, 0x8f, 0x40, 0x1, 0xee, 0x10, 0x3,
    0xfa, 0x0, 0x0, 0x5f, 0x90, 0xd, 0xe1, 0x0,
    0x0, 0xa, 0xf4, 0x7f, 0x50, 0x0, 0x0, 0x1,
    0xee, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0xf6, 0x0, 0x0,
    0x0, 0x5, 0xf7, 0xdf, 0x10, 0x0, 0x0, 0x1e,
    0xc0, 0x3f, 0xb0, 0x0, 0x0, 0xaf, 0x30, 0x9,
    0xf5, 0x0, 0x4, 0xf9, 0x0, 0x0, 0xee, 0x10,
    0xe, 0xe0, 0x0, 0x0, 0x5f, 0xa0, 0x9f, 0x40,
    0x0, 0x0, 0xb, 0xf5,

    /* U+03AC "ά" */
    0x0, 0x0, 0xc, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x34, 0x0, 0x0, 0x0,
    0x0, 0x8e, 0xfe, 0x80, 0xe9, 0x0, 0xb, 0xfc,
    0x78, 0xdb, 0xf9, 0x0, 0x5f, 0xa0, 0x0, 0xd,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x6, 0xf9, 0x0,
    0xdf, 0x0, 0x0, 0x3, 0xf9, 0x0, 0xee, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0xdf, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x5, 0xf9, 0x0,
    0x5f, 0xa0, 0x0, 0xc, 0xf9, 0x0, 0xb, 0xfc,
    0x78, 0xdb, 0xfe, 0x80, 0x0, 0x8e, 0xfe, 0x80,
    0x6f, 0xe0,

    /* U+03AD "έ" */
    0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0xbf,
    0x20, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x1,
    0x60, 0x0, 0x0, 0x5c, 0xff, 0xeb, 0x40, 0x5f,
    0xe8, 0x7a, 0xe7, 0xa, 0xf2, 0x0, 0x0, 0x10,
    0xaf, 0x10, 0x0, 0x0, 0x4, 0xfb, 0x31, 0x10,
    0x0, 0x5, 0xff, 0xfc, 0x0, 0x7, 0xfb, 0x54,
    0x30, 0x0, 0xfd, 0x0, 0x0, 0x0, 0xf, 0xd0,
    0x0, 0x0, 0x0, 0xaf, 0xd9, 0x89, 0xb8, 0x0,
    0x7d, 0xff, 0xec, 0x40,

    /* U+03AE "ή" */
    0x0, 0x0, 0xbf, 0x60, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x4, 0xf3, 0x0, 0x0, 0x0,
    0x3, 0x50, 0x0, 0x0, 0x4f, 0x36, 0xdf, 0xfb,
    0x20, 0x4f, 0xdd, 0x65, 0x7f, 0xe0, 0x4f, 0xf1,
    0x0, 0x7, 0xf5, 0x4f, 0xa0, 0x0, 0x3, 0xf8,
    0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4f, 0x70, 0x0,
    0x3, 0xf8, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4f,
    0x70, 0x0, 0x3, 0xf8, 0x4f, 0x70, 0x0, 0x3,
    0xf8, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4f, 0x70,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x3, 0xf8,
    0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0x3, 0xf8, 0x0, 0x0, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x0, 0x3, 0xf8,

    /* U+03AF "ί" */
    0x0, 0xef, 0x20, 0x3, 0xf9, 0x0, 0x8, 0xe1,
    0x0, 0x4, 0x30, 0x0, 0x5f, 0x60, 0x0, 0x5f,
    0x60, 0x0, 0x5f, 0x60, 0x0, 0x5f, 0x60, 0x0,
    0x5f, 0x60, 0x0, 0x5f, 0x60, 0x0, 0x5f, 0x60,
    0x0, 0x5f, 0x60, 0x0, 0x4f, 0x70, 0x0, 0x1f,
    0xf8, 0x82, 0x4, 0xdf, 0xe2,

    /* U+03B1 "α" */
    0x0, 0x8e, 0xfe, 0x80, 0xe9, 0x0, 0xb, 0xfc,
    0x78, 0xdb, 0xf9, 0x0, 0x5f, 0xa0, 0x0, 0xd,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x6, 0xf9, 0x0,
    0xdf, 0x0, 0x0, 0x3, 0xf9, 0x0, 0xee, 0x0,
    0x0, 0x2, 0xf9, 0x0, 0xdf, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x5, 0xf9, 0x0,
    0x5f, 0xa0, 0x0, 0xc, 0xf9, 0x0, 0xb, 0xfc,
    0x78, 0xdb, 0xfe, 0x80, 0x0, 0x8e, 0xfe, 0x80,
    0x6f, 0xe0,

    /* U+03B2 "β" */
    0x0, 0x4b, 0xff, 0xe8, 0x10, 0x0, 0x5f, 0xe9,
    0x8c, 0xfc, 0x0, 0xe, 0xe1, 0x0, 0xb, 0xf4,
    0x3, 0xf9, 0x0, 0x0, 0x5f, 0x70, 0x4f, 0x70,
    0x0, 0x5, 0xf7, 0x4, 0xf7, 0x0, 0x0, 0x9f,
    0x30, 0x4f, 0x70, 0x11, 0x6f, 0x70, 0x4, 0xf7,
    0x3f, 0xff, 0x70, 0x0, 0x4f, 0x70, 0x44, 0x7e,
    0xd2, 0x4, 0xf7, 0x0, 0x0, 0x1e, 0xc0, 0x4f,
    0x70, 0x0, 0x0, 0xaf, 0x14, 0xf7, 0x0, 0x0,
    0xa, 0xf2, 0x4f, 0x70, 0x0, 0x2, 0xfe, 0x4,
    0xff, 0xc8, 0x79, 0xff, 0x50, 0x4f, 0xbb, 0xff,
    0xeb, 0x30, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0,
    0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,

    /* U+03B3 "γ" */
    0xdf, 0x0, 0x0, 0x0, 0xfb, 0x7f, 0x50, 0x0,
    0x1, 0xfa, 0x1f, 0xa0, 0x0, 0x2, 0xf9, 0xc,
    0xf0, 0x0, 0x4, 0xf6, 0x6, 0xf5, 0x0, 0x7,
    0xf3, 0x1, 0xfa, 0x0, 0xc, 0xe0, 0x0, 0xbf,
    0x0, 0x2f, 0x80, 0x0, 0x5f, 0x50, 0xbf, 0x10,
    0x0, 0xf, 0xa5, 0xf7, 0x0, 0x0, 0xa, 0xff,
    0xb0, 0x0, 0x0, 0x4, 0xfd, 0x10, 0x0, 0x0,
    0x2, 0xfa, 0x0, 0x0, 0x0, 0x2, 0xfa, 0x0,
    0x0, 0x0, 0x2, 0xfa, 0x0, 0x0, 0x0, 0x2,
    0xfa, 0x0, 0x0,

    /* U+03B4 "δ" */
    0x0, 0x1, 0xae, 0xfe, 0xb3, 0x0, 0x0, 0xef,
    0x97, 0x9e, 0xf1, 0x0, 0x5f, 0x70, 0x0, 0x4,
    0x0, 0x4, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xfe, 0x60,
    0x0, 0x0, 0x3d, 0xf8, 0xaf, 0xb0, 0x0, 0x3f,
    0xc1, 0x0, 0x4f, 0xb0, 0xb, 0xf2, 0x0, 0x0,
    0x7f, 0x50, 0xfc, 0x0, 0x0, 0x2, 0xf9, 0x1f,
    0xb0, 0x0, 0x0, 0x1f, 0xa0, 0xfe, 0x0, 0x0,
    0x4, 0xf9, 0xa, 0xf7, 0x0, 0x0, 0xcf, 0x30,
    0x1d, 0xfb, 0x78, 0xdf, 0x80, 0x0, 0x18, 0xdf,
    0xfc, 0x50, 0x0,

    /* U+03B5 "ε" */
    0x0, 0x5c, 0xff, 0xeb, 0x40, 0x5f, 0xe8, 0x7a,
    0xe7, 0xa, 0xf2, 0x0, 0x0, 0x10, 0xaf, 0x10,
    0x0, 0x0, 0x4, 0xfb, 0x31, 0x10, 0x0, 0x5,
    0xff, 0xfc, 0x0, 0x7, 0xfb, 0x54, 0x30, 0x0,
    0xfd, 0x0, 0x0, 0x0, 0xf, 0xd0, 0x0, 0x0,
    0x0, 0xaf, 0xd9, 0x89, 0xb8, 0x0, 0x7d, 0xff,
    0xec, 0x40,

    /* U+03B6 "ζ" */
    0x4f, 0xff, 0xff, 0xff, 0x21, 0x55, 0x55, 0x6f,
    0xc0, 0x0, 0x0, 0xc, 0xe2, 0x0, 0x0, 0x8,
    0xf5, 0x0, 0x0, 0x5, 0xf8, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0x7f, 0x60, 0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0xcf, 0x40,
    0x0, 0x0, 0x4, 0xff, 0x93, 0x0, 0x0, 0x4,
    0xdf, 0xff, 0xa2, 0x0, 0x0, 0x37, 0xcf, 0xe0,
    0x0, 0x0, 0x0, 0xcf, 0x10, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x25, 0x10,

    /* U+03B7 "η" */
    0x4f, 0x36, 0xdf, 0xfb, 0x20, 0x4f, 0xdd, 0x65,
    0x7f, 0xe0, 0x4f, 0xf1, 0x0, 0x7, 0xf5, 0x4f,
    0xa0, 0x0, 0x3, 0xf8, 0x4f, 0x70, 0x0, 0x3,
    0xf8, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4f, 0x70,
    0x0, 0x3, 0xf8, 0x4f, 0x70, 0x0, 0x3, 0xf8,
    0x4f, 0x70, 0x0, 0x3, 0xf8, 0x4f, 0x70, 0x0,
    0x3, 0xf8, 0x4f, 0x70, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x3,
    0xf8, 0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x3, 0xf8,

    /* U+03B8 "θ" */
    0x0, 0x5c, 0xff, 0xb3, 0x0, 0x7, 0xfd, 0x88,
    0xef, 0x40, 0x1f, 0xc0, 0x0, 0xd, 0xd0, 0x6f,
    0x40, 0x0, 0x6, 0xf4, 0xaf, 0x0, 0x0, 0x2,
    0xf8, 0xce, 0x11, 0x11, 0x11, 0xfa, 0xef, 0xff,
    0xff, 0xff, 0xfc, 0xee, 0x44, 0x44, 0x44, 0xfc,
    0xee, 0x0, 0x0, 0x0, 0xfc, 0xcf, 0x0, 0x0,
    0x2, 0xfa, 0xaf, 0x20, 0x0, 0x4, 0xf8, 0x6f,
    0x60, 0x0, 0x9, 0xf4, 0xe, 0xd1, 0x0, 0x2f,
    0xe0, 0x5, 0xfd, 0x88, 0xef, 0x40, 0x0, 0x4c,
    0xff, 0xc4, 0x0,

    /* U+03B9 "ι" */
    0x5f, 0x60, 0x0, 0x5f, 0x60, 0x0, 0x5f, 0x60,
    0x0, 0x5f, 0x60, 0x0, 0x5f, 0x60, 0x0, 0x5f,
    0x60, 0x0, 0x5f, 0x60, 0x0, 0x5f, 0x60, 0x0,
    0x4f, 0x70, 0x0, 0x1f, 0xf8, 0x82, 0x4, 0xdf,
    0xe2,

    /* U+03BA "κ" */
    0x4f, 0x90, 0x0, 0x5f, 0xc0, 0x4f, 0x90, 0x3,
    0xfd, 0x10, 0x4f, 0x90, 0x1e, 0xf2, 0x0, 0x4f,
    0x80, 0xcf, 0x40, 0x0, 0x4f, 0x8a, 0xf7, 0x0,
    0x0, 0x4f, 0xdf, 0xf9, 0x0, 0x0, 0x4f, 0xf5,
    0xcf, 0x40, 0x0, 0x4f, 0x90, 0x2f, 0xe1, 0x0,
    0x4f, 0x90, 0x5, 0xfb, 0x0, 0x4f, 0x90, 0x0,
    0xaf, 0x60, 0x4f, 0x90, 0x0, 0x1e, 0xf2,

    /* U+03BB "λ" */
    0xff, 0xd7, 0x0, 0x0, 0x0, 0x8, 0x7c, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf5, 0x0,
    0x0, 0x0, 0xa, 0xce, 0xb0, 0x0, 0x0, 0x1,
    0xf8, 0x9f, 0x10, 0x0, 0x0, 0x6f, 0x34, 0xf7,
    0x0, 0x0, 0xc, 0xe0, 0xe, 0xd0, 0x0, 0x2,
    0xf8, 0x0, 0x8f, 0x40, 0x0, 0x8f, 0x30, 0x2,
    0xfa, 0x0, 0xe, 0xe0, 0x0, 0xd, 0xf1, 0x4,
    0xf9, 0x0, 0x0, 0x7f, 0xa2, 0xaf, 0x30, 0x0,
    0x0, 0xdf, 0x50,

    /* U+03BC "μ" */
    0x4f, 0x70, 0x0, 0x1, 0xfa, 0x0, 0x4f, 0x70,
    0x0, 0x1, 0xfa, 0x0, 0x4f, 0x70, 0x0, 0x1,
    0xfa, 0x0, 0x4f, 0x70, 0x0, 0x1, 0xfa, 0x0,
    0x4f, 0x70, 0x0, 0x1, 0xfa, 0x0, 0x4f, 0x70,
    0x0, 0x1, 0xfa, 0x0, 0x4f, 0x70, 0x0, 0x2,
    0xfa, 0x0, 0x4f, 0x80, 0x0, 0x5, 0xfa, 0x0,
    0x4f, 0xd0, 0x0, 0xc, 0xfa, 0x0, 0x4f, 0xfd,
    0x88, 0xdc, 0xef, 0x80, 0x4f, 0x9c, 0xfe, 0x90,
    0x5e, 0xe0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x0,

    /* U+03BD "ν" */
    0xdf, 0x0, 0x0, 0x0, 0xfb, 0x7f, 0x40, 0x0,
    0x1, 0xfa, 0x2f, 0xa0, 0x0, 0x2, 0xf9, 0xc,
    0xf0, 0x0, 0x4, 0xf7, 0x7, 0xf4, 0x0, 0x7,
    0xf3, 0x1, 0xf9, 0x0, 0xb, 0xf0, 0x0, 0xce,
    0x0, 0x2f, 0x90, 0x0, 0x6f, 0x40, 0x9f, 0x20,
    0x0, 0x1f, 0xa4, 0xf9, 0x0, 0x0, 0xb, 0xee,
    0xd1, 0x0, 0x0, 0x6, 0xff, 0x30, 0x0,

    /* U+03BE "ξ" */
    0x4f, 0xff, 0xff, 0xff, 0x21, 0x59, 0xec, 0x86,
    0x50, 0x7, 0xf5, 0x0, 0x0, 0x1, 0xfa, 0x0,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x0, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0x9, 0xf9, 0x31, 0x11, 0x0,
    0x6, 0xff, 0xff, 0xe0, 0x8, 0xfb, 0x64, 0x43,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0x0, 0xe, 0xe0, 0x0, 0x0, 0x0, 0xcf, 0x20,
    0x0, 0x0, 0x5, 0xfe, 0x61, 0x0, 0x0, 0x6,
    0xef, 0xfc, 0x71, 0x0, 0x0, 0x59, 0xdf, 0xd0,
    0x0, 0x0, 0x0, 0xcf, 0x10, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x25, 0x10,

    /* U+03BF "ο" */
    0x0, 0x6c, 0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8,
    0x8c, 0xfa, 0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5,
    0xa, 0xf3, 0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0,
    0x0, 0x0, 0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc,
    0xf0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa,
    0xf5, 0x0, 0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0,
    0x5c, 0xff, 0xc6, 0x0, 0x0,

    /* U+03C0 "π" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa4, 0x6b,
    0xf8, 0x66, 0x68, 0xfb, 0x63, 0x0, 0x8f, 0x30,
    0x0, 0x3f, 0x80, 0x0, 0x8, 0xf3, 0x0, 0x3,
    0xf8, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x3f, 0x80,
    0x0, 0x8, 0xf3, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0x3f, 0x80, 0x0, 0x8, 0xf3,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x3f, 0x80, 0x0, 0x8, 0xf3, 0x0, 0x1, 0xfe,
    0x72, 0x0, 0x8f, 0x30, 0x0, 0x7, 0xef, 0x40,

    /* U+03C1 "ρ" */
    0x0, 0x4c, 0xff, 0xc6, 0x0, 0x6, 0xfd, 0x89,
    0xdf, 0x90, 0x1f, 0xd0, 0x0, 0xb, 0xf4, 0x5f,
    0x60, 0x0, 0x3, 0xfa, 0x8f, 0x30, 0x0, 0x0,
    0xfd, 0x9f, 0x30, 0x0, 0x0, 0xee, 0x9f, 0x30,
    0x0, 0x0, 0xfd, 0x9f, 0x30, 0x0, 0x3, 0xfa,
    0x9f, 0x50, 0x0, 0xb, 0xf4, 0x9f, 0xfb, 0x88,
    0xdf, 0x90, 0x9f, 0x6b, 0xff, 0xc6, 0x0, 0x9f,
    0x20, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x0, 0x0,

    /* U+03C2 "ς" */
    0x0, 0x6c, 0xff, 0xd8, 0x0, 0x9f, 0xe9, 0x9c,
    0x90, 0x4f, 0xb0, 0x0, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x0, 0xdf, 0x0, 0x0, 0x0, 0xe, 0xe0,
    0x0, 0x0, 0x0, 0xdf, 0x0, 0x0, 0x0, 0xb,
    0xf3, 0x0, 0x0, 0x0, 0x5f, 0xc1, 0x0, 0x0,
    0x0, 0xaf, 0xe8, 0x30, 0x0, 0x0, 0x6e, 0xff,
    0xe5, 0x0, 0x0, 0x2, 0x7f, 0xf0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x0,
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+03C3 "σ" */
    0x0, 0x4a, 0xef, 0xff, 0xff, 0xa0, 0x8f, 0xd8,
    0x68, 0xfa, 0x63, 0x4f, 0xb0, 0x0, 0xb, 0xf1,
    0xa, 0xf3, 0x0, 0x0, 0x4f, 0x70, 0xdf, 0x0,
    0x0, 0x0, 0xfb, 0xe, 0xe0, 0x0, 0x0, 0xf,
    0xc0, 0xdf, 0x0, 0x0, 0x0, 0xfb, 0xa, 0xf2,
    0x0, 0x0, 0x4f, 0x80, 0x5f, 0xa0, 0x0, 0xc,
    0xf2, 0x0, 0xaf, 0xc8, 0x8d, 0xf7, 0x0, 0x0,
    0x6d, 0xff, 0xc5, 0x0, 0x0,

    /* U+03C4 "τ" */
    0xbf, 0xff, 0xff, 0xff, 0xf2, 0x46, 0x6e, 0xf6,
    0x66, 0x60, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0,
    0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x6, 0xfd,
    0x77, 0x50, 0x0, 0x0, 0x7e, 0xfe, 0x70,

    /* U+03C5 "υ" */
    0x6f, 0x50, 0x0, 0xb, 0xf1, 0x6f, 0x50, 0x0,
    0x7, 0xf4, 0x6f, 0x50, 0x0, 0x5, 0xf7, 0x6f,
    0x50, 0x0, 0x3, 0xf8, 0x6f, 0x50, 0x0, 0x3,
    0xf9, 0x6f, 0x50, 0x0, 0x3, 0xf9, 0x6f, 0x50,
    0x0, 0x5, 0xf7, 0x5f, 0x70, 0x0, 0x9, 0xf4,
    0x2f, 0xb0, 0x0, 0x2f, 0xe0, 0xc, 0xfb, 0x78,
    0xef, 0x40, 0x1, 0xae, 0xfe, 0xb3, 0x0,

    /* U+03C6 "φ" */
    0x0, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x0, 0x5, 0x9d, 0xfa, 0x61, 0x0,
    0x0, 0x2d, 0xfe, 0xef, 0xdf, 0xf6, 0x0, 0x1e,
    0xf5, 0x9, 0xf2, 0x2b, 0xf6, 0x7, 0xf6, 0x0,
    0x9f, 0x20, 0xe, 0xe0, 0xcf, 0x10, 0x9, 0xf2,
    0x0, 0x9f, 0x4e, 0xf0, 0x0, 0x9f, 0x20, 0x6,
    0xf6, 0xdf, 0x0, 0x9, 0xf2, 0x0, 0x7f, 0x6b,
    0xf2, 0x0, 0x9f, 0x20, 0xa, 0xf3, 0x4f, 0x90,
    0x9, 0xf2, 0x2, 0xfd, 0x0, 0x9f, 0xa3, 0xaf,
    0x36, 0xef, 0x30, 0x0, 0x7e, 0xff, 0xff, 0xfc,
    0x20, 0x0, 0x0, 0x3, 0xbf, 0x61, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x20,
    0x0, 0x0,

    /* U+03C7 "χ" */
    0x6f, 0xd2, 0x0, 0x0, 0x6, 0xf6, 0x38, 0xfb,
    0x0, 0x0, 0xe, 0xd0, 0x0, 0x9f, 0x30, 0x0,
    0x8f, 0x40, 0x0, 0x2f, 0xa0, 0x1, 0xfb, 0x0,
    0x0, 0xa, 0xf2, 0x9, 0xf2, 0x0, 0x0, 0x3,
    0xfa, 0x2f, 0x80, 0x0, 0x0, 0x0, 0xbf, 0xce,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xf8, 0x0, 0x0, 0x0, 0x3, 0xf8, 0xee,
    0x0, 0x0, 0x0, 0xd, 0xe0, 0x6f, 0x70, 0x0,
    0x0, 0x7f, 0x50, 0xe, 0xe0, 0x0, 0x2, 0xfb,
    0x0, 0x8, 0xf6, 0x0, 0xb, 0xf2, 0x0, 0x1,
    0xef, 0x85, 0x5f, 0x80, 0x0, 0x0, 0x4d, 0xfa,

    /* U+03C8 "ψ" */
    0x0, 0x0, 0x6, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x50,
    0x0, 0x0, 0x6f, 0x50, 0x6, 0xf5, 0x0, 0xaf,
    0x16, 0xf5, 0x0, 0x6f, 0x50, 0x7, 0xf4, 0x6f,
    0x50, 0x6, 0xf5, 0x0, 0x4f, 0x66, 0xf5, 0x0,
    0x6f, 0x50, 0x3, 0xf8, 0x6f, 0x50, 0x6, 0xf5,
    0x0, 0x2f, 0x96, 0xf5, 0x0, 0x6f, 0x50, 0x2,
    0xf9, 0x6f, 0x50, 0x6, 0xf5, 0x0, 0x4f, 0x83,
    0xf9, 0x0, 0x6f, 0x50, 0x8, 0xf4, 0xe, 0xf2,
    0x6, 0xf5, 0x4, 0xfe, 0x0, 0x5f, 0xfa, 0xbf,
    0xab, 0xff, 0x30, 0x0, 0x3a, 0xef, 0xff, 0xe9,
    0x20, 0x0, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x50,
    0x0, 0x0,

    /* U+03C9 "ω" */
    0x4, 0xf8, 0x0, 0x0, 0x0, 0x8f, 0x40, 0xd,
    0xe0, 0x0, 0x0, 0x0, 0xe, 0xd0, 0x4f, 0x80,
    0x0, 0x0, 0x0, 0x8, 0xf4, 0x8f, 0x40, 0x0,
    0x44, 0x0, 0x4, 0xf8, 0xaf, 0x10, 0x0, 0xdd,
    0x0, 0x1, 0xfa, 0xbf, 0x10, 0x0, 0xdd, 0x0,
    0x1, 0xfb, 0xaf, 0x10, 0x0, 0xdd, 0x0, 0x1,
    0xfa, 0x8f, 0x40, 0x0, 0xee, 0x0, 0x4, 0xf8,
    0x3f, 0xa0, 0x2, 0xff, 0x20, 0xa, 0xf3, 0xa,
    0xfb, 0x8e, 0xaa, 0xe8, 0xaf, 0xa0, 0x0, 0x9e,
    0xfb, 0x11, 0xbf, 0xe9, 0x0,

    /* U+03CC "ό" */
    0x0, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0x0, 0x2, 0x60, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0,

    /* U+03CD "ύ" */
    0x0, 0x0, 0xf, 0xf2, 0x0, 0x0, 0x0, 0x4f,
    0x80, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0,
    0x0, 0x53, 0x0, 0x0, 0x6f, 0x50, 0x0, 0xb,
    0xf1, 0x6f, 0x50, 0x0, 0x7, 0xf4, 0x6f, 0x50,
    0x0, 0x5, 0xf7, 0x6f, 0x50, 0x0, 0x3, 0xf8,
    0x6f, 0x50, 0x0, 0x3, 0xf9, 0x6f, 0x50, 0x0,
    0x3, 0xf9, 0x6f, 0x50, 0x0, 0x5, 0xf7, 0x5f,
    0x70, 0x0, 0x9, 0xf4, 0x2f, 0xb0, 0x0, 0x2f,
    0xe0, 0xc, 0xfb, 0x78, 0xef, 0x40, 0x1, 0xae,
    0xfe, 0xb3, 0x0,

    /* U+03CE "ώ" */
    0x0, 0x0, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x26, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x0, 0x0,
    0x0, 0x8f, 0x40, 0xd, 0xe0, 0x0, 0x0, 0x0,
    0xe, 0xd0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0x8,
    0xf4, 0x8f, 0x40, 0x0, 0x44, 0x0, 0x4, 0xf8,
    0xaf, 0x10, 0x0, 0xdd, 0x0, 0x1, 0xfa, 0xbf,
    0x10, 0x0, 0xdd, 0x0, 0x1, 0xfb, 0xaf, 0x10,
    0x0, 0xdd, 0x0, 0x1, 0xfa, 0x8f, 0x40, 0x0,
    0xee, 0x0, 0x4, 0xf8, 0x3f, 0xa0, 0x2, 0xff,
    0x20, 0xa, 0xf3, 0xa, 0xfb, 0x8e, 0xaa, 0xe8,
    0xaf, 0xa0, 0x0, 0x9e, 0xfb, 0x11, 0xbf, 0xe9,
    0x0,

    /* U+0406 "І" */
    0x1f, 0xb1, 0xfb, 0x1f, 0xb1, 0xfb, 0x1f, 0xb1,
    0xfb, 0x1f, 0xb1, 0xfb, 0x1f, 0xb1, 0xfb, 0x1f,
    0xb1, 0xfb, 0x1f, 0xb1, 0xfb,

    /* U+0408 "Ј" */
    0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2,
    0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0,
    0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa,
    0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2,
    0xfa, 0x0, 0x2, 0xfa, 0x0, 0x2, 0xfa, 0x0,
    0x2, 0xfa, 0x0, 0x2, 0xf9, 0x0, 0x7, 0xf7,
    0x6a, 0xbf, 0xe1, 0x7f, 0xfb, 0x20,

    /* U+0410 "А" */
    0x0, 0x0, 0xa, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x9f, 0x30, 0x0, 0x0, 0x0, 0xd, 0xd1, 0xf9,
    0x0, 0x0, 0x0, 0x3, 0xf7, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x10, 0x5f, 0x60, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0xec, 0x0, 0x0, 0x6, 0xf5,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x3f, 0xc9, 0x99, 0x99, 0xef,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x7, 0xf6, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0xaf, 0x2c, 0xf0, 0x0, 0x0,
    0x0, 0x4, 0xf9,

    /* U+0411 "Б" */
    0x1f, 0xff, 0xff, 0xff, 0xf7, 0x1, 0xfe, 0x99,
    0x99, 0x99, 0x40, 0x1f, 0xb0, 0x0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0x1, 0xfe, 0x88, 0x86, 0x30,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xc1, 0x0, 0xfc,
    0x0, 0x3, 0xaf, 0xb0, 0xf, 0xc0, 0x0, 0x0,
    0xdf, 0x20, 0xfc, 0x0, 0x0, 0x9, 0xf4, 0xf,
    0xc0, 0x0, 0x0, 0xbf, 0x30, 0xfc, 0x0, 0x0,
    0x3f, 0xe0, 0xf, 0xe8, 0x89, 0xcf, 0xf4, 0x0,
    0xff, 0xff, 0xfd, 0x92, 0x0,

    /* U+0412 "В" */
    0x1f, 0xff, 0xff, 0xec, 0x81, 0x1, 0xfe, 0x88,
    0x9a, 0xef, 0xe0, 0x1f, 0xb0, 0x0, 0x0, 0xbf,
    0x51, 0xfb, 0x0, 0x0, 0x7, 0xf6, 0x1f, 0xb0,
    0x0, 0x0, 0xbf, 0x21, 0xfd, 0x88, 0x89, 0xde,
    0x50, 0x1f, 0xff, 0xff, 0xff, 0x92, 0x1, 0xfb,
    0x0, 0x1, 0x5d, 0xf3, 0x1f, 0xb0, 0x0, 0x0,
    0x3f, 0xb1, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x1f,
    0xb0, 0x0, 0x0, 0x1f, 0xd1, 0xfb, 0x0, 0x0,
    0x9, 0xf9, 0x1f, 0xe8, 0x88, 0x9d, 0xfd, 0x11,
    0xff, 0xff, 0xff, 0xd8, 0x10,

    /* U+0413 "Г" */
    0x1f, 0xff, 0xff, 0xff, 0xb1, 0xfe, 0x99, 0x99,
    0x96, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,

    /* U+0417 "З" */
    0x6, 0xbe, 0xff, 0xea, 0x30, 0x0, 0xce, 0xb9,
    0x9c, 0xff, 0x50, 0x1, 0x0, 0x0, 0x5, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0,
    0x0, 0x5, 0xf8, 0x0, 0x3, 0x88, 0x8c, 0xf9,
    0x0, 0x0, 0x6f, 0xff, 0xfb, 0x40, 0x0, 0x0,
    0x0, 0x3, 0xaf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0x0, 0x8, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x51, 0x10, 0x0, 0x0,
    0x4f, 0xf1, 0x3f, 0xda, 0x9a, 0xdf, 0xf5, 0x1,
    0x9c, 0xef, 0xfd, 0x92, 0x0,

    /* U+0418 "И" */
    0x1f, 0xb0, 0x0, 0x0, 0x2, 0xff, 0x31, 0xfb,
    0x0, 0x0, 0x0, 0xbf, 0xf3, 0x1f, 0xb0, 0x0,
    0x0, 0x5f, 0xaf, 0x31, 0xfb, 0x0, 0x0, 0x1e,
    0x88, 0xf3, 0x1f, 0xb0, 0x0, 0xa, 0xd0, 0x9f,
    0x31, 0xfb, 0x0, 0x4, 0xf4, 0x9, 0xf3, 0x1f,
    0xb0, 0x0, 0xd9, 0x0, 0xaf, 0x31, 0xfb, 0x0,
    0x8e, 0x10, 0xa, 0xf3, 0x1f, 0xb0, 0x2f, 0x50,
    0x0, 0xaf, 0x31, 0xfb, 0xc, 0xb0, 0x0, 0xa,
    0xf3, 0x1f, 0xb6, 0xf1, 0x0, 0x0, 0xaf, 0x31,
    0xfc, 0xf7, 0x0, 0x0, 0xa, 0xf3, 0x1f, 0xfc,
    0x0, 0x0, 0x0, 0xaf, 0x31, 0xff, 0x30, 0x0,
    0x0, 0xa, 0xf3,

    /* U+041A "К" */
    0x1f, 0xb0, 0x0, 0x0, 0x6f, 0x80, 0x1f, 0xb0,
    0x0, 0x3, 0xfc, 0x0, 0x1f, 0xb0, 0x0, 0xd,
    0xe1, 0x0, 0x1f, 0xb0, 0x0, 0xaf, 0x40, 0x0,
    0x1f, 0xb0, 0x6, 0xf8, 0x0, 0x0, 0x1f, 0xe9,
    0x9f, 0xc0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x1f, 0xb0, 0xd, 0xf3, 0x0, 0x0,
    0x1f, 0xb0, 0x4, 0xfd, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0xaf, 0x70, 0x0, 0x1f, 0xb0, 0x0, 0x1e,
    0xf2, 0x0, 0x1f, 0xb0, 0x0, 0x5, 0xfb, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0xbf, 0x50, 0x1f, 0xb0,
    0x0, 0x0, 0x2f, 0xe1,

    /* U+041C "М" */
    0x1f, 0xfc, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xf3,
    0x1f, 0xef, 0x20, 0x0, 0x0, 0x1, 0xff, 0xf3,
    0x1f, 0x9f, 0x80, 0x0, 0x0, 0x6, 0xfa, 0xf3,
    0x1f, 0x9a, 0xe0, 0x0, 0x0, 0xc, 0xc8, 0xf3,
    0x1f, 0x94, 0xf5, 0x0, 0x0, 0x3f, 0x69, 0xf3,
    0x1f, 0x90, 0xeb, 0x0, 0x0, 0x9f, 0x19, 0xf3,
    0x1f, 0x90, 0x8f, 0x10, 0x0, 0xfa, 0x9, 0xf3,
    0x1f, 0x90, 0x2f, 0x70, 0x5, 0xf3, 0x9, 0xf3,
    0x1f, 0x90, 0xd, 0xd0, 0xc, 0xd0, 0x9, 0xf3,
    0x1f, 0x90, 0x7, 0xf3, 0x2f, 0x70, 0x9, 0xf3,
    0x1f, 0x90, 0x1, 0xfa, 0x8f, 0x10, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0xbf, 0xeb, 0x0, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0x5f, 0xf4, 0x0, 0x9, 0xf3,
    0x1f, 0x90, 0x0, 0xe, 0xe0, 0x0, 0x9, 0xf3,

    /* U+041D "Н" */
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xee, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xee, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xee, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xee,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xee, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xee, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x1f, 0xe9, 0x99, 0x99, 0x99, 0xfe,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xee, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xee, 0x1f, 0xb0, 0x0, 0x0,
    0x0, 0xee, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0xee,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0xee, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0xee,

    /* U+041E "О" */
    0x0, 0x4, 0xbe, 0xff, 0xc6, 0x0, 0x0, 0x0,
    0xaf, 0xfb, 0x9a, 0xef, 0xd1, 0x0, 0x9, 0xfb,
    0x10, 0x0, 0x8, 0xfc, 0x0, 0x2f, 0xd0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x3f, 0xb0, 0xbf, 0x30, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0xcf, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf0, 0xcf, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf0,
    0xaf, 0x30, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x7f,
    0x70, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x2f, 0xe0,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0x9, 0xfb, 0x10,
    0x0, 0x8, 0xfc, 0x0, 0x0, 0xaf, 0xfb, 0x9a,
    0xef, 0xd1, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xc6,
    0x0, 0x0,

    /* U+041F "П" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x1f, 0xe9,
    0x99, 0x99, 0x99, 0xfb, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb, 0x1f, 0xb0, 0x0, 0x0,
    0x1, 0xfb, 0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb,
    0x1f, 0xb0, 0x0, 0x0, 0x1, 0xfb, 0x1f, 0xb0,
    0x0, 0x0, 0x1, 0xfb,

    /* U+0420 "Р" */
    0x1f, 0xff, 0xff, 0xd9, 0x20, 0x1, 0xfe, 0x88,
    0x9d, 0xff, 0x30, 0x1f, 0xb0, 0x0, 0x6, 0xfc,
    0x1, 0xfb, 0x0, 0x0, 0xe, 0xf0, 0x1f, 0xb0,
    0x0, 0x0, 0xcf, 0x1, 0xfb, 0x0, 0x0, 0x1f,
    0xd0, 0x1f, 0xb0, 0x1, 0x5d, 0xf6, 0x1, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x1f, 0xe9, 0x87, 0x51,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x0, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x3, 0xad, 0xff, 0xeb, 0x50, 0x9, 0xff,
    0xc9, 0x9b, 0xfa, 0x8, 0xfd, 0x20, 0x0, 0x0,
    0x11, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x7f, 0x80,
    0x0, 0x0, 0x0, 0xa, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x10, 0x0, 0x0, 0x0, 0xc, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xd2, 0x0,
    0x0, 0x1, 0x0, 0xbf, 0xfc, 0xa9, 0xbe, 0xa0,
    0x0, 0x5b, 0xef, 0xfe, 0xb4,

    /* U+0422 "Т" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x99, 0x9b,
    0xfc, 0x99, 0x98, 0x0, 0x0, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x70, 0x0, 0x0, 0x0, 0x5, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x70, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0,
    0x0, 0x5, 0xf7, 0x0, 0x0,

    /* U+0423 "У" */
    0xaf, 0x50, 0x0, 0x0, 0x0, 0xdf, 0x12, 0xfd,
    0x0, 0x0, 0x0, 0x4f, 0x90, 0x9, 0xf6, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x1f, 0xe0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x8f, 0x70, 0x0, 0xaf, 0x30,
    0x0, 0x0, 0xee, 0x0, 0x1f, 0xc0, 0x0, 0x0,
    0x7, 0xf7, 0x8, 0xf5, 0x0, 0x0, 0x0, 0xe,
    0xe1, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x0, 0x5, 0xcd,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x4f, 0xfc, 0x30,
    0x0, 0x0, 0x0,

    /* U+0427 "Ч" */
    0x8f, 0x40, 0x0, 0x0, 0x4f, 0x88, 0xf4, 0x0,
    0x0, 0x4, 0xf8, 0x8f, 0x40, 0x0, 0x0, 0x4f,
    0x88, 0xf4, 0x0, 0x0, 0x4, 0xf8, 0x7f, 0x40,
    0x0, 0x0, 0x4f, 0x86, 0xf7, 0x0, 0x0, 0x4,
    0xf8, 0x2f, 0xf5, 0x10, 0x14, 0xaf, 0x80, 0x6f,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x16, 0x88, 0x63,
    0x4f, 0x80, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0,
    0x4, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x0, 0x0, 0x4, 0xf8,

    /* U+0430 "а" */
    0x1, 0x7c, 0xff, 0xea, 0x20, 0x1, 0xeb, 0x87,
    0x9f, 0xe0, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0, 0x14, 0xf7, 0x0, 0x4b, 0xff, 0xff,
    0xf8, 0x6, 0xfd, 0x74, 0x46, 0xf8, 0xe, 0xe1,
    0x0, 0x4, 0xf8, 0x1f, 0xb0, 0x0, 0x6, 0xf8,
    0xf, 0xe0, 0x0, 0x1d, 0xf8, 0xa, 0xfc, 0x78,
    0xe9, 0xf8, 0x0, 0x9e, 0xfd, 0x60, 0xe8,

    /* U+0431 "б" */
    0x0, 0x0, 0x27, 0x9b, 0xd2, 0x0, 0x3c, 0xff,
    0xfd, 0xc2, 0x3, 0xfe, 0x72, 0x0, 0x0, 0xd,
    0xd1, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x0, 0x9f, 0x29, 0xef, 0xe8, 0x0, 0xce, 0xec,
    0x77, 0xcf, 0xc0, 0xef, 0xb0, 0x0, 0xa, 0xf7,
    0xef, 0x30, 0x0, 0x2, 0xfc, 0xef, 0x0, 0x0,
    0x0, 0xef, 0xdf, 0x0, 0x0, 0x0, 0xef, 0xbf,
    0x0, 0x0, 0x0, 0xfe, 0x7f, 0x50, 0x0, 0x3,
    0xfa, 0x1f, 0xd0, 0x0, 0xc, 0xf4, 0x7, 0xfe,
    0x88, 0xdf, 0x80, 0x0, 0x5c, 0xff, 0xc5, 0x0,

    /* U+0432 "в" */
    0x4f, 0xff, 0xff, 0xd8, 0x0, 0x4f, 0xb7, 0x78,
    0xcf, 0xa0, 0x4f, 0x70, 0x0, 0xe, 0xf0, 0x4f,
    0x70, 0x0, 0xd, 0xf0, 0x4f, 0x81, 0x12, 0x8f,
    0x80, 0x4f, 0xff, 0xff, 0xf9, 0x0, 0x4f, 0x94,
    0x45, 0x8f, 0xc0, 0x4f, 0x70, 0x0, 0x8, 0xf4,
    0x4f, 0x70, 0x0, 0x9, 0xf4, 0x4f, 0xb7, 0x77,
    0xbf, 0xd0, 0x4f, 0xff, 0xff, 0xe9, 0x10,

    /* U+0433 "г" */
    0x4f, 0xff, 0xff, 0xf5, 0x4f, 0xb7, 0x77, 0x72,
    0x4f, 0x70, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0,

    /* U+0434 "д" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0x50, 0x0, 0xf,
    0xc7, 0x77, 0xbf, 0x50, 0x0, 0xf, 0x90, 0x0,
    0x6f, 0x50, 0x0, 0x1f, 0x80, 0x0, 0x6f, 0x50,
    0x0, 0x2f, 0x70, 0x0, 0x6f, 0x50, 0x0, 0x3f,
    0x50, 0x0, 0x6f, 0x50, 0x0, 0x6f, 0x30, 0x0,
    0x6f, 0x50, 0x0, 0xaf, 0x0, 0x0, 0x6f, 0x50,
    0x1, 0xfb, 0x0, 0x0, 0x6f, 0x50, 0x6b, 0xfa,
    0x77, 0x77, 0xbf, 0xa7, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xce, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xce, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xab, 0x0,
    0x0, 0x0, 0x0, 0x9c,

    /* U+0435 "е" */
    0x0, 0x7, 0xdf, 0xfb, 0x30, 0x0, 0xb, 0xfa,
    0x78, 0xef, 0x30, 0x6, 0xf6, 0x0, 0x2, 0xfc,
    0x0, 0xcf, 0x22, 0x22, 0x2c, 0xf0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x10, 0xfe, 0x55, 0x55, 0x55,
    0x50, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0x0, 0x0, 0x6, 0xfc, 0x0, 0x0,
    0x2, 0x0, 0xa, 0xfe, 0x98, 0xae, 0xa0, 0x0,
    0x6, 0xcf, 0xfe, 0xb4, 0x0,

    /* U+0436 "ж" */
    0x4f, 0x90, 0x0, 0x4f, 0x70, 0x0, 0x6f, 0x70,
    0xa, 0xf3, 0x0, 0x4f, 0x70, 0x1, 0xec, 0x0,
    0x1, 0xed, 0x0, 0x4f, 0x70, 0xa, 0xf3, 0x0,
    0x0, 0x5f, 0x70, 0x4f, 0x70, 0x4f, 0x80, 0x0,
    0x0, 0xb, 0xf3, 0x5f, 0x82, 0xdd, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x8f, 0xa5, 0xee, 0x10, 0x0,
    0x0, 0x7f, 0x70, 0x4f, 0x70, 0x4f, 0xa0, 0x0,
    0x3, 0xfc, 0x0, 0x4f, 0x70, 0xa, 0xf5, 0x0,
    0xd, 0xf2, 0x0, 0x4f, 0x70, 0x1, 0xee, 0x10,
    0x8f, 0x70, 0x0, 0x4f, 0x70, 0x0, 0x5f, 0xa0,

    /* U+0437 "з" */
    0x8, 0xcf, 0xfe, 0xa2, 0x0, 0xeb, 0x87, 0xaf,
    0xf1, 0x0, 0x0, 0x0, 0x7f, 0x60, 0x0, 0x0,
    0x6, 0xf6, 0x0, 0x11, 0x25, 0xed, 0x10, 0xc,
    0xff, 0xfc, 0x20, 0x0, 0x34, 0x57, 0xdf, 0x30,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x2f,
    0xc5, 0xd9, 0x77, 0x9e, 0xf5, 0x2a, 0xdf, 0xfe,
    0xb4, 0x0,

    /* U+0438 "и" */
    0x4f, 0x70, 0x0, 0xb, 0xfb, 0x4f, 0x70, 0x0,
    0x5f, 0xfb, 0x4f, 0x70, 0x0, 0xec, 0xfb, 0x4f,
    0x70, 0x7, 0xf3, 0xfb, 0x4f, 0x70, 0x1f, 0xa0,
    0xfb, 0x4f, 0x70, 0xaf, 0x10, 0xfb, 0x4f, 0x73,
    0xf7, 0x0, 0xfb, 0x4f, 0x6d, 0xe0, 0x0, 0xfb,
    0x4f, 0xcf, 0x50, 0x0, 0xfb, 0x4f, 0xfb, 0x0,
    0x0, 0xfb, 0x4f, 0xf2, 0x0, 0x0, 0xfb,

    /* U+0439 "й" */
    0x0, 0xcc, 0x0, 0x5f, 0x30, 0x0, 0x7f, 0x40,
    0xce, 0x0, 0x0, 0xa, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x12, 0x0, 0x0, 0x4f, 0x70, 0x0, 0xb,
    0xfb, 0x4f, 0x70, 0x0, 0x5f, 0xfb, 0x4f, 0x70,
    0x0, 0xec, 0xfb, 0x4f, 0x70, 0x7, 0xf3, 0xfb,
    0x4f, 0x70, 0x1f, 0xa0, 0xfb, 0x4f, 0x70, 0xaf,
    0x10, 0xfb, 0x4f, 0x73, 0xf7, 0x0, 0xfb, 0x4f,
    0x6d, 0xe0, 0x0, 0xfb, 0x4f, 0xcf, 0x50, 0x0,
    0xfb, 0x4f, 0xfb, 0x0, 0x0, 0xfb, 0x4f, 0xf2,
    0x0, 0x0, 0xfb,

    /* U+043A "к" */
    0x4f, 0x70, 0x0, 0x1e, 0xd0, 0x4f, 0x70, 0x0,
    0x9f, 0x30, 0x4f, 0x70, 0x4, 0xf9, 0x0, 0x4f,
    0x70, 0xd, 0xe0, 0x0, 0x4f, 0x82, 0x9f, 0x40,
    0x0, 0x4f, 0xff, 0xfd, 0x0, 0x0, 0x4f, 0xa5,
    0xbf, 0x50, 0x0, 0x4f, 0x70, 0x1e, 0xf1, 0x0,
    0x4f, 0x70, 0x4, 0xfb, 0x0, 0x4f, 0x70, 0x0,
    0x9f, 0x60, 0x4f, 0x70, 0x0, 0xd, 0xf2,

    /* U+043B "л" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0x0, 0x4, 0xfa,
    0x77, 0x7d, 0xf0, 0x0, 0x5f, 0x30, 0x0, 0xbf,
    0x0, 0x6, 0xf2, 0x0, 0xb, 0xf0, 0x0, 0x7f,
    0x20, 0x0, 0xbf, 0x0, 0x8, 0xf1, 0x0, 0xb,
    0xf0, 0x0, 0x9f, 0x0, 0x0, 0xbf, 0x0, 0xb,
    0xe0, 0x0, 0xb, 0xf0, 0x0, 0xeb, 0x0, 0x0,
    0xbf, 0xa, 0xcf, 0x60, 0x0, 0xb, 0xf0, 0xef,
    0x90, 0x0, 0x0, 0xbf, 0x0,

    /* U+043C "м" */
    0x4f, 0xf4, 0x0, 0x0, 0x0, 0xef, 0xa4, 0xff,
    0xb0, 0x0, 0x0, 0x5f, 0xfa, 0x4f, 0xdf, 0x10,
    0x0, 0xb, 0xee, 0xa4, 0xf7, 0xf8, 0x0, 0x2,
    0xf7, 0xfa, 0x4f, 0x5b, 0xe0, 0x0, 0x8f, 0x1f,
    0xa4, 0xf5, 0x4f, 0x50, 0xe, 0xa0, 0xfa, 0x4f,
    0x50, 0xeb, 0x6, 0xf3, 0xf, 0xa4, 0xf5, 0x8,
    0xf2, 0xcd, 0x0, 0xfa, 0x4f, 0x50, 0x1f, 0xbf,
    0x60, 0xf, 0xa4, 0xf5, 0x0, 0xbf, 0xe0, 0x0,
    0xfa, 0x4f, 0x50, 0x4, 0xf8, 0x0, 0xf, 0xa0,

    /* U+043D "н" */
    0x4f, 0x70, 0x0, 0x3, 0xf9, 0x4f, 0x70, 0x0,
    0x3, 0xf9, 0x4f, 0x70, 0x0, 0x3, 0xf9, 0x4f,
    0x70, 0x0, 0x3, 0xf9, 0x4f, 0xb8, 0x88, 0x89,
    0xf9, 0x4f, 0xff, 0xff, 0xff, 0xf9, 0x4f, 0x70,
    0x0, 0x3, 0xf9, 0x4f, 0x70, 0x0, 0x3, 0xf9,
    0x4f, 0x70, 0x0, 0x3, 0xf9, 0x4f, 0x70, 0x0,
    0x3, 0xf9, 0x4f, 0x70, 0x0, 0x3, 0xf9,

    /* U+043E "о" */
    0x0, 0x7, 0xdf, 0xfc, 0x50, 0x0, 0xb, 0xfc,
    0x88, 0xdf, 0x80, 0x6, 0xf9, 0x0, 0x0, 0xcf,
    0x40, 0xcf, 0x10, 0x0, 0x3, 0xfa, 0xf, 0xe0,
    0x0, 0x0, 0xf, 0xd0, 0xfd, 0x0, 0x0, 0x0,
    0xfe, 0xf, 0xe0, 0x0, 0x0, 0xf, 0xd0, 0xcf,
    0x10, 0x0, 0x3, 0xfa, 0x5, 0xfa, 0x0, 0x0,
    0xcf, 0x40, 0xa, 0xfc, 0x88, 0xdf, 0x90, 0x0,
    0x6, 0xcf, 0xfc, 0x50, 0x0,

    /* U+043F "п" */
    0x4f, 0xff, 0xff, 0xff, 0xf6, 0x4f, 0xb7, 0x77,
    0x7a, 0xf6, 0x4f, 0x70, 0x0, 0x5, 0xf6, 0x4f,
    0x70, 0x0, 0x5, 0xf6, 0x4f, 0x70, 0x0, 0x5,
    0xf6, 0x4f, 0x70, 0x0, 0x5, 0xf6, 0x4f, 0x70,
    0x0, 0x5, 0xf6, 0x4f, 0x70, 0x0, 0x5, 0xf6,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x4f, 0x70, 0x0,
    0x5, 0xf6, 0x4f, 0x70, 0x0, 0x5, 0xf6,

    /* U+0440 "р" */
    0x4f, 0x36, 0xdf, 0xfa, 0x20, 0x4, 0xfd, 0xd6,
    0x47, 0xfe, 0x20, 0x4f, 0xe1, 0x0, 0x4, 0xfa,
    0x4, 0xf9, 0x0, 0x0, 0xe, 0xf0, 0x4f, 0x70,
    0x0, 0x0, 0xbf, 0x24, 0xf7, 0x0, 0x0, 0xa,
    0xf3, 0x4f, 0x80, 0x0, 0x0, 0xbf, 0x24, 0xfb,
    0x0, 0x0, 0xf, 0xf0, 0x4f, 0xf3, 0x0, 0x7,
    0xfa, 0x4, 0xfc, 0xf9, 0x7a, 0xfe, 0x10, 0x4f,
    0x65, 0xdf, 0xfa, 0x20, 0x4, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70, 0x0,
    0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x6, 0xcf, 0xfd, 0x80, 0x0, 0xaf, 0xd8,
    0x8a, 0xa0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0x0, 0xf, 0xd0,
    0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0, 0x0,
    0x7, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xd9,
    0x8a, 0xa0, 0x0, 0x7, 0xdf, 0xfd, 0x80,

    /* U+0442 "т" */
    0xbf, 0xff, 0xff, 0xff, 0xf5, 0x77, 0x9f, 0xb7,
    0x77, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x3f,
    0x80, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0x3f, 0x80, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x0, 0x3f, 0x80, 0x0, 0x0, 0x3, 0xf8, 0x0,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x0, 0x3, 0xf8,
    0x0, 0x0,

    /* U+0443 "у" */
    0xcf, 0x10, 0x0, 0x0, 0xef, 0x6, 0xf6, 0x0,
    0x0, 0x3f, 0xa0, 0x1f, 0xc0, 0x0, 0x9, 0xf4,
    0x0, 0xaf, 0x20, 0x0, 0xee, 0x0, 0x4, 0xf8,
    0x0, 0x4f, 0x80, 0x0, 0xd, 0xe0, 0xa, 0xf2,
    0x0, 0x0, 0x7f, 0x40, 0xfc, 0x0, 0x0, 0x1,
    0xf9, 0x4f, 0x60, 0x0, 0x0, 0xb, 0xe9, 0xf1,
    0x0, 0x0, 0x0, 0x5f, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xef, 0x50, 0x0, 0x0, 0x0, 0xd, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x20, 0x0, 0x0, 0x8a, 0xdf, 0x90,
    0x0, 0x0, 0xa, 0xfe, 0x80, 0x0, 0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0x0, 0x0, 0x2, 0x9d, 0xff,
    0xfc, 0x81, 0x0, 0x0, 0x6f, 0xfa, 0xbf, 0x9b,
    0xfe, 0x30, 0x3, 0xfd, 0x10, 0x7f, 0x30, 0x4f,
    0xe1, 0xb, 0xf3, 0x0, 0x7f, 0x30, 0x7, 0xf7,
    0xf, 0xe0, 0x0, 0x7f, 0x30, 0x2, 0xfb, 0xf,
    0xd0, 0x0, 0x7f, 0x30, 0x1, 0xfc, 0xf, 0xe0,
    0x0, 0x7f, 0x30, 0x2, 0xfb, 0xb, 0xf3, 0x0,
    0x7f, 0x30, 0x7, 0xf7, 0x4, 0xfd, 0x10, 0x7f,
    0x30, 0x4f, 0xe1, 0x0, 0x6f, 0xfa, 0xbf, 0x9b,
    0xfe, 0x30, 0x0, 0x3, 0xae, 0xff, 0xfd, 0x81,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0x0,

    /* U+0445 "х" */
    0x4f, 0xb0, 0x0, 0x7, 0xf8, 0x0, 0x9f, 0x50,
    0x2, 0xfc, 0x0, 0x0, 0xee, 0x10, 0xcf, 0x20,
    0x0, 0x4, 0xfb, 0x7f, 0x70, 0x0, 0x0, 0x8,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x2f, 0xf5, 0x0,
    0x0, 0x0, 0xb, 0xfe, 0xe0, 0x0, 0x0, 0x6,
    0xf8, 0x4f, 0xa0, 0x0, 0x2, 0xfd, 0x0, 0xaf,
    0x50, 0x0, 0xcf, 0x30, 0x1, 0xee, 0x10, 0x7f,
    0x70, 0x0, 0x4, 0xfb, 0x0,

    /* U+0446 "ц" */
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x4f, 0x70,
    0x0, 0x5, 0xf6, 0x0, 0x4f, 0x70, 0x0, 0x5,
    0xf6, 0x0, 0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x4f, 0x70,
    0x0, 0x5, 0xf6, 0x0, 0x4f, 0x70, 0x0, 0x5,
    0xf6, 0x0, 0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x4f, 0xb7,
    0x77, 0x7a, 0xfb, 0x70, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xd0,

    /* U+0447 "ч" */
    0xcf, 0x0, 0x0, 0xb, 0xf1, 0xcf, 0x0, 0x0,
    0xb, 0xf1, 0xcf, 0x0, 0x0, 0xb, 0xf1, 0xcf,
    0x0, 0x0, 0xb, 0xf1, 0xbf, 0x20, 0x0, 0xb,
    0xf1, 0x6f, 0xc4, 0x23, 0x7e, 0xf1, 0x9, 0xff,
    0xff, 0xfe, 0xf1, 0x0, 0x14, 0x53, 0xb, 0xf1,
    0x0, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0x0,
    0xb, 0xf1, 0x0, 0x0, 0x0, 0xb, 0xf1,

    /* U+0448 "ш" */
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0x60, 0x0, 0xf, 0xd0, 0x0, 0x8, 0xf3,
    0x5f, 0xb7, 0x77, 0x7f, 0xe7, 0x77, 0x7c, 0xf3,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,

    /* U+0449 "щ" */
    0x4f, 0x70, 0x0, 0xf, 0xc0, 0x0, 0xa, 0xf1,
    0x4, 0xf7, 0x0, 0x0, 0xfc, 0x0, 0x0, 0xaf,
    0x10, 0x4f, 0x70, 0x0, 0xf, 0xc0, 0x0, 0xa,
    0xf1, 0x4, 0xf7, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0xaf, 0x10, 0x4f, 0x70, 0x0, 0xf, 0xc0, 0x0,
    0xa, 0xf1, 0x4, 0xf7, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0xaf, 0x10, 0x4f, 0x70, 0x0, 0xf, 0xc0,
    0x0, 0xa, 0xf1, 0x4, 0xf7, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0xaf, 0x10, 0x4f, 0x70, 0x0, 0xf,
    0xc0, 0x0, 0xa, 0xf1, 0x4, 0xfb, 0x77, 0x77,
    0xfe, 0x77, 0x77, 0xdf, 0x85, 0x4f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc9,

    /* U+044A "ъ" */
    0xbf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x57, 0x7d,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf2, 0x22, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xfc, 0x30, 0x0, 0xb,
    0xf5, 0x55, 0x8f, 0xf2, 0x0, 0xb, 0xf0, 0x0,
    0x7, 0xf7, 0x0, 0xb, 0xf0, 0x0, 0x4, 0xf8,
    0x0, 0xb, 0xf0, 0x0, 0x9, 0xf6, 0x0, 0xb,
    0xf7, 0x77, 0xbf, 0xd0, 0x0, 0xb, 0xff, 0xff,
    0xe9, 0x10,

    /* U+044B "ы" */
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x4f, 0x74, 0xf7,
    0x0, 0x0, 0x0, 0x4, 0xf7, 0x4f, 0x70, 0x0,
    0x0, 0x0, 0x4f, 0x74, 0xf8, 0x22, 0x10, 0x0,
    0x4, 0xf7, 0x4f, 0xff, 0xff, 0xe7, 0x0, 0x4f,
    0x74, 0xfa, 0x55, 0x6d, 0xf7, 0x4, 0xf7, 0x4f,
    0x70, 0x0, 0x1f, 0xd0, 0x4f, 0x74, 0xf7, 0x0,
    0x0, 0xee, 0x4, 0xf7, 0x4f, 0x70, 0x0, 0x2f,
    0xc0, 0x4f, 0x74, 0xfb, 0x77, 0x9f, 0xf4, 0x4,
    0xf7, 0x4f, 0xff, 0xff, 0xb4, 0x0, 0x4f, 0x70,

    /* U+044C "ь" */
    0x4f, 0x70, 0x0, 0x0, 0x4, 0xf7, 0x0, 0x0,
    0x0, 0x4f, 0x70, 0x0, 0x0, 0x4, 0xf8, 0x22,
    0x10, 0x0, 0x4f, 0xff, 0xff, 0xe8, 0x4, 0xfa,
    0x55, 0x6c, 0xf8, 0x4f, 0x70, 0x0, 0xf, 0xe4,
    0xf7, 0x0, 0x0, 0xdf, 0x4f, 0x70, 0x0, 0x2f,
    0xd4, 0xfb, 0x77, 0x9e, 0xf5, 0x4f, 0xff, 0xff,
    0xb4, 0x0,

    /* U+044E "ю" */
    0x4f, 0x70, 0x0, 0x3b, 0xff, 0xd7, 0x0, 0x4,
    0xf7, 0x0, 0x4f, 0xc5, 0x48, 0xfb, 0x0, 0x4f,
    0x70, 0xe, 0xe0, 0x0, 0x6, 0xf6, 0x4, 0xf7,
    0x4, 0xf8, 0x0, 0x0, 0xf, 0xc0, 0x4f, 0xb8,
    0xbf, 0x50, 0x0, 0x0, 0xdf, 0x4, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0xd, 0xf0, 0x4f, 0x70, 0x6f,
    0x60, 0x0, 0x0, 0xef, 0x4, 0xf7, 0x3, 0xf9,
    0x0, 0x0, 0x1f, 0xc0, 0x4f, 0x70, 0xd, 0xf2,
    0x0, 0x8, 0xf6, 0x4, 0xf7, 0x0, 0x4f, 0xe9,
    0x7b, 0xfb, 0x0, 0x4f, 0x70, 0x0, 0x3b, 0xff,
    0xd7, 0x0, 0x0,

    /* U+044F "я" */
    0x0, 0x4c, 0xff, 0xff, 0xfd, 0x3, 0xff, 0x97,
    0x77, 0xfd, 0x9, 0xf4, 0x0, 0x0, 0xed, 0xc,
    0xf1, 0x0, 0x0, 0xed, 0xa, 0xf3, 0x0, 0x0,
    0xed, 0x5, 0xfd, 0x42, 0x22, 0xed, 0x0, 0x7f,
    0xff, 0xff, 0xfd, 0x0, 0x9, 0xf8, 0x55, 0xfd,
    0x0, 0x6f, 0xa0, 0x0, 0xed, 0x2, 0xfd, 0x0,
    0x0, 0xed, 0xd, 0xf2, 0x0, 0x0, 0xed,

    /* U+0452 "ђ" */
    0x1, 0x52, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x0, 0x0, 0x15, 0xf9, 0x11, 0x10, 0x0,
    0xe, 0xff, 0xff, 0xff, 0x30, 0x0, 0x47, 0xfa,
    0x44, 0x41, 0x0, 0x0, 0x3f, 0x85, 0xcf, 0xfb,
    0x30, 0x3, 0xfc, 0xfa, 0x89, 0xff, 0x20, 0x3f,
    0xf4, 0x0, 0x6, 0xf8, 0x3, 0xfc, 0x0, 0x0,
    0x1f, 0xb0, 0x3f, 0x90, 0x0, 0x0, 0xfc, 0x3,
    0xf8, 0x0, 0x0, 0xf, 0xc0, 0x3f, 0x80, 0x0,
    0x0, 0xfc, 0x3, 0xf8, 0x0, 0x0, 0xf, 0xc0,
    0x3f, 0x80, 0x0, 0x0, 0xfc, 0x3, 0xf8, 0x0,
    0x0, 0xf, 0xc0, 0x3f, 0x80, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xa0, 0x0, 0x0, 0x29, 0x8e, 0xf4, 0x0, 0x0,
    0x2, 0xef, 0xd6, 0x0,

    /* U+0456 "і" */
    0x4f, 0x65, 0xf8, 0x3, 0x4, 0xf7, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f,
    0x74, 0xf7, 0x4f, 0x74, 0xf7,

    /* U+0457 "ї" */
    0x6f, 0x3e, 0x87, 0xf4, 0xfa, 0x3, 0x2, 0x0,
    0x5f, 0x70, 0x5, 0xf7, 0x0, 0x5f, 0x70, 0x5,
    0xf7, 0x0, 0x5f, 0x70, 0x5, 0xf7, 0x0, 0x5f,
    0x70, 0x5, 0xf7, 0x0, 0x5f, 0x70, 0x5, 0xf7,
    0x0, 0x5f, 0x70,

    /* U+0458 "ј" */
    0x0, 0x4, 0xf6, 0x0, 0x5, 0xf8, 0x0, 0x0,
    0x30, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0,
    0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7,
    0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4,
    0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0,
    0x4, 0xf7, 0x0, 0x4, 0xf7, 0x0, 0x4, 0xf7,
    0x0, 0x6, 0xf6, 0x18, 0x8e, 0xf2, 0x1e, 0xfd,
    0x50,

    /* U+0459 "љ" */
    0x0, 0x3f, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfa, 0x77, 0x7f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x30, 0x0, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf2, 0x0, 0xf, 0xd2, 0x21,
    0x0, 0x0, 0x0, 0x7f, 0x20, 0x0, 0xff, 0xff,
    0xff, 0xa1, 0x0, 0x8, 0xf1, 0x0, 0xf, 0xd5,
    0x56, 0xaf, 0xd0, 0x0, 0x9f, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0xbf, 0x30, 0xb, 0xe0, 0x0, 0xf,
    0xc0, 0x0, 0x9, 0xf4, 0x0, 0xeb, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0xdf, 0x1a, 0xcf, 0x60, 0x0,
    0xf, 0xe9, 0x9a, 0xef, 0xa0, 0xef, 0x90, 0x0,
    0x0, 0xff, 0xff, 0xfd, 0x70, 0x0,

    /* U+045A "њ" */
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0x4f, 0x82, 0x22, 0x27, 0xf8, 0x22, 0x10, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x80,
    0x4f, 0xa5, 0x55, 0x58, 0xf9, 0x55, 0x6c, 0xf9,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x0, 0xfe,
    0x4f, 0x70, 0x0, 0x5, 0xf6, 0x0, 0x1, 0xfd,
    0x4f, 0x70, 0x0, 0x5, 0xfb, 0x77, 0x8e, 0xf6,
    0x4f, 0x70, 0x0, 0x5, 0xff, 0xff, 0xfc, 0x50,

    /* U+045B "ћ" */
    0x1, 0x52, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x0, 0x0, 0x15, 0xf9, 0x11, 0x11, 0x0,
    0xe, 0xff, 0xff, 0xff, 0x90, 0x0, 0x47, 0xfa,
    0x44, 0x42, 0x0, 0x0, 0x3f, 0x84, 0xcf, 0xfc,
    0x40, 0x3, 0xfc, 0xfa, 0x89, 0xff, 0x30, 0x3f,
    0xf4, 0x0, 0x5, 0xf9, 0x3, 0xfc, 0x0, 0x0,
    0xf, 0xc0, 0x3f, 0x90, 0x0, 0x0, 0xfc, 0x3,
    0xf8, 0x0, 0x0, 0xf, 0xc0, 0x3f, 0x80, 0x0,
    0x0, 0xfc, 0x3, 0xf8, 0x0, 0x0, 0xf, 0xc0,
    0x3f, 0x80, 0x0, 0x0, 0xfc, 0x3, 0xf8, 0x0,
    0x0, 0xf, 0xc0, 0x3f, 0x80, 0x0, 0x0, 0xfc,

    /* U+060C "،" */
    0x0, 0x50, 0x7, 0xf1, 0xe, 0xa0, 0x2f, 0xf3,
    0xc, 0xf2,

    /* U+0622 "آ" */
    0x6, 0xfd, 0x50, 0x50, 0xb, 0x56, 0xef, 0xe2,
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xe1, 0x0, 0x0, 0x8, 0xf1, 0x0,
    0x0, 0x8, 0xf2, 0x0, 0x0, 0x7, 0xf2, 0x0,
    0x0, 0x7, 0xf2, 0x0, 0x0, 0x6, 0xf3, 0x0,
    0x0, 0x6, 0xf3, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x5, 0xf5, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x3, 0xf6, 0x0,

    /* U+0623 "أ" */
    0x2c, 0xe2, 0xb, 0x82, 0x0, 0xa8, 0x1, 0x5,
    0xff, 0xe0, 0x89, 0x40, 0x0, 0x0, 0x0, 0x7,
    0xe1, 0x0, 0x8f, 0x10, 0x8, 0xf2, 0x0, 0x7f,
    0x20, 0x7, 0xf2, 0x0, 0x6f, 0x30, 0x6, 0xf3,
    0x0, 0x5f, 0x40, 0x5, 0xf4, 0x0, 0x5f, 0x50,
    0x4, 0xf5, 0x0, 0x4f, 0x50, 0x3, 0xf6, 0x0,

    /* U+0625 "إ" */
    0x8f, 0x10, 0x8f, 0x10, 0x7f, 0x20, 0x7f, 0x20,
    0x7f, 0x30, 0x6f, 0x30, 0x6f, 0x30, 0x5f, 0x40,
    0x5f, 0x40, 0x4f, 0x50, 0x4f, 0x50, 0x3f, 0x60,
    0x3f, 0x60, 0x2f, 0x60, 0x4, 0x20, 0x0, 0x0,
    0x5d, 0xd0, 0xe5, 0x20, 0xab, 0x56, 0xbf, 0xc7,
    0x31, 0x0,

    /* U+0626 "ئ" */
    0x0, 0x1b, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0x92, 0x0, 0x0, 0x7, 0xdf, 0xf9, 0x0,
    0xa8, 0x0, 0x0, 0xc, 0xfd, 0xad, 0x70, 0x3,
    0xf9, 0xc0, 0xa, 0xf6, 0x0, 0x0, 0x0, 0x9e,
    0xa5, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x50, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x2, 0xff, 0x81, 0x0, 0x1, 0xf8, 0x0, 0x0,
    0x3, 0xcf, 0xfa, 0x20, 0x5f, 0x40, 0x0, 0x0,
    0x0, 0x29, 0xfe, 0x6, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf1, 0x4f, 0x80, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x0, 0xdf, 0x70, 0x0, 0x0, 0x18,
    0xfe, 0x10, 0x3, 0xef, 0xfb, 0xaa, 0xcf, 0xfb,
    0x10, 0x0, 0x1, 0x7c, 0xff, 0xfd, 0x93, 0x0,
    0x0,

    /* U+0627 "ا" */
    0x8f, 0x18, 0xf1, 0x7f, 0x27, 0xf2, 0x7f, 0x36,
    0xf3, 0x6f, 0x35, 0xf4, 0x5f, 0x44, 0xf5, 0x4f,
    0x53, 0xf6, 0x3f, 0x62, 0xf6, 0x4, 0x20,

    /* U+0628 "ب" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf2, 0xf, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x73, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x6f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd5,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdc, 0x1f, 0xf6, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xaf, 0x60, 0x5f, 0xff, 0xed, 0xcc, 0xcc,
    0xcc, 0xce, 0xff, 0x70, 0x0, 0x17, 0xbe, 0xff,
    0xff, 0xfe, 0xdb, 0x85, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x70,
    0x0, 0x0, 0x0, 0x0,

    /* U+0629 "ة" */
    0x1, 0xe9, 0x3f, 0x50, 0x1, 0xe9, 0x4f, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x1e, 0x80, 0x0, 0x0, 0x2f, 0xf8, 0x0,
    0x0, 0xcd, 0x9f, 0x60, 0x9, 0xf1, 0xa, 0xe0,
    0x1f, 0x80, 0x1, 0xf5, 0x5f, 0x30, 0x0, 0xf7,
    0x5f, 0x60, 0x3, 0xf5, 0x1e, 0xfb, 0xbf, 0xe0,
    0x3, 0xbf, 0xfb, 0x20,

    /* U+062A "ت" */
    0x0, 0x0, 0x0, 0x6, 0xf3, 0xad, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6e, 0x3a, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6e, 0x10, 0xb5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf6, 0x3f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xa5,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xc2, 0xff, 0x61, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x29, 0xf7, 0x6, 0xff, 0xfe, 0xdc,
    0xcc, 0xcc, 0xcc, 0xef, 0xf8, 0x0, 0x2, 0x8b,
    0xef, 0xff, 0xff, 0xed, 0xb9, 0x51, 0x0,

    /* U+062B "ث" */
    0x0, 0x0, 0x0, 0x0, 0x1e, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xe8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x3a, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xe3, 0xad, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xe1, 0xb, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x63, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfa, 0x5f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd6, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x2f,
    0xf6, 0x10, 0x0, 0x0, 0x0, 0x0, 0x2, 0x9f,
    0x70, 0x6f, 0xff, 0xed, 0xcc, 0xcc, 0xcc, 0xce,
    0xff, 0x80, 0x0, 0x28, 0xbe, 0xff, 0xff, 0xfe,
    0xdb, 0x95, 0x10, 0x0,

    /* U+062C "ج" */
    0x17, 0x9a, 0x84, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xe9, 0x41, 0x0, 0x2, 0x0, 0x26, 0xaf,
    0xff, 0xf6, 0x0, 0x0, 0x4, 0xbf, 0xfd, 0xb4,
    0x0, 0x1, 0xbf, 0xd6, 0x10, 0x0, 0x0, 0x3e,
    0xf6, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x20, 0x0,
    0x0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0xcc, 0x0, 0x0, 0xce, 0x0, 0x0, 0xcc,
    0x0, 0x0, 0xce, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xfe, 0x73, 0x0,
    0x14, 0x87, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x58, 0xaa, 0x96, 0x20,

    /* U+062D "ح" */
    0x3d, 0xff, 0xeb, 0x62, 0x0, 0x0, 0x18, 0x66,
    0x8b, 0xff, 0xeb, 0xa4, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xf6, 0x0, 0x0, 0x5e, 0xfc, 0x73, 0x10,
    0x0, 0xa, 0xfc, 0x30, 0x0, 0x0, 0x0, 0xcf,
    0x70, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x20, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf9,
    0x10, 0x0, 0x0, 0x23, 0x1, 0xcf, 0xfd, 0xba,
    0xbe, 0xfc, 0x0, 0x5, 0xad, 0xff, 0xec, 0x72,

    /* U+062E "خ" */
    0x0, 0x0, 0x8, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3d, 0xff, 0xeb, 0x62, 0x0, 0x0, 0x18, 0x66,
    0x8b, 0xff, 0xeb, 0xa4, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xf6, 0x0, 0x0, 0x5e, 0xfc, 0x73, 0x10,
    0x0, 0xa, 0xfc, 0x30, 0x0, 0x0, 0x0, 0xcf,
    0x70, 0x0, 0x0, 0x0, 0x9, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x20, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf9,
    0x10, 0x0, 0x0, 0x23, 0x1, 0xcf, 0xfd, 0xba,
    0xbe, 0xfc, 0x0, 0x5, 0xad, 0xff, 0xec, 0x72,

    /* U+062F "د" */
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0x3f, 0xa0, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0x0, 0x3, 0xf7, 0x0, 0x0, 0x0, 0xf, 0x90,
    0x20, 0x0, 0x4, 0xf8, 0x1f, 0xeb, 0xac, 0xff,
    0x20, 0x6c, 0xff, 0xea, 0x20,

    /* U+0630 "ذ" */
    0x0, 0x7, 0xe2, 0x0, 0x0, 0x0, 0x7e, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0,
    0x1, 0xee, 0x10, 0x0, 0x0, 0x4, 0xf8, 0x0,
    0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0x0, 0x3f,
    0x60, 0x0, 0x0, 0x0, 0xf9, 0x2, 0x0, 0x0,
    0x4f, 0x81, 0xfe, 0xba, 0xcf, 0xf2, 0x6, 0xcf,
    0xfe, 0xa2, 0x0,

    /* U+0631 "ر" */
    0x0, 0x0, 0x38, 0x0, 0x0, 0x0, 0x9f, 0x40,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0xd, 0xc0, 0x0, 0x0, 0x6f, 0x50,
    0x0, 0x6, 0xfb, 0x0, 0x4, 0xcf, 0xc0, 0x0,
    0x5f, 0xf8, 0x0, 0x0, 0x7, 0x10, 0x0, 0x0,

    /* U+0632 "ز" */
    0x0, 0x4, 0xf4, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x9f, 0x30,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0xc, 0xc0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x5, 0xfc, 0x0, 0x3, 0xaf, 0xd1, 0x0,
    0x5f, 0xf9, 0x0, 0x0, 0x8, 0x20, 0x0, 0x0,

    /* U+0633 "س" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x59, 0x0, 0x0, 0x48, 0x10, 0xc, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0,
    0x8f, 0x0, 0x8, 0xf1, 0x5, 0x20, 0x0, 0x0,
    0x0, 0x5f, 0x50, 0x0, 0xbe, 0x0, 0x5, 0xf2,
    0xe, 0xb0, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x1,
    0xfd, 0x0, 0x7, 0xf1, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0xfd, 0xae, 0xff, 0xca, 0xbf, 0xa0,
    0x6f, 0x40, 0x0, 0x0, 0x0, 0xf, 0xdd, 0xfd,
    0x56, 0xef, 0xe9, 0x0, 0x5f, 0x50, 0x0, 0x0,
    0x0, 0x1f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xb0, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xfc, 0x41, 0x1,
    0x4b, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x69, 0xa9,
    0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0634 "ش" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xe4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad,
    0x1d, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xad, 0x1e, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7b, 0x0, 0x0, 0x5b, 0x10, 0xb, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0,
    0x8f, 0x0, 0x7, 0xf2, 0x6, 0x30, 0x0, 0x0,
    0x0, 0x5f, 0x60, 0x0, 0xbe, 0x0, 0x5, 0xf2,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x1,
    0xfd, 0x0, 0x7, 0xf0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0xf, 0xfd, 0xae, 0xff, 0xca, 0xbf, 0xa0,
    0x6f, 0x40, 0x0, 0x0, 0x0, 0xf, 0xdd, 0xfd,
    0x56, 0xef, 0xe9, 0x0, 0x5f, 0x50, 0x0, 0x0,
    0x0, 0x2f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xfc, 0x41, 0x1,
    0x4c, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x69, 0xa9,
    0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0635 "ص" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x7a, 0x83, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x9f, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6a,
    0x0, 0x0, 0x2d, 0xf9, 0x20, 0x3d, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x2, 0xee,
    0x30, 0x0, 0x6, 0xf3, 0x7, 0x40, 0x0, 0x0,
    0x0, 0x5f, 0x60, 0x1e, 0xe2, 0x0, 0x0, 0x7,
    0xf1, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x1f, 0xe5,
    0xcf, 0x20, 0x0, 0x0, 0x7f, 0xb0, 0x3f, 0x60,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xfe, 0xaa, 0xab,
    0xdf, 0xfc, 0x10, 0x6f, 0x40, 0x0, 0x0, 0x0,
    0xf, 0xa5, 0xad, 0xff, 0xfe, 0xc9, 0x40, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xc0, 0x0,
    0x0, 0x0, 0xcf, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfc, 0x41, 0x1, 0x5c, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x69, 0xa9,
    0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+0636 "ض" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x7a, 0x83,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x9f, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6a, 0x0, 0x0, 0x2d, 0xf9,
    0x20, 0x3d, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x20, 0x2, 0xee, 0x30, 0x0, 0x6, 0xf3,
    0x7, 0x40, 0x0, 0x0, 0x0, 0x5f, 0x60, 0x1e,
    0xe2, 0x0, 0x0, 0x7, 0xf1, 0xf, 0xa0, 0x0,
    0x0, 0x0, 0x1f, 0xe5, 0xcf, 0x20, 0x0, 0x0,
    0x7f, 0xb0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xfe, 0xaa, 0xab, 0xdf, 0xfc, 0x10, 0x6f,
    0x40, 0x0, 0x0, 0x0, 0xf, 0xa5, 0xad, 0xff,
    0xfe, 0xc9, 0x40, 0x0, 0x5f, 0x50, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0xcf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc,
    0x41, 0x1, 0x5c, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x69, 0xa9, 0x61, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0637 "ط" */
    0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x4, 0x9a, 0x71, 0x0, 0x0, 0xe, 0xc0,
    0x3d, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xdc, 0x6f,
    0xe6, 0x10, 0x6f, 0xa0, 0x0, 0xd, 0xff, 0xb1,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0xcf, 0xa0, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x2f, 0xb0, 0x0, 0x0,
    0x2a, 0xf5, 0x6b, 0xad, 0xfb, 0x99, 0xab, 0xdf,
    0xf8, 0x6, 0xef, 0xff, 0xff, 0xff, 0xec, 0x82,
    0x0,

    /* U+0638 "ظ" */
    0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x6e, 0x20, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x4, 0x9a, 0x71, 0x0, 0x0, 0xe, 0xc0,
    0x3d, 0xff, 0xff, 0xe2, 0x0, 0x0, 0xdc, 0x6f,
    0xe6, 0x10, 0x6f, 0xa0, 0x0, 0xd, 0xff, 0xb1,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0xcf, 0xa0, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x2f, 0xb0, 0x0, 0x0,
    0x2a, 0xf5, 0x6b, 0xad, 0xfb, 0x99, 0xab, 0xdf,
    0xf8, 0x6, 0xef, 0xff, 0xff, 0xff, 0xec, 0x82,
    0x0,

    /* U+0639 "ع" */
    0x0, 0x5c, 0xff, 0x90, 0x0, 0x0, 0x7, 0xfe,
    0xab, 0x70, 0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9,
    0x25, 0xbf, 0x50, 0x0, 0x2, 0xdf, 0xff, 0xfa,
    0x40, 0x0, 0x0, 0x7f, 0xe6, 0x0, 0x0, 0x0,
    0x5, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x1f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xf8, 0x0, 0x0, 0x0, 0x30,
    0x2, 0xdf, 0xfc, 0xaa, 0xce, 0xf5, 0x0, 0x6,
    0xbe, 0xff, 0xda, 0x61,

    /* U+063A "غ" */
    0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5c, 0xff, 0x90, 0x0, 0x0, 0x7, 0xfe,
    0xab, 0x70, 0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9,
    0x25, 0xbf, 0x50, 0x0, 0x2, 0xdf, 0xff, 0xfa,
    0x40, 0x0, 0x0, 0x7f, 0xe6, 0x0, 0x0, 0x0,
    0x5, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x1f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xf8, 0x0, 0x0, 0x0, 0x30,
    0x2, 0xdf, 0xfc, 0xaa, 0xce, 0xf5, 0x0, 0x6,
    0xbe, 0xff, 0xda, 0x61,

    /* U+0640 "ـ" */
    0x8a, 0xaa, 0xaa, 0x2f, 0xff, 0xff, 0xf3,

    /* U+0641 "ف" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0x97, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf8, 0xa,
    0xf3, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x0, 0x1f, 0x80, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xc0, 0x0, 0xdb, 0x4f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x40, 0x1d, 0xc6, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xfb, 0x5f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x3, 0x89, 0x7f,
    0x91, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf6, 0x5, 0xff, 0xeb, 0xa9, 0x99, 0x99,
    0x99, 0xac, 0xfe, 0x0, 0x1, 0x7b, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xea, 0x20,

    /* U+0642 "ق" */
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x66, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xe6, 0x6e, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xdf, 0xb1, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xfd, 0xbf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x10, 0x8f, 0x30, 0x32, 0x0, 0x0,
    0xe, 0xa0, 0x2, 0xf7, 0xc, 0xf0, 0x0, 0x0,
    0xfb, 0x0, 0xf, 0x91, 0xfa, 0x0, 0x0, 0xc,
    0xfb, 0x9b, 0xf8, 0x5f, 0x50, 0x0, 0x0, 0x2b,
    0xff, 0xef, 0x76, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf3, 0x4f, 0xa0, 0x0, 0x0, 0x0, 0x2,
    0xed, 0x0, 0xdf, 0x91, 0x0, 0x0, 0x6, 0xef,
    0x30, 0x3, 0xef, 0xfd, 0xbb, 0xdf, 0xfe, 0x40,
    0x0, 0x1, 0x7c, 0xff, 0xfd, 0xa6, 0x0, 0x0,

    /* U+0643 "ك" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x54, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x70,
    0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x10, 0x0, 0x5f, 0x40, 0xc5, 0x0, 0x0, 0x0,
    0xe8, 0x0, 0x4, 0xf5, 0x3f, 0x60, 0x0, 0xb,
    0xfe, 0x20, 0x0, 0x4f, 0x65, 0xf4, 0x0, 0x0,
    0x85, 0x0, 0x0, 0x3, 0xf6, 0x6f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x52, 0xfe, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x3d, 0xf1, 0x6, 0xff,
    0xfc, 0xba, 0xaa, 0xbc, 0xef, 0xf6, 0x0, 0x2,
    0x8b, 0xef, 0xff, 0xfe, 0xda, 0x61, 0x0,

    /* U+0644 "ل" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90,
    0xda, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x2f, 0x80,
    0x0, 0x0, 0x0, 0xf, 0x85, 0xf4, 0x0, 0x0,
    0x0, 0x2, 0xf7, 0x6f, 0x40, 0x0, 0x0, 0x0,
    0x5f, 0x44, 0xf8, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0xd, 0xf6, 0x0, 0x0, 0x9, 0xf6, 0x0, 0x2e,
    0xfe, 0xba, 0xbf, 0xf9, 0x0, 0x0, 0x17, 0xcf,
    0xfe, 0xb4, 0x0, 0x0,

    /* U+0645 "م" */
    0x0, 0x2, 0x89, 0x60, 0x0, 0x5, 0xff, 0xff,
    0xb0, 0x2, 0xfc, 0x20, 0x9f, 0x50, 0x4d, 0x10,
    0x0, 0xea, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x2,
    0x79, 0xa9, 0xcd, 0x7, 0xff, 0xff, 0xff, 0x93,
    0xfc, 0x20, 0x13, 0x62, 0x8f, 0x20, 0x0, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0x0, 0x8f, 0x10, 0x0,
    0x0, 0x6, 0xf3, 0x0, 0x0, 0x0, 0x4f, 0x50,
    0x0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0xe,
    0xc0, 0x0, 0x0, 0x0, 0x9a, 0x0, 0x0, 0x0,

    /* U+0646 "ن" */
    0x0, 0x0, 0x3, 0xe6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1, 0xe9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x50, 0xdb, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x2f, 0x70, 0x0, 0x0,
    0x0, 0xf, 0xa5, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xfa, 0x6f, 0x40, 0x0, 0x0, 0x0, 0x2f, 0x84,
    0xf8, 0x0, 0x0, 0x0, 0x9, 0xf3, 0xd, 0xf6,
    0x0, 0x0, 0x8, 0xfa, 0x0, 0x3e, 0xfe, 0xba,
    0xbf, 0xfc, 0x0, 0x0, 0x18, 0xcf, 0xfe, 0xb6,
    0x0, 0x0,

    /* U+0647 "ه" */
    0x0, 0x0, 0x9, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x4e,
    0xff, 0xd2, 0x0, 0x0, 0x0, 0x1f, 0xc5, 0xbf,
    0xe3, 0x0, 0x0, 0x6, 0xf2, 0x1, 0xff, 0xe2,
    0x0, 0x0, 0x6f, 0x10, 0x2f, 0x9f, 0xd0, 0x0,
    0x3, 0xf8, 0x9, 0xf2, 0x6f, 0x60, 0x0, 0xa,
    0xfc, 0xf8, 0x2, 0xf8, 0x6c, 0x99, 0xcf, 0xff,
    0xb9, 0xcf, 0x55, 0xcf, 0xfc, 0x84, 0xae, 0xfe,
    0x80,

    /* U+0648 "و" */
    0x0, 0x1b, 0xfd, 0x30, 0x0, 0xcf, 0xaf, 0xe1,
    0x5, 0xf4, 0x4, 0xf7, 0x9, 0xe0, 0x0, 0xeb,
    0xb, 0xf0, 0x0, 0xbd, 0x8, 0xfd, 0x9a, 0xfd,
    0x0, 0x9e, 0xfe, 0xfb, 0x0, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x5f, 0xd0, 0x5, 0x8d, 0xfe, 0x20,
    0xf, 0xfe, 0x81, 0x0, 0x5, 0x30, 0x0, 0x0,

    /* U+0649 "ى" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xfe, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xda, 0xd7, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0xc9, 0x0,
    0x0, 0x2f, 0xf8, 0x10, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x3c, 0xff, 0xa2, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x2, 0x9f, 0xe0, 0x6f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x14, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xb0, 0xd, 0xf7, 0x0, 0x0, 0x1,
    0x8f, 0xe1, 0x0, 0x3e, 0xff, 0xba, 0xac, 0xff,
    0xb1, 0x0, 0x0, 0x17, 0xcf, 0xff, 0xd9, 0x30,
    0x0, 0x0,

    /* U+064A "ي" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x27, 0xa8, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xb3, 0x2, 0x20, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x97, 0x0,
    0x0, 0x3f, 0xd4, 0x0, 0x0, 0x1f, 0x90, 0x0,
    0x0, 0x5e, 0xfd, 0x70, 0x4, 0xf5, 0x0, 0x0,
    0x0, 0x5, 0xbf, 0xd0, 0x6f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x14, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xc0, 0xe, 0xf6, 0x0, 0x0, 0x1,
    0x7f, 0xe2, 0x0, 0x3e, 0xff, 0xba, 0xac, 0xff,
    0xc2, 0x0, 0x0, 0x17, 0xcf, 0xff, 0xd9, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xd9, 0x3e, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0x94, 0xf5, 0x0, 0x0, 0x0,

    /* U+064B "ً" */
    0x0, 0x1, 0x52, 0x7, 0xcf, 0xc2, 0x2a, 0x51,
    0x42, 0x5, 0xaf, 0xe3, 0x3c, 0x72, 0x0,

    /* U+064F "ُ" */
    0x0, 0x8e, 0x90, 0x2, 0xe2, 0xe2, 0x1, 0xf4,
    0xe1, 0x0, 0x8f, 0xa0, 0x8f, 0xd6, 0x0, 0x0,
    0x0, 0x0,

    /* U+067E "پ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf2, 0xf, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x73, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x6f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd5,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdc, 0x1f, 0xf6, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xaf, 0x60, 0x5f, 0xff, 0xed, 0xcc, 0xcc,
    0xcc, 0xce, 0xff, 0x70, 0x0, 0x17, 0xbe, 0xff,
    0xff, 0xfe, 0xdb, 0x85, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x2b, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe2, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0x70, 0x0, 0x0, 0x0, 0x0,

    /* U+0698 "ژ" */
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0x8e, 0x1d, 0xa0, 0x0, 0x9e, 0x1d, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x27, 0x0, 0x0, 0x0, 0x9f, 0x30,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0xc, 0xc0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x5, 0xfc, 0x0, 0x3, 0xaf, 0xd1, 0x0,
    0x5f, 0xf9, 0x0, 0x0, 0x8, 0x20, 0x0, 0x0,

    /* U+06A9 "ک" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4c, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3c, 0xff, 0x81, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x91, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xd2, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x20, 0x0,
    0xf, 0x80, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xd1,
    0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfa, 0x0, 0x6f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x10, 0x5f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x40, 0x1f, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xaf, 0x30, 0x5, 0xff, 0xfc,
    0xba, 0xaa, 0xbc, 0xef, 0xf8, 0x0, 0x0, 0x17,
    0xbe, 0xff, 0xff, 0xed, 0xb7, 0x20, 0x0,

    /* U+06AF "گ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfe, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xef, 0x70, 0x41, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xbf, 0xa1, 0x4c, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xc3, 0x3c, 0xff, 0x81, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0xff, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x91, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xd2, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfe,
    0x20, 0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xd1, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfa, 0x0, 0x6f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x10, 0x5f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x40, 0x1f, 0xe5,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xaf, 0x30, 0x5,
    0xff, 0xfc, 0xba, 0xaa, 0xbc, 0xef, 0xf8, 0x0,
    0x0, 0x17, 0xbe, 0xff, 0xff, 0xed, 0xb7, 0x20,
    0x0,

    /* U+06CC "ی" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7d, 0xfe, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xda, 0xd7, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0xc9, 0x0,
    0x0, 0x2f, 0xf8, 0x10, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x3c, 0xff, 0xa2, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x2, 0x9f, 0xe0, 0x6f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x14, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xb0, 0xd, 0xf7, 0x0, 0x0, 0x1,
    0x8f, 0xe1, 0x0, 0x3e, 0xff, 0xba, 0xac, 0xff,
    0xb1, 0x0, 0x0, 0x17, 0xcf, 0xff, 0xd9, 0x30,
    0x0, 0x0,

    /* U+0901 "ँ" */
    0x0, 0x4, 0x60, 0x0, 0x5c, 0xc, 0xf1, 0x89,
    0x6f, 0x24, 0x60, 0xda, 0xe, 0xd4, 0x3a, 0xf3,
    0x2, 0xdf, 0xfe, 0x50, 0x0, 0x1, 0x20, 0x0,

    /* U+0902 "ं" */
    0x3a, 0x1a, 0xf7, 0x3a, 0x20,

    /* U+0903 "ः" */
    0xff, 0xff, 0x57, 0x77, 0x72, 0x0, 0x0, 0x0,
    0xaa, 0x0, 0x2f, 0xf3, 0x0, 0xaa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaa,
    0x0, 0x2f, 0xf3, 0x0, 0xaa, 0x0,

    /* U+0905 "अ" */
    0x0, 0x19, 0xdf, 0xfb, 0x20, 0x9f, 0xff, 0xf9,
    0x0, 0xd, 0xa8, 0x9f, 0xd0, 0x48, 0xfb, 0x74,
    0x0, 0x0, 0x0, 0x8, 0xf2, 0x2, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x2, 0xf8, 0x0,
    0x0, 0x0, 0x15, 0xaf, 0xb0, 0x2, 0xf8, 0x0,
    0x19, 0x10, 0x7f, 0xff, 0x74, 0x48, 0xf8, 0x0,
    0x2f, 0x80, 0x13, 0x1c, 0xff, 0xff, 0xf8, 0x0,
    0xb, 0xf1, 0x0, 0x2, 0xf8, 0x33, 0xf8, 0x0,
    0x2, 0xfa, 0x0, 0x2, 0xf7, 0x2, 0xf8, 0x0,
    0x0, 0x7f, 0xb5, 0x5c, 0xf3, 0x2, 0xf8, 0x0,
    0x0, 0x7, 0xff, 0xff, 0x70, 0x2, 0xf8, 0x0,
    0x0, 0x0, 0x3, 0x30, 0x0, 0x2, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf8, 0x0,

    /* U+0906 "आ" */
    0x0, 0x19, 0xdf, 0xfb, 0x20, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0xda, 0x89, 0xfd, 0x4,
    0x8f, 0xb7, 0x77, 0xfd, 0x75, 0x0, 0x0, 0x0,
    0x8, 0xf2, 0x2, 0xf8, 0x0, 0xf, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x10, 0x2f, 0x80, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0x15, 0xaf, 0xb0, 0x2,
    0xf8, 0x0, 0xf, 0xb0, 0x1, 0x91, 0x7, 0xff,
    0xf7, 0x44, 0x8f, 0x80, 0x0, 0xfb, 0x0, 0x2f,
    0x80, 0x13, 0x1c, 0xff, 0xff, 0xf8, 0x0, 0xf,
    0xb0, 0x0, 0xbf, 0x10, 0x0, 0x2f, 0x83, 0x3f,
    0x80, 0x0, 0xfb, 0x0, 0x2, 0xfa, 0x0, 0x2,
    0xf7, 0x2, 0xf8, 0x0, 0xf, 0xb0, 0x0, 0x7,
    0xfb, 0x55, 0xcf, 0x30, 0x2f, 0x80, 0x0, 0xfb,
    0x0, 0x0, 0x7, 0xff, 0xff, 0x70, 0x2, 0xf8,
    0x0, 0xf, 0xb0, 0x0, 0x0, 0x0, 0x33, 0x0,
    0x0, 0x2f, 0x80, 0x0, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf8, 0x0, 0xf, 0xb0,
    0x0,

    /* U+0907 "इ" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x17, 0x77, 0x77,
    0x7c, 0xf8, 0x70, 0x0, 0x0, 0x0, 0x8f, 0x10,
    0x0, 0x1, 0x33, 0x3a, 0xf1, 0x0, 0x6, 0xff,
    0xff, 0xff, 0x10, 0x0, 0xfd, 0x43, 0x33, 0x30,
    0x0, 0xe, 0xc0, 0x13, 0x20, 0x0, 0x0, 0x6f,
    0xef, 0xff, 0xd2, 0x0, 0x0, 0x6a, 0x54, 0x7f,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x0, 0xa,
    0x90, 0x0, 0xd, 0xd0, 0x1, 0xff, 0xb6, 0x7d,
    0xf6, 0x0, 0x7, 0xef, 0xfe, 0xb5, 0x0, 0x0,
    0x0, 0x9f, 0x40, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x40, 0x0, 0x0, 0x0, 0x2, 0xea, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0,

    /* U+0909 "उ" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x77, 0x77,
    0x77, 0x8f, 0xe7, 0x72, 0x0, 0x0, 0x0, 0x6,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf4, 0x0, 0x0, 0x0,
    0x39, 0xdf, 0xb0, 0x0, 0x3d, 0x30, 0x5f, 0xdf,
    0xb0, 0x0, 0x1f, 0x90, 0x0, 0x5, 0xf7, 0x0,
    0xb, 0xe0, 0x0, 0x0, 0xdd, 0x0, 0x4, 0xf7,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0xcf, 0x30, 0x1,
    0xfd, 0x0, 0x0, 0x1e, 0xfa, 0x9e, 0xf6, 0x0,
    0x0, 0x1, 0xae, 0xfd, 0x60, 0x0,

    /* U+090F "ए" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x7b, 0xf9,
    0x77, 0x78, 0xfb, 0x72, 0x6, 0xf3, 0x0, 0x2,
    0xf7, 0x0, 0x6, 0xf3, 0x0, 0x2, 0xf7, 0x0,
    0x6, 0xf3, 0x0, 0x2, 0xf7, 0x0, 0x6, 0xf3,
    0x0, 0x3, 0xf7, 0x0, 0x6, 0xf3, 0x0, 0x1b,
    0xf4, 0x0, 0x4, 0xf7, 0x0, 0xaf, 0xa0, 0x0,
    0x0, 0xef, 0x50, 0x14, 0x0, 0x0, 0x0, 0x2c,
    0xfc, 0x30, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xfa,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xc1, 0x0,

    /* U+0915 "क" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x77, 0x77, 0x77, 0x7b, 0xf9, 0x77, 0x77, 0x75,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x34, 0x57, 0xf2, 0x0, 0x0, 0x0,
    0x1, 0xbf, 0xff, 0xc7, 0xf2, 0x13, 0x10, 0x0,
    0xb, 0xf9, 0x53, 0x17, 0xfc, 0xff, 0xf8, 0x0,
    0xf, 0xa0, 0x0, 0x7, 0xff, 0x64, 0xbf, 0x30,
    0xf, 0xa0, 0x0, 0xa, 0xf5, 0x0, 0x2f, 0x70,
    0xb, 0xf8, 0x45, 0xcf, 0xf2, 0x0, 0x1f, 0x70,
    0x1, 0xbf, 0xff, 0xec, 0xf2, 0x0, 0x6f, 0x40,
    0x0, 0x1, 0x32, 0x7, 0xf2, 0x1, 0xee, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x3, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,

    /* U+0916 "ख" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xa7, 0x77, 0x7f, 0xd7, 0x77, 0x87, 0x78, 0xfc,
    0x74, 0x0, 0x0, 0xbe, 0x0, 0x1, 0x31, 0xf,
    0x90, 0x0, 0x0, 0xa, 0xf0, 0xa, 0xff, 0xf4,
    0xf9, 0x0, 0x7, 0x60, 0xdd, 0x8, 0xf9, 0x46,
    0x3f, 0x90, 0x2, 0xff, 0xcf, 0x90, 0xdd, 0x0,
    0x0, 0xf9, 0x0, 0xf, 0xff, 0xe1, 0xd, 0xc0,
    0x0, 0xf, 0x90, 0x0, 0xaf, 0xb1, 0x0, 0x8f,
    0x83, 0x4b, 0xf9, 0x0, 0x2, 0xf9, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0x90, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0x13, 0x21, 0xf9, 0x0, 0x0, 0x9, 0xfa,
    0x10, 0x0, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x7,
    0xff, 0xc9, 0x89, 0xdf, 0xf9, 0x0, 0x0, 0x0,
    0x1, 0x8c, 0xff, 0xeb, 0x6f, 0x90, 0x0,

    /* U+0917 "ग" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x77, 0xbf,
    0x97, 0x78, 0xfb, 0x74, 0x0, 0x7f, 0x20, 0x2,
    0xf7, 0x0, 0x0, 0x7f, 0x20, 0x2, 0xf7, 0x0,
    0x0, 0x7f, 0x20, 0x2, 0xf7, 0x0, 0x6, 0xbf,
    0x20, 0x2, 0xf7, 0x0, 0x2f, 0xff, 0x20, 0x2,
    0xf7, 0x0, 0xe, 0xff, 0x20, 0x2, 0xf7, 0x0,
    0x4, 0xff, 0x10, 0x2, 0xf7, 0x0, 0x0, 0x13,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf7, 0x0,

    /* U+091A "च" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x77,
    0x77, 0x77, 0x77, 0xdf, 0x77, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x33, 0x33, 0x33, 0x20,
    0xbe, 0x0, 0x3f, 0xff, 0xff, 0xfb, 0xb, 0xe0,
    0x0, 0x33, 0xbf, 0x84, 0x20, 0xbe, 0x0, 0x0,
    0x2f, 0x70, 0x0, 0xb, 0xe0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0xce, 0x0, 0x0, 0xe, 0xe6, 0x46,
    0xdf, 0xe0, 0x0, 0x0, 0x3d, 0xff, 0xfe, 0xee,
    0x0, 0x0, 0x0, 0x2, 0x32, 0xb, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xe0, 0x0,

    /* U+091C "ज" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x7c, 0xf8, 0x71,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x33, 0x33, 0x3a, 0xf1, 0x0,
    0x2b, 0x20, 0x4, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x1f, 0x80, 0x2, 0xde, 0x43, 0x3a, 0xf1, 0x0,
    0xa, 0xe0, 0x0, 0x1f, 0x90, 0x9, 0xf1, 0x0,
    0x3, 0xf7, 0x0, 0x8, 0xf0, 0x9, 0xf1, 0x0,
    0x0, 0xaf, 0x20, 0x7, 0xf2, 0x9, 0xf1, 0x0,
    0x0, 0x1e, 0xe6, 0x5d, 0xf0, 0x9, 0xf1, 0x0,
    0x0, 0x2, 0xcf, 0xff, 0x50, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x2, 0x30, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,

    /* U+091F "ट" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0x57, 0x77, 0x77,
    0x7c, 0xf7, 0x72, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x1, 0x3b, 0xf0, 0x0, 0x0, 0x4c,
    0xff, 0xff, 0x0, 0x0, 0x4f, 0xe7, 0x43, 0x30,
    0x0, 0xc, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf5, 0x0, 0x0, 0x72, 0x0, 0x1d, 0xfc, 0x9a,
    0xef, 0x70, 0x0, 0x18, 0xef, 0xfb, 0x50, 0x0,

    /* U+0921 "ड" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x17, 0x77,
    0x77, 0x77, 0xdf, 0x77, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x13, 0x33, 0xce, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x1f,
    0xc4, 0x33, 0x33, 0x0, 0x0, 0x1f, 0x90, 0x23,
    0x20, 0x0, 0x0, 0x8, 0xfe, 0xff, 0xfb, 0x10,
    0x0, 0x0, 0x7a, 0x54, 0x9f, 0x80, 0x0, 0x90,
    0x0, 0x0, 0xe, 0xc0, 0x5, 0xfc, 0x20, 0x0,
    0x1f, 0xa0, 0x0, 0x7f, 0xfc, 0x99, 0xef, 0x40,
    0x0, 0x2, 0x9d, 0xff, 0xc4, 0x0,

    /* U+0923 "ण" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb7,
    0xbf, 0x97, 0x79, 0xfb, 0x77, 0xfd, 0x75, 0x6,
    0xf3, 0x0, 0x3f, 0x60, 0xf, 0xb0, 0x0, 0x6f,
    0x30, 0x3, 0xf6, 0x0, 0xfb, 0x0, 0x6, 0xf3,
    0x0, 0x3f, 0x60, 0xf, 0xb0, 0x0, 0x6f, 0x30,
    0x3, 0xf6, 0x0, 0xfb, 0x0, 0x6, 0xf3, 0x0,
    0x3f, 0x60, 0xf, 0xb0, 0x0, 0x4f, 0x60, 0x6,
    0xf5, 0x0, 0xfb, 0x0, 0x0, 0xee, 0x55, 0xdf,
    0x10, 0xf, 0xb0, 0x0, 0x4, 0xef, 0xff, 0x50,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0x33, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xb0, 0x0,

    /* U+0924 "त" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0xfc, 0x75, 0x0, 0x0, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0,
    0x0, 0x1, 0x33, 0x33, 0xfa, 0x0, 0x1, 0xbf,
    0xff, 0xff, 0xfa, 0x0, 0xc, 0xf9, 0x43, 0x33,
    0xfa, 0x0, 0xf, 0xa0, 0x0, 0x0, 0xfa, 0x0,
    0xf, 0x80, 0x0, 0x0, 0xfa, 0x0, 0xd, 0xc0,
    0x0, 0x0, 0xfa, 0x0, 0x6, 0xf6, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0xbf, 0x40, 0x0, 0xfa, 0x0,
    0x0, 0x1d, 0x90, 0x0, 0xfa, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0,

    /* U+0925 "थ" */
    0x1b, 0xff, 0xa0, 0x2f, 0xff, 0xff, 0x1a, 0xf7,
    0x7f, 0xa1, 0xbe, 0xfb, 0xb0, 0xcc, 0x0, 0xaf,
    0x0, 0xaf, 0x0, 0x9, 0xf6, 0x9, 0xf0, 0xa,
    0xf0, 0x0, 0xa, 0xb0, 0xde, 0x0, 0xaf, 0x0,
    0x0, 0x3, 0xcf, 0x60, 0xa, 0xf0, 0x0, 0x8e,
    0xff, 0x60, 0x0, 0xaf, 0x0, 0x5, 0xfb, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0xb, 0xf9, 0x44, 0x6d,
    0xff, 0x0, 0x0, 0x9, 0xff, 0xff, 0xee, 0xf0,
    0x0, 0x0, 0x0, 0x23, 0x20, 0xaf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0,

    /* U+0926 "द" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd7, 0x77, 0x77,
    0x77, 0xfd, 0x76, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x2, 0x33, 0xfb, 0x0, 0x0, 0x7e,
    0xff, 0xff, 0xb0, 0x0, 0x7f, 0xc6, 0x43, 0x32,
    0x0, 0xd, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x43, 0x0, 0xc, 0xe1, 0x0, 0x6f,
    0xf5, 0x0, 0x4f, 0xe7, 0x4a, 0xff, 0x70, 0x0,
    0x4d, 0xff, 0xff, 0xc1, 0x0, 0x0, 0x1, 0x33,
    0xdb, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x20, 0x0,

    /* U+0927 "ध" */
    0x1b, 0xff, 0xa0, 0x5f, 0xff, 0xf9, 0xbe, 0x34,
    0xf7, 0x28, 0xfc, 0x74, 0xf9, 0x1, 0xf8, 0x1,
    0xf8, 0x0, 0xeb, 0x3, 0xd2, 0x1, 0xf8, 0x0,
    0x7f, 0x72, 0x42, 0x1, 0xf8, 0x0, 0x8, 0xff,
    0xfa, 0x1, 0xf8, 0x0, 0xb, 0xf8, 0x42, 0x1,
    0xf8, 0x0, 0xf, 0xa0, 0x0, 0x1, 0xf8, 0x0,
    0xf, 0xa0, 0x0, 0x8, 0xf8, 0x0, 0x9, 0xf9,
    0x44, 0xaf, 0xf8, 0x0, 0x0, 0x9f, 0xff, 0xe7,
    0xf8, 0x0, 0x0, 0x0, 0x33, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf8, 0x0,

    /* U+0928 "न" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x77, 0x77,
    0x77, 0x7a, 0xfa, 0x72, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x2, 0x33,
    0x33, 0x37, 0xf5, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x1f, 0xff, 0x43, 0x37, 0xf5, 0x0,
    0x6, 0xff, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x33,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,

    /* U+092A "प" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x7b, 0xf9,
    0x77, 0x78, 0xfc, 0x75, 0x6, 0xf3, 0x0, 0x0,
    0xf9, 0x0, 0x6, 0xf3, 0x0, 0x0, 0xf9, 0x0,
    0x6, 0xf3, 0x0, 0x0, 0xf9, 0x0, 0x6, 0xf3,
    0x0, 0x0, 0xf9, 0x0, 0x4, 0xf6, 0x0, 0x1,
    0xf9, 0x0, 0x0, 0xee, 0x64, 0x7e, 0xf9, 0x0,
    0x0, 0x3d, 0xff, 0xfe, 0xf9, 0x0, 0x0, 0x0,
    0x23, 0x10, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,

    /* U+092B "फ" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x7b, 0xf9, 0x77, 0x7b, 0xf9, 0x77, 0x77, 0x75,
    0x6, 0xf3, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x0,
    0x6, 0xf3, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x0,
    0x6, 0xf3, 0x0, 0x6, 0xf3, 0x13, 0x10, 0x0,
    0x6, 0xf3, 0x0, 0x6, 0xfc, 0xff, 0xf8, 0x0,
    0x5, 0xf5, 0x0, 0x7, 0xff, 0x63, 0xaf, 0x40,
    0x0, 0xfd, 0x54, 0x8f, 0xf4, 0x0, 0x1f, 0x80,
    0x0, 0x4e, 0xff, 0xfe, 0xf3, 0x0, 0x1f, 0x80,
    0x0, 0x0, 0x33, 0x16, 0xf3, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x0, 0x6, 0xf3, 0x1, 0xee, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf3, 0x2, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x0,

    /* U+092C "ब" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x77, 0x77,
    0x77, 0x77, 0xfd, 0x75, 0x0, 0x0, 0x23, 0x0,
    0xfa, 0x0, 0x0, 0x8f, 0xff, 0xf3, 0xfa, 0x0,
    0x8, 0xff, 0x93, 0x73, 0xfa, 0x0, 0xf, 0xc7,
    0xf2, 0x0, 0xfa, 0x0, 0x1f, 0x90, 0xbd, 0x0,
    0xfa, 0x0, 0xf, 0xb0, 0x1e, 0xa0, 0xfa, 0x0,
    0x8, 0xf9, 0x47, 0xfe, 0xfa, 0x0, 0x0, 0x8f,
    0xff, 0xfd, 0xfa, 0x0, 0x0, 0x0, 0x23, 0x10,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfa, 0x0,

    /* U+092D "भ" */
    0x3, 0xdf, 0xe6, 0x0, 0xff, 0xff, 0xff, 0x50,
    0xed, 0x6b, 0xf3, 0xa, 0xbc, 0xfc, 0xb3, 0xf,
    0x70, 0x1f, 0x80, 0x0, 0x5f, 0x40, 0x0, 0xde,
    0x50, 0xfa, 0x0, 0x5, 0xf4, 0x0, 0x2, 0xcf,
    0x1f, 0xa0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x10,
    0xfa, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x3f,
    0xb3, 0x33, 0x7f, 0x40, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x6, 0xff, 0xb3,
    0x33, 0x7f, 0x40, 0x0, 0x0, 0x9, 0xf8, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x5f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x40, 0x0,

    /* U+092E "म" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x37, 0x7b,
    0xf8, 0x77, 0x7b, 0xf9, 0x71, 0x0, 0x7f, 0x20,
    0x0, 0x7f, 0x30, 0x0, 0x7, 0xf2, 0x0, 0x7,
    0xf3, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x7f, 0x30,
    0x0, 0x7, 0xf2, 0x0, 0x7, 0xf3, 0x0, 0x2,
    0x9f, 0x53, 0x33, 0x9f, 0x30, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0xe, 0xff, 0x53, 0x33,
    0x9f, 0x30, 0x0, 0x3e, 0xf0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0,

    /* U+092F "य" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x77, 0x8f,
    0xc7, 0x77, 0xee, 0x76, 0x0, 0xa, 0xe0, 0x0,
    0xcd, 0x0, 0x0, 0x7, 0xf2, 0x0, 0xcd, 0x0,
    0x0, 0x1d, 0xf0, 0x0, 0xcd, 0x0, 0x2b, 0xff,
    0x70, 0x0, 0xcd, 0x0, 0x1f, 0xd3, 0x0, 0x0,
    0xcd, 0x0, 0xb, 0xf1, 0x0, 0x2, 0xed, 0x0,
    0x2, 0xfd, 0x54, 0x7e, 0xfd, 0x0, 0x0, 0x4d,
    0xff, 0xfc, 0xed, 0x0, 0x0, 0x0, 0x23, 0x20,
    0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,

    /* U+0930 "र" */
    0xff, 0xff, 0xff, 0xff, 0x77, 0x77, 0x78, 0xfc,
    0x73, 0x0, 0x0, 0xf, 0xa0, 0x0, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0xed,
    0x6e, 0xf3, 0x0, 0x1f, 0xff, 0xf6, 0x0, 0x0,
    0xbf, 0xc2, 0x0, 0x0, 0x1, 0xec, 0x0, 0x0,
    0x0, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x6, 0xfb,
    0x0, 0x0, 0x0, 0x7, 0xfc, 0x10, 0x0, 0x0,
    0x6, 0xe3, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+0932 "ल" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x77,
    0x77, 0x77, 0x77, 0x77, 0xee, 0x76, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x2, 0x31,
    0x0, 0x3, 0xec, 0x0, 0x1, 0xbf, 0xff, 0x77,
    0xff, 0xfc, 0x0, 0xb, 0xf8, 0x47, 0xff, 0xb4,
    0xdc, 0x0, 0xf, 0xb0, 0x0, 0xee, 0x0, 0xdc,
    0x0, 0x1f, 0x80, 0x3, 0xf8, 0x0, 0xdc, 0x0,
    0xf, 0xa0, 0x3, 0xc4, 0x0, 0xdc, 0x0, 0xa,
    0xf3, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x1, 0xee,
    0x20, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x3f, 0xf5,
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x2, 0xda, 0x0,
    0x0, 0xdc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0935 "व" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x77, 0x77,
    0x77, 0x79, 0xfa, 0x73, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x1, 0x34, 0x64, 0xf5, 0x0,
    0x1, 0xbf, 0xff, 0xf4, 0xf5, 0x0, 0xb, 0xfa,
    0x54, 0x14, 0xf5, 0x0, 0xf, 0xa0, 0x0, 0x4,
    0xf5, 0x0, 0xf, 0xa0, 0x0, 0x5, 0xf5, 0x0,
    0xb, 0xf8, 0x45, 0x9f, 0xf5, 0x0, 0x1, 0xaf,
    0xff, 0xfd, 0xf5, 0x0, 0x0, 0x1, 0x33, 0x14,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,

    /* U+0936 "श" */
    0x0, 0x7e, 0xfd, 0x50, 0x9f, 0xff, 0xfe, 0x4,
    0xf8, 0x38, 0xf4, 0x47, 0xee, 0x76, 0x7, 0xf0,
    0x0, 0xdb, 0x0, 0xcd, 0x0, 0x4, 0xf9, 0x20,
    0xbd, 0x0, 0xcd, 0x0, 0x0, 0x7f, 0xf1, 0xcc,
    0x0, 0xcd, 0x0, 0x0, 0x0, 0x32, 0xf8, 0x0,
    0xcd, 0x0, 0x2d, 0xc2, 0xc, 0xe1, 0x0, 0xcd,
    0x0, 0x6f, 0xfe, 0xed, 0x30, 0x0, 0xcd, 0x0,
    0xa, 0xef, 0xd0, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0xa, 0xf7, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0xcf, 0x40, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x2f,
    0xe1, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x6, 0xd2,
    0x0, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0937 "ष" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x7b, 0xff,
    0xa7, 0x77, 0xee, 0x76, 0x6, 0xfd, 0xd0, 0x0,
    0xdc, 0x0, 0x6, 0xf4, 0xea, 0x0, 0xdc, 0x0,
    0x6, 0xf3, 0x3f, 0x60, 0xdc, 0x0, 0x6, 0xf3,
    0x7, 0xf3, 0xdc, 0x0, 0x6, 0xf3, 0x0, 0xae,
    0xec, 0x0, 0x3, 0xf7, 0x0, 0xe, 0xfc, 0x0,
    0x0, 0xdf, 0x64, 0x8f, 0xfc, 0x0, 0x0, 0x2d,
    0xff, 0xf9, 0xec, 0x0, 0x0, 0x0, 0x23, 0x10,
    0xdc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdc, 0x0,

    /* U+0938 "स" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x77,
    0x77, 0xdf, 0x77, 0x77, 0xfd, 0x76, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0xeb, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xeb, 0x0, 0xe, 0xd6, 0xfb, 0x0, 0x0,
    0xeb, 0x0, 0x1f, 0xff, 0xfe, 0x84, 0x47, 0xfb,
    0x0, 0xc, 0xfb, 0x4a, 0xff, 0xff, 0xfb, 0x0,
    0x3, 0xf8, 0x0, 0x3, 0x30, 0xeb, 0x0, 0x0,
    0x8f, 0x50, 0x0, 0x0, 0xeb, 0x0, 0x0, 0xc,
    0xf4, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x1, 0xdf,
    0x40, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x2e, 0x90,
    0x0, 0xeb, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0,

    /* U+0939 "ह" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0x77, 0x77,
    0x77, 0xee, 0x77, 0x0, 0x0, 0x0, 0xc, 0xd0,
    0x0, 0x0, 0x23, 0x33, 0xdd, 0x0, 0x2, 0xdf,
    0xff, 0xff, 0xd0, 0x0, 0x9f, 0x73, 0x33, 0x33,
    0x0, 0x7, 0xf2, 0x13, 0x30, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xf7, 0x0, 0x1, 0xfe, 0x74, 0x4b,
    0xf5, 0x0, 0x7f, 0x40, 0x0, 0xf, 0xa0, 0x9,
    0xf0, 0x0, 0x1, 0xf9, 0x0, 0x7f, 0x30, 0x1,
    0xdf, 0x40, 0x2, 0xfd, 0x20, 0x8, 0x60, 0x0,
    0x4, 0xff, 0x70, 0x0, 0x0, 0x0, 0x2, 0xcf,
    0xe5, 0x0, 0x0, 0x0, 0x0, 0x5c, 0x20, 0x0,

    /* U+093C "़" */
    0x26, 0xb, 0xf6, 0x6c, 0x20,

    /* U+093E "ा" */
    0xff, 0xff, 0xf7, 0x79, 0xfb, 0x73, 0x3, 0xf6,
    0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0, 0x3,
    0xf6, 0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0,
    0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6,
    0x0, 0x3, 0xf6, 0x0, 0x3, 0xf6, 0x0,

    /* U+093F "ि" */
    0x0, 0x2a, 0xef, 0xfc, 0x82, 0x0, 0x0, 0x0,
    0x3f, 0xfb, 0x88, 0xbf, 0xf9, 0x0, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0x7, 0xfd, 0x10, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x3, 0xed, 0x10, 0xd, 0xc0,
    0x0, 0x0, 0x0, 0x2, 0xec, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x0, 0x4, 0xf7, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x9f, 0xb7, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0940 "ी" */
    0x4, 0xdf, 0xe8, 0x0, 0x0, 0x1, 0xfe, 0x8a,
    0xf9, 0x0, 0x0, 0x5f, 0x60, 0x7, 0xf3, 0x0,
    0x6, 0xf3, 0x0, 0xe, 0x90, 0x0, 0x3f, 0x60,
    0x0, 0x9e, 0x0, 0x0, 0xeb, 0x0, 0x5, 0xf2,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x79, 0xfb, 0x73, 0x0, 0x0, 0x0, 0x3f,
    0x60, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60, 0x0,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0,

    /* U+0941 "ु" */
    0x0, 0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x1,
    0xbf, 0xff, 0x70, 0x4, 0x50, 0x2e, 0x73, 0xaf,
    0x20, 0xdf, 0x60, 0x0, 0x3, 0xf4, 0x1, 0xcf,
    0xc6, 0x45, 0xcf, 0x20, 0x0, 0x6d, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x2, 0x33, 0x0, 0x0,

    /* U+0942 "ू" */
    0x0, 0x2, 0x20, 0x0, 0x0, 0x9, 0xff, 0xfe,
    0x50, 0x0, 0x7f, 0x83, 0x5b, 0xf7, 0x0, 0xae,
    0x0, 0x0, 0xaf, 0x40, 0x7f, 0x74, 0x50, 0xd,
    0xd0, 0xb, 0xff, 0xf6, 0x5, 0xf6, 0x0, 0x23,
    0x20, 0x0, 0x81,

    /* U+0943 "ृ" */
    0x0, 0x7a, 0x30, 0x0, 0xcf, 0xc3, 0x0, 0x3f,
    0x60, 0x0, 0x4, 0xf3, 0x0, 0x0, 0x1f, 0xb4,
    0x5b, 0x20, 0x5f, 0xff, 0xf4, 0x0, 0x3, 0x30,
    0x0,

    /* U+0947 "े" */
    0x1, 0x42, 0x0, 0x0, 0x3f, 0xff, 0xc0, 0x0,
    0x7, 0x46, 0xf9, 0x0, 0x0, 0x0, 0x7f, 0x10,
    0x0, 0x0, 0x1f, 0x60, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0x0, 0x5, 0xb0,

    /* U+0948 "ै" */
    0x1, 0x31, 0x0, 0x0, 0xf, 0xff, 0xa0, 0x0,
    0x5, 0x46, 0xf7, 0x0, 0x13, 0x31, 0x5e, 0x0,
    0x4f, 0xff, 0x9d, 0x50, 0x3, 0x35, 0xcf, 0xb0,
    0x0, 0x0, 0x9, 0xb0,

    /* U+0949 "ॉ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x1,
    0xf5, 0xc, 0xd0, 0x0, 0x6f, 0x30, 0x5f, 0xa4,
    0x6f, 0xc0, 0x0, 0x7f, 0xff, 0xc2, 0x0, 0x0,
    0x3, 0x20, 0x0, 0x0, 0xf, 0xff, 0xff, 0x70,
    0x0, 0x79, 0xfb, 0x73, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x3f,
    0x60, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0x3f, 0x60, 0x0,

    /* U+094B "ो" */
    0xd, 0xff, 0x90, 0x0, 0x0, 0xa, 0x9a, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0x0, 0x5, 0xf2, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x79, 0xfb, 0x73,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0,
    0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,

    /* U+094D "्" */
    0x14, 0x20, 0x0, 0x7, 0xff, 0xd3, 0x0, 0x24,
    0x6c, 0xf4, 0x0, 0x0, 0xc, 0xe1, 0x0, 0x0,
    0x1e, 0x50, 0x0, 0x0, 0x0,

    /* U+0E01 "ก" */
    0x1, 0x9e, 0xff, 0xc6, 0x0, 0x1e, 0xfa, 0x78,
    0xdf, 0xa0, 0x9f, 0x60, 0x0, 0xc, 0xf3, 0x9f,
    0xa2, 0x0, 0x7, 0xf5, 0x4, 0xef, 0x30, 0x6,
    0xf6, 0x1d, 0xe5, 0x0, 0x6, 0xf6, 0x6f, 0x60,
    0x0, 0x6, 0xf6, 0x7f, 0x40, 0x0, 0x6, 0xf6,
    0x7f, 0x40, 0x0, 0x6, 0xf6, 0x7f, 0x40, 0x0,
    0x6, 0xf6, 0x7f, 0x40, 0x0, 0x6, 0xf6,

    /* U+0E02 "ข" */
    0xaf, 0xe6, 0x0, 0x7f, 0x56, 0x7e, 0xe0, 0x7,
    0xf5, 0x0, 0xde, 0x0, 0x7f, 0x50, 0x6f, 0x70,
    0x7, 0xf5, 0x1f, 0xd0, 0x0, 0x7f, 0x56, 0xf6,
    0x0, 0x7, 0xf5, 0x7f, 0x50, 0x0, 0x7f, 0x57,
    0xf5, 0x0, 0x7, 0xf4, 0x5f, 0x80, 0x0, 0xaf,
    0x30, 0xef, 0xa7, 0xaf, 0xd0, 0x1, 0xae, 0xfe,
    0xa1, 0x0,

    /* U+0E04 "ค" */
    0x0, 0x7d, 0xff, 0xe9, 0x10, 0xa, 0xfd, 0x87,
    0xbf, 0xe0, 0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x5f,
    0x70, 0x0, 0x3, 0xf9, 0x6f, 0x60, 0x12, 0x2,
    0xfa, 0x6f, 0x8d, 0xff, 0x2, 0xfa, 0x6f, 0xfb,
    0x65, 0x2, 0xfa, 0x6f, 0xb0, 0x0, 0x2, 0xfa,
    0x6f, 0x60, 0x0, 0x2, 0xfa, 0x6f, 0x60, 0x0,
    0x2, 0xfa, 0x6f, 0x60, 0x0, 0x2, 0xfa,

    /* U+0E07 "ง" */
    0xde, 0x2, 0xff, 0xd6, 0x0, 0x8f, 0x40, 0x66,
    0xcf, 0x90, 0x3f, 0x90, 0x0, 0xc, 0xf3, 0xe,
    0xe0, 0x0, 0x5, 0xf7, 0x9, 0xf3, 0x0, 0x2,
    0xfa, 0x4, 0xf8, 0x0, 0x2, 0xfa, 0x0, 0xfd,
    0x0, 0x4, 0xf8, 0x0, 0xaf, 0x20, 0x9, 0xf4,
    0x0, 0x5f, 0x70, 0x3f, 0xd0, 0x0, 0x1f, 0xd9,
    0xff, 0x30, 0x0, 0xb, 0xfe, 0xa2, 0x0,

    /* U+0E08 "จ" */
    0x8, 0xcf, 0xfe, 0xb3, 0x0, 0x3f, 0xb8, 0x79,
    0xff, 0x50, 0x11, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0xa, 0xf3, 0x0, 0x11, 0x0, 0x7,
    0xf5, 0x9, 0xff, 0xa0, 0x6, 0xf6, 0x2, 0x5f,
    0xa0, 0x7, 0xf6, 0x0, 0x1f, 0xa0, 0x9, 0xf3,
    0x0, 0x1f, 0xa0, 0x1e, 0xe0, 0x0, 0x1f, 0xc7,
    0xdf, 0x50, 0x0, 0x1f, 0xff, 0xb4, 0x0,

    /* U+0E09 "ฉ" */
    0x7, 0xce, 0xff, 0xc6, 0x0, 0x3f, 0xb8, 0x79,
    0xef, 0x90, 0x11, 0x0, 0x0, 0xd, 0xf1, 0x0,
    0x0, 0x0, 0x7, 0xf5, 0x14, 0x10, 0x0, 0x5,
    0xf7, 0x6f, 0x60, 0x0, 0x5, 0xf7, 0x6f, 0x60,
    0x0, 0x5, 0xf7, 0x5f, 0x60, 0x0, 0x7, 0xf7,
    0x4f, 0xa0, 0x0, 0x1e, 0xf7, 0xd, 0xfb, 0x89,
    0xeb, 0xf7, 0x1, 0xae, 0xfd, 0x80, 0xf7,

    /* U+0E0A "ช" */
    0xaf, 0xe6, 0x0, 0x4f, 0x85, 0x7e, 0xe0, 0x9,
    0xf4, 0x0, 0xde, 0xf, 0xf8, 0x0, 0x6f, 0x70,
    0x3d, 0xf1, 0x1f, 0xd0, 0x0, 0x7f, 0x46, 0xf6,
    0x0, 0x7, 0xf5, 0x7f, 0x50, 0x0, 0x7f, 0x57,
    0xf5, 0x0, 0x7, 0xf4, 0x5f, 0x80, 0x0, 0xaf,
    0x30, 0xef, 0xa7, 0xaf, 0xd0, 0x1, 0xae, 0xfe,
    0xa1, 0x0,

    /* U+0E0B "ซ" */
    0x1f, 0x80, 0xd5, 0x2, 0xfa, 0xd, 0xfe, 0xf5,
    0x8, 0xf6, 0x0, 0x49, 0xf2, 0xdf, 0xa0, 0x0,
    0x5f, 0x90, 0x2b, 0xf3, 0x1, 0xfd, 0x0, 0x5,
    0xf6, 0x4, 0xf7, 0x0, 0x5, 0xf7, 0x5, 0xf6,
    0x0, 0x5, 0xf7, 0x5, 0xf7, 0x0, 0x5, 0xf7,
    0x3, 0xfa, 0x0, 0x8, 0xf5, 0x0, 0xcf, 0xa7,
    0x9f, 0xe0, 0x0, 0x19, 0xef, 0xea, 0x10,

    /* U+0E13 "ณ" */
    0x2, 0xae, 0xfe, 0xb4, 0x0, 0x0, 0x5, 0xf6,
    0x2f, 0xf9, 0x79, 0xef, 0x40, 0x0, 0x5, 0xf6,
    0x9f, 0x50, 0x0, 0x2f, 0xc0, 0x0, 0x5, 0xf6,
    0x9f, 0xa3, 0x0, 0xd, 0xe0, 0x0, 0x5, 0xf6,
    0x2, 0xdf, 0x50, 0xd, 0xf0, 0x0, 0x5, 0xf6,
    0xd, 0xe5, 0x0, 0xd, 0xf0, 0x0, 0x5, 0xf6,
    0x4f, 0x80, 0x0, 0xd, 0xf0, 0x0, 0x5, 0xf6,
    0x5f, 0x70, 0x0, 0xd, 0xf0, 0x0, 0x8, 0xf6,
    0x5f, 0x70, 0x0, 0xc, 0xf3, 0x0, 0x1e, 0xf6,
    0x4f, 0xd8, 0x0, 0x6, 0xfe, 0x88, 0xea, 0xf6,
    0xa, 0xfe, 0x20, 0x0, 0x6d, 0xfe, 0x81, 0xf6,

    /* U+0E14 "ด" */
    0x0, 0x7d, 0xff, 0xe9, 0x20, 0xb, 0xfd, 0x87,
    0xaf, 0xe1, 0x4f, 0xb0, 0x0, 0x6, 0xf8, 0x9f,
    0x30, 0x0, 0x1, 0xfa, 0xcf, 0x0, 0x0, 0x1,
    0xfb, 0xcf, 0x0, 0x0, 0x1, 0xfb, 0xcf, 0x0,
    0x0, 0x1, 0xfb, 0x9f, 0x30, 0x0, 0x1, 0xfb,
    0x5f, 0x90, 0x0, 0x1, 0xfb, 0xd, 0xfb, 0x76,
    0x1, 0xfb, 0x1, 0xae, 0xfb, 0x1, 0xfb,

    /* U+0E15 "ต" */
    0x4, 0xdf, 0xc5, 0xdf, 0xd3, 0x1, 0xfe, 0x8c,
    0xfa, 0x8f, 0xd0, 0x6f, 0x60, 0x29, 0x0, 0xbf,
    0x1a, 0xf2, 0x0, 0x0, 0xb, 0xf1, 0xbf, 0x10,
    0x0, 0x0, 0xbf, 0x1b, 0xf0, 0x0, 0x0, 0xb,
    0xf1, 0xaf, 0x10, 0x0, 0x0, 0xbf, 0x18, 0xf3,
    0x0, 0x0, 0xb, 0xf1, 0x4f, 0xa0, 0x0, 0x0,
    0xbf, 0x10, 0xcf, 0xb7, 0x70, 0xb, 0xf1, 0x1,
    0x9e, 0xfe, 0x0, 0xbf, 0x10,

    /* U+0E16 "ถ" */
    0x1, 0x9e, 0xff, 0xc6, 0x0, 0x2e, 0xfa, 0x78,
    0xdf, 0xa0, 0x9f, 0x60, 0x0, 0xb, 0xf3, 0x9f,
    0xa3, 0x0, 0x6, 0xf6, 0x2, 0xdf, 0x50, 0x5,
    0xf6, 0xd, 0xe4, 0x0, 0x5, 0xf6, 0x4f, 0x70,
    0x0, 0x5, 0xf6, 0x5f, 0x70, 0x0, 0x5, 0xf6,
    0x5f, 0x70, 0x0, 0x5, 0xf6, 0x4f, 0xd7, 0x0,
    0x5, 0xf6, 0xa, 0xfe, 0x20, 0x5, 0xf6,

    /* U+0E17 "ท" */
    0x5f, 0x7, 0xdf, 0xfb, 0x20, 0x5f, 0xbe, 0x64,
    0x7f, 0xe1, 0x5f, 0xf1, 0x0, 0x7, 0xf6, 0x5f,
    0x90, 0x0, 0x3, 0xf8, 0x5f, 0x70, 0x0, 0x3,
    0xf9, 0x5f, 0x70, 0x0, 0x3, 0xf9, 0x5f, 0x70,
    0x0, 0x3, 0xf9, 0x5f, 0x70, 0x0, 0x3, 0xf9,
    0x5f, 0x70, 0x0, 0x3, 0xf9, 0x5f, 0x70, 0x0,
    0x3, 0xf9, 0x5f, 0x70, 0x0, 0x3, 0xf9,

    /* U+0E19 "น" */
    0x6f, 0x60, 0x0, 0x4, 0xf8, 0x6f, 0x60, 0x0,
    0x4, 0xf8, 0x6f, 0x60, 0x0, 0x4, 0xf8, 0x6f,
    0x60, 0x0, 0x4, 0xf8, 0x6f, 0x60, 0x0, 0x4,
    0xf8, 0x6f, 0x60, 0x0, 0x4, 0xf8, 0x6f, 0x60,
    0x0, 0x4, 0xf8, 0x5f, 0x70, 0x0, 0x7, 0xf8,
    0x3f, 0xb0, 0x0, 0x1e, 0xf8, 0xd, 0xfc, 0x89,
    0xeb, 0xf8, 0x1, 0xae, 0xfe, 0x80, 0xf8,

    /* U+0E1A "บ" */
    0x6f, 0x60, 0x0, 0x5, 0xf7, 0x6f, 0x60, 0x0,
    0x5, 0xf7, 0x6f, 0x60, 0x0, 0x5, 0xf7, 0x6f,
    0x60, 0x0, 0x5, 0xf7, 0x6f, 0x60, 0x0, 0x5,
    0xf7, 0x6f, 0x60, 0x0, 0x5, 0xf7, 0x6f, 0x60,
    0x0, 0x5, 0xf7, 0x5f, 0x70, 0x0, 0x5, 0xf6,
    0x2f, 0xc0, 0x0, 0xb, 0xf3, 0xa, 0xfc, 0x88,
    0xcf, 0xb0, 0x0, 0x8d, 0xff, 0xd8, 0x0,

    /* U+0E1B "ป" */
    0x0, 0x0, 0x0, 0x5, 0xf7, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0x5, 0xf7, 0x0,
    0x0, 0x0, 0x5, 0xf7, 0x6f, 0x60, 0x0, 0x5,
    0xf7, 0x6f, 0x60, 0x0, 0x5, 0xf7, 0x6f, 0x60,
    0x0, 0x5, 0xf7, 0x6f, 0x60, 0x0, 0x5, 0xf7,
    0x6f, 0x60, 0x0, 0x5, 0xf7, 0x6f, 0x60, 0x0,
    0x5, 0xf7, 0x6f, 0x60, 0x0, 0x5, 0xf7, 0x5f,
    0x70, 0x0, 0x5, 0xf6, 0x2f, 0xc0, 0x0, 0xb,
    0xf3, 0xa, 0xfc, 0x88, 0xcf, 0xb0, 0x0, 0x8d,
    0xff, 0xd8, 0x0,

    /* U+0E1C "ผ" */
    0x9, 0xff, 0x20, 0x0, 0x8f, 0x33, 0xfd, 0x71,
    0x0, 0x8, 0xf3, 0x4f, 0x70, 0x0, 0x0, 0x8f,
    0x34, 0xf7, 0x0, 0x10, 0x8, 0xf3, 0x4f, 0x70,
    0x6f, 0x50, 0x8f, 0x34, 0xf7, 0x1f, 0xfe, 0x8,
    0xf3, 0x4f, 0x79, 0xf3, 0xf8, 0x8f, 0x34, 0xf9,
    0xf6, 0x7, 0xf9, 0xf3, 0x4f, 0xfc, 0x0, 0xd,
    0xff, 0x34, 0xff, 0x30, 0x0, 0x4f, 0xf3, 0x4f,
    0x90, 0x0, 0x0, 0xaf, 0x30,

    /* U+0E1E "พ" */
    0x1f, 0xb0, 0x0, 0xec, 0x0, 0xd, 0xf0, 0xe,
    0xe0, 0x3, 0xff, 0x10, 0xf, 0xc0, 0xb, 0xf0,
    0x8, 0xff, 0x60, 0x2f, 0xa0, 0x8, 0xf3, 0xc,
    0xcd, 0xa0, 0x5f, 0x70, 0x6, 0xf6, 0x1f, 0x79,
    0xf0, 0x8f, 0x40, 0x3, 0xf8, 0x5f, 0x35, 0xf3,
    0xaf, 0x10, 0x0, 0xfa, 0xae, 0x0, 0xf8, 0xce,
    0x0, 0x0, 0xdc, 0xd9, 0x0, 0xbb, 0xdb, 0x0,
    0x0, 0xaf, 0xf4, 0x0, 0x6f, 0xf8, 0x0, 0x0,
    0x7f, 0xf0, 0x0, 0x1f, 0xf5, 0x0, 0x0, 0x4f,
    0xb0, 0x0, 0xc, 0xf2, 0x0,

    /* U+0E1F "ฟ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xb0, 0x1f, 0xb0, 0x0, 0xfb,
    0x0, 0x2f, 0x80, 0xe, 0xd0, 0x4, 0xff, 0x0,
    0x4f, 0x60, 0xc, 0xf0, 0x9, 0xef, 0x40, 0x6f,
    0x40, 0x9, 0xf2, 0xd, 0xae, 0x90, 0x8f, 0x10,
    0x6, 0xf4, 0x2f, 0x6b, 0xe0, 0xaf, 0x0, 0x3,
    0xf6, 0x7f, 0x26, 0xf2, 0xcd, 0x0, 0x1, 0xf8,
    0xbd, 0x1, 0xf6, 0xda, 0x0, 0x0, 0xea, 0xf8,
    0x0, 0xca, 0xf8, 0x0, 0x0, 0xbe, 0xf3, 0x0,
    0x7e, 0xf6, 0x0, 0x0, 0x8f, 0xe0, 0x0, 0x3f,
    0xf3, 0x0, 0x0, 0x5f, 0x90, 0x0, 0xe, 0xf1,
    0x0,

    /* U+0E20 "ภ" */
    0x0, 0x19, 0xef, 0xfc, 0x70, 0x0, 0x1e, 0xfa,
    0x78, 0xdf, 0xb0, 0x8, 0xf6, 0x0, 0x0, 0xbf,
    0x40, 0x8f, 0xb3, 0x0, 0x6, 0xf6, 0x0, 0x2d,
    0xf5, 0x0, 0x5f, 0x70, 0xc, 0xf5, 0x0, 0x5,
    0xf7, 0x1, 0xfb, 0x0, 0x0, 0x5f, 0x70, 0x2f,
    0xa0, 0x0, 0x5, 0xf7, 0x2, 0xfa, 0x0, 0x0,
    0x5f, 0x73, 0x9f, 0x90, 0x0, 0x5, 0xf7, 0x7f,
    0xd2, 0x0, 0x0, 0x5f, 0x70,

    /* U+0E21 "ม" */
    0x3f, 0x90, 0x0, 0x2, 0xfa, 0x3f, 0x90, 0x0,
    0x2, 0xfa, 0x3f, 0x90, 0x0, 0x2, 0xfa, 0x3f,
    0x90, 0x0, 0x2, 0xfa, 0x3f, 0x90, 0x0, 0x2,
    0xfa, 0x3f, 0x90, 0x0, 0x2, 0xfa, 0x3f, 0x90,
    0x0, 0x2, 0xfa, 0x3f, 0xc0, 0x0, 0x2, 0xfa,
    0x3f, 0xf4, 0x0, 0x7, 0xf8, 0x3f, 0xaf, 0xa8,
    0xaf, 0xf2, 0x3f, 0x45, 0xcf, 0xfb, 0x30,

    /* U+0E22 "ย" */
    0x8, 0xef, 0xf4, 0x8, 0xf4, 0x6f, 0xc7, 0x81,
    0x8, 0xf4, 0x9f, 0x30, 0x0, 0x8, 0xf4, 0x5f,
    0xa2, 0x0, 0x8, 0xf4, 0x5, 0xff, 0xf0, 0x8,
    0xf4, 0x2f, 0xe6, 0x30, 0x8, 0xf4, 0x7f, 0x50,
    0x0, 0x8, 0xf4, 0x9f, 0x40, 0x0, 0x8, 0xf3,
    0x7f, 0x80, 0x0, 0xc, 0xf1, 0x1e, 0xfa, 0x77,
    0xcf, 0xa0, 0x2, 0xae, 0xff, 0xd8, 0x0,

    /* U+0E23 "ร" */
    0x0, 0x8d, 0xff, 0xeb, 0x20, 0xbf, 0xb7, 0x78,
    0xc5, 0xf, 0xc0, 0x0, 0x0, 0x0, 0xfe, 0x20,
    0x0, 0x0, 0x6, 0xff, 0xb5, 0x0, 0x0, 0x3,
    0xaf, 0xff, 0x80, 0x0, 0x0, 0x16, 0xdf, 0x90,
    0x0, 0x0, 0x0, 0xef, 0x0, 0x0, 0x0, 0xe,
    0xe0, 0xec, 0x97, 0x8d, 0xf7, 0x7, 0xce, 0xff,
    0xc6, 0x0,

    /* U+0E25 "ล" */
    0x0, 0x7c, 0xef, 0xfc, 0x40, 0x2, 0xfc, 0x87,
    0x8e, 0xf3, 0x1, 0x30, 0x0, 0x3, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xfc, 0x0, 0x0, 0x1, 0x22,
    0xfc, 0x0, 0x7d, 0xff, 0xff, 0xfc, 0x8, 0xfd,
    0x75, 0x55, 0xfc, 0xf, 0xe0, 0x0, 0x0, 0xfc,
    0xf, 0xd0, 0x0, 0x0, 0xfc, 0xa, 0xf9, 0x44,
    0x0, 0xfc, 0x0, 0x9e, 0xff, 0x40, 0xfc,

    /* U+0E27 "ว" */
    0x1b, 0xef, 0xeb, 0x40, 0x2, 0xb8, 0x79, 0xff,
    0x50, 0x0, 0x0, 0x2, 0xff, 0x10, 0x0, 0x0,
    0x8, 0xf5, 0x0, 0x0, 0x0, 0x5f, 0x80, 0x0,
    0x0, 0x4, 0xf9, 0x0, 0x0, 0x0, 0x5f, 0x80,
    0x0, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x2, 0xff,
    0x0, 0xd9, 0x79, 0xff, 0x50, 0x9, 0xdf, 0xfc,
    0x40, 0x0,

    /* U+0E2A "ส" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0x50, 0x7, 0xce,
    0xff, 0xbb, 0xf6, 0x2, 0xfc, 0x87, 0x8e, 0xf7,
    0x0, 0x13, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x12, 0x2f,
    0xc0, 0x0, 0x7d, 0xff, 0xff, 0xfc, 0x0, 0x8f,
    0xd7, 0x55, 0x5f, 0xc0, 0xf, 0xe0, 0x0, 0x0,
    0xfc, 0x0, 0xfd, 0x0, 0x0, 0xf, 0xc0, 0xa,
    0xf9, 0x44, 0x0, 0xfc, 0x0, 0x9, 0xef, 0xf4,
    0xf, 0xc0,

    /* U+0E2B "ห" */
    0x3f, 0x90, 0x0, 0x5f, 0xc0, 0x3f, 0x90, 0x6,
    0xfc, 0x0, 0x3f, 0x90, 0x6f, 0xb0, 0x0, 0x3f,
    0x97, 0xff, 0xf9, 0x10, 0x3f, 0xef, 0xb5, 0xbf,
    0xb0, 0x3f, 0xfb, 0x0, 0xc, 0xf2, 0x3f, 0xb0,
    0x0, 0x7, 0xf5, 0x3f, 0x90, 0x0, 0x6, 0xf5,
    0x3f, 0x90, 0x0, 0x6, 0xf5, 0x3f, 0x90, 0x0,
    0x6, 0xf5, 0x3f, 0x90, 0x0, 0x6, 0xf5,

    /* U+0E2D "อ" */
    0x29, 0xdf, 0xfe, 0x91, 0x0, 0x7e, 0xa7, 0x7a,
    0xfe, 0x20, 0x20, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x0, 0xd, 0xf0, 0x11, 0x11, 0x0, 0xa,
    0xf2, 0xbf, 0xff, 0x80, 0x9, 0xf3, 0xcf, 0x44,
    0x20, 0xa, 0xf2, 0xbf, 0x0, 0x0, 0xc, 0xf0,
    0x8f, 0x50, 0x0, 0x3f, 0xb0, 0x1f, 0xf8, 0x69,
    0xff, 0x30, 0x2, 0xae, 0xfe, 0xb3, 0x0,

    /* U+0E2E "ฮ" */
    0x0, 0x0, 0x0, 0x0, 0x85, 0x29, 0xdf, 0xfe,
    0x9a, 0xf6, 0x7e, 0xa7, 0x7a, 0xff, 0x60, 0x20,
    0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0x0, 0xd,
    0xf0, 0x11, 0x11, 0x0, 0xa, 0xf2, 0xbf, 0xff,
    0x80, 0x9, 0xf3, 0xcf, 0x44, 0x20, 0xa, 0xf2,
    0xbf, 0x0, 0x0, 0xc, 0xf0, 0x8f, 0x50, 0x0,
    0x3f, 0xb0, 0x1f, 0xf8, 0x69, 0xff, 0x30, 0x2,
    0xae, 0xfe, 0xb3, 0x0,

    /* U+0E30 "ะ" */
    0x7, 0x30, 0x0, 0x3f, 0x91, 0x11, 0xd, 0xff,
    0xff, 0x0, 0x34, 0x44, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0x40, 0x0, 0x3f, 0x91, 0x11,
    0xd, 0xff, 0xff, 0x0, 0x34, 0x44,

    /* U+0E31 "ั" */
    0x37, 0x0, 0x0, 0x0, 0x9f, 0x31, 0x11, 0x11,
    0x4f, 0xff, 0xff, 0xfd, 0x1, 0x44, 0x44, 0x43,

    /* U+0E32 "า" */
    0x7d, 0xff, 0xd5, 0xb, 0xa7, 0x8f, 0xf2, 0x0,
    0x0, 0x6f, 0x70, 0x0, 0x4, 0xf8, 0x0, 0x0,
    0x4f, 0x80, 0x0, 0x4, 0xf8, 0x0, 0x0, 0x4f,
    0x80, 0x0, 0x4, 0xf8, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x4, 0xf8, 0x0, 0x0, 0x4f, 0x80,

    /* U+0E33 "ำ" */
    0x9, 0xed, 0x50, 0x0, 0x0, 0x0, 0x4, 0xf1,
    0x6e, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x16, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0xd5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xdf, 0xfd, 0x50, 0x0,
    0x0, 0x0, 0xba, 0x78, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf8,

    /* U+0E34 "ิ" */
    0x0, 0x11, 0x11, 0x11, 0x10, 0x2c, 0xff, 0xff,
    0xff, 0xf3, 0x14, 0x44, 0x44, 0x44, 0x41,

    /* U+0E35 "ี" */
    0x0, 0x0, 0x0, 0x4, 0xb2, 0x0, 0x11, 0x11,
    0x18, 0xf3, 0x2d, 0xff, 0xff, 0xff, 0xf3, 0x14,
    0x44, 0x44, 0x44, 0x41,

    /* U+0E36 "ึ" */
    0x0, 0x0, 0x0, 0xae, 0xb1, 0x0, 0x11, 0x15,
    0xd0, 0xa7, 0x2d, 0xff, 0xff, 0xf9, 0xe3, 0x14,
    0x44, 0x44, 0x44, 0x20,

    /* U+0E37 "ื" */
    0x0, 0x0, 0x1b, 0x32, 0xb2, 0x0, 0x11, 0x4f,
    0x65, 0xf3, 0x2d, 0xff, 0xff, 0xff, 0xf3, 0x14,
    0x44, 0x44, 0x44, 0x41,

    /* U+0E38 "ุ" */
    0x3d, 0xb0, 0x2a, 0xf3, 0x6, 0xf3, 0x6, 0xf3,

    /* U+0E39 "ู" */
    0x8c, 0x30, 0x4d, 0x25, 0xf8, 0x5, 0xf3, 0xf,
    0xb0, 0x8f, 0x20, 0x7f, 0xff, 0xa0, 0x0, 0x2,
    0x10, 0x0,

    /* U+0E40 "เ" */
    0x1f, 0xb0, 0x1, 0xfb, 0x0, 0x1f, 0xb0, 0x1,
    0xfb, 0x0, 0x1f, 0xb0, 0x1, 0xfb, 0x0, 0x1f,
    0xb0, 0x1, 0xfb, 0x0, 0x1f, 0xb0, 0x0, 0xfe,
    0x73, 0x6, 0xef, 0x60,

    /* U+0E41 "แ" */
    0x1f, 0xb0, 0x0, 0xaf, 0x20, 0x1f, 0xb0, 0x0,
    0xaf, 0x20, 0x1f, 0xb0, 0x0, 0xaf, 0x20, 0x1f,
    0xb0, 0x0, 0xaf, 0x20, 0x1f, 0xb0, 0x0, 0xaf,
    0x20, 0x1f, 0xb0, 0x0, 0xaf, 0x20, 0x1f, 0xb0,
    0x0, 0xaf, 0x20, 0x1f, 0xb0, 0x0, 0xaf, 0x20,
    0x1f, 0xb0, 0x0, 0xaf, 0x20, 0xf, 0xe7, 0x30,
    0x8f, 0xa6, 0x6, 0xef, 0x60, 0x1c, 0xfd,

    /* U+0E42 "โ" */
    0x7e, 0xff, 0xff, 0xf5, 0xcf, 0x86, 0x66, 0x0,
    0xec, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0xd, 0xf0, 0x0, 0x0, 0xdf, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0xbf, 0x95, 0x0, 0x3, 0xdf, 0xa0,

    /* U+0E43 "ใ" */
    0x6e, 0xfe, 0x80, 0x78, 0x7c, 0xf5, 0x0, 0x4,
    0xf7, 0x0, 0x9, 0xf3, 0x0, 0x5f, 0x90, 0x1,
    0xfc, 0x0, 0x4, 0xf8, 0x0, 0x4, 0xf8, 0x0,
    0x4, 0xf8, 0x0, 0x4, 0xf8, 0x0, 0x4, 0xf8,
    0x0, 0x4, 0xf8, 0x0, 0x4, 0xf8, 0x0, 0x4,
    0xf8, 0x0, 0x3, 0xfd, 0x71, 0x0, 0x9f, 0xf3,

    /* U+0E44 "ไ" */
    0xf, 0xff, 0xff, 0xd1, 0x66, 0x7f, 0xd6, 0x0,
    0x9, 0xf2, 0x0, 0x0, 0xcf, 0x0, 0x0, 0xc,
    0xf0, 0x0, 0x0, 0xdf, 0x0, 0x0, 0xd, 0xf0,
    0x0, 0x0, 0xcf, 0x0, 0x0, 0xc, 0xf0, 0x0,
    0x0, 0xcf, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0,
    0xcf, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0, 0xcf,
    0x0, 0x0, 0xb, 0xf9, 0x50, 0x0, 0x3d, 0xfa,

    /* U+0E47 "็" */
    0x3d, 0xff, 0xff, 0xf0, 0xdc, 0x33, 0x33, 0x30,
    0xea, 0x2d, 0x36, 0xf0, 0x6f, 0xf8, 0xff, 0xa0,
    0x0, 0x20, 0x12, 0x0,

    /* U+0E48 "่" */
    0x12, 0x9, 0xf3, 0x9f, 0x39, 0xf3, 0x9f, 0x30,

    /* U+0E49 "้" */
    0x0, 0x10, 0x0, 0x3, 0xff, 0x90, 0x0, 0x6,
    0xcf, 0x0, 0x0, 0xc, 0xd1, 0x11, 0x3e, 0xff,
    0xff, 0xd1, 0x44, 0x44, 0x43,

    /* U+0E4C "์" */
    0x0, 0x11, 0x10, 0x1d, 0xff, 0xf7, 0x5f, 0x94,
    0x41, 0x2a, 0x30, 0x0,

    /* U+1EA1 "ạ" */
    0x0, 0x4a, 0xef, 0xfc, 0x40, 0x0, 0xbe, 0x97,
    0x9f, 0xf2, 0x0, 0x20, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0x6b, 0xef, 0xff, 0xf9, 0x8, 0xfc,
    0x53, 0x35, 0xf9, 0xf, 0xe0, 0x0, 0x3, 0xf9,
    0xf, 0xc0, 0x0, 0x8, 0xf9, 0xb, 0xf8, 0x45,
    0xad, 0xf9, 0x1, 0xae, 0xfe, 0x90, 0xc9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0,

    /* U+1EA3 "ả" */
    0x0, 0x0, 0xee, 0xb1, 0x0, 0x0, 0x0, 0x23,
    0xd8, 0x0, 0x0, 0x0, 0x1, 0xe8, 0x0, 0x0,
    0x0, 0x3f, 0xb1, 0x0, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4a,
    0xef, 0xfc, 0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2,
    0x0, 0x20, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x6b, 0xef, 0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35,
    0xf9, 0xf, 0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0,
    0x0, 0x8, 0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9,
    0x1, 0xae, 0xfe, 0x90, 0xc9,

    /* U+1EA5 "ấ" */
    0x0, 0x0, 0x0, 0x0, 0x7, 0x60, 0x0, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0xbf, 0xd1, 0xd4,
    0x0, 0x0, 0x8e, 0x6e, 0xa0, 0x0, 0x0, 0x4b,
    0x20, 0x1a, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4a, 0xef, 0xfc, 0x40, 0x0, 0xb,
    0xe9, 0x79, 0xff, 0x20, 0x0, 0x20, 0x0, 0x7,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x6, 0xbe, 0xff,
    0xff, 0x90, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0x0,
    0xfe, 0x0, 0x0, 0x3f, 0x90, 0xf, 0xc0, 0x0,
    0x8, 0xf9, 0x0, 0xbf, 0x84, 0x5a, 0xdf, 0x90,
    0x1, 0xae, 0xfe, 0x90, 0xc9, 0x0,

    /* U+1EA7 "ầ" */
    0x48, 0x10, 0x0, 0x0, 0x0, 0x1e, 0x90, 0x0,
    0x0, 0x0, 0x2, 0xc2, 0xbf, 0xd1, 0x0, 0x0,
    0x8, 0xe6, 0xdb, 0x0, 0x0, 0x3b, 0x20, 0xa,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4a,
    0xef, 0xfc, 0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2,
    0x0, 0x20, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x6b, 0xef, 0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35,
    0xf9, 0xf, 0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0,
    0x0, 0x8, 0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9,
    0x1, 0xae, 0xfe, 0x90, 0xc9,

    /* U+1EAD "ậ" */
    0x0, 0x0, 0xaf, 0xd1, 0x0, 0x0, 0x8, 0xf8,
    0xec, 0x0, 0x0, 0x6d, 0x30, 0x1b, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc,
    0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2, 0x0, 0x20,
    0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x6b, 0xef,
    0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35, 0xf9, 0xf,
    0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0, 0x0, 0x8,
    0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9, 0x1, 0xae,
    0xfe, 0x90, 0xc9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x50, 0x0, 0x0, 0x0, 0x7f,
    0x60, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,

    /* U+1EAF "ắ" */
    0x0, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0xc,
    0x90, 0x0, 0x0, 0x4c, 0x1, 0x9, 0x70, 0x0,
    0x1f, 0x51, 0x4f, 0x30, 0x0, 0x6, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x13, 0x10, 0x0, 0x0, 0x4a,
    0xef, 0xfc, 0x40, 0x0, 0xbe, 0x97, 0x9f, 0xf2,
    0x0, 0x20, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0,
    0x6b, 0xef, 0xff, 0xf9, 0x8, 0xfc, 0x53, 0x35,
    0xf9, 0xf, 0xe0, 0x0, 0x3, 0xf9, 0xf, 0xc0,
    0x0, 0x8, 0xf9, 0xb, 0xf8, 0x45, 0xad, 0xf9,
    0x1, 0xae, 0xfe, 0x90, 0xc9,

    /* U+1EBB "ẻ" */
    0x0, 0x7, 0xed, 0x60, 0x0, 0x0, 0x1, 0x28,
    0xf0, 0x0, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0,
    0x0, 0xbe, 0x60, 0x0, 0x0, 0x0, 0xb7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6d,
    0xff, 0xb4, 0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50,
    0x4f, 0x80, 0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11,
    0x1a, 0xf3, 0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef,
    0x44, 0x44, 0x44, 0x41, 0xdf, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1,
    0x0, 0x0, 0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0,
    0x0, 0x5b, 0xff, 0xeb, 0x50,

    /* U+1EBD "ẽ" */
    0x0, 0x0, 0x1, 0x10, 0x0, 0x7, 0xef, 0xff,
    0xff, 0x20, 0x4, 0x66, 0x55, 0x41, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4,
    0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80,
    0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3,
    0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44,
    0x44, 0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0,
    0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b,
    0xff, 0xeb, 0x50,

    /* U+1EBF "ế" */
    0x0, 0x0, 0x0, 0x0, 0x67, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x0, 0x7, 0xff, 0x2b, 0x80,
    0x0, 0x4, 0xf7, 0xcd, 0x10, 0x0, 0x1, 0xb4,
    0x0, 0x88, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0xff, 0xb4, 0x0, 0x0, 0x9f,
    0xb7, 0x8d, 0xf5, 0x0, 0x4f, 0x80, 0x0, 0x1e,
    0xe0, 0xa, 0xf2, 0x11, 0x11, 0xaf, 0x30, 0xdf,
    0xff, 0xff, 0xff, 0xf4, 0xe, 0xf4, 0x44, 0x44,
    0x44, 0x10, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0,
    0x0, 0x20, 0x0, 0x8f, 0xe9, 0x89, 0xdc, 0x0,
    0x0, 0x5b, 0xff, 0xeb, 0x50, 0x0,

    /* U+1EC3 "ể" */
    0x0, 0x0, 0x0, 0x3d, 0xb1, 0x0, 0x0, 0x0,
    0x0, 0xb6, 0x0, 0x0, 0x0, 0x6, 0xd2, 0x0,
    0x9, 0xfe, 0x1b, 0x20, 0x0, 0x6f, 0x6c, 0xc0,
    0x0, 0x2, 0xc3, 0x0, 0x97, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4, 0x0,
    0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80, 0x0,
    0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3, 0xdf,
    0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44, 0x44,
    0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x50,
    0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0, 0x20,
    0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b, 0xff,
    0xeb, 0x50,

    /* U+1EC7 "ệ" */
    0x0, 0x8, 0xfe, 0x10, 0x0, 0x0, 0x7f, 0x8e,
    0xd1, 0x0, 0x5, 0xd4, 0x1, 0xab, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb4,
    0x0, 0x9, 0xfb, 0x78, 0xdf, 0x50, 0x4f, 0x80,
    0x0, 0x1e, 0xe0, 0xaf, 0x21, 0x11, 0x1a, 0xf3,
    0xdf, 0xff, 0xff, 0xff, 0xf4, 0xef, 0x44, 0x44,
    0x44, 0x41, 0xdf, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0x4f, 0xd1, 0x0, 0x0,
    0x20, 0x8, 0xfe, 0x98, 0x9d, 0xc0, 0x0, 0x5b,
    0xff, 0xeb, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,

    /* U+1ECB "ị" */
    0x4f, 0x65, 0xf8, 0x3, 0x0, 0x0, 0x4f, 0x74,
    0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f,
    0x74, 0xf7, 0x4f, 0x74, 0xf7, 0x4f, 0x70, 0x0,
    0x4f, 0x65, 0xf8, 0x3, 0x0,

    /* U+1ED1 "ố" */
    0x0, 0x0, 0x0, 0x0, 0x48, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xa0, 0x0, 0x4, 0xff, 0x57, 0xa0,
    0x0, 0x2, 0xe9, 0x9f, 0x20, 0x0, 0x0, 0xa6,
    0x0, 0x6b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6c, 0xff, 0xd6, 0x0, 0x0, 0x9f,
    0xd8, 0x8c, 0xfa, 0x0, 0x4f, 0xb0, 0x0, 0xa,
    0xf5, 0xa, 0xf3, 0x0, 0x0, 0x1f, 0xc0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xe, 0xe0, 0x0, 0x0,
    0xc, 0xf0, 0xdf, 0x0, 0x0, 0x0, 0xdf, 0xa,
    0xf3, 0x0, 0x0, 0x1f, 0xc0, 0x3f, 0xb0, 0x0,
    0xa, 0xf5, 0x0, 0x8f, 0xd8, 0x8c, 0xfa, 0x0,
    0x0, 0x5c, 0xff, 0xc6, 0x0, 0x0,

    /* U+1ED3 "ồ" */
    0x18, 0x50, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x88, 0x3f, 0xf6,
    0x0, 0x0, 0x0, 0x2, 0xea, 0x8f, 0x30, 0x0,
    0x0, 0xa, 0x60, 0x5, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xcf, 0xfd,
    0x60, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa, 0x0,
    0x4, 0xfb, 0x0, 0x0, 0xaf, 0x50, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xd, 0xf0, 0x0, 0x0,
    0xd, 0xf0, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0,
    0xd, 0xf0, 0x0, 0x0, 0xd, 0xf0, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0x3, 0xfb, 0x0, 0x0,
    0xaf, 0x50, 0x0, 0x8f, 0xd8, 0x8c, 0xfa, 0x0,
    0x0, 0x5, 0xcf, 0xfc, 0x60, 0x0,

    /* U+1ED7 "ỗ" */
    0x0, 0x5f, 0xd5, 0x1d, 0x10, 0x0, 0xe, 0x57,
    0xef, 0xa0, 0x0, 0x0, 0x20, 0x0, 0x20, 0x0,
    0x0, 0x0, 0x4f, 0xf5, 0x0, 0x0, 0x0, 0x3f,
    0x76, 0xf4, 0x0, 0x0, 0x8, 0x30, 0x2, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xcf, 0xfd, 0x60, 0x0, 0x9, 0xfd, 0x88, 0xcf,
    0xa0, 0x4, 0xfb, 0x0, 0x0, 0xaf, 0x50, 0xaf,
    0x30, 0x0, 0x1, 0xfc, 0xd, 0xf0, 0x0, 0x0,
    0xd, 0xf0, 0xee, 0x0, 0x0, 0x0, 0xcf, 0xd,
    0xf0, 0x0, 0x0, 0xd, 0xf0, 0xaf, 0x30, 0x0,
    0x1, 0xfc, 0x3, 0xfb, 0x0, 0x0, 0xaf, 0x50,
    0x8, 0xfd, 0x88, 0xcf, 0xa0, 0x0, 0x5, 0xcf,
    0xfc, 0x60, 0x0,

    /* U+1ED9 "ộ" */
    0x0, 0x3, 0xff, 0x50, 0x0, 0x0, 0x2, 0xeb,
    0xaf, 0x40, 0x0, 0x1, 0xd8, 0x0, 0x6d, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6c,
    0xff, 0xd6, 0x0, 0x0, 0x9f, 0xd8, 0x8c, 0xfa,
    0x0, 0x4f, 0xb0, 0x0, 0xa, 0xf5, 0xa, 0xf3,
    0x0, 0x0, 0x1f, 0xc0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0xe, 0xe0, 0x0, 0x0, 0xc, 0xf0, 0xdf,
    0x0, 0x0, 0x0, 0xdf, 0xa, 0xf3, 0x0, 0x0,
    0x1f, 0xc0, 0x3f, 0xb0, 0x0, 0xa, 0xf5, 0x0,
    0x8f, 0xd8, 0x8c, 0xfa, 0x0, 0x0, 0x5c, 0xff,
    0xc6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,
    0x0,

    /* U+1EDB "ớ" */
    0x0, 0x0, 0x8, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0,
    0x0, 0x54, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x6c, 0xff, 0xc6, 0x6, 0xf6, 0x9, 0xfd,
    0x88, 0xcf, 0xcf, 0xb0, 0x4f, 0xb0, 0x0, 0x9,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x1, 0xfb, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0xee, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0xaf, 0x30, 0x0, 0x1, 0xfc, 0x0,
    0x3f, 0xb0, 0x0, 0x9, 0xf6, 0x0, 0x8, 0xfd,
    0x88, 0xcf, 0xb0, 0x0, 0x0, 0x5c, 0xff, 0xc7,
    0x0, 0x0,

    /* U+1EDD "ờ" */
    0x0, 0x4f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4d, 0x30,
    0x0, 0x54, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x6c, 0xff, 0xc6, 0x6, 0xf6, 0x9, 0xfd,
    0x88, 0xcf, 0xcf, 0xb0, 0x4f, 0xb0, 0x0, 0x9,
    0xf9, 0x0, 0xaf, 0x30, 0x0, 0x1, 0xfb, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0xee, 0x0,
    0x0, 0x0, 0xcf, 0x0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0xaf, 0x30, 0x0, 0x1, 0xfc, 0x0,
    0x3f, 0xb0, 0x0, 0x9, 0xf6, 0x0, 0x8, 0xfd,
    0x88, 0xcf, 0xb0, 0x0, 0x0, 0x5c, 0xff, 0xc7,
    0x0, 0x0,

    /* U+1EDF "ở" */
    0x0, 0x7, 0xed, 0x50, 0x0, 0x0, 0x0, 0x1,
    0x28, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xc6, 0x0, 0x0, 0x98, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfb, 0x0, 0x6c, 0xff, 0xc6,
    0x6, 0xf5, 0x9, 0xfd, 0x88, 0xcf, 0xcf, 0xb0,
    0x4f, 0xb0, 0x0, 0x9, 0xf9, 0x0, 0xaf, 0x30,
    0x0, 0x1, 0xfb, 0x0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0xee, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0xaf, 0x30,
    0x0, 0x1, 0xfc, 0x0, 0x3f, 0xb0, 0x0, 0x9,
    0xf6, 0x0, 0x8, 0xfd, 0x88, 0xcf, 0xb0, 0x0,
    0x0, 0x5c, 0xff, 0xc7, 0x0, 0x0,

    /* U+1EE3 "ợ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x87, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfb, 0x0, 0x6c, 0xff, 0xc6,
    0x6, 0xf5, 0x9, 0xfd, 0x88, 0xcf, 0xcf, 0xb0,
    0x4f, 0xb0, 0x0, 0x9, 0xf9, 0x0, 0xaf, 0x30,
    0x0, 0x1, 0xfb, 0x0, 0xdf, 0x0, 0x0, 0x0,
    0xdf, 0x0, 0xee, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0xdf, 0x0, 0x0, 0x0, 0xdf, 0x0, 0xaf, 0x30,
    0x0, 0x1, 0xfc, 0x0, 0x3f, 0xb0, 0x0, 0x9,
    0xf6, 0x0, 0x8, 0xfd, 0x88, 0xcf, 0xb0, 0x0,
    0x0, 0x5c, 0xff, 0xc7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0,

    /* U+1EE5 "ụ" */
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f,
    0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1,
    0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50,
    0x0, 0x2, 0xfa, 0x6f, 0x60, 0x0, 0x4, 0xfa,
    0x4f, 0xa0, 0x0, 0xa, 0xfa, 0xd, 0xf8, 0x45,
    0xad, 0xfa, 0x1, 0xae, 0xfe, 0x91, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xeb, 0x0,
    0x0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x21, 0x0, 0x0,

    /* U+1EE7 "ủ" */
    0x0, 0x4, 0xed, 0x80, 0x0, 0x0, 0x1, 0x26,
    0xf3, 0x0, 0x0, 0x0, 0x6, 0xf2, 0x0, 0x0,
    0x0, 0xae, 0x50, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa,
    0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x6f,
    0x50, 0x0, 0x1, 0xfa, 0x6f, 0x50, 0x0, 0x2,
    0xfa, 0x6f, 0x60, 0x0, 0x4, 0xfa, 0x4f, 0xa0,
    0x0, 0xa, 0xfa, 0xd, 0xf8, 0x45, 0xad, 0xfa,
    0x1, 0xae, 0xfe, 0x91, 0xda,

    /* U+1EED "ử" */
    0x0, 0x4, 0xee, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x25, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9e,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0xa, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0x6f, 0x50, 0x0, 0x1, 0xfa, 0x4f,
    0x80, 0x6f, 0x50, 0x0, 0x1, 0xff, 0xfc, 0x0,
    0x6f, 0x50, 0x0, 0x1, 0xfd, 0x50, 0x0, 0x6f,
    0x50, 0x0, 0x1, 0xfa, 0x0, 0x0, 0x6f, 0x50,
    0x0, 0x1, 0xfa, 0x0, 0x0, 0x6f, 0x50, 0x0,
    0x1, 0xfa, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x2,
    0xfa, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x4, 0xfa,
    0x0, 0x0, 0x4f, 0xa0, 0x0, 0xb, 0xfa, 0x0,
    0x0, 0xd, 0xf8, 0x45, 0xad, 0xfa, 0x0, 0x0,
    0x1, 0xae, 0xfe, 0x91, 0xda, 0x0, 0x0,

    /* U+200C "‌" */

    /* U+3001 "、" */
    0x4, 0x0, 0x0, 0xaf, 0x70, 0x0, 0x2d, 0xf8,
    0x0, 0x1, 0xdf, 0x70, 0x0, 0x1d, 0xf6, 0x0,
    0x2, 0xd3, 0x0, 0x0, 0x0,

    /* U+3002 "。" */
    0x0, 0x8d, 0xc6, 0x0, 0xab, 0x34, 0xd7, 0x1f,
    0x0, 0x3, 0xd1, 0xe0, 0x0, 0x2e, 0xb, 0x91,
    0x2b, 0x80, 0x1a, 0xfe, 0x80,

    /* U+3044 "い" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0,
    0x0, 0x4f, 0x60, 0x0, 0x0, 0x0, 0x4, 0xf9,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf2, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x10, 0x2f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf6, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x0, 0xdc, 0x0, 0x0,
    0x41, 0x0, 0x0, 0x8, 0xf2, 0xa, 0xf0, 0x0,
    0xb, 0xc0, 0x0, 0x0, 0x5f, 0x50, 0x6f, 0x60,
    0x2, 0xf9, 0x0, 0x0, 0x3, 0xe4, 0x0, 0xfe,
    0x10, 0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfe, 0xdf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3046 "う" */
    0x0, 0x8, 0x64, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xed, 0xc5, 0x0, 0x0, 0x0,
    0x14, 0x67, 0x9a, 0xb4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x26, 0x9c, 0xff, 0xfe,
    0x91, 0x0, 0x7f, 0xff, 0xeb, 0x87, 0x7b, 0xfe,
    0x20, 0x5d, 0x73, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x2c,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x4a, 0xff, 0x70,
    0x0, 0x0, 0x7, 0xcf, 0xff, 0xa2, 0x0, 0x0,
    0x0, 0x4, 0xea, 0x61, 0x0, 0x0, 0x0,

    /* U+3048 "え" */
    0x0, 0x0, 0x98, 0x63, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xfd, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x13, 0x57, 0x9b, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x26, 0x67, 0x89, 0xab, 0xce,
    0xf3, 0x0, 0x0, 0x4, 0xff, 0xff, 0xdc, 0xbe,
    0xfb, 0x10, 0x0, 0x0, 0x13, 0x10, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0x92, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfd, 0xaf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x0, 0x2, 0xf7, 0x0, 0x0, 0x0, 0x6,
    0xfc, 0x0, 0x0, 0xe, 0xd0, 0x0, 0x2, 0x5,
    0xfd, 0x10, 0x0, 0x0, 0x7f, 0xfd, 0xef, 0xf1,
    0x8, 0x20, 0x0, 0x0, 0x0, 0x6a, 0xba, 0x97,
    0x0,

    /* U+304A "お" */
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x1, 0x0,
    0x82, 0x0, 0x0, 0x34, 0x33, 0xaf, 0x8a, 0xdf,
    0x21, 0xdf, 0x90, 0x0, 0x8f, 0xff, 0xff, 0xfd,
    0xa7, 0x0, 0x7, 0xfe, 0x40, 0x13, 0x33, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xc0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,
    0x0, 0x8e, 0x0, 0x24, 0x43, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xcf, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x19, 0xff, 0xa6, 0x31, 0x13, 0x9f,
    0xa0, 0x0, 0x3, 0xee, 0xcf, 0x0, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x3f, 0xb1, 0x7f, 0x0, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0xbd, 0x0, 0x7f, 0x0,
    0x0, 0x0, 0x5, 0xf4, 0x0, 0xec, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0x1d, 0xf0, 0x0, 0x8f, 0x82,
    0x9f, 0x0, 0x1, 0x38, 0xef, 0x50, 0x0, 0x8,
    0xff, 0xfd, 0x0, 0xcf, 0xff, 0xc4, 0x0, 0x0,
    0x0, 0x28, 0x92, 0x0, 0x47, 0x62, 0x0, 0x0,
    0x0,

    /* U+304B "か" */
    0x0, 0x0, 0x1, 0x95, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x30, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x12,
    0x3a, 0xf7, 0x88, 0x60, 0x1, 0xed, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xed, 0xef, 0xd0, 0x6, 0xf5,
    0x0, 0x39, 0x75, 0x4f, 0x80, 0x0, 0x7f, 0x50,
    0xd, 0xd0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x1,
    0xf7, 0x0, 0x6f, 0x50, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0xf, 0x70, 0x0, 0xfc, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x1, 0xf7, 0x0, 0x9, 0xf2, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x22,
    0x0, 0x0, 0xce, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x8f,
    0x10, 0x0, 0x0, 0x0, 0xa, 0xf2, 0x0, 0x0,
    0xc, 0xd0, 0x0, 0x0, 0x0, 0x3, 0xfa, 0x0,
    0x30, 0x6, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x20, 0x1f, 0xff, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x3, 0x50, 0x0, 0x58, 0x97, 0x10, 0x0, 0x0,
    0x0, 0x0,

    /* U+304C "が" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xb1, 0x0, 0x0, 0x0, 0x39, 0x30, 0x0, 0x0,
    0x3d, 0x1a, 0xb0, 0x0, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x0, 0xc9, 0x1f, 0x40, 0x0, 0x0, 0x8f,
    0x10, 0x0, 0x0, 0x3, 0xf1, 0x20, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0xb, 0xc1, 0x0, 0x0,
    0x1, 0x23, 0xde, 0x78, 0x84, 0x0, 0x5f, 0x70,
    0x0, 0xaf, 0xff, 0xff, 0xfe, 0xdf, 0xf9, 0x0,
    0xce, 0x10, 0x5, 0x86, 0x47, 0xf4, 0x0, 0xb,
    0xf1, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x5f, 0x30, 0xb, 0xf0, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0x5, 0xf3, 0x0, 0x4f, 0x70, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x5f, 0x20, 0x0, 0xed,
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x7, 0xf1, 0x0,
    0x5, 0x20, 0x0, 0xf, 0xa0, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xf4, 0x0, 0x0,
    0xc, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xed, 0x0,
    0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x11, 0x0, 0x9f, 0x40, 0x0, 0x0, 0x0,
    0x1f, 0xd0, 0x5, 0xff, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x64, 0x0, 0x17, 0x99, 0x70, 0x0,
    0x0, 0x0, 0x0,

    /* U+304D "き" */
    0x0, 0x0, 0x0, 0x4d, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf6, 0x0, 0x24, 0x0, 0x49,
    0x87, 0x66, 0x6f, 0xdb, 0xef, 0xe0, 0x4, 0xde,
    0xef, 0xff, 0xff, 0xb8, 0x51, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x90, 0x2, 0x60, 0x67, 0x65, 0x55,
    0x66, 0xcf, 0xbe, 0xff, 0x1a, 0xff, 0xff, 0xff,
    0xfe, 0xfd, 0x85, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x80, 0x0, 0x5, 0x60, 0x0, 0x3, 0x75,
    0xbf, 0x30, 0x0, 0xea, 0x0, 0x0, 0x5c, 0xef,
    0xf6, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x2,
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xfb, 0x98, 0x88, 0xac, 0x80, 0x0,
    0x0, 0x29, 0xcf, 0xff, 0xfe, 0xc6, 0x0, 0x0,

    /* U+304F "く" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xb0, 0x0, 0x0, 0x0, 0x1c, 0xf8, 0x0,
    0x0, 0x0, 0x2, 0xdf, 0x60, 0x0, 0x0, 0x0,
    0x4f, 0xe3, 0x0, 0x0, 0x0, 0x7, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0xaf, 0xa0, 0x0, 0x0, 0x0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xef, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x1c, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10,

    /* U+3053 "こ" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4,
    0xff, 0xfe, 0xee, 0xef, 0xff, 0x60, 0x2, 0x89,
    0xaa, 0xbb, 0xaa, 0x98, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0xfb, 0x53, 0x22, 0x23,
    0x57, 0xa9, 0x1, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x1, 0x47, 0x77, 0x76, 0x53, 0x10,

    /* U+3055 "さ" */
    0x0, 0x0, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf5, 0x0, 0x26, 0x17, 0x87,
    0x65, 0x55, 0x6f, 0xdb, 0xef, 0xf3, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xc9, 0x63, 0x0, 0x1, 0x12,
    0x21, 0x2, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x10, 0x0, 0x36, 0x0, 0x0, 0x3a,
    0x88, 0xfb, 0x0, 0xb, 0xe0, 0x0, 0x3, 0xcd,
    0xff, 0xe1, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0xfe, 0xa9, 0x89, 0xac, 0xe2, 0x0,
    0x0, 0x6, 0xbe, 0xff, 0xfe, 0xca, 0x10, 0x0,

    /* U+3057 "し" */
    0x19, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x20, 0x2f, 0x70, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x3, 0xef,
    0x40, 0xd, 0xf4, 0x0, 0x0, 0x18, 0xff, 0x50,
    0x0, 0x4f, 0xfc, 0xaa, 0xdf, 0xfc, 0x20, 0x0,
    0x0, 0x3a, 0xef, 0xfd, 0x94, 0x0, 0x0, 0x0,

    /* U+3059 "す" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x1, 0x11, 0x22, 0x33, 0x34, 0xfa,
    0x44, 0x44, 0x42, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x7, 0x65, 0x44, 0x33,
    0x22, 0xf8, 0x22, 0x22, 0x22, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5d, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfa, 0x48, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xc0, 0x0, 0xae, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x90, 0x0, 0x9f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfd, 0x8c,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4b,
    0xdb, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xbf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xaf, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfa, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+305B "せ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x75, 0x0,
    0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0,
    0xda, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0xda, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0,
    0x0, 0x1, 0xeb, 0x56, 0x73, 0x12, 0x35, 0xcf,
    0xab, 0xce, 0xff, 0xff, 0xff, 0xf6, 0xef, 0xff,
    0xff, 0xdb, 0x98, 0x65, 0xea, 0x11, 0x10, 0x66,
    0x42, 0xae, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0xae, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x1, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0xc, 0xee,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x4,
    0x78, 0x60, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xa3, 0x11, 0x12, 0x35, 0x72, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x25, 0x77, 0x76, 0x54, 0x30,
    0x0,

    /* U+305F "た" */
    0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x60, 0x4, 0x0, 0x0,
    0x0, 0x7, 0x66, 0x6a, 0xfc, 0xdf, 0xf0, 0x0,
    0x0, 0x0, 0xff, 0xff, 0xff, 0xca, 0x85, 0x0,
    0x0, 0x0, 0x0, 0x11, 0x1d, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0x0, 0x3c,
    0xde, 0xee, 0xda, 0x0, 0x0, 0x5f, 0x40, 0x2,
    0xb9, 0x98, 0x9a, 0x90, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x6e, 0x10, 0x0, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x0, 0x6, 0xfb, 0x42, 0x22, 0x46, 0x15,
    0xfa, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xf1,
    0x28, 0x30, 0x0, 0x0, 0x0, 0x35, 0x55, 0x42,
    0x0,

    /* U+3060 "だ" */
    0x0, 0x0, 0x7, 0x70, 0x0, 0x0, 0x0, 0x4,
    0x50, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x9,
    0x44, 0xf1, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x8, 0xd0, 0xaa, 0x22, 0x22, 0x5f, 0xb8, 0xbe,
    0x30, 0x0, 0xd7, 0x25, 0xcf, 0xff, 0xff, 0xff,
    0xda, 0x10, 0x0, 0x20, 0x0, 0x35, 0x65, 0xcf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdc, 0x0, 0x6, 0x78, 0x88, 0x76, 0x10, 0x0,
    0x1, 0xf8, 0x0, 0x1f, 0xff, 0xef, 0xff, 0x30,
    0x0, 0x6, 0xf3, 0x0, 0x1, 0x0, 0x0, 0x1,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x50, 0x2, 0x92,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x5,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfb, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf5,
    0x0, 0x5, 0xfa, 0x10, 0x0, 0x1, 0x10, 0x1f,
    0xe0, 0x0, 0x0, 0xbf, 0xfe, 0xde, 0xff, 0x80,
    0x2b, 0x70, 0x0, 0x0, 0x3, 0x8a, 0xaa, 0x98,
    0x30,

    /* U+3061 "ち" */
    0x0, 0x0, 0x5b, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0xad, 0x0, 0x2, 0x46, 0x96, 0xe, 0xfd,
    0xcf, 0xfe, 0xff, 0xff, 0xfe, 0x60, 0x68, 0x9a,
    0xfc, 0x87, 0x64, 0x20, 0x0, 0x0, 0x0, 0x4f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x0,
    0x24, 0x55, 0x30, 0x0, 0x0, 0x1f, 0x77, 0xdf,
    0xff, 0xff, 0xd4, 0x0, 0x7, 0xff, 0xe8, 0x30,
    0x0, 0x4d, 0xf3, 0x0, 0xdf, 0xa0, 0x0, 0x0,
    0x0, 0x1f, 0xa0, 0x3f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0xfc,
    0x0, 0x0, 0xb, 0xcc, 0xcd, 0xff, 0xf9, 0x10,
    0x0, 0x0, 0x6b, 0xcc, 0xb9, 0x61, 0x0, 0x0,

    /* U+3063 "っ" */
    0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0,
    0x0, 0x4, 0x8b, 0xff, 0xff, 0xa1, 0x0, 0x15,
    0x9e, 0xff, 0xb7, 0x55, 0x9f, 0xe2, 0x9, 0xff,
    0xa4, 0x0, 0x0, 0x0, 0x3f, 0xa0, 0x26, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x8f, 0xd0, 0x0, 0x0, 0x1, 0x24, 0x7b,
    0xff, 0xa1, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xe9,
    0x30, 0x0, 0x0, 0x0, 0x1, 0x65, 0x20, 0x0,
    0x0, 0x0,

    /* U+3064 "つ" */
    0x0, 0x0, 0x0, 0x37, 0xbd, 0xff, 0xea, 0x30,
    0x0, 0x0, 0x4, 0x9e, 0xff, 0xda, 0x88, 0xaf,
    0xf8, 0x0, 0x3a, 0xff, 0xfa, 0x51, 0x0, 0x0,
    0x1, 0xcf, 0x60, 0x2f, 0xd6, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xd0, 0x2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6e,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x1, 0x36, 0xaf,
    0xfe, 0x40, 0x0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xfc, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa9,
    0x75, 0x10, 0x0, 0x0, 0x0,

    /* U+3066 "て" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x23, 0x46, 0x78,
    0x51, 0x56, 0x79, 0xbc, 0xef, 0xff, 0xff, 0xff,
    0xfa, 0x3f, 0xff, 0xfd, 0xb9, 0x79, 0xfe, 0x73,
    0x10, 0x1, 0x53, 0x10, 0x0, 0x3, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xee, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xb6, 0x31, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x15, 0x85, 0x0,

    /* U+3067 "で" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x35, 0x67,
    0x30, 0x13, 0x56, 0x89, 0xbc, 0xef, 0xff, 0xff,
    0xff, 0x80, 0x5f, 0xff, 0xfe, 0xca, 0x8a, 0xfe,
    0x74, 0x22, 0x0, 0x26, 0x42, 0x0, 0x0, 0x4f,
    0xa0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfa, 0x0, 0x3, 0xe, 0x50, 0x0, 0x0, 0x0,
    0xa, 0xe1, 0x0, 0x2f, 0x35, 0xe1, 0x0, 0x0,
    0x0, 0x2f, 0x70, 0x0, 0x7, 0xd0, 0xb4, 0x0,
    0x0, 0x0, 0x6f, 0x20, 0x0, 0x0, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xe8, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xdf, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x8a, 0x50, 0x0,

    /* U+306A "な" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x3,
    0x20, 0x0, 0x0, 0x0, 0x8, 0x77, 0x7a, 0xfd,
    0xff, 0x60, 0x6d, 0x50, 0x0, 0xe, 0xff, 0xff,
    0xe9, 0x73, 0x0, 0x4c, 0xfc, 0x30, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x5e, 0xf6, 0x0,
    0x0, 0x8f, 0x10, 0x0, 0x8, 0x70, 0x0, 0x91,
    0x0, 0x1, 0xfa, 0x0, 0x0, 0xc, 0xb0, 0x0,
    0x0, 0x0, 0x8, 0xf2, 0x0, 0x0, 0xb, 0xb0,
    0x0, 0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0xa,
    0xc0, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x18,
    0xcd, 0xce, 0xe1, 0x0, 0x0, 0xa, 0xd0, 0x1,
    0xee, 0x86, 0x8d, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x7, 0xf1, 0x0, 0x8, 0xf9, 0xfd, 0x30, 0x0,
    0x0, 0x8, 0xf1, 0x0, 0xc, 0xe0, 0x4e, 0xc0,
    0x0, 0x0, 0x2, 0xfd, 0x87, 0xbf, 0x90, 0x1,
    0x20, 0x0, 0x0, 0x0, 0x3b, 0xef, 0xe8, 0x0,
    0x0, 0x0,

    /* U+306B "に" */
    0x2, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x7, 0x76, 0x55, 0x66, 0x83,
    0xd, 0xb0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xf5,
    0xf, 0x80, 0x0, 0x0, 0x12, 0x23, 0x22, 0x10,
    0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xd, 0x0, 0x46, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x6b, 0x0, 0xbb, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xd6, 0x0, 0xd9, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf1, 0x0, 0xce, 0x20, 0x0, 0x0, 0x2,
    0x3f, 0xd0, 0x0, 0x4f, 0xfd, 0xbb, 0xcd, 0xff,
    0xf, 0x90, 0x0, 0x2, 0x9c, 0xdd, 0xdc, 0xa8,
    0x8, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+306E "の" */
    0x0, 0x0, 0x0, 0x3, 0x67, 0x63, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xff, 0xff, 0xe7,
    0x0, 0x0, 0x0, 0x3, 0xef, 0xa4, 0x9f, 0x24,
    0xbf, 0xc0, 0x0, 0x0, 0x3f, 0xd3, 0x0, 0xbf,
    0x0, 0x5, 0xfb, 0x0, 0x0, 0xee, 0x10, 0x0,
    0xdc, 0x0, 0x0, 0x7f, 0x50, 0x7, 0xf4, 0x0,
    0x1, 0xf9, 0x0, 0x0, 0xe, 0xc0, 0xe, 0xc0,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0xa, 0xf0, 0x2f,
    0x70, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x8, 0xf2,
    0x3f, 0x50, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x8,
    0xf2, 0x3f, 0x50, 0x0, 0x4f, 0x70, 0x0, 0x0,
    0xb, 0xf0, 0xf, 0x90, 0x0, 0xbf, 0x10, 0x0,
    0x0, 0x1f, 0xc0, 0xb, 0xf2, 0x6, 0xf8, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x3, 0xff, 0xcf, 0xd0,
    0x0, 0x0, 0xa, 0xfb, 0x0, 0x0, 0x5e, 0xfc,
    0x10, 0x0, 0x27, 0xef, 0xb0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x1e, 0xff, 0xd6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x73, 0x0, 0x0, 0x0,

    /* U+306F "は" */
    0x1, 0x10, 0x0, 0x0, 0x0, 0x2, 0x20, 0x0,
    0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xbc,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x97, 0x77, 0x7d,
    0xea, 0xce, 0x44, 0xf3, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xdb, 0xa2, 0x6f, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xe0, 0x0, 0xa, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0xbc, 0x19, 0x0,
    0x0, 0x24, 0x39, 0xf0, 0x0, 0xa, 0xd7, 0x90,
    0x5, 0xef, 0xff, 0xff, 0x60, 0x0, 0xae, 0xd4,
    0x2, 0xf9, 0x10, 0x19, 0xff, 0xd3, 0x8, 0xfe,
    0x0, 0x7f, 0x0, 0x0, 0x8f, 0x4d, 0xf7, 0x6f,
    0xa0, 0x6, 0xf6, 0x0, 0x1d, 0xe0, 0xb, 0xa3,
    0xf7, 0x0, 0xb, 0xff, 0xef, 0xf6, 0x0, 0x0,
    0xa, 0x40, 0x0, 0x4, 0x79, 0x83, 0x0, 0x0,
    0x0,

    /* U+307E "ま" */
    0x0, 0x0, 0x0, 0x2e, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf5, 0x0, 0x0, 0x0, 0x29,
    0x76, 0x44, 0x6f, 0x96, 0x79, 0xb9, 0x2, 0xde,
    0xff, 0xff, 0xff, 0xfe, 0xdb, 0x70, 0x0, 0x0,
    0x11, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf5, 0x0, 0x0, 0x0, 0x25, 0x32, 0x11,
    0x4f, 0x73, 0x45, 0x78, 0x4, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x1, 0x23, 0x45, 0x6f,
    0x83, 0x21, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1f, 0x70,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xff, 0xfc, 0x40,
    0x0, 0x0, 0xd, 0xe7, 0x44, 0x5f, 0xff, 0xd6,
    0x0, 0x4, 0xf4, 0x0, 0x0, 0xf9, 0x4d, 0xfc,
    0x20, 0x4f, 0x40, 0x0, 0x1f, 0x90, 0x7, 0xff,
    0x20, 0xef, 0x96, 0x7d, 0xf4, 0x0, 0x3, 0x90,
    0x1, 0x9d, 0xff, 0xd5, 0x0, 0x0, 0x0, 0x0,

    /* U+307F "み" */
    0x0, 0x3, 0x66, 0x78, 0x8a, 0xb1, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xfe, 0xdf, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x2f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf8, 0x0, 0x0, 0x44, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf1, 0x0, 0x0, 0xae, 0x0, 0x0, 0x1,
    0x7b, 0xdf, 0xfa, 0x73, 0x0, 0xbd, 0x0, 0x0,
    0x6f, 0xfa, 0xdf, 0xac, 0xff, 0xd7, 0xdb, 0x0,
    0x7, 0xf8, 0x0, 0xeb, 0x0, 0x5, 0xcf, 0xfb,
    0x0, 0x2f, 0x80, 0x5, 0xf3, 0x0, 0x0, 0x6,
    0xff, 0xe4, 0x7f, 0x0, 0xd, 0xc0, 0x0, 0x0,
    0xa, 0xf7, 0xfc, 0x8f, 0x0, 0x7f, 0x40, 0x0,
    0x0, 0x2f, 0xa0, 0x34, 0x5f, 0xa8, 0xfb, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0xa, 0xff, 0xc1,
    0x0, 0x0, 0x1c, 0xf5, 0x0, 0x0, 0x0, 0x11,
    0x0, 0x0, 0x7, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1c, 0xc3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+3082 "も" */
    0x0, 0x0, 0x0, 0xb9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9c, 0x97, 0x7f, 0x84, 0x56, 0x20,
    0x0, 0x0, 0x4, 0xad, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x42, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0x0, 0x0, 0x44, 0x0, 0x1e, 0xb7, 0x5d, 0xc3,
    0x44, 0x61, 0xb, 0xf2, 0x0, 0x9d, 0xff, 0xff,
    0xff, 0xff, 0x30, 0x1e, 0xb0, 0x0, 0x0, 0x1f,
    0xa3, 0x32, 0x10, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0x19, 0xfb, 0x0,
    0x0, 0x0, 0x3f, 0xfb, 0x99, 0xbf, 0xfb, 0x10,
    0x0, 0x0, 0x0, 0x29, 0xef, 0xfd, 0xa4, 0x0,
    0x0,

    /* U+308A "り" */
    0xe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x6, 0xcd, 0xa2, 0x0, 0x3f, 0x41, 0xcf, 0xaa,
    0xff, 0x30, 0x5f, 0x2d, 0xb1, 0x0, 0x2e, 0xd0,
    0x7f, 0x8c, 0x0, 0x0, 0x6, 0xf4, 0x9e, 0xf2,
    0x0, 0x0, 0x1, 0xf9, 0xaf, 0xa0, 0x0, 0x0,
    0x0, 0xec, 0xbf, 0x40, 0x0, 0x0, 0x0, 0xdd,
    0xcf, 0x0, 0x0, 0x0, 0x0, 0xdd, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0xec, 0xae, 0x0, 0x0, 0x0,
    0x2, 0xf8, 0x35, 0x0, 0x0, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0,
    0x0, 0x4, 0xef, 0x20, 0x0, 0x0, 0x4, 0xbf,
    0xe3, 0x0, 0x0, 0x3b, 0xff, 0xf9, 0x10, 0x0,
    0x0, 0xc, 0xa6, 0x10, 0x0, 0x0,

    /* U+308C "れ" */
    0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x45, 0x6a, 0xfb,
    0x0, 0x4b, 0xff, 0xc2, 0x0, 0x0, 0x5f, 0xff,
    0xff, 0x71, 0xbf, 0xa7, 0x9f, 0xb0, 0x0, 0x1,
    0x42, 0x6, 0xf4, 0xed, 0x30, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0, 0x0, 0xa,
    0xd0, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x9, 0xfe, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x5, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x2,
    0xfb, 0xac, 0x0, 0x0, 0x0, 0x2f, 0x60, 0x0,
    0x0, 0xcf, 0x2a, 0xc0, 0x0, 0x0, 0x4, 0xf4,
    0x0, 0x0, 0x9f, 0x50, 0xbc, 0x0, 0x0, 0x0,
    0x6f, 0x20, 0x0, 0x7, 0xa0, 0xb, 0xc0, 0x0,
    0x0, 0x6, 0xf3, 0x1, 0xa5, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x4f, 0xeb, 0xff, 0x40, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x0, 0x9f, 0xfb, 0x30,
    0x0, 0x0, 0x79, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+3092 "を" */
    0x0, 0x0, 0x4, 0xe4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x49, 0x77, 0x7d, 0xf8, 0x9a, 0xce, 0xe0, 0x0,
    0x5e, 0xef, 0xff, 0xfe, 0xdb, 0xa9, 0x60, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x20,
    0x0, 0xc, 0xe9, 0xcd, 0x91, 0x0, 0x3b, 0xf6,
    0x0, 0x8f, 0xf9, 0x68, 0xfb, 0x4c, 0xfe, 0x82,
    0x6, 0xfb, 0x10, 0x0, 0xaf, 0xfc, 0x50, 0x0,
    0x5f, 0xc0, 0x0, 0x2b, 0xff, 0x40, 0x0, 0x0,
    0x5d, 0x10, 0x4, 0xfd, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xa0, 0x6f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdc, 0x0, 0x6f, 0x10, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x37, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0xc8, 0x77, 0x79, 0xbd, 0x40,
    0x0, 0x0, 0x7, 0xcf, 0xff, 0xff, 0xdc, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3093 "ん" */
    0x0, 0x0, 0x0, 0x0, 0x61, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x44, 0x63, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xee, 0xdf, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0x60, 0x2e, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0x52, 0x0, 0x7f, 0x60, 0x0, 0xa,
    0xe0, 0x0, 0x0, 0xcc, 0x0, 0xed, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x3, 0xf7, 0x6, 0xf6, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0xc, 0xe1, 0xd, 0xf0,
    0x0, 0x0, 0x8, 0xf4, 0x1, 0xbf, 0x60, 0x3f,
    0xa0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xf8, 0x0,
    0x18, 0x40, 0x0, 0x0, 0x0, 0x4a, 0xb9, 0x30,
    0x0,

    /* U+30A2 "ア" */
    0x59, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x1f, 0xa0, 0x0,
    0xbf, 0x40, 0x0, 0x0, 0x0, 0x1, 0xf9, 0x1,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x90,
    0xdf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf7,
    0x2, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x9f, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30A3 "ィ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1c, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xdf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x2b,
    0xfc, 0x20, 0x0, 0x0, 0x0, 0x2a, 0xff, 0xf1,
    0x0, 0x0, 0x1, 0x5c, 0xff, 0x9b, 0xf1, 0x0,
    0x0, 0x5f, 0xfe, 0x81, 0x9, 0xf1, 0x0, 0x0,
    0x19, 0x40, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x0,

    /* U+30A4 "イ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x42,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xe4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbf,
    0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xef,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x18, 0xef, 0xe6,
    0xed, 0x0, 0x0, 0x0, 0x17, 0xcf, 0xfd, 0x60,
    0xe, 0xd0, 0x0, 0x0, 0x0, 0xef, 0xa3, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0, 0xe, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xed, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0x80, 0x0, 0x0,
    0x0,

    /* U+30A6 "ウ" */
    0x0, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0,
    0x1d, 0xdd, 0xdd, 0xdf, 0xfd, 0xdd, 0xdd, 0xe6,
    0x1f, 0xda, 0xaa, 0xaa, 0xaa, 0xaa, 0xac, 0xf8,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf5,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf1,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xe, 0xd0,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x80,
    0x7, 0x40, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x8e, 0xfd, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xfe, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+30A8 "エ" */
    0x0, 0x87, 0x77, 0x77, 0x77, 0x77, 0x77, 0x78,
    0x20, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x11, 0x11, 0x11, 0xfc, 0x11,
    0x11, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xec, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xbb, 0xbb, 0xbb, 0xff,
    0xbb, 0xbb, 0xbb, 0xc4, 0x4e, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xe4,

    /* U+30A9 "ォ" */
    0x0, 0x0, 0x0, 0x0, 0x47, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x87,
    0x77, 0x77, 0x7b, 0xf7, 0x77, 0x71, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x7f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xef, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xb7, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xb0,
    0x6f, 0x10, 0x0, 0x0, 0x1, 0xbf, 0xa0, 0x6,
    0xf1, 0x0, 0x0, 0x6, 0xff, 0x70, 0x0, 0x6f,
    0x10, 0x0, 0x3, 0xfd, 0x30, 0x0, 0x6, 0xf1,
    0x0, 0x0, 0x2, 0x0, 0x2, 0x75, 0xaf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30AB "カ" */
    0x0, 0x0, 0x0, 0x7b, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x1, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x47, 0x77, 0x77, 0xed, 0x77, 0x77, 0x7c, 0xf0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0xa, 0xe0,
    0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0xd, 0xe0, 0x0, 0x0, 0xd, 0xb0,
    0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0xdf, 0x10, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x3f, 0x60,
    0x0, 0x8f, 0xc0, 0x0, 0x0, 0x0, 0x7f, 0x30,
    0x1a, 0xfc, 0x10, 0x0, 0x79, 0x78, 0xfe, 0x0,
    0x6f, 0xb1, 0x0, 0x0, 0xaf, 0xff, 0xf5, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,

    /* U+30AD "キ" */
    0x0, 0x0, 0x4, 0xa3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x14, 0x0,
    0x0, 0x0, 0x0, 0xdd, 0x68, 0xbe, 0xff, 0x10,
    0x35, 0x79, 0xce, 0xff, 0xff, 0xdb, 0x86, 0x10,
    0xaf, 0xff, 0xca, 0xbf, 0x50, 0x0, 0x0, 0x0,
    0x34, 0x20, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xc0, 0x3, 0x68, 0xba,
    0x0, 0x0, 0x3, 0x5d, 0xfd, 0xff, 0xff, 0xea,
    0x69, 0xbe, 0xff, 0xff, 0xfc, 0x85, 0x30, 0x0,
    0xaf, 0xda, 0x85, 0x24, 0xf6, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0x40, 0x0, 0x0,

    /* U+30AF "ク" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5e, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfb, 0x22, 0x22,
    0x22, 0x10, 0x0, 0x0, 0x1, 0xef, 0xff, 0xff,
    0xff, 0xff, 0x30, 0x0, 0x0, 0xbf, 0x75, 0x55,
    0x55, 0x5e, 0xf0, 0x0, 0x0, 0xaf, 0x80, 0x0,
    0x0, 0x2, 0xfb, 0x0, 0x0, 0xaf, 0x90, 0x0,
    0x0, 0x0, 0x8f, 0x40, 0x2, 0xcf, 0x90, 0x0,
    0x0, 0x0, 0x1f, 0xd0, 0x0, 0x8f, 0x60, 0x0,
    0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xef, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xdf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5d, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xef, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0x71, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B0 "グ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x50, 0x0, 0x0,
    0x67, 0x2f, 0x40, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x3, 0xf2, 0x7d, 0x0, 0x0, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x9, 0xb0, 0x50, 0x0, 0x0,
    0x5, 0xfd, 0x77, 0x77, 0x78, 0x92, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0x0, 0xc,
    0xf1, 0x0, 0x0, 0x0, 0xbf, 0x60, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x1, 0xcf, 0x70, 0x0,
    0x0, 0x0, 0x8f, 0x50, 0x0, 0x5, 0xef, 0x60,
    0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0x2b,
    0x30, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xef,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xef, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1a, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x9f, 0xfa, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xb3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30B5 "サ" */
    0x0, 0x0, 0x58, 0x10, 0x0, 0x1, 0xa6, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x1,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0,
    0x1, 0xf8, 0x0, 0x0, 0x79, 0x88, 0xcf, 0x88,
    0x88, 0x89, 0xfc, 0x88, 0x85, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x1, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x2, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x4, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x7,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xee, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0x60, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B6 "ザ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x12, 0x1,
    0xa, 0x10, 0x0, 0x0, 0xf, 0xb0, 0x0, 0x0,
    0xaf, 0xd, 0x49, 0x80, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0xaf, 0x7, 0xa3, 0xe0, 0x0, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0xaf, 0x1, 0xb0, 0x10,
    0x1, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xaf, 0x0,
    0x1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x8, 0x77, 0x7f, 0xd7,
    0x77, 0x77, 0xcf, 0x77, 0x78, 0x0, 0x0, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x60, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xef, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xaf, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfb, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+30B7 "シ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xdf, 0xc2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x91, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x40, 0x9f, 0xe6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0x10, 0x4d, 0xfc, 0x10, 0x0,
    0x0, 0x0, 0x3f, 0xd0, 0x0, 0x9, 0xe1, 0x0,
    0x0, 0x0, 0x2e, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xc2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5c, 0xff, 0x80, 0x0, 0x0, 0x0, 0x2,
    0x6a, 0xff, 0xfa, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xfd, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B8 "ジ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0x30, 0x0, 0x0, 0xbc, 0x20, 0x0, 0x0, 0x68,
    0x9, 0xd0, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0,
    0x2f, 0x30, 0xe7, 0x0, 0x0, 0x2, 0xcf, 0xc0,
    0x0, 0x9, 0xd0, 0x55, 0x0, 0x0, 0x0, 0x7,
    0x70, 0x0, 0x1, 0x70, 0x0, 0x5, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0xd, 0xfb,
    0x20, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0, 0x1,
    0x9f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x0, 0x3, 0xdc, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x10, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x3f,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4d, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4b, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x15,
    0x9e, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xfe, 0x82, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x58, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B9 "ス" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x2, 0xa9, 0x99, 0x99, 0x99, 0x9c, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xef, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2e, 0xfe, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xef, 0x31, 0xdf, 0x60, 0x0,
    0x0, 0x0, 0x7f, 0xe3, 0x0, 0x1d, 0xf6, 0x0,
    0x0, 0x2c, 0xfd, 0x10, 0x0, 0x1, 0xef, 0x50,
    0x29, 0xff, 0x90, 0x0, 0x0, 0x0, 0x2e, 0xf4,
    0x9f, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfa,
    0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40,

    /* U+30BB "セ" */
    0x0, 0x0, 0x5, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x20, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x25,
    0x8c, 0xff, 0x60, 0x0, 0x0, 0xed, 0x8b, 0xff,
    0xff, 0xcf, 0xf2, 0x36, 0x9c, 0xff, 0xff, 0xc9,
    0x63, 0x3, 0xf9, 0xa, 0xff, 0xc9, 0xfc, 0x0,
    0x0, 0x0, 0xde, 0x10, 0x33, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x9f, 0x40, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x21, 0x12, 0x34, 0x77, 0x0,
    0x0, 0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x15, 0x67, 0x76, 0x65, 0x31,
    0x0,

    /* U+30BF "タ" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xfc, 0x66, 0x66,
    0x67, 0x60, 0x0, 0x0, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x1, 0xdf, 0x20, 0x0,
    0x0, 0xe, 0xe0, 0x0, 0x0, 0xbf, 0x40, 0x0,
    0x0, 0x4, 0xf9, 0x0, 0x1, 0xbf, 0x60, 0x0,
    0x0, 0x0, 0xaf, 0x20, 0x3, 0xdf, 0x60, 0x5e,
    0x60, 0x0, 0x3f, 0xa0, 0x0, 0xbf, 0x40, 0x2,
    0xcf, 0xc2, 0xc, 0xf2, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x7f, 0xfb, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2d, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfe, 0x26, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0xfd, 0x20, 0x3, 0x20, 0x0,
    0x0, 0x0, 0x7e, 0xfa, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xff, 0xd4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5b, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30C0 "ダ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x0, 0x0,
    0x7b, 0xd, 0x60, 0x0, 0x0, 0x0, 0x3f, 0xa0,
    0x0, 0x1, 0xf5, 0x5e, 0x0, 0x0, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x8, 0xa0, 0x10, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x2, 0xfd, 0x77, 0x77, 0x77, 0xbf, 0x70,
    0x0, 0x0, 0x1, 0xee, 0x20, 0x0, 0x0, 0xb,
    0xf1, 0x0, 0x0, 0x1, 0xdf, 0x40, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x3, 0xef, 0x40, 0x73,
    0x0, 0x0, 0x9f, 0x40, 0x0, 0x5, 0xfe, 0x40,
    0x2e, 0xf9, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x19,
    0x20, 0x0, 0x1a, 0xfd, 0x4c, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xc2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfd, 0x9f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xfc, 0x10, 0x5c, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5e, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x16, 0xdf, 0xe6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xfe, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30C3 "ッ" */
    0x0, 0x0, 0x1, 0x50, 0x0, 0x0, 0x0, 0x5,
    0x10, 0x9, 0xf1, 0x0, 0x0, 0xb7, 0x3f, 0x70,
    0x3, 0xf7, 0x0, 0x1, 0xfa, 0xd, 0xd0, 0x0,
    0xdc, 0x0, 0x5, 0xf5, 0x6, 0xf4, 0x0, 0x7f,
    0x10, 0xa, 0xf0, 0x1, 0xfa, 0x0, 0x11, 0x0,
    0x1f, 0xa0, 0x0, 0x52, 0x0, 0x0, 0x0, 0xaf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xee, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xe3, 0x0, 0x0, 0x0, 0x1, 0x7e,
    0xfc, 0x10, 0x0, 0x0, 0x0, 0xb, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x50, 0x0, 0x0,
    0x0, 0x0,

    /* U+30C6 "テ" */
    0x0, 0x7, 0x98, 0x88, 0x88, 0x88, 0x88, 0x90,
    0x0, 0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xb3, 0x1d, 0xdd,
    0xdd, 0xdd, 0xef, 0xed, 0xdd, 0xdd, 0xd4, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xef, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7b, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30C7 "デ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xc, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf3, 0x6d, 0x0, 0x0, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x68, 0xc0, 0xd5, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x1c, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x39, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x88, 0x90, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xef, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x18, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbc, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30C8 "ト" */
    0x14, 0x20, 0x0, 0x0, 0x0, 0x5, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x60, 0x0, 0x0, 0x0,
    0x4, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xe9, 0x30, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xd8, 0x20, 0x0, 0x4f, 0x63, 0x9e, 0xff,
    0xb4, 0x4, 0xf6, 0x0, 0x5, 0xcf, 0xfb, 0x4f,
    0x60, 0x0, 0x0, 0x3a, 0x74, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x60, 0x0, 0x0, 0x0, 0x4,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x4d, 0x60, 0x0, 0x0, 0x0, 0x0,

    /* U+30C9 "ド" */
    0x1, 0x10, 0x0, 0x0, 0x0, 0x10, 0x0, 0xfd,
    0x0, 0x0, 0x0, 0x4f, 0x20, 0xe, 0xc0, 0x0,
    0xb, 0xa0, 0xbb, 0x0, 0xec, 0x0, 0x0, 0x2f,
    0x42, 0xf3, 0xe, 0xc0, 0x0, 0x0, 0x9b, 0x1,
    0x0, 0xec, 0x0, 0x0, 0x1, 0x0, 0x0, 0xe,
    0xf8, 0x20, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xc7, 0x10, 0x0, 0x0, 0xe, 0xc4, 0xaf, 0xff,
    0xb4, 0x0, 0x0, 0xec, 0x0, 0x6, 0xcf, 0xfd,
    0x10, 0xe, 0xc0, 0x0, 0x0, 0x3b, 0xe0, 0x0,
    0xec, 0x0, 0x0, 0x0, 0x1, 0x0, 0xe, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30CB "ニ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x20, 0x0, 0x4b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x1c, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xa0,

    /* U+30CD "ネ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe3, 0x0, 0x0, 0x98, 0x88,
    0x88, 0x88, 0x88, 0xbf, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xef, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xaf, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x8f, 0xff, 0x0,
    0x96, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xfc, 0xde,
    0x1, 0xcf, 0xd4, 0x0, 0x29, 0xdf, 0xfc, 0x40,
    0xbe, 0x0, 0x6, 0xff, 0xa1, 0xd, 0xd8, 0x20,
    0x0, 0xbe, 0x0, 0x0, 0x1b, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0x0, 0x0,

    /* U+30D0 "バ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x34, 0x4f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xe1, 0x9b, 0x0, 0x0, 0x0, 0x43,
    0x0, 0x2, 0x71, 0xb, 0x91, 0x90, 0x0, 0x0,
    0xc, 0xf0, 0x0, 0x5f, 0x80, 0x35, 0x0, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x70, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0x0, 0x7f, 0x50, 0x0, 0x0, 0x0, 0x1f,
    0xa0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x0, 0x0,
    0x7, 0xf5, 0x0, 0x0, 0x0, 0xa, 0xf2, 0x0,
    0x0, 0x0, 0xdf, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x80, 0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0xee, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf4, 0x0, 0x7, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x90, 0x2, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0,
    0x5e, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+30D5 "フ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1,
    0x1a, 0x99, 0x99, 0x99, 0x99, 0x99, 0x9f, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xcf, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x4, 0x9f, 0xfe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xfe, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30D6 "ブ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x53,
    0x2e, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0xa, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x61, 0xd1, 0x5b, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xae, 0x60, 0x0, 0x6e, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xef, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x6d, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0x71, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+30D7 "プ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8c,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x92, 0xb6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x20, 0x4a, 0x4a, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xae, 0x70, 0x97, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xbf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5e, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6c, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x82, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30D9 "ベ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x24,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60,
    0x5f, 0x20, 0x0, 0x0, 0x0, 0x23, 0x0, 0x0,
    0xe8, 0xb, 0xb0, 0x0, 0x0, 0x5, 0xff, 0xb0,
    0x0, 0x5f, 0x22, 0xe2, 0x0, 0x0, 0x3f, 0xeb,
    0xfc, 0x0, 0xc, 0x70, 0x0, 0x0, 0x1, 0xee,
    0x10, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf4, 0x0, 0x9, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x70, 0x0, 0x0, 0xaf, 0xa0, 0x0, 0x0,
    0x9, 0xfa, 0x0, 0x0, 0x0, 0xb, 0xf9, 0x0,
    0x0, 0x9f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x80, 0x0, 0x3e, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x1d, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xef, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+30DE "マ" */
    0x99, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x97,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x70, 0x0, 0x0, 0x1d, 0xa0, 0x0, 0x0,
    0xaf, 0x90, 0x0, 0x0, 0x0, 0x9f, 0xd2, 0x0,
    0xaf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xe4,
    0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x75, 0x0, 0x0, 0x0,

    /* U+30DF "ミ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xeb, 0x84, 0x10, 0x0, 0x0, 0x0, 0x58,
    0xbe, 0xff, 0xfd, 0x95, 0x10, 0x0, 0x0, 0x0,
    0x15, 0x8d, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x15, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xb8, 0x52, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xdf, 0xff, 0xeb, 0x73, 0x0, 0x0,
    0x0, 0x0, 0x47, 0xbe, 0xff, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x37, 0xc8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0xb8, 0x51, 0x0,
    0x0, 0x0, 0x0, 0x7b, 0xef, 0xff, 0xd9, 0x51,
    0x0, 0x0, 0x0, 0x1, 0x59, 0xdf, 0xff, 0xc7,
    0x10, 0x0, 0x0, 0x0, 0x1, 0x5a, 0xef, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0,

    /* U+30E0 "ム" */
    0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xde, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xe0, 0x0, 0x1, 0xdb, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0, 0x8f,
    0x50, 0x0, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0x0, 0xde, 0x0, 0x0,
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x3, 0xf9, 0x0,
    0x0, 0x1, 0x35, 0xff, 0x10, 0x13, 0x3a, 0xfa,
    0x9a, 0xce, 0xff, 0xff, 0xff, 0x80, 0x6f, 0xff,
    0xff, 0xfe, 0xcb, 0x97, 0x53, 0x2e, 0xf1, 0x29,
    0x75, 0x42, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x70,

    /* U+30E2 "モ" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x2, 0x77, 0x77, 0xfd, 0x77, 0x77, 0x77,
    0x40, 0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x67, 0x77, 0x77, 0xfd, 0x77,
    0x77, 0x77, 0x78, 0x1b, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x10, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xfc, 0x87, 0x78, 0x8a, 0x50, 0x0,
    0x0, 0x0, 0x2b, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x12, 0x11, 0x0, 0x0,

    /* U+30E3 "ャ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x3f, 0x60, 0x2, 0x58, 0xbf, 0xf1, 0x0, 0x3,
    0xfd, 0xcf, 0xff, 0xda, 0xfc, 0xa, 0xdf, 0xff,
    0xfa, 0x63, 0x0, 0x9f, 0x20, 0x8a, 0x73, 0x7f,
    0x30, 0x0, 0x5f, 0x60, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0x4f, 0xa0, 0x0, 0x0, 0x0, 0xd, 0xc0,
    0x1e, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x11, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x39, 0x20, 0x0, 0x0,
    0x0,

    /* U+30E5 "ュ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0,
    0x0, 0x19, 0x88, 0x88, 0x88, 0xaf, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0xc, 0xbb, 0xbb, 0xbb, 0xbc, 0xfe, 0xbb, 0xc1,
    0xc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc1,

    /* U+30E7 "ョ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x48, 0x77, 0x77, 0x77,
    0x77, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3, 0x22,
    0x22, 0x22, 0x22, 0xf8, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x4, 0x44, 0x44, 0x44, 0x44, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x57, 0x77, 0x77, 0x77, 0x77, 0xf8,

    /* U+30E9 "ラ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x39, 0x99, 0x99, 0x99, 0x99, 0x99, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x18, 0x77, 0x77, 0x77, 0x77, 0x77, 0x7d, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3a, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3d, 0x82, 0x0, 0x0, 0x0, 0x0,

    /* U+30EA "リ" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x30, 0xaf, 0x10,
    0x0, 0x0, 0xa, 0xf2, 0x9f, 0x0, 0x0, 0x0,
    0x9, 0xf2, 0x9f, 0x0, 0x0, 0x0, 0x9, 0xf2,
    0x9f, 0x0, 0x0, 0x0, 0x9, 0xf2, 0x9f, 0x0,
    0x0, 0x0, 0x9, 0xf2, 0x9f, 0x0, 0x0, 0x0,
    0x9, 0xf1, 0x9f, 0x0, 0x0, 0x0, 0xa, 0xf1,
    0x9f, 0x0, 0x0, 0x0, 0xa, 0xf0, 0xaf, 0x10,
    0x0, 0x0, 0xc, 0xe0, 0x6a, 0x10, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70,
    0x0, 0x0, 0x0, 0x1, 0xef, 0x10, 0x0, 0x0,
    0x0, 0x1d, 0xf6, 0x0, 0x0, 0x0, 0x7, 0xef,
    0x70, 0x0, 0x0, 0x6, 0xff, 0xe4, 0x0, 0x0,
    0x0, 0x0, 0xa6, 0x0, 0x0, 0x0,

    /* U+30EB "ル" */
    0x0, 0x0, 0xaf, 0x0, 0xa, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x9,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xae,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdc, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0x63, 0x0, 0x3, 0xf7, 0x0, 0x9, 0xf1, 0x0,
    0x3, 0xfa, 0x0, 0x8, 0xf3, 0x0, 0x9, 0xf1,
    0x0, 0x4f, 0xe1, 0x0, 0x1f, 0xd0, 0x0, 0x9,
    0xf1, 0x7, 0xfe, 0x20, 0x0, 0xbf, 0x50, 0x0,
    0x9, 0xf4, 0xcf, 0xc1, 0x0, 0x8, 0xfa, 0x0,
    0x0, 0x9, 0xff, 0xf8, 0x0, 0x0, 0x5f, 0xc0,
    0x0, 0x0, 0x9, 0xfc, 0x30, 0x0, 0x0, 0x4,
    0x10, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0,

    /* U+30EC "レ" */
    0x9e, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x9f, 0x10, 0x0, 0x0, 0x0, 0x1, 0xda,
    0x9f, 0x10, 0x0, 0x0, 0x0, 0x1d, 0xf5, 0x9f,
    0x10, 0x0, 0x0, 0x4, 0xef, 0x60, 0x9f, 0x10,
    0x0, 0x1, 0x9f, 0xf5, 0x0, 0x9f, 0x10, 0x0,
    0x7e, 0xfc, 0x20, 0x0, 0x9f, 0x12, 0x8e, 0xfe,
    0x50, 0x0, 0x0, 0x9f, 0xdf, 0xfd, 0x60, 0x0,
    0x0, 0x0, 0x8f, 0xe9, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30ED "ロ" */
    0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x6d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xdc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x9d, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf9, 0xdc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x9d, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf9, 0xdc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x9d, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0xdc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x9d, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf9, 0xdc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x9d, 0xe9, 0x99, 0x99, 0x99, 0x99,
    0x99, 0xf9, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x9e, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf9, 0x21, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x10,

    /* U+30EF "ワ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x1f, 0xd8, 0x88, 0x88, 0x88, 0x88, 0x8b, 0xf8,
    0x1f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf5,
    0x1f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf2,
    0x1f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf0,
    0x1f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xb0,
    0x1d, 0x80, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x7e, 0xfd, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xfe, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x60, 0x0, 0x0, 0x0, 0x0,

    /* U+30F3 "ン" */
    0x0, 0x61, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3e, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x20, 0x0, 0x0, 0x1d, 0xf6, 0x0, 0x0,
    0x0, 0x1e, 0x10, 0x0, 0x0, 0x17, 0x0, 0x0,
    0x0, 0xb, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1a, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7e, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x28, 0xef, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x69,
    0xdf, 0xfe, 0x81, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xff, 0xb6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x14, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30FC "ー" */
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4E00 "一" */
    0x1a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xa2, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4E0B "下" */
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x45, 0x55, 0x55, 0x56, 0xfa,
    0x55, 0x55, 0x55, 0x55, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xbc,
    0xfd, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf8, 0x5, 0xef, 0xb2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x1, 0x9f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x4e, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x0, 0x0,

    /* U+4E0D "不" */
    0x6, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x30, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xf9, 0x13, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xef, 0x9b, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xe2, 0xf9,
    0x9, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x7f, 0xe2,
    0xf, 0x90, 0x6, 0xfe, 0x40, 0x0, 0x1, 0xaf,
    0xd1, 0x0, 0xf9, 0x0, 0x3, 0xef, 0x60, 0x5,
    0xef, 0xa0, 0x0, 0xf, 0x90, 0x0, 0x1, 0xdf,
    0x71, 0xee, 0x50, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x1, 0xd7, 0x3, 0x10, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x0,

    /* U+4E2D "中" */
    0x0, 0x0, 0x0, 0x8, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x3, 0x33, 0x33, 0x33, 0xbf, 0x33, 0x33,
    0x33, 0x31, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x7d, 0xb3, 0x33, 0x33, 0xbf, 0x33,
    0x33, 0x34, 0xf7, 0xda, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x1f, 0x7d, 0xa0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x1, 0xf7, 0xda, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x1f, 0x7d, 0xa0, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0x1, 0xf7, 0xdc, 0x77, 0x77,
    0x7c, 0xf7, 0x77, 0x77, 0x7f, 0x7d, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xda, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x1f, 0x73, 0x20,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x31, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0,

    /* U+4E86 "了" */
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x8f, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfd, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xaf, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5e, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfb, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x77, 0x7d, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xfd, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4F3A "伺" */
    0x0, 0x0, 0x2c, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xe1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x1, 0xf8, 0x7, 0x77,
    0x77, 0x77, 0x77, 0x7f, 0x80, 0x0, 0x8f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x1f,
    0x90, 0x35, 0x55, 0x55, 0x55, 0x51, 0xf, 0x80,
    0xa, 0xf8, 0xa, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xf8, 0x5, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x82, 0xfc, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x8f, 0x2e, 0x80, 0x9,
    0xff, 0xff, 0xff, 0x10, 0xf, 0x81, 0x40, 0xe8,
    0x0, 0x9d, 0x44, 0x47, 0xf1, 0x0, 0xf8, 0x0,
    0xe, 0x80, 0x9, 0xc0, 0x0, 0x4f, 0x10, 0xf,
    0x80, 0x0, 0xe8, 0x0, 0x9c, 0x0, 0x4, 0xf1,
    0x0, 0xf8, 0x0, 0xe, 0x80, 0x9, 0xc0, 0x0,
    0x4f, 0x10, 0xf, 0x80, 0x0, 0xe8, 0x0, 0x9f,
    0xff, 0xff, 0xf1, 0x0, 0xf8, 0x0, 0xe, 0x80,
    0x9, 0xd5, 0x55, 0x55, 0x0, 0xf, 0x80, 0x0,
    0xe8, 0x0, 0x69, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x0,
    0x57, 0x78, 0xf7, 0x0, 0xe, 0x80, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xfb, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4F4E "低" */
    0x0, 0x0, 0x7, 0x50, 0x0, 0x0, 0x0, 0x4,
    0x94, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x15,
    0x8c, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x7f, 0x25,
    0xcf, 0xff, 0xef, 0xc3, 0x0, 0x0, 0x0, 0x0,
    0xea, 0x6, 0xf6, 0x31, 0xb, 0xb0, 0x0, 0x0,
    0x0, 0x8, 0xf2, 0x6, 0xf0, 0x0, 0xb, 0xb0,
    0x0, 0x0, 0x0, 0x2f, 0xf0, 0x6, 0xf0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x6,
    0xf0, 0x0, 0x9, 0xd0, 0x0, 0x0, 0x9, 0xfd,
    0xf0, 0x6, 0xf2, 0x22, 0x28, 0xf2, 0x22, 0x20,
    0x3f, 0xa7, 0xf0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x8, 0x7, 0xf0, 0x6, 0xf4, 0x44,
    0x47, 0xf7, 0x44, 0x40, 0x0, 0x7, 0xf0, 0x6,
    0xf0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x7,
    0xf0, 0x6, 0xf0, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0x0, 0x7, 0xf0, 0x6, 0xf0, 0x0, 0x0, 0xda,
    0x0, 0x0, 0x0, 0x7, 0xf0, 0x6, 0xf0, 0x0,
    0x10, 0x9e, 0x0, 0x20, 0x0, 0x7, 0xf0, 0x6,
    0xf0, 0x1, 0xf3, 0x5f, 0x30, 0xc5, 0x0, 0x7,
    0xf0, 0x6, 0xf0, 0x24, 0x9b, 0xe, 0xa0, 0xf3,
    0x0, 0x7, 0xf0, 0xa, 0xfe, 0xfd, 0x1f, 0x37,
    0xfe, 0xe0, 0x0, 0x7, 0xf0, 0xf, 0xff, 0xb4,
    0x8, 0x50, 0x9f, 0x60, 0x0, 0x7, 0xf0, 0xa,
    0x81, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4F60 "你" */
    0x0, 0x0, 0x5, 0x10, 0x5, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x1f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x0,
    0x5f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0xbd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xe0, 0x1, 0xfe, 0xbb, 0xbb, 0xbb,
    0xbb, 0xa0, 0x0, 0x6f, 0x80, 0x8, 0xfb, 0xaa,
    0xfd, 0xaa, 0xae, 0xd0, 0x2, 0xff, 0x80, 0xe,
    0xa0, 0x0, 0xe9, 0x0, 0xc, 0xa0, 0xd, 0xff,
    0x80, 0x9f, 0x20, 0x0, 0xe9, 0x0, 0xe, 0x70,
    0x9f, 0x5e, 0x80, 0xa9, 0x0, 0x0, 0xe9, 0x0,
    0x1a, 0x30, 0x38, 0xe, 0x80, 0x0, 0x4d, 0x20,
    0xe9, 0xb, 0xb0, 0x0, 0x0, 0xe, 0x80, 0x0,
    0x8f, 0x0, 0xe9, 0x6, 0xf2, 0x0, 0x0, 0xe,
    0x80, 0x0, 0xea, 0x0, 0xe9, 0x0, 0xf9, 0x0,
    0x0, 0xe, 0x80, 0x4, 0xf4, 0x0, 0xe9, 0x0,
    0x9f, 0x0, 0x0, 0xe, 0x80, 0xb, 0xd0, 0x0,
    0xe9, 0x0, 0x3f, 0x50, 0x0, 0xe, 0x80, 0x4f,
    0x60, 0x0, 0xe9, 0x0, 0xe, 0x90, 0x0, 0xe,
    0x80, 0x9d, 0x0, 0x0, 0xe9, 0x0, 0xa, 0xb0,
    0x0, 0xe, 0x80, 0x1, 0x0, 0x0, 0xe9, 0x0,
    0x1, 0x0, 0x0, 0xe, 0x80, 0x0, 0x1, 0x88,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0xd, 0x70, 0x0,
    0x0, 0xef, 0xc2, 0x0, 0x0, 0x0,

    /* U+4FE1 "信" */
    0x0, 0x0, 0x6, 0x20, 0x0, 0x6, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0xd,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf7, 0x35, 0x55, 0x55, 0xb6, 0x55, 0x55, 0x50,
    0x0, 0x9, 0xf1, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x2f, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xf0, 0x2,
    0x66, 0x66, 0x66, 0x66, 0x62, 0x0, 0x9, 0xfa,
    0xf0, 0x4, 0xdd, 0xdd, 0xdd, 0xdd, 0xd5, 0x0,
    0xd, 0x77, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x7, 0xf0, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x7, 0xf0, 0x1,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x7, 0xf0, 0xa, 0xc4, 0x44,
    0x44, 0x44, 0xd9, 0x0, 0x0, 0x7, 0xf0, 0xa,
    0xa0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x7,
    0xf0, 0xa, 0xa0, 0x0, 0x0, 0x0, 0xc9, 0x0,
    0x0, 0x7, 0xf0, 0xa, 0xc4, 0x44, 0x44, 0x44,
    0xd9, 0x0, 0x0, 0x7, 0xf0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x7, 0xf0, 0xa,
    0xa0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5019 "候" */
    0x0, 0x0, 0x68, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcb, 0x0, 0xa, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0x3, 0x55, 0x55, 0x57, 0xf3, 0x0, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf1, 0x0,
    0x0, 0xe, 0x90, 0x41, 0x0, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x51, 0xf4, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x1, 0xef, 0x51, 0xf4,
    0x34, 0xa9, 0x44, 0x44, 0x44, 0x40, 0x9, 0xff,
    0x51, 0xf4, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xaf, 0x51, 0xf4, 0x5, 0xfe, 0xdd, 0xdd,
    0xdd, 0x50, 0xa, 0x2f, 0x51, 0xf4, 0xd, 0xc7,
    0x9f, 0xa7, 0x77, 0x20, 0x0, 0x1f, 0x51, 0xf4,
    0x9f, 0x20, 0x2f, 0x40, 0x0, 0x0, 0x0, 0x1f,
    0x51, 0xf4, 0x36, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0x0, 0x1f, 0x51, 0xf4, 0xad, 0xdd, 0xdf, 0xdd,
    0xdd, 0xd0, 0x0, 0x1f, 0x51, 0xf4, 0x78, 0x88,
    0xcf, 0xd8, 0x88, 0x80, 0x0, 0x1f, 0x50, 0xe3,
    0x0, 0x0, 0xcf, 0xe0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x7, 0xf6, 0xea, 0x0, 0x0,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x9f, 0x80, 0x5f,
    0xb2, 0x0, 0x0, 0x1f, 0x50, 0x1, 0x8e, 0xf6,
    0x0, 0x5, 0xff, 0xa1, 0x0, 0x1f, 0x50, 0x0,
    0xc9, 0x10, 0x0, 0x0, 0x18, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5099 "備" */
    0x0, 0x0, 0x7b, 0x0, 0x8, 0xc0, 0x0, 0xc7,
    0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x9d, 0x0,
    0xd, 0x80, 0x0, 0x0, 0x3, 0xf5, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x9e, 0x4,
    0x77, 0xce, 0x77, 0x7e, 0xb7, 0x72, 0x0, 0x1f,
    0x80, 0x0, 0x9, 0xd0, 0x0, 0xd8, 0x0, 0x0,
    0x8, 0xf8, 0x2a, 0xaa, 0xdf, 0xaa, 0xaf, 0xda,
    0xa9, 0x2, 0xff, 0x82, 0xbb, 0xdf, 0xdb, 0xbb,
    0xbb, 0xbb, 0xa0, 0xbf, 0xf8, 0x0, 0xc, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x6f, 0x80, 0xb,
    0xfa, 0x77, 0x77, 0x77, 0x75, 0x0, 0x70, 0xf8,
    0x2d, 0xff, 0xcc, 0xcf, 0xec, 0xcf, 0xc0, 0x0,
    0xf, 0x8e, 0xfc, 0xd0, 0x0, 0xf6, 0x0, 0xac,
    0x0, 0x0, 0xf8, 0x52, 0x9e, 0x55, 0x5f, 0x95,
    0x5c, 0xc0, 0x0, 0xf, 0x80, 0x9, 0xfd, 0xdd,
    0xfe, 0xdd, 0xfc, 0x0, 0x0, 0xf8, 0x0, 0x9d,
    0x0, 0xf, 0x60, 0xa, 0xc0, 0x0, 0xf, 0x80,
    0x9, 0xfd, 0xdd, 0xfe, 0xdd, 0xfc, 0x0, 0x0,
    0xf8, 0x0, 0x9e, 0x44, 0x4f, 0x94, 0x4c, 0xc0,
    0x0, 0xf, 0x80, 0x9, 0xd0, 0x0, 0xf6, 0x0,
    0xac, 0x0, 0x0, 0xf8, 0x0, 0x9d, 0x0, 0xf,
    0x60, 0x2b, 0xc0, 0x0, 0xf, 0x80, 0x9, 0xd0,
    0x0, 0x0, 0xe, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5145 "充" */
    0x0, 0x0, 0x0, 0x1, 0x95, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xa0, 0x0, 0x0, 0x0, 0x3, 0x88, 0x88, 0x88,
    0x88, 0xd9, 0x88, 0x88, 0x88, 0x70, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xe1, 0x0, 0x0,
    0x6, 0xfb, 0x0, 0x0, 0x0, 0x1d, 0xf5, 0x34,
    0x55, 0x67, 0x7c, 0xfc, 0x10, 0x0, 0x2e, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0xdc, 0xfc, 0x10, 0x0,
    0xa6, 0x54, 0xfa, 0x10, 0x5f, 0x40, 0x5, 0xe3,
    0x0, 0x0, 0x0, 0x2f, 0x70, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0, 0x5f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x50, 0x0, 0x0, 0x4f,
    0x90, 0x0, 0x5f, 0x40, 0x0, 0x1f, 0x50, 0x0,
    0x4e, 0xe1, 0x0, 0x5, 0xf4, 0x0, 0x3, 0xf3,
    0x3, 0xaf, 0xe3, 0x0, 0x0, 0x4f, 0xa6, 0x66,
    0xbf, 0x5, 0xff, 0x91, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0x70, 0x5, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5148 "先" */
    0x0, 0x0, 0x0, 0x0, 0x9, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf2, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0xe,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xc8,
    0x88, 0xfc, 0x88, 0x88, 0x88, 0x10, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0xea, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x20, 0x0, 0xe, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x9, 0x80, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x6,
    0x66, 0x66, 0xde, 0x66, 0x6a, 0xf7, 0x66, 0x66,
    0x30, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x6f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf7, 0x0, 0x6,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x6f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xb0, 0x0, 0x6, 0xf1, 0x0, 0x7, 0xb0, 0x0,
    0x2d, 0xf2, 0x0, 0x0, 0x6f, 0x10, 0x0, 0x9d,
    0x1, 0x8f, 0xf4, 0x0, 0x0, 0x6, 0xf8, 0x77,
    0x7e, 0xa0, 0xdf, 0xa2, 0x0, 0x0, 0x0, 0x1c,
    0xff, 0xff, 0xe3, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5165 "入" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xbf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xde, 0x1e, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x7,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xa0, 0x0, 0x7f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0xe, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf7, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xc0,
    0x0, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x0, 0x8,
    0xfd, 0x10, 0x0, 0x0, 0x0, 0x1d, 0xf9, 0x0,
    0x2, 0xbf, 0xc1, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0xc1, 0xc, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0xd0, 0x0, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+5173 "关" */
    0x0, 0x1, 0x70, 0x0, 0x0, 0x0, 0x9, 0x40,
    0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x0, 0x5,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0xdd, 0x0, 0x0, 0x0, 0x0, 0x0, 0xea,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x0, 0x3, 0x88,
    0x8c, 0x98, 0x88, 0x8f, 0xe8, 0x88, 0x50, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xce, 0x0, 0x0, 0x0, 0x0, 0x3, 0x77, 0x77,
    0x77, 0x7e, 0xf7, 0x77, 0x77, 0x77, 0x70, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf9, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf9,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfc, 0x0, 0x1e, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x2c, 0xfc, 0x10, 0x0, 0x2e, 0xf9, 0x10, 0x0,
    0x3, 0xaf, 0xf8, 0x0, 0x0, 0x0, 0x1b, 0xff,
    0x93, 0x7, 0xff, 0x92, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xdf, 0xe1, 0x6, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x33, 0x0,

    /* U+518D "再" */
    0x3, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x20, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x33, 0x33, 0x3f, 0xb3, 0x33, 0x33, 0x20, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0xd, 0xb2, 0x22, 0x2f, 0xa2,
    0x22, 0x2b, 0xd0, 0x0, 0x0, 0xd, 0xa0, 0x0,
    0xe, 0x90, 0x0, 0xa, 0xd0, 0x0, 0x0, 0xd,
    0xc5, 0x55, 0x5f, 0xc5, 0x55, 0x5c, 0xd0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xd0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0xe, 0x90,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xd, 0xa0, 0x0,
    0xe, 0x90, 0x0, 0xa, 0xd0, 0x0, 0x2a, 0xaf,
    0xea, 0xaa, 0xaf, 0xea, 0xaa, 0xae, 0xfa, 0xa2,
    0x2c, 0xcf, 0xec, 0xcc, 0xcc, 0xcc, 0xcc, 0xce,
    0xfc, 0xc2, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xd, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0xd,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x65, 0x5d,
    0xc0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0,
    0xcf, 0xfe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+51FA "出" */
    0x0, 0x0, 0x0, 0xb, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0xe, 0xb0, 0x0, 0x8, 0xf1,
    0xf, 0x80, 0x0, 0xe, 0xb0, 0x0, 0x8, 0xf1,
    0xf, 0x80, 0x0, 0xe, 0xb0, 0x0, 0x8, 0xf1,
    0xf, 0x80, 0x0, 0xe, 0xb0, 0x0, 0x8, 0xf1,
    0xf, 0x80, 0x0, 0xe, 0xb0, 0x0, 0x8, 0xf1,
    0xf, 0xc8, 0x88, 0x8f, 0xd8, 0x88, 0x8c, 0xf1,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x8a,
    0xeb, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xbe,
    0xeb, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xbe,
    0xeb, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xbe,
    0xeb, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xbe,
    0xeb, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0xbe,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x78, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0xde,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbe,

    /* U+5207 "切" */
    0x0, 0x3, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe8, 0x0, 0x3, 0x44, 0x44,
    0x44, 0x44, 0x42, 0x0, 0xe, 0x80, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0xe8, 0x0,
    0x2, 0x33, 0x9f, 0x33, 0x33, 0xea, 0x0, 0xe,
    0x80, 0x3, 0x20, 0x8, 0xf0, 0x0, 0xe, 0x90,
    0x2, 0xfd, 0xcf, 0xf7, 0x0, 0x8e, 0x0, 0x0,
    0xe9, 0x6f, 0xff, 0xe9, 0x62, 0x0, 0x9, 0xd0,
    0x0, 0xf, 0x83, 0x73, 0xf8, 0x0, 0x0, 0x0,
    0xbc, 0x0, 0x0, 0xf8, 0x0, 0xe, 0x80, 0x0,
    0x0, 0xd, 0xa0, 0x0, 0xf, 0x70, 0x0, 0xe8,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x1, 0xf7, 0x0,
    0xe, 0x80, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x2f,
    0x60, 0x0, 0xe8, 0x1, 0x76, 0x7, 0xf1, 0x0,
    0x3, 0xf5, 0x0, 0xe, 0xa9, 0xff, 0x60, 0xdc,
    0x0, 0x0, 0x4f, 0x40, 0x5, 0xff, 0xe7, 0x0,
    0x5f, 0x60, 0x0, 0x6, 0xf2, 0x0, 0x7e, 0x60,
    0x0, 0x1e, 0xe0, 0x0, 0x0, 0x8f, 0x10, 0x1,
    0x0, 0x0, 0xc, 0xf4, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x3d, 0xf6, 0x0, 0x38, 0x78,
    0xfa, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0, 0x2,
    0xff, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+521D "初" */
    0x0, 0x4, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x50, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x20, 0x0, 0x0, 0xbe, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x34, 0x46, 0x84,
    0x14, 0x55, 0xaf, 0x65, 0x55, 0xf7, 0xe, 0xff,
    0xff, 0xfd, 0x0, 0x7, 0xf0, 0x0, 0xf, 0x70,
    0x11, 0x11, 0x3f, 0x70, 0x0, 0x8f, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x9, 0xe0,
    0x0, 0x1f, 0x60, 0x0, 0x3, 0xf7, 0x0, 0x0,
    0xad, 0x0, 0x1, 0xf6, 0x0, 0x0, 0xdd, 0xb,
    0x90, 0xc, 0xb0, 0x0, 0x2f, 0x50, 0x0, 0xaf,
    0xd9, 0xd1, 0x0, 0xe9, 0x0, 0x2, 0xf5, 0x0,
    0x8f, 0xff, 0xf2, 0x0, 0x1f, 0x60, 0x0, 0x3f,
    0x40, 0x8f, 0xaf, 0x9e, 0xb0, 0x5, 0xf3, 0x0,
    0x4, 0xf3, 0x1f, 0xa0, 0xf8, 0x3f, 0x50, 0x9f,
    0x0, 0x0, 0x5f, 0x20, 0x40, 0xf, 0x80, 0x50,
    0xe, 0xa0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0xf8,
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0xf, 0x80, 0x0, 0xdd, 0x0, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0xf8, 0x0, 0x9f, 0x40, 0x0, 0x0,
    0xdb, 0x0, 0x0, 0xf, 0x80, 0x8f, 0x80, 0x5,
    0x66, 0x8f, 0x70, 0x0, 0x0, 0xf8, 0x7, 0xa0,
    0x0, 0x7f, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5229 "利" */
    0x0, 0x0, 0x0, 0x0, 0x52, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x14, 0x7b, 0xff, 0xc0, 0x0,
    0x0, 0x6, 0xf1, 0x1c, 0xef, 0xff, 0xd7, 0x30,
    0x0, 0x30, 0x0, 0x6f, 0x10, 0x87, 0x42, 0xe8,
    0x0, 0x0, 0x4f, 0x30, 0x6, 0xf1, 0x0, 0x0,
    0xe, 0x80, 0x0, 0x4, 0xf3, 0x0, 0x6f, 0x10,
    0x0, 0x0, 0xe8, 0x0, 0x0, 0x4f, 0x30, 0x6,
    0xf1, 0x19, 0x99, 0x9f, 0xc9, 0x99, 0x34, 0xf3,
    0x0, 0x6f, 0x11, 0xdd, 0xde, 0xfe, 0xdd, 0xd5,
    0x4f, 0x30, 0x6, 0xf1, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x4, 0xf3, 0x0, 0x6f, 0x10, 0x0, 0xe,
    0xfc, 0x10, 0x0, 0x4f, 0x30, 0x6, 0xf1, 0x0,
    0x7, 0xef, 0xfd, 0x20, 0x4, 0xf3, 0x0, 0x6f,
    0x10, 0x1, 0xf6, 0xe9, 0xbe, 0x40, 0x4f, 0x30,
    0x6, 0xf1, 0x0, 0xbd, 0xe, 0x80, 0xbf, 0x24,
    0xf3, 0x0, 0x6f, 0x10, 0x6f, 0x40, 0xe8, 0x0,
    0x70, 0x3d, 0x20, 0x6, 0xf1, 0x4f, 0x90, 0xe,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x12, 0xc0,
    0x0, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf1,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x10, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x0,
    0x67, 0x7b, 0xf0, 0x0, 0x0, 0xe, 0x80, 0x0,
    0x0, 0x8, 0xff, 0xe8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5230 "到" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x73, 0x27, 0x77, 0x77, 0x77, 0x77, 0x70, 0x10,
    0x0, 0xf7, 0x4d, 0xde, 0xfe, 0xdd, 0xdd, 0xc0,
    0xf7, 0x0, 0xf7, 0x0, 0xb, 0xe0, 0x4, 0x0,
    0x0, 0xf7, 0x0, 0xf7, 0x0, 0x4f, 0x50, 0x2f,
    0x80, 0x0, 0xf7, 0x0, 0xf7, 0x0, 0xdb, 0x0,
    0x6, 0xf5, 0x0, 0xf7, 0x0, 0xf7, 0xa, 0xf9,
    0x8a, 0xbc, 0xff, 0x20, 0xf7, 0x0, 0xf7, 0xd,
    0xfd, 0xca, 0x87, 0x6f, 0xb0, 0xf7, 0x0, 0xf7,
    0x1, 0x0, 0x18, 0x20, 0x4, 0x10, 0xf7, 0x0,
    0xf7, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0, 0xf7,
    0x0, 0xf7, 0x5, 0x55, 0x7f, 0x85, 0x55, 0x10,
    0xf7, 0x0, 0xf7, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xf7, 0x0, 0xf7, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0xf7, 0x0, 0xf7, 0x0, 0x0, 0x2f,
    0x40, 0x0, 0x0, 0xf7, 0x0, 0xf7, 0x0, 0x0,
    0x2f, 0x41, 0x47, 0x50, 0x0, 0x0, 0xf7, 0x1,
    0x46, 0xaf, 0xff, 0xfd, 0x60, 0x0, 0x0, 0xf7,
    0x7f, 0xfe, 0xc9, 0x63, 0x0, 0x0, 0x7, 0x78,
    0xf6, 0x24, 0x10, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xfe, 0xb1,

    /* U+52A0 "加" */
    0x0, 0x0, 0x83, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x2, 0x55, 0x55, 0x55, 0x20, 0x0, 0x2f, 0x50,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xf7, 0xf, 0xff,
    0xff, 0xff, 0xfc, 0x9, 0xe2, 0x22, 0x2f, 0x70,
    0x67, 0x8f, 0x97, 0x7d, 0xc0, 0x9e, 0x0, 0x0,
    0xf7, 0x0, 0x3, 0xf4, 0x0, 0xac, 0x9, 0xe0,
    0x0, 0xf, 0x70, 0x0, 0x3f, 0x30, 0xb, 0xb0,
    0x9e, 0x0, 0x0, 0xf7, 0x0, 0x4, 0xf2, 0x0,
    0xbb, 0x9, 0xe0, 0x0, 0xf, 0x70, 0x0, 0x6f,
    0x0, 0xc, 0xb0, 0x9e, 0x0, 0x0, 0xf7, 0x0,
    0x8, 0xe0, 0x0, 0xca, 0x9, 0xe0, 0x0, 0xf,
    0x70, 0x0, 0xbb, 0x0, 0xd, 0xa0, 0x9e, 0x0,
    0x0, 0xf7, 0x0, 0xe, 0x80, 0x0, 0xd9, 0x9,
    0xe0, 0x0, 0xf, 0x70, 0x3, 0xf4, 0x0, 0xf,
    0x80, 0x9e, 0x0, 0x0, 0xf7, 0x0, 0x8f, 0x0,
    0x0, 0xf7, 0x9, 0xe0, 0x0, 0xf, 0x70, 0x1f,
    0x90, 0x0, 0x3f, 0x50, 0x9f, 0x77, 0x77, 0xf7,
    0x9, 0xf1, 0x18, 0x8c, 0xf2, 0x9, 0xff, 0xff,
    0xff, 0x72, 0xf6, 0x0, 0xdf, 0xe7, 0x0, 0x9e,
    0x0, 0x0, 0xf7, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52A1 "务" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x7f, 0xb5, 0x55, 0x55, 0x55, 0xaf,
    0x70, 0x0, 0x0, 0x1a, 0xfd, 0xe2, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0xdf, 0x60, 0xbf,
    0x50, 0x2, 0xbf, 0x70, 0x0, 0x0, 0x0, 0x32,
    0x0, 0x8, 0xfc, 0xaf, 0xc3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x48, 0xef, 0xff, 0x94, 0x10,
    0x0, 0x0, 0x5, 0x79, 0xcf, 0xfd, 0x82, 0x28,
    0xdf, 0xfe, 0xca, 0x70, 0xb, 0xec, 0x95, 0x10,
    0x15, 0x10, 0x1, 0x47, 0xac, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x36, 0x66, 0x66, 0xbf, 0x66, 0x66, 0x67,
    0x71, 0x0, 0x0, 0x7e, 0xee, 0xee, 0xff, 0xee,
    0xee, 0xef, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf2, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x80, 0x0, 0x0, 0xb, 0xc0, 0x0,
    0x0, 0x0, 0x18, 0xf9, 0x0, 0x0, 0x0, 0xf,
    0x90, 0x0, 0x1, 0x49, 0xfe, 0x60, 0x0, 0x24,
    0x43, 0x9f, 0x40, 0x0, 0x7, 0xfc, 0x60, 0x0,
    0x0, 0x1f, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52B9 "効" */
    0x0, 0x0, 0x77, 0x0, 0x0, 0x0, 0x7, 0x40,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0xd8, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0xd, 0x80, 0x0, 0x0, 0xce, 0xee, 0xfe,
    0xee, 0xe5, 0x0, 0xd7, 0x0, 0x0, 0x6, 0x77,
    0x77, 0x77, 0x77, 0x32, 0x2e, 0x82, 0x23, 0x10,
    0x0, 0x97, 0x0, 0x94, 0x4, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x3f, 0x40, 0x9, 0xe1, 0x14, 0x4f,
    0x94, 0x4e, 0x70, 0xd, 0xb0, 0x0, 0xd, 0xb0,
    0x0, 0xf5, 0x0, 0xe7, 0xa, 0xe1, 0x0, 0x6,
    0x5f, 0x50, 0x1f, 0x40, 0xf, 0x60, 0xd5, 0x42,
    0x3, 0xf3, 0x94, 0x3, 0xf2, 0x0, 0xf6, 0x1,
    0xc, 0xd1, 0x9e, 0x0, 0x0, 0x5f, 0x0, 0xf,
    0x50, 0x0, 0x1d, 0xce, 0x80, 0x0, 0x8, 0xe0,
    0x1, 0xf5, 0x0, 0x0, 0x2e, 0xf1, 0x0, 0x0,
    0xba, 0x0, 0x1f, 0x40, 0x0, 0x1, 0xff, 0x80,
    0x0, 0x1f, 0x60, 0x2, 0xf3, 0x0, 0x0, 0xbe,
    0x9f, 0x40, 0x6, 0xf1, 0x0, 0x3f, 0x20, 0x0,
    0x8f, 0x40, 0xcd, 0x0, 0xea, 0x0, 0x5, 0xf0,
    0x0, 0x8f, 0x70, 0x2, 0x40, 0x9f, 0x20, 0x0,
    0x7e, 0x1, 0xbf, 0x70, 0x0, 0x0, 0x6f, 0x70,
    0x45, 0x5e, 0xb0, 0xa, 0x50, 0x0, 0x0, 0xc,
    0x90, 0x6, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52D9 "務" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff,
    0xd0, 0x8, 0xf1, 0x0, 0x0, 0x0, 0x3, 0x44,
    0x44, 0x6f, 0xa0, 0x2f, 0xfe, 0xee, 0xef, 0x60,
    0x0, 0x0, 0x0, 0xce, 0x11, 0xdf, 0x65, 0x55,
    0x9f, 0x20, 0x0, 0x5d, 0x29, 0xf3, 0x1d, 0xed,
    0xa0, 0x0, 0xca, 0x0, 0x0, 0xc, 0xff, 0x40,
    0x2c, 0x33, 0xf8, 0x9, 0xe1, 0x0, 0x0, 0x1,
    0xdd, 0x0, 0x0, 0x0, 0x4f, 0xdf, 0x30, 0x0,
    0x8, 0x88, 0xbe, 0x88, 0x92, 0x0, 0x4e, 0xfe,
    0x40, 0x0, 0xc, 0xcd, 0xff, 0xcd, 0xf5, 0x6d,
    0xf9, 0x2a, 0xfd, 0x72, 0x0, 0x4, 0xfe, 0x5,
    0xed, 0xe9, 0x45, 0x0, 0x3a, 0xe3, 0x0, 0xc,
    0xfe, 0xa, 0xa1, 0x0, 0x7f, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x9e, 0xf, 0x45, 0x55, 0xce, 0x55,
    0x56, 0x30, 0x1, 0xe8, 0x8e, 0x5, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0x80, 0xb, 0xe0, 0x8e, 0x0,
    0x0, 0x2, 0xf5, 0x0, 0xf, 0x60, 0xd, 0x30,
    0x8e, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x5f, 0x70, 0x0,
    0x5f, 0x20, 0x0, 0x35, 0xbe, 0x0, 0x6, 0xfb,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x6f, 0xf8, 0x3,
    0xcf, 0x90, 0x4, 0x55, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xa3, 0x0, 0x5, 0xff, 0xd2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+5316 "化" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe6, 0x0, 0x79,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0xbe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x30, 0x0, 0xbe, 0x0, 0x0,
    0x3e, 0x40, 0x0, 0x4, 0xfb, 0x0, 0x0, 0xbe,
    0x0, 0x1, 0xdf, 0x30, 0x0, 0x1e, 0xfa, 0x0,
    0x0, 0xbe, 0x0, 0xc, 0xf6, 0x0, 0x0, 0xcf,
    0xfa, 0x0, 0x0, 0xbe, 0x0, 0xbf, 0x80, 0x0,
    0xb, 0xf7, 0xea, 0x0, 0x0, 0xbe, 0x1b, 0xf8,
    0x0, 0x0, 0xc, 0xa0, 0xea, 0x0, 0x0, 0xbf,
    0xdf, 0x70, 0x0, 0x0, 0x1, 0x0, 0xea, 0x0,
    0x0, 0xbf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xea, 0x0, 0x1a, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xea, 0x6, 0xef, 0xee, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xea, 0x3f, 0xb2, 0xbe,
    0x0, 0x0, 0x3, 0x50, 0x0, 0x0, 0xea, 0x1,
    0x0, 0xbe, 0x0, 0x0, 0x6, 0xf2, 0x0, 0x0,
    0xea, 0x0, 0x0, 0xbe, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0xea, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0xea, 0x0, 0x0, 0x8f,
    0x98, 0x88, 0x8f, 0xa0, 0x0, 0x0, 0xea, 0x0,
    0x0, 0x1c, 0xff, 0xff, 0xfc, 0x20, 0x0, 0x0,
    0xea, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5347 "升" */
    0x0, 0x0, 0x0, 0x0, 0x17, 0x20, 0x9, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xf9, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x4, 0x8d, 0xfe, 0x93,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x7f, 0xfd, 0xdf,
    0x10, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x3, 0x62,
    0x7, 0xf1, 0x0, 0x0, 0xe, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0xe,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x10, 0x0,
    0x0, 0xe9, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x88, 0x88,
    0xbf, 0x88, 0x88, 0x88, 0xfc, 0x88, 0x87, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0,
    0xe, 0x90, 0x0, 0x0, 0x0, 0x3, 0xf7, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x10, 0x0, 0x0, 0xe, 0x90, 0x0, 0x0, 0x0,
    0x6f, 0x90, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0x0, 0x5f, 0xd0, 0x0, 0x0, 0x0, 0xe, 0x90,
    0x0, 0x0, 0x9f, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x8, 0xa1, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5361 "卡" */
    0x0, 0x0, 0x0, 0x1, 0xc6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfb, 0x77, 0x77, 0x77, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x6, 0x77, 0x77, 0x77, 0x8f, 0xb7,
    0x77, 0x77, 0x77, 0x70, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x86, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0xbf,
    0xe8, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x80, 0x3a, 0xff, 0xa3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x2, 0x9f, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x14, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+53CB "友" */
    0x0, 0x0, 0x0, 0x1d, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x77,
    0x77, 0x9f, 0x97, 0x77, 0x77, 0x77, 0x77, 0x60,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfc, 0x55, 0x55, 0x55, 0x56, 0x10, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x7, 0xff, 0x51, 0x11,
    0x11, 0x7f, 0x40, 0x0, 0x0, 0x0, 0xd, 0xcb,
    0xc0, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x73, 0xf7, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x10, 0x8f, 0x40, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0xb, 0xf6,
    0xed, 0x10, 0x0, 0x0, 0x0, 0xd, 0xe1, 0x0,
    0x0, 0xdf, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x60, 0x0, 0x1a, 0xfe, 0xfd, 0x50, 0x0, 0x0,
    0x9, 0xfa, 0x0, 0x3a, 0xff, 0x70, 0x4d, 0xfd,
    0x83, 0x0, 0x4, 0xa0, 0xd, 0xfe, 0x81, 0x0,
    0x0, 0x5b, 0xff, 0xe1, 0x0, 0x0, 0x5, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x15, 0x50,

    /* U+53D1 "发" */
    0x0, 0x0, 0x10, 0x0, 0xc, 0x70, 0x0, 0x50,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x1f, 0x90,
    0x3, 0xfa, 0x0, 0x0, 0x0, 0x1, 0xf9, 0x0,
    0x4f, 0x70, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x7,
    0xf3, 0x0, 0x7f, 0x40, 0x0, 0x7, 0xd0, 0x0,
    0x0, 0x1e, 0xd3, 0x33, 0xbf, 0x43, 0x33, 0x33,
    0x43, 0x20, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0x0, 0x15, 0x33, 0x36,
    0xf9, 0x33, 0x33, 0x33, 0x33, 0x20, 0x0, 0x0,
    0x0, 0x9, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf7, 0x77, 0x77, 0x78,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xd0, 0x0, 0x0, 0x6f, 0x50, 0x0, 0x0, 0x0,
    0x9, 0xf7, 0xf8, 0x0, 0x0, 0xed, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xb0, 0x7f, 0x40, 0xa, 0xf3,
    0x0, 0x0, 0x0, 0x4, 0xfe, 0x10, 0xb, 0xf3,
    0x9f, 0x70, 0x0, 0x0, 0x0, 0x5f, 0xe2, 0x0,
    0x0, 0xcf, 0xf8, 0x0, 0x0, 0x0, 0x9, 0xfe,
    0x20, 0x0, 0x4, 0xdf, 0xfb, 0x20, 0x0, 0x0,
    0xc, 0xb1, 0x0, 0x5, 0xcf, 0xc3, 0x6f, 0xfa,
    0x40, 0x0, 0x0, 0x0, 0x9, 0xef, 0xd5, 0x0,
    0x1, 0x8e, 0xff, 0xb1, 0x0, 0x0, 0x6, 0x83,
    0x0, 0x0, 0x0, 0x0, 0x49, 0x70,

    /* U+53EF "可" */
    0x46, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0xfb, 0x11, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xea, 0x0, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0xae, 0x77, 0x77, 0x7f, 0x90, 0x0,
    0xea, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0xe9,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0xad, 0x0, 0x0,
    0xe, 0x90, 0x0, 0xea, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0xe9, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0xe, 0x90, 0x0, 0xea, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xf9, 0x0, 0xe,
    0xa0, 0x0, 0x0, 0xae, 0x88, 0x88, 0x88, 0x40,
    0x0, 0xea, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x98, 0x89, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xff,
    0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+540E "后" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36,
    0x80, 0x0, 0x0, 0x0, 0x12, 0x35, 0x68, 0xac,
    0xef, 0xff, 0xe7, 0x0, 0x0, 0xc, 0xff, 0xff,
    0xfd, 0xca, 0x86, 0x31, 0x0, 0x0, 0x0, 0xc,
    0xd3, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xd4, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x41, 0x0, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0xc,
    0xd3, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30,
    0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0xf,
    0x80, 0x8f, 0x77, 0x77, 0x77, 0x77, 0xdd, 0x0,
    0x0, 0x3f, 0x60, 0x8f, 0x0, 0x0, 0x0, 0x0,
    0xbd, 0x0, 0x0, 0x6f, 0x30, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0xaf, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x1, 0xfc,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0xbd, 0x0,
    0x8, 0xf6, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0xe, 0xf1, 0x0, 0x8f, 0x77, 0x77,
    0x77, 0x77, 0xdd, 0x0, 0x4, 0x70, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0, 0xbd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+542C "听" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x28,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x69,
    0xdf, 0xfa, 0x0, 0x7f, 0xff, 0xff, 0x10, 0x8f,
    0xff, 0xd9, 0x51, 0x0, 0x7, 0xf7, 0x7b, 0xf1,
    0x8, 0xf4, 0x10, 0x0, 0x0, 0x0, 0x7f, 0x0,
    0x6f, 0x10, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf0, 0x6, 0xf1, 0x8, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x0, 0x6f, 0x10, 0x8f, 0x77, 0x77,
    0x77, 0x77, 0x7, 0xf0, 0x6, 0xf1, 0x8, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x7f, 0x0, 0x6f, 0x10,
    0x9f, 0x0, 0x1, 0xf7, 0x0, 0x7, 0xf0, 0x6,
    0xf1, 0x9, 0xf0, 0x0, 0x1f, 0x70, 0x0, 0x7f,
    0x0, 0x6f, 0x10, 0xae, 0x0, 0x1, 0xf7, 0x0,
    0x7, 0xf0, 0x6, 0xf1, 0xc, 0xd0, 0x0, 0x1f,
    0x70, 0x0, 0x7f, 0xff, 0xff, 0x10, 0xeb, 0x0,
    0x1, 0xf7, 0x0, 0x7, 0xf8, 0x88, 0x80, 0x1f,
    0x80, 0x0, 0x1f, 0x70, 0x0, 0x7f, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x10,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x0, 0x0,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x39, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0,

    /* U+542F "启" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0xb, 0xe7, 0x77,
    0x77, 0x77, 0x77, 0x77, 0xf9, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0xb,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0xb, 0xe7, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x74, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xb1, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x0, 0xe, 0xa7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xf, 0x87, 0xf3,
    0x33, 0x33, 0x33, 0x33, 0xaf, 0x0, 0x3f, 0x67,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x7f,
    0x27, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x0,
    0xde, 0x7, 0xf2, 0x22, 0x22, 0x22, 0x22, 0xaf,
    0x4, 0xf9, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd, 0xf2, 0x7, 0xf3, 0x33, 0x33, 0x33,
    0x33, 0xaf, 0x6, 0x90, 0x7, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+544A "告" */
    0x0, 0x3, 0x71, 0x0, 0x7d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x90, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x3, 0xfb, 0x66, 0x66,
    0xbf, 0x66, 0x66, 0x66, 0x10, 0xd, 0xe1, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x24,
    0x22, 0x22, 0x22, 0xaf, 0x22, 0x22, 0x22, 0x21,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x8f, 0x66, 0x66,
    0x66, 0x66, 0x66, 0xf8, 0x0, 0x0, 0x8f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x8f, 0x77, 0x77, 0x77, 0x77, 0x77,
    0xf8, 0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+547D "命" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xfd, 0xce, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xc1, 0xc, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4d, 0xf9, 0x0, 0x0, 0x9f, 0xd4,
    0x0, 0x0, 0x0, 0x5c, 0xfe, 0xb6, 0x66, 0x66,
    0x6b, 0xef, 0xc6, 0x10, 0x1e, 0xfe, 0x71, 0xff,
    0xff, 0xff, 0xfe, 0x8, 0xef, 0xe1, 0x6, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x40,
    0x0, 0x27, 0x66, 0x66, 0x40, 0x16, 0x66, 0x66,
    0x73, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xa0, 0x3f,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x7f, 0x0, 0xc,
    0xa0, 0x3f, 0x30, 0x0, 0xe8, 0x0, 0x0, 0x7f,
    0x0, 0xc, 0xa0, 0x3f, 0x30, 0x0, 0xe8, 0x0,
    0x0, 0x7f, 0x0, 0xc, 0xa0, 0x3f, 0x30, 0x0,
    0xe8, 0x0, 0x0, 0x7f, 0x0, 0xc, 0xa0, 0x3f,
    0x30, 0x0, 0xe8, 0x0, 0x0, 0x7f, 0xdd, 0xdf,
    0xa0, 0x3f, 0x33, 0x66, 0xf8, 0x0, 0x0, 0x7f,
    0x77, 0x77, 0x40, 0x3f, 0x34, 0xff, 0xd3, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x30, 0x0, 0x0, 0x0,

    /* U+54CD "响" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x92, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,
    0x0, 0x0, 0x6e, 0xdd, 0xd4, 0x0, 0x0, 0x3f,
    0x80, 0x0, 0x0, 0x8e, 0x99, 0xf5, 0x5, 0x55,
    0xbf, 0x75, 0x55, 0x73, 0x8d, 0x0, 0xe5, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x8d, 0x0, 0xe5,
    0xf, 0x60, 0x0, 0x0, 0x0, 0xcb, 0x8d, 0x0,
    0xe5, 0xf, 0x60, 0x0, 0x0, 0x0, 0xcb, 0x8d,
    0x0, 0xe5, 0xf, 0x60, 0xff, 0xff, 0xc0, 0xcb,
    0x8d, 0x0, 0xe5, 0xf, 0x61, 0xf2, 0x26, 0xc0,
    0xcb, 0x8d, 0x0, 0xe5, 0xf, 0x61, 0xf0, 0x4,
    0xc0, 0xcb, 0x8d, 0x0, 0xe5, 0xf, 0x61, 0xf0,
    0x4, 0xc0, 0xcb, 0x8d, 0x0, 0xe5, 0xf, 0x61,
    0xf0, 0x4, 0xc0, 0xcb, 0x8f, 0xff, 0xf5, 0xf,
    0x61, 0xf2, 0x26, 0xc0, 0xcb, 0x8e, 0x66, 0x62,
    0xf, 0x61, 0xff, 0xff, 0xc0, 0xcb, 0x8d, 0x0,
    0x0, 0xf, 0x61, 0xf0, 0x0, 0x0, 0xcb, 0x12,
    0x0, 0x0, 0xf, 0x60, 0x10, 0x0, 0x0, 0xcb,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0x46, 0xea, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x0, 0x8f, 0xd4,

    /* U+554F "問" */
    0x5f, 0xff, 0xff, 0xff, 0x6, 0xff, 0xff, 0xff,
    0xd6, 0xf5, 0x44, 0x4d, 0xf1, 0x6f, 0x44, 0x44,
    0xcd, 0x6f, 0x20, 0x0, 0xcf, 0x16, 0xf0, 0x0,
    0xb, 0xd6, 0xff, 0xff, 0xff, 0xf1, 0x6f, 0xff,
    0xff, 0xfd, 0x6f, 0x21, 0x11, 0xcf, 0x16, 0xf1,
    0x11, 0x1b, 0xd6, 0xf3, 0x11, 0x1c, 0xf1, 0x6f,
    0x11, 0x11, 0xbd, 0x6f, 0xff, 0xff, 0xff, 0x16,
    0xff, 0xff, 0xff, 0xd6, 0xf3, 0x11, 0x11, 0x10,
    0x2, 0x22, 0x22, 0xbd, 0x6f, 0x10, 0x2, 0x11,
    0x11, 0x11, 0x0, 0xa, 0xd6, 0xf1, 0x4, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0xad, 0x6f, 0x10, 0x4f,
    0x43, 0x33, 0x3f, 0x50, 0xa, 0xd6, 0xf1, 0x4,
    0xf2, 0x0, 0x0, 0xf5, 0x0, 0xad, 0x6f, 0x10,
    0x4f, 0x20, 0x0, 0xf, 0x50, 0xa, 0xd6, 0xf1,
    0x4, 0xf6, 0x55, 0x55, 0xf5, 0x0, 0xad, 0x6f,
    0x10, 0x4f, 0xff, 0xff, 0xff, 0x50, 0xa, 0xd6,
    0xf1, 0x4, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xad,
    0x6f, 0x10, 0x2, 0x0, 0x0, 0x0, 0x77, 0x7e,
    0xc6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xe5, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+555F "啟" */
    0x0, 0x0, 0x1a, 0x20, 0x0, 0x0, 0x8, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0, 0x0,
    0xd, 0x90, 0x0, 0x0, 0x0, 0x1, 0x18, 0xf1,
    0x11, 0x0, 0x1f, 0x60, 0x0, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0x10, 0x5f, 0x30, 0x0, 0x0,
    0x0, 0xbc, 0x44, 0x44, 0x7f, 0x10, 0x9f, 0xff,
    0xff, 0xf2, 0x0, 0xbb, 0x0, 0x0, 0x4f, 0x10,
    0xec, 0x55, 0x8f, 0x70, 0x0, 0xbb, 0x0, 0x0,
    0x4f, 0x14, 0xfb, 0x0, 0x6f, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0x1c, 0xfe, 0x0, 0x9d, 0x0,
    0x0, 0xbd, 0x66, 0x66, 0x66, 0x5f, 0x8f, 0x20,
    0xd9, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0, 0x7,
    0xd, 0x71, 0xf5, 0x0, 0x0, 0xc9, 0x22, 0x22,
    0x22, 0x0, 0x9, 0xc6, 0xf1, 0x0, 0x0, 0xe8,
    0xff, 0xff, 0xff, 0x50, 0x4, 0xfd, 0xc0, 0x0,
    0x0, 0xf7, 0xf5, 0x22, 0x2f, 0x50, 0x0, 0xef,
    0x50, 0x0, 0x2, 0xf4, 0xf4, 0x0, 0xf, 0x50,
    0x0, 0xcf, 0x20, 0x0, 0x5, 0xf1, 0xf4, 0x0,
    0xf, 0x50, 0x6, 0xff, 0xb0, 0x0, 0xa, 0xc0,
    0xf6, 0x22, 0x2f, 0x50, 0x5f, 0x94, 0xf8, 0x0,
    0x1f, 0x70, 0xff, 0xff, 0xff, 0x58, 0xfb, 0x0,
    0x8f, 0x90, 0x1a, 0x10, 0xf5, 0x11, 0x1f, 0x6d,
    0x90, 0x0, 0x7, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5668 "器" */
    0x0, 0x6f, 0xff, 0xff, 0xb0, 0xe, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x7f, 0x55, 0x5c, 0xc0, 0xf,
    0xa5, 0x55, 0xf8, 0x0, 0x0, 0x7e, 0x0, 0xa,
    0xc0, 0xf, 0x70, 0x0, 0xf8, 0x0, 0x0, 0x7e,
    0x0, 0xa, 0xc0, 0xf, 0x70, 0x0, 0xf8, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xc0, 0xf, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x25, 0x55, 0x55, 0xaa, 0x5,
    0x8c, 0x65, 0x52, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xea, 0x0, 0x3c, 0xe6, 0x0, 0x0, 0x5, 0x66,
    0x66, 0x6b, 0xf7, 0x66, 0x66, 0xcd, 0x66, 0x60,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0xa, 0xf6, 0x0, 0x0,
    0xce, 0x30, 0x0, 0x0, 0x0, 0x3, 0xdf, 0x50,
    0x0, 0x0, 0xa, 0xf9, 0x10, 0x0, 0x2, 0x9f,
    0xf8, 0x55, 0x40, 0x5, 0x55, 0xbf, 0xf9, 0x30,
    0x1f, 0xff, 0xff, 0xff, 0xc0, 0xe, 0xff, 0xff,
    0xff, 0xe1, 0x2, 0x7f, 0x0, 0xb, 0xc0, 0xe,
    0x70, 0x0, 0xf8, 0x10, 0x0, 0x7f, 0x0, 0xb,
    0xc0, 0xe, 0x70, 0x0, 0xf8, 0x0, 0x0, 0x7f,
    0x55, 0x5c, 0xc0, 0xe, 0xa5, 0x55, 0xf8, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xc0, 0xe, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x7f, 0x0, 0xb, 0xc0, 0xe,
    0x70, 0x0, 0xf8, 0x0,

    /* U+5728 "在" */
    0x0, 0x0, 0x0, 0x2, 0x61, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 0x77, 0x78,
    0xfc, 0x77, 0x77, 0x77, 0x77, 0x77, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x3, 0x10, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xe1, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xf6, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xdf,
    0x60, 0x35, 0x55, 0x6f, 0xa5, 0x55, 0x50, 0x2,
    0xdf, 0xf6, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xee, 0x4f, 0x60, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0x0, 0x5, 0x21, 0xf6, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0x1, 0xf6,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x60, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0x0, 0x1, 0xf6, 0x1, 0x11, 0x12, 0xf8, 0x11,
    0x11, 0x10, 0x0, 0x1f, 0x65, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x1, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5831 "報" */
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x1, 0x11, 0x11,
    0x12, 0x0, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0x60, 0x6, 0xff, 0xff, 0xff,
    0xf2, 0x9d, 0x44, 0x44, 0x4f, 0x60, 0x2, 0x55,
    0x8f, 0x65, 0x50, 0x9c, 0x0, 0x0, 0xf, 0x60,
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x9c, 0x0, 0x0,
    0xf, 0x60, 0x9, 0x99, 0xbf, 0xa9, 0x95, 0x9c,
    0x0, 0xcd, 0xdf, 0x40, 0xc, 0xcc, 0xcc, 0xcd,
    0xc7, 0x9c, 0x0, 0x46, 0x63, 0x0, 0x0, 0x7c,
    0x0, 0xf, 0x60, 0x9d, 0x11, 0x11, 0x12, 0x0,
    0x0, 0x2f, 0x20, 0x7e, 0x0, 0x9f, 0xff, 0xff,
    0xff, 0xc0, 0x3, 0x4d, 0x74, 0xea, 0x41, 0x9d,
    0xe8, 0x22, 0x2e, 0x90, 0xa, 0xff, 0xff, 0xff,
    0xf4, 0x9c, 0x9c, 0x0, 0x2f, 0x50, 0x0, 0x0,
    0x4f, 0x10, 0x0, 0x9c, 0x3f, 0x30, 0x8f, 0x0,
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x9c, 0xc, 0xb0,
    0xe9, 0x0, 0xf, 0xff, 0xff, 0xff, 0xfa, 0x9c,
    0x4, 0xfb, 0xf2, 0x0, 0x5, 0x55, 0x8f, 0x65,
    0x53, 0x9c, 0x0, 0xbf, 0xa0, 0x0, 0x0, 0x0,
    0x4f, 0x10, 0x0, 0x9c, 0x0, 0xcf, 0xd1, 0x0,
    0x0, 0x0, 0x4f, 0x10, 0x0, 0x9c, 0xb, 0xf8,
    0xfd, 0x30, 0x0, 0x0, 0x4f, 0x10, 0x0, 0x9e,
    0xcf, 0x60, 0x4f, 0xf4, 0x0, 0x0, 0x4f, 0x10,
    0x0, 0x9d, 0xd5, 0x0, 0x3, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5907 "备" */
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x41, 0x11,
    0x11, 0x10, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x1,
    0xbf, 0xd3, 0x33, 0x33, 0x4d, 0xf5, 0x0, 0x0,
    0x0, 0x5e, 0xf8, 0xfb, 0x10, 0x2, 0xcf, 0x50,
    0x0, 0x0, 0x2, 0xeb, 0x10, 0x4e, 0xe6, 0x8f,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x3,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x37, 0xcf, 0xe9, 0x9f, 0xfd, 0x95, 0x10, 0x0,
    0x29, 0xcf, 0xff, 0xb5, 0x0, 0x0, 0x5a, 0xef,
    0xff, 0xc2, 0xc, 0xbb, 0x95, 0x55, 0x55, 0x55,
    0x55, 0x57, 0x88, 0x70, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x9,
    0xf0, 0x0, 0xe, 0x90, 0x0, 0x2f, 0x80, 0x0,
    0x0, 0x9, 0xf0, 0x0, 0xe, 0x90, 0x0, 0x2f,
    0x80, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x9, 0xf4, 0x44,
    0x4f, 0xb4, 0x44, 0x6f, 0x80, 0x0, 0x0, 0x9,
    0xf0, 0x0, 0xe, 0x90, 0x0, 0x2f, 0x80, 0x0,
    0x0, 0x9, 0xf9, 0x99, 0x9f, 0xd9, 0x99, 0xaf,
    0x80, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5927 "大" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x5, 0x88,
    0x88, 0x88, 0xaf, 0xfb, 0x88, 0x88, 0x88, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x8f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf8, 0x2f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf2, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xa0, 0x2, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0x10, 0x0,
    0x8f, 0x70, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x2,
    0xdf, 0x70, 0x0, 0x0, 0x1, 0xef, 0x70, 0x0,
    0x0, 0x7f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x2d,
    0xfb, 0x30, 0xb, 0xfd, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xd0, 0x1, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x20,

    /* U+5931 "失" */
    0x0, 0x0, 0x48, 0x10, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfa, 0x77, 0x7f, 0xd7, 0x77, 0x77, 0x72, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x6f, 0x60, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf3,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x8, 0x88, 0x88, 0x88,
    0xcf, 0xfb, 0x88, 0x88, 0x88, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xce, 0xdc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf8, 0x5f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xef,
    0x30, 0x1, 0xee, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xf4, 0x0, 0x0, 0x2e, 0xf7, 0x0, 0x0,
    0x1, 0x7e, 0xfc, 0x20, 0x0, 0x0, 0x1, 0xcf,
    0xe8, 0x20, 0xc, 0xfc, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xcf, 0xf1, 0x2, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x30,

    /* U+597D "好" */
    0x0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x1, 0x55,
    0x55, 0x55, 0x55, 0x0, 0x0, 0xb, 0xc0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0xe,
    0x90, 0x0, 0x0, 0x11, 0x11, 0x13, 0xfb, 0x0,
    0x17, 0x8f, 0xb7, 0x77, 0x20, 0x0, 0x0, 0x1d,
    0xd1, 0x0, 0x2e, 0xff, 0xfe, 0xef, 0x50, 0x0,
    0x1, 0xdd, 0x10, 0x0, 0x0, 0x7f, 0x0, 0x1f,
    0x30, 0x0, 0xd, 0xd1, 0x0, 0x0, 0x0, 0xbc,
    0x0, 0x4f, 0x10, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0xe8, 0x0, 0x7e, 0x24, 0x44, 0x4f, 0xb4,
    0x44, 0x40, 0x3, 0xf4, 0x0, 0xba, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x7, 0xf1, 0x0, 0xf6,
    0x12, 0x22, 0x2f, 0xb2, 0x22, 0x20, 0x6, 0xfe,
    0x35, 0xf1, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0x3e, 0xfd, 0xc0, 0x0, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x0, 0x1, 0xcf, 0x90, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf8,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0xa,
    0xf3, 0xbf, 0x50, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0x9f, 0x60, 0xc, 0x30, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x2c, 0xf7, 0x0, 0x0, 0x0, 0x36,
    0x6f, 0x90, 0x0, 0x0, 0xb, 0x40, 0x0, 0x0,
    0x0, 0x5f, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+59CB "始" */
    0x0, 0x3, 0x60, 0x0, 0x0, 0x0, 0x45, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0, 0x0,
    0xdd, 0x0, 0x0, 0x0, 0x0, 0xb, 0xa0, 0x0,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x0, 0xd, 0xd0, 0x5, 0x40, 0x0,
    0x17, 0x8f, 0xa7, 0x75, 0x0, 0x6f, 0x40, 0x9,
    0xf2, 0x0, 0x2e, 0xff, 0xee, 0xfb, 0x1, 0xea,
    0x0, 0x0, 0xdc, 0x0, 0x0, 0x7e, 0x0, 0xb9,
    0xb, 0xe1, 0x0, 0x1, 0x6f, 0x60, 0x0, 0xbb,
    0x0, 0xd8, 0x8f, 0xed, 0xef, 0xff, 0xff, 0xe0,
    0x0, 0xe7, 0x0, 0xf5, 0x8c, 0xa9, 0x76, 0x54,
    0x23, 0xf6, 0x2, 0xf3, 0x3, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x40, 0x7, 0xf0, 0x7, 0xf0,
    0x5, 0x66, 0x66, 0x66, 0x66, 0x20, 0x6, 0xfc,
    0x1b, 0xb0, 0xc, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x3e, 0xef, 0x60, 0xc, 0xa0, 0x0, 0x0,
    0x2f, 0x50, 0x0, 0x1, 0xdf, 0x50, 0xc, 0xa0,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x1, 0xef, 0xf4,
    0xc, 0xa0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0xa,
    0xf2, 0xcf, 0xc, 0xa0, 0x0, 0x0, 0x2f, 0x50,
    0x0, 0x8f, 0x60, 0x16, 0xc, 0xc6, 0x66, 0x66,
    0x7f, 0x50, 0xa, 0xf8, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x9, 0x60, 0x0, 0x0,
    0xc, 0xa0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5B8C "完" */
    0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x77, 0x77, 0x77,
    0x7f, 0xe7, 0x77, 0x77, 0x77, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x10, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x10, 0x6, 0xf1, 0xbf, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x7f, 0x10, 0x0, 0x0,
    0x46, 0x66, 0x66, 0x66, 0x66, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x50, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0,
    0x0, 0xdb, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0xb, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf6, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf2,
    0x0, 0xb, 0xc0, 0x0, 0x6, 0x90, 0x0, 0x0,
    0x6f, 0x90, 0x0, 0xb, 0xc0, 0x0, 0x9, 0xf0,
    0x0, 0x5b, 0xfb, 0x0, 0x0, 0xb, 0xe6, 0x66,
    0x6d, 0xe0, 0xc, 0xfc, 0x50, 0x0, 0x0, 0x4,
    0xef, 0xff, 0xfe, 0x50, 0x2, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5B9A "定" */
    0x0, 0x0, 0x0, 0x0, 0x2b, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x77, 0x77, 0x77,
    0x7d, 0xf8, 0x77, 0x77, 0x77, 0x30, 0x5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x5, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x70, 0x5, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x70, 0x5, 0xe1, 0x7a, 0xaa,
    0xaa, 0xaa, 0xaa, 0xa9, 0x1e, 0x60, 0x0, 0x0,
    0x9d, 0xdd, 0xdf, 0xfd, 0xdd, 0xdc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x57, 0x0, 0xc, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0xc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xea, 0x0, 0xc, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x2, 0xfb, 0x0, 0xc, 0xe7, 0x77, 0x77,
    0x50, 0x0, 0x0, 0x7, 0xff, 0x30, 0xc, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xbb, 0xe2,
    0xc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x31, 0xdf, 0x7d, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf9, 0x0, 0x1a, 0xff, 0xfa, 0x88, 0x88,
    0x88, 0x81, 0xd, 0xc0, 0x0, 0x0, 0x28, 0xbd,
    0xff, 0xff, 0xff, 0xe0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5BFB "寻" */
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x2, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x6f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x4,
    0x44, 0x44, 0x44, 0x44, 0x46, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x50,
    0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x2, 0x44, 0x44, 0x44, 0x44,
    0x4a, 0x84, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xea, 0x0, 0x0, 0x4, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x7f, 0xc7, 0x77, 0x70, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x10, 0x0, 0x6, 0xa0, 0x0, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x2e, 0xc1, 0x0, 0x0,
    0xea, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xc0,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x49, 0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x66, 0x7f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+5C06 "将" */
    0x0, 0x0, 0x26, 0x0, 0x0, 0x0, 0x43, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x5f,
    0xb3, 0x33, 0x30, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0x60, 0xb8, 0x6, 0xf1,
    0x4, 0xde, 0x50, 0x0, 0x1d, 0xe0, 0x6, 0xf6,
    0x6f, 0x19, 0xfa, 0x88, 0x0, 0xb, 0xf3, 0x0,
    0x8, 0xfa, 0xf1, 0x12, 0x3, 0xfa, 0x2c, 0xf4,
    0x0, 0x0, 0xc, 0xbf, 0x10, 0x0, 0x5, 0xff,
    0xd2, 0x0, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x49,
    0xfe, 0x70, 0x74, 0x0, 0x0, 0x0, 0x6f, 0x17,
    0xff, 0xc6, 0x0, 0xe, 0x90, 0x0, 0x0, 0x7,
    0xf1, 0x26, 0x10, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0x4, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x5, 0xfe, 0xf1, 0x66, 0x66, 0x66, 0x66,
    0xfb, 0x65, 0x7, 0xfa, 0x6f, 0x10, 0x3c, 0x20,
    0x0, 0xe, 0x90, 0x1, 0xfa, 0x6, 0xf1, 0x1,
    0xdd, 0x0, 0x0, 0xe9, 0x0, 0x3, 0x0, 0x6f,
    0x10, 0x3, 0xf9, 0x0, 0xe, 0x90, 0x0, 0x0,
    0x6, 0xf1, 0x0, 0x9, 0xf2, 0x0, 0xe9, 0x0,
    0x0, 0x0, 0x6f, 0x10, 0x0, 0x15, 0x0, 0xe,
    0x90, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x5,
    0x55, 0xf8, 0x0, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x0, 0xbf, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C07 "將" */
    0x0, 0x0, 0x8, 0x90, 0x0, 0x0, 0x4a, 0x10,
    0x0, 0x0, 0x4, 0xe0, 0xa, 0xc0, 0x0, 0x2,
    0xfb, 0x11, 0x12, 0x0, 0x5, 0xf0, 0xa, 0xc0,
    0x0, 0x3e, 0xff, 0xff, 0xff, 0x40, 0x5, 0xf0,
    0xa, 0xc0, 0x6, 0xfa, 0x30, 0x0, 0xae, 0x0,
    0x5, 0xf0, 0xa, 0xc3, 0xcf, 0x60, 0xcc, 0x26,
    0xf5, 0x0, 0x5, 0xf0, 0xa, 0xc5, 0xa4, 0x80,
    0x9, 0xef, 0x80, 0x0, 0x5, 0xff, 0xff, 0xc0,
    0x1, 0xcc, 0x17, 0xf9, 0x0, 0x0, 0x1, 0x54,
    0x4c, 0xc0, 0x0, 0xc, 0xff, 0x63, 0x10, 0x0,
    0x0, 0x0, 0xa, 0xc0, 0x5, 0xcf, 0xa2, 0xe,
    0x80, 0x0, 0x0, 0x0, 0xa, 0xc2, 0xff, 0xa3,
    0x0, 0xe, 0x80, 0x0, 0x2a, 0xaa, 0xae, 0xc3,
    0xa7, 0x66, 0x66, 0x6f, 0xb6, 0x60, 0x2c, 0xfc,
    0xbe, 0xc8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x1, 0xf3, 0xa, 0xc0, 0x4, 0x40, 0x0, 0xe,
    0x80, 0x0, 0x2, 0xf3, 0xa, 0xc0, 0x8, 0xf4,
    0x0, 0xe, 0x80, 0x0, 0x4, 0xf1, 0xa, 0xc0,
    0x0, 0x9f, 0x30, 0xe, 0x80, 0x0, 0x8, 0xf0,
    0xa, 0xc0, 0x0, 0xb, 0x50, 0xe, 0x80, 0x0,
    0xd, 0xc0, 0xa, 0xc0, 0x0, 0x0, 0x55, 0x6f,
    0x80, 0x0, 0x2f, 0x70, 0xa, 0xc0, 0x0, 0x0,
    0x9f, 0xfd, 0x30, 0x0, 0x8, 0x10, 0xa, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C0B "尋" */
    0x0, 0x2, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x10, 0x0, 0x0, 0xa, 0xdd, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x2f,
    0x60, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x5f, 0x60, 0x0, 0x0, 0xa, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0x50, 0x0, 0x1, 0x55,
    0x55, 0x55, 0x50, 0x25, 0x55, 0x55, 0x55, 0x0,
    0x3, 0xbb, 0xdf, 0xbb, 0xb0, 0x7f, 0xaa, 0xaa,
    0xde, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x9e, 0x0, 0x1, 0x23, 0x8f, 0x78,
    0x94, 0x7f, 0x66, 0x66, 0xbe, 0x0, 0xa, 0xff,
    0xdc, 0xba, 0x83, 0x5a, 0xad, 0xfa, 0xa9, 0x0,
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x19, 0xf1,
    0x11, 0x10, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x3, 0x33, 0x7e, 0x53,
    0x33, 0x33, 0x3a, 0xf3, 0x33, 0x30, 0x0, 0x0,
    0x3e, 0xe4, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0x30, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x0, 0x34,
    0x4b, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xfe, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C11 "少" */
    0x0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x77, 0x0, 0xf, 0x70, 0x0, 0x67, 0x0, 0x0,
    0x0, 0x0, 0xf9, 0x0, 0xf, 0x70, 0x0, 0x7f,
    0x30, 0x0, 0x0, 0x7, 0xf2, 0x0, 0xf, 0x70,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0xe, 0xa0, 0x0,
    0xf, 0x70, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x8f,
    0x20, 0x0, 0xf, 0x70, 0x0, 0x0, 0x9f, 0x10,
    0x3, 0xf8, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0x1f, 0xa0, 0x9, 0xd0, 0x0, 0x0, 0xf, 0x70,
    0x0, 0x0, 0x8, 0xa0, 0x0, 0x10, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x6, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x9f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x20, 0x9, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xbf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x8f, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x15, 0xbf, 0xf9, 0x10, 0x0, 0x0, 0x0,
    0x2, 0x46, 0x9d, 0xff, 0xd7, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xeb, 0x72, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x41, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5DF2 "已" */
    0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x60,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xb0, 0x0, 0x3, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xb0, 0x0, 0xd, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0xd, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0xd,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0xd, 0xd8, 0x88, 0x88, 0x88, 0x88, 0x8e, 0xb0,
    0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x60, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x10, 0xd, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf3, 0xd, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0xd, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x9,
    0xfb, 0x87, 0x77, 0x77, 0x77, 0x78, 0xcf, 0x70,
    0x0, 0x9d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8,
    0x0,

    /* U+5E94 "应" */
    0x0, 0x0, 0x0, 0x0, 0x5, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x24, 0x33, 0x33,
    0x33, 0xcf, 0x33, 0x33, 0x33, 0x20, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x9f, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x20, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x20,
    0x0, 0x0, 0x31, 0x0, 0x0, 0x9f, 0x0, 0x20,
    0x3, 0xf3, 0x0, 0x0, 0xdd, 0x0, 0x0, 0x9f,
    0x8, 0xe0, 0x0, 0xf8, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x9e, 0x3, 0xf4, 0x0, 0xbd, 0x0, 0x6,
    0xf3, 0x0, 0x0, 0x9e, 0x0, 0xda, 0x0, 0x7f,
    0x10, 0xc, 0xd0, 0x0, 0x0, 0xad, 0x0, 0x8f,
    0x0, 0x3f, 0x50, 0x2f, 0x70, 0x0, 0x0, 0xbc,
    0x0, 0x3f, 0x50, 0xf, 0x80, 0x8f, 0x10, 0x0,
    0x0, 0xcb, 0x0, 0xe, 0xa0, 0x9, 0x50, 0xe9,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x8, 0x70, 0x0,
    0x6, 0xf1, 0x0, 0x0, 0x2, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x90, 0x0, 0x0, 0x6, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x10, 0x0, 0x0,
    0xb, 0xe0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x1f, 0x80, 0x67, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x70, 0x3, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5EA6 "度" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x7f, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x60, 0x0, 0x7f, 0x0, 0x3, 0xe2, 0x0,
    0x0, 0xd7, 0x0, 0x0, 0x0, 0x7f, 0x12, 0x26,
    0xf4, 0x22, 0x22, 0xf9, 0x22, 0x10, 0x0, 0x7f,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x7f, 0x11, 0x15, 0xf4, 0x11, 0x11, 0xf8,
    0x11, 0x10, 0x0, 0x7f, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x8e,
    0x0, 0x1, 0x44, 0x44, 0x44, 0x42, 0x0, 0x0,
    0x0, 0xad, 0x14, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x30, 0x0, 0x0, 0xbb, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0xe9, 0x0, 0x1e,
    0xa0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x1, 0xf7,
    0x0, 0x3, 0xec, 0x20, 0x19, 0xf7, 0x0, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x2c, 0xfa, 0xfe, 0x40,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0x24, 0x8d, 0xff,
    0xfd, 0x84, 0x0, 0x0, 0x1f, 0x90, 0xcf, 0xff,
    0xc8, 0x30, 0x49, 0xef, 0xfe, 0xb0, 0x4, 0x20,
    0x45, 0x30, 0x0, 0x0, 0x0, 0x2, 0x57, 0x50,

    /* U+5F00 "开" */
    0x18, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88, 0x88,
    0x83, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x70, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0xf, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0xf9,
    0x0, 0x0, 0x5, 0x55, 0x56, 0xfa, 0x55, 0x55,
    0x5f, 0xb5, 0x55, 0x50, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x1, 0x11, 0x14,
    0xf5, 0x11, 0x11, 0x1f, 0x91, 0x11, 0x10, 0x0,
    0x0, 0x6f, 0x30, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x50, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x2e,
    0xf3, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x3, 0xd3, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5F0F "式" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7a, 0x2, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xe0,
    0x5f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xae, 0x0, 0x3e, 0xc0, 0x0, 0x11, 0x11, 0x11,
    0x11, 0x1a, 0xf1, 0x11, 0x36, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5,
    0x66, 0x66, 0x66, 0x66, 0x6a, 0xf7, 0x66, 0x66,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf4, 0x0, 0x0, 0x0, 0x1a, 0xaa, 0xaa, 0xaa,
    0xa6, 0x3f, 0x60, 0x0, 0x0, 0x2, 0xdd, 0xdf,
    0xfd, 0xdd, 0x81, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0xbd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x8,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0,
    0x0, 0x4f, 0x50, 0x0, 0x20, 0x0, 0x0, 0x9e,
    0x0, 0x2, 0x10, 0xfa, 0x0, 0xf, 0x30, 0x0,
    0x9, 0xf8, 0xbf, 0xf4, 0x9, 0xf2, 0x1, 0xf4,
    0x37, 0xad, 0xff, 0xfc, 0x84, 0x0, 0x2f, 0xb0,
    0x4f, 0x19, 0xfe, 0xb7, 0x30, 0x0, 0x0, 0x0,
    0x8f, 0xcd, 0xd0, 0x22, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0xe4, 0x0,

    /* U+5F55 "录" */
    0x4, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x81,
    0x0, 0x8, 0xee, 0xee, 0xee, 0xee, 0xee, 0xef,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x6b, 0xf0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x34, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x4c, 0xe4, 0x43, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0, 0x20, 0x0, 0x0, 0xea, 0x0, 0x0, 0x11,
    0x0, 0x4, 0xfb, 0x10, 0x0, 0xef, 0x10, 0x2,
    0xde, 0x0, 0x0, 0x5e, 0xe4, 0x0, 0xef, 0xa0,
    0x3e, 0xe3, 0x0, 0x0, 0x2, 0xce, 0x0, 0xfd,
    0xfa, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x3, 0x6d,
    0xf9, 0x9f, 0xb0, 0x0, 0x0, 0x0, 0x2, 0x8f,
    0xfa, 0xf9, 0xb, 0xf6, 0x0, 0x0, 0x4, 0xbf,
    0xf9, 0x20, 0xe9, 0x0, 0xbf, 0xb2, 0x0, 0x9f,
    0xe8, 0x10, 0x0, 0xe9, 0x0, 0x8, 0xff, 0xa4,
    0x26, 0x0, 0x4, 0x34, 0xf9, 0x0, 0x0, 0x2a,
    0xf6, 0x0, 0x0, 0xa, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+5F85 "待" */
    0x0, 0x0, 0x29, 0x20, 0x0, 0x0, 0xa6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x10, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xf3, 0x1,
    0x33, 0x33, 0xfa, 0x33, 0x33, 0x0, 0x2, 0xdf,
    0x30, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0xd, 0xe2, 0x3, 0x0, 0x22, 0x22, 0xfa, 0x22,
    0x22, 0x0, 0x3, 0x10, 0x1f, 0x80, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x35,
    0x55, 0x55, 0xfb, 0x55, 0x55, 0x51, 0x0, 0x8,
    0xf5, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x0, 0x7f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x60, 0x0, 0x7, 0xfe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x60, 0x0, 0x3f, 0xb5, 0xf2, 0x17,
    0x77, 0x77, 0x77, 0x8f, 0xb7, 0x70, 0x7, 0x4,
    0xf2, 0x3e, 0xee, 0xee, 0xee, 0xff, 0xfe, 0xe1,
    0x0, 0x4, 0xf2, 0x0, 0x4, 0x0, 0x0, 0x1f,
    0x60, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x7f, 0x40,
    0x0, 0x1f, 0x60, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0xb, 0xe1, 0x0, 0x1f, 0x60, 0x0, 0x0, 0x4,
    0xf2, 0x0, 0x2, 0xf9, 0x0, 0x1f, 0x60, 0x0,
    0x0, 0x4, 0xf2, 0x0, 0x0, 0x75, 0x0, 0x1f,
    0x60, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x66, 0x7f, 0x60, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0xcf, 0xfc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5F8C "後" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xa,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x0,
    0x0, 0x9f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xa0, 0x0, 0x9, 0xf5, 0x0, 0x1c, 0x90, 0x0,
    0x5, 0xfb, 0x0, 0x0, 0xae, 0x40, 0x2, 0xee,
    0x20, 0x0, 0xd, 0xa0, 0xb, 0x5d, 0xfe, 0xdd,
    0xef, 0xb1, 0x0, 0x0, 0x1, 0x0, 0x7f, 0x36,
    0x76, 0x6d, 0xf8, 0xc, 0x60, 0x0, 0x0, 0x2,
    0xf9, 0x0, 0x4, 0xdd, 0x30, 0x8, 0xf3, 0x0,
    0x0, 0x1d, 0xf0, 0x1, 0xaf, 0x81, 0x23, 0x45,
    0xed, 0x0, 0x0, 0xbf, 0xf0, 0x4f, 0xff, 0xff,
    0xff, 0xfe, 0xdf, 0x90, 0xb, 0xfc, 0xf0, 0x17,
    0x54, 0xaf, 0x30, 0x0, 0x7, 0xf1, 0x1e, 0x68,
    0xf0, 0x0, 0x5, 0xfa, 0x44, 0x44, 0x30, 0x20,
    0x1, 0x8, 0xf0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x8, 0xf0, 0x9, 0xff, 0x90,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x8, 0xf0, 0xcf,
    0x74, 0xf7, 0x0, 0xbf, 0x20, 0x0, 0x0, 0x8,
    0xf0, 0x33, 0x0, 0x6f, 0x8b, 0xf4, 0x0, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0xb, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x17, 0xdf,
    0xad, 0xfb, 0x40, 0x0, 0x0, 0x8, 0xf0, 0x7b,
    0xff, 0xb3, 0x0, 0x6d, 0xfe, 0x93, 0x0, 0x8,
    0xf0, 0xbb, 0x71, 0x0, 0x0, 0x0, 0x49, 0xc1,

    /* U+5FDC "応" */
    0x0, 0x0, 0x0, 0x0, 0x5, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x14, 0x33, 0x33,
    0x33, 0xce, 0x33, 0x33, 0x33, 0x30, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x9e, 0x33, 0x33, 0x34, 0x33, 0x33, 0x33,
    0x33, 0x30, 0x0, 0x9e, 0x0, 0x0, 0xd, 0xc4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x2, 0xbf, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x9e,
    0x0, 0x0, 0x0, 0x5, 0xef, 0x30, 0x0, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0x8e, 0x0, 0x17, 0x0,
    0x0, 0x0, 0x0, 0x9d, 0x1, 0x10, 0x8e, 0x0,
    0x0, 0x4, 0x60, 0x0, 0x0, 0xad, 0x6, 0xf0,
    0x8e, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0xbc,
    0x9, 0xd0, 0x8e, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0xda, 0xc, 0xa0, 0x8e, 0x0, 0x0, 0x0,
    0x7f, 0x30, 0x0, 0xf7, 0x1f, 0x60, 0x8e, 0x0,
    0x0, 0x55, 0xf, 0xa0, 0x3, 0xf4, 0x6f, 0x20,
    0x8e, 0x0, 0x0, 0x8c, 0x9, 0xf0, 0x8, 0xf1,
    0xdc, 0x0, 0x8e, 0x0, 0x0, 0xab, 0x4, 0xf4,
    0xd, 0xb0, 0x22, 0x0, 0x7f, 0x66, 0x66, 0xe8,
    0x0, 0x40, 0x2f, 0x50, 0x0, 0x0, 0x2d, 0xff,
    0xff, 0xd1, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6001 "态" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x5, 0x66, 0x66, 0x66, 0xcf, 0xee, 0x66, 0x66,
    0x66, 0x60, 0x0, 0x0, 0x0, 0x1, 0xfa, 0x6f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf2, 0xc, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x70, 0x2, 0xed, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x1b, 0xfb, 0xca, 0x10, 0x3e, 0xe5,
    0x0, 0x0, 0x0, 0x39, 0xff, 0x60, 0x4e, 0xe4,
    0x2, 0xcf, 0xd6, 0x10, 0xb, 0xff, 0x81, 0x0,
    0x1, 0xcc, 0x0, 0x6, 0xdf, 0xc0, 0x3, 0x40,
    0x0, 0x0, 0x6d, 0x20, 0x0, 0x0, 0x13, 0x10,
    0x0, 0xc, 0x38, 0xc0, 0x1c, 0xe2, 0x0, 0xc,
    0xb0, 0x0, 0x0, 0x5f, 0x29, 0xe0, 0x1, 0xde,
    0x10, 0x4, 0xf4, 0x0, 0x0, 0xad, 0x9, 0xe0,
    0x0, 0x1d, 0x30, 0x62, 0xcd, 0x0, 0x1, 0xf7,
    0x9, 0xe0, 0x0, 0x0, 0x0, 0xe8, 0x5f, 0x40,
    0xa, 0xf1, 0x8, 0xf6, 0x55, 0x55, 0x57, 0xf5,
    0xf, 0xa0, 0x2, 0x50, 0x2, 0xcf, 0xff, 0xff,
    0xff, 0xb0, 0x5, 0x20,

    /* U+606F "息" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x2,
    0xf7, 0x44, 0x44, 0x44, 0x44, 0x9f, 0x10, 0x0,
    0x0, 0x2f, 0x62, 0x22, 0x22, 0x22, 0x28, 0xf1,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x2, 0xf7, 0x33,
    0x33, 0x33, 0x33, 0x8f, 0x10, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x2, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x10,
    0x0, 0x0, 0x2f, 0xed, 0xdd, 0xdd, 0xdd, 0xde,
    0xf1, 0x0, 0x0, 0x0, 0x55, 0x55, 0x7d, 0x65,
    0x55, 0x55, 0x0, 0x0, 0x0, 0x10, 0x33, 0x2,
    0xeb, 0x0, 0x0, 0x27, 0x0, 0x0, 0x6f, 0x1c,
    0xb0, 0x3, 0xfa, 0x0, 0x5, 0xf5, 0x0, 0xd,
    0xb0, 0xcb, 0x0, 0x6, 0xd1, 0x7, 0x1b, 0xe1,
    0x5, 0xf4, 0xc, 0xb0, 0x0, 0x0, 0x2, 0xf5,
    0x3f, 0x80, 0xdc, 0x0, 0xbe, 0x66, 0x66, 0x66,
    0xaf, 0x10, 0xa7, 0x1, 0x20, 0x4, 0xdf, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0,

    /* U+60C5 "情" */
    0x0, 0x5, 0x20, 0x0, 0x0, 0x1, 0x61, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x13, 0x33, 0x35,
    0xf6, 0x33, 0x33, 0x10, 0x0, 0xf, 0x60, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xf,
    0x9a, 0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0,
    0x9, 0x8f, 0x7f, 0x3c, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x0, 0xb, 0x7f, 0x6a, 0x91, 0x22, 0x25,
    0xf6, 0x22, 0x22, 0x0, 0xd, 0x5f, 0x62, 0x65,
    0x55, 0x57, 0xf8, 0x55, 0x55, 0x50, 0xf, 0x2f,
    0x60, 0xbc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc2,
    0x4f, 0xf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x16, 0xf, 0x60, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0xf, 0x60, 0x7,
    0xe2, 0x22, 0x22, 0x22, 0xe9, 0x0, 0x0, 0xf,
    0x60, 0x7, 0xf3, 0x33, 0x33, 0x33, 0xe9, 0x0,
    0x0, 0xf, 0x60, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0xf, 0x60, 0x7, 0xe0, 0x0,
    0x0, 0x0, 0xd9, 0x0, 0x0, 0xf, 0x60, 0x7,
    0xfe, 0xee, 0xee, 0xee, 0xf9, 0x0, 0x0, 0xf,
    0x60, 0x7, 0xf3, 0x33, 0x33, 0x33, 0xe9, 0x0,
    0x0, 0xf, 0x60, 0x7, 0xe0, 0x0, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0xf, 0x60, 0x7, 0xe0, 0x0,
    0x1, 0x44, 0xe9, 0x0, 0x0, 0xf, 0x60, 0x7,
    0xe0, 0x0, 0x2, 0xff, 0xd3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+614B "態" */
    0x0, 0x0, 0x6c, 0x20, 0x0, 0x9, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x70, 0xa3, 0x0, 0xe7,
    0x3, 0x9f, 0x60, 0x1, 0xae, 0x40, 0x8, 0xe2,
    0xe, 0xde, 0xe9, 0x40, 0x0, 0xef, 0xfe, 0xff,
    0xff, 0xd1, 0xea, 0x30, 0x0, 0x91, 0x5, 0x53,
    0x21, 0x0, 0xa, 0x2e, 0x91, 0x11, 0x3f, 0x30,
    0xa, 0xdd, 0xdd, 0xdd, 0x60, 0xaf, 0xff, 0xff,
    0xd0, 0x0, 0xcb, 0x33, 0x33, 0xe7, 0x7, 0x52,
    0x22, 0x20, 0x0, 0xc, 0xb3, 0x33, 0x3e, 0x70,
    0xe7, 0x0, 0x1, 0x0, 0x0, 0xce, 0xbb, 0xbb,
    0xf7, 0xe, 0x70, 0x4a, 0xfa, 0x0, 0xc, 0xa2,
    0x22, 0x2e, 0x70, 0xee, 0xfe, 0x94, 0x0, 0x0,
    0xce, 0xdd, 0xdd, 0xf7, 0xe, 0xa3, 0x0, 0x6,
    0x10, 0xc, 0x90, 0x0, 0xe, 0x70, 0xe8, 0x0,
    0x1, 0xf5, 0x0, 0xc9, 0x0, 0xbf, 0xf4, 0xa,
    0xff, 0xff, 0xff, 0x10, 0x5, 0x30, 0x13, 0x11,
    0xd7, 0x3, 0x44, 0x5a, 0x20, 0x0, 0xcc, 0x9,
    0xe0, 0x4, 0xf4, 0x0, 0x2, 0xf7, 0x0, 0x7f,
    0x40, 0x9e, 0x0, 0x5, 0x10, 0xc6, 0x9, 0xf1,
    0x2f, 0xb0, 0x8, 0xf5, 0x44, 0x44, 0x5f, 0x50,
    0x2f, 0x70, 0x31, 0x0, 0x2d, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x30,

    /* U+61C9 "應" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x33, 0x33, 0x33,
    0x35, 0xfa, 0x33, 0x33, 0x33, 0x30, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0xc9, 0x0, 0x2b, 0x10, 0xb4, 0xc, 0x50,
    0x0, 0x0, 0x0, 0xc9, 0x0, 0xac, 0x6, 0xf1,
    0x6, 0xe0, 0x0, 0x0, 0x0, 0xc9, 0x5, 0xf4,
    0x1e, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0xc9,
    0x2f, 0xf2, 0xbf, 0x60, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0xcb, 0xed, 0xfb, 0xed, 0xfe, 0xef, 0xfe,
    0xec, 0x0, 0x0, 0xcc, 0xc3, 0xf5, 0x3c, 0x60,
    0x5, 0xf0, 0x0, 0x0, 0x0, 0xd8, 0x2, 0xf2,
    0xc, 0xfe, 0xef, 0xfe, 0xec, 0x0, 0x0, 0xd8,
    0x2, 0xf2, 0xc, 0x60, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0xe7, 0x2, 0xf2, 0xc, 0xfe, 0xef, 0xfe,
    0xee, 0xa0, 0x0, 0xf5, 0x2, 0xb1, 0x8, 0xa4,
    0x11, 0x11, 0x11, 0x10, 0x1, 0xf4, 0x0, 0x0,
    0x0, 0xbf, 0x90, 0x0, 0x10, 0x0, 0x4, 0xf1,
    0x5, 0xb0, 0xe7, 0x5, 0xed, 0xa, 0xc0, 0x0,
    0x7, 0xf0, 0xc, 0xa0, 0xe7, 0x0, 0x26, 0x1,
    0xe9, 0x0, 0xb, 0xb0, 0x4f, 0x30, 0xe7, 0x0,
    0x0, 0x97, 0x5f, 0x40, 0x1f, 0x62, 0xea, 0x0,
    0xea, 0x44, 0x44, 0xd8, 0xa, 0xd0, 0x2d, 0x10,
    0x70, 0x0, 0x7f, 0xff, 0xff, 0xe2, 0x2, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+6211 "我" */
    0x0, 0x0, 0x0, 0x1, 0x64, 0x8, 0x90, 0x2,
    0x0, 0x0, 0x0, 0x3, 0x6a, 0xdf, 0xfd, 0xc,
    0xd0, 0x9f, 0x30, 0x0, 0x8, 0xff, 0xff, 0xf6,
    0x20, 0xb, 0xd0, 0xc, 0xf3, 0x0, 0x2, 0x52,
    0x9, 0xe0, 0x0, 0xa, 0xd0, 0x0, 0xce, 0x20,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x9, 0xe0, 0x0,
    0x1a, 0x10, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x0, 0xd, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x6, 0x77,
    0x7c, 0xf7, 0x77, 0x7a, 0xf9, 0x77, 0x77, 0x70,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x3, 0xf4, 0x0,
    0x32, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x1,
    0xf7, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x9, 0xf4,
    0x7b, 0x70, 0xea, 0x9, 0xf2, 0x0, 0x0, 0x26,
    0x9e, 0xff, 0xfb, 0x50, 0xbd, 0x5f, 0x70, 0x0,
    0xf, 0xff, 0xfe, 0xf3, 0x0, 0x0, 0x8f, 0xfb,
    0x0, 0x0, 0x8, 0x73, 0x9, 0xe0, 0x0, 0x0,
    0x5f, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe0,
    0x0, 0x3, 0xef, 0xa0, 0x0, 0xc2, 0x0, 0x0,
    0x9, 0xe0, 0x0, 0x7f, 0xca, 0xf2, 0x1, 0xf3,
    0x0, 0x0, 0x9, 0xe0, 0x3c, 0xfa, 0x2, 0xfb,
    0x3, 0xf1, 0x0, 0x57, 0x7c, 0xe0, 0x8e, 0x50,
    0x0, 0x7f, 0xbc, 0xd0, 0x0, 0x7f, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x7, 0xee, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+624B "手" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0x95,
    0x0, 0x0, 0x1, 0x24, 0x56, 0x89, 0xbd, 0xff,
    0xfd, 0x90, 0x0, 0x5, 0xff, 0xff, 0xfe, 0xef,
    0x86, 0x41, 0x0, 0x0, 0x0, 0x3, 0x21, 0x0,
    0x9, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x12, 0x22, 0x22, 0x2a, 0xf2, 0x22, 0x22, 0x22,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x25, 0x55, 0x55, 0x5b, 0xf5,
    0x55, 0x55, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x67,
    0x77, 0x77, 0x77, 0xcf, 0x77, 0x77, 0x77, 0x77,
    0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xae, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x77, 0x7d, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+626B "扫" */
    0x0, 0x0, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0xbf, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0xf7, 0x0, 0x46,
    0x66, 0x66, 0x66, 0xcd, 0xf, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x9d, 0x6, 0x77, 0xfb,
    0x77, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9d,
    0x0, 0x0, 0xf7, 0x0, 0x38, 0x88, 0x88, 0x88,
    0xdd, 0x0, 0x0, 0xfb, 0xae, 0x6f, 0xff, 0xff,
    0xff, 0xfd, 0x7, 0xae, 0xff, 0xc8, 0x10, 0x0,
    0x0, 0x0, 0x9d, 0xf, 0xd9, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9d, 0x1, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0xf7, 0x0, 0x45, 0x55, 0x55, 0x55, 0xbd,
    0x0, 0x0, 0xf7, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xfd, 0x2, 0x56, 0xf6, 0x0, 0x11, 0x11, 0x11,
    0x11, 0x9d, 0x2, 0xff, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+627E "找" */
    0x0, 0x3, 0xf3, 0x0, 0x0, 0x5e, 0x20, 0x50,
    0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x4f,
    0x32, 0xfb, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x3f, 0x40, 0x3f, 0xb0, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0x2f, 0x50, 0x5, 0xe2, 0x0,
    0x1f, 0xff, 0xff, 0xfa, 0x0, 0x1f, 0x70, 0x2,
    0x45, 0x40, 0x7, 0x79, 0xf9, 0x75, 0x68, 0x9f,
    0xee, 0xff, 0xff, 0xb0, 0x0, 0x3, 0xf3, 0x0,
    0xfe, 0xcf, 0xe7, 0x64, 0x21, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x41, 0x0,
    0x0, 0x3, 0xf3, 0x13, 0x0, 0x9, 0xf0, 0x0,
    0xe9, 0x0, 0x0, 0x6, 0xfd, 0xfd, 0x0, 0x6,
    0xf2, 0x8, 0xf2, 0x0, 0x2b, 0xff, 0xfb, 0x51,
    0x0, 0x3, 0xf6, 0x4f, 0x80, 0x0, 0xc, 0x86,
    0xf3, 0x0, 0x0, 0x0, 0xfc, 0xec, 0x0, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0xe1,
    0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x3,
    0xef, 0x60, 0x0, 0x81, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x6f, 0xde, 0xd0, 0x0, 0xf5, 0x0, 0x3,
    0xf3, 0x0, 0x3c, 0xfb, 0x16, 0xf8, 0x3, 0xf2,
    0x3, 0x58, 0xf3, 0x4, 0xfe, 0x50, 0x0, 0xbf,
    0xcd, 0xd0, 0x5, 0xff, 0xb0, 0x0, 0x40, 0x0,
    0x0, 0x9, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0,

    /* U+633F "挿" */
    0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x0, 0x0, 0x6, 0xf0, 0x1, 0x45, 0x67,
    0x9a, 0xce, 0xfd, 0x0, 0x0, 0x6, 0xf0, 0x6,
    0xed, 0xcb, 0xdf, 0x75, 0x30, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x7, 0x7a, 0xf7, 0x72, 0x44, 0x44,
    0xaf, 0x44, 0x44, 0x40, 0x0, 0x6, 0xf0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x6, 0xf0, 0x5, 0xf4, 0x44, 0xaf, 0x44,
    0x4f, 0x70, 0x0, 0x6, 0xfa, 0xe7, 0xf0, 0x0,
    0x8e, 0x0, 0xf, 0x70, 0x16, 0xbf, 0xfc, 0x76,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x4f, 0xcb,
    0xf0, 0x5, 0xf4, 0x44, 0xaf, 0x44, 0x4f, 0x70,
    0x1, 0x6, 0xf0, 0x5, 0xf0, 0x0, 0x8e, 0x0,
    0xf, 0x70, 0x0, 0x6, 0xf0, 0x5, 0xf5, 0x55,
    0xaf, 0x55, 0x5f, 0x70, 0x0, 0x6, 0xf0, 0x5,
    0xfe, 0xee, 0xff, 0xee, 0xef, 0x70, 0x0, 0x6,
    0xf0, 0x4, 0xc0, 0x0, 0x8e, 0x0, 0xa, 0x40,
    0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x0, 0x4, 0x7b, 0xf0, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x6, 0xfe, 0x80, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,

    /* U+6362 "换" */
    0x0, 0x7, 0xb0, 0x0, 0x0, 0x4b, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0xce,
    0x10, 0x1, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0x3f, 0xa3, 0x33, 0x7f, 0x70, 0x0,
    0xa, 0xce, 0xfc, 0x92, 0xec, 0x0, 0x0, 0xdc,
    0x0, 0x0, 0x9, 0xad, 0xfa, 0x9e, 0xfd, 0xbb,
    0xbd, 0xfc, 0xb7, 0x0, 0x0, 0x9, 0xe0, 0x4,
    0xfb, 0x77, 0xcf, 0x77, 0xea, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0xe8, 0x0, 0x8e, 0x0, 0xda, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0xe8, 0x0, 0x8e, 0x0,
    0xda, 0x0, 0x0, 0x9, 0xf9, 0xa0, 0xe8, 0x0,
    0x9e, 0x0, 0xda, 0x0, 0x5, 0xaf, 0xfd, 0x70,
    0xe8, 0x0, 0xac, 0x0, 0xda, 0x0, 0xf, 0xed,
    0xf0, 0x4c, 0xfe, 0xcc, 0xff, 0xcc, 0xfe, 0xc0,
    0x2, 0x9, 0xe0, 0x38, 0x88, 0x8a, 0xff, 0x88,
    0x88, 0x80, 0x0, 0x9, 0xe0, 0x0, 0x0, 0xa,
    0xef, 0x70, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0,
    0x0, 0x5f, 0x57, 0xf3, 0x0, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0x5, 0xfa, 0x0, 0xce, 0x20, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0x8f, 0xa0, 0x0, 0x1d,
    0xe4, 0x0, 0x3, 0x7c, 0xe0, 0x6e, 0xf7, 0x0,
    0x0, 0x1, 0xcf, 0xa1, 0x3, 0xfe, 0x60, 0xba,
    0x20, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6383 "掃" */
    0x0, 0x5, 0xb0, 0x0, 0x12, 0x22, 0x22, 0x22,
    0x21, 0x0, 0x0, 0x7e, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd9, 0x0, 0x0, 0x7e, 0x0,
    0x4, 0xee, 0xee, 0xee, 0xef, 0x90, 0xf, 0xff,
    0xff, 0xf2, 0x13, 0x33, 0x33, 0x33, 0xe9, 0x0,
    0x99, 0xcf, 0x99, 0x12, 0x22, 0x22, 0x22, 0x2d,
    0x90, 0x0, 0x7, 0xe0, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x2e,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x9f,
    0xee, 0xe9, 0x44, 0x49, 0xf4, 0x44, 0x9e, 0x1b,
    0xff, 0xf7, 0x2e, 0x60, 0x0, 0x7e, 0x0, 0x7,
    0xe0, 0xb7, 0x9e, 0x0, 0x8c, 0xff, 0xff, 0xff,
    0xff, 0xd7, 0x0, 0x7, 0xe0, 0x0, 0x9e, 0x44,
    0x9f, 0x44, 0xba, 0x0, 0x0, 0x7e, 0x0, 0x9,
    0xe0, 0x7, 0xe0, 0xa, 0xa0, 0x0, 0x7, 0xe0,
    0x0, 0x9e, 0x0, 0x7e, 0x0, 0xaa, 0x0, 0x0,
    0x7e, 0x0, 0x9, 0xe0, 0x7, 0xe0, 0xa, 0xa0,
    0x0, 0x7, 0xe0, 0x0, 0x9e, 0x0, 0x7e, 0x2f,
    0xf7, 0x0, 0x46, 0xbe, 0x0, 0x1, 0x10, 0x7,
    0xe0, 0x32, 0x0, 0x5, 0xfe, 0x60, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0,

    /* U+63A2 "探" */
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x5, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xd0, 0x0, 0x7, 0xe0, 0x5,
    0xf6, 0x66, 0x66, 0x66, 0x6a, 0xe0, 0x0, 0x7,
    0xe0, 0x5, 0xe0, 0x2, 0x0, 0x21, 0x6, 0xe0,
    0xc, 0xff, 0xff, 0xd3, 0xa0, 0x5f, 0x30, 0xcd,
    0x13, 0x90, 0x5, 0x7b, 0xf7, 0x60, 0x3, 0xf9,
    0x0, 0x1d, 0xd1, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x2e, 0xc0, 0x0, 0x1, 0xec, 0x0, 0x0, 0x7,
    0xe0, 0x4, 0xfd, 0x10, 0x13, 0x0, 0x3f, 0x90,
    0x0, 0x7, 0xe0, 0x10, 0x81, 0x0, 0x8e, 0x0,
    0x5, 0x20, 0x0, 0x7, 0xfc, 0xe0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x6, 0xbf, 0xfb, 0x58,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xc, 0xcc,
    0xe0, 0x2, 0x55, 0x5c, 0xff, 0xf6, 0x55, 0x50,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x4f, 0xce, 0xca,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x4, 0xf8,
    0x8e, 0x2e, 0x90, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x6f, 0xa0, 0x8e, 0x4, 0xfa, 0x0, 0x0, 0x7,
    0xe0, 0x3c, 0xf8, 0x0, 0x8e, 0x0, 0x4f, 0xd3,
    0x2, 0x4a, 0xe0, 0x2c, 0x40, 0x0, 0x8e, 0x0,
    0x2, 0xb1, 0x4, 0xff, 0x80, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63A5 "接" */
    0x0, 0xe, 0x70, 0x0, 0x0, 0x7, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x3,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70, 0x7,
    0xee, 0xee, 0xff, 0xee, 0xee, 0x40, 0x0, 0xe,
    0x70, 0x3, 0x68, 0x76, 0x66, 0x6a, 0x76, 0x20,
    0x4f, 0xff, 0xff, 0x70, 0xc, 0xa0, 0x0, 0x3f,
    0x60, 0x0, 0x27, 0x7f, 0xb7, 0x30, 0x4, 0xf3,
    0x0, 0xbd, 0x0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0xa4, 0x3, 0xf4, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0xe, 0x70, 0x14, 0x44, 0x4b, 0x84, 0x44,
    0x44, 0x30, 0x0, 0xe, 0xaa, 0x40, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x15, 0xaf, 0xfe, 0x75,
    0x55, 0xbf, 0x55, 0x55, 0x55, 0x50, 0x6f, 0xef,
    0x90, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x14, 0xe, 0x70, 0x0, 0xc, 0xc0, 0x0, 0x1f,
    0x70, 0x0, 0x0, 0xe, 0x70, 0x0, 0x7f, 0x20,
    0x0, 0x8f, 0x10, 0x0, 0x0, 0xe, 0x70, 0x0,
    0xcf, 0xe8, 0x23, 0xf9, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x2, 0x8e, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x3a, 0xfe, 0xfc,
    0x40, 0x0, 0x5, 0x6f, 0x70, 0x37, 0xae, 0xfc,
    0x50, 0x4c, 0xfb, 0x10, 0xa, 0xfc, 0x20, 0x5e,
    0xb7, 0x20, 0x0, 0x0, 0x6d, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63CF "描" */
    0x0, 0xb, 0x50, 0x0, 0x5, 0xc0, 0x0, 0x3c,
    0x20, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x7f, 0x0,
    0x3, 0xf3, 0x0, 0x0, 0xe, 0x70, 0x0, 0x17,
    0xf1, 0x11, 0x4f, 0x41, 0x0, 0x0, 0xe7, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x5f, 0xff,
    0xff, 0x93, 0x49, 0xf4, 0x44, 0x6f, 0x64, 0x32,
    0x77, 0xfb, 0x74, 0x0, 0x7f, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0xe, 0x70, 0x0, 0x7, 0xf0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0xe7, 0x0, 0x14, 0x45,
    0x44, 0x44, 0x54, 0x41, 0x0, 0xe, 0x70, 0x15,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0xfd,
    0xe9, 0x5f, 0x11, 0x1f, 0x81, 0x14, 0xf5, 0x39,
    0xef, 0xfa, 0x35, 0xf0, 0x0, 0xe7, 0x0, 0x4f,
    0x57, 0xfa, 0xf7, 0x0, 0x5f, 0x0, 0xe, 0x70,
    0x4, 0xf5, 0x10, 0xe, 0x70, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0xe7, 0x0, 0x5f,
    0x55, 0x5f, 0xa5, 0x58, 0xf5, 0x0, 0xe, 0x70,
    0x5, 0xf0, 0x0, 0xe7, 0x0, 0x4f, 0x50, 0x0,
    0xe7, 0x0, 0x5f, 0x0, 0xe, 0x70, 0x4, 0xf5,
    0x0, 0xe, 0x70, 0x5, 0xfe, 0xee, 0xff, 0xee,
    0xff, 0x50, 0x56, 0xf7, 0x0, 0x5f, 0x66, 0x66,
    0x66, 0x69, 0xf5, 0xd, 0xfc, 0x20, 0x5, 0xf0,
    0x0, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63D2 "插" */
    0x0, 0xb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x64, 0x0, 0x0, 0xe, 0x80, 0x0, 0x57, 0x8a,
    0xce, 0xff, 0xfa, 0x0, 0x0, 0xe, 0x80, 0x0,
    0xcd, 0xca, 0xcf, 0x52, 0x0, 0x0, 0x0, 0xe,
    0x80, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0xb, 0xbf, 0xeb, 0x50, 0x11, 0x11, 0x8f, 0x11,
    0x11, 0x10, 0xa, 0xaf, 0xda, 0x49, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0xe, 0x80, 0x2,
    0x44, 0x44, 0x9f, 0x44, 0x44, 0x40, 0x0, 0xe,
    0x80, 0x0, 0x0, 0x50, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x80, 0x2, 0xaf, 0xf3, 0x7e, 0x4e,
    0xee, 0x50, 0x0, 0xe, 0xcb, 0x95, 0xf5, 0x0,
    0x7e, 0x26, 0x6f, 0x60, 0x28, 0xdf, 0xfc, 0x55,
    0xf0, 0x0, 0x7e, 0x0, 0xf, 0x60, 0x3f, 0xbf,
    0x80, 0x5, 0xf0, 0x0, 0x7e, 0x0, 0xf, 0x60,
    0x0, 0xe, 0x80, 0x5, 0xff, 0xf6, 0x7e, 0x4f,
    0xff, 0x60, 0x0, 0xe, 0x80, 0x5, 0xf5, 0x52,
    0x7e, 0x15, 0x5f, 0x60, 0x0, 0xe, 0x80, 0x5,
    0xf0, 0x0, 0x7e, 0x0, 0xf, 0x60, 0x0, 0xe,
    0x80, 0x5, 0xf0, 0x0, 0x7e, 0x0, 0xf, 0x60,
    0x0, 0xe, 0x80, 0x5, 0xfc, 0xcc, 0xef, 0xcc,
    0xcf, 0x60, 0x4, 0x7f, 0x80, 0x5, 0xf9, 0x99,
    0x99, 0x99, 0x9f, 0x60, 0x5, 0xec, 0x20, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+63DB "換" */
    0x0, 0xb, 0x40, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x1, 0xfa,
    0x44, 0x40, 0x0, 0x0, 0x0, 0xf, 0x60, 0x0,
    0xa, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x4f, 0x50, 0x6, 0xf1, 0x0, 0x0,
    0x2c, 0xcf, 0xdc, 0x32, 0xea, 0x0, 0x2f, 0x70,
    0x0, 0x0, 0x2a, 0xaf, 0xca, 0x5e, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0xf, 0x60, 0x9,
    0xe7, 0x33, 0x33, 0x33, 0x7e, 0x0, 0x0, 0xf,
    0x60, 0x0, 0xe4, 0xb, 0x45, 0xb0, 0x5e, 0x0,
    0x0, 0xf, 0x60, 0x0, 0xe4, 0x3e, 0x0, 0xd5,
    0x5e, 0x0, 0x0, 0xf, 0xbd, 0x30, 0xe4, 0xc8,
    0x0, 0x5d, 0x5e, 0x0, 0x17, 0xcf, 0xf9, 0x10,
    0xe8, 0xd0, 0x54, 0xc, 0x7e, 0x0, 0x4f, 0xbf,
    0x60, 0x0, 0xe4, 0x0, 0xd9, 0x0, 0x5e, 0x0,
    0x1, 0xf, 0x60, 0x57, 0xfa, 0x77, 0xfb, 0x77,
    0xaf, 0x71, 0x0, 0xf, 0x60, 0x9c, 0xcc, 0xcd,
    0xff, 0xcc, 0xcc, 0xc2, 0x0, 0xf, 0x60, 0x0,
    0x0, 0x9, 0xef, 0x30, 0x0, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x4f, 0x69, 0xd1, 0x0, 0x0,
    0x0, 0xf, 0x60, 0x0, 0x7, 0xfa, 0x0, 0xce,
    0x40, 0x0, 0x6, 0x7f, 0x50, 0x48, 0xef, 0x80,
    0x0, 0x9, 0xfc, 0x71, 0x9, 0xfc, 0x10, 0xdd,
    0x71, 0x0, 0x0, 0x0, 0x29, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6557 "敗" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xb2, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xe0, 0x6,
    0xf1, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x33, 0x3a,
    0xe0, 0xa, 0xd0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x8, 0xe0, 0xe, 0xa1, 0x11, 0x11, 0x10,
    0x3, 0xf6, 0x44, 0x4a, 0xe0, 0x4f, 0xff, 0xff,
    0xff, 0xf1, 0x3, 0xff, 0xff, 0xff, 0xe0, 0x9f,
    0x65, 0x56, 0xfa, 0x50, 0x3, 0xf3, 0x0, 0x8,
    0xe1, 0xff, 0x30, 0x3, 0xf5, 0x0, 0x3, 0xf3,
    0x0, 0x8, 0xe8, 0xff, 0x70, 0x6, 0xf1, 0x0,
    0x3, 0xf7, 0x55, 0x5b, 0xff, 0x9b, 0xc0, 0xa,
    0xd0, 0x0, 0x3, 0xfe, 0xdd, 0xde, 0xfc, 0x16,
    0xf1, 0xf, 0x90, 0x0, 0x3, 0xf3, 0x0, 0x8,
    0xe0, 0x1, 0xf7, 0x5f, 0x40, 0x0, 0x3, 0xf3,
    0x0, 0x8, 0xe0, 0x0, 0xae, 0xcd, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x3f, 0xf6,
    0x0, 0x0, 0x1, 0x47, 0x44, 0x56, 0x40, 0x0,
    0x1f, 0xf2, 0x0, 0x0, 0x0, 0x3f, 0x70, 0xad,
    0x0, 0x0, 0xbf, 0xfc, 0x0, 0x0, 0x0, 0xbe,
    0x0, 0x1e, 0x90, 0x1b, 0xf6, 0x5f, 0xb1, 0x0,
    0x5, 0xf6, 0x0, 0x6, 0xf6, 0xef, 0x70, 0x7,
    0xfd, 0x40, 0x1f, 0xb0, 0x0, 0x0, 0x3e, 0xe4,
    0x0, 0x0, 0x5f, 0xe1, 0x3, 0x10, 0x0, 0x0,
    0x3, 0x0, 0x0, 0x0, 0x1, 0x20,

    /* U+65B0 "新" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x56, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0x2, 0x58, 0xcf, 0xfc, 0x20, 0xb, 0xee,
    0xef, 0xfe, 0xee, 0xb, 0xfc, 0x85, 0x10, 0x0,
    0x4, 0x7b, 0x55, 0x59, 0xa5, 0xb, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x20, 0xc, 0xa0, 0xb,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x60, 0x1f,
    0x40, 0xb, 0xa0, 0x0, 0x0, 0x0, 0x5, 0x5c,
    0x95, 0xaf, 0x55, 0x2b, 0xc4, 0x44, 0x44, 0x40,
    0x1e, 0xee, 0xef, 0xfe, 0xee, 0x5b, 0xff, 0xff,
    0xff, 0xf2, 0x0, 0x0, 0xf, 0x60, 0x0, 0xb,
    0xb2, 0x29, 0xf2, 0x20, 0x0, 0x0, 0xf, 0x60,
    0x0, 0xb, 0xa0, 0x8, 0xf0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x2c, 0xa0, 0x8, 0xf0, 0x0,
    0x6, 0x66, 0x6f, 0xa6, 0x66, 0xd, 0x90, 0x8,
    0xf0, 0x0, 0x0, 0x69, 0xf, 0x67, 0x70, 0xf,
    0x80, 0x8, 0xf0, 0x0, 0x0, 0xd8, 0xf, 0x64,
    0xf2, 0x2f, 0x50, 0x8, 0xf0, 0x0, 0x7, 0xf1,
    0xf, 0x60, 0xba, 0x6f, 0x20, 0x8, 0xf0, 0x0,
    0xd, 0x60, 0xf, 0x60, 0x46, 0xbe, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x3, 0x4f, 0x60, 0x4, 0xf9,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x7, 0xfd, 0x20,
    0x8, 0xf2, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x50, 0x0, 0x8, 0xf0, 0x0,

    /* U+65E0 "无" */
    0x0, 0x57, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x76, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x8, 0x88, 0x88, 0x88,
    0xcf, 0x98, 0x88, 0x88, 0x88, 0x80, 0xe, 0xee,
    0xee, 0xee, 0xff, 0xff, 0xee, 0xee, 0xee, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xea, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0xcc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x90, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xde, 0x10, 0xcc, 0x0, 0x0,
    0x2, 0x30, 0x0, 0x0, 0xb, 0xf4, 0x0, 0xcc,
    0x0, 0x0, 0x5, 0xf2, 0x0, 0x2, 0xcf, 0x60,
    0x0, 0xcc, 0x0, 0x0, 0x6, 0xf0, 0x1, 0x8f,
    0xf5, 0x0, 0x0, 0xbf, 0x87, 0x77, 0x8e, 0xd0,
    0xc, 0xfa, 0x20, 0x0, 0x0, 0x4d, 0xff, 0xff,
    0xfe, 0x40, 0x2, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+65F6 "时" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc8,
    0x0, 0x2, 0x44, 0x44, 0x43, 0x0, 0x0, 0x0,
    0xe, 0x90, 0x0, 0x7f, 0xff, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x7, 0xf1, 0x11, 0x9d,
    0x0, 0x0, 0x0, 0xe, 0x90, 0x0, 0x7f, 0x0,
    0x9, 0xd6, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7,
    0xf0, 0x0, 0x9d, 0x38, 0x88, 0x88, 0x8f, 0xd8,
    0x80, 0x7f, 0x0, 0x9, 0xd0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x7, 0xf6, 0x66, 0xbd, 0x2, 0x70,
    0x0, 0xe, 0x90, 0x0, 0x7f, 0xff, 0xff, 0xd0,
    0x5f, 0x50, 0x0, 0xe9, 0x0, 0x7, 0xf0, 0x0,
    0x9d, 0x0, 0xae, 0x10, 0xe, 0x90, 0x0, 0x7f,
    0x0, 0x9, 0xd0, 0x1, 0xfa, 0x0, 0xe9, 0x0,
    0x7, 0xf0, 0x0, 0x9d, 0x0, 0x7, 0xf4, 0xe,
    0x90, 0x0, 0x7f, 0x0, 0x9, 0xd0, 0x0, 0xa,
    0x30, 0xe9, 0x0, 0x7, 0xf6, 0x66, 0xcd, 0x0,
    0x0, 0x0, 0xe, 0x90, 0x0, 0x7f, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x49, 0x0, 0x0, 0x0, 0x0, 0x67, 0x78, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xff,
    0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6642 "時" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xc1, 0x0,
    0x0, 0x3, 0x77, 0x77, 0x73, 0x0, 0x0, 0x6f,
    0x10, 0x0, 0x0, 0x7f, 0xee, 0xef, 0x63, 0x66,
    0x6a, 0xf7, 0x66, 0x62, 0x7, 0xe0, 0x0, 0xf6,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0x60, 0x7e, 0x0,
    0xf, 0x60, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0xf6, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x0, 0x7e, 0x0, 0xf, 0x96, 0x66, 0x6a, 0xf7,
    0x66, 0x66, 0x7, 0xf7, 0x77, 0xfd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x7f, 0xee, 0xef, 0x60,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x7, 0xe0, 0x0,
    0xf6, 0x0, 0x0, 0x0, 0xe, 0x80, 0x0, 0x7e,
    0x0, 0xf, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x7, 0xe0, 0x0, 0xf9, 0x66, 0x66, 0x66, 0x6f,
    0xb6, 0x50, 0x7e, 0x0, 0xf, 0x60, 0x99, 0x0,
    0x0, 0xe8, 0x0, 0x7, 0xfe, 0xee, 0xf6, 0x5,
    0xf7, 0x0, 0xe, 0x80, 0x0, 0x7f, 0x77, 0x77,
    0x20, 0x9, 0xf3, 0x0, 0xe8, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x0, 0xd, 0x60, 0xe, 0x80, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x45,
    0x5f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+66F4 "更" */
    0x6, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x60, 0x8, 0xcc, 0xcc, 0xcc, 0xce, 0xfc,
    0xcc, 0xcc, 0xcc, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xee, 0xee, 0xef, 0xfe, 0xee, 0xee, 0xe6, 0x0,
    0x0, 0xe, 0xb5, 0x55, 0x5c, 0xf5, 0x55, 0x56,
    0xf6, 0x0, 0x0, 0xe, 0x80, 0x0, 0xa, 0xe0,
    0x0, 0x1, 0xf6, 0x0, 0x0, 0xe, 0xa4, 0x44,
    0x4b, 0xf4, 0x44, 0x44, 0xf6, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0xe, 0x80, 0x0, 0xa, 0xe0, 0x0, 0x1,
    0xf6, 0x0, 0x0, 0xe, 0x93, 0x33, 0x3b, 0xe3,
    0x33, 0x34, 0xf6, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x1,
    0x83, 0x11, 0x1e, 0xb1, 0x11, 0x11, 0x10, 0x0,
    0x0, 0x0, 0xdd, 0x0, 0x4f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xc2, 0xde, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x28, 0xff, 0xfd, 0x83, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x8c, 0xff, 0x91, 0x4a, 0xff, 0xfd, 0xba,
    0x88, 0x71, 0x8, 0xfb, 0x61, 0x0, 0x0, 0x3,
    0x79, 0xbd, 0xef, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+66FF "替" */
    0x0, 0x0, 0x1c, 0x40, 0x0, 0x0, 0x6, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xf0, 0x8f, 0xff, 0xff, 0xff, 0x20, 0x0, 0x22,
    0x4f, 0x62, 0x20, 0x12, 0x29, 0xe2, 0x22, 0x0,
    0x1, 0x11, 0x4f, 0x41, 0x10, 0x11, 0x1a, 0xd1,
    0x11, 0x10, 0xe, 0xff, 0xff, 0xff, 0xf3, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x2, 0x22, 0xdf, 0x82,
    0x20, 0x22, 0x7f, 0xec, 0x22, 0x10, 0x0, 0x6,
    0xfa, 0xfa, 0x0, 0x3, 0xfb, 0x3f, 0x70, 0x0,
    0x0, 0x6f, 0x90, 0x3e, 0xc1, 0x8f, 0xc0, 0x6,
    0xf9, 0x0, 0xb, 0xf9, 0x0, 0x1, 0x31, 0xc7,
    0x0, 0x0, 0x6f, 0xd0, 0x5, 0x54, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x41, 0x30, 0x0, 0x4,
    0xf7, 0x55, 0x55, 0x55, 0x55, 0x7f, 0x40, 0x0,
    0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x40, 0x0, 0x0, 0x4, 0xfe, 0xee, 0xee, 0xee,
    0xee, 0xef, 0x40, 0x0, 0x0, 0x4, 0xf7, 0x44,
    0x44, 0x44, 0x44, 0x7f, 0x40, 0x0, 0x0, 0x4,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0x4, 0xf6, 0x44, 0x44, 0x44, 0x44, 0x7f,
    0x40, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0x0, 0x4, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x40, 0x0,

    /* U+6700 "最" */
    0x0, 0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x10, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x7,
    0xfe, 0xee, 0xee, 0xee, 0xee, 0xef, 0x90, 0x0,
    0x0, 0x7, 0xf1, 0x11, 0x11, 0x11, 0x11, 0x1f,
    0x90, 0x0, 0x0, 0x7, 0xf1, 0x11, 0x11, 0x11,
    0x11, 0x1f, 0x90, 0x0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x4, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x1f, 0x40, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x74, 0x44,
    0xf7, 0x56, 0x66, 0x66, 0x66, 0x10, 0x0, 0x1f,
    0xed, 0xdd, 0xf7, 0xbf, 0xed, 0xdd, 0xef, 0x40,
    0x0, 0x1f, 0x40, 0x0, 0xf7, 0xc, 0xa0, 0x0,
    0xad, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xf7, 0x4,
    0xf4, 0x4, 0xf5, 0x0, 0x0, 0x1f, 0x62, 0x22,
    0xf7, 0x0, 0xaf, 0x5f, 0xa0, 0x0, 0x0, 0x1f,
    0x64, 0x68, 0xfe, 0x70, 0xd, 0xfd, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xec, 0xfb, 0x31, 0x9f, 0xff,
    0xa2, 0x0, 0x9, 0x75, 0x30, 0x0, 0xf7, 0x9f,
    0xf7, 0x8, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x0,
    0xf7, 0x89, 0x10, 0x0, 0x29, 0x90,

    /* U+6709 "有" */
    0x0, 0x0, 0x0, 0x3, 0xa2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x33, 0x33, 0x3e, 0xc3,
    0x33, 0x33, 0x33, 0x33, 0x30, 0x9f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x1, 0x33,
    0x33, 0xec, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0xe6, 0x66, 0x66, 0x66,
    0x67, 0x20, 0x0, 0x0, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x7, 0xff, 0x90,
    0x0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x7, 0xf9,
    0xe9, 0x11, 0x11, 0x11, 0x11, 0xf7, 0x0, 0x9,
    0xfa, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x78, 0x0, 0xea, 0x33, 0x33, 0x33, 0x34,
    0xf7, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0xef, 0xee,
    0xee, 0xee, 0xee, 0xf7, 0x0, 0x0, 0x0, 0xe,
    0xc6, 0x66, 0x66, 0x66, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x27,
    0x78, 0xf6, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x0, 0xff, 0xeb, 0x10, 0x0,

    /* U+670B "朋" */
    0x0, 0x7f, 0xee, 0xef, 0xb0, 0xa, 0xfe, 0xee,
    0xff, 0x40, 0x8, 0xf7, 0x77, 0xdc, 0x0, 0xbd,
    0x77, 0x78, 0xf5, 0x0, 0x8e, 0x0, 0xa, 0xc0,
    0xb, 0xb0, 0x0, 0x2f, 0x50, 0x8, 0xe0, 0x0,
    0xac, 0x0, 0xbb, 0x0, 0x2, 0xf5, 0x0, 0x8e,
    0x33, 0x3b, 0xc0, 0xb, 0xc3, 0x33, 0x4f, 0x50,
    0x8, 0xff, 0xff, 0xfc, 0x0, 0xbf, 0xff, 0xff,
    0xf5, 0x0, 0x8e, 0x22, 0x2b, 0xc0, 0xb, 0xc2,
    0x22, 0x4f, 0x50, 0x8, 0xe0, 0x0, 0xac, 0x0,
    0xbb, 0x0, 0x2, 0xf5, 0x0, 0x8e, 0x0, 0xa,
    0xc0, 0xb, 0xa0, 0x0, 0x2f, 0x50, 0x9, 0xe7,
    0x77, 0xdc, 0x0, 0xcc, 0x77, 0x78, 0xf5, 0x0,
    0xaf, 0xee, 0xef, 0xc0, 0xe, 0xfe, 0xee, 0xff,
    0x50, 0xc, 0xa0, 0x0, 0xac, 0x0, 0xf6, 0x0,
    0x2, 0xf5, 0x0, 0xe8, 0x0, 0xa, 0xc0, 0x4f,
    0x30, 0x0, 0x2f, 0x50, 0x1f, 0x40, 0x0, 0xac,
    0x8, 0xf0, 0x0, 0x2, 0xf5, 0x6, 0xf0, 0x0,
    0xa, 0xc0, 0xea, 0x0, 0x0, 0x2f, 0x50, 0xcb,
    0x0, 0x55, 0xcb, 0x8f, 0x30, 0x6, 0x68, 0xf4,
    0x2e, 0x30, 0xa, 0xfe, 0x6d, 0xa0, 0x0, 0xbf,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+670D "服" */
    0x0, 0x1, 0x11, 0x11, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x60, 0xdf,
    0xff, 0xff, 0xff, 0x70, 0x0, 0xad, 0x55, 0x5f,
    0x60, 0xdc, 0x66, 0x66, 0x6f, 0x70, 0x0, 0xab,
    0x0, 0xf, 0x60, 0xd9, 0x0, 0x0, 0xf, 0x70,
    0x0, 0xab, 0x0, 0xf, 0x60, 0xd9, 0x0, 0x0,
    0xf, 0x70, 0x0, 0xae, 0x88, 0x8f, 0x60, 0xd9,
    0x0, 0xaf, 0xff, 0x40, 0x0, 0xaf, 0xff, 0xff,
    0x60, 0xd9, 0x0, 0x24, 0x42, 0x0, 0x0, 0xab,
    0x0, 0xf, 0x60, 0xda, 0x33, 0x33, 0x33, 0x20,
    0x0, 0xab, 0x0, 0xf, 0x60, 0xdf, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0xab, 0x0, 0xf, 0x60, 0xda,
    0xd9, 0x33, 0x3c, 0xb0, 0x0, 0xad, 0x77, 0x7f,
    0x60, 0xd9, 0x8c, 0x0, 0xf, 0x70, 0x0, 0xbf,
    0xff, 0xff, 0x60, 0xd9, 0x2f, 0x30, 0x5f, 0x10,
    0x0, 0xc9, 0x0, 0xf, 0x60, 0xd9, 0xb, 0xb0,
    0xcb, 0x0, 0x0, 0xe7, 0x0, 0xf, 0x60, 0xd9,
    0x3, 0xf8, 0xf4, 0x0, 0x0, 0xf5, 0x0, 0xf,
    0x60, 0xd9, 0x0, 0xaf, 0xb0, 0x0, 0x3, 0xf3,
    0x0, 0xf, 0x60, 0xd9, 0x0, 0xbf, 0xb0, 0x0,
    0x6, 0xf0, 0x0, 0xf, 0x60, 0xd9, 0xa, 0xf8,
    0xfa, 0x0, 0xc, 0xb0, 0x36, 0x6f, 0x60, 0xdb,
    0xcf, 0x50, 0x5f, 0xd3, 0xa, 0x50, 0x3f, 0xfc,
    0x10, 0xd9, 0xa3, 0x0, 0x4, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+671F "期" */
    0x0, 0x39, 0x0, 0x1, 0x92, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf0, 0x0, 0x2f, 0x40, 0x6d,
    0xcc, 0xcc, 0xd5, 0x2, 0x7f, 0x22, 0x24, 0xf5,
    0x18, 0xf9, 0x99, 0x9f, 0x70, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x8e, 0x0, 0x0, 0xf7, 0x3, 0x7f,
    0x33, 0x35, 0xf6, 0x28, 0xe0, 0x0, 0xf, 0x70,
    0x5, 0xf0, 0x0, 0x2f, 0x40, 0x8e, 0x33, 0x33,
    0xf7, 0x0, 0x5f, 0xff, 0xff, 0xf4, 0x8, 0xff,
    0xff, 0xff, 0x70, 0x5, 0xf3, 0x33, 0x4f, 0x40,
    0x8e, 0x22, 0x22, 0xf7, 0x0, 0x5f, 0x0, 0x2,
    0xf4, 0x8, 0xe0, 0x0, 0xf, 0x70, 0x5, 0xff,
    0xff, 0xff, 0x40, 0x8e, 0x0, 0x0, 0xf7, 0x0,
    0x5f, 0x44, 0x45, 0xf4, 0x8, 0xfa, 0xaa, 0xaf,
    0x70, 0x5, 0xf0, 0x0, 0x2f, 0x40, 0x9f, 0xcc,
    0xcc, 0xf7, 0x3a, 0xcf, 0xaa, 0xab, 0xfb, 0x7a,
    0xb0, 0x0, 0xf, 0x73, 0xbb, 0xbb, 0xbb, 0xbb,
    0xb8, 0xca, 0x0, 0x0, 0xf7, 0x0, 0x7, 0x60,
    0x19, 0x0, 0xe, 0x80, 0x0, 0xf, 0x70, 0x2,
    0xf8, 0x1, 0xf9, 0x1, 0xf5, 0x0, 0x0, 0xf7,
    0x0, 0xce, 0x0, 0x6, 0xf3, 0x5f, 0x10, 0x0,
    0xf, 0x70, 0x9f, 0x40, 0x0, 0xc, 0xab, 0xc0,
    0x4, 0x66, 0xf6, 0x1c, 0x70, 0x0, 0x0, 0x20,
    0xc5, 0x0, 0x6f, 0xfc, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+672C "本" */
    0x0, 0x0, 0x0, 0x0, 0xb, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x99, 0x99, 0x99, 0x9f, 0xd9, 0x99, 0x99,
    0x99, 0x50, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0, 0x1f,
    0x8e, 0xad, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x2e, 0xa6, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0xe, 0xa0, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0xe, 0xa0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x60,
    0xe, 0xa0, 0xc, 0xf2, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0xe, 0xa0, 0x2, 0xfe, 0x10, 0x0,
    0x0, 0x3f, 0xe1, 0x0, 0xe, 0xa0, 0x0, 0x4f,
    0xd1, 0x0, 0x5, 0xfe, 0x89, 0x99, 0x9f, 0xd9,
    0x99, 0x99, 0xfe, 0x40, 0x1f, 0xe2, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x5f, 0xc0, 0x3, 0x10,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x3, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0x0,

    /* U+673A "机" */
    0x0, 0x0, 0x6b, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x67,
    0x77, 0x77, 0x50, 0x0, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0xe9, 0x0, 0xb, 0xc0, 0x0,
    0x6, 0x77, 0xcf, 0x77, 0x60, 0xe9, 0x0, 0xb,
    0xc0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xd0, 0xe9,
    0x0, 0xb, 0xc0, 0x0, 0x0, 0x0, 0xee, 0x0,
    0x0, 0xe9, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x3,
    0xff, 0x0, 0x0, 0xe9, 0x0, 0xb, 0xc0, 0x0,
    0x0, 0x9, 0xff, 0xb0, 0x0, 0xe9, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x1f, 0xbf, 0xdb, 0x0, 0xf8,
    0x0, 0xb, 0xc0, 0x0, 0x0, 0x8c, 0x8e, 0x2f,
    0x90, 0xf7, 0x0, 0xb, 0xc0, 0x0, 0x2, 0xf5,
    0x8e, 0x5, 0x82, 0xf6, 0x0, 0xb, 0xc0, 0x0,
    0xc, 0xc0, 0x8e, 0x0, 0x5, 0xf3, 0x0, 0xb,
    0xc0, 0x0, 0x2f, 0x30, 0x8e, 0x0, 0xa, 0xf0,
    0x0, 0xb, 0xc0, 0x47, 0x3, 0x0, 0x8e, 0x0,
    0x1f, 0xc0, 0x0, 0xb, 0xc0, 0x5c, 0x0, 0x0,
    0x8e, 0x0, 0x9f, 0x60, 0x0, 0xb, 0xc0, 0x6c,
    0x0, 0x0, 0x8e, 0x4, 0xfe, 0x0, 0x0, 0xa,
    0xe6, 0xba, 0x0, 0x0, 0x8e, 0xa, 0xf6, 0x0,
    0x0, 0x4, 0xef, 0xe4, 0x0, 0x0, 0x8e, 0x1,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+67E5 "查" */
    0x0, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x44, 0x44, 0x44,
    0x4b, 0xe4, 0x44, 0x44, 0x44, 0x30, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x11, 0x11, 0x1b, 0xfc, 0xec, 0xd2, 0x11,
    0x11, 0x0, 0x0, 0x0, 0x1, 0xcf, 0x49, 0xe0,
    0xcd, 0x30, 0x0, 0x0, 0x0, 0x0, 0x5e, 0xe3,
    0x9, 0xe0, 0xa, 0xf7, 0x0, 0x0, 0x0, 0x3b,
    0xfc, 0x10, 0x9, 0xe0, 0x0, 0x6f, 0xd6, 0x0,
    0xc, 0xfe, 0x72, 0x22, 0x24, 0x52, 0x22, 0x23,
    0xaf, 0xe1, 0x4, 0x70, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x2, 0x40, 0x0, 0x0, 0x5f, 0x20,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x43, 0x33, 0x33, 0x33, 0xdc, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xed, 0xdd, 0xdd, 0xdd, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xee,
    0xee, 0xee, 0xee, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x13, 0x33, 0x33, 0x33, 0x33, 0x32, 0x0, 0x0,
    0x1, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x40, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd0,

    /* U+68C0 "检" */
    0x0, 0x5, 0xc0, 0x0, 0x0, 0x0, 0x97, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf0, 0x0, 0x0, 0x4,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf0, 0x0,
    0x0, 0xd, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0xae, 0x17, 0xf5, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x8, 0xf4, 0x0, 0x9f,
    0x50, 0x0, 0x6, 0x6c, 0xf6, 0x60, 0x8f, 0x60,
    0x0, 0x9, 0xf8, 0x0, 0x0, 0xd, 0xf1, 0x1b,
    0xfa, 0x66, 0x66, 0x66, 0x9f, 0xb1, 0x0, 0x1f,
    0xfa, 0x7f, 0x59, 0xee, 0xee, 0xee, 0x25, 0xd0,
    0x0, 0x6f, 0xfe, 0x52, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcd, 0xf6, 0xe0, 0x20, 0x0,
    0x91, 0x0, 0x28, 0x10, 0x2, 0xf8, 0xf0, 0x90,
    0xd7, 0x0, 0xe5, 0x0, 0x8d, 0x0, 0xa, 0xb6,
    0xf0, 0x0, 0x8c, 0x0, 0xb8, 0x0, 0xe6, 0x0,
    0x2f, 0x46, 0xf0, 0x0, 0x3f, 0x10, 0x8b, 0x6,
    0xe0, 0x0, 0xa, 0x6, 0xf0, 0x0, 0xf, 0x50,
    0x6c, 0xd, 0x70, 0x0, 0x0, 0x6, 0xf0, 0x0,
    0x6, 0x20, 0x0, 0x5f, 0x10, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xd7, 0x0, 0x0,
    0x0, 0x6, 0xf0, 0x1e, 0xee, 0xee, 0xef, 0xff,
    0xee, 0xc0, 0x0, 0x6, 0xf0, 0x6, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x50, 0x0, 0x6, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+691C "検" */
    0x0, 0x1, 0xc3, 0x0, 0x0, 0x0, 0x9c, 0x20,
    0x0, 0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x7,
    0xfc, 0xe2, 0x0, 0x0, 0x0, 0x2, 0xf4, 0x0,
    0x0, 0x7f, 0x41, 0xde, 0x30, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0xa, 0xf5, 0x0, 0x1c, 0xf6, 0x0,
    0xa, 0xbc, 0xfc, 0xb9, 0xef, 0x84, 0x44, 0x45,
    0xdf, 0xc3, 0xa, 0xbc, 0xfc, 0xbd, 0xa9, 0xff,
    0xff, 0xff, 0xf7, 0xd1, 0x0, 0x7, 0xf4, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf6, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0x20, 0xef, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x6e, 0xfc, 0xc0, 0xe9, 0x44,
    0x9f, 0x44, 0x4f, 0x50, 0x0, 0xc9, 0xf5, 0xe6,
    0xe6, 0x0, 0x7e, 0x0, 0x1f, 0x50, 0x3, 0xf3,
    0xf4, 0x64, 0xe6, 0x0, 0x7e, 0x0, 0x1f, 0x50,
    0xb, 0xa2, 0xf4, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xff, 0x50, 0x3f, 0x32, 0xf4, 0x0, 0x33, 0x33,
    0xef, 0xb3, 0x33, 0x10, 0x7, 0x2, 0xf4, 0x0,
    0x0, 0x4, 0xfb, 0xf2, 0x0, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x2e, 0xc0, 0xec, 0x0, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x5, 0xed, 0x10, 0x3f,
    0xd3, 0x0, 0x0, 0x2, 0xf4, 0x6, 0xcf, 0xb1,
    0x0, 0x4, 0xef, 0xa2, 0x0, 0x2, 0xf4, 0xc,
    0xc4, 0x0, 0x0, 0x0, 0x19, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6A21 "模" */
    0x0, 0x6, 0xb0, 0x0, 0x0, 0xa7, 0x0, 0x4c,
    0x10, 0x0, 0x0, 0x8, 0xf0, 0x1, 0x22, 0xea,
    0x22, 0x7f, 0x42, 0x20, 0x0, 0x8, 0xf0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x8,
    0xf0, 0x1, 0x22, 0xea, 0x22, 0x7f, 0x42, 0x20,
    0xf, 0xff, 0xff, 0xf0, 0x0, 0x85, 0x0, 0x3a,
    0x10, 0x0, 0x7, 0x7c, 0xf7, 0x70, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0xb, 0xf1, 0x0,
    0xf8, 0x22, 0x22, 0x22, 0xae, 0x0, 0x0, 0xf,
    0xfb, 0x0, 0xf9, 0x33, 0x33, 0x33, 0xae, 0x0,
    0x0, 0x4f, 0xfe, 0x50, 0xfe, 0xee, 0xee, 0xee,
    0xfe, 0x0, 0x0, 0xaf, 0xf7, 0xe0, 0xf7, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x1, 0xfb, 0xf0, 0xd1,
    0xff, 0xee, 0xee, 0xee, 0xfe, 0x0, 0x7, 0xd8,
    0xf0, 0x0, 0x33, 0x33, 0xfa, 0x33, 0x33, 0x0,
    0x1e, 0x78, 0xf0, 0x2, 0x22, 0x23, 0xf7, 0x22,
    0x22, 0x10, 0x2e, 0x18, 0xf0, 0x3f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x2, 0x8, 0xf0, 0x2,
    0x22, 0x2d, 0xee, 0xa2, 0x22, 0x20, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x7f, 0x66, 0xf5, 0x0, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x19, 0xfb, 0x0, 0xaf,
    0x80, 0x0, 0x0, 0x8, 0xf0, 0x4a, 0xff, 0x90,
    0x0, 0x8, 0xfe, 0x91, 0x0, 0x8, 0xf0, 0x3e,
    0x92, 0x0, 0x0, 0x0, 0x3a, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6A5F "機" */
    0x0, 0xc, 0x40, 0x0, 0x0, 0x4, 0x50, 0x1,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x99, 0x8,
    0xc0, 0xb, 0x70, 0x0, 0x0, 0xe, 0x50, 0x1,
    0xf2, 0x7, 0xc0, 0x2e, 0x12, 0x0, 0x0, 0xe,
    0x50, 0x9, 0x82, 0xb7, 0xd0, 0xb7, 0x5e, 0x0,
    0x1f, 0xff, 0xfe, 0x5f, 0xad, 0x86, 0xe5, 0xff,
    0xf5, 0x0, 0x7, 0x8f, 0xa6, 0x79, 0xad, 0x5,
    0xf2, 0x38, 0xb2, 0x0, 0x0, 0x5f, 0x50, 0x1,
    0xe6, 0xa3, 0xf0, 0x3e, 0x2e, 0x10, 0x0, 0x9f,
    0xb0, 0xb, 0x72, 0xf4, 0xf4, 0xda, 0x8e, 0x60,
    0x0, 0xdf, 0xf4, 0x7f, 0xfe, 0xe7, 0xf6, 0xed,
    0x89, 0xb0, 0x1, 0xee, 0xad, 0x24, 0x81, 0x33,
    0xe6, 0x1e, 0x91, 0x0, 0x7, 0xae, 0x5a, 0x35,
    0xf6, 0x44, 0xda, 0x45, 0xe7, 0x20, 0xd, 0x5e,
    0x50, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x4f, 0xe, 0x50, 0x3, 0xf2, 0x0, 0x6e, 0x0,
    0x95, 0x0, 0x5a, 0xe, 0x50, 0x6, 0xfe, 0x20,
    0x2f, 0x35, 0xf4, 0x0, 0x2, 0xe, 0x50, 0xa,
    0xca, 0xf4, 0xd, 0xae, 0x90, 0x0, 0x0, 0xe,
    0x50, 0x1f, 0x60, 0xaa, 0x8, 0xfb, 0x0, 0x50,
    0x0, 0xe, 0x50, 0xbd, 0x0, 0x0, 0x6f, 0xf9,
    0x0, 0xf1, 0x0, 0xe, 0x59, 0xf4, 0x0, 0x4c,
    0xf6, 0x5f, 0xba, 0xd0, 0x0, 0xe, 0x58, 0x50,
    0x0, 0x98, 0x10, 0x4, 0xdf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6AA2 "檢" */
    0x0, 0x4, 0xb0, 0x0, 0x0, 0x0, 0xb9, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x9,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x5, 0xe0, 0x0,
    0x0, 0x8f, 0x8d, 0xd4, 0x0, 0x0, 0x0, 0x5,
    0xe0, 0x0, 0xa, 0xf7, 0x0, 0xaf, 0xa2, 0x0,
    0xa, 0xef, 0xfe, 0xa4, 0xef, 0x94, 0x44, 0x48,
    0xdf, 0xb2, 0x5, 0x7c, 0xf7, 0x6d, 0xb4, 0xff,
    0xff, 0xfe, 0x6, 0xd1, 0x0, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xf8, 0x3, 0xdd, 0xdd, 0x24, 0xdd, 0xdd, 0x10,
    0x0, 0x4f, 0xfe, 0x23, 0xf4, 0x4f, 0x35, 0xe4,
    0x5f, 0x10, 0x0, 0x9c, 0xe8, 0xb3, 0xe0, 0xf,
    0x35, 0xd0, 0x2f, 0x10, 0x0, 0xe7, 0xe1, 0xa3,
    0xe0, 0xf, 0x35, 0xd0, 0x2f, 0x10, 0x5, 0xd5,
    0xe0, 0x3, 0xff, 0xff, 0x35, 0xff, 0xff, 0x10,
    0xd, 0x75, 0xe0, 0x0, 0x24, 0x32, 0x0, 0x27,
    0x32, 0x0, 0xb, 0x15, 0xe0, 0x0, 0xd, 0x90,
    0x0, 0x2f, 0x40, 0x0, 0x0, 0x5, 0xe0, 0x0,
    0x4f, 0x60, 0x0, 0x7f, 0x10, 0x0, 0x0, 0x5,
    0xe0, 0x0, 0xde, 0xf8, 0x0, 0xef, 0xe3, 0x0,
    0x0, 0x5, 0xe0, 0xa, 0xf2, 0x5f, 0x59, 0xf3,
    0xcf, 0x40, 0x0, 0x5, 0xe0, 0xaf, 0x40, 0x3,
    0x8f, 0x70, 0xb, 0xf2, 0x0, 0x5, 0xe1, 0xc5,
    0x0, 0x0, 0x89, 0x0, 0x0, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6B63 "正" */
    0x6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x75, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xea, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x31, 0x0, 0x0, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x70, 0x0, 0xe, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0xed,
    0x88, 0x88, 0x87, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x1, 0xf7,
    0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x70, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf7, 0x0, 0x0, 0xea, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0xe, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0,
    0xea, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x9, 0xcc,
    0xfe, 0xcc, 0xcc, 0xfe, 0xcc, 0xcc, 0xcc, 0xc4,
    0x8b, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb,
    0xbb, 0x40,

    /* U+6CD5 "法" */
    0x0, 0x43, 0x0, 0x0, 0x0, 0x0, 0xc5, 0x0,
    0x0, 0x0, 0xb, 0xfc, 0x30, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x0, 0x4, 0xdf, 0x50, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x80,
    0x25, 0x55, 0x6f, 0xa5, 0x55, 0x50, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x11, 0x1f, 0x71, 0x11,
    0x0, 0xc, 0xb3, 0x0, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0x6e, 0xf9, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x1,
    0x11, 0x12, 0xf8, 0x11, 0x11, 0x10, 0x0, 0x1,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x0, 0x15, 0x55, 0x5e, 0xe5, 0x55, 0x55,
    0x30, 0x0, 0x0, 0x90, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x30, 0x0, 0xde,
    0x0, 0x34, 0x0, 0x0, 0x0, 0x1e, 0xb0, 0x0,
    0x6f, 0x50, 0x8, 0xf2, 0x0, 0x0, 0x8, 0xf2,
    0x0, 0x1e, 0xb0, 0x0, 0xd, 0xc0, 0x0, 0x2,
    0xf9, 0x0, 0xa, 0xf2, 0x0, 0x24, 0x9f, 0x70,
    0x0, 0xcf, 0x10, 0x7, 0xfe, 0xde, 0xff, 0xff,
    0xef, 0x10, 0x4f, 0x60, 0x0, 0x7e, 0xb9, 0x75,
    0x31, 0x1, 0xf8, 0x0, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x40,

    /* U+6D3B "活" */
    0x2, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38,
    0x60, 0x0, 0x8f, 0xc4, 0x0, 0x13, 0x57, 0xad,
    0xff, 0xfb, 0x10, 0x0, 0x4d, 0xf7, 0x3f, 0xff,
    0xee, 0xf6, 0x30, 0x0, 0x0, 0x0, 0x7, 0x20,
    0x42, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x7d, 0x40, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x73, 0xcf, 0xb2, 0x27, 0x77, 0x77,
    0xbf, 0x77, 0x77, 0x73, 0x0, 0x6e, 0x50, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0x10, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x4, 0xf5, 0xf, 0xa6, 0x66,
    0x66, 0x6c, 0xc0, 0x0, 0x0, 0xcd, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x5f, 0x40,
    0xf, 0x70, 0x0, 0x0, 0xa, 0xc0, 0x0, 0xe,
    0xc0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0xac, 0x0,
    0x9, 0xf3, 0x0, 0xf, 0xb7, 0x77, 0x77, 0x7c,
    0xc0, 0x2, 0xfa, 0x0, 0x0, 0xff, 0xee, 0xee,
    0xee, 0xfc, 0x0, 0x7, 0x10, 0x0, 0xf, 0x70,
    0x0, 0x0, 0xa, 0xc0, 0x0,

    /* U+6D41 "流" */
    0x0, 0x62, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0x0, 0x1, 0xdf, 0x70, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x9, 0xfa, 0x35,
    0x55, 0x56, 0xfb, 0x55, 0x55, 0x50, 0x0, 0x0,
    0x67, 0xaf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfa, 0x0, 0x27,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xd0,
    0x0, 0x5f, 0x70, 0x0, 0xd, 0xc4, 0x0, 0x0,
    0xaf, 0x20, 0x0, 0x1a, 0xf4, 0x0, 0x5, 0xef,
    0xa1, 0x2d, 0xfe, 0xde, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x8, 0xe0, 0x1e, 0xca, 0x97, 0x65, 0x32,
    0x3f, 0xb0, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x5, 0x30, 0x0, 0x0, 0x0, 0x0,
    0xf6, 0x7, 0xe0, 0xe, 0x80, 0x0, 0x0, 0x0,
    0x2a, 0x0, 0xf6, 0x7, 0xe0, 0xe, 0x80, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0xf5, 0x7, 0xe0, 0xe,
    0x80, 0x0, 0x0, 0x4, 0xf5, 0x1, 0xf4, 0x7,
    0xe0, 0xe, 0x80, 0x0, 0x0, 0xd, 0xc0, 0x5,
    0xf1, 0x7, 0xe0, 0xe, 0x80, 0x51, 0x0, 0x9f,
    0x30, 0xb, 0xc0, 0x7, 0xe0, 0xe, 0x80, 0xc4,
    0x4, 0xf9, 0x0, 0x6f, 0x30, 0x7, 0xe0, 0xd,
    0xa3, 0xe2, 0x3, 0xc1, 0x5, 0xf5, 0x0, 0x6,
    0xd0, 0x8, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6D4B "测" */
    0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0x20, 0x3f, 0xe5, 0x9, 0xaa, 0xaa, 0xa9,
    0x0, 0x0, 0xe5, 0x0, 0x2c, 0xf6, 0xea, 0x88,
    0x8a, 0xe0, 0x5d, 0xe, 0x50, 0x0, 0x6, 0xe,
    0x40, 0x0, 0x4e, 0x5, 0xd0, 0xe5, 0x0, 0x0,
    0x0, 0xe4, 0x3e, 0x4, 0xe0, 0x5d, 0xe, 0x50,
    0x0, 0x0, 0xe, 0x43, 0xe0, 0x4e, 0x5, 0xd0,
    0xe5, 0x2e, 0xa1, 0x0, 0xe4, 0x3e, 0x4, 0xe0,
    0x5d, 0xe, 0x50, 0x6e, 0xf5, 0xe, 0x43, 0xe0,
    0x4e, 0x5, 0xd0, 0xe5, 0x0, 0x1a, 0x40, 0xe4,
    0x3e, 0x4, 0xe0, 0x5d, 0xe, 0x50, 0x0, 0x0,
    0xe, 0x43, 0xe0, 0x4e, 0x5, 0xd0, 0xe5, 0x0,
    0x0, 0x0, 0xe4, 0x3e, 0x4, 0xe0, 0x5d, 0xe,
    0x50, 0x0, 0x55, 0xe, 0x43, 0xe0, 0x4e, 0x5,
    0xd0, 0xe5, 0x0, 0xc, 0xb0, 0xe4, 0x4d, 0x4,
    0xe0, 0x5d, 0xe, 0x50, 0x2, 0xf6, 0xd, 0x36,
    0xb0, 0x4c, 0x5, 0xd0, 0xe5, 0x0, 0x8f, 0x10,
    0x0, 0xb8, 0x20, 0x0, 0x0, 0xe, 0x50, 0xe,
    0xa0, 0x0, 0x2f, 0x5f, 0x50, 0x0, 0x0, 0xe5,
    0x5, 0xf4, 0x0, 0x1d, 0xa0, 0x5f, 0x30, 0x0,
    0xe, 0x50, 0xce, 0x0, 0x3d, 0xc0, 0x0, 0x9d,
    0x10, 0x44, 0xf4, 0x4, 0x60, 0x9, 0x90, 0x0,
    0x0, 0xa2, 0xe, 0xfc, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6D4F "浏" */
    0x0, 0x30, 0x0, 0x2, 0xa1, 0x0, 0x0, 0x0,
    0xf, 0x60, 0x1e, 0xb0, 0x0, 0xe, 0xa0, 0x0,
    0x0, 0x0, 0xf6, 0x0, 0x3f, 0xa0, 0x0, 0x6f,
    0x10, 0x3, 0xe0, 0xf, 0x60, 0x0, 0x4c, 0x49,
    0x9a, 0xc9, 0x98, 0x3f, 0x10, 0xf6, 0x0, 0x0,
    0x5, 0xcc, 0xcc, 0xfe, 0xb3, 0xf1, 0xf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x80, 0x3f, 0x10,
    0xf6, 0xc, 0x90, 0x0, 0x32, 0x1, 0xf5, 0x3,
    0xf1, 0xf, 0x60, 0x4f, 0xc0, 0xc, 0xc0, 0x4f,
    0x20, 0x3f, 0x10, 0xf6, 0x0, 0x2e, 0x50, 0x2f,
    0x87, 0xe0, 0x3, 0xf1, 0xf, 0x60, 0x0, 0x10,
    0x0, 0x7f, 0xda, 0x0, 0x3f, 0x10, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x60, 0x3, 0xf1, 0xf,
    0x60, 0x0, 0x3a, 0x0, 0x6, 0xf7, 0x0, 0x3f,
    0x10, 0xf6, 0x0, 0x9, 0xd0, 0x0, 0xcf, 0xf1,
    0x3, 0xf1, 0xf, 0x60, 0x0, 0xf8, 0x0, 0x3f,
    0x7f, 0x90, 0x3f, 0x10, 0xf6, 0x0, 0x6f, 0x20,
    0xb, 0xd0, 0x9f, 0x10, 0x0, 0xf, 0x60, 0xd,
    0xb0, 0x6, 0xf4, 0x2, 0xf4, 0x0, 0x0, 0xf6,
    0x4, 0xf5, 0x4, 0xfa, 0x0, 0x3, 0x0, 0x0,
    0xf, 0x60, 0x7e, 0x0, 0xed, 0x0, 0x0, 0x0,
    0x1, 0x55, 0xf5, 0x0, 0x20, 0x3, 0x10, 0x0,
    0x0, 0x0, 0xf, 0xfc, 0x10,

    /* U+6E2C "測" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1a, 0x30, 0x1, 0x22, 0x22, 0x10,
    0x0, 0x1, 0xf4, 0x3, 0xdf, 0x80, 0xef, 0xff,
    0xfe, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x8f, 0x3e,
    0x73, 0x38, 0xe0, 0x6e, 0x1, 0xf4, 0x0, 0x0,
    0x20, 0xe5, 0x0, 0x6e, 0x6, 0xe0, 0x1f, 0x40,
    0x0, 0x0, 0xe, 0x95, 0x59, 0xe0, 0x6e, 0x1,
    0xf4, 0x4, 0x0, 0x0, 0xef, 0xee, 0xfe, 0x6,
    0xe0, 0x1f, 0x42, 0xfe, 0x60, 0xe, 0x50, 0x6,
    0xe0, 0x6e, 0x1, 0xf4, 0x2, 0xaf, 0x70, 0xe5,
    0x0, 0x6e, 0x6, 0xe0, 0x1f, 0x40, 0x0, 0x51,
    0xe, 0xb9, 0x9c, 0xe0, 0x6e, 0x1, 0xf4, 0x0,
    0x0, 0x0, 0xec, 0xaa, 0xce, 0x6, 0xe0, 0x1f,
    0x40, 0x0, 0x0, 0xe, 0x50, 0x6, 0xe0, 0x6e,
    0x1, 0xf4, 0x0, 0x6, 0x80, 0xe5, 0x0, 0x6e,
    0x6, 0xe0, 0x1f, 0x40, 0x0, 0xcb, 0xe, 0xed,
    0xde, 0xe0, 0x6e, 0x1, 0xf4, 0x0, 0x2f, 0x50,
    0x77, 0x77, 0x77, 0x3, 0x70, 0x1f, 0x40, 0x8,
    0xf0, 0x4, 0xc1, 0x2d, 0x30, 0x0, 0x1, 0xf4,
    0x0, 0xe9, 0x0, 0xcc, 0x0, 0xce, 0x0, 0x0,
    0x1f, 0x40, 0x6f, 0x30, 0x6f, 0x40, 0x2, 0xf9,
    0x0, 0x1, 0xf4, 0xd, 0xd0, 0x2f, 0xa0, 0x0,
    0x8, 0xe0, 0x56, 0x8f, 0x30, 0x35, 0x5, 0xc0,
    0x0, 0x0, 0x0, 0xa, 0xfe, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6E80 "満" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x58, 0x10, 0x0, 0x7, 0xe0, 0x0,
    0xe8, 0x0, 0x0, 0x7, 0xfe, 0x50, 0x0, 0x7e,
    0x0, 0xe, 0x80, 0x0, 0x0, 0x1, 0xbf, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x42, 0x66, 0xbf, 0x66, 0x6f, 0xb6, 0x63, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0xe8, 0x0,
    0x0, 0x11, 0x0, 0x5, 0x55, 0xaf, 0x55, 0x5f,
    0xb5, 0x55, 0xa, 0xfa, 0x20, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x19, 0xff, 0x40, 0x0,
    0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0x3, 0xc1,
    0x1, 0x11, 0x14, 0xf3, 0x11, 0x12, 0x0, 0x0,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0x7f, 0x33, 0x33, 0xf3, 0x33,
    0x3d, 0x90, 0x0, 0x5, 0x87, 0xe0, 0x55, 0xf,
    0x4, 0x60, 0xd9, 0x0, 0x0, 0xcc, 0x7e, 0x8,
    0x70, 0xf0, 0x69, 0xd, 0x90, 0x0, 0x3f, 0x57,
    0xe0, 0x87, 0xf, 0x6, 0x90, 0xd9, 0x0, 0xb,
    0xe0, 0x7e, 0x8, 0xec, 0xfc, 0xe9, 0xd, 0x90,
    0x3, 0xf7, 0x7, 0xe0, 0x8a, 0x66, 0x6a, 0x90,
    0xd9, 0x0, 0xbf, 0x10, 0x7e, 0x5, 0x40, 0x0,
    0x22, 0xd, 0x90, 0x3f, 0x90, 0x7, 0xe0, 0x0,
    0x0, 0x2, 0x33, 0xe9, 0x0, 0x71, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6E90 "源" */
    0x0, 0x72, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xef, 0x70, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x0, 0x9, 0xf9, 0x5f,
    0x76, 0x66, 0x78, 0x66, 0x66, 0x50, 0x0, 0x0,
    0x52, 0x5f, 0x10, 0x0, 0x5f, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x12, 0x22, 0xae, 0x22,
    0x22, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x1e, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x1e, 0xa1, 0x0, 0x5f,
    0x1e, 0x70, 0x0, 0x0, 0x4f, 0x20, 0x6, 0xff,
    0x60, 0x5f, 0x1e, 0x82, 0x22, 0x22, 0x6f, 0x20,
    0x0, 0x1b, 0x70, 0x6f, 0xe, 0xff, 0xff, 0xff,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x7f, 0xe, 0x70,
    0x0, 0x0, 0x4f, 0x20, 0x0, 0x0, 0x0, 0x8f,
    0xe, 0xa6, 0x66, 0x66, 0x8f, 0x20, 0x0, 0x1,
    0xb1, 0x9d, 0xb, 0xcc, 0xdf, 0xdc, 0xcc, 0x10,
    0x0, 0x7, 0xf1, 0xcb, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0xf8, 0x5, 0xc0,
    0x2f, 0x42, 0xf5, 0x0, 0x0, 0x5f, 0x43, 0xf4,
    0xc, 0xa0, 0x2f, 0x40, 0xbe, 0x0, 0x0, 0xcd,
    0x8, 0xf0, 0x5f, 0x20, 0x2f, 0x40, 0x3f, 0x70,
    0x4, 0xf7, 0xe, 0xa1, 0xe9, 0x0, 0x2f, 0x40,
    0xb, 0xe0, 0xb, 0xe0, 0x7f, 0x30, 0x80, 0x24,
    0x6f, 0x40, 0x2, 0x40, 0x3, 0x60, 0x59, 0x0,
    0x0, 0x6f, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6EE1 "满" */
    0x0, 0x20, 0x0, 0x0, 0x6, 0xb0, 0x0, 0xb6,
    0x0, 0x0, 0x0, 0xdd, 0x40, 0x23, 0x39, 0xf3,
    0x33, 0xe9, 0x33, 0x20, 0x0, 0x2c, 0xf7, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x83, 0x11, 0x18, 0xf1, 0x11, 0xe9, 0x11, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x90, 0x0, 0x95,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xb1, 0x7, 0x60, 0x1, 0x99,
    0x99, 0xdd, 0x9a, 0xf9, 0x99, 0x90, 0xa, 0xfc,
    0x20, 0x0, 0x0, 0xa8, 0x3, 0xf0, 0x0, 0x0,
    0x0, 0x5e, 0x90, 0x37, 0x77, 0xdb, 0x79, 0xf7,
    0x77, 0x30, 0x0, 0x1, 0x0, 0x8f, 0xee, 0xff,
    0xef, 0xfe, 0xef, 0x80, 0x0, 0x0, 0x0, 0x8e,
    0x0, 0xe5, 0x6, 0xc0, 0xe, 0x80, 0x0, 0x0,
    0x92, 0x8e, 0x2, 0xf5, 0x9, 0xd0, 0xe, 0x80,
    0x0, 0x4, 0xf5, 0x8e, 0x6, 0xff, 0x2d, 0xfa,
    0xe, 0x80, 0x0, 0xc, 0xd0, 0x8e, 0xd, 0x88,
    0x9f, 0x3f, 0x5e, 0x80, 0x0, 0x5f, 0x50, 0x8e,
    0xae, 0x0, 0xca, 0x7, 0x5e, 0x80, 0x0, 0xec,
    0x0, 0x8e, 0x23, 0x1, 0xc1, 0x0, 0xe, 0x80,
    0x7, 0xf4, 0x0, 0x8e, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x80, 0x1, 0x70, 0x0, 0x8e, 0x0, 0x0,
    0x0, 0x1f, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x8e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6EFF "滿" */
    0x0, 0x50, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x5, 0xfc, 0x30, 0x0, 0x5f, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0x0, 0x3d, 0xf7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x52, 0x66, 0xaf, 0x66, 0x66, 0xbf, 0x66, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x9e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xee,
    0xee, 0xfe, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x0,
    0x26, 0x6a, 0xf6, 0x66, 0x0, 0x0, 0x8, 0xfe,
    0x20, 0x22, 0x22, 0x28, 0xf2, 0x22, 0x23, 0x10,
    0x0, 0x2c, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0xe7, 0x22, 0x28,
    0xf2, 0x32, 0x2e, 0x70, 0x0, 0x0, 0x0, 0xe6,
    0x87, 0x6, 0xe0, 0xe1, 0xe, 0x70, 0x0, 0x0,
    0xb0, 0xe6, 0x2e, 0x6, 0xe0, 0x88, 0xe, 0x70,
    0x0, 0x7, 0xf0, 0xe6, 0xf, 0x66, 0xe0, 0x8e,
    0xe, 0x70, 0x0, 0xe, 0x80, 0xe6, 0x6e, 0xc6,
    0xe0, 0xec, 0x5e, 0x70, 0x0, 0x7f, 0x10, 0xe6,
    0xd3, 0xf8, 0xe6, 0xa5, 0xae, 0x70, 0x1, 0xf8,
    0x0, 0xeb, 0xa0, 0xac, 0xec, 0x21, 0xde, 0x70,
    0xa, 0xe0, 0x0, 0xe6, 0x0, 0x6, 0xe0, 0x0,
    0xe, 0x70, 0x6, 0x60, 0x0, 0xe6, 0x0, 0x6,
    0xe0, 0x2, 0x2e, 0x70, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0xc, 0xfe, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6FC0 "激" */
    0x3, 0x70, 0x0, 0x0, 0xe7, 0x0, 0x1, 0xe3,
    0x0, 0x0, 0x4, 0xfb, 0x10, 0x3, 0xf3, 0x0,
    0x3, 0xf1, 0x0, 0x0, 0x0, 0x2e, 0xc4, 0xff,
    0xff, 0xfb, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x2,
    0x45, 0xe2, 0x22, 0x9b, 0x9, 0xc1, 0x11, 0x10,
    0x0, 0x0, 0x5, 0xe1, 0x11, 0x9b, 0xc, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x5, 0xff, 0xff, 0xfb,
    0x1f, 0xa6, 0x6f, 0xa2, 0x1d, 0x60, 0x5, 0xe0,
    0x0, 0x8b, 0x5f, 0x60, 0xf, 0x40, 0x7, 0xfa,
    0x5, 0xf3, 0x33, 0xab, 0xbf, 0x90, 0x2f, 0x10,
    0x0, 0x4d, 0x14, 0xee, 0xee, 0xed, 0xf8, 0xc0,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x4, 0xd1, 0x0,
    0x62, 0xf0, 0x8b, 0x0, 0x0, 0x0, 0x3c, 0xcd,
    0xfd, 0xcc, 0x20, 0xe4, 0xd8, 0x0, 0x0, 0x5,
    0x47, 0xaf, 0x87, 0x77, 0x10, 0x9b, 0xf3, 0x0,
    0x0, 0xe, 0x70, 0x4f, 0x54, 0x42, 0x0, 0x4f,
    0xd0, 0x0, 0x0, 0x5f, 0x10, 0x6f, 0xff, 0xfa,
    0x0, 0xf, 0x90, 0x0, 0x0, 0xca, 0x0, 0xad,
    0x0, 0xb9, 0x0, 0x8f, 0xf2, 0x0, 0x3, 0xf4,
    0x2, 0xf7, 0x0, 0xd8, 0x4, 0xf5, 0xdc, 0x0,
    0xb, 0xd0, 0x1d, 0xd1, 0x33, 0xf6, 0x4f, 0x90,
    0x3f, 0xb1, 0x9, 0x50, 0xbe, 0x20, 0xff, 0xd3,
    0xf9, 0x0, 0x5, 0xe3, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0, 0x10,

    /* U+700F "瀏" */
    0x0, 0x10, 0x0, 0x5, 0x80, 0x0, 0x0, 0x0,
    0x2b, 0x0, 0x7e, 0x10, 0x5d, 0xe7, 0xaf, 0xff,
    0x60, 0x3, 0xf0, 0x0, 0xcd, 0x1c, 0x80, 0x2,
    0xc8, 0xc5, 0x51, 0x3f, 0x0, 0x1, 0xd7, 0xc4,
    0x54, 0xc, 0x4b, 0x5e, 0x33, 0xf0, 0x0, 0x2,
    0xc, 0x45, 0xb0, 0xf1, 0xc4, 0xe3, 0x3f, 0x0,
    0x0, 0x0, 0xc8, 0xcf, 0x6c, 0xe, 0x2e, 0x33,
    0xf0, 0x2a, 0x10, 0x1f, 0xd5, 0x6a, 0x7b, 0xe0,
    0xe3, 0x3f, 0x1, 0xbe, 0x30, 0x60, 0x9, 0xf4,
    0x52, 0xe, 0x33, 0xf0, 0x0, 0xac, 0x0, 0x1a,
    0xd7, 0xe9, 0x0, 0xe3, 0x3f, 0x0, 0x0, 0x10,
    0x5e, 0xc1, 0x2, 0xbe, 0x3e, 0x33, 0xf0, 0x0,
    0x0, 0x4f, 0x8f, 0xff, 0xfd, 0x64, 0xe3, 0x3f,
    0x0, 0x0, 0x72, 0x10, 0x15, 0xd1, 0x0, 0xe,
    0x33, 0xf0, 0x0, 0x1f, 0x48, 0x99, 0xbe, 0x99,
    0x92, 0xe3, 0x3f, 0x0, 0x7, 0xd0, 0x79, 0x9b,
    0xe9, 0x99, 0x1d, 0x33, 0xf0, 0x0, 0xe7, 0x0,
    0xc3, 0x4c, 0xd, 0x30, 0x0, 0x3f, 0x0, 0x7f,
    0x0, 0x6, 0xb4, 0xc4, 0xc0, 0x0, 0x3, 0xf0,
    0xe, 0x80, 0x26, 0x8d, 0xbf, 0xed, 0xc4, 0x34,
    0x7f, 0x0, 0x31, 0x2, 0x76, 0x43, 0x10, 0x0,
    0x9, 0xfe, 0x90,

    /* U+70B9 "点" */
    0x0, 0x0, 0x0, 0x0, 0x86, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed,
    0x77, 0x77, 0x77, 0x73, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xea, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5b, 0xbb, 0xbb, 0xfe, 0xbb, 0xbb,
    0xba, 0x0, 0x0, 0x8, 0xfb, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbd, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x8, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x37, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x76, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x40, 0x0, 0x0, 0xae, 0x0,
    0xc7, 0x0, 0xab, 0x0, 0x7f, 0x40, 0x0, 0x3f,
    0x70, 0xc, 0xa0, 0x6, 0xf2, 0x0, 0xbe, 0x10,
    0xd, 0xd0, 0x0, 0xbd, 0x0, 0x1f, 0x90, 0x1,
    0xfa, 0xa, 0xf3, 0x0, 0x9, 0xe0, 0x0, 0xbc,
    0x0, 0x8, 0xe1, 0x2, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+70ED "热" */
    0x0, 0x6, 0xb0, 0x0, 0x0, 0x6c, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0x7e, 0xef, 0xfe, 0xef, 0xb0, 0x0, 0x36, 0x6b,
    0xf6, 0x63, 0x66, 0xce, 0x66, 0xcb, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0xa, 0xc0, 0xa, 0xb0,
    0x0, 0x0, 0x7, 0xe0, 0x42, 0x0, 0xba, 0x0,
    0xab, 0x0, 0x0, 0x3, 0xbf, 0xff, 0x8d, 0x6e,
    0x80, 0xa, 0xb0, 0x0, 0x9e, 0xff, 0xf6, 0x20,
    0x8f, 0xf6, 0x0, 0xab, 0x0, 0x7, 0x84, 0x8e,
    0x0, 0x0, 0x8f, 0xf6, 0x9, 0xb0, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x1e, 0xa8, 0xf8, 0x8c, 0x3,
    0x30, 0x0, 0x7e, 0x0, 0x1c, 0xf2, 0x4, 0x46,
    0xf0, 0x7b, 0x7, 0x9d, 0xe0, 0x2d, 0xf4, 0x0,
    0x0, 0x1f, 0xad, 0x80, 0x5b, 0xa4, 0x0, 0x82,
    0x0, 0x0, 0x0, 0x5d, 0xb1, 0x0, 0x57, 0x0,
    0x22, 0x0, 0x34, 0x0, 0x6a, 0x0, 0x0, 0x1e,
    0xa0, 0xd, 0x90, 0x8, 0xe0, 0x4, 0xfa, 0x0,
    0xa, 0xf1, 0x0, 0xac, 0x0, 0x2f, 0x50, 0x8,
    0xf6, 0x6, 0xf6, 0x0, 0x9, 0xe0, 0x0, 0xd9,
    0x0, 0xd, 0xf2, 0x47, 0x0, 0x0, 0x46, 0x0,
    0x4, 0x30, 0x0, 0x38, 0x10,

    /* U+7121 "無" */
    0x0, 0x0, 0x9, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfd, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x10, 0x0, 0x2e,
    0xfe, 0xef, 0xfe, 0xef, 0xfe, 0xff, 0xee, 0x30,
    0x2, 0xee, 0xf3, 0x6, 0xe0, 0xf, 0x50, 0x4f,
    0x20, 0x0, 0xc, 0xd3, 0xf3, 0x6, 0xe0, 0xf,
    0x50, 0x4f, 0x20, 0x0, 0x0, 0x12, 0xf3, 0x6,
    0xe0, 0xf, 0x50, 0x4f, 0x20, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x2, 0x68, 0xf8, 0x6a, 0xf6, 0x6f, 0xa6, 0x9f,
    0x86, 0x20, 0x0, 0x2, 0xf3, 0x6, 0xe0, 0xf,
    0x50, 0x4f, 0x20, 0x0, 0x0, 0x2, 0xf3, 0x6,
    0xe0, 0xf, 0x50, 0x4f, 0x20, 0x0, 0x0, 0x2,
    0xf3, 0x6, 0xe0, 0xf, 0x50, 0x4f, 0x20, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xd0, 0x5, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x50, 0x0, 0x8, 0x60, 0x4,
    0x20, 0x5, 0x30, 0x7, 0xa0, 0x0, 0x0, 0x3f,
    0x60, 0xc, 0x90, 0xb, 0xd0, 0x4, 0xf8, 0x0,
    0x0, 0xce, 0x0, 0xa, 0xc0, 0x5, 0xf2, 0x0,
    0x9f, 0x30, 0x8, 0xf4, 0x0, 0x9, 0xe0, 0x0,
    0xf8, 0x0, 0xe, 0xd0, 0x4, 0x50, 0x0, 0x3,
    0x40, 0x0, 0x42, 0x0, 0x4, 0x50,

    /* U+7248 "版" */
    0x0, 0x22, 0x1, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x14, 0x20, 0x0, 0xbb, 0x2, 0xf3, 0x1, 0x57,
    0x8a, 0xce, 0xff, 0xd0, 0x0, 0xbb, 0x2, 0xf3,
    0x5, 0xfe, 0xcb, 0x97, 0x52, 0x0, 0x0, 0xbb,
    0x2, 0xf3, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbb, 0x2, 0xf3, 0x5, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbc, 0x35, 0xf6, 0x35, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xf5, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0xbb,
    0x11, 0x11, 0x15, 0xfb, 0xe6, 0x66, 0x6e, 0xa0,
    0x0, 0xbb, 0x0, 0x0, 0x5, 0xf5, 0xf0, 0x0,
    0xf, 0x70, 0x0, 0xbb, 0x0, 0x0, 0x5, 0xf1,
    0xf4, 0x0, 0x4f, 0x30, 0x0, 0xbf, 0xff, 0xfc,
    0x6, 0xf0, 0xa9, 0x0, 0x9e, 0x0, 0x0, 0xcc,
    0x55, 0xbc, 0x6, 0xf0, 0x5f, 0x0, 0xf9, 0x0,
    0x0, 0xd9, 0x0, 0x9c, 0x7, 0xf0, 0xf, 0x77,
    0xf2, 0x0, 0x0, 0xe7, 0x0, 0x9c, 0x9, 0xd0,
    0x8, 0xef, 0xa0, 0x0, 0x1, 0xf5, 0x0, 0x9c,
    0xb, 0xb0, 0x1, 0xff, 0x20, 0x0, 0x4, 0xf2,
    0x0, 0x9c, 0xe, 0x80, 0x9, 0xff, 0x70, 0x0,
    0x8, 0xe0, 0x0, 0x9c, 0x3f, 0x40, 0xaf, 0x8a,
    0xf7, 0x0, 0xe, 0x90, 0x0, 0x9c, 0x8f, 0x4d,
    0xf7, 0x0, 0xaf, 0xb2, 0xa, 0x30, 0x0, 0x9c,
    0x68, 0x3d, 0x40, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+72B6 "状" */
    0x0, 0x0, 0x6, 0x20, 0x0, 0x1, 0x51, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x3,
    0xf4, 0x8, 0x30, 0x0, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x3, 0xf4, 0xa, 0xe1, 0x0, 0x9, 0x80,
    0x1f, 0x60, 0x0, 0x3, 0xf4, 0x0, 0xdc, 0x0,
    0x5, 0xf6, 0x1f, 0x60, 0x0, 0x3, 0xf4, 0x0,
    0x3e, 0x20, 0x0, 0x9f, 0x4f, 0x60, 0x0, 0x3,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xd, 0x7f, 0x6d,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x1f, 0x67, 0x88, 0x8b, 0xfc, 0x88, 0x88, 0x80,
    0x0, 0x0, 0x1f, 0x60, 0x0, 0x6, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0, 0x8,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff, 0x60,
    0x0, 0xc, 0xef, 0x40, 0x0, 0x0, 0x0, 0x5f,
    0xcf, 0x60, 0x0, 0xf, 0x8c, 0xa0, 0x0, 0x0,
    0x6, 0xfb, 0x1f, 0x60, 0x0, 0x5f, 0x46, 0xf1,
    0x0, 0x0, 0x2f, 0xb0, 0x1f, 0x60, 0x0, 0xcd,
    0x1, 0xf9, 0x0, 0x0, 0x5, 0x0, 0x1f, 0x60,
    0x5, 0xf6, 0x0, 0x8f, 0x30, 0x0, 0x0, 0x0,
    0x1f, 0x60, 0x1e, 0xd0, 0x0, 0xe, 0xd1, 0x0,
    0x0, 0x0, 0x1f, 0x60, 0xcf, 0x30, 0x0, 0x4,
    0xfc, 0x10, 0x0, 0x0, 0x1f, 0x8c, 0xf5, 0x0,
    0x0, 0x0, 0x6f, 0xe2, 0x0, 0x0, 0x1f, 0x7b,
    0x50, 0x0, 0x0, 0x0, 0x5, 0xa0,

    /* U+72C0 "狀" */
    0x0, 0x0, 0x0, 0xc5, 0x0, 0x0, 0xb6, 0x0,
    0x0, 0x0, 0x5, 0xf0, 0x0, 0xf6, 0x0, 0x0,
    0xe8, 0x2f, 0x50, 0x0, 0x6, 0xf0, 0x0, 0xf6,
    0x0, 0x0, 0xe8, 0x8, 0xf3, 0x0, 0x6, 0xf0,
    0x0, 0xf6, 0x0, 0x0, 0xe8, 0x0, 0xbe, 0x0,
    0x6, 0xf0, 0x0, 0xf6, 0x0, 0x0, 0xe8, 0x0,
    0x2c, 0x20, 0x6, 0xf1, 0x11, 0xf6, 0x0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0x6, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x1, 0x44,
    0x44, 0xf8, 0x88, 0x88, 0xff, 0x88, 0x88, 0x70,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x2,
    0xff, 0x30, 0x0, 0x0, 0x9, 0x99, 0x99, 0xf6,
    0x0, 0x5, 0xff, 0x60, 0x0, 0x0, 0x1c, 0xef,
    0xcc, 0xf6, 0x0, 0x8, 0xfc, 0xa0, 0x0, 0x0,
    0x0, 0x9c, 0x0, 0xf6, 0x0, 0xd, 0xb8, 0xf1,
    0x0, 0x0, 0x0, 0xac, 0x0, 0xf6, 0x0, 0x4f,
    0x52, 0xf7, 0x0, 0x0, 0x0, 0xca, 0x0, 0xf6,
    0x0, 0xde, 0x0, 0xbe, 0x10, 0x0, 0x0, 0xf6,
    0x0, 0xf6, 0x8, 0xf5, 0x0, 0x3f, 0xa0, 0x0,
    0x6, 0xf1, 0x0, 0xf6, 0x6f, 0xa0, 0x0, 0x9,
    0xf8, 0x0, 0xe, 0xa0, 0x0, 0xfd, 0xfb, 0x0,
    0x0, 0x0, 0xbf, 0xa0, 0x4, 0x10, 0x0, 0xfc,
    0xa0, 0x0, 0x0, 0x0, 0x9, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+73B0 "现" */
    0x6, 0x77, 0x77, 0x75, 0x4d, 0xdd, 0xdd, 0xdd,
    0xd7, 0x0, 0xd, 0xff, 0xff, 0xfa, 0x5f, 0x88,
    0x88, 0x88, 0xf9, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x5f, 0x10, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x5f, 0x10, 0x5a, 0x0, 0xe9, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x5f, 0x10, 0x7e, 0x0,
    0xe9, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x5f, 0x10,
    0x7e, 0x0, 0xe9, 0x0, 0x4, 0x79, 0xf9, 0x72,
    0x5f, 0x10, 0x7e, 0x0, 0xe9, 0x0, 0x9, 0xff,
    0xff, 0xf4, 0x5f, 0x10, 0x7e, 0x0, 0xe9, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x5f, 0x10, 0x8d, 0x0,
    0xe9, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x5f, 0x10,
    0xab, 0x0, 0xe9, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x4d, 0x10, 0xed, 0x60, 0xc7, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0x4, 0xfd, 0xb0, 0x0, 0x0,
    0x0, 0x3, 0xf7, 0x9c, 0x0, 0xc, 0xd9, 0xb0,
    0x1, 0x20, 0x3, 0x7c, 0xff, 0xd8, 0x0, 0x7f,
    0x49, 0xb0, 0x3, 0xf0, 0xf, 0xfb, 0x61, 0x0,
    0x6, 0xf9, 0x9, 0xb0, 0x4, 0xe0, 0x3, 0x0,
    0x0, 0x0, 0x9f, 0xa0, 0x9, 0xc2, 0x29, 0xc0,
    0x0, 0x0, 0x0, 0x1e, 0xf7, 0x0, 0x4, 0xef,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x4, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+73FE "現" */
    0x9, 0x99, 0x99, 0x97, 0x2b, 0xbb, 0xbb, 0xbb,
    0xbb, 0x20, 0xd, 0xde, 0xfe, 0xdb, 0x3f, 0xa9,
    0x99, 0x99, 0xaf, 0x30, 0x0, 0x3, 0xf3, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x3,
    0xf3, 0x0, 0x3f, 0xee, 0xee, 0xee, 0xef, 0x30,
    0x0, 0x3, 0xf3, 0x0, 0x3f, 0x75, 0x55, 0x55,
    0x8f, 0x30, 0x0, 0x14, 0xf4, 0x10, 0x3f, 0x30,
    0x0, 0x0, 0x4f, 0x30, 0xc, 0xff, 0xff, 0xfb,
    0x3f, 0x64, 0x44, 0x44, 0x7f, 0x30, 0x5, 0x79,
    0xf9, 0x75, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x3, 0xf3, 0x0, 0x3f, 0x30, 0x0, 0x0,
    0x4f, 0x30, 0x0, 0x3, 0xf3, 0x0, 0x3f, 0x64,
    0x44, 0x44, 0x7f, 0x30, 0x0, 0x3, 0xf3, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0, 0x3,
    0xf7, 0x9e, 0x10, 0x7f, 0x0, 0xf7, 0x0, 0x0,
    0x1, 0x6b, 0xff, 0xe9, 0x10, 0xad, 0x0, 0xf7,
    0x0, 0x0, 0x4f, 0xfe, 0x94, 0x0, 0x0, 0xf9,
    0x0, 0xf7, 0x0, 0x0, 0x19, 0x40, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0xf7, 0x0, 0x93, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xa0, 0x0, 0xf7, 0x0, 0xd7,
    0x0, 0x0, 0x0, 0x3a, 0xfb, 0x0, 0x0, 0xea,
    0x45, 0xf4, 0x0, 0x0, 0x0, 0xce, 0x70, 0x0,
    0x0, 0x9f, 0xff, 0xc0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7528 "用" */
    0x0, 0x6, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x75, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0xd, 0xa0, 0x0, 0x9, 0xf0,
    0x0, 0x0, 0xad, 0x0, 0xd, 0xa0, 0x0, 0x9,
    0xf0, 0x0, 0x0, 0xad, 0x0, 0xd, 0xa0, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0xad, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0xd,
    0xc7, 0x77, 0x7c, 0xf7, 0x77, 0x77, 0xdd, 0x0,
    0xd, 0xa0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0xad,
    0x0, 0xd, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0xad, 0x0, 0xe, 0x90, 0x0, 0x9, 0xf0, 0x0,
    0x0, 0xad, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0xf, 0xa7, 0x77, 0x7c,
    0xf7, 0x77, 0x77, 0xdd, 0x0, 0x3f, 0x40, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0xad, 0x0, 0x6f, 0x10,
    0x0, 0x9, 0xf0, 0x0, 0x0, 0xad, 0x0, 0xbd,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0xad, 0x2,
    0xf8, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0xad,
    0xb, 0xf1, 0x0, 0x0, 0x9, 0xf0, 0x16, 0x66,
    0xdc, 0x1c, 0x70, 0x0, 0x0, 0x8, 0xe0, 0xf,
    0xff, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+7535 "电" */
    0x0, 0x0, 0x0, 0xd, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x9f, 0x88, 0x88, 0x8f,
    0xc8, 0x88, 0x89, 0xf7, 0x0, 0x9f, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x1, 0xf7, 0x0, 0x9f, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x1, 0xf7, 0x0, 0x9f,
    0x77, 0x77, 0x7f, 0xc7, 0x77, 0x78, 0xf7, 0x0,
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x9f, 0x0, 0x0, 0xf, 0x80, 0x0, 0x1,
    0xf7, 0x0, 0x9f, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x1, 0xf7, 0x0, 0x9f, 0x44, 0x44, 0x4f, 0xa4,
    0x44, 0x45, 0xf7, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x9f, 0x33, 0x33,
    0x3f, 0xa3, 0x33, 0x33, 0x32, 0x20, 0x36, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x3, 0xf4, 0x0,
    0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0x6, 0xf3,
    0x0, 0x0, 0x0, 0xd, 0xf9, 0x88, 0x88, 0x8e,
    0xe0, 0x0, 0x0, 0x0, 0x4, 0xdf, 0xff, 0xff,
    0xfd, 0x40,

    /* U+767B "登" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x0, 0x7,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xf4, 0x8f,
    0x10, 0xbf, 0x30, 0x0, 0x0, 0x33, 0x33, 0x3b,
    0xf1, 0x1e, 0xbd, 0xd2, 0x1, 0x0, 0x0, 0x89,
    0x0, 0x4f, 0x70, 0x5, 0xfc, 0x0, 0x3e, 0x80,
    0x0, 0x3d, 0xd3, 0xec, 0x0, 0x0, 0xaf, 0x45,
    0xfa, 0x0, 0x0, 0x1, 0xcf, 0xf5, 0x33, 0x33,
    0x4e, 0xff, 0x60, 0x0, 0x0, 0x2, 0xee, 0xaf,
    0xff, 0xff, 0xfc, 0xcf, 0x70, 0x0, 0x0, 0x7f,
    0xc1, 0x1, 0x11, 0x11, 0x10, 0xa, 0xfc, 0x30,
    0x1d, 0xf8, 0x44, 0x44, 0x44, 0x44, 0x44, 0x43,
    0x6e, 0xf3, 0x6, 0x20, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x1, 0x40, 0x0, 0x0, 0xda, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0xda, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0xdc, 0x44, 0x44, 0x44, 0x44, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x2, 0xc4,
    0x0, 0x0, 0x2d, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcd, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x3, 0x55, 0x55, 0x9d, 0x55, 0x56, 0xf9, 0x55,
    0x55, 0x40, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0,

    /* U+767C "發" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x75, 0x0, 0x6,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xf3, 0x7e,
    0x1, 0xcd, 0x10, 0x0, 0x0, 0x17, 0x44, 0x4d,
    0xd0, 0xd, 0xbd, 0xa0, 0x6, 0x20, 0x0, 0x6f,
    0x80, 0x8f, 0x30, 0x2, 0xfd, 0x0, 0xaf, 0x50,
    0x0, 0x3, 0xee, 0xf5, 0x0, 0x0, 0x3f, 0xcc,
    0xd2, 0x0, 0x0, 0x5, 0xee, 0x30, 0x0, 0x0,
    0x2, 0xdf, 0x81, 0x0, 0x16, 0xdf, 0xff, 0xee,
    0x50, 0x8f, 0xff, 0xfe, 0xff, 0xa1, 0x1e, 0xa4,
    0x44, 0x4f, 0x50, 0x8c, 0x44, 0xc9, 0x17, 0x80,
    0x0, 0x0, 0x0, 0xf, 0x50, 0xaa, 0x0, 0xb9,
    0x0, 0x0, 0x0, 0x7, 0x77, 0x7f, 0x52, 0xf5,
    0x0, 0xba, 0x0, 0x0, 0x0, 0x2f, 0xcc, 0xcc,
    0x8e, 0xb0, 0x0, 0x7f, 0xff, 0x60, 0x0, 0x4f,
    0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7d, 0x22, 0x23, 0x1b, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x53, 0xa3,
    0x11, 0x2e, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x31, 0x9f, 0x81, 0xbd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x10, 0x2, 0xef, 0xf1, 0x0, 0x0,
    0x0, 0x4, 0x33, 0xbe, 0x2, 0x6d, 0xf9, 0xdd,
    0x40, 0x0, 0x0, 0xc, 0xff, 0xe5, 0x5f, 0xd7,
    0x10, 0x8, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x10, 0x0,

    /* U+7684 "的" */
    0x0, 0x3, 0x81, 0x0, 0x0, 0x19, 0x20, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x27, 0x6f, 0x96, 0x63, 0x1,
    0xfc, 0x77, 0x77, 0x74, 0x6f, 0xff, 0xff, 0xf9,
    0x7, 0xfe, 0xee, 0xee, 0xf9, 0x6f, 0x0, 0x0,
    0xd9, 0xe, 0xa0, 0x0, 0x0, 0xe8, 0x6f, 0x0,
    0x0, 0xd9, 0x8f, 0x20, 0x0, 0x0, 0xe7, 0x6f,
    0x0, 0x0, 0xda, 0xd9, 0x0, 0x0, 0x0, 0xf7,
    0x6f, 0x0, 0x0, 0xd9, 0x0, 0x9a, 0x0, 0x0,
    0xf6, 0x6f, 0xff, 0xff, 0xf9, 0x0, 0x4f, 0x70,
    0x0, 0xf5, 0x6f, 0x44, 0x44, 0xd9, 0x0, 0x8,
    0xf3, 0x1, 0xf5, 0x6f, 0x0, 0x0, 0xd9, 0x0,
    0x0, 0xdd, 0x2, 0xf4, 0x6f, 0x0, 0x0, 0xd9,
    0x0, 0x0, 0x3e, 0x24, 0xf3, 0x6f, 0x0, 0x0,
    0xd9, 0x0, 0x0, 0x0, 0x5, 0xf1, 0x6f, 0x0,
    0x0, 0xd9, 0x0, 0x0, 0x0, 0x7, 0xf0, 0x6f,
    0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x6f, 0x66, 0x66, 0x63, 0x0, 0x5, 0x65, 0x7f,
    0x80, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+78BA "確" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0x40, 0x0, 0x0, 0x8, 0x99, 0x99, 0x95,
    0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0xb, 0xce,
    0xfc, 0xc8, 0xef, 0xff, 0xff, 0xff, 0xff, 0x70,
    0x0, 0xb, 0xb0, 0x0, 0xe9, 0x5a, 0xf7, 0x55,
    0x5f, 0x70, 0x0, 0xe, 0x80, 0x0, 0xe6, 0xd,
    0xc5, 0xb0, 0xe, 0x70, 0x0, 0x1f, 0x50, 0x0,
    0x73, 0x8f, 0x34, 0xf4, 0x6, 0x30, 0x0, 0x5f,
    0x10, 0x0, 0x4, 0xfd, 0x77, 0xfc, 0x77, 0x30,
    0x0, 0xae, 0x66, 0x61, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0xff, 0xff, 0xf9, 0xff, 0xf0,
    0x1, 0xf5, 0x0, 0x0, 0x6, 0xfc, 0x0, 0xf8,
    0xc9, 0xf2, 0x23, 0xf7, 0x22, 0x0, 0xe, 0xfc,
    0x0, 0xf4, 0x7, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x3f, 0xbc, 0x0, 0xf4, 0x7, 0xf0, 0x1, 0xf6,
    0x0, 0x0, 0x4, 0x8c, 0x0, 0xf4, 0x7, 0xf0,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x8c, 0x0, 0xf4,
    0x7, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x8d,
    0x77, 0xf4, 0x7, 0xf3, 0x34, 0xf8, 0x33, 0x10,
    0x0, 0x8f, 0xdd, 0xd4, 0x7, 0xf0, 0x1, 0xf5,
    0x0, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x7, 0xfb,
    0xbb, 0xfc, 0xbb, 0xb0, 0x0, 0x57, 0x0, 0x0,
    0x7, 0xf9, 0x99, 0x99, 0x99, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0, 0x0,

    /* U+79D2 "秒" */
    0x0, 0x0, 0x0, 0x34, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x0, 0x3, 0x6a, 0xef, 0xd0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0xd, 0xfe, 0xfc, 0x30, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x0, 0x20, 0xe, 0x90,
    0x0, 0x14, 0x7, 0xf0, 0x38, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x6, 0xf0, 0x7f, 0x3, 0xf5, 0x0,
    0x33, 0x3f, 0xa3, 0x31, 0x9c, 0x7, 0xf0, 0xb,
    0xc0, 0x4f, 0xff, 0xff, 0xff, 0x6c, 0x90, 0x7f,
    0x0, 0x4f, 0x30, 0x22, 0x6f, 0xb2, 0x22, 0xf5,
    0x7, 0xf0, 0x0, 0xe9, 0x0, 0x9, 0xff, 0x50,
    0x6f, 0x10, 0x7f, 0x0, 0x9, 0xb0, 0x1, 0xff,
    0xcf, 0x37, 0xb0, 0x7, 0xf0, 0x0, 0x0, 0x0,
    0x8c, 0xe9, 0x9e, 0x0, 0x0, 0x7f, 0x0, 0x9d,
    0x0, 0x1f, 0x4e, 0x91, 0x90, 0x0, 0x7, 0xf0,
    0x1f, 0x90, 0xb, 0xd0, 0xe9, 0x0, 0x0, 0x0,
    0x36, 0xa, 0xf2, 0x5, 0xf4, 0xe, 0x90, 0x0,
    0x0, 0x0, 0x7, 0xf7, 0x0, 0x19, 0x0, 0xe9,
    0x0, 0x0, 0x0, 0x7, 0xfb, 0x0, 0x0, 0x0,
    0xe, 0x90, 0x0, 0x0, 0x1b, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xe9, 0x0, 0x2, 0x9f, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x90, 0x7d, 0xff, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe9, 0x5, 0xd7,
    0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+7A0D "稍" */
    0x0, 0x0, 0x3, 0x60, 0x0, 0x0, 0xc, 0x50,
    0x0, 0x0, 0x2, 0x59, 0xdf, 0xe2, 0x1e, 0x50,
    0xf, 0x70, 0x9, 0xd0, 0xa, 0xec, 0xf6, 0x0,
    0x9, 0xe0, 0xf, 0x70, 0x2f, 0x70, 0x0, 0x1,
    0xf4, 0x0, 0x1, 0xf6, 0xf, 0x70, 0xad, 0x0,
    0x0, 0x1, 0xf4, 0x0, 0x0, 0x98, 0xf, 0x71,
    0xe4, 0x0, 0x1, 0x12, 0xf5, 0x10, 0x1, 0x21,
    0x1f, 0x81, 0x22, 0x0, 0x1f, 0xff, 0xff, 0xfb,
    0xe, 0xff, 0xff, 0xff, 0xff, 0x70, 0x5, 0x5b,
    0xf8, 0x53, 0xe, 0xa5, 0x55, 0x55, 0x5f, 0x70,
    0x0, 0xc, 0xfa, 0x0, 0xe, 0x70, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x2f, 0xfe, 0x70, 0xe, 0xa5,
    0x55, 0x55, 0x5f, 0x70, 0x0, 0x9b, 0xf6, 0xf4,
    0xe, 0xff, 0xff, 0xff, 0xff, 0x70, 0x1, 0xf5,
    0xf4, 0x74, 0xe, 0x70, 0x0, 0x0, 0xf, 0x70,
    0xa, 0xc1, 0xf4, 0x0, 0xe, 0x81, 0x11, 0x11,
    0x1f, 0x70, 0x1f, 0x41, 0xf4, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x5, 0x1, 0xf4, 0x0,
    0xe, 0x93, 0x33, 0x33, 0x3f, 0x70, 0x0, 0x1,
    0xf4, 0x0, 0xe, 0x70, 0x0, 0x0, 0xf, 0x70,
    0x0, 0x1, 0xf4, 0x0, 0xe, 0x70, 0x0, 0x35,
    0x5f, 0x60, 0x0, 0x1, 0xf4, 0x0, 0xe, 0x70,
    0x0, 0x7f, 0xfd, 0x20, 0x0, 0x1, 0xf4, 0x0,
    0xe, 0x70, 0x0, 0x0, 0x0, 0x0,

    /* U+7B49 "等" */
    0x0, 0x5, 0xb1, 0x0, 0x0, 0x6, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xe2, 0x22, 0x21, 0xe,
    0xb2, 0x22, 0x22, 0x20, 0x0, 0x7f, 0xff, 0xff,
    0xfe, 0x8f, 0xff, 0xff, 0xff, 0xf1, 0x3, 0xfa,
    0x3f, 0x92, 0x27, 0xf9, 0x2a, 0xf3, 0x22, 0x20,
    0x1e, 0xd0, 0xa, 0xd0, 0xd, 0xe0, 0x0, 0xe9,
    0x0, 0x0, 0x4, 0x10, 0x1, 0x10, 0xa, 0xe0,
    0x0, 0x31, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x5,
    0x55, 0x55, 0x5c, 0xf5, 0x55, 0x55, 0x51, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xdd, 0xdd, 0xdd, 0xdf, 0xfd,
    0xdd, 0xdd, 0xdd, 0xd1, 0x8, 0x88, 0x88, 0x88,
    0x88, 0x88, 0x8d, 0xf8, 0x88, 0x81, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0,
    0x6, 0xee, 0xee, 0xee, 0xee, 0xee, 0xef, 0xfe,
    0xee, 0x80, 0x2, 0x66, 0x6b, 0x86, 0x66, 0x66,
    0x6c, 0xf6, 0x66, 0x30, 0x0, 0x0, 0x2f, 0xe2,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xee, 0x20, 0x0, 0x9, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x90, 0x45,
    0x5c, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xfe, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7B54 "答" */
    0x0, 0x1, 0xc3, 0x0, 0x0, 0x2, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0, 0x8,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xfe, 0x1f, 0xff, 0xff, 0xff, 0xe0, 0x0, 0xbe,
    0x5d, 0xd5, 0x55, 0xaf, 0x69, 0xf9, 0x66, 0x50,
    0x7, 0xf5, 0x5, 0xf3, 0x2, 0xd6, 0x0, 0xcd,
    0x0, 0x0, 0x9, 0xa0, 0x0, 0xc5, 0x8, 0xc0,
    0x0, 0x4b, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf7, 0x6f, 0xb2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xde, 0x40, 0x2, 0xbf, 0xa2,
    0x0, 0x0, 0x0, 0x3, 0xbf, 0xe7, 0x66, 0x66,
    0x6b, 0xef, 0xa4, 0x0, 0x6, 0xcf, 0xa2, 0xee,
    0xee, 0xee, 0xee, 0x35, 0xcf, 0xe3, 0x5, 0x81,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x50,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xcc, 0x55, 0x55, 0x55,
    0x55, 0xbe, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0x0, 0xcd, 0x66, 0x66, 0x66, 0x66, 0xbe,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xcb, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0x0, 0x0,

    /* U+7CFB "系" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0x83,
    0x0, 0x1, 0x23, 0x45, 0x68, 0x9b, 0xdf, 0xff,
    0xfa, 0x0, 0xa, 0xff, 0xff, 0xef, 0xfa, 0x86,
    0x41, 0x0, 0x0, 0x1, 0x22, 0x10, 0xaf, 0x40,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1c, 0xe3,
    0x0, 0x3, 0xec, 0x0, 0x0, 0x0, 0x4, 0xec,
    0x10, 0x1, 0x8f, 0xc2, 0x0, 0x0, 0x0, 0x8f,
    0xfe, 0xef, 0xff, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x48, 0x75, 0x6d, 0xfa, 0x10, 0x38, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xfc, 0x30, 0x0, 0x2e, 0xb0,
    0x0, 0x0, 0x17, 0xed, 0x63, 0x45, 0x67, 0x8b,
    0xfb, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xdc,
    0xba, 0x9f, 0xa0, 0x6, 0x97, 0x53, 0x21, 0x9f,
    0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0x78, 0x0,
    0x9f, 0x0, 0xa7, 0x0, 0x20, 0x0, 0x6, 0xf9,
    0x0, 0x9f, 0x0, 0x7f, 0xa0, 0x0, 0x0, 0x7f,
    0xa0, 0x0, 0x9f, 0x0, 0x5, 0xfc, 0x10, 0x1a,
    0xf9, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x3e, 0xe2,
    0x2c, 0x70, 0x3, 0x66, 0xce, 0x0, 0x0, 0x3,
    0xd4, 0x0, 0x0, 0x2, 0xff, 0xe7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+7D1A "級" */
    0x0, 0x0, 0x77, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf9, 0x0, 0x5b, 0xbb,
    0xbb, 0xbb, 0xa0, 0x0, 0x0, 0x8, 0xf1, 0x0,
    0x5a, 0xef, 0xaa, 0xae, 0xc0, 0x0, 0x0, 0x2f,
    0x70, 0x76, 0x0, 0x9d, 0x0, 0xe, 0x70, 0x0,
    0x0, 0xbc, 0x2, 0xf9, 0x0, 0xac, 0x0, 0x3f,
    0x30, 0x0, 0x6, 0xf2, 0x1b, 0xe0, 0x0, 0xbb,
    0x0, 0x8e, 0x0, 0x0, 0x3f, 0xff, 0xff, 0x40,
    0x0, 0xca, 0x0, 0xcb, 0x12, 0x0, 0x9, 0x66,
    0xf8, 0x10, 0x0, 0xdc, 0x1, 0xff, 0xff, 0x90,
    0x0, 0xd, 0xc0, 0xe6, 0x0, 0xef, 0x11, 0x44,
    0x5f, 0x60, 0x0, 0xbd, 0x10, 0x8c, 0x0, 0xff,
    0x80, 0x0, 0x5f, 0x20, 0xa, 0xfc, 0xce, 0xff,
    0x22, 0xfb, 0xe0, 0x0, 0xbc, 0x0, 0xf, 0xda,
    0x85, 0x2e, 0x65, 0xf2, 0xe7, 0x3, 0xf5, 0x0,
    0x1, 0x0, 0x0, 0x54, 0x8, 0xe0, 0x7f, 0x2b,
    0xd0, 0x0, 0x6, 0xb0, 0xe3, 0xb8, 0xc, 0xb0,
    0xd, 0xef, 0x40, 0x0, 0x9, 0xb0, 0xe5, 0x6d,
    0x1f, 0x60, 0x6, 0xfc, 0x0, 0x0, 0xc, 0x80,
    0xc8, 0x2e, 0x8f, 0x10, 0x4f, 0xdf, 0x80, 0x0,
    0xf, 0x50, 0xa9, 0x0, 0xeb, 0x8, 0xfb, 0x7,
    0xfb, 0x10, 0x3f, 0x10, 0x54, 0x6, 0xf4, 0xdf,
    0x80, 0x0, 0x5f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x50, 0x43, 0x0, 0x0, 0x1, 0x20,

    /* U+7D42 "終" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0x8,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf4, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xb0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x5f, 0x30, 0xc3, 0x5, 0xfb, 0x66, 0x68,
    0xf7, 0x0, 0x0, 0xe9, 0x8, 0xf2, 0x2f, 0xfd,
    0x0, 0xb, 0xe0, 0x0, 0xa, 0xe3, 0x4f, 0x82,
    0xec, 0x1e, 0xa0, 0x7f, 0x40, 0x0, 0x3f, 0xff,
    0xfd, 0x0, 0x71, 0x3, 0xfb, 0xf7, 0x0, 0x0,
    0x5, 0x27, 0xf5, 0x30, 0x0, 0x0, 0xbf, 0xd0,
    0x0, 0x0, 0x0, 0x2f, 0x76, 0xd0, 0x0, 0x1b,
    0xfa, 0xfb, 0x10, 0x0, 0x1, 0xea, 0x2, 0xf3,
    0x7, 0xfe, 0x40, 0x4e, 0xe6, 0x0, 0x1d, 0xfd,
    0xef, 0xf8, 0xcf, 0x91, 0x40, 0x1, 0xbf, 0xd0,
    0xd, 0xa7, 0x42, 0x8a, 0x22, 0x5, 0xfd, 0x50,
    0x4, 0x40, 0x0, 0x0, 0x11, 0x90, 0x0, 0x0,
    0x19, 0xfb, 0x0, 0x0, 0x7, 0xc3, 0xf0, 0xe3,
    0x0, 0x0, 0x0, 0x48, 0x0, 0x0, 0xa, 0xa0,
    0xf2, 0xa9, 0x4, 0xa5, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x70, 0xe4, 0x5e, 0x5, 0xbf, 0xf9, 0x30,
    0x0, 0x0, 0x1f, 0x30, 0xd5, 0x2, 0x0, 0x1,
    0x6d, 0xfc, 0x50, 0x0, 0x2b, 0x0, 0x31, 0x0,
    0x0, 0x0, 0x0, 0x4b, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0,

    /* U+7D44 "組" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x99, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf7, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xa,
    0xe0, 0x0, 0x6, 0xf6, 0x66, 0x66, 0xda, 0x0,
    0x0, 0x3f, 0x50, 0x74, 0x6, 0xf0, 0x0, 0x0,
    0xca, 0x0, 0x0, 0xdb, 0x2, 0xf9, 0x6, 0xf0,
    0x0, 0x0, 0xca, 0x0, 0x9, 0xe1, 0xb, 0xe0,
    0x6, 0xf0, 0x0, 0x0, 0xca, 0x0, 0x3f, 0xed,
    0xef, 0x40, 0x6, 0xf7, 0x77, 0x77, 0xda, 0x0,
    0xb, 0x99, 0xf8, 0x0, 0x6, 0xfe, 0xee, 0xee,
    0xfa, 0x0, 0x0, 0x1d, 0xc0, 0xc6, 0x6, 0xf0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0xbd, 0x10, 0x8c,
    0x6, 0xf0, 0x0, 0x0, 0xca, 0x0, 0x1b, 0xfa,
    0xac, 0xef, 0x16, 0xf0, 0x0, 0x0, 0xca, 0x0,
    0xf, 0xec, 0x97, 0x4e, 0x66, 0xf6, 0x66, 0x66,
    0xda, 0x0, 0x1, 0x0, 0x0, 0x26, 0x6, 0xff,
    0xff, 0xff, 0xfa, 0x0, 0x6, 0x90, 0xc3, 0xaa,
    0x6, 0xf0, 0x0, 0x0, 0xca, 0x0, 0x9, 0xa0,
    0xd6, 0x5f, 0x6, 0xf0, 0x0, 0x0, 0xca, 0x0,
    0xc, 0x70, 0xb9, 0x1f, 0x36, 0xf0, 0x0, 0x0,
    0xca, 0x0, 0xf, 0x40, 0x9a, 0x5, 0x16, 0xf0,
    0x0, 0x0, 0xca, 0x0, 0x3e, 0x0, 0x67, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+7D61 "絡" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa8, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf6, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xd0, 0x0, 0x0, 0x4f, 0xfe, 0xee, 0xfb, 0x0,
    0x0, 0x3f, 0x40, 0xb3, 0x1, 0xed, 0x66, 0x67,
    0xfa, 0x0, 0x0, 0xda, 0x7, 0xf3, 0x1d, 0xff,
    0x20, 0x8, 0xf2, 0x0, 0x9, 0xe3, 0x4f, 0x90,
    0xdf, 0x3c, 0xc0, 0x3f, 0x70, 0x0, 0x2f, 0xff,
    0xfe, 0x0, 0x63, 0x2, 0xfa, 0xeb, 0x0, 0x0,
    0x5, 0x27, 0xf5, 0x30, 0x0, 0x0, 0x6f, 0xf1,
    0x0, 0x0, 0x0, 0x2f, 0x76, 0xe0, 0x0, 0x5,
    0xfd, 0xfb, 0x10, 0x0, 0x1, 0xda, 0x2, 0xf3,
    0x1, 0xaf, 0xb0, 0x4e, 0xe6, 0x0, 0x1d, 0xfd,
    0xef, 0xf8, 0x8f, 0xe6, 0x0, 0x2, 0xbf, 0xd0,
    0xd, 0xa7, 0x41, 0x8b, 0x4c, 0xff, 0xff, 0xff,
    0xfe, 0x30, 0x0, 0x0, 0x10, 0x90, 0x7, 0xf6,
    0x66, 0x66, 0xcc, 0x0, 0x7, 0xc1, 0xf1, 0xe5,
    0x7, 0xf0, 0x0, 0x0, 0xac, 0x0, 0x9, 0xb0,
    0xf3, 0x99, 0x7, 0xf0, 0x0, 0x0, 0xac, 0x0,
    0xc, 0x80, 0xd6, 0x5d, 0x7, 0xf0, 0x0, 0x0,
    0xac, 0x0, 0xf, 0x50, 0xb7, 0x19, 0x7, 0xf6,
    0x66, 0x66, 0xcc, 0x0, 0x3f, 0x20, 0x74, 0x0,
    0x7, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x3, 0x0,
    0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0xac, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+7D71 "統" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc7, 0x0, 0x0, 0x2,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xc0, 0x0, 0x55, 0x55, 0xbf, 0x65, 0x55, 0x30,
    0x0, 0x5f, 0x30, 0xa3, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0xe9, 0x6, 0xf3, 0x0, 0xa,
    0xf1, 0x2, 0x0, 0x0, 0xa, 0xe3, 0x4f, 0x90,
    0x0, 0x5f, 0x60, 0x1e, 0x80, 0x0, 0x3f, 0xff,
    0xfe, 0x0, 0x1, 0xeb, 0x0, 0x5, 0xf3, 0x0,
    0x6, 0x37, 0xf5, 0x40, 0x3d, 0xf8, 0x89, 0xbc,
    0xfd, 0x0, 0x0, 0x2f, 0x83, 0xf2, 0x9f, 0xfd,
    0xca, 0x97, 0x6f, 0x70, 0x1, 0xdb, 0x0, 0xe7,
    0x21, 0x22, 0x0, 0x31, 0x6, 0x40, 0x1d, 0xfc,
    0xdf, 0xfc, 0x0, 0xbb, 0x0, 0xf5, 0x0, 0x0,
    0xe, 0xb8, 0x63, 0x5e, 0x0, 0xca, 0x0, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x60, 0x0, 0xd9,
    0x0, 0xf5, 0x0, 0x0, 0x7, 0xb4, 0xd2, 0xf0,
    0x0, 0xf6, 0x0, 0xf5, 0x0, 0x0, 0x9, 0x92,
    0xf0, 0xd4, 0x5, 0xf3, 0x0, 0xf5, 0x3, 0xb0,
    0xc, 0x60, 0xf2, 0x97, 0xd, 0xd0, 0x0, 0xf5,
    0x4, 0xf0, 0xf, 0x30, 0xe3, 0x1, 0xbf, 0x40,
    0x0, 0xf9, 0x59, 0xd0, 0x3d, 0x0, 0x61, 0xe,
    0xf5, 0x0, 0x0, 0xaf, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x4, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7D9A "続" */
    0x0, 0x1, 0x91, 0x0, 0x0, 0x0, 0xd, 0x40,
    0x0, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x0,
    0x1f, 0x60, 0x0, 0x0, 0x0, 0xe, 0x80, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x6f,
    0x10, 0x81, 0x34, 0x44, 0x5f, 0x94, 0x44, 0x40,
    0x0, 0xe8, 0x7, 0xf1, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x0, 0x8, 0xd0, 0x2e, 0x80, 0xf, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x3f, 0xff, 0xfd, 0x0,
    0x5, 0x55, 0x55, 0x55, 0x55, 0x10, 0x9, 0x68,
    0xf3, 0x0, 0x34, 0x44, 0x44, 0x44, 0x44, 0x30,
    0x0, 0xe, 0x86, 0x90, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0xac, 0x3, 0xf1, 0xe6, 0x0,
    0x0, 0x0, 0x6, 0xe0, 0x9, 0xfd, 0xef, 0xf6,
    0xe6, 0xf, 0x50, 0x6e, 0x6, 0xe0, 0x1f, 0xc9,
    0x52, 0x99, 0x42, 0xf, 0x50, 0x7e, 0x2, 0x40,
    0x1, 0x0, 0x0, 0x60, 0x0, 0x1f, 0x40, 0x7e,
    0x0, 0x0, 0x4, 0xb3, 0xe0, 0xf2, 0x0, 0x5f,
    0x20, 0x7e, 0x0, 0x0, 0x7, 0xa1, 0xf1, 0xa8,
    0x0, 0xbd, 0x0, 0x7e, 0x0, 0x40, 0xa, 0x60,
    0xf4, 0x4d, 0x6, 0xf5, 0x0, 0x7e, 0x0, 0xd6,
    0xe, 0x20, 0xd5, 0x3, 0x6f, 0x90, 0x0, 0x6f,
    0x45, 0xf4, 0x19, 0x0, 0x20, 0x5, 0xf8, 0x0,
    0x0, 0x2e, 0xff, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7DB2 "網" */
    0x0, 0x0, 0x86, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x60, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x0, 0x9, 0xd0, 0x0, 0x7f,
    0x66, 0x66, 0x66, 0x6c, 0xc0, 0x2, 0xf5, 0x9,
    0x27, 0xe0, 0xd1, 0x2, 0xb0, 0xac, 0x0, 0xbb,
    0x5, 0xf4, 0x7e, 0xa, 0x60, 0x6b, 0xa, 0xc0,
    0x6f, 0x20, 0xda, 0x7, 0xe0, 0x5b, 0xb, 0x60,
    0xac, 0x1f, 0xed, 0xff, 0x10, 0x7e, 0x47, 0x95,
    0xf6, 0x4a, 0xc0, 0xb9, 0xaf, 0x50, 0x7, 0xea,
    0xdd, 0xed, 0xda, 0xac, 0x0, 0xd, 0xa2, 0xd0,
    0x7e, 0x0, 0x7d, 0x0, 0xa, 0xc0, 0xa, 0xd0,
    0xe, 0x57, 0xe2, 0x45, 0xf5, 0x42, 0xac, 0x8,
    0xfb, 0xbd, 0xfa, 0x7e, 0x9f, 0xfe, 0xee, 0x6a,
    0xc0, 0xef, 0xc9, 0x68, 0xe7, 0xe0, 0xe5, 0x0,
    0x0, 0xac, 0x2, 0x0, 0x0, 0x45, 0x7e, 0xe,
    0x50, 0x0, 0xa, 0xc0, 0x48, 0x3a, 0x4e, 0x7,
    0xe0, 0xe7, 0x33, 0x31, 0xac, 0x7, 0xb2, 0xf0,
    0xf3, 0x7e, 0xe, 0xff, 0xff, 0x6a, 0xc0, 0xa9,
    0x1f, 0x1b, 0x87, 0xe0, 0x0, 0x0, 0x0, 0xac,
    0xd, 0x60, 0xf3, 0x79, 0x7e, 0x0, 0x0, 0x0,
    0xa, 0xc1, 0xf3, 0xe, 0x40, 0x7, 0xe0, 0x0,
    0x0, 0x44, 0xcc, 0x18, 0x0, 0x10, 0x0, 0x7e,
    0x0, 0x0, 0xb, 0xfe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7EA7 "级" */
    0x0, 0x0, 0x66, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdb, 0x0, 0x88, 0x88,
    0x88, 0x88, 0x50, 0x0, 0x0, 0x5, 0xf3, 0x0,
    0xee, 0xff, 0xee, 0xef, 0x80, 0x0, 0x0, 0xd,
    0xb0, 0x0, 0x0, 0xcb, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0x5f, 0x30, 0x41, 0x0, 0xda, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0xe9, 0x1, 0xf9, 0x0, 0xe9,
    0x0, 0xcb, 0x0, 0x0, 0xa, 0xe4, 0x5b, 0xe1,
    0x0, 0xf8, 0x1, 0xf7, 0x1, 0x0, 0x3f, 0xff,
    0xff, 0x50, 0x1, 0xfa, 0x6, 0xff, 0xff, 0x50,
    0x6, 0x32, 0xea, 0x0, 0x3, 0xff, 0x2, 0x44,
    0x8f, 0x30, 0x0, 0xb, 0xe1, 0x0, 0x5, 0xff,
    0x60, 0x0, 0x9e, 0x0, 0x0, 0x8f, 0x56, 0xa8,
    0x7, 0xf9, 0xd0, 0x0, 0xe9, 0x0, 0x6, 0xff,
    0xfe, 0xa3, 0xa, 0xc2, 0xf6, 0x7, 0xf2, 0x0,
    0x1f, 0xe8, 0x30, 0x0, 0xe, 0x90, 0x9e, 0x2e,
    0xa0, 0x0, 0x3, 0x0, 0x0, 0x25, 0x3f, 0x50,
    0x1e, 0xff, 0x10, 0x0, 0x0, 0x1, 0x6c, 0xfc,
    0x8f, 0x0, 0xa, 0xfa, 0x0, 0x0, 0x5, 0xbf,
    0xfb, 0x41, 0xea, 0x0, 0x8f, 0xcf, 0x90, 0x0,
    0xf, 0xd7, 0x10, 0x8, 0xf3, 0x1b, 0xf8, 0x8,
    0xfb, 0x10, 0x2, 0x0, 0x0, 0x2f, 0xa3, 0xff,
    0x50, 0x0, 0x6f, 0xe1, 0x0, 0x0, 0x0, 0x5,
    0x10, 0x61, 0x0, 0x0, 0x2, 0x40,

    /* U+7EC4 "组" */
    0x0, 0x0, 0x3b, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xae, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xf6, 0x0, 0x0, 0x2, 0xf6, 0x0,
    0x7, 0xf6, 0x66, 0x67, 0xf6, 0x0, 0x0, 0xa,
    0xd0, 0x0, 0x7, 0xf0, 0x0, 0x1, 0xf6, 0x0,
    0x0, 0x3f, 0x40, 0x27, 0x7, 0xf0, 0x0, 0x1,
    0xf6, 0x0, 0x0, 0xda, 0x0, 0xbd, 0x7, 0xf0,
    0x0, 0x1, 0xf6, 0x0, 0x9, 0xf7, 0x7a, 0xf3,
    0x7, 0xfe, 0xee, 0xef, 0xf6, 0x0, 0x1f, 0xfe,
    0xdf, 0x80, 0x7, 0xf7, 0x77, 0x78, 0xf6, 0x0,
    0x3, 0x10, 0xcc, 0x0, 0x7, 0xf0, 0x0, 0x1,
    0xf6, 0x0, 0x0, 0x9, 0xe1, 0x0, 0x7, 0xf0,
    0x0, 0x1, 0xf6, 0x0, 0x0, 0x7f, 0x30, 0x14,
    0x7, 0xf0, 0x0, 0x1, 0xf6, 0x0, 0x8, 0xfd,
    0xbe, 0xfe, 0x7, 0xf6, 0x66, 0x67, 0xf6, 0x0,
    0xd, 0xfd, 0x96, 0x20, 0x7, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x3, 0x10, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x46,
    0x7, 0xf0, 0x0, 0x1, 0xf6, 0x0, 0x1, 0x59,
    0xcf, 0xfc, 0x7, 0xf0, 0x0, 0x1, 0xf6, 0x0,
    0xf, 0xfe, 0xa5, 0x10, 0x7, 0xf0, 0x0, 0x1,
    0xf6, 0x0, 0x5, 0x20, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2,

    /* U+7EDC "络" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x40, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x0,
    0x7f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xd0, 0x0, 0xe,
    0xa0, 0x0, 0xa, 0xf6, 0x66, 0x66, 0xfb, 0x0,
    0x7, 0xf2, 0x5, 0x7, 0xff, 0x60, 0x0, 0x8f,
    0x20, 0x2, 0xf8, 0x3, 0xfd, 0xf9, 0x7f, 0x30,
    0x5f, 0x70, 0x0, 0xce, 0x56, 0xde, 0x29, 0x0,
    0xae, 0x8f, 0x90, 0x0, 0x3f, 0xff, 0xff, 0x40,
    0x0, 0x1, 0xff, 0xc0, 0x0, 0x0, 0x52, 0x3f,
    0x90, 0x0, 0x6, 0xef, 0xaf, 0xb3, 0x0, 0x0,
    0xd, 0xc0, 0x2, 0x8e, 0xfa, 0x10, 0x4d, 0xfc,
    0x60, 0xa, 0xe3, 0x48, 0x6f, 0xa3, 0x0, 0x0,
    0x5, 0xc9, 0xa, 0xff, 0xff, 0xd2, 0x1c, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0xfd, 0x95, 0x10, 0x0,
    0xcc, 0x66, 0x66, 0x6e, 0x90, 0x2, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0xe9, 0x0, 0x0,
    0x1, 0x59, 0x70, 0xc9, 0x0, 0x0, 0xe, 0x90,
    0x4, 0x8c, 0xff, 0xc5, 0xc, 0x90, 0x0, 0x0,
    0xe9, 0x2, 0xff, 0xa6, 0x10, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0x90, 0x4, 0x0, 0x0, 0x0, 0xc,
    0xc6, 0x66, 0x66, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7EDF "统" */
    0x0, 0x0, 0x53, 0x0, 0x0, 0x0, 0x73, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xed, 0x0, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf6, 0x0,
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0xd,
    0xd0, 0x0, 0xab, 0xbb, 0xbe, 0xbb, 0xbb, 0x90,
    0x0, 0x6f, 0x50, 0x30, 0xaa, 0xad, 0xfc, 0xaa,
    0xaa, 0x90, 0x0, 0xeb, 0x2, 0xf8, 0x0, 0xd,
    0xd0, 0x5, 0x10, 0x0, 0xa, 0xf5, 0x5c, 0xe1,
    0x0, 0xaf, 0x20, 0xd, 0xb0, 0x0, 0x4f, 0xff,
    0xff, 0x60, 0x6, 0xf6, 0x0, 0x15, 0xf7, 0x0,
    0x6, 0x21, 0xeb, 0x1, 0x8f, 0xfd, 0xef, 0xff,
    0xff, 0x30, 0x0, 0xb, 0xe1, 0x1, 0xe9, 0xa8,
    0x43, 0x51, 0xd, 0x90, 0x0, 0x8f, 0x66, 0x92,
    0x0, 0xd9, 0x1, 0xf5, 0x1, 0x0, 0x8, 0xff,
    0xff, 0xc2, 0x0, 0xe8, 0x1, 0xf5, 0x0, 0x0,
    0x1f, 0xb7, 0x30, 0x0, 0x0, 0xf6, 0x1, 0xf5,
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x1, 0x5a, 0xe5,
    0x9, 0xf0, 0x1, 0xf5, 0x3, 0xb0, 0x17, 0xcf,
    0xfc, 0x71, 0x4f, 0x80, 0x1, 0xf5, 0x4, 0xf0,
    0x1f, 0xc7, 0x10, 0x7, 0xfd, 0x0, 0x1, 0xf9,
    0x5a, 0xd0, 0x1, 0x0, 0x0, 0x6f, 0xa1, 0x0,
    0x0, 0xbf, 0xff, 0x60, 0x0, 0x0, 0x0, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7F51 "网" */
    0x7, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x83, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x1f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x1f, 0x70, 0x0, 0x8, 0x40,
    0x0, 0x18, 0x10, 0xf8, 0x1f, 0x71, 0x0, 0xf,
    0x61, 0x0, 0x3f, 0x20, 0xf8, 0x1f, 0x7b, 0xb0,
    0x2f, 0x4e, 0x70, 0x6f, 0x0, 0xf8, 0x1f, 0x72,
    0xf7, 0x6f, 0x5, 0xf3, 0xab, 0x0, 0xf8, 0x1f,
    0x70, 0x6f, 0xcc, 0x0, 0xae, 0xe7, 0x0, 0xf8,
    0x1f, 0x70, 0xa, 0xf7, 0x0, 0x1e, 0xf3, 0x0,
    0xf8, 0x1f, 0x70, 0x4, 0xf9, 0x0, 0x8, 0xf4,
    0x0, 0xf8, 0x1f, 0x70, 0xa, 0xef, 0x40, 0xe,
    0xfd, 0x0, 0xf8, 0x1f, 0x70, 0x2f, 0x6a, 0xd0,
    0x6f, 0x4f, 0x70, 0xf8, 0x1f, 0x70, 0xbd, 0x1,
    0xd2, 0xea, 0x8, 0xe0, 0xf8, 0x1f, 0x76, 0xf4,
    0x0, 0xa, 0xf2, 0x1, 0x80, 0xf8, 0x1f, 0x9f,
    0x90, 0x0, 0x7f, 0x60, 0x0, 0x0, 0xf8, 0x1f,
    0x73, 0x0, 0x0, 0x16, 0x0, 0x0, 0x0, 0xf8,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x37, 0x78,
    0xf7, 0x1f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xfe, 0xb1,

    /* U+8046 "聆" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x40,
    0x0, 0x0, 0xa, 0xbb, 0xbb, 0xbb, 0x90, 0x0,
    0x1f, 0x90, 0x0, 0x0, 0x9, 0xed, 0xaa, 0xfd,
    0x80, 0x0, 0x9f, 0xe0, 0x0, 0x0, 0x0, 0xc9,
    0x0, 0xd8, 0x0, 0x3, 0xf7, 0xda, 0x0, 0x0,
    0x0, 0xc9, 0x0, 0xd8, 0x0, 0x1e, 0xc0, 0x3f,
    0x70, 0x0, 0x0, 0xcf, 0xff, 0xf8, 0x0, 0xce,
    0x21, 0x7, 0xf7, 0x0, 0x0, 0xcb, 0x44, 0xd8,
    0x1c, 0xf3, 0x8e, 0x10, 0x9f, 0x80, 0x0, 0xc9,
    0x0, 0xd8, 0x9f, 0x40, 0xc, 0xc0, 0x9, 0xf2,
    0x0, 0xc9, 0x0, 0xd8, 0x2, 0x0, 0x2, 0xb1,
    0x0, 0x20, 0x0, 0xcc, 0x88, 0xe8, 0x0, 0x56,
    0x66, 0x66, 0x63, 0x0, 0x0, 0xce, 0xbb, 0xf8,
    0x0, 0xef, 0xff, 0xff, 0xfd, 0x0, 0x0, 0xc9,
    0x0, 0xd8, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0xc9, 0x0, 0xd8, 0x0, 0x0, 0x0, 0xd,
    0xb0, 0x0, 0x0, 0xc9, 0x25, 0xed, 0x90, 0x2,
    0x0, 0x8f, 0x20, 0x0, 0xb, 0xff, 0xff, 0xfd,
    0x60, 0x3f, 0x93, 0xf8, 0x0, 0x0, 0xb, 0x96,
    0x30, 0xd8, 0x0, 0x4, 0xff, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd8, 0x0, 0x0, 0x3f, 0xc1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd8, 0x0, 0x0,
    0x3, 0xec, 0x10, 0x0, 0x0, 0x0, 0x0, 0xd8,
    0x0, 0x0, 0x0, 0x3b, 0x10, 0x0,

    /* U+807D "聽" */
    0x2, 0x22, 0x22, 0x22, 0x20, 0x0, 0xc, 0x60,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xe4, 0x44,
    0x4f, 0x84, 0x44, 0x30, 0x1, 0xba, 0x11, 0xbb,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0xba,
    0x11, 0xbb, 0x2, 0x22, 0x6f, 0x32, 0x22, 0x20,
    0x0, 0xbf, 0xff, 0xfb, 0x3, 0x44, 0x8e, 0x44,
    0x44, 0x10, 0x0, 0xba, 0x0, 0xab, 0xc, 0xdc,
    0xfc, 0xde, 0xcf, 0x60, 0x0, 0xbf, 0xff, 0xfb,
    0xc, 0x60, 0xe0, 0x78, 0xd, 0x60, 0x0, 0xbb,
    0x11, 0xbb, 0xc, 0x60, 0xe0, 0x78, 0xd, 0x60,
    0x0, 0xba, 0x1, 0xbb, 0xc, 0xed, 0xfd, 0xee,
    0xdf, 0x60, 0xc, 0xff, 0xff, 0xfb, 0x5, 0x66,
    0x66, 0x66, 0x66, 0x20, 0x3, 0x31, 0x0, 0xab,
    0x49, 0x99, 0x99, 0x99, 0x99, 0x90, 0xc, 0xff,
    0xfd, 0xab, 0x4a, 0xaa, 0xaa, 0xaa, 0xaa, 0xa0,
    0x0, 0x1d, 0x50, 0xab, 0x0, 0x0, 0xb9, 0x0,
    0x0, 0x0, 0x1, 0x2e, 0x61, 0xab, 0x1, 0xb,
    0x6f, 0x50, 0xa8, 0x0, 0x7, 0xef, 0xf9, 0xab,
    0xc, 0x7f, 0x47, 0xe0, 0x1f, 0x30, 0x0, 0xd,
    0x40, 0xab, 0x3f, 0x1f, 0x40, 0x91, 0x37, 0xc0,
    0x7, 0x9f, 0xdd, 0xab, 0xc8, 0xf, 0x73, 0x35,
    0xf1, 0xf2, 0x4, 0x43, 0x10, 0xab, 0x30, 0xa,
    0xff, 0xff, 0x90, 0x10, 0x0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+80FD "能" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xe6, 0x0, 0x0, 0xe, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x25, 0x90, 0x0,
    0xe9, 0x0, 0x2, 0x30, 0x0, 0x3f, 0x70, 0x3f,
    0x60, 0xe, 0x90, 0x5b, 0xfe, 0x10, 0x1d, 0xc0,
    0x0, 0x9f, 0x10, 0xee, 0xef, 0xa5, 0x0, 0xa,
    0xfe, 0xef, 0xff, 0xf9, 0xe, 0xc4, 0x0, 0x0,
    0x0, 0x49, 0x76, 0x43, 0x18, 0xd0, 0xe9, 0x0,
    0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x90, 0x0, 0x3, 0xf2, 0xb, 0xbb, 0xbb, 0xbb,
    0x10, 0xdc, 0x66, 0x66, 0xaf, 0x0, 0xfc, 0x99,
    0x9c, 0xf2, 0x5, 0xef, 0xff, 0xfe, 0x60, 0xf,
    0x60, 0x0, 0x5f, 0x20, 0x84, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xee, 0xef, 0xf2, 0xe, 0x90, 0x0,
    0x16, 0x0, 0xf, 0x94, 0x44, 0x8f, 0x20, 0xe9,
    0x2, 0x9f, 0xf3, 0x0, 0xf6, 0x0, 0x5, 0xf2,
    0xe, 0xcc, 0xfd, 0x71, 0x0, 0xf, 0xfe, 0xee,
    0xff, 0x20, 0xed, 0x72, 0x0, 0x0, 0x0, 0xf9,
    0x44, 0x48, 0xf2, 0xe, 0x90, 0x0, 0x0, 0x81,
    0xf, 0x60, 0x0, 0x5f, 0x20, 0xe9, 0x0, 0x0,
    0x1f, 0x50, 0xf6, 0x0, 0x5, 0xf2, 0xe, 0xc5,
    0x55, 0x59, 0xf2, 0xf, 0x60, 0x34, 0x8f, 0x20,
    0x6e, 0xff, 0xff, 0xf9, 0x0, 0xf6, 0x6, 0xff,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+884C "行" */
    0x0, 0x0, 0x8, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x7, 0x77,
    0x77, 0x77, 0x77, 0x50, 0x0, 0xb, 0xf5, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x1, 0xcf,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xe3, 0x0, 0x61, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0x10, 0x9, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x80,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x0, 0x3,
    0xfc, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x3f, 0xf5, 0x0, 0x22, 0x22, 0x22, 0x5f,
    0x62, 0x20, 0x4, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x50, 0x0, 0x3f, 0xe5, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x9, 0x22,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0,
    0x0, 0x2, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x50, 0x0, 0x0, 0x2, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x50, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x0, 0x2,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x50, 0x0,
    0x0, 0x2, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x50, 0x0, 0x0, 0x2, 0xf5, 0x0, 0x0, 0x5,
    0x66, 0x9f, 0x40, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0x0, 0x8, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+898B "見" */
    0x0, 0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x4, 0xf5, 0x33,
    0x33, 0x33, 0x33, 0x4f, 0x70, 0x0, 0x0, 0x4,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x0, 0x4, 0xfe, 0xee, 0xee, 0xee, 0xee, 0xef,
    0x70, 0x0, 0x0, 0x4, 0xf7, 0x55, 0x55, 0x55,
    0x55, 0x6f, 0x70, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x4,
    0xf6, 0x55, 0x55, 0x55, 0x55, 0x6f, 0x70, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x70, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x70, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0, 0x4,
    0xfd, 0xcc, 0xcc, 0xcc, 0xcc, 0xdf, 0x70, 0x0,
    0x0, 0x2, 0x88, 0xdf, 0x88, 0x8d, 0xf8, 0x88,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x0, 0x9,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf7,
    0x0, 0x9, 0xe0, 0x0, 0x2, 0x91, 0x0, 0x0,
    0x6f, 0xd0, 0x0, 0x9, 0xe0, 0x0, 0x4, 0xf2,
    0x4, 0x8e, 0xfc, 0x10, 0x0, 0x9, 0xf7, 0x66,
    0x6b, 0xf0, 0xb, 0xfb, 0x40, 0x0, 0x0, 0x3,
    0xdf, 0xff, 0xff, 0x70, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+89BD "覽" */
    0x0, 0x22, 0x22, 0x22, 0x21, 0x3, 0xb0, 0x0,
    0x0, 0x0, 0x5f, 0xcc, 0xdf, 0xcc, 0x90, 0xcf,
    0xbb, 0xbb, 0xb7, 0x5, 0xf5, 0x58, 0xf5, 0x51,
    0x8f, 0x6b, 0xf6, 0x55, 0x30, 0x5f, 0x99, 0x99,
    0xaf, 0x6f, 0x60, 0x1c, 0xe1, 0x0, 0x5, 0xf1,
    0x11, 0x12, 0xf3, 0x49, 0x99, 0xaf, 0xa9, 0x10,
    0x5f, 0xcc, 0xdf, 0xcc, 0x23, 0xf5, 0xe5, 0xe5,
    0xf3, 0x5, 0xf0, 0x5, 0xe0, 0x0, 0x3e, 0xe,
    0xd, 0xe, 0x30, 0x4e, 0xee, 0xee, 0xee, 0xd2,
    0xed, 0xed, 0xed, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xee, 0xee, 0xee, 0xee, 0xef, 0xf0, 0x0, 0x0,
    0x3, 0xf8, 0x55, 0x55, 0x55, 0x55, 0x9f, 0x0,
    0x0, 0x0, 0x3f, 0x97, 0x77, 0x77, 0x77, 0x7a,
    0xf0, 0x0, 0x0, 0x3, 0xfd, 0xcc, 0xcc, 0xcc,
    0xcc, 0xdf, 0x0, 0x0, 0x0, 0x3f, 0x62, 0x22,
    0x22, 0x22, 0x27, 0xf0, 0x0, 0x0, 0x3, 0xfe,
    0xee, 0xee, 0xee, 0xee, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf1, 0x0, 0xba, 0x0, 0x0, 0x58,
    0x0, 0x13, 0x7d, 0xf4, 0x0, 0xb, 0xc3, 0x33,
    0x3a, 0xc0, 0xef, 0xfc, 0x81, 0x0, 0x0, 0x5e,
    0xff, 0xff, 0xf5, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+89C8 "览" */
    0x0, 0x0, 0x3, 0x90, 0x0, 0x2b, 0x20, 0x0,
    0x0, 0x6, 0xa0, 0x5, 0xf1, 0x0, 0x7f, 0x0,
    0x0, 0x0, 0x8, 0xe0, 0x5, 0xf1, 0x0, 0xcf,
    0xcc, 0xcc, 0xca, 0x8, 0xe0, 0x5, 0xf1, 0x3,
    0xfa, 0x99, 0x99, 0x97, 0x8, 0xe0, 0x5, 0xf1,
    0xb, 0xe0, 0x8d, 0x10, 0x0, 0x8, 0xe0, 0x5,
    0xf1, 0x4f, 0x60, 0x1d, 0xd0, 0x0, 0x8, 0xe0,
    0x5, 0xf1, 0x4a, 0x0, 0x2, 0xfa, 0x0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x44, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0xe, 0xb6, 0x66, 0x66, 0x66, 0x66,
    0xf8, 0x0, 0x0, 0xe, 0x90, 0x0, 0x7a, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xe, 0x90, 0x0, 0xae,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xe, 0x90, 0x0,
    0xbd, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xe, 0x90,
    0x1, 0xfd, 0xd3, 0x0, 0xf8, 0x0, 0x0, 0x6,
    0x30, 0x1c, 0xf5, 0xf4, 0x0, 0x42, 0x0, 0x0,
    0x0, 0x6, 0xee, 0x43, 0xf4, 0x0, 0x0, 0x7b,
    0x1, 0x5a, 0xff, 0x91, 0x3, 0xf8, 0x44, 0x44,
    0xcb, 0x2f, 0xfc, 0x71, 0x0, 0x0, 0xbf, 0xff,
    0xff, 0xe4, 0x2, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+8A0A "訊" */
    0x0, 0x7, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xe1, 0x0, 0x6a, 0xaa,
    0xaa, 0xaa, 0xb3, 0x0, 0x0, 0x0, 0xe7, 0x0,
    0x7d, 0xdf, 0xed, 0xdd, 0xf5, 0x0, 0x4, 0x44,
    0x85, 0x44, 0x0, 0x2f, 0x40, 0x2, 0xf5, 0x0,
    0xf, 0xff, 0xff, 0xff, 0x20, 0x2f, 0x40, 0x2,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x40, 0x2, 0xf5, 0x0, 0x3, 0xff, 0xff, 0xf6,
    0x0, 0x2f, 0x40, 0x2, 0xf5, 0x0, 0x1, 0x44,
    0x44, 0x41, 0x0, 0x2f, 0x40, 0x2, 0xf5, 0x0,
    0x0, 0x22, 0x22, 0x20, 0x34, 0x6f, 0x74, 0x41,
    0xf5, 0x0, 0x4, 0xff, 0xff, 0xf7, 0xdf, 0xff,
    0xff, 0xf1, 0xf5, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x12, 0x4f, 0x62, 0x11, 0xf5, 0x0, 0x1, 0x54,
    0x44, 0x42, 0x0, 0x2f, 0x40, 0x0, 0xf6, 0x0,
    0x4, 0xff, 0xff, 0xf7, 0x0, 0x2f, 0x40, 0x0,
    0xf6, 0x0, 0x4, 0xf0, 0x0, 0xc7, 0x0, 0x2f,
    0x40, 0x0, 0xe7, 0x0, 0x4, 0xf0, 0x0, 0xc7,
    0x0, 0x2f, 0x40, 0x0, 0xc9, 0x31, 0x4, 0xf0,
    0x0, 0xc7, 0x0, 0x2f, 0x40, 0x0, 0xac, 0x68,
    0x4, 0xff, 0xff, 0xf7, 0x0, 0x2f, 0x40, 0x0,
    0x6f, 0xb6, 0x4, 0xf4, 0x44, 0x42, 0x0, 0x2f,
    0x40, 0x0, 0x1e, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x40, 0x0, 0x1, 0x30,

    /* U+8A2A "訪" */
    0x0, 0x6, 0x30, 0x0, 0x0, 0x0, 0x26, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x4, 0x44,
    0x84, 0x44, 0x13, 0x33, 0x3b, 0xc3, 0x33, 0x30,
    0xf, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2b,
    0xc2, 0x22, 0x22, 0x20, 0x4, 0xff, 0xff, 0xf4,
    0x0, 0xb, 0xb0, 0x0, 0x0, 0x0, 0x1, 0x44,
    0x44, 0x41, 0x0, 0xc, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x22, 0x22, 0x20, 0x0, 0xd, 0xff, 0xff,
    0xff, 0x0, 0x4, 0xff, 0xff, 0xf4, 0x0, 0xe,
    0xc9, 0x99, 0xcf, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x0, 0xf, 0x60, 0x0, 0x7f, 0x0, 0x1, 0x54,
    0x44, 0x41, 0x0, 0x3f, 0x30, 0x0, 0x8e, 0x0,
    0x4, 0xff, 0xff, 0xf4, 0x0, 0x7f, 0x0, 0x0,
    0x8d, 0x0, 0x4, 0xe0, 0x0, 0xf4, 0x0, 0xdc,
    0x0, 0x0, 0xac, 0x0, 0x4, 0xe0, 0x0, 0xf4,
    0x4, 0xf7, 0x0, 0x0, 0xbb, 0x0, 0x4, 0xe0,
    0x0, 0xf4, 0xd, 0xf1, 0x0, 0x0, 0xd9, 0x0,
    0x4, 0xff, 0xff, 0xf5, 0xaf, 0x80, 0x0, 0x0,
    0xf7, 0x0, 0x4, 0xf4, 0x44, 0x4a, 0xfd, 0x0,
    0x16, 0x69, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xd1, 0x0, 0xe, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8A2D "設" */
    0x0, 0x6, 0x70, 0x0, 0x0, 0x2, 0x11, 0x12,
    0x0, 0x0, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0xda, 0x0,
    0x0, 0x8f, 0x55, 0x5f, 0x60, 0x0, 0x4, 0x44,
    0x75, 0x44, 0x20, 0x8e, 0x0, 0xf, 0x60, 0x0,
    0xf, 0xff, 0xff, 0xff, 0x80, 0xbc, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0xf, 0x60, 0x0, 0x3, 0xee, 0xee, 0xea,
    0x2e, 0xe0, 0x0, 0xd, 0xfd, 0xb0, 0x0, 0x44,
    0x44, 0x43, 0xde, 0x30, 0x0, 0x2, 0x77, 0x50,
    0x0, 0x22, 0x22, 0x21, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xfb, 0xaf, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x4a, 0xd7, 0x77, 0x77, 0xfb, 0x0, 0x1, 0x54,
    0x44, 0x43, 0x6, 0xf2, 0x0, 0x5, 0xf4, 0x0,
    0x3, 0xff, 0xff, 0xfb, 0x0, 0xcc, 0x0, 0x1e,
    0xa0, 0x0, 0x3, 0xf1, 0x0, 0xab, 0x0, 0x2f,
    0xa1, 0xce, 0x10, 0x0, 0x3, 0xf1, 0x0, 0xab,
    0x0, 0x4, 0xff, 0xe2, 0x0, 0x0, 0x3, 0xf1,
    0x0, 0xab, 0x0, 0x6, 0xff, 0xd4, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xfb, 0x17, 0xef, 0x81, 0xaf,
    0xc6, 0x10, 0x3, 0xf5, 0x44, 0x45, 0xfe, 0x81,
    0x0, 0x3, 0xaf, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+8A66 "試" */
    0x0, 0x9, 0x30, 0x0, 0x0, 0x0, 0x1, 0xc3,
    0x20, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0x2, 0xf5, 0xe9, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0x0, 0x0, 0x2, 0xf4, 0x4f, 0x40, 0x4, 0x44,
    0x84, 0x42, 0x0, 0x0, 0x1, 0xf5, 0x8, 0x40,
    0xf, 0xff, 0xff, 0xf7, 0xbc, 0xcc, 0xcc, 0xfd,
    0xcc, 0xc3, 0x0, 0x0, 0x0, 0x0, 0x78, 0x88,
    0x88, 0xfb, 0x88, 0x82, 0x3, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x44,
    0x44, 0x40, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0x0, 0x22, 0x22, 0x22, 0xbb, 0xbb, 0xb5, 0xe8,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xf4, 0xbc, 0xfd,
    0xb5, 0xca, 0x0, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x0, 0xf5, 0x0, 0xbb, 0x0, 0x0, 0x1, 0x54,
    0x44, 0x40, 0x0, 0xf5, 0x0, 0x9d, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xf2, 0x0, 0xf5, 0x0, 0x7f,
    0x0, 0x0, 0x3, 0xf1, 0x2, 0xf2, 0x0, 0xf5,
    0x0, 0x5f, 0x10, 0x0, 0x3, 0xf1, 0x2, 0xf2,
    0x0, 0xf8, 0x7c, 0x5f, 0x40, 0x92, 0x3, 0xf1,
    0x2, 0xf4, 0x6a, 0xff, 0xd8, 0x1e, 0x80, 0xd4,
    0x3, 0xff, 0xff, 0xf7, 0xfe, 0x83, 0x0, 0x9,
    0xd0, 0xf2, 0x3, 0xf5, 0x44, 0x41, 0x30, 0x0,
    0x0, 0x3, 0xfa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,

    /* U+8A71 "話" */
    0x0, 0x5, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x34, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0, 0x2,
    0x47, 0xbe, 0xfe, 0x10, 0x0, 0x0, 0xe9, 0x0,
    0xc, 0xff, 0xff, 0xc7, 0x30, 0x0, 0x4, 0x44,
    0x85, 0x44, 0x4, 0x42, 0xe, 0x70, 0x0, 0x0,
    0x2f, 0xff, 0xff, 0xff, 0x20, 0x0, 0xe, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x70, 0x0, 0x0, 0x3, 0x99, 0x99, 0x94,
    0x27, 0x77, 0x7f, 0xb7, 0x77, 0x71, 0x3, 0x99,
    0x99, 0x94, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x22, 0x22, 0x21, 0x0, 0x0, 0xe, 0x70,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0xe, 0x70, 0x0, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x1, 0x54,
    0x44, 0x43, 0x5, 0xbb, 0xbf, 0xdb, 0xbb, 0x30,
    0x5, 0xff, 0xff, 0xfa, 0x8, 0xf8, 0x88, 0x88,
    0x9f, 0x50, 0x5, 0xf0, 0x0, 0xba, 0x8, 0xe0,
    0x0, 0x0, 0x2f, 0x50, 0x5, 0xf0, 0x0, 0xba,
    0x8, 0xe0, 0x0, 0x0, 0x2f, 0x50, 0x5, 0xf0,
    0x0, 0xba, 0x8, 0xe0, 0x0, 0x0, 0x2f, 0x50,
    0x5, 0xfb, 0xbb, 0xea, 0x8, 0xf6, 0x66, 0x66,
    0x7f, 0x50, 0x5, 0xf8, 0x88, 0x85, 0x8, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x2f, 0x50,

    /* U+8A8D "認" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x3, 0x33,
    0x33, 0x33, 0x34, 0x20, 0x0, 0xa, 0xf1, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0x1,
    0xf6, 0x0, 0x1, 0x11, 0x1f, 0x61, 0x1d, 0x80,
    0x4, 0x44, 0x74, 0x44, 0x3, 0xe0, 0x3f, 0x20,
    0xe, 0x80, 0x2f, 0xff, 0xff, 0xff, 0xa, 0x90,
    0x7e, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x20, 0xd9, 0x0, 0xf, 0x60, 0x5, 0xff,
    0xff, 0xf5, 0x24, 0x6, 0xf2, 0x0, 0x2f, 0x40,
    0x1, 0x44, 0x44, 0x41, 0x0, 0x3f, 0x90, 0x33,
    0x8f, 0x20, 0x0, 0x22, 0x22, 0x20, 0x6, 0xfb,
    0x0, 0xcf, 0xfb, 0x0, 0x6, 0xff, 0xff, 0xf5,
    0x1d, 0x80, 0x10, 0x13, 0x20, 0x0, 0x0, 0x11,
    0x11, 0x10, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0,
    0x2, 0x54, 0x44, 0x42, 0x1, 0x5d, 0x4f, 0x30,
    0x96, 0x0, 0x6, 0xff, 0xff, 0xf7, 0x2f, 0x6f,
    0xa, 0xb0, 0x6e, 0x0, 0x6, 0xe0, 0x0, 0xd7,
    0x6c, 0x5f, 0x2, 0xc0, 0xe, 0x60, 0x6, 0xe0,
    0x0, 0xd7, 0xa8, 0x5f, 0x0, 0x0, 0x27, 0xd0,
    0x6, 0xe0, 0x0, 0xd8, 0xf3, 0x5f, 0x0, 0x1,
    0xf3, 0xf3, 0x6, 0xff, 0xff, 0xf9, 0x90, 0x5f,
    0x55, 0x57, 0xf0, 0x40, 0x6, 0xe4, 0x44, 0x42,
    0x0, 0x1e, 0xff, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,

    /* U+8AA4 "誤" */
    0x0, 0x9, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x1, 0xf6, 0x0,
    0xe, 0xa5, 0x55, 0x55, 0x9f, 0x10, 0x4, 0x44,
    0x74, 0x44, 0xe, 0x70, 0x0, 0x0, 0x6f, 0x10,
    0x2f, 0xff, 0xff, 0xfe, 0xe, 0x70, 0x0, 0x0,
    0x6f, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb8,
    0x88, 0x88, 0xbf, 0x10, 0x5, 0xff, 0xff, 0xf4,
    0x9, 0xaa, 0xaa, 0xaa, 0xaa, 0x0, 0x1, 0x44,
    0x44, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x22, 0x22, 0x20, 0x2b, 0xbb, 0xbb, 0xbb,
    0xbb, 0x50, 0x6, 0xff, 0xff, 0xf4, 0x2b, 0xbb,
    0xcf, 0xdb, 0xbb, 0x60, 0x0, 0x11, 0x11, 0x10,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x3, 0x77,
    0x77, 0x72, 0x11, 0x11, 0x4f, 0x41, 0x11, 0x10,
    0x6, 0xfc, 0xcc, 0xf6, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xf3, 0x6, 0xe0, 0x0, 0xe6, 0x33, 0x33,
    0xdf, 0xb3, 0x33, 0x30, 0x6, 0xe0, 0x0, 0xe6,
    0x0, 0x3, 0xfa, 0xf2, 0x0, 0x0, 0x6, 0xe0,
    0x0, 0xe6, 0x0, 0x1d, 0xb0, 0xae, 0x20, 0x0,
    0x6, 0xff, 0xff, 0xf6, 0x6, 0xeb, 0x0, 0xb,
    0xe6, 0x0, 0x6, 0xe4, 0x44, 0x42, 0xdd, 0x60,
    0x0, 0x0, 0x6e, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+8AAA "說" */
    0x0, 0x6, 0x40, 0x0, 0x0, 0x13, 0x0, 0x46,
    0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0x7e,
    0x0, 0x5f, 0x10, 0x0, 0x0, 0x1, 0xf6, 0x0,
    0x1, 0xe6, 0x0, 0xc, 0xa0, 0x0, 0x4, 0x44,
    0x85, 0x44, 0xa, 0xd0, 0x0, 0x2, 0xf7, 0x0,
    0x1f, 0xff, 0xff, 0xfe, 0x7f, 0x30, 0x0, 0x0,
    0x5f, 0x60, 0x0, 0x0, 0x0, 0x3, 0xf9, 0x66,
    0x66, 0x66, 0x6b, 0xf1, 0x5, 0xff, 0xff, 0xf3,
    0x36, 0xfc, 0xcc, 0xcc, 0xfc, 0x10, 0x1, 0x44,
    0x44, 0x40, 0x6, 0xe0, 0x0, 0x0, 0xbc, 0x0,
    0x0, 0x22, 0x22, 0x20, 0x6, 0xe0, 0x0, 0x0,
    0xbc, 0x0, 0x5, 0xff, 0xff, 0xf3, 0x6, 0xe0,
    0x0, 0x0, 0xbc, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x6, 0xfd, 0xdd, 0xdd, 0xfc, 0x0, 0x1, 0x54,
    0x44, 0x41, 0x4, 0xaf, 0xca, 0xfc, 0xa7, 0x0,
    0x5, 0xff, 0xff, 0xf5, 0x0, 0x2f, 0x40, 0xe7,
    0x0, 0x0, 0x5, 0xe0, 0x0, 0xe5, 0x0, 0x5f,
    0x20, 0xe7, 0x0, 0x0, 0x5, 0xe0, 0x0, 0xe5,
    0x0, 0xae, 0x0, 0xe7, 0x0, 0x20, 0x5, 0xe0,
    0x0, 0xe5, 0x3, 0xfa, 0x0, 0xe7, 0x1, 0xf2,
    0x5, 0xff, 0xff, 0xf5, 0x3e, 0xf2, 0x0, 0xe7,
    0x2, 0xf1, 0x5, 0xf4, 0x44, 0x48, 0xff, 0x70,
    0x0, 0xeb, 0x58, 0xf0, 0x0, 0x0, 0x0, 0x1,
    0xe5, 0x0, 0x0, 0x8f, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8AAD "読" */
    0x0, 0xa, 0x40, 0x0, 0x0, 0x0, 0x1d, 0x50,
    0x0, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0, 0x0,
    0x1f, 0x60, 0x0, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x5, 0x55,
    0x85, 0x53, 0x45, 0x55, 0x6f, 0xa5, 0x55, 0x50,
    0x1f, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x1f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xee,
    0xef, 0xfe, 0xee, 0x20, 0x5, 0xff, 0xff, 0xe0,
    0x5, 0x55, 0x55, 0x55, 0x55, 0x0, 0x1, 0x44,
    0x44, 0x40, 0x57, 0x77, 0x77, 0x77, 0x77, 0x70,
    0x0, 0x22, 0x22, 0x10, 0xbf, 0xee, 0xee, 0xee,
    0xee, 0xf0, 0x5, 0xff, 0xff, 0xf0, 0xb9, 0x0,
    0x0, 0x0, 0x5, 0xf0, 0x0, 0x22, 0x22, 0x20,
    0xb9, 0xe, 0x70, 0x7e, 0x5, 0xf0, 0x1, 0x54,
    0x44, 0x40, 0x32, 0xf, 0x70, 0x7e, 0x1, 0x40,
    0x5, 0xff, 0xff, 0xf2, 0x0, 0xf, 0x60, 0x7e,
    0x0, 0x0, 0x5, 0xf0, 0x3, 0xf2, 0x0, 0x4f,
    0x30, 0x7e, 0x0, 0x0, 0x5, 0xf0, 0x3, 0xf2,
    0x0, 0xae, 0x0, 0x7e, 0x0, 0x30, 0x5, 0xf0,
    0x3, 0xf2, 0x4, 0xf6, 0x0, 0x7e, 0x0, 0xf5,
    0x5, 0xff, 0xff, 0xf2, 0x4f, 0xb0, 0x0, 0x7f,
    0x45, 0xf4, 0x5, 0xf4, 0x44, 0x45, 0xf9, 0x0,
    0x0, 0x2e, 0xff, 0xc0, 0x0, 0x10, 0x0, 0x0,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8ACB "請" */
    0x0, 0x5, 0x30, 0x0, 0x0, 0x0, 0x9, 0x30,
    0x0, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x13, 0x33,
    0x4f, 0x83, 0x33, 0x20, 0x0, 0x1, 0xf7, 0x0,
    0x4e, 0xee, 0xff, 0xfe, 0xee, 0xa0, 0x15, 0x55,
    0x96, 0x55, 0x1, 0x11, 0x2f, 0x61, 0x11, 0x0,
    0x2d, 0xdd, 0xdd, 0xdd, 0xc, 0xff, 0xff, 0xff,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x0, 0x5, 0xff, 0xff, 0xf5,
    0xbe, 0xee, 0xef, 0xee, 0xee, 0xe2, 0x1, 0x44,
    0x44, 0x41, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x0, 0x22, 0x22, 0x20, 0x2, 0x66, 0x66, 0x66,
    0x74, 0x0, 0x6, 0xff, 0xff, 0xf5, 0x6, 0xfc,
    0xcc, 0xcc, 0xfb, 0x0, 0x0, 0x11, 0x11, 0x10,
    0x6, 0xf0, 0x0, 0x0, 0xab, 0x0, 0x1, 0x54,
    0x44, 0x42, 0x6, 0xfa, 0xaa, 0xaa, 0xeb, 0x0,
    0x6, 0xff, 0xff, 0xf7, 0x6, 0xf7, 0x77, 0x77,
    0xdb, 0x0, 0x6, 0xe0, 0x0, 0xd7, 0x6, 0xf1,
    0x11, 0x11, 0xbb, 0x0, 0x6, 0xe0, 0x0, 0xd7,
    0x6, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x6, 0xe0,
    0x0, 0xd7, 0x6, 0xf0, 0x0, 0x0, 0xab, 0x0,
    0x6, 0xff, 0xff, 0xf7, 0x6, 0xf0, 0x0, 0x0,
    0xab, 0x0, 0x6, 0xe4, 0x44, 0x42, 0x6, 0xf0,
    0x0, 0x24, 0xcb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf0, 0x0, 0x7f, 0xe6, 0x0,

    /* U+8B66 "警" */
    0x0, 0x7, 0x90, 0xc, 0x30, 0x0, 0x59, 0x0,
    0x0, 0x0, 0xde, 0xff, 0xee, 0xfe, 0xe8, 0xc,
    0xa2, 0x22, 0x21, 0x1, 0x2c, 0xa1, 0x1c, 0x41,
    0x5, 0xff, 0xff, 0xff, 0xb0, 0x7, 0xf9, 0x99,
    0x99, 0x62, 0xff, 0x20, 0x2f, 0x30, 0x3, 0xf7,
    0x55, 0x55, 0xca, 0xda, 0x9c, 0xb, 0xc0, 0x1,
    0xee, 0xed, 0xdf, 0xb, 0x91, 0x0, 0xce, 0xe2,
    0x0, 0x2, 0xa7, 0x2, 0xf0, 0xd7, 0x0, 0x3d,
    0xfe, 0x40, 0x0, 0xa, 0xed, 0xde, 0x6f, 0x42,
    0xcf, 0x91, 0x9f, 0xc6, 0x0, 0x42, 0x0, 0x3a,
    0x8c, 0x77, 0x20, 0x0, 0x28, 0x50, 0xac, 0xcc,
    0xcc, 0xcc, 0xef, 0xcc, 0xcc, 0xcc, 0xc4, 0x3,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x10, 0x0, 0x1c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xc2, 0x0, 0x0, 0x0, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x0, 0x0, 0x0, 0x2e, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xee, 0xee, 0xee, 0xee, 0xee, 0xf6, 0x0,
    0x0, 0x4, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x4f, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xf6, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BBE "设" */
    0x0, 0x30, 0x0, 0x0, 0x2, 0x11, 0x11, 0x20,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x3f,
    0x75, 0x55, 0xf6, 0x0, 0x0, 0x0, 0x4f, 0x60,
    0x3, 0xf3, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x40, 0x0, 0x5f, 0x10, 0x0, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0xf, 0x60,
    0x0, 0x77, 0x77, 0x20, 0x9, 0xf4, 0x0, 0x0,
    0xed, 0xaa, 0x1e, 0xff, 0xf5, 0xc, 0xf7, 0x0,
    0x0, 0x5, 0xaa, 0xa2, 0x0, 0x1f, 0x50, 0x43,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf5,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x10, 0x0,
    0x1f, 0x50, 0x2a, 0xf7, 0x77, 0x77, 0x7e, 0xd0,
    0x0, 0x1, 0xf5, 0x0, 0x1f, 0x70, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x7f, 0x30,
    0x1, 0xdc, 0x0, 0x0, 0x1, 0xf5, 0x2, 0x0,
    0xce, 0x20, 0xce, 0x20, 0x0, 0x0, 0x1f, 0x7c,
    0xb0, 0x1, 0xde, 0xdf, 0x30, 0x0, 0x0, 0x2,
    0xff, 0xc2, 0x0, 0x9, 0xff, 0xb1, 0x0, 0x0,
    0x0, 0xaf, 0x90, 0x2, 0x8e, 0xf9, 0x8f, 0xf9,
    0x30, 0x0, 0xb, 0x70, 0xc, 0xff, 0x92, 0x0,
    0x29, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x45, 0x0,
    0x0, 0x0, 0x1, 0x57, 0x0,

    /* U+8BBF "访" */
    0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0xb6, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfb, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x23, 0x77, 0x77, 0x9b, 0x77, 0x77, 0x70,
    0x0, 0x0, 0x1, 0x8, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xbb, 0xc5, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xdd,
    0xf8, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0xdc,
    0x77, 0x77, 0xf9, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x1, 0xf6, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x4, 0xf3, 0x0, 0x0,
    0xf6, 0x0, 0x0, 0x0, 0xf8, 0x19, 0x8, 0xf0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0xfa, 0xde,
    0x1d, 0xb0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x1,
    0xff, 0xb1, 0x4f, 0x60, 0x0, 0x5, 0xf2, 0x0,
    0x0, 0xa, 0xf9, 0x0, 0xce, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0xa, 0x70, 0x9, 0xf5, 0x0,
    0x56, 0x6e, 0xd0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x80, 0x0, 0x9f, 0xfe, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BD5 "试" */
    0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x4b, 0x15,
    0x0, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0xcb, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0,
    0x0, 0x4f, 0x21, 0xe8, 0x0, 0x0, 0x5f, 0x50,
    0x0, 0x0, 0x4, 0xf3, 0x5, 0x90, 0x0, 0x0,
    0x30, 0x8a, 0xaa, 0xaa, 0xbf, 0xba, 0xaa, 0x40,
    0x0, 0x0, 0xb, 0xdd, 0xdd, 0xdd, 0xfe, 0xdd,
    0xd5, 0x67, 0x78, 0x30, 0x0, 0x0, 0x0, 0x2f,
    0x50, 0x0, 0xb, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x1, 0xf6, 0x0, 0x0, 0x0, 0xf, 0x60, 0x16,
    0x66, 0x66, 0x1f, 0x70, 0x0, 0x0, 0x0, 0xf6,
    0x3, 0xff, 0xff, 0xf2, 0xf8, 0x0, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x2f, 0x40, 0xd, 0xa0, 0x0,
    0x0, 0x0, 0xf6, 0x0, 0x2, 0xf4, 0x0, 0xcc,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x2f, 0x40,
    0x9, 0xe0, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x2,
    0xf4, 0x0, 0x7f, 0x0, 0x0, 0x0, 0xf, 0x63,
    0xa0, 0x2f, 0x55, 0x54, 0xf4, 0xa, 0x50, 0x0,
    0xfc, 0xfc, 0x27, 0xff, 0xfb, 0xf, 0x80, 0xc7,
    0x0, 0x4f, 0xf8, 0x7f, 0xfd, 0x83, 0x0, 0xbe,
    0x1f, 0x40, 0xb, 0xe3, 0x2, 0x72, 0x0, 0x0,
    0x4, 0xff, 0xf0, 0x0, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BDD "话" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x26,
    0x70, 0x0, 0x8e, 0x20, 0x0, 0x2, 0x47, 0x9c,
    0xff, 0xfd, 0x30, 0x1, 0xce, 0x20, 0x5f, 0xff,
    0xee, 0xf8, 0x41, 0x0, 0x0, 0x1, 0xdd, 0x0,
    0x42, 0x0, 0x7f, 0x10, 0x0, 0x0, 0x0, 0x1,
    0x40, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x10, 0x0,
    0x0, 0x77, 0x77, 0x20, 0x59, 0x99, 0x9c, 0xfa,
    0x99, 0x99, 0x3e, 0xff, 0xf4, 0x6, 0xdd, 0xdd,
    0xef, 0xdd, 0xdd, 0xd4, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0x7, 0xf1, 0x0, 0x0, 0x0, 0x2, 0xf4,
    0x0, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x0, 0x0,
    0x2f, 0x40, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x6d, 0xdd, 0xef, 0xed,
    0xdd, 0x60, 0x0, 0x2f, 0x40, 0x7, 0xf8, 0x88,
    0x88, 0x89, 0xf7, 0x0, 0x2, 0xf4, 0x14, 0x7f,
    0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x2f, 0x8e,
    0xb7, 0xf0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x3,
    0xff, 0xc1, 0x7f, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0xbf, 0xa0, 0x7, 0xf6, 0x66, 0x66, 0x67,
    0xf7, 0x0, 0xc, 0x80, 0x0, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x10, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x1, 0xf7, 0x0,

    /* U+8BEF "误" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x0, 0xcf, 0x40, 0x7, 0xf5,
    0x55, 0x55, 0x5b, 0xe0, 0x0, 0x0, 0xcf, 0x10,
    0x7f, 0x0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x1,
    0x70, 0x7, 0xf0, 0x0, 0x0, 0x9, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xcc, 0xcc, 0xcc, 0xee,
    0x0, 0x77, 0x77, 0x30, 0x4, 0x99, 0x99, 0x99,
    0x99, 0x80, 0xd, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x60, 0xa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xa4, 0x0, 0x1, 0xf6,
    0x0, 0xbb, 0xbb, 0xef, 0xbb, 0xbb, 0x50, 0x0,
    0x1f, 0x60, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x0,
    0x0, 0x1, 0xf6, 0x1, 0x11, 0x11, 0xcb, 0x11,
    0x11, 0x10, 0x0, 0x1f, 0x60, 0xbf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x1, 0xf6, 0x3, 0x33,
    0x37, 0xff, 0x63, 0x33, 0x30, 0x0, 0x1f, 0x79,
    0x90, 0x0, 0xbe, 0xcc, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xe3, 0x0, 0x8f, 0x52, 0xfb, 0x0, 0x0,
    0x0, 0x8f, 0xb1, 0x3, 0xbf, 0x80, 0x4, 0xfd,
    0x40, 0x0, 0x4, 0x80, 0xc, 0xfd, 0x50, 0x0,
    0x3, 0xdf, 0xd1, 0x0, 0x0, 0x0, 0x44, 0x0,
    0x0, 0x0, 0x0, 0x55, 0x0,

    /* U+8BF4 "说" */
    0x0, 0x20, 0x0, 0x1, 0x82, 0x0, 0x0, 0x58,
    0x0, 0x0, 0x5f, 0x60, 0x0, 0xd, 0xc0, 0x0,
    0xd, 0xd0, 0x0, 0x0, 0x9f, 0x60, 0x0, 0x4f,
    0x50, 0x3, 0xf6, 0x0, 0x0, 0x0, 0xaf, 0x40,
    0x0, 0xca, 0x0, 0xbe, 0x0, 0x0, 0x0, 0x0,
    0x80, 0x1c, 0xcd, 0xcc, 0xcf, 0xec, 0x70, 0x0,
    0x0, 0x0, 0x2, 0xfb, 0x99, 0x99, 0x99, 0xfa,
    0x0, 0x78, 0x88, 0x40, 0x2f, 0x50, 0x0, 0x0,
    0xe, 0xa0, 0xd, 0xff, 0xf8, 0x2, 0xf5, 0x0,
    0x0, 0x0, 0xea, 0x0, 0x0, 0xf, 0x80, 0x2f,
    0x50, 0x0, 0x0, 0xe, 0xa0, 0x0, 0x0, 0xf8,
    0x2, 0xfd, 0xcc, 0xcc, 0xcc, 0xfa, 0x0, 0x0,
    0xf, 0x80, 0x19, 0x9d, 0xf9, 0xbf, 0xa9, 0x50,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xbd, 0x4, 0xf3,
    0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0xd, 0xa0,
    0x4f, 0x30, 0x0, 0x0, 0x0, 0xf8, 0x5e, 0x11,
    0xf6, 0x4, 0xf3, 0x0, 0x0, 0x0, 0xf, 0xef,
    0x90, 0x8f, 0x10, 0x4f, 0x30, 0x7, 0x10, 0x7,
    0xfe, 0x50, 0x4f, 0x90, 0x4, 0xf3, 0x0, 0xf4,
    0x0, 0xdc, 0x10, 0x7f, 0xc0, 0x0, 0x4f, 0x86,
    0x8f, 0x20, 0x3, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0xdf, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BF7 "请" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x6, 0xb0, 0x0,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x33, 0x33, 0xaf,
    0x33, 0x33, 0x20, 0x0, 0xaf, 0x50, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x30, 0xa, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x12, 0x22, 0xaf, 0x22, 0x22,
    0x0, 0x77, 0x78, 0x30, 0x34, 0x44, 0x4b, 0xf4,
    0x44, 0x44, 0x1f, 0xff, 0xf7, 0xa, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xd4, 0x0, 0xf, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0,
    0xf, 0x70, 0x6, 0xf2, 0x22, 0x22, 0x2b, 0xc0,
    0x0, 0x0, 0xf7, 0x0, 0x6f, 0x11, 0x11, 0x11,
    0xbc, 0x0, 0x0, 0xf, 0x70, 0x6, 0xff, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x0, 0xf7, 0x2, 0x6f,
    0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0xf, 0x7a,
    0xd6, 0xfd, 0xdd, 0xdd, 0xdf, 0xc0, 0x0, 0x0,
    0xff, 0xe2, 0x6f, 0x44, 0x44, 0x44, 0xcc, 0x0,
    0x0, 0x4f, 0xd1, 0x6, 0xf0, 0x0, 0x0, 0xb,
    0xc0, 0x0, 0xb, 0xd1, 0x0, 0x6f, 0x0, 0x1,
    0x44, 0xcb, 0x0, 0x0, 0x41, 0x0, 0x6, 0xf0,
    0x0, 0xf, 0xfe, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8CC7 "資" */
    0x0, 0x10, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xe9, 0x30, 0x0, 0xdb, 0x33,
    0x33, 0x33, 0x30, 0x0, 0x5, 0xbf, 0x80, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x22,
    0xae, 0x20, 0x3e, 0x30, 0xd, 0xa0, 0x0, 0x0,
    0x27, 0x64, 0x20, 0x3e, 0xdd, 0x23, 0x90, 0x0,
    0x5a, 0xef, 0xb5, 0x4, 0xaf, 0x70, 0x7f, 0xa4,
    0x0, 0xb, 0xb5, 0x10, 0xc, 0xd8, 0x10, 0x0,
    0x19, 0xef, 0x30, 0x0, 0x5e, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xe8, 0x20, 0x0, 0x6, 0xf2, 0x11,
    0x11, 0x11, 0x11, 0x1e, 0x90, 0x0, 0x0, 0x6f,
    0x32, 0x22, 0x22, 0x22, 0x22, 0xe9, 0x0, 0x0,
    0x6, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0x90,
    0x0, 0x0, 0x6f, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x90, 0x0, 0x0, 0x6f, 0x10, 0x0,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x6, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdf, 0x90, 0x0, 0x0,
    0x2, 0x3a, 0x93, 0x22, 0x29, 0xa5, 0x21, 0x0,
    0x0, 0x16, 0xbf, 0xd5, 0x0, 0x0, 0x5a, 0xfd,
    0x71, 0x0, 0x8f, 0xfa, 0x40, 0x0, 0x0, 0x0,
    0x1, 0x7d, 0xf5, 0x0, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x0,

    /* U+8D25 "败" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x75, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0xe8, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x66, 0x6a,
    0xe0, 0x2, 0xf3, 0x0, 0x0, 0x0, 0x3, 0xf0,
    0x13, 0x6, 0xe0, 0x7, 0xf6, 0x55, 0x55, 0x50,
    0x3, 0xf0, 0x5f, 0x6, 0xe0, 0xc, 0xff, 0xff,
    0xff, 0xf0, 0x3, 0xf0, 0x5f, 0x6, 0xe0, 0x3f,
    0x40, 0x0, 0xd7, 0x0, 0x3, 0xf0, 0x5f, 0x6,
    0xe0, 0xae, 0x0, 0x0, 0xf5, 0x0, 0x3, 0xf0,
    0x5f, 0x6, 0xe2, 0xff, 0x0, 0x2, 0xf2, 0x0,
    0x3, 0xf0, 0x5f, 0x6, 0xe8, 0xdf, 0x50, 0x6,
    0xf0, 0x0, 0x3, 0xf0, 0x5f, 0x6, 0xe0, 0x39,
    0xb0, 0xa, 0xb0, 0x0, 0x3, 0xf0, 0x5f, 0x6,
    0xe0, 0x3, 0xf2, 0xe, 0x60, 0x0, 0x3, 0xf0,
    0x7d, 0x6, 0xe0, 0x0, 0xca, 0x5f, 0x10, 0x0,
    0x3, 0xf0, 0xab, 0x6, 0xe0, 0x0, 0x4f, 0xea,
    0x0, 0x0, 0x0, 0x30, 0xe7, 0x11, 0x20, 0x0,
    0xb, 0xf3, 0x0, 0x0, 0x0, 0x5, 0xf2, 0xe7,
    0x0, 0x0, 0x1e, 0xfb, 0x0, 0x0, 0x0, 0x1e,
    0x90, 0x5f, 0x30, 0x1, 0xdd, 0x4f, 0xa0, 0x0,
    0x1, 0xcd, 0x10, 0xa, 0xe1, 0x3e, 0xd1, 0x5,
    0xfc, 0x20, 0xd, 0xd2, 0x0, 0x1, 0xb5, 0xfc,
    0x10, 0x0, 0x3e, 0xe1, 0x3, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x0, 0x0, 0x0, 0x30,

    /* U+8D44 "资" */
    0x0, 0x20, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xe7, 0x0, 0x1, 0xea, 0x22,
    0x22, 0x22, 0x30, 0x0, 0x18, 0xfe, 0x40, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x1, 0xa3,
    0x7f, 0x50, 0x1f, 0x60, 0xa, 0xd0, 0x0, 0x0,
    0x0, 0x3f, 0x70, 0x8, 0xf8, 0x2, 0xf5, 0x0,
    0x0, 0x1, 0x6a, 0x20, 0x3, 0xfa, 0xf6, 0x1,
    0x0, 0x2, 0x7c, 0xff, 0xa0, 0x4, 0xec, 0x5,
    0xfa, 0x10, 0x0, 0xdf, 0xb5, 0x0, 0x3a, 0xfa,
    0x0, 0x3, 0xdf, 0xa4, 0x3, 0x10, 0x0, 0x2f,
    0xc4, 0x0, 0x0, 0x0, 0x6d, 0x70, 0x0, 0x27,
    0x77, 0x87, 0x77, 0x77, 0x77, 0x74, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0x5f, 0x20, 0x0, 0x46, 0x0, 0x0,
    0xf9, 0x0, 0x0, 0x5, 0xf2, 0x0, 0xc, 0xb0,
    0x0, 0xf, 0x90, 0x0, 0x0, 0x5f, 0x20, 0x2,
    0xf6, 0x0, 0x0, 0xf9, 0x0, 0x0, 0x5, 0xf2,
    0x0, 0xbe, 0x27, 0x20, 0xf, 0x90, 0x0, 0x0,
    0x2, 0x1, 0xaf, 0x55, 0xef, 0xd7, 0x10, 0x0,
    0x0, 0x0, 0x39, 0xfe, 0x40, 0x0, 0x4a, 0xff,
    0xb4, 0x0, 0x8c, 0xff, 0xc7, 0x0, 0x0, 0x0,
    0x1, 0x7e, 0xf6, 0x4, 0x85, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x0,

    /* U+8D85 "超" */
    0x0, 0x0, 0x4c, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0x70, 0x3, 0x66, 0xaf, 0x66,
    0x62, 0x55, 0xaf, 0x55, 0x5f, 0x70, 0x8, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x9d, 0x0, 0xf, 0x60,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0xe8, 0x0,
    0x2f, 0x50, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x7,
    0xf2, 0x0, 0x4f, 0x30, 0x8, 0x99, 0xbf, 0x99,
    0x95, 0x5f, 0x70, 0x89, 0xcf, 0x0, 0xb, 0xcc,
    0xcf, 0xdc, 0xcc, 0xf9, 0x0, 0x7b, 0xa4, 0x0,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x53, 0x33, 0x33,
    0x33, 0x0, 0x0, 0xb3, 0x1f, 0x40, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0x10, 0x1, 0xf4, 0x1f, 0x86,
    0x62, 0x8e, 0x0, 0x0, 0x7f, 0x10, 0x2, 0xf3,
    0x1f, 0xff, 0xf6, 0x8e, 0x0, 0x0, 0x6f, 0x10,
    0x3, 0xf5, 0x1f, 0x40, 0x0, 0x8e, 0x0, 0x0,
    0x6f, 0x10, 0x4, 0xfb, 0x1f, 0x40, 0x0, 0x8f,
    0x44, 0x44, 0x9f, 0x10, 0x6, 0xff, 0x6f, 0x40,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0x10, 0x9, 0xc8,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0x80, 0x8f, 0xfb, 0x97, 0x76, 0x66, 0x77,
    0x77, 0x71, 0x4f, 0x30, 0x2, 0x8c, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8DB3 "足" */
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x9, 0xf7, 0x77, 0x77, 0x77,
    0x77, 0x7b, 0xf1, 0x0, 0x0, 0x9, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf1, 0x0,
    0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf1, 0x0, 0x0, 0x9, 0xf7, 0x77, 0x77, 0x77,
    0x77, 0x7b, 0xf1, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x36, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0xfd, 0x0, 0x9, 0xf7, 0x77, 0x77, 0x75, 0x0,
    0x0, 0x6, 0xff, 0x60, 0x9, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xd9, 0xf4, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x50, 0xbf,
    0x9b, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfb,
    0x0, 0x8, 0xff, 0xfa, 0x87, 0x77, 0x77, 0x71,
    0xb, 0xc0, 0x0, 0x0, 0x16, 0xad, 0xef, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+8DEF "路" */
    0x0, 0x22, 0x22, 0x22, 0x0, 0x3, 0xd2, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0x60, 0x9,
    0xe0, 0x0, 0x0, 0x0, 0x3, 0xf4, 0x22, 0x3f,
    0x60, 0x1f, 0xff, 0xff, 0xf9, 0x0, 0x3, 0xf2,
    0x0, 0xf, 0x60, 0x8f, 0x76, 0x67, 0xf7, 0x0,
    0x3, 0xf2, 0x0, 0xf, 0x63, 0xff, 0x70, 0x9,
    0xf1, 0x0, 0x3, 0xf6, 0x55, 0x5f, 0x8e, 0xd6,
    0xf2, 0x2f, 0x80, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xcf, 0x30, 0xbd, 0xdd, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x0, 0x1, 0x0, 0x1f, 0xf3, 0x0, 0x0,
    0x0, 0x20, 0x6f, 0x0, 0x0, 0x0, 0xbf, 0xfb,
    0x10, 0x0, 0x3, 0xf1, 0x6f, 0x22, 0x10, 0x3d,
    0xf4, 0x3f, 0xd4, 0x0, 0x3, 0xf1, 0x6f, 0xff,
    0xb9, 0xfc, 0x20, 0x2, 0xdf, 0xb2, 0x3, 0xf1,
    0x6f, 0x33, 0x8e, 0xee, 0xee, 0xee, 0xef, 0xb0,
    0x3, 0xf1, 0x6f, 0x0, 0x0, 0xcc, 0x66, 0x66,
    0xbe, 0x0, 0x3, 0xf1, 0x6f, 0x0, 0x0, 0xca,
    0x0, 0x0, 0x8e, 0x0, 0x3, 0xf1, 0x6f, 0x26,
    0x70, 0xca, 0x0, 0x0, 0x8e, 0x0, 0x3, 0xf7,
    0xcf, 0xff, 0xb0, 0xca, 0x0, 0x0, 0x8e, 0x0,
    0x2f, 0xff, 0xe9, 0x51, 0x0, 0xcc, 0x55, 0x55,
    0xbe, 0x0, 0xa, 0x62, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xca, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8F09 "載" */
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x2c, 0x30, 0x50,
    0x0, 0x0, 0x33, 0x38, 0xf3, 0x33, 0x23, 0xf4,
    0x2e, 0xc1, 0x0, 0xf, 0xff, 0xff, 0xff, 0xfd,
    0x3f, 0x40, 0x2e, 0xc0, 0x0, 0x0, 0x6, 0xf0,
    0x0, 0x2, 0xf4, 0x0, 0x3e, 0x20, 0x22, 0x22,
    0x8f, 0x32, 0x22, 0x4f, 0x72, 0x22, 0x22, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x12, 0x22, 0x7f, 0x22, 0x22, 0x2f, 0x82,
    0x22, 0x22, 0x5, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0xe8, 0x0, 0x6e, 0x0, 0x13, 0x33, 0x8f, 0x33,
    0x33, 0xd, 0xa0, 0xc, 0xb0, 0x0, 0x89, 0x9c,
    0xf9, 0x99, 0x70, 0xbc, 0x2, 0xf5, 0x0, 0xe,
    0x75, 0x8e, 0x55, 0x9c, 0x9, 0xe0, 0x9e, 0x0,
    0x0, 0xea, 0x9b, 0xf9, 0x9b, 0xc0, 0x7f, 0x2f,
    0x70, 0x0, 0xe, 0x52, 0x6e, 0x22, 0x7c, 0x4,
    0xfd, 0xe0, 0x0, 0x0, 0xed, 0xcd, 0xfc, 0xcd,
    0xc0, 0xf, 0xf6, 0x0, 0x20, 0x1, 0x22, 0x7f,
    0x22, 0x21, 0x1, 0xfe, 0x0, 0xf, 0x23, 0x55,
    0x59, 0xf5, 0x55, 0x52, 0xcf, 0xf2, 0x1, 0xf2,
    0x9d, 0xdd, 0xef, 0xdd, 0xde, 0xef, 0x5f, 0xb0,
    0x3f, 0x0, 0x0, 0x6, 0xf0, 0x2, 0xdf, 0x50,
    0x6f, 0xbc, 0xc0, 0x0, 0x0, 0x6f, 0x0, 0xb,
    0x40, 0x0, 0x7e, 0xe4, 0x0,

    /* U+8F7D "载" */
    0x0, 0x0, 0x1d, 0x40, 0x0, 0x7, 0xa0, 0x20,
    0x0, 0x0, 0x23, 0x34, 0xf7, 0x33, 0x20, 0x9d,
    0xd, 0xc1, 0x0, 0xe, 0xff, 0xff, 0xff, 0xfe,
    0x9, 0xd0, 0x1e, 0xc0, 0x0, 0x0, 0x1, 0xf5,
    0x0, 0x0, 0x9d, 0x0, 0x3c, 0x10, 0x1, 0x11,
    0x2f, 0x61, 0x11, 0x19, 0xe1, 0x11, 0x11, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x22, 0x25, 0xd5, 0x22, 0x22, 0x28, 0xf2,
    0x22, 0x22, 0x0, 0x11, 0x8f, 0x21, 0x11, 0x10,
    0x5f, 0x10, 0x5c, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xe3, 0xf2, 0xa, 0xd0, 0x1, 0x39, 0xf4,
    0x33, 0x33, 0x32, 0x2f, 0x40, 0xf7, 0x0, 0x0,
    0xe8, 0x5, 0xf1, 0x0, 0x0, 0xf7, 0x6f, 0x10,
    0x0, 0xaf, 0x65, 0x9f, 0x65, 0x51, 0xd, 0xad,
    0xb0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0x30,
    0xaf, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x6, 0xfb, 0x0, 0x0, 0x1, 0x23, 0x48,
    0xf8, 0x9a, 0xa0, 0x8f, 0x70, 0xd, 0x27, 0xff,
    0xfd, 0xdf, 0xa8, 0x65, 0x4f, 0xfe, 0x1, 0xf2,
    0x11, 0x0, 0x5, 0xf1, 0x0, 0x3f, 0xc3, 0xfc,
    0xae, 0x0, 0x0, 0x0, 0x5f, 0x10, 0x3e, 0xd1,
    0x4, 0xef, 0x60, 0x0, 0x0, 0x5, 0xf1, 0x6,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8FBC "込" */
    0x0, 0x50, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xec, 0x10, 0x0, 0x9, 0xe3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2e, 0xc0, 0x0,
    0x1, 0xce, 0x10, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf9, 0x0, 0x0, 0x1e, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x51, 0x0, 0x0, 0x9, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x5f, 0x60, 0x0, 0x0,
    0xf, 0xff, 0xf3, 0x0, 0x0, 0xaf, 0xb, 0xc0,
    0x0, 0x0, 0x6, 0x68, 0xf3, 0x0, 0x2, 0xf9,
    0x5, 0xf2, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0xa, 0xf2, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x5f, 0x80, 0x0, 0x8f, 0x50, 0x0,
    0x0, 0x3, 0xf3, 0x4, 0xfc, 0x0, 0x0, 0xd,
    0xf5, 0x0, 0x0, 0x3, 0xf3, 0x6f, 0xd1, 0x0,
    0x0, 0x2, 0xef, 0xa0, 0x0, 0x8, 0xf6, 0x1a,
    0x10, 0x0, 0x0, 0x0, 0x1a, 0x60, 0x0, 0xbf,
    0xaf, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf2, 0x3, 0xdf, 0xa8, 0x76, 0x66, 0x77,
    0x89, 0xb1, 0xb, 0x40, 0x0, 0x5, 0xac, 0xee,
    0xee, 0xed, 0xdd, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8FDB "进" */
    0x0, 0x20, 0x0, 0x0, 0x2, 0x60, 0x0, 0x35,
    0x0, 0x0, 0x1, 0xfa, 0x0, 0x0, 0x6, 0xf1,
    0x0, 0x9e, 0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0,
    0x6, 0xf1, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x5,
    0xf8, 0x3, 0x38, 0xf4, 0x33, 0xaf, 0x33, 0x10,
    0x0, 0x0, 0x72, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x0, 0x0, 0x14, 0x48, 0xf5,
    0x44, 0xbf, 0x44, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf1, 0x0, 0x9e, 0x0, 0x0, 0x9, 0x99,
    0x92, 0x0, 0x6, 0xf1, 0x0, 0x9e, 0x0, 0x0,
    0xd, 0xde, 0xf3, 0x2, 0x28, 0xf3, 0x22, 0xaf,
    0x22, 0x20, 0x0, 0x3, 0xf3, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x3, 0xf3, 0x14,
    0x4c, 0xe4, 0x44, 0xbf, 0x44, 0x40, 0x0, 0x3,
    0xf3, 0x0, 0xf, 0xa0, 0x0, 0x9e, 0x0, 0x0,
    0x0, 0x3, 0xf3, 0x0, 0x7f, 0x40, 0x0, 0x9e,
    0x0, 0x0, 0x0, 0x3, 0xf3, 0x4, 0xfc, 0x0,
    0x0, 0x9e, 0x0, 0x0, 0x0, 0x8, 0xf6, 0xb,
    0xe2, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0xbf,
    0xaf, 0x71, 0x20, 0x0, 0x0, 0x36, 0x0, 0x0,
    0xc, 0xf3, 0x3, 0xee, 0x86, 0x44, 0x44, 0x55,
    0x78, 0xa1, 0xd, 0x60, 0x0, 0x17, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xd0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x11, 0x10, 0x0, 0x0,

    /* U+8FDE "连" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x92, 0x0, 0x0, 0x0, 0xab,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xde, 0x10, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x5, 0xf7, 0x46, 0x6e, 0xd6, 0x66, 0x66,
    0x66, 0x10, 0x0, 0x0, 0x71, 0x0, 0x3f, 0x60,
    0x36, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x1, 0x11,
    0x10, 0x4, 0xf6, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xf0, 0xc, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0, 0x4, 0x4a, 0xf0, 0x5, 0x77, 0x77,
    0xcf, 0x77, 0x76, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf0, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x7, 0xf0, 0x57, 0x77, 0x77,
    0xcf, 0x77, 0x77, 0x60, 0x0, 0x7, 0xf0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x0,
    0x1, 0xaf, 0xfb, 0x30, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x0, 0x1d, 0xf8, 0x4d, 0xfd, 0x98, 0x76,
    0x89, 0x78, 0x9a, 0xb3, 0x1d, 0x70, 0x0, 0x5a,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x11, 0x0, 0x0, 0x0,

    /* U+9001 "送" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x92, 0x0, 0x0, 0x4c, 0x0,
    0x0, 0x4, 0xd3, 0x0, 0x1, 0xde, 0x10, 0x0,
    0x1f, 0x80, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x2e,
    0xd0, 0x0, 0x7, 0xf2, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0x4, 0xf9, 0x3, 0x45, 0xb5, 0x44, 0xdd,
    0x44, 0x20, 0x0, 0x0, 0x50, 0xc, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x1,
    0x11, 0x12, 0xf8, 0x11, 0x11, 0x0, 0x3, 0x33,
    0x30, 0x0, 0x0, 0x1, 0xf7, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xf0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0x0, 0x0, 0x3, 0x39, 0xf0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x7, 0xf0, 0x37,
    0x77, 0x79, 0xfb, 0x77, 0x77, 0x70, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x8, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x1f, 0xab, 0xf4,
    0x0, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0xbf,
    0x20, 0xbf, 0x40, 0x0, 0x0, 0x7, 0xf0, 0x0,
    0x1c, 0xf5, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x8,
    0xf0, 0x8, 0xfe, 0x40, 0x0, 0x1, 0xde, 0x10,
    0x1, 0xaf, 0xfa, 0x2a, 0x91, 0x0, 0x0, 0x0,
    0x19, 0x0, 0x2d, 0xf7, 0x5d, 0xfc, 0x97, 0x66,
    0x66, 0x77, 0x88, 0x94, 0x1e, 0x50, 0x0, 0x6b,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x11, 0x11, 0x0, 0x0, 0x0,

    /* U+9023 "連" */
    0x0, 0x50, 0x0, 0x0, 0x0, 0x6, 0xb0, 0x0,
    0x0, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x8,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x80, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x9,
    0xf4, 0x44, 0x44, 0x4a, 0xf4, 0x44, 0x44, 0x20,
    0x0, 0x0, 0xc3, 0x2, 0x22, 0x29, 0xf2, 0x22,
    0x21, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x2, 0x22, 0x20, 0xf,
    0x60, 0x8, 0xf0, 0x0, 0xe8, 0x0, 0x1f, 0xff,
    0xf0, 0xf, 0xfe, 0xef, 0xfe, 0xee, 0xf8, 0x0,
    0x2, 0x29, 0xf0, 0xf, 0x83, 0x39, 0xf3, 0x33,
    0xf8, 0x0, 0x0, 0x7, 0xf0, 0xf, 0x60, 0x8,
    0xf0, 0x0, 0xe8, 0x0, 0x0, 0x7, 0xf0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x7,
    0xf0, 0x2, 0x22, 0x29, 0xf2, 0x22, 0x21, 0x0,
    0x0, 0x7, 0xf1, 0x55, 0x55, 0x5b, 0xf5, 0x55,
    0x55, 0x50, 0x0, 0x7, 0xf3, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x1, 0xaf,
    0xf9, 0x10, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0,
    0x1d, 0xf6, 0x5e, 0xfb, 0x86, 0x56, 0x75, 0x67,
    0x88, 0x93, 0x1e, 0x40, 0x0, 0x7c, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0xe2, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x11, 0x0, 0x0, 0x0,

    /* U+9054 "達" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xb1, 0x0,
    0x0, 0x0, 0x4, 0xc3, 0x0, 0x2, 0x22, 0x27,
    0xf4, 0x22, 0x21, 0x0, 0x1, 0xcf, 0x30, 0xc,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xb2, 0xcc, 0xcc, 0xcd, 0xfc, 0xcc,
    0xcc, 0xb0, 0x0, 0x0, 0x0, 0x66, 0xaf, 0x66,
    0x66, 0xaf, 0x76, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x50, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x36, 0x6e, 0xb6, 0x66, 0xf9, 0x66, 0x40,
    0x1f, 0xff, 0xe0, 0x7b, 0xbb, 0xbd, 0xfc, 0xbb,
    0xbb, 0x70, 0x6, 0x6b, 0xe0, 0x0, 0x0, 0x6,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x8, 0xe0, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x8,
    0xe0, 0x2, 0x33, 0x38, 0xf4, 0x33, 0x32, 0x0,
    0x0, 0x8, 0xe0, 0x34, 0x44, 0x48, 0xf5, 0x44,
    0x44, 0x30, 0x0, 0x8, 0xe0, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0xb, 0xf1, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xcd,
    0xbe, 0x40, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0,
    0xb, 0xe1, 0x7, 0xfb, 0x75, 0x43, 0x33, 0x44,
    0x56, 0x81, 0xc, 0x50, 0x0, 0x29, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x11, 0x0, 0x0, 0x0,

    /* U+914D "配" */
    0x1, 0x11, 0x11, 0x11, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0x1b, 0xff,
    0xff, 0xff, 0x90, 0x34, 0x4f, 0x5d, 0x84, 0x40,
    0x68, 0x88, 0x88, 0xe9, 0x0, 0x0, 0xf1, 0xc5,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x90, 0x25, 0x5f,
    0x6d, 0x95, 0x30, 0x0, 0x0, 0x0, 0xd9, 0x5,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0, 0xd,
    0x90, 0x5d, 0xc, 0x1d, 0x9, 0xa0, 0x0, 0x0,
    0x0, 0xd9, 0x5, 0xd0, 0xc0, 0xd0, 0x9a, 0x5,
    0x88, 0x88, 0x8e, 0x90, 0x5d, 0xd, 0xd, 0x9,
    0xa0, 0xbf, 0xff, 0xff, 0xf9, 0x5, 0xd2, 0xc0,
    0xd0, 0x9a, 0xb, 0xc0, 0x0, 0xd, 0x90, 0x5e,
    0xb5, 0x9, 0xdf, 0xa0, 0xbc, 0x0, 0x0, 0x43,
    0x5, 0xd4, 0x0, 0x0, 0x9a, 0xb, 0xc0, 0x0,
    0x0, 0x0, 0x5e, 0x22, 0x22, 0x2a, 0xa0, 0xbc,
    0x0, 0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xfa,
    0xb, 0xc0, 0x0, 0x0, 0x10, 0x5d, 0x0, 0x0,
    0x9, 0xa0, 0xbc, 0x0, 0x0, 0x1f, 0x35, 0xe1,
    0x11, 0x11, 0xaa, 0xb, 0xc0, 0x0, 0x3, 0xf3,
    0x5f, 0xff, 0xff, 0xff, 0xa0, 0xaf, 0x76, 0x66,
    0xbf, 0x15, 0xe2, 0x22, 0x22, 0xaa, 0x3, 0xdf,
    0xff, 0xff, 0x70, 0x5d, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+91CD "重" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x36,
    0x20, 0x0, 0x2, 0x77, 0x89, 0xab, 0xbd, 0xef,
    0xff, 0xe8, 0x0, 0x0, 0x2c, 0xbb, 0xa9, 0x8f,
    0xc5, 0x42, 0x0, 0x0, 0x0, 0x44, 0x44, 0x44,
    0x44, 0xfb, 0x44, 0x44, 0x44, 0x43, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0xe9, 0x22, 0x22, 0xfa,
    0x22, 0x22, 0xae, 0x0, 0x0, 0xe, 0x91, 0x11,
    0x1f, 0x91, 0x11, 0x19, 0xe0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0xe, 0x80, 0x0, 0xe, 0x90, 0x0, 0x9, 0xe0,
    0x0, 0x0, 0xef, 0xee, 0xee, 0xff, 0xee, 0xee,
    0xfe, 0x0, 0x0, 0x3, 0x33, 0x33, 0x3f, 0xa3,
    0x33, 0x33, 0x30, 0x0, 0x1, 0x33, 0x33, 0x33,
    0xfa, 0x33, 0x33, 0x33, 0x20, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x11, 0x1f, 0x91, 0x11, 0x11,
    0x11, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe,

    /* U+91CF "量" */
    0x0, 0x7, 0xfe, 0xee, 0xee, 0xee, 0xee, 0xef,
    0x70, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x70, 0x0, 0x0, 0x7, 0xfe, 0xee,
    0xee, 0xee, 0xee, 0xef, 0x70, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x0, 0x6, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0x60, 0x0, 0x3, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x30, 0xe, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xe0, 0x0, 0x4,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x50, 0x0,
    0x0, 0xd, 0xd9, 0x99, 0x9e, 0xe9, 0x99, 0x9c,
    0xf0, 0x0, 0x0, 0xd, 0xa2, 0x22, 0x2c, 0xb2,
    0x22, 0x28, 0xf0, 0x0, 0x0, 0xd, 0xec, 0xcc,
    0xcf, 0xec, 0xcc, 0xce, 0xf0, 0x0, 0x0, 0xd,
    0xa1, 0x11, 0x1c, 0xb1, 0x11, 0x18, 0xf0, 0x0,
    0x0, 0xb, 0xdd, 0xdd, 0xdf, 0xfd, 0xdd, 0xdd,
    0xd0, 0x0, 0x0, 0x1, 0x11, 0x11, 0x1c, 0xb1,
    0x11, 0x11, 0x10, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1,

    /* U+932F "錯" */
    0x0, 0x0, 0x86, 0x0, 0x0, 0x3c, 0x10, 0x5,
    0xb0, 0x0, 0x0, 0x3, 0xfa, 0x0, 0x0, 0x4f,
    0x20, 0x7, 0xe0, 0x0, 0x0, 0xd, 0xdf, 0xc1,
    0x2, 0x6f, 0x42, 0x28, 0xf2, 0x10, 0x0, 0xbf,
    0x22, 0xde, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x1b, 0xf5, 0x0, 0x1c, 0x72, 0x6f, 0x42, 0x28,
    0xf2, 0x10, 0x4f, 0xeb, 0xbb, 0xb5, 0x0, 0x4f,
    0x20, 0x7, 0xe0, 0x0, 0x6, 0xac, 0xfd, 0xc5,
    0x0, 0x4f, 0x20, 0x7, 0xe0, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x1, 0x11, 0xf6, 0x11, 0x15, 0x55, 0x55, 0x55,
    0x55, 0x51, 0xf, 0xff, 0xff, 0xff, 0x1, 0x33,
    0x33, 0x33, 0x33, 0x0, 0x1, 0x11, 0xf5, 0x11,
    0x5, 0xff, 0xff, 0xff, 0xff, 0x0, 0x5, 0x60,
    0xe5, 0x5a, 0x5, 0xf0, 0x0, 0x0, 0x6f, 0x0,
    0x5, 0xc0, 0xe5, 0x98, 0x5, 0xf0, 0x0, 0x0,
    0x5f, 0x0, 0x1, 0xf0, 0xe5, 0xd3, 0x5, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0xe2, 0xe5, 0xb0,
    0x5, 0xf4, 0x44, 0x44, 0x8f, 0x0, 0x0, 0x0,
    0xe8, 0x8c, 0x15, 0xf0, 0x0, 0x0, 0x5f, 0x0,
    0x6, 0xad, 0xff, 0xea, 0x5, 0xf5, 0x55, 0x55,
    0x9f, 0x0, 0xf, 0xd9, 0x62, 0x0, 0x5, 0xfe,
    0xee, 0xee, 0xff, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+9519 "错" */
    0x0, 0x6, 0x60, 0x0, 0x0, 0x2c, 0x20, 0xc,
    0x40, 0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x2f,
    0x30, 0xf, 0x50, 0x0, 0x0, 0x6f, 0x86, 0x66,
    0x2, 0x4f, 0x52, 0x2f, 0x72, 0x10, 0x1, 0xef,
    0xff, 0xff, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0xb, 0xe1, 0x0, 0x0, 0x2, 0x4f, 0x52, 0x2f,
    0x72, 0x10, 0x1e, 0x50, 0x0, 0x0, 0x0, 0x2f,
    0x30, 0xf, 0x50, 0x0, 0x2, 0xdf, 0xff, 0xfa,
    0x0, 0x2f, 0x30, 0xf, 0x50, 0x0, 0x0, 0x8a,
    0xfc, 0xa7, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0xf6, 0x0, 0x35, 0x55, 0x55, 0x55,
    0x55, 0x50, 0x0, 0x0, 0xf6, 0x0, 0x1, 0x44,
    0x44, 0x44, 0x43, 0x0, 0xb, 0xff, 0xff, 0xff,
    0x27, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x5, 0x66,
    0xfa, 0x66, 0x17, 0xf0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x0, 0xf6, 0x0, 0x7, 0xf0, 0x0, 0x0,
    0x9d, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0xf6, 0x4,
    0x7, 0xf4, 0x44, 0x44, 0xbd, 0x0, 0x0, 0x0,
    0xfa, 0xce, 0x7, 0xf0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x3, 0xff, 0xd3, 0x7, 0xf5, 0x55, 0x55,
    0xbd, 0x0, 0x0, 0xb, 0xf8, 0x0, 0x7, 0xfe,
    0xee, 0xee, 0xfd, 0x0, 0x0, 0x4, 0x40, 0x0,
    0x7, 0xf0, 0x0, 0x0, 0x9d, 0x0,

    /* U+9589 "閉" */
    0x6f, 0xff, 0xff, 0xfc, 0x1, 0xff, 0xff, 0xff,
    0xd6, 0xf4, 0x33, 0x3a, 0xd0, 0x2f, 0x63, 0x33,
    0xbe, 0x6f, 0x21, 0x11, 0x9d, 0x2, 0xf4, 0x11,
    0x1b, 0xe6, 0xff, 0xff, 0xff, 0xd0, 0x2f, 0xff,
    0xff, 0xfe, 0x6f, 0x10, 0x0, 0x9d, 0x2, 0xf3,
    0x0, 0xa, 0xe6, 0xf4, 0x33, 0x3a, 0xd0, 0x2f,
    0x52, 0x22, 0xbe, 0x6f, 0xff, 0xff, 0xfc, 0x2,
    0xff, 0xff, 0xff, 0xe6, 0xf1, 0x0, 0x0, 0x0,
    0x5b, 0x0, 0x0, 0xae, 0x6f, 0x10, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0xa, 0xe6, 0xf1, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xae, 0x6f, 0x10, 0x55,
    0x55, 0x8f, 0xf5, 0x55, 0xa, 0xe6, 0xf1, 0x0,
    0x0, 0x2e, 0xee, 0x0, 0x0, 0xae, 0x6f, 0x10,
    0x0, 0x4e, 0xa7, 0xe0, 0x0, 0xa, 0xe6, 0xf1,
    0x0, 0x8f, 0x90, 0x7e, 0x0, 0x0, 0xae, 0x6f,
    0x14, 0xdf, 0x60, 0x7, 0xe0, 0x0, 0xa, 0xe6,
    0xf1, 0x1a, 0x20, 0x23, 0x9e, 0x0, 0x0, 0xae,
    0x6f, 0x10, 0x0, 0x7, 0xff, 0x80, 0x57, 0x7d,
    0xd6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0xe6, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+958B "開" */
    0x6f, 0xff, 0xff, 0xfd, 0x5, 0xff, 0xff, 0xff,
    0xd7, 0xf3, 0x33, 0x3a, 0xd0, 0x6f, 0x33, 0x33,
    0xae, 0x7f, 0x21, 0x11, 0x9d, 0x6, 0xf2, 0x11,
    0x1a, 0xe7, 0xff, 0xff, 0xff, 0xd0, 0x6f, 0xff,
    0xff, 0xfe, 0x7f, 0x0, 0x0, 0x9d, 0x6, 0xf0,
    0x0, 0x9, 0xe7, 0xf4, 0x33, 0x3a, 0xd0, 0x6f,
    0x33, 0x33, 0xae, 0x7f, 0xff, 0xff, 0xfd, 0x5,
    0xff, 0xff, 0xff, 0xe7, 0xf0, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x10, 0x9e, 0x7f, 0x3, 0xff, 0xff,
    0xff, 0xff, 0xfb, 0x9, 0xe7, 0xf0, 0x1, 0x1f,
    0x51, 0x1f, 0x71, 0x0, 0x9e, 0x7f, 0x0, 0x0,
    0xf4, 0x0, 0xe6, 0x0, 0x9, 0xe7, 0xf0, 0x25,
    0x5f, 0x85, 0x5f, 0xa5, 0x50, 0x9e, 0x7f, 0x8,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x29, 0xe7, 0xf0,
    0x0, 0x3f, 0x20, 0xe, 0x60, 0x0, 0x9e, 0x7f,
    0x0, 0x8, 0xe0, 0x0, 0xe6, 0x0, 0x9, 0xe7,
    0xf0, 0x2, 0xf8, 0x0, 0xe, 0x60, 0x0, 0x9e,
    0x7f, 0x2, 0xee, 0x0, 0x0, 0xe6, 0x17, 0x7c,
    0xd7, 0xf0, 0xa, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+9593 "間" */
    0x6f, 0xff, 0xff, 0xff, 0x6, 0xff, 0xff, 0xff,
    0xd6, 0xf4, 0x33, 0x37, 0xf1, 0x6f, 0x33, 0x33,
    0xbe, 0x6f, 0x21, 0x11, 0x6f, 0x16, 0xf1, 0x11,
    0x1b, 0xe6, 0xff, 0xff, 0xff, 0xf1, 0x6f, 0xff,
    0xff, 0xfe, 0x6f, 0x10, 0x0, 0x5f, 0x16, 0xf0,
    0x0, 0xa, 0xe6, 0xf4, 0x33, 0x37, 0xf1, 0x6f,
    0x22, 0x22, 0xbe, 0x6f, 0xff, 0xff, 0xff, 0x6,
    0xff, 0xff, 0xff, 0xe6, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xae, 0x6f, 0x10, 0x4, 0x65,
    0x55, 0x55, 0x30, 0xa, 0xe6, 0xf1, 0x0, 0xcf,
    0xdd, 0xdd, 0xfb, 0x0, 0xae, 0x6f, 0x10, 0xc,
    0x90, 0x0, 0xf, 0xb0, 0xa, 0xe6, 0xf1, 0x0,
    0xcb, 0x55, 0x55, 0xfb, 0x0, 0xae, 0x6f, 0x10,
    0xc, 0xfd, 0xdd, 0xdf, 0xb0, 0xa, 0xe6, 0xf1,
    0x0, 0xc9, 0x0, 0x0, 0xfb, 0x0, 0xae, 0x6f,
    0x10, 0xc, 0xb3, 0x33, 0x3f, 0xb0, 0xa, 0xe6,
    0xf1, 0x0, 0xcf, 0xff, 0xff, 0xfa, 0x0, 0xae,
    0x6f, 0x10, 0xc, 0x90, 0x0, 0x0, 0x37, 0x7d,
    0xd6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0xe6, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+95DC "關" */
    0x6f, 0xff, 0xff, 0xfd, 0x2, 0xff, 0xff, 0xff,
    0xf6, 0x7f, 0x22, 0x22, 0x9e, 0x2, 0xf3, 0x22,
    0x23, 0xf6, 0x7f, 0x22, 0x22, 0x9e, 0x2, 0xf3,
    0x22, 0x23, 0xf6, 0x7f, 0xee, 0xee, 0xfe, 0x2,
    0xfe, 0xee, 0xee, 0xf6, 0x7f, 0x0, 0x0, 0x8e,
    0x2, 0xf1, 0x0, 0x0, 0xf6, 0x7f, 0xff, 0xff,
    0xfe, 0x2, 0xff, 0xff, 0xff, 0xf6, 0x7f, 0x22,
    0x2d, 0x52, 0x0, 0x7b, 0x22, 0x23, 0xf6, 0x7f,
    0x0, 0x9a, 0x19, 0x12, 0xe3, 0x74, 0x0, 0xf6,
    0x7f, 0x7, 0xfc, 0xe9, 0xe, 0xed, 0xd1, 0x0,
    0xf6, 0x7f, 0x1, 0x3c, 0x97, 0x2, 0x7d, 0x81,
    0x0, 0xf6, 0x7f, 0x4, 0xdc, 0x8f, 0x38, 0xf9,
    0xc9, 0x0, 0xf6, 0x7f, 0x5, 0x97, 0x59, 0x7b,
    0x86, 0x4c, 0x0, 0xf6, 0x7f, 0x0, 0xb1, 0xf,
    0x49, 0x80, 0x75, 0x0, 0xf6, 0x7f, 0x0, 0xe1,
    0xf, 0x49, 0x80, 0x97, 0x0, 0xf6, 0x7f, 0x0,
    0xee, 0xef, 0x39, 0xfe, 0xf7, 0x0, 0xf6, 0x7f,
    0x0, 0x0, 0x8f, 0x19, 0x80, 0x64, 0x0, 0xf6,
    0x7f, 0x0, 0x2a, 0xf7, 0x9, 0x80, 0x3, 0x67,
    0xf6, 0x7f, 0x0, 0xb, 0x40, 0x0, 0x0, 0x4,
    0xff, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+95ED "闭" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf4, 0x0, 0x57, 0x77, 0x77, 0x77,
    0x77, 0x83, 0x0, 0xbf, 0x40, 0xae, 0xee, 0xee,
    0xee, 0xee, 0xf7, 0x0, 0xc, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x0, 0x0, 0xf7, 0x3e, 0x30, 0x0,
    0x0, 0x0, 0xae, 0x0, 0x0, 0xf7, 0x3f, 0x40,
    0x33, 0x33, 0x33, 0xbf, 0x33, 0x20, 0xf7, 0x3f,
    0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xf7,
    0x3f, 0x40, 0x33, 0x33, 0x3c, 0xff, 0x33, 0x20,
    0xf7, 0x3f, 0x40, 0x0, 0x0, 0x6f, 0xee, 0x0,
    0x0, 0xf7, 0x3f, 0x40, 0x0, 0x5, 0xf9, 0xae,
    0x0, 0x0, 0xf7, 0x3f, 0x40, 0x0, 0x5f, 0xb0,
    0xae, 0x0, 0x0, 0xf7, 0x3f, 0x40, 0x9, 0xfa,
    0x0, 0xae, 0x0, 0x0, 0xf7, 0x3f, 0x44, 0xdf,
    0x70, 0x0, 0xae, 0x0, 0x0, 0xf7, 0x3f, 0x47,
    0xd3, 0x0, 0x0, 0xae, 0x0, 0x0, 0xf7, 0x3f,
    0x40, 0x0, 0x3, 0x77, 0xde, 0x0, 0x0, 0xf7,
    0x3f, 0x40, 0x0, 0x3, 0xff, 0xd6, 0x0, 0x0,
    0xf7, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x66, 0xf7, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xc1,

    /* U+95EE "问" */
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xd1, 0x0, 0x57, 0x77, 0x77, 0x77,
    0x77, 0x82, 0x1, 0xdd, 0x10, 0xaf, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x2e, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf5, 0x0, 0x4, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf5, 0x2e, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf5, 0x2f, 0x50,
    0x8, 0xff, 0xff, 0xff, 0x60, 0x2, 0xf5, 0x2f,
    0x50, 0x9, 0xe6, 0x66, 0x6f, 0x70, 0x2, 0xf5,
    0x2f, 0x50, 0x9, 0xd0, 0x0, 0xf, 0x70, 0x2,
    0xf5, 0x2f, 0x50, 0x9, 0xd0, 0x0, 0xf, 0x70,
    0x2, 0xf5, 0x2f, 0x50, 0x9, 0xd0, 0x0, 0xf,
    0x70, 0x2, 0xf5, 0x2f, 0x50, 0x9, 0xd0, 0x0,
    0xf, 0x70, 0x2, 0xf5, 0x2f, 0x50, 0x9, 0xff,
    0xff, 0xff, 0x70, 0x2, 0xf5, 0x2f, 0x50, 0x9,
    0xe6, 0x66, 0x66, 0x30, 0x2, 0xf5, 0x2f, 0x50,
    0x6, 0x90, 0x0, 0x0, 0x0, 0x2, 0xf5, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf5,
    0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x37, 0x79,
    0xf5, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xff, 0xb1, 0x2f, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+96FB "電" */
    0x0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xcc, 0xcc, 0xcc,
    0xcf, 0xfc, 0xcc, 0xcc, 0xcc, 0x60, 0x7f, 0x55,
    0x55, 0x55, 0xce, 0x55, 0x55, 0x55, 0xf8, 0x7,
    0xe0, 0x22, 0x22, 0xb, 0xd0, 0x22, 0x22, 0xe,
    0x80, 0x7e, 0xc, 0xcc, 0xc3, 0xbd, 0x1c, 0xcc,
    0xc3, 0xe8, 0x1, 0x20, 0x11, 0x11, 0xb, 0xd0,
    0x11, 0x11, 0x12, 0x10, 0x0, 0x6d, 0xdd, 0xd3,
    0xac, 0x1d, 0xdd, 0xda, 0x0, 0x0, 0x2, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x20, 0x0, 0x0,
    0xbf, 0xee, 0xee, 0xff, 0xee, 0xee, 0xfd, 0x0,
    0x0, 0xb, 0xc0, 0x0, 0xc, 0xb0, 0x0, 0x7,
    0xd0, 0x0, 0x0, 0xbf, 0xee, 0xee, 0xff, 0xee,
    0xee, 0xfd, 0x0, 0x0, 0xb, 0xc1, 0x11, 0x1c,
    0xc1, 0x11, 0x18, 0xd0, 0x0, 0x0, 0xbc, 0x22,
    0x22, 0xcc, 0x22, 0x22, 0x8d, 0x0, 0x0, 0xb,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc1, 0xb1,
    0x0, 0xbb, 0x0, 0x0, 0xbe, 0x43, 0x33, 0x33,
    0x8f, 0x10, 0x0, 0x0, 0x0, 0x4, 0xdf, 0xff,
    0xff, 0xff, 0x80,

    /* U+9759 "静" */
    0x0, 0x2, 0xc2, 0x0, 0x0, 0x8, 0x60, 0x0,
    0x0, 0x1, 0x11, 0x4f, 0x41, 0x11, 0x1, 0xf6,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xa0,
    0x9f, 0xff, 0xff, 0x10, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x4f, 0x61, 0x1c, 0xb0, 0x0, 0x3e, 0xee,
    0xfe, 0xee, 0x7e, 0xb0, 0x5, 0xf2, 0x0, 0x0,
    0x33, 0x5f, 0x53, 0x36, 0xf8, 0x77, 0xfc, 0x77,
    0x0, 0x11, 0x14, 0xf4, 0x11, 0x1a, 0xff, 0xff,
    0xff, 0xf2, 0xf, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0xe, 0x80, 0xf, 0x20, 0x11, 0x11, 0x11, 0x11,
    0x10, 0x0, 0xe7, 0x0, 0xf2, 0x0, 0xcf, 0xff,
    0xff, 0xd9, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xc,
    0x92, 0x22, 0x9d, 0x23, 0x33, 0xf9, 0x33, 0xf5,
    0x10, 0xca, 0x33, 0x3a, 0xd0, 0x0, 0xe, 0x70,
    0xf, 0x20, 0xc, 0xed, 0xdd, 0xed, 0x3, 0x44,
    0xfa, 0x44, 0xf2, 0x0, 0xc8, 0x0, 0x8, 0xd0,
    0x8c, 0xcf, 0xec, 0xcf, 0x20, 0xc, 0xff, 0xff,
    0xfd, 0x0, 0x0, 0xe7, 0x0, 0x81, 0x0, 0xc9,
    0x11, 0x19, 0xd0, 0x0, 0xe, 0x70, 0x0, 0x0,
    0xc, 0x80, 0x0, 0x8d, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x0, 0xc8, 0x1, 0x3a, 0xd0, 0x25, 0x5f,
    0x70, 0x0, 0x0, 0xc, 0x80, 0x4f, 0xe7, 0x1,
    0xff, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+975C "靜" */
    0x0, 0x2, 0xc2, 0x0, 0x0, 0x0, 0x0, 0x26,
    0x80, 0x1, 0x11, 0x4f, 0x41, 0x12, 0x78, 0xad,
    0xff, 0xeb, 0x30, 0x8f, 0xff, 0xff, 0xff, 0xaa,
    0x97, 0x84, 0x10, 0x24, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0xc3, 0xe, 0x70, 0xa, 0xd0, 0x3e, 0xee,
    0xfe, 0xee, 0x4a, 0xb0, 0x8d, 0x1, 0xf5, 0x0,
    0x33, 0x5f, 0x53, 0x30, 0x4f, 0x3, 0x90, 0x8d,
    0x0, 0x55, 0x57, 0xf7, 0x55, 0x53, 0x75, 0x55,
    0x5a, 0x92, 0xd, 0xdd, 0xdd, 0xdd, 0xdc, 0x8f,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe7, 0x0, 0xf6, 0x0, 0xcf, 0xff,
    0xff, 0xd2, 0x33, 0x3f, 0x93, 0x3f, 0x81, 0xc,
    0x92, 0x22, 0x9d, 0xaf, 0xff, 0xff, 0xff, 0xff,
    0x90, 0xca, 0x33, 0x3a, 0xd2, 0x33, 0x3f, 0x93,
    0x3f, 0x81, 0xc, 0xed, 0xdd, 0xed, 0x0, 0x0,
    0xe7, 0x0, 0xf6, 0x0, 0xc8, 0x0, 0x8, 0xd0,
    0x8e, 0xef, 0xfe, 0xef, 0x60, 0xc, 0xff, 0xff,
    0xfd, 0x1, 0x22, 0xf8, 0x22, 0xf6, 0x0, 0xc9,
    0x11, 0x19, 0xd0, 0x0, 0xe, 0x70, 0x0, 0x0,
    0xc, 0x80, 0x0, 0x8d, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x0, 0xc8, 0x1, 0x3a, 0xd0, 0x14, 0x4f,
    0x70, 0x0, 0x0, 0xc, 0x80, 0x4f, 0xf7, 0x1,
    0xff, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+97F3 "音" */
    0x0, 0x0, 0x0, 0x1, 0xd7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x4, 0x66, 0xaa, 0x66, 0x66,
    0x66, 0x9c, 0x76, 0x50, 0x0, 0x0, 0xbe, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x60, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x44, 0x44,
    0x4f, 0xa4, 0x44, 0x4b, 0xf5, 0x44, 0x44, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x0, 0x2, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x20, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x2f, 0x62, 0x22, 0x22,
    0x22, 0x24, 0xf5, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x2f,
    0x84, 0x44, 0x44, 0x44, 0x46, 0xf5, 0x0, 0x0,
    0x2f, 0x50, 0x0, 0x0, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0x2f, 0x84, 0x44, 0x44, 0x44, 0x46, 0xf5,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf5, 0x0, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+97FF "響" */
    0x0, 0x47, 0x0, 0x0, 0xd5, 0x0, 0x2, 0x22,
    0x21, 0x0, 0x2e, 0x42, 0x8, 0xbe, 0xea, 0x92,
    0xff, 0xff, 0xd0, 0x2d, 0xb6, 0xe4, 0xc9, 0x22,
    0x6e, 0x2f, 0x10, 0xe6, 0x8, 0xbc, 0xf4, 0xc,
    0xed, 0xde, 0xe2, 0xf1, 0x7c, 0x0, 0x5, 0xd3,
    0x3e, 0xc7, 0x0, 0x4e, 0x2f, 0x16, 0xe2, 0x8,
    0xfe, 0xdf, 0x8c, 0xfe, 0xee, 0xe2, 0xf1, 0x6,
    0xd0, 0x22, 0x8, 0xc0, 0xc7, 0x4, 0xf8, 0x2f,
    0x10, 0x2f, 0x10, 0x1b, 0xb0, 0x3f, 0xff, 0xd9,
    0xe8, 0xf4, 0xdf, 0xb0, 0x8e, 0x60, 0x1, 0x94,
    0xa9, 0x2, 0x4f, 0x13, 0x30, 0x1, 0xb, 0xdd,
    0xdd, 0xdf, 0xfd, 0xdd, 0xed, 0xd3, 0x0, 0x0,
    0x23, 0x4f, 0x73, 0x33, 0x35, 0xf7, 0x33, 0x0,
    0x1, 0x11, 0x11, 0xbc, 0x11, 0x11, 0xbc, 0x11,
    0x11, 0x10, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x10, 0x0, 0x0, 0x1f, 0xa7,
    0x77, 0x77, 0x77, 0x78, 0xf4, 0x0, 0x0, 0x1,
    0xfd, 0xbb, 0xbb, 0xbb, 0xbb, 0xcf, 0x40, 0x0,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x0, 0x0, 0x1, 0xfe, 0xee, 0xee, 0xee, 0xee,
    0xef, 0x40, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+AC00 "가" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x5, 0x66, 0x66, 0x67, 0x73, 0x0, 0xaf,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0x60, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfa,
    0x0, 0xa, 0xf3, 0x32, 0x0, 0x0, 0x0, 0x8f,
    0x30, 0x0, 0xaf, 0xff, 0xe0, 0x0, 0x0, 0x2f,
    0xb0, 0x0, 0xa, 0xf3, 0x32, 0x0, 0x0, 0x1d,
    0xf2, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x1c,
    0xf5, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x3d,
    0xf6, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x8f,
    0xf5, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x6f,
    0xb2, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0,

    /* U+AC04 "간" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x68, 0x0,
    0x0, 0x22, 0x22, 0x22, 0x23, 0x10, 0xb, 0xf0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xbf,
    0x0, 0x0, 0x33, 0x33, 0x33, 0x7f, 0x60, 0xb,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed, 0x0,
    0xb, 0xf1, 0x10, 0x0, 0x0, 0x0, 0x9f, 0x40,
    0x0, 0xbf, 0xff, 0xa0, 0x0, 0x0, 0x8f, 0x90,
    0x0, 0xb, 0xf5, 0x53, 0x0, 0x1, 0xaf, 0xa0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x18, 0xff, 0x80,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0x8f, 0xfb, 0x30,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x4, 0x93, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x7,
    0x40, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x1,
    0xf9, 0x0, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0,

    /* U+AC10 "감" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x80,
    0x0, 0x2, 0x55, 0x55, 0x55, 0x75, 0x0, 0xc,
    0xe0, 0x0, 0x6, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0xc, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfb,
    0x0, 0xc, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf7, 0x0, 0xc, 0xf2, 0x21, 0x0, 0x0, 0x0,
    0xc, 0xf1, 0x0, 0xc, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x9f, 0x60, 0x0, 0xc, 0xf3, 0x32, 0x0,
    0x0, 0xa, 0xf9, 0x0, 0x0, 0xc, 0xe0, 0x0,
    0x0, 0x6, 0xef, 0x70, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0xa, 0xff, 0xc3, 0x0, 0x0, 0x0, 0xc,
    0xe0, 0x0, 0xa, 0x93, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xa0, 0x0, 0x0, 0x3, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x60, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x9,
    0xf1, 0x0, 0x0, 0x0, 0xb, 0xe0, 0x0, 0x0,
    0x9, 0xf1, 0x0, 0x0, 0x0, 0xb, 0xe0, 0x0,
    0x0, 0x9, 0xf6, 0x55, 0x55, 0x55, 0x5d, 0xe0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0,

    /* U+AC70 "거" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x85,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x2, 0x66, 0x66, 0x66, 0x75, 0x0, 0x0, 0xfa,
    0x6, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0x44, 0x44, 0xfa,
    0x0, 0x0, 0x0, 0x2f, 0xa3, 0xff, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0xbf, 0x20, 0x11, 0x11, 0xfa,
    0x0, 0x0, 0x7, 0xf9, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x6f, 0xc0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x9, 0xfc, 0x10, 0x0, 0x0, 0x0, 0xfa,
    0x5, 0xdf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0xe, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,

    /* U+ACAC "견" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x80,
    0x3, 0x44, 0x44, 0x44, 0x42, 0x0, 0xd, 0xd0,
    0xd, 0xff, 0xff, 0xff, 0xf9, 0x0, 0xd, 0xd0,
    0x1, 0x11, 0x11, 0x15, 0xf7, 0x0, 0xd, 0xd0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x1e, 0xd6, 0x66, 0x6e, 0xd0,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0xd, 0xd0,
    0x0, 0x0, 0xa, 0xf7, 0x0, 0x0, 0xd, 0xd0,
    0x0, 0x3, 0xdf, 0x80, 0x9f, 0xff, 0xff, 0xd0,
    0x3, 0xaf, 0xe5, 0x0, 0x36, 0x66, 0x6e, 0xd0,
    0x8f, 0xe8, 0x0, 0x0, 0x0, 0x0, 0xd, 0xd0,
    0x15, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xd0,
    0x0, 0x5, 0x90, 0x0, 0x0, 0x0, 0xd, 0xd0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x9, 0x90,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+ACB0 "결" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80,
    0xa, 0xaa, 0xaa, 0xab, 0xa3, 0x0, 0xc, 0xe0,
    0xb, 0xbb, 0xbb, 0xbe, 0xf3, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x4f, 0xc5, 0x55, 0x5d, 0xe0,
    0x0, 0x0, 0x0, 0xdf, 0x30, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x1c, 0xf7, 0x25, 0x55, 0x5d, 0xe0,
    0x0, 0x6, 0xef, 0x70, 0x7f, 0xff, 0xff, 0xe0,
    0x38, 0xef, 0xc3, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0xaf, 0xa4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xb0,
    0x10, 0x4, 0x66, 0x66, 0x66, 0x66, 0x66, 0x50,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x3, 0x44, 0x44, 0x44, 0x44, 0x4d, 0xe0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xfc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc6,

    /* U+ACBD "경" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x70,
    0x22, 0x22, 0x22, 0x34, 0x10, 0x0, 0xce, 0xd,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0xc, 0xe0, 0x22,
    0x22, 0x22, 0x7f, 0x83, 0x33, 0xde, 0x0, 0x0,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x1, 0xec, 0x22, 0x22, 0xde, 0x0, 0x0, 0x0,
    0xbf, 0x30, 0x0, 0xc, 0xe0, 0x0, 0x0, 0xaf,
    0x63, 0x66, 0x66, 0xee, 0x0, 0x4, 0xdf, 0x70,
    0x7f, 0xff, 0xff, 0xe1, 0x6c, 0xfd, 0x30, 0x0,
    0x0, 0x0, 0xce, 0x8f, 0xc5, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xe0, 0x20, 0x0, 0x2, 0x57, 0x75,
    0x20, 0x44, 0x0, 0x0, 0x5d, 0xff, 0xee, 0xff,
    0xd5, 0x0, 0x0, 0x6f, 0xb3, 0x0, 0x0, 0x3b,
    0xf6, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0, 0xd,
    0xd0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0xb, 0xf3, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x2d, 0xfb, 0x75, 0x57, 0xbf, 0xd1, 0x0,
    0x0, 0x6, 0xbe, 0xff, 0xeb, 0x60, 0x0,

    /* U+ACE0 "고" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x6, 0x66, 0x66, 0x66, 0x66, 0x67, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x3f, 0x70, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x99, 0x99,
    0x99, 0xdf, 0x99, 0x99, 0x99, 0x99, 0x3c, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc4,

    /* U+ACF5 "공" */
    0x0, 0x56, 0x66, 0x66, 0x66, 0x66, 0x67, 0x30,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x1, 0xf9, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x90,
    0x0, 0x6c, 0x10, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x84, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x52, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x29,
    0xdf, 0xff, 0xff, 0xb5, 0x0, 0x0, 0x0, 0x5f,
    0xe8, 0x42, 0x23, 0x6b, 0xfb, 0x0, 0x0, 0xf,
    0xc0, 0x0, 0x0, 0x0, 0x6, 0xf6, 0x0, 0x2,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0xf, 0x90, 0x0,
    0xe, 0xd1, 0x0, 0x0, 0x0, 0x8, 0xf6, 0x0,
    0x0, 0x4f, 0xfa, 0x65, 0x45, 0x8d, 0xf9, 0x0,
    0x0, 0x0, 0x17, 0xbe, 0xff, 0xfd, 0x93, 0x0,
    0x0,

    /* U+ACFC "과" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x2, 0x66, 0x66, 0x66, 0x67, 0x40,
    0xf, 0xa0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff,
    0xb0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xb0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xb0, 0xf, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xa0, 0xf, 0xa0, 0x0, 0x0,
    0x0, 0x36, 0x0, 0xf, 0x90, 0xf, 0xa0, 0x0,
    0x0, 0x0, 0x9f, 0x10, 0x2f, 0x70, 0xf, 0xff,
    0xf8, 0x0, 0x0, 0x9f, 0x10, 0x4f, 0x50, 0xf,
    0xd7, 0x73, 0x0, 0x0, 0x9f, 0x10, 0x28, 0x20,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x1, 0x23, 0xf, 0xa0, 0x0, 0x4c, 0xcd, 0xef,
    0xef, 0xff, 0xff, 0xf, 0xa0, 0x0, 0x29, 0x99,
    0x88, 0x76, 0x53, 0x20, 0xf, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0,

    /* U+AD6C "구" */
    0x1, 0x55, 0x55, 0x55, 0x55, 0x55, 0x65, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x9a, 0xfc, 0x99, 0x3c, 0xcc, 0xcc, 0xcc,
    0xff, 0xcc, 0xcc, 0xcc, 0xc4, 0x0, 0x0, 0x0,
    0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0,

    /* U+ADF8 "그" */
    0x1, 0x66, 0x66, 0x66, 0x66, 0x66, 0x77, 0x10,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+AE30 "기" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x5,
    0x66, 0x66, 0x66, 0x73, 0x0, 0xb, 0xf0, 0xcf,
    0xff, 0xff, 0xff, 0x90, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0xb, 0xf0, 0x0, 0x0,
    0x0, 0x4f, 0x50, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x8, 0xf2, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0xdd, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x5f,
    0x70, 0x0, 0xb, 0xf0, 0x0, 0x0, 0xe, 0xe0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0xb, 0xf5, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0xa, 0xf9, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x1b, 0xfa, 0x0, 0x0, 0x0,
    0xb, 0xf0, 0x6e, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x6f, 0xd4, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf0,

    /* U+B044 "끄" */
    0x4, 0x66, 0x67, 0x61, 0x36, 0x66, 0x67, 0x30,
    0x0, 0xbf, 0xff, 0xff, 0x37, 0xff, 0xff, 0xf7,
    0x0, 0x0, 0x0, 0x7, 0xf2, 0x0, 0x0, 0x2f,
    0x70, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x2,
    0xf7, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x4, 0xf6, 0x0, 0x0, 0x0, 0xd, 0xd0, 0x0,
    0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0xfa, 0x0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0x3f, 0x70,
    0x0, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0xc, 0xe0, 0x0, 0x0, 0x0, 0x49,
    0x0, 0x0, 0x0, 0x77, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+B098 "나" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x8, 0x40, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf5, 0x54, 0x1f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xe1, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf1, 0x10, 0x1f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x0, 0x1, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x1f, 0xa3,
    0x45, 0x68, 0xad, 0xb0, 0xaf, 0x0, 0x2, 0xff,
    0xff, 0xff, 0xec, 0xa6, 0xa, 0xf0, 0x0, 0x2,
    0x22, 0x21, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0,

    /* U+B124 "네" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x9, 0x50, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x66, 0x66, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0xff, 0xff, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0x90, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x1f, 0xc7, 0x89, 0xbd, 0x80, 0xf9, 0x1, 0xf8,
    0x1f, 0xff, 0xed, 0xc9, 0x40, 0xf9, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb6, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf8,

    /* U+B155 "녕" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x67, 0x54,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xce, 0xeb, 0x0,
    0x0, 0x5, 0x66, 0x66, 0xde, 0xeb, 0x0, 0x0,
    0xd, 0xff, 0xff, 0xfe, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xce, 0xeb, 0x0, 0x0, 0x3, 0x33,
    0x33, 0xde, 0xeb, 0x0, 0x0, 0xd, 0xff, 0xff,
    0xfe, 0xeb, 0x0, 0x0, 0x1, 0x11, 0x11, 0xce,
    0xeb, 0x0, 0x1, 0x24, 0x73, 0x0, 0xce, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0xce, 0x66, 0x66,
    0x54, 0x31, 0x0, 0x0, 0xce, 0x0, 0x0, 0x0,
    0x34, 0x43, 0x0, 0x77, 0x0, 0x4, 0xcf, 0xff,
    0xff, 0xfb, 0x30, 0x0, 0x7f, 0xc5, 0x21, 0x12,
    0x6d, 0xf4, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x1,
    0xec, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x0, 0xde, 0x20, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x3e, 0xfa, 0x65, 0x57, 0xbf, 0xd2, 0x0, 0x1,
    0x7c, 0xef, 0xfe, 0xb6, 0x0,

    /* U+B294 "는" */
    0x0, 0x9, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x0, 0x4,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x52, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x52, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xd5, 0x55, 0x55, 0x55, 0x55, 0x53, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0,

    /* U+B2A5 "능" */
    0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xf9, 0x99, 0x99, 0x99,
    0x99, 0x94, 0x0, 0x0, 0x9c, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x10, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x8d, 0xff, 0xff, 0xea, 0x40, 0x0, 0x0, 0x4,
    0xfe, 0x95, 0x33, 0x47, 0xdf, 0x80, 0x0, 0x0,
    0xde, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x20, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x5, 0xf5, 0x0,
    0x0, 0xde, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x20,
    0x0, 0x3, 0xef, 0xa6, 0x54, 0x68, 0xef, 0x70,
    0x0, 0x0, 0x1, 0x7b, 0xef, 0xff, 0xc9, 0x20,
    0x0, 0x0,

    /* U+B2C8 "니" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xeb, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xeb, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xeb, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0xeb, 0x0, 0x0,
    0x2, 0x47, 0x20, 0xeb, 0xff, 0xcd, 0xde, 0xff,
    0xff, 0x40, 0xeb, 0xab, 0xaa, 0x98, 0x64, 0x20,
    0x0, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb,

    /* U+B2E4 "다" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xf4, 0x0, 0xaf,
    0x0, 0x1, 0xfb, 0x66, 0x66, 0x66, 0x10, 0xa,
    0xf0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf6, 0x66, 0x1f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xff, 0xf1, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x1f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x0, 0x1, 0xf9, 0x0,
    0x0, 0x0, 0x1, 0xa, 0xf0, 0x0, 0x1f, 0xd9,
    0x99, 0xab, 0xdf, 0xc0, 0xaf, 0x0, 0x1, 0xdd,
    0xdd, 0xcc, 0xa9, 0x74, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0,

    /* U+B2F5 "답" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x55, 0x55, 0x55, 0x54, 0x0, 0x9, 0xf1,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x9f,
    0x10, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf1, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x54, 0x31, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0xfb, 0x1f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x21, 0x1, 0xf9, 0x0, 0x0, 0x2,
    0x44, 0x9, 0xf1, 0x0, 0x2f, 0xfe, 0xee, 0xff,
    0xff, 0x90, 0x9f, 0x10, 0x0, 0x77, 0x77, 0x76,
    0x53, 0x10, 0x9, 0xf1, 0x0, 0x0, 0x3, 0x10,
    0x0, 0x0, 0x0, 0x24, 0x0, 0x0, 0x4, 0xf5,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x4,
    0xff, 0xee, 0xee, 0xee, 0xef, 0xf1, 0x0, 0x0,
    0x4f, 0xa6, 0x66, 0x66, 0x66, 0xcf, 0x10, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x4f, 0x95, 0x55, 0x55, 0x55, 0xbf, 0x10,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0,

    /* U+B300 "대" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x3, 0x81,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x35, 0x55, 0x55, 0x50, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0xff, 0xff, 0xf2, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf4, 0x49, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xff, 0xff, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf1, 0x18, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0x10, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x9f, 0x21, 0x23, 0x57, 0x19, 0xf0, 0x7, 0xf2,
    0x9f, 0xff, 0xff, 0xfe, 0x39, 0xf0, 0x7, 0xf2,
    0x25, 0x44, 0x43, 0x10, 0x9, 0xf0, 0x7, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x7, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x90, 0x7, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf2,

    /* U+B3C4 "도" */
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0xec, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x10, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xd4, 0x44, 0x44,
    0x44, 0x44, 0x42, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x62,

    /* U+B428 "됨" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xb0,
    0x0, 0xbb, 0xbb, 0xbb, 0xbb, 0x70, 0x9, 0xf0,
    0x1, 0xfd, 0xaa, 0xaa, 0xaa, 0x60, 0x9, 0xf0,
    0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x1, 0xfb, 0x44, 0x44, 0x44, 0x30, 0x9, 0xf0,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x9, 0xf0,
    0x0, 0x11, 0x1a, 0xf3, 0x11, 0x10, 0x9, 0xf0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x12, 0x9, 0xf0,
    0x6a, 0xaa, 0xbe, 0xfd, 0xef, 0xff, 0x9, 0xf0,
    0x5b, 0xba, 0xa9, 0x98, 0x65, 0x30, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x30,
    0x0, 0x5, 0x66, 0x66, 0x66, 0x66, 0x66, 0x60,
    0x0, 0xc, 0xfe, 0xee, 0xee, 0xee, 0xef, 0xf0,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x0, 0xc, 0xe5, 0x55, 0x55, 0x55, 0x5b, 0xf0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+B4C8 "듈" */
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0xd, 0xe6, 0x66, 0x66, 0x66, 0x66, 0x61,
    0x0, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0x50, 0x0, 0x7, 0x88, 0x88, 0x88, 0x88,
    0x88, 0x83, 0x0, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x33, 0x33, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x22, 0x22, 0x9f, 0x32,
    0x22, 0xbf, 0x22, 0x22, 0x0, 0x0, 0x8, 0xf1,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xdd, 0xef,
    0xdd, 0xdd, 0xff, 0xdd, 0x30, 0x0, 0x7, 0x77,
    0x77, 0x77, 0x77, 0x7a, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x30, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0xfb, 0x33, 0x33, 0x33, 0x33, 0x33, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0,

    /* U+B4DC "드" */
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0xe, 0xd6, 0x66, 0x66, 0x66, 0x66, 0x62,
    0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xfd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xd6, 0x0, 0x0, 0x78, 0x88, 0x88,
    0x88, 0x88, 0x88, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0,

    /* U+B4E3 "듣" */
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0xe, 0xd6, 0x66, 0x66, 0x66, 0x66, 0x61,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xec, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x34, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x52, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0xfd,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x20, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0,

    /* U+B529 "딩" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x86, 0x12,
    0x22, 0x22, 0x22, 0x10, 0x0, 0xeb, 0xef, 0xff,
    0xff, 0xff, 0x90, 0x0, 0xeb, 0xec, 0x33, 0x33,
    0x33, 0x20, 0x0, 0xeb, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xeb, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xeb, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xeb, 0xeb, 0x0, 0x0, 0x0, 0x13, 0x10, 0xeb,
    0xff, 0xcc, 0xcd, 0xef, 0xff, 0x60, 0xeb, 0x9a,
    0xa9, 0x98, 0x76, 0x42, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x2,
    0x55, 0x54, 0x10, 0x86, 0x0, 0x7, 0xef, 0xff,
    0xff, 0xfb, 0x30, 0x0, 0xaf, 0x93, 0x0, 0x1,
    0x5d, 0xf3, 0x2, 0xfa, 0x0, 0x0, 0x0, 0x1,
    0xfb, 0x3, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xec,
    0x0, 0xfd, 0x10, 0x0, 0x0, 0x6, 0xf9, 0x0,
    0x5f, 0xe9, 0x65, 0x57, 0xcf, 0xc0, 0x0, 0x2,
    0x8c, 0xff, 0xfe, 0xb5, 0x0,

    /* U+B808 "레" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x36, 0x66, 0x66, 0x60, 0x0, 0xf9, 0x8, 0xf1,
    0x8f, 0xff, 0xff, 0xe0, 0x0, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0xa, 0xe0, 0x0, 0xf9, 0x8, 0xf1,
    0x36, 0x66, 0x6c, 0xe3, 0xdd, 0xf9, 0x8, 0xf1,
    0x8f, 0xff, 0xff, 0xe2, 0x99, 0xf9, 0x8, 0xf1,
    0x8f, 0x10, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x8f, 0x10, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x8f, 0x10, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x8f, 0x88, 0x9a, 0xbd, 0x70, 0xf9, 0x8, 0xf1,
    0x7e, 0xdd, 0xdc, 0xa8, 0x30, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x95, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf1,

    /* U+B824 "려" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x2f, 0xff, 0xff, 0xff, 0xa0, 0x0, 0x9, 0xf1,
    0x16, 0x66, 0x66, 0x6f, 0xb0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x66, 0x6c, 0xf1,
    0x0, 0x0, 0x0, 0xe, 0xb1, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x9, 0xf1,
    0x1c, 0xcc, 0xcc, 0xcf, 0xb0, 0x0, 0x9, 0xf1,
    0x1f, 0xd9, 0x99, 0x99, 0x60, 0x0, 0x9, 0xf1,
    0x1f, 0x80, 0x0, 0x0, 0x1, 0x77, 0x7c, 0xf1,
    0x1f, 0x80, 0x0, 0x0, 0x3, 0xff, 0xff, 0xf1,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x1f, 0x80, 0x0, 0x12, 0x46, 0x10, 0x9, 0xf1,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0x20, 0x9, 0xf1,
    0x6, 0x66, 0x65, 0x43, 0x10, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,

    /* U+B85C "로" */
    0x0, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x10,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x0, 0x22, 0x22, 0x22, 0x22, 0x22, 0x3f,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x0, 0xfc, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x20, 0x0, 0xf, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xfc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xc9, 0x0, 0x0, 0x89, 0x99,
    0x9d, 0xf9, 0x99, 0x99, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x62,

    /* U+B958 "류" */
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0, 0x0, 0x6, 0x66, 0x66, 0x66, 0x66, 0x69,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf6, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x48, 0xf6, 0x0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x65,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xc3, 0x9, 0x99, 0x9e, 0xf9, 0x99,
    0x9d, 0xfa, 0x99, 0x93, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xe0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xe0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xe0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xe0, 0x0, 0x9, 0xf1,
    0x0, 0x0,

    /* U+B968 "륨" */
    0x0, 0x1, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0, 0x0, 0x2, 0x33, 0x33, 0x33, 0x33,
    0x37, 0xf4, 0x0, 0x0, 0x1, 0x11, 0x11, 0x11,
    0x11, 0x16, 0xf4, 0x0, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0xe, 0xc2,
    0x22, 0x22, 0x22, 0x22, 0x20, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x4, 0x55, 0x55, 0x55, 0x55, 0x55, 0x53,
    0x0, 0x6, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x66, 0x62, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0xd,
    0xd4, 0x44, 0x44, 0x44, 0x48, 0xf4, 0x0, 0x0,
    0xd, 0xc0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0xd, 0xd5, 0x55, 0x55, 0x55, 0x58, 0xf4,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf4, 0x0,

    /* U+B97C "를" */
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x2, 0x33, 0x33, 0x33, 0x33, 0x37,
    0xf4, 0x0, 0x0, 0x2, 0x22, 0x22, 0x22, 0x22,
    0x27, 0xf4, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0xe, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xeb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x0, 0x0, 0x7,
    0x88, 0x88, 0x88, 0x88, 0x88, 0x84, 0x0, 0x2,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf6, 0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x20, 0x0, 0x4, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x41, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0xe, 0xee,
    0xee, 0xee, 0xee, 0xef, 0xf5, 0x0, 0x0, 0xf,
    0xb3, 0x33, 0x33, 0x33, 0x33, 0x31, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xfe, 0xee, 0xee, 0xee, 0xee, 0xec,
    0x0,

    /* U+B9AC "리" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0xeb, 0x66, 0x66, 0x66,
    0x7f, 0x90, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x1f, 0x90,
    0x0, 0xeb, 0x0, 0x0, 0x0, 0x1f, 0x90, 0x0,
    0xeb, 0xef, 0xff, 0xff, 0xff, 0x90, 0x0, 0xeb,
    0xfd, 0x66, 0x66, 0x66, 0x30, 0x0, 0xeb, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0xfb, 0x0, 0x1, 0x23,
    0x57, 0x50, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0xeb, 0x66, 0x66, 0x55, 0x42, 0x10, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb,

    /* U+B9D0 "말" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 0x0,
    0x0, 0x66, 0x66, 0x66, 0x66, 0x0, 0x9, 0xf1,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x9f,
    0x10, 0x1, 0xf8, 0x0, 0x0, 0x8f, 0x10, 0x9,
    0xf1, 0x0, 0x1f, 0x80, 0x0, 0x8, 0xf1, 0x0,
    0x9f, 0x76, 0x41, 0xf8, 0x0, 0x0, 0x8f, 0x10,
    0x9, 0xff, 0xfa, 0x1f, 0x80, 0x0, 0x8, 0xf1,
    0x0, 0x9f, 0x10, 0x1, 0xfb, 0x66, 0x66, 0xbf,
    0x10, 0x9, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xe1, 0x0, 0x0, 0x16, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x1,
    0x44, 0x44, 0x44, 0x44, 0x4b, 0xf1, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0,

    /* U+BAA8 "모" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x1, 0xfa, 0x44, 0x44, 0x44, 0x44, 0x5f,
    0x80, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0, 0x1,
    0xf8, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x0,
    0x1, 0xf8, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x1, 0xfe, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdf, 0x80, 0x0, 0x7, 0x77, 0x77,
    0xdf, 0x77, 0x77, 0x74, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x62,

    /* U+BC1C "발" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 0x0,
    0x1, 0xc7, 0x0, 0x0, 0x6c, 0x10, 0x9, 0xf1,
    0x0, 0x1f, 0x90, 0x0, 0x8, 0xf1, 0x0, 0x9f,
    0x10, 0x1, 0xf9, 0x0, 0x0, 0x8f, 0x10, 0x9,
    0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x9f, 0x76, 0x41, 0xfb, 0x55, 0x55, 0xbf, 0x10,
    0x9, 0xff, 0xfa, 0x1f, 0x90, 0x0, 0x8, 0xf1,
    0x0, 0x9f, 0x10, 0x1, 0xfa, 0x33, 0x33, 0xaf,
    0x10, 0x9, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x9f, 0x10, 0x0, 0x11, 0x11, 0x11,
    0x11, 0x0, 0x9, 0xf1, 0x0, 0x0, 0x15, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x0,
    0x33, 0x33, 0x33, 0x33, 0x3a, 0xf1, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x3, 0xf5, 0x11, 0x11, 0x11, 0x11, 0x10, 0x0,
    0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0,

    /* U+BC30 "배" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x5, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x9, 0xf0,
    0x6d, 0x10, 0x1, 0xd6, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x76, 0x67, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0xee, 0xee, 0xf7, 0x9, 0xf6, 0x6b, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xff, 0xff, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x10, 0x1, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0x55, 0x55, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x8f, 0xff, 0xff, 0xf7, 0x9, 0xf0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xa0, 0x9, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf0,

    /* U+BC84 "버" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xb0,
    0x4, 0x20, 0x0, 0x2, 0x40, 0x0, 0x9, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0xc8, 0x88, 0x8d, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0xec, 0xcc, 0xce, 0xff, 0xff, 0xff, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf6, 0x66, 0x6c, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0x90, 0x0, 0x9, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0xb5, 0x55, 0x5b, 0xf0, 0x0, 0x9, 0xf1,
    0x1f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,

    /* U+BCF4 "보" */
    0x0, 0x42, 0x0, 0x0, 0x0, 0x0, 0x4, 0x20,
    0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x1, 0xf9,
    0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0x1,
    0xf9, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x1f, 0xb5, 0x55, 0x55, 0x55,
    0x55, 0xf9, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x90, 0x0, 0x1f, 0x90, 0x0, 0x0,
    0x0, 0x1, 0xf9, 0x0, 0x1, 0xfb, 0x55, 0x55,
    0x55, 0x55, 0x6f, 0x90, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x62,

    /* U+BCFC "볼" */
    0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0x24, 0x0,
    0x0, 0xd, 0xc0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0xdd, 0x55, 0x55, 0x55, 0x55, 0xbf,
    0x10, 0x0, 0xd, 0xfe, 0xee, 0xee, 0xee, 0xef,
    0xf1, 0x0, 0x0, 0xdc, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x10, 0x0, 0xd, 0xe9, 0x99, 0x99, 0x99,
    0x9d, 0xf1, 0x0, 0x0, 0x9b, 0xbb, 0xbe, 0xfb,
    0xbb, 0xbb, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0x0, 0x0, 0x0, 0x88, 0x88, 0x88, 0x8d,
    0xf8, 0x88, 0x88, 0x88, 0x3c, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xc4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x55,
    0x55, 0x55, 0x55, 0x55, 0xaf, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf1, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0xf, 0xb3, 0x33, 0x33, 0x33, 0x33, 0x30, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0,

    /* U+BD80 "부" */
    0x0, 0xb, 0x80, 0x0, 0x0, 0x0, 0x7, 0xc1,
    0x0, 0x0, 0xf, 0xb0, 0x0, 0x0, 0x0, 0x9,
    0xf1, 0x0, 0x0, 0xf, 0xc5, 0x55, 0x55, 0x55,
    0x5b, 0xf1, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0xf, 0xb0, 0x0,
    0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xf,
    0xc5, 0x55, 0x55, 0x55, 0x5b, 0xf1, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0x99, 0x99, 0x99, 0x99, 0x99,
    0x99, 0x99, 0x93, 0xb, 0xbb, 0xbb, 0xbb, 0xef,
    0xbb, 0xbb, 0xbb, 0xb4, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x0,

    /* U+BE44 "비" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0xfb, 0x0,
    0x0, 0x1f, 0x90, 0x0, 0xeb, 0xfb, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0xeb, 0xfb, 0x0, 0x0, 0x1f,
    0x90, 0x0, 0xeb, 0xfb, 0x0, 0x0, 0x1f, 0x90,
    0x0, 0xeb, 0xfc, 0x33, 0x33, 0x4f, 0x90, 0x0,
    0xeb, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xeb,
    0xfb, 0x11, 0x11, 0x2f, 0x90, 0x0, 0xeb, 0xfb,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0xeb, 0xfb, 0x0,
    0x0, 0x1f, 0x90, 0x0, 0xeb, 0xfb, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0xeb, 0xfb, 0x22, 0x22, 0x3f,
    0x90, 0x0, 0xeb, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0xeb, 0x33, 0x33, 0x33, 0x33, 0x20, 0x0,
    0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xeb,

    /* U+C0AC "사" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x6, 0xf3, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x7, 0xf3,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x7,
    0xf3, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x8, 0xf4, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0xb, 0xf8, 0x0, 0x0, 0xa, 0xf3, 0x33,
    0x0, 0x0, 0xf, 0xfd, 0x0, 0x0, 0xa, 0xff,
    0xff, 0x0, 0x0, 0x6f, 0x8f, 0x40, 0x0, 0xa,
    0xf3, 0x33, 0x0, 0x1, 0xec, 0xe, 0xd0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0xb, 0xf4, 0x5, 0xfa,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x9f, 0x90, 0x0,
    0xaf, 0xa0, 0xa, 0xf0, 0x0, 0xc, 0xfb, 0x0,
    0x0, 0xb, 0xf7, 0xa, 0xf0, 0x0, 0x6, 0x90,
    0x0, 0x0, 0x0, 0x50, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0,

    /* U+C0BD "삽" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x80,
    0x0, 0x0, 0x0, 0x4, 0x80, 0x0, 0x0, 0xc,
    0xe0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0xc, 0xe0, 0x0, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0xc, 0xf5, 0x53, 0x0, 0x0, 0x1f,
    0xfb, 0x0, 0x0, 0xc, 0xff, 0xf9, 0x0, 0x0,
    0xaf, 0x7f, 0x60, 0x0, 0xc, 0xe0, 0x0, 0x0,
    0x9, 0xf7, 0xb, 0xf7, 0x0, 0xc, 0xe0, 0x0,
    0x4, 0xcf, 0x90, 0x0, 0xbf, 0xc2, 0xc, 0xe0,
    0x0, 0x1e, 0xe6, 0x0, 0x0, 0x6, 0xa0, 0xc,
    0xe0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x60, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0x0, 0xc, 0xe0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0xc, 0xe0, 0x0, 0x0, 0x9, 0xf6,
    0x55, 0x55, 0x55, 0x5d, 0xe0, 0x0, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x9, 0xf1, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x0,
    0x0, 0x9, 0xf6, 0x55, 0x55, 0x55, 0x5d, 0xe0,
    0x0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0,

    /* U+C0C1 "상" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xa0,
    0x0, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x1f,
    0xf9, 0x0, 0x0, 0xa, 0xff, 0xfa, 0x0, 0x0,
    0x8f, 0xaf, 0x30, 0x0, 0xa, 0xf7, 0x75, 0x0,
    0x5, 0xf9, 0xe, 0xe3, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x7f, 0xd0, 0x2, 0xef, 0x81, 0xa, 0xf0,
    0x0, 0xc, 0xfc, 0x10, 0x0, 0x1a, 0xe1, 0xa,
    0xf0, 0x0, 0x4, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x3, 0x50, 0x0, 0x0, 0x0, 0x6, 0xcf,
    0xff, 0xfe, 0xa3, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xa6, 0x43, 0x48, 0xdf, 0x60, 0x0, 0x0, 0x8,
    0xf5, 0x0, 0x0, 0x0, 0xc, 0xf1, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x0, 0xc, 0xf0,
    0x0, 0x0, 0x0, 0xbf, 0xb7, 0x55, 0x69, 0xef,
    0x50, 0x0, 0x0, 0x0, 0x5, 0xae, 0xff, 0xfc,
    0x82, 0x0, 0x0,

    /* U+C0C8 "새" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x10, 0x8,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0,
    0xf9, 0x0, 0x0, 0x2e, 0x50, 0x0, 0x1f, 0x70,
    0xf, 0x90, 0x0, 0x3, 0xf6, 0x0, 0x1, 0xf7,
    0x0, 0xf9, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x1f,
    0x70, 0xf, 0x90, 0x0, 0x3, 0xf6, 0x0, 0x1,
    0xf7, 0x0, 0xf9, 0x0, 0x0, 0x3f, 0x70, 0x0,
    0x1f, 0x70, 0xf, 0x90, 0x0, 0x6, 0xf9, 0x0,
    0x1, 0xf9, 0x44, 0xf9, 0x0, 0x0, 0xaf, 0xe0,
    0x0, 0x1f, 0xff, 0xff, 0x90, 0x0, 0xf, 0xcf,
    0x40, 0x1, 0xf8, 0x11, 0xf9, 0x0, 0x7, 0xf2,
    0xec, 0x0, 0x1f, 0x70, 0xf, 0x90, 0x2, 0xfa,
    0x6, 0xf9, 0x1, 0xf7, 0x0, 0xf9, 0x2, 0xdf,
    0x10, 0xb, 0xf9, 0x2f, 0x70, 0xf, 0x90, 0xef,
    0x40, 0x0, 0xa, 0xc2, 0xf7, 0x0, 0xf9, 0x4,
    0x30, 0x0, 0x0, 0x0, 0x1f, 0x70, 0xf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf7, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0xf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x1, 0xa4, 0x0,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x90,

    /* U+C11C "서" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x77,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x6, 0xf6, 0x0, 0x66, 0x66, 0xed,
    0x0, 0x0, 0x9, 0xfa, 0x0, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0xe, 0xfe, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x5f, 0x8f, 0x50, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0xde, 0xd, 0xe0, 0x0, 0x0, 0xdd,
    0x0, 0x8, 0xf6, 0x4, 0xfb, 0x0, 0x0, 0xdd,
    0x0, 0x7f, 0xb0, 0x0, 0x9f, 0xa0, 0x0, 0xdd,
    0xa, 0xfd, 0x10, 0x0, 0xa, 0xfa, 0x0, 0xdd,
    0x5, 0xb1, 0x0, 0x0, 0x0, 0x62, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd,

    /* U+C124 "설" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x70,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x8f, 0x30, 0x3, 0x44, 0x4d, 0xe0,
    0x0, 0x0, 0xcf, 0x80, 0xb, 0xff, 0xff, 0xe0,
    0x0, 0x3, 0xfe, 0xe1, 0x1, 0x11, 0x1c, 0xe0,
    0x0, 0x1d, 0xd2, 0xfc, 0x10, 0x0, 0xc, 0xe0,
    0x3, 0xdf, 0x30, 0x4f, 0xe5, 0x0, 0xc, 0xe0,
    0x9f, 0xe4, 0x0, 0x3, 0xdf, 0x50, 0xc, 0xe0,
    0x59, 0x10, 0x0, 0x0, 0x4, 0x0, 0x9, 0xb0,
    0x0, 0x3, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x2, 0x33, 0x33, 0x33, 0x33, 0x3c, 0xe0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0xb, 0xe1, 0x11, 0x11, 0x11, 0x11, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,

    /* U+C131 "성" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9a,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0, 0x8, 0xf4, 0x0, 0xaf, 0xff, 0xfe,
    0x0, 0x0, 0xc, 0xfa, 0x0, 0x57, 0x77, 0xee,
    0x0, 0x0, 0x4f, 0xcf, 0x30, 0x0, 0x0, 0xce,
    0x0, 0x2, 0xed, 0xd, 0xe4, 0x0, 0x0, 0xce,
    0x0, 0x6f, 0xe2, 0x2, 0xdf, 0xa2, 0x0, 0xce,
    0xb, 0xfd, 0x20, 0x0, 0x8, 0xe2, 0x0, 0xce,
    0x3, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbd,
    0x0, 0x0, 0x0, 0x1, 0x34, 0x43, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xcf, 0xff, 0xff, 0xfb, 0x30,
    0x0, 0x0, 0x7f, 0xc5, 0x10, 0x2, 0x6d, 0xf4,
    0x0, 0x0, 0xfc, 0x0, 0x0, 0x0, 0x1, 0xec,
    0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x0, 0x0, 0xde, 0x20, 0x0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x3e, 0xfa, 0x65, 0x56, 0xaf, 0xd2,
    0x0, 0x0, 0x1, 0x7c, 0xef, 0xfe, 0xb6, 0x0,

    /* U+C138 "세" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x10, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xea, 0x1,
    0xf8, 0x0, 0x0, 0x3e, 0x50, 0x0, 0xe, 0xa0,
    0x1f, 0x80, 0x0, 0x3, 0xf5, 0x0, 0x0, 0xea,
    0x1, 0xf8, 0x0, 0x0, 0x3f, 0x50, 0x0, 0xe,
    0xa0, 0x1f, 0x80, 0x0, 0x3, 0xf5, 0x0, 0x0,
    0xea, 0x1, 0xf8, 0x0, 0x0, 0x4f, 0x60, 0x1,
    0x1e, 0xa0, 0x1f, 0x80, 0x0, 0x6, 0xf9, 0xe,
    0xff, 0xfa, 0x1, 0xf8, 0x0, 0x0, 0xaf, 0xd0,
    0x45, 0x5f, 0xa0, 0x1f, 0x80, 0x0, 0x1f, 0xcf,
    0x30, 0x0, 0xea, 0x1, 0xf8, 0x0, 0x7, 0xf2,
    0xeb, 0x0, 0xe, 0xa0, 0x1f, 0x80, 0x2, 0xfa,
    0x6, 0xf6, 0x0, 0xea, 0x1, 0xf8, 0x2, 0xee,
    0x10, 0xb, 0xf7, 0xe, 0xa0, 0x1f, 0x80, 0xef,
    0x40, 0x0, 0x1c, 0xb0, 0xea, 0x1, 0xf8, 0x4,
    0x30, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x1f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xea, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xa0, 0x1f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x96, 0x1,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x80,

    /* U+C14B "셋" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x3, 0x60,
    0x0, 0x0, 0x18, 0x20, 0x0, 0xe, 0xb0, 0x8f,
    0x10, 0x0, 0x4, 0xf5, 0x0, 0x0, 0xeb, 0x8,
    0xf1, 0x0, 0x0, 0x4f, 0x50, 0x0, 0xe, 0xb0,
    0x8f, 0x10, 0x0, 0x5, 0xf6, 0x4, 0x66, 0xfb,
    0x8, 0xf1, 0x0, 0x0, 0x8f, 0x90, 0xaf, 0xff,
    0xb0, 0x8f, 0x10, 0x0, 0xe, 0xff, 0x10, 0x0,
    0xeb, 0x8, 0xf1, 0x0, 0x9, 0xf4, 0xfc, 0x0,
    0xe, 0xb0, 0x8f, 0x10, 0x9, 0xf8, 0x6, 0xfc,
    0x20, 0xeb, 0x8, 0xf1, 0xb, 0xf9, 0x0, 0x6,
    0xf8, 0xe, 0xb0, 0x8f, 0x10, 0x35, 0x0, 0x0,
    0x1, 0x0, 0xeb, 0x8, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x10, 0x8f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x7, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfc, 0x4f, 0xb1, 0x0, 0x0,
    0x0, 0x0, 0x3a, 0xfc, 0x10, 0x5f, 0xe7, 0x10,
    0x0, 0x6, 0xef, 0xe7, 0x0, 0x0, 0x2a, 0xff,
    0xb0, 0x0, 0x28, 0x40, 0x0, 0x0, 0x0, 0x1,
    0x66, 0x0,

    /* U+C18C "소" */
    0x0, 0x0, 0x0, 0x2, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc8, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0xe2, 0xc,
    0xf6, 0x0, 0x0, 0x0, 0x1, 0x9f, 0xe2, 0x0,
    0x1c, 0xfb, 0x30, 0x0, 0x2b, 0xff, 0x91, 0x0,
    0x0, 0x7, 0xff, 0xd4, 0x0, 0xa8, 0x20, 0x0,
    0x45, 0x0, 0x1, 0x7b, 0x10, 0x0, 0x0, 0x0,
    0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x62,

    /* U+C18D "속" */
    0x0, 0x0, 0x0, 0x5, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf8, 0x4f, 0xc2,
    0x0, 0x0, 0x0, 0x1, 0x7e, 0xf7, 0x0, 0x4e,
    0xf8, 0x20, 0x0, 0xd, 0xff, 0xa2, 0x3, 0x50,
    0x19, 0xff, 0xd0, 0x0, 0x65, 0x10, 0x0, 0xaf,
    0x0, 0x1, 0x55, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x9, 0x99, 0x99, 0x99,
    0xef, 0x99, 0x99, 0x99, 0x93, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0,

    /* U+C1A1 "송" */
    0x0, 0x0, 0x0, 0x5, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf8, 0x3f, 0xc2,
    0x0, 0x0, 0x0, 0x1, 0x6d, 0xf8, 0x0, 0x3e,
    0xf9, 0x30, 0x0, 0xb, 0xff, 0xb3, 0x3, 0x50,
    0x8, 0xef, 0xe2, 0x0, 0x46, 0x10, 0x0, 0xaf,
    0x0, 0x0, 0x47, 0x0, 0x0, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0xb, 0xbb, 0xbb, 0xbb,
    0xef, 0xbb, 0xbb, 0xbb, 0xb3, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x59, 0xcd, 0xdc, 0xa7, 0x10, 0x0, 0x0, 0x2,
    0xdf, 0xc8, 0x77, 0x8a, 0xff, 0x60, 0x0, 0x0,
    0xcf, 0x30, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x4, 0xf6, 0x0,
    0x0, 0xee, 0x10, 0x0, 0x0, 0x0, 0x9f, 0x40,
    0x0, 0x4, 0xff, 0x96, 0x44, 0x58, 0xdf, 0x90,
    0x0, 0x0, 0x1, 0x7c, 0xef, 0xff, 0xd9, 0x30,
    0x0, 0x0,

    /* U+C218 "수" */
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfd, 0xe2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1a, 0xf7, 0x2e, 0xe3,
    0x0, 0x0, 0x0, 0x1, 0x7e, 0xf6, 0x0, 0x2d,
    0xfa, 0x30, 0x0, 0xc, 0xff, 0xb2, 0x0, 0x0,
    0x8, 0xef, 0xe4, 0x0, 0x66, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x58, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x62, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0,

    /* U+C2A4 "스" */
    0x0, 0x0, 0x0, 0x3, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb7, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0xe1, 0xb,
    0xf7, 0x0, 0x0, 0x0, 0x1, 0x9f, 0xd2, 0x0,
    0xb, 0xfb, 0x30, 0x0, 0x1b, 0xff, 0xa1, 0x0,
    0x0, 0x7, 0xff, 0xc4, 0x0, 0xb9, 0x20, 0x0,
    0x0, 0x0, 0x1, 0x7c, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x41, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x62,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20,

    /* U+C2B5 "습" */
    0x0, 0x0, 0x0, 0x4, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1a, 0xf7, 0x3f, 0xd3,
    0x0, 0x0, 0x0, 0x3, 0x9f, 0xf6, 0x0, 0x2d,
    0xfb, 0x50, 0x0, 0xd, 0xff, 0x91, 0x0, 0x0,
    0x6, 0xdf, 0xf3, 0x0, 0x33, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x25, 0x0, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x11, 0x0, 0xf, 0xb0,
    0x0, 0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x30, 0x0, 0xf,
    0xd6, 0x66, 0x66, 0x66, 0x6a, 0xf3, 0x0, 0x0,
    0xff, 0xee, 0xee, 0xee, 0xee, 0xff, 0x30, 0x0,
    0xf, 0xb0, 0x0, 0x0, 0x0, 0x7, 0xf3, 0x0,
    0x0, 0xfc, 0x55, 0x55, 0x55, 0x55, 0x9f, 0x30,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3,
    0x0,

    /* U+C2DC "시" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x2, 0x93, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x3, 0xf6, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x7, 0xfa, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0xb, 0xfe, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x1f, 0xcf, 0x50, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0xaf, 0x2d, 0xd0, 0x0, 0x0, 0xeb,
    0x0, 0x5, 0xf9, 0x4, 0xfa, 0x0, 0x0, 0xeb,
    0x0, 0x3f, 0xe1, 0x0, 0x9f, 0x90, 0x0, 0xeb,
    0x7, 0xff, 0x30, 0x0, 0xb, 0xfd, 0x0, 0xeb,
    0x9, 0xd3, 0x0, 0x0, 0x0, 0x77, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,

    /* U+C2E4 "실" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x60,
    0x0, 0x0, 0x4f, 0x60, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x0, 0x4f, 0x60, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x0, 0xbf, 0xd0, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x4, 0xfb, 0xf6, 0x0, 0x0, 0xf, 0xb0,
    0x0, 0x2e, 0xd0, 0xcf, 0x50, 0x0, 0xf, 0xb0,
    0x6, 0xfe, 0x20, 0x1d, 0xf9, 0x20, 0xf, 0xb0,
    0xbf, 0xd2, 0x0, 0x0, 0x9f, 0x90, 0xf, 0xb0,
    0x36, 0x0, 0x0, 0x0, 0x1, 0x0, 0xc, 0x90,
    0x0, 0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x30,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x1e, 0xb0,
    0x0, 0x2, 0x22, 0x22, 0x22, 0x22, 0x2e, 0xb0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xb0,
    0x0, 0xe, 0xb1, 0x11, 0x11, 0x11, 0x11, 0x10,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+C548 "안" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x3, 0x31, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x9f, 0xff, 0xfa, 0x10, 0x0, 0xaf,
    0x0, 0x0, 0xcf, 0x93, 0x38, 0xfd, 0x0, 0xa,
    0xf0, 0x0, 0x5f, 0x70, 0x0, 0x5, 0xf7, 0x0,
    0xaf, 0x0, 0xa, 0xf0, 0x0, 0x0, 0xe, 0xb0,
    0xa, 0xf0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0xaf, 0xff, 0xa7, 0xf4, 0x0, 0x0, 0x2f,
    0x80, 0xa, 0xf5, 0x53, 0x1e, 0xe3, 0x0, 0x3d,
    0xf2, 0x0, 0xaf, 0x0, 0x0, 0x3e, 0xfe, 0xef,
    0xe4, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x5, 0x89,
    0x61, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x16,
    0x20, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x3,
    0xf6, 0x0, 0x0, 0x0, 0x8, 0xc0, 0x0, 0x0,
    0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0,

    /* U+C5C5 "업" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x80,
    0x0, 0x58, 0x85, 0x0, 0x0, 0x0, 0xbe, 0x5,
    0xef, 0xee, 0xfe, 0x30, 0x0, 0xb, 0xe3, 0xfc,
    0x20, 0x3, 0xde, 0x10, 0x0, 0xbe, 0x9f, 0x10,
    0x0, 0x3, 0xf8, 0x33, 0x3c, 0xeb, 0xe0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xfe, 0x9f, 0x10, 0x0,
    0x3, 0xf8, 0x22, 0x2c, 0xe2, 0xfc, 0x20, 0x3,
    0xde, 0x10, 0x0, 0xbe, 0x5, 0xef, 0xee, 0xfe,
    0x30, 0x0, 0xb, 0xe0, 0x1, 0x58, 0x85, 0x0,
    0x0, 0x0, 0xbe, 0x0, 0x2, 0x30, 0x0, 0x0,
    0x0, 0x4, 0x60, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0xbf, 0x77, 0x77, 0x77, 0x77,
    0xde, 0x0, 0xb, 0xfe, 0xee, 0xee, 0xee, 0xef,
    0xe0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x0, 0xb, 0xf5, 0x55, 0x55, 0x55, 0x5d, 0xe0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe,

    /* U+C5C6 "없" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x70,
    0x0, 0x4, 0xad, 0xda, 0x40, 0x0, 0x0, 0xde,
    0x0, 0x9, 0xfd, 0x89, 0xdf, 0x70, 0x0, 0xd,
    0xe0, 0x4, 0xf8, 0x0, 0x0, 0xaf, 0x30, 0x0,
    0xde, 0x0, 0xaf, 0x0, 0x0, 0x2, 0xfa, 0x44,
    0x4e, 0xe0, 0xb, 0xe0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xfe, 0x0, 0x8f, 0x20, 0x0, 0x4, 0xf8,
    0x11, 0x1d, 0xe0, 0x2, 0xfd, 0x20, 0x3, 0xee,
    0x10, 0x0, 0xde, 0x0, 0x4, 0xef, 0xee, 0xfe,
    0x30, 0x0, 0xd, 0xe0, 0x0, 0x0, 0x57, 0x74,
    0x0, 0x0, 0x0, 0xde, 0x0, 0x0, 0x32, 0x0,
    0x3, 0x10, 0x1, 0x52, 0x0, 0x0, 0xf, 0xa0,
    0x1, 0xf7, 0x0, 0x3f, 0x60, 0x0, 0x0, 0xfa,
    0x0, 0x1f, 0x70, 0x4, 0xf6, 0x0, 0x0, 0xf,
    0xfe, 0xee, 0xf7, 0x0, 0x6f, 0x90, 0x0, 0x0,
    0xfc, 0x55, 0x6f, 0x70, 0xd, 0xff, 0x10, 0x0,
    0xf, 0xa0, 0x1, 0xf7, 0x8, 0xf5, 0xfb, 0x0,
    0x0, 0xfc, 0x44, 0x5f, 0x89, 0xf9, 0x5, 0xfc,
    0x30, 0xf, 0xff, 0xff, 0xf8, 0xe8, 0x0, 0x5,
    0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+C5D0 "에" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x1, 0xf8,
    0x0, 0x8f, 0xfa, 0x10, 0x0, 0xdc, 0x1, 0xf8,
    0x9, 0xfa, 0x9f, 0xb0, 0x0, 0xdc, 0x1, 0xf8,
    0x2f, 0x90, 0x6, 0xf4, 0x0, 0xdc, 0x1, 0xf8,
    0x7f, 0x20, 0x0, 0xe9, 0x0, 0xdc, 0x1, 0xf8,
    0xae, 0x0, 0x0, 0xbd, 0x0, 0xdc, 0x1, 0xf8,
    0xcc, 0x0, 0x0, 0x9f, 0x66, 0xec, 0x1, 0xf8,
    0xcc, 0x0, 0x0, 0x9f, 0xff, 0xfc, 0x1, 0xf8,
    0xbd, 0x0, 0x0, 0xae, 0x0, 0xdc, 0x1, 0xf8,
    0x9f, 0x0, 0x0, 0xdb, 0x0, 0xdc, 0x1, 0xf8,
    0x5f, 0x40, 0x2, 0xf7, 0x0, 0xdc, 0x1, 0xf8,
    0xe, 0xd2, 0x1b, 0xf1, 0x0, 0xdc, 0x1, 0xf8,
    0x4, 0xff, 0xff, 0x60, 0x0, 0xdc, 0x1, 0xf8,
    0x0, 0x28, 0x83, 0x0, 0x0, 0xdc, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdc, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x99, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf8,

    /* U+C5F0 "연" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xa0,
    0x0, 0x6, 0x98, 0x50, 0x0, 0x0, 0xc, 0xe0,
    0x3, 0xef, 0xef, 0xfd, 0x20, 0x0, 0xc, 0xe0,
    0x1e, 0xe3, 0x0, 0x4e, 0xfe, 0xee, 0xef, 0xe0,
    0x7f, 0x30, 0x0, 0x5, 0xfa, 0x77, 0x7e, 0xe0,
    0xbe, 0x0, 0x0, 0x0, 0xf8, 0x0, 0xc, 0xe0,
    0xbe, 0x0, 0x0, 0x0, 0xf8, 0x0, 0xc, 0xe0,
    0x7f, 0x30, 0x0, 0x5, 0xfb, 0x88, 0x8e, 0xe0,
    0x1e, 0xd3, 0x0, 0x4e, 0xfe, 0xee, 0xef, 0xe0,
    0x3, 0xef, 0xee, 0xfd, 0x20, 0x0, 0xc, 0xe0,
    0x0, 0x6, 0x99, 0x50, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x3, 0x50, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xa, 0xb0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+C624 "오" */
    0x0, 0x0, 0x0, 0x35, 0x54, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x2a, 0xff, 0xff, 0xff, 0xc5, 0x0,
    0x0, 0x0, 0x4f, 0xe7, 0x20, 0x1, 0x5c, 0xf8,
    0x0, 0x0, 0xe, 0xd1, 0x0, 0x0, 0x0, 0x9,
    0xf4, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xeb, 0x0, 0x3, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x80, 0x0, 0xb, 0xf5, 0x0, 0x0,
    0x0, 0x2d, 0xf2, 0x0, 0x0, 0x1b, 0xfc, 0x75,
    0x57, 0xaf, 0xe3, 0x0, 0x0, 0x0, 0x4, 0xad,
    0xff, 0xeb, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x62,

    /* U+C644 "완" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x80,
    0x0, 0x0, 0x1, 0x8c, 0xdc, 0x71, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x2e, 0xe8, 0x69, 0xee, 0x10,
    0xa, 0xf0, 0x0, 0x0, 0xbe, 0x10, 0x0, 0x2f,
    0xa0, 0xa, 0xf0, 0x0, 0x0, 0xf9, 0x0, 0x0,
    0xa, 0xe0, 0xa, 0xf0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0xc, 0xd0, 0xa, 0xf0, 0x0, 0x0, 0x8f,
    0x60, 0x0, 0x7f, 0x70, 0xa, 0xf6, 0x64, 0x0,
    0x9, 0xff, 0xdf, 0xf8, 0x0, 0xa, 0xff, 0xfa,
    0x0, 0x0, 0x27, 0xfb, 0x10, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x1, 0xf9, 0x0, 0x24, 0x1a,
    0xf0, 0x0, 0xb, 0xbc, 0xcd, 0xff, 0xff, 0xff,
    0x4a, 0xf0, 0x0, 0x8, 0xa9, 0x98, 0x87, 0x64,
    0x20, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x4, 0xa4,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x6,
    0xf6, 0x0, 0x0, 0x0, 0x3, 0x50, 0x0, 0x0,
    0x6, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0x0,

    /* U+C694 "요" */
    0x0, 0x0, 0x0, 0x45, 0x65, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x2a, 0xff, 0xfe, 0xff, 0xe7, 0x0,
    0x0, 0x0, 0x4f, 0xe6, 0x10, 0x0, 0x39, 0xfc,
    0x0, 0x0, 0xe, 0xd1, 0x0, 0x0, 0x0, 0x5,
    0xf8, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xc0, 0x0, 0xa, 0xf7, 0x0, 0x0,
    0x0, 0x1c, 0xf4, 0x0, 0x0, 0xa, 0xfe, 0x97,
    0x67, 0xbf, 0xe5, 0x0, 0x0, 0x0, 0xf, 0xec,
    0xee, 0xdb, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xfb,
    0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x1f, 0x90, 0x0, 0x0, 0x0,
    0xf, 0xb0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa6,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x63,

    /* U+C6A9 "용" */
    0x0, 0x0, 0x0, 0x13, 0x32, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5b, 0xff, 0xff, 0xff, 0xc6, 0x0,
    0x0, 0x0, 0x9f, 0xb5, 0x31, 0x12, 0x5b, 0xfa,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x9,
    0xf3, 0x0, 0x2, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0xb, 0xf8, 0x20, 0x0, 0x1,
    0x7f, 0xd0, 0x0, 0x0, 0x8, 0xff, 0xfe, 0xdf,
    0xff, 0xa1, 0x0, 0x0, 0x0, 0xf, 0xb5, 0x66,
    0x5a, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x9f, 0x10, 0x0, 0x9, 0x99, 0x9f, 0xd9,
    0x99, 0x9d, 0xfa, 0x99, 0x91, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6a, 0xcd, 0xdc, 0xa6, 0x10, 0x0, 0x0, 0x3,
    0xef, 0xb8, 0x66, 0x8b, 0xfe, 0x30, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x2, 0xee, 0x0, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0xde, 0x10, 0x0, 0x0, 0x1, 0xde, 0x0,
    0x0, 0x4, 0xff, 0x96, 0x44, 0x59, 0xef, 0x50,
    0x0, 0x0, 0x1, 0x8c, 0xef, 0xfe, 0xc8, 0x20,
    0x0, 0x0,

    /* U+C6B4 "운" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x18, 0xcf, 0xff, 0xfe, 0xa3,
    0x0, 0x0, 0x0, 0x4, 0xff, 0xa6, 0x44, 0x58,
    0xdf, 0x90, 0x0, 0x0, 0xe, 0xe2, 0x0, 0x0,
    0x0, 0xa, 0xf4, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x0, 0x4, 0xf8, 0x0, 0x0, 0xf, 0xd1,
    0x0, 0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0x5,
    0xfe, 0x85, 0x33, 0x47, 0xcf, 0xa0, 0x0, 0x0,
    0x0, 0x29, 0xef, 0xff, 0xff, 0xb5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x22, 0x10, 0x0, 0x0,
    0x0, 0x5, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x51, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x4, 0x30, 0x0,
    0x9f, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x9f, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0x6a, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xd6, 0x66, 0x66, 0x66, 0x66, 0x63,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0,

    /* U+C6CC "워" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x67,
    0x0, 0x0, 0x4, 0x66, 0x30, 0x0, 0x0, 0xdd,
    0x0, 0x6, 0xff, 0xee, 0xfc, 0x20, 0x0, 0xdd,
    0x0, 0x4f, 0xa1, 0x0, 0x3d, 0xe0, 0x0, 0xdd,
    0x0, 0xae, 0x0, 0x0, 0x5, 0xf4, 0x0, 0xdd,
    0x0, 0xae, 0x0, 0x0, 0x5, 0xf4, 0x0, 0xdd,
    0x0, 0x4f, 0x91, 0x0, 0x3d, 0xe0, 0x0, 0xdd,
    0x0, 0x6, 0xff, 0xee, 0xfd, 0x20, 0x0, 0xdd,
    0x0, 0x0, 0x4, 0x66, 0x30, 0x0, 0x0, 0xdd,
    0x3, 0x34, 0x44, 0x55, 0x67, 0x8a, 0x90, 0xdd,
    0xf, 0xff, 0xff, 0xff, 0xfd, 0xca, 0x70, 0xdd,
    0x2, 0x22, 0x12, 0xf9, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x23, 0x33, 0xdd,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0xef, 0xff, 0xfd,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x12, 0x22, 0xdd,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdd,

    /* U+C744 "을" */
    0x0, 0x0, 0x0, 0x23, 0x32, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x6c, 0xff, 0xff, 0xff, 0xd8, 0x10,
    0x0, 0x0, 0xaf, 0xa4, 0x10, 0x1, 0x37, 0xee,
    0x10, 0x0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0x4,
    0xf7, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0x8, 0xfd, 0x74, 0x33, 0x46,
    0xaf, 0xc0, 0x0, 0x0, 0x3, 0x9d, 0xff, 0xff,
    0xeb, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x56, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x62, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x9f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xf3, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0xf, 0xb3, 0x33, 0x33, 0x33, 0x33, 0x30, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0,

    /* U+C74C "음" */
    0x0, 0x0, 0x0, 0x1, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x29, 0xef, 0xff, 0xff, 0xb5, 0x0,
    0x0, 0x0, 0x6f, 0xe8, 0x43, 0x34, 0x6b, 0xfb,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x0, 0x8,
    0xf5, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0xe, 0xe3, 0x0, 0x0, 0x0,
    0x1b, 0xf4, 0x0, 0x0, 0x3e, 0xfc, 0x97, 0x78,
    0xbf, 0xf7, 0x0, 0x0, 0x0, 0x5, 0x9c, 0xdd,
    0xca, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x20, 0x0, 0xf,
    0xfe, 0xee, 0xee, 0xee, 0xef, 0xf5, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x4, 0xf5, 0x0,
    0x0, 0xfc, 0x55, 0x55, 0x55, 0x55, 0x8f, 0x50,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x0,

    /* U+C751 "응" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x28, 0xdf, 0xff, 0xfe, 0xa4, 0x0,
    0x0, 0x0, 0x5f, 0xe8, 0x54, 0x34, 0x7c, 0xfa,
    0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0, 0x8,
    0xf5, 0x0, 0x2, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x70, 0x0, 0xe, 0xe2, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x3e, 0xfc, 0x97, 0x78,
    0xaf, 0xf7, 0x0, 0x0, 0x0, 0x5, 0x9c, 0xdd,
    0xca, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6a, 0xde, 0xed, 0xb7, 0x20, 0x0, 0x0, 0x3,
    0xef, 0xb7, 0x66, 0x79, 0xef, 0x60, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x20, 0x0,
    0xf, 0xa0, 0x0, 0x0, 0x0, 0x5, 0xf5, 0x0,
    0x0, 0xde, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x20,
    0x0, 0x3, 0xef, 0xa6, 0x54, 0x58, 0xdf, 0x70,
    0x0, 0x0, 0x1, 0x7c, 0xef, 0xff, 0xd9, 0x30,
    0x0, 0x0,

    /* U+C774 "이" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x2b, 0xff, 0xe6, 0x0, 0x0, 0xe, 0xb0, 0x1e,
    0xe7, 0x6b, 0xf7, 0x0, 0x0, 0xeb, 0x9, 0xf3,
    0x0, 0xb, 0xf1, 0x0, 0xe, 0xb0, 0xfa, 0x0,
    0x0, 0x3f, 0x70, 0x0, 0xeb, 0x3f, 0x60, 0x0,
    0x0, 0xfa, 0x0, 0xe, 0xb5, 0xf4, 0x0, 0x0,
    0xd, 0xc0, 0x0, 0xeb, 0x5f, 0x30, 0x0, 0x0,
    0xdc, 0x0, 0xe, 0xb4, 0xf5, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0xeb, 0x1f, 0x80, 0x0, 0x1, 0xf8,
    0x0, 0xe, 0xb0, 0xce, 0x0, 0x0, 0x8f, 0x30,
    0x0, 0xeb, 0x3, 0xfb, 0x20, 0x6f, 0xa0, 0x0,
    0xe, 0xb0, 0x6, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0xeb, 0x0, 0x1, 0x67, 0x40, 0x0, 0x0, 0xe,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,

    /* U+C778 "인" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x5c, 0xff, 0xd7, 0x0, 0x0, 0xe, 0xb0,
    0x8, 0xfd, 0x77, 0xbf, 0xb0, 0x0, 0xe, 0xb0,
    0x2f, 0xb0, 0x0, 0x7, 0xf6, 0x0, 0xe, 0xb0,
    0x8f, 0x20, 0x0, 0x0, 0xec, 0x0, 0xe, 0xb0,
    0x9f, 0x0, 0x0, 0x0, 0xcd, 0x0, 0xe, 0xb0,
    0x7f, 0x30, 0x0, 0x0, 0xfb, 0x0, 0xe, 0xb0,
    0x1f, 0xd1, 0x0, 0xa, 0xf5, 0x0, 0xe, 0xb0,
    0x5, 0xff, 0xaa, 0xef, 0x80, 0x0, 0xe, 0xb0,
    0x0, 0x29, 0xcd, 0xa4, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x5, 0x60, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,

    /* U+C785 "입" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x80,
    0x2, 0x9c, 0xca, 0x40, 0x0, 0x0, 0xeb, 0x6,
    0xfe, 0xa9, 0xdf, 0xa0, 0x0, 0xe, 0xb2, 0xfb,
    0x0, 0x0, 0x8f, 0x60, 0x0, 0xeb, 0x7f, 0x20,
    0x0, 0x0, 0xeb, 0x0, 0xe, 0xb9, 0xf0, 0x0,
    0x0, 0xc, 0xd0, 0x0, 0xeb, 0x6f, 0x40, 0x0,
    0x1, 0xfa, 0x0, 0xe, 0xb1, 0xee, 0x40, 0x2,
    0xcf, 0x30, 0x0, 0xeb, 0x3, 0xef, 0xee, 0xff,
    0x60, 0x0, 0xe, 0xb0, 0x0, 0x47, 0x85, 0x10,
    0x0, 0x0, 0xeb, 0x0, 0x3, 0x20, 0x0, 0x0,
    0x0, 0x4, 0x30, 0x0, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0xeb, 0x0, 0xe, 0xb0, 0x0, 0x0, 0x0,
    0xe, 0xb0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0xe, 0xc5, 0x55, 0x55, 0x55, 0x5e,
    0xb0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0xe, 0xc5, 0x55, 0x55, 0x55, 0x5e, 0xb0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+C7A0 "잠" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x60,
    0x0, 0x3, 0x55, 0x55, 0x55, 0x55, 0x50, 0xe,
    0xc0, 0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0xe, 0xc0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0xa, 0xf2,
    0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0xe,
    0xf7, 0x0, 0x0, 0xe, 0xff, 0xf6, 0x0, 0x0,
    0x5f, 0xee, 0x0, 0x0, 0xe, 0xd5, 0x52, 0x0,
    0x2, 0xec, 0x3f, 0xb0, 0x0, 0xe, 0xc0, 0x0,
    0x0, 0x3e, 0xf2, 0x6, 0xfc, 0x30, 0xe, 0xc0,
    0x0, 0xa, 0xfe, 0x30, 0x0, 0x5e, 0xf1, 0xe,
    0xc0, 0x0, 0x7, 0x81, 0x0, 0x0, 0x1, 0x40,
    0xe, 0xc0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11,
    0x11, 0x12, 0x10, 0x0, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x8, 0xf5,
    0x44, 0x44, 0x44, 0x4e, 0xc0, 0x0, 0x0, 0x8,
    0xf1, 0x0, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0,
    0x8, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xc0, 0x0,
    0x0, 0x8, 0xf6, 0x55, 0x55, 0x55, 0x5e, 0xc0,
    0x0, 0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0,

    /* U+C804 "전" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xc0,
    0x5d, 0xdd, 0xdd, 0xdd, 0xdd, 0x20, 0xd, 0xc0,
    0x38, 0x88, 0xbf, 0xa8, 0x88, 0x10, 0xd, 0xc0,
    0x0, 0x0, 0x6f, 0x40, 0x0, 0x0, 0xd, 0xc0,
    0x0, 0x0, 0x8f, 0x60, 0x3, 0x66, 0x6e, 0xc0,
    0x0, 0x0, 0xdf, 0xc0, 0x7, 0xff, 0xff, 0xc0,
    0x0, 0x5, 0xfa, 0xf5, 0x0, 0x0, 0xd, 0xc0,
    0x0, 0x4f, 0xc0, 0xbf, 0x50, 0x0, 0xd, 0xc0,
    0x7, 0xfe, 0x10, 0x1c, 0xfa, 0x20, 0xd, 0xc0,
    0xaf, 0xb1, 0x0, 0x0, 0x9f, 0x20, 0xd, 0xc0,
    0x24, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xc0,
    0x0, 0x3, 0x40, 0x0, 0x0, 0x0, 0xd, 0xc0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+C811 "접" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x82,
    0x66, 0x66, 0x66, 0x66, 0x61, 0x0, 0xbe, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0x40, 0xb, 0xe0, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x0, 0xbe, 0x0, 0x0,
    0x8f, 0x60, 0x0, 0x22, 0x2c, 0xe0, 0x0, 0xd,
    0xfc, 0x0, 0x5f, 0xff, 0xfe, 0x0, 0x5, 0xf9,
    0xf6, 0x1, 0x33, 0x3c, 0xe0, 0x3, 0xfb, 0xb,
    0xf5, 0x0, 0x0, 0xbe, 0x7, 0xfd, 0x10, 0xc,
    0xfa, 0x20, 0xb, 0xea, 0xfb, 0x10, 0x0, 0x8,
    0xf4, 0x0, 0xbe, 0x13, 0x1, 0x20, 0x0, 0x0,
    0x0, 0x5, 0x60, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0, 0xbe, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0xbf, 0x66, 0x66, 0x66, 0x66,
    0xde, 0x0, 0xb, 0xfe, 0xee, 0xee, 0xee, 0xef,
    0xe0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x0, 0xb, 0xf5, 0x55, 0x55, 0x55, 0x5d, 0xe0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe,

    /* U+C815 "정" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x92,
    0x55, 0x55, 0x55, 0x55, 0x51, 0x0, 0xce, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0x30, 0xc, 0xe0, 0x0,
    0x6, 0xf4, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0,
    0x7f, 0x60, 0x0, 0x0, 0xc, 0xe0, 0x0, 0xb,
    0xfa, 0x0, 0x5f, 0xff, 0xfe, 0x0, 0x3, 0xfd,
    0xf3, 0x2, 0x77, 0x7e, 0xe0, 0x0, 0xde, 0x1d,
    0xe2, 0x0, 0x0, 0xce, 0x1, 0xcf, 0x40, 0x3f,
    0xe6, 0x0, 0xc, 0xe7, 0xff, 0x50, 0x0, 0x2d,
    0xf6, 0x0, 0xce, 0x6b, 0x20, 0x0, 0x0, 0x4,
    0x0, 0xc, 0xe0, 0x0, 0x0, 0x0, 0x13, 0x31,
    0x0, 0x11, 0x0, 0x0, 0x3b, 0xff, 0xff, 0xff,
    0xa2, 0x0, 0x0, 0x6f, 0xc6, 0x31, 0x13, 0x7e,
    0xf4, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0x1e,
    0xc0, 0x1, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x0, 0xd, 0xe2, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x3f, 0xfa, 0x65, 0x56, 0xaf, 0xe2, 0x0,
    0x0, 0x17, 0xce, 0xff, 0xeb, 0x70, 0x0,

    /* U+C871 "족" */
    0x7, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0xbb, 0x70,
    0x0, 0x7a, 0xaa, 0xaa, 0xff, 0xba, 0xaa, 0xa7,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xda, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xaf, 0xd2, 0xa, 0xfc,
    0x50, 0x0, 0x1, 0xcf, 0xfe, 0x70, 0x46, 0x5,
    0xdf, 0xfc, 0x10, 0x7, 0x73, 0x0, 0xa, 0xf0,
    0x0, 0x26, 0x70, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x0, 0x0, 0xaa, 0xaa, 0xaa, 0xae,
    0xfa, 0xaa, 0xaa, 0xaa, 0x3b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xbb, 0xbb, 0xbb, 0xb4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x25, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x50, 0x0, 0x6, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0,

    /* U+C8FC "주" */
    0x3, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x50,
    0x0, 0x6e, 0xee, 0xee, 0xff, 0xfe, 0xee, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xdd, 0x9f, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xee, 0x20, 0xbf,
    0x91, 0x0, 0x0, 0x4, 0x8d, 0xfb, 0x10, 0x0,
    0x8f, 0xf9, 0x51, 0x0, 0xbf, 0xa4, 0x0, 0x0,
    0x0, 0x18, 0xdf, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x52, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x0,

    /* U+C911 "중" */
    0x5, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x90,
    0x0, 0x5b, 0xbb, 0xbb, 0xff, 0xcb, 0xbb, 0xba,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2d, 0xda, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x8f, 0xd2, 0xa, 0xfb,
    0x40, 0x0, 0x0, 0xad, 0xfe, 0x80, 0x0, 0x5,
    0xcf, 0xfb, 0x30, 0x6, 0x84, 0x0, 0x0, 0x0,
    0x0, 0x26, 0x90, 0x4, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x41, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x51, 0x11, 0x11, 0x11,
    0xbf, 0x11, 0x11, 0x11, 0x10, 0x0, 0x0, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x9c, 0xff, 0xca, 0x71, 0x0, 0x0, 0x0, 0x2d,
    0xfc, 0x97, 0x78, 0xbf, 0xf6, 0x0, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0x0, 0x1b, 0xf3, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0xd, 0xe1, 0x0, 0x0, 0x0, 0x9, 0xf3, 0x0,
    0x0, 0x4f, 0xfa, 0x64, 0x45, 0x8d, 0xf9, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xff, 0xfd, 0x93, 0x0,
    0x0,

    /* U+C9C0 "지" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x5, 0xbb, 0xbb, 0xbb, 0xbb, 0xb6, 0x0, 0xeb,
    0x5, 0xbb, 0xbc, 0xfd, 0xbb, 0xb7, 0x0, 0xeb,
    0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0xa, 0xfd, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x1f, 0xdf, 0x30, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x8f, 0x2e, 0xc0, 0x0, 0x0, 0xeb,
    0x0, 0x3, 0xfa, 0x5, 0xf8, 0x0, 0x0, 0xeb,
    0x0, 0x1e, 0xf1, 0x0, 0xaf, 0x80, 0x0, 0xeb,
    0x4, 0xef, 0x40, 0x0, 0xb, 0xfc, 0x0, 0xeb,
    0xb, 0xf5, 0x0, 0x0, 0x0, 0x79, 0x0, 0xeb,
    0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,

    /* U+C9C4 "진" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0xb, 0xe0,
    0x15, 0x55, 0x7f, 0xa5, 0x55, 0x30, 0xb, 0xe0,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0xaf, 0xf0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x2, 0xfa, 0xf9, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x1d, 0xe1, 0x7f, 0x80, 0x0, 0xb, 0xe0,
    0x4, 0xef, 0x40, 0x9, 0xfc, 0x40, 0xb, 0xe0,
    0x7f, 0xe4, 0x0, 0x0, 0x6e, 0xc0, 0xb, 0xe0,
    0x17, 0x10, 0x0, 0x0, 0x0, 0x10, 0xb, 0xe0,
    0x0, 0x3, 0x40, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,

    /* U+CC3E "찾" */
    0x0, 0x0, 0x4a, 0x10, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x7, 0xf3, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x37, 0x77, 0xbf, 0x87, 0x77, 0x10, 0xaf,
    0x0, 0x7, 0xee, 0xef, 0xfe, 0xee, 0xe2, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0,
    0xaf, 0x11, 0x0, 0x0, 0xa, 0xf6, 0x0, 0x0,
    0xa, 0xff, 0xfa, 0x0, 0x2, 0xff, 0xd0, 0x0,
    0x0, 0xaf, 0x44, 0x30, 0x0, 0xce, 0x4f, 0xa0,
    0x0, 0xa, 0xf0, 0x0, 0x3, 0xdf, 0x40, 0x6f,
    0xd4, 0x0, 0xaf, 0x0, 0xa, 0xfe, 0x40, 0x0,
    0x4d, 0xf5, 0xa, 0xf0, 0x0, 0x57, 0x10, 0x0,
    0x0, 0x4, 0x0, 0xaf, 0x0, 0x0, 0x2, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x41, 0x0, 0x0, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0,
    0x11, 0x11, 0xaf, 0x71, 0x11, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xd2, 0xee, 0x40, 0x0, 0x0,
    0x0, 0x26, 0xcf, 0xb1, 0x2, 0xcf, 0xb5, 0x10,
    0x0, 0xe, 0xfb, 0x40, 0x0, 0x0, 0x6c, 0xfc,
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x10, 0x0,

    /* U+CD08 "초" */
    0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x5a, 0xaa, 0xaa, 0xef, 0xaa, 0xaa,
    0xa9, 0x0, 0x5, 0xbb, 0xbb, 0xbe, 0xfb, 0xbb,
    0xbb, 0x90, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xfb,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 0xf5,
    0x1d, 0xf5, 0x0, 0x0, 0x0, 0x3, 0x9f, 0xf5,
    0x0, 0x1c, 0xfc, 0x50, 0x0, 0xd, 0xff, 0x91,
    0x1, 0x20, 0x6, 0xdf, 0xf3, 0x0, 0x44, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x26, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
    0x20,

    /* U+CD5C "최" */
    0x0, 0x0, 0x4, 0x60, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x0, 0xbe, 0x0, 0x0, 0x0, 0xeb, 0x4,
    0x55, 0x5d, 0xf5, 0x55, 0x50, 0xe, 0xb0, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0x10, 0xeb, 0x0, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x1,
    0xff, 0x30, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x8f,
    0xeb, 0x0, 0x0, 0xe, 0xb0, 0x0, 0x4f, 0x95,
    0xf9, 0x0, 0x0, 0xeb, 0x0, 0x8f, 0xc0, 0x8,
    0xfc, 0x40, 0xe, 0xb1, 0xef, 0xa0, 0x0, 0x5,
    0xef, 0x30, 0xeb, 0x5, 0x30, 0xb, 0xe0, 0x0,
    0x40, 0xe, 0xb0, 0x0, 0x0, 0xbe, 0x0, 0x0,
    0x0, 0xeb, 0x0, 0x0, 0xb, 0xe0, 0x0, 0x1,
    0xe, 0xb6, 0x88, 0x99, 0xef, 0xbc, 0xdf, 0xf0,
    0xeb, 0x9d, 0xdd, 0xcc, 0xba, 0x87, 0x42, 0xe,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xeb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xb0,

    /* U+CDA9 "충" */
    0x0, 0x0, 0x0, 0x6, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xcc, 0xcc, 0xce, 0xfc, 0xcc, 0xcc,
    0x80, 0x0, 0x29, 0x99, 0x99, 0xef, 0x99, 0x99,
    0x96, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2d, 0xeb, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x14, 0xaf, 0xd2, 0xa,
    0xfc, 0x62, 0x0, 0x0, 0xdf, 0xfc, 0x60, 0x0,
    0x4, 0xaf, 0xff, 0x30, 0x4, 0x41, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x50, 0xa, 0xaa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xaa, 0xaa, 0xa3, 0xbb, 0xbb, 0xbb,
    0xbe, 0xfb, 0xbb, 0xbb, 0xbb, 0x30, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x6d, 0xf6, 0x51, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xfe, 0xcc, 0xdf, 0xfc, 0x30, 0x0, 0x0,
    0xaf, 0x71, 0x0, 0x0, 0x4, 0xdf, 0x10, 0x0,
    0xf, 0xb0, 0x0, 0x0, 0x0, 0x4, 0xf6, 0x0,
    0x0, 0xed, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x40,
    0x0, 0x5, 0xfe, 0x85, 0x44, 0x57, 0xcf, 0xa0,
    0x0, 0x0, 0x2, 0x8c, 0xef, 0xff, 0xda, 0x40,
    0x0, 0x0,

    /* U+CE5C "친" */
    0x0, 0x0, 0x7, 0x40, 0x0, 0x0, 0x4, 0x60,
    0x0, 0x0, 0xf, 0x90, 0x0, 0x0, 0xb, 0xe0,
    0x1, 0x11, 0x2f, 0xa1, 0x11, 0x0, 0xb, 0xe0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0xb, 0xe0,
    0x4, 0x44, 0x4f, 0xa4, 0x44, 0x20, 0xb, 0xe0,
    0x0, 0x0, 0x1f, 0xa0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x5f, 0xe0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0xdd, 0xf8, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x9, 0xf4, 0x9f, 0x60, 0x0, 0xb, 0xe0,
    0x1, 0xbf, 0x80, 0xb, 0xfa, 0x20, 0xb, 0xe0,
    0x5f, 0xf7, 0x0, 0x0, 0x8f, 0xd0, 0xb, 0xe0,
    0x19, 0x20, 0x0, 0x0, 0x1, 0x20, 0xb, 0xe0,
    0x0, 0x3, 0x40, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,

    /* U+CE74 "카" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x4, 0x77, 0x77, 0x77, 0x83, 0x0, 0xaf,
    0x0, 0x0, 0x9e, 0xee, 0xee, 0xff, 0x70, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf6, 0x0,
    0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xf1,
    0x0, 0xaf, 0x0, 0x5, 0xbc, 0xdf, 0xff, 0xfd,
    0x0, 0xa, 0xf3, 0x32, 0x4b, 0x98, 0x65, 0x7f,
    0x80, 0x0, 0xaf, 0xff, 0xe0, 0x0, 0x0, 0xc,
    0xf1, 0x0, 0xa, 0xf3, 0x32, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x4,
    0xfd, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x5,
    0xfe, 0x10, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x1a,
    0xfd, 0x10, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x4e,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x1,
    0xb3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0,

    /* U+CE94 "캔" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x31, 0x4, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0x8, 0xf0,
    0xf, 0xff, 0xff, 0xff, 0x1, 0xf8, 0x8, 0xf0,
    0x6, 0x66, 0x66, 0xde, 0x1, 0xf8, 0x8, 0xf0,
    0x0, 0x0, 0x0, 0xdb, 0x1, 0xf8, 0x8, 0xf0,
    0x35, 0x67, 0x89, 0xf7, 0x1, 0xf8, 0x8, 0xf0,
    0xbf, 0xfd, 0xbe, 0xf2, 0x1, 0xff, 0xff, 0xf0,
    0x10, 0x0, 0x3f, 0x90, 0x1, 0xfb, 0x6b, 0xf0,
    0x0, 0x2, 0xed, 0x0, 0x1, 0xf8, 0x8, 0xf0,
    0x0, 0x5f, 0xd2, 0x0, 0x1, 0xf8, 0x8, 0xf0,
    0x4c, 0xfb, 0x10, 0x0, 0x1, 0xf8, 0x8, 0xf0,
    0x6d, 0x50, 0x0, 0x0, 0x1, 0xf8, 0x8, 0xf0,
    0x0, 0x5, 0x90, 0x0, 0x1, 0xf8, 0x8, 0xf0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x73, 0x8, 0xf0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+CF1C "켜" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x5, 0x77, 0x77, 0x77, 0x72, 0x0, 0x9, 0xf1,
    0xb, 0xee, 0xee, 0xef, 0xf5, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x5, 0xf3, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x8, 0xf8, 0x66, 0x6c, 0xf1,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xf1,
    0x6b, 0xcd, 0xef, 0xff, 0xa0, 0x0, 0x9, 0xf1,
    0x7d, 0xb9, 0x86, 0xaf, 0x50, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0xed, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x9, 0xf5, 0x36, 0x66, 0x6c, 0xf1,
    0x0, 0x0, 0x7f, 0xa0, 0x7f, 0xff, 0xff, 0xf1,
    0x0, 0x8, 0xfc, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x1, 0xbf, 0xc0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x6f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x2b, 0x30, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,

    /* U+D06C "크" */
    0x0, 0xee, 0xee, 0xee, 0xee, 0xee, 0xff, 0x50,
    0x0, 0x7, 0x77, 0x77, 0x77, 0x77, 0x79, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x12, 0x33, 0x45, 0x56, 0x77,
    0x8b, 0xf4, 0x0, 0x7, 0xff, 0xff, 0xff, 0xed,
    0xcb, 0xdf, 0x30, 0x0, 0x13, 0x21, 0x0, 0x0,
    0x0, 0x7, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0x30, 0x0, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+D0DC "태" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x85,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x6, 0x66, 0x66, 0x66, 0x0, 0xf9, 0x0, 0xf9,
    0x1f, 0xff, 0xff, 0xff, 0x0, 0xf9, 0x0, 0xf9,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x1f, 0xda, 0xaa, 0xa8, 0x0, 0xfb, 0x44, 0xf9,
    0x1f, 0xda, 0xaa, 0xa7, 0x0, 0xff, 0xff, 0xf9,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0xf9, 0x11, 0xf9,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x1f, 0x70, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x2f, 0xc8, 0x89, 0xac, 0xa0, 0xf9, 0x0, 0xf9,
    0x1e, 0xed, 0xdc, 0xb9, 0x60, 0xf9, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf9, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa5, 0x0, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf9,

    /* U+D130 "터" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xce, 0x2f,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0xc, 0xe2, 0xfb,
    0x66, 0x66, 0x66, 0x10, 0x0, 0xce, 0x2f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xe2, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x2f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xe2, 0xff, 0xff, 0xff,
    0xf6, 0x7f, 0xff, 0xfe, 0x2f, 0xa5, 0x55, 0x55,
    0x23, 0x66, 0x6d, 0xe2, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xce, 0x2f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xe2, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xce, 0x2f, 0x70, 0x0, 0x2, 0x46, 0x20,
    0xc, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0,
    0xce, 0x16, 0x66, 0x65, 0x53, 0x20, 0x0, 0xc,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xce,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xce, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0,

    /* U+D15C "템" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x84,
    0x5, 0x55, 0x55, 0x54, 0x0, 0xcd, 0x1, 0xf8,
    0x1f, 0xff, 0xff, 0xfb, 0x0, 0xcd, 0x1, 0xf8,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0xcd, 0x1, 0xf8,
    0x1f, 0x80, 0x0, 0x0, 0x22, 0xcd, 0x1, 0xf8,
    0x1f, 0xff, 0xff, 0xf2, 0xff, 0xfd, 0x1, 0xf8,
    0x1f, 0xa5, 0x55, 0x50, 0x33, 0xdd, 0x1, 0xf8,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0xcd, 0x1, 0xf8,
    0x1f, 0x80, 0x1, 0x25, 0x40, 0xcd, 0x1, 0xf8,
    0x3f, 0xff, 0xff, 0xff, 0x90, 0xcd, 0x1, 0xf8,
    0x5, 0x55, 0x54, 0x31, 0x0, 0xcd, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x52,
    0x0, 0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x9, 0xf7, 0x66, 0x66, 0x66, 0x67, 0xf8,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x1, 0xf8,
    0x0, 0x9, 0xf1, 0x0, 0x0, 0x0, 0x1, 0xf8,
    0x0, 0x9, 0xf6, 0x55, 0x55, 0x55, 0x56, 0xf8,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+D2B8 "트" */
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0xe, 0xd6, 0x66, 0x66, 0x66, 0x66, 0x62,
    0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x0, 0xe, 0xd6, 0x66, 0x66, 0x66,
    0x66, 0x50, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0x60, 0x0, 0x8, 0x99, 0x99,
    0x99, 0x99, 0x99, 0x94, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x10,

    /* U+D31F "팟" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x47, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x50, 0xaf,
    0x0, 0x2, 0x6c, 0xf6, 0x67, 0xfb, 0x62, 0xa,
    0xf0, 0x0, 0x0, 0xaf, 0x0, 0x1f, 0x80, 0x0,
    0xaf, 0x0, 0x0, 0xa, 0xf0, 0x1, 0xf8, 0x0,
    0xa, 0xf6, 0x64, 0x0, 0xaf, 0x0, 0x1f, 0x80,
    0x0, 0xaf, 0xff, 0xa0, 0xa, 0xf0, 0x1, 0xf8,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0xaf, 0x0, 0x1f,
    0x93, 0x50, 0xaf, 0x0, 0xc, 0xdf, 0xfe, 0xff,
    0xff, 0xfe, 0x2a, 0xf0, 0x0, 0x78, 0x87, 0x76,
    0x54, 0x21, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x10, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf6, 0x0, 0x7b, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0xe2, 0xde, 0x40, 0x0, 0x0,
    0x0, 0x3, 0xaf, 0xd2, 0x1, 0xcf, 0xb4, 0x0,
    0x0, 0x1e, 0xff, 0x80, 0x0, 0x0, 0x7e, 0xff,
    0x20, 0x0, 0x65, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x70, 0x0,

    /* U+D328 "패" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x10, 0x58,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x9f,
    0x5, 0x55, 0x55, 0x55, 0x52, 0x1f, 0x70, 0x9f,
    0xf, 0xff, 0xff, 0xff, 0xf7, 0x1f, 0x70, 0x9f,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0xa4, 0xbf,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0xff, 0xff,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0x82, 0xaf,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x7f, 0x10, 0x9e, 0x0, 0x1f, 0x70, 0x9f,
    0x26, 0xaf, 0x77, 0xcf, 0xaa, 0x1f, 0x70, 0x9f,
    0x3f, 0xff, 0xfe, 0xdb, 0x97, 0x1f, 0x70, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x40, 0x9f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,

    /* U+D558 "하" */
    0x0, 0x0, 0x3, 0x50, 0x0, 0x0, 0x6, 0x70,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xb,
    0xe0, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0,
    0xb, 0xe0, 0x0, 0x1a, 0xaa, 0xad, 0xfa, 0xaa,
    0xa5, 0xb, 0xe0, 0x0, 0x1b, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb5, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x0,
    0x7b, 0xca, 0x40, 0x0, 0xb, 0xe0, 0x0, 0x0,
    0x1d, 0xfb, 0x9d, 0xf8, 0x0, 0xb, 0xe1, 0x11,
    0x0, 0xaf, 0x30, 0x0, 0x9f, 0x40, 0xb, 0xff,
    0xfd, 0x0, 0xfa, 0x0, 0x0, 0xf, 0xa0, 0xb,
    0xf4, 0x44, 0x1, 0xf8, 0x0, 0x0, 0xe, 0xb0,
    0xb, 0xe0, 0x0, 0x0, 0xeb, 0x0, 0x0, 0x1f,
    0x80, 0xb, 0xe0, 0x0, 0x0, 0x8f, 0x70, 0x1,
    0xcf, 0x20, 0xb, 0xe0, 0x0, 0x0, 0x9, 0xff,
    0xef, 0xf5, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x0,
    0x27, 0x86, 0x10, 0x0, 0xb, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xe0, 0x0,

    /* U+D55C "한" */
    0x0, 0x0, 0x2, 0x40, 0x0, 0x0, 0x3, 0x40,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x1, 0x11, 0x1a, 0xf2, 0x11, 0x10,
    0xa, 0xf0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0xa, 0xf0, 0x0, 0x3, 0x33, 0x33, 0x33,
    0x33, 0x32, 0xa, 0xf0, 0x0, 0x0, 0x1, 0x8b,
    0xcb, 0x60, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x3f,
    0xe8, 0x79, 0xfd, 0x10, 0xa, 0xf6, 0x64, 0x0,
    0xce, 0x10, 0x0, 0x3f, 0x80, 0xa, 0xff, 0xfa,
    0x0, 0xfa, 0x0, 0x0, 0xe, 0xa0, 0xa, 0xf0,
    0x0, 0x0, 0xce, 0x10, 0x0, 0x3f, 0x80, 0xa,
    0xf0, 0x0, 0x0, 0x3f, 0xe8, 0x79, 0xfd, 0x10,
    0xa, 0xf0, 0x0, 0x0, 0x2, 0x9c, 0xdc, 0x71,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x3, 0xd4,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x3,
    0xf4, 0x0, 0x0, 0x0, 0x2, 0x30, 0x0, 0x0,
    0x3, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x0,

    /* U+D560 "할" */
    0x0, 0x0, 0x6, 0xb0, 0x0, 0x0, 0x5, 0x90,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x1e, 0xee, 0xef, 0xfe, 0xee, 0xe8,
    0xa, 0xf0, 0x0, 0x6, 0x66, 0x66, 0x66, 0x66,
    0x63, 0xa, 0xf0, 0x0, 0x0, 0x2, 0x8b, 0xcb,
    0x71, 0x0, 0xa, 0xf4, 0x32, 0x0, 0x5f, 0xd8,
    0x78, 0xee, 0x20, 0xa, 0xff, 0xfb, 0x0, 0xdd,
    0x0, 0x0, 0x1f, 0x90, 0xa, 0xf3, 0x21, 0x0,
    0xeb, 0x0, 0x0, 0xf, 0xa0, 0xa, 0xf0, 0x0,
    0x0, 0x8f, 0x82, 0x13, 0xbf, 0x40, 0xa, 0xf0,
    0x0, 0x0, 0x7, 0xef, 0xff, 0xc4, 0x0, 0xa,
    0xf0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x4, 0x60, 0x0, 0x0, 0x6, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xe0, 0x0, 0x0, 0x2, 0x55, 0x55,
    0x55, 0x55, 0x5b, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x6, 0xf5, 0x44, 0x44, 0x44, 0x44, 0x40, 0x0,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xee, 0xee, 0xee, 0xee,
    0xea, 0x0,

    /* U+D569 "합" */
    0x0, 0x0, 0x6, 0xc0, 0x0, 0x0, 0x5, 0x90,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x1b, 0xbb, 0xbe, 0xfc, 0xbb, 0xb6,
    0xa, 0xf0, 0x0, 0x9, 0x99, 0x99, 0x99, 0x99,
    0x95, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x47, 0x87,
    0x30, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x1d, 0xfd,
    0xce, 0xfa, 0x0, 0xa, 0xff, 0xfa, 0x0, 0xbf,
    0x30, 0x0, 0x6f, 0x70, 0xa, 0xf7, 0x75, 0x0,
    0xea, 0x0, 0x0, 0xe, 0xa0, 0xa, 0xf0, 0x0,
    0x0, 0xdd, 0x0, 0x0, 0x2f, 0x90, 0xa, 0xf0,
    0x0, 0x0, 0x4f, 0xd8, 0x69, 0xee, 0x10, 0xa,
    0xf0, 0x0, 0x0, 0x2, 0x9c, 0xdc, 0x81, 0x0,
    0x9, 0xf0, 0x0, 0x0, 0x2, 0x81, 0x0, 0x0,
    0x0, 0x5, 0x80, 0x0, 0x0, 0x5, 0xf3, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x5, 0xf7,
    0x55, 0x55, 0x55, 0x5b, 0xf0, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x5, 0xf7, 0x55, 0x55, 0x55, 0x5c, 0xf0,
    0x0, 0x0, 0x5, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0x0,

    /* U+D56B "핫" */
    0x0, 0x0, 0x7, 0xd1, 0x0, 0x0, 0x5, 0x80,
    0x0, 0x0, 0x0, 0x9, 0xf1, 0x0, 0x0, 0xa,
    0xf0, 0x0, 0x1a, 0xaa, 0xad, 0xfb, 0xaa, 0xa6,
    0xa, 0xf0, 0x0, 0x1a, 0xaa, 0xaa, 0xaa, 0xaa,
    0xa6, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x14, 0x53,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x9, 0xff,
    0xff, 0xe5, 0x0, 0xa, 0xf4, 0x43, 0x0, 0x8f,
    0x82, 0x13, 0xbf, 0x40, 0xa, 0xff, 0xfa, 0x0,
    0xec, 0x0, 0x0, 0xf, 0x90, 0xa, 0xf1, 0x11,
    0x0, 0xeb, 0x0, 0x0, 0xf, 0x90, 0xa, 0xf0,
    0x0, 0x0, 0x8f, 0x81, 0x2, 0xaf, 0x30, 0xa,
    0xf0, 0x0, 0x0, 0x8, 0xff, 0xff, 0xe5, 0x0,
    0xa, 0xf0, 0x0, 0x0, 0x0, 0x3, 0x43, 0x0,
    0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x50, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x90, 0x1, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xef, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3d, 0xe2, 0xde, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x4a, 0xfd, 0x20, 0x1c, 0xfb, 0x40,
    0x0, 0x0, 0x1f, 0xfe, 0x70, 0x0, 0x0, 0x6d,
    0xff, 0x20, 0x0, 0x5, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x25, 0x0,

    /* U+D588 "했" */
    0x0, 0x1, 0xa5, 0x0, 0x0, 0x10, 0x5, 0xb1,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0xf, 0x90, 0x7f,
    0x10, 0x9b, 0xbb, 0xfd, 0xbb, 0xb3, 0xf9, 0x7,
    0xf1, 0x9, 0xaa, 0xaa, 0xaa, 0xaa, 0x2f, 0x90,
    0x7f, 0x10, 0x0, 0x2, 0x32, 0x0, 0x0, 0xf9,
    0x7, 0xf1, 0x0, 0x3d, 0xff, 0xfd, 0x30, 0xf,
    0xc6, 0xbf, 0x10, 0x1e, 0xd5, 0x25, 0xde, 0x10,
    0xff, 0xff, 0xf1, 0x5, 0xf3, 0x0, 0x3, 0xf5,
    0xf, 0x90, 0x7f, 0x10, 0x4f, 0x40, 0x0, 0x4f,
    0x40, 0xf9, 0x7, 0xf1, 0x0, 0xce, 0x74, 0x7e,
    0xc0, 0xf, 0x90, 0x7f, 0x10, 0x0, 0x8d, 0xfd,
    0x81, 0x0, 0xf9, 0x7, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0x50, 0x6d, 0x10, 0x0, 0x0,
    0x2b, 0x40, 0x0, 0x6, 0xb0, 0x0, 0x0, 0x0,
    0x4, 0xf6, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x0,
    0x0, 0x9f, 0xa0, 0x0, 0xe, 0xf6, 0x0, 0x0,
    0x0, 0x4f, 0xaf, 0x30, 0x7, 0xfc, 0xe1, 0x0,
    0x0, 0x6f, 0xc0, 0xae, 0x46, 0xf9, 0x1e, 0xd3,
    0x0, 0x9f, 0xa0, 0x0, 0xcf, 0xfb, 0x0, 0x2d,
    0xf4, 0x1, 0x40, 0x0, 0x0, 0x67, 0x0, 0x0,
    0x5, 0x0,

    /* U+D654 "화" */
    0x0, 0x0, 0x4, 0x20, 0x0, 0x0, 0x34, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0xb, 0xf0,
    0x0, 0x12, 0x22, 0x3f, 0xa2, 0x22, 0x20, 0xbf,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2b,
    0xf0, 0x0, 0x23, 0x33, 0x33, 0x33, 0x33, 0x30,
    0xbf, 0x0, 0x0, 0x2, 0x9d, 0xfd, 0x92, 0x0,
    0xb, 0xf0, 0x0, 0x2, 0xee, 0x75, 0x7e, 0xf2,
    0x0, 0xbf, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x1f,
    0xa0, 0xb, 0xf0, 0x0, 0xb, 0xd0, 0x0, 0x0,
    0xdc, 0x0, 0xbf, 0xff, 0xb0, 0x8f, 0x30, 0x0,
    0x3f, 0x90, 0xb, 0xf7, 0x75, 0x1, 0xdf, 0xb9,
    0xbf, 0xd1, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x6a,
    0xfd, 0x60, 0x0, 0xb, 0xf0, 0x0, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0x0, 0xbf, 0x0, 0x7, 0x77,
    0x89, 0xfd, 0xab, 0xce, 0x6b, 0xf0, 0x0, 0xce,
    0xee, 0xdd, 0xcb, 0x97, 0x51, 0xbf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x0, 0x0,

    /* U+D655 "확" */
    0x0, 0x0, 0xb, 0x60, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x6e, 0xee, 0xef, 0xfe, 0xee, 0xd0, 0xaf,
    0x0, 0x2, 0x55, 0x55, 0x55, 0x55, 0x55, 0xa,
    0xf0, 0x0, 0x0, 0x4b, 0xef, 0xeb, 0x40, 0x0,
    0xaf, 0x0, 0x0, 0x5f, 0xb4, 0x34, 0xaf, 0x60,
    0xa, 0xf1, 0x10, 0xa, 0xf0, 0x0, 0x0, 0xeb,
    0x0, 0xaf, 0xff, 0xa0, 0x7f, 0x40, 0x0, 0x3f,
    0x90, 0xa, 0xf5, 0x53, 0x0, 0x9f, 0xdb, 0xdf,
    0xa0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x4, 0xfa,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x67, 0x88, 0x9f,
    0xda, 0xbc, 0xe7, 0xaf, 0x0, 0xa, 0xdd, 0xdc,
    0xcb, 0xa8, 0x74, 0x1a, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x69, 0x0, 0x0, 0x5,
    0x66, 0x66, 0x66, 0x66, 0x66, 0x60, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0,

    /* U+D658 "환" */
    0x0, 0x0, 0x9, 0x50, 0x0, 0x0, 0x58, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x5c, 0xcc, 0xcf, 0xec, 0xcc, 0xb0, 0xaf,
    0x0, 0x3, 0x77, 0x77, 0x77, 0x77, 0x77, 0xa,
    0xf0, 0x0, 0x0, 0x29, 0xcd, 0xc9, 0x20, 0x0,
    0xaf, 0x0, 0x0, 0x3f, 0xd7, 0x56, 0xcf, 0x40,
    0xa, 0xf0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0xeb,
    0x0, 0xaf, 0x33, 0x20, 0x9f, 0x10, 0x0, 0xe,
    0xb0, 0xa, 0xff, 0xfa, 0x2, 0xee, 0x76, 0x7d,
    0xf3, 0x0, 0xaf, 0x22, 0x10, 0x1, 0x7b, 0xfd,
    0x82, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x1f,
    0x90, 0x13, 0x52, 0xaf, 0x0, 0xa, 0xcd, 0xde,
    0xff, 0xff, 0xfe, 0x5a, 0xf0, 0x0, 0x68, 0x88,
    0x76, 0x54, 0x20, 0x0, 0xaf, 0x0, 0x0, 0x3,
    0x83, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0x6a, 0x0, 0x0,
    0x6, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xa6, 0x66, 0x66, 0x66, 0x66, 0x40,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa,
    0x0,

    /* U+D65C "활" */
    0x0, 0x0, 0x8, 0x40, 0x0, 0x0, 0x59, 0x0,
    0x0, 0x0, 0x1, 0xf9, 0x0, 0x0, 0xa, 0xf0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xaf,
    0x0, 0x1, 0x22, 0x36, 0x76, 0x42, 0x22, 0xa,
    0xf0, 0x0, 0x1, 0xaf, 0xcb, 0xcf, 0xb1, 0x0,
    0xaf, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x1e, 0xa0,
    0xa, 0xff, 0xfa, 0x9, 0xf3, 0x0, 0x2, 0xfa,
    0x0, 0xaf, 0x77, 0x40, 0x1a, 0xfd, 0xbd, 0xfb,
    0x10, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x11, 0xaf, 0x0, 0x9, 0xbb, 0xbc, 0xfe,
    0xde, 0xff, 0x6a, 0xf0, 0x0, 0x68, 0x88, 0x77,
    0x65, 0x32, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x1,
    0x22, 0x22, 0x22, 0x22, 0x2a, 0xf0, 0x0, 0x0,
    0x24, 0x44, 0x44, 0x44, 0x44, 0xbf, 0x0, 0x0,
    0xa, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd0, 0x0,
    0x0, 0xaf, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xfd, 0xdd, 0xdd, 0xdd, 0xdd, 0xd9,
    0x0,

    /* U+D6C4 "후" */
    0x0, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0xbb, 0xbb, 0xbe, 0xfb, 0xbb, 0xbb,
    0xb4, 0x1, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xaa, 0x40, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x29, 0xdf, 0xff, 0xfe,
    0xa4, 0x0, 0x0, 0x0, 0x3f, 0xe8, 0x43, 0x34,
    0x6c, 0xf7, 0x0, 0x0, 0xa, 0xf2, 0x0, 0x0,
    0x0, 0xc, 0xf0, 0x0, 0x0, 0x9f, 0x30, 0x0,
    0x0, 0x0, 0xdf, 0x0, 0x0, 0x2, 0xef, 0xa6,
    0x55, 0x68, 0xef, 0x60, 0x0, 0x0, 0x0, 0x6b,
    0xde, 0xee, 0xc8, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0x59, 0x99,
    0x99, 0x99, 0xdf, 0x99, 0x99, 0x99, 0x93, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0,

    /* U+FF01 "！" */
    0x2f, 0xf0, 0x1f, 0xf0, 0x1f, 0xf0, 0xf, 0xf0,
    0xf, 0xe0, 0xf, 0xd0, 0xe, 0xc0, 0xd, 0xb0,
    0xc, 0xb0, 0xb, 0xa0, 0x1, 0x10, 0x0, 0x0,
    0x6, 0x60, 0x4f, 0xf2, 0x2f, 0xe1, 0x0, 0x0,

    /* U+FF0C "，" */
    0x2, 0xa9, 0x0, 0x9f, 0xf6, 0x5, 0xff, 0x90,
    0x1, 0xe7, 0x0, 0x4f, 0x20, 0x5f, 0x80, 0x1e,
    0x60, 0x0, 0x0, 0x0,

    /* U+FF1A "：" */
    0x3c, 0xa0, 0xbf, 0xf4, 0x6f, 0xe1, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4d, 0xb0, 0xbf, 0xf4,
    0x6f, 0xd1, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 83, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 86, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21, .adv_w = 131, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 39, .adv_w = 207, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 130, .adv_w = 183, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 215, .adv_w = 266, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 327, .adv_w = 234, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 425, .adv_w = 72, .box_w = 3, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 434, .adv_w = 96, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 488, .adv_w = 96, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 542, .adv_w = 176, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 597, .adv_w = 183, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 647, .adv_w = 86, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 657, .adv_w = 103, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 663, .adv_w = 86, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 668, .adv_w = 119, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 724, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 801, .adv_w = 183, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 850, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 927, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1004, .adv_w = 183, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1088, .adv_w = 183, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1158, .adv_w = 183, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1228, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1305, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1382, .adv_w = 183, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1452, .adv_w = 86, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1469, .adv_w = 86, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1497, .adv_w = 183, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1552, .adv_w = 183, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1587, .adv_w = 183, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1642, .adv_w = 139, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1705, .adv_w = 288, .box_w = 16, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 1833, .adv_w = 204, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1924, .adv_w = 208, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2001, .adv_w = 202, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2085, .adv_w = 234, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2176, .adv_w = 178, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2239, .adv_w = 166, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2302, .adv_w = 233, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2393, .adv_w = 237, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2477, .adv_w = 108, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2519, .adv_w = 87, .box_w = 6, .box_h = 18, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 2573, .adv_w = 198, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2657, .adv_w = 168, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2720, .adv_w = 290, .box_w = 16, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2832, .adv_w = 243, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2923, .adv_w = 250, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3021, .adv_w = 194, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3098, .adv_w = 250, .box_w = 14, .box_h = 17, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3217, .adv_w = 199, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3301, .adv_w = 176, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3371, .adv_w = 178, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3448, .adv_w = 234, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3532, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3616, .adv_w = 298, .box_w = 19, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3749, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3833, .adv_w = 181, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3917, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3994, .adv_w = 105, .box_w = 6, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 4048, .adv_w = 119, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4104, .adv_w = 105, .box_w = 5, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4149, .adv_w = 183, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4199, .adv_w = 142, .box_w = 10, .box_h = 3, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 4214, .adv_w = 90, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 12},
    {.bitmap_index = 4222, .adv_w = 180, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4277, .adv_w = 197, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4360, .adv_w = 154, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4404, .adv_w = 197, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4479, .adv_w = 180, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4534, .adv_w = 110, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4594, .adv_w = 197, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 4674, .adv_w = 198, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4749, .adv_w = 83, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4772, .adv_w = 83, .box_w = 6, .box_h = 20, .ofs_x = -2, .ofs_y = -5},
    {.bitmap_index = 4832, .adv_w = 171, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4907, .adv_w = 83, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4930, .adv_w = 299, .box_w = 17, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5024, .adv_w = 198, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5079, .adv_w = 194, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5140, .adv_w = 197, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 5228, .adv_w = 197, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 5308, .adv_w = 132, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5347, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5391, .adv_w = 116, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5440, .adv_w = 198, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5495, .adv_w = 163, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5556, .adv_w = 252, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5644, .adv_w = 169, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5705, .adv_w = 163, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 5793, .adv_w = 150, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5843, .adv_w = 122, .box_w = 7, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5906, .adv_w = 176, .box_w = 3, .box_h = 20, .ofs_x = 4, .ofs_y = -5},
    {.bitmap_index = 5936, .adv_w = 122, .box_w = 8, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6008, .adv_w = 183, .box_w = 10, .box_h = 4, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 6028, .adv_w = 86, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6051, .adv_w = 183, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6114, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6191, .adv_w = 183, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 6241, .adv_w = 183, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6325, .adv_w = 176, .box_w = 3, .box_h = 20, .ofs_x = 4, .ofs_y = -5},
    {.bitmap_index = 6355, .adv_w = 164, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6415, .adv_w = 186, .box_w = 7, .box_h = 2, .ofs_x = 2, .ofs_y = 13},
    {.bitmap_index = 6422, .adv_w = 266, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6550, .adv_w = 114, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 6578, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6623, .adv_w = 183, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 6658, .adv_w = 103, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 6664, .adv_w = 266, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6792, .adv_w = 160, .box_w = 12, .box_h = 3, .ofs_x = -1, .ofs_y = 15},
    {.bitmap_index = 6810, .adv_w = 137, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 6835, .adv_w = 183, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6895, .adv_w = 112, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 6927, .adv_w = 112, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 6959, .adv_w = 90, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 12},
    {.bitmap_index = 6967, .adv_w = 199, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 7047, .adv_w = 210, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7137, .adv_w = 86, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 7142, .adv_w = 72, .box_w = 5, .box_h = 6, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 7157, .adv_w = 112, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 7180, .adv_w = 120, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 7208, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 7253, .adv_w = 238, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7366, .adv_w = 247, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7479, .adv_w = 250, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7591, .adv_w = 139, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7659, .adv_w = 204, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7783, .adv_w = 204, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7907, .adv_w = 204, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8031, .adv_w = 204, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8155, .adv_w = 204, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8272, .adv_w = 204, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8389, .adv_w = 282, .box_w = 18, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8515, .adv_w = 202, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 8629, .adv_w = 178, .box_w = 9, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8715, .adv_w = 178, .box_w = 9, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8801, .adv_w = 178, .box_w = 9, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8887, .adv_w = 178, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8968, .adv_w = 108, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9025, .adv_w = 108, .box_w = 7, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9092, .adv_w = 108, .box_w = 7, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9159, .adv_w = 108, .box_w = 7, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9222, .adv_w = 234, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9320, .adv_w = 243, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9444, .adv_w = 250, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9577, .adv_w = 250, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9710, .adv_w = 250, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9843, .adv_w = 250, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9976, .adv_w = 250, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10109, .adv_w = 183, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 10159, .adv_w = 250, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 10271, .adv_w = 234, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10385, .adv_w = 234, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10499, .adv_w = 234, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10613, .adv_w = 234, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10727, .adv_w = 181, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10841, .adv_w = 194, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10918, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11001, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11076, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11151, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11226, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11301, .adv_w = 180, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11371, .adv_w = 180, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11451, .adv_w = 276, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11545, .adv_w = 154, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 11609, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11684, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11759, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11834, .adv_w = 180, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11904, .adv_w = 83, .box_w = 5, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11942, .adv_w = 83, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11980, .adv_w = 83, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12033, .adv_w = 83, .box_w = 7, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12082, .adv_w = 194, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12170, .adv_w = 198, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12245, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12328, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12411, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12494, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12577, .adv_w = 194, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12654, .adv_w = 183, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 12704, .adv_w = 194, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 12776, .adv_w = 198, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12851, .adv_w = 198, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12926, .adv_w = 198, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13001, .adv_w = 198, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13071, .adv_w = 163, .box_w = 11, .box_h = 20, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 13181, .adv_w = 197, .box_w = 11, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 13291, .adv_w = 163, .box_w = 11, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 13396, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13471, .adv_w = 180, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 13559, .adv_w = 154, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13619, .adv_w = 202, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13733, .adv_w = 154, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13801, .adv_w = 197, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13899, .adv_w = 234, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13997, .adv_w = 197, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14087, .adv_w = 180, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14167, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14242, .adv_w = 197, .box_w = 10, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14342, .adv_w = 83, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14359, .adv_w = 83, .box_w = 6, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14404, .adv_w = 168, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14474, .adv_w = 83, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14527, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14610, .adv_w = 132, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14670, .adv_w = 153, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14730, .adv_w = 176, .box_w = 10, .box_h = 19, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14825, .adv_w = 153, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 14889, .adv_w = 153, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14949, .adv_w = 116, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15024, .adv_w = 198, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15104, .adv_w = 150, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15172, .adv_w = 150, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15240, .adv_w = 150, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15308, .adv_w = 216, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15399, .adv_w = 153, .box_w = 8, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 15463, .adv_w = 116, .box_w = 7, .box_h = 18, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 15526, .adv_w = 230, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15624, .adv_w = 204, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15715, .adv_w = 208, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15792, .adv_w = 160, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15855, .adv_w = 178, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15918, .adv_w = 237, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16002, .adv_w = 195, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16093, .adv_w = 290, .box_w = 16, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16205, .adv_w = 243, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16296, .adv_w = 250, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16394, .adv_w = 234, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16478, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16555, .adv_w = 178, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16632, .adv_w = 270, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16737, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16821, .adv_w = 199, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16911, .adv_w = 150, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16979, .adv_w = 195, .box_w = 10, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 17079, .adv_w = 106, .box_w = 6, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17124, .adv_w = 199, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17190, .adv_w = 196, .box_w = 11, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 17300, .adv_w = 165, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 17375, .adv_w = 188, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17458, .adv_w = 150, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17508, .adv_w = 147, .box_w = 9, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 17598, .adv_w = 195, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 17678, .adv_w = 190, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17753, .adv_w = 106, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17786, .adv_w = 171, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17841, .adv_w = 166, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17924, .adv_w = 200, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18020, .adv_w = 165, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18075, .adv_w = 157, .box_w = 9, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18165, .adv_w = 194, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18226, .adv_w = 209, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18298, .adv_w = 192, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18378, .adv_w = 156, .box_w = 9, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18450, .adv_w = 196, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18511, .adv_w = 157, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18566, .adv_w = 191, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18621, .adv_w = 232, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18751, .adv_w = 190, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 18847, .adv_w = 240, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 18977, .adv_w = 256, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19054, .adv_w = 194, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19137, .adv_w = 191, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19212, .adv_w = 256, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19317, .adv_w = 91, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19338, .adv_w = 87, .box_w = 6, .box_h = 18, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 19392, .adv_w = 204, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19483, .adv_w = 196, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19560, .adv_w = 208, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19637, .adv_w = 163, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19700, .adv_w = 185, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19777, .adv_w = 242, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19868, .adv_w = 200, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19952, .adv_w = 290, .box_w = 16, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20064, .adv_w = 238, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20148, .adv_w = 244, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20246, .adv_w = 235, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20330, .adv_w = 194, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20407, .adv_w = 205, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20484, .adv_w = 178, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20561, .adv_w = 197, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20652, .adv_w = 215, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20729, .adv_w = 178, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20784, .adv_w = 191, .box_w = 10, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20864, .adv_w = 180, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20919, .adv_w = 140, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20963, .adv_w = 194, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 21047, .adv_w = 176, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21108, .adv_w = 243, .box_w = 16, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21196, .adv_w = 156, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21246, .adv_w = 199, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21301, .adv_w = 199, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21376, .adv_w = 170, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21431, .adv_w = 188, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21492, .adv_w = 246, .box_w = 13, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21564, .adv_w = 196, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21619, .adv_w = 190, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21680, .adv_w = 194, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21735, .adv_w = 195, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 21823, .adv_w = 158, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21878, .adv_w = 149, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21928, .adv_w = 163, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 22016, .adv_w = 236, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 22156, .adv_w = 164, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22217, .adv_w = 196, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 22301, .adv_w = 188, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22356, .adv_w = 286, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22444, .adv_w = 287, .box_w = 17, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 22563, .adv_w = 199, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22629, .adv_w = 243, .box_w = 13, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22701, .adv_w = 174, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22751, .adv_w = 256, .box_w = 15, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22834, .adv_w = 185, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22889, .adv_w = 198, .box_w = 11, .box_h = 21, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 23005, .adv_w = 83, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23026, .adv_w = 83, .box_w = 5, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23061, .adv_w = 83, .box_w = 6, .box_h = 19, .ofs_x = -2, .ofs_y = -5},
    {.bitmap_index = 23118, .adv_w = 275, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23212, .adv_w = 285, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23300, .adv_w = 199, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23388, .adv_w = 105, .box_w = 4, .box_h = 5, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23398, .adv_w = 75, .box_w = 8, .box_h = 17, .ofs_x = -2, .ofs_y = 0},
    {.bitmap_index = 23466, .adv_w = 75, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23514, .adv_w = 76, .box_w = 4, .box_h = 21, .ofs_x = 1, .ofs_y = -7},
    {.bitmap_index = 23556, .adv_w = 243, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 23661, .adv_w = 76, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23684, .adv_w = 318, .box_w = 19, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 23808, .adv_w = 130, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23860, .adv_w = 318, .box_w = 19, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23955, .adv_w = 318, .box_w = 19, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24079, .adv_w = 204, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 24181, .adv_w = 204, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 24277, .adv_w = 204, .box_w = 12, .box_h = 20, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 24397, .adv_w = 153, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24442, .adv_w = 153, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24501, .adv_w = 117, .box_w = 8, .box_h = 12, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 24549, .adv_w = 117, .box_w = 8, .box_h = 16, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 24613, .adv_w = 387, .box_w = 24, .box_h = 14, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 24781, .adv_w = 387, .box_w = 24, .box_h = 18, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 24997, .adv_w = 418, .box_w = 26, .box_h = 13, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 25166, .adv_w = 418, .box_w = 26, .box_h = 17, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 25387, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25492, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25597, .adv_w = 162, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 25705, .adv_w = 162, .box_w = 12, .box_h = 22, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 25837, .adv_w = 86, .box_w = 7, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25844, .adv_w = 315, .box_w = 19, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25977, .adv_w = 248, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 26097, .adv_w = 282, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26216, .adv_w = 222, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 26340, .adv_w = 155, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 26412, .adv_w = 219, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 26510, .adv_w = 215, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26575, .adv_w = 143, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 26623, .adv_w = 243, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 26721, .adv_w = 243, .box_w = 15, .box_h = 17, .ofs_x = 0, .ofs_y = -8},
    {.bitmap_index = 26849, .adv_w = 0, .box_w = 6, .box_h = 5, .ofs_x = 0, .ofs_y = 12},
    {.bitmap_index = 26864, .adv_w = 0, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 11},
    {.bitmap_index = 26882, .adv_w = 318, .box_w = 19, .box_h = 15, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 27025, .adv_w = 117, .box_w = 8, .box_h = 18, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 27097, .adv_w = 281, .box_w = 18, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27232, .adv_w = 281, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27385, .adv_w = 243, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 27483, .adv_w = 0, .box_w = 8, .box_h = 6, .ofs_x = -7, .ofs_y = 13},
    {.bitmap_index = 27507, .adv_w = 0, .box_w = 3, .box_h = 3, .ofs_x = -4, .ofs_y = 15},
    {.bitmap_index = 27512, .adv_w = 65, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 27542, .adv_w = 244, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27646, .adv_w = 327, .box_w = 21, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27783, .adv_w = 157, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 27877, .adv_w = 175, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27955, .adv_w = 177, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 28045, .adv_w = 246, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28149, .adv_w = 262, .box_w = 17, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28260, .adv_w = 180, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28338, .adv_w = 203, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28423, .adv_w = 237, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28527, .adv_w = 161, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28599, .adv_w = 171, .box_w = 12, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 28677, .adv_w = 231, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28775, .adv_w = 182, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28859, .adv_w = 204, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 28944, .adv_w = 170, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29027, .adv_w = 197, .box_w = 12, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 29105, .adv_w = 178, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29183, .adv_w = 182, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29261, .adv_w = 247, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29365, .adv_w = 183, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29443, .adv_w = 225, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29541, .adv_w = 191, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29626, .adv_w = 186, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29704, .adv_w = 131, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 29767, .adv_w = 217, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 29865, .adv_w = 178, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29943, .adv_w = 218, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 30041, .adv_w = 185, .box_w = 12, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30119, .adv_w = 216, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 30217, .adv_w = 170, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 30305, .adv_w = 0, .box_w = 3, .box_h = 3, .ofs_x = -7, .ofs_y = -4},
    {.bitmap_index = 30310, .adv_w = 83, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30349, .adv_w = 83, .box_w = 15, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30492, .adv_w = 83, .box_w = 11, .box_h = 19, .ofs_x = -5, .ofs_y = 0},
    {.bitmap_index = 30597, .adv_w = 0, .box_w = 11, .box_h = 7, .ofs_x = -10, .ofs_y = -6},
    {.bitmap_index = 30636, .adv_w = 0, .box_w = 10, .box_h = 7, .ofs_x = -7, .ofs_y = -6},
    {.bitmap_index = 30671, .adv_w = 0, .box_w = 7, .box_h = 7, .ofs_x = -6, .ofs_y = -6},
    {.bitmap_index = 30696, .adv_w = 0, .box_w = 8, .box_h = 7, .ofs_x = -9, .ofs_y = 12},
    {.bitmap_index = 30724, .adv_w = 0, .box_w = 8, .box_h = 7, .ofs_x = -9, .ofs_y = 13},
    {.bitmap_index = 30752, .adv_w = 83, .box_w = 9, .box_h = 19, .ofs_x = -3, .ofs_y = 0},
    {.bitmap_index = 30838, .adv_w = 83, .box_w = 10, .box_h = 19, .ofs_x = -4, .ofs_y = 0},
    {.bitmap_index = 30933, .adv_w = 0, .box_w = 7, .box_h = 6, .ofs_x = -4, .ofs_y = -6},
    {.bitmap_index = 30954, .adv_w = 192, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31009, .adv_w = 175, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31059, .adv_w = 196, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31114, .adv_w = 172, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31169, .adv_w = 170, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31224, .adv_w = 193, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31279, .adv_w = 176, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31329, .adv_w = 178, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31384, .adv_w = 291, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31472, .adv_w = 197, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31527, .adv_w = 204, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31588, .adv_w = 193, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31643, .adv_w = 195, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31698, .adv_w = 196, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31753, .adv_w = 193, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31808, .adv_w = 194, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31883, .adv_w = 207, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31944, .adv_w = 222, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32021, .adv_w = 218, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32126, .adv_w = 193, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32187, .adv_w = 196, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32242, .adv_w = 190, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32297, .adv_w = 156, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32347, .adv_w = 183, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32402, .adv_w = 157, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32452, .adv_w = 183, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32518, .adv_w = 188, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32573, .adv_w = 184, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32628, .adv_w = 179, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32688, .adv_w = 108, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 32718, .adv_w = 0, .box_w = 8, .box_h = 4, .ofs_x = -7, .ofs_y = 12},
    {.bitmap_index = 32734, .adv_w = 130, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32773, .adv_w = 130, .box_w = 13, .box_h = 16, .ofs_x = -6, .ofs_y = 0},
    {.bitmap_index = 32877, .adv_w = 0, .box_w = 10, .box_h = 3, .ofs_x = -11, .ofs_y = 12},
    {.bitmap_index = 32892, .adv_w = 0, .box_w = 10, .box_h = 4, .ofs_x = -11, .ofs_y = 12},
    {.bitmap_index = 32912, .adv_w = 0, .box_w = 10, .box_h = 4, .ofs_x = -11, .ofs_y = 12},
    {.bitmap_index = 32932, .adv_w = 0, .box_w = 10, .box_h = 4, .ofs_x = -11, .ofs_y = 12},
    {.bitmap_index = 32952, .adv_w = 0, .box_w = 4, .box_h = 4, .ofs_x = -5, .ofs_y = -5},
    {.bitmap_index = 32960, .adv_w = 0, .box_w = 7, .box_h = 5, .ofs_x = -8, .ofs_y = -6},
    {.bitmap_index = 32978, .adv_w = 94, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33006, .adv_w = 182, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33061, .adv_w = 99, .box_w = 7, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33117, .adv_w = 92, .box_w = 6, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33165, .adv_w = 97, .box_w = 7, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 33221, .adv_w = 0, .box_w = 8, .box_h = 5, .ofs_x = -9, .ofs_y = 11},
    {.bitmap_index = 33241, .adv_w = 0, .box_w = 3, .box_h = 5, .ofs_x = -4, .ofs_y = 13},
    {.bitmap_index = 33249, .adv_w = 0, .box_w = 7, .box_h = 6, .ofs_x = -8, .ofs_y = 12},
    {.bitmap_index = 33270, .adv_w = 0, .box_w = 6, .box_h = 4, .ofs_x = -6, .ofs_y = 12},
    {.bitmap_index = 33282, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 33357, .adv_w = 180, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33442, .adv_w = 180, .box_w = 11, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33536, .adv_w = 180, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33621, .adv_w = 180, .box_w = 10, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 33716, .adv_w = 180, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33801, .adv_w = 180, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33886, .adv_w = 180, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33961, .adv_w = 180, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34055, .adv_w = 180, .box_w = 10, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34145, .adv_w = 180, .box_w = 10, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 34240, .adv_w = 83, .box_w = 3, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 34269, .adv_w = 194, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34363, .adv_w = 194, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34465, .adv_w = 194, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34564, .adv_w = 194, .box_w = 11, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 34669, .adv_w = 197, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34759, .adv_w = 197, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34849, .adv_w = 197, .box_w = 12, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34951, .adv_w = 197, .box_w = 12, .box_h = 17, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 35053, .adv_w = 198, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 35128, .adv_w = 198, .box_w = 10, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 35213, .adv_w = 216, .box_w = 14, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 35332, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35332, .adv_w = 320, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 35353, .adv_w = 320, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35374, .adv_w = 320, .box_w = 17, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 35510, .adv_w = 320, .box_w = 14, .box_h = 17, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 35629, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 35774, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 35927, .adv_w = 320, .box_w = 19, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 36089, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 36260, .adv_w = 320, .box_w = 15, .box_h = 17, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 36388, .adv_w = 320, .box_w = 12, .box_h = 19, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 36502, .adv_w = 320, .box_w = 14, .box_h = 16, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 36614, .adv_w = 320, .box_w = 15, .box_h = 17, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 36742, .adv_w = 320, .box_w = 15, .box_h = 17, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 36870, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 37032, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 37185, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 37330, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 37483, .adv_w = 320, .box_w = 15, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 37611, .adv_w = 320, .box_w = 15, .box_h = 12, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 37701, .adv_w = 320, .box_w = 18, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 37818, .adv_w = 320, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 37954, .adv_w = 320, .box_w = 18, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 38098, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 38260, .adv_w = 320, .box_w = 16, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 38396, .adv_w = 320, .box_w = 18, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 38540, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 38685, .adv_w = 320, .box_w = 15, .box_h = 17, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 38813, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 38966, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 39111, .adv_w = 320, .box_w = 12, .box_h = 17, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 39213, .adv_w = 320, .box_w = 19, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 39375, .adv_w = 320, .box_w = 16, .box_h = 18, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 39519, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 39672, .adv_w = 320, .box_w = 17, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 39808, .adv_w = 320, .box_w = 14, .box_h = 14, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 39906, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 40051, .adv_w = 320, .box_w = 16, .box_h = 18, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 40195, .adv_w = 320, .box_w = 18, .box_h = 13, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 40312, .adv_w = 320, .box_w = 15, .box_h = 15, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 40425, .adv_w = 320, .box_w = 16, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 40561, .adv_w = 320, .box_w = 16, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 40697, .adv_w = 320, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 40850, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 41031, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 41184, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41364, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 41509, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 41662, .adv_w = 320, .box_w = 16, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 41790, .adv_w = 320, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 41935, .adv_w = 320, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 42088, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 42269, .adv_w = 320, .box_w = 14, .box_h = 14, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 42367, .adv_w = 320, .box_w = 18, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 42511, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 42701, .adv_w = 320, .box_w = 11, .box_h = 17, .ofs_x = 6, .ofs_y = -1},
    {.bitmap_index = 42795, .adv_w = 320, .box_w = 13, .box_h = 17, .ofs_x = 5, .ofs_y = -1},
    {.bitmap_index = 42906, .adv_w = 320, .box_w = 17, .box_h = 13, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 43017, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 43179, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 43350, .adv_w = 320, .box_w = 16, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 43478, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 43649, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 43811, .adv_w = 320, .box_w = 18, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 43946, .adv_w = 320, .box_w = 17, .box_h = 15, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 44074, .adv_w = 320, .box_w = 14, .box_h = 17, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 44193, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 44346, .adv_w = 320, .box_w = 17, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 44482, .adv_w = 320, .box_w = 15, .box_h = 15, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 44595, .adv_w = 320, .box_w = 16, .box_h = 11, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 44683, .adv_w = 320, .box_w = 12, .box_h = 13, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 44761, .adv_w = 320, .box_w = 16, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 44897, .adv_w = 320, .box_w = 12, .box_h = 17, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 44999, .adv_w = 320, .box_w = 18, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 45143, .adv_w = 320, .box_w = 14, .box_h = 16, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 45255, .adv_w = 320, .box_w = 15, .box_h = 15, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 45368, .adv_w = 320, .box_w = 16, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 45496, .adv_w = 320, .box_w = 17, .box_h = 16, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 45632, .adv_w = 320, .box_w = 16, .box_h = 3, .ofs_x = 2, .ofs_y = 6},
    {.bitmap_index = 45656, .adv_w = 320, .box_w = 20, .box_h = 3, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 45686, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 45857, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46028, .adv_w = 320, .box_w = 17, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 46190, .adv_w = 320, .box_w = 16, .box_h = 19, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 46342, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 46532, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 46732, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46922, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 47122, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 47322, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 47512, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 47693, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47874, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48064, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 48245, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 48435, .adv_w = 320, .box_w = 16, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 48587, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48768, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 48958, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 49148, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 49310, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49491, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49691, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 49881, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 50091, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50291, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 50481, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 50662, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50852, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51042, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 51223, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 51423, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 51604, .adv_w = 320, .box_w = 18, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 51784, .adv_w = 320, .box_w = 18, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 51964, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52154, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 52325, .adv_w = 320, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 52487, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52677, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52857, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 53038, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 53238, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 53438, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 53628, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 53818, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54018, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54218, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54408, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54598, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 54769, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54959, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 55159, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 55359, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 55549, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 55702, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 55892, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 56092, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 56273, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 56454, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 56625, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 56825, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 57025, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 57215, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57395, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57576, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 57776, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57947, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58157, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58357, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 58547, .adv_w = 320, .box_w = 18, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58727, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58917, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 59107, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 59307, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 59488, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 59678, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 59878, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 60068, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 60268, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 60468, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 60658, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 60858, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 61038, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 61219, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 61409, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 61599, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 61789, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 61979, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 62160, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 62331, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 62531, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 62721, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 62911, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 63111, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 63291, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 63481, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 63681, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 63881, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 64081, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 64281, .adv_w = 320, .box_w = 19, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 64443, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 64624, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 64805, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 64995, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 65185, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 65366, .adv_w = 320, .box_w = 19, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 65566, .adv_w = 320, .box_w = 19, .box_h = 21, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 65766, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 65966, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 66156, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 66356, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 66546, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 66717, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 66898, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 67079, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 67269, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 67469, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 67659, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 67859, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 68039, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 68229, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 68400, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 68562, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 68742, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 68932, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 69103, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 69303, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 69484, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 69674, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 69874, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 70064, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 70235, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 70425, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 70625, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 70815, .adv_w = 320, .box_w = 20, .box_h = 21, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 71025, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 71225, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 71415, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 71605, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 71795, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 71975, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 72165, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 72355, .adv_w = 320, .box_w = 18, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 72517, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 72707, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 72897, .adv_w = 320, .box_w = 19, .box_h = 21, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 73097, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 73297, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 73487, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 73668, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 73839, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 74029, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 74229, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 74419, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 74609, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 74799, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 74999, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 75189, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 75389, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 75579, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 75769, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 75959, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 76140, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 76340, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 76530, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 76711, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 76892, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 77073, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 77263, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 77444, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 77634, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 77815, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 78005, .adv_w = 320, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 78185, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 78385, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 78566, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 78756, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 78946, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 79136, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 79336, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 79536, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 79726, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 79916, .adv_w = 320, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 80097, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 80268, .adv_w = 320, .box_w = 20, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 80438, .adv_w = 320, .box_w = 20, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 80638, .adv_w = 320, .box_w = 20, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 80828, .adv_w = 320, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 80990, .adv_w = 320, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 81152, .adv_w = 320, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 81314, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 81485, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 81656, .adv_w = 320, .box_w = 18, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 81827, .adv_w = 320, .box_w = 19, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 81998, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 82188, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 82378, .adv_w = 320, .box_w = 18, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 82558, .adv_w = 320, .box_w = 19, .box_h = 20, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 82748, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 82910, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 83063, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 83225, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 83377, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 83521, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 83665, .adv_w = 294, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 83808, .adv_w = 294, .box_w = 17, .box_h = 14, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 83927, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 84080, .adv_w = 294, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 84251, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 84404, .adv_w = 294, .box_w = 17, .box_h = 14, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 84523, .adv_w = 294, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 84666, .adv_w = 294, .box_w = 17, .box_h = 14, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 84785, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 84947, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 85099, .adv_w = 294, .box_w = 14, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 85232, .adv_w = 294, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 85385, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 85547, .adv_w = 294, .box_w = 14, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 85680, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 85842, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 85995, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 86147, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 86283, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 86427, .adv_w = 294, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 86572, .adv_w = 294, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 86700, .adv_w = 294, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 86845, .adv_w = 294, .box_w = 14, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 86978, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 87130, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 87282, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 87418, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 87580, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 87742, .adv_w = 294, .box_w = 18, .box_h = 17, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 87895, .adv_w = 294, .box_w = 14, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 88028, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 88181, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 88317, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 88470, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 88622, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 88774, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 88910, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 89063, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 89225, .adv_w = 294, .box_w = 14, .box_h = 19, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 89358, .adv_w = 294, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 89529, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 89691, .adv_w = 294, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 89862, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 90024, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 90176, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 90320, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 90472, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 90634, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 90796, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 90932, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 91094, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 91256, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 91409, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 91545, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 91698, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 91850, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 91994, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 92147, .adv_w = 294, .box_w = 15, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 92282, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 92444, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 92596, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 92740, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 92876, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 93038, .adv_w = 294, .box_w = 17, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 93174, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 93336, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 93498, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 93650, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 93803, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 93956, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 94118, .adv_w = 294, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 94261, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 94405, .adv_w = 294, .box_w = 15, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 94540, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 94702, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 94846, .adv_w = 294, .box_w = 15, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 94981, .adv_w = 294, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 95124, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 95277, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 95430, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 95583, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 95735, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 95879, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 96041, .adv_w = 294, .box_w = 17, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 96186, .adv_w = 294, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 96329, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 96491, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 96635, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 96797, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 96941, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 97093, .adv_w = 294, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 97221, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 97373, .adv_w = 294, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 97516, .adv_w = 294, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 97660, .adv_w = 294, .box_w = 17, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 97788, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 97950, .adv_w = 294, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 98102, .adv_w = 294, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 98273, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 98435, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 98597, .adv_w = 294, .box_w = 18, .box_h = 18, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 98759, .adv_w = 294, .box_w = 18, .box_h = 19, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 98930, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 99092, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 99254, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 99416, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 99569, .adv_w = 294, .box_w = 17, .box_h = 18, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 99722, .adv_w = 294, .box_w = 17, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 99884, .adv_w = 320, .box_w = 4, .box_h = 16, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 99916, .adv_w = 320, .box_w = 5, .box_h = 8, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 99936, .adv_w = 320, .box_w = 4, .box_h = 14, .ofs_x = 3, .ofs_y = -1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe,
    0x16, 0x18, 0x1c, 0x2e, 0x3b, 0x3e, 0x3f, 0x4e,
    0x56, 0x58, 0x5b, 0x5c, 0x5e, 0x62, 0x6c, 0x77,
    0x79, 0x7b, 0xad, 0x116, 0x118, 0x285, 0x28e, 0x28f,
    0x290, 0x292, 0x294, 0x298, 0x299, 0x29a, 0x29c, 0x29d,
    0x2a0, 0x2a1, 0x2a3, 0x2a4, 0x2a9, 0x2aa, 0x2ab, 0x2ac
};

static const uint16_t unicode_list_4[] = {
    0x0, 0x1, 0x2, 0x3a, 0x3c, 0x44, 0x45, 0x46,
    0x47, 0x4b, 0x4c, 0x4e, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x5b
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0x1be, 0x1d4, 0x1d5
};

static const uint16_t unicode_list_9[] = {
    0x0, 0x2f, 0x49, 0x5a, 0x60, 0x7d, 0x2b2, 0x2b3,
    0x2b4, 0x2b6, 0x2b7, 0x2b8, 0x2ba, 0x2c0, 0x2c6, 0x2c7,
    0x2c8, 0x2cb, 0x2cd, 0x2d0, 0x2d2, 0x2d4, 0x2d5, 0x2d6,
    0x2d7, 0x2d8, 0x2d9, 0x2db, 0x2dc, 0x2dd, 0x2de, 0x2df,
    0x2e0, 0x2e1, 0x2e3, 0x2e6, 0x2e7, 0x2e8, 0x2e9, 0x2ea,
    0x2ed, 0x2ef, 0x2f0, 0x2f1, 0x2f2, 0x2f3, 0x2f4, 0x2f8,
    0x2f9, 0x2fa, 0x2fc, 0x2fe, 0x7b2, 0x7b3, 0x7b5, 0x7b8,
    0x7b9, 0x7ba, 0x7bb, 0x7bc, 0x7c4, 0x7c5, 0x7c6, 0x7c7,
    0x7c8, 0x7ca, 0x7cb, 0x7cc, 0x7cd, 0x7cf, 0x7d0, 0x7d1,
    0x7d2, 0x7d3, 0x7d4, 0x7d6, 0x7d8, 0x7db, 0x7dc, 0x7de,
    0x7df, 0x7e1, 0x7e2, 0x7e3, 0x7e4, 0x7e5, 0x7e6, 0x7e7,
    0x7e8, 0x7e9, 0x7ea, 0x7f1, 0x7f2, 0x7f3, 0x7f4, 0x7f5,
    0x7f8, 0x7f9, 0x7fa, 0x7fd, 0x1852, 0x1854, 0x1856, 0x1858,
    0x185e, 0x1860, 0x186c, 0x186e, 0x1870, 0x1874, 0x1878, 0x187c,
    0x1882, 0x1884, 0x1888, 0x188a, 0x188c, 0x188e, 0x1890, 0x1894,
    0x1896, 0x1898, 0x189e, 0x19bd, 0x29b2, 0x29b3, 0x29f5, 0x29f7,
    0x29f9, 0x29fb, 0x29fc, 0x29fd, 0x29fe, 0x2a00, 0x2a04, 0x2a06,
    0x2a08, 0x2a0a, 0x2a0c, 0x2a10, 0x2a11, 0x2a12, 0x2a14, 0x2a15,
    0x2a17, 0x2a18, 0x2a1b, 0x2a1c, 0x2a1f, 0x2a20, 0x2a2f, 0x2a30,
    0x2a33, 0x2a3b, 0x2a3d, 0x2a43, 0x2a44, 0x2a53, 0x2a54, 0x2a55,
    0x2a57, 0x2a59, 0x2a5a, 0x2a5c, 0x2a5e, 0x2a60, 0x2a61, 0x2a66,
    0x2a67, 0x2a68, 0x2a69, 0x2a6a, 0x2a6c, 0x2a70, 0x2a71, 0x2a74,
    0x2a77, 0x2a78, 0x2a79, 0x2a7a, 0x2a7c, 0x2a7e, 0x2a81, 0x2a86,
    0x2a87, 0x2a88, 0x2a8a, 0x2a8f, 0x2a90, 0x2a91, 0x2a93, 0x2a94,
    0x2a96, 0x2a98, 0x2a9a, 0x2a9b, 0x2a9c, 0x2a9d, 0x2a9e, 0x2aa0,
    0x2aa4, 0x2aad, 0x47b1, 0x47bc, 0x47be, 0x47de, 0x4837, 0x48eb,
    0x48ff, 0x4911, 0x4992, 0x49ca, 0x4a4a, 0x4af6, 0x4af9, 0x4b16,
    0x4b24, 0x4b3e, 0x4bab, 0x4bb8, 0x4bce, 0x4bda, 0x4be1, 0x4c51,
    0x4c52, 0x4c6a, 0x4c8a, 0x4cc7, 0x4cf8, 0x4d12, 0x4d7c, 0x4d82,
    0x4da0, 0x4dbf, 0x4ddd, 0x4de0, 0x4dfb, 0x4e2e, 0x4e7e, 0x4f00,
    0x4f10, 0x5019, 0x50d9, 0x51e2, 0x52b8, 0x52d8, 0x52e2, 0x532e,
    0x537c, 0x553d, 0x554b, 0x55ac, 0x55b7, 0x55b8, 0x55bc, 0x55c2,
    0x57a3, 0x5845, 0x5857, 0x58b1, 0x58c0, 0x5906, 0x5936, 0x593d,
    0x598d, 0x59b2, 0x5a20, 0x5a76, 0x5afc, 0x5b7a, 0x5bc2, 0x5bfc,
    0x5c1c, 0x5c2f, 0x5cf0, 0x5d13, 0x5d34, 0x5d53, 0x5d56, 0x5d80,
    0x5d83, 0x5d8c, 0x5f08, 0x5f61, 0x5f91, 0x5fa7, 0x5ff3, 0x60a5,
    0x60b0, 0x60b1, 0x60ba, 0x60bc, 0x60be, 0x60d0, 0x60dd, 0x60eb,
    0x6196, 0x6271, 0x62cd, 0x63d2, 0x6410, 0x6453, 0x6514, 0x6686,
    0x66ec, 0x66f2, 0x66fc, 0x6700, 0x67dd, 0x6831, 0x6841, 0x6892,
    0x68b0, 0x6971, 0x69c0, 0x6a6a, 0x6a9e, 0x6ad2, 0x6bf9, 0x6c67,
    0x6c71, 0x6d61, 0x6daf, 0x6ed9, 0x6ee6, 0x702c, 0x702d, 0x7035,
    0x726b, 0x7383, 0x73be, 0x74fa, 0x7505, 0x76ac, 0x76cb, 0x76f3,
    0x76f5, 0x7712, 0x7722, 0x774b, 0x7763, 0x7858, 0x7875, 0x788d,
    0x7890, 0x7902, 0x79f7, 0x7a2e, 0x7aae, 0x81fd, 0x833c, 0x836e,
    0x8379, 0x83bb, 0x83db, 0x83de, 0x8417, 0x8422, 0x843e, 0x8455,
    0x845b, 0x845e, 0x847c, 0x8517, 0x856f, 0x8570, 0x8586, 0x858e,
    0x85a0, 0x85a5, 0x85a8, 0x8678, 0x86d6, 0x86f5, 0x8736, 0x8764,
    0x87a0, 0x88ba, 0x892e, 0x896d, 0x898c, 0x898f, 0x89b2, 0x89d4,
    0x8a05, 0x8afe, 0x8b7e, 0x8b80, 0x8ce0, 0x8eca, 0x8f3a, 0x8f3c,
    0x8f44, 0x8f8d, 0x8f9e, 0x8f9f, 0x90ac, 0x910a, 0x910d, 0x91a4,
    0x91b0, 0xa5b1, 0xa5b5, 0xa5c1, 0xa621, 0xa65d, 0xa661, 0xa66e,
    0xa691, 0xa6a6, 0xa6ad, 0xa71d, 0xa7a9, 0xa7e1, 0xa9f5, 0xaa49,
    0xaad5, 0xab06, 0xac45, 0xac56, 0xac79, 0xac95, 0xaca6, 0xacb1,
    0xad75, 0xadd9, 0xae79, 0xae8d, 0xae94, 0xaeda, 0xb1b9, 0xb1d5,
    0xb20d, 0xb309, 0xb319, 0xb32d, 0xb35d, 0xb381, 0xb459, 0xb5cd,
    0xb5e1, 0xb635, 0xb6a5, 0xb6ad, 0xb731, 0xb7f5, 0xba5d, 0xba6e,
    0xba72, 0xba79, 0xbacd, 0xbad5, 0xbae2, 0xbae9, 0xbafc, 0xbb3d,
    0xbb3e, 0xbb52, 0xbbc9, 0xbc55, 0xbc66, 0xbc8d, 0xbc95, 0xbef9,
    0xbf76, 0xbf77, 0xbf81, 0xbfa1, 0xbfd5, 0xbff5, 0xc045, 0xc05a,
    0xc065, 0xc07d, 0xc0f5, 0xc0fd, 0xc102, 0xc125, 0xc129, 0xc136,
    0xc151, 0xc1b5, 0xc1c2, 0xc1c6, 0xc222, 0xc2ad, 0xc2c2, 0xc371,
    0xc375, 0xc5ef, 0xc6b9, 0xc70d, 0xc75a, 0xc80d, 0xc825, 0xc845,
    0xc8cd, 0xca1d, 0xca8d, 0xcae1, 0xcb0d, 0xcc69, 0xccd0, 0xccd9,
    0xcf09, 0xcf0d, 0xcf11, 0xcf1a, 0xcf1c, 0xcf39, 0xd005, 0xd006,
    0xd009, 0xd00d, 0xd075, 0xf8b2, 0xf8bd, 0xf8cb
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 161, .range_length = 95, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 259, .range_length = 685, .glyph_id_start = 191,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 48, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 945, .range_length = 25, .glyph_id_start = 239,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 972, .range_length = 92, .glyph_id_start = 264,
        .unicode_list = unicode_list_4, .glyph_id_ofs_list = NULL, .list_length = 21, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1072, .range_length = 29, .glyph_id_start = 285,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1102, .range_length = 470, .glyph_id_start = 314,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 12, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1573, .range_length = 22, .glyph_id_start = 326,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1600, .range_length = 12, .glyph_id_start = 348,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1615, .range_length = 63692, .glyph_id_start = 360,
        .unicode_list = unicode_list_9, .glyph_id_ofs_list = NULL, .list_length = 518, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 2,
    3, 0, 4, 5, 6, 7, 8, 0,
    9, 10, 0, 11, 12, 0, 13, 14,
    15, 16, 0, 17, 18, 19, 20, 21,
    22, 23, 24, 0, 25, 26, 0, 27,
    28, 0, 29, 30, 31, 32, 33, 34,
    35, 36, 37, 38, 0, 39, 40, 41,
    42, 43, 44, 45, 0, 0, 46, 47,
    48, 49, 50, 51, 0, 52, 0, 53,
    54, 0, 55, 56, 57, 58, 0, 59,
    60, 61, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 2, 3, 4,
    0, 5, 0, 6, 7, 8, 6, 6,
    0, 9, 10, 11, 11, 0, 12, 13,
    14, 15, 0, 0, 16, 17, 18, 19,
    20, 0, 0, 21, 0, 22, 23, 24,
    0, 25, 0, 26, 0, 27, 28, 29,
    30, 31, 31, 32, 33, 34, 34, 0,
    35, 0, 36, 36, 33, 37, 38, 39,
    39, 40, 41, 42, 33, 43, 0, 44,
    45, 0, 46, 0, 47, 48, 0, 0,
    49, 50, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 51, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -19, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -32, 0, 0,
    0, 0, 0, 0, -10, -10, 0, 0,
    0, 0, -10, -16, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 0, -6, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -19, -6, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -19, -22,
    -16, 0, -6, 0, 0, 0, 0, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -10, 0, 0, 0, 13, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, -6, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    -22, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -16,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, -19, -10, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -26, -32, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -13, 0,
    3, 3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -22, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, -10, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -16, 0, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    -13, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -16, -16, -10, 0, 0, -10, 0,
    -10, -10, 0, 0, 0, -19, -6, 0,
    0, 0, -6, -16, 0, -16, -6, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -22, -13, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    -10, 0, 0, 0, 0, -6, 0, -6,
    3, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -16, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -19, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, -13, 0, 0, 0, 0, 0,
    0, 0, -10, 0, -13, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -16, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -13, -10,
    0, -6, -10, 0, 0, 0, 0, 0,
    0, 0, 0, -13, -13, -13, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -13, -13, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -22, 3, 3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -6, -10, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, -16, -16, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -32, -32, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -16, 0, 0, -16, -16, 0,
    0, -13, 0, -6, 0, 0, 0, 0,
    -13, 0, 0, -6, 0, -22, 0, 0,
    0, -3, 0, -13, -19, -32, -6, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -6, -6, 0, 0, 0, -10, 0, -13,
    -6, 0, 0, -6, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, -10, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -16, -16, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -16, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, -13, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, -10, -29, -26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -13,
    -13, 0, 0, 0, -10, 0, -13, 0,
    0, 0, -16, 0, 0, 0, 0, -26,
    0, 0, 0, -10, 0, 0, 0, -29,
    -22, -26, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    0, 0, -22, -29, -29, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    -13, 0, 0, 0, 0, -6, 0, 0,
    0, 0, 0, 0, 0, -22, -26, -22,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    -19, -6, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, -10, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, -19, 0, 0, 0, 0, 0, -16,
    -22, 0, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -22,
    -10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -16, -16, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -16,
    -3, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -16, -10, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -19, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, -13, -10, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -22, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    -16, -6, -6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, -13, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -6, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 16,
    0, 3, -13, -13, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 6, 0, -6, -10, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -16,
    -10, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 0, 0, 0,
    0, 0, -16, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 6, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -16, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -16, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -19,
    -19, 0, 0, 0, 0, 0, -16, 0,
    0, 0, 0, 0, -6, -6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -6, 0,
    0, 0, -6, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, -6, 0, 0, 0, 0, 0, -3,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, -16, -19, -13, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -6, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -6, 0, 0,
    0, 0, 0, 0, 0, 0, -19, -19,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -16, -19, -19, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -6, 0, 0, 0, 0, -6, 0, -10,
    -10, 0, 0, -6, 0, 0, 0, 0,
    0, 0, 0, -16, -3, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -19, -19, 0, 0, 0, 0, 0,
    0, -13, -13, 0, 0, 0, 0, 0,
    -6, -6, -6, -16, 0, 0, 0, 0,
    0, -3, -19, -19, 0, 0, -10, 0,
    0, 0, 0, 0, -16, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 61,
    .right_class_cnt     = 51,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 10,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t font_noto_basic_20_4 = {
#else
lv_font_t font_noto_basic_20_4 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 28,          /*The maximum line height required by the font*/
    .base_line = 8,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .fallback = NULL,
    .user_data = NULL
};



#endif /*#if FONT_NOTO_BASIC_20_4*/

