/*******************************************************************************
 * Size: 16 px
 * Bpp: 4
 * Opts: --force-fast-kern-format --no-compress --no-prefilter --font ttf/puhui-basic.ttf --format lvgl --lv-include lvgl.h --bpp 4 -o src/font_puhui_basic_16_4.c --size 16 -r 0x0-0xfffff
 ******************************************************************************/

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
#include "lvgl.h"
#else
#include "lvgl.h"
#endif

#ifndef FONT_PUHUI_BASIC_16_4
#define FONT_PUHUI_BASIC_16_4 1
#endif

#if FONT_PUHUI_BASIC_16_4

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xe, 0x90, 0xe9, 0xd, 0x90, 0xd8, 0xc, 0x80,
    0xc7, 0xb, 0x70, 0xb6, 0x0, 0x1, 0xfc, 0x1f,
    0xb0,

    /* U+0022 "\"" */
    0xbc, 0x5f, 0x3a, 0xb3, 0xf2, 0x9a, 0x2f, 0x18,
    0x91, 0xf0, 0x56, 0xc, 0x0,

    /* U+0023 "#" */
    0x0, 0xb, 0x90, 0xd, 0x70, 0x0, 0xe, 0x60,
    0xf, 0x40, 0x0, 0x1f, 0x20, 0x3f, 0x10, 0xbf,
    0xff, 0xff, 0xff, 0xf4, 0x12, 0x9c, 0x22, 0xba,
    0x20, 0x0, 0xb8, 0x0, 0xd6, 0x0, 0x0, 0xf5,
    0x1, 0xf3, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xf4,
    0x17, 0xe2, 0x29, 0xc2, 0x20, 0x9, 0xb0, 0xb,
    0x80, 0x0, 0xd, 0x70, 0xf, 0x50, 0x0,

    /* U+0024 "$" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1a,
    0xef, 0xfe, 0x59, 0xc3, 0xf2, 0x42, 0xc7, 0xf,
    0x0, 0xb, 0x90, 0xf0, 0x0, 0x5f, 0xbf, 0x10,
    0x0, 0x39, 0xff, 0xa1, 0x0, 0xf, 0x3d, 0xa0,
    0x0, 0xf0, 0x5f, 0x0, 0xf, 0x5, 0xe8, 0x54,
    0xf5, 0xd9, 0xbe, 0xff, 0xd8, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x70, 0x0,

    /* U+0025 "%" */
    0x2d, 0xea, 0x0, 0x2, 0xd0, 0x0, 0xb6, 0xa,
    0x60, 0xb, 0x50, 0x0, 0xd2, 0x7, 0x90, 0x4c,
    0x0, 0x0, 0xd2, 0x7, 0x90, 0xd3, 0x0, 0x0,
    0xa6, 0xa, 0x66, 0xa0, 0x0, 0x0, 0x2b, 0xd9,
    0x1e, 0x18, 0xdc, 0x30, 0x0, 0x0, 0x88, 0x4d,
    0x4, 0xc0, 0x0, 0x2, 0xe0, 0x79, 0x0, 0xf0,
    0x0, 0xa, 0x60, 0x79, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0x4b, 0x2, 0xd0, 0x0, 0xc4, 0x0, 0x9,
    0xbc, 0x40,

    /* U+0026 "&" */
    0x0, 0x9, 0xfe, 0x80, 0x0, 0x0, 0x8, 0xf5,
    0x6f, 0x40, 0x0, 0x0, 0xbb, 0x0, 0xe7, 0x0,
    0x0, 0x9, 0xe0, 0x6f, 0x20, 0x0, 0x0, 0x2f,
    0xde, 0x40, 0x0, 0x0, 0x1b, 0xff, 0x50, 0x7,
    0x60, 0xc, 0xc1, 0x9f, 0x20, 0xe6, 0x4, 0xf2,
    0x0, 0xbe, 0x7f, 0x20, 0x5f, 0x30, 0x1, 0xdf,
    0x80, 0x1, 0xed, 0x54, 0x8f, 0xfd, 0x50, 0x2,
    0xbf, 0xfc, 0x53, 0xcf, 0x30,

    /* U+0027 "'" */
    0xbc, 0xab, 0x9a, 0x89, 0x56,

    /* U+0028 "(" */
    0x0, 0xba, 0x4, 0xf1, 0xc, 0x80, 0x3f, 0x20,
    0x8d, 0x0, 0xc9, 0x0, 0xd7, 0x0, 0xe7, 0x0,
    0xe8, 0x0, 0xc9, 0x0, 0x8d, 0x0, 0x4f, 0x20,
    0xd, 0x80, 0x5, 0xe1, 0x0, 0xb9,

    /* U+0029 ")" */
    0xd, 0x70, 0x0, 0x4f, 0x20, 0x0, 0xc9, 0x0,
    0x6, 0xf0, 0x0, 0x1f, 0x40, 0x0, 0xe8, 0x0,
    0xc, 0xa0, 0x0, 0xba, 0x0, 0xc, 0x90, 0x0,
    0xe7, 0x0, 0x1f, 0x40, 0x6, 0xe0, 0x0, 0xd8,
    0x0, 0x5f, 0x10, 0xe, 0x60, 0x0,

    /* U+002A "*" */
    0x0, 0x3f, 0x10, 0x1, 0x52, 0xf1, 0x60, 0x5f,
    0xff, 0xfe, 0x30, 0xb, 0xf9, 0x0, 0x6, 0xf4,
    0xf5, 0x0, 0x35, 0x6, 0x20,

    /* U+002B "+" */
    0x0, 0x4, 0xf1, 0x0, 0x0, 0x0, 0x4f, 0x10,
    0x0, 0x1, 0x15, 0xf2, 0x11, 0x7, 0xff, 0xff,
    0xff, 0xf4, 0x14, 0x47, 0xf5, 0x44, 0x10, 0x0,
    0x4f, 0x10, 0x0, 0x0, 0x4, 0xf1, 0x0, 0x0,
    0x0, 0x3e, 0x10, 0x0,

    /* U+002C "," */
    0x0, 0x73, 0x0, 0xf4, 0x4, 0xf0, 0xa, 0x90,
    0x2e, 0x10,

    /* U+002D "-" */
    0xdf, 0xff, 0xe2, 0x22, 0x22,

    /* U+002E "." */
    0x0, 0x8, 0xf5, 0x7f, 0x40,

    /* U+002F "/" */
    0x0, 0x0, 0x45, 0x0, 0x0, 0xd6, 0x0, 0x2,
    0xf1, 0x0, 0x8, 0xb0, 0x0, 0xd, 0x60, 0x0,
    0x3f, 0x10, 0x0, 0x8b, 0x0, 0x0, 0xd5, 0x0,
    0x3, 0xf0, 0x0, 0x9, 0xa0, 0x0, 0xe, 0x50,
    0x0, 0x4f, 0x0, 0x0, 0x9a, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x6d, 0xfe, 0x80, 0x0, 0x5f, 0x84, 0x7f,
    0x80, 0xc, 0xb0, 0x0, 0x8f, 0x0, 0xf7, 0x0,
    0x4, 0xf3, 0x1f, 0x50, 0x0, 0x2f, 0x42, 0xf5,
    0x0, 0x1, 0xf5, 0x1f, 0x50, 0x0, 0x2f, 0x40,
    0xf7, 0x0, 0x4, 0xf3, 0xc, 0xb0, 0x0, 0x8f,
    0x0, 0x5f, 0x83, 0x6f, 0x80, 0x0, 0x6d, 0xfe,
    0x80, 0x0,

    /* U+0031 "1" */
    0x28, 0xbe, 0xd4, 0xa7, 0xcd, 0x0, 0xa, 0xd0,
    0x0, 0xad, 0x0, 0xa, 0xd0, 0x0, 0xad, 0x0,
    0xa, 0xd0, 0x0, 0xad, 0x0, 0xa, 0xd0, 0x0,
    0xad, 0x0, 0xa, 0xd0,

    /* U+0032 "2" */
    0x3, 0xdf, 0xfd, 0x60, 0x0, 0x25, 0x44, 0x9f,
    0x50, 0x0, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x0,
    0x0, 0x9e, 0x10, 0x0, 0x0, 0x8f, 0x30, 0x0,
    0x0, 0x9e, 0x30, 0x0, 0x1, 0xcc, 0x10, 0x0,
    0x0, 0xed, 0x44, 0x44, 0x40, 0x1f, 0xff, 0xff,
    0xff, 0x30,

    /* U+0033 "3" */
    0x4d, 0xff, 0xd7, 0x2, 0x53, 0x48, 0xf5, 0x0,
    0x0, 0xc, 0x80, 0x0, 0x16, 0xf4, 0x8, 0xff,
    0xe4, 0x0, 0x12, 0x49, 0xf3, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0xb, 0xc6,
    0x43, 0x5a, 0xf5, 0xbf, 0xff, 0xc5, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x1e, 0xf2, 0x0, 0x0, 0xa, 0xdf,
    0x20, 0x0, 0x6, 0xe4, 0xf2, 0x0, 0x2, 0xf4,
    0x3f, 0x20, 0x0, 0xd8, 0x3, 0xf2, 0x0, 0x9c,
    0x0, 0x3f, 0x20, 0x4f, 0x20, 0x3, 0xf2, 0x7,
    0xff, 0xff, 0xff, 0xf7, 0x13, 0x33, 0x35, 0xf5,
    0x10, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x0, 0x3,
    0xf2, 0x0,

    /* U+0035 "5" */
    0xe, 0xff, 0xff, 0x50, 0xf, 0x64, 0x44, 0x10,
    0x3f, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x0,
    0x7f, 0xee, 0xc6, 0x0, 0x33, 0x23, 0x8f, 0x90,
    0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x5, 0xf1,
    0x0, 0x0, 0x8, 0xe0, 0x44, 0x34, 0x9f, 0x70,
    0x8e, 0xfe, 0xb5, 0x0,

    /* U+0036 "6" */
    0x0, 0x2, 0x9d, 0xd0, 0x0, 0x5, 0xfa, 0x63,
    0x0, 0x1, 0xe3, 0x0, 0x0, 0x0, 0x8b, 0xae,
    0xd8, 0x0, 0xd, 0xf7, 0x35, 0xe9, 0x0, 0xf8,
    0x0, 0x6, 0xf0, 0x1f, 0x50, 0x0, 0x2f, 0x20,
    0xf5, 0x0, 0x2, 0xf1, 0xd, 0xa0, 0x0, 0x6f,
    0x0, 0x7f, 0x84, 0x6f, 0x70, 0x0, 0x7d, 0xfe,
    0x80, 0x0,

    /* U+0037 "7" */
    0x2f, 0xff, 0xff, 0xff, 0x30, 0x44, 0x44, 0x47,
    0xf1, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0,
    0x2f, 0x30, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0,
    0x2, 0xf3, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0,
    0x0, 0x2f, 0x40, 0x0, 0x0, 0x9, 0xd0, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x9e, 0xfe, 0xa1, 0x0, 0x9e, 0x53, 0x5d,
    0xc0, 0xc, 0x80, 0x0, 0x5f, 0x0, 0x8c, 0x10,
    0x1a, 0xb0, 0x0, 0xaf, 0xff, 0xc1, 0x0, 0x7e,
    0x52, 0x4c, 0xb0, 0xf, 0x50, 0x0, 0x2f, 0x32,
    0xf2, 0x0, 0x0, 0xf5, 0xf, 0x50, 0x0, 0x2f,
    0x30, 0xae, 0x63, 0x5d, 0xd0, 0x0, 0x8d, 0xfe,
    0xa1, 0x0,

    /* U+0039 "9" */
    0x0, 0x7d, 0xfe, 0x70, 0x0, 0x6f, 0x74, 0x7f,
    0x80, 0xe, 0x80, 0x0, 0x7f, 0x0, 0xf4, 0x0,
    0x3, 0xf2, 0xf, 0x50, 0x0, 0x3f, 0x20, 0xad,
    0x20, 0x2c, 0xf2, 0x1, 0xbf, 0xfe, 0xbf, 0x0,
    0x0, 0x1, 0xa, 0xb0, 0x0, 0x0, 0x5, 0xf3,
    0x0, 0x3, 0x6b, 0xf7, 0x0, 0x0, 0xbe, 0xa3,
    0x0, 0x0,

    /* U+003A ":" */
    0xde, 0xe, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xe0, 0xde, 0x0,

    /* U+003B ";" */
    0xd, 0xe0, 0xe, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x8, 0xc0,
    0xc, 0x80, 0x2f, 0x20, 0x98, 0x0, 0x0, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xc4, 0x0, 0x1, 0x8e, 0xfa, 0x10, 0x4a, 0xfd,
    0x71, 0x0, 0x6f, 0xb4, 0x0, 0x0, 0x7, 0xe8,
    0x10, 0x0, 0x0, 0x17, 0xdf, 0xb4, 0x0, 0x0,
    0x0, 0x4b, 0xfd, 0x70, 0x0, 0x0, 0x2, 0x8e,
    0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+003D "=" */
    0x1, 0x11, 0x11, 0x11, 0x7, 0xff, 0xff, 0xff,
    0xf4, 0x14, 0x44, 0x44, 0x44, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x7, 0xff,
    0xff, 0xff, 0xf4, 0x14, 0x44, 0x44, 0x44, 0x10,

    /* U+003E ">" */
    0x0, 0x0, 0x0, 0x0, 0x6, 0xa4, 0x0, 0x0,
    0x0, 0x2b, 0xfd, 0x71, 0x0, 0x0, 0x2, 0x8e,
    0xf9, 0x30, 0x0, 0x0, 0x5, 0xcf, 0x30, 0x0,
    0x0, 0x29, 0xf4, 0x0, 0x5, 0xcf, 0xc6, 0x1,
    0x8e, 0xfa, 0x30, 0x0, 0x7d, 0x71, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x3d, 0xff, 0xe8, 0x3, 0x75, 0x5a, 0xf5, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0xae, 0x10, 0x0, 0xcd, 0x20, 0x0, 0x7e, 0x10,
    0x0, 0x6, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0xce, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x29, 0xdf, 0xfc, 0x70, 0x0, 0x0,
    0x7, 0xfa, 0x42, 0x36, 0xdc, 0x0, 0x0, 0x8e,
    0x30, 0x0, 0x0, 0xd, 0x90, 0x3, 0xf3, 0x3,
    0xce, 0x8d, 0x44, 0xf0, 0xa, 0xa0, 0x2f, 0x72,
    0xbf, 0x10, 0xf3, 0xe, 0x50, 0xab, 0x0, 0x6e,
    0x0, 0xf4, 0xf, 0x30, 0xe6, 0x0, 0x7b, 0x0,
    0xf3, 0x1f, 0x20, 0xf4, 0x0, 0xb9, 0x4, 0xf0,
    0xf, 0x40, 0xd8, 0x5, 0xfb, 0xb, 0x90, 0xb,
    0x90, 0x4f, 0xfe, 0x6e, 0xfb, 0x0, 0x4, 0xf3,
    0x0, 0x10, 0x0, 0x10, 0x0, 0x0, 0x7f, 0x83,
    0x0, 0x2, 0x40, 0x0, 0x0, 0x4, 0xbf, 0xff,
    0xfe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x12, 0x0,
    0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f,
    0xbd, 0x0, 0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0,
    0x0, 0x0, 0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e,
    0x0, 0x4f, 0x0, 0x0, 0xb, 0x91, 0x11, 0xe6,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c,
    0x44, 0x44, 0x5f, 0x20, 0xd, 0x70, 0x0, 0x0,
    0xd8, 0x4, 0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac,
    0x0, 0x0, 0x0, 0x3f, 0x40,

    /* U+0042 "B" */
    0x8f, 0xff, 0xfc, 0x40, 0x8e, 0x44, 0x5b, 0xf1,
    0x8e, 0x0, 0x1, 0xf5, 0x8e, 0x0, 0x1, 0xf5,
    0x8e, 0x0, 0x19, 0xe1, 0x8f, 0xff, 0xff, 0x50,
    0x8e, 0x22, 0x38, 0xf5, 0x8e, 0x0, 0x0, 0xbb,
    0x8e, 0x0, 0x0, 0xca, 0x8e, 0x44, 0x58, 0xf6,
    0x8f, 0xff, 0xfd, 0x70,

    /* U+0043 "C" */
    0x0, 0x6c, 0xef, 0xe9, 0xa, 0xfa, 0x65, 0x66,
    0x4f, 0x60, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0xc, 0xf9, 0x55, 0x68,
    0x0, 0x8d, 0xff, 0xe9,

    /* U+0044 "D" */
    0x8f, 0xff, 0xfd, 0x81, 0x0, 0x8e, 0x44, 0x59,
    0xfd, 0x0, 0x8e, 0x0, 0x0, 0x4f, 0x80, 0x8e,
    0x0, 0x0, 0xc, 0xd0, 0x8e, 0x0, 0x0, 0x8,
    0xf0, 0x8e, 0x0, 0x0, 0x7, 0xf0, 0x8e, 0x0,
    0x0, 0x8, 0xf0, 0x8e, 0x0, 0x0, 0xb, 0xc0,
    0x8e, 0x0, 0x0, 0x4f, 0x70, 0x8e, 0x44, 0x6a,
    0xfc, 0x0, 0x8f, 0xff, 0xfc, 0x70, 0x0,

    /* U+0045 "E" */
    0x8f, 0xff, 0xff, 0xa0, 0x8e, 0x55, 0x55, 0x30,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x50, 0x8e, 0x33, 0x33, 0x10,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x55, 0x55, 0x50,
    0x8f, 0xff, 0xff, 0xf0,

    /* U+0046 "F" */
    0x8f, 0xff, 0xff, 0xa8, 0xe5, 0x55, 0x53, 0x8e,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x11,
    0x11, 0x8, 0xff, 0xff, 0xf5, 0x8e, 0x44, 0x44,
    0x18, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8,
    0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x5b, 0xef, 0xec, 0x40, 0xaf, 0xa6, 0x55,
    0x74, 0x4f, 0x60, 0x0, 0x0, 0xa, 0xe0, 0x0,
    0x0, 0x0, 0xcb, 0x0, 0x0, 0x0, 0xd, 0xa0,
    0x0, 0xef, 0xfb, 0xcb, 0x0, 0x3, 0x3c, 0xba,
    0xe0, 0x0, 0x0, 0xbb, 0x5f, 0x50, 0x0, 0xb,
    0xb0, 0xcf, 0x95, 0x45, 0xdb, 0x0, 0x8d, 0xff,
    0xec, 0x60,

    /* U+0048 "H" */
    0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0, 0x0,
    0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0,
    0x0, 0x9d, 0x8f, 0xff, 0xff, 0xff, 0xd8, 0xe3,
    0x33, 0x33, 0xad, 0x8e, 0x0, 0x0, 0x9, 0xd8,
    0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9,
    0xd8, 0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0,
    0x9, 0xd0,

    /* U+0049 "I" */
    0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e,
    0x8e, 0x8e, 0x8e,

    /* U+004A "J" */
    0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0,
    0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0,
    0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0,
    0x8e, 0x0, 0x8, 0xe0, 0x0, 0xad, 0x15, 0x7f,
    0x83, 0xfe, 0x90,

    /* U+004B "K" */
    0x8e, 0x0, 0x1, 0xdc, 0x18, 0xe0, 0x1, 0xdc,
    0x10, 0x8e, 0x1, 0xcc, 0x0, 0x8, 0xe1, 0xcc,
    0x0, 0x0, 0x8f, 0xff, 0x10, 0x0, 0x8, 0xe4,
    0xf8, 0x0, 0x0, 0x8e, 0x6, 0xf4, 0x0, 0x8,
    0xe0, 0xb, 0xe1, 0x0, 0x8e, 0x0, 0x1f, 0xb0,
    0x8, 0xe0, 0x0, 0x6f, 0x60, 0x8e, 0x0, 0x0,
    0xaf, 0x20,

    /* U+004C "L" */
    0x8e, 0x0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8,
    0xe5, 0x55, 0x53, 0x8f, 0xff, 0xff, 0xb0,

    /* U+004D "M" */
    0x8f, 0xf0, 0x0, 0x0, 0xaf, 0xd8, 0xef, 0x60,
    0x0, 0x1f, 0xdd, 0x8e, 0x9c, 0x0, 0x7, 0xda,
    0xd8, 0xe3, 0xf2, 0x0, 0xd6, 0xad, 0x8e, 0xc,
    0x90, 0x4f, 0x1a, 0xd8, 0xe0, 0x6e, 0xa, 0xa0,
    0xad, 0x8e, 0x0, 0xe7, 0xf3, 0xa, 0xd8, 0xe0,
    0x8, 0xfd, 0x0, 0xad, 0x8e, 0x0, 0x28, 0x40,
    0xa, 0xd8, 0xe0, 0x0, 0x0, 0x0, 0xad, 0x8e,
    0x0, 0x0, 0x0, 0xa, 0xd0,

    /* U+004E "N" */
    0x8f, 0xe1, 0x0, 0x2, 0xf5, 0x8e, 0xe9, 0x0,
    0x2, 0xf5, 0x8e, 0x5f, 0x20, 0x2, 0xf5, 0x8e,
    0xc, 0xa0, 0x2, 0xf5, 0x8e, 0x3, 0xf3, 0x2,
    0xf5, 0x8e, 0x0, 0xac, 0x2, 0xf5, 0x8e, 0x0,
    0x2f, 0x52, 0xf5, 0x8e, 0x0, 0x8, 0xd2, 0xf5,
    0x8e, 0x0, 0x1, 0xe8, 0xf5, 0x8e, 0x0, 0x0,
    0x6f, 0xf5, 0x8e, 0x0, 0x0, 0xd, 0xf5,

    /* U+004F "O" */
    0x1, 0x9d, 0xff, 0xd8, 0x0, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x6f, 0x30, 0x0, 0x5, 0xf4, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0xcb, 0x0, 0x0, 0x0,
    0xda, 0xda, 0x0, 0x0, 0x0, 0xcb, 0xcb, 0x0,
    0x0, 0x0, 0xda, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0x6f, 0x30, 0x0, 0x4, 0xf4, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x1, 0x9d, 0xff, 0xd8, 0x0,

    /* U+0050 "P" */
    0x8f, 0xff, 0xec, 0x40, 0x8e, 0x44, 0x6c, 0xf3,
    0x8e, 0x0, 0x0, 0xf8, 0x8e, 0x0, 0x0, 0xd9,
    0x8e, 0x0, 0x0, 0xf8, 0x8e, 0x0, 0x18, 0xf3,
    0x8f, 0xff, 0xfe, 0x70, 0x8e, 0x33, 0x20, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x1, 0x9d, 0xff, 0xd8, 0x0, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x6f, 0x30, 0x0, 0x5, 0xf4, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0xcb, 0x0, 0x0, 0x0,
    0xda, 0xda, 0x0, 0x0, 0x0, 0xcb, 0xcb, 0x0,
    0x0, 0x0, 0xda, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0x6f, 0x30, 0x0, 0x4, 0xf4, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x1, 0x9d, 0xff, 0xe7, 0x0, 0x0,
    0x0, 0x9, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xcc,
    0x0,

    /* U+0052 "R" */
    0x8f, 0xff, 0xec, 0x50, 0x8, 0xe4, 0x45, 0xbf,
    0x30, 0x8e, 0x0, 0x0, 0xf7, 0x8, 0xe0, 0x0,
    0xf, 0x70, 0x8e, 0x0, 0x17, 0xf3, 0x8, 0xff,
    0xff, 0xe7, 0x0, 0x8e, 0x33, 0xe9, 0x0, 0x8,
    0xe0, 0x5, 0xf3, 0x0, 0x8e, 0x0, 0xb, 0xd0,
    0x8, 0xe0, 0x0, 0x1f, 0x90, 0x8e, 0x0, 0x0,
    0x6f, 0x30,

    /* U+0053 "S" */
    0x0, 0x8d, 0xff, 0xd5, 0x0, 0x9f, 0x75, 0x57,
    0x50, 0xd, 0x90, 0x0, 0x0, 0x0, 0xd9, 0x0,
    0x0, 0x0, 0x7, 0xfa, 0x51, 0x0, 0x0, 0x4,
    0xae, 0xfb, 0x20, 0x0, 0x0, 0x3, 0xcd, 0x0,
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x6f,
    0x1, 0x96, 0x54, 0x7e, 0xb0, 0xb, 0xef, 0xfd,
    0x81, 0x0,

    /* U+0054 "T" */
    0xcf, 0xff, 0xff, 0xff, 0x23, 0x55, 0xaf, 0x55,
    0x50, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0,

    /* U+0055 "U" */
    0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0, 0x0, 0x0,
    0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0, 0x0,
    0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0,
    0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9,
    0xe0, 0x0, 0x0, 0xac, 0x7f, 0x10, 0x0, 0xd,
    0xa1, 0xfd, 0x64, 0x5b, 0xf4, 0x3, 0xbe, 0xff,
    0xb4, 0x0,

    /* U+0056 "V" */
    0x9e, 0x0, 0x0, 0x0, 0xf7, 0x3f, 0x40, 0x0,
    0x5, 0xf1, 0xe, 0x90, 0x0, 0xa, 0xc0, 0x8,
    0xe0, 0x0, 0xf, 0x60, 0x3, 0xf4, 0x0, 0x5f,
    0x10, 0x0, 0xd9, 0x0, 0xab, 0x0, 0x0, 0x8e,
    0x0, 0xf5, 0x0, 0x0, 0x2f, 0x45, 0xf0, 0x0,
    0x0, 0xd, 0x9a, 0xa0, 0x0, 0x0, 0x8, 0xef,
    0x50, 0x0, 0x0, 0x2, 0xff, 0x0, 0x0,

    /* U+0057 "W" */
    0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x3f,
    0x40, 0x0, 0x8b, 0x20, 0x0, 0xd9, 0xf, 0x70,
    0x0, 0xff, 0x60, 0x0, 0xf5, 0xc, 0xb0, 0x4,
    0xf9, 0xb0, 0x4, 0xf1, 0x8, 0xe0, 0x8, 0xa4,
    0xf0, 0x7, 0xd0, 0x4, 0xf2, 0xd, 0x60, 0xf4,
    0xb, 0xa0, 0x0, 0xf5, 0x1f, 0x10, 0xc8, 0xe,
    0x60, 0x0, 0xd9, 0x6d, 0x0, 0x7d, 0x2f, 0x20,
    0x0, 0x9d, 0xa8, 0x0, 0x3f, 0x7e, 0x0, 0x0,
    0x5f, 0xf4, 0x0, 0xe, 0xfa, 0x0, 0x0, 0x1f,
    0xf0, 0x0, 0xa, 0xf6, 0x0,

    /* U+0058 "X" */
    0x1e, 0xa0, 0x0, 0x6, 0xf2, 0x6, 0xf3, 0x0,
    0x1e, 0x70, 0x0, 0xcc, 0x0, 0xad, 0x0, 0x0,
    0x2f, 0x64, 0xf3, 0x0, 0x0, 0x8, 0xed, 0x80,
    0x0, 0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0xb,
    0xdc, 0xb0, 0x0, 0x0, 0x5f, 0x33, 0xf6, 0x0,
    0x1, 0xe9, 0x0, 0x9e, 0x10, 0xa, 0xe0, 0x0,
    0x1e, 0xa0, 0x4f, 0x40, 0x0, 0x6, 0xf4,

    /* U+0059 "Y" */
    0x9f, 0x10, 0x0, 0x7, 0xf2, 0x1e, 0xa0, 0x0,
    0x1f, 0x70, 0x5, 0xf4, 0x0, 0xac, 0x0, 0x0,
    0xbd, 0x4, 0xf3, 0x0, 0x0, 0x2f, 0x7d, 0x90,
    0x0, 0x0, 0x7, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0,

    /* U+005A "Z" */
    0xc, 0xff, 0xff, 0xff, 0xf0, 0x4, 0x55, 0x55,
    0x6f, 0xd0, 0x0, 0x0, 0x0, 0x9f, 0x20, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x0, 0x1, 0xdb, 0x0, 0x0, 0x0, 0xb,
    0xd1, 0x0, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0xe, 0xd6, 0x66,
    0x66, 0x61, 0x1f, 0xff, 0xff, 0xff, 0xf5,

    /* U+005B "[" */
    0xef, 0xf2, 0xe9, 0x30, 0xe8, 0x0, 0xe8, 0x0,
    0xe8, 0x0, 0xe8, 0x0, 0xe8, 0x0, 0xe8, 0x0,
    0xe8, 0x0, 0xe8, 0x0, 0xe8, 0x0, 0xe8, 0x0,
    0xe8, 0x0, 0xe9, 0x30, 0xef, 0xf2,

    /* U+005C "\\" */
    0x6d, 0x0, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x8, 0xb0, 0x0, 0x0, 0x1, 0xf2, 0x0, 0x0,
    0x0, 0xa9, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x0,
    0x0, 0xc, 0x70, 0x0, 0x0, 0x5, 0xe0, 0x0,
    0x0, 0x0, 0xe5, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x1f, 0x30, 0x0, 0x0, 0x9, 0xa0,
    0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0x0, 0xb8,

    /* U+005D "]" */
    0x7f, 0xf9, 0x13, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9, 0x0, 0xd9,
    0x0, 0xd9, 0x13, 0xd9, 0x7f, 0xf9,

    /* U+005E "^" */
    0x0, 0xb, 0xf9, 0x0, 0x0, 0x2f, 0x9f, 0x0,
    0x0, 0x8c, 0xe, 0x60, 0x0, 0xe6, 0x8, 0xc0,
    0x6, 0xe0, 0x2, 0xf3, 0xc, 0x90, 0x0, 0xba,

    /* U+005F "_" */
    0xff, 0xff, 0xff, 0xff, 0x22, 0x22, 0x22, 0x22,

    /* U+0060 "`" */
    0x7, 0x60, 0x0, 0x5f, 0x30, 0x0, 0x8b, 0x0,

    /* U+0061 "a" */
    0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0, 0x53, 0x4c,
    0xf1, 0x0, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0x1, 0xf5, 0x2, 0xae, 0xff, 0xff, 0x50, 0xdc,
    0x42, 0x23, 0xf5, 0x1f, 0x50, 0x0, 0x2f, 0x50,
    0xea, 0x11, 0x4c, 0xf5, 0x3, 0xcf, 0xfb, 0x3e,
    0x50,

    /* U+0062 "b" */
    0x8d, 0x0, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x8, 0xd4, 0xdf,
    0xe9, 0x0, 0x8e, 0xc5, 0x36, 0xf9, 0x8, 0xf2,
    0x0, 0x8, 0xf0, 0x8d, 0x0, 0x0, 0x5f, 0x28,
    0xc0, 0x0, 0x4, 0xf2, 0x8d, 0x0, 0x0, 0x5f,
    0x18, 0xf2, 0x0, 0x8, 0xe0, 0x8e, 0xd5, 0x37,
    0xf8, 0x8, 0xb4, 0xdf, 0xe9, 0x0,

    /* U+0063 "c" */
    0x0, 0x6d, 0xff, 0xd2, 0x6, 0xf8, 0x44, 0x61,
    0xc, 0xb0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0x6, 0xf8, 0x44, 0x62,
    0x0, 0x6d, 0xff, 0xd2,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0xa, 0xb0, 0x7, 0xdf,
    0xe6, 0xab, 0x5, 0xf8, 0x34, 0xcd, 0xb0, 0xcb,
    0x0, 0x0, 0xfb, 0xf, 0x80, 0x0, 0xb, 0xb0,
    0xf7, 0x0, 0x0, 0xab, 0xf, 0x70, 0x0, 0xb,
    0xb0, 0xda, 0x0, 0x0, 0xeb, 0x7, 0xf5, 0x12,
    0xae, 0xb0, 0x8, 0xef, 0xe7, 0x8b,

    /* U+0065 "e" */
    0x0, 0x6d, 0xff, 0xb2, 0x0, 0x6f, 0x73, 0x3c,
    0xc0, 0xd, 0xa0, 0x0, 0x2f, 0x20, 0xf7, 0x12,
    0x35, 0xf4, 0xf, 0xed, 0xdd, 0xdd, 0x30, 0xf7,
    0x0, 0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x0,
    0x6f, 0x95, 0x46, 0x90, 0x0, 0x6d, 0xff, 0xd8,
    0x0,

    /* U+0066 "f" */
    0x0, 0x6d, 0xf8, 0x1, 0xf9, 0x21, 0x3, 0xf2,
    0x0, 0xbf, 0xff, 0xf2, 0x16, 0xf4, 0x20, 0x4,
    0xf1, 0x0, 0x4, 0xf1, 0x0, 0x4, 0xf1, 0x0,
    0x4, 0xf1, 0x0, 0x4, 0xf1, 0x0, 0x4, 0xf1,
    0x0, 0x4, 0xf1, 0x0,

    /* U+0067 "g" */
    0x0, 0x7d, 0xfd, 0x6a, 0xb0, 0x5f, 0x83, 0x4c,
    0xdb, 0xc, 0xb0, 0x0, 0xf, 0xb0, 0xf7, 0x0,
    0x0, 0xbb, 0xf, 0x70, 0x0, 0xa, 0xb0, 0xf7,
    0x0, 0x0, 0xbb, 0xd, 0xb0, 0x0, 0xe, 0xb0,
    0x7f, 0x83, 0x4b, 0xeb, 0x0, 0x8e, 0xfe, 0x7b,
    0xb0, 0x0, 0x0, 0x0, 0xe8, 0x0, 0x34, 0x35,
    0xce, 0x10, 0x7, 0xef, 0xea, 0x20,

    /* U+0068 "h" */
    0x8d, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x0, 0x8d, 0x5d, 0xfd, 0x70,
    0x8f, 0xd6, 0x49, 0xf3, 0x8f, 0x10, 0x0, 0xf7,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,

    /* U+0069 "i" */
    0x9d, 0x58, 0x0, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d,
    0x8d, 0x8d, 0x8d, 0x8d,

    /* U+006A "j" */
    0x0, 0x9, 0xd0, 0x0, 0x58, 0x0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0,
    0x8, 0xd0, 0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0,
    0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0, 0x9,
    0xc0, 0x34, 0xe8, 0x1f, 0xfb, 0x10,

    /* U+006B "k" */
    0x8d, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x1e, 0xa0,
    0x8d, 0x0, 0xcc, 0x0, 0x8d, 0x8, 0xe1, 0x0,
    0x8d, 0x4f, 0x30, 0x0, 0x8f, 0xf9, 0x0, 0x0,
    0x8d, 0x7f, 0x40, 0x0, 0x8d, 0x9, 0xe2, 0x0,
    0x8d, 0x0, 0xcd, 0x10, 0x8d, 0x0, 0x1e, 0xc0,

    /* U+006C "l" */
    0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8e, 0x31, 0x2d, 0xf4,

    /* U+006D "m" */
    0x8d, 0x8e, 0xfc, 0x36, 0xdf, 0xd4, 0x8, 0xfa,
    0x22, 0xcf, 0xc3, 0x29, 0xf1, 0x8e, 0x0, 0x6,
    0xf2, 0x0, 0x1f, 0x48, 0xd0, 0x0, 0x4f, 0x10,
    0x0, 0xf5, 0x8d, 0x0, 0x4, 0xf1, 0x0, 0xf,
    0x58, 0xd0, 0x0, 0x4f, 0x10, 0x0, 0xf5, 0x8d,
    0x0, 0x4, 0xf1, 0x0, 0xf, 0x58, 0xd0, 0x0,
    0x4f, 0x10, 0x0, 0xf5, 0x8d, 0x0, 0x4, 0xf1,
    0x0, 0xf, 0x50,

    /* U+006E "n" */
    0x8d, 0x6d, 0xfd, 0x70, 0x8f, 0xb3, 0x27, 0xf3,
    0x8f, 0x10, 0x0, 0xf7, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8,

    /* U+006F "o" */
    0x0, 0x6d, 0xff, 0xc5, 0x0, 0x6f, 0x73, 0x39,
    0xf4, 0xc, 0xa0, 0x0, 0xd, 0xa0, 0xf7, 0x0,
    0x0, 0x9d, 0xf, 0x60, 0x0, 0x8, 0xe0, 0xf7,
    0x0, 0x0, 0x9d, 0xc, 0xb0, 0x0, 0xc, 0xa0,
    0x6f, 0x83, 0x39, 0xf4, 0x0, 0x6d, 0xff, 0xc5,
    0x0,

    /* U+0070 "p" */
    0x8d, 0x5d, 0xfe, 0x90, 0x8, 0xeb, 0x31, 0x4e,
    0x90, 0x8f, 0x10, 0x0, 0x8f, 0x8, 0xd0, 0x0,
    0x4, 0xf2, 0x8c, 0x0, 0x0, 0x4f, 0x28, 0xe0,
    0x0, 0x5, 0xf1, 0x8f, 0x30, 0x0, 0x9e, 0x8,
    0xed, 0x53, 0x7f, 0x80, 0x8d, 0x4d, 0xfe, 0x90,
    0x8, 0xd0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x0, 0x8, 0xd0, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x7d, 0xfe, 0x6a, 0xb0, 0x5f, 0x83, 0x4c,
    0xdb, 0xc, 0xb0, 0x0, 0xf, 0xb0, 0xf7, 0x0,
    0x0, 0xbb, 0xf, 0x70, 0x0, 0xa, 0xb0, 0xf7,
    0x0, 0x0, 0xbb, 0xd, 0xb0, 0x0, 0xf, 0xb0,
    0x7f, 0x83, 0x5c, 0xdb, 0x0, 0x8e, 0xfe, 0x6a,
    0xb0, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0xa, 0xb0, 0x0, 0x0, 0x0, 0xab,

    /* U+0072 "r" */
    0x8d, 0x4d, 0xb8, 0xec, 0x41, 0x8f, 0x20, 0x8,
    0xd0, 0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d,
    0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0, 0x0,

    /* U+0073 "s" */
    0x1, 0xae, 0xfe, 0x40, 0xac, 0x32, 0x42, 0xe,
    0x60, 0x0, 0x0, 0xbd, 0x51, 0x0, 0x1, 0x8e,
    0xfb, 0x10, 0x0, 0x2, 0xd9, 0x0, 0x0, 0x9,
    0xb0, 0x53, 0x24, 0xe7, 0xd, 0xff, 0xe8, 0x0,

    /* U+0074 "t" */
    0x7, 0xe0, 0x0, 0x7, 0xe0, 0x0, 0xcf, 0xff,
    0xf0, 0x29, 0xe3, 0x30, 0x7, 0xe0, 0x0, 0x7,
    0xe0, 0x0, 0x7, 0xe0, 0x0, 0x7, 0xe0, 0x0,
    0x7, 0xe0, 0x0, 0x5, 0xf5, 0x30, 0x0, 0xbf,
    0xf1,

    /* U+0075 "u" */
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x8d, 0x0, 0x3, 0xf5, 0x5f, 0x51, 0x4c, 0xf5,
    0x8, 0xef, 0xd5, 0xe5,

    /* U+0076 "v" */
    0xab, 0x0, 0x0, 0x5f, 0x14, 0xf1, 0x0, 0xb,
    0xb0, 0xe, 0x60, 0x1, 0xf5, 0x0, 0x9c, 0x0,
    0x6f, 0x0, 0x3, 0xf1, 0xb, 0xa0, 0x0, 0xd,
    0x71, 0xf4, 0x0, 0x0, 0x8c, 0x6e, 0x0, 0x0,
    0x2, 0xfd, 0x90, 0x0, 0x0, 0xc, 0xf3, 0x0,
    0x0,

    /* U+0077 "w" */
    0x8d, 0x0, 0x5, 0xf9, 0x0, 0x9, 0xc4, 0xf1,
    0x0, 0xae, 0xd0, 0x0, 0xd8, 0xf, 0x50, 0xe,
    0x6f, 0x20, 0x1f, 0x30, 0xb9, 0x3, 0xf0, 0xc7,
    0x4, 0xf0, 0x7, 0xd0, 0x7b, 0x8, 0xb0, 0x8b,
    0x0, 0x3f, 0xc, 0x60, 0x3f, 0xc, 0x70, 0x0,
    0xf5, 0xf2, 0x0, 0xe5, 0xf2, 0x0, 0xb, 0xdd,
    0x0, 0xa, 0xde, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x5f, 0xa0, 0x0,

    /* U+0078 "x" */
    0x4f, 0x30, 0x0, 0xe8, 0x0, 0xad, 0x0, 0x8e,
    0x0, 0x1, 0xe7, 0x2f, 0x40, 0x0, 0x6, 0xfc,
    0xa0, 0x0, 0x0, 0xe, 0xf4, 0x0, 0x0, 0x8,
    0xeb, 0xc0, 0x0, 0x2, 0xf5, 0x1f, 0x60, 0x0,
    0xcb, 0x0, 0x7f, 0x10, 0x7f, 0x10, 0x0, 0xdb,
    0x0,

    /* U+0079 "y" */
    0xad, 0x0, 0x0, 0x4f, 0x14, 0xf2, 0x0, 0xa,
    0xb0, 0xd, 0x80, 0x0, 0xf5, 0x0, 0x7e, 0x0,
    0x5f, 0x0, 0x1, 0xf4, 0xa, 0x90, 0x0, 0xa,
    0xa0, 0xf4, 0x0, 0x0, 0x4f, 0x6e, 0x0, 0x0,
    0x0, 0xdf, 0x80, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0x4, 0x9f, 0x30,
    0x0, 0x0, 0xec, 0x40, 0x0, 0x0,

    /* U+007A "z" */
    0xe, 0xff, 0xff, 0xf4, 0x3, 0x33, 0x3c, 0xe1,
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x2, 0xf7, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0x9e, 0x10, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x1e, 0xb4, 0x44, 0x42,
    0x4f, 0xff, 0xff, 0xf8,

    /* U+007B "{" */
    0x0, 0x6e, 0x30, 0xf, 0x91, 0x2, 0xf3, 0x0,
    0x3f, 0x30, 0x3, 0xf3, 0x0, 0x3f, 0x30, 0x6,
    0xf1, 0x3, 0xfa, 0x0, 0x8, 0xf1, 0x0, 0x3f,
    0x30, 0x3, 0xf3, 0x0, 0x3f, 0x30, 0x2, 0xf3,
    0x0, 0xf, 0x91, 0x0, 0x6e, 0x30,

    /* U+007C "|" */
    0x3f, 0x23, 0xf2, 0x3f, 0x23, 0xf2, 0x3f, 0x23,
    0xf2, 0x3f, 0x23, 0xf2, 0x3f, 0x23, 0xf2, 0x3f,
    0x23, 0xf2, 0x3f, 0x23, 0xf2, 0x3f, 0x20,

    /* U+007D "}" */
    0x7d, 0x30, 0x2c, 0xc0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x6, 0xf0, 0x5, 0xf2, 0x0, 0xdf,
    0x4, 0xf5, 0x6, 0xf0, 0x6, 0xf0, 0x6, 0xf0,
    0x6, 0xf0, 0x2c, 0xd0, 0x7d, 0x30,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xe9, 0x33,
    0xf4, 0x6d, 0x3, 0xbf, 0xfc, 0x0, 0x10, 0x0,
    0x12, 0x0,

    /* U+00A1 "¡" */
    0x1e, 0xb1, 0xfc, 0x0, 0x0, 0xb6, 0xb, 0x60,
    0xc7, 0xc, 0x70, 0xd8, 0xd, 0x80, 0xe9, 0xe,
    0x90, 0x0,

    /* U+00A2 "¢" */
    0x0, 0x0, 0xe1, 0x0, 0x0, 0x8d, 0xff, 0xe4,
    0xc, 0xe6, 0xf4, 0x63, 0x4f, 0x30, 0xe1, 0x0,
    0x7f, 0x0, 0xe1, 0x0, 0x8f, 0x0, 0xe1, 0x0,
    0x6f, 0x10, 0xe1, 0x0, 0x1f, 0xb3, 0xe2, 0x22,
    0x3, 0xcf, 0xff, 0xf6, 0x0, 0x0, 0xe3, 0x10,
    0x0, 0x0, 0xe1, 0x0,

    /* U+00A3 "£" */
    0x0, 0x4c, 0xee, 0xc0, 0x5, 0xf8, 0x33, 0x50,
    0xc, 0xc0, 0x0, 0x0, 0xd, 0x90, 0x0, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0xdf, 0xff, 0xfb, 0x0,
    0x14, 0xf4, 0x21, 0x0, 0x1, 0xf4, 0x0, 0x0,
    0x4, 0xf1, 0x0, 0x0, 0x1d, 0xb4, 0x44, 0x41,
    0x5f, 0xff, 0xff, 0xf6,

    /* U+00A4 "¤" */
    0x1, 0x0, 0x0, 0x1, 0x1, 0xe8, 0xcf, 0xd8,
    0xf3, 0x7, 0xfa, 0x58, 0xfa, 0x0, 0x8d, 0x0,
    0xa, 0xb0, 0x9, 0xa0, 0x0, 0x7d, 0x0, 0x8b,
    0x0, 0x8, 0xc0, 0x6, 0xf6, 0x14, 0xe9, 0x1,
    0xec, 0xff, 0xfc, 0xf3, 0x4, 0x1, 0x31, 0x4,
    0x0,

    /* U+00A5 "¥" */
    0x6f, 0x20, 0x0, 0xe, 0x90, 0xcb, 0x0, 0x7,
    0xe0, 0x2, 0xf4, 0x1, 0xf5, 0x0, 0x8, 0xd0,
    0x9b, 0x0, 0x0, 0xd, 0x9f, 0x20, 0x0, 0x8e,
    0xff, 0xfe, 0xb0, 0x1, 0x12, 0xf5, 0x11, 0x0,
    0x8e, 0xef, 0xfe, 0xb0, 0x1, 0x12, 0xf5, 0x11,
    0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x1, 0xf4,
    0x0, 0x0,

    /* U+00A6 "¦" */
    0x3f, 0x23, 0xf2, 0x3f, 0x23, 0xf2, 0x3f, 0x21,
    0x81, 0x0, 0x0, 0x0, 0x0, 0x1, 0x81, 0x3f,
    0x23, 0xf2, 0x3f, 0x23, 0xf2, 0x3f, 0x20,

    /* U+00A7 "§" */
    0x1, 0xae, 0xfe, 0x40, 0xac, 0x32, 0x42, 0xe,
    0x60, 0x0, 0x0, 0xbd, 0x40, 0x0, 0x2, 0xff,
    0xfa, 0x0, 0xab, 0x4, 0xe8, 0xe, 0x60, 0x9,
    0xb0, 0xbd, 0x41, 0xd8, 0x1, 0xaf, 0xff, 0x10,
    0x0, 0x4, 0xe8, 0x0, 0x0, 0x9, 0xb0, 0x30,
    0x2, 0xd8, 0xf, 0xff, 0xfb, 0x10, 0x1, 0x20,
    0x0,

    /* U+00A8 "¨" */
    0x39, 0x5, 0x85, 0xf1, 0x8d,

    /* U+00A9 "©" */
    0x0, 0x2, 0x8c, 0xdc, 0x81, 0x0, 0x0, 0x5,
    0xe8, 0x32, 0x38, 0xe4, 0x0, 0x3, 0xe2, 0x0,
    0x0, 0x3, 0xe2, 0x0, 0xc5, 0x4, 0xbe, 0xe5,
    0x7, 0xa0, 0x1f, 0x1, 0xf7, 0x23, 0x20, 0x1f,
    0x3, 0xc0, 0x5e, 0x0, 0x0, 0x0, 0xe2, 0x4c,
    0x5, 0xe0, 0x0, 0x0, 0xe, 0x22, 0xe0, 0x2f,
    0x50, 0x1, 0x0, 0xf0, 0xd, 0x40, 0x6e, 0xff,
    0x80, 0x6b, 0x0, 0x6d, 0x0, 0x1, 0x10, 0x2e,
    0x30, 0x0, 0x9d, 0x50, 0x0, 0x6e, 0x60, 0x0,
    0x0, 0x5c, 0xff, 0xfb, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0,

    /* U+00AA "ª" */
    0x0, 0x9e, 0xd8, 0x0, 0x1, 0x14, 0xf3, 0x6,
    0xcd, 0xdf, 0x41, 0xf5, 0x3, 0xf4, 0x9, 0xed,
    0x9d, 0x30,

    /* U+00AB "«" */
    0x0, 0x5b, 0x23, 0xb4, 0x3, 0xf8, 0x1e, 0xb0,
    0x1e, 0xb0, 0xcd, 0x0, 0x3f, 0x71, 0xea, 0x0,
    0x6, 0xf4, 0x4f, 0x70, 0x0, 0x9f, 0x26, 0xf4,

    /* U+00AC "¬" */
    0x1, 0x11, 0x11, 0x11, 0x7, 0xff, 0xff, 0xff,
    0xf4, 0x14, 0x44, 0x44, 0x5f, 0x40, 0x0, 0x0,
    0x1, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x40, 0x0,
    0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x4, 0x10,

    /* U+00AD "­" */
    0xdf, 0xff, 0xe2, 0x22, 0x22,

    /* U+00AE "®" */
    0x4, 0xbb, 0x91, 0x3, 0xbc, 0xb7, 0xa0, 0x83,
    0xc4, 0x8b, 0x9, 0x3e, 0xd3, 0xb0, 0x4a, 0x85,
    0x8a, 0x0, 0x5b, 0xb9, 0x0,

    /* U+00AF "¯" */
    0x9f, 0xff, 0xf1, 0x12, 0x22, 0x20,

    /* U+00B0 "°" */
    0x0, 0x0, 0x0, 0x8, 0xfe, 0x50, 0x6e, 0x56,
    0xf3, 0xa9, 0x0, 0xc7, 0x7d, 0x23, 0xf4, 0xb,
    0xff, 0x80, 0x0, 0x21, 0x0,

    /* U+00B1 "±" */
    0x0, 0x4, 0xf1, 0x0, 0x0, 0x0, 0x4f, 0x10,
    0x0, 0x0, 0x4, 0xf1, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xf4, 0x13, 0x36, 0xf4, 0x33, 0x0, 0x0,
    0x4f, 0x10, 0x0, 0x0, 0x1, 0x61, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xf4, 0x13, 0x33, 0x33, 0x33,
    0x0,

    /* U+00B2 "²" */
    0x8, 0xef, 0xc2, 0x1, 0x1, 0xc8, 0x0, 0x0,
    0xd4, 0x0, 0x2c, 0x70, 0x6, 0xd4, 0x0, 0x1f,
    0xff, 0xfd,

    /* U+00B3 "³" */
    0x7e, 0xfc, 0x20, 0x1, 0xd6, 0xf, 0xfc, 0x0,
    0x1, 0xc8, 0x10, 0x1c, 0x9c, 0xfe, 0xb1,

    /* U+00B4 "´" */
    0x2, 0x82, 0xc, 0xb0, 0x4e, 0x10,

    /* U+00B5 "µ" */
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9d, 0x0, 0x3, 0xf5, 0x9f, 0x51, 0x4c, 0xf5,
    0x9f, 0xef, 0xd5, 0xe5, 0x9c, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x0,

    /* U+00B6 "¶" */
    0x6, 0xdf, 0xff, 0xff, 0xb3, 0xff, 0xfb, 0x3d,
    0xa2, 0x7f, 0xff, 0xa0, 0xc9, 0x7, 0xff, 0xfa,
    0xc, 0x90, 0x5f, 0xff, 0xa0, 0xc9, 0x0, 0xcf,
    0xfa, 0xc, 0x90, 0x0, 0x3c, 0xa0, 0xc9, 0x0,
    0x0, 0xaa, 0xc, 0x90, 0x0, 0xa, 0xa0, 0xc9,
    0x0, 0x0, 0xaa, 0xc, 0x90, 0x0, 0xa, 0xa0,
    0xc9, 0x0, 0x0, 0xaa, 0xc, 0x90, 0x0, 0xa,
    0xa0, 0xc9, 0x0, 0x0, 0x22, 0x2, 0x20,

    /* U+00B7 "·" */
    0x0, 0x8, 0xf5, 0x7f, 0x40,

    /* U+00B8 "¸" */
    0x8, 0x40, 0x4e, 0x91, 0x0, 0xe7, 0xcc, 0xa1,

    /* U+00B9 "¹" */
    0x7d, 0xf4, 0x21, 0xe4, 0x0, 0xe4, 0x0, 0xe4,
    0x0, 0xe4, 0x0, 0xe4,

    /* U+00BA "º" */
    0x3, 0xbd, 0xc3, 0x0, 0xd6, 0x5, 0xe0, 0xf,
    0x10, 0xf, 0x10, 0xf1, 0x0, 0xf1, 0xd, 0x60,
    0x4e, 0x0, 0x3c, 0xdc, 0x40,

    /* U+00BB "»" */
    0x2b, 0x51, 0xa7, 0x0, 0x8, 0xf3, 0x5f, 0x50,
    0x0, 0xbe, 0x18, 0xf3, 0x0, 0x8f, 0x35, 0xf6,
    0x4, 0xf6, 0x2f, 0x90, 0x2f, 0x91, 0xdb, 0x0,

    /* U+00BC "¼" */
    0x5a, 0xc3, 0x0, 0x0, 0x4c, 0x10, 0x6, 0x6e,
    0x40, 0x0, 0xc, 0x90, 0x0, 0x0, 0xe4, 0x0,
    0x5, 0xf1, 0x0, 0x0, 0xe, 0x40, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0xe4, 0x0, 0x7e, 0x0, 0x12,
    0x0, 0xe, 0x40, 0x1e, 0x60, 0x1e, 0xe0, 0x0,
    0xe4, 0x8, 0xd0, 0xc, 0xae, 0x0, 0x0, 0x1,
    0xf4, 0x8, 0xa4, 0xe0, 0x0, 0x0, 0xac, 0x4,
    0xd0, 0x4e, 0x0, 0x0, 0x3f, 0x30, 0x9f, 0xef,
    0xfa, 0x0, 0xb, 0xa0, 0x1, 0x11, 0x5e, 0x10,
    0x1, 0x92, 0x0, 0x0, 0x2, 0x80,

    /* U+00BD "½" */
    0x7d, 0xf4, 0x0, 0x0, 0x6e, 0x10, 0x2, 0x1e,
    0x40, 0x0, 0xe, 0x70, 0x0, 0x0, 0xe4, 0x0,
    0x8, 0xd0, 0x0, 0x0, 0xe, 0x40, 0x1, 0xf5,
    0x0, 0x0, 0x0, 0xe4, 0x0, 0xac, 0x9d, 0xd8,
    0x0, 0xe, 0x40, 0x3f, 0x33, 0x23, 0xf5, 0x0,
    0xb3, 0xc, 0xa0, 0x0, 0xe, 0x50, 0x0, 0x5,
    0xf1, 0x0, 0x6, 0xe1, 0x0, 0x0, 0xd8, 0x0,
    0x6, 0xe3, 0x0, 0x0, 0x7e, 0x0, 0x8, 0xd2,
    0x0, 0x0, 0x1e, 0x60, 0x3, 0xff, 0xff, 0x90,
    0x0, 0x10, 0x0, 0x1, 0x11, 0x11,

    /* U+00BE "¾" */
    0x7f, 0xfa, 0x0, 0x0, 0x5f, 0x10, 0x1, 0x1,
    0xd6, 0x0, 0xd, 0x70, 0x0, 0x0, 0x2e, 0x50,
    0x7, 0xe0, 0x0, 0x0, 0xff, 0xb0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x1c, 0x80, 0x8d, 0x0, 0x12,
    0x0, 0x0, 0xb9, 0x1f, 0x50, 0x1e, 0xe0, 0xdf,
    0xfc, 0x29, 0xc0, 0xc, 0xae, 0x0, 0x10, 0x2,
    0xf4, 0x8, 0xa4, 0xe0, 0x0, 0x0, 0xab, 0x4,
    0xd0, 0x4e, 0x0, 0x0, 0x3f, 0x30, 0x9f, 0xef,
    0xfa, 0x0, 0xb, 0xa0, 0x1, 0x11, 0x5e, 0x10,
    0x1, 0x92, 0x0, 0x0, 0x2, 0x80,

    /* U+00BF "¿" */
    0x0, 0x1f, 0xa0, 0x0, 0x1, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x85, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x2d, 0xc0, 0x0, 0x1e, 0xb0, 0x0,
    0x8, 0xf0, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x8,
    0xf5, 0x11, 0x31, 0x1c, 0xff, 0xff, 0x30, 0x2,
    0x33, 0x10,

    /* U+00C0 "À" */
    0x0, 0x38, 0x30, 0x0, 0x0, 0x0, 0x0, 0xae,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f, 0xbd, 0x0,
    0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0, 0x0, 0x0,
    0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e, 0x0, 0x4f,
    0x0, 0x0, 0xb, 0x91, 0x11, 0xe6, 0x0, 0x1,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c, 0x44, 0x44,
    0x5f, 0x20, 0xd, 0x70, 0x0, 0x0, 0xd8, 0x4,
    0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac, 0x0, 0x0,
    0x0, 0x3f, 0x40,

    /* U+00C1 "Á" */
    0x0, 0x0, 0x0, 0x67, 0x10, 0x0, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0x0, 0x1e, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f, 0xbd, 0x0,
    0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0, 0x0, 0x0,
    0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e, 0x0, 0x4f,
    0x0, 0x0, 0xb, 0x91, 0x11, 0xe6, 0x0, 0x1,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c, 0x44, 0x44,
    0x5f, 0x20, 0xd, 0x70, 0x0, 0x0, 0xd8, 0x4,
    0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac, 0x0, 0x0,
    0x0, 0x3f, 0x40,

    /* U+00C2 "Â" */
    0x0, 0x0, 0x68, 0x30, 0x0, 0x0, 0x0, 0x6f,
    0xbe, 0x20, 0x0, 0x0, 0x4e, 0x30, 0x7d, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f, 0xbd, 0x0,
    0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0, 0x0, 0x0,
    0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e, 0x0, 0x4f,
    0x0, 0x0, 0xb, 0x91, 0x11, 0xe6, 0x0, 0x1,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c, 0x44, 0x44,
    0x5f, 0x20, 0xd, 0x70, 0x0, 0x0, 0xd8, 0x4,
    0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac, 0x0, 0x0,
    0x0, 0x3f, 0x40,

    /* U+00C3 "Ã" */
    0x0, 0x2d, 0xd6, 0xc, 0x40, 0x0, 0x9, 0xa5,
    0xdf, 0xd0, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0,
    0x0, 0x0, 0xc, 0xf7, 0x0, 0x0, 0x0, 0x2,
    0xfb, 0xd0, 0x0, 0x0, 0x0, 0x9c, 0x1f, 0x40,
    0x0, 0x0, 0xe, 0x50, 0xba, 0x0, 0x0, 0x5,
    0xe0, 0x4, 0xf0, 0x0, 0x0, 0xb9, 0x11, 0x1e,
    0x60, 0x0, 0x1f, 0xff, 0xff, 0xfc, 0x0, 0x7,
    0xc4, 0x44, 0x45, 0xf2, 0x0, 0xd7, 0x0, 0x0,
    0xd, 0x80, 0x4f, 0x20, 0x0, 0x0, 0x8e, 0xa,
    0xc0, 0x0, 0x0, 0x3, 0xf4,

    /* U+00C4 "Ä" */
    0x0, 0xe, 0x80, 0xd9, 0x0, 0x0, 0x0, 0x94,
    0x8, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf7, 0x0, 0x0, 0x0, 0x2,
    0xfb, 0xd0, 0x0, 0x0, 0x0, 0x9c, 0x1f, 0x40,
    0x0, 0x0, 0xe, 0x50, 0xba, 0x0, 0x0, 0x5,
    0xe0, 0x4, 0xf0, 0x0, 0x0, 0xb9, 0x11, 0x1e,
    0x60, 0x0, 0x1f, 0xff, 0xff, 0xfc, 0x0, 0x7,
    0xc4, 0x44, 0x45, 0xf2, 0x0, 0xd7, 0x0, 0x0,
    0xd, 0x80, 0x4f, 0x20, 0x0, 0x0, 0x8e, 0xa,
    0xc0, 0x0, 0x0, 0x3, 0xf4,

    /* U+00C5 "Å" */
    0x0, 0x0, 0xbe, 0x80, 0x0, 0x0, 0x0, 0x4c,
    0x1e, 0x0, 0x0, 0x0, 0x0, 0xbe, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f, 0xbd, 0x0,
    0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0, 0x0, 0x0,
    0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e, 0x0, 0x4f,
    0x0, 0x0, 0xb, 0x91, 0x11, 0xe6, 0x0, 0x1,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c, 0x44, 0x44,
    0x5f, 0x20, 0xd, 0x70, 0x0, 0x0, 0xd8, 0x4,
    0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac, 0x0, 0x0,
    0x0, 0x3f, 0x40,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x3f, 0x9f, 0x75, 0x55, 0x40, 0x0,
    0x0, 0xb, 0xb3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf2, 0x3f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xc9, 0x3, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x4f,
    0x21, 0x4f, 0x63, 0x33, 0x20, 0x0, 0xc, 0xff,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0x4, 0xf4, 0x44,
    0x6f, 0x30, 0x0, 0x0, 0x0, 0xc8, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x3f,
    0x75, 0x55, 0x51, 0xd, 0xa0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0x50,

    /* U+00C7 "Ç" */
    0x0, 0x6c, 0xef, 0xe9, 0xa, 0xfa, 0x65, 0x66,
    0x4f, 0x60, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0xc, 0xf9, 0x55, 0x68,
    0x0, 0x8d, 0xff, 0xe9, 0x0, 0x5, 0xf5, 0x0,
    0x0, 0x3, 0x6f, 0x40, 0x0, 0x2c, 0xdb, 0x10,

    /* U+00C8 "È" */
    0x17, 0x50, 0x0, 0x0, 0x6, 0xf3, 0x0, 0x0,
    0x0, 0x6e, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xa0, 0x8e, 0x55, 0x55, 0x30,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x50, 0x8e, 0x33, 0x33, 0x10,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x55, 0x55, 0x50,
    0x8f, 0xff, 0xff, 0xf0,

    /* U+00C9 "É" */
    0x0, 0x0, 0x38, 0x20, 0x0, 0x1, 0xe9, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xa0, 0x8e, 0x55, 0x55, 0x30,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x50, 0x8e, 0x33, 0x33, 0x10,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x55, 0x55, 0x50,
    0x8f, 0xff, 0xff, 0xf0,

    /* U+00CA "Ê" */
    0x0, 0x38, 0x50, 0x0, 0x2, 0xfb, 0xf5, 0x0,
    0x1e, 0x70, 0x4e, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xa0, 0x8e, 0x55, 0x55, 0x30,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x50, 0x8e, 0x33, 0x33, 0x10,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x55, 0x55, 0x50,
    0x8f, 0xff, 0xff, 0xf0,

    /* U+00CB "Ë" */
    0x7, 0xf0, 0xac, 0x0, 0x4, 0x90, 0x67, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xa0,
    0x8e, 0x55, 0x55, 0x30, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0x50,
    0x8e, 0x33, 0x33, 0x10, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x55, 0x55, 0x50, 0x8f, 0xff, 0xff, 0xf0,

    /* U+00CC "Ì" */
    0x48, 0x20, 0xc, 0xc0, 0x0, 0xb8, 0x0, 0x0,
    0x0, 0x8e, 0x0, 0x8e, 0x0, 0x8e, 0x0, 0x8e,
    0x0, 0x8e, 0x0, 0x8e, 0x0, 0x8e, 0x0, 0x8e,
    0x0, 0x8e, 0x0, 0x8e, 0x0, 0x8e,

    /* U+00CD "Í" */
    0x0, 0x77, 0x0, 0x7f, 0x30, 0x3e, 0x30, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e,
    0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0,
    0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0,
    0x8, 0xe0, 0x0, 0x8e, 0x0, 0x0,

    /* U+00CE "Î" */
    0x0, 0x68, 0x10, 0x5, 0xfc, 0xb0, 0x1e, 0x40,
    0xc6, 0x0, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x8e, 0x0,

    /* U+00CF "Ï" */
    0xe, 0x82, 0xf5, 0x9, 0x41, 0x92, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8e, 0x0,

    /* U+00D0 "Ð" */
    0x3, 0xff, 0xff, 0xea, 0x30, 0x0, 0x3f, 0x74,
    0x57, 0xef, 0x40, 0x3, 0xf3, 0x0, 0x1, 0xdd,
    0x0, 0x3f, 0x40, 0x0, 0x6, 0xf2, 0x7f, 0xff,
    0xfe, 0x0, 0x3f, 0x41, 0x6f, 0x63, 0x30, 0x2,
    0xf5, 0x3, 0xf3, 0x0, 0x0, 0x3f, 0x40, 0x3f,
    0x30, 0x0, 0x6, 0xf2, 0x3, 0xf3, 0x0, 0x1,
    0xec, 0x0, 0x3f, 0x74, 0x58, 0xff, 0x30, 0x3,
    0xff, 0xff, 0xd9, 0x20, 0x0,

    /* U+00D1 "Ñ" */
    0x0, 0x7e, 0xb2, 0x4c, 0x0, 0x0, 0xf4, 0x9f,
    0xf6, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0, 0x8f,
    0xe1, 0x0, 0x2, 0xf5, 0x8e, 0xe9, 0x0, 0x2,
    0xf5, 0x8e, 0x5f, 0x20, 0x2, 0xf5, 0x8e, 0xc,
    0xa0, 0x2, 0xf5, 0x8e, 0x3, 0xf3, 0x2, 0xf5,
    0x8e, 0x0, 0xac, 0x2, 0xf5, 0x8e, 0x0, 0x2f,
    0x52, 0xf5, 0x8e, 0x0, 0x8, 0xd2, 0xf5, 0x8e,
    0x0, 0x1, 0xe8, 0xf5, 0x8e, 0x0, 0x0, 0x6f,
    0xf5, 0x8e, 0x0, 0x0, 0xd, 0xf5,

    /* U+00D2 "Ò" */
    0x0, 0x67, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x63, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9d, 0xff, 0xd8,
    0x0, 0xd, 0xe7, 0x44, 0x8f, 0xb0, 0x6f, 0x30,
    0x0, 0x5, 0xf4, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0xda, 0x0, 0x0,
    0x0, 0xcb, 0xcb, 0x0, 0x0, 0x0, 0xda, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0x6f, 0x30, 0x0, 0x4,
    0xf4, 0xd, 0xe7, 0x44, 0x8f, 0xb0, 0x1, 0x9d,
    0xff, 0xd8, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x0, 0x1, 0x75, 0x0, 0x0, 0x0, 0x1d,
    0xa0, 0x0, 0x0, 0x0, 0x45, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9d, 0xff, 0xd8,
    0x0, 0xd, 0xe7, 0x44, 0x8f, 0xb0, 0x6f, 0x30,
    0x0, 0x5, 0xf4, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0xda, 0x0, 0x0,
    0x0, 0xcb, 0xcb, 0x0, 0x0, 0x0, 0xda, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0x6f, 0x30, 0x0, 0x4,
    0xf4, 0xd, 0xe7, 0x44, 0x8f, 0xb0, 0x1, 0x9d,
    0xff, 0xd8, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x5, 0xff, 0x40, 0x0, 0x0, 0x4f, 0x67,
    0xe2, 0x0, 0x0, 0x63, 0x0, 0x46, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9d, 0xff, 0xd8,
    0x0, 0xd, 0xe7, 0x44, 0x8f, 0xb0, 0x6f, 0x30,
    0x0, 0x5, 0xf4, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0xda, 0x0, 0x0,
    0x0, 0xcb, 0xcb, 0x0, 0x0, 0x0, 0xda, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0x6f, 0x30, 0x0, 0x4,
    0xf4, 0xd, 0xe7, 0x44, 0x8f, 0xb0, 0x1, 0x9d,
    0xff, 0xd8, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0xaf, 0xff, 0xfb, 0x0, 0x0, 0x22, 0x22,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x9d, 0xff, 0xd8, 0x0, 0xd, 0xe7, 0x44, 0x8f,
    0xb0, 0x6f, 0x30, 0x0, 0x5, 0xf4, 0xad, 0x0,
    0x0, 0x0, 0xf8, 0xcb, 0x0, 0x0, 0x0, 0xda,
    0xda, 0x0, 0x0, 0x0, 0xcb, 0xcb, 0x0, 0x0,
    0x0, 0xda, 0xad, 0x0, 0x0, 0x0, 0xf8, 0x6f,
    0x30, 0x0, 0x4, 0xf4, 0xd, 0xe7, 0x44, 0x8f,
    0xb0, 0x1, 0x9d, 0xff, 0xd8, 0x0,

    /* U+00D6 "Ö" */
    0x0, 0x5f, 0x23, 0xf3, 0x0, 0x0, 0x39, 0x12,
    0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x9d, 0xff, 0xd8, 0x0, 0xd, 0xe7, 0x44, 0x8f,
    0xb0, 0x6f, 0x30, 0x0, 0x5, 0xf4, 0xad, 0x0,
    0x0, 0x0, 0xf8, 0xcb, 0x0, 0x0, 0x0, 0xda,
    0xda, 0x0, 0x0, 0x0, 0xcb, 0xcb, 0x0, 0x0,
    0x0, 0xda, 0xad, 0x0, 0x0, 0x0, 0xf8, 0x6f,
    0x30, 0x0, 0x4, 0xf4, 0xd, 0xe7, 0x44, 0x8f,
    0xb0, 0x1, 0x9d, 0xff, 0xd8, 0x0,

    /* U+00D7 "×" */
    0x7, 0x0, 0x0, 0x26, 0x1, 0xec, 0x0, 0x1d,
    0xc0, 0x2, 0xec, 0x2d, 0xc1, 0x0, 0x2, 0xef,
    0xd1, 0x0, 0x0, 0x1d, 0xfb, 0x0, 0x0, 0x1d,
    0xd4, 0xeb, 0x0, 0x1c, 0xd1, 0x3, 0xeb, 0x0,
    0xa1, 0x0, 0x3, 0x90,

    /* U+00D8 "Ø" */
    0x1, 0x9d, 0xff, 0xd8, 0xe5, 0xd, 0xe7, 0x45,
    0x8f, 0xe0, 0x6f, 0x30, 0x0, 0x6f, 0xf5, 0xad,
    0x0, 0x3, 0xf4, 0xe9, 0xcb, 0x0, 0x1d, 0x70,
    0xca, 0xda, 0x0, 0xba, 0x0, 0xcb, 0xca, 0x8,
    0xd0, 0x0, 0xca, 0xac, 0x4f, 0x20, 0x0, 0xe8,
    0x6f, 0xe5, 0x0, 0x4, 0xf3, 0xf, 0xf7, 0x44,
    0x7f, 0xb0, 0x8d, 0x8d, 0xff, 0xd8, 0x0,

    /* U+00D9 "Ù" */
    0x1, 0x75, 0x0, 0x0, 0x0, 0x3, 0xe6, 0x0,
    0x0, 0x0, 0x1, 0x71, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0,
    0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9,
    0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9,
    0xd9, 0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0,
    0x9, 0xd9, 0xe0, 0x0, 0x0, 0xac, 0x7f, 0x10,
    0x0, 0xd, 0xa1, 0xfd, 0x64, 0x5b, 0xf4, 0x3,
    0xbe, 0xff, 0xb4, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x0, 0x4, 0x72, 0x0, 0x0, 0x4, 0xe6,
    0x0, 0x0, 0x0, 0x73, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0,
    0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9,
    0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9,
    0xd9, 0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0,
    0x9, 0xd9, 0xe0, 0x0, 0x0, 0xac, 0x7f, 0x10,
    0x0, 0xd, 0xa1, 0xfd, 0x64, 0x5b, 0xf4, 0x3,
    0xbe, 0xff, 0xb4, 0x0,

    /* U+00DB "Û" */
    0x0, 0xb, 0xfd, 0x10, 0x0, 0x8, 0xd3, 0xbc,
    0x0, 0x1, 0x71, 0x0, 0x73, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0,
    0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9,
    0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9,
    0xd9, 0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0,
    0x9, 0xd9, 0xe0, 0x0, 0x0, 0xac, 0x7f, 0x10,
    0x0, 0xd, 0xa1, 0xfd, 0x64, 0x5b, 0xf4, 0x3,
    0xbe, 0xff, 0xb4, 0x0,

    /* U+00DC "Ü" */
    0x0, 0xac, 0x8, 0xe0, 0x0, 0x6, 0x70, 0x58,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xd0, 0x0,
    0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9, 0xd0,
    0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9, 0xd9,
    0xd0, 0x0, 0x0, 0x9d, 0x9d, 0x0, 0x0, 0x9,
    0xd9, 0xd0, 0x0, 0x0, 0x9d, 0x9e, 0x0, 0x0,
    0xa, 0xc7, 0xf1, 0x0, 0x0, 0xda, 0x1f, 0xd6,
    0x45, 0xbf, 0x40, 0x3b, 0xef, 0xfb, 0x40,

    /* U+00DD "Ý" */
    0x0, 0x0, 0x2, 0x84, 0x0, 0x0, 0x0, 0xd,
    0xb0, 0x0, 0x0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x10, 0x0, 0x7,
    0xf2, 0x1e, 0xa0, 0x0, 0x1f, 0x70, 0x5, 0xf4,
    0x0, 0xac, 0x0, 0x0, 0xbd, 0x4, 0xf3, 0x0,
    0x0, 0x2f, 0x7d, 0x90, 0x0, 0x0, 0x7, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x0,

    /* U+00DE "Þ" */
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xfc, 0x50, 0x8e, 0x44, 0x5b, 0xf4,
    0x8e, 0x0, 0x0, 0xf9, 0x8e, 0x0, 0x0, 0xe8,
    0x8e, 0x0, 0x17, 0xf4, 0x8f, 0xff, 0xff, 0x80,
    0x8e, 0x33, 0x20, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0,

    /* U+00DF "ß" */
    0x3, 0xbe, 0xec, 0x30, 0x1f, 0xa3, 0x3a, 0xe0,
    0x6f, 0x0, 0x1, 0xf3, 0x8d, 0x0, 0x1, 0xf3,
    0x8d, 0x0, 0x1a, 0xc0, 0x8d, 0x3f, 0xfd, 0x20,
    0x8d, 0x2, 0x4a, 0xf3, 0x8d, 0x0, 0x0, 0xca,
    0x8d, 0x0, 0x0, 0x9c, 0x8d, 0x0, 0x0, 0xba,
    0x8d, 0x1, 0x17, 0xf5, 0x8d, 0x5f, 0xfd, 0x60,

    /* U+00E0 "à" */
    0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0xb, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+00E1 "á" */
    0x0, 0x0, 0x9, 0xe2, 0x0, 0x0, 0x3, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+00E2 "â" */
    0x0, 0x2, 0xff, 0x70, 0x0, 0x1, 0xd6, 0x2d,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+00E3 "ã" */
    0x0, 0x1d, 0xd4, 0x5b, 0x0, 0x7, 0xb5, 0xef,
    0x50, 0x0, 0x0, 0x0, 0x10, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+00E4 "ä" */
    0x0, 0xe, 0x72, 0xf4, 0x0, 0x0, 0x94, 0x1a,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+00E5 "å" */
    0x0, 0x2, 0xde, 0x60, 0x0, 0x0, 0x7a, 0x4c,
    0x0, 0x0, 0x1, 0xcd, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0,
    0x53, 0x4c, 0xf1, 0x0, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0x1, 0xf5, 0x2, 0xae, 0xff, 0xff,
    0x50, 0xdc, 0x42, 0x23, 0xf5, 0x1f, 0x50, 0x0,
    0x2f, 0x50, 0xea, 0x11, 0x4c, 0xf5, 0x3, 0xcf,
    0xfb, 0x3e, 0x50,

    /* U+00E6 "æ" */
    0x0, 0x1e, 0xff, 0xb2, 0x8e, 0xfe, 0x70, 0x0,
    0x5, 0x34, 0xdf, 0xe6, 0x36, 0xf5, 0x0, 0x0,
    0x0, 0x5f, 0x70, 0x0, 0xab, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x7d, 0x2, 0xae, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0xd, 0xb4, 0x22, 0x5f, 0x52,
    0x22, 0x22, 0x1f, 0x50, 0x0, 0x5f, 0x60, 0x0,
    0x0, 0xe, 0xc4, 0x48, 0xeb, 0xe7, 0x44, 0x74,
    0x3, 0xcf, 0xeb, 0x20, 0x8e, 0xfe, 0xc3,

    /* U+00E7 "ç" */
    0x0, 0x6d, 0xff, 0xd2, 0x6, 0xf8, 0x44, 0x61,
    0xc, 0xb0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0x0, 0x6, 0xf7, 0x33, 0x51,
    0x0, 0x6d, 0xff, 0xe2, 0x0, 0x2, 0xe6, 0x0,
    0x0, 0x2, 0x5f, 0x70, 0x0, 0xb, 0xcc, 0x20,

    /* U+00E8 "è" */
    0x0, 0x4f, 0x50, 0x0, 0x0, 0x0, 0x5e, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfb, 0x20, 0x6, 0xf7, 0x33, 0xcc, 0x0, 0xda,
    0x0, 0x2, 0xf2, 0xf, 0x71, 0x23, 0x5f, 0x40,
    0xfe, 0xdd, 0xdd, 0xd3, 0xf, 0x70, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x54,
    0x69, 0x0, 0x6, 0xdf, 0xfd, 0x80,

    /* U+00E9 "é" */
    0x0, 0x0, 0x2f, 0x70, 0x0, 0x0, 0xc, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfb, 0x20, 0x6, 0xf7, 0x33, 0xcc, 0x0, 0xda,
    0x0, 0x2, 0xf2, 0xf, 0x71, 0x23, 0x5f, 0x40,
    0xfe, 0xdd, 0xdd, 0xd3, 0xf, 0x70, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x54,
    0x69, 0x0, 0x6, 0xdf, 0xfd, 0x80,

    /* U+00EA "ê" */
    0x0, 0xa, 0xfd, 0x0, 0x0, 0x7, 0xc1, 0x9b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfb, 0x20, 0x6, 0xf7, 0x33, 0xcc, 0x0, 0xda,
    0x0, 0x2, 0xf2, 0xf, 0x71, 0x23, 0x5f, 0x40,
    0xfe, 0xdd, 0xdd, 0xd3, 0xf, 0x70, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x54,
    0x69, 0x0, 0x6, 0xdf, 0xfd, 0x80,

    /* U+00EB "ë" */
    0x0, 0x7e, 0xb, 0xb0, 0x0, 0x4, 0x90, 0x67,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfb, 0x20, 0x6, 0xf7, 0x33, 0xcc, 0x0, 0xda,
    0x0, 0x2, 0xf2, 0xf, 0x71, 0x23, 0x5f, 0x40,
    0xfe, 0xdd, 0xdd, 0xd3, 0xf, 0x70, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x54,
    0x69, 0x0, 0x6, 0xdf, 0xfd, 0x80,

    /* U+00EC "ì" */
    0xa, 0xd0, 0x0, 0xa8, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d,
    0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d,

    /* U+00ED "í" */
    0x9, 0xe2, 0x4d, 0x10, 0x0, 0x0, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0,

    /* U+00EE "î" */
    0x3, 0xfe, 0x70, 0x1d, 0x52, 0xc4, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8d, 0x0,

    /* U+00EF "ï" */
    0xe, 0x73, 0xf4, 0x9, 0x41, 0xa2, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8d, 0x0,

    /* U+00F0 "ð" */
    0x0, 0x3, 0xea, 0xaa, 0x0, 0x0, 0x8e, 0xfd,
    0x0, 0x0, 0x5, 0x22, 0xe6, 0x0, 0x5, 0xce,
    0xee, 0xe0, 0x6, 0xf8, 0x33, 0x9f, 0x60, 0xda,
    0x0, 0x0, 0xdb, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+00F1 "ñ" */
    0x3, 0xec, 0x38, 0x80, 0xa, 0x87, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x8d, 0x6d, 0xfd, 0x70,
    0x8f, 0xb3, 0x27, 0xf3, 0x8f, 0x10, 0x0, 0xf7,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,
    0x8d, 0x0, 0x0, 0xe8, 0x8d, 0x0, 0x0, 0xe8,

    /* U+00F2 "ò" */
    0x0, 0x1d, 0xa0, 0x0, 0x0, 0x0, 0x1d, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+00F3 "ó" */
    0x0, 0x0, 0xc, 0xc0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+00F4 "ô" */
    0x0, 0x5, 0xff, 0x30, 0x0, 0x3, 0xe3, 0x4d,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+00F5 "õ" */
    0x0, 0x3e, 0xc3, 0x98, 0x0, 0xa, 0x88, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+00F6 "ö" */
    0x0, 0x3f, 0x46, 0xf1, 0x0, 0x1, 0xa2, 0x39,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+00F7 "÷" */
    0x0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0x6f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x11,
    0x11, 0x10, 0x7f, 0xff, 0xff, 0xff, 0x41, 0x44,
    0x44, 0x44, 0x41, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x40, 0x0, 0x0, 0x6, 0xf3, 0x0,
    0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x0, 0x3, 0x60, 0x6, 0xdf, 0xfc,
    0xd4, 0x6, 0xf7, 0x33, 0xdf, 0x40, 0xca, 0x0,
    0x4d, 0xda, 0xf, 0x70, 0x1e, 0x39, 0xd0, 0xf6,
    0xa, 0x80, 0x8e, 0xf, 0x75, 0xd0, 0x9, 0xd0,
    0xcc, 0xe2, 0x0, 0xca, 0x6, 0xfb, 0x33, 0x8f,
    0x40, 0x6d, 0xdf, 0xfc, 0x50, 0x7, 0x20, 0x0,
    0x0, 0x0,

    /* U+00F9 "ù" */
    0x1, 0xda, 0x0, 0x0, 0x0, 0x1d, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x8d, 0x0, 0x3, 0xf5,
    0x5f, 0x51, 0x4c, 0xf5, 0x8, 0xef, 0xd5, 0xe5,

    /* U+00FA "ú" */
    0x0, 0x0, 0xdb, 0x0, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x8d, 0x0, 0x3, 0xf5,
    0x5f, 0x51, 0x4c, 0xf5, 0x8, 0xef, 0xd5, 0xe5,

    /* U+00FB "û" */
    0x0, 0x6f, 0xf3, 0x0, 0x3, 0xd2, 0x4d, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x8d, 0x0, 0x3, 0xf5,
    0x5f, 0x51, 0x4c, 0xf5, 0x8, 0xef, 0xd5, 0xe5,

    /* U+00FC "ü" */
    0x3, 0xf4, 0x6f, 0x10, 0x1, 0xa2, 0x39, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x8d, 0x0, 0x3, 0xf5,
    0x5f, 0x51, 0x4c, 0xf5, 0x8, 0xef, 0xd5, 0xe5,

    /* U+00FD "ý" */
    0x0, 0x0, 0x8e, 0x20, 0x0, 0x0, 0x3d, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x4, 0xf1, 0x4f, 0x20, 0x0, 0xab, 0x0, 0xd8,
    0x0, 0xf, 0x50, 0x7, 0xe0, 0x5, 0xf0, 0x0,
    0x1f, 0x40, 0xa9, 0x0, 0x0, 0xaa, 0xf, 0x40,
    0x0, 0x4, 0xf6, 0xe0, 0x0, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x49, 0xf3, 0x0, 0x0, 0xe,
    0xc4, 0x0, 0x0, 0x0,

    /* U+00FE "þ" */
    0x8d, 0x0, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x0, 0x8, 0xd4, 0xdf,
    0xe9, 0x0, 0x8e, 0xc5, 0x36, 0xf9, 0x8, 0xf2,
    0x0, 0x8, 0xf0, 0x8d, 0x0, 0x0, 0x5f, 0x28,
    0xc0, 0x0, 0x4, 0xf2, 0x8d, 0x0, 0x0, 0x5f,
    0x18, 0xf2, 0x0, 0x8, 0xe0, 0x8e, 0xd5, 0x37,
    0xf8, 0x8, 0xd4, 0xdf, 0xe9, 0x0, 0x8d, 0x0,
    0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x0, 0x0,

    /* U+00FF "ÿ" */
    0x0, 0xe8, 0x2f, 0x50, 0x0, 0x8, 0x51, 0x93,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x4, 0xf1, 0x4f, 0x20, 0x0, 0xab, 0x0, 0xd8,
    0x0, 0xf, 0x50, 0x7, 0xe0, 0x5, 0xf0, 0x0,
    0x1f, 0x40, 0xa9, 0x0, 0x0, 0xaa, 0xf, 0x40,
    0x0, 0x4, 0xf6, 0xe0, 0x0, 0x0, 0xd, 0xf8,
    0x0, 0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x49, 0xf3, 0x0, 0x0, 0xe,
    0xc4, 0x0, 0x0, 0x0,

    /* U+0103 "ă" */
    0x0, 0x3f, 0x20, 0xc8, 0x0, 0x0, 0x8f, 0xfc,
    0x10, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+0105 "ą" */
    0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0, 0x43, 0x39,
    0xf1, 0x0, 0x0, 0x0, 0x1f, 0x40, 0x19, 0xdf,
    0xff, 0xf5, 0xb, 0xd4, 0x22, 0x3f, 0x50, 0xf6,
    0x0, 0x1, 0xf5, 0x1f, 0x50, 0x0, 0x7f, 0x50,
    0xdc, 0x33, 0x8d, 0xf5, 0x2, 0xbf, 0xea, 0x1e,
    0x40, 0x0, 0x0, 0xa, 0x70, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x0, 0xa, 0xfa,

    /* U+0107 "ć" */
    0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0xd5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xd2,
    0x6, 0xf8, 0x44, 0x61, 0xc, 0xb0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0xc, 0xb0, 0x0, 0x0,
    0x6, 0xf8, 0x44, 0x62, 0x0, 0x6d, 0xff, 0xd2,

    /* U+010C "Č" */
    0x2, 0xe6, 0x5, 0xe2, 0x0, 0x3f, 0xbf, 0x40,
    0x0, 0x4, 0x84, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6c, 0xef, 0xe9, 0xa, 0xfa, 0x65, 0x66,
    0x4f, 0x60, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0xc, 0xf9, 0x55, 0x68,
    0x0, 0x8d, 0xff, 0xe9,

    /* U+010D "č" */
    0x0, 0xa9, 0xa, 0x90, 0x0, 0xd, 0xec, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xd2,
    0x6, 0xf8, 0x44, 0x61, 0xc, 0xb0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0xc, 0xb0, 0x0, 0x0,
    0x6, 0xf8, 0x44, 0x62, 0x0, 0x6d, 0xff, 0xd2,

    /* U+010F "ď" */
    0x0, 0x0, 0x0, 0xa, 0xb8, 0xb0, 0x0, 0x0,
    0x0, 0xab, 0x89, 0x0, 0x0, 0x0, 0xa, 0xb2,
    0x10, 0x7, 0xdf, 0xe6, 0xab, 0x0, 0x5, 0xf8,
    0x34, 0xcd, 0xb0, 0x0, 0xcb, 0x0, 0x0, 0xfb,
    0x0, 0xf, 0x80, 0x0, 0xb, 0xb0, 0x0, 0xf7,
    0x0, 0x0, 0xab, 0x0, 0xf, 0x70, 0x0, 0xb,
    0xb0, 0x0, 0xda, 0x0, 0x0, 0xeb, 0x0, 0x7,
    0xf5, 0x12, 0xae, 0xb0, 0x0, 0x8, 0xef, 0xe7,
    0x8b, 0x0,

    /* U+0110 "Đ" */
    0x3, 0xff, 0xff, 0xea, 0x30, 0x0, 0x3f, 0x74,
    0x57, 0xef, 0x40, 0x3, 0xf3, 0x0, 0x1, 0xdd,
    0x0, 0x3f, 0x40, 0x0, 0x6, 0xf2, 0x7f, 0xff,
    0xfe, 0x0, 0x3f, 0x41, 0x6f, 0x63, 0x30, 0x2,
    0xf5, 0x3, 0xf3, 0x0, 0x0, 0x3f, 0x40, 0x3f,
    0x30, 0x0, 0x6, 0xf2, 0x3, 0xf3, 0x0, 0x1,
    0xec, 0x0, 0x3f, 0x74, 0x58, 0xff, 0x30, 0x3,
    0xff, 0xff, 0xd9, 0x20, 0x0,

    /* U+0111 "đ" */
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x7f,
    0xff, 0xfe, 0x0, 0x0, 0x2, 0x2b, 0xc1, 0x0,
    0x7d, 0xfe, 0x6a, 0xb0, 0x5, 0xf8, 0x34, 0xcd,
    0xb0, 0xc, 0xb0, 0x0, 0xf, 0xb0, 0xf, 0x80,
    0x0, 0xb, 0xb0, 0xf, 0x70, 0x0, 0xa, 0xb0,
    0xf, 0x70, 0x0, 0xb, 0xb0, 0xd, 0xa0, 0x0,
    0xe, 0xb0, 0x7, 0xf5, 0x12, 0xae, 0xb0, 0x0,
    0x8e, 0xfe, 0x78, 0xb0,

    /* U+0119 "ę" */
    0x0, 0x6d, 0xff, 0xb2, 0x0, 0x6f, 0x73, 0x3c,
    0xc0, 0xd, 0xa0, 0x0, 0x2f, 0x20, 0xf7, 0x12,
    0x35, 0xf4, 0xf, 0xed, 0xdd, 0xdd, 0x30, 0xf7,
    0x0, 0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x0,
    0x6f, 0x94, 0x46, 0x80, 0x0, 0x6d, 0xff, 0xf9,
    0x0, 0x0, 0x0, 0xa7, 0x0, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x0, 0x9e, 0xb0,

    /* U+011B "ě" */
    0x0, 0x8b, 0x8, 0xb0, 0x0, 0x0, 0xbe, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfb, 0x20, 0x6, 0xf7, 0x33, 0xcc, 0x0, 0xda,
    0x0, 0x2, 0xf2, 0xf, 0x71, 0x23, 0x5f, 0x40,
    0xfe, 0xdd, 0xdd, 0xd3, 0xf, 0x70, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x54,
    0x69, 0x0, 0x6, 0xdf, 0xfd, 0x80,

    /* U+011F "ğ" */
    0x0, 0xc8, 0x6, 0xe0, 0x0, 0x3, 0xef, 0xf5,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x7, 0xdf,
    0xd6, 0xab, 0x5, 0xf8, 0x34, 0xcd, 0xb0, 0xcb,
    0x0, 0x0, 0xfb, 0xf, 0x70, 0x0, 0xb, 0xb0,
    0xf7, 0x0, 0x0, 0xab, 0xf, 0x70, 0x0, 0xb,
    0xb0, 0xdb, 0x0, 0x0, 0xeb, 0x7, 0xf8, 0x34,
    0xbe, 0xb0, 0x8, 0xef, 0xe7, 0xbb, 0x0, 0x0,
    0x0, 0xe, 0x80, 0x3, 0x43, 0x5c, 0xe1, 0x0,
    0x7e, 0xfe, 0xa2, 0x0,

    /* U+0131 "ı" */
    0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d,
    0x8d,

    /* U+013E "ľ" */
    0x8d, 0x7b, 0x8d, 0x7a, 0x8d, 0x32, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8e, 0x31, 0x2d, 0xf4,

    /* U+0141 "Ł" */
    0x0, 0x8e, 0x0, 0x0, 0x0, 0x8, 0xe0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x0, 0x8, 0xe4,
    0xd8, 0x0, 0x0, 0x8f, 0xf8, 0x0, 0x0, 0x9f,
    0xf1, 0x0, 0x0, 0x7, 0xbe, 0x0, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x0, 0x8, 0xe5, 0x55, 0x53, 0x0, 0x8f, 0xff,
    0xff, 0xb0,

    /* U+0142 "ł" */
    0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8d, 0x41, 0x0, 0x8f, 0xe4, 0x0,
    0xaf, 0x20, 0xa, 0xfd, 0x0, 0x5, 0x9d, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8e,
    0x31, 0x0, 0x2d, 0xf4,

    /* U+0151 "ő" */
    0x0, 0x6, 0xf4, 0xcc, 0x0, 0x0, 0xe5, 0x6d,
    0x10, 0x0, 0x13, 0x3, 0x10, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+0159 "ř" */
    0xa, 0x90, 0xa9, 0x0, 0xb, 0xeb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8d, 0x4d, 0xb0, 0x8, 0xec,
    0x41, 0x0, 0x8f, 0x20, 0x0, 0x8, 0xd0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x8d,
    0x0, 0x0,

    /* U+015B "ś" */
    0x0, 0x0, 0xda, 0x0, 0x0, 0x9b, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xe4, 0xa, 0xc3,
    0x24, 0x20, 0xe6, 0x0, 0x0, 0xb, 0xd5, 0x10,
    0x0, 0x18, 0xef, 0xb1, 0x0, 0x0, 0x2d, 0x90,
    0x0, 0x0, 0x9b, 0x5, 0x32, 0x4e, 0x70, 0xdf,
    0xfe, 0x80,

    /* U+015E "Ş" */
    0x0, 0x8d, 0xff, 0xd5, 0x0, 0x9f, 0x75, 0x57,
    0x50, 0xd, 0x90, 0x0, 0x0, 0x0, 0xd9, 0x0,
    0x0, 0x0, 0x7, 0xfa, 0x51, 0x0, 0x0, 0x4,
    0xae, 0xfb, 0x20, 0x0, 0x0, 0x3, 0xcd, 0x0,
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x6f,
    0x11, 0x96, 0x54, 0x7e, 0xb0, 0xb, 0xef, 0xfe,
    0x90, 0x0, 0x0, 0x3f, 0x60, 0x0, 0x0, 0x2,
    0x5f, 0x60, 0x0, 0x0, 0xcc, 0xc2, 0x0,

    /* U+015F "ş" */
    0x1, 0xae, 0xfe, 0x40, 0xac, 0x32, 0x42, 0xe,
    0x60, 0x0, 0x0, 0xbd, 0x51, 0x0, 0x1, 0x8e,
    0xfb, 0x10, 0x0, 0x2, 0xd9, 0x0, 0x0, 0x9,
    0xb0, 0x53, 0x24, 0xe7, 0xd, 0xff, 0xe8, 0x0,
    0x0, 0xd9, 0x10, 0x0, 0x5, 0xda, 0x0, 0x9,
    0xcd, 0x40,

    /* U+0161 "š" */
    0x5, 0xd1, 0x5d, 0x10, 0x8, 0xef, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0xef, 0xe4, 0xa, 0xc3,
    0x24, 0x20, 0xe6, 0x0, 0x0, 0xb, 0xd5, 0x10,
    0x0, 0x18, 0xef, 0xb1, 0x0, 0x0, 0x2d, 0x90,
    0x0, 0x0, 0x9b, 0x5, 0x32, 0x4e, 0x70, 0xdf,
    0xfe, 0x80,

    /* U+0165 "ť" */
    0x0, 0x0, 0xf3, 0x5, 0x90, 0xf1, 0x7, 0xe0,
    0x40, 0xcf, 0xff, 0xf0, 0x29, 0xe3, 0x30, 0x7,
    0xe0, 0x0, 0x7, 0xe0, 0x0, 0x7, 0xe0, 0x0,
    0x7, 0xe0, 0x0, 0x7, 0xe0, 0x0, 0x5, 0xf5,
    0x30, 0x0, 0xbf, 0xf1,

    /* U+016F "ů" */
    0x0, 0x5e, 0xd3, 0x0, 0x0, 0xb5, 0x88, 0x0,
    0x0, 0x4d, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x8d, 0x0, 0x3, 0xf5, 0x5f, 0x51, 0x4c, 0xf5,
    0x8, 0xef, 0xd5, 0xe5,

    /* U+017A "ź" */
    0x0, 0x0, 0xbd, 0x10, 0x0, 0x5, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xf4,
    0x3, 0x33, 0x3c, 0xe1, 0x0, 0x0, 0x6f, 0x30,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0x9e, 0x10, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x1e, 0xb4, 0x44, 0x42, 0x4f, 0xff, 0xff, 0xf8,

    /* U+017C "ż" */
    0x0, 0xa, 0xc0, 0x0, 0x0, 0x6, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xf4,
    0x3, 0x33, 0x3c, 0xe1, 0x0, 0x0, 0x6f, 0x30,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0x9e, 0x10, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x1e, 0xb4, 0x44, 0x42, 0x4f, 0xff, 0xff, 0xf8,

    /* U+017E "ž" */
    0x2, 0xd4, 0x3d, 0x30, 0x0, 0x3e, 0xe4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xf4,
    0x3, 0x33, 0x3c, 0xe1, 0x0, 0x0, 0x6f, 0x30,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0xd, 0xb0, 0x0,
    0x0, 0x9e, 0x10, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x1e, 0xb4, 0x44, 0x42, 0x4f, 0xff, 0xff, 0xf8,

    /* U+01B0 "ư" */
    0x0, 0x0, 0x0, 0x0, 0x28, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf0, 0x9c, 0x0, 0x0, 0xf5, 0x7f,
    0x9, 0xc0, 0x0, 0xf, 0xff, 0x80, 0x9c, 0x0,
    0x0, 0xf5, 0x0, 0x9, 0xc0, 0x0, 0xf, 0x50,
    0x0, 0x9c, 0x0, 0x0, 0xf5, 0x0, 0x9, 0xc0,
    0x0, 0xf, 0x50, 0x0, 0x8d, 0x0, 0x3, 0xf5,
    0x0, 0x5, 0xf5, 0x13, 0xcf, 0x50, 0x0, 0x8,
    0xef, 0xd5, 0xe5, 0x0, 0x0,

    /* U+0219 "ș" */
    0x1, 0xae, 0xfe, 0x40, 0xac, 0x32, 0x42, 0xe,
    0x60, 0x0, 0x0, 0xbd, 0x51, 0x0, 0x1, 0x8e,
    0xfb, 0x10, 0x0, 0x2, 0xd9, 0x0, 0x0, 0x9,
    0xb0, 0x53, 0x24, 0xe7, 0xd, 0xff, 0xe8, 0x0,
    0x0, 0x33, 0x0, 0x0, 0xd, 0x90, 0x0, 0x2,
    0xe1, 0x0,

    /* U+021B "ț" */
    0x7, 0xe0, 0x0, 0x7, 0xe0, 0x0, 0xcf, 0xff,
    0xf0, 0x29, 0xe3, 0x30, 0x7, 0xe0, 0x0, 0x7,
    0xe0, 0x0, 0x7, 0xe0, 0x0, 0x7, 0xe0, 0x0,
    0x7, 0xe0, 0x0, 0x5, 0xf5, 0x30, 0x0, 0xbf,
    0xf1, 0x0, 0x14, 0x10, 0x0, 0x5f, 0x10, 0x0,
    0xa7, 0x0,

    /* U+0388 "Έ" */
    0xe, 0x96, 0xff, 0xff, 0xfc, 0x2, 0xf1, 0x6f,
    0x55, 0x55, 0x30, 0x13, 0x6, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x10, 0x0, 0x0, 0x0, 0x6,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x6f, 0x43, 0x33,
    0x10, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x10, 0x0, 0x0, 0x0, 0x6, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x55, 0x55, 0x51, 0x0,
    0x6, 0xff, 0xff, 0xff, 0x30,

    /* U+0391 "Α" */
    0x0, 0x0, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f,
    0xbd, 0x0, 0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0,
    0x0, 0x0, 0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e,
    0x0, 0x4f, 0x0, 0x0, 0xb, 0x91, 0x11, 0xe6,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c,
    0x44, 0x44, 0x5f, 0x20, 0xd, 0x70, 0x0, 0x0,
    0xd8, 0x4, 0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac,
    0x0, 0x0, 0x0, 0x3f, 0x40,

    /* U+0392 "Β" */
    0x8f, 0xff, 0xfc, 0x40, 0x8e, 0x44, 0x5b, 0xf1,
    0x8e, 0x0, 0x1, 0xf5, 0x8e, 0x0, 0x1, 0xf5,
    0x8e, 0x0, 0x19, 0xe1, 0x8f, 0xff, 0xff, 0x50,
    0x8e, 0x22, 0x38, 0xf5, 0x8e, 0x0, 0x0, 0xbb,
    0x8e, 0x0, 0x0, 0xca, 0x8e, 0x44, 0x58, 0xf6,
    0x8f, 0xff, 0xfd, 0x70,

    /* U+0393 "Γ" */
    0x8f, 0xff, 0xff, 0xb8, 0xe5, 0x55, 0x53, 0x8e,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8,
    0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,

    /* U+0395 "Ε" */
    0x8f, 0xff, 0xff, 0xa0, 0x8e, 0x55, 0x55, 0x30,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0x50, 0x8e, 0x33, 0x33, 0x10,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x55, 0x55, 0x50,
    0x8f, 0xff, 0xff, 0xf0,

    /* U+0397 "Η" */
    0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0, 0x0,
    0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0,
    0x0, 0x9d, 0x8f, 0xff, 0xff, 0xff, 0xd8, 0xe3,
    0x33, 0x33, 0xad, 0x8e, 0x0, 0x0, 0x9, 0xd8,
    0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9,
    0xd8, 0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0,
    0x9, 0xd0,

    /* U+039B "Λ" */
    0x0, 0x1, 0xff, 0x0, 0x0, 0x0, 0x7, 0xef,
    0x50, 0x0, 0x0, 0xc, 0x8b, 0xb0, 0x0, 0x0,
    0x2f, 0x36, 0xf1, 0x0, 0x0, 0x7d, 0x1, 0xf6,
    0x0, 0x0, 0xd8, 0x0, 0xbb, 0x0, 0x3, 0xf3,
    0x0, 0x6f, 0x10, 0x8, 0xd0, 0x0, 0x1f, 0x60,
    0xe, 0x80, 0x0, 0xb, 0xc0, 0x3f, 0x30, 0x0,
    0x6, 0xf1, 0x9d, 0x0, 0x0, 0x1, 0xf7,

    /* U+039C "Μ" */
    0x8f, 0xf0, 0x0, 0x0, 0xaf, 0xd8, 0xef, 0x60,
    0x0, 0x1f, 0xdd, 0x8e, 0x9c, 0x0, 0x7, 0xda,
    0xd8, 0xe3, 0xf2, 0x0, 0xd6, 0xad, 0x8e, 0xc,
    0x90, 0x4f, 0x1a, 0xd8, 0xe0, 0x6e, 0xa, 0xa0,
    0xad, 0x8e, 0x0, 0xe7, 0xf3, 0xa, 0xd8, 0xe0,
    0x8, 0xfd, 0x0, 0xad, 0x8e, 0x0, 0x28, 0x40,
    0xa, 0xd8, 0xe0, 0x0, 0x0, 0x0, 0xad, 0x8e,
    0x0, 0x0, 0x0, 0xa, 0xd0,

    /* U+039D "Ν" */
    0x8f, 0xe1, 0x0, 0x2, 0xf5, 0x8e, 0xe9, 0x0,
    0x2, 0xf5, 0x8e, 0x5f, 0x20, 0x2, 0xf5, 0x8e,
    0xc, 0xa0, 0x2, 0xf5, 0x8e, 0x3, 0xf3, 0x2,
    0xf5, 0x8e, 0x0, 0xac, 0x2, 0xf5, 0x8e, 0x0,
    0x2f, 0x52, 0xf5, 0x8e, 0x0, 0x8, 0xd2, 0xf5,
    0x8e, 0x0, 0x1, 0xe8, 0xf5, 0x8e, 0x0, 0x0,
    0x6f, 0xf5, 0x8e, 0x0, 0x0, 0xd, 0xf5,

    /* U+039F "Ο" */
    0x1, 0x9d, 0xff, 0xd8, 0x0, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x6f, 0x30, 0x0, 0x5, 0xf4, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0xcb, 0x0, 0x0, 0x0,
    0xda, 0xda, 0x0, 0x0, 0x0, 0xcb, 0xcb, 0x0,
    0x0, 0x0, 0xda, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0x6f, 0x30, 0x0, 0x4, 0xf4, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x1, 0x9d, 0xff, 0xd8, 0x0,

    /* U+03A0 "Π" */
    0x8f, 0xff, 0xff, 0xff, 0xd8, 0xe3, 0x33, 0x33,
    0xbd, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0,
    0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0,
    0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8,
    0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9,
    0xd8, 0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0,
    0x9, 0xd0,

    /* U+03A3 "Σ" */
    0xe, 0xff, 0xff, 0xff, 0x70, 0xbe, 0x55, 0x55,
    0x52, 0x1, 0xe9, 0x0, 0x0, 0x0, 0x3, 0xf6,
    0x0, 0x0, 0x0, 0x6, 0xf3, 0x0, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x9, 0xe1, 0x0, 0x0,
    0x7, 0xf3, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0,
    0x0, 0xec, 0x55, 0x55, 0x54, 0x1f, 0xff, 0xff,
    0xff, 0xd0,

    /* U+03A4 "Τ" */
    0xcf, 0xff, 0xff, 0xff, 0x23, 0x55, 0xaf, 0x55,
    0x50, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0,

    /* U+03A6 "Φ" */
    0x0, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x2,
    0xae, 0xff, 0xfe, 0xb5, 0x0, 0x3, 0xfb, 0x54,
    0xf7, 0x49, 0xf7, 0x0, 0xbd, 0x0, 0x1f, 0x50,
    0x8, 0xf0, 0xf, 0x80, 0x1, 0xf5, 0x0, 0x3f,
    0x40, 0xf7, 0x0, 0x1f, 0x50, 0x2, 0xf5, 0xf,
    0x80, 0x1, 0xf5, 0x0, 0x3f, 0x40, 0xcb, 0x0,
    0x1f, 0x50, 0x7, 0xf1, 0x5, 0xf8, 0x21, 0xf5,
    0x16, 0xf9, 0x0, 0x5, 0xdf, 0xff, 0xff, 0xe8,
    0x0, 0x0, 0x0, 0x13, 0xf7, 0x10, 0x0, 0x0,

    /* U+03A7 "Χ" */
    0x1e, 0xa0, 0x0, 0x6, 0xf2, 0x6, 0xf3, 0x0,
    0x1e, 0x70, 0x0, 0xcc, 0x0, 0xad, 0x0, 0x0,
    0x2f, 0x64, 0xf3, 0x0, 0x0, 0x8, 0xed, 0x80,
    0x0, 0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0xb,
    0xdc, 0xb0, 0x0, 0x0, 0x5f, 0x33, 0xf6, 0x0,
    0x1, 0xe9, 0x0, 0x9e, 0x10, 0xa, 0xe0, 0x0,
    0x1e, 0xa0, 0x4f, 0x40, 0x0, 0x6, 0xf4,

    /* U+03AC "ά" */
    0x0, 0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0,
    0x7d, 0xfc, 0x36, 0xf0, 0x6, 0xf7, 0x38, 0xfa,
    0xc0, 0xc, 0xb0, 0x0, 0xcf, 0x80, 0xf, 0x70,
    0x0, 0x9f, 0x40, 0xf, 0x70, 0x0, 0x7f, 0x0,
    0xf, 0x80, 0x0, 0x6e, 0x0, 0xd, 0xb0, 0x0,
    0x9f, 0x0, 0x7, 0xf8, 0x48, 0xff, 0x71, 0x0,
    0x7e, 0xfd, 0x49, 0xf6,

    /* U+03AD "έ" */
    0x0, 0xf, 0x80, 0x0, 0x3, 0xf1, 0x0, 0x0,
    0x13, 0x0, 0x0, 0x7d, 0xff, 0xc0, 0x6f, 0x74,
    0x47, 0xa, 0xc0, 0x0, 0x0, 0x7f, 0x51, 0x0,
    0x0, 0xbf, 0xff, 0x40, 0x9e, 0x64, 0x30, 0xe,
    0x80, 0x0, 0x0, 0xbe, 0x64, 0x45, 0x41, 0xae,
    0xff, 0xe5,

    /* U+03AE "ή" */
    0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0xf3,
    0x0, 0x0, 0x0, 0x4, 0x0, 0x8, 0xfa, 0x2b,
    0xfe, 0xb1, 0x27, 0xfd, 0x73, 0x5e, 0xa0, 0x2f,
    0x60, 0x0, 0x9d, 0x2, 0xf3, 0x0, 0x7, 0xe0,
    0x2f, 0x30, 0x0, 0x7e, 0x2, 0xf3, 0x0, 0x7,
    0xe0, 0x2f, 0x30, 0x0, 0x7e, 0x2, 0xf3, 0x0,
    0x7, 0xe0, 0x2f, 0x30, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x0, 0x7, 0xe0,

    /* U+03AF "ί" */
    0x1f, 0x60, 0x5e, 0x0, 0x22, 0x0, 0xab, 0x0,
    0xab, 0x0, 0xab, 0x0, 0xab, 0x0, 0xab, 0x0,
    0xab, 0x0, 0x9c, 0x0, 0x8f, 0x43, 0x1c, 0xfe,

    /* U+03B1 "α" */
    0x0, 0x7d, 0xfc, 0x36, 0xf0, 0x6, 0xf7, 0x38,
    0xfa, 0xc0, 0xc, 0xb0, 0x0, 0xcf, 0x80, 0xf,
    0x70, 0x0, 0x9f, 0x40, 0xf, 0x70, 0x0, 0x7f,
    0x0, 0xf, 0x80, 0x0, 0x6e, 0x0, 0xd, 0xb0,
    0x0, 0x9f, 0x0, 0x7, 0xf8, 0x48, 0xff, 0x71,
    0x0, 0x7e, 0xfd, 0x49, 0xf6,

    /* U+03B2 "β" */
    0x3, 0xcf, 0xeb, 0x20, 0x1f, 0x92, 0x3c, 0xc0,
    0x6f, 0x0, 0x5, 0xf0, 0x8d, 0x0, 0x1b, 0xa0,
    0x8d, 0x3f, 0xfd, 0x10, 0x8d, 0x2, 0x4b, 0xe2,
    0x8d, 0x0, 0x0, 0xd9, 0x8d, 0x0, 0x0, 0xab,
    0x8d, 0x0, 0x0, 0xab, 0x8d, 0x0, 0x0, 0xd9,
    0x8e, 0x74, 0x5b, 0xf2, 0x8f, 0xcf, 0xfc, 0x40,
    0x8d, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x0,

    /* U+03B3 "γ" */
    0xab, 0x0, 0x0, 0x6f, 0x14, 0xf1, 0x0, 0xb,
    0xa0, 0xd, 0x70, 0x1, 0xf4, 0x0, 0x7d, 0x0,
    0x7e, 0x0, 0x1, 0xf3, 0xd, 0x70, 0x0, 0xb,
    0xa3, 0xf1, 0x0, 0x0, 0x5f, 0xab, 0x0, 0x0,
    0x0, 0xef, 0x50, 0x0, 0x0, 0x9, 0xe0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x0, 0x8, 0xe0,
    0x0, 0x0, 0x0, 0x8e, 0x0, 0x0,

    /* U+03B4 "δ" */
    0x0, 0x5d, 0xff, 0xd8, 0x0, 0x1f, 0xa5, 0x57,
    0x80, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x8, 0xfa,
    0x40, 0x0, 0x0, 0x6d, 0xff, 0xe5, 0x0, 0x7f,
    0x62, 0x28, 0xf5, 0xd, 0x90, 0x0, 0xb, 0xb0,
    0xf7, 0x0, 0x0, 0x9e, 0xf, 0x70, 0x0, 0x9,
    0xe0, 0xea, 0x0, 0x0, 0xbc, 0x7, 0xf7, 0x33,
    0x8f, 0x50, 0x6, 0xcf, 0xfc, 0x50,

    /* U+03B5 "ε" */
    0x7, 0xdf, 0xfc, 0x6, 0xf7, 0x44, 0x70, 0xac,
    0x0, 0x0, 0x7, 0xf5, 0x10, 0x0, 0xb, 0xff,
    0xf4, 0x9, 0xe6, 0x43, 0x0, 0xe8, 0x0, 0x0,
    0xb, 0xe6, 0x44, 0x54, 0x1a, 0xef, 0xfe, 0x50,

    /* U+03B6 "ζ" */
    0x9, 0xff, 0xff, 0xe0, 0x1, 0x22, 0x7f, 0x70,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x0, 0xeb, 0x0, 0x0, 0x6, 0xf2, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0,
    0x4, 0xfc, 0x61, 0x0, 0x0, 0x29, 0xef, 0x90,
    0x0, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x16, 0xf3,
    0x0, 0x0, 0x8e, 0x70,

    /* U+03B7 "η" */
    0x8f, 0xa2, 0xbf, 0xeb, 0x12, 0x7f, 0xd7, 0x35,
    0xea, 0x2, 0xf6, 0x0, 0x9, 0xd0, 0x2f, 0x30,
    0x0, 0x7e, 0x2, 0xf3, 0x0, 0x7, 0xe0, 0x2f,
    0x30, 0x0, 0x7e, 0x2, 0xf3, 0x0, 0x7, 0xe0,
    0x2f, 0x30, 0x0, 0x7e, 0x2, 0xf3, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0x0, 0x7e,

    /* U+03B8 "θ" */
    0x2, 0xbe, 0xfc, 0x40, 0x0, 0xea, 0x43, 0x8f,
    0x20, 0x6e, 0x0, 0x0, 0xc9, 0xa, 0xb0, 0x0,
    0x7, 0xd0, 0xca, 0x11, 0x11, 0x7f, 0xd, 0xff,
    0xff, 0xff, 0xf1, 0xdb, 0x44, 0x44, 0x8f, 0x1c,
    0xa0, 0x0, 0x7, 0xf0, 0xac, 0x0, 0x0, 0x9d,
    0x6, 0xf1, 0x0, 0xd, 0x90, 0xe, 0xc4, 0x39,
    0xf2, 0x0, 0x2b, 0xef, 0xc4, 0x0,

    /* U+03B9 "ι" */
    0xab, 0x0, 0xab, 0x0, 0xab, 0x0, 0xab, 0x0,
    0xab, 0x0, 0xab, 0x0, 0x9c, 0x0, 0x8f, 0x43,
    0x1c, 0xfe,

    /* U+03BA "κ" */
    0x8d, 0x0, 0x1e, 0xa0, 0x8d, 0x0, 0xcc, 0x0,
    0x8d, 0x8, 0xe1, 0x0, 0x8d, 0x4f, 0x30, 0x0,
    0x8f, 0xf9, 0x0, 0x0, 0x8d, 0x7f, 0x40, 0x0,
    0x8d, 0x9, 0xe2, 0x0, 0x8d, 0x0, 0xcd, 0x10,
    0x8d, 0x0, 0x1e, 0xc0,

    /* U+03BB "λ" */
    0x0, 0xbb, 0x0, 0x0, 0x0, 0x5, 0xf2, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x0, 0xad,
    0x0, 0x0, 0x0, 0xe, 0xf4, 0x0, 0x0, 0x5,
    0xfd, 0xa0, 0x0, 0x0, 0xba, 0x7f, 0x0, 0x0,
    0x1f, 0x41, 0xf6, 0x0, 0x8, 0xd0, 0xb, 0xc0,
    0x0, 0xe7, 0x0, 0x5f, 0x20, 0x4f, 0x10, 0x0,
    0xe8, 0xa, 0xb0, 0x0, 0x9, 0xe0,

    /* U+03BC "μ" */
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9d, 0x0, 0x3, 0xf5, 0x9f, 0x51, 0x4c, 0xf5,
    0x9f, 0xef, 0xd5, 0xe5, 0x9c, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x0,

    /* U+03BD "ν" */
    0xab, 0x0, 0x0, 0x5f, 0x14, 0xf1, 0x0, 0xb,
    0xb0, 0xe, 0x60, 0x1, 0xf5, 0x0, 0x9c, 0x0,
    0x6f, 0x0, 0x3, 0xf1, 0xb, 0xa0, 0x0, 0xd,
    0x71, 0xf4, 0x0, 0x0, 0x8c, 0x6e, 0x0, 0x0,
    0x2, 0xfd, 0x90, 0x0, 0x0, 0xc, 0xf3, 0x0,
    0x0,

    /* U+03BE "ξ" */
    0x9, 0xff, 0xff, 0xe0, 0x1, 0xbd, 0x63, 0x20,
    0x4, 0xf2, 0x0, 0x0, 0x3, 0xf7, 0x10, 0x0,
    0x0, 0x7f, 0xff, 0x30, 0x3, 0xfc, 0x53, 0x0,
    0xc, 0xc0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0xc, 0xd2, 0x0, 0x0,
    0x3, 0xef, 0xa5, 0x0, 0x0, 0x17, 0xdf, 0xd0,
    0x0, 0x0, 0x5, 0xf4, 0x0, 0x0, 0x17, 0xf2,
    0x0, 0x0, 0x8d, 0x60,

    /* U+03BF "ο" */
    0x0, 0x6d, 0xff, 0xc5, 0x0, 0x6f, 0x73, 0x39,
    0xf4, 0xc, 0xa0, 0x0, 0xd, 0xa0, 0xf7, 0x0,
    0x0, 0x9d, 0xf, 0x60, 0x0, 0x8, 0xe0, 0xf7,
    0x0, 0x0, 0x9d, 0xc, 0xb0, 0x0, 0xc, 0xa0,
    0x6f, 0x83, 0x39, 0xf4, 0x0, 0x6d, 0xff, 0xc5,
    0x0,

    /* U+03C0 "π" */
    0x9f, 0xff, 0xff, 0xff, 0xf6, 0x16, 0xf3, 0x33,
    0x7f, 0x31, 0x4, 0xf0, 0x0, 0x5f, 0x0, 0x5,
    0xf0, 0x0, 0x5f, 0x0, 0x5, 0xf0, 0x0, 0x5f,
    0x0, 0x6, 0xf0, 0x0, 0x5f, 0x0, 0x6, 0xf0,
    0x0, 0x5f, 0x0, 0x7, 0xe0, 0x0, 0x4f, 0x51,
    0x9, 0xd0, 0x0, 0xb, 0xf6,

    /* U+03C1 "ρ" */
    0x2, 0xbe, 0xfd, 0x60, 0x2f, 0xb4, 0x39, 0xf5,
    0x8e, 0x0, 0x0, 0xcb, 0xba, 0x0, 0x0, 0x9d,
    0xca, 0x0, 0x0, 0x8e, 0xcb, 0x0, 0x0, 0x9e,
    0xcf, 0x0, 0x0, 0xdb, 0xce, 0xc4, 0x39, 0xf4,
    0xc9, 0x8e, 0xfd, 0x50, 0xc9, 0x0, 0x0, 0x0,
    0xc9, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x0,

    /* U+03C2 "ς" */
    0x0, 0x6d, 0xff, 0xd2, 0x6, 0xf8, 0x44, 0x61,
    0xd, 0xb0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0xb, 0xd0, 0x0, 0x0, 0x2, 0xee, 0x83, 0x0,
    0x0, 0x17, 0xdf, 0xb0, 0x0, 0x0, 0x3, 0xf5,
    0x0, 0x0, 0x15, 0xf4, 0x0, 0x0, 0x7e, 0x80,

    /* U+03C3 "σ" */
    0x0, 0x4b, 0xef, 0xff, 0xff, 0x10, 0x4f, 0xa4,
    0x34, 0xf6, 0x20, 0xc, 0xc0, 0x0, 0xc, 0xa0,
    0x0, 0xf7, 0x0, 0x0, 0x9d, 0x0, 0xf, 0x60,
    0x0, 0x8, 0xe0, 0x0, 0xf7, 0x0, 0x0, 0x9d,
    0x0, 0xc, 0xb0, 0x0, 0xc, 0xb0, 0x0, 0x5f,
    0x83, 0x38, 0xf4, 0x0, 0x0, 0x6d, 0xff, 0xc5,
    0x0, 0x0,

    /* U+03C4 "τ" */
    0xef, 0xff, 0xff, 0xa2, 0x39, 0xe3, 0x31, 0x0,
    0x8d, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0x6, 0xf4, 0x20, 0x0, 0xb, 0xfa, 0x0,

    /* U+03C5 "υ" */
    0x9c, 0x0, 0x7, 0xe0, 0x9c, 0x0, 0x4, 0xf1,
    0x9c, 0x0, 0x2, 0xf3, 0x9c, 0x0, 0x1, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x1, 0xf4,
    0x8e, 0x0, 0x5, 0xf1, 0x3f, 0xa4, 0x6e, 0xa0,
    0x4, 0xcf, 0xe9, 0x0,

    /* U+03C6 "φ" */
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x0, 0x2a, 0xef, 0xff, 0xd7, 0x0,
    0x2, 0xfc, 0x59, 0xe4, 0x7f, 0xa0, 0xb, 0xd0,
    0x7, 0xe0, 0x6, 0xf2, 0xf, 0x80, 0x7, 0xe0,
    0x1, 0xf6, 0xf, 0x60, 0x7, 0xe0, 0x0, 0xf6,
    0xf, 0x70, 0x7, 0xe0, 0x2, 0xf5, 0xc, 0xc0,
    0x7, 0xe0, 0x7, 0xf1, 0x4, 0xfa, 0x49, 0xe4,
    0x8f, 0x80, 0x0, 0x4b, 0xef, 0xff, 0xc6, 0x0,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0,

    /* U+03C7 "χ" */
    0x6f, 0x10, 0x0, 0xe8, 0xe, 0x70, 0x5, 0xf1,
    0x7, 0xe0, 0xc, 0x90, 0x0, 0xe5, 0x3f, 0x20,
    0x0, 0x8c, 0xaa, 0x0, 0x0, 0x1f, 0xf3, 0x0,
    0x0, 0x3f, 0xf5, 0x0, 0x0, 0xba, 0x8c, 0x0,
    0x2, 0xf3, 0x1f, 0x40, 0x9, 0xc0, 0xa, 0xb0,
    0x1f, 0x50, 0x3, 0xf3, 0x8d, 0x0, 0x0, 0xba,

    /* U+03C8 "ψ" */
    0x9c, 0x0, 0xac, 0x0, 0xd7, 0x9c, 0x0, 0xac,
    0x0, 0xab, 0x9c, 0x0, 0xac, 0x0, 0x8d, 0x9c,
    0x0, 0xac, 0x0, 0x6f, 0x9c, 0x0, 0xac, 0x0,
    0x7e, 0x9c, 0x0, 0xac, 0x0, 0x9d, 0x7f, 0x0,
    0xac, 0x0, 0xd8, 0x1e, 0xb4, 0xbc, 0x4c, 0xe1,
    0x3, 0xbf, 0xff, 0xeb, 0x20, 0x0, 0x0, 0xac,
    0x0, 0x0, 0x0, 0x0, 0xac, 0x0, 0x0, 0x0,
    0x0, 0xac, 0x0, 0x0,

    /* U+03C9 "ω" */
    0x6f, 0x0, 0x0, 0x0, 0x7e, 0xa, 0xb0, 0x0,
    0x0, 0x3, 0xf2, 0xc9, 0x0, 0x5c, 0x0, 0x1f,
    0x4d, 0x80, 0x7, 0xf0, 0x0, 0xf6, 0xe7, 0x0,
    0x7f, 0x0, 0xf, 0x6d, 0x80, 0x7, 0xf0, 0x0,
    0xf5, 0xbb, 0x0, 0x9f, 0x10, 0x3f, 0x35, 0xf7,
    0x5f, 0xea, 0x5c, 0xd0, 0x8, 0xff, 0x82, 0xdf,
    0xc3, 0x0,

    /* U+03CC "ό" */
    0x0, 0x0, 0x3f, 0x40, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x0, 0x22, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+03CD "ύ" */
    0x0, 0xa, 0xd0, 0x0, 0x0, 0xd, 0x50, 0x0,
    0x0, 0x4, 0x0, 0x0, 0x9c, 0x0, 0x7, 0xe0,
    0x9c, 0x0, 0x4, 0xf1, 0x9c, 0x0, 0x2, 0xf3,
    0x9c, 0x0, 0x1, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x1, 0xf4, 0x8e, 0x0, 0x5, 0xf1,
    0x3f, 0xa4, 0x6e, 0xa0, 0x4, 0xcf, 0xe9, 0x0,

    /* U+03CE "ώ" */
    0x0, 0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0x2,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x13, 0x0, 0x0,
    0x6, 0xf0, 0x0, 0x0, 0x7, 0xe0, 0xab, 0x0,
    0x0, 0x0, 0x3f, 0x2c, 0x90, 0x5, 0xc0, 0x1,
    0xf4, 0xd8, 0x0, 0x7f, 0x0, 0xf, 0x6e, 0x70,
    0x7, 0xf0, 0x0, 0xf6, 0xd8, 0x0, 0x7f, 0x0,
    0xf, 0x5b, 0xb0, 0x9, 0xf1, 0x3, 0xf3, 0x5f,
    0x75, 0xfe, 0xa5, 0xcd, 0x0, 0x8f, 0xf8, 0x2d,
    0xfc, 0x30,

    /* U+0406 "І" */
    0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e, 0x8e,
    0x8e, 0x8e, 0x8e,

    /* U+0408 "Ј" */
    0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0,
    0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0, 0x8e, 0x0,
    0x8, 0xe0, 0x0, 0x8e, 0x0, 0x8, 0xe0, 0x0,
    0x8e, 0x0, 0x8, 0xe0, 0x0, 0xad, 0x15, 0x7f,
    0x83, 0xfe, 0x90,

    /* U+0410 "А" */
    0x0, 0x0, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x2f,
    0xbd, 0x0, 0x0, 0x0, 0x9, 0xc1, 0xf4, 0x0,
    0x0, 0x0, 0xe5, 0xb, 0xa0, 0x0, 0x0, 0x5e,
    0x0, 0x4f, 0x0, 0x0, 0xb, 0x91, 0x11, 0xe6,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x7c,
    0x44, 0x44, 0x5f, 0x20, 0xd, 0x70, 0x0, 0x0,
    0xd8, 0x4, 0xf2, 0x0, 0x0, 0x8, 0xe0, 0xac,
    0x0, 0x0, 0x0, 0x3f, 0x40,

    /* U+0411 "Б" */
    0x8f, 0xff, 0xff, 0xe0, 0x8, 0xe4, 0x44, 0x44,
    0x0, 0x8e, 0x0, 0x0, 0x0, 0x8, 0xe0, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xfe, 0x91, 0x8, 0xe3,
    0x34, 0x7f, 0x90, 0x8e, 0x0, 0x0, 0x8e, 0x8,
    0xe0, 0x0, 0x6, 0xf0, 0x8e, 0x0, 0x0, 0x9e,
    0x8, 0xe4, 0x45, 0x8f, 0x80, 0x8f, 0xff, 0xfe,
    0x80, 0x0,

    /* U+0412 "В" */
    0x8f, 0xff, 0xfc, 0x40, 0x8e, 0x44, 0x5b, 0xf1,
    0x8e, 0x0, 0x1, 0xf5, 0x8e, 0x0, 0x1, 0xf5,
    0x8e, 0x0, 0x19, 0xe1, 0x8f, 0xff, 0xff, 0x50,
    0x8e, 0x22, 0x38, 0xf5, 0x8e, 0x0, 0x0, 0xbb,
    0x8e, 0x0, 0x0, 0xca, 0x8e, 0x44, 0x58, 0xf6,
    0x8f, 0xff, 0xfd, 0x70,

    /* U+0413 "Г" */
    0x8f, 0xff, 0xff, 0xa8, 0xe5, 0x55, 0x53, 0x8e,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x8,
    0xe0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,

    /* U+0417 "З" */
    0xb, 0xef, 0xfd, 0x70, 0x7, 0x54, 0x59, 0xf5,
    0x0, 0x0, 0x0, 0xe8, 0x0, 0x0, 0x16, 0xf3,
    0xa, 0xff, 0xfe, 0x40, 0x2, 0x33, 0x5b, 0xf3,
    0x0, 0x0, 0x0, 0xcb, 0x0, 0x0, 0x0, 0x9d,
    0x0, 0x0, 0x0, 0xcc, 0x37, 0x44, 0x5a, 0xf5,
    0x3d, 0xff, 0xfc, 0x50,

    /* U+0418 "И" */
    0x8e, 0x0, 0x0, 0x2f, 0xf5, 0x8e, 0x0, 0x0,
    0xbc, 0xf5, 0x8e, 0x0, 0x4, 0xf4, 0xf5, 0x8e,
    0x0, 0xd, 0x81, 0xf5, 0x8e, 0x0, 0x6e, 0x11,
    0xf5, 0x8e, 0x0, 0xe6, 0x1, 0xf5, 0x8e, 0x8,
    0xd0, 0x1, 0xf5, 0x8e, 0x1f, 0x40, 0x1, 0xf5,
    0x8e, 0xab, 0x0, 0x1, 0xf5, 0x8f, 0xf2, 0x0,
    0x1, 0xf5, 0x8f, 0x90, 0x0, 0x1, 0xf5,

    /* U+041A "К" */
    0x8e, 0x0, 0x1, 0xeb, 0x8, 0xe0, 0x0, 0xbe,
    0x10, 0x8e, 0x0, 0x7f, 0x30, 0x8, 0xe0, 0x3f,
    0x70, 0x0, 0x8e, 0x1d, 0xb0, 0x0, 0x8, 0xff,
    0xfb, 0x10, 0x0, 0x8e, 0x46, 0xed, 0x10, 0x8,
    0xe0, 0x2, 0xf9, 0x0, 0x8e, 0x0, 0x7, 0xf2,
    0x8, 0xe0, 0x0, 0xe, 0xa0, 0x8e, 0x0, 0x0,
    0x7f, 0x20,

    /* U+041C "М" */
    0x8f, 0xf0, 0x0, 0x0, 0xaf, 0xd8, 0xef, 0x60,
    0x0, 0x1f, 0xdd, 0x8e, 0x9c, 0x0, 0x7, 0xda,
    0xd8, 0xe3, 0xf2, 0x0, 0xd6, 0xad, 0x8e, 0xc,
    0x90, 0x4f, 0x1a, 0xd8, 0xe0, 0x6e, 0xa, 0xa0,
    0xad, 0x8e, 0x0, 0xe7, 0xf3, 0xa, 0xd8, 0xe0,
    0x8, 0xfd, 0x0, 0xad, 0x8e, 0x0, 0x28, 0x40,
    0xa, 0xd8, 0xe0, 0x0, 0x0, 0x0, 0xad, 0x8e,
    0x0, 0x0, 0x0, 0xa, 0xd0,

    /* U+041D "Н" */
    0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0, 0x0,
    0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0,
    0x0, 0x9d, 0x8f, 0xff, 0xff, 0xff, 0xd8, 0xe3,
    0x33, 0x33, 0xad, 0x8e, 0x0, 0x0, 0x9, 0xd8,
    0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9,
    0xd8, 0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0,
    0x9, 0xd0,

    /* U+041E "О" */
    0x1, 0x9d, 0xff, 0xd8, 0x0, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x6f, 0x30, 0x0, 0x5, 0xf4, 0xad,
    0x0, 0x0, 0x0, 0xf8, 0xcb, 0x0, 0x0, 0x0,
    0xda, 0xda, 0x0, 0x0, 0x0, 0xcb, 0xcb, 0x0,
    0x0, 0x0, 0xda, 0xad, 0x0, 0x0, 0x0, 0xf8,
    0x6f, 0x30, 0x0, 0x4, 0xf4, 0xd, 0xe7, 0x44,
    0x8f, 0xb0, 0x1, 0x9d, 0xff, 0xd8, 0x0,

    /* U+041F "П" */
    0x8f, 0xff, 0xff, 0xff, 0xd8, 0xe4, 0x44, 0x44,
    0xbd, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0, 0x0,
    0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8, 0xe0,
    0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9, 0xd8,
    0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0, 0x9,
    0xd8, 0xe0, 0x0, 0x0, 0x9d, 0x8e, 0x0, 0x0,
    0x9, 0xd0,

    /* U+0420 "Р" */
    0x8f, 0xff, 0xec, 0x40, 0x8e, 0x44, 0x6c, 0xf3,
    0x8e, 0x0, 0x0, 0xf8, 0x8e, 0x0, 0x0, 0xd9,
    0x8e, 0x0, 0x0, 0xf8, 0x8e, 0x0, 0x18, 0xf3,
    0x8f, 0xff, 0xfe, 0x70, 0x8e, 0x33, 0x20, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x6c, 0xef, 0xe9, 0xa, 0xfa, 0x65, 0x66,
    0x4f, 0x60, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0xcb, 0x0, 0x0, 0x0, 0xae, 0x0, 0x0, 0x0,
    0x5f, 0x50, 0x0, 0x0, 0xc, 0xf9, 0x55, 0x68,
    0x0, 0x8d, 0xff, 0xe9,

    /* U+0422 "Т" */
    0xcf, 0xff, 0xff, 0xff, 0x23, 0x55, 0xaf, 0x55,
    0x50, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x8f,
    0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0, 0x0,
    0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0, 0x0,
    0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0, 0x0,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0x0, 0x8, 0xf0,
    0x0, 0x0,

    /* U+0423 "У" */
    0xad, 0x0, 0x0, 0x9, 0xd0, 0x3f, 0x40, 0x0,
    0xf, 0x60, 0xb, 0xb0, 0x0, 0x6e, 0x0, 0x4,
    0xf2, 0x0, 0xd8, 0x0, 0x0, 0xc9, 0x4, 0xf1,
    0x0, 0x0, 0x5f, 0x1b, 0xa0, 0x0, 0x0, 0xe,
    0x9f, 0x30, 0x0, 0x0, 0x6, 0xfc, 0x0, 0x0,
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x3, 0x6e, 0xb0,
    0x0, 0x0, 0xd, 0xe8, 0x0, 0x0, 0x0,

    /* U+0427 "Ч" */
    0xe8, 0x0, 0x0, 0x7f, 0xe8, 0x0, 0x0, 0x7f,
    0xe8, 0x0, 0x0, 0x7f, 0xe9, 0x0, 0x0, 0x7f,
    0xcb, 0x0, 0x0, 0x7f, 0x8f, 0x51, 0x2, 0x9f,
    0xa, 0xff, 0xff, 0xff, 0x0, 0x12, 0x20, 0x7f,
    0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0x7f,

    /* U+0430 "а" */
    0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0, 0x53, 0x4c,
    0xf1, 0x0, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0x1, 0xf5, 0x2, 0xae, 0xff, 0xff, 0x50, 0xdc,
    0x42, 0x23, 0xf5, 0x1f, 0x50, 0x0, 0x2f, 0x50,
    0xea, 0x11, 0x4c, 0xf5, 0x3, 0xcf, 0xfb, 0x3e,
    0x50,

    /* U+0431 "б" */
    0x0, 0x3, 0x57, 0x92, 0x4, 0xef, 0xdc, 0xa2,
    0x2f, 0x80, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0xc9, 0x9e, 0xfd, 0x60, 0xee, 0x73, 0x28, 0xf4,
    0xfb, 0x0, 0x0, 0xcb, 0xf7, 0x0, 0x0, 0x9d,
    0xf6, 0x0, 0x0, 0x8e, 0xd7, 0x0, 0x0, 0x9d,
    0xab, 0x0, 0x0, 0xca, 0x4f, 0x83, 0x38, 0xf4,
    0x6, 0xdf, 0xfc, 0x50,

    /* U+0432 "в" */
    0x8f, 0xff, 0xfc, 0x30, 0x8d, 0x33, 0x3c, 0xd0,
    0x8d, 0x0, 0x6, 0xf0, 0x8d, 0x0, 0xa, 0xc0,
    0x8f, 0xff, 0xff, 0x40, 0x8d, 0x22, 0x39, 0xf1,
    0x8d, 0x0, 0x3, 0xf3, 0x8e, 0x33, 0x39, 0xf1,
    0x8f, 0xff, 0xfd, 0x50,

    /* U+0433 "г" */
    0x8f, 0xff, 0xc8, 0xd3, 0x32, 0x8d, 0x0, 0x8,
    0xd0, 0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d,
    0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0, 0x0,

    /* U+0434 "д" */
    0x0, 0x6f, 0xff, 0xff, 0x0, 0x0, 0x8e, 0x22,
    0x8f, 0x0, 0x0, 0xac, 0x0, 0x6f, 0x0, 0x0,
    0xba, 0x0, 0x6f, 0x0, 0x0, 0xe8, 0x0, 0x6f,
    0x0, 0x0, 0xf5, 0x0, 0x6f, 0x0, 0x5, 0xf1,
    0x0, 0x6f, 0x0, 0x3d, 0xd5, 0x55, 0x9f, 0x51,
    0xbf, 0xff, 0xff, 0xff, 0xf5, 0xba, 0x0, 0x0,
    0x0, 0xf5, 0xba, 0x0, 0x0, 0x0, 0xf5, 0x65,
    0x0, 0x0, 0x0, 0x93,

    /* U+0435 "е" */
    0x0, 0x6d, 0xff, 0xb2, 0x0, 0x6f, 0x73, 0x3c,
    0xc0, 0xd, 0xa0, 0x0, 0x2f, 0x20, 0xf7, 0x12,
    0x35, 0xf4, 0xf, 0xed, 0xdd, 0xdd, 0x30, 0xf7,
    0x0, 0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x0,
    0x6f, 0x95, 0x46, 0x90, 0x0, 0x6d, 0xff, 0xd8,
    0x0,

    /* U+0436 "ж" */
    0x7f, 0x30, 0xd, 0x90, 0x7, 0xf3, 0xb, 0xd0,
    0xd, 0x90, 0x3f, 0x70, 0x1, 0xe9, 0xd, 0x90,
    0xdb, 0x0, 0x0, 0x3f, 0x5d, 0x99, 0xe1, 0x0,
    0x0, 0x3e, 0xff, 0xff, 0xb1, 0x0, 0x3, 0xf9,
    0x3d, 0xa3, 0xce, 0x0, 0xc, 0xb0, 0xd, 0x90,
    0x1e, 0x80, 0x4f, 0x30, 0xd, 0x90, 0x7, 0xe0,
    0xac, 0x0, 0xd, 0x90, 0x1, 0xf6,

    /* U+0437 "з" */
    0xb, 0xef, 0xe9, 0x0, 0x53, 0x25, 0xf6, 0x0,
    0x0, 0xc, 0x80, 0x0, 0x3, 0xf5, 0x1, 0xff,
    0xfb, 0x0, 0x2, 0x24, 0xe8, 0x0, 0x0, 0x9,
    0xb1, 0x53, 0x35, 0xe8, 0x3d, 0xef, 0xe9, 0x0,

    /* U+0438 "и" */
    0x8d, 0x0, 0x7, 0xfd, 0x8d, 0x0, 0x1f, 0xcd,
    0x8d, 0x0, 0x9b, 0x8d, 0x8d, 0x2, 0xf3, 0x8d,
    0x8d, 0xa, 0xa0, 0x8d, 0x8d, 0x3f, 0x10, 0x8d,
    0x8d, 0xb8, 0x0, 0x8d, 0x8f, 0xe1, 0x0, 0x8d,
    0x8f, 0x70, 0x0, 0x8d,

    /* U+0439 "й" */
    0x2, 0x80, 0x4, 0x50, 0x1, 0xf6, 0x1d, 0x70,
    0x0, 0x4b, 0xc8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x7, 0xfd, 0x8d, 0x0, 0x1f, 0xcd,
    0x8d, 0x0, 0x9b, 0x8d, 0x8d, 0x2, 0xf3, 0x8d,
    0x8d, 0xa, 0xa0, 0x8d, 0x8d, 0x3f, 0x10, 0x8d,
    0x8d, 0xb8, 0x0, 0x8d, 0x8f, 0xe1, 0x0, 0x8d,
    0x8f, 0x70, 0x0, 0x8d,

    /* U+043A "к" */
    0x8d, 0x0, 0x3f, 0x78, 0xd0, 0xd, 0xb0, 0x8d,
    0x9, 0xe1, 0x8, 0xd4, 0xf3, 0x0, 0x8f, 0xfe,
    0x30, 0x8, 0xd3, 0x9f, 0x30, 0x8d, 0x0, 0xbc,
    0x8, 0xd0, 0x3, 0xf4, 0x8d, 0x0, 0xc, 0xa0,

    /* U+043B "л" */
    0x0, 0x6f, 0xff, 0xff, 0x0, 0x8e, 0x22, 0x8f,
    0x0, 0x9c, 0x0, 0x6f, 0x0, 0xba, 0x0, 0x6f,
    0x0, 0xd8, 0x0, 0x6f, 0x0, 0xf6, 0x0, 0x6f,
    0x3, 0xf2, 0x0, 0x6f, 0x2c, 0xc0, 0x0, 0x6f,
    0xcb, 0x10, 0x0, 0x6f,

    /* U+043C "м" */
    0x8f, 0xc0, 0x0, 0xf, 0xf4, 0x8e, 0xf2, 0x0,
    0x6e, 0xf4, 0x8c, 0xc8, 0x0, 0xc8, 0xf4, 0x8c,
    0x5e, 0x3, 0xf2, 0xf4, 0x8c, 0xf, 0x59, 0xa1,
    0xf4, 0x8c, 0x9, 0xce, 0x41, 0xf4, 0x8c, 0x2,
    0xfe, 0x1, 0xf4, 0x8c, 0x0, 0x42, 0x1, 0xf4,
    0x8c, 0x0, 0x0, 0x1, 0xf4,

    /* U+043D "н" */
    0x8d, 0x0, 0x0, 0x9d, 0x8d, 0x0, 0x0, 0x9d,
    0x8d, 0x0, 0x0, 0x9d, 0x8d, 0x11, 0x11, 0x9d,
    0x8f, 0xff, 0xff, 0xfd, 0x8d, 0x44, 0x44, 0xad,
    0x8d, 0x0, 0x0, 0x9d, 0x8d, 0x0, 0x0, 0x9d,
    0x8d, 0x0, 0x0, 0x9d,

    /* U+043E "о" */
    0x0, 0x6d, 0xff, 0xc5, 0x0, 0x6f, 0x73, 0x39,
    0xf4, 0xc, 0xa0, 0x0, 0xd, 0xa0, 0xf7, 0x0,
    0x0, 0x9d, 0xf, 0x60, 0x0, 0x8, 0xe0, 0xf7,
    0x0, 0x0, 0x9d, 0xc, 0xb0, 0x0, 0xc, 0xa0,
    0x6f, 0x83, 0x39, 0xf4, 0x0, 0x6d, 0xff, 0xc5,
    0x0,

    /* U+043F "п" */
    0x8f, 0xff, 0xff, 0xfd, 0x8e, 0x55, 0x55, 0xbd,
    0x8d, 0x0, 0x0, 0x9d, 0x8d, 0x0, 0x0, 0x9d,
    0x8d, 0x0, 0x0, 0x9d, 0x8d, 0x0, 0x0, 0x9d,
    0x8d, 0x0, 0x0, 0x9d, 0x8d, 0x0, 0x0, 0x9d,
    0x8d, 0x0, 0x0, 0x9d,

    /* U+0440 "р" */
    0x8d, 0x5d, 0xfe, 0x90, 0x8, 0xeb, 0x31, 0x4e,
    0x90, 0x8f, 0x10, 0x0, 0x8f, 0x8, 0xd0, 0x0,
    0x4, 0xf2, 0x8c, 0x0, 0x0, 0x4f, 0x28, 0xe0,
    0x0, 0x5, 0xf1, 0x8f, 0x30, 0x0, 0x9e, 0x8,
    0xed, 0x53, 0x7f, 0x80, 0x8d, 0x4d, 0xfe, 0x90,
    0x8, 0xd0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x0, 0x8, 0xd0, 0x0, 0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x6d, 0xff, 0xd2, 0x6, 0xf8, 0x44, 0x61,
    0xc, 0xb0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0x6, 0xf8, 0x44, 0x62,
    0x0, 0x6d, 0xff, 0xd2,

    /* U+0442 "т" */
    0xbf, 0xff, 0xff, 0xf2, 0x34, 0xf6, 0x32, 0x0,
    0x1f, 0x40, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x1f, 0x40,
    0x0, 0x1, 0xf4, 0x0, 0x0, 0x1f, 0x40, 0x0,

    /* U+0443 "у" */
    0xad, 0x0, 0x0, 0x4f, 0x14, 0xf2, 0x0, 0xa,
    0xb0, 0xd, 0x80, 0x0, 0xf5, 0x0, 0x7e, 0x0,
    0x5f, 0x0, 0x1, 0xf4, 0xa, 0x90, 0x0, 0xa,
    0xa0, 0xf4, 0x0, 0x0, 0x4f, 0x6e, 0x0, 0x0,
    0x0, 0xdf, 0x80, 0x0, 0x0, 0x8, 0xf2, 0x0,
    0x0, 0x0, 0xbb, 0x0, 0x0, 0x4, 0x9f, 0x30,
    0x0, 0x0, 0xec, 0x40, 0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0x0, 0x37, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7e, 0x0, 0x0, 0x0, 0x0, 0x9e, 0xfa, 0x8e,
    0x5d, 0xfd, 0x30, 0x7, 0xf7, 0x38, 0xef, 0xb4,
    0x4d, 0xe0, 0xd, 0xa0, 0x0, 0xcf, 0x20, 0x4,
    0xf4, 0xf, 0x70, 0x0, 0x8e, 0x0, 0x1, 0xf6,
    0xf, 0x60, 0x0, 0x7d, 0x0, 0x0, 0xf6, 0xf,
    0x70, 0x0, 0x8e, 0x0, 0x1, 0xf6, 0xd, 0xa0,
    0x0, 0xbf, 0x20, 0x4, 0xf3, 0x9, 0xf6, 0x38,
    0xef, 0xc4, 0x4d, 0xd0, 0x0, 0xaf, 0xf9, 0x8e,
    0x6e, 0xfc, 0x20, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,

    /* U+0445 "х" */
    0x4f, 0x30, 0x0, 0xe8, 0x0, 0xad, 0x0, 0x8e,
    0x0, 0x1, 0xe7, 0x2f, 0x40, 0x0, 0x6, 0xfc,
    0xa0, 0x0, 0x0, 0xe, 0xf4, 0x0, 0x0, 0x8,
    0xeb, 0xc0, 0x0, 0x2, 0xf5, 0x1f, 0x60, 0x0,
    0xcb, 0x0, 0x7f, 0x10, 0x7f, 0x10, 0x0, 0xdb,
    0x0,

    /* U+0446 "ц" */
    0x8d, 0x0, 0x0, 0x9d, 0x0, 0x8d, 0x0, 0x0,
    0x9d, 0x0, 0x8d, 0x0, 0x0, 0x9d, 0x0, 0x8d,
    0x0, 0x0, 0x9d, 0x0, 0x8d, 0x0, 0x0, 0x9d,
    0x0, 0x8d, 0x0, 0x0, 0x9d, 0x0, 0x8d, 0x0,
    0x0, 0x9d, 0x0, 0x8e, 0x55, 0x55, 0xbd, 0x50,
    0x8f, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x4, 0xf2, 0x0, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x2, 0x91,

    /* U+0447 "ч" */
    0xba, 0x0, 0x2, 0xf3, 0xba, 0x0, 0x2, 0xf3,
    0xba, 0x0, 0x2, 0xf3, 0xbb, 0x0, 0x4, 0xf3,
    0x8f, 0x30, 0x3d, 0xf3, 0x1d, 0xff, 0xf7, 0xf3,
    0x0, 0x12, 0x2, 0xf3, 0x0, 0x0, 0x2, 0xf3,
    0x0, 0x0, 0x2, 0xf3,

    /* U+0448 "ш" */
    0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x8d, 0x0,
    0x8, 0xd0, 0x0, 0x8d, 0x8d, 0x0, 0x8, 0xd0,
    0x0, 0x8d, 0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d,
    0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x8d, 0x0,
    0x8, 0xd0, 0x0, 0x8d, 0x8d, 0x0, 0x8, 0xd0,
    0x0, 0x8d, 0x8e, 0x55, 0x5a, 0xe5, 0x55, 0xad,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xfd,

    /* U+0449 "щ" */
    0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0, 0x8d,
    0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0, 0x8d, 0x0,
    0x8, 0xd0, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8,
    0xd0, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8, 0xd0,
    0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d,
    0x0, 0x8e, 0x55, 0x5a, 0xe5, 0x55, 0xae, 0x50,
    0x8f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x91,

    /* U+044A "ъ" */
    0xbf, 0xff, 0x20, 0x0, 0x0, 0x23, 0x5f, 0x20,
    0x0, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xfe, 0x90, 0x0, 0x3f, 0x53, 0x36,
    0xf7, 0x0, 0x3f, 0x20, 0x0, 0xca, 0x0, 0x3f,
    0x20, 0x0, 0xba, 0x0, 0x3f, 0x53, 0x36, 0xf6,
    0x0, 0x3f, 0xff, 0xfe, 0x90,

    /* U+044B "ы" */
    0x8d, 0x0, 0x0, 0x0, 0x4f, 0x18, 0xd0, 0x0,
    0x0, 0x4, 0xf1, 0x8d, 0x0, 0x0, 0x0, 0x4f,
    0x18, 0xff, 0xff, 0xd6, 0x4, 0xf1, 0x8d, 0x33,
    0x3a, 0xf1, 0x4f, 0x18, 0xd0, 0x0, 0x1f, 0x44,
    0xf1, 0x8d, 0x0, 0x1, 0xf4, 0x4f, 0x18, 0xe3,
    0x34, 0xaf, 0x14, 0xf1, 0x8f, 0xff, 0xfd, 0x50,
    0x4f, 0x10,

    /* U+044C "ь" */
    0x8d, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xfd, 0x60,
    0x8d, 0x33, 0x3a, 0xf1, 0x8d, 0x0, 0x1, 0xf4,
    0x8d, 0x0, 0x1, 0xf4, 0x8e, 0x33, 0x4a, 0xf1,
    0x8f, 0xff, 0xfd, 0x50,

    /* U+044E "ю" */
    0x8d, 0x0, 0x7, 0xdf, 0xe9, 0x10, 0x8d, 0x0,
    0x8e, 0x30, 0x2c, 0xc0, 0x8d, 0x0, 0xf6, 0x0,
    0x4, 0xf2, 0x8d, 0x13, 0xf4, 0x0, 0x1, 0xf5,
    0x8f, 0xff, 0xf3, 0x0, 0x0, 0xf6, 0x8d, 0x46,
    0xf4, 0x0, 0x1, 0xf5, 0x8d, 0x1, 0xf7, 0x0,
    0x5, 0xf2, 0x8d, 0x0, 0xaf, 0x63, 0x5d, 0xc0,
    0x8d, 0x0, 0x8, 0xdf, 0xe9, 0x10,

    /* U+044F "я" */
    0x4, 0xcf, 0xff, 0xe1, 0xfa, 0x32, 0x9e, 0x3f,
    0x30, 0x7, 0xe1, 0xf8, 0x0, 0x7e, 0x8, 0xff,
    0xff, 0xe0, 0xb, 0xc2, 0x9e, 0x5, 0xf2, 0x7,
    0xe0, 0xe9, 0x0, 0x7e, 0x9e, 0x0, 0x7, 0xe0,

    /* U+0452 "ђ" */
    0x3, 0x50, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xf5, 0x0, 0x1, 0x9d, 0x22,
    0x0, 0x0, 0x8, 0xd5, 0xdf, 0xe7, 0x0, 0x8f,
    0xd6, 0x49, 0xf3, 0x8, 0xf1, 0x0, 0xf, 0x70,
    0x8d, 0x0, 0x0, 0xe8, 0x8, 0xd0, 0x0, 0xe,
    0x80, 0x8d, 0x0, 0x0, 0xe8, 0x8, 0xd0, 0x0,
    0xe, 0x80, 0x8d, 0x0, 0x0, 0xe8, 0x8, 0xd0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x12, 0x6f, 0x30, 0x0, 0x6, 0xfe, 0x80,

    /* U+0456 "і" */
    0x9d, 0x58, 0x0, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d,
    0x8d, 0x8d, 0x8d, 0x8d,

    /* U+0457 "ї" */
    0xe, 0x73, 0xf4, 0x9, 0x41, 0xa2, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x8d, 0x0,

    /* U+0458 "ј" */
    0x0, 0x5, 0x80, 0x0, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0,
    0x8, 0xd0, 0x0, 0x8d, 0x0, 0x8, 0xd0, 0x0,
    0x8d, 0x0, 0x8, 0xd0, 0x0, 0x8d, 0x0, 0x8,
    0xd0, 0x0, 0x9c, 0x3, 0x4e, 0x81, 0xff, 0xb1,

    /* U+0459 "љ" */
    0x0, 0x6f, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0x22, 0x8f, 0x0, 0x0, 0x0, 0x0, 0x9c,
    0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0xba, 0x0,
    0x6f, 0xff, 0xfe, 0x70, 0x0, 0xd8, 0x0, 0x6f,
    0x33, 0x38, 0xf3, 0x0, 0xf6, 0x0, 0x6f, 0x0,
    0x0, 0xf6, 0x3, 0xf2, 0x0, 0x6f, 0x0, 0x0,
    0xe6, 0x2c, 0xc0, 0x0, 0x6f, 0x11, 0x17, 0xf3,
    0xcb, 0x10, 0x0, 0x6f, 0xff, 0xfd, 0x60,

    /* U+045A "њ" */
    0x8d, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x8d,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x8d, 0x0,
    0x0, 0x9d, 0x0, 0x0, 0x0, 0x8d, 0x11, 0x11,
    0x9f, 0xff, 0xfd, 0x50, 0x8f, 0xff, 0xff, 0xfd,
    0x33, 0x3a, 0xf1, 0x8d, 0x44, 0x44, 0xad, 0x0,
    0x1, 0xf4, 0x8d, 0x0, 0x0, 0x9d, 0x0, 0x1,
    0xf4, 0x8d, 0x0, 0x0, 0x9d, 0x33, 0x4a, 0xf1,
    0x8d, 0x0, 0x0, 0x9f, 0xff, 0xfd, 0x40,

    /* U+045B "ћ" */
    0x3, 0x50, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xf5, 0x0, 0x1, 0x9d, 0x22,
    0x0, 0x0, 0x8, 0xd5, 0xdf, 0xd7, 0x0, 0x8f,
    0xd6, 0x49, 0xf3, 0x8, 0xf1, 0x0, 0xf, 0x70,
    0x8d, 0x0, 0x0, 0xe8, 0x8, 0xd0, 0x0, 0xe,
    0x80, 0x8d, 0x0, 0x0, 0xe8, 0x8, 0xd0, 0x0,
    0xe, 0x80, 0x8d, 0x0, 0x0, 0xe8, 0x8, 0xd0,
    0x0, 0xe, 0x80,

    /* U+0E01 "ก" */
    0x1, 0xae, 0xff, 0xc4, 0x0, 0xcd, 0x42, 0x3b,
    0xf1, 0xf, 0x50, 0x0, 0x2f, 0x40, 0xde, 0xb2,
    0x1, 0xf5, 0x1, 0xbb, 0x20, 0x1f, 0x50, 0x7e,
    0x0, 0x1, 0xf5, 0x8, 0xd0, 0x0, 0x1f, 0x50,
    0x9d, 0x0, 0x1, 0xf5, 0x9, 0xd0, 0x0, 0x1f,
    0x50,

    /* U+0E02 "ข" */
    0xc, 0xcb, 0x1, 0xf4, 0x3d, 0xf, 0x21, 0xf4,
    0xa, 0xdf, 0x1, 0xf4, 0x0, 0xd7, 0x1, 0xf4,
    0x6, 0xe0, 0x1, 0xf4, 0x8, 0xd0, 0x1, 0xf4,
    0x8, 0xd0, 0x2, 0xf4, 0x6, 0xf6, 0x39, 0xf1,
    0x0, 0x9e, 0xfd, 0x60,

    /* U+0E04 "ค" */
    0x5, 0xcf, 0xfd, 0x70, 0x3f, 0x93, 0x26, 0xf7,
    0x8d, 0x0, 0x0, 0xac, 0x9b, 0xa, 0xc6, 0x7e,
    0x9b, 0x8c, 0x2c, 0x7e, 0x9c, 0xea, 0xc5, 0x7e,
    0x9f, 0x90, 0x0, 0x7e, 0x9f, 0x10, 0x0, 0x7e,
    0x9c, 0x0, 0x0, 0x7e,

    /* U+0E07 "ง" */
    0x0, 0x7, 0xed, 0x13, 0x30, 0xc2, 0xb6, 0x8e,
    0x5, 0xcf, 0x72, 0xf4, 0x0, 0xf7, 0xc, 0xa0,
    0xf, 0x70, 0x6f, 0x0, 0xf7, 0x1, 0xf5, 0xf,
    0x70, 0xa, 0xb1, 0xf7, 0x0, 0x4f, 0xff, 0x70,

    /* U+0E08 "จ" */
    0x2b, 0xef, 0xeb, 0x20, 0x27, 0x42, 0x4c, 0xe0,
    0x0, 0x0, 0x3, 0xf3, 0xb, 0xd6, 0x1, 0xf5,
    0x3d, 0x2e, 0x3, 0xf3, 0xa, 0xcf, 0x2a, 0xd0,
    0x0, 0xf, 0xde, 0x30, 0x0, 0xc, 0xc1, 0x0,
    0x0, 0x8, 0xc0, 0x0,

    /* U+0E09 "ฉ" */
    0xa, 0xdf, 0xfd, 0x70, 0x0, 0x84, 0x33, 0x7f,
    0x80, 0x0, 0x0, 0x0, 0x9d, 0x4, 0xdb, 0x10,
    0x7, 0xe0, 0xa5, 0xb5, 0x0, 0x7e, 0x4, 0xcf,
    0x60, 0xc, 0xa0, 0x0, 0xe7, 0x5c, 0xfc, 0x20,
    0xe, 0xea, 0xc7, 0x79, 0x0, 0xe6, 0x4, 0xdd,
    0x40,

    /* U+0E0A "ช" */
    0xc, 0xdb, 0x0, 0xab, 0x3d, 0xf, 0x20, 0xd8,
    0x8, 0xdf, 0x2f, 0xd0, 0x0, 0xe7, 0x4, 0xf4,
    0x6, 0xe0, 0x0, 0xe7, 0x8, 0xd0, 0x0, 0xe7,
    0x8, 0xe0, 0x0, 0xf6, 0x5, 0xf6, 0x37, 0xf4,
    0x0, 0x9e, 0xfe, 0x70,

    /* U+0E0B "ซ" */
    0x4d, 0xc3, 0xf0, 0x7e, 0x95, 0xaa, 0xf0, 0x9d,
    0x3d, 0xcd, 0xc8, 0xf5, 0x0, 0xad, 0x21, 0xd6,
    0x6, 0xf1, 0x0, 0xba, 0x8, 0xd0, 0x0, 0xba,
    0x7, 0xe0, 0x0, 0xc9, 0x5, 0xf7, 0x36, 0xf7,
    0x0, 0x8e, 0xfe, 0x90,

    /* U+0E13 "ณ" */
    0x2, 0xae, 0xfe, 0xb3, 0x0, 0xa, 0xb0, 0xc,
    0xc4, 0x23, 0xce, 0x0, 0xa, 0xb0, 0xf, 0x50,
    0x0, 0x3f, 0x20, 0xa, 0xb0, 0xb, 0xec, 0x30,
    0x2f, 0x30, 0xa, 0xb0, 0x1, 0xca, 0x10, 0x2f,
    0x30, 0xb, 0xa0, 0x8, 0xd0, 0x0, 0x2f, 0x30,
    0x1f, 0x60, 0x9, 0xeb, 0x30, 0x2f, 0x68, 0xee,
    0xc2, 0x9, 0x75, 0x90, 0x2f, 0xd8, 0xe2, 0xa6,
    0x4, 0xdd, 0x40, 0x2f, 0x30, 0x7d, 0xd2,

    /* U+0E14 "ด" */
    0x5, 0xcf, 0xfd, 0x70, 0x3f, 0x93, 0x26, 0xf7,
    0x8e, 0x0, 0x0, 0xac, 0x9b, 0x1c, 0xd4, 0x7e,
    0x9b, 0x69, 0x5a, 0x7e, 0x9b, 0x2b, 0xe6, 0x7e,
    0x9b, 0xb, 0x90, 0x7e, 0x9b, 0xba, 0x0, 0x7e,
    0x9f, 0xa0, 0x0, 0x7e,

    /* U+0E15 "ต" */
    0x9, 0xe9, 0x5e, 0xc2, 0x5f, 0x5a, 0xe5, 0xdb,
    0x9c, 0x0, 0x0, 0x7e, 0x9b, 0x1c, 0xd4, 0x6f,
    0x9b, 0x5a, 0x4b, 0x6f, 0x9b, 0x1c, 0xf7, 0x6f,
    0x9b, 0xb, 0xa0, 0x6f, 0x9c, 0xbb, 0x0, 0x6f,
    0x9f, 0xa0, 0x0, 0x6f,

    /* U+0E16 "ถ" */
    0x1, 0xae, 0xff, 0xc4, 0x0, 0xcd, 0x42, 0x3a,
    0xf2, 0xf, 0x50, 0x0, 0xf, 0x50, 0xbe, 0xd3,
    0x0, 0xf6, 0x1, 0xd9, 0x10, 0xf, 0x60, 0x8c,
    0x0, 0x0, 0xf6, 0x9, 0xfc, 0x30, 0xf, 0x60,
    0x97, 0x59, 0x0, 0xf6, 0x4, 0xcc, 0x40, 0xf,
    0x60,

    /* U+0E17 "ท" */
    0x6d, 0xd2, 0x5, 0xde, 0x4b, 0x3a, 0x63, 0xf5,
    0xda, 0x5c, 0xf8, 0xe5, 0xa, 0xb0, 0xd, 0xf9,
    0x0, 0xab, 0x0, 0xdd, 0x0, 0xa, 0xb0, 0xd,
    0x80, 0x0, 0xab, 0x0, 0xd8, 0x0, 0xa, 0xb0,
    0xd, 0x80, 0x0, 0xab, 0x0, 0xd8, 0x0, 0xa,
    0xb0,

    /* U+0E19 "น" */
    0x6e, 0xd2, 0x0, 0x2f, 0x40, 0xb4, 0xa7, 0x0,
    0x2f, 0x40, 0x5c, 0xf8, 0x0, 0x2f, 0x40, 0x0,
    0xd8, 0x0, 0x2f, 0x40, 0x0, 0xd8, 0x0, 0x2f,
    0x30, 0x0, 0xd8, 0x0, 0x7f, 0x0, 0x0, 0xd8,
    0x4a, 0xfe, 0x70, 0x0, 0xdf, 0xca, 0xb1, 0xf0,
    0x0, 0xd8, 0x1, 0xdd, 0x90,

    /* U+0E1A "บ" */
    0x7c, 0xc2, 0x0, 0xb, 0xac, 0x3a, 0x60, 0x0,
    0xba, 0x5c, 0xf7, 0x0, 0xb, 0xa0, 0xe, 0x70,
    0x0, 0xba, 0x0, 0xe7, 0x0, 0xb, 0xa0, 0xe,
    0x70, 0x0, 0xba, 0x0, 0xe8, 0x0, 0xd, 0x90,
    0xa, 0xe5, 0x37, 0xf5, 0x0, 0x1a, 0xef, 0xe8,
    0x0,

    /* U+0E1B "ป" */
    0x0, 0x0, 0x0, 0xb, 0xa0, 0x0, 0x0, 0x0,
    0xba, 0x0, 0x0, 0x0, 0xb, 0xa7, 0xed, 0x20,
    0x0, 0xba, 0xc3, 0xb6, 0x0, 0xb, 0xa5, 0xcf,
    0x70, 0x0, 0xba, 0x0, 0xe7, 0x0, 0xb, 0xa0,
    0xe, 0x70, 0x0, 0xba, 0x0, 0xe7, 0x0, 0xb,
    0xa0, 0xe, 0x80, 0x0, 0xd9, 0x0, 0xae, 0x53,
    0x7f, 0x50, 0x1, 0xae, 0xfe, 0x80,

    /* U+0E1C "ผ" */
    0x3d, 0xc4, 0x0, 0x9b, 0x88, 0x5a, 0x0, 0x9b,
    0x9f, 0xc3, 0x0, 0x9b, 0x9b, 0x0, 0x0, 0x9b,
    0x9b, 0x3, 0x40, 0x9b, 0x9b, 0x1f, 0xf3, 0x9b,
    0x9b, 0xa9, 0x6c, 0x9b, 0x9e, 0xe1, 0xd, 0xeb,
    0x9f, 0x70, 0x4, 0xfb,

    /* U+0E1E "พ" */
    0x6c, 0xc2, 0x6, 0x50, 0x9b, 0xb3, 0x97, 0xf,
    0xe0, 0x9b, 0x5c, 0xf7, 0x5d, 0xe3, 0x9b, 0x0,
    0xd7, 0x98, 0xa8, 0x9b, 0x0, 0xd7, 0xe3, 0x5c,
    0x9b, 0x0, 0xda, 0xe0, 0x1f, 0xab, 0x0, 0xdf,
    0xa0, 0xc, 0xfb, 0x0, 0xdf, 0x50, 0x7, 0xfb,
    0x0, 0xdf, 0x10, 0x2, 0xfb,

    /* U+0E1F "ฟ" */
    0x0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0,
    0x0, 0x9b, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x6e,
    0xd2, 0x4, 0x40, 0x9b, 0xb3, 0xa7, 0xf, 0xe0,
    0x9b, 0x5c, 0xf7, 0x4d, 0xe3, 0x9b, 0x0, 0xd7,
    0x98, 0xa7, 0x9b, 0x0, 0xd7, 0xe3, 0x5c, 0x9b,
    0x0, 0xda, 0xe0, 0x1f, 0xab, 0x0, 0xdf, 0xa0,
    0xc, 0xfb, 0x0, 0xdf, 0x50, 0x7, 0xfb, 0x0,
    0xdf, 0x10, 0x2, 0xfb,

    /* U+0E20 "ภ" */
    0x0, 0x6c, 0xff, 0xe9, 0x0, 0x4f, 0x73, 0x26,
    0xf9, 0x8, 0xd0, 0x0, 0x9, 0xd0, 0x5c, 0xea,
    0x0, 0x8d, 0x0, 0x5e, 0x60, 0x8, 0xd0, 0xc,
    0x90, 0x0, 0x8d, 0x3c, 0xf8, 0x0, 0x8, 0xda,
    0x58, 0x80, 0x0, 0x8d, 0x5c, 0xc2, 0x0, 0x8,
    0xd0,

    /* U+0E21 "ม" */
    0x1c, 0xc8, 0x0, 0xe, 0x74, 0xa2, 0xe0, 0x0,
    0xe7, 0xb, 0xef, 0x0, 0xe, 0x70, 0x6, 0xf0,
    0x0, 0xe7, 0x0, 0x6f, 0x0, 0xe, 0x70, 0x6,
    0xf0, 0x0, 0xe7, 0x9, 0xef, 0xda, 0x4e, 0x72,
    0xe0, 0xe4, 0x6d, 0xf7, 0xb, 0xbb, 0x0, 0xe,
    0x70,

    /* U+0E22 "ย" */
    0x6c, 0xc2, 0x7, 0xee, 0x48, 0x70, 0x7e, 0xed,
    0xb2, 0x7, 0xe9, 0xc2, 0x0, 0x7e, 0xb, 0xff,
    0x47, 0xe6, 0xf5, 0x20, 0x7e, 0xbb, 0x0, 0x8,
    0xe8, 0xf5, 0x25, 0xf9, 0x9, 0xef, 0xea, 0x10,

    /* U+0E23 "ร" */
    0x9, 0xef, 0xff, 0x74, 0xf4, 0x22, 0x20, 0x6f,
    0x63, 0x0, 0x3, 0x9c, 0xfe, 0x40, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x1b, 0xed,
    0x0, 0x6, 0x94, 0xd0, 0x0, 0x2d, 0xe6, 0x0,

    /* U+0E25 "ล" */
    0x1, 0xcf, 0xfe, 0xa1, 0x0, 0x52, 0x24, 0xda,
    0x0, 0x0, 0x0, 0x7e, 0x2, 0xbe, 0xe9, 0x8e,
    0xc, 0xc3, 0x38, 0xfe, 0xf, 0x50, 0x0, 0x9e,
    0x1f, 0xdb, 0x10, 0x7e, 0xf, 0x49, 0x60, 0x7e,
    0x6, 0xcc, 0x20, 0x7e,

    /* U+0E27 "ว" */
    0x8e, 0xfe, 0x80, 0x43, 0x27, 0xf4, 0x0, 0x0,
    0xe7, 0x0, 0x0, 0xe8, 0x0, 0x0, 0xe8, 0x0,
    0x0, 0xe8, 0x0, 0x5c, 0xf8, 0x0, 0xb4, 0x97,
    0x0, 0x6d, 0xd2,

    /* U+0E2A "ส" */
    0x0, 0x0, 0x0, 0x4, 0x30, 0x1c, 0xff, 0xea,
    0xf4, 0x0, 0x52, 0x24, 0xeb, 0x0, 0x0, 0x0,
    0x8, 0xe0, 0x2, 0xbe, 0xe9, 0x8e, 0x0, 0xcc,
    0x33, 0x7f, 0xe0, 0xf, 0x50, 0x0, 0x9e, 0x1,
    0xfd, 0xb1, 0x7, 0xe0, 0xf, 0x49, 0x60, 0x7e,
    0x0, 0x6c, 0xc2, 0x7, 0xe0,

    /* U+0E2B "ห" */
    0x6d, 0xd2, 0x5, 0xdd, 0x4b, 0x49, 0x70, 0xa5,
    0x69, 0x5c, 0xf8, 0x6, 0xff, 0x40, 0xd, 0x81,
    0xd9, 0xf5, 0x0, 0xd8, 0xca, 0xe, 0x70, 0xd,
    0xfb, 0x0, 0xe8, 0x0, 0xdd, 0x10, 0xe, 0x80,
    0xd, 0x80, 0x0, 0xe8, 0x0, 0xd8, 0x0, 0xe,
    0x80,

    /* U+0E2D "อ" */
    0x7d, 0xef, 0xd8, 0x0, 0x65, 0x33, 0x6e, 0xa0,
    0x0, 0x0, 0x7, 0xf0, 0x4c, 0xc2, 0x5, 0xf0,
    0xb5, 0x87, 0x5, 0xf0, 0xbe, 0xb2, 0x5, 0xf0,
    0xba, 0x0, 0x6, 0xf0, 0x7f, 0x52, 0x4d, 0xb0,
    0x8, 0xdf, 0xfb, 0x10,

    /* U+0E2E "ฮ" */
    0x0, 0x0, 0x0, 0x66, 0x7, 0xde, 0xfd, 0x9f,
    0x50, 0x65, 0x33, 0x6f, 0xc0, 0x0, 0x0, 0x0,
    0x7f, 0x0, 0x4c, 0xc2, 0x5, 0xf0, 0xb, 0x58,
    0x70, 0x5f, 0x0, 0xbe, 0xb2, 0x5, 0xf0, 0xb,
    0xa0, 0x0, 0x6f, 0x0, 0x7f, 0x52, 0x4d, 0xb0,
    0x0, 0x8d, 0xff, 0xb1, 0x0,

    /* U+0E30 "ะ" */
    0x1b, 0xb1, 0x0, 0x58, 0x84, 0x1, 0x1c, 0xff,
    0xf7, 0x0, 0x11, 0x0, 0x1b, 0xb1, 0x0, 0x68,
    0x84, 0x1, 0x1c, 0xff, 0xf7, 0x0, 0x1, 0x0,

    /* U+0E31 "ั" */
    0x7b, 0x70, 0x0, 0xd, 0x1c, 0x1, 0x32, 0x5d,
    0xff, 0xfc, 0x40,

    /* U+0E32 "า" */
    0xaf, 0xfc, 0x23, 0x23, 0xea, 0x0, 0x9, 0xc0,
    0x0, 0x9d, 0x0, 0x9, 0xd0, 0x0, 0x9d, 0x0,
    0x9, 0xd0, 0x0, 0x9d, 0x0, 0x9, 0xd0,

    /* U+0E33 "ำ" */
    0xa, 0xd9, 0x0, 0x0, 0x0, 0x3d, 0xf, 0x0,
    0x0, 0x0, 0xa, 0xd9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xff,
    0xc2, 0x0, 0x0, 0x3, 0x23, 0xea, 0x0, 0x0,
    0x0, 0x0, 0x9c, 0x0, 0x0, 0x0, 0x0, 0x9d,
    0x0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x0, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x0,
    0x9d,

    /* U+0E34 "ิ" */
    0x6, 0xdd, 0xa5, 0x0, 0xf, 0x30, 0x29, 0xc3,
    0x2e, 0xdd, 0xdd, 0xe9,

    /* U+0E35 "ี" */
    0x6, 0xef, 0xb4, 0x99, 0x1f, 0x40, 0x3a, 0xfa,
    0x2e, 0xdd, 0xdd, 0xe9,

    /* U+0E36 "ึ" */
    0x5, 0xbb, 0x85, 0xb9, 0x0, 0xf3, 0x3, 0xd3,
    0xd1, 0x2f, 0xee, 0xee, 0xe9, 0x0,

    /* U+0E37 "ื" */
    0x6, 0xee, 0x9e, 0x89, 0x1f, 0x40, 0x4c, 0xca,
    0x2e, 0xdd, 0xdd, 0xe9,

    /* U+0E38 "ุ" */
    0x8, 0xb3, 0xd, 0x59, 0x8, 0xda, 0x0, 0x77,

    /* U+0E39 "ู" */
    0x38, 0x70, 0x77, 0x49, 0xf0, 0xa9, 0x0, 0xbe,
    0xd4,

    /* U+0E40 "เ" */
    0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0, 0x8d, 0x0,
    0x8d, 0x0, 0x8d, 0x0, 0x8f, 0xc4, 0x79, 0x4b,
    0x2d, 0xe6,

    /* U+0E41 "แ" */
    0x8d, 0x0, 0xd, 0x90, 0x8, 0xd0, 0x0, 0xd9,
    0x0, 0x8d, 0x0, 0xd, 0x90, 0x8, 0xd0, 0x0,
    0xd9, 0x0, 0x8d, 0x0, 0xd, 0x90, 0x8, 0xd0,
    0x0, 0xd9, 0x0, 0x8f, 0xc4, 0xd, 0xeb, 0x17,
    0x94, 0xb0, 0xc4, 0x96, 0x2d, 0xe6, 0x6, 0xed,
    0x20,

    /* U+0E42 "โ" */
    0x6, 0xef, 0xff, 0xb0, 0xf7, 0x11, 0x11, 0x2f,
    0xb5, 0x0, 0x0, 0x38, 0xf4, 0x0, 0x0, 0xd,
    0x80, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xc, 0x90,
    0x0, 0x0, 0xc9, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0xc9, 0x0, 0x0, 0xc, 0x90, 0x0, 0x0,
    0xce, 0xb2, 0x0, 0xc, 0x58, 0x70, 0x0, 0x5e,
    0xd2,

    /* U+0E43 "ใ" */
    0x3, 0xcf, 0xe9, 0x0, 0xed, 0x63, 0xe6, 0x1d,
    0x2b, 0xd, 0x80, 0x9b, 0x59, 0xf2, 0x0, 0x8,
    0xf3, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xc, 0x90,
    0x0, 0x0, 0xc9, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0xc9, 0x0, 0x0, 0xc, 0x90, 0x0, 0x0,
    0xce, 0xb2, 0x0, 0xc, 0x58, 0x70, 0x0, 0x6e,
    0xd2,

    /* U+0E44 "ไ" */
    0xa2, 0x3d, 0xb0, 0x7f, 0xf7, 0xf5, 0x3, 0x22,
    0xf4, 0x0, 0x2d, 0xb0, 0x0, 0xbc, 0x0, 0x0,
    0xc9, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xc9, 0x0,
    0x0, 0xc9, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xc9,
    0x0, 0x0, 0xce, 0xb2, 0x0, 0xc5, 0x87, 0x0,
    0x6e, 0xd2,

    /* U+0E47 "็" */
    0x1b, 0xee, 0xee, 0x16, 0xc1, 0x8, 0x90, 0x6d,
    0x87, 0xa9, 0x21, 0xbb, 0xae, 0xb0,

    /* U+0E48 "่" */
    0x86, 0xb9, 0xb9,

    /* U+0E49 "้" */
    0x2a, 0x90, 0x0, 0x19, 0xe1, 0x25, 0x2b, 0xff,
    0xe9,

    /* U+0E4C "์" */
    0x0, 0x0, 0x14, 0xce, 0xd6, 0xc2, 0xd0, 0x6,
    0xc7, 0x0,

    /* U+1EA1 "ạ" */
    0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0, 0x53, 0x4c,
    0xf1, 0x0, 0x0, 0x0, 0x2f, 0x40, 0x0, 0x0,
    0x1, 0xf5, 0x2, 0xae, 0xff, 0xff, 0x50, 0xdc,
    0x42, 0x23, 0xf5, 0x1f, 0x50, 0x0, 0x2f, 0x50,
    0xea, 0x11, 0x4c, 0xf5, 0x3, 0xcf, 0xfb, 0x3e,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x85,
    0x0, 0x0, 0x0, 0xd, 0x90, 0x0,

    /* U+1EA3 "ả" */
    0x0, 0x4, 0xdd, 0x90, 0x0, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x0, 0x8c, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0,
    0x53, 0x4c, 0xf1, 0x0, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0x1, 0xf5, 0x2, 0xae, 0xff, 0xff,
    0x50, 0xdc, 0x42, 0x23, 0xf5, 0x1f, 0x50, 0x0,
    0x2f, 0x50, 0xea, 0x11, 0x4c, 0xf5, 0x3, 0xcf,
    0xfb, 0x3e, 0x50,

    /* U+1EA5 "ấ" */
    0x0, 0x0, 0x0, 0x6, 0xd1, 0x0, 0x0, 0x0,
    0xc, 0x50, 0x0, 0x3, 0xc9, 0x70, 0x0, 0x0,
    0x1b, 0x10, 0x94, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xff, 0xc4, 0x0, 0x0, 0x5,
    0x34, 0xcf, 0x10, 0x0, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0x0, 0x1f, 0x50, 0x2, 0xae, 0xff,
    0xff, 0x50, 0xd, 0xc4, 0x22, 0x3f, 0x50, 0x1f,
    0x50, 0x0, 0x2f, 0x50, 0xe, 0xa1, 0x14, 0xcf,
    0x50, 0x3, 0xcf, 0xfb, 0x3e, 0x50,

    /* U+1EA7 "ầ" */
    0x9, 0xb0, 0x0, 0x0, 0x0, 0x1e, 0x20, 0x0,
    0x0, 0x0, 0x3, 0xc9, 0x80, 0x0, 0x1, 0xa2,
    0x9, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10,
    0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22,
    0x3f, 0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1,
    0x14, 0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+1EAD "ậ" */
    0x0, 0x2, 0xff, 0x70, 0x0, 0x1, 0xd6, 0x2d,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10, 0x0,
    0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f, 0x50,
    0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22, 0x3f,
    0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1, 0x14,
    0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0x50, 0x0, 0x0,
    0x0, 0xd9, 0x0, 0x0,

    /* U+1EAF "ắ" */
    0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x3, 0x60,
    0x0, 0x0, 0x3f, 0x30, 0xc8, 0x0, 0x0, 0x8f,
    0xfc, 0x10, 0x0, 0x0, 0x1, 0x0, 0x0, 0x1,
    0xef, 0xfc, 0x40, 0x0, 0x5, 0x34, 0xcf, 0x10,
    0x0, 0x0, 0x2, 0xf4, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x2a, 0xef, 0xff, 0xf5, 0xd, 0xc4, 0x22,
    0x3f, 0x51, 0xf5, 0x0, 0x2, 0xf5, 0xe, 0xa1,
    0x14, 0xcf, 0x50, 0x3c, 0xff, 0xb3, 0xe5,

    /* U+1EBB "ẻ" */
    0x0, 0xb, 0xdc, 0x20, 0x0, 0x0, 0x0, 0x97,
    0x0, 0x0, 0x1, 0xf9, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6d, 0xff, 0xb2, 0x0, 0x6f,
    0x73, 0x3c, 0xc0, 0xd, 0xa0, 0x0, 0x2f, 0x20,
    0xf7, 0x12, 0x35, 0xf4, 0xf, 0xed, 0xdd, 0xdd,
    0x30, 0xf7, 0x0, 0x0, 0x0, 0xc, 0xb0, 0x0,
    0x0, 0x0, 0x6f, 0x95, 0x46, 0x90, 0x0, 0x6d,
    0xff, 0xd8, 0x0,

    /* U+1EBD "ẽ" */
    0xa, 0xf9, 0x17, 0x90, 0x3e, 0x3b, 0xff, 0x40,
    0x1, 0x0, 0x11, 0x0, 0x8f, 0xff, 0xff, 0xa0,
    0x8f, 0x55, 0x55, 0x30, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff, 0x50,
    0x8e, 0x33, 0x33, 0x10, 0x8e, 0x0, 0x0, 0x0,
    0x8e, 0x0, 0x0, 0x0, 0x8e, 0x0, 0x0, 0x0,
    0x8f, 0x55, 0x55, 0x50, 0x8f, 0xff, 0xff, 0xf0,

    /* U+1EBF "ế" */
    0x0, 0x0, 0x0, 0x1, 0x84, 0x0, 0x0, 0x0,
    0x9, 0xd0, 0x0, 0xa, 0xfd, 0x3e, 0x20, 0x0,
    0x7c, 0x19, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0xff, 0xb2, 0x0, 0x6, 0xf7,
    0x33, 0xcc, 0x0, 0xd, 0xa0, 0x0, 0x2f, 0x20,
    0xf, 0x71, 0x23, 0x5f, 0x40, 0xf, 0xed, 0xdd,
    0xdd, 0x30, 0xf, 0x70, 0x0, 0x0, 0x0, 0xc,
    0xb0, 0x0, 0x0, 0x0, 0x6, 0xfa, 0x54, 0x69,
    0x0, 0x0, 0x6d, 0xff, 0xd8, 0x0,

    /* U+1EC3 "ể" */
    0x0, 0x0, 0x0, 0xbd, 0x70, 0x0, 0x0, 0x0,
    0x2e, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0xb8,
    0xc2, 0x10, 0x0, 0x77, 0x4, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xb2, 0x0,
    0x6f, 0x73, 0x3c, 0xc0, 0xd, 0xa0, 0x0, 0x2f,
    0x20, 0xf7, 0x12, 0x35, 0xf4, 0xf, 0xed, 0xdd,
    0xdd, 0x30, 0xf7, 0x0, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0x0, 0x0, 0x6f, 0x95, 0x46, 0x90, 0x0,
    0x6d, 0xff, 0xd8, 0x0,

    /* U+1EC7 "ệ" */
    0x0, 0xa, 0xfd, 0x0, 0x0, 0x7, 0xc1, 0x9b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfb, 0x20, 0x6, 0xf7, 0x33, 0xcc, 0x0, 0xda,
    0x0, 0x2, 0xf2, 0xf, 0x71, 0x23, 0x5f, 0x40,
    0xfe, 0xdd, 0xdd, 0xd3, 0xf, 0x70, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x0, 0x6, 0xf9, 0x54,
    0x69, 0x0, 0x6, 0xdf, 0xfd, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x19, 0x30, 0x0, 0x0,
    0x2, 0xf5, 0x0, 0x0,

    /* U+1ECB "ị" */
    0x9d, 0x58, 0x0, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d,
    0x8d, 0x8d, 0x8d, 0x8d, 0x0, 0x58, 0x9d,

    /* U+1ED1 "ố" */
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0xe, 0x20, 0x0, 0x6, 0xac, 0x40, 0x0, 0x0,
    0x3a, 0x1, 0xa1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0xff, 0xc5, 0x0, 0x6, 0xf7,
    0x33, 0x9f, 0x40, 0xc, 0xa0, 0x0, 0xd, 0xa0,
    0xf, 0x70, 0x0, 0x9, 0xd0, 0xf, 0x60, 0x0,
    0x8, 0xe0, 0xf, 0x70, 0x0, 0x9, 0xd0, 0xc,
    0xb0, 0x0, 0xc, 0xa0, 0x6, 0xf8, 0x33, 0x9f,
    0x40, 0x0, 0x6d, 0xff, 0xc5, 0x0,

    /* U+1ED3 "ồ" */
    0xc, 0x80, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xac, 0x40, 0x0, 0x2, 0xa0,
    0x1a, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xdf, 0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40,
    0xca, 0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0,
    0x9, 0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8,
    0x33, 0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50,

    /* U+1ED7 "ỗ" */
    0x0, 0x4e, 0xb2, 0x98, 0x0, 0xa, 0x74, 0xdd,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xf3, 0x0, 0x0, 0x3e, 0x34, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6d, 0xff, 0xc5, 0x0,
    0x6f, 0x73, 0x39, 0xf4, 0xc, 0xa0, 0x0, 0xd,
    0xa0, 0xf7, 0x0, 0x0, 0x9d, 0xf, 0x60, 0x0,
    0x8, 0xe0, 0xf7, 0x0, 0x0, 0x9d, 0xc, 0xb0,
    0x0, 0xc, 0xa0, 0x6f, 0x83, 0x39, 0xf4, 0x0,
    0x6d, 0xff, 0xc5, 0x0,

    /* U+1ED9 "ộ" */
    0x0, 0x5, 0xff, 0x30, 0x0, 0x3, 0xe3, 0x4d,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0xfc, 0x50, 0x6, 0xf7, 0x33, 0x9f, 0x40, 0xca,
    0x0, 0x0, 0xda, 0xf, 0x70, 0x0, 0x9, 0xd0,
    0xf6, 0x0, 0x0, 0x8e, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0xcb, 0x0, 0x0, 0xca, 0x6, 0xf8, 0x33,
    0x9f, 0x40, 0x6, 0xdf, 0xfc, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x60, 0x0, 0x0,
    0x0, 0xca, 0x0, 0x0,

    /* U+1EDB "ớ" */
    0x0, 0x0, 0xb, 0xc0, 0x0, 0x0, 0x0, 0x6,
    0xd1, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x10, 0x6, 0xdf, 0xfc, 0x56, 0xf0, 0x6, 0xf7,
    0x33, 0x9f, 0xf8, 0x0, 0xca, 0x0, 0x0, 0xda,
    0x0, 0xf, 0x70, 0x0, 0x9, 0xd0, 0x0, 0xf6,
    0x0, 0x0, 0x8e, 0x0, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0x0, 0xcb, 0x0, 0x0, 0xca, 0x0, 0x6,
    0xf8, 0x33, 0x9f, 0x40, 0x0, 0x6, 0xdf, 0xfc,
    0x50, 0x0,

    /* U+1EDD "ờ" */
    0x0, 0x1d, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0x60, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x10, 0x6, 0xdf, 0xfc, 0x56, 0xf0, 0x6, 0xf7,
    0x33, 0x9f, 0xf8, 0x0, 0xca, 0x0, 0x0, 0xda,
    0x0, 0xf, 0x70, 0x0, 0x9, 0xd0, 0x0, 0xf6,
    0x0, 0x0, 0x8e, 0x0, 0xf, 0x70, 0x0, 0x9,
    0xd0, 0x0, 0xcb, 0x0, 0x0, 0xca, 0x0, 0x6,
    0xf8, 0x33, 0x9f, 0x40, 0x0, 0x6, 0xdf, 0xfc,
    0x50, 0x0,

    /* U+1EDF "ở" */
    0x0, 0x7, 0xdd, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x3d, 0x0, 0x0, 0x0, 0x0, 0xbb, 0x30, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xf1, 0x0, 0x6d,
    0xff, 0xc5, 0x6f, 0x0, 0x6f, 0x73, 0x39, 0xff,
    0x80, 0xc, 0xa0, 0x0, 0xd, 0xa0, 0x0, 0xf7,
    0x0, 0x0, 0x9d, 0x0, 0xf, 0x60, 0x0, 0x8,
    0xe0, 0x0, 0xf7, 0x0, 0x0, 0x9d, 0x0, 0xc,
    0xb0, 0x0, 0xc, 0xa0, 0x0, 0x6f, 0x83, 0x39,
    0xf4, 0x0, 0x0, 0x6d, 0xff, 0xc5, 0x0, 0x0,

    /* U+1EE3 "ợ" */
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x10, 0x6, 0xdf,
    0xfc, 0x56, 0xf0, 0x6, 0xf7, 0x33, 0x9f, 0xf8,
    0x0, 0xca, 0x0, 0x0, 0xda, 0x0, 0xf, 0x70,
    0x0, 0x9, 0xd0, 0x0, 0xf6, 0x0, 0x0, 0x8e,
    0x0, 0xf, 0x70, 0x0, 0x9, 0xd0, 0x0, 0xcb,
    0x0, 0x0, 0xca, 0x0, 0x6, 0xf8, 0x33, 0x9f,
    0x40, 0x0, 0x6, 0xdf, 0xfc, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xbb, 0x0, 0x0, 0x0,

    /* U+1EE5 "ụ" */
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x8d, 0x0, 0x3, 0xf5, 0x5f, 0x51, 0x4c, 0xf5,
    0x8, 0xef, 0xd5, 0xe5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0x60, 0x0, 0x0, 0xd, 0xa0, 0x0,

    /* U+1EE7 "ủ" */
    0x0, 0x8d, 0xd5, 0x0, 0x0, 0x0, 0x5c, 0x0,
    0x0, 0xd, 0xa3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x9c, 0x0, 0x0, 0xf5, 0x9c, 0x0, 0x0, 0xf5,
    0x8d, 0x0, 0x3, 0xf5, 0x5f, 0x51, 0x4c, 0xf5,
    0x8, 0xef, 0xd5, 0xe5,

    /* U+1EED "ử" */
    0x0, 0x9d, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xb0, 0x0, 0x0, 0x0, 0xe, 0xa2, 0x0, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x9c, 0x0,
    0x0, 0xf5, 0x6f, 0x9, 0xc0, 0x0, 0xf, 0xff,
    0x80, 0x9c, 0x0, 0x0, 0xf5, 0x0, 0x9, 0xc0,
    0x0, 0xf, 0x50, 0x0, 0x9c, 0x0, 0x0, 0xf5,
    0x0, 0x9, 0xc0, 0x0, 0xf, 0x50, 0x0, 0x8d,
    0x0, 0x3, 0xf5, 0x0, 0x5, 0xf5, 0x13, 0xcf,
    0x50, 0x0, 0x8, 0xef, 0xd5, 0xe5, 0x0, 0x0,

    /* U+3001 "、" */
    0x0, 0x0, 0x0, 0xc7, 0x0, 0x3, 0xf7, 0x0,
    0x4, 0xf4, 0x0, 0x4, 0x0,

    /* U+3002 "。" */
    0x0, 0x0, 0x0, 0xa, 0xde, 0x70, 0x2d, 0x0,
    0xf0, 0x9, 0xee, 0x70,

    /* U+3044 "い" */
    0xd, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x50, 0x0, 0x0, 0x2a, 0x10, 0x0, 0xf, 0x40,
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x1f, 0x40, 0x0,
    0x0, 0x1, 0xea, 0x0, 0x1f, 0x30, 0x0, 0x0,
    0x0, 0x5f, 0x40, 0xf, 0x40, 0x0, 0x0, 0x0,
    0xb, 0xd0, 0xe, 0x60, 0x0, 0x0, 0x0, 0x3,
    0xf4, 0xc, 0x90, 0x0, 0xd3, 0x0, 0x0, 0xc7,
    0x8, 0xd0, 0x5, 0xf1, 0x0, 0x0, 0x10, 0x1,
    0xf9, 0x4e, 0x80, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0,

    /* U+3046 "う" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed,
    0x95, 0x42, 0x0, 0x0, 0x4, 0x8b, 0xdf, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x3, 0x54, 0x10, 0x0, 0x6, 0xbf, 0xfe, 0xff,
    0x60, 0xd, 0xe9, 0x30, 0x0, 0x9f, 0x10, 0x30,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x40, 0x0, 0x0, 0x0, 0x4, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0x0, 0x0, 0x2, 0xbf, 0x40, 0x0,
    0x0, 0x4c, 0xfb, 0x20, 0x0, 0x0, 0x2, 0x82,
    0x0, 0x0, 0x0,

    /* U+3048 "え" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x85, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x58, 0xbd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x13, 0x0, 0x0, 0x0, 0x78, 0x9b, 0xce, 0xff,
    0x0, 0x0, 0x0, 0xdc, 0xb9, 0x79, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xef, 0x30, 0x0, 0x0, 0x0, 0xa,
    0xe4, 0xd, 0x90, 0x0, 0x0, 0x0, 0xbe, 0x20,
    0x9, 0xd0, 0x0, 0x0, 0x1c, 0xe2, 0x0, 0x5,
    0xf6, 0x46, 0x96, 0x2c, 0x20, 0x0, 0x0, 0xaf,
    0xfd, 0xb5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+304A "お" */
    0x0, 0x0, 0x52, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe6, 0x0, 0x0, 0xd9, 0x10, 0x5, 0x56, 0xfc,
    0xcf, 0x60, 0x2b, 0xf4, 0xd, 0xdc, 0xfb, 0x74,
    0x0, 0x0, 0x69, 0x0, 0x0, 0xe5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe5, 0x1, 0x22, 0x0,
    0x0, 0x0, 0x0, 0xec, 0xdf, 0xee, 0xf9, 0x10,
    0x0, 0x2b, 0xfb, 0x40, 0x0, 0x3d, 0xa0, 0x4,
    0xf9, 0xe6, 0x0, 0x0, 0x5, 0xf0, 0x1e, 0x60,
    0xc7, 0x0, 0x0, 0x5, 0xf0, 0x6d, 0x0, 0xc7,
    0x0, 0x0, 0xc, 0xb0, 0x5f, 0x63, 0xe7, 0x1,
    0x68, 0xed, 0x10, 0x6, 0xcf, 0xe2, 0x0, 0xcb,
    0x60, 0x0,

    /* U+304B "か" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0xb4, 0x0, 0x37, 0x9c, 0xfe, 0xec,
    0x30, 0x8e, 0x10, 0x7b, 0x9d, 0xb3, 0x3b, 0xc0,
    0xd, 0x90, 0x0, 0xe, 0x50, 0x5, 0xf0, 0x5,
    0xf2, 0x0, 0x4f, 0x10, 0x4, 0xf0, 0x0, 0xe8,
    0x0, 0xab, 0x0, 0x5, 0xf0, 0x0, 0x9d, 0x0,
    0xf5, 0x0, 0x6, 0xe0, 0x0, 0x22, 0x7, 0xe0,
    0x0, 0x8, 0xd0, 0x0, 0x0, 0xe, 0x80, 0x0,
    0xc, 0x90, 0x0, 0x0, 0x6f, 0x11, 0x96, 0x8f,
    0x40, 0x0, 0x0, 0x87, 0x0, 0xac, 0xc6, 0x0,
    0x0, 0x0,

    /* U+304C "が" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0xa0,
    0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0xb5, 0xa5,
    0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 0x2d, 0x24,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0xb, 0x41, 0x0,
    0x4, 0x79, 0xdf, 0xee, 0xb2, 0x8, 0xe1, 0x0,
    0x9, 0xb8, 0xf9, 0x34, 0xda, 0x0, 0xd9, 0x0,
    0x0, 0x2, 0xf2, 0x0, 0x7d, 0x0, 0x5f, 0x20,
    0x0, 0x7, 0xe0, 0x0, 0x7e, 0x0, 0xe, 0x80,
    0x0, 0xc, 0x80, 0x0, 0x7d, 0x0, 0x9, 0xd0,
    0x0, 0x2f, 0x20, 0x0, 0x8c, 0x0, 0x2, 0x20,
    0x0, 0x9c, 0x0, 0x0, 0xba, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0x9, 0xd0, 0x39, 0x6a, 0xf1, 0x0, 0x0, 0x0,
    0xa, 0x50, 0x1a, 0xdc, 0x40, 0x0, 0x0, 0x0,

    /* U+304D "き" */
    0x0, 0x0, 0x12, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8d, 0x0, 0x2, 0x10, 0x2, 0x23, 0x4f, 0xba,
    0xdf, 0x50, 0xd, 0xfe, 0xdc, 0xf9, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xb9, 0x2, 0x71, 0x4, 0x44,
    0x56, 0xaf, 0xef, 0xb1, 0x1d, 0xdd, 0xcb, 0x9c,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf1, 0x0,
    0x0, 0x6c, 0xef, 0xda, 0xe7, 0x0, 0xb, 0xe6,
    0x32, 0x48, 0xeb, 0x0, 0xf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xfa, 0x64, 0x45, 0x70, 0x0, 0x0, 0x49,
    0xde, 0xff, 0xa0, 0x0,

    /* U+304F "く" */
    0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x1c,
    0xd0, 0x0, 0x0, 0x3e, 0xd2, 0x0, 0x0, 0x6f,
    0xa0, 0x0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0x9f,
    0x40, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x0, 0xc,
    0xe2, 0x0, 0x0, 0x0, 0x2d, 0xf5, 0x0, 0x0,
    0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x6, 0xfc,
    0x10, 0x0, 0x0, 0x3, 0xee, 0x20, 0x0, 0x0,
    0x2, 0xde, 0x30, 0x0, 0x0, 0x1, 0xe7, 0x0,
    0x0, 0x0, 0x1, 0x0,

    /* U+3053 "こ" */
    0x1, 0xca, 0x87, 0x76, 0x78, 0x30, 0x0, 0x8a,
    0xcc, 0xdd, 0xdc, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf9,
    0x42, 0x22, 0x35, 0x70, 0x0, 0x6c, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x1, 0x21, 0x10, 0x0,

    /* U+3055 "さ" */
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x1, 0x50, 0x11, 0x12, 0x35, 0xfc, 0xdf, 0xe1,
    0xbf, 0xff, 0xfd, 0xcf, 0x83, 0x0, 0x0, 0x10,
    0x0, 0xb, 0x80, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf1, 0x0, 0x0, 0x1, 0x23, 0x10, 0xc6, 0x0,
    0x2, 0xbf, 0xee, 0xfd, 0xcc, 0x0, 0xd, 0xb1,
    0x0, 0x4, 0xac, 0x0, 0x2f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xfa, 0x64, 0x34, 0x40, 0x0, 0x0, 0x49,
    0xde, 0xff, 0x80, 0x0,

    /* U+3057 "し" */
    0xd, 0x60, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xf, 0x50,
    0x0, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x30, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x41, 0x3f, 0x20, 0x0, 0x0,
    0xe, 0x72, 0xf3, 0x0, 0x0, 0x9, 0xe0, 0xf,
    0x70, 0x0, 0x8, 0xf4, 0x0, 0xaf, 0x85, 0x7d,
    0xf4, 0x0, 0x0, 0x9e, 0xfe, 0x92, 0x0, 0x0,

    /* U+3059 "す" */
    0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x12, 0x28, 0xe3, 0x33, 0x31, 0x7e, 0xff, 0xff,
    0xff, 0xfe, 0xee, 0xf5, 0x24, 0x33, 0x21, 0x4,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x5c, 0xca, 0xe0,
    0x0, 0x0, 0x0, 0x3, 0xf6, 0x4c, 0xe0, 0x0,
    0x0, 0x0, 0x7, 0xd0, 0x4, 0xf0, 0x0, 0x0,
    0x0, 0x7, 0xe1, 0x6, 0xf2, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0xde, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x37, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0x80, 0x0, 0x0, 0x0, 0x0, 0x37, 0xed,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xee, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+305B "せ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x24, 0x0, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0x0, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0x12, 0x34, 0x9f, 0x88, 0x91,
    0x8, 0xac, 0xef, 0xff, 0xfe, 0xef, 0xba, 0xa1,
    0x9, 0x86, 0xad, 0x10, 0x0, 0x5e, 0x0, 0x0,
    0x0, 0x0, 0x8d, 0x0, 0x0, 0x6d, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0x0, 0x43, 0xab, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x9f, 0xe4, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x60, 0x0, 0x0, 0x20, 0x0,
    0x0, 0x0, 0x9, 0xfe, 0xde, 0xef, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x35, 0x66, 0x54, 0x20, 0x0,

    /* U+305F "た" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9b, 0x0, 0x10, 0x0, 0x0, 0x14, 0x56, 0xdd,
    0xdf, 0x60, 0x0, 0x0, 0x4d, 0xdc, 0xfa, 0x52,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xf0, 0x2, 0x34,
    0x32, 0x10, 0x0, 0x9, 0xb0, 0x9, 0xfe, 0xff,
    0xb0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x22, 0x0, 0x0, 0x0, 0x1, 0xf5,
    0x0, 0xaa, 0x0, 0x0, 0x0, 0x8, 0xe0, 0x0,
    0xba, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x6f,
    0xa7, 0x67, 0x82, 0x2a, 0x0, 0x0, 0x4, 0xac,
    0xdd, 0xc3,

    /* U+3060 "だ" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0x0, 0x0, 0x34, 0xa0, 0x0, 0x0,
    0x9b, 0x0, 0x10, 0xb4, 0xb4, 0x14, 0x56, 0xdd,
    0xdf, 0x60, 0x2c, 0x22, 0x4d, 0xdc, 0xfa, 0x52,
    0x0, 0x1, 0x0, 0x0, 0x4, 0xf0, 0x2, 0x34,
    0x32, 0x10, 0x0, 0x9, 0xb0, 0x9, 0xfe, 0xff,
    0xb0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xac, 0x0, 0x22, 0x0, 0x0, 0x0, 0x1, 0xf5,
    0x0, 0xaa, 0x0, 0x0, 0x0, 0x8, 0xe0, 0x0,
    0xba, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x6f,
    0xa7, 0x67, 0x82, 0x2a, 0x0, 0x0, 0x4, 0xac,
    0xdd, 0xc3,

    /* U+3061 "ち" */
    0x0, 0x7, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xa0, 0x0, 0x2, 0x0, 0x34, 0x4c, 0xb7, 0xac,
    0xfb, 0x0, 0x9d, 0xdf, 0xca, 0x86, 0x30, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0x0, 0x1, 0x0, 0x0, 0x0, 0xc7, 0x7d, 0xff,
    0xfc, 0x30, 0x2, 0xff, 0xc5, 0x10, 0x2b, 0xe1,
    0xa, 0xf5, 0x0, 0x0, 0x0, 0xf6, 0x2, 0x30,
    0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x3, 0x43, 0x57, 0xcf, 0x60,
    0x0, 0x4, 0xff, 0xec, 0x82, 0x0,

    /* U+3063 "っ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x59,
    0xdf, 0xfd, 0x60, 0x2d, 0xfe, 0x95, 0x33, 0x7f,
    0x60, 0x73, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x50, 0x0,
    0x1, 0x36, 0xbf, 0x70, 0x0, 0x1, 0xff, 0xd9,
    0x20, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+3064 "つ" */
    0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0,
    0x1, 0x59, 0xdf, 0xff, 0xe6, 0x0, 0x27, 0xcf,
    0xfa, 0x63, 0x13, 0x9f, 0x70, 0x5e, 0xa5, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xee, 0x20, 0x0,
    0x0, 0x16, 0x8a, 0xef, 0xa1, 0x0, 0x0, 0x0,
    0x1d, 0xca, 0x61, 0x0, 0x0,

    /* U+3066 "て" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x0,
    0x13, 0x57, 0x9a, 0xce, 0xff, 0xf0, 0x6f, 0xff,
    0xec, 0xae, 0xf8, 0x31, 0x10, 0x24, 0x20, 0x0,
    0x9c, 0x10, 0x0, 0x0, 0x0, 0x0, 0x6, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xea, 0x74, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x7a, 0xc7, 0x0,

    /* U+3067 "で" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x20, 0x0,
    0x1, 0x35, 0x79, 0xac, 0xef, 0xff, 0x0, 0x6f,
    0xff, 0xec, 0xae, 0xf8, 0x31, 0x10, 0x2, 0x42,
    0x0, 0x9, 0xc1, 0x0, 0x19, 0x30, 0x0, 0x0,
    0x6, 0xe1, 0x0, 0x3c, 0x3d, 0x0, 0x0, 0x0,
    0xf5, 0x0, 0x0, 0x96, 0x60, 0x0, 0x0, 0x6e,
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x8, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xfe, 0xa7,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x2, 0x7a, 0xc7,
    0x0, 0x0,

    /* U+306A "な" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0x0, 0x0, 0x25, 0x56, 0xfd,
    0xd9, 0x2, 0xa3, 0x0, 0x6c, 0xcd, 0xf7, 0x41,
    0x2, 0x9f, 0xb1, 0x0, 0xa, 0xa0, 0x0, 0x0,
    0x1, 0xb5, 0x0, 0xf, 0x40, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0x7d, 0x0, 0x0, 0x6e, 0x0, 0x0,
    0x0, 0xe6, 0x0, 0x0, 0x5e, 0x0, 0x0, 0x8,
    0xd0, 0x0, 0x1, 0x5f, 0x0, 0x0, 0x4f, 0x40,
    0x1c, 0xfe, 0xff, 0x92, 0x0, 0x36, 0x0, 0xaa,
    0x0, 0x2f, 0xaf, 0x90, 0x0, 0x0, 0xac, 0x22,
    0x9e, 0x2, 0xd5, 0x0, 0x0, 0x1a, 0xef, 0xc3,
    0x0, 0x0,

    /* U+306B "に" */
    0x2, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x54, 0x32, 0x23, 0x30, 0x6, 0xe0,
    0x0, 0xdf, 0xff, 0xff, 0xc0, 0x9, 0xb0, 0x0,
    0x0, 0x11, 0x11, 0x0, 0xc, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x30, 0x7, 0xb0, 0x0, 0x0, 0x0,
    0x1f, 0x30, 0xc, 0x90, 0x0, 0x0, 0x0, 0x1f,
    0x40, 0xd, 0x90, 0x0, 0x0, 0x0, 0xf, 0x60,
    0x9, 0xf8, 0x42, 0x34, 0x63, 0xd, 0x90, 0x0,
    0x8e, 0xff, 0xff, 0xe5, 0x7, 0x80, 0x0, 0x0,
    0x1, 0x10, 0x0,

    /* U+306E "の" */
    0x0, 0x0, 0x6b, 0xef, 0xda, 0x30, 0x0, 0x0,
    0x3d, 0xd7, 0xe7, 0x4a, 0xf7, 0x0, 0x2, 0xe9,
    0x0, 0xe5, 0x0, 0x5f, 0x40, 0xb, 0xb0, 0x0,
    0xf3, 0x0, 0xa, 0xc0, 0x2f, 0x30, 0x4, 0xf0,
    0x0, 0x5, 0xf0, 0x5e, 0x0, 0x9, 0xb0, 0x0,
    0x3, 0xf2, 0x7d, 0x0, 0xe, 0x50, 0x0, 0x4,
    0xf0, 0x7e, 0x0, 0x6e, 0x0, 0x0, 0x8, 0xd0,
    0x3f, 0x51, 0xe7, 0x0, 0x0, 0x2f, 0x70, 0xa,
    0xff, 0xb0, 0x0, 0x4, 0xec, 0x0, 0x0, 0x45,
    0x0, 0x7, 0xcf, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x93, 0x0, 0x0,

    /* U+306F "は" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0x10, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x4,
    0xf0, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x6d,
    0x0, 0x0, 0x0, 0xe8, 0x46, 0x20, 0x9, 0xb0,
    0x1f, 0xff, 0xff, 0xfe, 0xb3, 0x0, 0xb8, 0x0,
    0x22, 0x21, 0xd7, 0x0, 0x0, 0xd, 0x60, 0x0,
    0x0, 0xd, 0x80, 0x0, 0x0, 0xf5, 0x0, 0x0,
    0x0, 0xc9, 0x0, 0x0, 0xf, 0x40, 0x0, 0x0,
    0xa, 0xa0, 0x0, 0x0, 0xf4, 0x0, 0x29, 0xcd,
    0xed, 0x10, 0x0, 0xf, 0x50, 0xe, 0xa4, 0x4b,
    0xff, 0x60, 0x0, 0xe6, 0x2, 0xf1, 0x0, 0xab,
    0x7f, 0x80, 0xc, 0xa0, 0xe, 0xa5, 0x6f, 0x60,
    0x5d, 0x0, 0x7a, 0x0, 0x2a, 0xdc, 0x60, 0x0,
    0x0,

    /* U+307E "ま" */
    0x0, 0x0, 0x2, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf0, 0x0, 0x0, 0x2, 0x21, 0x4, 0xf2,
    0x34, 0x63, 0xe, 0xff, 0xff, 0xff, 0xdc, 0xa3,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf0, 0x13, 0x40, 0x8, 0xff, 0xee, 0xff,
    0xff, 0xc0, 0x0, 0x12, 0x35, 0xf4, 0x10, 0x0,
    0x0, 0x0, 0x1, 0xf3, 0x0, 0x0, 0x0, 0x2,
    0x21, 0xf4, 0x0, 0x0, 0x9, 0xfd, 0xef, 0xfb,
    0x50, 0x0, 0x4e, 0x10, 0x1, 0xf9, 0xdf, 0x70,
    0x3f, 0x51, 0x29, 0xe0, 0x5, 0xd8, 0x5, 0xcf,
    0xfc, 0x30, 0x0, 0x0,

    /* U+307F "み" */
    0x0, 0x25, 0x67, 0x99, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xcb, 0xaf, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf3, 0x0, 0x20, 0x0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0xc6, 0x0, 0x0, 0x1, 0x4e, 0x80, 0x0,
    0xe4, 0x0, 0x3, 0xce, 0xef, 0xef, 0xb6, 0xf1,
    0x0, 0x3f, 0x60, 0xd6, 0x1, 0x7d, 0xf6, 0x0,
    0xa8, 0x6, 0xd0, 0x0, 0xd, 0xae, 0xb1, 0xb7,
    0x4f, 0x30, 0x0, 0x6e, 0x1, 0xc7, 0x6f, 0xf6,
    0x0, 0x4, 0xf4, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+3082 "も" */
    0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xba, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x60, 0x0, 0x0, 0x0, 0x1d, 0xa7, 0xf5, 0x22,
    0x0, 0x0, 0x0, 0x59, 0xdf, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x7, 0xd0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0xaa, 0x0, 0x0, 0x0, 0x0, 0xfd, 0xad,
    0xb5, 0x55, 0x0, 0x64, 0x2, 0x7a, 0xfe, 0xdd,
    0x90, 0x9, 0xc0, 0x0, 0xe, 0x50, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0xe6, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0xc, 0xa0, 0x0, 0x0, 0xcb, 0x0, 0x0,
    0x5f, 0x94, 0x35, 0xcf, 0x20, 0x0, 0x0, 0x5c,
    0xff, 0xea, 0x20,

    /* U+308A "り" */
    0x2, 0x30, 0x0, 0x0, 0x0, 0x7, 0xd0, 0x4,
    0x50, 0x0, 0x9, 0xb2, 0xde, 0xfe, 0x10, 0xb,
    0x9e, 0x60, 0x1d, 0xa0, 0xd, 0xe8, 0x0, 0x6,
    0xf0, 0xf, 0xe0, 0x0, 0x3, 0xf2, 0xf, 0x90,
    0x0, 0x1, 0xf3, 0xf, 0x50, 0x0, 0x1, 0xf3,
    0x1f, 0x30, 0x0, 0x3, 0xf2, 0xa, 0x20, 0x0,
    0x6, 0xf0, 0x0, 0x0, 0x0, 0xd, 0xa0, 0x0,
    0x0, 0x0, 0x8f, 0x20, 0x0, 0x0, 0x2a, 0xf6,
    0x0, 0x0, 0xa, 0xfd, 0x40, 0x0, 0x0, 0x2,
    0x30, 0x0, 0x0,

    /* U+308C "れ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb8, 0x0, 0x2, 0x20, 0x0, 0x0,
    0x1, 0x35, 0xd7, 0x7, 0xef, 0xf8, 0x0, 0x0,
    0xe, 0xfd, 0xf8, 0xcc, 0x40, 0x6f, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x90, 0x0, 0x3f, 0x0, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x0, 0x4f, 0x0, 0x0,
    0x0, 0x1e, 0xf5, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0xba, 0xe5, 0x0, 0x0, 0x9a, 0x0, 0x0,
    0x7, 0xf1, 0xe5, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0x2f, 0x60, 0xe5, 0x0, 0x0, 0xc8, 0x0, 0x54,
    0x7, 0x0, 0xe5, 0x0, 0x0, 0xad, 0x6a, 0xf3,
    0x0, 0x0, 0xe5, 0x0, 0x0, 0x2b, 0xd9, 0x20,
    0x0, 0x0, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3092 "を" */
    0x0, 0x0, 0x0, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x40, 0x0, 0x0, 0x1, 0x32, 0x28,
    0xf6, 0x8a, 0x90, 0x0, 0x4e, 0xff, 0xfe, 0xca,
    0x73, 0x0, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x32, 0x10, 0x0, 0x0, 0x0,
    0xd, 0xee, 0xef, 0x60, 0x4, 0x50, 0xc, 0xf7,
    0x0, 0x7e, 0xaf, 0xd8, 0xb, 0xe3, 0x1, 0x8f,
    0xf7, 0x10, 0x3, 0xe3, 0x4, 0xea, 0x3f, 0x30,
    0x0, 0x0, 0x3, 0xf5, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0x8d, 0x0, 0x6, 0x10, 0x0, 0x0, 0x6,
    0xf8, 0x43, 0x45, 0x79, 0x0, 0x0, 0x6, 0xce,
    0xff, 0xed, 0xa0,

    /* U+3093 "ん" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0xad, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xb0, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x9f, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xb1, 0x6f, 0x10, 0x0, 0x31, 0x4,
    0xfa, 0x0, 0x1f, 0x30, 0x0, 0xba, 0xb, 0xe0,
    0x0, 0x1f, 0x30, 0x4, 0xf4, 0x2f, 0x60, 0x0,
    0xf, 0x70, 0x5f, 0x90, 0x8e, 0x0, 0x0, 0xa,
    0xfe, 0xf8, 0x0, 0x3, 0x0, 0x0, 0x0, 0x46,
    0x20, 0x0,

    /* U+30A2 "ア" */
    0x14, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40, 0x4f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x0, 0x1,
    0x60, 0x0, 0xae, 0x10, 0x0, 0x0, 0x3, 0xf1,
    0x1b, 0xe2, 0x0, 0x0, 0x0, 0x4, 0xf1, 0xdb,
    0x10, 0x0, 0x0, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xb3, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+30A3 "ィ" */
    0x0, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xb0, 0x0, 0x0, 0x0, 0x1c, 0xd1,
    0x0, 0x0, 0x0, 0x2d, 0xc1, 0x0, 0x0, 0x0,
    0x7f, 0xf5, 0x0, 0x0, 0x4, 0xcf, 0x6f, 0x50,
    0x0, 0xc, 0xfa, 0x10, 0xf5, 0x0, 0x0, 0x42,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0xf5, 0x0, 0x0,

    /* U+30A4 "イ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x1b, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xcf, 0x70, 0x0, 0x0, 0x4, 0xcf,
    0x80, 0xe7, 0x0, 0x0, 0x2d, 0xfb, 0x20, 0xe,
    0x70, 0x0, 0x0, 0x73, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe7, 0x0, 0x0,

    /* U+30A6 "ウ" */
    0x0, 0x0, 0x3, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x7f, 0x44, 0x44, 0x44, 0x44, 0xbc, 0x7e, 0x0,
    0x0, 0x0, 0x0, 0xba, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xe6, 0x7e, 0x0, 0x0, 0x0, 0x4, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0x5,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x90, 0x0,
    0x0, 0x3, 0x8e, 0xf6, 0x0, 0x0, 0x0, 0x7,
    0xd7, 0x10, 0x0, 0x0,

    /* U+30A8 "エ" */
    0x2, 0x44, 0x44, 0x44, 0x44, 0x43, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x0,
    0x12, 0x22, 0x22, 0xf6, 0x22, 0x22, 0x20, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x12, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x20,

    /* U+30A9 "ォ" */
    0x0, 0x0, 0x0, 0x3b, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x2, 0x22, 0x22, 0x5f,
    0x32, 0x20, 0xc, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x3f, 0x8f, 0x20, 0x0, 0x0, 0x4, 0xf8, 0x2f,
    0x20, 0x0, 0x0, 0x7f, 0x70, 0x1f, 0x20, 0x0,
    0x1d, 0xe4, 0x0, 0x1f, 0x20, 0x0, 0x5, 0x0,
    0x14, 0x8f, 0x10, 0x0, 0x0, 0x0, 0x3e, 0xc7,
    0x0, 0x0,

    /* U+30AB "カ" */
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x34, 0x44, 0xbd, 0x44, 0x44, 0xf5, 0x0,
    0x0, 0xd, 0x90, 0x0, 0xf, 0x40, 0x0, 0x1,
    0xf5, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x2f, 0x30, 0x0, 0xe, 0x90, 0x0, 0x4,
    0xf1, 0x0, 0x8, 0xf2, 0x0, 0x0, 0x6f, 0x0,
    0x5, 0xf6, 0x0, 0x0, 0xa, 0xc0, 0x6, 0xf9,
    0x0, 0x9, 0x68, 0xf7, 0x1, 0xc7, 0x0, 0x0,
    0x9c, 0xc8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30AD "キ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xe5, 0x79, 0xc9, 0x0, 0x6, 0x9b, 0xef, 0xff,
    0xca, 0x74, 0x0, 0xd, 0xb8, 0x66, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xea, 0x68, 0xad, 0xf1,
    0x15, 0x7a, 0xcf, 0xff, 0xdb, 0x96, 0x40, 0x5f,
    0xca, 0x75, 0xad, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0,

    /* U+30AF "ク" */
    0x0, 0x0, 0x0, 0x42, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf5, 0x33, 0x33, 0x20, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x2, 0xeb, 0x0, 0x0, 0xf,
    0x80, 0x1, 0xdd, 0x0, 0x0, 0x5, 0xf3, 0x3,
    0xed, 0x10, 0x0, 0x0, 0xcd, 0x0, 0xab, 0x10,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xd1, 0x0, 0x0, 0x0, 0x17,
    0xef, 0x80, 0x0, 0x0, 0x0, 0x3, 0xea, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30B0 "グ" */
    0x0, 0x0, 0x0, 0x50, 0x0, 0x4, 0x67, 0x0,
    0x0, 0x0, 0x7f, 0x20, 0x0, 0xc4, 0xd2, 0x0,
    0x0, 0x1e, 0xb3, 0x33, 0x36, 0xa4, 0x20, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x8,
    0xf4, 0x0, 0x0, 0x7f, 0x10, 0x0, 0x7, 0xf6,
    0x0, 0x0, 0xc, 0xb0, 0x0, 0x9, 0xf7, 0x0,
    0x0, 0x4, 0xf5, 0x0, 0x3, 0xd5, 0x0, 0x0,
    0x0, 0xdc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xcf, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x3a, 0xfd, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xd6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B5 "サ" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0xa, 0xa0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0xa,
    0xb0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0xa, 0xb0,
    0x0, 0x7e, 0x0, 0x0, 0xbd, 0xdf, 0xfd, 0xdd,
    0xef, 0xdd, 0xd4, 0x66, 0x6c, 0xd6, 0x66, 0xaf,
    0x66, 0x62, 0x0, 0xa, 0xb0, 0x0, 0x7e, 0x0,
    0x0, 0x0, 0xa, 0xb0, 0x0, 0x7d, 0x0, 0x0,
    0x0, 0xa, 0xb0, 0x0, 0xab, 0x0, 0x0, 0x0,
    0x2, 0x20, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x5c, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xda, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B6 "ザ" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x94, 0x0,
    0x0, 0xaa, 0x0, 0x7, 0xe2, 0xd2, 0xe0, 0x0,
    0xa, 0xb0, 0x0, 0x7e, 0x8, 0x75, 0x10, 0x0,
    0xab, 0x0, 0x7, 0xe0, 0x0, 0x0, 0xbd, 0xdf,
    0xfd, 0xdd, 0xef, 0xdd, 0xd4, 0x6, 0x66, 0xcd,
    0x66, 0x6a, 0xf6, 0x66, 0x20, 0x0, 0xa, 0xb0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xab, 0x0,
    0x7, 0xd0, 0x0, 0x0, 0x0, 0xa, 0xb0, 0x0,
    0xab, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0xe,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5c, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3d, 0xa2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30B7 "シ" */
    0x1, 0x72, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4e,
    0xfa, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xda,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x40, 0x8a, 0x30, 0x0, 0x0, 0x0, 0x5f,
    0x6, 0xcf, 0xb1, 0x0, 0x0, 0x1e, 0x90, 0x0,
    0x3d, 0x40, 0x0, 0xb, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x1c,
    0xe4, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xd2, 0x0,
    0x0, 0x0, 0x38, 0xef, 0x70, 0x0, 0x0, 0x4,
    0xff, 0xd7, 0x10, 0x0, 0x0, 0x0, 0x16, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30B8 "ジ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x10, 0x0,
    0x17, 0x10, 0x0, 0x4, 0x95, 0xa0, 0x0, 0x4e,
    0xfa, 0x10, 0x0, 0xc4, 0xa0, 0x0, 0x0, 0x5d,
    0x90, 0x0, 0x32, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x30, 0x9, 0x93, 0x0, 0x0, 0x0,
    0x6, 0xe0, 0x6, 0xdf, 0xb1, 0x0, 0x0, 0x1e,
    0x80, 0x0, 0x4, 0xd3, 0x0, 0x0, 0xcd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xce, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xc2, 0x0, 0x0, 0x0, 0x3, 0x9e,
    0xf6, 0x0, 0x0, 0x0, 0x5, 0xff, 0xd6, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x51, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30B9 "ス" */
    0x2, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x55, 0x55, 0x55, 0x5b, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xed, 0xf9, 0x0,
    0x0, 0x0, 0x0, 0x3e, 0xc0, 0x4f, 0xc0, 0x0,
    0x0, 0x6, 0xfa, 0x0, 0x3, 0xec, 0x0, 0x3,
    0xcf, 0x70, 0x0, 0x0, 0x4f, 0xa0, 0x3f, 0xc3,
    0x0, 0x0, 0x0, 0x6, 0xf1, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10,

    /* U+30BB "セ" */
    0x0, 0x0, 0xa3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf5,
    0x0, 0x0, 0x14, 0x50, 0x0, 0xf, 0x76, 0x9b,
    0xef, 0xfe, 0x58, 0xbe, 0xff, 0xca, 0x74, 0x1c,
    0x9a, 0xa8, 0x5f, 0x50, 0x0, 0x6, 0xf1, 0x0,
    0x0, 0xf5, 0x0, 0x3, 0xf6, 0x0, 0x0, 0xf,
    0x50, 0x3, 0xf9, 0x0, 0x0, 0x0, 0xf5, 0x0,
    0x4, 0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xea, 0x10, 0x0, 0x25, 0x20,
    0x0, 0x5, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x34, 0x43, 0x20, 0x0,

    /* U+30BF "タ" */
    0x0, 0x0, 0x0, 0x42, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf5, 0x33, 0x33, 0x20, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xf9, 0x0, 0x1, 0xeb, 0x0, 0x0, 0x1f,
    0x60, 0x1, 0xdd, 0x0, 0x0, 0x7, 0xf1, 0x3,
    0xed, 0x2b, 0x70, 0x0, 0xe9, 0x0, 0xab, 0x10,
    0x6f, 0xb1, 0x9f, 0x10, 0x0, 0x0, 0x0, 0x2d,
    0xef, 0x70, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0x6,
    0xef, 0x70, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30C0 "ダ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x0,
    0x0, 0x0, 0x5, 0x0, 0x0, 0xb3, 0xd1, 0x0,
    0x0, 0x4, 0xf4, 0x0, 0x4, 0xb6, 0x80, 0x0,
    0x0, 0xdd, 0x33, 0x33, 0x37, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x5f,
    0x60, 0x0, 0x6, 0xf1, 0x0, 0x0, 0x4f, 0x90,
    0x0, 0x0, 0xcb, 0x0, 0x0, 0x6f, 0xa2, 0xc4,
    0x0, 0x4f, 0x40, 0x0, 0x1d, 0x70, 0xa, 0xf8,
    0xd, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfe,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2c, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x8f, 0xe4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xde, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30C3 "ッ" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x11, 0x8,
    0xd0, 0x0, 0x76, 0xc, 0xb0, 0x1f, 0x50, 0xd,
    0x80, 0x4f, 0x20, 0xba, 0x2, 0xf3, 0x0, 0xe5,
    0x2, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x50, 0x0, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x0,
    0x0, 0x1c, 0xe1, 0x0, 0x0, 0x0, 0x5e, 0xd2,
    0x0, 0x0, 0x5, 0xdf, 0x90, 0x0, 0x0, 0x0,
    0x7, 0x20, 0x0, 0x0, 0x0,

    /* U+30C6 "テ" */
    0x0, 0x25, 0x55, 0x55, 0x55, 0x51, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x36, 0x66, 0x66, 0x66,
    0x66, 0x66, 0x60, 0x7d, 0xdd, 0xdd, 0xef, 0xdd,
    0xdd, 0xd1, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+30C7 "デ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x35, 0x0,
    0x2, 0x55, 0x55, 0x55, 0x53, 0xc2, 0xd1, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xa6, 0xa6, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x66, 0x66,
    0x66, 0x66, 0x66, 0x66, 0x0, 0x7d, 0xdd, 0xdd,
    0xef, 0xdd, 0xdd, 0xd1, 0x0, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9d,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2e, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30C8 "ト" */
    0x12, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x7, 0xfa,
    0x50, 0x0, 0x0, 0x7f, 0xbf, 0xe6, 0x0, 0x7,
    0xe0, 0x29, 0xfd, 0x40, 0x7e, 0x0, 0x2, 0xce,
    0x7, 0xe0, 0x0, 0x0, 0x20, 0x7e, 0x0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0,

    /* U+30C9 "ド" */
    0x3, 0x10, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x46, 0x80, 0x1f, 0x50, 0x0, 0xc3, 0xd3, 0x1f,
    0x50, 0x0, 0x4a, 0x31, 0x1f, 0x50, 0x0, 0x0,
    0x0, 0x1f, 0xd7, 0x10, 0x0, 0x0, 0x1f, 0xce,
    0xfa, 0x20, 0x0, 0x1f, 0x50, 0x6d, 0xf9, 0x0,
    0x1f, 0x50, 0x0, 0x7f, 0x50, 0x1f, 0x50, 0x0,
    0x2, 0x0, 0x1f, 0x50, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x0,

    /* U+30CB "ニ" */
    0x0, 0x55, 0x55, 0x55, 0x55, 0x52, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x13, 0x33, 0x33, 0x33, 0x33, 0x33, 0x30, 0x8f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x1, 0x11,
    0x11, 0x11, 0x11, 0x11, 0x10,

    /* U+30CD "ネ" */
    0x0, 0x0, 0x0, 0x31, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x33, 0x33, 0x33,
    0x3c, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9e,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xef, 0x92, 0x0, 0x0,
    0x0, 0x4, 0xce, 0xfa, 0xbf, 0xa2, 0x0, 0x27,
    0xde, 0x70, 0xe6, 0x3, 0xcf, 0x80, 0x5b, 0x50,
    0x0, 0xe6, 0x0, 0x6, 0xe2, 0x0, 0x0, 0x0,
    0xe6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe6, 0x0,
    0x0, 0x0,

    /* U+30D0 "バ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x76, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xd2, 0xd1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x94, 0x10, 0x0,
    0x0, 0xc4, 0x0, 0x7d, 0x1, 0x0, 0x0, 0x0,
    0x2f, 0x40, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x0, 0xcb,
    0x0, 0x0, 0xe, 0x90, 0x0, 0x0, 0x3f, 0x40,
    0x0, 0x0, 0x8f, 0x0, 0x0, 0xb, 0xd0, 0x0,
    0x0, 0x1, 0xf6, 0x0, 0x5, 0xf4, 0x0, 0x0,
    0x0, 0xb, 0xd0, 0x1, 0xeb, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0xce, 0x10, 0x0, 0x0, 0x0,
    0x1, 0xf6, 0x2a, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0,

    /* U+30D5 "フ" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x44, 0x44,
    0x44, 0x44, 0x46, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xa, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x0, 0x0, 0x5, 0xfc, 0x0, 0x0, 0x0, 0x2,
    0xbf, 0xa0, 0x0, 0x0, 0x1, 0xcf, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x55, 0x0, 0x0, 0x0, 0x0,

    /* U+30D6 "ブ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x87, 0xa6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe3, 0xa3, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd3, 0x0, 0x4, 0x44,
    0x44, 0x44, 0x44, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6e, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xef, 0xa2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30D7 "プ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x1a, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xb4, 0xa5, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe3, 0x61, 0x14, 0x44,
    0x44, 0x44, 0x44, 0xbd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5e, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xef, 0xb2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+30D9 "ベ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x14, 0x78, 0x0,
    0x0, 0x0, 0x1, 0x52, 0x0, 0xd, 0x3d, 0x20,
    0x0, 0x0, 0x1d, 0xff, 0x30, 0x5, 0x82, 0x0,
    0x0, 0x1, 0xdc, 0x3b, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xe1, 0x0, 0xce, 0x30, 0x0, 0x0,
    0x0, 0xcf, 0x20, 0x0, 0xc, 0xe3, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x1, 0xde, 0x30, 0x0,
    0x6, 0x30, 0x0, 0x0, 0x0, 0x1c, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30DE "マ" */
    0x2, 0x22, 0x22, 0x22, 0x22, 0x22, 0x20, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x12, 0x22,
    0x22, 0x22, 0x22, 0x2d, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9e, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf3, 0x0, 0x0, 0xa, 0xd2, 0x0, 0x9f,
    0x40, 0x0, 0x0, 0x1, 0xce, 0x4b, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xfd, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xce, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x0, 0x0,

    /* U+30DF "ミ" */
    0x0, 0x5c, 0x96, 0x20, 0x0, 0x0, 0x3, 0x7a,
    0xdf, 0xea, 0x40, 0x0, 0x0, 0x0, 0x16, 0xbf,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x59,
    0x62, 0x0, 0x0, 0x0, 0x5, 0xbe, 0xfe, 0x93,
    0x0, 0x0, 0x0, 0x2, 0x7c, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x0, 0x5, 0x20, 0x0, 0x0,
    0x0, 0x2, 0xef, 0xfb, 0x62, 0x0, 0x0, 0x0,
    0x25, 0xae, 0xfc, 0x61, 0x0, 0x0, 0x0, 0x4,
    0x9f, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x7, 0x70,

    /* U+30E0 "ム" */
    0x0, 0x0, 0x2, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xca, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xf4, 0x0, 0x3f, 0x40,
    0x0, 0x0, 0x8, 0xe0, 0x0, 0x8, 0xe1, 0x0,
    0x0, 0xe, 0x80, 0x0, 0x0, 0xdb, 0x0, 0x0,
    0x6f, 0x10, 0x2, 0x57, 0xcf, 0x40, 0x14, 0xde,
    0xbe, 0xff, 0xeb, 0x9c, 0xc0, 0x9f, 0xdb, 0x86,
    0x30, 0x0, 0x4, 0xf2, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x40,

    /* U+30E2 "モ" */
    0x5, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x1,
    0x33, 0x4f, 0x73, 0x33, 0x33, 0x0, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x50, 0x0, 0x0, 0x0, 0x24, 0x44, 0x4f, 0x84,
    0x44, 0x44, 0x40, 0x8f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf1, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x90, 0x0, 0x1, 0x20, 0x0, 0x0,
    0x7, 0xfe, 0xde, 0xff, 0x90, 0x0, 0x0, 0x0,
    0x25, 0x66, 0x53, 0x0,

    /* U+30E3 "ャ" */
    0x0, 0x2b, 0x10, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x0, 0x10, 0x0, 0xd, 0x82, 0x58,
    0xcf, 0xe0, 0x15, 0x8e, 0xff, 0xd9, 0x6b, 0xb0,
    0x5e, 0xaa, 0xf0, 0x0, 0x3f, 0x20, 0x0, 0x2,
    0xf3, 0x2, 0xe8, 0x0, 0x0, 0x0, 0xe6, 0x7,
    0xa0, 0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x10, 0x0, 0x0, 0x0, 0x0, 0xd, 0x30,
    0x0, 0x0,

    /* U+30E5 "ュ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x22, 0x22, 0x27,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x25, 0x55, 0x55, 0x5f, 0x85, 0x50,
    0x6d, 0xdd, 0xdd, 0xdd, 0xdd, 0xd1,

    /* U+30E7 "ョ" */
    0x16, 0x66, 0x66, 0x66, 0x61, 0x4d, 0xdd, 0xdd,
    0xdd, 0xf3, 0x0, 0x0, 0x0, 0x1, 0xf3, 0x2,
    0x33, 0x33, 0x34, 0xf3, 0xc, 0xff, 0xff, 0xff,
    0xf3, 0x0, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x0,
    0x0, 0x1, 0xf3, 0x25, 0x55, 0x55, 0x56, 0xf3,
    0x5d, 0xdd, 0xdd, 0xdd, 0xf3, 0x0, 0x0, 0x0,
    0x1, 0xd2,

    /* U+30E9 "ラ" */
    0x8, 0xff, 0xff, 0xff, 0xfc, 0x0, 0x2, 0x44,
    0x44, 0x44, 0x43, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x10,
    0x0, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xa0, 0x0, 0x0, 0x0, 0x1a, 0xfa,
    0x0, 0x0, 0x0, 0x49, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x9d, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+30EA "リ" */
    0x0, 0x0, 0x0, 0x1, 0x20, 0xf4, 0x0, 0x0,
    0x7e, 0xf, 0x50, 0x0, 0x7, 0xe0, 0xf5, 0x0,
    0x0, 0x7e, 0xf, 0x50, 0x0, 0x7, 0xe0, 0xf5,
    0x0, 0x0, 0x7e, 0xf, 0x50, 0x0, 0x7, 0xe0,
    0xf5, 0x0, 0x0, 0x8d, 0x5, 0x10, 0x0, 0xb,
    0xb0, 0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x3, 0xcf, 0x30, 0x0, 0x5b,
    0xfc, 0x20, 0x0, 0x6, 0xb4, 0x0, 0x0,

    /* U+30EB "ル" */
    0x0, 0x0, 0x0, 0x0, 0x48, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc6, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd8, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd8, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd7, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf4, 0x0, 0x7e, 0x0, 0x0, 0x82,
    0x0, 0x3, 0xf2, 0x0, 0x7e, 0x0, 0x4, 0xf6,
    0x0, 0x9, 0xd0, 0x0, 0x7e, 0x0, 0x4f, 0x90,
    0x0, 0x2f, 0x70, 0x0, 0x7e, 0x7, 0xf9, 0x0,
    0x2, 0xec, 0x0, 0x0, 0x7f, 0xdf, 0x60, 0x0,
    0x4f, 0xd1, 0x0, 0x0, 0x4e, 0x92, 0x0, 0x0,
    0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30EC "レ" */
    0x25, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x3, 0x80, 0x6f, 0x0, 0x0, 0x0,
    0x2e, 0xd0, 0x6f, 0x0, 0x0, 0x4, 0xed, 0x10,
    0x6f, 0x0, 0x0, 0x7f, 0xc1, 0x0, 0x6f, 0x0,
    0x3d, 0xf8, 0x0, 0x0, 0x6f, 0x6c, 0xfc, 0x30,
    0x0, 0x0, 0x5f, 0xfb, 0x40, 0x0, 0x0, 0x0,
    0x4, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+30ED "ロ" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x7f, 0x44,
    0x44, 0x44, 0x44, 0xf6, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xf6, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x7e, 0x0, 0x0, 0x0, 0x0, 0xf6, 0x7e, 0x0,
    0x0, 0x0, 0x0, 0xf6, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xf6, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x7e, 0x22, 0x22, 0x22, 0x22, 0xf6, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x7e, 0x11, 0x11, 0x11,
    0x11, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30EF "ワ" */
    0x1, 0x11, 0x11, 0x11, 0x11, 0x10, 0x7f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x7e, 0x11, 0x11, 0x11,
    0x11, 0xf7, 0x7e, 0x0, 0x0, 0x0, 0x1, 0xf5,
    0x7e, 0x0, 0x0, 0x0, 0x4, 0xf2, 0x7e, 0x0,
    0x0, 0x0, 0x8, 0xe0, 0x12, 0x0, 0x0, 0x0,
    0xe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x20,
    0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x2a, 0xfb,
    0x0, 0x0, 0x0, 0x3b, 0xfe, 0x60, 0x0, 0x0,
    0x0, 0x1a, 0x60, 0x0, 0x0, 0x0,

    /* U+30F3 "ン" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfd, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xde, 0x10, 0x0,
    0x1, 0x90, 0x0, 0x1, 0x90, 0x0, 0x0, 0x8e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xb0, 0x0, 0x0, 0x0, 0x6, 0xdf, 0x80, 0x0,
    0x0, 0x26, 0xaf, 0xfa, 0x20, 0x0, 0x0, 0x9,
    0xfc, 0x71, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+30FC "ー" */
    0x4, 0x44, 0x44, 0x44, 0x44, 0x44, 0x31, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x1, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x10,

    /* U+4E00 "一" */
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1,
    0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,

    /* U+4E0B "下" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x44, 0x44, 0x46, 0xf5, 0x44, 0x44, 0x43, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf3, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x6f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf2, 0x3e, 0xb1, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x20, 0x1d, 0xd1, 0x0, 0x0, 0x0, 0x2,
    0xf2, 0x0, 0xc, 0x60, 0x0, 0x0, 0x0, 0x2f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x20, 0x0,
    0x0, 0x0,

    /* U+4E0D "不" */
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x24, 0x44, 0x44, 0x8f, 0x54, 0x44, 0x40, 0x0,
    0x0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0x55, 0x20, 0x0, 0x0, 0x0, 0x5,
    0xf5, 0xe5, 0x9f, 0x40, 0x0, 0x0, 0x6, 0xf6,
    0xe, 0x50, 0x7f, 0x70, 0x0, 0x9, 0xf6, 0x0,
    0xe5, 0x0, 0x5f, 0x80, 0x1c, 0xe4, 0x0, 0xe,
    0x50, 0x0, 0x5f, 0x70, 0x81, 0x0, 0x0, 0xe5,
    0x0, 0x0, 0x51, 0x0, 0x0, 0x0, 0xe, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x50, 0x0,
    0x0, 0x0,

    /* U+4E2D "中" */
    0x0, 0x0, 0x0, 0x72, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x50,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x82, 0xf4, 0x33, 0x3f, 0x83, 0x33, 0xc8, 0x2f,
    0x10, 0x0, 0xe5, 0x0, 0xb, 0x82, 0xf1, 0x0,
    0xe, 0x50, 0x0, 0xb8, 0x2f, 0x10, 0x0, 0xe5,
    0x0, 0xb, 0x82, 0xf4, 0x33, 0x3f, 0x73, 0x33,
    0xc8, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe5, 0x0,
    0x0, 0x0,

    /* U+4E86 "了" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0x44,
    0x44, 0x44, 0x44, 0x4c, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x2c, 0xe4, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x4d, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+4F3A "伺" */
    0x0, 0x2, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xd3, 0xff, 0xff, 0xff, 0xff, 0x0, 0xe,
    0x70, 0x33, 0x33, 0x33, 0x5f, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0x0, 0x2f, 0x0, 0xde, 0xe, 0xff,
    0xff, 0xff, 0x3f, 0x6, 0xfe, 0x2, 0x22, 0x22,
    0x22, 0x2f, 0x2f, 0x9e, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x6b, 0x3e, 0x2, 0xff, 0xff, 0xe0, 0x2f,
    0x0, 0x3e, 0x2, 0xf2, 0x24, 0xf0, 0x2f, 0x0,
    0x3e, 0x2, 0xf0, 0x2, 0xf0, 0x2f, 0x0, 0x3e,
    0x2, 0xf0, 0x2, 0xf0, 0x2f, 0x0, 0x3e, 0x2,
    0xff, 0xff, 0xf0, 0x2f, 0x0, 0x3e, 0x0, 0x22,
    0x22, 0x33, 0x8f, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x8f, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+4F4E "低" */
    0x0, 0x1, 0xc1, 0x0, 0x0, 0x0, 0x13, 0x0,
    0x0, 0x7, 0xd0, 0x56, 0x8a, 0xcf, 0xfe, 0x0,
    0x0, 0xd, 0x60, 0xfd, 0xa8, 0xf6, 0x10, 0x0,
    0x0, 0x5f, 0x0, 0xf3, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0xde, 0x0, 0xf3, 0x0, 0xe3, 0x0, 0x0,
    0x6, 0xfe, 0x0, 0xf3, 0x0, 0xd5, 0x0, 0x0,
    0x2f, 0x8e, 0x0, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x69, 0x3e, 0x0, 0xf5, 0x22, 0xb8, 0x22, 0x10,
    0x0, 0x3e, 0x0, 0xf3, 0x0, 0x89, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0xf3, 0x0, 0x6c, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0xf3, 0x5a, 0x2f, 0x0, 0x10,
    0x0, 0x3e, 0x0, 0xfb, 0xf4, 0xe, 0x51, 0xe0,
    0x0, 0x3e, 0x3, 0xfb, 0xb8, 0x7, 0xea, 0xb0,
    0x0, 0x3e, 0x1, 0x70, 0xc, 0x40, 0xae, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+4F60 "你" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xd0, 0x9, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xb0, 0xe, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x50, 0x6f, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x6f, 0x0, 0xd7, 0x33, 0x33, 0x5f, 0x20,
    0x0, 0xde, 0x6, 0xd0, 0x6, 0x20, 0x9b, 0x0,
    0x6, 0xfe, 0xe, 0x50, 0xd, 0x50, 0x93, 0x0,
    0x1f, 0x8e, 0x3, 0x1, 0xd, 0x50, 0x10, 0x0,
    0x28, 0x3e, 0x0, 0x6a, 0xd, 0x54, 0xd0, 0x0,
    0x0, 0x3e, 0x0, 0xc4, 0xd, 0x50, 0xc6, 0x0,
    0x0, 0x3e, 0x3, 0xe0, 0xd, 0x50, 0x5d, 0x0,
    0x0, 0x3e, 0xb, 0x70, 0xd, 0x50, 0xe, 0x40,
    0x0, 0x3e, 0x3e, 0x0, 0xd, 0x50, 0x7, 0xb0,
    0x0, 0x3e, 0x45, 0x1, 0x4e, 0x50, 0x2, 0xa0,
    0x0, 0x3e, 0x0, 0x9, 0xfc, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4FE1 "信" */
    0x0, 0x0, 0xa0, 0x0, 0xb, 0x20, 0x0, 0x0,
    0x0, 0x5, 0xd0, 0x0, 0xb, 0x80, 0x0, 0x0,
    0x0, 0xb, 0x8f, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x2f, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10,
    0x0, 0xae, 0x0, 0x44, 0x44, 0x44, 0x43, 0x0,
    0x3, 0xfe, 0x1, 0xcc, 0xcc, 0xcc, 0xcb, 0x0,
    0xc, 0xde, 0x0, 0x11, 0x11, 0x11, 0x11, 0x0,
    0x4e, 0x5e, 0x1, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x1, 0x4e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x1, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x4e, 0x1, 0xf3, 0x22, 0x22, 0x6e, 0x0,
    0x0, 0x4e, 0x1, 0xf1, 0x0, 0x0, 0x5e, 0x0,
    0x0, 0x4e, 0x1, 0xf4, 0x33, 0x33, 0x7e, 0x0,
    0x0, 0x4e, 0x1, 0xfe, 0xee, 0xee, 0xee, 0x0,

    /* U+5019 "候" */
    0x0, 0x9, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x10, 0xc, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x6b, 0x3d, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0xc6, 0x3d, 0x12, 0x22, 0x27, 0xe2, 0x10,
    0x3, 0xf4, 0x3d, 0x9e, 0xee, 0xee, 0xee, 0xb0,
    0xb, 0xf4, 0x3d, 0x3, 0xa0, 0x0, 0x0, 0x0,
    0x3f, 0xd4, 0x3d, 0x9, 0xd8, 0x88, 0x88, 0x0,
    0xb7, 0xc4, 0x3d, 0x2e, 0x89, 0xf8, 0x87, 0x0,
    0x20, 0xc4, 0x3d, 0x67, 0x3, 0xe0, 0x0, 0x0,
    0x0, 0xc4, 0x3d, 0x8b, 0xbc, 0xfb, 0xbb, 0x60,
    0x0, 0xc4, 0x3d, 0x34, 0x4b, 0xf6, 0x44, 0x20,
    0x0, 0xc4, 0x3d, 0x0, 0x3f, 0xbc, 0x10, 0x0,
    0x0, 0xc4, 0x2, 0x18, 0xe6, 0x7, 0xe6, 0x0,
    0x0, 0xc4, 0x1, 0xe8, 0x10, 0x0, 0x2a, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5099 "備" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xa0, 0xc, 0x50, 0xf, 0x20, 0x0,
    0x0, 0x9, 0x71, 0x1c, 0x61, 0x1f, 0x31, 0x0,
    0x0, 0xe, 0x3e, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x5f, 0x0, 0xc, 0x50, 0xf, 0x20, 0x0,
    0x0, 0xce, 0x7d, 0xdf, 0xed, 0xdf, 0xdd, 0xd2,
    0x4, 0xfe, 0x13, 0x6f, 0x33, 0x33, 0x33, 0x30,
    0xd, 0xae, 0x0, 0xcb, 0x22, 0x22, 0x21, 0x0,
    0x6d, 0x3e, 0x9, 0xfe, 0xef, 0xee, 0xec, 0x0,
    0x13, 0x3e, 0x8f, 0xe0, 0xc, 0x50, 0x4c, 0x0,
    0x0, 0x3f, 0xb5, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x3e, 0x3, 0xe0, 0xc, 0x50, 0x4c, 0x0,
    0x0, 0x3e, 0x3, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x3e, 0x3, 0xe0, 0xc, 0x50, 0x4c, 0x0,
    0x0, 0x3e, 0x3, 0xe0, 0xc, 0x59, 0xc5, 0x0,

    /* U+5145 "充" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x2, 0x33,
    0x3a, 0xe3, 0x33, 0x33, 0x33, 0x0, 0x0, 0x4,
    0xf4, 0x0, 0xc7, 0x0, 0x0, 0x0, 0x2, 0xf7,
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x4, 0xea, 0x22,
    0x34, 0x4b, 0xf3, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xdd, 0xe1, 0x0, 0x2, 0x11, 0xd6, 0x9,
    0x90, 0xa, 0x10, 0x0, 0x0, 0xf, 0x40, 0x99,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf1, 0x9, 0x90,
    0x0, 0x20, 0x0, 0x2, 0xe9, 0x0, 0x99, 0x0,
    0xb, 0x70, 0x6, 0xeb, 0x0, 0x9, 0xc3, 0x24,
    0xf5, 0x1e, 0xf8, 0x0, 0x0, 0x3e, 0xff, 0xfb,
    0x0, 0x62, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5148 "先" */
    0x0, 0x0, 0x20, 0x6, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x0, 0x8a, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xb2, 0x29, 0xb2, 0x22, 0x22, 0x0, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x9c,
    0x0, 0x8, 0xa0, 0x0, 0x0, 0x0, 0x2f, 0x30,
    0x0, 0x8a, 0x0, 0x0, 0x0, 0x2, 0x72, 0x22,
    0x29, 0xb2, 0x22, 0x22, 0x10, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0xc, 0x70,
    0xf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xf5, 0x0,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x10, 0xf,
    0x30, 0x2, 0x20, 0x0, 0x1d, 0xa0, 0x0, 0xf3,
    0x0, 0x6b, 0x0, 0x3d, 0xd1, 0x0, 0xf, 0x82,
    0x2b, 0x90, 0xaf, 0xa1, 0x0, 0x0, 0x9f, 0xff,
    0xd3, 0x5, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5165 "入" */
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xca, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc9, 0xa9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf2, 0x3f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x90, 0xb, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x8e, 0x10, 0x2, 0xf5, 0x0, 0x0,
    0x0, 0x5, 0xf4, 0x0, 0x0, 0x8f, 0x20, 0x0,
    0x0, 0x4f, 0x70, 0x0, 0x0, 0xc, 0xe1, 0x0,
    0x5, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xde, 0x20,
    0x1f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1d, 0xc0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+5173 "关" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3d, 0x0, 0x0, 0xb, 0x80, 0x0, 0x0,
    0x0, 0xc9, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x3, 0xf1, 0x1, 0xe7, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x3, 0x33,
    0x33, 0xf6, 0x33, 0x33, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf3, 0x0, 0x0, 0x0, 0xd, 0xee, 0xee, 0xef,
    0xee, 0xee, 0xee, 0x10, 0x45, 0x55, 0x58, 0xfa,
    0x55, 0x55, 0x50, 0x0, 0x0, 0x0, 0xce, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x1d, 0xb0,
    0x0, 0x0, 0x0, 0x2, 0xbe, 0x20, 0x2e, 0xc2,
    0x0, 0x0, 0x19, 0xfb, 0x10, 0x0, 0x2c, 0xf9,
    0x30, 0x3f, 0xd5, 0x0, 0x0, 0x0, 0x6, 0xdf,
    0x70, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x31,

    /* U+518D "再" */
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x1, 0x22, 0x22, 0x2c, 0x82, 0x22, 0x22, 0x0,
    0x0, 0x2, 0x22, 0x2c, 0x82, 0x22, 0x10, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x4e, 0x0, 0xc, 0x70, 0x3, 0xf0, 0x0,
    0x0, 0x4e, 0x11, 0x1c, 0x81, 0x14, 0xf0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x4e, 0x0, 0xc, 0x70, 0x3, 0xf0, 0x0,
    0x2, 0x6e, 0x22, 0x2c, 0x82, 0x25, 0xf2, 0x20,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x17, 0xf0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x2, 0xec, 0x60, 0x0,

    /* U+51FA "出" */
    0x0, 0x0, 0x0, 0xa3, 0x0, 0x0, 0x0, 0x25,
    0x0, 0xe, 0x40, 0x0, 0x60, 0x6, 0xc0, 0x0,
    0xe4, 0x0, 0x1f, 0x20, 0x6c, 0x0, 0xe, 0x40,
    0x1, 0xf2, 0x6, 0xc0, 0x0, 0xe4, 0x0, 0x1f,
    0x20, 0x6d, 0x33, 0x3f, 0x73, 0x35, 0xf2, 0x6,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x50, 0x0,
    0xe, 0x40, 0x0, 0x25, 0x1f, 0x20, 0x0, 0xe4,
    0x0, 0x7, 0xd1, 0xf2, 0x0, 0xe, 0x40, 0x0,
    0x7d, 0x1f, 0x20, 0x0, 0xe4, 0x0, 0x7, 0xd1,
    0xf2, 0x0, 0xe, 0x40, 0x0, 0x7d, 0x1f, 0x53,
    0x33, 0xf7, 0x33, 0x39, 0xd1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd,

    /* U+5207 "切" */
    0x0, 0x19, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf0, 0x3, 0x55, 0x55, 0x55, 0x51, 0x0,
    0x2f, 0x0, 0x8e, 0xef, 0xee, 0xef, 0x20, 0x2,
    0xf0, 0x0, 0x4, 0xf0, 0x1, 0xf2, 0x0, 0x4f,
    0x67, 0x70, 0x4f, 0x0, 0x2f, 0x15, 0xff, 0xfd,
    0xb7, 0x5, 0xe0, 0x2, 0xf1, 0x13, 0x3f, 0x0,
    0x0, 0x6d, 0x0, 0x3f, 0x0, 0x2, 0xf0, 0x0,
    0x7, 0xc0, 0x3, 0xf0, 0x0, 0x2f, 0x0, 0x0,
    0x9a, 0x0, 0x4f, 0x0, 0x2, 0xf0, 0x2, 0xd,
    0x60, 0x5, 0xf0, 0x0, 0x2f, 0x2b, 0xc3, 0xf2,
    0x0, 0x5e, 0x0, 0x3, 0xff, 0xb2, 0xca, 0x0,
    0x6, 0xd0, 0x0, 0x6e, 0x50, 0x9e, 0x20, 0x0,
    0xbc, 0x0, 0x0, 0x10, 0x9f, 0x40, 0xc, 0xff,
    0x50, 0x0, 0x0, 0xa, 0x40, 0x0, 0x44, 0x10,
    0x0,

    /* U+521D "初" */
    0x0, 0x3b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf0, 0x4, 0x77, 0x77, 0x77, 0x71, 0x2,
    0x3e, 0x52, 0x6b, 0xed, 0xbb, 0xcf, 0x10, 0xdf,
    0xff, 0xb0, 0xc, 0x50, 0x2, 0xf1, 0x0, 0x0,
    0xd4, 0x0, 0xc5, 0x0, 0x2f, 0x0, 0x0, 0x99,
    0x3, 0xd, 0x40, 0x3, 0xf0, 0x0, 0x6f, 0x25,
    0xc0, 0xf3, 0x0, 0x4e, 0x0, 0x5e, 0xfa, 0xe2,
    0x1f, 0x10, 0x4, 0xe0, 0x5e, 0x3f, 0xdc, 0x13,
    0xf0, 0x0, 0x5d, 0x2, 0x21, 0xf2, 0xa8, 0x7b,
    0x0, 0x6, 0xc0, 0x0, 0x1f, 0x10, 0x1d, 0x50,
    0x0, 0x6c, 0x0, 0x1, 0xf1, 0x7, 0xc0, 0x0,
    0x8, 0xb0, 0x0, 0x1f, 0x13, 0xe2, 0x2, 0x46,
    0xe9, 0x0, 0x1, 0xf2, 0xd4, 0x0, 0x7f, 0xeb,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5229 "利" */
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x2a, 0x0,
    0x46, 0x8b, 0xdf, 0xe1, 0x33, 0x3, 0xf0, 0x8,
    0xb9, 0xd8, 0x10, 0x9, 0xa0, 0x3f, 0x0, 0x0,
    0xc, 0x60, 0x0, 0x9a, 0x3, 0xf0, 0x3, 0x44,
    0xd9, 0x44, 0x19, 0xa0, 0x3f, 0x0, 0xde, 0xef,
    0xfe, 0xe7, 0x9a, 0x3, 0xf0, 0x0, 0x3, 0xf6,
    0x0, 0x9, 0xa0, 0x3f, 0x0, 0x0, 0xbf, 0x96,
    0x0, 0x9a, 0x3, 0xf0, 0x0, 0x6d, 0xca, 0xf6,
    0x9, 0xa0, 0x3f, 0x0, 0x2f, 0x4c, 0x64, 0xf5,
    0x9a, 0x3, 0xf0, 0x1d, 0x70, 0xc6, 0x6, 0x29,
    0xa0, 0x3f, 0x2, 0x80, 0xc, 0x60, 0x0, 0x0,
    0x3, 0xf0, 0x0, 0x0, 0xc6, 0x0, 0x0, 0x23,
    0xaf, 0x0, 0x0, 0xc, 0x60, 0x0, 0xa, 0xfd,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5230 "到" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x19, 0xd,
    0xdd, 0xdd, 0xdd, 0xd1, 0x50, 0x3f, 0x5, 0x58,
    0xf6, 0x55, 0x51, 0xf1, 0x3f, 0x0, 0xd, 0x70,
    0x83, 0x0, 0xf1, 0x3f, 0x0, 0x9b, 0x0, 0x6d,
    0x0, 0xf1, 0x3f, 0x7, 0xf9, 0x89, 0xaf, 0x90,
    0xf1, 0x3f, 0x7, 0x98, 0xbd, 0x65, 0xf2, 0xf1,
    0x3f, 0x0, 0x0, 0x7b, 0x0, 0x10, 0xf1, 0x3f,
    0x2, 0x44, 0x9c, 0x44, 0x30, 0xf1, 0x3f, 0x9,
    0xdd, 0xef, 0xdd, 0xc0, 0xf1, 0x3f, 0x0, 0x0,
    0x7b, 0x0, 0x0, 0xf1, 0x3f, 0x0, 0x0, 0x7b,
    0x13, 0x41, 0x10, 0x3f, 0x3b, 0xde, 0xfe, 0xdb,
    0xa3, 0x13, 0x9f, 0x3, 0x21, 0x0, 0x0, 0x0,
    0x8f, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+52A0 "加" */
    0x0, 0xc, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x2e, 0x62, 0x21, 0x1f, 0xff, 0xff, 0x10, 0xff,
    0xff, 0xff, 0x61, 0xf3, 0x23, 0xf1, 0x0, 0xf,
    0x30, 0xd5, 0x1f, 0x10, 0x1f, 0x10, 0x0, 0xf2,
    0xd, 0x51, 0xf1, 0x1, 0xf1, 0x0, 0x1f, 0x10,
    0xe5, 0x1f, 0x10, 0x1f, 0x10, 0x3, 0xf0, 0xe,
    0x41, 0xf1, 0x1, 0xf1, 0x0, 0x6c, 0x0, 0xe4,
    0x1f, 0x10, 0x1f, 0x10, 0xa, 0x90, 0xf, 0x41,
    0xf1, 0x1, 0xf1, 0x0, 0xe4, 0x0, 0xf3, 0x1f,
    0x10, 0x1f, 0x10, 0x6e, 0x0, 0xf, 0x31, 0xf4,
    0x34, 0xf1, 0x1e, 0x60, 0x14, 0xf2, 0x1f, 0xff,
    0xff, 0x18, 0xc0, 0xa, 0xd8, 0x1, 0xf1, 0x1,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+52A1 "务" */
    0x0, 0x0, 0x9, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x54, 0x44, 0x44, 0x20, 0x0,
    0x0, 0x5, 0xfc, 0xbb, 0xbb, 0xcf, 0xa0, 0x0,
    0x0, 0x5f, 0xdb, 0x0, 0x2, 0xdb, 0x10, 0x0,
    0x7, 0xe3, 0x1c, 0xd2, 0x6f, 0x80, 0x0, 0x0,
    0x3, 0x10, 0x0, 0xcf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x4, 0x9e, 0xd7, 0x9f, 0xd8, 0x41, 0x0,
    0x3b, 0xfe, 0xa4, 0x72, 0x0, 0x59, 0xdf, 0xd0,
    0x17, 0x41, 0x11, 0xf5, 0x11, 0x11, 0x11, 0x30,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x0, 0x0, 0x7, 0xd0, 0x0, 0x8, 0xa0, 0x0,
    0x0, 0x0, 0x1e, 0x60, 0x0, 0xa, 0x90, 0x0,
    0x0, 0x3, 0xdb, 0x0, 0x0, 0xd, 0x60, 0x0,
    0x5, 0xbf, 0x80, 0x0, 0x4a, 0xdf, 0x20, 0x0,
    0x9, 0x81, 0x0, 0x0, 0x17, 0x52, 0x0, 0x0,

    /* U+52B9 "効" */
    0x0, 0x3, 0x40, 0x0, 0x0, 0x80, 0x0, 0x0,
    0x0, 0x4c, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3,
    0x34, 0xf3, 0x32, 0x1, 0xf0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xc2, 0x5f, 0x44, 0x40, 0x0, 0x18,
    0x8, 0x10, 0x7e, 0xfe, 0xef, 0x30, 0xa, 0x90,
    0xab, 0x0, 0x2f, 0x0, 0xd3, 0x3, 0xe1, 0x0,
    0xd7, 0x3, 0xe0, 0xe, 0x21, 0xe5, 0x0, 0x56,
    0xe1, 0x4d, 0x0, 0xf2, 0x5, 0xa9, 0xd, 0x51,
    0x6, 0xb0, 0xf, 0x10, 0x1, 0xeb, 0xe0, 0x0,
    0x89, 0x0, 0xf1, 0x0, 0x3, 0xf9, 0x0, 0xc,
    0x50, 0xf, 0x0, 0x0, 0xad, 0xf4, 0x3, 0xf1,
    0x1, 0xf0, 0x0, 0xad, 0x7, 0xe1, 0xba, 0x0,
    0x3f, 0x2, 0xcc, 0x10, 0x6, 0x5f, 0x24, 0xcf,
    0xb0, 0x3a, 0x0, 0x0, 0xa, 0x70, 0x18, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+52D9 "務" */
    0x0, 0x0, 0x0, 0x0, 0xa, 0x10, 0x0, 0x0,
    0x9, 0xbb, 0xbb, 0x70, 0x6d, 0x33, 0x33, 0x0,
    0x4, 0x55, 0x5d, 0x91, 0xec, 0xcc, 0xde, 0x0,
    0x1, 0xd2, 0x6d, 0xb, 0xf4, 0x0, 0xd6, 0x0,
    0x0, 0x4e, 0xe2, 0x5c, 0x3e, 0x3b, 0xa0, 0x0,
    0x2, 0x29, 0xd2, 0x21, 0x7, 0xfd, 0x0, 0x0,
    0x2d, 0xdf, 0xfd, 0xe2, 0x9e, 0x8d, 0xd6, 0x10,
    0x0, 0x3f, 0xc3, 0xdd, 0x7a, 0x10, 0x5b, 0xf1,
    0x0, 0xb8, 0xc8, 0x61, 0x1f, 0x21, 0x10, 0x0,
    0x5, 0xc4, 0xc3, 0x5f, 0xff, 0xff, 0xfa, 0x0,
    0x2e, 0x24, 0xc0, 0x0, 0x5c, 0x0, 0x79, 0x0,
    0x76, 0x4, 0xc0, 0x0, 0xc6, 0x0, 0x88, 0x0,
    0x0, 0x4, 0xb0, 0x1b, 0xb0, 0x0, 0xb7, 0x0,
    0x1, 0xae, 0x94, 0xea, 0x0, 0x9d, 0xf3, 0x0,
    0x0, 0x64, 0x1, 0x50, 0x0, 0x23, 0x0, 0x0,

    /* U+5316 "化" */
    0x0, 0x0, 0x47, 0x2, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x3f, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf2, 0x3, 0xf0, 0x0, 0x6, 0x0, 0x0,
    0xba, 0x0, 0x3f, 0x0, 0x9, 0xe2, 0x0, 0x4f,
    0x50, 0x3, 0xf0, 0x8, 0xf3, 0x0, 0xe, 0xf5,
    0x0, 0x3f, 0x9, 0xf3, 0x0, 0xa, 0xcf, 0x50,
    0x3, 0xfb, 0xe3, 0x0, 0x6, 0xe2, 0xe5, 0x0,
    0x5f, 0xc1, 0x0, 0x0, 0x13, 0xe, 0x50, 0x7f,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xe7, 0xde, 0x8f,
    0x0, 0x0, 0x10, 0x0, 0xe, 0x58, 0x3, 0xf0,
    0x0, 0x7, 0xb0, 0x0, 0xe5, 0x0, 0x3f, 0x0,
    0x0, 0x9a, 0x0, 0xe, 0x50, 0x2, 0xf7, 0x33,
    0x4e, 0x70, 0x0, 0xe5, 0x0, 0xa, 0xff, 0xff,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5347 "升" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x79, 0xb, 0x90, 0x0, 0x3,
    0x8a, 0xdf, 0xfb, 0x70, 0xb9, 0x0, 0x0, 0x4b,
    0x9a, 0xe0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0,
    0x7d, 0x0, 0x0, 0xb9, 0x0, 0x0, 0x0, 0x7,
    0xd0, 0x0, 0xb, 0x90, 0x0, 0x0, 0x0, 0x7d,
    0x0, 0x0, 0xb9, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x3, 0x33, 0x9d, 0x33,
    0x33, 0xca, 0x33, 0x20, 0x0, 0x8, 0xb0, 0x0,
    0xb, 0x90, 0x0, 0x0, 0x0, 0xc8, 0x0, 0x0,
    0xb9, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0, 0xb,
    0x90, 0x0, 0x0, 0x2e, 0xa0, 0x0, 0x0, 0xb9,
    0x0, 0x0, 0x4e, 0xb0, 0x0, 0x0, 0xb, 0x90,
    0x0, 0xa, 0x90, 0x0, 0x0, 0x0, 0xb9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5361 "卡" */
    0x0, 0x0, 0x0, 0x15, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x0, 0x3f, 0x33, 0x33, 0x31, 0x0, 0x0, 0x0,
    0x3, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x3, 0x33, 0x33, 0x6f,
    0x33, 0x33, 0x33, 0x20, 0x0, 0x0, 0x3, 0xf6,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x4c,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x4,
    0xdd, 0x40, 0x0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x79, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x0,
    0x0,

    /* U+53CB "友" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x3, 0x33, 0x6f, 0x43, 0x33, 0x33, 0x33, 0x20,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9d, 0x44, 0x44, 0x44, 0x40, 0x0,
    0x0, 0x0, 0xef, 0xed, 0xdd, 0xde, 0xf0, 0x0,
    0x0, 0x4, 0xfa, 0xb0, 0x0, 0x9, 0xb0, 0x0,
    0x0, 0x9, 0xc0, 0xe4, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x2f, 0x50, 0x5e, 0x21, 0xe9, 0x0, 0x0,
    0x0, 0xad, 0x0, 0x8, 0xed, 0xb0, 0x0, 0x0,
    0x3, 0xf4, 0x0, 0x6, 0xff, 0x60, 0x0, 0x0,
    0x1e, 0xa0, 0x5, 0xde, 0x65, 0xed, 0x50, 0x0,
    0x7d, 0x7, 0xef, 0x81, 0x0, 0x18, 0xfe, 0x80,
    0x1, 0x7, 0x60, 0x0, 0x0, 0x0, 0x6, 0x70,

    /* U+53D1 "发" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x70, 0xd, 0x60, 0x4d, 0x50, 0x0, 0x0,
    0xa9, 0x0, 0xf4, 0x0, 0x7f, 0x80, 0x0, 0xe,
    0x50, 0x2f, 0x10, 0x0, 0x23, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x2, 0x22,
    0xbb, 0x22, 0x22, 0x22, 0x21, 0x0, 0x0, 0xe,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfe,
    0xdd, 0xdd, 0xda, 0x0, 0x0, 0x0, 0xcf, 0xc4,
    0x44, 0x4d, 0xa0, 0x0, 0x0, 0x4f, 0x6f, 0x30,
    0x5, 0xf2, 0x0, 0x0, 0xd, 0xa0, 0x8e, 0x23,
    0xe6, 0x0, 0x0, 0x9, 0xe1, 0x0, 0xae, 0xe8,
    0x0, 0x0, 0x6, 0xf4, 0x0, 0x1a, 0xff, 0x80,
    0x0, 0x5, 0xf6, 0x4, 0xaf, 0xb2, 0x4d, 0xe8,
    0x20, 0x26, 0x1e, 0xf9, 0x20, 0x0, 0x5, 0xcf,
    0xa0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x23,

    /* U+53EF "可" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x7d, 0x22, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5d, 0x0, 0x0, 0x33, 0x33,
    0x32, 0x0, 0x5d, 0x0, 0x1, 0xfe, 0xee, 0xfd,
    0x0, 0x5d, 0x0, 0x1, 0xf1, 0x0, 0x5d, 0x0,
    0x5d, 0x0, 0x1, 0xf1, 0x0, 0x5d, 0x0, 0x5d,
    0x0, 0x1, 0xf1, 0x0, 0x5d, 0x0, 0x5d, 0x0,
    0x1, 0xf1, 0x0, 0x5d, 0x0, 0x5d, 0x0, 0x1,
    0xff, 0xff, 0xfd, 0x0, 0x5d, 0x0, 0x0, 0x11,
    0x11, 0x11, 0x0, 0x5d, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8e, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x24,
    0x20, 0x0,

    /* U+540E "后" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x46, 0x82, 0x0,
    0x2, 0xcd, 0xde, 0xff, 0xfe, 0xca, 0x40, 0x0,
    0x3f, 0x54, 0x32, 0x10, 0x0, 0x0, 0x0, 0x3,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x10, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x4e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0xf, 0xff,
    0xff, 0xff, 0xf4, 0x0, 0xa, 0x80, 0xf3, 0x22,
    0x22, 0x2e, 0x40, 0x0, 0xf3, 0xf, 0x20, 0x0,
    0x0, 0xe4, 0x0, 0x6d, 0x0, 0xf2, 0x0, 0x0,
    0xe, 0x40, 0xe, 0x40, 0xf, 0xdd, 0xdd, 0xdd,
    0xf4, 0x3, 0x80, 0x0, 0xf5, 0x44, 0x44, 0x4f,
    0x40,

    /* U+542C "听" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,
    0x33, 0x33, 0x0, 0x46, 0x8a, 0xdf, 0x70, 0x3f,
    0xff, 0xe0, 0x3f, 0xdb, 0x96, 0x20, 0x3, 0xe0,
    0x3e, 0x3, 0xf0, 0x0, 0x0, 0x0, 0x3e, 0x3,
    0xe0, 0x3f, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x3e,
    0x3, 0xf2, 0x22, 0x22, 0x21, 0x3e, 0x3, 0xe0,
    0x3f, 0xff, 0xff, 0xff, 0x73, 0xe0, 0x3e, 0x4,
    0xe0, 0x5, 0xe0, 0x0, 0x3e, 0x3, 0xe0, 0x4d,
    0x0, 0x5e, 0x0, 0x3, 0xe0, 0x3e, 0x6, 0xb0,
    0x5, 0xe0, 0x0, 0x3e, 0x35, 0xe0, 0xa8, 0x0,
    0x5e, 0x0, 0x3, 0xff, 0xfe, 0x1f, 0x30, 0x5,
    0xe0, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x0, 0x5e,
    0x0, 0x0, 0x0, 0x6, 0xd1, 0x0, 0x5, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+542F "启" */
    0x0, 0x0, 0x0, 0x4, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x22, 0x22, 0x3f, 0x52, 0x22, 0x20, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xf3, 0x0, 0x4f,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x30, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x4e, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x0, 0x5, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0x4d, 0xdd,
    0xdd, 0xdd, 0xdb, 0x0, 0xa, 0x76, 0xe4, 0x44,
    0x44, 0x47, 0xe0, 0x0, 0xf2, 0x6d, 0x0, 0x0,
    0x0, 0x5e, 0x0, 0x6c, 0x6, 0xd0, 0x0, 0x0,
    0x5, 0xe0, 0xe, 0x30, 0x6e, 0x33, 0x33, 0x33,
    0x7e, 0x4, 0x90, 0x6, 0xfd, 0xdd, 0xdd, 0xde,
    0xe0,

    /* U+544A "告" */
    0x0, 0x1, 0x50, 0x5, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x7b, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xec, 0xce, 0xfc, 0xcc, 0xc9, 0x0, 0x8,
    0xc5, 0x55, 0xad, 0x55, 0x55, 0x40, 0x2, 0xf3,
    0x0, 0x7, 0xb0, 0x0, 0x0, 0x0, 0x25, 0x22,
    0x22, 0x8c, 0x22, 0x22, 0x21, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x33, 0x33,
    0x33, 0x33, 0x30, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x1f, 0x10, 0x0, 0x0,
    0x5, 0xe0, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x0,
    0x5e, 0x0, 0x0, 0x1f, 0x32, 0x22, 0x22, 0x26,
    0xe0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0,

    /* U+547D "命" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf4, 0xad, 0x30, 0x0, 0x0,
    0x0, 0x3, 0xdd, 0x20, 0x8, 0xf7, 0x0, 0x0,
    0x2, 0xaf, 0x80, 0x0, 0x0, 0x4e, 0xc4, 0x0,
    0x7f, 0xb7, 0xff, 0xff, 0xff, 0xf9, 0x9f, 0xb0,
    0x23, 0x0, 0x33, 0x33, 0x33, 0x31, 0x2, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x10, 0x0,
    0x0, 0xef, 0xff, 0xd0, 0xef, 0xff, 0xf3, 0x0,
    0x0, 0xe4, 0x15, 0xd0, 0xe4, 0x0, 0xe3, 0x0,
    0x0, 0xe3, 0x4, 0xd0, 0xe3, 0x0, 0xe3, 0x0,
    0x0, 0xe3, 0x4, 0xd0, 0xe3, 0x0, 0xe3, 0x0,
    0x0, 0xe5, 0x25, 0xd0, 0xe3, 0x4, 0xf2, 0x0,
    0x0, 0xef, 0xff, 0xd0, 0xe3, 0x3f, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe3, 0x0, 0x0, 0x0,

    /* U+54CD "响" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x80, 0x0, 0x45, 0x54, 0x0,
    0x3, 0xf3, 0x0, 0xd, 0xdd, 0xe2, 0xff, 0xff,
    0xff, 0xfe, 0xd3, 0x2e, 0x2e, 0x11, 0x11, 0x13,
    0xfd, 0x32, 0xe2, 0xe0, 0x0, 0x0, 0x2f, 0xd3,
    0x2e, 0x2e, 0xd, 0xff, 0xa2, 0xfd, 0x32, 0xe2,
    0xe0, 0xe1, 0x4b, 0x2f, 0xd3, 0x2e, 0x2e, 0xe,
    0x4, 0xb2, 0xfd, 0x32, 0xe2, 0xe0, 0xe0, 0x4b,
    0x2f, 0xd3, 0x2e, 0x2e, 0xe, 0x4, 0xb2, 0xfd,
    0x32, 0xe2, 0xe0, 0xee, 0xeb, 0x2f, 0xdf, 0xfe,
    0x2e, 0x1, 0x22, 0x12, 0xf1, 0x22, 0x12, 0xe0,
    0x0, 0x0, 0x6e, 0x0, 0x0, 0x2e, 0x0, 0x0,
    0xee, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+554F "問" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0x22, 0xff, 0xff, 0xf0, 0x3e, 0x0,
    0xf, 0x22, 0xe0, 0x2, 0xf0, 0x3f, 0xff, 0xff,
    0x22, 0xff, 0xff, 0xf0, 0x3e, 0x0, 0xf, 0x22,
    0xe0, 0x2, 0xf0, 0x3f, 0x33, 0x3f, 0x22, 0xf3,
    0x35, 0xf0, 0x3f, 0xcc, 0xcc, 0x21, 0xcc, 0xcc,
    0xf0, 0x3e, 0x0, 0x1, 0x11, 0x10, 0x2, 0xf0,
    0x3e, 0x0, 0xef, 0xff, 0xfd, 0x2, 0xf0, 0x3e,
    0x0, 0xe2, 0x0, 0x2d, 0x2, 0xf0, 0x3e, 0x0,
    0xe2, 0x0, 0x2d, 0x2, 0xf0, 0x3e, 0x0, 0xef,
    0xff, 0xfd, 0x2, 0xf0, 0x3e, 0x0, 0x1, 0x11,
    0x10, 0x16, 0xf0, 0x3e, 0x0, 0x0, 0x0, 0x9,
    0xfc, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+555F "啟" */
    0x0, 0x0, 0x92, 0x0, 0x0, 0x75, 0x0, 0x0,
    0x0, 0x0, 0xa8, 0x0, 0x0, 0xd4, 0x0, 0x0,
    0x0, 0xdd, 0xef, 0xdb, 0x2, 0xf4, 0x33, 0x30,
    0x0, 0xf4, 0x44, 0x5e, 0x8, 0xff, 0xff, 0xd0,
    0x0, 0xf0, 0x0, 0x2e, 0xf, 0x40, 0x2e, 0x0,
    0x0, 0xf5, 0x55, 0x6e, 0x7f, 0x60, 0x4c, 0x0,
    0x0, 0xfc, 0xcc, 0xcb, 0xbb, 0x90, 0x79, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x3, 0xd0, 0xb6, 0x0,
    0x1, 0xea, 0xff, 0xfe, 0x0, 0xe5, 0xf1, 0x0,
    0x3, 0xda, 0x82, 0x3e, 0x0, 0x6e, 0xb0, 0x0,
    0x5, 0xba, 0x70, 0x2e, 0x0, 0x2f, 0x70, 0x0,
    0x9, 0x8a, 0x70, 0x2e, 0x0, 0xcc, 0xf2, 0x0,
    0xe, 0x3a, 0x94, 0x5e, 0xb, 0xd0, 0x8e, 0x20,
    0x6d, 0x8, 0xdd, 0xdc, 0xbd, 0x10, 0xa, 0xe1,
    0x12, 0x0, 0x0, 0x0, 0x61, 0x0, 0x0, 0x60,

    /* U+5668 "器" */
    0x1, 0xff, 0xff, 0xf0, 0x9f, 0xff, 0xf7, 0x0,
    0x1f, 0x0, 0x1f, 0x9, 0x70, 0x9, 0x70, 0x1,
    0xf1, 0x12, 0xf0, 0x98, 0x11, 0x97, 0x0, 0x1e,
    0xee, 0xee, 0x8, 0xef, 0xee, 0x70, 0x0, 0x0,
    0x0, 0x2d, 0x10, 0xc6, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x11, 0x1b,
    0xe2, 0x9e, 0x31, 0x11, 0x0, 0x2, 0x7e, 0xc2,
    0x0, 0x7f, 0x93, 0x0, 0x5e, 0xfe, 0x83, 0x30,
    0x13, 0x4c, 0xff, 0xa1, 0x5f, 0xcc, 0xcf, 0xa,
    0xdc, 0xce, 0x94, 0x0, 0xf1, 0x1, 0xf0, 0xa7,
    0x0, 0xa7, 0x0, 0xf, 0x21, 0x2f, 0xa, 0x71,
    0x1a, 0x70, 0x0, 0xfd, 0xdd, 0xf0, 0xae, 0xdd,
    0xe7, 0x0,

    /* U+5728 "在" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xe0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x3, 0x33,
    0x6f, 0x33, 0x33, 0x33, 0x33, 0x10, 0x0, 0xc,
    0x90, 0x0, 0xd2, 0x0, 0x0, 0x0, 0x6, 0xe1,
    0x0, 0xf, 0x30, 0x0, 0x0, 0x3, 0xf5, 0x0,
    0x0, 0xf3, 0x0, 0x0, 0x2, 0xef, 0x48, 0xff,
    0xff, 0xff, 0xfe, 0x2, 0xea, 0xf4, 0x13, 0x33,
    0xf5, 0x33, 0x20, 0x59, 0xf, 0x40, 0x0, 0xf,
    0x30, 0x0, 0x0, 0x0, 0xf4, 0x0, 0x0, 0xf3,
    0x0, 0x0, 0x0, 0xf, 0x40, 0x0, 0xf, 0x30,
    0x0, 0x0, 0x0, 0xf7, 0xee, 0xee, 0xfe, 0xee,
    0xe9, 0x0, 0xf, 0x43, 0x33, 0x33, 0x33, 0x33,
    0x20,

    /* U+5831 "報" */
    0x0, 0x1, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x13, 0xf1, 0x10, 0xce, 0xee, 0xee, 0x20,
    0x6, 0xff, 0xff, 0xf4, 0xd5, 0x11, 0x1f, 0x20,
    0x0, 0x2, 0xf0, 0x0, 0xd4, 0x2, 0x4f, 0x10,
    0x2, 0x24, 0xf2, 0x21, 0xd4, 0x2f, 0xfb, 0x0,
    0x1f, 0xff, 0xff, 0xfb, 0xd4, 0x2, 0x10, 0x0,
    0x0, 0x86, 0xb, 0x40, 0xdc, 0xbb, 0xbb, 0x20,
    0x0, 0x5a, 0xf, 0x10, 0xd9, 0xd4, 0x4d, 0x10,
    0x9, 0xff, 0xff, 0xf7, 0xd4, 0xe1, 0x1d, 0x0,
    0x0, 0x13, 0xf1, 0x10, 0xd4, 0x98, 0x78, 0x0,
    0x2, 0x23, 0xf2, 0x21, 0xd4, 0x1e, 0xe1, 0x0,
    0x3f, 0xff, 0xff, 0xfb, 0xd4, 0x1d, 0xd1, 0x0,
    0x0, 0x2, 0xf0, 0x0, 0xd7, 0xd8, 0x7d, 0x40,
    0x0, 0x2, 0xf0, 0x0, 0xdb, 0x40, 0x4, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5907 "备" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xcc, 0xcc, 0xcc, 0xc0, 0x0,
    0x0, 0xb, 0xf7, 0x44, 0x44, 0x7f, 0xc0, 0x0,
    0x1, 0xcd, 0x9f, 0x50, 0x7, 0xfa, 0x0, 0x0,
    0xc, 0xb1, 0x7, 0xfb, 0xed, 0x40, 0x0, 0x0,
    0x1, 0x0, 0x27, 0xef, 0xf9, 0x40, 0x0, 0x0,
    0x15, 0x9d, 0xfc, 0x50, 0x5a, 0xff, 0xc9, 0x60,
    0x3d, 0xa8, 0x32, 0x22, 0x22, 0x25, 0x9a, 0xc0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x4e, 0x0, 0xe, 0x40, 0x4, 0xe0, 0x0,
    0x0, 0x4f, 0xdd, 0xdf, 0xed, 0xde, 0xe0, 0x0,
    0x0, 0x4e, 0x22, 0x2e, 0x62, 0x26, 0xe0, 0x0,
    0x0, 0x4e, 0x0, 0xe, 0x40, 0x5, 0xe0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,

    /* U+5927 "大" */
    0x0, 0x0, 0x0, 0xa, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0xd, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x23, 0x33,
    0x33, 0xe8, 0x33, 0x33, 0x30, 0x0, 0x0, 0x0,
    0xf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd8,
    0xc7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8e, 0x13,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x40, 0x8,
    0xd1, 0x0, 0x0, 0x0, 0x9f, 0x60, 0x0, 0xb,
    0xd2, 0x0, 0x3, 0xcf, 0x50, 0x0, 0x0, 0xb,
    0xe5, 0x2, 0xfd, 0x20, 0x0, 0x0, 0x0, 0x8,
    0xf7, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x10,

    /* U+5931 "失" */
    0x0, 0x1, 0x20, 0x9, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x8b, 0x0, 0xb8, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x71, 0x1c, 0x81, 0x11, 0x10, 0x0, 0x4,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0x0, 0xb9,
    0x22, 0x2c, 0x92, 0x22, 0x21, 0x0, 0x4f, 0x20,
    0x0, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0,
    0xd, 0x70, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x3, 0x44, 0x44, 0x6f,
    0xd4, 0x44, 0x44, 0x10, 0x0, 0x0, 0xa, 0xdf,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf3, 0x8e,
    0x20, 0x0, 0x0, 0x0, 0x8, 0xf5, 0x0, 0xbd,
    0x30, 0x0, 0x0, 0x4c, 0xe4, 0x0, 0x0, 0xaf,
    0x91, 0x0, 0xcf, 0xa1, 0x0, 0x0, 0x0, 0x4d,
    0xf7, 0x5, 0x20, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x10,

    /* U+597D "好" */
    0x0, 0xd, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x7c, 0xcc, 0xcc, 0xc2, 0x0,
    0x3f, 0x0, 0x3, 0x66, 0x66, 0xce, 0x11, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x7e, 0x20, 0x3, 0x9b,
    0x38, 0xb0, 0x0, 0x8e, 0x20, 0x0, 0xb, 0x70,
    0x88, 0x0, 0xe, 0x50, 0x0, 0x0, 0xe4, 0xb,
    0x73, 0x33, 0xf7, 0x33, 0x30, 0x1f, 0x0, 0xe6,
    0xff, 0xff, 0xff, 0xfd, 0x5, 0xf2, 0x3e, 0x0,
    0x0, 0xe4, 0x0, 0x0, 0x8, 0xfc, 0x90, 0x0,
    0xe, 0x40, 0x0, 0x0, 0x8, 0xfa, 0x0, 0x0,
    0xe4, 0x0, 0x0, 0x4, 0xf7, 0xec, 0x10, 0xe,
    0x40, 0x0, 0x5, 0xf7, 0x1, 0xb1, 0x35, 0xf4,
    0x0, 0x1, 0xe6, 0x0, 0x0, 0xd, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+59CB "始" */
    0x0, 0x49, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x6, 0xa0, 0x0, 0x1, 0xe5, 0x0, 0x0, 0x0,
    0x88, 0x0, 0x0, 0x8c, 0x6, 0xc0, 0x2, 0xef,
    0xfe, 0xe1, 0x2f, 0x30, 0xe, 0x60, 0x4, 0xd7,
    0x4f, 0x1b, 0x80, 0x0, 0x7e, 0x0, 0xf, 0x22,
    0xf8, 0xfe, 0xff, 0xff, 0xf7, 0x1, 0xf0, 0x4d,
    0x24, 0x33, 0x21, 0x5, 0x80, 0x4c, 0x6, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0x90, 0xb8, 0xe,
    0xff, 0xff, 0xfe, 0x0, 0x6f, 0x7f, 0x30, 0xe5,
    0x22, 0x25, 0xe0, 0x0, 0x5f, 0xe0, 0xe, 0x30,
    0x0, 0x4e, 0x0, 0x1, 0xef, 0x80, 0xe3, 0x0,
    0x4, 0xe0, 0x0, 0xc9, 0x4f, 0x6e, 0x63, 0x33,
    0x6e, 0x0, 0xb7, 0x0, 0x52, 0xee, 0xdd, 0xde,
    0xe0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5B8C "完" */
    0x0, 0x0, 0x0, 0xd, 0x20, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0xd8, 0x11, 0x11, 0x10, 0xa,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0xa8,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xe0, 0xa, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x4e, 0x0, 0x11, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x20, 0x0, 0x1, 0x11,
    0x11, 0x11, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x22, 0x24, 0xf3, 0x26,
    0xe2, 0x22, 0x20, 0x0, 0x0, 0x5f, 0x0, 0x4e,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x4, 0xe0,
    0x0, 0xb5, 0x0, 0x2c, 0xe1, 0x0, 0x3f, 0x31,
    0x3e, 0x40, 0xcf, 0xa1, 0x0, 0x0, 0xbf, 0xff,
    0xa0, 0x5, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5B9A "定" */
    0x0, 0x0, 0x0, 0x8, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x22, 0x22, 0x27, 0xd2, 0x22, 0x22, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x4, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x20,
    0x2, 0x90, 0x0, 0x0, 0x0, 0x0, 0xa, 0x10,
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x12, 0x22, 0x25, 0xe2, 0x22, 0x21, 0x0,
    0x0, 0x2, 0x50, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xd0, 0x4, 0xe2, 0x22, 0x21, 0x0,
    0x0, 0xa, 0xa0, 0x4, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0xe, 0x80, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xf5, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x1, 0xe7, 0x5f, 0xa8, 0xe1, 0x11, 0x22, 0x20,
    0x1d, 0xb0, 0x2, 0x9e, 0xff, 0xff, 0xff, 0xd0,
    0x6, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5BFB "寻" */
    0x0, 0x12, 0x22, 0x22, 0x22, 0x22, 0x20, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x2,
    0xdd, 0xdd, 0xdd, 0xdd, 0xef, 0x0, 0x0, 0x3,
    0x33, 0x33, 0x33, 0x35, 0xf0, 0x0, 0x1, 0x22,
    0x22, 0x22, 0x22, 0x4f, 0x0, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x80, 0x0, 0x2, 0x22, 0x22, 0x22,
    0x22, 0x6f, 0x22, 0x16, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x5f, 0x0, 0x0, 0x0, 0x3d, 0xd2, 0x0, 0x5,
    0xf0, 0x0, 0x0, 0x0, 0xa, 0xc0, 0x0, 0x5e,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x6, 0xae, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x58, 0x61, 0x0,
    0x0,

    /* U+5C06 "将" */
    0x0, 0x0, 0x30, 0x0, 0x5, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x5f, 0x30, 0x0, 0x0,
    0x0, 0x3, 0xe0, 0x2, 0xfb, 0x11, 0x11, 0x0,
    0x9, 0x3, 0xe0, 0x2e, 0xed, 0xdd, 0xdf, 0x40,
    0xc, 0x63, 0xe3, 0xef, 0x50, 0x0, 0xac, 0x0,
    0x6, 0xc3, 0xe7, 0x84, 0xe6, 0x1b, 0xc1, 0x0,
    0x1, 0xf5, 0xe0, 0x0, 0x3a, 0xe8, 0x0, 0x0,
    0x0, 0x95, 0xe0, 0x5a, 0xea, 0x22, 0xd0, 0x0,
    0x0, 0x8, 0xe1, 0xb6, 0x10, 0x3, 0xf0, 0x0,
    0x1, 0xbe, 0xea, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x3e, 0xb4, 0xe1, 0x3c, 0x21, 0x14, 0xf1, 0x10,
    0x27, 0x3, 0xe0, 0xb, 0xc0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0xc8, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x10, 0x16, 0xf0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x4, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C07 "將" */
    0x0, 0x0, 0x15, 0x0, 0x2, 0x50, 0x0, 0x0,
    0x0, 0x50, 0x2e, 0x0, 0xb, 0xb0, 0x0, 0x0,
    0x1, 0xf0, 0x2e, 0x0, 0x7f, 0x51, 0x11, 0x0,
    0x1, 0xf0, 0x2e, 0x5, 0xff, 0xff, 0xff, 0x40,
    0x1, 0xf0, 0x2e, 0x6f, 0x9c, 0x60, 0x7c, 0x0,
    0x1, 0xfd, 0xde, 0x57, 0xc2, 0x48, 0xd1, 0x0,
    0x0, 0x55, 0x6e, 0x0, 0x45, 0xcc, 0x50, 0x0,
    0x0, 0x0, 0x2e, 0x7, 0xde, 0x62, 0xf0, 0x0,
    0x18, 0x88, 0x9e, 0xb, 0x50, 0x2, 0xf0, 0x0,
    0x1a, 0xfa, 0xbe, 0x8f, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xe1, 0x2e, 0x17, 0x52, 0x23, 0xf2, 0x20,
    0x0, 0xf0, 0x2e, 0x5, 0xe5, 0x2, 0xf0, 0x0,
    0x4, 0xc0, 0x2e, 0x0, 0x3c, 0x2, 0xf0, 0x0,
    0xb, 0x70, 0x2e, 0x0, 0x1, 0x38, 0xf0, 0x0,
    0x3d, 0x0, 0x2e, 0x0, 0x4, 0xec, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5C0B "尋" */
    0x0, 0x9e, 0xee, 0xee, 0xee, 0xee, 0xf0, 0x0,
    0x0, 0x22, 0x22, 0x22, 0x22, 0x4f, 0x0, 0x0,
    0x2b, 0xbb, 0xbb, 0xbb, 0xbc, 0xf0, 0x0, 0x7,
    0x88, 0x88, 0x88, 0x88, 0x9f, 0x0, 0x0, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x40, 0x0, 0x6e, 0xee,
    0xee, 0x5d, 0xee, 0xee, 0x90, 0x0, 0x1, 0xf0,
    0x0, 0xe2, 0x0, 0x7a, 0x0, 0x8a, 0xbf, 0xcc,
    0x7e, 0xed, 0xde, 0xa0, 0x3, 0x32, 0x0, 0x0,
    0x0, 0x39, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x9, 0xa2, 0x0, 0x0,
    0x4d, 0x0, 0x0, 0x0, 0x7, 0xe6, 0x0, 0x18,
    0xc0, 0x0, 0x0, 0x0, 0x2, 0x20, 0xef, 0xe5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5C11 "少" */
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa4, 0xe, 0x50, 0xd3, 0x0, 0x0, 0x0,
    0x3f, 0x20, 0xe5, 0x7, 0xe2, 0x0, 0x0, 0xb,
    0xa0, 0xe, 0x50, 0xa, 0xd0, 0x0, 0x3, 0xf2,
    0x0, 0xe5, 0x0, 0xc, 0xb0, 0x0, 0xca, 0x0,
    0xe, 0x50, 0x0, 0x2f, 0x70, 0x6f, 0x10, 0x0,
    0xe5, 0x0, 0x68, 0x65, 0xa, 0x70, 0x0, 0xe,
    0x50, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x72,
    0x7f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x1, 0xbe,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x29, 0xfb, 0x10,
    0x0, 0x0, 0x0, 0x16, 0xbf, 0xc4, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xf9, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x7, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5DF2 "已" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x14,
    0x44, 0x44, 0x44, 0x44, 0x8e, 0x0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x5e, 0x0, 0xe, 0x50, 0x0,
    0x0, 0x0, 0x5e, 0x0, 0xe, 0x50, 0x0, 0x0,
    0x0, 0x5e, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0xe, 0x84, 0x44, 0x44, 0x44, 0x44,
    0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x50, 0x0, 0x0, 0x0, 0x0, 0xe4, 0xe, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xf3, 0xc, 0xc5, 0x33,
    0x32, 0x33, 0x4a, 0xf1, 0x4, 0xdf, 0xff, 0xff,
    0xff, 0xfe, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+5E94 "应" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0x80, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3, 0xe2,
    0x22, 0x22, 0x22, 0x22, 0x21, 0x0, 0x3e, 0x0,
    0x0, 0x73, 0x0, 0x3, 0x0, 0x3, 0xe4, 0xd0,
    0xa, 0x80, 0x4, 0xe0, 0x0, 0x3e, 0xe, 0x30,
    0x6b, 0x0, 0x8a, 0x0, 0x4, 0xe0, 0xa8, 0x3,
    0xf0, 0xd, 0x50, 0x0, 0x4d, 0x5, 0xd0, 0xf,
    0x22, 0xf1, 0x0, 0x6, 0xc0, 0xf, 0x20, 0xd5,
    0x7b, 0x0, 0x0, 0x99, 0x0, 0xb6, 0x5, 0x2c,
    0x60, 0x0, 0xc, 0x60, 0x3, 0x10, 0x2, 0xf0,
    0x0, 0x1, 0xf2, 0x22, 0x22, 0x22, 0x9b, 0x22,
    0x20, 0x8b, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x37, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5EA6 "度" */
    0x0, 0x0, 0x0, 0x4, 0xa0, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x3f, 0x41, 0x11, 0x10, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80, 0xe,
    0x30, 0x28, 0x0, 0x2, 0x80, 0x0, 0x0, 0xe8,
    0xcc, 0xfc, 0xcc, 0xcf, 0xcc, 0x60, 0xe, 0x54,
    0x6f, 0x44, 0x47, 0xf4, 0x42, 0x0, 0xe3, 0x3,
    0xe0, 0x0, 0x4e, 0x0, 0x0, 0xf, 0x30, 0x3f,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x3f, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x3, 0xf0, 0xb, 0xa0, 0x0,
    0x4f, 0x60, 0x0, 0x7c, 0x0, 0xb, 0xc3, 0x8f,
    0x60, 0x0, 0xc, 0x70, 0x0, 0x4e, 0xff, 0x81,
    0x0, 0x4, 0xf2, 0x8b, 0xfd, 0x82, 0x5a, 0xfe,
    0xb7, 0x57, 0x8, 0x62, 0x0, 0x0, 0x0, 0x26,
    0x50,

    /* U+5F00 "开" */
    0x5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x13, 0x39, 0xd3, 0x33, 0x3f, 0x73, 0x30, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0xf, 0x50, 0x0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x11, 0x18,
    0xd1, 0x11, 0x1f, 0x61, 0x11, 0x3f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x11, 0x19, 0xb1,
    0x11, 0x1f, 0x61, 0x11, 0x0, 0x0, 0xb8, 0x0,
    0x0, 0xf5, 0x0, 0x0, 0x0, 0x1f, 0x40, 0x0,
    0xf, 0x50, 0x0, 0x0, 0xa, 0xd0, 0x0, 0x0,
    0xf5, 0x0, 0x0, 0x9, 0xe2, 0x0, 0x0, 0xf,
    0x50, 0x0, 0x5, 0xe3, 0x0, 0x0, 0x0, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+5F0F "式" */
    0x0, 0x0, 0x0, 0x0, 0x5a, 0x8, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xd0, 0x6e, 0x10, 0x2,
    0x22, 0x22, 0x22, 0x7e, 0x22, 0xb7, 0x10, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xf1, 0x0, 0x0, 0x2, 0x44, 0x44,
    0x44, 0x1f, 0x20, 0x0, 0x0, 0x7e, 0xef, 0xee,
    0xe1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xd6, 0x0,
    0xc, 0x70, 0x0, 0x0, 0x0, 0xd, 0x60, 0x0,
    0x9b, 0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x4,
    0xf0, 0x4, 0x30, 0x13, 0x4e, 0xba, 0xc9, 0xe,
    0x70, 0xa7, 0x1f, 0xec, 0xa8, 0x64, 0x10, 0x7f,
    0x7f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x90,

    /* U+5F55 "录" */
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xa0, 0x0, 0x3,
    0xcc, 0xcc, 0xcc, 0xcc, 0xea, 0x0, 0x0, 0x14,
    0x44, 0x44, 0x44, 0x4a, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9a, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0x8, 0x50, 0x0,
    0xc8, 0x0, 0x7, 0x40, 0x0, 0x4f, 0x90, 0xc,
    0xf1, 0x9, 0xf5, 0x0, 0x0, 0x2c, 0x38, 0xcd,
    0xcd, 0xd2, 0x0, 0x0, 0x0, 0x7f, 0xac, 0x6b,
    0xf2, 0x0, 0x0, 0x4, 0xdd, 0x40, 0xc6, 0x9,
    0xf7, 0x0, 0xc, 0xf7, 0x0, 0xd, 0x50, 0x4,
    0xde, 0x70, 0x51, 0x0, 0xcd, 0xf3, 0x0, 0x0,
    0x55, 0x0, 0x0, 0x5, 0x52, 0x0, 0x0, 0x0,
    0x0,

    /* U+5F85 "待" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x20, 0x0, 0xf2, 0x0, 0x0, 0x0,
    0xb, 0xb0, 0x0, 0x1f, 0x30, 0x0, 0x0, 0xa,
    0xd1, 0x4f, 0xff, 0xff, 0xff, 0xb0, 0xa, 0xd1,
    0x10, 0x22, 0x3f, 0x42, 0x21, 0x0, 0x91, 0x3f,
    0x10, 0x1, 0xf3, 0x0, 0x0, 0x0, 0xd, 0xae,
    0xee, 0xef, 0xee, 0xee, 0xb0, 0xa, 0xf0, 0x22,
    0x22, 0x22, 0xf6, 0x22, 0x9, 0xff, 0x0, 0x0,
    0x0, 0xf, 0x40, 0x5, 0xe5, 0xf0, 0xef, 0xff,
    0xff, 0xff, 0xf5, 0x2, 0x3f, 0x1, 0x73, 0x22,
    0x2f, 0x52, 0x0, 0x3, 0xf0, 0xa, 0xc1, 0x0,
    0xf4, 0x0, 0x0, 0x3f, 0x0, 0xb, 0x90, 0xf,
    0x40, 0x0, 0x3, 0xf0, 0x0, 0x1, 0x25, 0xf3,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0xc, 0xc8, 0x0,
    0x0,

    /* U+5F8C "後" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa2, 0x0, 0x4c, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xd0, 0x3, 0xe4, 0x1, 0xd3, 0x0,
    0x0, 0x8e, 0x10, 0x5e, 0x40, 0x2d, 0x80, 0x0,
    0x8, 0xe2, 0x8, 0xff, 0xef, 0xf7, 0x0, 0x0,
    0xa, 0x20, 0x91, 0x10, 0x7e, 0x51, 0xd1, 0x0,
    0x0, 0x7, 0xc0, 0x2b, 0xc2, 0x0, 0x9b, 0x0,
    0x0, 0x2f, 0x28, 0xff, 0xee, 0xff, 0xff, 0x70,
    0x1, 0xde, 0x2, 0x37, 0x61, 0x0, 0x5, 0x80,
    0xb, 0xde, 0x0, 0x2e, 0x83, 0x33, 0x31, 0x0,
    0x3b, 0x3e, 0x1, 0xdf, 0xbb, 0xbb, 0xf5, 0x0,
    0x0, 0x2e, 0x2d, 0xad, 0x70, 0xa, 0xa0, 0x0,
    0x0, 0x2e, 0x45, 0x1, 0xbc, 0xd7, 0x0, 0x0,
    0x0, 0x2e, 0x1, 0x59, 0xd9, 0xcd, 0x84, 0x10,
    0x0, 0x2e, 0x7d, 0x94, 0x0, 0x2, 0x8d, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5FDC "応" */
    0x0, 0x0, 0x0, 0x0, 0xb3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa9, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x4e, 0x22, 0x22, 0x42, 0x22, 0x22, 0x20,
    0x0, 0x4e, 0x0, 0x0, 0xc9, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x1d, 0x90, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0xf, 0x12, 0xe5, 0x0, 0x0,
    0x0, 0x5d, 0xa, 0x5f, 0x10, 0x20, 0x6b, 0x0,
    0x0, 0x6c, 0xf, 0x3f, 0x10, 0x0, 0x1f, 0x20,
    0x0, 0x8a, 0x3e, 0xf, 0x10, 0x0, 0xb, 0x80,
    0x0, 0xb8, 0x9a, 0xf, 0x10, 0x2, 0xb5, 0xe0,
    0x0, 0xf4, 0xc4, 0xf, 0x10, 0x3, 0xe0, 0x80,
    0x6, 0xe0, 0x0, 0xf, 0x62, 0x29, 0xc0, 0x0,
    0xe, 0x60, 0x0, 0xb, 0xff, 0xff, 0x50, 0x0,
    0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6001 "态" */
    0x0, 0x0, 0x0, 0xd, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x2, 0x22, 0x22, 0xde, 0xd2, 0x22, 0x22, 0x0,
    0x0, 0x0, 0x8, 0xe2, 0xca, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xaf, 0xb0, 0x1c, 0xd3, 0x0, 0x0,
    0x3, 0x9f, 0xb3, 0xcc, 0x10, 0x8f, 0xb5, 0x0,
    0x6f, 0xb4, 0x0, 0xa, 0x30, 0x1, 0x8e, 0xd0,
    0x2, 0x20, 0x55, 0xc, 0x20, 0x3, 0x20, 0x10,
    0x0, 0xe5, 0xa9, 0x7, 0xc0, 0x8, 0xc0, 0x0,
    0x4, 0xe0, 0xa9, 0x0, 0xd5, 0x0, 0xd7, 0x0,
    0xb, 0x80, 0xa9, 0x0, 0x10, 0xc3, 0x4f, 0x10,
    0x3f, 0x10, 0x9b, 0x10, 0x3, 0xf1, 0xb, 0x60,
    0x2, 0x0, 0x3e, 0xff, 0xff, 0xa0, 0x1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+606F "息" */
    0x0, 0x0, 0x0, 0x39, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x33, 0xae, 0x33, 0x33, 0x30, 0x0,
    0x0, 0x4f, 0xcc, 0xcc, 0xcc, 0xcd, 0xe0, 0x0,
    0x0, 0x4e, 0x11, 0x11, 0x11, 0x15, 0xe0, 0x0,
    0x0, 0x4f, 0xee, 0xee, 0xee, 0xee, 0xe0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x20, 0x34, 0xb, 0x50, 0x0, 0x40, 0x0,
    0x1, 0xf2, 0x7c, 0x3, 0xf2, 0x0, 0xd8, 0x0,
    0x6, 0xc0, 0x7c, 0x0, 0x95, 0x96, 0x2f, 0x30,
    0xd, 0x40, 0x6d, 0x10, 0x1, 0xd7, 0x6, 0xd0,
    0x29, 0x0, 0x2d, 0xff, 0xff, 0xc1, 0x0, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+60C5 "情" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0xc, 0x40, 0x0, 0x0,
    0x0, 0x2f, 0x0, 0x22, 0x2d, 0x62, 0x22, 0x0,
    0x0, 0x2f, 0x5, 0xcc, 0xcf, 0xdc, 0xcc, 0x30,
    0xc, 0x6f, 0xd1, 0x56, 0x6e, 0x96, 0x64, 0x0,
    0xe, 0x4f, 0x5a, 0x45, 0x5d, 0x85, 0x53, 0x0,
    0xf, 0x2f, 0xc, 0xcc, 0xcf, 0xdc, 0xcc, 0xc0,
    0x2d, 0x2f, 0x1, 0x11, 0x11, 0x11, 0x11, 0x10,
    0x4b, 0x2f, 0x0, 0xde, 0xee, 0xee, 0xe7, 0x0,
    0x35, 0x2f, 0x0, 0xe3, 0x0, 0x0, 0x98, 0x0,
    0x0, 0x2f, 0x0, 0xee, 0xee, 0xee, 0xf8, 0x0,
    0x0, 0x2f, 0x0, 0xe2, 0x0, 0x0, 0x98, 0x0,
    0x0, 0x2f, 0x0, 0xee, 0xee, 0xee, 0xf8, 0x0,
    0x0, 0x2f, 0x0, 0xe2, 0x0, 0x0, 0x97, 0x0,
    0x0, 0x2f, 0x0, 0xe2, 0x0, 0x2b, 0xc3, 0x0,

    /* U+614B "態" */
    0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xe1, 0x0, 0x2e, 0x0, 0x15, 0x0,
    0x0, 0x6d, 0x25, 0xc0, 0x2f, 0x6b, 0xd7, 0x0,
    0x9, 0xfb, 0xbb, 0xfc, 0x3f, 0x83, 0x5, 0x30,
    0x3, 0x33, 0x22, 0x1a, 0x5f, 0x0, 0xb, 0x50,
    0x0, 0xcb, 0xbb, 0xc5, 0xa, 0xdc, 0xca, 0x0,
    0x0, 0xf0, 0x0, 0x97, 0x2d, 0x0, 0x4, 0x0,
    0x0, 0xfc, 0xcc, 0xe7, 0x2e, 0x17, 0xec, 0x0,
    0x0, 0xf6, 0x66, 0xc7, 0x2f, 0xc7, 0x23, 0x10,
    0x0, 0xf4, 0x44, 0xb6, 0x2f, 0x10, 0xa, 0x70,
    0x0, 0xf0, 0x2d, 0xf5, 0xc, 0xff, 0xfd, 0x10,
    0x0, 0x82, 0x2c, 0x29, 0x90, 0x0, 0x72, 0x0,
    0x0, 0xe5, 0x4e, 0x0, 0xa6, 0x32, 0x6d, 0x10,
    0x9, 0xc0, 0x3f, 0x10, 0x0, 0xb8, 0xa, 0xb0,
    0xa, 0x10, 0xc, 0xff, 0xff, 0xd2, 0x1, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+61C9 "應" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5b, 0x0, 0x0, 0x0, 0x0,
    0xcd, 0xdd, 0xdd, 0xfd, 0xdd, 0xdd, 0x60, 0xe,
    0x42, 0x85, 0x66, 0x29, 0x22, 0x21, 0x0, 0xe2,
    0xd, 0x1b, 0x85, 0xe6, 0x55, 0x0, 0xe, 0x26,
    0xc1, 0xf8, 0x8f, 0x88, 0x81, 0x0, 0xe3, 0xeb,
    0xaf, 0xaa, 0xfa, 0xa8, 0x0, 0xe, 0xdb, 0xdc,
    0xe2, 0x2e, 0x22, 0x20, 0x0, 0xf4, 0x3b, 0xe,
    0xdd, 0xfd, 0xdb, 0x0, 0xf, 0x12, 0xb0, 0xe0,
    0xe, 0x0, 0x0, 0x1, 0xf0, 0x2a, 0xb, 0xdc,
    0xcc, 0xcc, 0x50, 0x5c, 0x4, 0x46, 0x1b, 0x50,
    0xb, 0x20, 0x9, 0x80, 0xe4, 0xb3, 0x1d, 0x24,
    0x7c, 0x1, 0xf3, 0x9a, 0xb, 0x50, 0x6, 0xb0,
    0xb7, 0x7b, 0x9, 0x10, 0x6f, 0xff, 0xf5, 0x2,
    0x20, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6211 "我" */
    0x0, 0x0, 0x0, 0x0, 0x55, 0x0, 0x0, 0x0,
    0x2, 0x46, 0x9d, 0x58, 0x94, 0xc1, 0x0, 0x7,
    0xec, 0xfa, 0x40, 0x7a, 0xa, 0xd1, 0x0, 0x0,
    0xe, 0x50, 0x7, 0xb0, 0xb, 0x80, 0x2, 0x22,
    0xe6, 0x22, 0x7c, 0x22, 0x32, 0x11, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x0, 0xe5,
    0x0, 0x3e, 0x0, 0x4, 0x0, 0x0, 0xe, 0x50,
    0x21, 0xf0, 0xb, 0xa0, 0x1, 0x47, 0xfe, 0xfb,
    0xf, 0x3a, 0xc0, 0x0, 0xdc, 0x9f, 0x70, 0x0,
    0xbe, 0xb0, 0x0, 0x0, 0x0, 0xe5, 0x0, 0x5e,
    0xd0, 0x2, 0x10, 0x0, 0xe, 0x55, 0xce, 0x6f,
    0x30, 0x8a, 0x0, 0x46, 0xf6, 0xd7, 0x0, 0x9d,
    0x5e, 0x40, 0xb, 0xd9, 0x0, 0x0, 0x0, 0xaf,
    0x90,

    /* U+624B "手" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x13, 0x43, 0x0,
    0x9, 0xaa, 0xbc, 0xde, 0xff, 0xfd, 0x70, 0x0,
    0x67, 0x76, 0x5c, 0xa2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb, 0x90, 0x0, 0x0, 0x0, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0x23, 0x33,
    0x3b, 0xa3, 0x33, 0x31, 0x0, 0x0, 0x0, 0x0,
    0xb9, 0x0, 0x0, 0x0, 0x3, 0x33, 0x33, 0x3c,
    0xa3, 0x33, 0x33, 0x21, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0xb, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbe, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x63, 0x0, 0x0, 0x0,
    0x0,

    /* U+626B "扫" */
    0x0, 0xa, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc6, 0x3, 0x88, 0x88, 0x88, 0x80, 0x0,
    0xc, 0x60, 0x4b, 0xbb, 0xbb, 0xcf, 0x0, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x3, 0xf0, 0x2, 0x3d,
    0x73, 0x10, 0x0, 0x0, 0x3f, 0x0, 0x0, 0xc6,
    0x0, 0x0, 0x0, 0x3, 0xf0, 0x0, 0xc, 0x77,
    0x33, 0x33, 0x33, 0x6f, 0x0, 0x5, 0xef, 0xc5,
    0xff, 0xff, 0xff, 0xf0, 0x4f, 0xde, 0x60, 0x0,
    0x0, 0x0, 0x3f, 0x1, 0x20, 0xc6, 0x0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0xc, 0x60, 0x0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0xc6, 0x0, 0x0, 0x0,
    0x3, 0xf0, 0x0, 0x1e, 0x51, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x8f, 0xd1, 0x3, 0x33, 0x33, 0x36,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+627E "找" */
    0x0, 0xa, 0x40, 0x0, 0xe2, 0x21, 0x0, 0x0,
    0x0, 0xc5, 0x0, 0xe, 0x37, 0xe2, 0x0, 0x0,
    0xc, 0x50, 0x0, 0xd4, 0x6, 0xe2, 0x0, 0xff,
    0xff, 0xf4, 0xc, 0x50, 0x18, 0x55, 0x1, 0x1d,
    0x63, 0x89, 0xee, 0xff, 0xdb, 0x70, 0x0, 0xc5,
    0x19, 0x7b, 0xa1, 0x0, 0x20, 0x0, 0xc, 0x65,
    0x20, 0x7a, 0x0, 0xba, 0x0, 0x15, 0xef, 0xc3,
    0x4, 0xd0, 0x9d, 0x0, 0x5f, 0xce, 0x60, 0x0,
    0x1f, 0xad, 0x10, 0x0, 0x10, 0xc5, 0x0, 0x2,
    0xfc, 0x10, 0x0, 0x0, 0xc, 0x50, 0x7, 0xfd,
    0xa0, 0x6, 0x40, 0x0, 0xc5, 0x6e, 0xd3, 0x2f,
    0x20, 0xa6, 0x3, 0x5e, 0x55, 0x50, 0x0, 0x9d,
    0x6f, 0x20, 0x7e, 0xb1, 0x0, 0x0, 0x0, 0xaf,
    0x80,

    /* U+633F "挿" */
    0x0, 0x18, 0x0, 0x0, 0x1, 0x34, 0x68, 0x10,
    0x2, 0xe0, 0xb, 0xff, 0xff, 0xcb, 0x92, 0x0,
    0x2e, 0x0, 0x11, 0x6, 0xb0, 0x0, 0x0, 0xee,
    0xfe, 0x4c, 0xcc, 0xdf, 0xcc, 0xcb, 0x2, 0x4e,
    0x31, 0x44, 0x48, 0xc4, 0x44, 0x40, 0x2, 0xe0,
    0x0, 0x11, 0x6b, 0x11, 0x10, 0x0, 0x2e, 0x10,
    0xef, 0xff, 0xff, 0xff, 0x40, 0x3, 0xff, 0x2e,
    0x20, 0x6b, 0x0, 0xc4, 0x2c, 0xff, 0x30, 0xe5,
    0x38, 0xc3, 0x3d, 0x41, 0x74, 0xe0, 0xe, 0xdc,
    0xde, 0xcc, 0xf4, 0x0, 0x2e, 0x0, 0xe2, 0x6,
    0xb0, 0xc, 0x40, 0x2, 0xe0, 0xe, 0xff, 0xff,
    0xff, 0xf4, 0x2, 0x7e, 0x0, 0x12, 0x27, 0xb2,
    0x22, 0x0, 0x79, 0x40, 0x0, 0x0, 0x6b, 0x0,
    0x0,

    /* U+6362 "换" */
    0x0, 0x16, 0x0, 0x0, 0x81, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x5, 0xe2, 0x22, 0x20, 0x0,
    0x0, 0x3e, 0x0, 0xd, 0xff, 0xff, 0xe0, 0x0,
    0x8, 0xaf, 0x94, 0x8b, 0x0, 0x1e, 0x60, 0x0,
    0x6, 0x9f, 0x7a, 0xe3, 0x22, 0xcb, 0x21, 0x0,
    0x0, 0x3e, 0x7, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x3e, 0x12, 0xe2, 0xc, 0x50, 0x1e, 0x0,
    0x0, 0x6f, 0xf6, 0xe2, 0xc, 0x50, 0x1e, 0x0,
    0x4e, 0xff, 0x21, 0xe3, 0x1c, 0x51, 0x2e, 0x10,
    0x14, 0x3e, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x3e, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0xc9, 0xbb, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x4d, 0xc0, 0x1c, 0xd3, 0x0,
    0x6, 0xdd, 0x3d, 0xe7, 0x0, 0x0, 0x7f, 0xc2,
    0x4, 0x72, 0x6, 0x0, 0x0, 0x0, 0x1, 0x60,

    /* U+6383 "掃" */
    0x0, 0x27, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xc0, 0xc, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x4c, 0x0, 0x0, 0x0, 0x0, 0x4c, 0x0, 0x8a,
    0xe8, 0x47, 0xee, 0xee, 0xee, 0xc0, 0xa, 0xbe,
    0xa5, 0x22, 0x22, 0x22, 0x5c, 0x0, 0x4, 0xc0,
    0xc, 0xcc, 0xcc, 0xcc, 0xa0, 0x0, 0x4c, 0x42,
    0x44, 0x44, 0x44, 0x44, 0x30, 0x18, 0xfe, 0xae,
    0xcc, 0xfc, 0xcc, 0xdb, 0x7f, 0xdd, 0x8, 0xa0,
    0xd, 0x30, 0x4, 0xb1, 0x4, 0xc0, 0x8, 0xff,
    0xff, 0xff, 0xc0, 0x0, 0x4c, 0x0, 0x86, 0xd,
    0x30, 0x3d, 0x0, 0x4, 0xc0, 0x8, 0x60, 0xd3,
    0x3, 0xd0, 0x0, 0x5c, 0x0, 0x86, 0xd, 0x37,
    0xcb, 0x0, 0xbb, 0x50, 0x3, 0x20, 0xd3, 0x34,
    0x0,

    /* U+63A2 "探" */
    0x0, 0x3a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3d, 0x4, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x3d, 0x4, 0xb1, 0x11, 0x11, 0x1e, 0x10,
    0xf, 0xff, 0xf9, 0xb0, 0x70, 0x43, 0xe, 0x10,
    0x3, 0x6d, 0x31, 0x2c, 0xb0, 0x5e, 0x92, 0x0,
    0x0, 0x3d, 0x4, 0xfb, 0xb, 0x21, 0xce, 0x10,
    0x0, 0x3e, 0xd5, 0x80, 0xe, 0x20, 0x7, 0x0,
    0x2, 0xbf, 0xc2, 0x11, 0x1e, 0x31, 0x11, 0x0,
    0x6f, 0xed, 0x8, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x22, 0x3d, 0x0, 0x1, 0xdf, 0xe4, 0x0, 0x0,
    0x0, 0x3d, 0x0, 0x1d, 0x6e, 0x5e, 0x60, 0x0,
    0x0, 0x3d, 0x5, 0xe7, 0xe, 0x22, 0xcb, 0x30,
    0x3, 0x8c, 0x5d, 0x40, 0xe, 0x20, 0x7, 0xc0,
    0x9, 0xa4, 0x0, 0x0, 0xe, 0x20, 0x0, 0x0,

    /* U+63A5 "接" */
    0x0, 0x18, 0x0, 0x0, 0x6, 0x40, 0x0, 0x0,
    0x2, 0xf0, 0x1, 0x11, 0x9b, 0x11, 0x10, 0x0,
    0x2f, 0x1, 0xff, 0xff, 0xff, 0xff, 0x40, 0xcc,
    0xfc, 0x70, 0x99, 0x0, 0x99, 0x0, 0x3, 0x5f,
    0x32, 0x5, 0xc0, 0xe, 0x40, 0x0, 0x2, 0xf0,
    0x8f, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x2f, 0x63,
    0x11, 0x94, 0x11, 0x11, 0x10, 0x4a, 0xfd, 0x20,
    0x1f, 0x20, 0x0, 0x0, 0x6e, 0xaf, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xa0, 0x2, 0xf0, 0x1, 0xf4,
    0x0, 0x8b, 0x0, 0x0, 0x2f, 0x0, 0x6f, 0x93,
    0x2e, 0x30, 0x0, 0x2, 0xf0, 0x0, 0x17, 0xff,
    0xb1, 0x0, 0x0, 0x5f, 0x2, 0x6a, 0xeb, 0x5b,
    0xf9, 0x20, 0xdf, 0x83, 0xeb, 0x61, 0x0, 0x2,
    0xa9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+63CF "描" */
    0x0, 0x1b, 0x0, 0x3, 0x90, 0x9, 0x40, 0x0,
    0x1, 0xf1, 0x0, 0x4d, 0x0, 0xc5, 0x0, 0x0,
    0x2f, 0x14, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xef,
    0xff, 0x72, 0x5e, 0x22, 0xc7, 0x21, 0x0, 0x2f,
    0x10, 0x2, 0x90, 0x8, 0x30, 0x0, 0x1, 0xf1,
    0xa, 0xdd, 0xdd, 0xdd, 0xd0, 0x0, 0x1f, 0xa7,
    0xd7, 0x4a, 0xb4, 0x5f, 0x2, 0x8d, 0xfb, 0x3d,
    0x50, 0x8a, 0x2, 0xf0, 0x5d, 0x8f, 0x10, 0xd6,
    0x18, 0xa1, 0x3f, 0x0, 0x1, 0xf1, 0xd, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x1f, 0x10, 0xd5, 0x8,
    0xa0, 0x2f, 0x0, 0x1, 0xf1, 0xd, 0x50, 0x8a,
    0x2, 0xf0, 0x0, 0x1f, 0x0, 0xd7, 0x4a, 0xb4,
    0x5f, 0x0, 0x7b, 0x80, 0xd, 0xdc, 0xcc, 0xcc,
    0xf0,

    /* U+63D2 "插" */
    0x0, 0x2d, 0x0, 0x0, 0x1, 0x34, 0x68, 0x0,
    0x3, 0xe0, 0x3e, 0xef, 0xfd, 0xb9, 0x70, 0x3,
    0x5f, 0x31, 0x21, 0xb, 0x60, 0x0, 0x0, 0xff,
    0xff, 0x31, 0x11, 0xb7, 0x11, 0x11, 0x0, 0x3e,
    0x7, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x3, 0xe0,
    0x0, 0x1, 0xb6, 0x0, 0x0, 0x0, 0x4f, 0xe5,
    0xae, 0x8b, 0x7c, 0xcc, 0x14, 0xdf, 0xf4, 0x3e,
    0x20, 0xb6, 0x45, 0xf1, 0x38, 0x5e, 0x3, 0xd0,
    0xb, 0x60, 0xf, 0x10, 0x3, 0xe0, 0x3f, 0xe8,
    0xb6, 0xce, 0xf1, 0x0, 0x3e, 0x3, 0xd1, 0x1b,
    0x61, 0x2f, 0x10, 0x3, 0xe0, 0x3d, 0x0, 0xb6,
    0x0, 0xf1, 0x0, 0x3e, 0x3, 0xe5, 0x5c, 0x95,
    0x5f, 0x10, 0x6b, 0x60, 0x3f, 0xcc, 0xcc, 0xcc,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+63DB "換" */
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0x0, 0x0, 0xe3, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x8, 0xfc, 0xcc, 0xb0, 0x0,
    0x0, 0x1f, 0x0, 0x3f, 0x43, 0x3b, 0xa0, 0x0,
    0xd, 0xdf, 0xd4, 0xe7, 0x0, 0x4e, 0x20, 0x0,
    0x5, 0x6f, 0x5b, 0xff, 0xee, 0xee, 0xee, 0x0,
    0x0, 0x1f, 0x0, 0xb4, 0x15, 0x33, 0x3e, 0x0,
    0x0, 0x1f, 0x31, 0xb4, 0x97, 0x3d, 0x3e, 0x0,
    0x2, 0x7f, 0xe3, 0xb8, 0xd2, 0x19, 0x8e, 0x0,
    0x5e, 0xbf, 0x0, 0x62, 0x18, 0x70, 0x2a, 0x0,
    0x0, 0x1f, 0x5, 0xcc, 0xce, 0xec, 0xcc, 0xb0,
    0x0, 0x1f, 0x2, 0x44, 0x5f, 0xf5, 0x44, 0x40,
    0x0, 0x1f, 0x0, 0x0, 0xab, 0x9b, 0x0, 0x0,
    0x0, 0x2e, 0x0, 0x3c, 0xd1, 0xb, 0xd4, 0x0,
    0xc, 0xfc, 0x1c, 0xf8, 0x0, 0x0, 0x6e, 0xc0,
    0x2, 0x20, 0x5, 0x10, 0x0, 0x0, 0x0, 0x30,

    /* U+6557 "敗" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0xa0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xe0, 0x9, 0x90, 0x0, 0x0,
    0x0, 0xf3, 0x13, 0xf0, 0xe, 0x84, 0x44, 0x30,
    0x0, 0xf3, 0x2, 0xf0, 0x4f, 0xff, 0xff, 0xd0,
    0x0, 0xfe, 0xee, 0xf0, 0xb9, 0x0, 0x79, 0x0,
    0x0, 0xf2, 0x2, 0xf3, 0xfa, 0x0, 0xa7, 0x0,
    0x0, 0xf5, 0x35, 0xfd, 0xbe, 0x0, 0xd3, 0x0,
    0x0, 0xfc, 0xcc, 0xf2, 0xe, 0x32, 0xe0, 0x0,
    0x0, 0xf2, 0x2, 0xf0, 0x7, 0xa9, 0x80, 0x0,
    0x0, 0xfe, 0xee, 0xf0, 0x0, 0xee, 0x10, 0x0,
    0x0, 0x26, 0x27, 0x20, 0x2, 0xef, 0x20, 0x0,
    0x0, 0x9b, 0xb, 0xa0, 0x2e, 0x98, 0xe2, 0x0,
    0x5, 0xe1, 0x0, 0xc5, 0xe9, 0x0, 0x9e, 0x30,
    0x1f, 0x40, 0x0, 0x4f, 0x60, 0x0, 0x7, 0xe0,
    0x2, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x10,

    /* U+65B0 "新" */
    0x0, 0x0, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x11, 0xc6, 0x11, 0x1, 0x36, 0x9e, 0x60,
    0xa, 0xff, 0xff, 0xff, 0x1e, 0xeb, 0x84, 0x0,
    0x0, 0x79, 0x2, 0xd0, 0xe, 0x20, 0x0, 0x0,
    0x0, 0x4c, 0x5, 0xb0, 0xe, 0x20, 0x0, 0x0,
    0x6, 0x8e, 0x6b, 0xb6, 0x3e, 0x54, 0x44, 0x40,
    0x9, 0x99, 0xeb, 0x99, 0x4e, 0xdd, 0xfe, 0xd0,
    0x0, 0x0, 0xc5, 0x0, 0xe, 0x20, 0xe3, 0x0,
    0xc, 0xff, 0xff, 0xff, 0xe, 0x20, 0xe3, 0x0,
    0x1, 0x42, 0xd6, 0x51, 0xf, 0x10, 0xe3, 0x0,
    0x1, 0xe2, 0xc5, 0xd4, 0x3f, 0x0, 0xe3, 0x0,
    0x9, 0x90, 0xc5, 0x3d, 0x8b, 0x0, 0xe3, 0x0,
    0x4e, 0x12, 0xe5, 0x4, 0xe5, 0x0, 0xe3, 0x0,
    0x1, 0xc, 0xb1, 0x7, 0xc0, 0x0, 0xe3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,

    /* U+65E0 "无" */
    0x0, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x2, 0x33, 0x38, 0xe3, 0x33, 0x33, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xd0, 0x0, 0x0, 0x0, 0x3, 0x44,
    0x44, 0xad, 0x44, 0x44, 0x44, 0x0, 0xad, 0xdd,
    0xdf, 0xed, 0xdd, 0xdd, 0xd1, 0x0, 0x0, 0x0,
    0xe8, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x5f, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xa3,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xe1, 0x3f,
    0x0, 0x0, 0x52, 0x0, 0x8, 0xf4, 0x3, 0xf0,
    0x0, 0xc, 0x70, 0x1b, 0xe4, 0x0, 0x2f, 0x61,
    0x13, 0xf5, 0x3f, 0xc2, 0x0, 0x0, 0x9f, 0xff,
    0xfb, 0x0, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+65F6 "时" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x2b,
    0xbb, 0xb3, 0x0, 0x0, 0x2f, 0x20, 0x3, 0xf7,
    0x7e, 0x50, 0x0, 0x2, 0xf2, 0x0, 0x3e, 0x0,
    0xd5, 0xee, 0xee, 0xef, 0xee, 0x33, 0xe0, 0xd,
    0x54, 0x44, 0x45, 0xf5, 0x40, 0x3e, 0x0, 0xd5,
    0x3, 0x0, 0x2f, 0x20, 0x3, 0xf3, 0x3d, 0x55,
    0xf1, 0x2, 0xf2, 0x0, 0x3f, 0xff, 0xf5, 0xc,
    0x90, 0x2f, 0x20, 0x3, 0xe0, 0xd, 0x50, 0x3f,
    0x22, 0xf2, 0x0, 0x3e, 0x0, 0xd5, 0x0, 0xb7,
    0x2f, 0x20, 0x3, 0xe0, 0xd, 0x50, 0x1, 0x2,
    0xf2, 0x0, 0x3e, 0x0, 0xd5, 0x0, 0x0, 0x2f,
    0x20, 0x3, 0xff, 0xff, 0x50, 0x0, 0x4, 0xf1,
    0x0, 0x2, 0x22, 0x20, 0x0, 0x8e, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x53, 0x0, 0x0,

    /* U+6642 "時" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf1, 0x0, 0x0, 0x19,
    0x99, 0x80, 0x0, 0xf, 0x10, 0x0, 0x2, 0xf9,
    0xaf, 0xf, 0xff, 0xff, 0xff, 0x60, 0x2e, 0x1,
    0xf0, 0x22, 0x2f, 0x32, 0x20, 0x2, 0xe0, 0x1f,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0x2e, 0x1, 0xf8,
    0xee, 0xef, 0xee, 0xee, 0x32, 0xf8, 0x8f, 0x13,
    0x33, 0x34, 0xf3, 0x30, 0x2f, 0xab, 0xf0, 0x0,
    0x0, 0x1f, 0x0, 0x2, 0xe0, 0x1f, 0x5d, 0xdd,
    0xdd, 0xfd, 0xb0, 0x2e, 0x1, 0xf1, 0x77, 0x44,
    0x5f, 0x43, 0x2, 0xe0, 0x1f, 0x7, 0xe1, 0x1,
    0xf0, 0x0, 0x2e, 0x2, 0xf0, 0xa, 0xc0, 0x1f,
    0x0, 0x2, 0xff, 0xff, 0x0, 0x4, 0x4, 0xf0,
    0x0, 0x1, 0x11, 0x10, 0x0, 0x4e, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x52, 0x0, 0x0,

    /* U+66F4 "更" */
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0, 0x8,
    0xcc, 0xcc, 0xfd, 0xcc, 0xcc, 0x0, 0x0, 0xaa,
    0x33, 0x3e, 0x73, 0x34, 0xf0, 0x0, 0xa, 0x90,
    0x0, 0xe5, 0x0, 0x2f, 0x0, 0x0, 0xaf, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0xa, 0x80, 0x0,
    0xe5, 0x0, 0x2f, 0x0, 0x0, 0xaf, 0xee, 0xef,
    0xee, 0xee, 0xf0, 0x0, 0x1, 0x77, 0x22, 0xf4,
    0x22, 0x22, 0x0, 0x0, 0x3, 0xe7, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xef, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xbf, 0x9d, 0xfb, 0x86,
    0x54, 0x23, 0xcf, 0xd8, 0x10, 0x2, 0x58, 0xbc,
    0xe9, 0x6, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+66FF "替" */
    0x0, 0x0, 0xd1, 0x0, 0x0, 0xb4, 0x0, 0x0,
    0x1, 0x22, 0xf4, 0x20, 0x22, 0xd6, 0x22, 0x0,
    0x8, 0xcc, 0xfc, 0xc3, 0xbc, 0xfd, 0xcc, 0x20,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0xd4, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x70,
    0x0, 0x8, 0xf7, 0x0, 0x6, 0xed, 0x10, 0x0,
    0x0, 0x6f, 0x3b, 0xc2, 0x8e, 0x37, 0xd3, 0x0,
    0x2b, 0xe3, 0x0, 0x82, 0xa2, 0x0, 0x6e, 0x90,
    0x38, 0xe, 0xee, 0xee, 0xee, 0xee, 0x81, 0x70,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xa, 0x80, 0x0,
    0x0, 0xf, 0xdc, 0xcc, 0xcc, 0xce, 0x80, 0x0,
    0x0, 0xf, 0x42, 0x22, 0x22, 0x2a, 0x80, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x9, 0x80, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0x80, 0x0,

    /* U+6700 "最" */
    0x0, 0x7, 0x88, 0x88, 0x88, 0x88, 0x50, 0x0,
    0x0, 0xf, 0x76, 0x66, 0x66, 0x6a, 0xb0, 0x0,
    0x0, 0xf, 0xcb, 0xbb, 0xbb, 0xbd, 0xb0, 0x0,
    0x0, 0xf, 0x31, 0x11, 0x11, 0x17, 0xb0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x89, 0x0, 0xa6, 0x12, 0x22, 0x21, 0x0,
    0x0, 0x8e, 0xdd, 0xf6, 0xce, 0xcc, 0xec, 0x0,
    0x0, 0x89, 0x0, 0xa6, 0x1e, 0x0, 0xc6, 0x0,
    0x0, 0x8e, 0xdd, 0xf6, 0x9, 0x96, 0xc0, 0x0,
    0x0, 0x89, 0x0, 0xb9, 0x20, 0xde, 0x20, 0x0,
    0x9, 0xde, 0xcb, 0xeb, 0x5a, 0xb9, 0xd5, 0x0,
    0x3, 0x10, 0x0, 0xa7, 0xb5, 0x0, 0x29, 0x70,

    /* U+6709 "有" */
    0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x11, 0x1f, 0x71, 0x11, 0x11, 0x10, 0xe,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x1,
    0x13, 0xf6, 0x11, 0x11, 0x11, 0x10, 0x0, 0x0,
    0xcd, 0x11, 0x11, 0x11, 0x10, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x0, 0x3, 0xf0, 0x0, 0x9f, 0xad, 0x33,
    0x33, 0x33, 0x6f, 0x0, 0x5e, 0x35, 0xfd, 0xdd,
    0xdd, 0xdd, 0xf0, 0x0, 0x0, 0x5d, 0x0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x5, 0xfe, 0xee, 0xee,
    0xee, 0xf0, 0x0, 0x0, 0x5d, 0x22, 0x22, 0x22,
    0x5f, 0x0, 0x0, 0x5, 0xd0, 0x0, 0x0, 0x27,
    0xf0, 0x0, 0x0, 0x5d, 0x0, 0x0, 0x3e, 0xc6,
    0x0,

    /* U+670B "朋" */
    0x0, 0xef, 0xff, 0xe0, 0x2f, 0xff, 0xfe, 0x0,
    0xe5, 0x35, 0xe0, 0x3e, 0x33, 0x5e, 0x0, 0xe3,
    0x2, 0xe0, 0x3e, 0x0, 0x3e, 0x0, 0xe5, 0x24,
    0xe0, 0x3e, 0x22, 0x4e, 0x0, 0xef, 0xff, 0xe0,
    0x3f, 0xff, 0xfe, 0x0, 0xe3, 0x2, 0xe0, 0x3e,
    0x0, 0x3e, 0x0, 0xf3, 0x2, 0xe0, 0x3e, 0x0,
    0x3e, 0x0, 0xf5, 0x35, 0xe0, 0x3e, 0x33, 0x5e,
    0x0, 0xfe, 0xee, 0xe0, 0x4f, 0xee, 0xee, 0x2,
    0xf0, 0x2, 0xe0, 0x59, 0x0, 0x3e, 0x5, 0xd0,
    0x2, 0xe0, 0x97, 0x0, 0x3e, 0xb, 0x90, 0x3,
    0xe0, 0xe3, 0x0, 0x3e, 0x2f, 0x20, 0xae, 0xc7,
    0xd0, 0x9, 0xcd, 0x48, 0x0, 0x66, 0x18, 0x40,
    0x8, 0x82,

    /* U+670D "服" */
    0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x10, 0x0,
    0x1, 0xff, 0xff, 0x44, 0xff, 0xff, 0xfd, 0x0,
    0x1, 0xf0, 0xd, 0x44, 0xd0, 0x0, 0x5c, 0x0,
    0x1, 0xf0, 0xd, 0x44, 0xd0, 0x0, 0x7c, 0x0,
    0x1, 0xf5, 0x5e, 0x44, 0xd0, 0x1e, 0xf6, 0x0,
    0x1, 0xfb, 0xbf, 0x44, 0xd0, 0x2, 0x0, 0x0,
    0x1, 0xf0, 0xd, 0x44, 0xff, 0xff, 0xff, 0x50,
    0x1, 0xf0, 0xd, 0x44, 0xd9, 0x91, 0x3f, 0x20,
    0x1, 0xfd, 0xdf, 0x44, 0xd3, 0xd0, 0x6c, 0x0,
    0x2, 0xe3, 0x3e, 0x44, 0xd0, 0xd5, 0xe5, 0x0,
    0x5, 0xb0, 0xd, 0x44, 0xd0, 0x4f, 0xa0, 0x0,
    0x8, 0x90, 0xd, 0x34, 0xd0, 0x6f, 0xc2, 0x0,
    0xe, 0x42, 0x6f, 0x24, 0xd9, 0xd1, 0x8f, 0x70,
    0x4c, 0x3, 0xa6, 0x4, 0xd6, 0x0, 0x3, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+671F "期" */
    0x0, 0x34, 0x0, 0x43, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xa1, 0x19, 0x80, 0x7d, 0xdd, 0xd2, 0x8,
    0xff, 0xff, 0xff, 0xb9, 0x93, 0x3f, 0x20, 0x6,
    0xa0, 0x8, 0x80, 0x97, 0x0, 0xe2, 0x0, 0x6d,
    0x88, 0xc8, 0x9, 0x81, 0x1e, 0x20, 0x6, 0xc7,
    0x7b, 0x80, 0x9f, 0xff, 0xf2, 0x0, 0x6a, 0x0,
    0x98, 0x9, 0x70, 0xe, 0x20, 0x6, 0xfe, 0xef,
    0x80, 0x97, 0x0, 0xe2, 0x0, 0x6a, 0x0, 0x88,
    0x9, 0x94, 0x4f, 0x20, 0x38, 0xb3, 0x3a, 0x92,
    0xaf, 0xff, 0xf2, 0x2c, 0xcc, 0xcc, 0xcc, 0x9c,
    0x50, 0xe, 0x20, 0x0, 0x93, 0x4a, 0x0, 0xf2,
    0x0, 0xe2, 0x0, 0x7d, 0x10, 0xbb, 0x6d, 0x0,
    0xe, 0x20, 0x7e, 0x20, 0x0, 0x7e, 0x50, 0x3a,
    0xf1, 0x3, 0x30, 0x0, 0x4, 0x90, 0x1, 0x73,
    0x0,

    /* U+672C "本" */
    0x0, 0x0, 0x0, 0x7, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,
    0x2, 0x33, 0x33, 0x3e, 0x73, 0x33, 0x33, 0x0,
    0x8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x1, 0xff, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xae, 0x9f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x2e, 0x5b, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xc8, 0xe, 0x52, 0xf4, 0x0, 0x0,
    0x0, 0x9, 0xd0, 0xe, 0x50, 0x7e, 0x20, 0x0,
    0x0, 0x7e, 0x10, 0xe, 0x50, 0xa, 0xd1, 0x0,
    0x8, 0xf3, 0x33, 0x3e, 0x83, 0x32, 0xbe, 0x20,
    0x7f, 0x31, 0xff, 0xff, 0xff, 0xf9, 0xa, 0xe0,
    0x2, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x20,
    0x0, 0x0, 0x0, 0xe, 0x50, 0x0, 0x0, 0x0,

    /* U+673A "机" */
    0x0, 0x5, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x60, 0x2, 0x33, 0x33, 0x0, 0x0,
    0x0, 0xc, 0x60, 0xc, 0xff, 0xff, 0x40, 0x0,
    0x0, 0xc, 0x60, 0xc, 0x83, 0x3f, 0x40, 0x0,
    0xe, 0xff, 0xff, 0xac, 0x70, 0xe, 0x40, 0x0,
    0x3, 0x3f, 0x83, 0x2c, 0x70, 0xe, 0x40, 0x0,
    0x0, 0x5f, 0x60, 0xc, 0x70, 0xe, 0x40, 0x0,
    0x0, 0xcf, 0xe4, 0xc, 0x60, 0xe, 0x40, 0x0,
    0x4, 0xec, 0xae, 0x3c, 0x60, 0xe, 0x40, 0x0,
    0xd, 0x6c, 0x67, 0x7d, 0x50, 0xe, 0x40, 0x0,
    0x7d, 0xc, 0x60, 0xe, 0x30, 0xe, 0x40, 0x0,
    0x12, 0xc, 0x60, 0x2f, 0x0, 0xe, 0x41, 0xb0,
    0x0, 0xc, 0x60, 0x7a, 0x0, 0xe, 0x42, 0xf0,
    0x0, 0xc, 0x61, 0xe2, 0x0, 0xe, 0x76, 0xe0,
    0x0, 0xc, 0x6b, 0x60, 0x0, 0x9, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+67E5 "查" */
    0x0, 0x0, 0x0, 0x9, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x11, 0x11, 0x1e, 0x61, 0x11, 0x11, 0x0,
    0x9, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x5, 0xef, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xbd, 0x2e, 0x59, 0xe6, 0x0, 0x0,
    0x3, 0x9f, 0x80, 0xe, 0x50, 0x4d, 0xe7, 0x10,
    0x8f, 0xa5, 0x44, 0x46, 0x44, 0x44, 0x6c, 0xd0,
    0x11, 0xc, 0xdb, 0xbb, 0xbb, 0xbf, 0x40, 0x0,
    0x0, 0xc, 0x72, 0x22, 0x22, 0x2f, 0x40, 0x0,
    0x0, 0xc, 0xed, 0xdd, 0xdd, 0xdf, 0x40, 0x0,
    0x0, 0xc, 0x70, 0x0, 0x0, 0xf, 0x40, 0x0,
    0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20,

    /* U+68C0 "检" */
    0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x1e, 0xb0, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x9b, 0xe5, 0x0, 0x0,
    0x1, 0x2f, 0x11, 0x5, 0xe1, 0x4f, 0x20, 0x0,
    0xf, 0xff, 0xfc, 0x4f, 0x30, 0x7, 0xe3, 0x0,
    0x0, 0x5f, 0x7, 0xf4, 0x0, 0x0, 0x7f, 0x50,
    0x0, 0xaf, 0x9, 0x5f, 0xff, 0xff, 0xd5, 0xe1,
    0x1, 0xff, 0xd0, 0x2, 0x24, 0x22, 0x20, 0x0,
    0x8, 0xaf, 0xa9, 0xd3, 0x2e, 0x0, 0x89, 0x0,
    0x1f, 0x3f, 0x13, 0x88, 0xe, 0x20, 0xd6, 0x0,
    0x8a, 0x1f, 0x0, 0x4d, 0xa, 0x62, 0xf1, 0x0,
    0x1, 0x1f, 0x0, 0xf, 0x17, 0xa7, 0xb0, 0x0,
    0x0, 0x1f, 0x0, 0xb, 0x22, 0x2d, 0x60, 0x0,
    0x0, 0x1f, 0x2, 0x22, 0x22, 0x4f, 0x22, 0x10,
    0x0, 0x1f, 0xe, 0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+691C "検" */
    0x0, 0x4, 0x0, 0x0, 0x3, 0x10, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x4, 0xfb, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0xd5, 0xd6, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x9a, 0x3, 0xf3, 0x0, 0xf, 0xff,
    0xf8, 0x8c, 0x0, 0x6, 0xf4, 0x0, 0x26, 0xf2,
    0xad, 0xdf, 0xff, 0xf9, 0xf5, 0x0, 0x8f, 0x6,
    0x10, 0xc, 0x50, 0x4, 0x20, 0xe, 0xf8, 0x3,
    0x33, 0xd7, 0x33, 0x20, 0x5, 0xdf, 0xe7, 0xfd,
    0xdf, 0xed, 0xeb, 0x0, 0xc7, 0xf3, 0x6e, 0x0,
    0xe4, 0x6, 0xb0, 0x5d, 0x1f, 0x0, 0xe2, 0x2f,
    0x42, 0x8b, 0x6, 0x41, 0xf0, 0xf, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0x1f, 0x0, 0x1, 0xd9, 0xe3,
    0x0, 0x0, 0x1, 0xf0, 0x6, 0xe8, 0x4, 0xe9,
    0x20, 0x0, 0x1f, 0xe, 0xb3, 0x0, 0x0, 0x7d,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6A21 "模" */
    0x0, 0x4, 0x0, 0x0, 0x50, 0x5, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x1, 0xe0, 0xe, 0x20, 0x0,
    0x0, 0xf, 0x3, 0xab, 0xfa, 0xaf, 0xba, 0x50,
    0x0, 0xf, 0x2, 0x89, 0xf8, 0x8f, 0x98, 0x40,
    0xf, 0xff, 0xfb, 0x1, 0xa0, 0xa, 0x10, 0x0,
    0x3, 0x6f, 0x42, 0xbe, 0xee, 0xee, 0xe8, 0x0,
    0x0, 0x9f, 0x10, 0xc5, 0x0, 0x0, 0x89, 0x0,
    0x1, 0xff, 0xd1, 0xce, 0xdd, 0xdd, 0xe9, 0x0,
    0x9, 0x9f, 0x9a, 0xc5, 0x0, 0x0, 0x89, 0x0,
    0x2f, 0x3f, 0x14, 0xbe, 0xef, 0xee, 0xe8, 0x0,
    0x99, 0xf, 0x0, 0x0, 0x9, 0x60, 0x0, 0x0,
    0x1, 0xf, 0x9, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0xf, 0x0, 0x0, 0x4e, 0xe3, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x39, 0xe4, 0x4e, 0x93, 0x0,
    0x0, 0xf, 0x2e, 0xc6, 0x0, 0x1, 0x7c, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6A5F "機" */
    0x0, 0x4, 0x0, 0x0, 0x2, 0x0, 0x10, 0x0,
    0x0, 0x2e, 0x0, 0x1c, 0xc, 0x31, 0xd0, 0x0,
    0x0, 0x2e, 0x0, 0x87, 0x4c, 0x48, 0x67, 0x20,
    0x0, 0x2e, 0x2, 0xe2, 0xbb, 0x7e, 0x3d, 0x0,
    0xe, 0xff, 0xfa, 0xde, 0x4a, 0xaa, 0xe6, 0x0,
    0x2, 0x7e, 0x20, 0x2b, 0x99, 0x62, 0xc8, 0x30,
    0x0, 0xae, 0x32, 0xe7, 0xbc, 0x9d, 0xbb, 0x90,
    0x1, 0xff, 0xe7, 0x98, 0x7b, 0xa6, 0x83, 0x80,
    0x7, 0xbe, 0x46, 0x5c, 0x4, 0xc0, 0xa5, 0x0,
    0xe, 0x4e, 0xf, 0xff, 0xff, 0xff, 0xff, 0xd0,
    0x7a, 0x2e, 0x0, 0x6e, 0x10, 0xd3, 0x17, 0x0,
    0x11, 0x2e, 0x0, 0x8c, 0xd2, 0x8a, 0xd4, 0x0,
    0x0, 0x2e, 0x0, 0xe2, 0x32, 0x8f, 0x40, 0xc0,
    0x0, 0x2e, 0xa, 0x90, 0x6d, 0x9a, 0xa3, 0xd0,
    0x0, 0x2e, 0x5c, 0x2, 0x92, 0x0, 0xbf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6AA2 "檢" */
    0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x9, 0x80, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x6d, 0xd5, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x4, 0xf2, 0x3f, 0x40, 0x0,
    0xc, 0xcf, 0xc7, 0x4f, 0x40, 0x4, 0xf5, 0x0,
    0x4, 0x7f, 0x4a, 0xe8, 0xff, 0xff, 0x6f, 0x80,
    0x0, 0x8f, 0x9, 0x20, 0x0, 0x0, 0x2, 0x90,
    0x0, 0xef, 0xc0, 0xef, 0xf5, 0x9f, 0xfb, 0x0,
    0x5, 0xbf, 0xab, 0xe0, 0x86, 0x94, 0x1c, 0x0,
    0xc, 0x5f, 0x17, 0xe0, 0x96, 0x95, 0x2c, 0x0,
    0x6b, 0x1f, 0x0, 0xdf, 0xf5, 0x8f, 0xfb, 0x0,
    0x52, 0x1f, 0x0, 0xd, 0x40, 0xc, 0x30, 0x0,
    0x0, 0x1f, 0x0, 0x5c, 0xd4, 0x4f, 0x80, 0x0,
    0x0, 0x1f, 0x3, 0xd1, 0x27, 0xe3, 0xbb, 0x0,
    0x0, 0x1f, 0x1d, 0x20, 0xd, 0x50, 0x9, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6B63 "正" */
    0x4, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x30,
    0x14, 0x44, 0x44, 0x7f, 0x44, 0x44, 0x41, 0x0,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x4f, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x90, 0x4, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xb9,
    0x0, 0x4f, 0xdd, 0xdd, 0x80, 0x0, 0xb, 0x90,
    0x4, 0xf6, 0x66, 0x64, 0x0, 0x0, 0xb9, 0x0,
    0x4f, 0x0, 0x0, 0x0, 0x0, 0xb, 0x90, 0x4,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0xb9, 0x0, 0x4f,
    0x0, 0x0, 0x0, 0x0, 0xb, 0x90, 0x4, 0xf0,
    0x0, 0x0, 0x0, 0x44, 0xca, 0x44, 0x7f, 0x44,
    0x44, 0x43, 0x2e, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xc0,

    /* U+6CD5 "法" */
    0x0, 0x20, 0x0, 0x0, 0xc, 0x20, 0x0, 0x0,
    0xe, 0x90, 0x0, 0x0, 0xf3, 0x0, 0x0, 0x0,
    0x2c, 0xd2, 0x33, 0x4f, 0x63, 0x33, 0x0, 0x0,
    0x9, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x1b, 0x20,
    0x0, 0x0, 0xf, 0x30, 0x0, 0x0, 0x9f, 0x60,
    0x0, 0x0, 0xf3, 0x0, 0x0, 0x0, 0x5f, 0x40,
    0x0, 0x1f, 0x30, 0x0, 0x0, 0x0, 0x35, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x2, 0x2, 0x22,
    0xe8, 0x22, 0x22, 0x20, 0x1, 0xf1, 0x0, 0x7d,
    0x3, 0xa0, 0x0, 0x0, 0x8c, 0x0, 0x1f, 0x40,
    0x1e, 0x70, 0x0, 0xe, 0x60, 0xb, 0x90, 0x0,
    0x4f, 0x20, 0x6, 0xe0, 0xa, 0xfb, 0xbc, 0xde,
    0xfb, 0x0, 0xd8, 0x0, 0x99, 0x87, 0x54, 0x34,
    0xf3, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x0,

    /* U+6D3B "活" */
    0x0, 0x20, 0x0, 0x0, 0x2, 0x35, 0x77, 0x0,
    0x5f, 0x60, 0x8e, 0xff, 0xfe, 0xca, 0x80, 0x0,
    0x4f, 0x92, 0x32, 0x1f, 0x40, 0x0, 0x0, 0x0,
    0x26, 0x0, 0x0, 0xf4, 0x0, 0x0, 0x7, 0x0,
    0x3, 0x33, 0x3f, 0x63, 0x33, 0x22, 0xdd, 0x20,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x9f, 0x20,
    0x0, 0xf, 0x40, 0x0, 0x0, 0x0, 0x50, 0x0,
    0x0, 0xf4, 0x0, 0x0, 0x0, 0x5, 0x12, 0xdd,
    0xdf, 0xed, 0xd7, 0x0, 0x1, 0xf3, 0x2f, 0x54,
    0x44, 0x4b, 0x90, 0x0, 0x5d, 0x2, 0xf0, 0x0,
    0x0, 0xa9, 0x0, 0xb, 0x70, 0x2f, 0x0, 0x0,
    0xa, 0x90, 0x1, 0xf1, 0x2, 0xf5, 0x55, 0x55,
    0xc9, 0x0, 0x89, 0x0, 0x2f, 0xdd, 0xdd, 0xdf,
    0x90,

    /* U+6D41 "流" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x98, 0x0, 0x0, 0x0,
    0x8, 0xc2, 0x0, 0x0, 0x6d, 0x0, 0x0, 0x0,
    0x0, 0xae, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x6, 0x1, 0x1b, 0xa1, 0x13, 0x11, 0x0,
    0x16, 0x0, 0x0, 0x5e, 0x10, 0x1f, 0x40, 0x0,
    0x3e, 0xb0, 0x3, 0xf4, 0x0, 0x18, 0xf2, 0x0,
    0x1, 0xd9, 0x3f, 0xff, 0xff, 0xee, 0xec, 0x0,
    0x0, 0x2, 0x3, 0x60, 0x34, 0x5, 0x35, 0x0,
    0x0, 0x47, 0x4, 0xd0, 0x7a, 0xb, 0x50, 0x0,
    0x0, 0x99, 0x5, 0xc0, 0x7a, 0xb, 0x50, 0x0,
    0x0, 0xe4, 0x7, 0xa0, 0x7a, 0xb, 0x50, 0x0,
    0x4, 0xf0, 0xb, 0x70, 0x7a, 0xb, 0x50, 0xe0,
    0xa, 0xa0, 0x3f, 0x10, 0x7a, 0xb, 0x62, 0xf0,
    0xf, 0x43, 0xe5, 0x0, 0x7a, 0x8, 0xff, 0x90,
    0x1, 0x1, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6D4B "测" */
    0x1, 0x20, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0,
    0x5f, 0x43, 0xcc, 0xcc, 0xb0, 0x10, 0xf2, 0x0,
    0x6f, 0x7d, 0x44, 0x6e, 0x1f, 0xf, 0x20, 0x0,
    0x44, 0xc2, 0xb2, 0xe1, 0xf0, 0xf2, 0xa, 0x20,
    0x4c, 0x3e, 0x2e, 0x1f, 0xf, 0x20, 0x8e, 0x44,
    0xc3, 0xe2, 0xe1, 0xf0, 0xf2, 0x0, 0x6c, 0x4c,
    0x3e, 0x2e, 0x1f, 0xf, 0x20, 0x0, 0x4, 0xc3,
    0xe2, 0xe1, 0xf0, 0xf2, 0x0, 0x43, 0x4c, 0x4d,
    0x2e, 0x1f, 0xf, 0x20, 0xa, 0x64, 0xc6, 0xc2,
    0xe1, 0xf0, 0xf2, 0x0, 0xe2, 0x25, 0xaa, 0x15,
    0xe, 0xf, 0x20, 0x3e, 0x0, 0x3f, 0x8d, 0x10,
    0x0, 0xf2, 0x8, 0x90, 0x4e, 0x60, 0x7d, 0x10,
    0xf, 0x10, 0xe4, 0x5f, 0x50, 0x0, 0xa4, 0x9e,
    0xd0, 0x3, 0x0, 0x20, 0x0, 0x0, 0x2, 0x30,
    0x0,

    /* U+6D4F "浏" */
    0x1, 0x10, 0x0, 0xa3, 0x0, 0x0, 0xa, 0x10,
    0x7e, 0x30, 0xa, 0x70, 0x2, 0x30, 0xf2, 0x0,
    0x7e, 0x46, 0xac, 0x65, 0x7a, 0xf, 0x20, 0x0,
    0x26, 0xaa, 0xbf, 0x97, 0xa0, 0xf2, 0x2b, 0x10,
    0x14, 0x3, 0xe0, 0x7a, 0xf, 0x20, 0xae, 0x33,
    0xf1, 0x5b, 0x7, 0xa0, 0xf2, 0x0, 0x9c, 0x9,
    0xa9, 0x80, 0x7a, 0xf, 0x20, 0x0, 0x10, 0x1f,
    0xe4, 0x7, 0xa0, 0xf2, 0x0, 0x36, 0x0, 0x7f,
    0x0, 0x7a, 0xf, 0x20, 0x8, 0x90, 0xa, 0xf4,
    0x7, 0xa0, 0xf2, 0x0, 0xd4, 0x3, 0xf9, 0xd0,
    0x7a, 0xf, 0x20, 0x2f, 0x0, 0xc8, 0xe, 0x50,
    0x0, 0xf2, 0x8, 0xa0, 0x9d, 0x0, 0x7b, 0x0,
    0xf, 0x20, 0xe5, 0x4e, 0x20, 0x0, 0x0, 0x9e,
    0xe0, 0x4, 0x0, 0x10, 0x0, 0x0, 0x3, 0x30,
    0x0,

    /* U+6E2C "測" */
    0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x9, 0x10,
    0x7e, 0x41, 0xee, 0xee, 0x10, 0x20, 0xe2, 0x0,
    0x5f, 0x5e, 0x44, 0xe1, 0x1e, 0xe, 0x20, 0x0,
    0x32, 0xe1, 0x1e, 0x11, 0xe0, 0xe2, 0x9, 0x10,
    0x1f, 0xff, 0xf1, 0x1e, 0xe, 0x21, 0xbe, 0x21,
    0xe0, 0xe, 0x11, 0xe0, 0xe2, 0x0, 0x9c, 0x1e,
    0x66, 0xe1, 0x1e, 0xe, 0x20, 0x0, 0x21, 0xfa,
    0xaf, 0x11, 0xe0, 0xe2, 0x0, 0x43, 0x1e, 0x0,
    0xe1, 0x1e, 0xe, 0x20, 0xa, 0x71, 0xfb, 0xaf,
    0x11, 0xe0, 0xe2, 0x0, 0xe3, 0x7, 0x77, 0x80,
    0x1e, 0xe, 0x20, 0x2e, 0x0, 0x78, 0x7b, 0x0,
    0x10, 0xe2, 0x7, 0xa0, 0x3e, 0x10, 0xd7, 0x0,
    0xf, 0x10, 0xd5, 0x1e, 0x50, 0x4, 0xc0, 0x6e,
    0xe0, 0x2, 0x0, 0x30, 0x0, 0x0, 0x1, 0x40,
    0x0,

    /* U+6E80 "満" */
    0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x96, 0x0, 0xf1, 0x0, 0x7,
    0xc2, 0x1, 0x1a, 0x61, 0x1f, 0x21, 0x10, 0x7,
    0xe5, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x4,
    0x10, 0x9, 0x60, 0xf, 0x10, 0x0, 0xb3, 0x0,
    0xee, 0xfe, 0xee, 0xfe, 0xeb, 0x7, 0xf4, 0x2,
    0x22, 0x2d, 0x52, 0x22, 0x20, 0x6, 0xe0, 0x0,
    0x0, 0xc3, 0x0, 0x0, 0x0, 0x2, 0xa, 0xff,
    0xff, 0xff, 0xff, 0x40, 0x3, 0x80, 0xa6, 0x51,
    0xc4, 0x32, 0xb4, 0x0, 0x7b, 0xa, 0x5f, 0xc,
    0x38, 0x6b, 0x40, 0xb, 0x70, 0xa5, 0xf0, 0xc3,
    0x86, 0xb4, 0x0, 0xf2, 0xa, 0x5f, 0xdf, 0xde,
    0x6b, 0x40, 0x5d, 0x0, 0xa5, 0x22, 0x22, 0x22,
    0xd4, 0x9, 0x80, 0xa, 0x50, 0x0, 0x1, 0xeb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6E90 "源" */
    0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xe3, 0xe, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x6f, 0x4f, 0x42, 0x22, 0xf3, 0x22, 0x10,
    0x0, 0x4, 0x2f, 0x20, 0x5, 0xe0, 0x0, 0x0,
    0x1a, 0x20, 0xf, 0x2c, 0xff, 0xff, 0xfe, 0x0,
    0x8, 0xf5, 0xf, 0x2c, 0x50, 0x0, 0x3e, 0x0,
    0x0, 0x4c, 0xf, 0x2c, 0xfe, 0xee, 0xfe, 0x0,
    0x0, 0x0, 0xf, 0x2c, 0x50, 0x0, 0x3e, 0x0,
    0x0, 0x33, 0xf, 0x1c, 0x62, 0x22, 0x5e, 0x0,
    0x0, 0xa8, 0x2f, 0xa, 0xdd, 0xfd, 0xdb, 0x0,
    0x0, 0xe4, 0x5d, 0x2, 0x10, 0xe3, 0x30, 0x0,
    0x2, 0xf0, 0x99, 0xc, 0x50, 0xe3, 0x7b, 0x0,
    0x6, 0xb0, 0xe5, 0x7b, 0x0, 0xf3, 0xa, 0x90,
    0xc, 0x75, 0xe4, 0xe1, 0x7a, 0xf2, 0x1, 0xe3,
    0x7, 0x16, 0x70, 0x20, 0x78, 0x30, 0x0, 0x10,

    /* U+6EE1 "满" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0xd4, 0x4, 0xe0, 0x0, 0x3,
    0xe6, 0x28, 0x8e, 0xa8, 0xaf, 0x88, 0x70, 0x3,
    0xe6, 0x77, 0xe9, 0x79, 0xe7, 0x76, 0x0, 0x2,
    0x0, 0x8, 0x20, 0x28, 0x0, 0x0, 0xb3, 0x2,
    0xee, 0xee, 0xee, 0xee, 0xe9, 0x7, 0xf3, 0x1,
    0x15, 0xb1, 0x98, 0x11, 0x0, 0x7, 0xe0, 0x0,
    0x5a, 0x9, 0x80, 0x0, 0x0, 0x3, 0xe, 0xff,
    0xff, 0xff, 0xff, 0x50, 0x1, 0x70, 0xe2, 0x78,
    0x9, 0x60, 0xd5, 0x0, 0x5d, 0xe, 0x2a, 0xe2,
    0xcb, 0xd, 0x50, 0xa, 0x80, 0xe2, 0xe5, 0xae,
    0xa9, 0xd5, 0x0, 0xf3, 0xe, 0xb8, 0xb, 0x70,
    0x4d, 0x50, 0x6e, 0x0, 0xe5, 0x2, 0xa0, 0x1,
    0xe4, 0xa, 0x70, 0xe, 0x20, 0x0, 0x7, 0xfc,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+6EFF "滿" */
    0x0, 0x0, 0x0, 0x75, 0x0, 0x9, 0x40, 0x0,
    0xab, 0x10, 0x2a, 0x82, 0x22, 0xc6, 0x21, 0x0,
    0xae, 0x9d, 0xee, 0xdd, 0xdf, 0xed, 0xd0, 0x0,
    0x74, 0x9, 0x70, 0x0, 0xb5, 0x0, 0x1a, 0x10,
    0x0, 0x9f, 0xff, 0xff, 0x50, 0x1, 0xae, 0x40,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x7b, 0x2f,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x2, 0xd2,
    0x42, 0xe2, 0x42, 0xe0, 0x0, 0x46, 0x2d, 0x1d,
    0x1e, 0x1c, 0x1e, 0x0, 0x9, 0x92, 0xd2, 0xf4,
    0xe3, 0xf4, 0xe0, 0x0, 0xd5, 0x2d, 0x99, 0x9e,
    0x98, 0xae, 0x0, 0x2f, 0x2, 0xec, 0xd, 0xeb,
    0xa, 0xe0, 0x7, 0xb0, 0x2d, 0x0, 0x1e, 0x0,
    0x2e, 0x0, 0xb6, 0x2, 0xd0, 0x1, 0xe0, 0x5e,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+6FC0 "激" */
    0x0, 0x0, 0x0, 0x54, 0x0, 0x17, 0x0, 0x0,
    0x8, 0x80, 0x1, 0xd5, 0x10, 0x4b, 0x0, 0x0,
    0x1, 0xcb, 0x6e, 0xcc, 0xf2, 0x78, 0x0, 0x0,
    0x0, 0xa, 0x6a, 0x11, 0xd2, 0xbf, 0xff, 0x90,
    0x16, 0x0, 0x5e, 0xcc, 0xf2, 0xf2, 0x4c, 0x10,
    0x2d, 0x90, 0x5a, 0x22, 0xd7, 0xf1, 0x4a, 0x0,
    0x1, 0xd7, 0x4c, 0xcc, 0xcc, 0xe4, 0x68, 0x0,
    0x0, 0x11, 0x0, 0x97, 0x4, 0x67, 0x95, 0x0,
    0x0, 0x65, 0xef, 0xee, 0xed, 0x2c, 0xd2, 0x0,
    0x0, 0xe2, 0xd, 0x10, 0x0, 0xd, 0xd0, 0x0,
    0x2, 0xf0, 0xf, 0xff, 0xf0, 0xb, 0xb0, 0x0,
    0x5, 0xc0, 0x4d, 0x0, 0xf0, 0x5d, 0xe5, 0x0,
    0xa, 0x70, 0xb7, 0x1, 0xe2, 0xe3, 0x5e, 0x20,
    0xe, 0x38, 0xc0, 0xae, 0xae, 0x60, 0x9, 0xc0,
    0x4, 0x6, 0x10, 0x21, 0x4, 0x0, 0x0, 0x20,

    /* U+700F "瀏" */
    0x2, 0x0, 0x2, 0x70, 0x0, 0x0, 0x8, 0x1,
    0xe8, 0xc, 0xd7, 0xcd, 0xd5, 0x30, 0xe1, 0x2,
    0xd9, 0xe1, 0x54, 0x87, 0x5e, 0xe, 0x10, 0x0,
    0x2e, 0xd, 0x75, 0x85, 0xe0, 0xe1, 0x48, 0x0,
    0xeb, 0xdf, 0x3c, 0x4e, 0xe, 0x12, 0xcb, 0x1b,
    0x31, 0xb3, 0x80, 0xe0, 0xe1, 0x0, 0xc3, 0x3,
    0xdc, 0x91, 0xe, 0xe, 0x10, 0x0, 0x19, 0xe5,
    0x17, 0xe5, 0xe0, 0xe1, 0x0, 0x77, 0x88, 0xce,
    0xb4, 0x3e, 0xe, 0x10, 0xf, 0x4, 0x47, 0xc4,
    0x40, 0xe0, 0xe1, 0x4, 0xc0, 0x89, 0xad, 0x8b,
    0xd, 0xe, 0x10, 0x98, 0x5, 0xb3, 0xb6, 0x90,
    0x0, 0xe1, 0xe, 0x30, 0x18, 0x6c, 0xa8, 0x50,
    0xf, 0x14, 0xd0, 0x7c, 0xba, 0x98, 0x64, 0x5d,
    0xd0, 0x13, 0x0, 0x0, 0x0, 0x0, 0x1, 0x40,
    0x0,

    /* U+70B9 "点" */
    0x0, 0x0, 0x0, 0x2b, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf3, 0x33, 0x33, 0x30, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0x22, 0x5f, 0x22, 0x22, 0x20, 0x0, 0x2, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x2f, 0x10,
    0x0, 0x0, 0x4, 0xe0, 0x0, 0x2, 0xf1, 0x0,
    0x0, 0x0, 0x4e, 0x0, 0x0, 0x2f, 0x43, 0x33,
    0x33, 0x36, 0xe0, 0x0, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x23, 0x0, 0x0, 0x1,
    0x0, 0x40, 0x0, 0xb, 0x90, 0xb7, 0x5, 0xd0,
    0x1e, 0x50, 0x3, 0xf1, 0x8, 0xa0, 0xf, 0x40,
    0x5e, 0x10, 0xd8, 0x0, 0x4e, 0x0, 0xa9, 0x0,
    0xba, 0x19, 0x0, 0x1, 0x80, 0x3, 0x30, 0x3,
    0x40,

    /* U+70ED "热" */
    0x0, 0x9, 0x60, 0x0, 0xb5, 0x0, 0x0, 0x0,
    0x0, 0xa, 0x70, 0x0, 0xd5, 0x0, 0x0, 0x0,
    0xb, 0xce, 0xec, 0x4e, 0xfe, 0xee, 0xb0, 0x0,
    0x4, 0x5c, 0xa5, 0x14, 0xd8, 0x47, 0xd0, 0x0,
    0x0, 0xa, 0x73, 0x0, 0xd4, 0x4, 0xd0, 0x0,
    0x1, 0x5d, 0xfe, 0x7b, 0xf3, 0x4, 0xd0, 0x0,
    0x6f, 0xde, 0x90, 0x19, 0xfa, 0x23, 0xd0, 0x0,
    0x22, 0xa, 0x70, 0x9, 0xbb, 0xf7, 0xe0, 0xc1,
    0x0, 0xb, 0x70, 0x5f, 0x20, 0x52, 0xf4, 0xe0,
    0x6, 0xcf, 0x46, 0xf5, 0x0, 0x0, 0xaf, 0x80,
    0x3, 0x83, 0x2, 0x40, 0x2, 0x0, 0x64, 0x0,
    0x0, 0xc6, 0xb, 0x70, 0x5e, 0x0, 0xd7, 0x0,
    0x3, 0xf0, 0x7, 0xc0, 0xe, 0x40, 0x4e, 0x10,
    0xc, 0x80, 0x4, 0xf0, 0xa, 0xa0, 0xc, 0x80,
    0x8, 0x10, 0x1, 0x60, 0x2, 0x10, 0x3, 0x20,

    /* U+7121 "無" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0x91, 0x11, 0x11, 0x11, 0x11, 0x0, 0x9,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x7, 0xfd,
    0x60, 0xf1, 0x4c, 0x9, 0x70, 0x0, 0xb5, 0xa6,
    0xf, 0x14, 0xc0, 0x97, 0x0, 0x1, 0x2b, 0x72,
    0xf3, 0x5c, 0x29, 0x82, 0x0, 0x8f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0xa, 0x60, 0xf1,
    0x4c, 0x9, 0x70, 0x0, 0x0, 0xa6, 0xf, 0x14,
    0xc0, 0x97, 0x0, 0x3e, 0xef, 0xee, 0xfe, 0xef,
    0xef, 0xee, 0xd0, 0x34, 0x53, 0x33, 0x33, 0x53,
    0x37, 0x33, 0x0, 0x6c, 0x8, 0x90, 0x4f, 0x1,
    0xf4, 0x0, 0xd, 0x60, 0x5d, 0x0, 0xe5, 0x7,
    0xd0, 0x6, 0xe0, 0x2, 0xf0, 0xa, 0x70, 0xe,
    0x40, 0x13, 0x0, 0x1, 0x0, 0x0, 0x0, 0x10,

    /* U+7248 "版" */
    0x0, 0x20, 0x16, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0xe3, 0x2f, 0x2, 0x56, 0x8b, 0xef, 0x0,
    0x0, 0xe3, 0x2f, 0xd, 0xec, 0xa7, 0x41, 0x0,
    0x0, 0xe3, 0x2f, 0xd, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xe5, 0x4f, 0x2d, 0x62, 0x22, 0x22, 0x0,
    0x0, 0xef, 0xff, 0xcd, 0xff, 0xee, 0xfd, 0x0,
    0x0, 0xe3, 0x0, 0xd, 0x5f, 0x10, 0x7b, 0x0,
    0x0, 0xf5, 0x22, 0xd, 0x3d, 0x50, 0xb6, 0x0,
    0x0, 0xff, 0xfe, 0xe, 0x38, 0xb1, 0xf1, 0x0,
    0x0, 0xf2, 0x3e, 0xf, 0x11, 0xea, 0x90, 0x0,
    0x3, 0xf0, 0x3e, 0x3e, 0x0, 0x8f, 0x20, 0x0,
    0x6, 0xd0, 0x3e, 0x7a, 0x2, 0xed, 0xa0, 0x0,
    0xc, 0x80, 0x3e, 0xd4, 0x6e, 0x50, 0xcb, 0x10,
    0x4f, 0x10, 0x3f, 0x79, 0xb2, 0x0, 0x9, 0xd0,
    0x2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,

    /* U+72B6 "状" */
    0x0, 0x0, 0x51, 0x0, 0x5, 0x10, 0x0, 0x0,
    0x0, 0xe, 0x40, 0x0, 0xe5, 0x62, 0x0, 0x0,
    0x0, 0xe4, 0x0, 0xe, 0x59, 0xd0, 0x0, 0xd4,
    0xe, 0x40, 0x0, 0xe5, 0xd, 0x80, 0x8, 0xb0,
    0xe4, 0x0, 0xe, 0x50, 0x3a, 0x0, 0x2f, 0x1e,
    0x44, 0x44, 0xf8, 0x44, 0x42, 0x0, 0xb7, 0xe5,
    0xdd, 0xdf, 0xed, 0xdd, 0x60, 0x5, 0x8e, 0x40,
    0x0, 0xf6, 0x0, 0x0, 0x0, 0x1, 0xf4, 0x0,
    0x2f, 0xa0, 0x0, 0x0, 0x4, 0xef, 0x40, 0x6,
    0xef, 0x10, 0x0, 0x1a, 0xf6, 0xe4, 0x0, 0xc7,
    0xb8, 0x0, 0x7, 0xc2, 0xe, 0x40, 0x5e, 0x13,
    0xf4, 0x0, 0x0, 0x0, 0xe4, 0x2f, 0x60, 0x8,
    0xe3, 0x0, 0x0, 0xe, 0x6e, 0x90, 0x0, 0xa,
    0xf4, 0x0, 0x0, 0xea, 0x90, 0x0, 0x0, 0x8,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+72C0 "狀" */
    0x0, 0x0, 0x5, 0x0, 0x1, 0x50, 0x0, 0x0,
    0x0, 0x20, 0xe, 0x20, 0x3, 0xe0, 0x0, 0x0,
    0x1, 0xf0, 0xe, 0x20, 0x3, 0xe2, 0xe2, 0x0,
    0x1, 0xf0, 0xe, 0x20, 0x3, 0xe0, 0x7d, 0x10,
    0x1, 0xf0, 0xe, 0x20, 0x3, 0xe0, 0x8, 0x10,
    0x1, 0xfa, 0xaf, 0x33, 0x36, 0xf3, 0x33, 0x20,
    0x0, 0x88, 0x8f, 0x4f, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xe, 0x20, 0x4, 0xf0, 0x0, 0x0,
    0x4, 0x44, 0x4f, 0x20, 0x7, 0xf3, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0x20, 0xa, 0xf9, 0x0, 0x0,
    0x0, 0xc4, 0xe, 0x20, 0x1f, 0xbf, 0x10, 0x0,
    0x0, 0xe2, 0xe, 0x20, 0x9e, 0x1d, 0xa0, 0x0,
    0x2, 0xf0, 0xe, 0x24, 0xf6, 0x3, 0xf7, 0x0,
    0xa, 0x90, 0xe, 0x5f, 0xa0, 0x0, 0x6f, 0x80,
    0x3e, 0x10, 0xe, 0x8a, 0x0, 0x0, 0x5, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+73B0 "现" */
    0x0, 0x0, 0x0, 0x13, 0x33, 0x33, 0x33, 0x0,
    0x1d, 0xdd, 0xdb, 0x7f, 0xee, 0xee, 0xed, 0x0,
    0x5, 0x6f, 0x54, 0x79, 0x1, 0x0, 0x5d, 0x0,
    0x0, 0x2f, 0x0, 0x79, 0xd, 0x50, 0x5d, 0x0,
    0x0, 0x2f, 0x0, 0x79, 0xd, 0x50, 0x5d, 0x0,
    0x0, 0x2f, 0x0, 0x79, 0xd, 0x50, 0x5d, 0x0,
    0xf, 0xff, 0xfd, 0x79, 0xd, 0x40, 0x5d, 0x0,
    0x3, 0x4f, 0x32, 0x79, 0xf, 0x30, 0x5d, 0x0,
    0x0, 0x2f, 0x0, 0x79, 0x1f, 0x70, 0x5d, 0x0,
    0x0, 0x2f, 0x0, 0x57, 0x6f, 0xf0, 0x39, 0x0,
    0x0, 0x2f, 0x37, 0x1, 0xea, 0xf0, 0x0, 0x30,
    0x27, 0xbf, 0xea, 0x2b, 0xc4, 0xf0, 0x0, 0xe1,
    0x5a, 0x73, 0x2, 0xcd, 0x23, 0xf4, 0x24, 0xf0,
    0x0, 0x0, 0x2f, 0xc1, 0x0, 0xcf, 0xff, 0x90,
    0x0, 0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+73FE "現" */
    0x0, 0x0, 0x0, 0x13, 0x33, 0x33, 0x31, 0x0,
    0xcd, 0xdd, 0xd7, 0xfd, 0xdd, 0xde, 0x90, 0x4,
    0x5f, 0x75, 0x7c, 0x0, 0x0, 0x69, 0x0, 0x0,
    0xe3, 0x6, 0xc2, 0x22, 0x28, 0x90, 0x0, 0xe,
    0x30, 0x6f, 0xdd, 0xdd, 0xe9, 0x0, 0x0, 0xe3,
    0x6, 0xc0, 0x0, 0x6, 0x90, 0xc, 0xff, 0xff,
    0x7f, 0xdd, 0xdd, 0xe9, 0x0, 0x22, 0xe5, 0x26,
    0xc2, 0x22, 0x28, 0x90, 0x0, 0xe, 0x30, 0x6c,
    0x11, 0x11, 0x79, 0x0, 0x0, 0xe3, 0x6, 0xff,
    0xff, 0xff, 0x90, 0x0, 0xe, 0x32, 0x10, 0xf2,
    0x3e, 0x0, 0x1, 0x68, 0xff, 0xd3, 0x6e, 0x3,
    0xe0, 0x17, 0x4a, 0x74, 0x10, 0x6f, 0x40, 0x2f,
    0x14, 0xd0, 0x0, 0x2, 0xde, 0x40, 0x0, 0xdf,
    0xf8, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+7528 "用" */
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0x6d, 0x33, 0x37, 0xf3, 0x33, 0x7e, 0x0, 0x6d,
    0x0, 0x4, 0xe0, 0x0, 0x4e, 0x0, 0x6d, 0x0,
    0x4, 0xe0, 0x0, 0x4e, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x6d, 0x22, 0x26, 0xe2,
    0x22, 0x6e, 0x0, 0x6d, 0x0, 0x4, 0xe0, 0x0,
    0x4e, 0x0, 0x6d, 0x33, 0x37, 0xf3, 0x33, 0x7e,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0xaa, 0x0, 0x4, 0xe0, 0x0, 0x4e, 0x0, 0xe6,
    0x0, 0x4, 0xe0, 0x0, 0x4e, 0x5, 0xf1, 0x0,
    0x4, 0xe0, 0x3, 0x9e, 0xd, 0x80, 0x0, 0x4,
    0xe0, 0x2f, 0xe6, 0x2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+7535 "电" */
    0x0, 0x0, 0x2d, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x10, 0x0, 0x0, 0x0, 0xcd, 0xdd,
    0xdf, 0xdd, 0xdd, 0xc0, 0x0, 0xe7, 0x44, 0x6f,
    0x44, 0x47, 0xf0, 0x0, 0xe4, 0x0, 0x2f, 0x10,
    0x4, 0xf0, 0x0, 0xe5, 0x0, 0x3f, 0x10, 0x4,
    0xf0, 0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xe5, 0x0, 0x3f, 0x10, 0x4, 0xf0, 0x0,
    0xe4, 0x0, 0x2f, 0x10, 0x4, 0xf0, 0x0, 0xe7,
    0x33, 0x5f, 0x43, 0x36, 0xf0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x10, 0x0, 0x0, 0x2f,
    0x10, 0x0, 0x4, 0xf0, 0x0, 0x0, 0x1f, 0x62,
    0x22, 0x3a, 0xd0, 0x0, 0x0, 0x9, 0xff, 0xff,
    0xfd, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+767B "登" */
    0x0, 0x0, 0x0, 0x3, 0x70, 0x5, 0x30, 0x0,
    0x9, 0xff, 0xff, 0xf8, 0xf3, 0xae, 0x40, 0x0,
    0x0, 0x70, 0x2, 0xf2, 0xaf, 0x91, 0x5, 0x0,
    0x1, 0xcb, 0x1c, 0x80, 0x1e, 0x32, 0xcd, 0x0,
    0x0, 0xc, 0xec, 0x10, 0x6, 0xef, 0x80, 0x0,
    0x0, 0x3d, 0xac, 0xee, 0xee, 0xae, 0x60, 0x0,
    0x2a, 0xe6, 0x0, 0x0, 0x0, 0x3, 0xcd, 0x70,
    0x58, 0x1b, 0xee, 0xee, 0xee, 0xee, 0x35, 0xa0,
    0x0, 0xc, 0x50, 0x0, 0x0, 0xd, 0x40, 0x0,
    0x0, 0xc, 0x62, 0x22, 0x22, 0x2e, 0x40, 0x0,
    0x0, 0xa, 0xdd, 0xdd, 0xdd, 0xdd, 0x30, 0x0,
    0x0, 0x0, 0x59, 0x0, 0x3, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0x40, 0x2d, 0x30, 0x0, 0x0,
    0xa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10,

    /* U+767C "發" */
    0x0, 0x0, 0x0, 0x0, 0xa1, 0x4, 0x60, 0x0,
    0x4, 0xff, 0xff, 0xfd, 0x9a, 0xbd, 0x40, 0x0,
    0x0, 0x95, 0x0, 0xc6, 0x1e, 0x90, 0x4c, 0x20,
    0x0, 0x3e, 0x9c, 0x80, 0x4, 0xeb, 0xc4, 0x0,
    0x0, 0x7, 0xf6, 0x0, 0x0, 0x4e, 0xa2, 0x0,
    0x6, 0xdf, 0xff, 0x34, 0xff, 0xff, 0xaf, 0xb2,
    0x9, 0x40, 0xf, 0x35, 0xc0, 0xe, 0x30, 0x50,
    0x0, 0x9d, 0xdf, 0x4d, 0x80, 0xc, 0xed, 0x30,
    0x0, 0xc5, 0x22, 0x9, 0x33, 0x33, 0x52, 0x0,
    0x0, 0xe3, 0x0, 0x1f, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0xef, 0xff, 0x7, 0x41, 0x19, 0xd0, 0x0,
    0x0, 0x0, 0x3e, 0x6, 0xcc, 0xad, 0x10, 0x0,
    0x0, 0x0, 0x7d, 0x3, 0x8e, 0xbe, 0x81, 0x0,
    0x0, 0x7f, 0xd6, 0x5e, 0x81, 0x2, 0x9f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0,

    /* U+7684 "的" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x40, 0x0, 0x89, 0x0, 0x0, 0x0, 0x2f,
    0x20, 0x0, 0xd6, 0x0, 0x0, 0x2, 0x8e, 0x22,
    0x3, 0xf6, 0x55, 0x52, 0x3f, 0xff, 0xff, 0x39,
    0xec, 0xcc, 0xf6, 0x3e, 0x0, 0xe, 0x5f, 0x30,
    0x0, 0xd6, 0x3e, 0x0, 0xe, 0x8b, 0x0, 0x0,
    0xd5, 0x3e, 0x0, 0xe, 0x30, 0x70, 0x0, 0xe5,
    0x3f, 0x33, 0x3f, 0x30, 0xe6, 0x0, 0xe5, 0x3f,
    0xff, 0xff, 0x30, 0x4f, 0x10, 0xe4, 0x3e, 0x0,
    0xe, 0x30, 0xb, 0xa0, 0xf4, 0x3e, 0x0, 0xe,
    0x30, 0x2, 0x20, 0xf3, 0x3e, 0x0, 0xe, 0x30,
    0x0, 0x0, 0xf3, 0x3e, 0x11, 0x1e, 0x30, 0x0,
    0x3, 0xf2, 0x3f, 0xff, 0xff, 0x30, 0x5, 0xef,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x53, 0x0,

    /* U+78BA "確" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0xb0, 0x0, 0x0,
    0x33, 0x33, 0x30, 0x11, 0x7e, 0x11, 0x10, 0xe,
    0xef, 0xee, 0xbf, 0xff, 0xff, 0xff, 0x30, 0x1,
    0xf0, 0xb, 0x21, 0xf2, 0x10, 0xd3, 0x0, 0x6b,
    0x0, 0xb2, 0x8b, 0x3d, 0x9, 0x20, 0xc, 0x60,
    0x1, 0x3f, 0x52, 0xf3, 0x20, 0x3, 0xfc, 0xc8,
    0x1d, 0xcc, 0xdf, 0xcc, 0x20, 0xbf, 0x46, 0xcd,
    0xf2, 0x2, 0xc0, 0x0, 0x5e, 0xe0, 0x3b, 0x7e,
    0xff, 0xff, 0xfe, 0x6, 0x5e, 0x3, 0xb0, 0xe2,
    0x2, 0xc0, 0x0, 0x0, 0xe0, 0x3b, 0xe, 0xff,
    0xff, 0xfe, 0x0, 0xe, 0x3, 0xb0, 0xe2, 0x2,
    0xc0, 0x0, 0x0, 0xe9, 0xab, 0xe, 0x43, 0x5d,
    0x33, 0x10, 0x7, 0x99, 0x60, 0xed, 0xcc, 0xcc,
    0xc8,

    /* U+79D2 "秒" */
    0x0, 0x0, 0x2, 0x30, 0x3, 0xe0, 0x0, 0x0,
    0x6, 0x9b, 0xef, 0x80, 0x4, 0xe0, 0x0, 0x0,
    0xa, 0x8d, 0x70, 0x1, 0xb4, 0xe2, 0xd1, 0x0,
    0x0, 0xc, 0x50, 0x6, 0xd4, 0xe0, 0xc9, 0x0,
    0x7, 0x7d, 0xa7, 0x4b, 0x84, 0xe0, 0x3f, 0x20,
    0xa, 0xaf, 0xca, 0x7f, 0x34, 0xe0, 0xb, 0x90,
    0x0, 0x3f, 0x50, 0x7d, 0x4, 0xe0, 0x3, 0xf1,
    0x0, 0xbf, 0xc4, 0xe6, 0x4, 0xe0, 0x35, 0x81,
    0x4, 0xdc, 0xaf, 0x60, 0x4, 0xe1, 0xe7, 0x0,
    0xe, 0x4c, 0x56, 0x90, 0x1, 0x6c, 0xb0, 0x0,
    0x69, 0xc, 0x50, 0x0, 0x2, 0xdb, 0x0, 0x0,
    0x0, 0xc, 0x50, 0x1, 0x8f, 0x80, 0x0, 0x0,
    0x0, 0xc, 0x53, 0x9f, 0xc3, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x5b, 0xa4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7A0D "稍" */
    0x0, 0x0, 0x0, 0x0, 0x2, 0x90, 0x0, 0x0,
    0x25, 0x8c, 0xc9, 0x70, 0x3e, 0x0, 0xa4, 0xd,
    0xbf, 0x61, 0x2e, 0x43, 0xe0, 0x6e, 0x0, 0x0,
    0xf2, 0x0, 0x5d, 0x3e, 0x1f, 0x30, 0x4, 0x4f,
    0x54, 0x13, 0x55, 0xf3, 0x43, 0x1, 0xee, 0xfe,
    0xe5, 0xfe, 0xee, 0xee, 0xf0, 0x0, 0x6f, 0x20,
    0x5c, 0x0, 0x0, 0x1f, 0x0, 0xd, 0xfe, 0x25,
    0xff, 0xff, 0xff, 0xf0, 0x5, 0xaf, 0x8d, 0x6c,
    0x22, 0x22, 0x3f, 0x0, 0xe3, 0xf2, 0xb8, 0xc0,
    0x0, 0x1, 0xf0, 0x7a, 0xf, 0x20, 0x5f, 0xff,
    0xff, 0xff, 0x0, 0x10, 0xf2, 0x5, 0xc1, 0x11,
    0x13, 0xf0, 0x0, 0xf, 0x20, 0x5c, 0x0, 0x2,
    0x6f, 0x0, 0x0, 0xf2, 0x5, 0xc0, 0x0, 0xef,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+7B49 "等" */
    0x0, 0x5, 0x90, 0x0, 0x7, 0x70, 0x0, 0x0,
    0x0, 0xea, 0x44, 0x42, 0xf8, 0x44, 0x43, 0x0,
    0xae, 0xee, 0xbc, 0xdd, 0xcf, 0xcb, 0x90, 0x9e,
    0x24, 0xe1, 0x5b, 0x0, 0xb9, 0x0, 0x6, 0x40,
    0x5, 0xb, 0x80, 0x1, 0x30, 0x0, 0x9, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0xb, 0x80, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfe, 0x1, 0x11, 0x11, 0x11,
    0x11, 0xaa, 0x11, 0x10, 0x13, 0x33, 0x33, 0x33,
    0x3b, 0xb3, 0x30, 0x4, 0xcc, 0xec, 0xcc, 0xcc,
    0xee, 0xcc, 0x20, 0x0, 0x2f, 0x70, 0x0, 0xa,
    0x90, 0x0, 0x0, 0x0, 0x3d, 0xc0, 0x0, 0xa9,
    0x0, 0x0, 0x0, 0x0, 0x16, 0x16, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xca, 0x70, 0x0,
    0x0,

    /* U+7B54 "答" */
    0x0, 0x8, 0x90, 0x0, 0xa, 0x30, 0x0, 0x0,
    0x2, 0xf7, 0x22, 0x25, 0xf3, 0x22, 0x21, 0x0,
    0xde, 0xfe, 0xec, 0xee, 0xff, 0xee, 0x60, 0xbd,
    0x9, 0xa0, 0x7b, 0x4, 0xe2, 0x0, 0x8, 0x10,
    0x5, 0xcd, 0xe3, 0x6, 0x30, 0x0, 0x0, 0x5,
    0xe9, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x4c, 0xd4,
    0x0, 0x3, 0xdd, 0x60, 0x4, 0xed, 0x6e, 0xff,
    0xff, 0xff, 0x8e, 0xf7, 0x15, 0x0, 0x12, 0x22,
    0x22, 0x20, 0x5, 0x40, 0x0, 0x22, 0x22, 0x22,
    0x22, 0x20, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x0, 0xf3, 0x0, 0x0, 0x0,
    0xe4, 0x0, 0x0, 0xf, 0x31, 0x11, 0x11, 0x1e,
    0x40, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+7CFB "系" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x35, 0x0,
    0x1, 0x9a, 0xab, 0xcd, 0xef, 0xff, 0xed, 0x10,
    0x0, 0x98, 0x76, 0xdb, 0x32, 0x12, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xd1, 0x0, 0x4f, 0x20, 0x0,
    0x0, 0x3, 0xda, 0x10, 0x16, 0xf5, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xff, 0xfd, 0x20, 0x0, 0x0,
    0x0, 0x11, 0x0, 0x6e, 0x80, 0x2c, 0x20, 0x0,
    0x0, 0x1, 0x6d, 0xc3, 0x0, 0x8, 0xe2, 0x0,
    0x0, 0xbf, 0xff, 0xde, 0xff, 0xff, 0xfe, 0x10,
    0x0, 0x66, 0x55, 0x47, 0xe2, 0x21, 0x1a, 0x60,
    0x0, 0x0, 0x7a, 0x5, 0xe0, 0xa9, 0x10, 0x0,
    0x0, 0x2b, 0xe3, 0x5, 0xe0, 0x2b, 0xf6, 0x0,
    0x8, 0xf9, 0x0, 0x7, 0xd0, 0x0, 0x5e, 0xc1,
    0xa, 0x30, 0x6, 0xff, 0x90, 0x0, 0x1, 0x90,
    0x0, 0x0, 0x0, 0x21, 0x0, 0x0, 0x0, 0x0,

    /* U+7D1A "級" */
    0x0, 0x8, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x10, 0x9f, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0xb8, 0x9, 0x37, 0xc2, 0x25, 0xe0, 0x0,
    0x5, 0xd0, 0x7c, 0x5, 0xb0, 0x9, 0x90, 0x0,
    0x3f, 0xca, 0xe2, 0x6, 0xe0, 0xe, 0x30, 0x0,
    0x16, 0x6f, 0x71, 0x7, 0xf2, 0x3f, 0xfd, 0x0,
    0x0, 0xaa, 0x3c, 0x8, 0xf7, 0x2, 0x6b, 0x0,
    0x7, 0xe4, 0x5e, 0x3a, 0xad, 0x0, 0xb5, 0x0,
    0x1f, 0xed, 0xbb, 0xac, 0x4d, 0x52, 0xe0, 0x0,
    0x2, 0x3, 0x5, 0x3f, 0x14, 0xec, 0x70, 0x0,
    0xe, 0xd, 0x1e, 0x5c, 0x0, 0xcf, 0x0, 0x0,
    0x2c, 0xb, 0x3a, 0xe6, 0x7, 0xed, 0xb0, 0x0,
    0x78, 0xa, 0x56, 0xe1, 0x9e, 0x31, 0xdc, 0x20,
    0x63, 0x4, 0x3e, 0x7e, 0xc2, 0x0, 0xa, 0xe0,
    0x0, 0x0, 0x3, 0x5, 0x0, 0x0, 0x0, 0x30,

    /* U+7D42 "終" */
    0x0, 0x6, 0x10, 0x0, 0x39, 0x0, 0x0, 0x0,
    0x4, 0xe0, 0x0, 0xa, 0x92, 0x22, 0x10, 0x0,
    0xc6, 0x4, 0x3, 0xff, 0xff, 0xf8, 0x0, 0x6d,
    0x6, 0xd0, 0xcb, 0x0, 0x1e, 0x30, 0x3f, 0x74,
    0xe3, 0x8b, 0xd5, 0xa, 0xa0, 0x7, 0xcc, 0xf8,
    0x8, 0x13, 0xe8, 0xd1, 0x0, 0x0, 0x7c, 0x43,
    0x0, 0xa, 0xf8, 0x0, 0x0, 0x4e, 0x14, 0xb0,
    0x3c, 0xd5, 0xeb, 0x20, 0x4f, 0xdc, 0xef, 0x7f,
    0x90, 0x1, 0x9f, 0xa1, 0x75, 0x42, 0x94, 0x1b,
    0xd8, 0x20, 0x25, 0x9, 0x29, 0xb, 0x0, 0x4,
    0xaf, 0x40, 0x0, 0xe0, 0xd2, 0xb4, 0x41, 0x0,
    0x10, 0x0, 0x3c, 0xb, 0x36, 0x9b, 0xfc, 0x61,
    0x0, 0x8, 0x80, 0xb4, 0x16, 0x1, 0x6c, 0xfa,
    0x0, 0x21, 0x0, 0x0, 0x0, 0x0, 0x2, 0x70,
    0x0,

    /* U+7D44 "組" */
    0x0, 0x6, 0x50, 0x0, 0x11, 0x11, 0x10, 0x0,
    0x0, 0x1f, 0x30, 0x6, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x9a, 0x6, 0x26, 0xb1, 0x11, 0x99, 0x0,
    0x3, 0xf1, 0x2e, 0x26, 0xb0, 0x0, 0x89, 0x0,
    0x1d, 0xb7, 0xd6, 0x6, 0xc2, 0x22, 0x99, 0x0,
    0x1a, 0x9e, 0xb0, 0x6, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x4e, 0x3c, 0x6, 0xb0, 0x0, 0x89, 0x0,
    0x2, 0xe3, 0xd, 0x46, 0xb0, 0x0, 0x89, 0x0,
    0xe, 0xfe, 0xff, 0xa6, 0xc3, 0x33, 0xa9, 0x0,
    0x4, 0x31, 0x1, 0x66, 0xff, 0xff, 0xf9, 0x0,
    0x7, 0x4c, 0x1e, 0x6, 0xb0, 0x0, 0x89, 0x0,
    0xc, 0x2b, 0x3a, 0x56, 0xb0, 0x0, 0x89, 0x0,
    0x1e, 0x9, 0x54, 0x77, 0xc2, 0x22, 0x9a, 0x20,
    0x5a, 0x6, 0x50, 0xcf, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+7D61 "絡" */
    0x0, 0x5, 0x20, 0x0, 0x48, 0x0, 0x0, 0x0,
    0x2, 0xf2, 0x0, 0xc, 0x93, 0x33, 0x10, 0x0,
    0xb7, 0x1, 0x6, 0xfd, 0xdd, 0xf6, 0x0, 0x6c,
    0x6, 0xd3, 0xfb, 0x0, 0x3e, 0x10, 0x3f, 0xcc,
    0xf4, 0xa6, 0x97, 0xc, 0x50, 0x1, 0x55, 0xf9,
    0x0, 0x0, 0xcd, 0x80, 0x0, 0x0, 0x9c, 0x96,
    0x1, 0xaf, 0xbf, 0x71, 0x0, 0x5e, 0x25, 0xd8,
    0xfc, 0x20, 0x4d, 0xf7, 0x2f, 0xff, 0xff, 0x95,
    0x11, 0x11, 0x14, 0x40, 0x53, 0x20, 0x53, 0xcf,
    0xff, 0xff, 0x20, 0xa, 0x2c, 0x3a, 0xc, 0x50,
    0x0, 0xe2, 0x0, 0xe0, 0xc2, 0xd1, 0xc5, 0x0,
    0xe, 0x20, 0x4b, 0xa, 0x49, 0x6c, 0x62, 0x22,
    0xe2, 0x6, 0x50, 0x75, 0x33, 0xce, 0xdd, 0xdf,
    0x20,

    /* U+7D71 "統" */
    0x0, 0x7, 0x30, 0x0, 0x9, 0x60, 0x0, 0x0,
    0x3, 0xe1, 0x0, 0x0, 0x6c, 0x0, 0x0, 0x0,
    0xc7, 0x1, 0xaf, 0xff, 0xff, 0xff, 0x30, 0x6d,
    0x7, 0x91, 0x17, 0xd1, 0x21, 0x10, 0x3f, 0xb9,
    0xe1, 0x1, 0xe3, 0xc, 0x50, 0x2, 0x76, 0xf5,
    0x0, 0xb8, 0x0, 0x2e, 0x10, 0x0, 0x99, 0x67,
    0x9f, 0xcc, 0xde, 0xfb, 0x0, 0x7e, 0x47, 0xd5,
    0x6f, 0x49, 0xa2, 0xc1, 0x2f, 0xed, 0xbd, 0x30,
    0xf0, 0x79, 0x0, 0x0, 0x20, 0x10, 0x61, 0x1f,
    0x7, 0x90, 0x0, 0xc, 0x2d, 0x2d, 0x4, 0xd0,
    0x79, 0x2, 0x20, 0xe0, 0xc2, 0xb2, 0x98, 0x7,
    0x90, 0x59, 0x4a, 0xb, 0x45, 0x8e, 0x10, 0x6b,
    0x29, 0x77, 0x60, 0x72, 0x6e, 0x30, 0x2, 0xef,
    0xe3, 0x0, 0x0, 0x2, 0x20, 0x0, 0x0, 0x0,
    0x0,

    /* U+7D9A "続" */
    0x0, 0x7, 0x50, 0x0, 0x0, 0x91, 0x0, 0x0,
    0x0, 0x1f, 0x30, 0x1, 0x11, 0xe3, 0x11, 0x10,
    0x0, 0xaa, 0x0, 0xd, 0xdd, 0xfe, 0xdd, 0xb0,
    0x4, 0xe1, 0x3e, 0x0, 0x0, 0xe2, 0x0, 0x0,
    0x2e, 0xc8, 0xe4, 0x8, 0xff, 0xff, 0xff, 0x10,
    0x17, 0x6e, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7c, 0x69, 0x2e, 0xee, 0xee, 0xee, 0xd0,
    0x5, 0xf5, 0x7f, 0x3c, 0x11, 0x11, 0x12, 0xe0,
    0xe, 0xec, 0xad, 0x8b, 0x28, 0x9, 0x21, 0xd0,
    0x2, 0x1, 0x4, 0x0, 0x3b, 0xd, 0x40, 0x0,
    0xa, 0x4e, 0x1e, 0x0, 0x5a, 0xd, 0x40, 0x0,
    0xe, 0xc, 0x2a, 0x50, 0xa7, 0xd, 0x40, 0x95,
    0x3c, 0xa, 0x45, 0x85, 0xe1, 0xc, 0x60, 0xb4,
    0x46, 0x6, 0x30, 0x6e, 0x30, 0x7, 0xff, 0xd1,
    0x0, 0x0, 0x0, 0x12, 0x0, 0x0, 0x0, 0x0,

    /* U+7DB2 "網" */
    0x0, 0x4, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd5, 0x2, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x7c, 0x2, 0x2d, 0x35, 0x23, 0x35, 0xb0, 0x2e,
    0x32, 0xf4, 0xd1, 0xc0, 0x94, 0x3b, 0xc, 0xd8,
    0xd7, 0x2d, 0x7, 0x4c, 0x3, 0xb0, 0x88, 0xdd,
    0x2, 0xdb, 0xff, 0xff, 0x5b, 0x0, 0x3f, 0x99,
    0x2d, 0x1, 0x91, 0x13, 0xb0, 0x1d, 0x61, 0xe3,
    0xd0, 0x1c, 0x30, 0x3b, 0xc, 0xfd, 0xff, 0x8d,
    0xaf, 0xff, 0xe3, 0xb0, 0x44, 0x21, 0x46, 0xd1,
    0xc0, 0x0, 0x3b, 0x4, 0x8a, 0x4d, 0x2d, 0x1c,
    0x11, 0x3, 0xb0, 0x96, 0x95, 0xb6, 0xd1, 0xff,
    0xf8, 0x3b, 0xe, 0x18, 0x76, 0x9d, 0x0, 0x0,
    0x6, 0xb1, 0x70, 0x22, 0x2, 0xd0, 0x0, 0x4e,
    0xc3,

    /* U+7EA7 "级" */
    0x0, 0x8, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0x10, 0xef, 0xff, 0xff, 0xf1, 0x0,
    0x0, 0xa7, 0x1, 0x2a, 0x82, 0x24, 0xe0, 0x0,
    0x4, 0xd0, 0x4d, 0xa, 0x60, 0x8, 0x90, 0x0,
    0x2e, 0xa7, 0xd5, 0xa, 0x80, 0xe, 0x20, 0x0,
    0x3c, 0xad, 0xb0, 0xb, 0xc0, 0x3f, 0xff, 0x0,
    0x0, 0x2e, 0x10, 0xc, 0xf2, 0x2, 0x6e, 0x0,
    0x0, 0xc5, 0x0, 0xe, 0xa8, 0x0, 0xa8, 0x0,
    0xb, 0xfa, 0xcb, 0x1f, 0x2f, 0x12, 0xf2, 0x0,
    0xb, 0x86, 0x41, 0x5c, 0x9, 0xbc, 0x80, 0x0,
    0x0, 0x0, 0x0, 0xb7, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x48, 0xc9, 0xf1, 0x9, 0xef, 0x80, 0x0,
    0x7f, 0xd9, 0x5d, 0x82, 0xbd, 0x23, 0xeb, 0x10,
    0x10, 0x0, 0x6d, 0x5f, 0xa1, 0x0, 0x2c, 0xe0,
    0x0, 0x0, 0x1, 0x14, 0x0, 0x0, 0x0, 0x30,

    /* U+7EC4 "组" */
    0x0, 0x3, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x70, 0xe, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x4e, 0x0, 0xe, 0x51, 0x11, 0xb8, 0x0,
    0x0, 0xd6, 0x8, 0x5e, 0x40, 0x0, 0xa8, 0x0,
    0x9, 0xd2, 0x4f, 0x1e, 0x51, 0x11, 0xb8, 0x0,
    0x1f, 0xed, 0xf7, 0xe, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x7, 0xd0, 0xe, 0x40, 0x0, 0xa8, 0x0,
    0x0, 0x3f, 0x30, 0xe, 0x40, 0x0, 0xa8, 0x0,
    0x1, 0xda, 0x47, 0xe, 0x62, 0x22, 0xb8, 0x0,
    0xb, 0xff, 0xca, 0xe, 0xff, 0xff, 0xf8, 0x0,
    0x2, 0x10, 0x0, 0xe, 0x40, 0x0, 0xa8, 0x0,
    0x0, 0x2, 0x46, 0xe, 0x40, 0x0, 0xa8, 0x0,
    0x4d, 0xfe, 0xca, 0x1e, 0x51, 0x11, 0xb9, 0x10,
    0x13, 0x10, 0x6, 0xff, 0xff, 0xff, 0xff, 0xf1,

    /* U+7EDC "络" */
    0x0, 0x4, 0x30, 0x0, 0x56, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x0, 0xd9, 0x44, 0x42, 0x0,
    0x0, 0x6c, 0x4, 0x17, 0xec, 0xcc, 0xf8, 0x0,
    0x1, 0xe3, 0x1e, 0x7f, 0xa0, 0x3, 0xf2, 0x0,
    0xa, 0xc4, 0xac, 0xd8, 0xc6, 0x1d, 0x70, 0x0,
    0x1e, 0xdd, 0xf2, 0x50, 0x1e, 0xe9, 0x0, 0x0,
    0x0, 0xc, 0x80, 0x0, 0x8f, 0xeb, 0x30, 0x0,
    0x0, 0x6d, 0x2, 0x9e, 0xc3, 0x7, 0xfd, 0x70,
    0x4, 0xf9, 0x8a, 0xa5, 0x11, 0x11, 0x26, 0x80,
    0xc, 0xeb, 0x94, 0xf, 0xff, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x20, 0x0, 0xe3, 0x0,
    0x0, 0x2, 0x58, 0x2f, 0x20, 0x0, 0xe3, 0x0,
    0x4c, 0xff, 0xda, 0x2f, 0x64, 0x44, 0xf3, 0x0,
    0x26, 0x30, 0x0, 0xf, 0xcc, 0xcc, 0xf3, 0x0,

    /* U+7EDF "统" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x85, 0x0, 0x0, 0xd6, 0x0, 0x0, 0x0,
    0x1f, 0x20, 0x0, 0x8, 0xb0, 0x0, 0x0, 0x7,
    0xb0, 0x1f, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xe3,
    0x1b, 0x22, 0x9c, 0x22, 0x22, 0x10, 0x9b, 0x29,
    0xa0, 0x2f, 0x30, 0x94, 0x0, 0x1f, 0xff, 0xf2,
    0xd, 0x90, 0x5, 0xe2, 0x0, 0x20, 0xb9, 0x1b,
    0xe4, 0x44, 0x5e, 0xc0, 0x0, 0x6e, 0x1, 0xbc,
    0xfc, 0xde, 0xaf, 0x50, 0x2f, 0xa8, 0x80, 0x3e,
    0x6, 0xb0, 0x30, 0xc, 0xec, 0x96, 0x5, 0xd0,
    0x6b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7b, 0x6,
    0xb0, 0x1, 0x1, 0x37, 0xad, 0x1d, 0x60, 0x6b,
    0x1, 0xe6, 0xfd, 0xa7, 0x5b, 0xd0, 0x6, 0xc1,
    0x5d, 0x0, 0x0, 0x2e, 0xc1, 0x0, 0x2e, 0xff,
    0x60, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0,

    /* U+7F51 "网" */
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x13, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x3e, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xe3, 0xe1, 0x60, 0x2e, 0x0,
    0xb, 0x6e, 0x3e, 0xe, 0x37, 0xac, 0x33, 0xe3,
    0xe3, 0xe0, 0x5c, 0xd4, 0x5d, 0xa9, 0x3e, 0x3e,
    0x0, 0xdd, 0x0, 0xcf, 0x23, 0xe3, 0xe0, 0xb,
    0xd0, 0x8, 0xf0, 0x3e, 0x3e, 0x4, 0xed, 0x41,
    0xfd, 0x73, 0xe3, 0xe0, 0xc7, 0x7b, 0x8a, 0x3e,
    0x4e, 0x3e, 0x6d, 0x1, 0x8f, 0x20, 0xc9, 0xe3,
    0xea, 0x40, 0xb, 0x70, 0x4, 0x6e, 0x3e, 0x0,
    0x0, 0x10, 0x2, 0x39, 0xd3, 0xe0, 0x0, 0x0,
    0x0, 0x9f, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+8046 "聆" */
    0x1, 0x11, 0x11, 0x10, 0x1, 0xa2, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0x9, 0xcb, 0x0, 0x0,
    0x3, 0xd0, 0x1f, 0x0, 0x4e, 0xd, 0x60, 0x0,
    0x3, 0xd0, 0x1f, 0x2, 0xe4, 0x3, 0xf4, 0x0,
    0x3, 0xff, 0xff, 0x2e, 0x87, 0x60, 0x6f, 0x60,
    0x3, 0xd1, 0x2f, 0xca, 0x3, 0xf1, 0x6, 0xf2,
    0x3, 0xd0, 0x1f, 0x20, 0x0, 0x96, 0x0, 0x20,
    0x3, 0xd4, 0x4f, 0x3, 0x33, 0x43, 0x32, 0x0,
    0x3, 0xfd, 0xdf, 0x1d, 0xdd, 0xdd, 0xec, 0x0,
    0x3, 0xd0, 0x1f, 0x0, 0x0, 0x1, 0xe5, 0x0,
    0x3, 0xd2, 0x5f, 0x94, 0xb2, 0xd, 0x80, 0x0,
    0x5e, 0xec, 0xbf, 0x60, 0x7e, 0xda, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x2, 0xcc, 0x10, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x8, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+807D "聽" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd1, 0x0, 0x0,
    0xef, 0xff, 0xf9, 0x77, 0x7f, 0x77, 0x73, 0x1,
    0xe0, 0xe, 0x18, 0x88, 0xf9, 0x88, 0x30, 0x1f,
    0xee, 0xe0, 0x44, 0x4f, 0x54, 0x40, 0x1, 0xe0,
    0xe, 0xe, 0xaf, 0xae, 0xaf, 0x0, 0x1f, 0xee,
    0xe0, 0xc0, 0xd0, 0xd0, 0xe0, 0x4, 0xe3, 0x3e,
    0xe, 0x8e, 0x8e, 0x8f, 0x2, 0xaa, 0xaa, 0xe0,
    0x34, 0x44, 0x44, 0x40, 0x8, 0x88, 0x5e, 0x7e,
    0xee, 0xee, 0xee, 0xb0, 0x5b, 0x94, 0xe0, 0x0,
    0x39, 0x0, 0x10, 0x8, 0xdc, 0x5e, 0xb, 0xb3,
    0xd5, 0x3b, 0x0, 0x3a, 0x72, 0xe5, 0x8c, 0x33,
    0x55, 0xc3, 0x28, 0xdd, 0x7e, 0xc2, 0xb4, 0x2,
    0xc4, 0xb2, 0x42, 0x0, 0xf7, 0x7, 0xff, 0xf7,
    0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+80FD "能" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5c, 0x0, 0x0, 0xf1, 0x0, 0x0, 0x1, 0xe4,
    0x84, 0x0, 0xf1, 0x7, 0xe2, 0xc, 0x90, 0x5e,
    0x20, 0xf9, 0xed, 0x50, 0xbf, 0xbc, 0xdf, 0xc0,
    0xfb, 0x40, 0x11, 0x55, 0x43, 0x22, 0xd2, 0xf1,
    0x0, 0x5c, 0x6, 0x66, 0x66, 0x20, 0xf7, 0x34,
    0xb9, 0x2f, 0xcc, 0xcf, 0x40, 0x7d, 0xdd, 0xb2,
    0x2f, 0x0, 0xd, 0x40, 0x80, 0x0, 0x0, 0x2f,
    0xff, 0xff, 0x40, 0xf1, 0x4, 0xc4, 0x2f, 0x0,
    0xd, 0x40, 0xf7, 0xde, 0x70, 0x2f, 0xee, 0xef,
    0x40, 0xfb, 0x50, 0x0, 0x2f, 0x11, 0x1d, 0x40,
    0xf1, 0x0, 0x4c, 0x2f, 0x0, 0xe, 0x30, 0xf5,
    0x11, 0xaa, 0x2f, 0x2, 0xfc, 0x10, 0x8f, 0xff,
    0xd3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+884C "行" */
    0x0, 0x0, 0x73, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x32, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x5f, 0x50, 0x3, 0x33, 0x33, 0x33, 0x0, 0x6f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x50,
    0x52, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x53, 0x33, 0x33, 0x33, 0x33, 0x0, 0x1d, 0xa1,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x1d, 0xf3, 0x0,
    0x0, 0x0, 0xf4, 0x0, 0x2d, 0xbf, 0x30, 0x0,
    0x0, 0xf, 0x40, 0x4, 0x80, 0xf3, 0x0, 0x0,
    0x0, 0xf4, 0x0, 0x0, 0xf, 0x30, 0x0, 0x0,
    0xf, 0x40, 0x0, 0x0, 0xf3, 0x0, 0x0, 0x0,
    0xf4, 0x0, 0x0, 0xf, 0x30, 0x0, 0x13, 0x6f,
    0x30, 0x0, 0x0, 0xf3, 0x0, 0x3, 0xfd, 0x80,
    0x0,

    /* U+898B "見" */
    0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x1f, 0x30, 0x0, 0x0, 0xd, 0x60, 0x0, 0x1,
    0xf6, 0x44, 0x44, 0x44, 0xd6, 0x0, 0x0, 0x1f,
    0xdc, 0xcc, 0xcc, 0xcf, 0x60, 0x0, 0x1, 0xf3,
    0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0x60, 0x0, 0x1, 0xf4, 0x11,
    0x11, 0x11, 0xd6, 0x0, 0x0, 0x1f, 0x41, 0x11,
    0x11, 0x1d, 0x60, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x0, 0xc, 0x80, 0x3f,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf2, 0x3, 0xf0,
    0x0, 0x6a, 0x0, 0x18, 0xf6, 0x0, 0x2f, 0x42,
    0x2b, 0x91, 0xbf, 0xc3, 0x0, 0x0, 0xbf, 0xff,
    0xe3, 0x7, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+89BD "覽" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x55, 0x55, 0x51, 0x2c, 0x0, 0x0, 0x0, 0x1e,
    0x77, 0xe7, 0x2a, 0xed, 0xdd, 0xdd, 0x11, 0xfa,
    0xaf, 0xa5, 0xc0, 0x5b, 0x0, 0x0, 0x1e, 0x11,
    0x1d, 0x8c, 0xbb, 0xeb, 0xb0, 0x1, 0xfb, 0xbe,
    0xc0, 0xd5, 0x8a, 0x3c, 0x0, 0x1e, 0x23, 0xd2,
    0xd, 0x58, 0xa3, 0xc0, 0x0, 0xaa, 0xaa, 0xa3,
    0x99, 0x99, 0x99, 0x0, 0x0, 0xcb, 0xaa, 0xaa,
    0xaa, 0xb8, 0x0, 0x0, 0xe, 0xcb, 0xbb, 0xbb,
    0xbd, 0x90, 0x0, 0x0, 0xe9, 0x55, 0x55, 0x55,
    0xa9, 0x0, 0x0, 0xe, 0x96, 0x66, 0x66, 0x6a,
    0x90, 0x0, 0x0, 0xab, 0xce, 0xbc, 0xeb, 0xc7,
    0x42, 0x0, 0x0, 0x2b, 0x70, 0x3e, 0x0, 0xc,
    0x70, 0x7a, 0xdd, 0x60, 0x0, 0xcf, 0xef, 0xd2,
    0x4, 0x51, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+89C8 "览" */
    0x0, 0x0, 0x9, 0x20, 0x9, 0x10, 0x0, 0x0,
    0xe, 0x40, 0xe4, 0x4, 0xf2, 0x22, 0x21, 0x0,
    0xe4, 0xe, 0x40, 0xcf, 0xff, 0xff, 0xa0, 0xe,
    0x40, 0xe4, 0x5e, 0x29, 0x30, 0x0, 0x0, 0xe4,
    0xe, 0x4e, 0x60, 0x6e, 0xa1, 0x0, 0x8, 0x20,
    0xa3, 0x30, 0x0, 0x1b, 0x70, 0x0, 0xb, 0xcc,
    0xcc, 0xcc, 0xcc, 0x30, 0x0, 0x0, 0xe8, 0x55,
    0x55, 0x55, 0xf4, 0x0, 0x0, 0xe, 0x40, 0xe,
    0x40, 0xe, 0x40, 0x0, 0x0, 0xe4, 0x1, 0xf7,
    0x0, 0xe4, 0x0, 0x0, 0xe, 0x40, 0x7f, 0xf0,
    0xe, 0x41, 0x10, 0x0, 0x10, 0x5f, 0x7f, 0x0,
    0x10, 0x7c, 0x0, 0x5, 0xcf, 0x61, 0xf5, 0x22,
    0x3b, 0x90, 0xbf, 0xe8, 0x10, 0xa, 0xff, 0xff,
    0xd3, 0x6, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+8A0A "訊" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x20, 0x1, 0x11, 0x11, 0x10, 0x0,
    0x0, 0x9, 0x60, 0xf, 0xff, 0xff, 0xe0, 0x0,
    0x2e, 0xef, 0xfe, 0xd0, 0x4d, 0x13, 0xe0, 0x0,
    0x2, 0x22, 0x22, 0x10, 0x4d, 0x2, 0xe0, 0x0,
    0x0, 0x22, 0x22, 0x0, 0x4d, 0x2, 0xe0, 0x0,
    0x4, 0xdd, 0xdd, 0x20, 0x4d, 0x2, 0xe0, 0x0,
    0x0, 0x11, 0x11, 0x3, 0x6d, 0x34, 0xe0, 0x0,
    0x5, 0xff, 0xff, 0x4e, 0xef, 0xea, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4d, 0x2, 0xe0, 0x0,
    0x3, 0xff, 0xff, 0x10, 0x4d, 0x2, 0xf0, 0x0,
    0x4, 0xc1, 0x1e, 0x10, 0x4d, 0x1, 0xf0, 0x61,
    0x4, 0xc0, 0xe, 0x10, 0x4d, 0x0, 0xf1, 0xd3,
    0x4, 0xc0, 0xe, 0x10, 0x4d, 0x0, 0xc9, 0xf0,
    0x3, 0xff, 0xff, 0x10, 0x4d, 0x0, 0x5f, 0x70,

    /* U+8A2A "訪" */
    0x0, 0x7, 0x10, 0x0, 0x0, 0x83, 0x0, 0x0,
    0x0, 0x9, 0x60, 0x0, 0x0, 0x99, 0x0, 0x0,
    0x6, 0x69, 0xc6, 0x53, 0x44, 0x8d, 0x44, 0x41,
    0xb, 0xbb, 0xbb, 0x99, 0xef, 0xee, 0xee, 0xe5,
    0x0, 0x11, 0x11, 0x0, 0x2f, 0x0, 0x0, 0x0,
    0x4, 0xff, 0xff, 0x30, 0x2e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xcc, 0xcc, 0x10,
    0x4, 0xff, 0xff, 0x40, 0x4d, 0x44, 0x6f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6b, 0x0, 0x2f, 0x0,
    0x2, 0xff, 0xff, 0x30, 0x89, 0x0, 0x3f, 0x0,
    0x2, 0xe2, 0x2d, 0x30, 0xb7, 0x0, 0x3e, 0x0,
    0x2, 0xe0, 0xd, 0x31, 0xf2, 0x0, 0x4d, 0x0,
    0x2, 0xe2, 0x2d, 0x39, 0xc0, 0x0, 0x8c, 0x0,
    0x2, 0xee, 0xee, 0x7f, 0x30, 0x8e, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x36, 0x0, 0x25, 0x30, 0x0,

    /* U+8A2D "設" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x0, 0x0, 0x45, 0x55, 0x40, 0x0,
    0x0, 0xc, 0x40, 0x0, 0xee, 0xdd, 0xe0, 0x0,
    0x3e, 0xef, 0xee, 0xd0, 0xe3, 0x2, 0xe0, 0x0,
    0x3, 0x33, 0x33, 0x20, 0xf2, 0x2, 0xe0, 0x0,
    0x1, 0x22, 0x22, 0x6, 0xe0, 0x1, 0xf8, 0x60,
    0x7, 0xff, 0xff, 0x3f, 0x40, 0x0, 0x8c, 0x90,
    0x0, 0x11, 0x11, 0x19, 0x66, 0x66, 0x65, 0x0,
    0x7, 0xff, 0xff, 0x2d, 0xea, 0xaa, 0xdc, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xf1, 0x0, 0xd6, 0x0,
    0x5, 0xff, 0xfe, 0x0, 0xac, 0x9, 0xe0, 0x0,
    0x6, 0xb2, 0x3f, 0x0, 0x1d, 0xdf, 0x30, 0x0,
    0x6, 0xa0, 0x1f, 0x0, 0xb, 0xfd, 0x10, 0x0,
    0x6, 0xa0, 0x1f, 0x4, 0xde, 0x5c, 0xe6, 0x0,
    0x6, 0xff, 0xff, 0x9f, 0xa1, 0x0, 0x8f, 0xe2,
    0x0, 0x0, 0x0, 0x53, 0x0, 0x0, 0x1, 0x70,

    /* U+8A66 "試" */
    0x0, 0xc, 0x0, 0x0, 0x0, 0x2c, 0x31, 0x0,
    0x0, 0xb, 0x50, 0x0, 0x0, 0x2e, 0x4d, 0x20,
    0x1e, 0xef, 0xfe, 0x80, 0x0, 0x2f, 0x4, 0x40,
    0x2, 0x22, 0x22, 0x6f, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x22, 0x22, 0x38, 0x88, 0x9f, 0x88, 0x70,
    0x3, 0xdd, 0xdd, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x14, 0x44, 0x1f, 0x10, 0x0,
    0x4, 0xff, 0xff, 0x3d, 0xfd, 0x5e, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe1, 0xc, 0x40, 0x0,
    0x2, 0xff, 0xfd, 0x0, 0xe1, 0xa, 0x60, 0x0,
    0x3, 0xc1, 0x2e, 0x0, 0xe1, 0x8, 0x90, 0x20,
    0x3, 0xc0, 0x1e, 0x0, 0xe5, 0x75, 0xe0, 0xd2,
    0x3, 0xc1, 0x2e, 0x8d, 0xed, 0xb1, 0xe9, 0xe0,
    0x2, 0xee, 0xec, 0x0, 0x0, 0x0, 0x5f, 0x60,

    /* U+8A71 "話" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x30, 0x0, 0x0, 0x2, 0x47, 0x20,
    0x0, 0x8, 0x80, 0x8, 0xce, 0xff, 0xdb, 0x30,
    0x1e, 0xef, 0xfe, 0xd4, 0x53, 0xe4, 0x0, 0x0,
    0x3, 0x33, 0x33, 0x20, 0x0, 0xe4, 0x0, 0x0,
    0x0, 0x22, 0x22, 0x0, 0x0, 0xe4, 0x0, 0x0,
    0x4, 0xee, 0xee, 0x4f, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x11, 0x11, 0x1, 0x22, 0xe5, 0x22, 0x20,
    0x4, 0xff, 0xff, 0x40, 0x0, 0xe4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0x99, 0xfb, 0x98, 0x0,
    0x2, 0xff, 0xff, 0x35, 0xe7, 0x77, 0x8e, 0x0,
    0x3, 0xe2, 0x2d, 0x45, 0xc0, 0x0, 0x2e, 0x0,
    0x3, 0xd0, 0xc, 0x45, 0xc0, 0x0, 0x2e, 0x0,
    0x3, 0xd1, 0x1d, 0x45, 0xd5, 0x55, 0x7e, 0x0,
    0x2, 0xff, 0xff, 0x35, 0xfc, 0xcc, 0xce, 0x0,

    /* U+8A8D "認" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x10, 0x5f, 0xff, 0xff, 0xff, 0x0,
    0x3e, 0xef, 0xee, 0x33, 0x17, 0xa0, 0x2f, 0x0,
    0x2, 0x22, 0x22, 0xb, 0x49, 0x80, 0x2e, 0x0,
    0x0, 0x11, 0x10, 0x2d, 0xd, 0x40, 0x3e, 0x0,
    0x7, 0xff, 0xfa, 0x75, 0x5e, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xe4, 0x4e, 0xf8, 0x0,
    0x7, 0xff, 0xfa, 0xae, 0x33, 0x25, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x31, 0x26, 0xc0, 0x2, 0x0,
    0x6, 0xff, 0xf8, 0x3a, 0xe1, 0xb7, 0x3d, 0x0,
    0x6, 0xa1, 0x78, 0x86, 0xe1, 0x23, 0xc, 0x40,
    0x6, 0xa0, 0x78, 0xe2, 0xe1, 0x2, 0xa5, 0xa0,
    0x6, 0xa1, 0x7b, 0xb0, 0xe4, 0x16, 0xb0, 0xb0,
    0x5, 0xee, 0xe7, 0x0, 0x9f, 0xff, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8AA4 "誤" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x10, 0x3, 0x44, 0x44, 0x44, 0x0,
    0x0, 0xc, 0x60, 0xb, 0xdc, 0xcc, 0xce, 0x0,
    0x1e, 0xef, 0xfe, 0xbb, 0x50, 0x0, 0x2e, 0x0,
    0x2, 0x22, 0x22, 0x2b, 0x50, 0x0, 0x2e, 0x0,
    0x0, 0x22, 0x22, 0xb, 0xff, 0xff, 0xfe, 0x0,
    0x5, 0xee, 0xee, 0x12, 0x44, 0x44, 0x43, 0x0,
    0x0, 0x11, 0x11, 0x17, 0x77, 0x77, 0x77, 0x20,
    0x6, 0xff, 0xff, 0x28, 0x88, 0xf8, 0x88, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf1, 0x0, 0x0,
    0x4, 0xff, 0xff, 0x8f, 0xff, 0xff, 0xff, 0xd0,
    0x4, 0xc2, 0x2f, 0x12, 0x26, 0xf6, 0x22, 0x20,
    0x4, 0xb0, 0xf, 0x0, 0xb, 0xed, 0x0, 0x0,
    0x4, 0xc2, 0x2f, 0x0, 0x9f, 0x2b, 0xc2, 0x0,
    0x4, 0xee, 0xee, 0x6d, 0xe4, 0x0, 0xaf, 0xa1,
    0x0, 0x0, 0x0, 0x98, 0x10, 0x0, 0x3, 0x90,

    /* U+8AAA "說" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x0, 0x0, 0x8, 0x3c, 0x0, 0x0,
    0x0, 0xc, 0x50, 0x0, 0x3e, 0xa, 0x80, 0x0,
    0x1e, 0xef, 0xee, 0xa0, 0xd6, 0x1, 0xf3, 0x0,
    0x3, 0x33, 0x33, 0x2a, 0xb0, 0x0, 0x6e, 0x20,
    0x0, 0x22, 0x22, 0x7f, 0x54, 0x44, 0x4b, 0xd0,
    0x4, 0xee, 0xee, 0x8, 0xfd, 0xdd, 0xeb, 0x20,
    0x0, 0x11, 0x11, 0x7, 0xa0, 0x0, 0x5b, 0x0,
    0x4, 0xff, 0xff, 0x7, 0xa0, 0x0, 0x5b, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xea, 0xaa, 0xcb, 0x0,
    0x3, 0xff, 0xfd, 0x2, 0x8d, 0x5f, 0x63, 0x0,
    0x4, 0xd2, 0x3e, 0x0, 0x6a, 0xe, 0x20, 0x0,
    0x4, 0xd0, 0x2e, 0x0, 0xb5, 0xe, 0x20, 0x60,
    0x4, 0xd1, 0x3e, 0x5, 0xc0, 0xe, 0x41, 0xe1,
    0x3, 0xff, 0xfd, 0x7a, 0x0, 0x9, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+8AAD "読" */
    0x0, 0x48, 0x0, 0x0, 0x3, 0x90, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x37, 0x7a, 0xf7, 0x77, 0x40,
    0x2d, 0xdf, 0xdd, 0x77, 0x79, 0xf7, 0x77, 0x30,
    0x3, 0x33, 0x33, 0x0, 0x5, 0xe0, 0x0, 0x0,
    0x0, 0x11, 0x10, 0x1f, 0xff, 0xff, 0xfd, 0x0,
    0x8, 0xff, 0xf9, 0x3, 0x33, 0x33, 0x33, 0x0,
    0x0, 0x0, 0x0, 0x79, 0x99, 0x99, 0x99, 0x70,
    0x8, 0xff, 0xf9, 0xc5, 0x44, 0x44, 0x46, 0xd0,
    0x0, 0x0, 0x0, 0xc2, 0xa3, 0xc, 0x2, 0xd0,
    0x7, 0xff, 0xf8, 0x10, 0xd3, 0xf, 0x0, 0x10,
    0x7, 0x91, 0x79, 0x0, 0xe2, 0xf, 0x0, 0x0,
    0x7, 0x80, 0x69, 0x2, 0xe0, 0xf, 0x0, 0xb1,
    0x7, 0x80, 0x69, 0xa, 0x70, 0xf, 0x33, 0xf0,
    0x7, 0xff, 0xf8, 0x99, 0x0, 0xa, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x0,

    /* U+8ACB "請" */
    0x0, 0xb, 0x10, 0x0, 0x0, 0xb1, 0x0, 0x0,
    0x0, 0xa, 0x60, 0x9, 0x99, 0xfa, 0x99, 0x60,
    0x1e, 0xef, 0xfe, 0x93, 0x33, 0xf4, 0x33, 0x20,
    0x2, 0x22, 0x22, 0x19, 0xbb, 0xfc, 0xbb, 0x40,
    0x0, 0x22, 0x22, 0x6, 0x88, 0xf8, 0x88, 0x30,
    0x4, 0xee, 0xee, 0x36, 0x66, 0xf7, 0x66, 0x61,
    0x1, 0x33, 0x33, 0x25, 0x55, 0x55, 0x55, 0x51,
    0x3, 0xbb, 0xbb, 0x8, 0xee, 0xee, 0xed, 0x0,
    0x0, 0x0, 0x0, 0x9, 0x70, 0x0, 0x2e, 0x0,
    0x3, 0xff, 0xff, 0x19, 0xfe, 0xee, 0xee, 0x0,
    0x3, 0xd2, 0x2f, 0x19, 0x70, 0x0, 0x2e, 0x0,
    0x3, 0xd0, 0xf, 0x19, 0xfe, 0xee, 0xee, 0x0,
    0x3, 0xd0, 0xf, 0x19, 0x70, 0x0, 0x2e, 0x0,
    0x3, 0xff, 0xff, 0x19, 0x70, 0x7, 0x97, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8B66 "警" */
    0x0, 0x8, 0x10, 0x90, 0x0, 0x90, 0x0, 0x1,
    0xbb, 0xfb, 0xbf, 0xb9, 0x6d, 0x44, 0x44, 0x1,
    0x77, 0x21, 0x91, 0x3f, 0x98, 0xbd, 0x70, 0x7d,
    0xbb, 0xbb, 0xf9, 0xb9, 0xc, 0x40, 0x37, 0xa8,
    0x88, 0xd, 0x0, 0xbd, 0x90, 0x0, 0xd, 0x89,
    0xb3, 0xe5, 0xbd, 0x7d, 0xb6, 0x0, 0x11, 0x11,
    0xaa, 0x74, 0x0, 0x4, 0x52, 0x88, 0x88, 0x88,
    0xcd, 0x88, 0x88, 0x88, 0x15, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x50, 0x2, 0xbb, 0xbb, 0xbb,
    0xbb, 0xb9, 0x0, 0x0, 0x2a, 0xaa, 0xaa, 0xaa,
    0xaa, 0x80, 0x0, 0x3, 0xaa, 0xaa, 0xaa, 0xaa,
    0xa9, 0x0, 0x0, 0x5b, 0x11, 0x11, 0x11, 0x12,
    0xe0, 0x0, 0x5, 0xeb, 0xbb, 0xbb, 0xbb, 0xce,
    0x0,

    /* U+8BBE "设" */
    0x0, 0x51, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xad, 0x10, 0xd, 0xff, 0xff, 0x90, 0x0,
    0x0, 0xd, 0xb0, 0xd, 0x60, 0xa, 0x90, 0x0,
    0x0, 0x2, 0xb0, 0xf, 0x50, 0xa, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x10, 0x8, 0xfd, 0xa0,
    0x4e, 0xee, 0x14, 0xf6, 0x0, 0x0, 0x34, 0x30,
    0x29, 0x9f, 0x10, 0x74, 0x44, 0x44, 0x42, 0x0,
    0x0, 0x1f, 0x10, 0xef, 0xdd, 0xdd, 0xf7, 0x0,
    0x0, 0x1f, 0x10, 0x1e, 0x40, 0x2, 0xf2, 0x0,
    0x0, 0x1f, 0x10, 0x7, 0xd0, 0xc, 0x80, 0x0,
    0x0, 0x1f, 0x11, 0x10, 0xbb, 0xac, 0x0, 0x0,
    0x0, 0x1f, 0x4d, 0x70, 0x2f, 0xf2, 0x0, 0x0,
    0x0, 0x2f, 0xf8, 0x6, 0xea, 0xce, 0x60, 0x0,
    0x0, 0x6f, 0x68, 0xed, 0x50, 0x6, 0xee, 0x80,
    0x0, 0x2, 0xa, 0x50, 0x0, 0x0, 0x6, 0x90,

    /* U+8BBF "访" */
    0x0, 0x10, 0x0, 0x0, 0x7, 0x40, 0x0, 0x0,
    0xe, 0x60, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0,
    0x4f, 0x31, 0x44, 0x49, 0xe4, 0x44, 0x40, 0x0,
    0x9c, 0x5e, 0xff, 0xee, 0xee, 0xed, 0x0, 0x0,
    0x10, 0x7, 0xb0, 0x0, 0x0, 0x1, 0xbb, 0xb0,
    0x0, 0x7a, 0x0, 0x0, 0x0, 0x5, 0x6f, 0x0,
    0x8, 0xff, 0xff, 0xf7, 0x0, 0x1, 0xf0, 0x0,
    0x9a, 0x33, 0x3d, 0x60, 0x0, 0x1f, 0x0, 0xa,
    0x70, 0x0, 0xd5, 0x0, 0x1, 0xf0, 0x0, 0xd5,
    0x0, 0xe, 0x40, 0x0, 0x1f, 0x2c, 0x2f, 0x10,
    0x0, 0xf4, 0x0, 0x1, 0xfe, 0xa8, 0xc0, 0x0,
    0xf, 0x30, 0x0, 0x5f, 0x82, 0xf5, 0x0, 0x17,
    0xf1, 0x0, 0x1, 0x60, 0xdb, 0x0, 0x7f, 0xf9,
    0x0, 0x0, 0x0, 0x4, 0x10, 0x0, 0x20, 0x0,
    0x0,

    /* U+8BD5 "试" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x60, 0x0, 0x0, 0x0, 0xf3, 0x80, 0x0,
    0x0, 0xd9, 0x0, 0x0, 0x0, 0xf4, 0xad, 0x10,
    0x0, 0x2f, 0x60, 0x0, 0x0, 0xe4, 0x8, 0x10,
    0x0, 0x5, 0x6c, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x2, 0x33, 0x33, 0xe7, 0x33, 0x30,
    0x4d, 0xda, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0,
    0x29, 0xbd, 0x3, 0x44, 0x43, 0xb7, 0x0, 0x0,
    0x0, 0x5d, 0xa, 0xdf, 0xdb, 0xa8, 0x0, 0x0,
    0x0, 0x5d, 0x0, 0xf, 0x20, 0x8a, 0x0, 0x0,
    0x0, 0x5d, 0x0, 0xf, 0x20, 0x6c, 0x0, 0x0,
    0x0, 0x5d, 0x57, 0xf, 0x20, 0x3f, 0x0, 0x30,
    0x0, 0x5f, 0xe5, 0x4f, 0xad, 0x4e, 0x50, 0xf1,
    0x0, 0x8e, 0x3d, 0xca, 0x73, 0x8, 0xd9, 0xc0,
    0x0, 0x33, 0x0, 0x0, 0x0, 0x1, 0xce, 0x30,

    /* U+8BDD "话" */
    0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf6, 0x1, 0x56, 0x78, 0xac, 0xdf, 0x10,
    0x0, 0x5f, 0x33, 0xdc, 0xbe, 0xc6, 0x42, 0x0,
    0x0, 0xa, 0x90, 0x0, 0xa, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x0,
    0x15, 0x55, 0xa, 0xdd, 0xdf, 0xed, 0xdd, 0xd0,
    0x3d, 0xde, 0x4, 0x66, 0x6c, 0xc6, 0x66, 0x60,
    0x0, 0x4e, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x0,
    0x0, 0x4e, 0x0, 0x24, 0x4b, 0xb4, 0x42, 0x0,
    0x0, 0x4e, 0x0, 0x9f, 0xee, 0xee, 0xfa, 0x0,
    0x0, 0x4e, 0x2, 0x99, 0x0, 0x0, 0x9a, 0x0,
    0x0, 0x4e, 0x6d, 0x99, 0x0, 0x0, 0x9a, 0x0,
    0x0, 0x4f, 0xd3, 0x9b, 0x33, 0x33, 0xaa, 0x0,
    0x0, 0x79, 0x0, 0x9f, 0xff, 0xff, 0xfa, 0x0,

    /* U+8BEF "误" */
    0x0, 0x50, 0x0, 0x11, 0x11, 0x11, 0x10, 0x0,
    0x0, 0xd9, 0x1, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x0, 0x2f, 0x61, 0xf1, 0x0, 0x0, 0xb8, 0x0,
    0x0, 0x6, 0x71, 0xf2, 0x0, 0x0, 0xb8, 0x0,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0x2e, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x4e, 0x8, 0xcc, 0xcc, 0xcc, 0xcc, 0x0,
    0x0, 0x3e, 0x3, 0x44, 0x4e, 0x64, 0x44, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0xe, 0x30, 0x0, 0x0,
    0x0, 0x3e, 0x2f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x3e, 0x3, 0x11, 0x7f, 0xc1, 0x11, 0x0,
    0x0, 0x3f, 0xc7, 0x2, 0xe7, 0xd8, 0x0, 0x0,
    0x0, 0x6f, 0x82, 0x8f, 0x80, 0x2d, 0xd5, 0x10,
    0x0, 0x46, 0x5f, 0xc3, 0x0, 0x0, 0x7e, 0xe0,
    0x0, 0x0, 0x12, 0x0, 0x0, 0x0, 0x0, 0x20,

    /* U+8BF4 "说" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x80, 0x0, 0x4a, 0x0, 0x0, 0xc1, 0x0,
    0x0, 0xca, 0x0, 0x1e, 0x70, 0x7, 0xc0, 0x0,
    0x0, 0x1f, 0x60, 0x5, 0xd0, 0x1f, 0x40, 0x0,
    0x0, 0x5, 0x30, 0xcc, 0xdc, 0xef, 0xca, 0x0,
    0x0, 0x0, 0x1, 0xf5, 0x55, 0x55, 0x7c, 0x0,
    0x1d, 0xdc, 0x1, 0xf0, 0x0, 0x0, 0x3c, 0x0,
    0x4, 0x7e, 0x1, 0xf0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x3e, 0x1, 0xf3, 0x22, 0x22, 0x5c, 0x0,
    0x0, 0x3e, 0x1, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x3e, 0x0, 0x6, 0xc0, 0x4d, 0x0, 0x0,
    0x0, 0x3e, 0x18, 0x8, 0xa0, 0x4d, 0x0, 0x0,
    0x0, 0x3f, 0xda, 0xe, 0x50, 0x4d, 0x0, 0xc3,
    0x0, 0x7f, 0x71, 0xbc, 0x0, 0x4e, 0x23, 0xf2,
    0x0, 0x14, 0x1e, 0xc1, 0x0, 0x1d, 0xff, 0xb0,
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8BF7 "请" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x10, 0x0, 0x0, 0xe3, 0x0, 0x0, 0x0,
    0xb9, 0x7, 0x99, 0x9f, 0xb9, 0x99, 0x20, 0x1,
    0xf3, 0x45, 0x55, 0xe7, 0x55, 0x51, 0x0, 0x7,
    0x43, 0xbb, 0xbf, 0xcb, 0xb9, 0x0, 0x0, 0x0,
    0x13, 0x33, 0xe6, 0x33, 0x30, 0x3e, 0xed, 0x3c,
    0xcc, 0xcf, 0xdc, 0xcc, 0xa0, 0x36, 0xe0, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x0, 0x3e, 0x1, 0xdd,
    0xdd, 0xdd, 0xd5, 0x0, 0x3, 0xe0, 0x1f, 0x21,
    0x11, 0x1b, 0x60, 0x0, 0x3e, 0x1, 0xfe, 0xee,
    0xee, 0xf6, 0x0, 0x3, 0xe1, 0x2f, 0x11, 0x11,
    0x1b, 0x60, 0x0, 0x3f, 0xd5, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x6, 0xf6, 0x1f, 0x0, 0x0, 0xb,
    0x60, 0x0, 0x34, 0x1, 0xf0, 0x0, 0x1d, 0xc2,
    0x0,

    /* U+8CC7 "資" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x90, 0x0, 0x1f, 0x20, 0x0, 0x0, 0x0,
    0x1, 0xae, 0x40, 0x9f, 0xcc, 0xcc, 0xcc, 0x20,
    0x0, 0x5, 0x45, 0xe3, 0x35, 0x22, 0x7e, 0x0,
    0x0, 0x3, 0x3e, 0x30, 0x7e, 0x0, 0xc4, 0x0,
    0x0, 0x7e, 0x40, 0x5, 0xea, 0xc3, 0x0, 0x0,
    0xc, 0xc2, 0x38, 0xdc, 0x30, 0x5d, 0xd8, 0x50,
    0x6, 0x5, 0xcd, 0x85, 0x55, 0x55, 0x87, 0x90,
    0x0, 0x1f, 0x77, 0x77, 0x77, 0x78, 0xe0, 0x0,
    0x0, 0x1f, 0xbb, 0xbb, 0xbb, 0xbc, 0xe0, 0x0,
    0x0, 0x1f, 0x55, 0x55, 0x55, 0x57, 0xe0, 0x0,
    0x0, 0x1f, 0x66, 0x66, 0x66, 0x67, 0xe0, 0x0,
    0x0, 0x1f, 0xdd, 0xdd, 0xdd, 0xdd, 0xe0, 0x0,
    0x0, 0x0, 0x59, 0x60, 0x5, 0x85, 0x10, 0x0,
    0x9, 0xdf, 0xc7, 0x10, 0x3, 0x8b, 0xfd, 0x90,
    0x6, 0x40, 0x0, 0x0, 0x0, 0x0, 0x4, 0x70,

    /* U+8D25 "败" */
    0x0, 0x0, 0x0, 0x0, 0x5, 0x70, 0x0, 0x0,
    0x1, 0x99, 0x99, 0x80, 0xb, 0x80, 0x0, 0x0,
    0x3, 0xf8, 0x89, 0xf0, 0x1f, 0x52, 0x22, 0x20,
    0x3, 0xe1, 0x72, 0xf0, 0x6f, 0xff, 0xff, 0xf1,
    0x3, 0xe2, 0xe2, 0xf0, 0xea, 0x0, 0x7b, 0x0,
    0x3, 0xe2, 0xe2, 0xf7, 0xfc, 0x0, 0xa8, 0x0,
    0x3, 0xe2, 0xe2, 0xfd, 0x6f, 0x0, 0xd5, 0x0,
    0x3, 0xe2, 0xe2, 0xf1, 0xc, 0x41, 0xf1, 0x0,
    0x3, 0xe2, 0xe2, 0xf0, 0x7, 0xb7, 0xb0, 0x0,
    0x3, 0xe3, 0xd2, 0xf0, 0x0, 0xee, 0x30, 0x0,
    0x0, 0x38, 0x91, 0x30, 0x0, 0xce, 0x0, 0x0,
    0x0, 0x2e, 0x6e, 0x20, 0x9, 0xdc, 0xb0, 0x0,
    0x2, 0xd7, 0x7, 0xe1, 0xad, 0x20, 0xdb, 0x0,
    0x3f, 0x80, 0x0, 0x8e, 0xc1, 0x0, 0x1b, 0xd1,
    0x4, 0x0, 0x0, 0x28, 0x0, 0x0, 0x0, 0x60,

    /* U+8D44 "资" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xa1, 0x0, 0x2f, 0x10, 0x0, 0x0, 0x0,
    0x1, 0xae, 0x30, 0xaf, 0xcc, 0xcc, 0xcc, 0x20,
    0x0, 0x6, 0x53, 0xe4, 0x44, 0x44, 0x7f, 0x10,
    0x0, 0x0, 0x1e, 0x60, 0x4a, 0x0, 0xc7, 0x0,
    0x0, 0xa, 0x85, 0x0, 0xcf, 0x40, 0x50, 0x0,
    0x2, 0xdb, 0x0, 0x4c, 0xb4, 0xea, 0x40, 0x0,
    0x2f, 0x70, 0xae, 0xd6, 0x0, 0x18, 0xee, 0xb0,
    0x2, 0x3, 0x86, 0x33, 0x33, 0x33, 0x33, 0x50,
    0x0, 0xf, 0xed, 0xdd, 0xdd, 0xde, 0xe0, 0x0,
    0x0, 0xf, 0x20, 0x8, 0x50, 0x4, 0xe0, 0x0,
    0x0, 0xf, 0x20, 0xd, 0x60, 0x4, 0xe0, 0x0,
    0x0, 0xf, 0x20, 0x6f, 0x51, 0x4, 0xe0, 0x0,
    0x0, 0x0, 0x2a, 0xf5, 0x9f, 0xc6, 0x10, 0x0,
    0x3, 0x8d, 0xfa, 0x20, 0x0, 0x6c, 0xfa, 0x20,
    0x6, 0xb6, 0x10, 0x0, 0x0, 0x0, 0x3b, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8D85 "超" */
    0x0, 0x0, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf1, 0xa, 0xef, 0xfe, 0xef, 0x10,
    0x7, 0xff, 0xff, 0xf1, 0x9, 0x80, 0x2f, 0x0,
    0x0, 0x11, 0xf2, 0x10, 0xe, 0x30, 0x3f, 0x0,
    0x0, 0x0, 0xf1, 0x0, 0x8b, 0x2, 0x8e, 0x0,
    0xb, 0xbb, 0xfb, 0xb7, 0xe2, 0x2f, 0xd5, 0x0,
    0x5, 0x55, 0xc9, 0x53, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x90, 0xb6, 0x0, 0xef, 0xff, 0xfd, 0x0,
    0x1, 0xf0, 0xb7, 0x20, 0xf3, 0x11, 0x4e, 0x0,
    0x2, 0xe0, 0xbf, 0xf5, 0xf2, 0x0, 0x3e, 0x0,
    0x5, 0xf2, 0xb6, 0x10, 0xf3, 0x11, 0x4e, 0x0,
    0x8, 0xfb, 0xb6, 0x0, 0xef, 0xff, 0xfd, 0x0,
    0xd, 0x5c, 0xf9, 0x32, 0x11, 0x11, 0x11, 0x20,
    0x4e, 0x0, 0x7c, 0xef, 0xff, 0xff, 0xff, 0xf1,
    0x13, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,

    /* U+8DB3 "足" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x3f, 0x22, 0x22, 0x22, 0x25, 0xf0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x3, 0x33, 0x36, 0xf3, 0x33, 0x30, 0x0,
    0x0, 0x8, 0x40, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0x50, 0x4, 0xe3, 0x33, 0x33, 0x0,
    0x0, 0xf, 0x20, 0x4, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x5f, 0x70, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xcb, 0xf4, 0x4, 0xe0, 0x0, 0x0, 0x0,
    0x6, 0xe1, 0x7f, 0xa8, 0xe2, 0x11, 0x12, 0x20,
    0x3f, 0x50, 0x3, 0x9d, 0xff, 0xff, 0xff, 0xf3,
    0x5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8DEF "路" */
    0x0, 0x0, 0x0, 0x0, 0x13, 0x0, 0x0, 0x0,
    0x35, 0x55, 0x50, 0x9, 0x90, 0x0, 0x0, 0xa,
    0xdc, 0xcf, 0x1, 0xfd, 0xcc, 0xc8, 0x0, 0xa6,
    0x0, 0xf0, 0xaa, 0x44, 0x4e, 0x80, 0xa, 0x60,
    0xf, 0x6f, 0xe1, 0x8, 0xe1, 0x0, 0xa8, 0x33,
    0xf8, 0x3b, 0xd7, 0xf5, 0x0, 0x9, 0xde, 0xfd,
    0x0, 0x1d, 0xf8, 0x0, 0x0, 0x0, 0x4c, 0x0,
    0x19, 0xfb, 0xd6, 0x0, 0xd, 0x14, 0xc0, 0x8f,
    0xb2, 0x3, 0xbf, 0x90, 0xe2, 0x4f, 0xc9, 0x52,
    0x22, 0x22, 0x24, 0xe, 0x24, 0xd4, 0x2e, 0xee,
    0xee, 0xf1, 0x0, 0xe2, 0x4c, 0x0, 0xe2, 0x0,
    0xf, 0x10, 0xe, 0x24, 0xd4, 0x3e, 0x20, 0x0,
    0xf1, 0x9, 0xff, 0xfd, 0xb5, 0xec, 0xcc, 0xcf,
    0x10, 0x43, 0x10, 0x0, 0xe, 0x54, 0x44, 0xf1,
    0x0,

    /* U+8F09 "載" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x2, 0xe0, 0x0, 0x6a, 0x36, 0x0, 0x4,
    0xcc, 0xcf, 0xcc, 0xa5, 0xb1, 0xd8, 0x0, 0x2,
    0x24, 0xe2, 0x22, 0x5b, 0x1, 0xa0, 0x2, 0x22,
    0x4e, 0x22, 0x26, 0xc2, 0x22, 0x21, 0xcc, 0xcd,
    0xfc, 0xcc, 0xcf, 0xcc, 0xc9, 0x6, 0xee, 0xef,
    0xee, 0xe4, 0xe0, 0x1d, 0x0, 0x13, 0x34, 0xd3,
    0x33, 0x1f, 0x5, 0xb0, 0x0, 0xcc, 0xcf, 0xcc,
    0x90, 0xf0, 0xa6, 0x0, 0xe, 0x2, 0xd0, 0x3b,
    0xd, 0x4e, 0x10, 0x0, 0xfc, 0xcf, 0xcc, 0xb0,
    0xac, 0x90, 0x0, 0xe, 0x78, 0xe7, 0x9b, 0x7,
    0xf1, 0x11, 0x0, 0x33, 0x5e, 0x33, 0x20, 0xbe,
    0x6, 0xa4, 0xee, 0xee, 0xfe, 0xee, 0xba, 0xd9,
    0xc7, 0x0, 0x0, 0x2d, 0x0, 0x79, 0x3, 0xed,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8F7D "载" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xa0, 0x0, 0xe4, 0x20, 0x0, 0x0,
    0x22, 0x8b, 0x22, 0x1d, 0x4c, 0xa0, 0x0, 0x4d,
    0xde, 0xfd, 0xd6, 0xd5, 0x1d, 0x90, 0x0, 0x0,
    0x7b, 0x0, 0xc, 0x60, 0x15, 0x2, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x1, 0x13, 0xb1,
    0x11, 0x1b, 0x91, 0x24, 0x10, 0x9c, 0xef, 0xcc,
    0xc8, 0x8a, 0x6, 0xc0, 0x3, 0x7f, 0x5b, 0x44,
    0x26, 0xc0, 0xd5, 0x0, 0xc, 0x81, 0xf0, 0x0,
    0x4f, 0x6e, 0x0, 0x1, 0xff, 0xff, 0xff, 0x80,
    0xff, 0x50, 0x0, 0x1, 0x12, 0xf1, 0x10, 0xe,
    0xb0, 0x31, 0x13, 0x45, 0x7f, 0xac, 0x9b, 0xfc,
    0x9, 0x85, 0xdc, 0xba, 0xf7, 0x9f, 0xe6, 0xf8,
    0xe5, 0x0, 0x0, 0x1f, 0x1, 0x80, 0x6, 0xfc,
    0x0,

    /* U+8FBC "込" */
    0x0, 0x0, 0x0, 0x7, 0x50, 0x0, 0x0, 0x0,
    0x5, 0xb0, 0x0, 0x8, 0xdd, 0x0, 0x0, 0x0,
    0x0, 0xd7, 0x0, 0x0, 0xc, 0x60, 0x0, 0x0,
    0x0, 0x4f, 0x0, 0x0, 0x9, 0xa0, 0x0, 0x0,
    0x0, 0x2, 0x0, 0x0, 0xe, 0xe0, 0x0, 0x0,
    0x4, 0x44, 0x0, 0x0, 0x5d, 0xf2, 0x0, 0x0,
    0xb, 0xde, 0x0, 0x0, 0xd6, 0x99, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x7, 0xd0, 0x2f, 0x20, 0x0,
    0x0, 0x3e, 0x0, 0x3f, 0x40, 0x8, 0xd0, 0x0,
    0x0, 0x3e, 0x2, 0xe8, 0x0, 0x0, 0xdb, 0x0,
    0x0, 0x3e, 0xd, 0xb0, 0x0, 0x0, 0x2e, 0xa0,
    0x0, 0xaf, 0x42, 0x0, 0x0, 0x0, 0x2, 0x50,
    0xa, 0xd5, 0xfb, 0x63, 0x22, 0x12, 0x23, 0x30,
    0x3d, 0x10, 0x18, 0xce, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+8FDB "进" */
    0x0, 0x50, 0x0, 0xc, 0x30, 0xc, 0x20, 0x0,
    0x3f, 0x40, 0x0, 0xf4, 0x0, 0xe3, 0x0, 0x0,
    0x7e, 0x13, 0x4f, 0x74, 0x4f, 0x64, 0x0, 0x0,
    0xc4, 0xbd, 0xfe, 0xdd, 0xfe, 0xd2, 0x0, 0x0,
    0x0, 0xf, 0x40, 0xe, 0x30, 0x0, 0x89, 0x80,
    0x0, 0xf4, 0x0, 0xe3, 0x0, 0x8, 0xaf, 0x0,
    0xf, 0x40, 0xe, 0x30, 0x0, 0x3, 0xf3, 0xff,
    0xff, 0xff, 0xff, 0xfa, 0x0, 0x3f, 0x2, 0x3f,
    0x52, 0x2e, 0x52, 0x10, 0x3, 0xf0, 0x5, 0xf0,
    0x0, 0xe3, 0x0, 0x0, 0x3f, 0x0, 0xd9, 0x0,
    0xe, 0x30, 0x0, 0xc, 0xf7, 0x7d, 0x0, 0x0,
    0xe3, 0x0, 0xb, 0xc3, 0xec, 0x83, 0x22, 0x24,
    0x22, 0x22, 0xd1, 0x0, 0x7c, 0xef, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+8FDE "连" */
    0x0, 0x40, 0x0, 0x0, 0xb5, 0x0, 0x0, 0x0,
    0x2, 0xf4, 0x1, 0x13, 0xf2, 0x11, 0x11, 0x0,
    0x0, 0x6e, 0x1e, 0xff, 0xff, 0xff, 0xff, 0x40,
    0x0, 0xc, 0x70, 0x1f, 0x31, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x0, 0x8c, 0xb, 0x70, 0x0, 0x0,
    0x6, 0x88, 0x1, 0xf4, 0xb, 0x70, 0x0, 0x0,
    0x8, 0xbf, 0x4, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x2f, 0x0, 0x11, 0x1b, 0x81, 0x11, 0x0,
    0x0, 0x2f, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0,
    0x0, 0x2f, 0x4c, 0xcc, 0xcf, 0xec, 0xcc, 0x90,
    0x0, 0x2f, 0x15, 0x55, 0x5c, 0xa5, 0x55, 0x30,
    0x0, 0x9f, 0x50, 0x0, 0xb, 0x70, 0x0, 0x0,
    0xa, 0xe6, 0xfb, 0x73, 0x26, 0x42, 0x22, 0x30,
    0x2d, 0x20, 0x17, 0xbe, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+9001 "送" */
    0x1, 0x20, 0x0, 0x46, 0x0, 0x4, 0x80, 0x0,
    0x7d, 0x10, 0x2, 0xf4, 0x0, 0xd7, 0x0, 0x0,
    0xbb, 0x0, 0x18, 0x61, 0x8d, 0x11, 0x0, 0x1,
    0xd3, 0x3f, 0xff, 0xff, 0xff, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x89, 0x80,
    0x0, 0x2, 0xf2, 0x0, 0x0, 0x7, 0x9e, 0xd,
    0xee, 0xef, 0xee, 0xee, 0x50, 0x3, 0xe0, 0x22,
    0x26, 0xf3, 0x22, 0x21, 0x0, 0x3e, 0x0, 0x0,
    0xaf, 0xb1, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x8f,
    0x4a, 0xe3, 0x0, 0x0, 0x3e, 0x5, 0xde, 0x30,
    0x8, 0xf5, 0x0, 0xc, 0xf6, 0xb8, 0x10, 0x0,
    0x6, 0xb0, 0xb, 0xc5, 0xec, 0x63, 0x22, 0x22,
    0x23, 0x33, 0xc1, 0x1, 0x8c, 0xef, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+9023 "連" */
    0x1, 0x50, 0x0, 0x0, 0xd, 0x30, 0x0, 0x0,
    0x3, 0xf3, 0x5, 0x66, 0x6e, 0x86, 0x66, 0x20,
    0x0, 0x7d, 0x8, 0x99, 0x9f, 0xa9, 0x99, 0x30,
    0x0, 0xd, 0x40, 0x33, 0x3e, 0x53, 0x31, 0x0,
    0x0, 0x1, 0x3, 0xfa, 0xaf, 0xba, 0xd8, 0x0,
    0x1a, 0xa9, 0x3, 0xe2, 0x2e, 0x52, 0x98, 0x0,
    0x7, 0x9f, 0x3, 0xfa, 0xaf, 0xba, 0xd8, 0x0,
    0x0, 0x3f, 0x3, 0xe2, 0x2e, 0x52, 0x98, 0x0,
    0x0, 0x3f, 0x2, 0xbb, 0xbf, 0xcb, 0xb6, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0xd, 0x30, 0x0, 0x0,
    0x0, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0xbf, 0x50, 0x0, 0xd, 0x30, 0x0, 0x0,
    0xa, 0xc5, 0xeb, 0x63, 0x2a, 0x32, 0x22, 0x30,
    0x2d, 0x10, 0x18, 0xce, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+9054 "達" */
    0x0, 0x10, 0x0, 0x0, 0x9, 0x10, 0x0, 0x0,
    0x5, 0xd1, 0x8, 0xcc, 0xcf, 0xcc, 0xcb, 0x0,
    0x0, 0x8d, 0x1, 0x22, 0x2e, 0x52, 0x22, 0x0,
    0x0, 0xb, 0x33, 0x33, 0x3e, 0x53, 0x33, 0x20,
    0x0, 0x0, 0x3b, 0xbf, 0xcb, 0xbf, 0xcb, 0x90,
    0x7, 0x87, 0x0, 0xb, 0x50, 0x1e, 0x0, 0x0,
    0x6, 0x8e, 0xe, 0xef, 0xfe, 0xef, 0xee, 0x30,
    0x0, 0x3e, 0x0, 0x0, 0xe, 0x20, 0x0, 0x0,
    0x0, 0x3e, 0x7, 0xee, 0xef, 0xee, 0xeb, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0xe, 0x20, 0x0, 0x0,
    0x0, 0x3e, 0x4e, 0xee, 0xef, 0xee, 0xee, 0xa0,
    0x0, 0xcf, 0x60, 0x0, 0xe, 0x20, 0x0, 0x0,
    0xb, 0xc5, 0xec, 0x63, 0x27, 0x21, 0x11, 0x20,
    0x3d, 0x10, 0x18, 0xce, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+914D "配" */
    0x2f, 0xff, 0xff, 0xff, 0x6f, 0xff, 0xff, 0x0,
    0x0, 0xb4, 0xe1, 0x0, 0x33, 0x35, 0xf0, 0x0,
    0xb, 0x3e, 0x10, 0x0, 0x0, 0x3f, 0x0, 0x9f,
    0xff, 0xff, 0xf0, 0x0, 0x3, 0xf0, 0x9, 0x8b,
    0x4e, 0x4f, 0x2, 0x22, 0x4f, 0x0, 0x98, 0xc2,
    0xe3, 0xf1, 0xff, 0xff, 0xf0, 0x9, 0x9e, 0xe,
    0x6f, 0x1f, 0x0, 0x0, 0x0, 0x9f, 0x80, 0x7d,
    0xf1, 0xf0, 0x0, 0x0, 0x9, 0x90, 0x0, 0x2f,
    0x1f, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xf1,
    0xf0, 0x0, 0x47, 0x9, 0x80, 0x0, 0x2f, 0x1f,
    0x0, 0x7, 0xb0, 0x98, 0x11, 0x13, 0xf1, 0xf5,
    0x12, 0xb9, 0x9, 0xff, 0xff, 0xff, 0xa, 0xff,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+91CD "重" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x23, 0x42, 0x0,
    0x0, 0xce, 0xef, 0xff, 0xfe, 0xed, 0xc6, 0x0,
    0x0, 0x22, 0x21, 0xb, 0x70, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x5e, 0xee, 0xef, 0xfe, 0xee, 0xe2, 0x0,
    0x0, 0x6c, 0x0, 0xb, 0x70, 0x0, 0xf2, 0x0,
    0x0, 0x6f, 0xee, 0xef, 0xfe, 0xee, 0xf2, 0x0,
    0x0, 0x6c, 0x0, 0xb, 0x70, 0x0, 0xf2, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xa0,

    /* U+91CF "量" */
    0x0, 0x25, 0x55, 0x55, 0x55, 0x55, 0x50, 0x0,
    0x7, 0xd7, 0x77, 0x77, 0x77, 0x8f, 0x10, 0x0,
    0x7e, 0xbb, 0xbb, 0xbb, 0xbb, 0xf1, 0x0, 0x7,
    0xd6, 0x66, 0x66, 0x66, 0x7f, 0x10, 0x0, 0x26,
    0x66, 0x66, 0x66, 0x66, 0x60, 0x3, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xdd, 0xdc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xec, 0xcc,
    0xfd, 0xcc, 0xcf, 0x10, 0x0, 0x7d, 0x77, 0x7d,
    0xb7, 0x78, 0xf1, 0x0, 0x7, 0xc4, 0x44, 0xc8,
    0x44, 0x4f, 0x10, 0x0, 0x5c, 0xcc, 0xcf, 0xec,
    0xcc, 0xc1, 0x0, 0x2, 0x22, 0x22, 0xc8, 0x22,
    0x22, 0x10, 0x0, 0x9a, 0xaa, 0xae, 0xca, 0xaa,
    0xa5, 0x0, 0xcd, 0xdd, 0xdd, 0xfe, 0xdd, 0xdd,
    0xd8,

    /* U+932F "錯" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0x90, 0x0, 0xb4, 0x2, 0xd0, 0x0,
    0x0, 0x3f, 0xf4, 0x0, 0xc5, 0x2, 0xe0, 0x0,
    0x0, 0xc7, 0x4e, 0x4f, 0xff, 0xff, 0xff, 0x80,
    0x8, 0xc0, 0x4, 0x90, 0xc5, 0x13, 0xe1, 0x0,
    0x5e, 0xed, 0xdd, 0x30, 0xc5, 0x2, 0xe0, 0x0,
    0x2, 0x2a, 0x82, 0x7f, 0xff, 0xff, 0xff, 0xf2,
    0x2, 0x2a, 0x82, 0x21, 0x11, 0x11, 0x11, 0x10,
    0xf, 0xff, 0xff, 0xa0, 0x11, 0x11, 0x10, 0x0,
    0x3, 0x1a, 0x82, 0x28, 0xfe, 0xee, 0xec, 0x0,
    0xa, 0x49, 0x77, 0x88, 0x70, 0x0, 0x4c, 0x0,
    0x4, 0xa9, 0x7d, 0x28, 0xfe, 0xee, 0xfc, 0x0,
    0x0, 0x69, 0x85, 0x8, 0x70, 0x0, 0x4c, 0x0,
    0x1, 0x3b, 0xcc, 0xe8, 0x70, 0x0, 0x4c, 0x0,
    0x6d, 0xb9, 0x75, 0x38, 0xfe, 0xee, 0xec, 0x0,

    /* U+9519 "错" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xa0, 0x0, 0x2b, 0x0, 0xb3, 0x0, 0x0,
    0xe4, 0x0, 0x3, 0xe0, 0xd, 0x40, 0x0, 0x5f,
    0xff, 0xac, 0xff, 0xff, 0xff, 0xf5, 0xd, 0x42,
    0x21, 0x2, 0xe0, 0xd, 0x40, 0x6, 0xa1, 0x11,
    0x0, 0x2e, 0x0, 0xd4, 0x0, 0xa, 0xff, 0xf7,
    0xff, 0xff, 0xff, 0xff, 0xb0, 0x7, 0xa0, 0x1,
    0x11, 0x11, 0x11, 0x11, 0x0, 0x7a, 0x0, 0x2,
    0x22, 0x22, 0x21, 0x0, 0xac, 0xda, 0x75, 0xfe,
    0xee, 0xef, 0x60, 0x5, 0xac, 0x54, 0x5c, 0x0,
    0x0, 0xb6, 0x0, 0x7, 0xa0, 0x5, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x7a, 0x25, 0x5c, 0x11, 0x11,
    0xc6, 0x0, 0x7, 0xde, 0x85, 0xd1, 0x11, 0x1c,
    0x60, 0x0, 0x99, 0x20, 0x5f, 0xff, 0xff, 0xf6,
    0x0,

    /* U+9589 "閉" */
    0x3f, 0xee, 0xef, 0x32, 0xfe, 0xee, 0xf0, 0x3e,
    0x0, 0xe, 0x32, 0xe0, 0x1, 0xf0, 0x3f, 0xdd,
    0xdf, 0x32, 0xfd, 0xdd, 0xf0, 0x3e, 0x0, 0xe,
    0x32, 0xe0, 0x1, 0xf0, 0x3f, 0xee, 0xee, 0x22,
    0xee, 0xee, 0xf0, 0x3e, 0x0, 0x0, 0x0, 0xb0,
    0x1, 0xf0, 0x3e, 0x1c, 0xcc, 0xcc, 0xfc, 0xc1,
    0xf0, 0x3e, 0x3, 0x33, 0xcc, 0xf4, 0x31, 0xf0,
    0x3e, 0x0, 0x9, 0xd1, 0xf1, 0x1, 0xf0, 0x3e,
    0x1, 0xbc, 0x10, 0xf1, 0x1, 0xf0, 0x3e, 0x7f,
    0x80, 0x0, 0xf0, 0x1, 0xf0, 0x3e, 0x42, 0x3,
    0xce, 0xc0, 0x37, 0xf0, 0x3e, 0x0, 0x0, 0x42,
    0x0, 0xec, 0x60,

    /* U+958B "開" */
    0x3f, 0xff, 0xff, 0x17, 0xff, 0xff, 0xf3, 0xe0,
    0x1, 0xf1, 0x7a, 0x0, 0x2f, 0x3f, 0xee, 0xef,
    0x17, 0xfe, 0xee, 0xf3, 0xe0, 0x1, 0xf1, 0x7a,
    0x0, 0x2f, 0x3f, 0xee, 0xee, 0x17, 0xee, 0xee,
    0xf3, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x3e,
    0xd, 0xff, 0xee, 0xfe, 0x62, 0xf3, 0xe0, 0x5,
    0xc0, 0x2f, 0x0, 0x2f, 0x3e, 0x4b, 0xce, 0xbc,
    0xfb, 0xb3, 0xf3, 0xe1, 0x39, 0xb3, 0x5f, 0x33,
    0x2f, 0x3e, 0x0, 0xb6, 0x2, 0xf0, 0x2, 0xf3,
    0xe0, 0x5c, 0x0, 0x2f, 0x0, 0x3e, 0x3e, 0x1b,
    0x10, 0x2, 0xe1, 0x8a, 0x50,

    /* U+9593 "間" */
    0x3f, 0xff, 0xff, 0x42, 0xff, 0xff, 0xf0, 0x3e,
    0x0, 0xe, 0x42, 0xe0, 0x1, 0xf0, 0x3f, 0xee,
    0xef, 0x42, 0xfe, 0xee, 0xf0, 0x3e, 0x0, 0xe,
    0x42, 0xe0, 0x1, 0xf0, 0x3f, 0xee, 0xee, 0x42,
    0xee, 0xee, 0xf0, 0x3e, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf0, 0x3e, 0x1, 0xfe, 0xee, 0xef, 0x1,
    0xf0, 0x3e, 0x1, 0xf0, 0x0, 0xf, 0x1, 0xf0,
    0x3e, 0x1, 0xff, 0xff, 0xff, 0x1, 0xf0, 0x3e,
    0x1, 0xf1, 0x0, 0xf, 0x1, 0xf0, 0x3e, 0x1,
    0xfb, 0xbb, 0xbf, 0x1, 0xf0, 0x3e, 0x0, 0x44,
    0x44, 0x44, 0x27, 0xf0, 0x3e, 0x0, 0x0, 0x0,
    0x1, 0xec, 0x50,

    /* U+95DC "關" */
    0x2f, 0xdd, 0xdf, 0x21, 0xfd, 0xdd, 0xf0, 0x2f,
    0x66, 0x6f, 0x21, 0xf6, 0x66, 0xf0, 0x2f, 0x44,
    0x4f, 0x21, 0xf4, 0x44, 0xf0, 0x2f, 0xcc, 0xec,
    0x10, 0xdd, 0xcc, 0xf0, 0x2e, 0x5, 0xc2, 0x73,
    0xc3, 0x60, 0xf0, 0x2e, 0x4f, 0xcd, 0x7f, 0xdd,
    0x70, 0xf0, 0x2e, 0x3, 0xc8, 0x41, 0xb7, 0x70,
    0xf0, 0x2e, 0x2f, 0xcd, 0xee, 0xdb, 0xe2, 0xf0,
    0x2e, 0x3, 0x6, 0x73, 0x70, 0x51, 0xf0, 0x2e,
    0xe, 0x1a, 0x54, 0xb1, 0xe0, 0xf0, 0x2e, 0xd,
    0xdf, 0x44, 0xfd, 0xd0, 0xf0, 0x2e, 0x0, 0x2c,
    0x4, 0xb0, 0x1, 0xf0, 0x2e, 0x9, 0x91, 0x4,
    0xb0, 0xbd, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+95ED "闭" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x2f,
    0xff, 0xff, 0xff, 0xe1, 0x64, 0xe2, 0x33, 0x5b,
    0x33, 0x7f, 0x3f, 0x1, 0x0, 0x3, 0xf0, 0x4,
    0xf3, 0xf0, 0x0, 0x0, 0x3f, 0x0, 0x4f, 0x3f,
    0x5f, 0xff, 0xff, 0xff, 0xf7, 0xf3, 0xf0, 0x11,
    0x15, 0xff, 0x11, 0x4f, 0x3f, 0x0, 0x1, 0xe8,
    0xf0, 0x4, 0xf3, 0xf0, 0x1, 0xd9, 0x3f, 0x0,
    0x4f, 0x3f, 0x3, 0xeb, 0x3, 0xf0, 0x4, 0xf3,
    0xf6, 0xfa, 0x0, 0x3f, 0x0, 0x4f, 0x3f, 0x25,
    0x0, 0x5, 0xf0, 0x4, 0xf3, 0xf0, 0x0, 0x5e,
    0xfb, 0x0, 0x7e, 0x3f, 0x0, 0x1, 0x43, 0x5,
    0xfe, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+95EE "问" */
    0xb, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x44, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x6e, 0x14,
    0x44, 0x44, 0x47, 0xf4, 0xf0, 0x10, 0x0, 0x0,
    0x0, 0x4f, 0x4f, 0x0, 0x22, 0x22, 0x21, 0x4,
    0xf4, 0xf0, 0xf, 0xff, 0xff, 0xd0, 0x4f, 0x4f,
    0x0, 0xf2, 0x0, 0x4d, 0x4, 0xf4, 0xf0, 0xf,
    0x20, 0x4, 0xd0, 0x4f, 0x4f, 0x0, 0xf2, 0x0,
    0x4d, 0x4, 0xf4, 0xf0, 0xf, 0x41, 0x15, 0xd0,
    0x4f, 0x4f, 0x0, 0xff, 0xff, 0xfd, 0x4, 0xf4,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x4f, 0x0,
    0x0, 0x0, 0x0, 0x29, 0xd4, 0xf0, 0x0, 0x0,
    0x0, 0x7f, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+96FB "電" */
    0xa, 0xee, 0xee, 0xef, 0xee, 0xee, 0xc0, 0x0,
    0x33, 0x33, 0x36, 0xe3, 0x33, 0x33, 0x10, 0x4e,
    0xaa, 0xaa, 0xbf, 0xaa, 0xaa, 0xe5, 0x4, 0xd3,
    0xcc, 0xc3, 0xe5, 0xcc, 0x5b, 0x50, 0x39, 0x28,
    0x88, 0x3e, 0x38, 0x83, 0x63, 0x0, 0x1, 0x55,
    0x52, 0xa2, 0x55, 0x20, 0x0, 0x1, 0xed, 0xdd,
    0xde, 0xdd, 0xde, 0x20, 0x0, 0x1f, 0x10, 0x4,
    0xd0, 0x0, 0xe3, 0x0, 0x1, 0xfd, 0xdd, 0xef,
    0xdd, 0xdf, 0x30, 0x0, 0x1f, 0x10, 0x4, 0xd0,
    0x0, 0xe3, 0x0, 0x1, 0xdd, 0xdd, 0xef, 0xdd,
    0xdd, 0x4e, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x6, 0xd0, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff,
    0xd4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+9759 "静" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb3, 0x0, 0x1, 0xe3, 0x0, 0x0, 0x2a,
    0xae, 0xca, 0x70, 0xaf, 0xcc, 0xb0, 0x0, 0x33,
    0xd6, 0x32, 0x6d, 0x22, 0xc9, 0x0, 0xa, 0xcf,
    0xdc, 0x6e, 0x20, 0x3d, 0x0, 0x0, 0x22, 0xd5,
    0x20, 0x8e, 0xef, 0xfe, 0x40, 0x7b, 0xbf, 0xcb,
    0xb1, 0x2, 0xe0, 0xb4, 0x1, 0x33, 0x33, 0x33,
    0x0, 0x2e, 0xb, 0x40, 0x9, 0xdd, 0xdd, 0x6f,
    0xff, 0xff, 0xff, 0x70, 0xb4, 0x0, 0xe0, 0x0,
    0x2e, 0xb, 0x40, 0xb, 0xed, 0xdf, 0x12, 0x24,
    0xe2, 0xc4, 0x0, 0xb4, 0x0, 0xe3, 0xdd, 0xef,
    0xdd, 0x40, 0xb, 0xed, 0xdf, 0x0, 0x2, 0xe0,
    0x0, 0x0, 0xb4, 0x0, 0xe0, 0x0, 0x3e, 0x0,
    0x0, 0xb, 0x42, 0xd9, 0x1, 0xed, 0x70, 0x0,
    0x0,

    /* U+975C "靜" */
    0x0, 0x9, 0x40, 0x1, 0x12, 0x34, 0x68, 0x12,
    0xbb, 0xed, 0xba, 0xbd, 0xcb, 0xa8, 0x81, 0x3,
    0x3b, 0x73, 0x25, 0x31, 0xb0, 0x5b, 0x0, 0x8a,
    0xeb, 0xa5, 0x5b, 0xc, 0x2c, 0x40, 0x6, 0x7d,
    0x97, 0x30, 0x41, 0x21, 0x81, 0x4, 0x77, 0xd9,
    0x77, 0x5f, 0xff, 0xff, 0xd0, 0x35, 0x55, 0x55,
    0x50, 0x1, 0xe0, 0x1d, 0x0, 0x8e, 0xee, 0xe3,
    0xdd, 0xdf, 0xdd, 0xfb, 0x9, 0x60, 0xb, 0x33,
    0x34, 0xe3, 0x4e, 0x20, 0x9f, 0xff, 0xf3, 0x1,
    0x2e, 0x12, 0xd0, 0x9, 0x60, 0xb, 0x38, 0xff,
    0xff, 0xfd, 0x0, 0x9e, 0xdd, 0xf3, 0x0, 0x1e,
    0x0, 0x0, 0x9, 0x60, 0xc, 0x30, 0x2, 0xd0,
    0x0, 0x0, 0x96, 0xc, 0xb0, 0x8, 0xe7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+97F3 "音" */
    0x0, 0x0, 0x0, 0xb, 0x40, 0x0, 0x0, 0x0,
    0x2, 0x22, 0x22, 0xba, 0x22, 0x22, 0x20, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x3, 0xe0, 0x0, 0xe, 0x30, 0x0, 0x0, 0x0,
    0xf, 0x20, 0x2, 0xf0, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfd, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x10, 0x0, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x0, 0x1, 0xf1, 0x0, 0x0,
    0x0, 0x4f, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x1, 0xf2, 0x11, 0x11, 0x11,
    0x5f, 0x0, 0x0, 0x1f, 0x31, 0x11, 0x11, 0x15,
    0xf0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0,

    /* U+97FF "響" */
    0x0, 0x9, 0x10, 0x9, 0x40, 0x0, 0x0, 0x0,
    0x9, 0x83, 0x3c, 0xcc, 0xb4, 0xfd, 0xf5, 0xa,
    0xf9, 0xd3, 0xf8, 0x8e, 0x4a, 0x1d, 0x0, 0x15,
    0xd6, 0x8f, 0x89, 0xe4, 0xa5, 0xb0, 0x7, 0xfc,
    0xd6, 0xe1, 0x66, 0x4a, 0x9, 0x50, 0x55, 0x7e,
    0x1e, 0xae, 0xe6, 0xa5, 0xc7, 0x0, 0x7e, 0x32,
    0x98, 0x33, 0x6a, 0x55, 0x0, 0xbd, 0x98, 0x88,
    0xcc, 0x88, 0xa8, 0x20, 0x0, 0x13, 0x4f, 0x53,
    0x38, 0xc3, 0x31, 0x0, 0xcc, 0xcc, 0xed, 0xcc,
    0xdd, 0xcc, 0xca, 0x0, 0x7, 0x77, 0x77, 0x77,
    0x77, 0x60, 0x0, 0x1, 0xf5, 0x44, 0x44, 0x44,
    0x8d, 0x0, 0x0, 0x1f, 0xbb, 0xbb, 0xbb, 0xbc,
    0xd0, 0x0, 0x1, 0xfc, 0xcc, 0xcc, 0xcc, 0xdd,
    0x0,

    /* U+AC00 "가" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe4, 0x0, 0x23,
    0x33, 0x33, 0x30, 0x1, 0xf5, 0x0, 0x8f, 0xff,
    0xff, 0xf3, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x3,
    0xf2, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x5, 0xf1,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x1,
    0xf9, 0x64, 0x0, 0x0, 0x2f, 0x70, 0x1, 0xfe,
    0xdb, 0x0, 0x0, 0xce, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x1c, 0xf3, 0x0, 0x1, 0xf5, 0x0, 0x6,
    0xed, 0x20, 0x0, 0x1, 0xf5, 0x0, 0x7f, 0x80,
    0x0, 0x0, 0x1, 0xf5, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf5, 0x0,

    /* U+AC04 "간" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa3, 0x0, 0x7c,
    0xcc, 0xcc, 0xc3, 0x1, 0xf5, 0x0, 0x35, 0x55,
    0x56, 0xf4, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x5,
    0xf1, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x1d, 0xb0,
    0x1, 0xfb, 0x96, 0x0, 0x3, 0xdd, 0x10, 0x1,
    0xfb, 0x86, 0x5, 0xbf, 0x90, 0x0, 0x1, 0xf5,
    0x0, 0x8e, 0x92, 0x0, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x2e, 0x30, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x2f,
    0x40, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x63, 0x33,
    0x33, 0x33, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff,
    0xfd, 0x0,

    /* U+AC10 "감" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd4, 0x0, 0x8f,
    0xff, 0xff, 0xf4, 0x1, 0xf5, 0x0, 0x24, 0x44,
    0x46, 0xf4, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x5,
    0xf1, 0x1, 0xf8, 0x43, 0x0, 0x0, 0x2e, 0xb0,
    0x1, 0xff, 0xfa, 0x0, 0x7, 0xfd, 0x10, 0x1,
    0xf5, 0x0, 0x39, 0xef, 0x80, 0x0, 0x1, 0xf5,
    0x0, 0x7c, 0x71, 0x0, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x51, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x2f,
    0x74, 0x44, 0x45, 0xf5, 0x0, 0x0, 0x2f, 0x40,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x2f, 0x40, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x2f, 0x74, 0x44, 0x45,
    0xf5, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xf5,
    0x0,

    /* U+AC70 "거" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0x13, 0x33,
    0x33, 0x31, 0x0, 0x6f, 0x5f, 0xff, 0xff, 0xf4,
    0x0, 0x6f, 0x0, 0x0, 0x2, 0xf4, 0x0, 0x6f,
    0x0, 0x0, 0x4, 0xf2, 0x0, 0x6f, 0x0, 0x0,
    0x8, 0xff, 0xff, 0xff, 0x0, 0x0, 0x1e, 0x94,
    0x44, 0x9f, 0x0, 0x0, 0xbe, 0x0, 0x0, 0x6f,
    0x0, 0x1b, 0xf3, 0x0, 0x0, 0x6f, 0x6, 0xed,
    0x20, 0x0, 0x0, 0x6f, 0x3e, 0x70, 0x0, 0x0,
    0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f,

    /* U+ACAC "견" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0x4, 0xcc,
    0xcc, 0xcc, 0x30, 0x6, 0xf0, 0x25, 0x55, 0x57,
    0xf5, 0x66, 0x9f, 0x0, 0x0, 0x0, 0x5f, 0x5c,
    0xcd, 0xf0, 0x0, 0x0, 0xd, 0xb0, 0x0, 0x6f,
    0x0, 0x0, 0x3c, 0xd1, 0x25, 0x59, 0xf0, 0x4,
    0xaf, 0xa1, 0x6, 0xcc, 0xdf, 0x4, 0xfa, 0x30,
    0x0, 0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x6,
    0xf0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf3, 0x33, 0x33, 0x33, 0x10, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xf8,

    /* U+ACB0 "결" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x26, 0x3, 0x88,
    0x88, 0x88, 0x10, 0x7, 0xf0, 0x4b, 0xbb, 0xbc,
    0xf4, 0x44, 0x9f, 0x0, 0x0, 0x0, 0x5f, 0x6f,
    0xff, 0xf0, 0x0, 0x0, 0x3e, 0xa0, 0x0, 0x7f,
    0x0, 0x4, 0xaf, 0x90, 0x7d, 0xde, 0xf0, 0x3f,
    0xfa, 0x30, 0x3, 0x55, 0xaf, 0x0, 0x40, 0x0,
    0x0, 0x0, 0x2, 0x50, 0x0, 0x8, 0xff, 0xff,
    0xff, 0xfe, 0x0, 0x0, 0x24, 0x44, 0x44, 0x49,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x7,
    0xe3, 0x33, 0x33, 0x32, 0x0, 0x0, 0x7e, 0x22,
    0x22, 0x22, 0x21, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xb0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10,

    /* U+ACBD "경" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x48, 0x3, 0x88,
    0x88, 0x88, 0x10, 0x7, 0xf0, 0x4a, 0xaa, 0xab,
    0xf4, 0x44, 0x9f, 0x0, 0x0, 0x0, 0x4f, 0x6f,
    0xff, 0xf0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x7f,
    0x0, 0x0, 0x9, 0xf4, 0x24, 0x49, 0xf0, 0x0,
    0x5d, 0xf5, 0x8, 0xff, 0xff, 0x4, 0xff, 0x91,
    0x0, 0x0, 0x7, 0xf0, 0x16, 0x10, 0x0, 0x0,
    0x0, 0x4a, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xd7,
    0x0, 0x0, 0x0, 0xdd, 0x63, 0x37, 0xf9, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x7, 0xf0, 0x0, 0x4,
    0xf2, 0x0, 0x0, 0x6f, 0x0, 0x0, 0xe, 0xc3,
    0x11, 0x5e, 0xb0, 0x0, 0x0, 0x2b, 0xff, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,

    /* U+ACE0 "고" */
    0x0, 0x14, 0x44, 0x44, 0x44, 0x44, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x0, 0x0,
    0x5b, 0x0, 0xc, 0xa0, 0x0, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x2f, 0x30, 0x0, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x33, 0x33, 0x33, 0x33, 0x33,
    0x33, 0x30,

    /* U+ACF5 "공" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x33, 0x33, 0x33, 0x39, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x70, 0x9, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0xe8, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x80, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x20, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x40, 0x0, 0x0, 0x0, 0x23,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x1b, 0xff, 0xff,
    0xfb, 0x20, 0x0, 0x0, 0xd, 0xd4, 0x10, 0x14,
    0xdd, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0x5,
    0xf1, 0x0, 0x0, 0xd, 0xc3, 0x0, 0x2, 0xcd,
    0x0, 0x0, 0x0, 0x2c, 0xff, 0xff, 0xfc, 0x20,
    0x0, 0x0, 0x0, 0x1, 0x34, 0x31, 0x0, 0x0,
    0x0,

    /* U+ACFC "과" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x60, 0x0,
    0x15, 0x55, 0x55, 0x54, 0x0, 0xe7, 0x0, 0x3,
    0xee, 0xee, 0xef, 0xd0, 0xe, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x9c, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xb0, 0xe, 0x70, 0x0, 0x0, 0x2,
    0x0, 0xba, 0x0, 0xea, 0x43, 0x0, 0x4, 0xf1,
    0xd, 0x80, 0xe, 0xff, 0xc0, 0x0, 0x4f, 0x10,
    0xf5, 0x0, 0xe7, 0x0, 0x0, 0x4, 0xf1, 0x0,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x4f, 0x10, 0x12,
    0x41, 0xe7, 0x0, 0x3d, 0xde, 0xff, 0xff, 0xfd,
    0x3e, 0x70, 0x1, 0x66, 0x54, 0x32, 0x10, 0x0,
    0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe7,
    0x0,

    /* U+AD6C "구" */
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x1, 0x44, 0x44, 0x44, 0x49, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8d, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xca, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x0, 0x6, 0x66, 0x66,
    0x66, 0x67, 0xf9, 0x66, 0x1, 0xdd, 0xdd, 0xdd,
    0xfd, 0xdd, 0xdd, 0xd2, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0,

    /* U+ADF8 "그" */
    0x0, 0x14, 0x44, 0x44, 0x44, 0x44, 0x0, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9c, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x40, 0x0, 0x0, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x10,

    /* U+AE30 "기" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x13, 0x33,
    0x33, 0x31, 0x0, 0x7e, 0x5f, 0xff, 0xff, 0xf7,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x7e,
    0x0, 0x0, 0x1, 0xf5, 0x0, 0x7e, 0x0, 0x0,
    0x5, 0xf1, 0x0, 0x7e, 0x0, 0x0, 0xc, 0xb0,
    0x0, 0x7e, 0x0, 0x0, 0x9f, 0x20, 0x0, 0x7e,
    0x0, 0x9, 0xf5, 0x0, 0x0, 0x7e, 0x5, 0xde,
    0x40, 0x0, 0x0, 0x7e, 0x2f, 0x80, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+B044 "끄" */
    0x0, 0x55, 0x55, 0x41, 0x55, 0x55, 0x10, 0x0,
    0xd, 0xdd, 0xfb, 0x4d, 0xdd, 0xf5, 0x0, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x1f, 0x40, 0x0, 0x0,
    0x0, 0xc9, 0x0, 0x2, 0xf3, 0x0, 0x0, 0x0,
    0xe, 0x80, 0x0, 0x4f, 0x10, 0x0, 0x0, 0x1,
    0xf5, 0x0, 0x6, 0xf0, 0x0, 0x0, 0x0, 0x4f,
    0x20, 0x0, 0x9d, 0x0, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0xd, 0x90, 0x0, 0x0, 0x0, 0x2, 0x0,
    0x0, 0x22, 0x0, 0x0, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x10,

    /* U+B098 "나" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe4, 0x0, 0x26,
    0x0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x1, 0xf5, 0x0, 0x6f, 0x0, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x6f, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x1,
    0xf9, 0x64, 0x6f, 0x0, 0x0, 0x0, 0x1, 0xfe,
    0xdb, 0x6f, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0,
    0x6f, 0x0, 0x1, 0x35, 0x11, 0xf5, 0x0, 0x6f,
    0xee, 0xff, 0xfe, 0x41, 0xf5, 0x0, 0x25, 0x54,
    0x32, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf5, 0x0,

    /* U+B124 "네" */
    0x0, 0x0, 0x0, 0x1, 0x40, 0x1e, 0x33, 0x50,
    0x0, 0x0, 0x4f, 0x12, 0xf4, 0x7e, 0x0, 0x0,
    0x4, 0xf1, 0x2f, 0x47, 0xe0, 0x0, 0x0, 0x4f,
    0x12, 0xf4, 0x7e, 0x0, 0x1, 0x15, 0xf1, 0x2f,
    0x47, 0xe0, 0x4, 0xff, 0xff, 0x12, 0xf4, 0x7e,
    0x0, 0x2, 0x26, 0xf1, 0x2f, 0x47, 0xe0, 0x0,
    0x0, 0x4f, 0x12, 0xf4, 0x7e, 0x0, 0x0, 0x4,
    0xf1, 0x2f, 0x47, 0xfc, 0xde, 0xf3, 0x4f, 0x12,
    0xf4, 0x37, 0x76, 0x53, 0x4, 0xf1, 0x2f, 0x40,
    0x0, 0x0, 0x0, 0x4f, 0x12, 0xf4, 0x0, 0x0,
    0x0, 0x4, 0xf1, 0x2f, 0x40, 0x0, 0x0, 0x0,
    0x3e, 0x12, 0xf4,

    /* U+B155 "녕" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0x2, 0xa1,
    0x0, 0x0, 0x12, 0x27, 0xf0, 0x3f, 0x20, 0x0,
    0xd, 0xff, 0xff, 0x3, 0xf2, 0x0, 0x0, 0x1,
    0x17, 0xf0, 0x3f, 0x20, 0x0, 0x4, 0x44, 0x9f,
    0x3, 0xf2, 0x0, 0x0, 0xcf, 0xff, 0xf0, 0x3f,
    0x31, 0x24, 0x50, 0x0, 0x6f, 0x3, 0xff, 0xff,
    0xec, 0x0, 0x6, 0xf0, 0x2, 0x21, 0x0, 0x0,
    0x0, 0x4b, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xd7,
    0x0, 0x0, 0x0, 0xed, 0x63, 0x47, 0xfa, 0x0,
    0x0, 0x5f, 0x20, 0x0, 0x6, 0xf1, 0x0, 0x5,
    0xf1, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x1f, 0xb3,
    0x11, 0x5e, 0xc0, 0x0, 0x0, 0x3b, 0xff, 0xff,
    0x91, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,

    /* U+B294 "는" */
    0x0, 0x2, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x94, 0x44, 0x44, 0x44, 0x10, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x10, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x20, 0x0, 0x6, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x44, 0x44, 0x44, 0x41,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0,

    /* U+B2A5 "능" */
    0x0, 0x4, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0, 0x44,
    0x44, 0x44, 0x44, 0x41, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x0, 0x0, 0x0, 0x13, 0x43,
    0x10, 0x0, 0x0, 0x0, 0x2, 0xcf, 0xff, 0xff,
    0xc2, 0x0, 0x0, 0x0, 0xdd, 0x30, 0x0, 0x3c,
    0xd0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0xdc, 0x20, 0x0, 0x2c, 0xe0,
    0x0, 0x0, 0x3, 0xdf, 0xfe, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x54, 0x20, 0x0, 0x0,

    /* U+B2C8 "니" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x6, 0x20,
    0x0, 0x0, 0x0, 0x7e, 0x1f, 0x50, 0x0, 0x0,
    0x0, 0x7e, 0x1f, 0x50, 0x0, 0x0, 0x0, 0x7e,
    0x1f, 0x50, 0x0, 0x0, 0x0, 0x7e, 0x1f, 0x50,
    0x0, 0x0, 0x0, 0x7e, 0x1f, 0x50, 0x0, 0x0,
    0x0, 0x7e, 0x1f, 0x50, 0x0, 0x0, 0x0, 0x7e,
    0x1f, 0x50, 0x1, 0x35, 0x40, 0x7e, 0x1f, 0xfe,
    0xff, 0xfe, 0x80, 0x7e, 0x5, 0x54, 0x42, 0x10,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+B2E4 "다" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x24,
    0x44, 0x44, 0x40, 0x0, 0xf7, 0x0, 0x7f, 0xff,
    0xff, 0xf1, 0x0, 0xf7, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x0,
    0xfa, 0x65, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xfe,
    0xdd, 0x7e, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x0,
    0x7e, 0x0, 0x0, 0x2, 0x0, 0xf7, 0x0, 0x7f,
    0xcd, 0xdf, 0xff, 0x0, 0xf7, 0x0, 0x36, 0x65,
    0x53, 0x10, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf7, 0x0,

    /* U+B2F5 "답" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc5, 0x0, 0x7f,
    0xff, 0xff, 0xf3, 0x0, 0xf7, 0x0, 0x7f, 0x44,
    0x44, 0x41, 0x0, 0xf7, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0xfc, 0xa8, 0x7e, 0x0, 0x0, 0x0,
    0x0, 0xfc, 0x97, 0x7e, 0x11, 0x23, 0x46, 0x40,
    0xf7, 0x0, 0x7f, 0xff, 0xff, 0xec, 0x60, 0xf7,
    0x0, 0x12, 0x22, 0x10, 0x0, 0x0, 0xf7, 0x0,
    0x0, 0x2, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x3f,
    0x75, 0x55, 0x55, 0xf7, 0x0, 0x0, 0x3f, 0xee,
    0xee, 0xee, 0xf7, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0xf7, 0x0, 0x0, 0x3f, 0x64, 0x44, 0x44,
    0xf7, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xf7,
    0x0,

    /* U+B300 "대" */
    0x0, 0x0, 0x0, 0x1, 0x30, 0x1e, 0x31, 0x44,
    0x44, 0x20, 0x6f, 0x1, 0xf4, 0x7f, 0xff, 0xf9,
    0x6, 0xf0, 0x1f, 0x47, 0xe0, 0x0, 0x0, 0x6f,
    0x1, 0xf4, 0x7e, 0x0, 0x0, 0x6, 0xf0, 0x1f,
    0x47, 0xe0, 0x0, 0x0, 0x6f, 0x67, 0xf4, 0x7e,
    0x0, 0x0, 0x6, 0xfd, 0xdf, 0x47, 0xe0, 0x0,
    0x0, 0x6f, 0x1, 0xf4, 0x7e, 0x0, 0x0, 0x6,
    0xf0, 0x1f, 0x47, 0xf6, 0x78, 0x94, 0x6f, 0x1,
    0xf4, 0x6d, 0xcc, 0xb9, 0x36, 0xf0, 0x1f, 0x40,
    0x0, 0x0, 0x0, 0x6f, 0x1, 0xf4, 0x0, 0x0,
    0x0, 0x6, 0xf0, 0x1f, 0x40, 0x0, 0x0, 0x0,
    0x5e, 0x1, 0xf4,

    /* U+B3C4 "도" */
    0x0, 0x1d, 0xdd, 0xdd, 0xdd, 0xdd, 0x10, 0x0,
    0x2, 0xf8, 0x66, 0x66, 0x66, 0x60, 0x0, 0x0,
    0x2f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf8,
    0x55, 0x55, 0x55, 0x51, 0x0, 0x0, 0x1e, 0xee,
    0xef, 0xfe, 0xee, 0x30, 0x0, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+B428 "됨" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x90, 0xf,
    0xff, 0xff, 0xff, 0x0, 0x7e, 0x0, 0xf9, 0x33,
    0x33, 0x30, 0x7, 0xe0, 0xf, 0x70, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0xf7, 0x11, 0x11, 0x10, 0x7,
    0xe0, 0xf, 0xff, 0xff, 0xff, 0x40, 0x7e, 0x0,
    0x22, 0x3f, 0x62, 0x20, 0x7, 0xe0, 0x11, 0x13,
    0xf6, 0x45, 0x64, 0x7e, 0xf, 0xff, 0xff, 0xfe,
    0xdc, 0x67, 0xe0, 0x11, 0x11, 0x0, 0x0, 0x0,
    0x36, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff, 0xe0,
    0x0, 0xc, 0xb4, 0x44, 0x44, 0x9e, 0x0, 0x0,
    0xc9, 0x0, 0x0, 0x7, 0xe0, 0x0, 0xc, 0xa2,
    0x22, 0x22, 0x8e, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x11,

    /* U+B4C8 "듈" */
    0x0, 0x2, 0x22, 0x22, 0x22, 0x22, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x1f, 0x51, 0x11, 0x11, 0x11, 0x0, 0x0, 0x1,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0x40, 0x0, 0x0, 0x44,
    0x44, 0x44, 0x44, 0x41, 0x0, 0x4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x9c, 0x0,
    0xc, 0xa0, 0x0, 0x0, 0x1, 0xef, 0xfe, 0xee,
    0xff, 0xc0, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0xae, 0x0, 0x0, 0x0, 0x33, 0x33, 0x33, 0x39,
    0xe0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x33, 0x33, 0x33, 0x33, 0x31, 0x0,

    /* U+B4DC "드" */
    0x0, 0x5, 0x55, 0x55, 0x55, 0x55, 0x0, 0x0,
    0x2, 0xfe, 0xee, 0xee, 0xee, 0xe2, 0x0, 0x0,
    0x2f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf7,
    0x44, 0x44, 0x44, 0x41, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x10, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x20,

    /* U+B4E3 "듣" */
    0x0, 0x2, 0x22, 0x22, 0x22, 0x22, 0x0, 0x0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x2f, 0x51, 0x11, 0x11, 0x11, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0x85, 0x55, 0x55, 0x55, 0x10, 0x0, 0x1, 0xee,
    0xee, 0xee, 0xee, 0xe3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xe2, 0x5, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0x1, 0xf7, 0x44, 0x44, 0x44,
    0x40, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf5, 0x11, 0x11, 0x11, 0x10,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x22, 0x22, 0x22, 0x22, 0x20, 0x0,

    /* U+B529 "딩" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x3, 0xee,
    0xee, 0xee, 0x60, 0x7, 0xe0, 0x4f, 0x75, 0x55,
    0x52, 0x0, 0x7e, 0x4, 0xf2, 0x0, 0x0, 0x0,
    0x7, 0xe0, 0x4f, 0x20, 0x0, 0x0, 0x0, 0x7e,
    0x4, 0xf2, 0x0, 0x0, 0x12, 0x7, 0xe0, 0x4f,
    0xdc, 0xde, 0xff, 0xc0, 0x7e, 0x1, 0x76, 0x66,
    0x53, 0x10, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x48, 0x0, 0x0, 0x2, 0xae, 0xff, 0xd6,
    0x0, 0x0, 0x1, 0xfc, 0x53, 0x37, 0xf9, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0x7, 0xf0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x2f, 0xa3,
    0x11, 0x5e, 0xa0, 0x0, 0x0, 0x4c, 0xff, 0xff,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,

    /* U+B808 "레" */
    0x0, 0x0, 0x0, 0x0, 0x31, 0xe, 0x53, 0x44,
    0x44, 0x20, 0xf, 0x60, 0xf5, 0xbf, 0xff, 0xf7,
    0x0, 0xf6, 0xf, 0x50, 0x0, 0xe, 0x70, 0xf,
    0x60, 0xf5, 0x0, 0x0, 0xe7, 0x0, 0xf6, 0xf,
    0x53, 0x77, 0x7f, 0x76, 0x9f, 0x60, 0xf5, 0x7f,
    0xcc, 0xc5, 0x7a, 0xf6, 0xf, 0x57, 0xe0, 0x0,
    0x0, 0xf, 0x60, 0xf5, 0x7e, 0x0, 0x0, 0x0,
    0xf6, 0xf, 0x57, 0xf3, 0x44, 0x64, 0xf, 0x60,
    0xf5, 0x7f, 0xff, 0xed, 0x70, 0xf6, 0xf, 0x50,
    0x0, 0x0, 0x0, 0xf, 0x60, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xf6, 0xf, 0x50, 0x0, 0x0, 0x0,
    0xe, 0x50, 0xf5,

    /* U+B824 "려" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x7b, 0xbb,
    0xbb, 0x50, 0x0, 0x7e, 0x58, 0x88, 0x8f, 0x70,
    0x0, 0x7e, 0x0, 0x0, 0xe, 0x75, 0xee, 0xfe,
    0x0, 0x0, 0xe, 0x72, 0x55, 0xae, 0x6d, 0xdd,
    0xdf, 0x70, 0x0, 0x7e, 0x7f, 0x77, 0x77, 0x30,
    0x0, 0x7e, 0x7f, 0x0, 0x0, 0x5, 0xff, 0xfe,
    0x7f, 0x0, 0x0, 0x1, 0x44, 0xae, 0x7f, 0x55,
    0x67, 0x98, 0x0, 0x7e, 0x7f, 0xee, 0xdc, 0xa6,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+B85C "로" */
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x44, 0x44, 0x44, 0x48, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x1,
    0xee, 0xee, 0xee, 0xee, 0xf1, 0x0, 0x0, 0x1f,
    0x85, 0x55, 0x55, 0x55, 0x0, 0x0, 0x1, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x85,
    0x55, 0x55, 0x55, 0x20, 0x0, 0x1, 0xee, 0xee,
    0xfe, 0xee, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+B958 "류" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x0,
    0x2, 0x22, 0x22, 0x22, 0x6f, 0x10, 0x0, 0x0,
    0x33, 0x33, 0x33, 0x37, 0xf1, 0x0, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x1, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x74,
    0x44, 0x44, 0x44, 0x20, 0x0, 0x1, 0xff, 0xff,
    0xff, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xe2, 0x5, 0x55, 0xbd, 0x55, 0x5d,
    0xc5, 0x55, 0x0, 0x0, 0xa, 0xc0, 0x0, 0xca,
    0x0, 0x0, 0x0, 0x0, 0xac, 0x0, 0xc, 0xa0,
    0x0, 0x0, 0x0, 0xa, 0xc0, 0x0, 0xca, 0x0,
    0x0,

    /* U+B968 "륨" */
    0x0, 0x4, 0x44, 0x44, 0x44, 0x43, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x11, 0x7f, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xee, 0xee, 0xee, 0xe6, 0x0, 0x0, 0x4, 0x44,
    0x44, 0x44, 0x44, 0x20, 0x0, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x10, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x22, 0x2b, 0xc2, 0x22,
    0xbb, 0x22, 0x20, 0x0, 0x3, 0xbc, 0x33, 0x3c,
    0xc3, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x3f,
    0x20, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x4, 0xf2,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x22, 0x22, 0x22, 0x22, 0x20, 0x0,

    /* U+B97C "를" */
    0x0, 0x4, 0x44, 0x44, 0x44, 0x43, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x1, 0x11, 0x11, 0x11, 0x7f, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xf7, 0x0, 0x0, 0x3, 0x44,
    0x44, 0x44, 0x44, 0x10, 0x0, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x50, 0x1e, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0x20, 0x0, 0x33, 0x33, 0x33,
    0x33, 0x30, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x18,
    0xe0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x33, 0x33, 0x33, 0x33, 0x31, 0x0,

    /* U+B9AC "리" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x14, 0x44,
    0x44, 0x41, 0x0, 0x7e, 0x5f, 0xff, 0xff, 0xf7,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0xf7, 0x0, 0x7e, 0x3e, 0xee,
    0xee, 0xf7, 0x0, 0x7e, 0x4f, 0x65, 0x55, 0x52,
    0x0, 0x7e, 0x4f, 0x20, 0x0, 0x0, 0x0, 0x7e,
    0x4f, 0x20, 0x0, 0x0, 0x0, 0x7e, 0x4f, 0x65,
    0x56, 0x8a, 0xa0, 0x7e, 0x3f, 0xfe, 0xed, 0xb9,
    0x60, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+B9D0 "말" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xd2, 0x0, 0xef,
    0xff, 0xff, 0xf4, 0x4, 0xf2, 0x0, 0xe9, 0x33,
    0x34, 0xf4, 0x4, 0xf2, 0x0, 0xe7, 0x0, 0x2,
    0xf4, 0x4, 0xfe, 0xd7, 0xe7, 0x0, 0x2, 0xf4,
    0x4, 0xf7, 0x52, 0xe8, 0x0, 0x2, 0xf4, 0x4,
    0xf2, 0x0, 0xef, 0xff, 0xff, 0xf4, 0x4, 0xf2,
    0x0, 0x23, 0x33, 0x33, 0x30, 0x4, 0xf2, 0x0,
    0x0, 0x13, 0x33, 0x33, 0x33, 0x30, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf2, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x7f, 0x33, 0x33,
    0x33, 0x30, 0x0, 0x0, 0x7f, 0x22, 0x22, 0x22,
    0x22, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10, 0x0,

    /* U+BAA8 "모" */
    0x0, 0x1d, 0xdd, 0xdd, 0xdd, 0xdd, 0x20, 0x0,
    0x2, 0xf8, 0x55, 0x55, 0x57, 0xf3, 0x0, 0x0,
    0x2f, 0x40, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x2f,
    0x40, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x2, 0xf7,
    0x44, 0x44, 0x47, 0xf3, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x3,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+BC1C "발" */
    0x10, 0x0, 0x0, 0x10, 0x3, 0xc1, 0x0, 0xe7,
    0x0, 0x1, 0xf4, 0x4, 0xf2, 0x0, 0xe7, 0x0,
    0x1, 0xf4, 0x4, 0xf2, 0x0, 0xee, 0xcc, 0xcc,
    0xf4, 0x4, 0xf6, 0x42, 0xeb, 0x77, 0x78, 0xf4,
    0x4, 0xff, 0xf7, 0xe7, 0x0, 0x1, 0xf4, 0x4,
    0xf2, 0x0, 0xef, 0xff, 0xff, 0xf4, 0x4, 0xf2,
    0x0, 0x34, 0x44, 0x44, 0x41, 0x4, 0xf2, 0x0,
    0x0, 0x13, 0x33, 0x33, 0x33, 0x30, 0x0, 0x0,
    0x8f, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf2, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x7f, 0x33, 0x33,
    0x33, 0x30, 0x0, 0x0, 0x7f, 0x22, 0x22, 0x22,
    0x22, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10, 0x0,

    /* U+BC30 "배" */
    0x0, 0x0, 0x0, 0x0, 0x40, 0xe, 0x54, 0x70,
    0x0, 0x83, 0x2f, 0x30, 0xf6, 0x7e, 0x0, 0xf,
    0x52, 0xf3, 0xf, 0x67, 0xe0, 0x0, 0xf5, 0x2f,
    0x30, 0xf6, 0x7f, 0x99, 0x9f, 0x52, 0xf3, 0xf,
    0x67, 0xfb, 0xbb, 0xf5, 0x2f, 0xa8, 0xf6, 0x7e,
    0x0, 0xf, 0x52, 0xfc, 0xbf, 0x67, 0xe0, 0x0,
    0xf5, 0x2f, 0x30, 0xf6, 0x7e, 0x0, 0xf, 0x52,
    0xf3, 0xf, 0x67, 0xf7, 0x77, 0xf5, 0x2f, 0x30,
    0xf6, 0x6c, 0xcc, 0xcc, 0x42, 0xf3, 0xf, 0x60,
    0x0, 0x0, 0x0, 0x2f, 0x30, 0xf6, 0x0, 0x0,
    0x0, 0x2, 0xf3, 0xf, 0x60, 0x0, 0x0, 0x0,
    0x2e, 0x30, 0xf6,

    /* U+BC84 "버" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0x24, 0x0,
    0x0, 0x52, 0x0, 0x6f, 0x7e, 0x0, 0x0, 0xf6,
    0x0, 0x6f, 0x7e, 0x0, 0x0, 0xf6, 0x0, 0x6f,
    0x7f, 0x88, 0x88, 0xf6, 0x0, 0x6f, 0x7f, 0x99,
    0x99, 0xf9, 0x44, 0x9f, 0x7e, 0x0, 0x0, 0xff,
    0xff, 0xff, 0x7e, 0x0, 0x0, 0xf6, 0x0, 0x6f,
    0x7e, 0x0, 0x0, 0xf6, 0x0, 0x6f, 0x7f, 0x66,
    0x66, 0xf6, 0x0, 0x6f, 0x6d, 0xdd, 0xdd, 0xd5,
    0x0, 0x6f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f,

    /* U+BCF4 "보" */
    0x0, 0x1d, 0x30, 0x0, 0x0, 0x3d, 0x10, 0x0,
    0x1, 0xf4, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x1f, 0xee, 0xee, 0xee, 0xef, 0x20, 0x0, 0x1,
    0xf8, 0x55, 0x55, 0x58, 0xf2, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x1, 0xf4,
    0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x33, 0x36,
    0xf6, 0x33, 0x30, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+BCFC "볼" */
    0x0, 0x5, 0x10, 0x0, 0x0, 0x15, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x4, 0xf1, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0, 0x1,
    0xf7, 0x33, 0x33, 0x37, 0xf1, 0x0, 0x0, 0x1f,
    0x74, 0x44, 0x44, 0x7f, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x0, 0x0, 0x44, 0x44, 0x44,
    0x44, 0x30, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff,
    0xfe, 0x0, 0x0, 0x0, 0x33, 0x33, 0x33, 0x39,
    0xe0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x33, 0x33, 0x33, 0x33, 0x31, 0x0,

    /* U+BD80 "부" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x1, 0xf4, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x1f, 0x74, 0x44, 0x44, 0x7f, 0x20, 0x0, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x1, 0xf5,
    0x11, 0x11, 0x15, 0xf2, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x22, 0x22,
    0x22, 0x22, 0x20, 0x0, 0x2, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x2, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x1, 0x11, 0x11, 0x3f, 0x41,
    0x11, 0x11, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0,

    /* U+BE44 "비" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x15, 0x0,
    0x0, 0x42, 0x0, 0x7e, 0x5f, 0x10, 0x0, 0xe7,
    0x0, 0x7e, 0x5f, 0x10, 0x0, 0xe7, 0x0, 0x7e,
    0x5f, 0xdd, 0xdd, 0xf7, 0x0, 0x7e, 0x5f, 0x66,
    0x66, 0xf7, 0x0, 0x7e, 0x5f, 0x10, 0x0, 0xe7,
    0x0, 0x7e, 0x5f, 0x10, 0x0, 0xe7, 0x0, 0x7e,
    0x5f, 0x10, 0x0, 0xe7, 0x0, 0x7e, 0x5f, 0x66,
    0x66, 0xf7, 0x0, 0x7e, 0x4d, 0xdd, 0xdd, 0xd6,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+C0AC "사" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x10, 0x0,
    0x0, 0xa, 0x50, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x0, 0xe8, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x4, 0xf2, 0x0, 0x0, 0x1,
    0xf9, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x0, 0x5f,
    0xe0, 0x0, 0x4, 0xf7, 0x63, 0x0, 0xa, 0xff,
    0x30, 0x0, 0x4f, 0xdd, 0x80, 0x4, 0xf7, 0xcd,
    0x10, 0x4, 0xf2, 0x0, 0x4, 0xfb, 0x1, 0xed,
    0x10, 0x4f, 0x20, 0x4, 0xfb, 0x0, 0x1, 0xce,
    0x4, 0xf2, 0x0, 0x17, 0x0, 0x0, 0x0, 0x20,
    0x4f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf2,
    0x0,

    /* U+C0BD "삽" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x40, 0x0,
    0x0, 0x8, 0x80, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x1, 0xf9, 0x54, 0x0, 0x7,
    0xff, 0x60, 0x0, 0x1f, 0xdc, 0x90, 0x7, 0xf6,
    0x6f, 0x70, 0x1, 0xf5, 0x0, 0x2d, 0xf6, 0x0,
    0x5e, 0xd2, 0x1f, 0x50, 0x0, 0x71, 0x0, 0x0,
    0x6, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x0, 0x0, 0x0, 0x4f, 0x10, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0x4, 0xf5, 0x44, 0x44,
    0x5f, 0x60, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x4, 0xf1, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x4f, 0x54, 0x44, 0x45, 0xf6,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0,

    /* U+C0C1 "상" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x30, 0x0,
    0x0, 0x9, 0x90, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x0, 0xcb, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0xe, 0xd0, 0x0, 0x1, 0xf7, 0x21, 0x0, 0x5,
    0xff, 0x30, 0x0, 0x1f, 0xff, 0xb0, 0x2, 0xea,
    0x9e, 0x20, 0x1, 0xf6, 0x10, 0x7, 0xfb, 0x0,
    0xaf, 0x81, 0x1f, 0x50, 0x2, 0xe7, 0x0, 0x0,
    0x6d, 0x11, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x40, 0x0, 0x0, 0x0, 0x5b, 0xee,
    0xd8, 0x10, 0x0, 0x0, 0x0, 0x8f, 0x85, 0x46,
    0xde, 0x10, 0x0, 0x0, 0xf, 0x80, 0x0, 0x1,
    0xf6, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0xb, 0xe5, 0x11, 0x3b, 0xf2,
    0x0, 0x0, 0x0, 0x19, 0xff, 0xff, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x12, 0x0, 0x0, 0x0,

    /* U+C0C8 "새" */
    0x0, 0x0, 0x0, 0x0, 0x14, 0x1, 0xe3, 0x0,
    0x2, 0x50, 0x0, 0x4f, 0x11, 0xf4, 0x0, 0x7,
    0xe0, 0x0, 0x4f, 0x11, 0xf4, 0x0, 0x8, 0xf0,
    0x0, 0x4f, 0x11, 0xf4, 0x0, 0x9, 0xf0, 0x0,
    0x4f, 0x11, 0xf4, 0x0, 0xb, 0xf3, 0x0, 0x4f,
    0x77, 0xf4, 0x0, 0xf, 0xf7, 0x0, 0x4f, 0xdd,
    0xf4, 0x0, 0x7e, 0x8e, 0x10, 0x4f, 0x11, 0xf4,
    0x2, 0xf7, 0xd, 0xb0, 0x4f, 0x11, 0xf4, 0x1e,
    0xb0, 0x2, 0xea, 0x4f, 0x11, 0xf4, 0x1a, 0x0,
    0x0, 0x23, 0x4f, 0x11, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x11, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x11, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x3e,
    0x11, 0xf4,

    /* U+C11C "서" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x0, 0x6b, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0,
    0x7e, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0xaf, 0x0,
    0x1, 0x16, 0xf1, 0x0, 0x0, 0xef, 0x50, 0x7f,
    0xff, 0xf1, 0x0, 0x4, 0xfe, 0xb0, 0x12, 0x27,
    0xf1, 0x0, 0xd, 0xc4, 0xf7, 0x0, 0x5, 0xf1,
    0x1, 0xce, 0x20, 0x7f, 0x80, 0x5, 0xf1, 0xd,
    0xe2, 0x0, 0x5, 0xf4, 0x5, 0xf1, 0x4, 0x10,
    0x0, 0x0, 0x10, 0x5, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf1,

    /* U+C124 "설" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x28, 0x10, 0x0,
    0x6c, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x8, 0xf0,
    0x0, 0x0, 0x4f, 0x20, 0x0, 0xbf, 0x20, 0x2f,
    0xff, 0xf2, 0x0, 0x3f, 0xe9, 0x0, 0x44, 0x7f,
    0x20, 0x3e, 0xa3, 0xf9, 0x0, 0x4, 0xf2, 0x9f,
    0xa0, 0x3, 0xee, 0x30, 0x4f, 0x27, 0x50, 0x0,
    0x0, 0x70, 0x4, 0xf2, 0x0, 0x1, 0x33, 0x33,
    0x33, 0x34, 0x0, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x20,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x7,
    0xf3, 0x33, 0x33, 0x33, 0x0, 0x0, 0x7f, 0x22,
    0x22, 0x22, 0x22, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10,

    /* U+C131 "성" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x60, 0x0,
    0x0, 0x67, 0x0, 0x0, 0x6, 0xf0, 0x0, 0x0,
    0xac, 0x0, 0x0, 0x6, 0xf0, 0x0, 0x0, 0xde,
    0x0, 0x15, 0x59, 0xf0, 0x0, 0x2, 0xff, 0x30,
    0x4e, 0xee, 0xf0, 0x0, 0xc, 0xdb, 0xd1, 0x0,
    0x6, 0xf0, 0x3, 0xde, 0x21, 0xce, 0x50, 0x6,
    0xf0, 0xe, 0xa1, 0x0, 0x8, 0xe1, 0x6, 0xf0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x5, 0xc0, 0x0,
    0x0, 0x1, 0x8d, 0xee, 0xc6, 0x0, 0x0, 0x0,
    0xd, 0xd7, 0x45, 0x8f, 0x90, 0x0, 0x0, 0x5f,
    0x20, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x6f, 0x10,
    0x0, 0x6, 0xf1, 0x0, 0x0, 0x1f, 0xb3, 0x11,
    0x5e, 0xc0, 0x0, 0x0, 0x3, 0xbf, 0xff, 0xf9,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0, 0x0,

    /* U+C138 "세" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0x11, 0xe3, 0x0,
    0x2, 0x50, 0x0, 0xf, 0x51, 0xf4, 0x0, 0x7,
    0xe0, 0x0, 0xf, 0x51, 0xf4, 0x0, 0x8, 0xf0,
    0x0, 0xf, 0x51, 0xf4, 0x0, 0x9, 0xf0, 0x25,
    0x5f, 0x51, 0xf4, 0x0, 0xb, 0xf2, 0x5e, 0xef,
    0x51, 0xf4, 0x0, 0xf, 0xf7, 0x0, 0xf, 0x51,
    0xf4, 0x0, 0x7e, 0x8e, 0x10, 0xf, 0x51, 0xf4,
    0x2, 0xf7, 0xd, 0xb0, 0xf, 0x51, 0xf4, 0x1d,
    0xb0, 0x2, 0xea, 0xf, 0x51, 0xf4, 0x1a, 0x0,
    0x0, 0x23, 0xf, 0x51, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x51, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x51, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x41, 0xf4,

    /* U+C14B "셋" */
    0x0, 0x0, 0x10, 0x0, 0x1c, 0x32, 0xc2, 0x0,
    0x7, 0xf0, 0x0, 0x1f, 0x43, 0xf2, 0x0, 0x7,
    0xf0, 0x0, 0x1f, 0x43, 0xf2, 0x0, 0x9, 0xf2,
    0x4e, 0xef, 0x43, 0xf2, 0x0, 0xe, 0xf7, 0x15,
    0x6f, 0x43, 0xf2, 0x0, 0x9e, 0x7f, 0x20, 0x1f,
    0x43, 0xf2, 0x9, 0xf4, 0xa, 0xf5, 0x1f, 0x43,
    0xf2, 0x3e, 0x40, 0x0, 0x8b, 0x1f, 0x43, 0xf2,
    0x1, 0x0, 0x0, 0x0, 0x4, 0x13, 0xf2, 0x0,
    0x0, 0x0, 0x4, 0xe1, 0x3, 0xf2, 0x0, 0x0,
    0x0, 0x6, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x3, 0xce,
    0x4f, 0x91, 0x0, 0x0, 0x5, 0xcf, 0xb1, 0x3,
    0xdf, 0xa3, 0x0, 0x7, 0x93, 0x0, 0x0, 0x5,
    0xa4,

    /* U+C18C "소" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfa, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x9e, 0xf7,
    0x0, 0x7, 0xff, 0x91, 0x0, 0xc, 0x81, 0x0,
    0x30, 0x1, 0x8c, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x4, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x0,

    /* U+C18D "속" */
    0x0, 0x0, 0x0, 0x15, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x59,
    0xee, 0x50, 0x4e, 0xe9, 0x50, 0x0, 0xc, 0xa6,
    0x0, 0x41, 0x5, 0xac, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x0, 0x44, 0x44, 0x46,
    0xf7, 0x44, 0x44, 0x40, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x60, 0x0,

    /* U+C1A1 "송" */
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x9f, 0x70, 0x0, 0x0, 0x0, 0x48,
    0xdf, 0x60, 0x5f, 0xe8, 0x40, 0x0, 0xd, 0xb7,
    0x0, 0x30, 0x6, 0xbd, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x0, 0x44, 0x44, 0x46,
    0xf7, 0x44, 0x44, 0x40, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x1, 0x11,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xff,
    0xa1, 0x0, 0x0, 0x0, 0xce, 0x52, 0x12, 0x5d,
    0xc0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0xec, 0x20, 0x0, 0x1b, 0xe0,
    0x0, 0x0, 0x3, 0xdf, 0xfe, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x54, 0x20, 0x0, 0x0,

    /* U+C218 "수" */
    0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xed, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2c, 0xd1, 0xdd, 0x20, 0x0, 0x0, 0x5, 0xaf,
    0xb1, 0x1, 0xaf, 0xb5, 0x0, 0x0, 0xda, 0x30,
    0x0, 0x0, 0x3a, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0,

    /* U+C2A4 "스" */
    0x0, 0x0, 0x0, 0x2f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xb0, 0xbf, 0x70, 0x0, 0x0, 0x7, 0xdf,
    0x90, 0x0, 0x9f, 0xd7, 0x0, 0x0, 0xea, 0x30,
    0x0, 0x0, 0x2a, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x10, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x20,

    /* U+C2B5 "습" */
    0x0, 0x0, 0x0, 0x19, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xde, 0x3e, 0xd5, 0x0, 0x0, 0x0, 0xbf,
    0xf9, 0x10, 0x19, 0xff, 0xb0, 0x0, 0x6, 0x40,
    0x0, 0x0, 0x0, 0x46, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x0, 0x0, 0x61, 0x0, 0x0,
    0x1, 0x60, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0,
    0x4f, 0x20, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x1f, 0x74, 0x44, 0x44, 0x7f,
    0x20, 0x0, 0x1, 0xf5, 0x11, 0x11, 0x14, 0xf2,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x22, 0x22, 0x22, 0x22, 0x20, 0x0,

    /* U+C2DC "시" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xc0, 0x0,
    0x4, 0xd0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x7, 0xf1, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x8f, 0x30, 0x0, 0x7,
    0xe0, 0x0, 0xd, 0xf8, 0x0, 0x0, 0x7e, 0x0,
    0x3, 0xfc, 0xe0, 0x0, 0x7, 0xe0, 0x0, 0xdb,
    0x1e, 0xb0, 0x0, 0x7e, 0x1, 0xce, 0x10, 0x3e,
    0xc1, 0x7, 0xe0, 0xcd, 0x20, 0x0, 0x2c, 0x70,
    0x7e, 0x3, 0x0, 0x0, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7e,

    /* U+C2E4 "실" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x40, 0x0,
    0x0, 0x9a, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0,
    0xbc, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0xee,
    0x0, 0x0, 0xe, 0x70, 0x0, 0x6, 0xff, 0x60,
    0x0, 0xe, 0x70, 0x0, 0x5f, 0x86, 0xf6, 0x0,
    0xe, 0x70, 0x1b, 0xf8, 0x0, 0x6f, 0xc0, 0xe,
    0x70, 0x9, 0x30, 0x0, 0x1, 0x70, 0xe, 0x70,
    0x0, 0x0, 0x33, 0x33, 0x33, 0x34, 0x20, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0xe9, 0x33,
    0x33, 0x33, 0x10, 0x0, 0x0, 0xe8, 0x22, 0x22,
    0x22, 0x20, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x10,

    /* U+C548 "안" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa3, 0x0, 0x6,
    0xef, 0xfc, 0x30, 0x1, 0xf5, 0x0, 0x6f, 0x61,
    0x2a, 0xf2, 0x1, 0xf5, 0x0, 0xc9, 0x0, 0x0,
    0xe7, 0x1, 0xf5, 0x0, 0xe8, 0x0, 0x0, 0xd9,
    0x1, 0xfb, 0x96, 0xbc, 0x0, 0x2, 0xf6, 0x1,
    0xfb, 0x86, 0x2e, 0xd8, 0x9f, 0xb0, 0x1, 0xf5,
    0x0, 0x0, 0x69, 0x85, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0, 0x0,
    0x4e, 0x10, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0xf5, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x43, 0x33,
    0x33, 0x33, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xfd, 0x0,

    /* U+C5C5 "업" */
    0x0, 0x2, 0x20, 0x0, 0x0, 0x6c, 0x7, 0xff,
    0xfe, 0x50, 0x0, 0x7f, 0x5f, 0x50, 0x8, 0xf2,
    0x0, 0x7f, 0xab, 0x0, 0x0, 0xec, 0x99, 0xcf,
    0xbb, 0x0, 0x0, 0xed, 0xaa, 0xcf, 0x7f, 0x20,
    0x5, 0xf4, 0x0, 0x7f, 0xb, 0xfd, 0xdf, 0x80,
    0x0, 0x7f, 0x0, 0x35, 0x52, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x10, 0x0, 0x0, 0x12, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0x7f, 0x0, 0x7, 0xf5, 0x55,
    0x55, 0x9f, 0x0, 0x7, 0xfe, 0xee, 0xee, 0xff,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x7f, 0x0, 0x7,
    0xf4, 0x44, 0x44, 0x9f, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xff,

    /* U+C5C6 "없" */
    0x0, 0x13, 0x20, 0x0, 0x0, 0x6c, 0x0, 0x7,
    0xff, 0xfe, 0x50, 0x0, 0x7f, 0x0, 0x5f, 0x50,
    0x8, 0xf2, 0x0, 0x7f, 0x0, 0xab, 0x0, 0x0,
    0xec, 0x99, 0xcf, 0x0, 0xba, 0x0, 0x0, 0xdd,
    0xaa, 0xdf, 0x0, 0x7f, 0x20, 0x4, 0xf4, 0x0,
    0x7f, 0x0, 0xc, 0xfb, 0xcf, 0xa0, 0x0, 0x7f,
    0x0, 0x0, 0x47, 0x73, 0x0, 0x0, 0x7f, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0xc7, 0x2, 0xf2, 0x5, 0xf0, 0x0, 0x0, 0xd9,
    0x35, 0xf2, 0x6, 0xf1, 0x0, 0x0, 0xdf, 0xff,
    0xf2, 0x9, 0xf4, 0x0, 0x0, 0xd8, 0x2, 0xf2,
    0x2f, 0xec, 0x0, 0x0, 0xd9, 0x25, 0xf4, 0xdc,
    0x2f, 0xa0, 0x0, 0xdf, 0xff, 0xf7, 0xd1, 0x3,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+C5D0 "에" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0x12, 0xe2, 0x0,
    0x16, 0x72, 0x0, 0x1f, 0x43, 0xf3, 0x2, 0xee,
    0xdf, 0x50, 0x1f, 0x43, 0xf3, 0xa, 0xd0, 0x9,
    0xe0, 0x1f, 0x43, 0xf3, 0xe, 0x70, 0x2, 0xf3,
    0x1f, 0x43, 0xf3, 0xf, 0x40, 0x0, 0xfb, 0x9f,
    0x43, 0xf3, 0x1f, 0x40, 0x0, 0xfc, 0xbf, 0x43,
    0xf3, 0xf, 0x50, 0x0, 0xf5, 0x1f, 0x43, 0xf3,
    0xd, 0x90, 0x4, 0xf2, 0x1f, 0x43, 0xf3, 0x8,
    0xf5, 0x3c, 0xc0, 0x1f, 0x43, 0xf3, 0x0, 0xaf,
    0xfd, 0x20, 0x1f, 0x43, 0xf3, 0x0, 0x0, 0x10,
    0x0, 0x1f, 0x43, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x43, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0x33, 0xf3,

    /* U+C5F0 "연" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0x0, 0x5d,
    0xff, 0xc3, 0x0, 0x7, 0xf0, 0x4f, 0x71, 0x2a,
    0xe1, 0xbb, 0xdf, 0xa, 0xc0, 0x0, 0xf, 0x66,
    0x6a, 0xf0, 0xba, 0x0, 0x0, 0xe7, 0x0, 0x7f,
    0x8, 0xe0, 0x0, 0x3f, 0x4a, 0xac, 0xf0, 0x1d,
    0xd8, 0x9f, 0xa0, 0x77, 0xbf, 0x0, 0x6, 0x98,
    0x40, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0xe, 0x80, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x93, 0x33, 0x33, 0x33, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xf4,

    /* U+C624 "오" */
    0x0, 0x0, 0x5a, 0xce, 0xca, 0x50, 0x0, 0x0,
    0x0, 0xaf, 0xa6, 0x56, 0xaf, 0xa0, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0x0, 0x6f,
    0x10, 0x0, 0x0, 0x1f, 0x60, 0x0, 0x1, 0xed,
    0x40, 0x0, 0x3c, 0xe1, 0x0, 0x0, 0x2, 0xbf,
    0xff, 0xff, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf6, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+C644 "완" */
    0x0, 0x1, 0x44, 0x10, 0x0, 0x1b, 0x20, 0x0,
    0xa, 0xff, 0xff, 0x80, 0x2, 0xf3, 0x0, 0x7,
    0xf4, 0x0, 0x5f, 0x50, 0x2f, 0x30, 0x0, 0xbb,
    0x0, 0x0, 0xd9, 0x2, 0xf3, 0x0, 0x9, 0xd0,
    0x0, 0x1e, 0x70, 0x2f, 0x30, 0x0, 0x2f, 0xd9,
    0x9e, 0xd1, 0x2, 0xff, 0xf9, 0x0, 0x28, 0xfc,
    0x60, 0x0, 0x2f, 0x63, 0x20, 0x0, 0xe, 0x70,
    0x0, 0x2, 0xf3, 0x0, 0x8b, 0xbc, 0xfe, 0xcd,
    0xd9, 0x2f, 0x30, 0x0, 0x11, 0x11, 0x0, 0x0,
    0x2, 0xf3, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0x2f, 0x30, 0x0, 0x0, 0x9b, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xc3, 0x33, 0x33, 0x33,
    0x20, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff, 0xfc,
    0x0,

    /* U+C694 "요" */
    0x0, 0x0, 0x5a, 0xce, 0xca, 0x50, 0x0, 0x0,
    0x0, 0xaf, 0xa6, 0x56, 0xaf, 0xb0, 0x0, 0x0,
    0x4f, 0x50, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x5f,
    0x20, 0x0, 0x0, 0x2f, 0x60, 0x0, 0x0, 0xde,
    0x62, 0x12, 0x6d, 0xd0, 0x0, 0x0, 0x1, 0x9e,
    0xff, 0xfe, 0x91, 0x0, 0x0, 0x0, 0x7, 0x60,
    0x20, 0x68, 0x0, 0x0, 0x0, 0x0, 0xca, 0x0,
    0xa, 0xc0, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0xac, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+C6A9 "용" */
    0x0, 0x0, 0x2, 0x45, 0x42, 0x0, 0x0, 0x0,
    0x0, 0x4d, 0xfe, 0xde, 0xfe, 0x40, 0x0, 0x0,
    0xe, 0xa1, 0x0, 0x1, 0xaf, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xe,
    0xc3, 0x0, 0x3, 0xce, 0x0, 0x0, 0x0, 0x2c,
    0xff, 0xff, 0xfd, 0x20, 0x0, 0x0, 0x0, 0x8e,
    0x23, 0x2e, 0x80, 0x0, 0x0, 0x33, 0x39, 0xe3,
    0x33, 0xea, 0x33, 0x30, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6b, 0xde, 0xdb,
    0x60, 0x0, 0x0, 0x0, 0xaf, 0x86, 0x56, 0x8f,
    0xb0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x6f,
    0x10, 0x0, 0x0, 0xeb, 0x10, 0x0, 0x1b, 0xe0,
    0x0, 0x0, 0x3, 0xdf, 0xee, 0xef, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x54, 0x20, 0x0, 0x0,

    /* U+C6B4 "운" */
    0x0, 0x0, 0x2, 0x45, 0x42, 0x0, 0x0, 0x0,
    0x0, 0x3d, 0xfe, 0xde, 0xfd, 0x40, 0x0, 0x0,
    0xe, 0xb1, 0x0, 0x1, 0xae, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0xe,
    0xb1, 0x0, 0x1, 0xaf, 0x0, 0x0, 0x0, 0x3d,
    0xfe, 0xde, 0xfe, 0x40, 0x0, 0x0, 0x0, 0x2,
    0x45, 0x52, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x33, 0x33, 0x33, 0xea,
    0x33, 0x33, 0x30, 0x0, 0x8, 0x30, 0xd, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xf7, 0x0, 0xc8, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf9, 0x44, 0x44, 0x44, 0x41,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0,

    /* U+C6CC "워" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xe1, 0x0,
    0x7, 0xdf, 0xd9, 0x10, 0x4, 0xf2, 0x0, 0xae,
    0x63, 0x5d, 0xc0, 0x4, 0xf2, 0x1, 0xf5, 0x0,
    0x2, 0xf4, 0x4, 0xf2, 0x2, 0xf5, 0x0, 0x2,
    0xf4, 0x4, 0xf2, 0x0, 0xbd, 0x52, 0x4c, 0xd0,
    0x4, 0xf2, 0x0, 0x19, 0xef, 0xea, 0x10, 0x4,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x2, 0x14, 0xf2,
    0xd, 0xdd, 0xde, 0xef, 0xff, 0x94, 0xf2, 0x6,
    0x66, 0x6f, 0x83, 0x20, 0x4, 0xf2, 0x0, 0x0,
    0x1f, 0x50, 0x44, 0x47, 0xf2, 0x0, 0x0, 0x1f,
    0x50, 0xef, 0xff, 0xf2, 0x0, 0x0, 0x1f, 0x50,
    0x0, 0x4, 0xf2, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x4, 0xf2,

    /* U+C744 "을" */
    0x0, 0x0, 0x2, 0x45, 0x53, 0x0, 0x0, 0x0,
    0x0, 0x5e, 0xfe, 0xde, 0xfe, 0x50, 0x0, 0x0,
    0xf, 0xa1, 0x0, 0x0, 0x9f, 0x0, 0x0, 0x1,
    0xf5, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xc,
    0xe9, 0x65, 0x68, 0xec, 0x0, 0x0, 0x0, 0x6,
    0xbd, 0xdd, 0xb6, 0x0, 0x0, 0x2, 0x22, 0x22,
    0x22, 0x22, 0x22, 0x22, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xee, 0xee, 0xee,
    0xee, 0xc0, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0xae, 0x0, 0x0, 0x0, 0x33, 0x33, 0x33, 0x39,
    0xe0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x0, 0x1, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x60,
    0x0, 0x0, 0x33, 0x33, 0x33, 0x33, 0x31, 0x0,

    /* U+C74C "음" */
    0x0, 0x0, 0x2, 0x45, 0x42, 0x0, 0x0, 0x0,
    0x0, 0x3d, 0xfe, 0xde, 0xfe, 0x40, 0x0, 0x0,
    0xe, 0xb1, 0x0, 0x1, 0xaf, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xe,
    0xb2, 0x0, 0x2, 0xbe, 0x0, 0x0, 0x0, 0x3c,
    0xff, 0xff, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x1,
    0x34, 0x31, 0x0, 0x0, 0x0, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x40, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x0, 0x1, 0xf7, 0x44, 0x44, 0x47,
    0xf2, 0x0, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x4f,
    0x20, 0x0, 0x1, 0xf5, 0x11, 0x11, 0x14, 0xf2,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x22, 0x22, 0x22, 0x22, 0x20, 0x0,

    /* U+C751 "응" */
    0x0, 0x0, 0x2, 0x45, 0x42, 0x0, 0x0, 0x0,
    0x0, 0x4d, 0xfe, 0xde, 0xfe, 0x40, 0x0, 0x0,
    0xf, 0xa1, 0x0, 0x1, 0xaf, 0x0, 0x0, 0x2,
    0xf4, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xd,
    0xd5, 0x21, 0x24, 0xce, 0x0, 0x0, 0x0, 0x1a,
    0xef, 0xff, 0xfa, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x10, 0x0, 0x0, 0x1, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xd2, 0x5, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x55, 0x0, 0x0, 0x0, 0x1, 0x11,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xff,
    0xa1, 0x0, 0x0, 0x0, 0xce, 0x52, 0x12, 0x5d,
    0xc0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0xec, 0x20, 0x0, 0x1b, 0xe0,
    0x0, 0x0, 0x3, 0xdf, 0xfe, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x54, 0x20, 0x0, 0x0,

    /* U+C774 "이" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x0, 0x7c,
    0xda, 0x30, 0x0, 0x7e, 0xa, 0xf8, 0x7b, 0xf3,
    0x0, 0x7e, 0x3f, 0x50, 0x0, 0xcc, 0x0, 0x7e,
    0x7f, 0x0, 0x0, 0x6f, 0x0, 0x7e, 0x9d, 0x0,
    0x0, 0x4f, 0x10, 0x7e, 0x9d, 0x0, 0x0, 0x4f,
    0x20, 0x7e, 0x7e, 0x0, 0x0, 0x6f, 0x0, 0x7e,
    0x3f, 0x40, 0x0, 0xbc, 0x0, 0x7e, 0xb, 0xf7,
    0x6b, 0xf4, 0x0, 0x7e, 0x0, 0x8d, 0xeb, 0x40,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+C778 "인" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0x0, 0x3c,
    0xff, 0xd6, 0x0, 0x7, 0xe0, 0x2f, 0x92, 0x16,
    0xf5, 0x0, 0x7e, 0x7, 0xe0, 0x0, 0xb, 0xb0,
    0x7, 0xe0, 0x9d, 0x0, 0x0, 0x9c, 0x0, 0x7e,
    0x6, 0xf2, 0x0, 0xd, 0x90, 0x7, 0xe0, 0xc,
    0xe9, 0x8d, 0xe1, 0x0, 0x7e, 0x0, 0x5, 0x99,
    0x60, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x84, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x93, 0x33, 0x33, 0x33, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xf4,

    /* U+C785 "입" */
    0x0, 0x2, 0x30, 0x0, 0x0, 0x6c, 0x5, 0xef,
    0xff, 0x80, 0x0, 0x7e, 0x3f, 0x80, 0x5, 0xf6,
    0x0, 0x7e, 0x8e, 0x0, 0x0, 0xac, 0x0, 0x7e,
    0x8d, 0x0, 0x0, 0x9c, 0x0, 0x7e, 0x4f, 0x40,
    0x2, 0xe8, 0x0, 0x7e, 0x8, 0xfd, 0xdf, 0xb0,
    0x0, 0x7e, 0x0, 0x25, 0x63, 0x0, 0x0, 0x7e,
    0x0, 0x1, 0x0, 0x0, 0x0, 0x12, 0x0, 0xe,
    0x70, 0x0, 0x0, 0x7f, 0x0, 0xe, 0xa5, 0x55,
    0x55, 0xaf, 0x0, 0xe, 0xfe, 0xee, 0xee, 0xff,
    0x0, 0xe, 0x70, 0x0, 0x0, 0x7f, 0x0, 0xe,
    0xa4, 0x44, 0x44, 0x9f, 0x0, 0xe, 0xff, 0xff,
    0xff, 0xfe,

    /* U+C7A0 "잠" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x40, 0x0,
    0xdf, 0xff, 0xff, 0xfe, 0x1, 0xf5, 0x0, 0x4,
    0x44, 0xbd, 0x44, 0x40, 0x1f, 0x50, 0x0, 0x0,
    0xc, 0xe0, 0x0, 0x1, 0xf8, 0x43, 0x0, 0x2,
    0xff, 0x40, 0x0, 0x1f, 0xff, 0xa0, 0x2, 0xdd,
    0xbe, 0x30, 0x1, 0xf5, 0x0, 0x8, 0xfd, 0x21,
    0xbf, 0x90, 0x1f, 0x50, 0x0, 0xb8, 0x0, 0x0,
    0x59, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x10, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x4, 0xf5, 0x44, 0x44,
    0x4f, 0x60, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x0,
    0xf6, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x4f, 0x54, 0x44, 0x45, 0xf6,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0,

    /* U+C804 "전" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0x8, 0xdd,
    0xdd, 0xdd, 0xc0, 0x5, 0xf1, 0x24, 0x4a, 0xf4,
    0x44, 0x0, 0x5f, 0x10, 0x0, 0x9f, 0x0, 0x3,
    0x37, 0xf1, 0x0, 0xe, 0xf6, 0x2, 0xff, 0xff,
    0x10, 0xb, 0xe8, 0xf4, 0x0, 0x5, 0xf1, 0x3d,
    0xe3, 0x8, 0xfa, 0x0, 0x5f, 0x17, 0x91, 0x0,
    0x3, 0x80, 0x5, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x10, 0x0, 0x8c, 0x0, 0x0, 0x5,
    0xf1, 0x0, 0x9, 0xd0, 0x0, 0x0, 0x4f, 0x10,
    0x0, 0x9d, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xe3, 0x33, 0x33, 0x33, 0x10, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0xf7,

    /* U+C811 "접" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4d, 0x19, 0xff,
    0xff, 0xff, 0xe0, 0x5, 0xf1, 0x23, 0x39, 0xf3,
    0x33, 0x0, 0x5f, 0x10, 0x0, 0xaf, 0x10, 0x18,
    0x8a, 0xf1, 0x0, 0x2f, 0xf9, 0x1, 0xbb, 0xcf,
    0x10, 0x4e, 0xb4, 0xfa, 0x10, 0x5, 0xf1, 0x8f,
    0x90, 0x3, 0xde, 0x0, 0x5f, 0x13, 0x30, 0x0,
    0x0, 0x20, 0x5, 0xf1, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x2, 0x0, 0x0, 0x9d, 0x0, 0x0, 0x4,
    0xf2, 0x0, 0x9, 0xe5, 0x55, 0x55, 0x8f, 0x20,
    0x0, 0x9f, 0xee, 0xee, 0xee, 0xf2, 0x0, 0x9,
    0xd0, 0x0, 0x0, 0x4f, 0x20, 0x0, 0x9e, 0x44,
    0x44, 0x47, 0xf2, 0x0, 0x8, 0xff, 0xff, 0xff,
    0xff, 0x10,

    /* U+C815 "정" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4d, 0x18, 0xee,
    0xee, 0xee, 0xd0, 0x5, 0xf1, 0x35, 0x5a, 0xf5,
    0x54, 0x0, 0x5f, 0x10, 0x0, 0x9f, 0x0, 0x1,
    0x16, 0xf1, 0x0, 0xe, 0xf5, 0x2, 0xff, 0xff,
    0x10, 0x9, 0xfc, 0xe2, 0x2, 0x26, 0xf1, 0x1b,
    0xf6, 0x1c, 0xe6, 0x0, 0x5f, 0x19, 0xe4, 0x0,
    0x8, 0xd0, 0x5, 0xf1, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x3b, 0x10, 0x0, 0x1, 0x8d, 0xff, 0xd7,
    0x0, 0x0, 0x0, 0xde, 0x63, 0x37, 0xec, 0x0,
    0x0, 0x4f, 0x30, 0x0, 0x5, 0xf2, 0x0, 0x4,
    0xf2, 0x0, 0x0, 0x4f, 0x30, 0x0, 0xe, 0xc4,
    0x11, 0x4d, 0xd0, 0x0, 0x0, 0x2b, 0xff, 0xff,
    0xa1, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0, 0x0,

    /* U+C871 "족" */
    0x0, 0x3, 0x33, 0x33, 0x33, 0x33, 0x10, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xfd, 0x20, 0x0, 0x0, 0x0, 0x15,
    0xaf, 0xb1, 0xbf, 0xa5, 0x10, 0x0, 0x6, 0xd9,
    0x40, 0x30, 0x49, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0x30, 0x0, 0x0, 0x0, 0x33, 0x33, 0x35,
    0xf6, 0x33, 0x33, 0x30, 0x2f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0x44, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x60, 0x0,

    /* U+C8FC "주" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x1, 0x44, 0x47, 0xf7, 0x44, 0x41, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x1,
    0x7f, 0xc2, 0xcf, 0x71, 0x0, 0x0, 0x6, 0xfd,
    0x60, 0x0, 0x6d, 0xf6, 0x0, 0x0, 0x13, 0x0,
    0x0, 0x0, 0x3, 0x10, 0x0, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x40, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0,

    /* U+C911 "중" */
    0x0, 0x3, 0x33, 0x33, 0x33, 0x33, 0x10, 0x0,
    0x4, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2d, 0xed, 0x20, 0x0, 0x0, 0x0, 0x27,
    0xbf, 0xa1, 0x9f, 0xc7, 0x30, 0x0, 0x5, 0xb7,
    0x20, 0x0, 0x27, 0xb5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0x4, 0x44, 0x44, 0x6f,
    0x74, 0x44, 0x44, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xfe,
    0xa1, 0x0, 0x0, 0x0, 0xbe, 0x52, 0x12, 0x5d,
    0xc0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0xec, 0x20, 0x0, 0x1b, 0xe0,
    0x0, 0x0, 0x3, 0xdf, 0xfe, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x54, 0x20, 0x0, 0x0,

    /* U+C9C0 "지" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x10, 0x44,
    0x44, 0x44, 0x42, 0x5, 0xf1, 0x3f, 0xff, 0xff,
    0xff, 0xa0, 0x5f, 0x10, 0x0, 0xf, 0x70, 0x0,
    0x5, 0xf1, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x3f, 0xb0, 0x0, 0x5, 0xf1, 0x0,
    0x9, 0xef, 0x10, 0x0, 0x5f, 0x10, 0x4, 0xf4,
    0xcb, 0x0, 0x5, 0xf1, 0x3, 0xe9, 0x2, 0xea,
    0x0, 0x5f, 0x13, 0xf9, 0x0, 0x2, 0xdb, 0x5,
    0xf1, 0x5, 0x0, 0x0, 0x0, 0x20, 0x5f, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf1,

    /* U+C9C4 "진" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0x8, 0xdd,
    0xdd, 0xdd, 0xd1, 0x7, 0xe0, 0x34, 0x49, 0xf4,
    0x44, 0x0, 0x7e, 0x0, 0x0, 0x8f, 0x10, 0x0,
    0x7, 0xe0, 0x0, 0xe, 0xf7, 0x0, 0x0, 0x7e,
    0x0, 0xa, 0xe8, 0xf5, 0x0, 0x7, 0xe0, 0x4d,
    0xe3, 0x7, 0xfb, 0x10, 0x7e, 0x7, 0x91, 0x0,
    0x2, 0x90, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0xc8, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0xd, 0x90, 0x0, 0x0, 0x7e, 0x0,
    0x0, 0xd9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xa3, 0x33, 0x33, 0x33, 0x10, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xf6,

    /* U+CC3E "찾" */
    0x0, 0x5, 0xa0, 0x0, 0x0, 0xd4, 0x0, 0x0,
    0x8, 0xe0, 0x0, 0x1, 0xf5, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0x1, 0xf5, 0x0, 0x45, 0x5b, 0xf5,
    0x55, 0x1, 0xf8, 0x32, 0x0, 0xb, 0xf1, 0x0,
    0x1, 0xff, 0xfb, 0x0, 0x4f, 0xea, 0x0, 0x1,
    0xf5, 0x0, 0x7, 0xf8, 0x2e, 0xc4, 0x1, 0xf5,
    0x0, 0xbe, 0x50, 0x0, 0x8f, 0x21, 0xf5, 0x0,
    0x30, 0x0, 0x0, 0x0, 0x0, 0x51, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x14,
    0x44, 0xcc, 0x44, 0x41, 0x0, 0x0, 0x0, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2c, 0xdd,
    0xb2, 0x0, 0x0, 0x0, 0x4b, 0xfc, 0x11, 0xcf,
    0xb4, 0x0, 0x0, 0x59, 0x40, 0x0, 0x4, 0x96,
    0x0,

    /* U+CD08 "초" */
    0x0, 0x0, 0x0, 0x16, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x25, 0x55, 0x7f, 0x75, 0x55, 0x20, 0x0, 0x6,
    0xee, 0xee, 0xfe, 0xee, 0xe6, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf4, 0xe9, 0x0, 0x0, 0x0, 0x1, 0x7e, 0xd2,
    0x2, 0xce, 0x72, 0x0, 0x0, 0x7c, 0x60, 0x15,
    0x10, 0x5b, 0x70, 0x0, 0x0, 0x0, 0x3, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30,
    0x0, 0x0, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf2, 0x4, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x0,

    /* U+CD5C "최" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4e, 0x10, 0x0,
    0xf, 0x70, 0x0, 0x5, 0xf1, 0x15, 0x55, 0xf9,
    0x55, 0x30, 0x5f, 0x12, 0xee, 0xef, 0xfe, 0xe9,
    0x5, 0xf1, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x5f,
    0x10, 0x0, 0x5f, 0xc0, 0x0, 0x5, 0xf1, 0x0,
    0x2e, 0xaf, 0xa0, 0x0, 0x5f, 0x10, 0x5e, 0xb0,
    0x3e, 0xd5, 0x5, 0xf1, 0x1e, 0x70, 0x42, 0x19,
    0x70, 0x5f, 0x10, 0x0, 0xe, 0x70, 0x0, 0x5,
    0xf1, 0x23, 0x44, 0xfa, 0x79, 0xa9, 0x5f, 0x1c,
    0xff, 0xed, 0xcb, 0xa8, 0x55, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xf1,

    /* U+CDA9 "충" */
    0x0, 0x0, 0x0, 0x2c, 0x20, 0x0, 0x0, 0x0,
    0x1, 0x55, 0x57, 0xf7, 0x55, 0x52, 0x0, 0x0,
    0x5e, 0xee, 0xef, 0xee, 0xee, 0x50, 0x0, 0x0,
    0x0, 0x6, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x4a, 0xfa, 0xfa, 0x41, 0x0, 0x0, 0x7, 0xfd,
    0x82, 0x2, 0x8d, 0xf8, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x1, 0xdd, 0xdd, 0xdd,
    0xdd, 0xdd, 0xdd, 0xd2, 0x5, 0x55, 0x55, 0x7f,
    0x75, 0x55, 0x55, 0x0, 0x0, 0x0, 0x3, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x9e, 0xff, 0xfe,
    0xa1, 0x0, 0x0, 0x0, 0xbe, 0x52, 0x12, 0x5d,
    0xc0, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x5f,
    0x0, 0x0, 0x0, 0xec, 0x20, 0x0, 0x1b, 0xe0,
    0x0, 0x0, 0x3, 0xdf, 0xfe, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x54, 0x20, 0x0, 0x0,

    /* U+CE5C "친" */
    0x0, 0x1, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x0, 0x0, 0x7, 0x30, 0x68, 0x8b, 0xf8,
    0x88, 0x10, 0xe7, 0x8, 0xbb, 0xdf, 0xbb, 0xb1,
    0xe, 0x70, 0x0, 0x7, 0xf1, 0x0, 0x0, 0xe7,
    0x0, 0x0, 0xcf, 0x50, 0x0, 0xe, 0x70, 0x0,
    0x6f, 0xae, 0x20, 0x0, 0xe7, 0x0, 0x7f, 0x70,
    0xae, 0x50, 0xe, 0x70, 0xaf, 0x50, 0x0, 0x7f,
    0x40, 0xe7, 0x4, 0x10, 0x0, 0x0, 0x10, 0xe,
    0x70, 0x0, 0xc, 0x40, 0x0, 0x0, 0xe7, 0x0,
    0x0, 0xf6, 0x0, 0x0, 0xe, 0x70, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x33,
    0x33, 0x33, 0x31, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0x60,

    /* U+CE74 "카" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe4, 0x0, 0x25,
    0x55, 0x55, 0x51, 0x1, 0xf5, 0x0, 0x7e, 0xee,
    0xee, 0xf3, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x3,
    0xf2, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xf1,
    0x1, 0xf5, 0x0, 0x6a, 0xaa, 0xac, 0xe0, 0x1,
    0xf9, 0x64, 0x69, 0x99, 0x9f, 0x80, 0x1, 0xfe,
    0xdb, 0x0, 0x0, 0x7f, 0x10, 0x1, 0xf5, 0x0,
    0x0, 0x6, 0xf5, 0x0, 0x1, 0xf5, 0x0, 0x2,
    0xbf, 0x50, 0x0, 0x1, 0xf5, 0x0, 0x5f, 0xb2,
    0x0, 0x0, 0x1, 0xf5, 0x0, 0x14, 0x0, 0x0,
    0x0, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xf5, 0x0,

    /* U+CE94 "캔" */
    0x0, 0x0, 0x0, 0x2, 0x70, 0x1a, 0x18, 0xdd,
    0xdd, 0xd1, 0x4f, 0x13, 0xf3, 0x24, 0x44, 0x8f,
    0x4, 0xf1, 0x3f, 0x32, 0x22, 0x28, 0xe0, 0x4f,
    0x13, 0xf3, 0xbf, 0xff, 0xfb, 0x4, 0xff, 0xff,
    0x30, 0x0, 0x5f, 0x40, 0x4f, 0x35, 0xf3, 0x0,
    0x8f, 0x70, 0x4, 0xf1, 0x3f, 0x36, 0xed, 0x40,
    0x0, 0x4f, 0x13, 0xf3, 0x45, 0x0, 0x0, 0x4,
    0xf1, 0x3f, 0x30, 0x0, 0x6c, 0x0, 0x4f, 0x13,
    0xf3, 0x0, 0x7, 0xe0, 0x3, 0xb1, 0x2f, 0x20,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf3, 0x33, 0x33, 0x33, 0x20, 0x0, 0x7f, 0xff,
    0xff, 0xff, 0xfa,

    /* U+CF1C "켜" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0x28, 0x88,
    0x88, 0x80, 0x0, 0x7f, 0x3d, 0xdd, 0xde, 0xf0,
    0x0, 0x7f, 0x0, 0x0, 0x6, 0xe1, 0x44, 0x9f,
    0x0, 0x0, 0x8, 0xd6, 0xff, 0xff, 0x5c, 0xcc,
    0xce, 0xa0, 0x0, 0x7f, 0x24, 0x44, 0x7f, 0x40,
    0x0, 0x7f, 0x0, 0x0, 0xcc, 0xb, 0xff, 0xff,
    0x0, 0xb, 0xe2, 0x3, 0x44, 0x9f, 0x4, 0xde,
    0x30, 0x0, 0x0, 0x7f, 0x4f, 0xa1, 0x0, 0x0,
    0x0, 0x7f, 0x2, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f,

    /* U+D06C "크" */
    0x0, 0x26, 0x66, 0x66, 0x66, 0x66, 0x0, 0x0,
    0x4, 0xdd, 0xdd, 0xdd, 0xde, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf0, 0x0, 0x0, 0x9f,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x2, 0x44,
    0x44, 0x44, 0x4a, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xab, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x96, 0x0, 0x0, 0x22, 0x22, 0x22, 0x22,
    0x22, 0x22, 0x20, 0x2f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x10,

    /* U+D0DC "태" */
    0x0, 0x0, 0x0, 0x1, 0x30, 0x5e, 0x44, 0x44,
    0x43, 0x7, 0xe0, 0x6f, 0xef, 0xff, 0xfa, 0x7,
    0xe0, 0x6f, 0xe7, 0x0, 0x0, 0x7, 0xe0, 0x6f,
    0xe7, 0x0, 0x0, 0x7, 0xe0, 0x6f, 0xeb, 0x77,
    0x72, 0x7, 0xf6, 0xaf, 0xee, 0xcc, 0xc4, 0x7,
    0xfd, 0xef, 0xe7, 0x0, 0x0, 0x7, 0xe0, 0x6f,
    0xe7, 0x0, 0x0, 0x7, 0xe0, 0x6f, 0xe8, 0x22,
    0x46, 0x17, 0xe0, 0x6f, 0xef, 0xff, 0xec, 0x27,
    0xe0, 0x6f, 0x11, 0x10, 0x0, 0x7, 0xe0, 0x6f,
    0x0, 0x0, 0x0, 0x7, 0xe0, 0x6f, 0x0, 0x0,
    0x0, 0x6, 0xd0, 0x6f,

    /* U+D130 "터" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0x24, 0x44,
    0x44, 0x40, 0x0, 0x7e, 0x7f, 0xff, 0xff, 0xf2,
    0x0, 0x7e, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x7e, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x7f, 0xdd,
    0xdd, 0xa7, 0xff, 0xfe, 0x7f, 0x55, 0x55, 0x41,
    0x33, 0x9e, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x7e, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x7f, 0x55,
    0x67, 0x9b, 0x0, 0x7e, 0x6d, 0xdd, 0xdb, 0x97,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7e,

    /* U+D15C "템" */
    0x0, 0x0, 0x0, 0x2, 0x91, 0x3c, 0xe, 0xff,
    0xff, 0x70, 0x4f, 0x25, 0xf0, 0xe9, 0x44, 0x42,
    0x4, 0xf2, 0x5f, 0xe, 0x81, 0x11, 0x3, 0x6f,
    0x25, 0xf0, 0xef, 0xff, 0xf6, 0xff, 0xf2, 0x5f,
    0xe, 0x82, 0x22, 0x0, 0x4f, 0x25, 0xf0, 0xe8,
    0x1, 0x23, 0x14, 0xf2, 0x5f, 0xe, 0xff, 0xff,
    0xf4, 0x4f, 0x25, 0xf0, 0x22, 0x22, 0x10, 0x3,
    0xd1, 0x4f, 0x0, 0x0, 0x44, 0x44, 0x44, 0x44,
    0x40, 0x0, 0xe, 0xfe, 0xee, 0xee, 0xff, 0x10,
    0x0, 0xe7, 0x0, 0x0, 0x5, 0xf1, 0x0, 0xe,
    0x70, 0x0, 0x0, 0x5f, 0x10, 0x0, 0xea, 0x44,
    0x44, 0x48, 0xf1, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0x0,

    /* U+D2B8 "트" */
    0x0, 0x2d, 0xdd, 0xdd, 0xdd, 0xdd, 0x30, 0x0,
    0x2, 0xf8, 0x66, 0x66, 0x66, 0x61, 0x0, 0x0,
    0x2f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfe, 0xdd, 0xdd, 0xdd, 0xc0, 0x0, 0x0, 0x2f,
    0x86, 0x66, 0x66, 0x65, 0x0, 0x0, 0x2, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x75,
    0x55, 0x55, 0x55, 0x10, 0x0, 0x2, 0xee, 0xee,
    0xee, 0xee, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x20, 0x44, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x40,

    /* U+D31F "팟" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0x40, 0x1,
    0xdd, 0xdd, 0xdd, 0xdd, 0x31, 0xf5, 0x0, 0x6,
    0xaf, 0x66, 0xec, 0x61, 0x1f, 0x50, 0x0, 0x7,
    0xf0, 0xd, 0x90, 0x1, 0xf5, 0x0, 0x0, 0x7f,
    0x0, 0xd9, 0x0, 0x1f, 0xca, 0x70, 0x7, 0xf0,
    0xd, 0x90, 0x1, 0xfc, 0xa7, 0x0, 0x7f, 0x0,
    0xd9, 0x11, 0x1f, 0x50, 0x3, 0xce, 0xfd, 0xef,
    0xff, 0x71, 0xf5, 0x0, 0x15, 0x55, 0x44, 0x32,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa6,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf6, 0xbd, 0x40,
    0x0, 0x0, 0x1, 0x9e, 0xe6, 0x0, 0x9f, 0xd7,
    0x0, 0x0, 0xb, 0x60, 0x0, 0x0, 0x28, 0x80,
    0x0,

    /* U+D328 "패" */
    0x0, 0x0, 0x0, 0x0, 0x4, 0x1, 0xe3, 0x4,
    0x44, 0x44, 0x44, 0x2f, 0x32, 0xf4, 0x1e, 0xff,
    0xef, 0xfd, 0x2f, 0x32, 0xf4, 0x0, 0xd8, 0xb,
    0xa0, 0x2f, 0x32, 0xf4, 0x0, 0xd8, 0xb, 0xa0,
    0x2f, 0x32, 0xf4, 0x0, 0xd8, 0xb, 0xa0, 0x2f,
    0x99, 0xf4, 0x0, 0xd8, 0xb, 0xa0, 0x2f, 0xcb,
    0xf4, 0x0, 0xd8, 0xb, 0xa0, 0x2f, 0x32, 0xf4,
    0x0, 0xd8, 0xb, 0xa0, 0x2f, 0x32, 0xf4, 0x3a,
    0xed, 0xbe, 0xff, 0x5f, 0x32, 0xf4, 0x2a, 0x99,
    0x87, 0x53, 0x3f, 0x32, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0x32, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x32, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0x22, 0xf4,

    /* U+D558 "하" */
    0x0, 0x0, 0x23, 0x0, 0x0, 0xd, 0x60, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0xf7, 0x0, 0x5,
    0x55, 0xaf, 0x55, 0x52, 0xf, 0x70, 0x1, 0xee,
    0xee, 0xee, 0xee, 0x60, 0xf7, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xf, 0x70, 0x0, 0x3, 0xdf,
    0xff, 0x70, 0x0, 0xfa, 0x65, 0x1, 0xea, 0x21,
    0x6f, 0x60, 0xf, 0xed, 0xd0, 0x5f, 0x0, 0x0,
    0xab, 0x0, 0xf7, 0x0, 0x5, 0xf0, 0x0, 0xa,
    0xb0, 0xf, 0x70, 0x0, 0x1f, 0x91, 0x5, 0xf7,
    0x0, 0xf7, 0x0, 0x0, 0x4e, 0xff, 0xf9, 0x0,
    0xf, 0x70, 0x0, 0x0, 0x2, 0x30, 0x0, 0x0,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf7,
    0x0,

    /* U+D55C "한" */
    0x0, 0x0, 0x86, 0x0, 0x0, 0xa, 0x30, 0x0,
    0x33, 0x3d, 0xb3, 0x33, 0x1, 0xf5, 0x0, 0x4e,
    0xee, 0xee, 0xee, 0xe2, 0x1f, 0x50, 0x0, 0x0,
    0x36, 0x63, 0x0, 0x1, 0xf5, 0x0, 0x0, 0xaf,
    0xbb, 0xfb, 0x0, 0x1f, 0x95, 0x40, 0x4f, 0x20,
    0x1, 0xf5, 0x1, 0xfd, 0xc8, 0x5, 0xf0, 0x0,
    0xf, 0x60, 0x1f, 0x50, 0x0, 0x1d, 0xc6, 0x6b,
    0xe1, 0x1, 0xf5, 0x0, 0x0, 0x17, 0xaa, 0x71,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x14, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x5, 0xf1, 0x0, 0x0,
    0xf, 0x50, 0x0, 0x0, 0x5f, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x33, 0x33, 0x33,
    0x30, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xfd,
    0x0,

    /* U+D560 "할" */
    0x0, 0x0, 0x65, 0x0, 0x0, 0x8, 0x20, 0x1,
    0x33, 0x3d, 0xb3, 0x33, 0x1, 0xf5, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xf2, 0x1f, 0x50, 0x0, 0x0,
    0x46, 0x64, 0x0, 0x1, 0xf8, 0x43, 0x0, 0xcf,
    0xbb, 0xed, 0x10, 0x1f, 0xff, 0xa0, 0x5f, 0x10,
    0x1, 0xf6, 0x1, 0xf5, 0x0, 0x4, 0xf4, 0x0,
    0x3f, 0x50, 0x1f, 0x50, 0x0, 0x8, 0xfe, 0xef,
    0x80, 0x1, 0xf5, 0x0, 0x0, 0x0, 0x22, 0x0,
    0x0, 0x6, 0x20, 0x0, 0x0, 0x5f, 0xff, 0xff,
    0xff, 0xf5, 0x0, 0x0, 0x1, 0x33, 0x33, 0x33,
    0x3f, 0x50, 0x0, 0x0, 0x4, 0x44, 0x44, 0x44,
    0xf5, 0x0, 0x0, 0x3, 0xfe, 0xee, 0xee, 0xee,
    0x50, 0x0, 0x0, 0x3f, 0x31, 0x11, 0x11, 0x11,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x1, 0x11, 0x11, 0x11, 0x11, 0x0,

    /* U+D569 "합" */
    0x0, 0x0, 0x57, 0x0, 0x0, 0x9, 0x30, 0x0,
    0x33, 0x3b, 0xd3, 0x33, 0x11, 0xf5, 0x0, 0x2f,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0x50, 0x0, 0x0,
    0x36, 0x64, 0x0, 0x1, 0xf7, 0x21, 0x0, 0x9f,
    0xcb, 0xed, 0x10, 0x1f, 0xff, 0xb0, 0x2f, 0x50,
    0x0, 0xe8, 0x1, 0xf6, 0x10, 0x2, 0xf3, 0x0,
    0xd, 0x80, 0x1f, 0x50, 0x0, 0xb, 0xea, 0x9d,
    0xe2, 0x1, 0xf5, 0x0, 0x0, 0x5, 0x88, 0x61,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x27, 0x0, 0x0,
    0x0, 0x72, 0x0, 0x0, 0x5, 0xf3, 0x22, 0x22,
    0x2f, 0x60, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x5, 0xf3, 0x11, 0x11, 0x2f,
    0x60, 0x0, 0x0, 0x5f, 0x54, 0x44, 0x45, 0xf6,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0,

    /* U+D56B "핫" */
    0x0, 0x0, 0x65, 0x0, 0x0, 0xd, 0x40, 0x0,
    0x11, 0x1c, 0xa1, 0x11, 0x1, 0xf5, 0x0, 0x4f,
    0xff, 0xff, 0xff, 0xf2, 0x1f, 0x50, 0x0, 0x22,
    0x35, 0x53, 0x22, 0x1, 0xf5, 0x0, 0x0, 0x8f,
    0xee, 0xf8, 0x0, 0x1f, 0xb9, 0x60, 0x3f, 0x50,
    0x4, 0xf4, 0x1, 0xfc, 0xa7, 0x5, 0xf0, 0x0,
    0xf, 0x60, 0x1f, 0x50, 0x0, 0x2f, 0xa4, 0x49,
    0xf2, 0x1, 0xf5, 0x0, 0x0, 0x3b, 0xee, 0xb4,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x0, 0x0, 0x63,
    0x1, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xe, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xe8, 0xdc, 0x30,
    0x0, 0x0, 0x1, 0x9e, 0xf7, 0x1, 0xbf, 0xc6,
    0x0, 0x0, 0xb, 0x61, 0x0, 0x0, 0x38, 0x80,
    0x0,

    /* U+D588 "했" */
    0x0, 0x2, 0xa1, 0x0, 0x7, 0x20, 0x93, 0x0,
    0x44, 0x7f, 0x64, 0x41, 0xf4, 0xf, 0x60, 0x2e,
    0xee, 0xee, 0xed, 0x1f, 0x40, 0xf6, 0x0, 0x0,
    0x68, 0x61, 0x1, 0xf4, 0xf, 0x60, 0x1, 0xed,
    0xad, 0xe1, 0x1f, 0xee, 0xf6, 0x0, 0x6f, 0x0,
    0xe, 0x71, 0xf8, 0x5f, 0x60, 0x6, 0xf0, 0x0,
    0xe7, 0x1f, 0x40, 0xf6, 0x0, 0x1e, 0xc8, 0xcf,
    0x11, 0xf4, 0xf, 0x60, 0x0, 0x17, 0x97, 0x10,
    0x1d, 0x40, 0xf6, 0x0, 0x0, 0x0, 0x53, 0x0,
    0x4, 0x30, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0xda, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x1f,
    0xd0, 0x0, 0x0, 0x0, 0xbd, 0xf5, 0x9, 0xdf,
    0x60, 0x0, 0x1, 0xbf, 0x27, 0xfa, 0xf3, 0x6f,
    0x80, 0x0, 0x1c, 0x20, 0x7, 0xe4, 0x0, 0x5b,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+D654 "화" */
    0x0, 0x0, 0x35, 0x0, 0x0, 0x1e, 0x40, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x1, 0xf5, 0x0, 0xe,
    0xff, 0xff, 0xff, 0xf4, 0x1f, 0x50, 0x0, 0x44,
    0x44, 0x44, 0x44, 0x11, 0xf5, 0x0, 0x0, 0x2a,
    0xee, 0xd6, 0x0, 0x1f, 0x50, 0x0, 0xd, 0xd7,
    0x69, 0xf6, 0x1, 0xf8, 0x42, 0x2, 0xf4, 0x0,
    0xc, 0xa0, 0x1f, 0xff, 0xa0, 0xe, 0xa2, 0x14,
    0xf7, 0x1, 0xf5, 0x0, 0x0, 0x4d, 0xff, 0xf9,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0x8, 0xe0, 0x0,
    0x1, 0xf5, 0x0, 0x13, 0x44, 0xae, 0x78, 0xac,
    0x2f, 0x50, 0x6, 0xff, 0xee, 0xdc, 0xa8, 0x62,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xf5,
    0x0,

    /* U+D655 "확" */
    0x0, 0x0, 0x4a, 0x0, 0x0, 0xa, 0x30, 0x0,
    0x44, 0x48, 0xf4, 0x44, 0x20, 0xf6, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xf8, 0xf, 0x60, 0x0, 0xc,
    0xb2, 0x14, 0xf5, 0x0, 0xf6, 0x0, 0x0, 0xf6,
    0x0, 0xc, 0x90, 0xf, 0xff, 0xb0, 0xb, 0xe7,
    0x69, 0xf4, 0x0, 0xf8, 0x43, 0x0, 0x7, 0xdf,
    0xa4, 0x0, 0xf, 0x60, 0x0, 0x0, 0x7, 0xf1,
    0x23, 0x40, 0xf6, 0x0, 0x8f, 0xff, 0xff, 0xff,
    0xfd, 0xf, 0x60, 0x2, 0x44, 0x33, 0x21, 0x0,
    0x0, 0xf5, 0x0, 0x0, 0x1, 0x22, 0x22, 0x22,
    0x22, 0x10, 0x0, 0x0, 0x9f, 0xff, 0xff, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0,

    /* U+D658 "환" */
    0x0, 0x0, 0x4c, 0x0, 0x0, 0xb, 0x40, 0x0,
    0x33, 0x38, 0xf3, 0x33, 0x10, 0xf6, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xf9, 0xf, 0x60, 0x0, 0x1b,
    0xd4, 0x37, 0xf5, 0x0, 0xf6, 0x0, 0x0, 0xf6,
    0x0, 0xc, 0x90, 0xf, 0x60, 0x0, 0xd, 0xa0,
    0x2, 0xe7, 0x0, 0xff, 0xfb, 0x0, 0x4e, 0xed,
    0xfc, 0x0, 0xf, 0x83, 0x20, 0x0, 0x9, 0xf2,
    0x0, 0x0, 0xf6, 0x0, 0x24, 0x45, 0xaf, 0x67,
    0x89, 0xf, 0x60, 0x3, 0x77, 0x77, 0x65, 0x54,
    0x30, 0xf6, 0x0, 0x0, 0x4, 0xd0, 0x0, 0x0,
    0xf, 0x60, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xf4, 0x33, 0x33, 0x33,
    0x20, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xfc,
    0x0,

    /* U+D65C "활" */
    0x0, 0x0, 0x38, 0x0, 0x0, 0x8, 0x30, 0x0,
    0x44, 0x48, 0xf4, 0x44, 0x20, 0xf6, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xf8, 0xf, 0x60, 0x0, 0xc,
    0xb1, 0x3, 0xf6, 0x0, 0xf7, 0x21, 0x0, 0xf7,
    0x0, 0xd, 0x90, 0xf, 0xff, 0xb0, 0x8, 0xfb,
    0xad, 0xf2, 0x0, 0xf7, 0x11, 0x0, 0x3, 0xaf,
    0x61, 0x0, 0xf, 0x60, 0x2, 0x33, 0x39, 0xf5,
    0x67, 0x80, 0xf6, 0x0, 0x7f, 0xff, 0xee, 0xdc,
    0xb9, 0xf, 0x60, 0x0, 0x0, 0x2, 0x22, 0x22,
    0x22, 0x52, 0x0, 0x0, 0x6, 0xff, 0xff, 0xff,
    0xff, 0x60, 0x0, 0x0, 0x1, 0x11, 0x11, 0x11,
    0xf6, 0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff,
    0x60, 0x0, 0x0, 0x4f, 0x21, 0x11, 0x11, 0x10,
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xf1,
    0x0, 0x0, 0x3, 0x33, 0x33, 0x33, 0x33, 0x0,

    /* U+D6C4 "후" */
    0x0, 0x0, 0x0, 0x2a, 0x20, 0x0, 0x0, 0x0,
    0x3, 0x33, 0x35, 0xf6, 0x33, 0x33, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x25, 0x55, 0x20, 0x0, 0x0, 0x0, 0x3,
    0xdf, 0xed, 0xef, 0xd3, 0x0, 0x0, 0x0, 0xcc,
    0x10, 0x0, 0x1c, 0xc0, 0x0, 0x0, 0xc, 0xc1,
    0x0, 0x1, 0xcc, 0x0, 0x0, 0x0, 0x3d, 0xfe,
    0xde, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x2, 0x45,
    0x42, 0x0, 0x0, 0x0, 0x55, 0x55, 0x55, 0x55,
    0x55, 0x55, 0x50, 0x1e, 0xee, 0xee, 0xef, 0xfe,
    0xee, 0xee, 0x20, 0x0, 0x0, 0x3, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf3, 0x0, 0x0,
    0x0,

    /* U+FF01 "！" */
    0x1, 0x6, 0xe0, 0x6d, 0x6, 0xd0, 0x5d, 0x5,
    0xd0, 0x5c, 0x5, 0xc0, 0x4c, 0x0, 0x20, 0x9e,
    0x2b, 0xf2, 0x0, 0x0,

    /* U+FF0C "，" */
    0x0, 0x0, 0x4, 0xf0, 0x8, 0xc0, 0xe, 0x50,
    0x6c, 0x0, 0x11, 0x0,

    /* U+FF1A "：" */
    0xb, 0xc0, 0xf, 0xf0, 0x1, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd0,
    0xe, 0xf0, 0x0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 66, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 91, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17, .adv_w = 104, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 30, .adv_w = 154, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 85, .adv_w = 147, .box_w = 7, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 141, .adv_w = 210, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 207, .adv_w = 164, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 268, .adv_w = 65, .box_w = 2, .box_h = 5, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 273, .adv_w = 92, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 303, .adv_w = 92, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 341, .adv_w = 110, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 362, .adv_w = 141, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 398, .adv_w = 77, .box_w = 4, .box_h = 5, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 408, .adv_w = 113, .box_w = 5, .box_h = 2, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 413, .adv_w = 77, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 418, .adv_w = 128, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 457, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 507, .adv_w = 147, .box_w = 5, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 535, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 585, .adv_w = 147, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 624, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 674, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 718, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 768, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 818, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 868, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 918, .adv_w = 97, .box_w = 3, .box_h = 9, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 932, .adv_w = 97, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 956, .adv_w = 141, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1001, .adv_w = 141, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1033, .adv_w = 141, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1078, .adv_w = 110, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1117, .adv_w = 220, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1215, .adv_w = 171, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1276, .adv_w = 159, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1320, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1364, .adv_w = 179, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1419, .adv_w = 142, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1463, .adv_w = 135, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1502, .adv_w = 175, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1552, .adv_w = 181, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1602, .adv_w = 70, .box_w = 2, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1613, .adv_w = 69, .box_w = 5, .box_h = 14, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 1648, .adv_w = 157, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1698, .adv_w = 130, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1737, .adv_w = 212, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1798, .adv_w = 189, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1853, .adv_w = 190, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1908, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1952, .adv_w = 190, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2017, .adv_w = 157, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2067, .adv_w = 145, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2117, .adv_w = 135, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2167, .adv_w = 179, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2217, .adv_w = 158, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2272, .adv_w = 230, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2349, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2404, .adv_w = 152, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2459, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2514, .adv_w = 75, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2544, .adv_w = 131, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2600, .adv_w = 75, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2630, .adv_w = 141, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 2654, .adv_w = 128, .box_w = 8, .box_h = 2, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2662, .adv_w = 89, .box_w = 5, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 2670, .adv_w = 157, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2711, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2765, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2801, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2855, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2896, .adv_w = 89, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2932, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2986, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3034, .adv_w = 69, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3046, .adv_w = 69, .box_w = 5, .box_h = 15, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 3084, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3132, .adv_w = 73, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3156, .adv_w = 236, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3215, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3251, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3292, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3346, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3400, .adv_w = 97, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3423, .adv_w = 123, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3455, .adv_w = 86, .box_w = 6, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3488, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3524, .adv_w = 135, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3565, .adv_w = 212, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3624, .adv_w = 132, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3665, .adv_w = 135, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3719, .adv_w = 130, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3755, .adv_w = 77, .box_w = 5, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3793, .adv_w = 47, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3816, .adv_w = 77, .box_w = 4, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3846, .adv_w = 141, .box_w = 9, .box_h = 4, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 3864, .adv_w = 91, .box_w = 3, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3882, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3926, .adv_w = 147, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3970, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4011, .adv_w = 147, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4061, .adv_w = 47, .box_w = 3, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4084, .adv_w = 123, .box_w = 7, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4133, .adv_w = 89, .box_w = 5, .box_h = 2, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4138, .adv_w = 206, .box_w = 13, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4223, .adv_w = 124, .box_w = 7, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4241, .adv_w = 131, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 4265, .adv_w = 141, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 4297, .adv_w = 113, .box_w = 5, .box_h = 2, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 4302, .adv_w = 103, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 4323, .adv_w = 89, .box_w = 6, .box_h = 2, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 4329, .adv_w = 93, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 4350, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4391, .adv_w = 104, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 4409, .adv_w = 104, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 4424, .adv_w = 89, .box_w = 4, .box_h = 3, .ofs_x = 1, .ofs_y = 10},
    {.bitmap_index = 4430, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4478, .adv_w = 152, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4541, .adv_w = 91, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 4546, .adv_w = 89, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 4554, .adv_w = 104, .box_w = 4, .box_h = 6, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 4566, .adv_w = 114, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 4587, .adv_w = 131, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 4611, .adv_w = 231, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4689, .adv_w = 234, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 4767, .adv_w = 231, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4845, .adv_w = 110, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4887, .adv_w = 171, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4970, .adv_w = 171, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5053, .adv_w = 171, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5136, .adv_w = 171, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5213, .adv_w = 171, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5290, .adv_w = 171, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5373, .adv_w = 228, .box_w = 15, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5456, .adv_w = 153, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 5512, .adv_w = 142, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5572, .adv_w = 142, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5632, .adv_w = 142, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5692, .adv_w = 142, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5748, .adv_w = 70, .box_w = 4, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5778, .adv_w = 70, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5816, .adv_w = 70, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5861, .adv_w = 70, .box_w = 6, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5903, .adv_w = 184, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5964, .adv_w = 189, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6034, .adv_w = 190, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6109, .adv_w = 190, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6184, .adv_w = 190, .box_w = 10, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6259, .adv_w = 190, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6329, .adv_w = 190, .box_w = 10, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6399, .adv_w = 141, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 6435, .adv_w = 190, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6490, .adv_w = 179, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6558, .adv_w = 179, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6626, .adv_w = 179, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6694, .adv_w = 179, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6757, .adv_w = 152, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6832, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6876, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6924, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6978, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7032, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7086, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7140, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7194, .adv_w = 157, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7253, .adv_w = 237, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7316, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7364, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7418, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7472, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7526, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7580, .adv_w = 69, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7604, .adv_w = 69, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7628, .adv_w = 69, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7664, .adv_w = 69, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7700, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7754, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7802, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7856, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7910, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7964, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8018, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8072, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8113, .adv_w = 158, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8163, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8211, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8259, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8307, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8355, .adv_w = 135, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8423, .adv_w = 163, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 8491, .adv_w = 135, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8559, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8613, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8667, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8715, .adv_w = 153, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8775, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8823, .adv_w = 164, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8889, .adv_w = 184, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8950, .adv_w = 163, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9010, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9064, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9118, .adv_w = 163, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9186, .adv_w = 69, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9195, .adv_w = 74, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9219, .adv_w = 130, .box_w = 9, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9269, .adv_w = 73, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9305, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9359, .adv_w = 97, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9401, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9443, .adv_w = 145, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9506, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9548, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9590, .adv_w = 87, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9626, .adv_w = 157, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9678, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9726, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9774, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9822, .adv_w = 169, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9883, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9925, .adv_w = 86, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 9967, .adv_w = 161, .box_w = 11, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10028, .adv_w = 171, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10089, .adv_w = 159, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10133, .adv_w = 130, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10172, .adv_w = 142, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10216, .adv_w = 181, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10266, .adv_w = 158, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10321, .adv_w = 212, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10382, .adv_w = 189, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10437, .adv_w = 190, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10492, .adv_w = 181, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10542, .adv_w = 153, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10592, .adv_w = 135, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10642, .adv_w = 213, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10714, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10769, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10829, .adv_w = 130, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10871, .adv_w = 165, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10939, .adv_w = 80, .box_w = 4, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10963, .adv_w = 157, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11008, .adv_w = 156, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 11068, .adv_w = 135, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11122, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11176, .adv_w = 130, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11208, .adv_w = 119, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11268, .adv_w = 165, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11322, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11376, .adv_w = 80, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11394, .adv_w = 133, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11430, .adv_w = 132, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11484, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 11532, .adv_w = 135, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11573, .adv_w = 119, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11633, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11674, .adv_w = 158, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11719, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 11767, .adv_w = 127, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 11815, .adv_w = 164, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11865, .adv_w = 112, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11897, .adv_w = 152, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11933, .adv_w = 198, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12023, .adv_w = 130, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12071, .adv_w = 191, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12131, .adv_w = 200, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12181, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12235, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12283, .adv_w = 200, .box_w = 11, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12349, .adv_w = 70, .box_w = 2, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12360, .adv_w = 69, .box_w = 5, .box_h = 14, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 12395, .adv_w = 171, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12456, .adv_w = 159, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12506, .adv_w = 159, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12550, .adv_w = 127, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12589, .adv_w = 145, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12633, .adv_w = 189, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12688, .adv_w = 157, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12738, .adv_w = 212, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12799, .adv_w = 181, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12849, .adv_w = 190, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12904, .adv_w = 181, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12954, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12998, .adv_w = 153, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13042, .adv_w = 135, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13092, .adv_w = 144, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13147, .adv_w = 167, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13191, .adv_w = 157, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13232, .adv_w = 158, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13284, .adv_w = 148, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13320, .adv_w = 98, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13343, .adv_w = 156, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13403, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13444, .adv_w = 188, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13498, .adv_w = 124, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13530, .adv_w = 165, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13566, .adv_w = 165, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13618, .adv_w = 128, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13650, .adv_w = 151, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13686, .adv_w = 188, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13731, .adv_w = 164, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13767, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13808, .adv_w = 164, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13844, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13898, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13934, .adv_w = 116, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13966, .adv_w = 135, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14020, .adv_w = 230, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14132, .adv_w = 132, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14173, .adv_w = 168, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 14233, .adv_w = 155, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14269, .adv_w = 229, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14323, .adv_w = 233, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 14407, .adv_w = 167, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14452, .adv_w = 201, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14502, .adv_w = 146, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14538, .adv_w = 214, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14592, .adv_w = 134, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14624, .adv_w = 158, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 14696, .adv_w = 69, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14708, .adv_w = 69, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 14744, .adv_w = 69, .box_w = 5, .box_h = 16, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 14784, .adv_w = 228, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14847, .adv_w = 241, .box_w = 14, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14910, .adv_w = 158, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14969, .adv_w = 155, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15010, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15046, .adv_w = 165, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15082, .adv_w = 126, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15114, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15150, .adv_w = 147, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15191, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15227, .adv_w = 142, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15263, .adv_w = 226, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15326, .adv_w = 165, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15362, .adv_w = 166, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15398, .adv_w = 156, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15439, .adv_w = 162, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15480, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15525, .adv_w = 161, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15566, .adv_w = 161, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15620, .adv_w = 163, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15656, .adv_w = 179, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15701, .adv_w = 179, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15761, .adv_w = 164, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15802, .adv_w = 159, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15843, .adv_w = 149, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15875, .adv_w = 114, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15907, .adv_w = 149, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15943, .adv_w = 110, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15970, .adv_w = 150, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16015, .adv_w = 158, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16056, .adv_w = 149, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16092, .adv_w = 150, .box_w = 9, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16137, .adv_w = 98, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16161, .adv_w = 0, .box_w = 7, .box_h = 3, .ofs_x = -6, .ofs_y = 10},
    {.bitmap_index = 16172, .adv_w = 100, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16195, .adv_w = 100, .box_w = 10, .box_h = 13, .ofs_x = -5, .ofs_y = 0},
    {.bitmap_index = 16260, .adv_w = 0, .box_w = 8, .box_h = 3, .ofs_x = -9, .ofs_y = 10},
    {.bitmap_index = 16272, .adv_w = 0, .box_w = 8, .box_h = 3, .ofs_x = -9, .ofs_y = 10},
    {.bitmap_index = 16284, .adv_w = 0, .box_w = 9, .box_h = 3, .ofs_x = -9, .ofs_y = 10},
    {.bitmap_index = 16298, .adv_w = 0, .box_w = 8, .box_h = 3, .ofs_x = -9, .ofs_y = 10},
    {.bitmap_index = 16310, .adv_w = 0, .box_w = 4, .box_h = 4, .ofs_x = -5, .ofs_y = -4},
    {.bitmap_index = 16318, .adv_w = 0, .box_w = 6, .box_h = 3, .ofs_x = -7, .ofs_y = -4},
    {.bitmap_index = 16327, .adv_w = 79, .box_w = 4, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16345, .adv_w = 154, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16386, .adv_w = 91, .box_w = 7, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 16435, .adv_w = 91, .box_w = 7, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 16484, .adv_w = 91, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16526, .adv_w = 0, .box_w = 7, .box_h = 4, .ofs_x = -8, .ofs_y = 10},
    {.bitmap_index = 16540, .adv_w = 0, .box_w = 2, .box_h = 3, .ofs_x = -3, .ofs_y = 10},
    {.bitmap_index = 16543, .adv_w = 0, .box_w = 6, .box_h = 3, .ofs_x = -6, .ofs_y = 10},
    {.bitmap_index = 16552, .adv_w = 0, .box_w = 5, .box_h = 4, .ofs_x = -5, .ofs_y = 10},
    {.bitmap_index = 16562, .adv_w = 157, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16616, .adv_w = 157, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16675, .adv_w = 157, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16745, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16808, .adv_w = 157, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16876, .adv_w = 157, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16939, .adv_w = 148, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16998, .adv_w = 142, .box_w = 8, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17054, .adv_w = 148, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17124, .adv_w = 148, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17192, .adv_w = 148, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17260, .adv_w = 69, .box_w = 2, .box_h = 15, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17275, .adv_w = 158, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17345, .adv_w = 158, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17408, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17476, .adv_w = 158, .box_w = 9, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17544, .adv_w = 165, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17610, .adv_w = 165, .box_w = 11, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17676, .adv_w = 165, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17748, .adv_w = 165, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 17820, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17868, .adv_w = 157, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17920, .adv_w = 169, .box_w = 11, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17992, .adv_w = 252, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18005, .adv_w = 252, .box_w = 6, .box_h = 4, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 18017, .adv_w = 252, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 18101, .adv_w = 252, .box_w = 11, .box_h = 15, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 18184, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18289, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 18387, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 18485, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 18597, .adv_w = 252, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 18681, .adv_w = 252, .box_w = 9, .box_h = 15, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 18749, .adv_w = 252, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 18821, .adv_w = 252, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 18905, .adv_w = 252, .box_w = 11, .box_h = 13, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 18977, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 19082, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 19194, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19292, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19390, .adv_w = 252, .box_w = 12, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 19468, .adv_w = 252, .box_w = 11, .box_h = 10, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 19523, .adv_w = 252, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19600, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19691, .adv_w = 252, .box_w = 15, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19789, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19887, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 19978, .adv_w = 252, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 20062, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 20167, .adv_w = 252, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 20251, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 20349, .adv_w = 252, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 20440, .adv_w = 252, .box_w = 10, .box_h = 15, .ofs_x = 3, .ofs_y = -2},
    {.bitmap_index = 20515, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 20627, .adv_w = 252, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 20718, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 20816, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 20907, .adv_w = 252, .box_w = 11, .box_h = 11, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 20968, .adv_w = 252, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 21059, .adv_w = 252, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 21143, .adv_w = 252, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21220, .adv_w = 252, .box_w = 12, .box_h = 11, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 21286, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21384, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21489, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21587, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21700, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21805, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 21918, .adv_w = 252, .box_w = 13, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 22003, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 22101, .adv_w = 252, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 22185, .adv_w = 252, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 22270, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22368, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22488, .adv_w = 252, .box_w = 11, .box_h = 11, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 22549, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22647, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22760, .adv_w = 252, .box_w = 9, .box_h = 14, .ofs_x = 5, .ofs_y = -1},
    {.bitmap_index = 22823, .adv_w = 252, .box_w = 10, .box_h = 14, .ofs_x = 4, .ofs_y = -1},
    {.bitmap_index = 22893, .adv_w = 252, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22970, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23068, .adv_w = 252, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23166, .adv_w = 252, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 23238, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23351, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23464, .adv_w = 252, .box_w = 16, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23560, .adv_w = 252, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23644, .adv_w = 252, .box_w = 11, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 23716, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23807, .adv_w = 252, .box_w = 14, .box_h = 12, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 23891, .adv_w = 252, .box_w = 12, .box_h = 11, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 23957, .adv_w = 252, .box_w = 12, .box_h = 9, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 24011, .adv_w = 252, .box_w = 10, .box_h = 10, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 24061, .adv_w = 252, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 24145, .adv_w = 252, .box_w = 9, .box_h = 14, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 24208, .adv_w = 252, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 24312, .adv_w = 252, .box_w = 12, .box_h = 13, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 24390, .adv_w = 252, .box_w = 12, .box_h = 12, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24462, .adv_w = 252, .box_w = 12, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24540, .adv_w = 252, .box_w = 13, .box_h = 13, .ofs_x = 2, .ofs_y = -1},
    {.bitmap_index = 24625, .adv_w = 252, .box_w = 13, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 24645, .adv_w = 252, .box_w = 15, .box_h = 2, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 24660, .adv_w = 252, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 24758, .adv_w = 252, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 24856, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 24954, .adv_w = 252, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 25045, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25150, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25270, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25398, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 25510, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25630, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 25750, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25870, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 25983, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26103, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26223, .adv_w = 252, .box_w = 16, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 26327, .adv_w = 252, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 26418, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26531, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26644, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26757, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26862, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 26975, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27095, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 27215, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27335, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27448, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27568, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 27681, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27809, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 27929, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 28027, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28132, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 28245, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28350, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28455, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 28575, .adv_w = 252, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 28679, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 28784, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 28904, .adv_w = 252, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 29002, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 29115, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29235, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 29355, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29468, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29581, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29694, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29807, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 29920, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30040, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30153, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30281, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30409, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30514, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30627, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 30725, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 30845, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 30958, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31063, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 31168, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31281, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 31394, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31522, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31642, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31762, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 31882, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 32002, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32130, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32250, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 32355, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32468, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32581, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 32686, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 32791, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 32911, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 33016, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 33128, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33241, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 33346, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33459, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33587, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33707, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33827, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 33932, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 34052, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 34172, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34285, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 34397, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 34509, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 34614, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34712, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34832, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 34945, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35065, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35193, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35305, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 35425, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35545, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35673, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35801, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 35929, .adv_w = 252, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 36027, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36140, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 36245, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36373, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36486, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36599, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36712, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36832, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 36952, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37072, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37185, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37305, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37418, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37531, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37651, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37771, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 37891, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38011, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38139, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38259, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38372, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38470, .adv_w = 252, .box_w = 14, .box_h = 15, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 38575, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 38687, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 38807, .adv_w = 252, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 38919, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 39024, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39144, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39257, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39370, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39483, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39603, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39723, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39836, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 39956, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 40061, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40174, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40294, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 40399, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40519, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 40631, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 40743, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 40863, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 40961, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41081, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41194, .adv_w = 252, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 41306, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41411, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41524, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 41644, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41757, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 41877, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 41997, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42125, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 42237, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 42357, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42485, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42613, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42741, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42861, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 42981, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 43086, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43206, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43319, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 43439, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 43551, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43671, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 43799, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 43912, .adv_w = 252, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44040, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44160, .adv_w = 252, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 44296, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44416, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44536, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 44649, .adv_w = 252, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44769, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 44882, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45002, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45115, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45235, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45348, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45468, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45588, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 45693, .adv_w = 252, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 45805, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 45910, .adv_w = 252, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 46030, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 46143, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 46234, .adv_w = 252, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 46319, .adv_w = 252, .box_w = 14, .box_h = 13, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 46410, .adv_w = 252, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 46508, .adv_w = 252, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 46612, .adv_w = 252, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 46710, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 46815, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 46928, .adv_w = 252, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 47041, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 47146, .adv_w = 252, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 47251, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 47349, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 47447, .adv_w = 241, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 47552, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 47636, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 47727, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 47831, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 47935, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 48025, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 48138, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 48243, .adv_w = 241, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 48341, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 48431, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 48515, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 48605, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 48703, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 48794, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 48898, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 49011, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 49131, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 49215, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 49313, .adv_w = 241, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 49418, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 49509, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 49599, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 49703, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 49823, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 49913, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 50033, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 50137, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 50228, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 50312, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50402, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 50507, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 50627, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 50747, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 50831, .adv_w = 241, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 50943, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51033, .adv_w = 241, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 51145, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 51236, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 51320, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51410, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 51530, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 51635, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 51719, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 51824, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 51937, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 52057, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 52155, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 52253, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 52357, .adv_w = 241, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 52469, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 52567, .adv_w = 241, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 52672, .adv_w = 241, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 52770, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 52890, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 53010, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 53115, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53205, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 53325, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 53416, .adv_w = 241, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 53528, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 53626, .adv_w = 241, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 53716, .adv_w = 241, .box_w = 14, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 53828, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 53926, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 54017, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 54107, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 54212, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 54302, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54422, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 54535, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 54633, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54753, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54873, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 54993, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 55077, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 55168, .adv_w = 241, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 55258, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 55371, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 55462, .adv_w = 241, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 55560, .adv_w = 241, .box_w = 13, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 55664, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 55784, .adv_w = 241, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 55882, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 56002, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56093, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56184, .adv_w = 241, .box_w = 14, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 56289, .adv_w = 241, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 56387, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56478, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 56598, .adv_w = 241, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56696, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56794, .adv_w = 241, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56885, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 56969, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57059, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 57143, .adv_w = 241, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 57227, .adv_w = 241, .box_w = 13, .box_h = 15, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 57325, .adv_w = 241, .box_w = 15, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57415, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 57528, .adv_w = 241, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57626, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57731, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 57836, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 57956, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58069, .adv_w = 241, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58182, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58302, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 58407, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58527, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 58632, .adv_w = 241, .box_w = 15, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58752, .adv_w = 241, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 58857, .adv_w = 252, .box_w = 3, .box_h = 13, .ofs_x = 3, .ofs_y = -1},
    {.bitmap_index = 58877, .adv_w = 252, .box_w = 4, .box_h = 6, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 58889, .adv_w = 252, .box_w = 4, .box_h = 10, .ofs_x = 2, .ofs_y = -1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint16_t unicode_list_2[] = {
    0x0, 0x2, 0x4, 0x9, 0xa, 0xc, 0xd, 0xe,
    0x16, 0x18, 0x1c, 0x2e, 0x3b, 0x3e, 0x3f, 0x4e,
    0x56, 0x58, 0x5b, 0x5c, 0x5e, 0x62, 0x6c, 0x77,
    0x79, 0x7b, 0xad, 0x116, 0x118, 0x285, 0x28e, 0x28f,
    0x290, 0x292, 0x294, 0x298, 0x299, 0x29a, 0x29c, 0x29d,
    0x2a0, 0x2a1, 0x2a3, 0x2a4, 0x2a9, 0x2aa, 0x2ab, 0x2ac
};

static const uint16_t unicode_list_4[] = {
    0x0, 0x1, 0x2, 0x3a, 0x3c, 0x44, 0x45, 0x46,
    0x47, 0x4b, 0x4c, 0x4e, 0x50, 0x51, 0x52, 0x53,
    0x54, 0x55, 0x56, 0x57, 0x5b
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x4, 0x8, 0x9, 0xa, 0xb, 0xc,
    0xd, 0x9b3, 0x9b4, 0x9b6, 0x9b9, 0x9ba, 0x9bb, 0x9bc,
    0x9bd, 0x9c5, 0x9c6, 0x9c7, 0x9c8, 0x9c9, 0x9cb, 0x9cc,
    0x9cd, 0x9ce, 0x9d0, 0x9d1, 0x9d2, 0x9d3, 0x9d4, 0x9d5,
    0x9d7, 0x9d9, 0x9dc, 0x9dd, 0x9df, 0x9e0, 0x9e2, 0x9e3,
    0x9e4, 0x9e5, 0x9e6, 0x9e7, 0x9e8, 0x9e9, 0x9ea, 0x9eb,
    0x9f2, 0x9f3, 0x9f4, 0x9f5, 0x9f6, 0x9f9, 0x9fa, 0x9fb,
    0x9fe, 0x1a53, 0x1a55, 0x1a57, 0x1a59, 0x1a5f, 0x1a61, 0x1a6d,
    0x1a6f, 0x1a71, 0x1a75, 0x1a79, 0x1a7d, 0x1a83, 0x1a85, 0x1a89,
    0x1a8b, 0x1a8d, 0x1a8f, 0x1a91, 0x1a95, 0x1a97, 0x1a99, 0x1a9f,
    0x2bb3, 0x2bb4, 0x2bf6, 0x2bf8, 0x2bfa, 0x2bfc, 0x2bfd, 0x2bfe,
    0x2bff, 0x2c01, 0x2c05, 0x2c07, 0x2c09, 0x2c0b, 0x2c0d, 0x2c11,
    0x2c12, 0x2c13, 0x2c15, 0x2c16, 0x2c18, 0x2c19, 0x2c1c, 0x2c1d,
    0x2c20, 0x2c21, 0x2c30, 0x2c31, 0x2c34, 0x2c3c, 0x2c3e, 0x2c44,
    0x2c45, 0x2c54, 0x2c55, 0x2c56, 0x2c58, 0x2c5a, 0x2c5b, 0x2c5d,
    0x2c5f, 0x2c61, 0x2c62, 0x2c67, 0x2c68, 0x2c69, 0x2c6a, 0x2c6b,
    0x2c6d, 0x2c71, 0x2c72, 0x2c75, 0x2c78, 0x2c79, 0x2c7a, 0x2c7b,
    0x2c7d, 0x2c7f, 0x2c82, 0x2c87, 0x2c88, 0x2c89, 0x2c8b, 0x2c90,
    0x2c91, 0x2c92, 0x2c94, 0x2c95, 0x2c97, 0x2c99, 0x2c9b, 0x2c9c,
    0x2c9d, 0x2c9e, 0x2c9f, 0x2ca1, 0x2ca5, 0x2cae, 0x49b2, 0x49bd,
    0x49bf, 0x49df, 0x4a38, 0x4aec, 0x4b00, 0x4b12, 0x4b93, 0x4bcb,
    0x4c4b, 0x4cf7, 0x4cfa, 0x4d17, 0x4d25, 0x4d3f, 0x4dac, 0x4db9,
    0x4dcf, 0x4ddb, 0x4de2, 0x4e52, 0x4e53, 0x4e6b, 0x4e8b, 0x4ec8,
    0x4ef9, 0x4f13, 0x4f7d, 0x4f83, 0x4fa1, 0x4fc0, 0x4fde, 0x4fe1,
    0x4ffc, 0x502f, 0x507f, 0x5101, 0x5111, 0x521a, 0x52da, 0x53e3,
    0x54b9, 0x54d9, 0x54e3, 0x552f, 0x557d, 0x573e, 0x574c, 0x57ad,
    0x57b8, 0x57b9, 0x57bd, 0x57c3, 0x59a4, 0x5a46, 0x5a58, 0x5ab2,
    0x5ac1, 0x5b07, 0x5b37, 0x5b3e, 0x5b8e, 0x5bb3, 0x5c21, 0x5c77,
    0x5cfd, 0x5d7b, 0x5dc3, 0x5dfd, 0x5e1d, 0x5e30, 0x5ef1, 0x5f14,
    0x5f35, 0x5f54, 0x5f57, 0x5f81, 0x5f84, 0x5f8d, 0x6109, 0x6162,
    0x6192, 0x61a8, 0x61f4, 0x62a6, 0x62b1, 0x62b2, 0x62bb, 0x62bd,
    0x62bf, 0x62d1, 0x62de, 0x62ec, 0x6397, 0x6472, 0x64ce, 0x65d3,
    0x6611, 0x6654, 0x6715, 0x6887, 0x68ed, 0x68f3, 0x68fd, 0x6901,
    0x69de, 0x6a32, 0x6a42, 0x6a93, 0x6ab1, 0x6b72, 0x6bc1, 0x6c6b,
    0x6c9f, 0x6cd3, 0x6dfa, 0x6e68, 0x6e72, 0x6f62, 0x6fb0, 0x70da,
    0x70e7, 0x722d, 0x722e, 0x7236, 0x746c, 0x7584, 0x75bf, 0x76fb,
    0x7706, 0x78ad, 0x78cc, 0x78f4, 0x78f6, 0x7913, 0x7923, 0x794c,
    0x7964, 0x7a59, 0x7a76, 0x7a8e, 0x7a91, 0x7b03, 0x7bf8, 0x7c2f,
    0x7caf, 0x83fe, 0x853d, 0x856f, 0x857a, 0x85bc, 0x85dc, 0x85df,
    0x8618, 0x8623, 0x863f, 0x8656, 0x865c, 0x865f, 0x867d, 0x8718,
    0x8770, 0x8771, 0x8787, 0x878f, 0x87a1, 0x87a6, 0x87a9, 0x8879,
    0x88d7, 0x88f6, 0x8937, 0x8965, 0x89a1, 0x8abb, 0x8b2f, 0x8b6e,
    0x8b8d, 0x8b90, 0x8bb3, 0x8bd5, 0x8c06, 0x8cff, 0x8d7f, 0x8d81,
    0x8ee1, 0x90cb, 0x913b, 0x913d, 0x9145, 0x918e, 0x919f, 0x91a0,
    0x92ad, 0x930b, 0x930e, 0x93a5, 0x93b1, 0xa7b2, 0xa7b6, 0xa7c2,
    0xa822, 0xa85e, 0xa862, 0xa86f, 0xa892, 0xa8a7, 0xa8ae, 0xa91e,
    0xa9aa, 0xa9e2, 0xabf6, 0xac4a, 0xacd6, 0xad07, 0xae46, 0xae57,
    0xae7a, 0xae96, 0xaea7, 0xaeb2, 0xaf76, 0xafda, 0xb07a, 0xb08e,
    0xb095, 0xb0db, 0xb3ba, 0xb3d6, 0xb40e, 0xb50a, 0xb51a, 0xb52e,
    0xb55e, 0xb582, 0xb65a, 0xb7ce, 0xb7e2, 0xb836, 0xb8a6, 0xb8ae,
    0xb932, 0xb9f6, 0xbc5e, 0xbc6f, 0xbc73, 0xbc7a, 0xbcce, 0xbcd6,
    0xbce3, 0xbcea, 0xbcfd, 0xbd3e, 0xbd3f, 0xbd53, 0xbdca, 0xbe56,
    0xbe67, 0xbe8e, 0xbe96, 0xc0fa, 0xc177, 0xc178, 0xc182, 0xc1a2,
    0xc1d6, 0xc1f6, 0xc246, 0xc25b, 0xc266, 0xc27e, 0xc2f6, 0xc2fe,
    0xc303, 0xc326, 0xc32a, 0xc337, 0xc352, 0xc3b6, 0xc3c3, 0xc3c7,
    0xc423, 0xc4ae, 0xc4c3, 0xc572, 0xc576, 0xc7f0, 0xc8ba, 0xc90e,
    0xc95b, 0xca0e, 0xca26, 0xca46, 0xcace, 0xcc1e, 0xcc8e, 0xcce2,
    0xcd0e, 0xce6a, 0xced1, 0xceda, 0xd10a, 0xd10e, 0xd112, 0xd11b,
    0xd11d, 0xd13a, 0xd206, 0xd207, 0xd20a, 0xd20e, 0xd276, 0xfab3,
    0xfabe, 0xfacc
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 161, .range_length = 95, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 259, .range_length = 685, .glyph_id_start = 191,
        .unicode_list = unicode_list_2, .glyph_id_ofs_list = NULL, .list_length = 48, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 945, .range_length = 25, .glyph_id_start = 239,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 972, .range_length = 92, .glyph_id_start = 264,
        .unicode_list = unicode_list_4, .glyph_id_ofs_list = NULL, .list_length = 21, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1072, .range_length = 29, .glyph_id_start = 285,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1102, .range_length = 64205, .glyph_id_start = 314,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 474, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] =
{
    0, 0, 0, 1, 0, 0, 0, 0,
    1, 2, 0, 3, 0, 4, 0, 4,
    5, 0, 6, 0, 0, 0, 0, 0,
    7, 0, 0, 8, 8, 0, 0, 0,
    9, 0, 10, 11, 12, 13, 14, 15,
    16, 17, 17, 18, 19, 20, 17, 0,
    13, 21, 22, 23, 24, 25, 26, 27,
    28, 19, 29, 30, 31, 0, 0, 0,
    0, 0, 32, 33, 0, 0, 34, 35,
    0, 36, 37, 38, 39, 40, 36, 36,
    33, 33, 41, 42, 43, 44, 45, 46,
    47, 39, 46, 48, 49, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 50, 0, 0, 51, 0, 0,
    0, 0, 0, 0, 45, 0, 52, 0,
    0, 0, 53, 0, 0, 0, 54, 10,
    10, 10, 10, 10, 10, 14, 12, 14,
    14, 14, 14, 17, 17, 17, 17, 13,
    0, 13, 13, 13, 13, 13, 0, 13,
    26, 26, 26, 26, 29, 55, 56, 32,
    32, 32, 32, 32, 32, 34, 0, 34,
    34, 34, 34, 37, 57, 58, 59, 0,
    36, 33, 33, 33, 33, 33, 0, 33,
    45, 45, 45, 45, 46, 33, 46, 32,
    60, 0, 12, 0, 61, 13, 62, 34,
    34, 0, 37, 61, 20, 63, 33, 42,
    43, 24, 43, 43, 64, 45, 48, 48,
    48, 0, 43, 44, 65, 66, 67, 68,
    65, 69, 66, 69, 0, 70, 69, 65,
    68, 71, 72, 73, 74, 75, 76, 73,
    77, 78, 79, 74, 80, 75, 81, 76,
    82, 83, 0, 78, 84, 85, 86, 85,
    87, 88, 89, 90, 85, 91, 90, 92,
    85, 92, 92, 93, 94, 95, 96, 97,
    98, 97, 93, 99, 93, 93, 100, 93,
    101, 102, 98, 103, 93, 104, 105, 106,
    107, 108, 109, 110, 106, 111, 112, 110,
    112, 112, 112, 113, 111, 113, 114, 107,
    115, 113, 116, 108, 111, 112, 108, 117,
    111, 117, 113, 111, 118, 119, 120, 121,
    117, 117, 122, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] =
{
    0, 0, 0, 1, 0, 0, 0, 0,
    2, 0, 3, 4, 0, 5, 0, 5,
    6, 0, 7, 0, 0, 0, 0, 0,
    8, 0, 9, 10, 10, 0, 0, 0,
    11, 0, 12, 13, 14, 13, 13, 13,
    14, 13, 13, 15, 13, 13, 13, 13,
    14, 13, 14, 13, 16, 17, 18, 19,
    20, 21, 22, 23, 0, 0, 24, 0,
    0, 0, 25, 0, 26, 26, 26, 27,
    28, 29, 30, 31, 29, 32, 33, 33,
    26, 34, 26, 33, 35, 36, 37, 38,
    39, 40, 38, 41, 0, 0, 42, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 43, 0, 0, 44, 0, 0,
    0, 0, 0, 0, 45, 0, 46, 0,
    0, 0, 47, 0, 0, 0, 0, 12,
    12, 12, 12, 12, 12, 48, 14, 13,
    13, 13, 13, 13, 13, 13, 13, 49,
    13, 14, 14, 14, 14, 14, 0, 14,
    18, 18, 18, 18, 22, 13, 27, 50,
    25, 50, 50, 50, 50, 25, 26, 51,
    26, 51, 51, 52, 30, 53, 54, 55,
    33, 51, 26, 51, 51, 51, 0, 26,
    37, 37, 37, 37, 38, 0, 38, 50,
    25, 26, 14, 51, 26, 49, 26, 26,
    51, 28, 30, 32, 13, 56, 51, 0,
    35, 16, 35, 57, 36, 37, 41, 41,
    41, 0, 35, 36, 58, 59, 60, 60,
    60, 60, 59, 60, 60, 61, 60, 62,
    63, 64, 65, 66, 67, 68, 69, 66,
    70, 71, 72, 67, 73, 68, 74, 75,
    45, 76, 45, 71, 77, 66, 78, 79,
    66, 66, 80, 81, 66, 82, 81, 83,
    66, 81, 83, 84, 85, 86, 84, 84,
    84, 0, 84, 84, 84, 84, 87, 84,
    84, 87, 88, 89, 90, 91, 92, 93,
    93, 94, 95, 96, 97, 93, 93, 93,
    98, 93, 93, 95, 93, 99, 95, 100,
    101, 95, 102, 93, 103, 93, 93, 100,
    93, 93, 93, 104, 105, 106, 107, 108,
    98, 93, 109, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] =
{
    -14, -15, 0, 0, -46, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1,
    15, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -41,
    -41, 0, 0, 0, 0, -36, -10, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -31, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -25, 0, 0,
    0, 0, -25, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -41, 0, 0, 0, 0, -25,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, -15, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -26, -26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, -20, -3, -18,
    -10, 0, -21, 0, 0, 0, 0, -5,
    0, 0, 0, 0, -3, 0, 0, 0,
    -5, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -3,
    0, 0, -10, 0, -5, 0, -5, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -15, 0, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, -9, 0, -8, -5,
    -5, -10, -5, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -41, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -15, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, -1, -25, 0, -15,
    0, 1, 1, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -5,
    0, 0, -5, -10, -10, -10, 0, -10,
    0, 0, 0, -10, 0, -10, 0, 0,
    0, -10, 0, 0, -5, -3, -10, -15,
    -10, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, -10, 0, 0, 1,
    -10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -25,
    -25, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5, 0, -15, 0, 0, -20,
    -5, -20, -10, 0, -26, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, -5, 0, 0,
    0, 0, -1, 0, -66, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -51, 0, 0, 0, 0, 0, 0, -15,
    0, 0, 0, 0, -7, 0, -3, -3,
    -13, -5, -10, 0, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -26, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 2,
    0, -9, 0, -8, -5, -5, -10, -5,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -4, 0, 0, -10, -3,
    -5, -3, -7, -10, 0, 0, 0, -5,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, -5, -3, -3, 0, 5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, -3, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 0, 0, -39, 0, 0, 0,
    0, 0, 0, -20, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -20, -15, 0, -15, 0, -5, -5, 0,
    -15, -15, -15, 5, -20, -10, -5, -10,
    -15, 0, -20, 0, 0, 0, -15, -21,
    0, -20, -15, 10, 10, 10, -15, 0,
    -1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -36, 0,
    0, 0, 0, -10, 0, -18, 0, -8,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, -10, -5, 0, -5, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    -10, -16, 0, -10, -5, 10, 10, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -20, 0, 0, 0, 0,
    -10, 0, -10, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    -5, 0, -5, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, -5, -10, 0,
    -10, 0, 5, 5, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -36, 0, 0, 0, 0, -15, 0, -21,
    0, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -26, -15, 0, -15,
    0, -5, 0, 0, -10, -10, -16, 0,
    -10, -10, 0, -10, -10, 0, -21, 0,
    0, 0, -20, -26, 0, -26, -15, 10,
    10, 11, -15, 0, -1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 20, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 11, 11, 11, 0, 0, 0, 0,
    0, 1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 11,
    11, 20, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -15, 0, -5, 0, 0,
    -16, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -3, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -15, 0, -5, -5, -10, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -3, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 0, 16, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 0, 10, 0, 5, 5, 5, 0,
    0, 5, -7, -5, 0, -10, -5, -5,
    -5, -5, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 1, 0, 10, 0, 0,
    0, 0, 0, -7, 0, 11, 11, 11,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -3, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 1, 1, 0,
    0, 0, 0, 0, 0, 0, 1, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 6, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    0, -5, 0, 0, 0, 0, -5, -5,
    0, -5, 0, 0, 0, -5, 0, 0,
    0, 0, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -3, 0, 0, 0, 0, 0, 0,
    -36, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 0,
    0, -23, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -13, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, -8, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -15, 0, -5, -5, -5, -15,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -23, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, -10, 0, 0,
    0, -9, -3, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -13, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, 0, -10, 0, 0, 0, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -7,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 20, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 1, 1, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 1, 1, 20, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, -5,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -41, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -25, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -25, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -20, 0, -10, 0,
    0, -21, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, -20, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -20, -21, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 20,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 20, 0, 0, 0,
    0, 0, -35, 0, 0, 0, 0, 0,
    0, -10, 0, 0, 0, 0, -10, 0,
    -10, -5, -10, -10, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -16, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 0, 0, 0, 0, 0,
    0, 0, 1, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 6, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 1, 1,
    0, 0, 0, 0, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 6, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 5, 0, 6, 1, 0, 6,
    0, 10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 6, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15,
    0, -5, 0, 0, -16, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, -3, -3, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 5, 5, 0, 0,
    -1, 0, 0, 0, 0, -1, 10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -1, -1, 0, -1,
    0, 0, 0, 0, 0, 0, -1, 0,
    0, -1, -1, -1, -1, 0, -1, 0,
    0, 0, 0, 0, 0, -1, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -1, -1, 0, -1, 0,
    0, 0, 0, -1, 0, -1, 0, 0,
    -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, 0, 0, -1, -1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -26, -26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -16,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, -15, -5, 0, 0, 0,
    0, -5, 0, -5, 0, 0, 0, -5,
    0, 0, 0, 0, -10, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -20, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    -10, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 1,
    1, 0, 0, -50, 0, 0, 0, 0,
    0, 0, -25, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -20, 0, -15, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -16, 0, -5, 0, 0, -10, 0,
    -25, -25, -15, -17, -10, -10, -10, -5,
    0, -17, -15, 0, -10, -16, -5, -20,
    -15, -20, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, -5, -9,
    0, -13, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -20, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, -5, -10, 0, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, -13,
    0, -5, -10, 0, -10, -5, 0, -7,
    0, -10, -10, -5, -15, -7, 0, -10,
    -10, -5, -10, -10, -15, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    3, 0, 0, 5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -20, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 5, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, 0, -10,
    0, -10, -5, -3, 0, 0, 0, 0,
    -5, 0, 0, 0, -5, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, -10, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, -10, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -15, -5, -10, -7,
    0, -15, -10, 0, 0, -7, 0, 0,
    0, 0, -10, -10, 0, -10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -15, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, -3,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -20, 0, 0, 0, 0, 0, -5, 0,
    -5, 0, 0, -4, -5, 0, 0, 0,
    0, -5, -3, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, -5, 0, -8, 0, 0, 0, 0,
    0, -7, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -20, 0, -10, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, -5,
    0, 0, 0, -5, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    5, 0, 5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, -5,
    0, 0, 0, -5, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, -5, 0,
    -15, 0, 0, -5, 0, 0, -7, 0,
    0, -10, -5, 0, -7, -12, -5, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -36, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -5, 0,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -26, -26,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -16, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, -5, -15, -10, -15,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, -10, 0, -15, 0, 0, 0,
    0, 0, 0, -15, -15, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -15, 0,
    -8, -10, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, -10,
    -5, -10, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, 0, -10, 0,
    0, 0, 0, 0, 0, 1, 1, 0,
    0, -39, 0, 0, 0, 0, -10, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -20,
    0, 0, 0, -15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -20, -5, 5, 0, 0, -25,
    0, -15, -25, -20, -5, -10, -20, -15,
    0, -10, -10, -15, -15, 0, -5, 10,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, -5, -5, -10, 0, -5, 0, 0,
    -5, 0, 0, 0, 0, -15, -10, 0,
    -15, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, -15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, -9, -10,
    -5, -10, 0, 0, -5, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -51, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -3, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -15, 0, -7, -5, 0, -15, 0,
    0, -18, -5, 0, 0, -18, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, -5, 0, -20,
    0, 0, 1, 1, 0, 0, 0, 0,
    0, 0, -41, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -16, -5, 0, 0, 0,
    -1, 0, -10, -16, -10, 0, 0, -21,
    0, -5, -5, -10, -10, -5, 0, 0,
    10, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -15, 0, -5, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -8, -3,
    0, -5, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -26, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15,
    0, -5, -5, 0, -13, 0, 0, -15,
    0, 0, 0, -10, 0, 0, 0, 0,
    0, 0, 0, 0, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -10, 0,
    -5, 0, 0, 0, 5, 0, 0, 0,
    0, 0, 0, 0, 0, -7, 0, 0,
    0, 0, 15, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -15, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -5,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -5, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -15, 0, 0,
    0, 0, 0, 5, 0, 0, 0, 5,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15,
    0, 0, 0, 0, 0, -5, 0, 0,
    0, -5, 0, -5, -5, -5, -10, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -5, 0, 0, 0,
    0, 0, 5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -23, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -10,
    0, -10, -5, 0, -9, 0, 0, -5,
    -3, 0, 0, -8, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -5, 0, 0, 0, -5, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -20, -20, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -25, 0, -20, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -15,
    -10, 0, -15, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -10, 0, -5, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 1, 1,
    1, 0, 0, 0, 0, 0, 0, 0,
    1, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 10, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 6,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -5, 1, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 1, 1, 1, 1, 0, 0,
    0, 0, 0, 0, 0, 1, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 10, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 6, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 11, 1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 1, 0, 0, 0, 1,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -10, 0, -5, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -3, 0, 0, 0, 0, 0, 0,
    0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes =
{
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 122,
    .right_class_cnt     = 109,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 7,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t font_puhui_basic_16_4 = {
#else
lv_font_t font_puhui_basic_16_4 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 19,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
    .fallback = NULL,
    .user_data = NULL
};



#endif /*#if FONT_PUHUI_BASIC_16_4*/

