/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: CC0-1.0
 */
/*******************************************************************************
 * Size: 26 px
 * Bpp: 4
 * Opts: --bpp 4 --size 26 --no-compress --font MaisonNeue-Book.ttf --range 32-127 --format lvgl -o esp_brookesia_font_maison_neue_book_26.c
 ******************************************************************************/

#ifdef __has_include
#if __has_include("lvgl.h")
#ifndef LV_LVGL_H_INCLUDE_SIMPLE
#define LV_LVGL_H_INCLUDE_SIMPLE
#endif
#endif
#endif

#if defined(LV_LVGL_H_INCLUDE_SIMPLE)
#include "lvgl.h"
#else
#include "lvgl/lvgl.h"
#endif

#ifndef ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_26
#define ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_26 1
#endif

#if ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_26

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xf, 0xf2, 0xf, 0xf2, 0xf, 0xf2, 0xf, 0xf2,
    0xf, 0xf2, 0xf, 0xf2, 0xf, 0xf2, 0xf, 0xf2,
    0xf, 0xf2, 0xf, 0xf2, 0xf, 0xf2, 0xf, 0xf2,
    0xb, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf9,
    0x7f, 0xfa, 0x7f, 0xfa,

    /* U+0022 "\"" */
    0xaf, 0x43, 0xfb, 0xaf, 0x43, 0xfb, 0xaf, 0x43,
    0xfb, 0xaf, 0x43, 0xfb, 0xaf, 0x43, 0xfb, 0x7b,
    0x32, 0xb8,

    /* U+0023 "#" */
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x6f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x9f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x60, 0x0,
    0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0xff, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x2, 0xcc, 0xcd,
    0xff, 0xcc, 0xce, 0xfe, 0xcc, 0xc7, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf5, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x1f, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x2d, 0xdd, 0xdf, 0xfd, 0xdd,
    0xef, 0xfd, 0xdd, 0x80, 0x5f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x8f,
    0x70, 0x0, 0xbf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x40, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x1, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x4, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfc, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x4a, 0xef, 0xfe, 0xb5, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0xff, 0xff, 0xfd, 0x20, 0x0, 0x9f, 0xe7,
    0x12, 0xf3, 0x6e, 0xfe, 0x10, 0xf, 0xf3, 0x0,
    0x2f, 0x20, 0x1e, 0xfa, 0x2, 0xff, 0x0, 0x2,
    0xf2, 0x0, 0x5f, 0xf0, 0xf, 0xf3, 0x0, 0x2f,
    0x20, 0x0, 0x63, 0x0, 0x8f, 0xf7, 0x2, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xff, 0xcf, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x29, 0xef, 0xff, 0xd8,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xdf, 0xff,
    0x90, 0x0, 0x0, 0x0, 0x2, 0xf2, 0x28, 0xff,
    0xc0, 0x25, 0x20, 0x0, 0x2f, 0x20, 0x2, 0xef,
    0x7b, 0xf9, 0x0, 0x2, 0xf2, 0x0, 0x6, 0xfc,
    0x7f, 0xe0, 0x0, 0x2f, 0x20, 0x0, 0x4f, 0xd1,
    0xff, 0xa0, 0x2, 0xf2, 0x0, 0xa, 0xfa, 0x6,
    0xff, 0xd5, 0x4f, 0x21, 0x5b, 0xff, 0x20, 0x5,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x0, 0x1,
    0x7b, 0xef, 0xfe, 0xb7, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x81, 0x0, 0x0, 0x0,

    /* U+0025 "%" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xf1, 0x0, 0x0,
    0x0, 0x3b, 0xef, 0xc5, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x80, 0x0, 0x0, 0x3, 0xff, 0xdd, 0xff,
    0x70, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0, 0x0,
    0xd, 0xf6, 0x0, 0x3f, 0xf2, 0x0, 0x0, 0xe,
    0xf4, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x8f, 0xa0, 0x0, 0x0, 0x0,
    0x5f, 0x90, 0x0, 0x5, 0xfa, 0x0, 0x2, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x3,
    0xfb, 0x0, 0xc, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x5, 0xfa, 0x0, 0x6f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0xa,
    0xf6, 0x1, 0xef, 0x30, 0x4c, 0xff, 0xb3, 0x0,
    0xb, 0xfa, 0x21, 0x7f, 0xf1, 0xa, 0xf9, 0x6,
    0xff, 0xde, 0xff, 0x40, 0x1, 0xdf, 0xff, 0xff,
    0x40, 0x4f, 0xe0, 0x1f, 0xf4, 0x0, 0x6f, 0xe0,
    0x0, 0x7, 0xbb, 0x82, 0x0, 0xdf, 0x50, 0x6f,
    0xa0, 0x0, 0xc, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xfb, 0x0, 0x9f, 0x60, 0x0, 0x9, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf2, 0x0, 0xaf,
    0x50, 0x0, 0x7, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x70, 0x0, 0x9f, 0x60, 0x0, 0x9, 0xf7,
    0x0, 0x0, 0x0, 0x5, 0xfd, 0x0, 0x0, 0x6f,
    0xa0, 0x0, 0xc, 0xf4, 0x0, 0x0, 0x0, 0x1e,
    0xf3, 0x0, 0x0, 0x1f, 0xf4, 0x0, 0x6f, 0xe0,
    0x0, 0x0, 0x0, 0x9f, 0x90, 0x0, 0x0, 0x6,
    0xff, 0xde, 0xff, 0x40, 0x0, 0x0, 0x3, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0x4c, 0xff, 0xb3, 0x0,
    0x0, 0x0, 0xb, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0026 "&" */
    0x0, 0x0, 0x7d, 0xff, 0xc6, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xff, 0xde, 0xff, 0xa0, 0x0, 0x0,
    0x0, 0x9f, 0xd2, 0x0, 0x4f, 0xf5, 0x0, 0x0,
    0x0, 0xdf, 0x40, 0x0, 0x7, 0xfb, 0x0, 0x0,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0xff, 0xfc, 0x10, 0x8, 0xf7, 0x0,
    0x1, 0xdf, 0xa2, 0xbf, 0xe2, 0x8, 0xf7, 0x0,
    0xa, 0xfa, 0x0, 0x9, 0xff, 0x58, 0xf7, 0x0,
    0x2f, 0xe0, 0x0, 0x0, 0x6f, 0xfd, 0xf7, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0x4, 0xef, 0xf7, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0x0, 0x2e, 0xfc, 0x10,
    0x2f, 0xf1, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xd2,
    0xb, 0xfe, 0x50, 0x0, 0x5, 0xef, 0x99, 0xf7,
    0x1, 0xcf, 0xff, 0xee, 0xff, 0xfa, 0x0, 0x40,
    0x0, 0x5, 0xbe, 0xff, 0xda, 0x40, 0x0, 0x0,

    /* U+0027 "'" */
    0xaf, 0x4a, 0xf4, 0xaf, 0x4a, 0xf4, 0xaf, 0x47,
    0xb3,

    /* U+0028 "(" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xe7, 0x0,
    0x0, 0xdf, 0x80, 0x0, 0x9f, 0xb0, 0x0, 0x3f,
    0xf1, 0x0, 0xc, 0xf7, 0x0, 0x3, 0xfe, 0x0,
    0x0, 0xaf, 0x80, 0x0, 0xf, 0xf3, 0x0, 0x3,
    0xff, 0x0, 0x0, 0x6f, 0xc0, 0x0, 0x8, 0xfa,
    0x0, 0x0, 0x9f, 0x90, 0x0, 0xa, 0xf8, 0x0,
    0x0, 0x9f, 0x90, 0x0, 0x8, 0xfa, 0x0, 0x0,
    0x6f, 0xc0, 0x0, 0x2, 0xff, 0x0, 0x0, 0xe,
    0xf4, 0x0, 0x0, 0x9f, 0x90, 0x0, 0x2, 0xff,
    0x10, 0x0, 0xa, 0xf9, 0x0, 0x0, 0x2f, 0xf3,
    0x0, 0x0, 0x7f, 0xd0, 0x0, 0x0, 0xbf, 0x90,
    0x0, 0x1, 0xc5, 0x0, 0x0, 0x0, 0x0,

    /* U+0029 ")" */
    0x0, 0x0, 0x0, 0x0, 0x1d, 0x80, 0x0, 0x0,
    0x1e, 0xf5, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0,
    0x0, 0x9f, 0xb0, 0x0, 0x0, 0xe, 0xf4, 0x0,
    0x0, 0x7, 0xfc, 0x0, 0x0, 0x1, 0xff, 0x20,
    0x0, 0x0, 0xbf, 0x70, 0x0, 0x0, 0x7f, 0xb0,
    0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x1f, 0xf0,
    0x0, 0x0, 0xf, 0xf1, 0x0, 0x0, 0xf, 0xf2,
    0x0, 0x0, 0x1f, 0xf1, 0x0, 0x0, 0x2f, 0xf0,
    0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0, 0x7f, 0xa0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x1, 0xff, 0x10,
    0x0, 0x8, 0xfa, 0x0, 0x0, 0x1f, 0xf3, 0x0,
    0x0, 0xaf, 0x90, 0x0, 0x5, 0xfe, 0x10, 0x0,
    0x2f, 0xf3, 0x0, 0x0, 0xb, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+002A "*" */
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x7,
    0xf3, 0x0, 0x0, 0xc, 0x70, 0x7f, 0x31, 0x99,
    0x2, 0xdf, 0xdb, 0xf9, 0xff, 0xb0, 0x0, 0x7f,
    0xff, 0xfd, 0x50, 0x0, 0x0, 0x8f, 0xff, 0x30,
    0x0, 0x0, 0x5f, 0xd3, 0xfe, 0x10, 0x0, 0x3f,
    0xe1, 0x4, 0xfd, 0x0, 0x4, 0xe3, 0x0, 0x7,
    0xc1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0x2, 0xa6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0xbb, 0xbb,
    0xcf, 0xeb, 0xbb, 0xb8, 0x0, 0x0, 0x3, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf9, 0x0, 0x0, 0x0,

    /* U+002C "," */
    0x9e, 0xe7, 0xaf, 0xf8, 0xaf, 0xf8, 0x6, 0xf5,
    0x5e, 0xd0, 0x35, 0x0,

    /* U+002D "-" */
    0x9e, 0xee, 0xee, 0xe1, 0xaf, 0xff, 0xff, 0xf1,

    /* U+002E "." */
    0xaf, 0xf7, 0xaf, 0xf7, 0xaf, 0xf7,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x40, 0x0, 0x0, 0x0, 0x0, 0xec, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0xdd, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x4c, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x0, 0x7c, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0x2d, 0xff, 0xfe, 0xff, 0xe3, 0x0, 0x0, 0xdf,
    0xb3, 0x0, 0x2a, 0xff, 0x20, 0x9, 0xfb, 0x0,
    0x0, 0x0, 0x9f, 0xc0, 0x1f, 0xf2, 0x0, 0x0,
    0x0, 0xe, 0xf3, 0x6f, 0xb0, 0x0, 0x0, 0x0,
    0x8, 0xf8, 0x9f, 0x70, 0x0, 0x0, 0x0, 0x4,
    0xfc, 0xbf, 0x40, 0x0, 0x0, 0x0, 0x1, 0xfe,
    0xcf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xff, 0xcf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xff, 0xbf, 0x40,
    0x0, 0x0, 0x0, 0x1, 0xfe, 0x9f, 0x70, 0x0,
    0x0, 0x0, 0x4, 0xfc, 0x6f, 0xb0, 0x0, 0x0,
    0x0, 0x8, 0xf8, 0x1f, 0xf2, 0x0, 0x0, 0x0,
    0xe, 0xf3, 0x9, 0xfb, 0x0, 0x0, 0x0, 0x9f,
    0xc0, 0x1, 0xef, 0xb2, 0x0, 0x2a, 0xff, 0x20,
    0x0, 0x2d, 0xff, 0xfe, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x7c, 0xff, 0xd8, 0x10, 0x0,

    /* U+0031 "1" */
    0x0, 0x0, 0x4, 0x30, 0x0, 0x4d, 0xfd, 0x1,
    0x9f, 0xff, 0xd0, 0xef, 0xc5, 0xfd, 0x1f, 0x70,
    0x2f, 0xd0, 0x20, 0x2, 0xfd, 0x0, 0x0, 0x2f,
    0xd0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2, 0xfd,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x2, 0xfd,

    /* U+0032 "2" */
    0x0, 0x3, 0xae, 0xff, 0xc6, 0x0, 0x0, 0x7,
    0xff, 0xfd, 0xef, 0xfc, 0x10, 0x5, 0xff, 0x50,
    0x0, 0x3c, 0xfb, 0x0, 0xef, 0x50, 0x0, 0x0,
    0xe, 0xf3, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x9f,
    0x67, 0xf8, 0x0, 0x0, 0x0, 0xb, 0xf6, 0x2,
    0x10, 0x0, 0x0, 0x2, 0xff, 0x30, 0x0, 0x0,
    0x0, 0x2, 0xdf, 0xb0, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xc1, 0x0, 0x0, 0x0, 0x5d, 0xff, 0x90,
    0x0, 0x0, 0x3, 0xcf, 0xfb, 0x30, 0x0, 0x0,
    0x6, 0xff, 0xc4, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xfe, 0xee, 0xee, 0xee, 0xee, 0x36, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf3,

    /* U+0033 "3" */
    0x0, 0x4, 0xbe, 0xfe, 0xb5, 0x0, 0x0, 0x9,
    0xff, 0xfd, 0xef, 0xfa, 0x0, 0x7, 0xfe, 0x50,
    0x0, 0x4e, 0xf6, 0x0, 0xff, 0x30, 0x0, 0x0,
    0x6f, 0xc0, 0x2c, 0xb0, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xe2, 0x0, 0x0, 0x0,
    0xcc, 0xff, 0xc2, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xfd, 0x40, 0x0, 0x0, 0x0, 0x0, 0x16, 0xef,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x4,
    0x82, 0x0, 0x0, 0x0, 0xc, 0xf3, 0xaf, 0x50,
    0x0, 0x0, 0x0, 0xaf, 0x57, 0xfa, 0x0, 0x0,
    0x0, 0xc, 0xf4, 0x1f, 0xf3, 0x0, 0x0, 0x3,
    0xff, 0x0, 0x8f, 0xe5, 0x0, 0x5, 0xef, 0x90,
    0x0, 0xaf, 0xff, 0xef, 0xff, 0xb0, 0x0, 0x0,
    0x4b, 0xef, 0xeb, 0x50, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x0, 0x1, 0x88, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xcf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x2f, 0xf0, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0xbf, 0x40, 0xf, 0xf0,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x9f, 0x70, 0x0, 0xf, 0xf0, 0x0, 0x3, 0xfd,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0xc, 0xf3, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x6f, 0x90, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0xbf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x9c, 0xcc, 0xcc, 0xcc, 0xcf, 0xfc,
    0xc3, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,

    /* U+0035 "5" */
    0x0, 0xde, 0xee, 0xee, 0xee, 0xe4, 0x0, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0x50, 0x4, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xe2, 0x9d, 0xff, 0xc6, 0x0, 0x3, 0xff, 0xff,
    0xdc, 0xdf, 0xfd, 0x10, 0x6f, 0xfa, 0x20, 0x0,
    0x2c, 0xfc, 0x1, 0x66, 0x0, 0x0, 0x0, 0xd,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x3, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xdc, 0xf6, 0x0, 0x0,
    0x0, 0x6, 0xfa, 0x7f, 0xd1, 0x0, 0x0, 0x1,
    0xef, 0x50, 0xdf, 0xd4, 0x0, 0x4, 0xdf, 0xc0,
    0x2, 0xdf, 0xff, 0xef, 0xff, 0xc1, 0x0, 0x0,
    0x6c, 0xef, 0xeb, 0x60, 0x0,

    /* U+0036 "6" */
    0x0, 0x0, 0x4a, 0xef, 0xea, 0x30, 0x0, 0x0,
    0xa, 0xff, 0xfe, 0xff, 0xf8, 0x0, 0x0, 0xaf,
    0xe5, 0x0, 0x7, 0xff, 0x50, 0x5, 0xfe, 0x20,
    0x0, 0x0, 0x6f, 0xd0, 0xe, 0xf5, 0x0, 0x0,
    0x0, 0xc, 0xa1, 0x4f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x90, 0x3a, 0xef, 0xea, 0x40,
    0x0, 0xbf, 0x68, 0xff, 0xdc, 0xef, 0xf8, 0x0,
    0xcf, 0xbf, 0xa1, 0x0, 0x4, 0xef, 0x70, 0xcf,
    0xfb, 0x0, 0x0, 0x0, 0x3f, 0xf0, 0xcf, 0xf2,
    0x0, 0x0, 0x0, 0xb, 0xf5, 0xaf, 0xf0, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x7f, 0xf0, 0x0, 0x0,
    0x0, 0x9, 0xf7, 0x2f, 0xf3, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0xa, 0xfb, 0x0, 0x0, 0x0, 0x5f,
    0xf0, 0x1, 0xef, 0xb3, 0x0, 0x7, 0xff, 0x60,
    0x0, 0x2e, 0xff, 0xfe, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x7c, 0xef, 0xea, 0x30, 0x0,

    /* U+0037 "7" */
    0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x59, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x1, 0x8d, 0xff, 0xd8, 0x10, 0x0, 0x0,
    0x3e, 0xfe, 0xbb, 0xef, 0xe4, 0x0, 0x0, 0xef,
    0x80, 0x0, 0x8, 0xfe, 0x10, 0x5, 0xfd, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x7, 0xf9, 0x0, 0x0,
    0x0, 0x8f, 0x70, 0x4, 0xfc, 0x0, 0x0, 0x0,
    0xcf, 0x50, 0x0, 0xcf, 0x91, 0x0, 0x19, 0xfd,
    0x0, 0x0, 0x1b, 0xff, 0xdd, 0xff, 0xb1, 0x0,
    0x0, 0x2b, 0xff, 0xff, 0xff, 0xc2, 0x0, 0x2,
    0xef, 0xa3, 0x11, 0x3a, 0xff, 0x30, 0xc, 0xf6,
    0x0, 0x0, 0x0, 0x6f, 0xd0, 0x2f, 0xd0, 0x0,
    0x0, 0x0, 0xd, 0xf3, 0x4f, 0xb0, 0x0, 0x0,
    0x0, 0xa, 0xf5, 0x4f, 0xc0, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0xf, 0xf4, 0x0, 0x0, 0x0, 0x3f,
    0xf1, 0x8, 0xff, 0x71, 0x0, 0x17, 0xff, 0x90,
    0x0, 0x9f, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x3, 0xad, 0xff, 0xda, 0x40, 0x0,

    /* U+0039 "9" */
    0x0, 0x1, 0x7c, 0xff, 0xd9, 0x10, 0x0, 0x0,
    0x3e, 0xff, 0xdd, 0xff, 0xf5, 0x0, 0x1, 0xef,
    0x91, 0x0, 0x8, 0xff, 0x30, 0x9, 0xfa, 0x0,
    0x0, 0x0, 0x7f, 0xc0, 0xe, 0xf2, 0x0, 0x0,
    0x0, 0xf, 0xf2, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0xc, 0xf6, 0xf, 0xf0, 0x0, 0x0, 0x0, 0xc,
    0xf8, 0xe, 0xf3, 0x0, 0x0, 0x0, 0xf, 0xfa,
    0x9, 0xfb, 0x0, 0x0, 0x0, 0x9f, 0xfa, 0x1,
    0xef, 0xc4, 0x0, 0x3a, 0xff, 0xf9, 0x0, 0x3e,
    0xff, 0xff, 0xff, 0xb8, 0xf8, 0x0, 0x0, 0x6a,
    0xcc, 0xa5, 0x9, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf4, 0x1, 0x99, 0x0, 0x0, 0x0,
    0x1f, 0xf0, 0x0, 0xef, 0x30, 0x0, 0x0, 0x8f,
    0xa0, 0x0, 0x7f, 0xe4, 0x0, 0x7, 0xff, 0x20,
    0x0, 0x9, 0xff, 0xed, 0xff, 0xf5, 0x0, 0x0,
    0x0, 0x5b, 0xff, 0xea, 0x20, 0x0,

    /* U+003A ":" */
    0xaf, 0xf7, 0xaf, 0xf7, 0xaf, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0xf7, 0xaf, 0xf7, 0xaf, 0xf7,

    /* U+003B ";" */
    0x9f, 0xf8, 0x9f, 0xf8, 0x9f, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9e, 0xe7, 0xaf, 0xf8, 0xaf, 0xf8,
    0x6, 0xf5, 0x5e, 0xd0, 0x35, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xb0, 0x0, 0x0,
    0x0, 0x1, 0x9f, 0xf7, 0x0, 0x0, 0x0, 0x6e,
    0xff, 0x70, 0x0, 0x0, 0x3c, 0xff, 0xa1, 0x0,
    0x0, 0x19, 0xff, 0xc3, 0x0, 0x0, 0x6, 0xff,
    0xe6, 0x0, 0x0, 0x0, 0x6f, 0xf9, 0x10, 0x0,
    0x0, 0x0, 0x6f, 0xf9, 0x10, 0x0, 0x0, 0x0,
    0x6, 0xef, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x19,
    0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x3c, 0xff,
    0xa1, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x1, 0x9f, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xa0,

    /* U+003D "=" */
    0x5d, 0xdd, 0xdd, 0xdd, 0xdd, 0xda, 0x6f, 0xff,
    0xff, 0xff, 0xff, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xdd,
    0xdd, 0xdd, 0xdd, 0xda, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xfd,

    /* U+003E ">" */
    0x8, 0x60, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xfc,
    0x30, 0x0, 0x0, 0x0, 0x4, 0xdf, 0xf9, 0x10,
    0x0, 0x0, 0x0, 0x6, 0xef, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x19, 0xff, 0xc3, 0x0, 0x0, 0x0,
    0x0, 0x3c, 0xff, 0xa1, 0x0, 0x0, 0x0, 0x0,
    0x6e, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xfb,
    0x0, 0x0, 0x0, 0x3c, 0xff, 0x91, 0x0, 0x0,
    0x1a, 0xff, 0xc3, 0x0, 0x0, 0x7, 0xff, 0xe6,
    0x0, 0x0, 0x4, 0xdf, 0xf9, 0x10, 0x0, 0x0,
    0x2f, 0xfc, 0x30, 0x0, 0x0, 0x0, 0x8, 0x50,
    0x0, 0x0, 0x0, 0x0,

    /* U+003F "?" */
    0x0, 0x1, 0x8d, 0xff, 0xd7, 0x0, 0x0, 0x5,
    0xff, 0xff, 0xff, 0xfd, 0x10, 0x3, 0xff, 0xc4,
    0x11, 0x5d, 0xfc, 0x0, 0xbf, 0xc0, 0x0, 0x0,
    0x2f, 0xf3, 0xf, 0xf4, 0x0, 0x0, 0x0, 0xef,
    0x41, 0xba, 0x0, 0x0, 0x0, 0xf, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0xff, 0x30, 0x0, 0x0, 0x0, 0x6f,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x6f, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x22,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xff, 0x80, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x0, 0x4, 0x67, 0x65, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x9f, 0xff, 0xff, 0xff,
    0xb3, 0x0, 0x0, 0x0, 0x4, 0xef, 0x94, 0x10,
    0x13, 0x8e, 0xf7, 0x0, 0x0, 0x3, 0xfd, 0x20,
    0x0, 0x0, 0x0, 0x1b, 0xf7, 0x0, 0x0, 0xee,
    0x10, 0x1, 0x79, 0x83, 0x0, 0xc, 0xf2, 0x0,
    0x8f, 0x40, 0x2, 0xef, 0xff, 0xf6, 0x0, 0x2f,
    0xa0, 0xe, 0xc0, 0x0, 0xcf, 0x70, 0x2e, 0xf1,
    0x0, 0xbf, 0x2, 0xf8, 0x0, 0xc, 0xb0, 0x0,
    0xbf, 0x30, 0x6, 0xf4, 0x4f, 0x50, 0x0, 0x0,
    0x5, 0xbf, 0xf4, 0x0, 0x4f, 0x56, 0xf3, 0x0,
    0x0, 0x9f, 0xfe, 0xcf, 0x40, 0x3, 0xf6, 0x5f,
    0x40, 0x0, 0xcf, 0xc5, 0x9, 0xf4, 0x0, 0x4f,
    0x54, 0xf5, 0x0, 0x2f, 0xc0, 0x0, 0x9f, 0x40,
    0x7, 0xf3, 0x1f, 0x90, 0x2, 0xfb, 0x0, 0xe,
    0xf7, 0x0, 0xcf, 0x0, 0xce, 0x0, 0xd, 0xfb,
    0x9e, 0xfe, 0xf9, 0xcf, 0x70, 0x6, 0xf7, 0x0,
    0x2a, 0xef, 0xc3, 0x3d, 0xfe, 0x70, 0x0, 0xc,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xf8, 0x10, 0x0, 0x0, 0x4, 0x40,
    0x0, 0x0, 0x0, 0x1a, 0xff, 0xc9, 0x89, 0xbe,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x3, 0x8c, 0xef,
    0xfd, 0xa5, 0x0, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x0, 0x8f, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfe, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf5, 0xef, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x8f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xa0, 0x3f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x40, 0xd, 0xf1, 0x0, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x7, 0xf7, 0x0, 0x0,
    0x0, 0x6, 0xf9, 0x0, 0x2, 0xfd, 0x0, 0x0,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x2f, 0xe0, 0x0, 0x0, 0x6f, 0x90, 0x0,
    0x0, 0x8f, 0x80, 0x0, 0x0, 0x1f, 0xe0, 0x0,
    0x0, 0xdf, 0xed, 0xdd, 0xdd, 0xdf, 0xf4, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x9, 0xf7, 0x0, 0x0, 0x0, 0x1, 0xff, 0x0,
    0xf, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x50,
    0x5f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xb0,
    0xbf, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf1,

    /* U+0042 "B" */
    0xcf, 0xff, 0xff, 0xff, 0xd9, 0x20, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0xcf, 0x60,
    0x0, 0x1, 0x4c, 0xfe, 0x0, 0xcf, 0x60, 0x0,
    0x0, 0x1, 0xef, 0x50, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0xbf, 0x70, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0xbf, 0x70, 0xcf, 0x60, 0x0, 0x0, 0x1, 0xef,
    0x30, 0xcf, 0x60, 0x0, 0x1, 0x4c, 0xfb, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xb0, 0x0, 0xcf,
    0xee, 0xee, 0xee, 0xff, 0xf8, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x5, 0xef, 0x70, 0xcf, 0x60, 0x0,
    0x0, 0x0, 0x4f, 0xf0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0xf, 0xf2, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0xf, 0xf2, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x5f,
    0xf0, 0xcf, 0x60, 0x0, 0x0, 0x28, 0xff, 0x80,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xda, 0x40, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x39, 0xdf, 0xfd, 0x81, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0xbf, 0xf8, 0x20, 0x4, 0xbf, 0xf5, 0x0, 0x6f,
    0xf3, 0x0, 0x0, 0x0, 0x9f, 0xe1, 0xe, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x65, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfb, 0x9f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x24, 0x1b, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xb7, 0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xb0, 0xef, 0x60, 0x0, 0x0, 0x0, 0xe,
    0xf6, 0x7, 0xff, 0x30, 0x0, 0x0, 0x9, 0xfe,
    0x10, 0xb, 0xff, 0x82, 0x1, 0x4b, 0xff, 0x60,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x4, 0xad, 0xff, 0xd9, 0x20, 0x0,

    /* U+0044 "D" */
    0xcf, 0xff, 0xff, 0xfd, 0x92, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0x80, 0x0, 0xcf, 0x60,
    0x0, 0x14, 0xaf, 0xfa, 0x0, 0xcf, 0x60, 0x0,
    0x0, 0x5, 0xff, 0x50, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x7f, 0xd0, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0xf, 0xf4, 0xcf, 0x60, 0x0, 0x0, 0x0, 0xb,
    0xf7, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x8, 0xfa,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x6, 0xfb, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x7, 0xfb, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x8, 0xfa, 0xcf, 0x60, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0xe, 0xf5, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0x6f, 0xf0, 0xcf, 0x60, 0x0, 0x0, 0x3, 0xff,
    0x80, 0xcf, 0x60, 0x0, 0x13, 0x9f, 0xfc, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x0, 0xcf,
    0xff, 0xff, 0xfd, 0x93, 0x0, 0x0,

    /* U+0045 "E" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xf2, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0x60, 0xcf, 0xee,
    0xee, 0xee, 0xee, 0x60, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf2, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xf2,

    /* U+0046 "F" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xee, 0xee, 0xee, 0xee, 0x60, 0xcf, 0xff,
    0xff, 0xff, 0xff, 0x70, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x0, 0x4a, 0xdf, 0xfd, 0x81, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0xbf, 0xf8, 0x20, 0x3, 0xbf, 0xf5, 0x0, 0x7f,
    0xf3, 0x0, 0x0, 0x0, 0x9f, 0xf1, 0xe, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x75, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xe8, 0x9f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0xe,
    0xff, 0xff, 0xfd, 0xbf, 0x60, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xc9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfc, 0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xa0, 0xef, 0x60, 0x0, 0x0, 0x0, 0xc,
    0xf6, 0x7, 0xff, 0x30, 0x0, 0x0, 0x7, 0xfe,
    0x0, 0xb, 0xff, 0x83, 0x1, 0x3a, 0xff, 0x50,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0x4, 0xad, 0xff, 0xd8, 0x20, 0x0,

    /* U+0048 "H" */
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x6f, 0xbc, 0xf6,
    0x0, 0x0, 0x0, 0x6, 0xfb, 0xcf, 0x60, 0x0,
    0x0, 0x0, 0x6f, 0xbc, 0xf6, 0x0, 0x0, 0x0,
    0x6, 0xfb, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x6f,
    0xbc, 0xf6, 0x0, 0x0, 0x0, 0x6, 0xfb, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x6f, 0xbc, 0xf6, 0x0,
    0x0, 0x0, 0x6, 0xfb, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xbc, 0xfe, 0xdd, 0xdd, 0xdd, 0xde,
    0xfb, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x6f, 0xbc,
    0xf6, 0x0, 0x0, 0x0, 0x6, 0xfb, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x6f, 0xbc, 0xf6, 0x0, 0x0,
    0x0, 0x6, 0xfb, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0x6f, 0xbc, 0xf6, 0x0, 0x0, 0x0, 0x6, 0xfb,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x6f, 0xbc, 0xf6,
    0x0, 0x0, 0x0, 0x6, 0xfb,

    /* U+0049 "I" */
    0xcf, 0x6c, 0xf6, 0xcf, 0x6c, 0xf6, 0xcf, 0x6c,
    0xf6, 0xcf, 0x6c, 0xf6, 0xcf, 0x6c, 0xf6, 0xcf,
    0x6c, 0xf6, 0xcf, 0x6c, 0xf6, 0xcf, 0x6c, 0xf6,
    0xcf, 0x6c, 0xf6,

    /* U+004A "J" */
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf7,
    0x5, 0x60, 0x0, 0x0, 0xc, 0xf7, 0x1f, 0xf0,
    0x0, 0x0, 0xe, 0xf5, 0xe, 0xf6, 0x0, 0x0,
    0x4f, 0xf1, 0x8, 0xff, 0x61, 0x4, 0xef, 0xa0,
    0x0, 0xcf, 0xff, 0xff, 0xfd, 0x10, 0x0, 0x7,
    0xcf, 0xfd, 0x70, 0x0,

    /* U+004B "K" */
    0xcf, 0x60, 0x0, 0x0, 0x4, 0xff, 0x60, 0xcf,
    0x60, 0x0, 0x0, 0x2e, 0xf8, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0xdf, 0xb0, 0x0, 0xcf, 0x60, 0x0,
    0xb, 0xfc, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x8f,
    0xe1, 0x0, 0x0, 0xcf, 0x60, 0x6, 0xff, 0x30,
    0x0, 0x0, 0xcf, 0x60, 0x3f, 0xf5, 0x0, 0x0,
    0x0, 0xcf, 0x62, 0xef, 0x70, 0x0, 0x0, 0x0,
    0xcf, 0x6d, 0xff, 0x80, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xdf, 0xf4, 0x0, 0x0, 0x0, 0xcf, 0xfd,
    0x18, 0xfe, 0x10, 0x0, 0x0, 0xcf, 0xe2, 0x0,
    0xcf, 0xb0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x2f,
    0xf7, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x6, 0xff,
    0x30, 0x0, 0xcf, 0x60, 0x0, 0x0, 0xbf, 0xe1,
    0x0, 0xcf, 0x60, 0x0, 0x0, 0x1e, 0xfa, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x4, 0xff, 0x60, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x8f, 0xf2,

    /* U+004C "L" */
    0xcf, 0x60, 0x0, 0x0, 0x0, 0xc, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0xc, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0xc, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0xc, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0xc, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0xc,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0,
    0x0, 0x0, 0xc, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0x9c, 0xff, 0xff,
    0xff, 0xff, 0xf9,

    /* U+004D "M" */
    0xcf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xfd, 0xcf, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xfd, 0xcf, 0xff, 0x20, 0x0, 0x0, 0x0,
    0x1, 0xff, 0xfd, 0xcf, 0xef, 0x80, 0x0, 0x0,
    0x0, 0x7, 0xfe, 0xfd, 0xcf, 0x7f, 0xe0, 0x0,
    0x0, 0x0, 0xe, 0xf7, 0xfd, 0xcf, 0x6b, 0xf5,
    0x0, 0x0, 0x0, 0x5f, 0xb5, 0xfd, 0xcf, 0x64,
    0xfc, 0x0, 0x0, 0x0, 0xbf, 0x45, 0xfd, 0xcf,
    0x60, 0xdf, 0x30, 0x0, 0x2, 0xfd, 0x5, 0xfd,
    0xcf, 0x60, 0x6f, 0x90, 0x0, 0x8, 0xf7, 0x5,
    0xfd, 0xcf, 0x60, 0xf, 0xf0, 0x0, 0xe, 0xf1,
    0x5, 0xfd, 0xcf, 0x60, 0x9, 0xf6, 0x0, 0x6f,
    0x90, 0x5, 0xfd, 0xcf, 0x60, 0x2, 0xfd, 0x0,
    0xcf, 0x30, 0x5, 0xfd, 0xcf, 0x60, 0x0, 0xcf,
    0x43, 0xfc, 0x0, 0x5, 0xfd, 0xcf, 0x60, 0x0,
    0x5f, 0xaa, 0xf5, 0x0, 0x5, 0xfd, 0xcf, 0x60,
    0x0, 0xe, 0xff, 0xe0, 0x0, 0x5, 0xfd, 0xcf,
    0x60, 0x0, 0x7, 0xff, 0x80, 0x0, 0x5, 0xfd,
    0xcf, 0x60, 0x0, 0x1, 0xff, 0x10, 0x0, 0x5,
    0xfd, 0xcf, 0x60, 0x0, 0x0, 0xaa, 0x0, 0x0,
    0x5, 0xfd,

    /* U+004E "N" */
    0xcf, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xf3, 0xcf,
    0xf9, 0x0, 0x0, 0x0, 0xe, 0xf3, 0xcf, 0xff,
    0x20, 0x0, 0x0, 0xe, 0xf3, 0xcf, 0xdf, 0xb0,
    0x0, 0x0, 0xe, 0xf3, 0xcf, 0x6e, 0xf4, 0x0,
    0x0, 0xe, 0xf3, 0xcf, 0x65, 0xfd, 0x0, 0x0,
    0xe, 0xf3, 0xcf, 0x60, 0xcf, 0x60, 0x0, 0xe,
    0xf3, 0xcf, 0x60, 0x3f, 0xe1, 0x0, 0xe, 0xf3,
    0xcf, 0x60, 0xa, 0xf8, 0x0, 0xe, 0xf3, 0xcf,
    0x60, 0x2, 0xff, 0x20, 0xe, 0xf3, 0xcf, 0x60,
    0x0, 0x8f, 0xa0, 0xe, 0xf3, 0xcf, 0x60, 0x0,
    0xe, 0xf3, 0xe, 0xf3, 0xcf, 0x60, 0x0, 0x6,
    0xfc, 0xe, 0xf3, 0xcf, 0x60, 0x0, 0x0, 0xdf,
    0x5e, 0xf3, 0xcf, 0x60, 0x0, 0x0, 0x4f, 0xef,
    0xf3, 0xcf, 0x60, 0x0, 0x0, 0xb, 0xff, 0xf3,
    0xcf, 0x60, 0x0, 0x0, 0x2, 0xff, 0xf3, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x9f, 0xf3,

    /* U+004F "O" */
    0x0, 0x0, 0x3a, 0xdf, 0xec, 0x81, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0xbf, 0xf8, 0x20, 0x14, 0xbf, 0xf6, 0x0,
    0x6, 0xff, 0x30, 0x0, 0x0, 0x7, 0xff, 0x20,
    0xe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x90,
    0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf0,
    0x9f, 0x90, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf4,
    0xbf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf6,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf7,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf7,
    0xbf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf6,
    0x9f, 0x90, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xf0,
    0xe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x90,
    0x6, 0xff, 0x30, 0x0, 0x0, 0x8, 0xff, 0x20,
    0x0, 0xbf, 0xf8, 0x30, 0x14, 0xbf, 0xf6, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x3a, 0xdf, 0xfd, 0x81, 0x0, 0x0,

    /* U+0050 "P" */
    0xcf, 0xff, 0xff, 0xff, 0xeb, 0x40, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xcf, 0x60,
    0x0, 0x0, 0x27, 0xff, 0x80, 0xcf, 0x60, 0x0,
    0x0, 0x0, 0x5f, 0xf0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0xe, 0xf3, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0xd, 0xf5, 0xcf, 0x60, 0x0, 0x0, 0x0, 0xf,
    0xf4, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xf0,
    0xcf, 0x60, 0x0, 0x0, 0x27, 0xff, 0x90, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0xcf, 0xff,
    0xff, 0xff, 0xeb, 0x50, 0x0, 0xcf, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x0, 0x3a, 0xdf, 0xec, 0x81, 0x0, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0,
    0x0, 0xbf, 0xf8, 0x20, 0x14, 0xbf, 0xf6, 0x0,
    0x6, 0xff, 0x30, 0x0, 0x0, 0x7, 0xff, 0x20,
    0xe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xa0,
    0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xf0,
    0x9f, 0x90, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf4,
    0xbf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf6,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf7,
    0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf7,
    0xbf, 0x60, 0x0, 0x1, 0xb3, 0x0, 0xb, 0xf6,
    0x9f, 0x90, 0x0, 0x5, 0xff, 0x30, 0xe, 0xf3,
    0x5f, 0xe0, 0x0, 0x0, 0x5f, 0xe3, 0x3f, 0xf0,
    0xe, 0xf6, 0x0, 0x0, 0x5, 0xfe, 0xcf, 0x90,
    0x6, 0xff, 0x30, 0x0, 0x0, 0x5f, 0xff, 0x10,
    0x0, 0xbf, 0xf8, 0x30, 0x14, 0xbf, 0xfe, 0x20,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xfe, 0x9f, 0xe1,
    0x0, 0x0, 0x3a, 0xdf, 0xfc, 0x81, 0x6, 0x90,

    /* U+0052 "R" */
    0xcf, 0xff, 0xff, 0xff, 0xd9, 0x20, 0xc, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x50, 0xcf, 0x60, 0x0,
    0x1, 0x4b, 0xff, 0x3c, 0xf6, 0x0, 0x0, 0x0,
    0xc, 0xfa, 0xcf, 0x60, 0x0, 0x0, 0x0, 0x5f,
    0xdc, 0xf6, 0x0, 0x0, 0x0, 0x4, 0xfe, 0xcf,
    0x60, 0x0, 0x0, 0x0, 0x5f, 0xcc, 0xf6, 0x0,
    0x0, 0x0, 0xc, 0xf8, 0xcf, 0x60, 0x0, 0x0,
    0x4b, 0xfe, 0x1c, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x10, 0xcf, 0xff, 0xff, 0xff, 0xb3, 0x0, 0xc,
    0xf6, 0x0, 0xb, 0xfd, 0x0, 0x0, 0xcf, 0x60,
    0x0, 0x2f, 0xf6, 0x0, 0xc, 0xf6, 0x0, 0x0,
    0x9f, 0xe0, 0x0, 0xcf, 0x60, 0x0, 0x1, 0xff,
    0x70, 0xc, 0xf6, 0x0, 0x0, 0x8, 0xff, 0x10,
    0xcf, 0x60, 0x0, 0x0, 0xe, 0xf8, 0xc, 0xf6,
    0x0, 0x0, 0x0, 0x6f, 0xf2,

    /* U+0053 "S" */
    0x0, 0x0, 0x5b, 0xef, 0xec, 0x70, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xff, 0xff, 0xe3, 0x0, 0x0,
    0xaf, 0xf7, 0x20, 0x15, 0xdf, 0xf2, 0x0, 0x1f,
    0xf4, 0x0, 0x0, 0x1, 0xdf, 0xb0, 0x2, 0xff,
    0x0, 0x0, 0x0, 0x4, 0xff, 0x10, 0x1f, 0xf3,
    0x0, 0x0, 0x0, 0x6, 0x30, 0x0, 0xaf, 0xe6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xfe,
    0x94, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0xff,
    0xfe, 0x92, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5a,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x7f, 0xfb, 0x0, 0x36, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xf5, 0xf, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xa0, 0xcf, 0x90, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x5, 0xff, 0x40, 0x0, 0x0, 0x0, 0xcf,
    0x80, 0xb, 0xff, 0x93, 0x10, 0x25, 0xcf, 0xf2,
    0x0, 0xa, 0xff, 0xff, 0xff, 0xff, 0xe4, 0x0,
    0x0, 0x3, 0x9d, 0xff, 0xec, 0x71, 0x0,

    /* U+0054 "T" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x61,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x0,
    0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x0,

    /* U+0055 "U" */
    0xef, 0x30, 0x0, 0x0, 0x0, 0xf, 0xf2, 0xef,
    0x30, 0x0, 0x0, 0x0, 0xf, 0xf2, 0xef, 0x30,
    0x0, 0x0, 0x0, 0xf, 0xf2, 0xef, 0x30, 0x0,
    0x0, 0x0, 0xf, 0xf2, 0xef, 0x30, 0x0, 0x0,
    0x0, 0xf, 0xf2, 0xef, 0x30, 0x0, 0x0, 0x0,
    0xf, 0xf2, 0xef, 0x30, 0x0, 0x0, 0x0, 0xf,
    0xf2, 0xef, 0x30, 0x0, 0x0, 0x0, 0xf, 0xf2,
    0xef, 0x30, 0x0, 0x0, 0x0, 0xf, 0xf2, 0xef,
    0x30, 0x0, 0x0, 0x0, 0xf, 0xf2, 0xef, 0x30,
    0x0, 0x0, 0x0, 0xf, 0xf2, 0xef, 0x30, 0x0,
    0x0, 0x0, 0xf, 0xf1, 0xdf, 0x40, 0x0, 0x0,
    0x0, 0x1f, 0xf1, 0xbf, 0x80, 0x0, 0x0, 0x0,
    0x5f, 0xf0, 0x7f, 0xe1, 0x0, 0x0, 0x0, 0xcf,
    0xa0, 0xe, 0xfe, 0x51, 0x1, 0x5c, 0xff, 0x20,
    0x3, 0xef, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x17, 0xce, 0xff, 0xc8, 0x10, 0x0,

    /* U+0056 "V" */
    0xbf, 0x90, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf5,
    0x5f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xe0,
    0xe, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x90,
    0x9, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xff, 0x30,
    0x3, 0xff, 0x0, 0x0, 0x0, 0x5, 0xfd, 0x0,
    0x0, 0xdf, 0x50, 0x0, 0x0, 0xa, 0xf8, 0x0,
    0x0, 0x8f, 0xb0, 0x0, 0x0, 0x1f, 0xf2, 0x0,
    0x0, 0x2f, 0xf1, 0x0, 0x0, 0x6f, 0xc0, 0x0,
    0x0, 0xc, 0xf6, 0x0, 0x0, 0xcf, 0x60, 0x0,
    0x0, 0x6, 0xfc, 0x0, 0x1, 0xff, 0x10, 0x0,
    0x0, 0x1, 0xff, 0x20, 0x7, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x70, 0xd, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xd0, 0x3f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf3, 0x8f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0xef, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0xf2, 0x0, 0x0, 0x0,

    /* U+0057 "W" */
    0x6f, 0xd0, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0,
    0x0, 0xd, 0xf5, 0x3f, 0xf0, 0x0, 0x0, 0x8,
    0xff, 0x70, 0x0, 0x0, 0xf, 0xf2, 0xf, 0xf3,
    0x0, 0x0, 0xd, 0xff, 0xc0, 0x0, 0x0, 0x3f,
    0xf0, 0xd, 0xf5, 0x0, 0x0, 0x2f, 0xff, 0xf1,
    0x0, 0x0, 0x6f, 0xc0, 0xa, 0xf8, 0x0, 0x0,
    0x6f, 0xab, 0xf6, 0x0, 0x0, 0x9f, 0x90, 0x7,
    0xfb, 0x0, 0x0, 0xbf, 0x56, 0xfa, 0x0, 0x0,
    0xcf, 0x60, 0x4, 0xfe, 0x0, 0x1, 0xff, 0x11,
    0xff, 0x0, 0x0, 0xff, 0x30, 0x1, 0xff, 0x10,
    0x5, 0xfb, 0x0, 0xcf, 0x40, 0x2, 0xff, 0x0,
    0x0, 0xef, 0x40, 0xa, 0xf6, 0x0, 0x7f, 0x90,
    0x5, 0xfd, 0x0, 0x0, 0xbf, 0x70, 0xf, 0xf1,
    0x0, 0x2f, 0xe0, 0x8, 0xfa, 0x0, 0x0, 0x8f,
    0xa0, 0x4f, 0xc0, 0x0, 0xd, 0xf3, 0xa, 0xf7,
    0x0, 0x0, 0x5f, 0xd0, 0x9f, 0x80, 0x0, 0x8,
    0xf8, 0xd, 0xf4, 0x0, 0x0, 0x2f, 0xf0, 0xef,
    0x30, 0x0, 0x3, 0xfd, 0xf, 0xf1, 0x0, 0x0,
    0xf, 0xf6, 0xfe, 0x0, 0x0, 0x0, 0xef, 0x6f,
    0xe0, 0x0, 0x0, 0xc, 0xfd, 0xf9, 0x0, 0x0,
    0x0, 0x9f, 0xdf, 0xb0, 0x0, 0x0, 0x9, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x4f, 0xff, 0x80, 0x0,
    0x0, 0x6, 0xff, 0xf0, 0x0, 0x0, 0x0, 0xf,
    0xff, 0x50, 0x0, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0x20, 0x0,

    /* U+0058 "X" */
    0x4f, 0xf3, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x0,
    0xaf, 0xc0, 0x0, 0x0, 0x6, 0xff, 0x10, 0x1,
    0xff, 0x60, 0x0, 0x1, 0xef, 0x70, 0x0, 0x6,
    0xfe, 0x10, 0x0, 0x9f, 0xd0, 0x0, 0x0, 0xc,
    0xf9, 0x0, 0x3f, 0xf3, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0xc, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0xc5, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xfd, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf9, 0x3f, 0xf2,
    0x0, 0x0, 0x0, 0x5, 0xfe, 0x10, 0x9f, 0xb0,
    0x0, 0x0, 0x0, 0xef, 0x60, 0x1, 0xff, 0x50,
    0x0, 0x0, 0x9f, 0xd0, 0x0, 0x7, 0xfe, 0x10,
    0x0, 0x3f, 0xf4, 0x0, 0x0, 0xd, 0xf9, 0x0,
    0xc, 0xfa, 0x0, 0x0, 0x0, 0x4f, 0xf3, 0x6,
    0xff, 0x10, 0x0, 0x0, 0x0, 0xaf, 0xc0,

    /* U+0059 "Y" */
    0xbf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x92,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x7f, 0xe1, 0x7,
    0xfe, 0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0, 0xd,
    0xf8, 0x0, 0x0, 0xa, 0xfc, 0x0, 0x0, 0x4f,
    0xf2, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0xaf,
    0xb0, 0x0, 0xcf, 0x80, 0x0, 0x0, 0x1, 0xff,
    0x40, 0x6f, 0xe0, 0x0, 0x0, 0x0, 0x7, 0xfd,
    0x1e, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xd, 0xfe,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf8, 0x0, 0x0, 0x0,

    /* U+005A "Z" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+005B "[" */
    0xcf, 0xff, 0xf7, 0xcf, 0xee, 0xe7, 0xcf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf,
    0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0,
    0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf,
    0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0,
    0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0xcf, 0x40, 0x0, 0xcf,
    0x40, 0x0, 0xcf, 0xee, 0xe7, 0xcf, 0xff, 0xf7,

    /* U+005C "\\" */
    0x3c, 0x10, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0xc, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xde, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x60, 0x0, 0x0, 0x0, 0x0, 0xd, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xed, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xa0,

    /* U+005D "]" */
    0x7f, 0xff, 0xfd, 0x6e, 0xee, 0xfd, 0x0, 0x4,
    0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0,
    0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd,
    0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4,
    0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0,
    0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd,
    0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4,
    0xfd, 0x0, 0x4, 0xfd, 0x0, 0x4, 0xfd, 0x0,
    0x4, 0xfd, 0x6e, 0xee, 0xfd, 0x7f, 0xff, 0xfd,

    /* U+005E "^" */
    0x0, 0x0, 0x6, 0x81, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x9f, 0xff,
    0x10, 0x0, 0x0, 0x1, 0xfe, 0x9f, 0x70, 0x0,
    0x0, 0x8, 0xf7, 0x1f, 0xe0, 0x0, 0x0, 0x1f,
    0xf1, 0xa, 0xf6, 0x0, 0x0, 0x8f, 0x90, 0x2,
    0xfe, 0x0, 0x0, 0xef, 0x20, 0x0, 0xbf, 0x60,
    0x7, 0xfb, 0x0, 0x0, 0x4f, 0xd0, 0xe, 0xf4,
    0x0, 0x0, 0xd, 0xf5,

    /* U+005F "_" */
    0x8c, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xc4, 0xaf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+0060 "`" */
    0x1d, 0xf7, 0x0, 0x2, 0xef, 0x20, 0x0, 0x3f,
    0xb0,

    /* U+0061 "a" */
    0x0, 0x29, 0xef, 0xfc, 0x50, 0x0, 0x5f, 0xff,
    0xde, 0xff, 0x90, 0x2f, 0xf9, 0x10, 0x4, 0xff,
    0x49, 0xfb, 0x0, 0x0, 0x8, 0xf9, 0x48, 0x30,
    0x0, 0x0, 0xbf, 0xa0, 0x0, 0x0, 0x5, 0xbf,
    0xfa, 0x0, 0x17, 0xcf, 0xff, 0xbf, 0xa0, 0x7f,
    0xff, 0xb7, 0x15, 0xfa, 0x5f, 0xf7, 0x0, 0x0,
    0x5f, 0xab, 0xf6, 0x0, 0x0, 0x6, 0xfa, 0xcf,
    0x40, 0x0, 0x0, 0xbf, 0xa9, 0xfc, 0x10, 0x2,
    0xbf, 0xfa, 0x1e, 0xff, 0xef, 0xff, 0xaf, 0xa0,
    0x18, 0xdf, 0xeb, 0x43, 0xfa,

    /* U+0062 "b" */
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xc0, 0x7d, 0xfe, 0xc6,
    0x0, 0x0, 0x4f, 0xdc, 0xff, 0xef, 0xff, 0xc0,
    0x0, 0x4f, 0xff, 0x91, 0x0, 0x4d, 0xfb, 0x0,
    0x4f, 0xf8, 0x0, 0x0, 0x1, 0xef, 0x40, 0x4f,
    0xf0, 0x0, 0x0, 0x0, 0x7f, 0xa0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x2f, 0xe0, 0x4f, 0xc0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x4f, 0xc0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x4f, 0xc0, 0x0, 0x0, 0x0,
    0x2f, 0xe0, 0x4f, 0xf0, 0x0, 0x0, 0x0, 0x7f,
    0xa0, 0x4f, 0xf8, 0x0, 0x0, 0x1, 0xef, 0x40,
    0x4f, 0xff, 0x81, 0x0, 0x4d, 0xfb, 0x0, 0x4f,
    0xce, 0xff, 0xef, 0xff, 0xc0, 0x0, 0x4f, 0xa1,
    0x8d, 0xff, 0xc6, 0x0, 0x0,

    /* U+0063 "c" */
    0x0, 0x3, 0xae, 0xfe, 0xb5, 0x0, 0x0, 0x8,
    0xff, 0xfe, 0xff, 0xfb, 0x0, 0x7, 0xff, 0x60,
    0x0, 0x5e, 0xfa, 0x1, 0xff, 0x40, 0x0, 0x0,
    0x3f, 0xf2, 0x6f, 0xb0, 0x0, 0x0, 0x0, 0xaf,
    0x6a, 0xf6, 0x0, 0x0, 0x0, 0x1, 0x0, 0xcf,
    0x40, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x10, 0x6, 0xfa, 0x0, 0x0, 0x0, 0xa,
    0xf6, 0x1f, 0xf4, 0x0, 0x0, 0x3, 0xff, 0x20,
    0x7f, 0xf6, 0x0, 0x5, 0xef, 0xa0, 0x0, 0x8f,
    0xff, 0xef, 0xff, 0xb0, 0x0, 0x0, 0x3a, 0xef,
    0xeb, 0x50, 0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x80, 0x0, 0x4b, 0xef, 0xd9, 0x18, 0xf8, 0x0,
    0x9f, 0xff, 0xef, 0xfe, 0xbf, 0x80, 0x7f, 0xf5,
    0x0, 0x6, 0xff, 0xf8, 0x1f, 0xf3, 0x0, 0x0,
    0x4, 0xff, 0x87, 0xfa, 0x0, 0x0, 0x0, 0xb,
    0xf8, 0xaf, 0x60, 0x0, 0x0, 0x0, 0x8f, 0x8c,
    0xf4, 0x0, 0x0, 0x0, 0x8, 0xf8, 0xcf, 0x30,
    0x0, 0x0, 0x0, 0x8f, 0x8a, 0xf6, 0x0, 0x0,
    0x0, 0x8, 0xf8, 0x7f, 0xa0, 0x0, 0x0, 0x0,
    0xbf, 0x81, 0xff, 0x40, 0x0, 0x0, 0x4f, 0xf8,
    0x7, 0xff, 0x60, 0x0, 0x6f, 0xff, 0x80, 0x9,
    0xff, 0xfe, 0xff, 0xfb, 0xf8, 0x0, 0x4, 0xbe,
    0xfe, 0xa2, 0x7f, 0x80,

    /* U+0065 "e" */
    0x0, 0x3, 0xae, 0xfe, 0xb4, 0x0, 0x0, 0x8,
    0xff, 0xfd, 0xef, 0xfa, 0x0, 0x7, 0xff, 0x60,
    0x0, 0x4e, 0xf8, 0x1, 0xff, 0x40, 0x0, 0x0,
    0x2f, 0xf1, 0x6f, 0xa0, 0x0, 0x0, 0x0, 0x9f,
    0x7a, 0xf5, 0x0, 0x0, 0x0, 0x6, 0xfa, 0xcf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xfb, 0x99,
    0x99, 0x99, 0x99, 0x97, 0xaf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0x2,
    0x0, 0x1f, 0xf3, 0x0, 0x0, 0x1, 0xee, 0x20,
    0x7f, 0xf5, 0x0, 0x3, 0xdf, 0xb0, 0x0, 0x8f,
    0xff, 0xde, 0xff, 0xb1, 0x0, 0x0, 0x3a, 0xef,
    0xeb, 0x50, 0x0,

    /* U+0066 "f" */
    0x0, 0x2, 0xbe, 0xff, 0x0, 0x0, 0xdf, 0xfe,
    0xe0, 0x0, 0x1f, 0xf1, 0x0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0x66, 0xcd,
    0xff, 0xcc, 0xc4, 0x0, 0x1f, 0xe0, 0x0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x1, 0xfe, 0x0,
    0x0,

    /* U+0067 "g" */
    0x0, 0x4, 0xbe, 0xfe, 0x91, 0x8f, 0x80, 0x9,
    0xff, 0xfe, 0xff, 0xeb, 0xf8, 0x7, 0xff, 0x50,
    0x0, 0x6f, 0xff, 0x81, 0xff, 0x30, 0x0, 0x0,
    0x4f, 0xf8, 0x7f, 0xa0, 0x0, 0x0, 0x0, 0xbf,
    0x8a, 0xf6, 0x0, 0x0, 0x0, 0x8, 0xf8, 0xcf,
    0x40, 0x0, 0x0, 0x0, 0x8f, 0x8c, 0xf3, 0x0,
    0x0, 0x0, 0x8, 0xf8, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x8f, 0x87, 0xfa, 0x0, 0x0, 0x0, 0xb,
    0xf8, 0x1f, 0xf4, 0x0, 0x0, 0x4, 0xff, 0x80,
    0x7f, 0xf6, 0x0, 0x6, 0xff, 0xf8, 0x0, 0x9f,
    0xff, 0xef, 0xff, 0xbf, 0x80, 0x0, 0x4b, 0xef,
    0xea, 0x28, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x70, 0x6, 0x40, 0x0, 0x0, 0xc, 0xf5,
    0x6, 0xfd, 0x0, 0x0, 0x3, 0xff, 0x10, 0xd,
    0xfc, 0x40, 0x5, 0xef, 0x80, 0x0, 0x1c, 0xff,
    0xff, 0xff, 0xa0, 0x0, 0x0, 0x5, 0xac, 0xda,
    0x40, 0x0,

    /* U+0068 "h" */
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc1,
    0x8d, 0xfe, 0xb4, 0x0, 0x4f, 0xde, 0xff, 0xef,
    0xff, 0x70, 0x4f, 0xff, 0x60, 0x1, 0x9f, 0xf3,
    0x4f, 0xf5, 0x0, 0x0, 0xb, 0xf9, 0x4f, 0xe0,
    0x0, 0x0, 0x5, 0xfc, 0x4f, 0xc0, 0x0, 0x0,
    0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0,
    0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0,
    0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0,
    0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0,
    0x3, 0xfd,

    /* U+0069 "i" */
    0x7f, 0xe7, 0xfe, 0x13, 0x30, 0x0, 0x4f, 0xc4,
    0xfc, 0x4f, 0xc4, 0xfc, 0x4f, 0xc4, 0xfc, 0x4f,
    0xc4, 0xfc, 0x4f, 0xc4, 0xfc, 0x4f, 0xc4, 0xfc,
    0x4f, 0xc4, 0xfc,

    /* U+006A "j" */
    0x0, 0x3f, 0xf2, 0x0, 0x3f, 0xf2, 0x0, 0x3,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0x1f, 0xf0, 0x3e, 0xff, 0xc0, 0x4f,
    0xfb, 0x20,

    /* U+006B "k" */
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0xaf, 0xd1, 0x4f, 0xc0, 0x0, 0x9,
    0xfe, 0x10, 0x4f, 0xc0, 0x0, 0x8f, 0xe2, 0x0,
    0x4f, 0xc0, 0x7, 0xfe, 0x20, 0x0, 0x4f, 0xc0,
    0x6f, 0xf3, 0x0, 0x0, 0x4f, 0xc5, 0xff, 0x70,
    0x0, 0x0, 0x4f, 0xef, 0xff, 0xe1, 0x0, 0x0,
    0x4f, 0xff, 0x3b, 0xf9, 0x0, 0x0, 0x4f, 0xf4,
    0x2, 0xff, 0x30, 0x0, 0x4f, 0xc0, 0x0, 0x7f,
    0xd0, 0x0, 0x4f, 0xc0, 0x0, 0xd, 0xf8, 0x0,
    0x4f, 0xc0, 0x0, 0x3, 0xff, 0x20, 0x4f, 0xc0,
    0x0, 0x0, 0x9f, 0xc0, 0x4f, 0xc0, 0x0, 0x0,
    0x1e, 0xf6,

    /* U+006C "l" */
    0x4f, 0xc4, 0xfc, 0x4f, 0xc4, 0xfc, 0x4f, 0xc4,
    0xfc, 0x4f, 0xc4, 0xfc, 0x4f, 0xc4, 0xfc, 0x4f,
    0xc4, 0xfc, 0x4f, 0xc4, 0xfc, 0x4f, 0xc4, 0xfc,
    0x4f, 0xc4, 0xfc, 0x4f, 0xc0,

    /* U+006D "m" */
    0x4f, 0xb4, 0xbf, 0xfc, 0x50, 0x18, 0xdf, 0xea,
    0x20, 0x4, 0xfe, 0xff, 0xef, 0xff, 0x9d, 0xff,
    0xef, 0xff, 0x50, 0x4f, 0xfc, 0x20, 0x8, 0xff,
    0xfa, 0x10, 0x1a, 0xfe, 0x4, 0xff, 0x10, 0x0,
    0xb, 0xfd, 0x0, 0x0, 0xd, 0xf5, 0x4f, 0xd0,
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0xaf, 0x74,
    0xfc, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x9,
    0xf7, 0x4f, 0xc0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x9f, 0x74, 0xfc, 0x0, 0x0, 0x6, 0xf8,
    0x0, 0x0, 0x9, 0xf7, 0x4f, 0xc0, 0x0, 0x0,
    0x6f, 0x80, 0x0, 0x0, 0x9f, 0x74, 0xfc, 0x0,
    0x0, 0x6, 0xf8, 0x0, 0x0, 0x9, 0xf7, 0x4f,
    0xc0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x9f,
    0x74, 0xfc, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0,
    0x9, 0xf7, 0x4f, 0xc0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x9f, 0x74, 0xfc, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0x9, 0xf7,

    /* U+006E "n" */
    0x4f, 0xb1, 0x8d, 0xfe, 0xb4, 0x0, 0x4f, 0xde,
    0xff, 0xef, 0xff, 0x70, 0x4f, 0xff, 0x60, 0x1,
    0x9f, 0xf3, 0x4f, 0xf5, 0x0, 0x0, 0xb, 0xf9,
    0x4f, 0xe0, 0x0, 0x0, 0x5, 0xfc, 0x4f, 0xc0,
    0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0,
    0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0,
    0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0,
    0x3, 0xfd, 0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0x4f, 0xc0, 0x0, 0x0, 0x3, 0xfd, 0x4f, 0xc0,
    0x0, 0x0, 0x3, 0xfd,

    /* U+006F "o" */
    0x0, 0x3, 0xae, 0xfe, 0xb6, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xef, 0xff, 0xc1, 0x0, 0x7, 0xff,
    0x60, 0x0, 0x4d, 0xfc, 0x0, 0x1f, 0xf4, 0x0,
    0x0, 0x1, 0xdf, 0x60, 0x6f, 0xa0, 0x0, 0x0,
    0x0, 0x5f, 0xc0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0xcf, 0x40, 0x0, 0x0, 0x0, 0xe,
    0xf2, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0xaf, 0x60, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x6f,
    0xa0, 0x0, 0x0, 0x0, 0x5f, 0xc0, 0x1f, 0xf4,
    0x0, 0x0, 0x0, 0xdf, 0x60, 0x7, 0xff, 0x60,
    0x0, 0x3d, 0xfc, 0x0, 0x0, 0x8f, 0xff, 0xef,
    0xff, 0xc1, 0x0, 0x0, 0x3, 0xae, 0xfe, 0xb6,
    0x0, 0x0,

    /* U+0070 "p" */
    0x4f, 0xc0, 0x7d, 0xfe, 0xc6, 0x0, 0x0, 0x4f,
    0xdc, 0xff, 0xef, 0xff, 0xb0, 0x0, 0x4f, 0xff,
    0x91, 0x0, 0x4d, 0xfb, 0x0, 0x4f, 0xf8, 0x0,
    0x0, 0x1, 0xef, 0x40, 0x4f, 0xf0, 0x0, 0x0,
    0x0, 0x7f, 0xa0, 0x4f, 0xc0, 0x0, 0x0, 0x0,
    0x2f, 0xe0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0x4f,
    0xf0, 0x0, 0x0, 0x0, 0x7f, 0xa0, 0x4f, 0xf8,
    0x0, 0x0, 0x1, 0xef, 0x40, 0x4f, 0xff, 0x81,
    0x0, 0x4d, 0xfb, 0x0, 0x4f, 0xdd, 0xff, 0xef,
    0xff, 0xc0, 0x0, 0x4f, 0xc0, 0x7d, 0xff, 0xc6,
    0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x16, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x4, 0xbe, 0xfe, 0x91, 0x8f, 0x80, 0x9,
    0xff, 0xfe, 0xff, 0xeb, 0xf8, 0x7, 0xff, 0x50,
    0x0, 0x6f, 0xff, 0x81, 0xff, 0x30, 0x0, 0x0,
    0x4f, 0xf8, 0x7f, 0xa0, 0x0, 0x0, 0x0, 0xbf,
    0x8a, 0xf6, 0x0, 0x0, 0x0, 0x8, 0xf8, 0xcf,
    0x40, 0x0, 0x0, 0x0, 0x8f, 0x8c, 0xf3, 0x0,
    0x0, 0x0, 0x8, 0xf8, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x8f, 0x87, 0xfa, 0x0, 0x0, 0x0, 0xb,
    0xf8, 0x1f, 0xf4, 0x0, 0x0, 0x4, 0xff, 0x80,
    0x7f, 0xf6, 0x0, 0x6, 0xff, 0xf8, 0x0, 0x9f,
    0xff, 0xef, 0xff, 0xbf, 0x80, 0x0, 0x4b, 0xef,
    0xd9, 0x18, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x63,

    /* U+0072 "r" */
    0x0, 0x0, 0x0, 0x4, 0xfa, 0x8e, 0xfd, 0x4f,
    0xff, 0xfe, 0x94, 0xff, 0x90, 0x0, 0x4f, 0xf0,
    0x0, 0x4, 0xfc, 0x0, 0x0, 0x4f, 0xc0, 0x0,
    0x4, 0xfc, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x4,
    0xfc, 0x0, 0x0, 0x4f, 0xc0, 0x0, 0x4, 0xfc,
    0x0, 0x0, 0x4f, 0xc0, 0x0, 0x4, 0xfc, 0x0,
    0x0, 0x4f, 0xc0, 0x0, 0x0,

    /* U+0073 "s" */
    0x0, 0x4, 0xbe, 0xfe, 0x92, 0x0, 0x0, 0x7,
    0xff, 0xfe, 0xff, 0xf5, 0x0, 0x2, 0xff, 0x60,
    0x1, 0x9f, 0xf2, 0x0, 0x5f, 0xb0, 0x0, 0x0,
    0xaf, 0x90, 0x4, 0xfe, 0x10, 0x0, 0x2, 0x30,
    0x0, 0xc, 0xff, 0x93, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xef, 0xfe, 0x92, 0x0, 0x0, 0x0, 0x0,
    0x59, 0xef, 0xfa, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x5d, 0xfa, 0x0, 0xff, 0x20, 0x0, 0x0, 0x1f,
    0xf1, 0xb, 0xf8, 0x0, 0x0, 0x0, 0xff, 0x10,
    0x4f, 0xf8, 0x10, 0x2, 0xbf, 0xd0, 0x0, 0x7f,
    0xff, 0xfe, 0xff, 0xe3, 0x0, 0x0, 0x39, 0xdf,
    0xfd, 0x91, 0x0,

    /* U+0074 "t" */
    0x0, 0x38, 0x50, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0x0, 0x0, 0x6f, 0xa0, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xf0, 0x6c, 0xef, 0xec, 0xcc, 0x0, 0x6,
    0xfa, 0x0, 0x0, 0x0, 0x6f, 0xa0, 0x0, 0x0,
    0x6, 0xfa, 0x0, 0x0, 0x0, 0x6f, 0xa0, 0x0,
    0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x0, 0x0, 0x6, 0xfa, 0x0, 0x0, 0x0, 0x6f,
    0xa0, 0x0, 0x0, 0x6, 0xfa, 0x0, 0x0, 0x0,
    0x5f, 0xc0, 0x0, 0x0, 0x2, 0xff, 0xfe, 0x30,
    0x0, 0x5, 0xdf, 0xf4, 0x0,

    /* U+0075 "u" */
    0x6f, 0x90, 0x0, 0x0, 0x8, 0xf8, 0x6f, 0x90,
    0x0, 0x0, 0x8, 0xf8, 0x6f, 0x90, 0x0, 0x0,
    0x8, 0xf8, 0x6f, 0x90, 0x0, 0x0, 0x8, 0xf8,
    0x6f, 0x90, 0x0, 0x0, 0x8, 0xf8, 0x6f, 0x90,
    0x0, 0x0, 0x8, 0xf8, 0x6f, 0x90, 0x0, 0x0,
    0x8, 0xf8, 0x6f, 0x90, 0x0, 0x0, 0x8, 0xf8,
    0x6f, 0x90, 0x0, 0x0, 0x8, 0xf8, 0x5f, 0xb0,
    0x0, 0x0, 0xa, 0xf8, 0x3f, 0xf1, 0x0, 0x0,
    0x1f, 0xf8, 0xd, 0xfc, 0x20, 0x3, 0xcf, 0xf8,
    0x4, 0xff, 0xff, 0xff, 0xfc, 0xf8, 0x0, 0x3a,
    0xef, 0xea, 0x37, 0xf8,

    /* U+0076 "v" */
    0x8f, 0xa0, 0x0, 0x0, 0x0, 0xb, 0xf7, 0x1f,
    0xf1, 0x0, 0x0, 0x0, 0x2f, 0xf1, 0xb, 0xf7,
    0x0, 0x0, 0x0, 0x8f, 0xa0, 0x4, 0xfd, 0x0,
    0x0, 0x0, 0xef, 0x30, 0x0, 0xdf, 0x30, 0x0,
    0x5, 0xfc, 0x0, 0x0, 0x7f, 0xa0, 0x0, 0xb,
    0xf6, 0x0, 0x0, 0x1f, 0xf1, 0x0, 0x2f, 0xe0,
    0x0, 0x0, 0x9, 0xf7, 0x0, 0x8f, 0x80, 0x0,
    0x0, 0x3, 0xfd, 0x0, 0xef, 0x20, 0x0, 0x0,
    0x0, 0xcf, 0x45, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xab, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff, 0x10,
    0x0, 0x0,

    /* U+0077 "w" */
    0x3f, 0xc0, 0x0, 0x0, 0x4f, 0xe0, 0x0, 0x0,
    0x2f, 0xd0, 0xff, 0x0, 0x0, 0x9, 0xff, 0x30,
    0x0, 0x5, 0xfa, 0xc, 0xf3, 0x0, 0x0, 0xee,
    0xf9, 0x0, 0x0, 0x9f, 0x60, 0x8f, 0x70, 0x0,
    0x4f, 0x7d, 0xe0, 0x0, 0xd, 0xf2, 0x4, 0xfa,
    0x0, 0xa, 0xf2, 0x7f, 0x40, 0x0, 0xfe, 0x0,
    0xf, 0xe0, 0x0, 0xfc, 0x2, 0xf9, 0x0, 0x4f,
    0xa0, 0x0, 0xdf, 0x20, 0x5f, 0x70, 0xc, 0xe0,
    0x8, 0xf7, 0x0, 0x9, 0xf5, 0xa, 0xf1, 0x0,
    0x7f, 0x40, 0xbf, 0x30, 0x0, 0x5f, 0x90, 0xfc,
    0x0, 0x2, 0xf9, 0xf, 0xf0, 0x0, 0x1, 0xfd,
    0x5f, 0x60, 0x0, 0xc, 0xe3, 0xfb, 0x0, 0x0,
    0xd, 0xfb, 0xf1, 0x0, 0x0, 0x7f, 0xbf, 0x70,
    0x0, 0x0, 0xaf, 0xfb, 0x0, 0x0, 0x1, 0xff,
    0xf4, 0x0, 0x0, 0x6, 0xff, 0x60, 0x0, 0x0,
    0xc, 0xff, 0x0, 0x0, 0x0, 0x2f, 0xf1, 0x0,
    0x0, 0x0, 0x6f, 0xc0, 0x0,

    /* U+0078 "x" */
    0x6f, 0xe1, 0x0, 0x0, 0xc, 0xf9, 0x0, 0xbf,
    0xa0, 0x0, 0x7, 0xfd, 0x0, 0x1, 0xff, 0x40,
    0x2, 0xff, 0x30, 0x0, 0x6, 0xfe, 0x0, 0xcf,
    0x90, 0x0, 0x0, 0xb, 0xf9, 0x6f, 0xd0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xdf,
    0x60, 0x0, 0x0, 0x0, 0xdf, 0x63, 0xff, 0x10,
    0x0, 0x0, 0x8f, 0xc0, 0x9, 0xfb, 0x0, 0x0,
    0x3f, 0xf2, 0x0, 0xe, 0xf6, 0x0, 0xd, 0xf7,
    0x0, 0x0, 0x4f, 0xf1, 0x8, 0xfd, 0x0, 0x0,
    0x0, 0xaf, 0xb0,

    /* U+0079 "y" */
    0x8f, 0xa0, 0x0, 0x0, 0x0, 0x5f, 0xd0, 0x1f,
    0xf1, 0x0, 0x0, 0x0, 0xbf, 0x60, 0xa, 0xf7,
    0x0, 0x0, 0x2, 0xfe, 0x0, 0x3, 0xfd, 0x0,
    0x0, 0x9, 0xf8, 0x0, 0x0, 0xdf, 0x40, 0x0,
    0xe, 0xf2, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x6f,
    0xb0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0xcf, 0x40,
    0x0, 0x0, 0x8, 0xf8, 0x3, 0xfd, 0x0, 0x0,
    0x0, 0x2, 0xfe, 0x9, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x6f, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18, 0x60,
    0x0, 0x0, 0x0, 0x0,

    /* U+007A "z" */
    0xe, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xbd,
    0xdd, 0xdd, 0xdd, 0xef, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0xb, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x4,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x2, 0xef, 0x50,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xfe,
    0xdd, 0xdd, 0xdd, 0xdd, 0x23, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+007B "{" */
    0x0, 0x1, 0xae, 0xff, 0x0, 0xd, 0xff, 0xff,
    0x0, 0x2f, 0xf5, 0x0, 0x0, 0x4f, 0xd0, 0x0,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x9f, 0xa0, 0x0, 0x6f, 0xff, 0x30, 0x0,
    0x6f, 0xfb, 0x10, 0x0, 0x26, 0xcf, 0x80, 0x0,
    0x0, 0x5f, 0xb0, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0x4f, 0xd0, 0x0, 0x0, 0x3f, 0xf4, 0x0,
    0x0, 0xe, 0xff, 0xff, 0x0, 0x2, 0xbe, 0xff,

    /* U+007C "|" */
    0x38, 0x16, 0xf2, 0x6f, 0x26, 0xf2, 0x6f, 0x26,
    0xf2, 0x6f, 0x26, 0xf2, 0x6f, 0x26, 0xf2, 0x6f,
    0x26, 0xf2, 0x6f, 0x26, 0xf2, 0x6f, 0x26, 0xf2,
    0x6f, 0x26, 0xf2, 0x6f, 0x26, 0xf2, 0x6f, 0x26,
    0xf2, 0x6f, 0x26, 0xf2, 0x6f, 0x26, 0xf2, 0x6f,
    0x26, 0xf2,

    /* U+007D "}" */
    0x7f, 0xfd, 0x50, 0x0, 0x7f, 0xff, 0xf5, 0x0,
    0x0, 0x1c, 0xfa, 0x0, 0x0, 0x5, 0xfc, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x4, 0xfd, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x4, 0xfd, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x3, 0xfd, 0x0,
    0x0, 0x2, 0xff, 0x20, 0x0, 0x0, 0xaf, 0xff,
    0x0, 0x0, 0x5e, 0xff, 0x0, 0x1, 0xff, 0x85,
    0x0, 0x3, 0xfd, 0x0, 0x0, 0x4, 0xfd, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x4, 0xfd, 0x0,
    0x0, 0x4, 0xfd, 0x0, 0x0, 0x4, 0xfd, 0x0,
    0x0, 0x5, 0xfd, 0x0, 0x0, 0x1b, 0xfb, 0x0,
    0x7f, 0xff, 0xf6, 0x0, 0x7f, 0xfd, 0x60, 0x0,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6d, 0xfd, 0x70, 0x0, 0x2, 0xd7, 0x8, 0xff,
    0xff, 0xfe, 0x60, 0xb, 0xf8, 0x1f, 0xf4, 0x3,
    0xbf, 0xff, 0xff, 0xe1, 0x2b, 0x90, 0x0, 0x4,
    0xbe, 0xea, 0x20
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 112, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 162, .box_w = 4, .box_h = 18, .ofs_x = 3, .ofs_y = 0},
    {.bitmap_index = 36, .adv_w = 161, .box_w = 6, .box_h = 6, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 54, .adv_w = 327, .box_w = 18, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 216, .adv_w = 272, .box_w = 15, .box_h = 24, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 396, .adv_w = 417, .box_w = 24, .box_h = 22, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 660, .adv_w = 280, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 804, .adv_w = 106, .box_w = 3, .box_h = 6, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 813, .adv_w = 152, .box_w = 7, .box_h = 27, .ofs_x = 2, .ofs_y = -6},
    {.bitmap_index = 908, .adv_w = 152, .box_w = 8, .box_h = 27, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 1016, .adv_w = 203, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 1071, .adv_w = 245, .box_w = 13, .box_h = 13, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 1156, .adv_w = 126, .box_w = 4, .box_h = 6, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 1168, .adv_w = 151, .box_w = 8, .box_h = 2, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 1176, .adv_w = 125, .box_w = 4, .box_h = 3, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 1182, .adv_w = 185, .box_w = 12, .box_h = 20, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1302, .adv_w = 259, .box_w = 14, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1428, .adv_w = 152, .box_w = 7, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1491, .adv_w = 238, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1608, .adv_w = 237, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1725, .adv_w = 225, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1851, .adv_w = 237, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1968, .adv_w = 247, .box_w = 14, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2094, .adv_w = 210, .box_w = 13, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2205, .adv_w = 225, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2331, .adv_w = 237, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2457, .adv_w = 125, .box_w = 4, .box_h = 12, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2481, .adv_w = 126, .box_w = 4, .box_h = 15, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 2511, .adv_w = 229, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 2595, .adv_w = 230, .box_w = 12, .box_h = 7, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 2637, .adv_w = 229, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 2721, .adv_w = 247, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2838, .adv_w = 336, .box_w = 19, .box_h = 19, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 3019, .adv_w = 247, .box_w = 16, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3163, .adv_w = 262, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3289, .adv_w = 270, .box_w = 15, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3424, .adv_w = 271, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3550, .adv_w = 233, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3658, .adv_w = 230, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3766, .adv_w = 272, .box_w = 15, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3901, .adv_w = 271, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4018, .adv_w = 106, .box_w = 3, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4045, .adv_w = 217, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4153, .adv_w = 250, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4279, .adv_w = 216, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4378, .adv_w = 352, .box_w = 18, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4540, .adv_w = 280, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4666, .adv_w = 283, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4810, .adv_w = 256, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 4936, .adv_w = 283, .box_w = 16, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5080, .adv_w = 253, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5197, .adv_w = 250, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5332, .adv_w = 245, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5467, .adv_w = 275, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 5593, .adv_w = 250, .box_w = 16, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5737, .adv_w = 352, .box_w = 22, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5935, .adv_w = 230, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6070, .adv_w = 238, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6205, .adv_w = 247, .box_w = 14, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6331, .adv_w = 129, .box_w = 6, .box_h = 24, .ofs_x = 2, .ofs_y = -5},
    {.bitmap_index = 6403, .adv_w = 185, .box_w = 12, .box_h = 20, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6523, .adv_w = 129, .box_w = 6, .box_h = 24, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 6595, .adv_w = 230, .box_w = 12, .box_h = 10, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 6655, .adv_w = 251, .box_w = 14, .box_h = 2, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6669, .adv_w = 122, .box_w = 6, .box_h = 3, .ofs_x = 1, .ofs_y = 15},
    {.bitmap_index = 6678, .adv_w = 212, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6755, .adv_w = 244, .box_w = 14, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6888, .adv_w = 234, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6979, .adv_w = 244, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7103, .adv_w = 238, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7194, .adv_w = 141, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7275, .adv_w = 242, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 7405, .adv_w = 231, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7519, .adv_w = 87, .box_w = 3, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7546, .adv_w = 92, .box_w = 6, .box_h = 22, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 7612, .adv_w = 213, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7726, .adv_w = 87, .box_w = 3, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7755, .adv_w = 337, .box_w = 19, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7888, .adv_w = 231, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7972, .adv_w = 245, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8070, .adv_w = 244, .box_w = 14, .box_h = 20, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 8210, .adv_w = 244, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 8340, .adv_w = 135, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8393, .adv_w = 209, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8484, .adv_w = 141, .box_w = 9, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8561, .adv_w = 228, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8645, .adv_w = 223, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8743, .adv_w = 314, .box_w = 19, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8876, .adv_w = 195, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8967, .adv_w = 213, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 9107, .adv_w = 208, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9198, .adv_w = 152, .box_w = 8, .box_h = 24, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 9294, .adv_w = 108, .box_w = 3, .box_h = 28, .ofs_x = 2, .ofs_y = -8},
    {.bitmap_index = 9336, .adv_w = 152, .box_w = 8, .box_h = 24, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 9432, .adv_w = 264, .box_w = 14, .box_h = 5, .ofs_x = 1, .ofs_y = 7}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] = {
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Map glyph_ids to kern left classes*/
static const uint8_t kern_left_class_mapping[] = {
    0, 1, 2, 3, 0, 0, 0, 0,
    3, 4, 4, 5, 0, 6, 7, 6,
    8, 9, 10, 11, 12, 13, 14, 15,
    16, 17, 9, 0, 0, 0, 0, 0,
    2, 0, 18, 19, 20, 21, 22, 23,
    21, 24, 24, 25, 26, 27, 24, 24,
    21, 28, 29, 30, 31, 32, 25, 33,
    34, 26, 35, 36, 37, 38, 37, 0,
    6, 0, 39, 40, 40, 41, 40, 42,
    43, 39, 44, 44, 45, 41, 39, 39,
    40, 40, 0, 46, 47, 48, 49, 50,
    51, 45, 52, 53, 37, 0, 37, 0
};

/*Map glyph_ids to kern right classes*/
static const uint8_t kern_right_class_mapping[] = {
    0, 0, 0, 1, 0, 0, 0, 0,
    1, 2, 2, 3, 0, 4, 5, 4,
    6, 7, 8, 9, 10, 11, 12, 7,
    13, 14, 15, 16, 16, 0, 0, 0,
    17, 0, 18, 19, 20, 19, 19, 19,
    20, 19, 19, 21, 19, 19, 19, 19,
    20, 19, 20, 19, 22, 23, 24, 25,
    26, 27, 28, 29, 30, 31, 30, 0,
    4, 0, 32, 33, 34, 34, 34, 35,
    34, 33, 36, 37, 33, 33, 38, 38,
    34, 38, 34, 38, 39, 40, 41, 42,
    43, 44, 45, 46, 30, 0, 30, 0
};

/*Kern values between classes*/
static const int8_t kern_class_values[] = {
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, -17, 0, -33, 0,
    -12, -8, -4, -17, 0, 0, 0, -12,
    0, -12, -8, 0, 0, 0, -8, -8,
    0, -17, -8, -12, -17, 0, -21, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -50,
    0, 0, -8, 0, 0, 0, -29, -8,
    4, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4, -4, -17, 0,
    4, 0, 4, 4, 4, 4, 0, 0,
    0, -12, 8, -12, 0, 12, 12, 0,
    0, 0, 0, -8, -4, -8, -8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 4, 0, 0, 0, -25, 4,
    0, 0, 0, 0, 0, 0, -58, -21,
    0, 0, 0, 0, -17, -41, 0, 0,
    4, -8, -29, 0, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -21, 0, 0,
    0, 0, 8, 0, 0, 0, 17, 12,
    -29, 12, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -62,
    0, 0, 0, -8, 0, 0, 0, 0,
    0, 0, 0, -29, 4, -12, -50, -12,
    12, 12, 12, 8, 12, 12, 4, 0,
    0, -33, 8, -46, 4, 12, 12, -17,
    -33, 0, 0, 0, 0, -21, 0, -12,
    -8, 0, 0, -17, 8, 0, 0, -4,
    -12, -8, -4, -4, -17, -4, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, -12, 0, 0, -7, -8, -8,
    0, 0, -4, 0, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -12, -8, -7, -8, -12, -8,
    -17, -4, -4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, 0,
    0, -8, -8, 0, 0, 0, -13, 0,
    -4, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -13, 0, 0, 0, 0, 0, -4, -8,
    0, 0, 0, 0, -12, 0, -12, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -12, 0,
    0, 0, 0, 0, 0, -17, -8, -4,
    0, 0, -12, 0, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -12, 0, 0, 0,
    0, 0, -4, -8, -4, 0, 0, 0,
    -12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 0, 0, -75, -38, 0,
    -25, -9, -21, -13, -30, -12, 0, -17,
    -4, 0, 0, -29, 0, -8, -42, -5,
    0, 0, 0, 4, 0, 0, -12, 0,
    0, 0, 0, -24, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    -8, 0, 0, 0, 8, 0, -4, -8,
    -4, 0, 0, 0, -17, 4, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -42, 0,
    0, 8, -8, 12, 0, 0, 0, -12,
    0, 0, -8, 0, 0, 0, -29, 8,
    0, -8, 0, -12, -42, -17, -29, -17,
    4, -37, 0, -12, 0, 0, 0, -8,
    -17, 0, 0, 0, -8, -12, 0, -21,
    -17, 4, -29, 0, -12, 0, 0, -8,
    0, -8, 0, 0, 0, -8, 0, 0,
    -4, 0, 0, 0, 0, -8, 0, 0,
    0, 0, -12, 0, -16, -4, -12, -17,
    -4, -8, 0, -12, 0, -4, 0, 0,
    0, -4, 0, 0, 0, -4, 0, 0,
    0, 0, -8, -4, 0, -17, 8, -12,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, 4, -8, 0, 0, 0, 0,
    -17, 0, -8, 0, -8, -8, -13, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 4, 0, 8, 8, 4, 8, 0,
    -17, -4, 0, -17, 8, -12, 0, 0,
    0, 0, 0, 0, -17, 0, 0, 0,
    -8, -8, 0, 0, 0, 0, -17, 0,
    -17, 0, -8, -20, -13, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    0, 0, 0, -8, -4, 0, -4, 0,
    0, 0, 0, 12, 0, 0, 0, 0,
    0, 0, 4, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, 0, -8,
    0, 0, 0, 0, -12, -4, 0, -8,
    0, 0, 0, 0, 0, 0, 0, -46,
    0, -37, 0, 0, 0, 0, 0, 0,
    8, 0, 0, 0, 0, -21, 0, -8,
    -42, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -12, 0, -12, -12, 0,
    -4, 0, -17, -17, -8, -17, -17, -17,
    -17, -21, -8, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -17, 0, -12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -17, 0, 0, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    0, 0, -33, 12, 0, 0, 0, -12,
    0, 0, 0, 0, 0, 0, -12, 4,
    0, -12, -12, 0, 0, 0, 0, 0,
    4, 0, 0, 4, 8, -8, 0, -21,
    -17, 0, 0, 0, -12, -12, -8, -25,
    -12, 0, -25, 0, -54, 0, 0, 12,
    -50, 12, 0, 0, 0, 0, 0, 0,
    -12, 0, 0, 0, -21, 8, 0, -12,
    0, 0, -37, -12, -54, -21, 4, -58,
    0, -8, 0, 0, 0, -4, -12, 0,
    0, 0, 0, -12, 0, -37, -21, 4,
    -33, 0, 0, 0, 0, -54, 0, -37,
    0, 0, 0, 0, -12, 0, 0, 0,
    0, 0, 4, -25, 0, 0, -59, 0,
    0, 0, 0, 0, -12, -12, -12, -8,
    0, 0, 0, -12, 0, 0, 0, 0,
    -4, 8, 0, 0, 0, 0, 0, 0,
    -17, -4, 0, -17, 8, -12, 0, 0,
    0, 0, 0, 0, -17, 0, 0, 0,
    -8, -4, 0, 0, 0, 0, -17, 0,
    -17, 0, -8, -20, -9, -8, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 4,
    0, 0, 0, -8, -4, 0, 0, 0,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -17, 0, -8, 0, -4, 0,
    0, -12, -4, 0, 0, 0, 0, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -17, 0, 0, -8,
    0, 0, 0, 0, 0, 0, 4, 0,
    -13, 0, 0, 0, 0, -8, 0, 0,
    0, 0, -17, 0, -12, 0, 0, -12,
    0, -8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, 0, 0, 0,
    0, 0, 0, 4, 0, -62, -54, -50,
    0, 0, 0, -21, -29, 0, 8, 0,
    0, -42, -4, -42, 0, -17, -62, 0,
    -8, 0, 0, 0, 0, 0, 0, 4,
    8, -67, -8, -54, -20, -8, -8, -58,
    -62, -20, -50, -46, -58, -54, -54, -58,
    0, 4, 0, -54, -21, -33, 0, 0,
    0, 0, -21, 0, 4, 0, 0, 0,
    0, -29, 0, -12, -54, -8, 0, 0,
    8, 0, 0, 8, 0, 4, 0, -25,
    0, -20, 0, 0, 0, -8, -25, -4,
    -17, -4, -8, 0, -4, -12, 0, 4,
    0, -42, -4, -21, 0, 0, 0, 0,
    -12, 0, 4, 0, 0, 0, 0, -17,
    0, 0, -29, 0, 0, 0, 0, 0,
    0, 0, 0, 4, 0, -4, 0, -12,
    0, 0, 0, -4, -12, 0, 0, 0,
    0, 0, -4, 0, 0, 4, 0, -71,
    -42, -54, 0, 0, 0, 0, -37, 0,
    4, 0, 0, 0, 0, -37, 0, -17,
    -58, -8, 0, 0, 8, 0, 0, 0,
    0, 4, 0, -37, 0, -37, -12, 0,
    0, -25, -37, -12, -29, -17, -17, -17,
    -17, -29, 0, 0, 0, 0, -25, 4,
    0, 0, 0, 0, -21, 0, 0, 0,
    0, 0, -8, 0, 0, -25, -4, 0,
    0, 0, 0, 4, 0, 4, 0, 0,
    0, 0, 0, -17, -12, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 0, -8, -25, -8, 4, 0,
    4, 4, 4, 4, 0, 0, 0, -4,
    0, -12, 0, 0, 12, 0, -12, 0,
    0, -12, -4, -8, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 8,
    0, 0, 0, 0, -42, 0, 0, 0,
    4, 0, 0, 0, -62, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 8, 0, 0, -33, -8, -12, 0,
    0, 8, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -8, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, 0, 0, -8, 0,
    0, 0, 0, -4, 0, -12, -8, -8,
    -4, 0, -21, -12, -12, -12, 4, -8,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -21, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -12,
    -42, -4, 0, -4, -8, 0, 0, 0,
    -4, -4, 0, -12, -8, -12, -8, -8,
    0, 4, 0, 0, 0, 12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 8,
    4, -45, 0, -12, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -12, 0, -9,
    4, 0, 0, 0, -4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 12, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 12, 0, 0, 0, 12,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -8, 0, 0, -29, 12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    4, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -8, -21, -8,
    0, -12, 0, 0, 0, 0, -17, 4,
    0, 0, 0, 4, 0, 0, 0, 0,
    0, -42, -25, -33, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 8, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, -17, 0, -12,
    0, 0, 0, 0, -17, 0, 0, 0,
    0, 0, 0, 0, -25, 0, -25, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -12, 0, 0, 0, 0, -8, 0,
    0, 0, -4, -8, 0, -12, -8, -17,
    -12, 0, -4, 0, 0, 0, -29, 12,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 12, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -12,
    0, -12, 0, -12, -4, 0, 0, 0,
    -8, -4, 0, 0, 0, 0, 0, 0,
    -12, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -17, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    0, -50, -8, -21, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -4, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -12, 0, -8, 0, -16,
    0, 0, 0, 0, -12, 4, 0, 0,
    0, 0, 0, 0, 0, -4, 0, -25,
    -4, -17, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 4, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, -4, 0, -8, 0, -8, 0, 0,
    0, 0, -8, 0, 0, 0, 0, 0,
    0, 0, 0, -8, 0, -50, -12, -21,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 4, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -8,
    0, -12, 0, -12, 4, 0, 0, 0,
    -12, 4, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, -17, 12, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -4,
    0, -8, 0, 0, 0, 0, -8, 0,
    0, 0, 0, 0, 0, 0
};


/*Collect the kern class' data in one place*/
static const lv_font_fmt_txt_kern_classes_t kern_classes = {
    .class_pair_values   = kern_class_values,
    .left_class_mapping  = kern_left_class_mapping,
    .right_class_mapping = kern_right_class_mapping,
    .left_class_cnt      = 53,
    .right_class_cnt     = 46,
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_classes,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 4,
    .kern_classes = 1,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t font_maison_neue_book_26 = {
#else
lv_font_t font_maison_neue_book_26 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 29,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 2,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if ESP_BROOKESIA_FONT_MAISON_NEUE_BOOK_26*/
