# BMI270 滚动检测示例

## 概述

本示例演示了如何使用 BMI270 传感器进行滚动检测。传感器可以检测设备沿 X、Y、Z 轴的绝对朝向，通过比较当前状态与之前状态，可以判断设备绕哪个轴滚动。

## 功能特性

- **朝向检测**：检测沿 X、Y、Z 轴的绝对朝向（每个轴的正/负方向，共 6 个方向）
- **滚动分析**：通过比较朝向变化，判断设备绕哪个轴滚动
- **中断驱动**：使用 GPIO 中断进行高效检测
- **玩具固件**：使用 BMI270 玩具固件增强运动检测能力

## 硬件要求

- ESP32 开发板
- 通过 I2C 连接的 BMI270 传感器
- 用于中断连接的 GPIO 引脚

### 加速度计配置
- **ODR**：200Hz（输出数据率）
- **量程**：±16G（测量范围）
- **带宽**：正常平均 4 个样本
- **滤波器性能**：高性能模式

### 陀螺仪配置
- **ODR**：200Hz（输出数据率）
- **量程**：±2000dps（角速率范围）
- **带宽**：正常模式
- **噪声性能**：功耗优化模式
- **滤波器性能**：高性能模式

### 中断配置
- **引脚**：INT1
- **电平**：低电平有效
- **输出**：推挽输出
- **锁存**：启用

## 滚动检测方向

传感器可以检测 6 个不同方向的绝对朝向：

1. **X 正方向** - 设备 X 轴指向上方
2. **X 负方向** - 设备 X 轴指向下方
3. **Y 正方向** - 设备 Y 轴指向上方
4. **Y 负方向** - 设备 Y 轴指向下方
5. **Z 正方向** - 设备 Z 轴指向上方
6. **Z 负方向** - 设备 Z 轴指向下方

## 滚动分析

通过比较连续的朝向状态，可以判断滚动行为：
- **X 轴滚动**：在 X 正/负方向之间变化
- **Y 轴滚动**：在 Y 正/负方向之间变化
- **Z 轴滚动**：在 Z 正/负方向之间变化
- **复合滚动**：多个轴连续变化

## 使用方法

1. 根据引脚配置将 BMI270 传感器连接到 ESP32 开发板
2. 构建并烧录示例
3. 旋转传感器到不同朝向
4. 示例将检测朝向变化并显示当前的绝对朝向

## 输出示例

当检测到朝向变化时，您应该看到如下输出：

```
I (1637) bmi270_api: BMI270 sensor created successfully
I (1647) MAIN: Rolling feature enabled, result: 0
I (1747) MAIN: Move the sensor to get rolling interrupt...
I (9277) MAIN: 🔄 Rolling: X downside
I (9277) MAIN:    |
I (9277) MAIN:    ↓
I (10537) MAIN: 🔄 Rolling: Z upside
I (10537) MAIN:    ↻
I (11727) MAIN: 🔄 Rolling: Y downside
I (11727) MAIN:    ——→
I (13047) MAIN: 🔄 Rolling: Z upside
I (13047) MAIN:    ↻
I (14147) MAIN: 🔄 Rolling: Y upside
I (14147) MAIN:    ←——
I (15267) MAIN: 🔄 Rolling: Z upside
I (15267) MAIN:    ↻
I (16387) MAIN: 🔄 Rolling: X upside
I (16387) MAIN:    ↑
I (16387) MAIN:    |
I (17587) MAIN: 🔄 Rolling: Z upside
I (17587) MAIN:    ↻
```

## API 函数

### 主要函数
- `bmi270_sensor_create()` - 初始化 BMI270 传感器
- `bmi270_enable_rolling_int()` - 启用滚动检测中断
- `bmi270_sensor_del()` - 清理传感器资源

### 配置函数
- `set_feature_config()` - 配置加速度计和陀螺仪参数
- `bmi270_toy_enable_rolling()` - 在玩具固件中启用滚动功能

## 故障排除

1. **无滚动检测**：检查 I2C 连接和传感器电源
2. **方向错误**：验证传感器方向和安装
3. **中断不工作**：检查 GPIO 配置和中断引脚连接

## 注意事项

- 示例在检测之间使用 3 秒延迟以防止误触发
- 滚动检测需要加速度计和陀螺仪数据
- 传感器必须正确安装和定向以获得准确的检测
