# BMI270 旋转角度检测示例

## 概述

本示例演示了如何使用 BMI270 传感器进行旋转角度检测。传感器可以测量设备的旋转角度并提供实时角度测量。

## 功能特性

- **旋转角度检测**：以 0.01 度为单位测量旋转角度。
- **实时监控**：100ms 轮询的连续角度测量

## 硬件要求

- ESP32 开发板
- 通过 I2C 连接的 BMI270 传感器
- 用于中断连接的 GPIO 引脚

### 加速度计配置
- **ODR**：200Hz（输出数据率）
- **量程**：±16g
- **BWP**：4 样本正常平均
- **滤波器性能**：优化模式

### 陀螺仪配置
- **ODR**：200Hz（输出数据率）
- **量程**：±2000 dps
- **BWP**：正常模式
- **噪声性能**：功耗优化模式
- **滤波器性能**：优化模式

### 旋转参数
- **静态阈值**：0x0014（默认，对桌面放置敏感）
- **鲁棒阈值**：0x0080（用于手持应用）

## 使用方法

1. 根据引脚配置将 BMI270 传感器连接到 ESP32 开发板
2. 构建并烧录示例
3. 将传感器旋转到不同角度
4. 示例将连续测量并显示旋转角度

## 输出示例

当检测到旋转角度时，您应该看到如下输出：

```
I (1637) bmi270_api: BMI270 sensor created successfully
I (1647) MAIN: Rotation feature enabled, result: 0
I (1747) MAIN: Rotate the sensor to get rotation angle...
I (1847) MAIN: Please keep static for a while...
```

### 实时旋转检测

以下是连续旋转角度检测的示例，展示了传感器跟踪平滑旋转运动的能力，可用于手持调光器等应用：

```
I (11837) MAIN:    ↻ -37.39°
I (11937) MAIN:    ↻ -33.87°
I (12037) MAIN:    ↻ -31.26°
I (12137) MAIN:    ↻ -28.50°
I (12237) MAIN:    ↻ -26.10°
I (12337) MAIN:    ↻ -24.92°
I (12437) MAIN:    ↻ -23.31°
I (12537) MAIN:    ↻ -21.21°
I (12637) MAIN:    ↻ -18.70°
I (12737) MAIN:    ↻ -16.56°
I (12837) MAIN:    ↻ -14.18°
I (12937) MAIN:    ↻ -10.74°
I (13037) MAIN:    ↻ -8.38°
I (13137) MAIN:    ↻ -7.22°
I (13237) MAIN:    ↻ -5.98°
I (13337) MAIN:    ↻ -2.67°
I (13437) MAIN:    ↻ -0.51°
I (13537) MAIN:    ↺ +0.41°
I (13637) MAIN:    ↺ +3.84°
I (13737) MAIN:    ↺ +5.09°
I (13837) MAIN:    ↺ +5.69°
I (13937) MAIN:    ↺ +7.08°
```

## 配置函数

### `adjust_rotation_parameter()`
配置旋转检测的静态阈值：
- **默认阈值 (0x0014)**：对桌面放置敏感
- **鲁棒阈值 (0x0080)**：用于手持应用
- **静态检测**：确保设备在角度测量前保持静止

### `set_accel_gyro_config()`
配置加速度计和陀螺仪参数：
- **高 ODR**：200Hz 用于响应式角度检测
- **宽量程**：±16g 加速度计，±2000 dps 陀螺仪
- **优化滤波**：性能和功耗之间的平衡

## 注意事项

- 旋转角度检测基于轮询（100ms 间隔），不是基于中断
- 传感器需要相对静止才能进行准确的角度测量
- 示例使用玩具固件，提供增强的旋转检测能力
- 角度测量以度为单位，精度为 2 位小数
