# ESP_AUDIO_CODEC

ESP Audio Codec 组件是由乐鑫为其系列 SOC 开发的官方音频编码与解码处理模块。

ESP Audio Encoder 提供了统一的编码接口，允许注册多个编码器，如：AAC、AMR-NB、AMR-WB、ADPCM、G711A、G711U、PCM、OPUS、ALAC。用户可以基于这些编码接口创建一个或多个编码实例，这些实例可同时进行编码。同时，用户也可以直接调用指定的编码器 API，以减少调用层级。

ESP Audio Decoder 同样提供了统一的解码接口，允许注册多个解码器，如：AAC、MP3、AMR-NB、AMR-WB、ADPCM、G711A、G711U、VORBIS、OPUS、ALAC。用户可以使用这些接口创建一个或多个解码实例，这些实例可同时进行解码。同时，也可以直接调用某一指定解码器的 API 以减少调用深度。ESP Audio Decoder 仅支持音频帧级别的数据处理（即输入数据必须是帧边界对齐的数据）。

为了简化音频帧的解析与定位，我们设计了 ESP Audio Simple Decoder。它通过内置解析器自动完成数据聚合、帧边界检测和帧结构化处理，随后由 ESP Audio Decoder 执行实际解码。用户可以输入任意长度的数据。支持的容器和格式包括：AAC、MP3、WAV、FLAC、AMR-NB、AMR-WB、M4A。

第三方版权许可记录在 [版权和许可](http://docs.espressif.com/projects/esp-adf/en/latest/COPYRIGHT.html)。

# 亮点

- **统一且易用的接口**  
  ESP Audio Codec 模块提供统一的接口设计，使用简便，便于快速集成和调用。

- **轻量化与高性能**  
  该模块针对核心编解码算法做了深度汇编优化，实现高性能同时保持轻量级和低内存占用。

- **双层解码 API**  
  系统提供两类解码器以满足不同数据输入模式，两类解码器的 API 设计保持一致，便于用户在不同模式间平滑切换。
  - 对于已按帧边界切分的数据，可直接使用 ESP Audio Decoder。
  - 对于任意长度、未对齐帧的数据，可使用 ESP Audio Simple Decoder 自动完成帧检测与拼接。

- **高度可定制的注册机制**  
  通过注册 API，用户可以轻松添加自定义的解码器、编码器或 Simple Decoder，也可在无需修改应用层代码的情况下替换默认的编码器与解码器，实现高度灵活的功能扩展与定制化。
  
# 功能特性

ESP Audio Codec 支持以下功能特性：   

## 编码器   

* 支持以下编码器：
  - AAC
  - AMR-NB 和 AMR-WB
  - ADPCM
  - G711A 和 G711U
  - PCM
  - ALAC
  - OPUS
  - LC3
  - SBC
* 支持所有编码器均可通过统一 API 操作，参见 [esp_audio_enc.h](include/encoder/esp_audio_enc.h)
* 支持通过 `esp_audio_enc_register` 注册自定义编码器或覆盖默认编码器
* 支持通过 `esp_audio_enc_register_default` 注册所有支持的编码器，并通过 menuconfig 进行管理

支持的编码器详细信息如下：  
**AAC**     
- AAC-LC 编码
- 采样率 (Hz)：96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000    
- 声道数：单声道、双声道     
- 采样位宽：16 位    
- 恒定比特率(Kbps)：[12, 160]
- 可选择是否写入 ADTS 头   
  
**AMR**       
- 窄带 (NB) 和宽带 (WB)   
- AMRNB 采样率为 8 kHz       
- AMRWB 采样率为 16 kHz     
- 声道数：单声道    
- 采样位宽：16 位    
- AMRNB 比特率 (Kbps)：4.75, 5.15, 5.9, 6.7, 7.4, 7.95, 10.2, 12.2    
- AMRWB 比特率 (Kbps)：6.6, 8.85, 12.65, 14.25, 15.85, 18.25, 19.85, 23.05, 23.85      
- 不连续传输 (DTX)     
  
**ADPCM**   
- 支持所有采样率    
- 声道数：单声道、双声道    
- 采样位宽：16 位    
  
**G711**    
- 支持 A-LAW 和 U-LAW      
- 支持所有采样率    
- 支持所有声道数    
- 采样位宽：16 位    
  
**OPUS**    
- 采样率 (Hz)：8000, 12000, 16000, 24000, 48000    
- 声道数：单声道、双声道    
- 采样位宽：16 位    
- 比特率编码(Kbps): [20, 510]   
- 编码帧时长 (ms)：2.5, 5, 10, 20, 40, 60, 80, 100, 120       
- VoIP ,音乐和低延迟应用模式       
- 编码复杂度：[0, 10]   
- 带内前向纠错 (FEC)     
- 不连续传输 (DTX)
- 可变比特率 (VBR)
  
**ALAC**    
- 采样率(kHz)：[1, 384]  
- 声道数：[1, 8]  
- 采样位宽：16, 24, 32 位  
  
**SBC**    
- 采样率 (Hz)：16000, 32000, 44100, 48000    
- 声道模式：单声道、双声道、立体声、联合立体声 
- 采样位宽：16 位  
- sbc 模式：标准、msbc
- 块长度：4, 8, 12, 16 
- 子带数：4, 8
- 分配方法：响度、信噪比
- 比特池范围：[2, 250]
  
**LC3**    
- 采样率 (Hz)：8000, 16000, 24000, 32000, 44100, 48000    
- 支持所有声道数
- 采样位宽：16, 24, 32 位  
- 帧时长：75, 100 dms
- nbyte 范围：[20, 400]
- 支持在每个编码帧前添加 2 字节长度字段
  
## 解码器   

* 支持以下解码器：
  - AAC
  - MP3
  - AMR-NB 和 AMR-WB
  - ADPCM
  - G711A 和 G711U
  - OPUS
  - VORBIS
  - FLAC
  - ALAC
  - SBC
  - LC3
* 支持通过统一接口操作，参见 [esp_audio_dec.h](include/encoder/esp_audio_dec.h)
* 支持通过 `esp_audio_dec_register` 注册自定义解码器或覆盖默认解码器
* 支持通过 `esp_audio_dec_register_default` 注册所有支持的解码器，并通过 menuconfig 进行管理
  
支持的解码器详细信息如下：  
**AAC**     
- 支持 AAC-LC、HE-AAC、HE-AACv2
- 支持配置是否启用 AAC-Plus 以降低资源消耗
- 采样率 (Hz)：96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000
- 声道数：单声道、双声道
- 采样位宽：16 位
- 支持有 / 无 ADTS 头文件
   
**AMR**       
- AMRNB 采样率: 8 kHz       
- AMRWB 采样率: 16 kHz     
- 声道数：单声道    
- 采样位宽：16 位  
  
**ADPCM**   
- 支持所有采样率    
- 声道数：单声道、双声道    
- 采样位宽：16 位  
- 支持 IMA-ADPCM
  
**G711**    
- 支持 A-LAW 和 U-LAW      
- 支持所有采样率    
- 支持所有声道数   
- 采样位宽：16 位    
  
**OPUS**    
- 采样率 (Hz)：8000, 12000, 16000, 24000, 48000    
- 声道数：单声道、双声道    
- 采样位宽：16 位      
- 支持自分隔包解码
  
**ALAC**    
- 采样率 (kHz)：[1, 384]    
- 声道数：[1, 8]    
- 采样位宽：16, 24, 32 位 
   
**FLAC**  
- 采样率(kHz)：[8, 192]   
- 声道数：[1, 8]
- 采样位宽：16, 24, 32 位 
  
**VORBIS**  
- 采样率 (Hz)：48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000 
- 声道数：单声道、双声道    
- 采样位宽：16 位
- 仅支持解码 VORBIS 帧，需要移除 OGG 头
- 用户需要首先提供通用头信息
  
**SBC**    
- 采样率 (Hz)：16000, 32000, 44100, 48000    
- 声道：单声道、双声道 
- 采样位宽：16 位  
- sbc 模式：标准、msbc
- 支持丢包隐藏 (PLC)
  
**LC3**    
- 采样率 (Hz)：8000, 16000, 24000, 32000, 44100, 48000    
- 全范围声道
- 采样位宽：16, 24, 32 位  
- 帧时长：75, 100 dms
- nbyte 范围：[20, 400]
- 支持带 2 字节长度前缀的数据
- 支持丢包隐藏 (PLC)
  
## 简单解码器   

* 支持帧查找与解码
* 支持通用解析器，用户可以根据解析器规则添加自定义解析器
* 支持自定义简单解码器以处理新文件格式
* 支持自定义解析器和解码器对：使用默认解析器但使用自定义解码器
* 仅支持流式解码，不支持 seek
  
支持的音频容器详细信息如下：
| 音频容器        | 说明                                            |
|       --       |  --                                             |
|       AAC      | 支持通过配置控制 AAC-Plus                        |
|       MP3      | 支持第 1、2、3 层                                |
|       AMRNB    | 仅支持带 AMRNB 文件头的文件                      |
|       AMRWB    | 仅支持带 AMRWB 文件头的文件                      |
|       FLAC     | 仅支持带 FLAC 文件头的文件                       |
|       ADPCM    | 仅支持 IMA-ADPCM                                |
|       WAV      | 支持 G711A、G711U、PCM、ADPCM                    |
|       M4A      | 支持 MP3、AAC、ALAC <br> 仅支持 MOOV 之后的 MDAT  |
|       TS       | 支持 MP3、AAC                                    |
|       G711     | 支持 G711A、G711U                                |
|       SBC      | 支持 SBC 和 MSBC                                 |
|       LC3      | 支持 LC3                                         |
|       OPUS     | 仅支持原始 opus                                   |
|       PCM      | 仅支持原始 pcm                                    |
|       ALAC     | 仅支持原始 alac                                   |
|       VORBIS   | 仅支持原始 vorbis                                 |
  
# 性能

以下结果在 ESP32-S3R8 平台上测试和收集。可以通过运行测试代码中的 `Encode to Decode chain test` 来获取数据，示例日志输出如下：
```
I (12599) CODEC_TEST: Start to do chain test for AAC sample_rate 48000 channel 2
I (12879) DEC_TEST: Encoder for AAC cpu: 12.91%
I (12880) DEC_TEST: Encoder AAC compress ratio: 5.86% heap usage: 51400
I (12914) DEC_TEST: Decode for AAC cpu: 6.75% heap usage: 51168
```
要获取其他采样率、声道数或复杂度下的性能，请在测试代码中更改参数（主要位于函数 `chain_test_thread` 和 `get_encoder_config` 中）。

## 编码器
| 编码器编解码器 | 采样率 (Hz) | 声道数 | 内存 (KB) | CPU 占用 (%) |
| --            |  --              | --      | --          | --              |
| AAC           | 48000            | 2       | 51.4        | 12.9            |
| G711-A        | 8000             | 1       | 0.06        | 0.32            |
| G711-U        | 8000             | 1       | 0.06        | 0.33            |
| AMR-NB        | 8000             | 1       | 3.3         | 17.81           |
| AMR-WB        | 16000            | 1       | 5.6         | 37.69           |
| ADPCM         | 48000            | 2       | 0.01        | 2.69            |
| OPUS          | 48000            | 2       | 29.4        | 24.9            |
| SBC           | 48000            | 2       | 1.85        | 9.55            |
| LC3           | 48000            | 2       | 3.67        | 46.57           |
  
**说明：**   
编码器 CPU 使用率高度依赖于某些编码设置（如比特率或复杂度）  
 1) 对于 AAC 编码器测试，比特率设置为 90kbps
 2) 对于 AMR-NB 和 AMR-WB 编码器测试，比特率设置为：
    - AMR-NB: 12.2kbps
    - AMR-WB: 8.85kbps
 3) 对于 OPUS 编码器测试，比特率设置为 90kbps，复杂度设置为 0
 4) 内存使用统计说明：
    - 仅统计堆内存（Heap）使用情况，不包含栈内存（Stack）
    - 若需要支持所有编码器，建议运行时栈空间配置约 40k
  
## 解码器
| 解码器编解码器 | 采样率 (Hz) | 声道数 | 内存 (KB) | CPU 占用 (%) |
| --            |  --              | --      | --          | --              |
| AAC           | 48000            | 2       | 51.2        | 6.75            |
| G711-A        | 8000             | 1       | 0.04        | 0.14            |
| G711-U        | 8000             | 1       | 0.04        | 0.13            |
| AMR-NB        | 8000             | 1       | 1.8         | 4.23            |
| AMR-WB        | 16000            | 1       | 5.4         | 9.5             |
| ADPCM         | 48000            | 2       | 0.11        | 2.43            |
| OPUS          | 48000            | 2       | 26.6        | 5.86            |
| MP3           | 44100            | 2       | 28          | 8.17            |
| FLAC          | 44100            | 2       | 89.4        | 8.0             |
| SBC           | 48000            | 2       | 0.21        | 8.14            |
| LC3           | 48000            | 2       | 1.36        | 17.5            |
  
**说明：** 
 1) MP3 和 FLAC 解码器使用真实音频数据测试。其他解码器使用由正弦波 PCM 信号编码生成的数据进行测试 
 2) 对于 AAC 解码器，测试文件以 AAC-LC 文件编码，解码 AAC-Plus（HE-AAC) 文件将具有更高的内存和 CPU 使用率
 3) 内存使用统计说明：
    - 仅统计堆内存（Heap）使用情况，不包含栈内存（Stack）
    - 若需要支持所有解码器，建议运行时栈空间配置约 20k
  
# ESP_AUDIO_CODEC 版本发布与 SoC 兼容性

下表显示了 ESP_AUDIO_CODEC 对乐鑫 SoC 的支持情况。"&#10004;" 表示支持，"&#10006;" 表示不支持。 

|Version      |  ESP32   |   ESP32-S2 |   ESP32-S3 |   ESP32-C2 |  ESP32-C3 |  ESP32-C5 |  ESP32-C6 |   ESP32-P4  |   ESP32-H4 |
|:-----------:|:--------:|:----------:|:----------:|:----------:|:---------:|:---------:|:---------:|:-----------:|:----------:|
|   v1.0.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10006;  | &#10004;  | &#10006;  | &#10006;  |  &#10006;   |  &#10006;  |
|   v2.0.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10006;  | &#10004;  | &#10006;  | &#10004;  |  &#10004;   |  &#10006;  |
|   v2.1.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10006;  |
|   v2.2.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10006;  |
|   v2.3.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10004;  |
|   v2.4.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10004;  |
  
# 使用方法

## 编码器使用
示例用法请参考 [audio_encoder_test.c](test_apps/audio_codec_test/main/audio_encoder_test.c)

## 解码器使用
示例用法请参考 [audio_decoder_test.c](test_apps/audio_codec_test/main/audio_decoder_test.c)

## 简单解码器使用
示例用法请参考 [simple_decoder_test.c](test_apps/audio_codec_test/main/simple_decoder_test.c)
自定义解析器和解码器的用法请参考 [simple_decoder_cust.c](test_apps/audio_codec_test/main/simple_decoder_cust.c)
