# ESP_AUDIO_EFFECTS（音频效果库）

- [English](./README.md)

Espressif Audio Effects（ESP_AUDIO_EFFECTS）是乐鑫为 SoC 打造的官方音频处理模块集合，提供一系列专业且高性能的音频处理算法，可用于修改、增强或塑造音频信号的特性。当前支持的模块包括：自动电平控制（ALC）、采样率转换、位深转换、声道转换、均衡（EQ）、数据交织（Data Weaver）、混音（Mixer）、淡入淡出（Fade）、 Sonic 变速/变调处理、 动态范围控制（DRC）以及多频段动态范围压缩（MBC）。

# 各模块详细介绍入口

下表列出了各模块支持的采样率、声道数与采样位宽。若需了解各模块的功能介绍、性能指标、使用示例等，请点击 `模块` 列中的 README 链接进入相应的文档。

|               模块                          |       采样率（Hz）                                 | 声道数  |  采样位宽            |       数据布局              |    初始支持版本  |
|:-------------------------------------------:|:--------------------------------------------------:|:------:|:-------------------:|:---------------------------:|:--------------:|
| [ALC](docs/README_ALC_CN.md)                |       全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |       v1.0.0     |
| [RATE CONVERSION](docs/README_RATE_CVT_CN.md) | 4–192 kHz，且为 4000 或 11025 的整数倍             | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.0.0     |
| [BIT CONVERSION](docs/README_BIT_CVT_CN.md) |       全范围                                       | 全范围 |  u8, s16, s24, s32  | 交织 与 非交织              |      v1.0.0     |
| [CHANNEL CONVERSION](docs/README_CH_CVT_CN.md)|     全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.0.0     |
| [DATA WEAVER](docs/README_DATA_WEAVER_CN.md)|       全范围                                       | 全范围 |  s16, s24, s32      | —                           |      v1.0.0     |
| [EQUALIZER](docs/README_EQ_CN.md)           |       全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.0.0     |
| [FADE](docs/README_FADE_CN.md)              |       全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.0.0     |
| [MIXER](docs/README_MIXER_CN.md)            |       全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.0.0     |
| [SONIC](docs/README_SONIC_CN.md)            | 4–192 kHz，且为 4000 或 11025 的整数倍             | 全范围 |  s16, s24, s32      | 交织                         |      v1.0.0     |
| [DRC](docs/README_DRC_CN.md)                |       全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.2.0     |
| [MBC](docs/README_MBC_CN.md)                |       全范围                                       | 全范围 |  s16, s24, s32      | 交织 与 非交织              |      v1.2.0     |

# 版本发布与 SoC 兼容性

下表展示 ESP_AUDIO_EFFECTS 在各款乐鑫 SoC 上的支持情况。“✔” 表示支持，“✘” 表示不支持。

|Version      |  ESP32   |   ESP32-S2 |   ESP32-S3 |   ESP32-C2 |  ESP32-C3 |  ESP32-C5 |  ESP32-C6 |   ESP32-P4  |   ESP32-H4 |
|:-----------:|:--------:|:----------:|:----------:|:----------:|:---------:|:---------:|:---------:|:-----------:|:----------:|
|   v1.0.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10006;  |
|   v1.0.1    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10006;  |
|   v1.0.2    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10006;  |
|   v1.1.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10004;  |
|   v1.2.0    | &#10004; |  &#10004;  |  &#10004;  |  &#10004;  | &#10004;  | &#10004;  | &#10004;  |  &#10004;   |  &#10004;  |
