# 声道转换（CHANNEL CONVERSION）

- [English](./README_CH_CVT.md)

`CHANNEL CONVERSION` 模块用于将原始音频的声道数转换为目标声道数。其算法原理为：用指定的权重矩阵与输入数据相乘并求和，得到输出数据。

## 特性

- 支持全范围采样率与声道
- 支持位深：s16、s24、s32
- 支持数据布局：交织（interleaved）、非交织（non-interleaved）

## 性能

测试配置：

| 芯片 | IDF 版本 | CPU 频率 | SPI RAM 频率 |
| -- | -- | -- | -- |
| ESP32-S3R8 | v5.3 | 240MHz | 80MHz |

| 位深 | 堆内存（Byte） | CPU 负载（%） |
| -- | -- | -- |
| 16 | 40 | < 0.07 |
| 24 | 40 | < 0.20 |
| 32 | 40 | < 0.24 |

说明：
1) 该测试结果基于 8 kHz 双声道转换为单声道，且声道转换数组包含两个非零系数。
2) 声道转换的 CPU 负载可按公式估算：`sample_rate / 8000 * non_zero_cof_num / 2`，其中 `non_zero_cof_num` 为权重数组中的非零系数个数。
3) 表中 CPU 负载为平均值。

## 使用

使用示例参见：[CHANNEL CONVERSION](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

## 常见问题（FAQ）

1) CHANNEL CONVERSION 的工作原理是什么？
   > 通过系数数组运算实现将一种声道布局转换为另一种。算法形式如下，并给出示例：
   > A1、A2、A3 表示三声道输入；B1、B2 表示两声道输出；Wxx 为权重系数。
   > 算法表示：
   >
   > B1 = W1 × A1 + W2 × A2 + W3 × A3;
   >
   > B2 = W4 × A1 + W5 × A2 + W6 × A3;
   >
   > 例如，权重为 {0.5, 0, 0.5, 0, 0.6, 0.4}：
   >
   > B1 = 0.5 × A1 + 0 × A2 + 0.5 × A3;
   >
   > B2 = 0 × A1 + 0.6 × A2 + 0.4 × A3;
   >
   > 若未设置权重数组，则默认所有权重为 1/src_ch_num。

2) 增益过高会失真吗？
   > 会。若增益设置过高，混合后的信号可能超过最大允许幅度，导致削顶失真。

3) 如何选择合适的声道转换系数？
   > 声道转换所用系数受扬声器布局影响。根据 Dolby 标准，以下表格给出不同输出格式对应的布局与换算关系：
   
   | 声道布局 | Mono | Left | Right | Front Left | Front Right | Center | 低频效果（LFE） | Surround Left | Surround Right | Back Left | Back Right |
   |:--:|:--:|:--:|:--:|:--:|:--:|:--:|:--:|:--:|:--:|:--:|:--:|
   | 术语 | M | L | R | FL | FR | C | LFE | SL | SR | BL | BR |

   a. **MONO**

   | 输出 | Mono | Stereo | Quad | 5.1 | 7.1 |
   |:--:|:--:|:--:|:--:|:--:|:--:|
   | M | M | L×0.707+R×0.707 | FL×0.5+FR×0.5+SL×0.5+SR×0.5 | FL×0.447+FR×0.447+C×0.447+BL×0.447+BR×0.447 | FL×0.378+FR×0.378+C×0.378+SL×0.378+SR×0.378+BL×0.378+BR×0.378 |

   b. **STEREO**

   | 输出 | Mono | Stereo | Quad | 5.1 | 7.1 |
   |:--:|:--:|:--:|:--:|:--:|:--:|
   | L | M×0.707 | L | FL+SL×0.707 | FL+C×0.707+BL×0.707 | FL+C×0.707+SL×0.707+BL×0.596 |
   | R | M×0.707 | R | FR+SR×0.707 | FR+C×0.707+BR×0.707 | FR+C×0.707+SR×0.707+BR×0.596 |

   c. **QUAD**

   | 输出 | Mono | Stereo | Quad | 5.1 | 7.1 |
   |:--:|:--:|:--:|:--:|:--:|:--:|
   | FL | M×0.707 | L | FL | FL+C×0.707 | FL×0.965+FR×0.258+C×0.707+SL×0.707 |
   | FR | M×0.707 | R | FR | FR+C×0.707 | FL×0.258+FR×0.965+C×0.707+SR×0.707 |
   | SL |  |  | SL | BL | SL×0.707+BL×0.965+BR×0.258 |
   | SR |  |  | SR | BR | SR×0.707+BL×0.258+BR×0.965 |

   d. **5.1**

   | 输出 | Mono | Stereo | Quad | 5.1 | 7.1 |
   |:--:|:--:|:--:|:--:|:--:|:--:|
   | FL | M×0.707 | L | FL×0.961 | FL | FL+SL×0.367 |
   | FR | M×0.707 | R | FR×0.961 | FR | FR+SR×0.367 |
   | C  |  |  |  | C | C |
   | LFE |  |  |  | LFE | LFE |
   | SL |  |  | FL×0.274+SL×0.960+SR×0.422 | BL | SL×0.930+BL×0.700+BR×0.460 |
   | SR |  |  | FR×0.274+SL×0.422+SR×0.960 | BR | SR×0.930+BL×0.460+BR×0.700 |

   e. **7.1**

   | 输出 | Mono | Stereo | Quad | 5.1 | 7.1 |
   |:--:|:--:|:--:|:--:|:--:|:--:|
   | FL | M×0.707 | L | FL×0.939 | FL | FL |
   | FR | M×0.707 | R | FR×0.939 | FR | FR |
   | C  |  |  |  | C | C |
   | LFE |  |  |  | LFE | LFE |
   | SL |  |  | FL×0.344+SL×0.344 | BL×0.883 | SL |
   | SR |  |  | FR×0.344+SR×0.344 | BR×0.883 | SR |
   | BL |  |  | SL×0.939 | BL×0.470 | BL |
   | BR |  |  | SR×0.939 | BR×0.470 | BR |
