# 数据交织器（DATA WEAVER）

- [English](./README_DATA_WEAVER.md)

`DATA WEAVER` 模块用于将分别存储的多路声道数据交织在一起，或将交织数据拆分为各声道的独立缓冲区。

## 特性

- 支持全范围采样率与声道
- 支持位深：s16、s24、s32

## 性能

测试配置：

| 芯片 | IDF 版本 | CPU 频率 | SPI RAM 频率 |
| -- | -- | -- | -- |
| ESP32-S3R8 | v5.3 | 240MHz | 80MHz |

| 位深 | 堆内存（Byte） | CPU 负载（%） |
| -- | -- | -- |
| 16 | 0 | < 0.05 |
| 24 | 0 | < 0.05 |
| 32 | 0 | < 0.05 |

说明：
1) 测试音频为 8 kHz 单声道。不同采样率和声道配置下的 CPU 负载可按如下公式估算：
   > CPU Load = (sample_rate / 8000) × channel_count × base_load
   其中 `base_load` 为表格所列基准负载。
2) 表中 CPU 负载为平均值。

## 使用

示例参见：[DATA WEAVER](../test_app/main/test_data_weaver.c)

## 常见问题（FAQ）
1) Data Weaver 有何作用？
   > 在音频处理中，既有交织也有非交织的数据处理模块，这主要源于不同的应用场景与需求：
   - 交织数据处理：
     - 传输效率高：在实时音频流或大数据量处理时更有优势；
     - 多声道同时处理：常用于需要同步处理多通道的场景；
     - 兼容性：许多工具与库默认支持交织格式，便于跨平台互操作。
   - 非交织数据处理：
     - 独立声道控制：当需要对各通道独立处理（如均衡）时更适合；
     - 模块化系统：在分模块处理各通道的系统中，非交织更便于模块化设计与处理。
