# DRC（动态范围控制）

- [English](./README_DRC.md)

动态范围控制（Dynamic Range Control, DRC）是一种音频处理技术，用于根据不同的播放环境和设备，调节音频信号的动态范围。动态范围表示音频信号中最安静与最响亮部分之间的差值。

DRC 覆盖压缩器、扩展器、限幅器以及噪声门等处理方式，这些方式通过应用增益曲线来调节信号电平。关键步骤包括增益平滑与补偿增益（Makeup Gain），以在避免过载和不必要噪声的同时，保证音质。

# 特性

- 支持所有采样率与声道数
- 支持采样位宽：s16、s24、s32
- 支持最多 6 个分段点的动态范围曲线配置
- 支持补偿增益范围：[-10.0, 10.0] dB
- 支持攻击时间范围：[0, 500] ms
- 支持释放时间范围：[0, 500] ms
- 支持保持时间范围：[0, 100] ms
- 支持膝宽范围：[0.0, 10.0] dB，用于平滑阈值过渡
- 支持数据布局：交织（interleaved）、非交织（non-interleaved）
- 支持就地（in-place）处理

# 性能

系统 menuconfig 配置：

|   HW_Version   | IDF_Version  | CPU Frequency | SPI Ram  |
|       --       |     --       |      --       |    --    |
|   ESP32-S3R8   | release/v5.5 |    240MHz     |  80MHz   |

| 采样位宽 (bits) | 内存 (Byte) | CPU 占用(%) |
|       --        |     --      |     --       |
|      16         |   < 11K     |    < 0.4     |
|      24         |   < 11K     |    < 0.5     |
|      32         |   < 11K     |    < 0.4     |

说明：
1) 测试音频为 8k 单声道，其它采样率与声道数的 CPU 占用约按 `sample rate / 8000 * channel` 成比例变化。
2) 表中 CPU 占用为平均值。

# DRC 曲线场景

下表展示了不同 DRC 曲线场景的示意与应用：

| 场景                 | 输出行为                 | 典型应用                 | 示意图 |
| -------------------- | ------------------------ | ------------------------ | ------ |
| 向下压缩（Compressor） | 降低大音量峰值           | 降噪、增强静音段细节       | <img src="_static/down_compress.PNG" width="200"/> |
| 向上压缩             | 提升低电平细节           | 提高语音可懂度           | <img src="_static/up_compress.PNG" width="200"/> |
| 向下扩展（Expander）   | 衰减低电平噪声           | 降噪、增强静音段          | <img src="_static/down_expander.PNG" width="200"/> |
| 向上扩展             | 增强动态对比度           | 音乐制作                 | <img src="_static/up_expander.PNG" width="200"/> |
| 噪声门（Noise Gate）   | 消除背景噪声             | 录音、现场扩声           | <img src="_static/noise_gate.PNG" width="200"/> |
| 限幅器（Limiter）       | 防止削波                 | 母带、广播               | <img src="_static/limiter.PNG" width="200"/> |

# 使用

使用示例参见：[DRC](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

# 常见问题（FAQ）

1) 曲线点（curve points）有什么作用？

    曲线点定义了 DRC 的动态范围曲线，决定输入信号电平映射到输出电平的方式。每个曲线点包含：

    - x 坐标：输入电平（dB）
    - y 坐标：输出电平（dB）

    要求：
    - 曲线必须包含 **0 dB** 与 **-100 dB** 两个点
    - 最多可定义 **6 个**点

    通过这些点可以设计不同的压缩、限幅或扩展曲线，描述 DRC 在不同输入电平下的响应。

2) 硬膝（hard knee）与软膝（soft knee）有什么区别？

    - 硬膝（`knee_width = 0`）：
      当信号超过阈值时立即施加压缩，曲线在阈值处拐角明显。

    - 软膝（`knee_width > 0`）：
      在阈值附近的一个范围内逐渐引入压缩，过渡更平滑。`knee_width` 越大，逐步引入压缩的 dB 范围越宽。

3) 如何设置攻击（Attack）、释放（Release）与保持（Hold）时间？有哪些典型应用？

    攻击时间（`attack_time`）

    - 定义：控制增益衰减的响应时间。
    - 范围：0 – 500 ms
    - 典型应用：
      - 短攻击（<10 ms）：快速压制瞬态峰值，如爆破音、鼓击或短促噪声。
      - 长攻击（>30 ms）：保留人声、吉他、打击乐等的瞬态，听感更自然。

    释放时间（`release_time`）

    - 定义：控制增益恢复的响应时间。
    - 范围：0 – 500 ms
    - 典型应用：
      - 短释放（50–100 ms）：提升语音清晰度，适合实时通信。
      - 长释放（200–500 ms）：音乐播放或母带处理中提供平滑的增益恢复，有助于避免“喘泵”（pumping）。

    保持时间（`hold_time`）

    - 定义：控制增益变化的延迟时间。
    - 范围：0 – 100 ms（建议小于攻击与释放时间）
    - 典型应用：
      - 语音：抑制因短暂停顿导致的频繁增益变化，降低“呼吸感”。
      - 音乐：稳定动态范围，避免不自然的电平波动。
