# EQ（均衡器）

- [English](./README_EQ.md)

`EQ`（均衡器）模块用于对声音进行音质调整。它可以补偿扬声器和声学环境的缺陷，修饰不同来源的声音，并提供额外的专业功能。均衡器的核心是滤波器，一个均衡器由多个滤波器组合而成。不同滤波器的作用各不相同，下面将逐一说明。

## 特性

- 支持全采样率与多声道
- 支持位深：s16、s24、s32
- 支持单个或多个滤波器组合
- 支持滤波器类型：高通（High Pass）、低通（Low Pass）、高搁架（High Shelf）、低搁架（Low Shelf）、峰值（Peak）
- 支持实时调整滤波器的设计参数
- 支持数据布局：交织（interleaved）、非交织（deinterleaved）

## 性能

测试环境：

| 芯片 | IDF 版本 | CPU 频率 | SPI RAM 频率 |
| -- | -- | -- | -- |
| ESP32-S3R8 | v5.3 | 240MHz | 80MHz |

| 位深 | 堆内存（Byte） | CPU 占用（%） |
| -- | -- | -- |
| 16 | 128 | 0.09 |
| 24 | 2176 | 0.23 |
| 32 | 128 | 0.20 |

说明：
1) 测试音频为 8 kHz 单声道。不同采样率与声道下的 CPU 占用可用下式估算：
   > CPU_Load = (sample_rate / 8000) × channel_count × filter_num × base_load
   其中 `base_load` 为上表中的基准占用。
2) 表格中的 CPU 占用为平均值。

## 使用

示例参见：[EQ 用例](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

## 常见问题（FAQ）

1) 参数均衡器适用于哪些音频处理场景？
   > 参数均衡器适用于音乐录音、混音、基带处理、音频修复，以及音乐播放器和音响系统。它提供精细的音频调校能力，使音色塑形与平衡更为精准。

2) 如何选择参数均衡器的滤波模式、中心频率、增益和 Q 值？
   > 每个 EQ 频段都可独立控制并可禁用。用户可以为每个频段选择滤波模式并设置滤波参数。下表概述了在不同滤波模式下可配置的参数：
   
   | 滤波模式 | fc（中心/截止频率） | Q 值 | 增益 |
   |:--:|:--:|:--:|:--:|
   | High Pass | 是 | 是 | 否 |
   | Low Pass  | 是 | 是 | 否 |
   | High Shelf| 是 | 是 | 是 |
   | Low Shelf | 是 | 是 | 是 |
   | Peak      | 是 | 是 | 是 |

   接下来对各类滤波器的参数选择及其对音频的影响进行说明：
   - 低通滤波器（LPF）：衰减高于某一 `fc` 的频率，保留较低频率。常用于去除高频噪声或多余的高频成分。本模式可设置 `fc` 与 `Q 值`：
     - `fc` 定义了从哪个频率开始音量下降；LPF 的 `fc` 为所有 EQ 频段中 `fc` 的最大值。
     - `Q 值`影响共振：`Q=0.7` 时无共振峰，`fc` 处电平约 -3 dB；`Q=1.0` 时在 `fc` 以下出现共振峰，`fc` 处约 0 dB；`Q=2.0` 时在 `fc` 处出现约 +6 dB 的峰值。
   - 高通滤波器（HPF）：衰减低于某一截止点的频率，保留更高频率。用于去除低频轰鸣或不需要的低频。本模式可设置 `fc` 与 `Q 值`：
     - `fc` 定义了截至到哪个频率之前会有音量下降；HPF 的 `fc` 为所有 EQ 频段中 `fc` 的最小值。
     - `Q 值`特性参考低通 LPF 的说明。
   - 低搁架滤波器（LSF）：对低于 `fc` 的频率整体提升或衰减，高于 `fc` 的频率基本不变。用于增强或减少低频（低音）响应。本模式可设置 `fc`、`Q 值` 和 `增益`：
     - `fc` 定义了从哪个频率之前会出现音量的提升或衰减。
     - `增益`控制 `fc` 之前的音量提升/衰减幅度。
     - `Q 值`特性参考低通 LPF。
   - 高搁架滤波器（HSF）：对高于 `fc` 的频率整体提升或衰减，低于 `fc` 的频率基本不变。用于增加明亮度或暖感：
     - `fc` 定义了从哪个频率之后会出现音量的提升或衰减。
     - `增益`控制 `fc` 之后的音量提升/衰减幅度。
     - `Q 值`特性参考低通 LPF。
   - 峰值滤波器（Peak）：围绕中心频率 `fc` 在一定带宽内进行提升或削减，适合做精细频点处理或营造共振效果。本模式可设置 `fc`、`Q 值` 与 `增益`：
     - `fc` 控制输出相对输入出现峰值的位置。
     - `增益` 控制 `fc` 处的增益大小。
     - `Q 值` 控制受影响频带（以 `fc` 为中心）的带宽；`Q` 越小，影响越宽（峰更平缓）；`Q` 越大，影响越窄（峰更陡峭）。
