# 淡入淡出（FADE）

- [English](./README_FADE.md)

`FADE` 模块通过逐步增减音量来平滑引入或移除声音，从而实现顺滑的过渡效果。

## 特性

- 支持全范围采样率与声道
- 支持位深：s16、s24、s32
- 支持模式：淡入（fade in）、淡出（fade out）
- 支持曲线：线性（line）、二次（quadratic）、平方根（sqrt）
- 支持数据布局：交织、非交织

## 性能

测试配置：

| 芯片 | IDF 版本 | CPU 频率 | SPI RAM 频率 |
| -- | -- | -- | -- |
| ESP32-S3R8 | v5.3 | 240MHz | 80MHz |

| 位深 | 堆内存（Byte） | CPU 负载（%） |
| -- | -- | -- |
| 16 | 4.5k | < 0.2 |
| 24 | 4.5k | < 0.2 |
| 32 | 4.5k | < 0.2 |

说明：
1) 测试基于 10 秒时长的 8 kHz 单声道音频，淡变时长为 10 秒。
2) 其他采样率与声道的 CPU 负载约为 `sample_rate / 8000 × channel` 倍。
3) 内存使用与过渡时间有关，约为 `2 × transition_time(ms)`。

## 使用

示例参见：[FADE](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

## 常见问题（FAQ）
1) 淡入淡出适用场景？
   > 可实现更平滑自然的音频起止，避免突兀；降低不必要噪声，提升听感。

2) 如何选择淡变曲线？
   - 线性曲线：全程均匀变化，过渡感一致。
   - 平方曲线（square/二次）：前期变化缓慢，后期加速，更平滑自然的起始效果。
   - 平方根曲线（sqrt）：前期变化较快，后期放缓，适合突出段首与结尾的动态感。
