# MBC（多段压缩器）

- [English](./README_MBC.md)

`MBC（Multi-Band Compressor，多段压缩器）` 是一款高级的音频动态处理模块，提供按频率选择性的压缩能力。不同于传统的单段压缩器对整个频谱一刀切地处理，MBC 将输入信号划分为多个频带，并对每个频带分别进行独立的压缩处理。

# 特性

- 支持所有采样率与声道数
- 支持采样位宽：s16、s24、s32
- 四分频（四频带）结构，分频点可配置
- 各频带具备独立压缩参数
- 支持阈值范围：(-100, 0) dB
- 支持压缩比范围：[1, +∞)
- 支持补偿增益范围：[-10, 10] dB
- 支持攻击时间范围：[0, 500] ms
- 支持释放时间范围：[0, 500] ms
- 支持保持时间范围：[0, 100] ms
- 支持膝宽范围：[0, 10] dB，用于平滑阈值过渡
- 支持各频带的独奏（solo）与旁路（bypass）功能
- 支持数据布局：交织（interleaved）、非交织（non-interleaved）
- 支持就地（in-place）处理

# 性能

系统 menuconfig 配置：
|   HW_Version   | IDF_Version  | CPU Frequency | SPI Ram  |
|       --       |     --       |      --       |    --    |
|   ESP32-S3R8   | release/v5.5 |    240MHz     |  80MHz   |

| 采样位宽 (bits) | 内存 (Byte) | CPU 占用(%) |
|       --        |     --      |     --       |
|      16         |   < 43K     |    < 3.2     |
|      24         |   < 43K     |    < 4.1     |
|      32         |   < 44K     |    < 4.7     |

说明：
1) 测试音频为 8k 单声道，其它采样率与声道数的 CPU 占用约按 `sample rate / 8000 * channel` 成比例变化。
2) 表中 CPU 占用为平均值。

# 模块架构

## 频带划分

MBC 通过 3 个分频点将音频频谱划分为 4 个频带：

<img src="_static/mbc_crossover.PNG" width="300"/>

## 压缩参数

每个频带都可以配置独立的压缩参数：

<img src="_static/mbc_param.png" width="300"/>

| 参数 | 描述 | 取值范围 | 影响 |
|------|------|----------|------|
| **Threshold（阈值）** | 开始进入压缩的电平 | (-100, 0) dB | 决定何时激活压缩 |
| **Ratio（比率）** | 压缩强度 | [1, +∞) | 控制压缩力度 |
| **Makeup Gain（补偿增益）** | 压缩后的电平补偿 | [-10, 10] dB | 恢复整体响度 |
| **Attack Time（攻击时间）** | 增益衰减速度 | [0, 500] ms | 压缩响应速度 |
| **Release Time（释放时间）** | 增益恢复速度 | [0, 500] ms | 压缩释放速度 |
| **Hold Time（保持时间）** | 触发后增益改变的延迟 | [0, 100] ms | 防止过快的增益抖动 |
| **Knee Width（膝宽）** | 阈值过渡的平滑程度 | [0, 10] dB | 0 为硬膝，>0 为软膝 |

## MBC 信号处理流程

MBC 遵循如下的结构化信号处理流程：

```
输入音频信号
        ↓
   [预处理]
        ↓
[频带分频器] ← Linkwitz-Riley 分频滤波器
        ↓
    +-----------+-----------+-----------+-----------+
    |    Low    |  Low-Mid  | High-Mid  |    High   |
    +-----------+-----------+-----------+-----------+
        ↓
   [频带混合]
        ↓
   [后处理]
        ↓
   输出音频信号
```

## 独奏与旁路功能

MBC 为每个频带提供独奏与旁路功能：

### 独奏（Solo）
- 目的：只监听某一频带，同时静音其它频带
- 适用场景：混音/母带处理中对单频带的监听
- API：`esp_ae_mbc_set_solo()` 与 `esp_ae_mbc_get_solo()`

### 旁路（Bypass）
- 目的：使选定频带不经过压缩处理直接通过
- 适用场景：临时关闭特定频段的压缩
- API：`esp_ae_mbc_set_bypass()` 与 `esp_ae_mbc_get_bypass()`

# 使用

使用示例参见：[MBC](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

# 常见问题（FAQ）

1) MBC 与单段压缩有何不同？

    MBC 通过对不同频率范围独立处理，提供更精细的控制。单段压缩对整个频谱统一作用，而 MBC 允许：
    - 对低频更强力地压缩，以控制低频轰鸣
    - 对中频轻柔压缩，以保留人声清晰度
    - 针对不同频段设置不同的攻击/释放时间
    - 定向处理特定频率问题，而不影响其它频段

2) 分频点如何设置？

    分频点选择取决于音频内容与目标：

    - **低频带（0Hz 至 low_fc）**：80–200Hz，用于低频控制
    - **低中频带（low_fc 至 mid_fc）**：200Hz–2kHz，覆盖人声与基音
    - **高中频带（mid_fc 至 high_fc）**：2–8kHz，增强存在感与清晰度
    - **高频带（high_fc 至 Nyquist）**：8–20kHz，增强空气感与明亮度

    一般建议：
    - 避免将分频点设置在重要乐器的基频附近
    - 分频点间隔保持约 1.5–2 倍频程，利于干净的频带分离
    - 结合 Fletcher-Munson 等响曲线进行心理声学优化

3) 不同应用的典型参数如何设置？

    **人声增强（Vocal Enhancement）**
    - 低频带（0–400Hz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 低中频带（400Hz–2.1kHz）：重压缩（4:1，比率，-18dB 阈值，1ms 攻击，200ms 释放，6dB 补偿增益）
    - 高中频带（2.1kHz–6kHz）：重压缩（4:1 比率，-20dB 阈值，1ms 攻击，200ms 释放，7dB 补偿增益）
    - 高频带（6kHz+）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 分频点：400Hz、2.1kHz、6kHz

    **低频增强（Bass Enhancement）**
    - 低频带（0–80Hz）：重压缩（2.5:1 比率，-20dB 阈值，1ms 攻击，200ms 释放，6dB 补偿增益）
    - 低中频带（80Hz–250Hz）：中等压缩（2:1 比率，-18dB 阈值，1ms 攻击，200ms 释放，6dB 补偿增益）
    - 高中频带（250Hz–10kHz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 高频带（10kHz+）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 分频点：80Hz、250Hz、10kHz

    **高频增强（Treble Enhancement）**
    - 低频带（0–120Hz）：轻压缩（2.5:1 比率，-10dB 阈值，10ms 攻击，100ms 释放，-2dB 增益）
    - 低中频带（120Hz–4.5kHz）：轻压缩（2:1 比率，-10dB 阈值，10ms 攻击，100ms 释放，-2dB 增益）
    - 高中频带（4.5kHz–10kHz）：中等压缩（1.8:1 比率，-20dB 阈值，10ms 攻击，100ms 释放，5dB 补偿增益）
    - 高频带（10kHz+）：中等压缩（2:1 比率，-22dB 阈值，10ms 攻击，100ms 释放，5dB 补偿增益）
    - 分频点：120Hz、4.5kHz、10kHz

    **对讲机风格（Walkie-Talkie）**
    - 低频带（0–991Hz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 低中频带（991Hz–2.57kHz）：极重压缩（4:1 比率，-30dB 阈值，10ms 攻击，100ms 释放，18dB 补偿增益）
    - 高中频带（2.57kHz–10kHz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 高频带（10kHz+）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 分频点：991Hz、2.57kHz、10kHz

    **玩具音效（Toy Audio）**
    - 低频带（0–921Hz）：重限幅（20:1 比率，-60dB 阈值，10ms 攻击，100ms 释放，-18dB 增益）
    - 低中频带（921Hz–1.78kHz）：中等压缩（3:1 比率，-30dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 高中频带（1.78kHz–4kHz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 高频带（4kHz+）：重限幅（20:1 比率，-60dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 分频点：921Hz、1.78kHz、4kHz

    **齿音抑制（Sibilance Reduction）**
    - 低频带（0–54.8Hz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 低中频带（54.8Hz–4kHz）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 高中频带（4kHz–10.15kHz）：重压缩（4:1 比率，-25dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 高频带（10.15kHz+）：旁路（1:1 比率，0dB 阈值，10ms 攻击，100ms 释放，0dB 增益）
    - 分频点：54.8Hz、4kHz、10.15kHz

    **广播（Broadcast）**
    - 低频带（0–137Hz）：中等压缩（3:1 比率，-20.2dB 阈值，1ms 攻击，100ms 释放，1dB 补偿增益）
    - 低中频带（137Hz–1.15kHz）：轻压缩（2:1 比率，-17.6dB 阈值，1ms 攻击，100ms 释放，0dB 增益）
    - 高中频带（1.15kHz–6.91kHz）：轻压缩（2:1 比率，-24.8dB 阈值，1ms 攻击，100ms 释放，0dB 增益）
    - 高频带（6.91kHz+）：中等压缩（3:1 比率，-25dB 阈值，1ms 攻击，100ms 释放，3dB 补偿增益）
    - 分频点：137Hz、1.15kHz、6.91kHz

    **流行音乐母带（Pop Music Master）**
    - 低频带（0–120Hz）：中等压缩（2.3:1 比率，-22dB 阈值，2ms 攻击，100ms 释放，0dB 增益）
    - 低中频带（120Hz–2kHz）：中等压缩（2.6:1 比率，-22dB 阈值，3ms 攻击，100ms 释放，0dB 增益）
    - 高中频带（2kHz–10kHz）：中等压缩（2.6:1 比率，-22dB 阈值，2.5ms 攻击，100ms 释放，0dB 增益）
    - 高频带（10kHz+）：重压缩（3:1 比率，-30dB 阈值，3ms 攻击，100ms 释放，0dB 增益）
    - 分频点：120Hz、2kHz、10kHz
