# RATE CONVERSION

- [中文版](./README_RATE_CVT_CN.md)

`RATE CONVERSION` module is used to change the sampling rate of the original audio signal to the desired sampling rate.

# Features

- Support sample rates (Hz) that are integer multiples of 4000 and 11025, with a maximum value of 192000
- Support all channel number
- Support bits per sample: s16, s24, s32
- Support complexity: 1, 2, 3

# Performance

Tested with the following system configuration:  
|      Chip      | IDF Version  | CPU Frequency | SPI Ram Frequency |
|       --       |      --      |  --           |     --            |
|   ESP32-S3R8   |      v5.3    | 240MHz        |   80MHz           |

## CPU loading(%)

Input sample rate is **8000 mono**<br>
|complexity   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:| 
|  1          | 0.3    |   0.3  |  0.2   |   0.6  |  0.3   |   0.5  |  1.2   |  0.7   |   0.9  |  2.4   |  1.3   |
|  2          | 1.4    |   0.4  |  0.3   |   2.7  |  0.4   |   0.6  |  5.3   |  0.9   |   1.2  |  10.5  |  1.7   |
|  3          | 2.2    |   0.5  |  0.4   |   4.3  |  0.5   |   0.7  |  8.5   |  1.0   |   1.3  |  17.0  |  1.9   |

Input sample rate is **11025 mono**<br>
|complexity   | 8000   | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |  0.3   | 0.5    |   0.3  |  0.7   |  1.7   |  0.6   | 1.3    |  3.4   |  1.2   | 5.1    |
|  2          |  0.4   |  0.4   | 2.1    |   0.4  |  0.9   |  4.1   |  0.8   | 6.1    |  8.2   |  1.6   | 12.1   |
|  3          |  1.4   |  0.5   | 3.2    |   0.5  |  4.8   |  6.4   |  0.9   | 9.6    |  12.9  |  1.8   | 19.2   |

Input sample rate is **12000 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |  0.3   |   0.5  |	 0.6  |	  0.4  |   0.9  |	1.2  |	 0.7  |   1.7  |   2.4  |  1.3   |
|  2          |  0.3   |  0.4   |   0.6  |	 0.7  |	  0.5  |   1.0  |   1.4  |	 0.9  |   2.1  |   2.8  |  1.7   |
|  3          |  0.3   |  0.4   |   0.6  |	 0.9  |	  0.5  |   1.2  |	1.7  |	 1.0  |   2.4  |   3.3  |  2     |

Input sample rate is **16000 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.2   |   0.4	|   0.4	 |	 0.7  |	 0.7   |  0.5	|   1.3	 |  0.7	  |   0.9  |   2.4	|   1.3  |
|  2          |  0.2   |   1.4	|   0.4	 |	 2.7  |	 0.8   |  0.6	|   5.3  |	0.9	  |   1.2  |   10.5	|   1.7  |
|  3          |  0.3   |   2	|   0.5	 |	 4.3  |	 0.9   |  0.7	|   8.6	 |  1.0	  |   1.4  |   17.0	|   2.0  |

Input sample rate is **22050 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |  0.2	|   0.4	 |   0.5  |	  0.7  |   0.9	|   0.7	 |  1.4   |	 3.5   |  1.3	|   2.6  |
|  2          |  0.4   |  0.3	|   0.5	 |   0.7  |	  0.8  |   4.1	|   0.9	 |  1.8	  |  8.2   |  1.6	|   12.1 |
|  3          |  2.7   |  0.4	|   0.5	 |   2.9  |	  1.0  |   6.5	|   1.0  | 	9.7	  |  12.9  |  1.9	|   19.3 |

Input sample rate is **24000 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.2   |   0.4	|   0.3	 |   0.5  |	 0.7   |  0.9	|   1.3	 |   0.7  |	  1.7  |  2.4	|   1.4  |
|  2          |  0.3   |   0.5	|   0.3	 |   0.6  |  0.7   |  1.1	|   1.5	 |   1.0  |	  2.1  |  2.9	|   1.8  |
|  3          |  0.4   |   0.7	|   0.4	 |   0.7  |  0.8   |  1.3	|   1.7	 |   1.1  |	  2.4  |  3.3	|   2.0  |

Input sample rate is **32000 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |   0.5	|   0.5  |   0.4  |	  0.4  |   0.8  |   1.4  |  1.4   |	 1.0   |  2.5	|   1.4  |
|  2          |  0.4   |   2.3	|   0.5	 |   0.5  |	  0.5  |   0.8  |   5.4  |  1.6   |  1.3   |  10.6  |	1.8  |
|  3          |  0.4   |   3.7	|   0.6	 |   0.5  |	  0.5  |   0.9  |   8.7  |  1.9   |	 1.4   |  17.2  |	2.1  |

Input sample rate is **44100 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.4   |   0.4	|  0.5	 |  0.6   |	  0.5  |  0.8   |	1.1  |  1.4   |	  1.9  |  1.4	|   2.7  |
|  2          |  0.6   |   0.5	|  0.7	 |  0.8	  |   0.6  |  1.0   |	1.4  |  1.7   |	  8.3  |  1.7	|   3.6  |
|  3          |  5.1   |   0.6	|  0.8	 |  5.3	  |   0.7  |  1.1   |	5.7  |  2.0   |	  12.9 |  2.0	|   19.4 |

Input sample rate is **48000 mono**<br>  
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |   0.5	|  0.4	 |  0.4	  |  0.8   |  0.5   |   1.0  |  1.4	  |	  1.9  |  2.5   |   1.5  |
|  2          |  0.5   |   2.7	|  0.5	 |  0.6	  |  0.9   |  0.7   |   1.2  |  1.5	  |	  2.2  |  3.0   |   1.9  |
|  3          |  0.6   |   5.3	|  0.7	 |  0.7	  |  1.3   |  0.8   |   1.3  |  1.6	  |	  2.5  |  3.4   |   2.1  |

Input sample rate is **64000 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.4   |   2.2	|  0.6   |  0.5	  |   1.1  |   0.9	|  0.7   | 	1.5   |	 1.5   |  2.7	|  2.8   |
|  2          |  0.6   |   4.6	|  0.8   |  0.7	  |   4.6  |   1.1	|  0.9   |	5.6	  |  1.7   |  10.8	|  3.3   |
|  3          |  0.8   |   7.1	|  1.0   |  0.9	  |   7.4  |   1.3	|  1.1   | 	7.9	  |  1.9   |  17.3	|  3.7   |

Input sample rate is **88200 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.7   |   0.6  |   0.8  |	 0.9  |  0.7   |   1.1  |   1.3	 |   1.0  |	 1.7   |  2.1	|	2.9  |
|  2          |  0.9   |   0.9  |   1.0  |	 1.2  |  1.0   |   1.3  |   1.6	 |   1.3  |	 1.9   |  2.9	|	3.4  |
|  3          |  8.6   |   1.1  |   1.3  |	 10.1 |	 1.2   |   1.6  |   10.6 |	 1.5  |	 2.2   |  11.4	|	3.9  |

Input sample rate is **96000 mono**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.6   |  0.9	|   0.7	 |  0.7   |	 1.1   |  0.8	|   0.9  |	 1.5  |  1.4   |  2.2   |  3.0   |
|  2          |  0.9   |  7.1	|   1.0	 |  1.0	  |  6.8   |  1.1	|   1.2	 |   1.9  |	 1.6   |  2.4   |  3.2   |
|  3          |  1.2   |  11.0  |	1.2	 |  1.3	  |  10.9  |  1.4	|   1.5	 |   3.8  |	 2.2   |  2.6   |  3.4   |

## Heap Memory(Byte)
Input sample rate is **8000 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <1.8k  |  <2.7k |  <3.4k | 
|Multiple of 11025  | <29k   |  <82k  |  <138k | 

Input sample rate is **11025 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <83k   |  <236k |  <400k |
|Multiple of 11025  | <4k    |  <4k   |  <4k   |

Input sample rate is **12000 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <3k    |  <4k   |  <6k   |
|Multiple of 11025  | <10k   |  <28k  |  <47k  |

Input sample rate is **16000 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <2k    |  <2k   |  <2k   |
|Multiple of 11025  | <29k   |  <82k  |  <138k |

Input sample rate is **22050 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <42k   |  <118k |  <200k |
|Multiple of 11025  | <2k    |  <2k   |  <2k   |

Input sample rate is **24000 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <1k    |  <1k   |  <1k   |
|Multiple of 11025  | <10k   |  <28k  |  <47k  |

Input sample rate is **32000 mono**<br>
|    sample_rate   |    1   |    2   |    3   |
|:----------------:|:------:|:------:|:------:|
|Multiple of 4000  | <2k    |  <2k   |  <2k   |
|Multiple of 11025 | <54k   |  <138k |  <226k |

Input sample rate is **44100 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <42k   |  <118k |  <200k |
|Multiple of 11025  | <2k    |  <2k   |  <2k   |

Input sample rate is **48000 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <2k    |  <2k   |  <3k   |
|Multiple of 11025  | <27k   |  <72k  |  <114k |

Input sample rate is **64000 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <3k    |  <3k   |  <3k   |
|Multiple of 11025  | <103k  |  <279k |  <452k |

Input sample rate is **88200 mono**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <16k   |  <50k  |  <81k  |
|Multiple of 11025  | <3k    |  <3k   |  <6k   |

Input sample rate is **96000 mono**<br>  
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <2k    |  <3k   |  <4k   |
|Multiple of 11025  | <47k   |  <139k |  <226k |

# Usage

Here is an example of using [RATE CONVERSION](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

# FAQ  

1) How to choose the complexity of RATE CONVERSION?
   >The complexity of RATE CONVERSION depends on the performance of the chip. Lower complexity results in poorer audio quality but reduces memory and CPU usage. Conversely, higher complexity improves audio quality but increases memory and CPU consumption.
