# 采样率转换（RATE CONVERSION）

- [English](./README_RATE_CVT.md)

`RATE CONVERSION` 模块用于将原始音频信号的采样率变换为目标采样率。

## 特性

- 支持采样率（Hz）：为 4000 与 11025 的整数倍，最大至 192000
- 支持所有声道数
- 支持采样位宽：s16、s24、s32
- 支持复杂度（complexity）：1、2、3

## 性能

测试系统配置：
| 芯片 | IDF 版本 | CPU 频率 | SPI RAM 频率 |
| -- | -- | -- | -- |
| ESP32-S3R8 | v5.3 | 240MHz | 80MHz |

### CPU 负载（%）
输入采样率为 **8000 单声道**<br>
|complexity   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:| 
|  1          | 0.3    |   0.3  |  0.2   |   0.6  |  0.3   |   0.5  |  1.2   |  0.7   |   0.9  |  2.4   |  1.3   |
|  2          | 1.4    |   0.4  |  0.3   |   2.7  |  0.4   |   0.6  |  5.3   |  0.9   |   1.2  |  10.5  |  1.7   |
|  3          | 2.2    |   0.5  |  0.4   |   4.3  |  0.5   |   0.7  |  8.5   |  1.0   |   1.3  |  17.0  |  1.9   |

输入采样率为 **11025 单声道**<br>
|complexity   | 8000   | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |  0.3   | 0.5    |   0.3  |  0.7   |  1.7   |  0.6   | 1.3    |  3.4   |  1.2   | 5.1    |
|  2          |  0.4   |  0.4   | 2.1    |   0.4  |  0.9   |  4.1   |  0.8   | 6.1    |  8.2   |  1.6   | 12.1   |
|  3          |  1.4   |  0.5   | 3.2    |   0.5  |  4.8   |  6.4   |  0.9   | 9.6    |  12.9  |  1.8   | 19.2   |

输入采样率为 **12000 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |  0.3   |   0.5  |     0.6  |     0.4  |   0.9  |   1.2  |    0.7  |   1.7  |   2.4  |  1.3   |
|  2          |  0.3   |  0.4   |   0.6  |     0.7  |     0.5  |   1.0  |   1.4  |    0.9  |   2.1  |   2.8  |  1.7   |
|  3          |  0.3   |  0.4   |   0.6  |     0.9  |     0.5  |   1.2  |   1.7  |    1.0  |   2.4  |   3.3  |  2     |

输入采样率为 **16000 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.2   |   0.4  |   0.4  |     0.7  |   0.7   |  0.5  |   1.3  |  0.7   |   0.9  |   2.4  |   1.3  |
|  2          |  0.2   |   1.4  |   0.4  |     2.7  |   0.8   |  0.6  |   5.3  |  0.9   |   1.2  |   10.5 |   1.7  |
|  3          |  0.3   |   2    |   0.5  |     4.3  |   0.9   |  0.7  |   8.6  |  1.0   |   1.4  |   17.0 |   2.0  |

输入采样率为 **22050 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |  0.2   |   0.4  |   0.5  |     0.7  |   0.9  |   0.7  |  1.4   |   3.5   |  1.3  |   2.6  |
|  2          |  0.4   |  0.3   |   0.5  |   0.7  |     0.8  |   4.1  |   0.9  |  1.8   |   8.2   |  1.6  |   12.1 |
|  3          |  2.7   |  0.4   |   0.5  |   2.9  |     1.0  |   6.5  |   1.0  |  9.7   |   12.9  |  1.9  |   19.3 |

输入采样率为 **24000 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 32000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.2   |   0.4  |   0.3  |   0.5  |   0.7   |  0.9  |   1.3  |   0.7  |   1.7  |  2.4  |   1.4  |
|  2          |  0.3   |   0.5  |   0.3  |   0.6  |   0.7   |  1.1  |   1.5  |   1.0  |   2.1  |  2.9  |   1.8  |
|  3          |  0.4   |   0.7  |   0.4  |   0.7  |   0.8   |  1.3  |   1.7  |   1.1  |   2.4  |  3.3  |   2.0  |

输入采样率为 **32000 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 44100  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |   0.5  |   0.5  |   0.4  |     0.4  |   0.8  |   1.4  |  1.4   |   1.0   |  2.5  |   1.4  |
|  2          |  0.4   |   2.3  |   0.5  |   0.5  |     0.5  |   0.8  |   5.4  |  1.6   |   1.3   |  10.6 |   1.8  |
|  3          |  0.4   |   3.7  |   0.6  |   0.5  |     0.5  |   0.9  |   8.7  |  1.9   |   1.4   |  17.2 |   2.1  |

输入采样率为 **44100 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 48000  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.4   |   0.4  |  0.5   |  0.6   |     0.5  |  0.8   |  1.1  |  1.4   |   1.9  |  1.4  |   2.7  |
|  2          |  0.6   |   0.5  |  0.7   |  0.8   |     0.6  |  1.0   |  1.4  |  1.7   |   8.3  |  1.7  |   3.6  |
|  3          |  5.1   |   0.6  |  0.8   |  5.3   |     0.7  |  1.1   |  5.7  |  2.0   |   12.9 |  2.0  |   19.4 |

输入采样率为 **48000 单声道**<br>  
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 64000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.3   |   0.5  |  0.4   |  0.4   |  0.8   |  0.5   |   1.0  |  1.4   |   1.9  |  2.5   |   1.5  |
|  2          |  0.5   |   2.7  |  0.5   |  0.6   |  0.9   |  0.7   |   1.2  |  1.5   |   2.2  |  3.0   |   1.9  |
|  3          |  0.6   |   5.3  |  0.7   |  0.7   |  1.3   |  0.8   |   1.3  |  1.6   |   2.5  |  3.4   |   2.1  |

输入采样率为 **64000 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 88200  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.4   |   2.2  |  0.6   |  0.5   |   1.1  |   0.9  |  0.7   |   1.5  |   1.5   |  2.7  |  2.8   |
|  2          |  0.6   |   4.6  |  0.8   |  0.7   |   4.6  |   1.1  |  0.9   |   5.6  |   1.7   |  10.8 |  3.3   |
|  3          |  0.8   |   7.1  |  1.0   |  0.9   |   7.4  |   1.3  |  1.1   |   7.9  |   1.9   |  17.3 |  3.7   |

输入采样率为 **88200 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 96000  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.7   |   0.6  |   0.8  |   0.9  |  0.7   |   1.1  |   1.3  |   1.0  |   1.7   |  2.1  |  2.9  |
|  2          |  0.9   |   0.9  |   1.0  |   1.2  |  1.0   |   1.3  |   1.6  |   1.3  |   1.9   |  2.9  |  3.4  |
|  3          |  8.6   |   1.1  |   1.3  |   10.1 |  1.2   |   1.6  |   10.6 |   1.5  |   2.2   |  11.4 |  3.9  |

输入采样率为 **96000 单声道**<br>
|complexity   | 8000   | 11025  | 12000  | 16000  | 22050  | 24000  | 32000  | 44100  | 48000  | 64000  | 88200  |
|:-----------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|:------:|
|  1          |  0.6   |  0.9   |   0.7  |  0.7   |   1.1   |  0.8   |   0.9  |   1.5  |  1.4   |  2.2   |  3.0   |
|  2          |  0.9   |  7.1   |   1.0  |  1.0   |  6.8   |  1.1   |   1.2  |   1.9  |  1.6   |  2.4   |  3.2   |
|  3          |  1.2   |  11.0  |   1.2  |  1.3   |  10.9  |  1.4   |   1.5  |   3.8  |  2.2   |  2.6   |  3.4   |

### 堆内存（Byte）
输入采样率为 **8000 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <1.8k  |  <2.7k |  <3.4k | 
|Multiple of 11025  | <29k   |  <82k  |  <138k | 

输入采样率为 **11025 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <83k   |  <236k |  <400k |
|Multiple of 11025  | <4k    |  <4k   |  <4k   |

输入采样率为 **12000 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <3k    |  <4k   |  <6k   |
|Multiple of 11025  | <10k   |  <28k  |  <47k  |

输入采样率为 **16000 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <2k    |  <2k   |  <2k   |
|Multiple of 11025  | <29k   |  <82k  |  <138k |

输入采样率为 **22050 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <42k   |  <118k |  <200k |
|Multiple of 11025  | <2k    |  <2k   |  <2k   |

输入采样率为 **24000 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <1k    |  <1k   |  <1k   |
|Multiple of 11025  | <10k   |  <28k  |  <47k  |

输入采样率为 **32000 单声道**<br>
|    sample_rate   |    1   |    2   |    3   |
|:----------------:|:------:|:------:|:------:|
|Multiple of 4000  | <2k    |  <2k   |  <2k   |
|Multiple of 11025 | <54k   |  <138k |  <226k |

输入采样率为 **44100 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <42k   |  <118k |  <200k |
|Multiple of 11025  | <2k    |  <2k   |  <2k   |

输入采样率为 **48000 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <2k    |  <2k   |  <3k   |
|Multiple of 11025  | <27k   |  <72k  |  <114k |

输入采样率为 **64000 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <3k    |  <3k   |  <3k   |
|Multiple of 11025  | <103k  |  <279k |  <452k |

输入采样率为 **88200 单声道**<br>
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <16k   |  <50k  |  <81k  |
|Multiple of 11025  | <3k    |  <3k   |  <6k   |

输入采样率为 **96000 单声道**<br>  
|output sample_rate |    1   |    2   |    3   |
|:-----------------:|:------:|:------:|:------:|
|Multiple of 4000   | <2k    |  <3k   |  <4k   |
|Multiple of 11025  | <47k   |  <139k |  <226k |

## 使用

以下示例展示了如何使用 [RATE CONVERSION](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

## 常见问题（FAQ）

1) 如何选择 RATE CONVERSION 的复杂度？

   > RATE CONVERSION 的复杂度取决于芯片的性能。复杂度越低，音质会下降，但内存与 CPU 使用更低；复杂度越高，音质更好，但内存与 CPU 消耗也会增加。
