# Sonic（变速/变调）

- [English](./README_SONIC.md)

`Sonic` 模块用于同时或分别调整音频的音高（pitch）与播放速度（speed）。通过设置 speed 可在不改变音高的情况下变速；设置 pitch 可在不改变速度的情况下变调；同时调整二者可得到不同的速度与音高组合。

## 特性

- 支持采样率（Hz）：4000 与 11025 的整数倍，最高至 192000
- 支持任意声道数
- 支持位深：s16、s24、s32
- 支持速度范围：[0.5, 2.0]
- 支持音高范围：[0.5, 2.0]

## 性能

测试配置：

| 芯片 | IDF 版本 | CPU 频率 | SPI RAM 频率 |
| -- | -- | -- | -- |
| ESP32-S3R8 | v5.3 | 240MHz | 80MHz |

速度（speed）模式下：

| speed | 堆内存（16bit） | CPU（16） | 内存（24） | CPU（24） | 内存（32） | CPU（32） |
| -- | -- | -- | -- | -- | -- | -- |
| 0.50 | 5.3k | 1.09 | 11.3k | 2.54 | 12.7k | 2.57 |
| 0.75 | 5.8k | 0.38 | 11k | 1.01 | 10.8k | 0.99 |
| 1.25 | 5.0k | 0.22 | 8.1k | 0.67 | 8.1k | 0.60 |
| 1.50 | 4.3k | 0.34 | 7.3k | 0.84 | 7.3k | 0.85 |
| 1.75 | 3.7k | 0.43 | 7.4k | 1.06 | 7.4k | 1.03 |
| 2.00 | 3.8k | 0.48 | 7.5k | 1.18 | 7.5k | 1.21 |

音高（pitch）模式下：

| pitch | 堆内存（16bit） | CPU（16） | 内存（24） | CPU（24） | 内存（32） | CPU（32） |
| -- | -- | -- | -- | -- | -- | -- |
| 0.50 | 5.4k | 0.84 | 9.4k | 1.45 | 10.5k | 1.48 |
| 0.75 | 5.5k | 0.64 | 11.3k | 0.98 | 10.0k | 1.00 |
| 1.25 | 9.3k | 0.70 | 16.8k | 1.08 | 12.4k | 0.88 |
| 1.50 | 9.2k | 0.95 | 12.9k | 1.69 | 19.6k | 1.45 |
| 1.75 | 10.4k | 1.23 | 17.6k | 2.38 | 18.5k | 2.28 |
| 2.00 | 9.7k | 1.49 | 21.1k | 2.92 | 19.9k | 2.80 |

说明：
1) 测试音频为 8 kHz 单声道，其他采样率与声道的 CPU 负载约为 `sample_rate / 8000 × channel` 倍。
2) 表中 CPU 负载为平均值。

## 使用

使用示例参见：[Sonic](../example/esp_audio_effects_demo/main/esp_audio_effects_demo.c)

## 版权与许可

Sonic 为第三方版权代码，遵循以下许可：
- [Sonic](https://github.com/waywardgeek/sonic) 库版权归 Bill Cox（2010）所有，许可协议为 Apache 2.0。

## 常见问题（FAQ）
1) Sonic 的功能有哪些？
   - 变速不变调（Time-Stretch without Pitch-Shifting）：
     - 使用 `esp_ae_sonic_set_speed` 调整速度：speed<1 变慢；=1 不变；>1 变快。
   - 变调不变速（Pitch-Shifting without Time-Stretching）：
     - 使用 `esp_ae_sonic_set_pitch` 调整音高：pitch<1 变低；=1 不变；>1 变高。
   - 同时变速与变调：
     - 同时调用上述两个接口即可。

2) 仅靠 Sonic 能否实现“萝莉音”？
   > 通常不够。Sonic 可变速/变调，但“萝莉音”往往需更细致的音色塑形（共振峰、谐波结构等）。

3) Sonic 能将钢琴音色变成小提琴吗？
   > 不能。Sonic 仅改变音高；而音色由谐波结构与共振特性决定，无法凭变调直接变成另一乐器音色。
