/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
*
* SPDX-License-Identifier: Apache-2.0
*/

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "bf3901_regs.h"
#include "bf3901_types.h"

#define G3LB5  0x05
#define RGB    0x04

#if CONFIG_CAMERA_SENSOR_SWAP_PIXEL_BYTE_ORDER
#define YUV422 0x02
#else
#define YUV422 0x00
#endif

#ifdef __cplusplus
extern "C" {
#endif

static const bf3901_reginfo_t SPI_1bit_24Minput_240x320_rgb565_15fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // no frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x06}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, RGB}, // Zhan Xun or MTK CCIR; RGB565,
    {0x3a, G3LB5}, // Output YUV422/RGB565 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x81}, // SPI
    {0x08, 0xa0},
    {0x06, 0x68},
    {0x2b, 0x06},
    {0x27, 0x97},
    {0x17, 0x01},
    {0x18, 0x79},
    {0x19, 0x00},
    {0x1a, 0xa0},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x7d},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},
};

static const bf3901_reginfo_t SPI_1bit_24Minput_240x320_yuv422_15fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // en frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x06}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, 0x00}, // Zhan Xun or MTK CCIR; YUV422,
    {0x3a, YUV422}, // Output YUV422 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x81}, // SPI
    {0x08, 0xa0}, // Bit[7]: Serial mode select for VCLK: 0: normal, 1: Serial mode
    {0x06, 0x68},
    {0x2b, 0x06},
    {0x27, 0x97},
    {0x17, 0x01},
    {0x18, 0x79},
    {0x19, 0x00},
    {0x1a, 0xa0},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x7d},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},
};

static const bf3901_reginfo_t SPI_1bit_20Minput_240x320_yuv422_12fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // en frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x06}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, 0x00}, // Zhan Xun or MTK CCIR; YUV422,
    {0x3a, YUV422}, // Output YUV422 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x81}, // SPI
    {0x08, 0xa0}, // Bit[7]: Serial mode select for VCLK: 0: normal, 1: Serial mode
    {0x06, 0x68},
    {0x2b, 0x20},
    {0x27, 0x97},
    {0x17, 0x01},
    {0x18, 0x79},
    {0x19, 0x00},
    {0x1a, 0xa0},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x74},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},
};

static const bf3901_reginfo_t SPI_1bit_24Minput_240x240_yuv422_10fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // en frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x06}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, 0x00}, // Zhan Xun or MTK CCIR; YUV422,
    {0x3a, YUV422}, // Output YUV422 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x81}, // SPI
    {0x08, 0xa0}, // Bit[7]: Serial mode select for VCLK: 0: normal, 1: Serial mode
    {0x06, 0x68},
    {0x2b, 0x20},
    {0x27, 0x97},
    {0x17, 0x00},
    {0x18, 0x78},
    {0x19, 0x00},
    {0x1a, 0x78},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x74},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},

};

static const bf3901_reginfo_t SPI_1bit_24Minput_120x160_yuv422_10fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // en frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x06}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, 0x00}, // Zhan Xun or MTK CCIR; YUV422,
    {0x3a, YUV422}, // Output YUV422 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x81}, // SPI
    {0x08, 0xa0}, // Bit[7]: Serial mode select for VCLK: 0: normal, 1: Serial mode
    {0x06, 0x68},
    {0x2b, 0x20},
    {0x27, 0x97},
    {0x17, 0x10},
    {0x18, 0x4c},
    {0x19, 0x10},
    {0x1a, 0x60},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x74},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},
};

static const bf3901_reginfo_t SPI_1bit_20Minput_120x160_yuv422_5fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // en frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x82}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, 0x00}, // Zhan Xun or MTK CCIR; YUV422,
    {0x3a, YUV422}, // Output YUV422 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x81}, // SPI
    {0x08, 0xa0}, // Bit[7]: Serial mode select for VCLK: 0: normal, 1: Serial mode
    {0x06, 0x68},
    {0x2b, 0x20},
    {0x27, 0x97},
    {0x17, 0x10},
    {0x18, 0x4c},
    {0x19, 0x10},
    {0x1a, 0x60},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x74},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},
};

static const bf3901_reginfo_t SPI_2bit_24Minput_240x320_yuv422_20fps[] = {
    {0x09, 0x13}, // standby enable
    {BF3901_REG_DELAY, 0x01},
    {0x0b, 0x03}, // en frame header, frame end, line data packet; skip 2 frame
    {0x11, 0x30}, // CLKRC
    {0x1b, 0x06}, // disable PLL
    {0x6b, 0x41}, // Enable CCIR656; Enable CK-GATE subsample.
    {0x12, 0x00}, // Zhan Xun or MTK CCIR; YUV422,
    {0x3a, YUV422}, // Output YUV422 Sequence,
    {0x15, 0x10}, // reverse vclk
    {0x62, 0x82}, // SPI
    {0x08, 0xa0}, // Bit[7]: Serial mode select for VCLK: 0: normal, 1: Serial mode
    {0x06, 0x68},
    {0x2b, 0x20},
    {0x27, 0x97},
    {0x17, 0x01},
    {0x18, 0x79},
    {0x19, 0x00},
    {0x1a, 0xa0},
    {0x03, 0x00},
    {0x13, 0x00},
    {0x01, 0x13},
    {0x02, 0x20},
    {0x87, 0x16},
    {0x8c, 0x01},
    {0x8d, 0xcc},
    {0x13, 0x07},
    {0x33, 0x10},
    {0x34, 0x1d},
    {0x35, 0x46},
    {0x36, 0x40},
    {0x37, 0xa4},
    {0x38, 0x7c},
    {0x65, 0x46},
    {0x66, 0x46},
    {0x6e, 0x20},
    {0x9b, 0xa4},
    {0x9c, 0x7c},
    {0xbc, 0x0c},
    {0xbd, 0xa4},
    {0xbe, 0x7c},
    {0x20, 0x09},
    {0x72, 0x2f},
    {0x73, 0x2f},
    {0x74, 0xa7},
    {0x75, 0x12},
    {0x79, 0x8d},
    {0x7a, 0x00},
    {0x7e, 0xfa},
    {0x70, 0x0f},
    {0x7c, 0x84},
    {0x7d, 0xba},
    {0x5b, 0xc2},
    {0x76, 0x90},
    {0x7b, 0x55},
    {0x71, 0x46},
    {0x77, 0xdd},
    {0x13, 0x0f},
    {0x8a, 0x10},
    {0x8b, 0x20},
    {0x8e, 0x21},
    {0x8f, 0x40},
    {0x94, 0x41},
    {0x95, 0x7e},
    {0x96, 0x7f},
    {0x97, 0xf3},
    {0x13, 0x07},
    {0x24, 0x58},
    {0x97, 0x48},
    {0x25, 0x08},
    {0x94, 0xb5},
    {0x95, 0xc0},
    {0x80, 0xf6},
    {0x81, 0xe0},
    {0x82, 0x1b},
    {0x83, 0x37},
    {0x84, 0x39},
    {0x85, 0x58},
    {0x86, 0x77},
    {0x89, 0x74},
    {0x8a, 0x5c},
    {0x8b, 0x4c},
    {0x39, 0x98},
    {0x3f, 0x98},
    {0x90, 0xa0},
    {0x91, 0xe0},
    {0x40, 0x20},
    {0x41, 0x28},
    {0x42, 0x26},
    {0x43, 0x25},
    {0x44, 0x1f},
    {0x45, 0x1a},
    {0x46, 0x16},
    {0x47, 0x12},
    {0x48, 0x0f},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0a},
    {0x4e, 0x08},
    {0x4f, 0x06},
    {0x50, 0x06},
    {0x5a, 0x56},
    {0x51, 0x1b},
    {0x52, 0x04},
    {0x53, 0x4a},
    {0x54, 0x26},
    {0x57, 0x75},
    {0x58, 0x2b},
    {0x5a, 0xd6},
    {0x51, 0x28},
    {0x52, 0x1e},
    {0x53, 0x9e},
    {0x54, 0x70},
    {0x57, 0x50},
    {0x58, 0x07},
    {0x5c, 0x28},
    {0xb0, 0xe0},
    {0xb1, 0xc0},
    {0xb2, 0xb0},
    {0xb3, 0x4f},
    {0xb4, 0x63},
    {0xb4, 0xe3},
    {0xb1, 0xf0},
    {0xb2, 0xa0},
    {0x55, 0x00},
    {0x56, 0x40},
    {0x96, 0x50},
    {0x9a, 0x30},
    {0x6a, 0x81},
    {0x23, 0x33},
    {0xa0, 0xd0},
    {0xa1, 0x31},
    {0xa6, 0x04},
    {0xa2, 0x0f},
    {0xa3, 0x2b},
    {0xa4, 0x0f},
    {0xa5, 0x2b},
    {0xa7, 0x9a},
    {0xa8, 0x1c},
    {0xa9, 0x11},
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x3c},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc6, 0xaa},
    {0xd2, 0x78},
    {0xd0, 0xb4},
    {0xd1, 0x00},
    {0xc8, 0x10},
    {0xc9, 0x12},
    {0xd3, 0x09},
    {0xd4, 0x2a},
    {0xee, 0x4c},
    {0x7e, 0xfa},
    {0x74, 0xa7},
    {0x78, 0x4e},
    {0x60, 0xe7},
    {0x61, 0xc8},
    {0x6d, 0x70},
    {0x1e, 0x39},
    {0x98, 0x1a},
};

#ifdef __cplusplus
}
#endif
