/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "bf3a03_regs.h"
#include "bf3a03_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#define BF3A03_SPEC_EFFECT_REG_SIZE (5)
#define BF3A03_SPEC_EFFECT_NUM      (8)
#define BF3A03_AEC_TARGET_MAX       (0x6f)
#define BF3A03_AEC_TARGET_MIN       (0X28)
#define BF3A03_AEC_TARGET_DEFAULT   (0x50)

#if CONFIG_CAMERA_SENSOR_SWAP_PIXEL_BYTE_ORDER
#define BF3A03_YUV422_FMT 0x02
#else
#define BF3A03_YUV422_FMT 0x00
#endif

/*
 * The color effect settings
 */
static const bf3a03_reginfo_t bf3a03_spec_effect_regs[BF3A03_SPEC_EFFECT_NUM][BF3A03_SPEC_EFFECT_REG_SIZE] = {
    {
        {0x70, 0x0f},
        {0x69, 0x00},
        {0x67, 0x80},
        {0x68, 0x80},
        {0xb4, 0x91},
    }, /*colorfx_none*/
    {
        {0x70, 0x0f},
        {0x69, 0x20},
        {0x67, 0x80},
        {0x68, 0x80},
        {0xb4, 0x91},
    }, /*colorfx_bw*/
    {
        {0x70, 0x0b},
        {0x69, 0x20},
        {0x67, 0x60},
        {0x68, 0xa0},
        {0xb4, 0x91},
    }, /*colorfx_sepia*/
    {
        {0x70, 0x0f},
        {0x69, 0x01},
        {0x67, 0x80},
        {0x68, 0x80},
        {0xb4, 0x91},
    }, /*colorfx_negative*/
    {
        {0x70, 0x1b},
        {0x69, 0x01},
        {0x67, 0x80},
        {0x68, 0x80},
        {0xb4, 0x91},
    }, /*colorfx_emboss*/
    {
        {0x70, 0x3b},
        {0x69, 0x00},
        {0x67, 0x80},
        {0x68, 0x80},
        {0xb4, 0x91},
    }, /*colorfx_sketch*/
    {
        {0x70, 0x0b},
        {0x69, 0x20},
        {0x67, 0xe0},
        {0x68, 0x50},
        {0xb4, 0x91},
    }, /*sky_blue*/
    {
        {0x70, 0x0b},
        {0x69, 0x20},
        {0x67, 0x60},
        {0x68, 0x60},
        {0xb4, 0x91},
    }, /*grass_green*/
};

static const bf3a03_reginfo_t DVP_8bit_20Minput_640x480_yuv422_15fps_mono[] = {
    {0x09, 0x03}, //55
    {0x15, 0x02},
    {0x1e, 0x40}, //HV mirror
    //Analog signals
    {0x06, 0x68},
    {0x21, 0x00},
    {0x3e, 0x37},
    {0x29, 0x29},
    {0x27, 0x98},
    //clock
    {0x2f, 0x4c}, //42
    {0x11, 0x10},
    {0x1b, 0xe1},
    //output formats
    {0x4a, 0x98},
    {0x12, 0x00},
    {0x3a, BF3A03_YUV422_FMT}, //yuv seq
    {0x2b, 0x20},
    {0x8a, 0x73},
    {0x8b, 0x60},
    {0x89, 0x25}, //7D  25FPS
    //Manual
    {0x13, 0x08}, //bit[3]GLB GAIN0
    {0x01, 0x14},
    {0x02, 0x20},
    {0x8c, 0x02},
    {0x8d, 0x4c},
    {0x87, 0x16}, //GLB GAIN0
    //Auto
    {0x13, 0x07},
    //Denoise
    {0x70, 0x0f}, //插值模块开关
    {0x3b, 0x00}, //去格子噪声
    {0x71, 0x0c}, //插值模块开关
    {0x73, 0x27}, //Denoise
    {0x75, 0x88}, //Outdoor denoise
    {0x76, 0xd8},
    {0x77, 0x0a}, //Low light denoise
    {0x78, 0xff},
    {0x79, 0x14},
    {0x7a, 0x12}, //边缘增强
    {0x9e, 0xc4},
    {0x7d, 0x2a}, //去紫边
    //Gamma default
    {0x39, 0xc0}, //Gamma offset
    {0x3f, 0xc0},
    {0x90, 0x20},
    {0x5f, 0x01}, //Dark_sel gamma
    {0x40, 0x22},
    {0x41, 0x23},
    {0x42, 0x28},
    {0x43, 0x25},
    {0x44, 0x1d},
    {0x45, 0x17},
    {0x46, 0x13},
    {0x47, 0x12},
    {0x48, 0x10},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0b},
    {0x4e, 0x09},
    {0x4f, 0x07},
    {0x50, 0x06},
    /* Gamma case1: 低噪
    {0x40,0x24},
    {0x41,0x30},
    {0x42,0x24},
    {0x43,0x1d},
    {0x44,0x1a},
    {0x45,0x14},
    {0x46,0x11},
    {0x47,0x0e},
    {0x48,0x0d},
    {0x49,0x0c},
    {0x4b,0x0b},
    {0x4c,0x09},
    {0x4e,0x09},
    {0x4f,0x08},
    {0x50,0x07},

    //Gamma case1: 过曝过度好
    {0x40,0x18},
    {0x41,0x2c},
    {0x42,0x28},
    {0x43,0x20},
    {0x44,0x16},
    {0x45,0x10},
    {0x46,0x0f},
    {0x47,0x0f},
    {0x48,0x0e},
    {0x49,0x0a},
    {0x4b,0x0b},
    {0x4c,0x09},
    {0x4e,0x09},
    {0x4f,0x08},
    {0x50,0x06},

    //Gamma case1: 清晰亮丽
    {0x40,0x19},
    {0x41,0x1e},
    {0x42,0x1f},
    {0x43,0x20},
    {0x44,0x1d},
    {0x45,0x19},
    {0x46,0x17},
    {0x47,0x17},
    {0x48,0x14},
    {0x49,0x12},
    {0x4b,0x0f},
    {0x4c,0x0c},
    {0x4e,0x08},
    {0x4f,0x06},
    {0x50,0x03},*/
    //AE
    {0x24, BF3A03_AEC_TARGET_DEFAULT}, //非A光Y_target
    {0x97, 0x40}, //A光Y_target
    {0x25, 0x88}, //AE_LOC
    {0x81, 0x00}, //AE speed
    {0x82, 0x18},
    {0x83, 0x30},
    {0x84, 0x20},
    {0x85, 0x38},
    {0x86, 0x55},
    {0x94, 0x82}, //对AE亮度权重调节
    {0x80, 0x92}, //对过曝点数调节,bit[1]choose 50HZ or 60HZ step;
    {0x98, 0x8a}, //对窗口权重调节
    {0x89, 0x25}, //帧率调节bit[7:3]
    {0x8e, 0x2c},
    {0x8f, 0x86},
    //Banding
    {0x2b, 0x00},
    {0x92, 0x00},
    //Color default
    {0x5a, 0x6c}, //Indoor color
    {0x51, 0x93},
    {0x52, 0x04},
    {0x53, 0x8a},
    {0x54, 0x88},
    {0x57, 0x02},
    {0x58, 0x8d},
    /*//Color色彩艳丽
    {0x5a,0x6c},//Indoor color
    {0x51,0xa0},
    {0x52,0x01},
    {0x53,0x8d},
    {0x54,0x85},
    {0x57,0x01},
    {0x58,0x90},

    //Color肤色较好
    {0x5a,0x6c},//Indoor color
    {0x51,0x90},
    {0x52,0x0a},
    {0x53,0x84},
    {0x54,0x05},
    {0x57,0x05},
    {0x58,0x87},

    //Color
    {0x5a, 0xec}, //Outdoor color
    {0x51, 0x90},
    {0x52, 0x10},
    {0x53, 0x8d},
    {0x54, 0x88},
    {0x57, 0x82},
    {0x58, 0x8d},

    //A light color
    {0x5a, 0x7c},
    {0x51, 0x80},
    {0x52, 0x04},
    {0x53, 0x8d},
    {0x54, 0x88},
    {0x57, 0x82},
    {0x58, 0x8d},

    //Color色彩淡
    {0x5a,0x6c},//Indoor color
    {0x51,0x85},
    {0x52,0x06},
    {0x53,0x8a},
    {0x54,0x81},
    {0x57,0x02},
    {0x58,0x8a},*/
    //Saturation
    {0xb0, 0xa0}, //A光饱和度
    {0xb1, 0x26},
    {0xb2, 0x1c},
    {0xb4, 0xfd},
    {0xb0, 0x30}, //非A光饱和度
    {0xb1, 0xd8},
    {0xb2, 0xb0},
    {0xb4, 0xf1},
    //Contrast
    {0x3c, 0x40}, //K1
    {0x56, 0x48}, //K2 0xb4[4]选择new or old
    {0x4d, 0x40}, //K3
    {0x59, 0x40}, //K4
    /*// AWB G gain大一些
    {0x35,0x56},//shading R
    {0x65,0x36},//shading G
    {0x66,0x44},//shading B
    //AWB
    {0x6a,0x91},
    {0x23,0x44},
    {0xa2,0x04},
    {0xa3,0x26},
    {0xa4,0x04},
    {0xa5,0x26},
    {0xa7,0x1a},
    {0xa8,0x10},
    {0xa9,0x1f},
    {0xaa,0x16},
    {0xab,0x16},
    {0xac,0x30},
    {0xad,0xf0},
    {0xae,0x57},
    {0xc5,0xaa},
    {0xc7,0x38},
    {0xc8,0x0d},
    {0xc9,0x16},
    {0xd3,0x09},
    {0xd4,0x15},
    {0xd0,0x00},
    {0xd1,0x01},
    {0xd2,0x58},*/

    //G gain小一些
    {0x35, 0x46}, //shading R
    {0x65, 0x3a}, //shading G
    {0x66, 0x40}, //shading B
    //AWB
    {0x6a, 0xd1}, //AWB
    {0x23, 0x00}, //G GAIN
    {0xa2, 0x08}, //非户外 B上下线
    {0xa3, 0x26},
    {0xa4, 0x04}, //非户外 R上下线
    {0xa5, 0x26},
    {0xa7, 0x13}, //B GAIN
    {0xa8, 0x8e}, //R GAIN
    {0xa9, 0x16}, //白点
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x30},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc5, 0x66},
    {0xc7, 0x38}, //户内、外开关bit[4]
    {0xc8, 0x0d}, //非户外 B上下线
    {0xc9, 0x16},
    {0xd3, 0x09}, //非户外 R上下线
    {0xd4, 0x15},
    {0xd0, 0x00}, //A光下的offset
    {0xd1, 0x01}, //非A光下的offset
    {0x70, 0x0b}, // 0f 3.11 C black—white mode
    {0x69, 0x20}, //  3.11 C
    {0x67, 0x80}, //  3.11 C
    {0x68, 0x80}, //  3.11 C
    {0xb4, 0xf1}, //  3.11 C
    {0xf1, 0x28}, //disable cc sat
    {0xd2, 0x58},
};

static const bf3a03_reginfo_t DVP_8bit_20Minput_640x480_yuv422_15fps_color[] = {
    {0x09, 0x03}, //55
    {0x15, 0x02},
    {0x1e, 0x40}, //HV mirror
    //Analog signals
    {0x06, 0x68},
    {0x21, 0x00},
    {0x3e, 0x37},
    {0x29, 0x29},
    {0x27, 0x98},
    //clock
    {0x2f, 0x4c}, //42
    {0x11, 0x10},
    {0x1b, 0xe1},
    //output formats
    {0x4a, 0x98},
    {0x12, 0x00},
    {0x3a, 0x02}, //uyvy
    {0x2b, 0x00}, //20
    {0x8a, 0x73},
    {0x8b, 0x60},
    {0x89, 0x2d}, // 20fps    25       7D  25FPS
    //Manual
    {0x13, 0x08}, //手写bit[3]GLB GAIN0
    {0x01, 0x14},
    {0x02, 0x20},
    {0x8c, 0x02},
    {0x8d, 0x4c},
    {0x87, 0x16}, //GLB GAIN0
    //Auto
    {0x13, 0x07},
    //Denoise
    {0x70, 0x0f}, //插值模块开关
    {0x3b, 0x00}, //去格子噪声
    {0x71, 0x0c}, //插值模块开关
    {0x73, 0x27}, //Denoise
    {0x75, 0x88}, //Outdoor denoise
    {0x76, 0xd8},
    {0x77, 0x0a}, //Low light denoise
    {0x78, 0xff},
    {0x79, 0x14},
    {0x7a, 0x12}, //边缘增强
    {0x9e, 0xc4},
    {0x7d, 0x2a}, //去紫边
    //Gamma default
    {0x39, 0xc0}, //Gamma offset
    {0x3f, 0xc0},
    {0x90, 0x20},
    {0x5f, 0x01}, //Dark_sel gamma
    {0x40, 0x22},
    {0x41, 0x23},
    {0x42, 0x28},
    {0x43, 0x25},
    {0x44, 0x1d},
    {0x45, 0x17},
    {0x46, 0x13},
    {0x47, 0x12},
    {0x48, 0x10},
    {0x49, 0x0d},
    {0x4b, 0x0b},
    {0x4c, 0x0b},
    {0x4e, 0x09},
    {0x4f, 0x07},
    {0x50, 0x06},
    /*//Gamma 低噪
    {0x40,0x24},
    {0x41,0x30},
    {0x42,0x24},
    {0x43,0x1d},
    {0x44,0x1a},
    {0x45,0x14},
    {0x46,0x11},
    {0x47,0x0e},
    {0x48,0x0d},
    {0x49,0x0c},
    {0x4b,0x0b},
    {0x4c,0x09},
    {0x4e,0x09},
    {0x4f,0x08},
    {0x50,0x07},

    //Gamma 过曝过度好
    {0x40,0x18},
    {0x41,0x2c},
    {0x42,0x28},
    {0x43,0x20},
    {0x44,0x16},
    {0x45,0x10},
    {0x46,0x0f},
    {0x47,0x0f},
    {0x48,0x0e},
    {0x49,0x0a},
    {0x4b,0x0b},
    {0x4c,0x09},
    {0x4e,0x09},
    {0x4f,0x08},
    {0x50,0x06},

    //Gamma 清晰亮丽
    {0x40,0x19},
    {0x41,0x1e},
    {0x42,0x1f},
    {0x43,0x20},
    {0x44,0x1d},
    {0x45,0x19},
    {0x46,0x17},
    {0x47,0x17},
    {0x48,0x14},
    {0x49,0x12},
    {0x4b,0x0f},
    {0x4c,0x0c},
    {0x4e,0x08},
    {0x4f,0x06},
    {0x50,0x03},*/
    //AE
    {0x24, BF3A03_AEC_TARGET_DEFAULT}, //非A光Y_target
    {0x97, 0x40}, //A光Y_target
    {0x25, 0x88}, //AE_LOC
    {0x81, 0x00}, //AE speed
    {0x82, 0x18},
    {0x83, 0x30},
    {0x84, 0x20},
    {0x85, 0x38},
    {0x86, 0x55},
    {0x94, 0x82}, //对AE亮度权重调节
    {0x80, 0x92}, //对过曝点数调节,bit[1]choose 50HZ or 60HZ step;
    {0x98, 0x8a}, //对窗口权重调节
    {0x89, 0x25}, //帧率调节bit[7:3]
    {0x8e, 0x2c},
    {0x8f, 0x86},
    //Banding
    {0x2b, 0x00},
    {0x92, 0x00},

    //Color default
    {0x5a, 0x6c}, //Indoor color
    {0x51, 0x93},
    {0x52, 0x04},
    {0x53, 0x8a},
    {0x54, 0x88},
    {0x57, 0x02},
    {0x58, 0x8d},

    /*//Color色彩艳丽
    {0x5a,0x6c},//Indoor color
    {0x51,0xa0},
    {0x52,0x01},
    {0x53,0x8d},
    {0x54,0x85},
    {0x57,0x01},
    {0x58,0x90},

    //Color肤色较好
    {0x5a,0x6c},//Indoor color
    {0x51,0x90},
    {0x52,0x0a},
    {0x53,0x84},
    {0x54,0x05},
    {0x57,0x05},
    {0x58,0x87},

    //Color Outdoor color
    {0x5a, 0xec},
    {0x51, 0x90},
    {0x52, 0x10},
    {0x53, 0x8d},
    {0x54, 0x88},
    {0x57, 0x82},
    {0x58, 0x8d},

    //A light color
    {0x5a, 0x7c},
    {0x51, 0x80},
    {0x52, 0x04},
    {0x53, 0x8d},
    {0x54, 0x88},
    {0x57, 0x82},
    {0x58, 0x8d},

    //Color色彩淡
    {0x5a,0x6c},//Indoor color
    {0x51,0x85},
    {0x52,0x06},
    {0x53,0x8a},
    {0x54,0x81},
    {0x57,0x02},
    {0x58,0x8a},*/
    //Saturation
    {0xb0, 0xa0}, //A光饱和度
    {0xb1, 0x26},
    {0xb2, 0x1c},
    {0xb4, 0xfd},
    {0xb0, 0x30}, //非A光饱和度
    {0xb1, 0xd8},
    {0xb2, 0xb0},
    {0xb4, 0xf1},
    //Contrast
    {0x3c, 0x40}, //K1
    {0x56, 0x48}, //K2 0xb4[4]选择new or old
    {0x4d, 0x40}, //K3
    {0x59, 0x40}, //K4
    /*//G gain大一些
    {0x35,0x56},//shading R
    {0x65,0x36},//shading G
    {0x66,0x44},//shading B
    //AWB
    {0x6a,0x91},
    {0x23,0x44},
    {0xa2,0x04},
    {0xa3,0x26},
    {0xa4,0x04},
    {0xa5,0x26},
    {0xa7,0x1a},
    {0xa8,0x10},
    {0xa9,0x1f},
    {0xaa,0x16},
    {0xab,0x16},
    {0xac,0x30},
    {0xad,0xf0},
    {0xae,0x57},
    {0xc5,0xaa},
    {0xc7,0x38},
    {0xc8,0x0d},
    {0xc9,0x16},
    {0xd3,0x09},
    {0xd4,0x15},
    {0xd0,0x00},
    {0xd1,0x01},
    {0xd2,0x58},*/
    //G gain小一些
    {0x35, 0x46}, // shading R
    {0x65, 0x3a}, // shading G
    {0x66, 0x40}, // shading B
    //AWB
    {0x6a, 0xd1}, // AWB
    {0x23, 0x00}, // G GAIN
    {0xa2, 0x08}, // 非户外 B上下线
    {0xa3, 0x26},
    {0xa4, 0x04}, // 非户外 R上下线
    {0xa5, 0x26},
    {0xa7, 0x13}, // B GAIN
    {0xa8, 0x8e}, // R GAIN
    {0xa9, 0x16}, // 白点
    {0xaa, 0x16},
    {0xab, 0x16},
    {0xac, 0x30},
    {0xad, 0xf0},
    {0xae, 0x57},
    {0xc5, 0x66},
    {0xc7, 0x38}, // 户内、外开关bit[4]
    {0xc8, 0x0d}, // 非户外 B上下线
    {0xc9, 0x16},
    {0xd3, 0x09}, // 非户外 R上下线
    {0xd4, 0x15},
    {0xd0, 0x00}, // A光下的offset
    {0xd1, 0x01}, // 非A光下的offset
    {0x70, 0x0b}, //   normal 3.12  0b 3.11 C black—white mode
    {0x69, 0x00}, //   203.11 C
    {0x67, 0x80}, //  3.11 C
    {0x68, 0x80}, //  3.11 C
    {0xb4, 0xe1}, //  f1  3.11 C
    {0xf1, 0x00}, // 28  //disable cc sat
    {0xd2, 0x58},
};

#ifdef __cplusplus
}
#endif
