/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "os02n10_regs.h"
#include "os02n10_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#if CONFIG_SOC_MIPI_CSI_SUPPORTED
/*
;Input clock frequency: 24MHz
;Image output size: 1920x1080
;Frame rate: 25fps
;Interface, lane numbers and data rate: MIPI, 2lane;
;TLine:30.22us
;VTSxHTS:1323x544
//Tline=272*2/18=30.222 ROW_CLK=18M HTS=272 VTS=1109 FPS=18*1000000/272/2/1109=29.836
*/
static const os02n10_reginfo_t os02n10_init_reglist_MIPI_2lane_raw10_1080p_25fps[] = {
    {0xfc, 0x01},
    {0xfd, 0x00},
    {0x2b, 0x03}, // non-continuous mode
    {0xba, 0x02},
    {0xfd, 0x00},
    {0xb1, 0x14}, //dpll 480m
    {0xba, 0x00},
    {0x1a, 0x00}, //disable dvp
    {0x1b, 0x03},

    {0xfd, 0x01},
    {0x0e, 0x01}, // exp_h
    {0x0f, 0xc2}, // exp_l
    {0x15, 0xd7},
    {0x24, 0x20}, // 40 ;again
    {0x2f, 0x30},
    {0xfe, 0x02},
    {0x2b, 0xff}, // col_cap
    {0x30, 0x00},
    {0x31, 0x16}, // rowsg_toggle
    {0x32, 0x25},
    {0x33, 0xfb}, //[5]cms
    {0xfd, 0x01}, //timing
    {0x50, 0x03},
    {0x51, 0x07},
    {0x52, 0x04},
    {0x53, 0x05},
    {0x57, 0x40},
    {0x66, 0x04},//0c
    {0x6d, 0x58},//sig_clamp start
    {0x77, 0x01},
    {0x79, 0x32},
    {0x7c, 0x01}, //04
    {0x90, 0x3b},
    {0x91, 0x0b}, //08
    {0x92, 0x18},
    {0x95, 0x40},
    {0x99, 0x05},//dac-samp
    {0xaa, 0x0e},//0c
    {0xab, 0x0c},
    {0xac, 0x10},//0e
    {0xad, 0x10},
    {0xae, 0x20},//24
    {0xb0, 0x0e},//0d
    {0xb1, 0x0f},
    {0xb2, 0x1a},//1a
    {0xb3, 0x1c},

    {0xfd, 0x00},//fix reg bug
    {0xb0, 0x00},
    {0xb1, 0x14},
    {0xb2, 0x00},
    {0xb3, 0x10},

    {0xfd, 0x03},
    {0x08, 0x00},//01
    {0x09, 0x20},//cc ob select col
    {0x0a, 0x02},
    {0x0b, 0x80},//n2p
    {0x11, 0x40},//41 ;41 ;target
    {0x12, 0x40},//41 ;41
    {0x13, 0x40},//41 ;41
    {0x14, 0x40},//41 ;41
    {0x17, 0x72},//68;60 ;blc exp coe
    {0x18, 0x6f},//68;60
    {0x19, 0x70},//68;60
    {0x1a, 0x6f},//68;60
    {0x1b, 0xc0},//blc dc limit lsb
    {0x1d, 0x01},//blc_dc_limit en
    {0x1f, 0x80},
    {0x20, 0x40},
    {0x21, 0x80},
    {0x22, 0x40},
    {0x23, 0x88},
    {0x4b, 0x06},
    {0x0e, 0x03},
    {0x58, 0x7b},//79;59 ;blc en
    {0x59, 0x97},//08 ;auto
    {0x5a, 0x32},//blc dc limit msb
    // ;;ble improve
    {0xfd, 0x03},
    {0x24, 0x00},
    {0x4c, 0x7a},//7b ;00 ;01 ;b
    {0x4d, 0x7a},//00 ;00 ;r
    {0x4e, 0x7d},//7c ;00 ;01 ;gr
    {0x4f, 0x7a},//00 ;00 ;gb

    {0xfd, 0x01},
    {0x5f, 0x01},
    {0x30, 0x10},

    {0xfd, 0x00},
    {0x13, 0xbe},//icomp1 5.64u
    {0x14, 0x02},//bitline current
    {0x4c, 0x24},//bit3 osc off
    {0xb6, 0x00},//reg psnc on
    {0xb7, 0x08},//ncp lp op en
    {0xb9, 0xd6},//d5 ;[7]dac 8bit, 0x[6]dac 2x current
    {0xc6, 0x95},//a5;c5 ;vlow 1.3
    {0xc7, 0x77},//aa;bsun sig 2x 1x
    {0xc9, 0x22},//66 ;bsun rst 2x, 0x1x 1.92V
    {0xca, 0x32},//22;66 ;bsun rst 2x, 0x1x 1.92V
    {0xd7, 0xaa},//6a
    {0xbc, 0x1f},//bc~d1 psnc
    {0xbd, 0x60},
    {0xbe, 0x78},
    {0xbf, 0xa5},
    {0xcb, 0x00},
    {0xcc, 0x00},
    {0xce, 0x20},
    {0xcf, 0x3f},
    {0xd0, 0x76},
    {0xd1, 0xec},

    {0xfd, 0x04},
    {0x1b, 0x01},//00 ;[0]=0 dpc off, 0x=1 dpc on

    {0xfd, 0x01},
    {0x3c, 0x04},//vb_psv_exp_h
    {0x3d, 0x68}, //vb_psv_exp_l
    {0x3e, 0x04},//0d;04; vb_psv_fl_h
    {0x3f, 0x55},//bb;80; vb_psv_fl_h

    //;;digital windowing
    {0xfd, 0x03},
    {0x01, 0x04},
    {0x02, 0x07},
    {0x03, 0x80},
    {0x05, 0x04},
    {0x06, 0x04},
    {0x07, 0x38},
    {0xfd, 0x00},
    {0x1e, 0x0f},
    {0x1d, 0xa1},//[5]mipi pwdn sel
    {0x21, 0x04},
    {0x24, 0x02},
    {0x27, 0x07},//mipi output size
    {0x28, 0x80}, //88
    {0x29, 0x04},
    {0x2a, 0x38}, //40
    {0x2d, 0x04},
    {0x2e, 0x03},
    {0x2f, 0x0c},
    {0x31, 0x04},
    {0x32, 0x1a},
    {0x33, 0x04},
    {0x34, 0x05},//02
    {0x3f, 0x40},
    {0x40, 0x94},
    {0x23, 0x01},//mipi en

    {0xfb, 0x03},//fast exp mode
};

/*
;Input clock frequency: 24MHz
;Image output size: 1280x720
;Frame rate: 50fps
;Interface, lane numbers and data rate: MIPI, 2lane;
;TLine:26.66us
;VTSxHTS:750x544
ROW_CLK=20.4M HTS=544 VTS=750 FPS=20.4*1000000/544/2/750=50
@@OS02N10_MIPI_2LANE_1280x720_MCLK24M_816M_raw10_50fps_V13
*/
static const os02n10_reginfo_t os02n10_init_reglist_MIPI_2lane_raw10_720p_50fps[] = {
    {0xfc, 0x01},
    {0xfd, 0x00},
    {0x2b, 0x03}, // non-continuous mode
    {0xba, 0x02},
    {0xfd, 0x00},
    {0xb1, 0x14},//dpll 480m
    {0xba, 0x00},
    {0x1a, 0x00},//disable dvp
    {0x1b, 0x03},

    {0xfd, 0x01},
    {0x0e, 0x01}, //exp_h
    {0x0f, 0xc2}, //exp_l
    {0x15, 0x02},
    {0x24, 0x20}, //10 //again
    {0x2f, 0x30},
    {0xfe, 0x02},
    {0x2b, 0xff}, //col_cap
    {0x30, 0x00},
    {0x31, 0x16},//rowsg_toggle
    {0x32, 0x25},
    {0x33, 0xfb}, //[5]cms
    {0xfd, 0x01}, //timing
    {0x50, 0x03},
    {0x51, 0x07},
    {0x52, 0x04},
    {0x53, 0x05},
    {0x57, 0x40},
    {0x66, 0x04},//0c
    {0x6d, 0x58}, //sig_clamp start
    {0x77, 0x01},
    {0x79, 0x32},
    {0x7c, 0x01},//04
    {0x90, 0x3b},
    {0x91, 0x0b},//08
    {0x92, 0x18},
    {0x95, 0x40},
    {0x99, 0x05},//dac-samp
    {0xaa, 0x0e},//0c
    {0xab, 0x0c},
    {0xac, 0x10},//0e
    {0xad, 0x10},
    {0xae, 0x20},//24
    {0xb0, 0x0e},//0d
    {0xb1, 0x0f},
    {0xb2, 0x1a},//1a
    {0xb3, 0x1c},

    {0xfd, 0x00}, //fix reg bug
    {0xb0, 0x00},
    {0xb1, 0x14},
    {0xb2, 0x00},
    {0xb3, 0x10},

    {0xfd, 0x03},
    {0x08, 0x00},//01
    {0x09, 0x20},//cc ob select col
    {0x0a, 0x02},
    {0x0b, 0x80}, //n2p
    {0x11, 0x40}, //41 //41 //target
    {0x12, 0x40}, //41 //41
    {0x13, 0x40}, //41 //41
    {0x14, 0x40}, //41 //41
    {0x17, 0x72}, //68//60 //blc exp coe
    {0x18, 0x6f}, //68//60
    {0x19, 0x70}, //68//60
    {0x1a, 0x6f}, //68//60
    {0x1b, 0xc0},//blc dc limit lsb
    {0x1d, 0x01},//blc_dc_limit en
    {0x1f, 0x80},
    {0x20, 0x40},
    {0x21, 0x80},
    {0x22, 0x40},
    {0x23, 0x88},
    {0x4b, 0x06},
    {0x0e, 0x03},
    {0x58, 0x7b}, //79//59 //blc en
    {0x59, 0x97}, //08 //auto
    {0x5a, 0x32}, //blc dc limit msb
////ble improve
    {0xfd, 0x03},
    {0x24, 0x00},
    {0x4c, 0x7a}, //7b //00 //01 //b
    {0x4d, 0x7a}, //00 //00 //r
    {0x4e, 0x7d}, //7c //00 //01 //gr
    {0x4f, 0x7a}, //00 //00 //gb

    {0xfd, 0x01},
    {0x5f, 0x01},
    {0x30, 0x10},

    {0xfd, 0x00},
    {0x13, 0xbe}, //icomp1 5.64u
    {0x14, 0x02},//bitline current
    {0x4c, 0x24}, //bit3 osc off
    {0xb6, 0x00}, //reg psnc on
    {0xb7, 0x08}, //ncp lp op en
    {0xb9, 0xd6},//d5 //[7]dac 8bit, [6]dac 2x current
    {0xc6, 0x95},//a5//c5 //vlow 1.3
    {0xc7, 0x77},//aa//bsun sig 2x 1x
    {0xc9, 0x22},//66 //bsun rst 2x, 1x 1.92V
    {0xca, 0x32},//22//66 //bsun rst 2x, 1x 1.92V
    {0xd7, 0xaa},//6a
    {0xbc, 0x1f}, //bc~d1 psnc
    {0xbd, 0x60},
    {0xbe, 0x78},
    {0xbf, 0xa5},
    {0xcb, 0x00},
    {0xcc, 0x00},
    {0xce, 0x20},
    {0xcf, 0x3f},
    {0xd0, 0x76},
    {0xd1, 0xec},

    {0xfd, 0x04},
    {0x1b, 0x01}, //00 //[0]=0 dpc off, =1 dpc on

    {0xfd, 0x01},
    {0x3c, 0x04}, //vb_psv_exp_h
    {0x3d, 0x68},// vb_psv_exp_l
    {0x3e, 0x04}, //0d//04// vb_psv_fl_h
    {0x3f, 0x55}, //bb//80// vb_psv_fl_h

////digital windowing
    {0xfd, 0x01},
    {0x05, 0xc2},
    {0x08, 0x02},
    {0x09, 0xd8},
    {0xfd, 0x03},
    {0x01, 0xa2},
    {0x02, 0x05},
    {0x03, 0x00},
    {0x05, 0x04},
    {0x06, 0x02},
    {0x07, 0xd0},
    {0xfd, 0x00},
    {0x08, 0x22},
    {0xb1, 0x2d},
    {0xb2, 0x01},
    {0x1e, 0x0f},
    {0x1d, 0xa1}, //[5]mipi pwdn sel
    {0x21, 0x04},
    {0x24, 0x02},
    {0x27, 0x05}, //mipi output size
    {0x28, 0x00}, //88
    {0x29, 0x02},
    {0x2a, 0xd0}, //40
    {0x2d, 0x04},
    {0x2e, 0x03},
    {0x2f, 0x0c},
    {0x31, 0x04},
    {0x32, 0x1a},
    {0x33, 0x04},
    {0x34, 0x05},//02
    {0x3f, 0x40},
    {0x40, 0x94},
    {0x23, 0x01}, //mipi en

    {0xfb, 0x03}, //fast exp mode
};

/*
;Input clock frequency: 24MHz
;Image output size: 1920x1080
;Frame rate: 25fps
;Interface, lane numbers and data rate: MIPI, 2lane;
;TLine:30.22us
;VTSxHTS:1323x544
//Tline=272*2/18=30.222 ROW_CLK=18M HTS=272 VTS=1109 FPS=18*1000000/272/2/1109=29.836
*/
static const os02n10_reginfo_t os02n10_init_reglist_MIPI_2lane_raw8_1080p_25fps[] = {
    {0xfc, 0x01},
    {0xfd, 0x00},
    {0x2b, 0x03}, // non-continuous mode
    {0xba, 0x02},
    {0xfd, 0x00},
    {0xb1, 0x14},
    {0xba, 0x00},
    {0x1a, 0x00},
    {0x1b, 0x03},

    {0xfd, 0x01},
    {0x0e, 0x01}, // exp_h
    {0x0f, 0xc2}, // exp_l
    {0x15, 0xd7},
    {0x24, 0x20}, // 40;again
    {0x2f, 0x30},
    {0xfe, 0x02},
    {0x2b, 0xff},
    {0x30, 0x00},
    {0x31, 0x16},
    {0x32, 0x25},
    {0x33, 0xfb},
    {0xfd, 0x01},
    {0x50, 0x03},
    {0x51, 0x07},
    {0x52, 0x04},
    {0x53, 0x05},
    {0x57, 0x40},
    {0x66, 0x04},
    {0x6d, 0x58},
    {0x77, 0x01},
    {0x79, 0x32},
    {0x7c, 0x01},
    {0x90, 0x3b},
    {0x91, 0x0b},
    {0x92, 0x18},
    {0x95, 0x40},
    {0x99, 0x05},
    {0xaa, 0x0e},
    {0xab, 0x0c},
    {0xac, 0x10},
    {0xad, 0x10},
    {0xae, 0x20},
    {0xb0, 0x0e},
    {0xb1, 0x0f},
    {0xb2, 0x1a},
    {0xb3, 0x1c},

    {0xfd, 0x00},
    {0xb0, 0x00},
    {0xb1, 0x14},
    {0xb2, 0x00},
    {0xb3, 0x10},

    {0xfd, 0x03},
    {0x08, 0x00},
    {0x09, 0x20},
    {0x0a, 0x02},
    {0x0b, 0x80},
    {0x11, 0x40},
    {0x12, 0x40},
    {0x13, 0x40},
    {0x14, 0x40},
    {0x17, 0x72},
    {0x18, 0x6f},
    {0x19, 0x70},
    {0x1a, 0x6f},
    {0x1b, 0xc0},
    {0x1d, 0x01},
    {0x1f, 0x80},
    {0x20, 0x40},
    {0x21, 0x80},
    {0x22, 0x40},
    {0x23, 0x88},
    {0x4b, 0x06},
    {0x0e, 0x03},
    {0x58, 0x7b},
    {0x59, 0x97},
    {0x5a, 0x32},
    // ble, improve
    {0xfd, 0x03},
    {0x24, 0x00},
    {0x4c, 0x7a},
    {0x4d, 0x7a},
    {0x4e, 0x7d},
    {0x4f, 0x7a},

    {0xfd, 0x01},
    {0x5f, 0x01},
    {0x30, 0x10},

    {0xfd, 0x00},
    {0x13, 0xbe},
    {0x14, 0x02},
    {0x4c, 0x24},
    {0xb6, 0x00},
    {0xb7, 0x08},
    {0xb9, 0xd6},
    {0xc6, 0x95},
    {0xc7, 0x77},
    {0xc9, 0x22},
    {0xca, 0x32},
    {0xd7, 0xaa},
    {0xbc, 0x1f},
    {0xbd, 0x60},
    {0xbe, 0x78},
    {0xbf, 0xa5},
    {0xcb, 0x00},
    {0xcc, 0x00},
    {0xce, 0x20},
    {0xcf, 0x3f},
    {0xd0, 0x76},
    {0xd1, 0xec},

    {0xfd, 0x04},
    {0x1b, 0x01},

    {0xfd, 0x01},
    {0x3c, 0x04},
    {0x3d, 0x68},
    {0x3e, 0x04},
    {0x3f, 0x55},

    {0xfd, 0x00},
    {0x30, 0x2a},
    {0x0a, 0x05},
    {0xfe, 0x02},
    // digital, windowing
    {0xfd, 0x03},
    {0x01, 0x04},
    {0x02, 0x07},
    {0x03, 0x80},
    {0x05, 0x04},
    {0x06, 0x04},
    {0x07, 0x38},
    {0xfd, 0x00},
    {0x08, 0x18},
    {0x1e, 0x0f},
    {0x1d, 0xa1},
    {0x21, 0x04},
    {0x24, 0x02},
    {0x27, 0x07},
    {0x28, 0x80},
    {0x29, 0x04},
    {0x2a, 0x38},
    {0x2d, 0x04},
    {0x2e, 0x03},
    {0x2f, 0x0c},
    {0x31, 0x04},
    {0x32, 0x1a},
    {0x33, 0x04},
    {0x34, 0x05},
    {0x3f, 0x40},
    {0x40, 0x79},
    {0x23, 0x01},

    {0xfb, 0x03},
};
/*
;Input clock frequency: 24MHz
;Image output size: 1280x720
;Frame rate: 50fps
;Interface, lane numbers and data rate: MIPI, 2lane;
;TLine:26.66us
;VTSxHTS:750x544
ROW_CLK=20.4M HTS=544 VTS=750 FPS=20.4*1000000/544/2/750=50
@@OS02N10_MIPI_2LANE_1280x720_MCLK24M_652M_raw8_50fps_V13
*/
static const os02n10_reginfo_t os02n10_init_reglist_MIPI_2lane_raw8_720p_50fps[] = {
    {0xfc, 0x01},
    {0xfd, 0x00},
    {0x2b, 0x03}, // non-continuous mode
    {0xba, 0x02},
    {0xfd, 0x00},
    {0xb1, 0x14},
    {0xba, 0x00},
    {0x1a, 0x00},
    {0x1b, 0x03},

    {0xfd, 0x01},
    {0x0e, 0x01}, //exp_h
    {0x0f, 0xc2}, //exp_l
    {0x15, 0x02},
    {0x24, 0x20}, //10 //again
    {0x2f, 0x30},
    {0xfe, 0x02},
    {0x2b, 0xff},
    {0x30, 0x00},
    {0x31, 0x16},
    {0x32, 0x25},
    {0x33, 0xfb},
    {0xfd, 0x01},
    {0x50, 0x03},
    {0x51, 0x07},
    {0x52, 0x04},
    {0x53, 0x05},
    {0x57, 0x40},
    {0x66, 0x04},
    {0x6d, 0x58},
    {0x77, 0x01},
    {0x79, 0x32},
    {0x7c, 0x01},
    {0x90, 0x3b},
    {0x91, 0x0b},
    {0x92, 0x18},
    {0x95, 0x40},
    {0x99, 0x05},
    {0xaa, 0x0e},
    {0xab, 0x0c},
    {0xac, 0x10},
    {0xad, 0x10},
    {0xae, 0x20},
    {0xb0, 0x0e},
    {0xb1, 0x0f},
    {0xb2, 0x1a},
    {0xb3, 0x1c},

    {0xfd, 0x00},
    {0xb0, 0x00},
    {0xb1, 0x14},
    {0xb2, 0x00},
    {0xb3, 0x10},

    {0xfd, 0x03},
    {0x08, 0x00},
    {0x09, 0x20},
    {0x0a, 0x02},
    {0x0b, 0x80},
    {0x11, 0x40},
    {0x12, 0x40},
    {0x13, 0x40},
    {0x14, 0x40},
    {0x17, 0x72},
    {0x18, 0x6f},
    {0x19, 0x70},
    {0x1a, 0x6f},
    {0x1b, 0xc0},
    {0x1d, 0x01},
    {0x1f, 0x80},
    {0x20, 0x40},
    {0x21, 0x80},
    {0x22, 0x40},
    {0x23, 0x88},
    {0x4b, 0x06},
    {0x0e, 0x03},
    {0x58, 0x7b},
    {0x59, 0x97},
    {0x5a, 0x32},
    // ble, improve
    {0xfd, 0x03},
    {0x24, 0x00},
    {0x4c, 0x7a},
    {0x4d, 0x7a},
    {0x4e, 0x7d},
    {0x4f, 0x7a},

    {0xfd, 0x01},
    {0x5f, 0x01},
    {0x30, 0x10},

    {0xfd, 0x00},
    {0x13, 0xbe},
    {0x14, 0x02},
    {0x4c, 0x24},
    {0xb6, 0x00},
    {0xb7, 0x08},
    {0xb9, 0xd6},
    {0xc6, 0x95},
    {0xc7, 0x77},
    {0xc9, 0x22},
    {0xca, 0x32},
    {0xd7, 0xaa},
    {0xbc, 0x1f},
    {0xbd, 0x60},
    {0xbe, 0x78},
    {0xbf, 0xa5},
    {0xcb, 0x00},
    {0xcc, 0x00},
    {0xce, 0x20},
    {0xcf, 0x3f},
    {0xd0, 0x76},
    {0xd1, 0xec},

    {0xfd, 0x04},
    {0x1b, 0x01},

    {0xfd, 0x01},
    {0x3c, 0x04},
    {0x3d, 0x68},
    {0x3e, 0x04},
    {0x3f, 0x55},


    {0xfd, 0x00},
    {0x30, 0x2a},
    {0x0a, 0x05},
    {0xfe, 0x02},

    // digital, windowing
    {0xfd, 0x01},
    {0x05, 0xc2},
    {0x08, 0x02},
    {0x09, 0xd8},
    {0xfd, 0x03},
    {0x01, 0xa2},
    {0x02, 0x05},
    {0x03, 0x00},
    {0x05, 0x04},
    {0x06, 0x02},
    {0x07, 0xd0},
    {0xfd, 0x00},
    {0x08, 0x88},
    {0x09, 0x04},
    {0xb1, 0x2d},
    {0xb2, 0x01},
    {0x1e, 0x0f},
    {0x1d, 0xa1},
    {0x21, 0x04},
    {0x24, 0x02},
    {0x27, 0x05},
    {0x28, 0x00},
    {0x29, 0x02},
    {0x2a, 0xd0},
    {0x2d, 0x04},
    {0x2e, 0x03},
    {0x2f, 0x0c},
    {0x31, 0x04},
    {0x32, 0x1a},
    {0x33, 0x04},
    {0x34, 0x05},
    {0x3f, 0x41},
    {0x40, 0xb9},
    {0x23, 0x01},

    {0xfb, 0x03},
};

/*
;Input clock frequency: 24MHz
;Image output size: 960x540
;Frame rate: 25fps
;Interface, lane numbers and data rate: MIPI, 2lane;
;TLine:30.22us
;VTSxHTS:1323x544
@@OS02N10_MCLK24M_BINNING_960X540_MIPI_2LANE_360Mbps_RAW8_LINEAR_25fps_V13
*/
static const os02n10_reginfo_t os02n10_init_reglist_MIPI_2lane_raw8_binning_960x540_25fps[] = {
    {0xfc, 0x01},
    {0xfd, 0x00},
    {0x2b, 0x03}, // non-continuous mode
    {0xba, 0x02},
    {0xfd, 0x00},
    {0xb1, 0x14},
    {0xba, 0x00},
    {0x1a, 0x00},
    {0x1b, 0x03},
    {0x08, 0x18},
    {0x11, 0x55},
    {0x0a, 0x03},

    {0xfd, 0x01},
    {0x0e, 0x01}, // exp_h
    {0x0f, 0xc2}, // exp_l
    {0x14, 0x03},//00
    {0x15, 0x00},//01
    {0x24, 0x20}, // 40;again
    {0x2f, 0x31},
    {0xfe, 0x02},
    {0x2b, 0xff},
    {0x30, 0x00},
    {0x31, 0x16},
    {0x32, 0x25},
    {0x33, 0xfb},
    {0xfd, 0x01},
    {0x50, 0x03},
    {0x51, 0x07},
    {0x52, 0x04},
    {0x53, 0x05},
    {0x57, 0x40},
    {0x66, 0x04},
    {0x6d, 0x58},
    {0x77, 0x01},
    {0x79, 0x32},
    {0x7c, 0x01},
    {0x90, 0x3b},
    {0x91, 0x0b},
    {0x92, 0x18},
    {0x95, 0x40},
    {0x99, 0x05},
    {0xaa, 0x0e},
    {0xab, 0x0c},
    {0xac, 0x10},
    {0xad, 0x10},
    {0xae, 0x20},
    {0xb0, 0x0e},
    {0xb1, 0x0f},
    {0xb2, 0x1a},
    {0xb3, 0x1c},

    {0xfd, 0x00},
    {0xb0, 0x00},
    {0xb1, 0x14},
    {0xb2, 0x00},
    {0xb3, 0x10},

    {0xfd, 0x03},
    {0x01, 0x04},
    {0x03, 0x80},
    {0x05, 0x04},
    {0x07, 0x38},

    {0x08, 0x00},
    {0x09, 0x20},
    {0x0a, 0x02},
    {0x0b, 0x80},
    {0x0c, 0x01},

    {0x11, 0x40},
    {0x12, 0x40},
    {0x13, 0x40},
    {0x14, 0x40},
    {0x17, 0x72},
    {0x18, 0x6f},
    {0x19, 0x70},
    {0x1a, 0x6f},
    {0x1b, 0xc0},
    {0x1d, 0x01},
    {0x1f, 0x80},
    {0x20, 0x40},
    {0x21, 0x80},
    {0x22, 0x40},
    {0x23, 0x88},
    {0x4b, 0x04},
    {0x0e, 0x03},
    {0x58, 0x7b},
    {0x59, 0x97},
    {0x5a, 0x32},
    // ble, improve
    {0xfd, 0x03},
    {0x24, 0x00},
    {0x4c, 0x7a},
    {0x4d, 0x7a},
    {0x4e, 0x7d},
    {0x4f, 0x7a},

    {0xfd, 0x01},
    {0x5f, 0x01},
    {0x30, 0x10},

    {0xfd, 0x01},
    {0x3c, 0x04},
    {0x3d, 0x68},
    {0x3e, 0x07},//04
    {0x3f, 0x54},//55

    {0xfd, 0x00},
    {0x13, 0xbe},
    {0x14, 0x02},
    {0x4c, 0x24},
    {0xb6, 0x00},
    {0xb7, 0x08},
    {0xb9, 0xd6},
    {0xc6, 0x95},
    {0xc7, 0x77},
    {0xc9, 0x22},
    {0xca, 0x32},
    {0xd7, 0xaa},
    {0xbc, 0x1f},
    {0xbd, 0x60},
    {0xbe, 0x78},
    {0xbf, 0xa5},
    {0xcb, 0x00},
    {0xcc, 0x00},
    {0xce, 0x20},
    {0xcf, 0x3f},
    {0xd0, 0x76},
    {0xd1, 0xec},

    {0xfd, 0x04},
    {0x1b, 0x01},
    {0x1f, 0x01},
    {0x1d, 0x03},
    {0x1e, 0xc0},

    {0xfd, 0x00},
    {0x30, 0x2a},
    {0x0a, 0x07},
    {0xfe, 0x02},

    {0xfd, 0x00},
    {0x27, 0x03},
    {0x28, 0xc0},
    {0x29, 0x02},
    {0x2a, 0x1c},
    {0x1d, 0xa1},
    {0x34, 0x01},
    {0x3f, 0x40},
    {0x40, 0x39},
    {0x23, 0x01},

    {0xfb, 0x03},
};

#endif

#ifdef __cplusplus
}
#endif
