/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdint.h>
#include <sdkconfig.h>
#include "ov5640_regs.h"
#include "ov5640_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#define OV5640_SOFT_POWER_DOWN_EN                 (0x42)
#define OV5640_SOFT_POWER_DOWN_DIS                (0x02)
#define OV5640_OUTPUT_ENABLE_DEFAULT              (0)
#define OV5640_IDI_CLOCK_RATE_1280x720_14FPS      (80000000ULL)
// Note, for mipi rgb565\yuv422\yuv420 use 16bit trans len for each pixel
#define OV5640_LINE_RATE_16BITS_1280x720_14FPS    (OV5640_IDI_CLOCK_RATE_1280x720_14FPS * 8)

#define ov5640_settings_raw8 \
    {FORMAT_CTRL0, 0x00}, \
    {FORMAT_MUX_CTRL, 0x03}, \

#define ov5640_settings_yuv420 \
    {FORMAT_CTRL0, 0x5F}, \
    {FORMAT_MUX_CTRL, 0x00}, \

#if CONFIG_CAMERA_SENSOR_SWAP_PIXEL_BYTE_ORDER
// send in [Cb Y Cr Y] order.
#define ov5640_settings_yuv422 \
    {FORMAT_CTRL0, 0x33}, \
    {FORMAT_MUX_CTRL, 0x00}, \

// send in [R[4:0],G[5:3],G[2:0],B[4:0]] order.
#define ov5640_settings_rgb565 \
    {FORMAT_CTRL0, 0x61}, \
    {FORMAT_MUX_CTRL, 0x01}, \

#else
// send in [Y Cb Y Cr] order.
#define ov5640_settings_yuv422 \
    {FORMAT_CTRL0, 0x31}, \
    {FORMAT_MUX_CTRL, 0x00}, \

// send in [G[2:0],B[4:0],R[4:0],G[5:3]] order.
#define ov5640_settings_rgb565 \
    {FORMAT_CTRL0, 0x6F}, \
    {FORMAT_MUX_CTRL, 0x01}, \

#endif

/* Note, YUV444/RGB888 not available for full resolution(2592x1964) */
#define ov5640_settings_rgb888 \
    {FORMAT_CTRL0, 0x25}, \
    {FORMAT_MUX_CTRL, 0x00}

#if CONFIG_SOC_MIPI_CSI_SUPPORTED
static const ov5640_reginfo_t ov5640_mipi_reset_regs[] = {
    {0x3103, 0x11},
    // Comment this out if want AF to work
    {0x3008, 0x82},
    // Ensure streaming off to make clock lane go into LP-11 state.
    {0x4800, 0x05},
    {OV5640_REG_DELAY, 0x10},
    {0x3008, OV5640_SOFT_POWER_DOWN_EN}, // bit[6]=1: software power down default
    {OV5640_REG_END, 0x00},
};

static const ov5640_reginfo_t ov5640_MIPI_2lane_rgb565_720p_14fps[] = {
    {0x3103, 0x03},
    {0x3017, 0x00},
    {0x3018, 0x00},
    // {0x3034, (TEST_CSI_COLOR_MODE==MIPI_CSI_RAW10_MODE) ? 0x1A : 0x18},
    {0x3034, 0x18},
    {0x3035, 0x11},
    {0x3036, 0x38},
    {0x3037, 0x11},
    {0x3108, 0x01},
    {0x303D, 0x10},
    {0x303B, 0x19},

    {0x3630, 0x2e},
    {0x3631, 0x0e},
    {0x3632, 0xe2},
    {0x3633, 0x23},
    {0x3621, 0xe0},
    {0x3704, 0xa0},
    {0x3703, 0x5a},
    {0x3715, 0x78},
    {0x3717, 0x01},
    {0x370b, 0x60},
    {0x3705, 0x1a},
    {0x3905, 0x02},
    {0x3906, 0x10},
    {0x3901, 0x0a},
    {0x3731, 0x02},
    //VCM debug mode
    {0x3600, 0x37},
    {0x3601, 0x33},
    //System control register changing not recommended
    {0x302d, 0x60},
    {0x3620, 0x52},
    {0x371b, 0x20},
    {0x471c, 0x50},
    {0x3a13, 0x43},
    {0x3a18, 0x00},
    {0x3a19, 0xf8},
    {0x3635, 0x13},
    {0x3636, 0x06},
    {0x3634, 0x44},
    {0x3622, 0x01},
    {0x3c01, 0x34},
    {0x3c04, 0x28},
    {0x3c05, 0x98},
    {0x3c06, 0x00},
    {0x3c07, 0x08},
    {0x3c08, 0x00},
    {0x3c09, 0x1c},
    {0x3c0a, 0x9c},
    {0x3c0b, 0x40},
    {0x503d, 0x00},
    {0x3820, 0x46},
    //[7:5]=001 Two lane mode, [4]=0 MIPI HS TX no power down, [3]=0 MIPI LP RX no power down, [2]=1 MIPI enable, [1:0]=10 Debug mode; Default=0x58
    {0x300e, 0x45},
    //[5]=0 Clock free running, [4]=1 Send line short packet, [3]=0 Use lane1 as default, [2]=1 MIPI bus LP11 when no packet; Default=0x04
    {0x4800, CONFIG_CAMERA_OV5640_CSI_LINESYNC_ENABLE ? 0x14 : 0x04},
    {0x302e, 0x08},
    {0x4300, 0x6f},
    {0x501f, 0x01},

    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x440e, 0x00},
    {0x460b, 0x35},
    {0x460c, 0x20},
    {0x3824, 0x01},
    {0x5000, 0x07},
    {0x5001, 0x03},
    // test
    {0x3035, 0x21},
    //[7:0]=40 PLL multiplier
    {0x3036, OV5640_IDI_CLOCK_RATE_1280x720_14FPS / 1000000},
    //[4]=0 PLL root divider /1, [3:0]=5 PLL pre-divider /1.5
    {0x3037, 0x05},
    //[5:4]=01 PCLK root divider /2, [3:2]=00 SCLK2x root divider /1, [1:0]=01 SCLK root divider /2
    {0x3108, 0x11},

    //[3:0]=0 X address start high byte
    {0x3800, (0 >> 8) & 0x0F},
    //[7:0]=0 X address start low byte
    {0x3801, 0 & 0xFF},
    //[2:0]=0 Y address start high byte
    {0x3802, (0 >> 8) & 0x07},
    //[7:0]=0 Y address start low byte
    {0x3803, 0 & 0xFF},

    //[3:0] X address end high byte
    {0x3804, (2623 >> 8) & 0x0F},
    //[7:0] X address end low byte
    {0x3805, 2623 & 0xFF},
    //[2:0] Y address end high byte
    {0x3806, (1951 >> 8) & 0x07},
    //[7:0] Y address end low byte
    {0x3807, 1951 & 0xFF},

    //[3:0]=0 timing hoffset high byte
    {0x3810, (16 >> 8) & 0x0F},
    //[7:0]=0 timing hoffset low byte
    {0x3811, 16 & 0xFF},
    //[2:0]=0 timing voffset high byte
    {0x3812, (4 >> 8) & 0x07},
    //[7:0]=0 timing voffset low byte
    {0x3813, 4 & 0xFF},

    //[3:0] Output horizontal width high byte
    {0x3808, (1280 >> 8) & 0x0F},
    //[7:0] Output horizontal width low byte
    {0x3809, 1280 & 0xFF},
    //[2:0] Output vertical height high byte
    {0x380a, (720 >> 8) & 0x7F},
    //[7:0] Output vertical height low byte
    {0x380b, 720 & 0xFF},

    //HTS line exposure time in # of pixels Tline=HTS/sclk
    {0x380c, (2844 >> 8) & 0x1F},
    {0x380d, 2844 & 0xFF},
    //VTS frame exposure time in # lines
    {0x380e, (1968 >> 8) & 0xFF},
    {0x380f, 1968 & 0xFF},

    //[7:4]=0x1 horizontal odd subsample increment, [3:0]=0x1 horizontal even subsample increment
    {0x3814, 0x11},
    //[7:4]=0x1 vertical odd subsample increment, [3:0]=0x1 vertical even subsample increment
    {0x3815, 0x11},

    //[2]=0 ISP mirror, [1]=0 sensor mirror, [0]=1 horizontal binning
    {0x3821, 0x00},

    //little MIPI shit: global timing unit, period of PCLK in ns * 2(depends on # of lanes)
    {0x4837, (1000000000 / OV5640_IDI_CLOCK_RATE_1280x720_14FPS) * 2}, // 1/40M*2

    //Undocumented anti-green settings
    {0x3618, 0x04}, // Removes vertical lines appearing under bright light
    {0x3612, 0x2b},
    // {0x3708, 0x64},
    {0x3709, 0x12},
    {0x370c, 0x00},

    {0x4300, 0x6F},
    //[2:0]=0x0 Format select YUV422
    {0x501f, 0x01},
    {0x5001, 0x23},

    // Enable Advanced AWB
    {0x3406, 0x00},
    {0x5192, 0x04},
    {0x5191, 0xf8},
    {0x518d, 0x26},
    {0x518f, 0x42},
    {0x518e, 0x2b},
    {0x5190, 0x42},
    {0x518b, 0xd0},
    {0x518c, 0xbd},
    {0x5187, 0x18},
    {0x5188, 0x18},
    {0x5189, 0x56},
    {0x518a, 0x5c},
    {0x5186, 0x1c},
    {0x5181, 0x50},
    {0x5184, 0x20},
    {0x5182, 0x11},
    {0x5183, 0x00},
    {OV5640_REG_END, 0x00},
};
#endif

#if CONFIG_SOC_LCDCAM_CAM_SUPPORTED
static const ov5640_reginfo_t ov5640_dvp_reset_regs[] = {
    {0x3103, 0x11},
    {0x3008, 0x82},
    {OV5640_REG_DELAY, 0x05},
    {0x3008, OV5640_SOFT_POWER_DOWN_EN},
    {OV5640_REG_END, 0x00},
};

static const ov5640_reginfo_t ov5640_dvp_yuv422_svga_10fps[] = {
    {0x3103, 0x03},
    {0x3017, 0xff},
    {0x3018, 0xff},
    {0x3034, 0x1a},
    {0x3035, 0x21},
    {0x3036, 0x46},
    {0x3037, 0x13},
    {0x3108, 0x01},
    {0x3630, 0x36},
    {0x3631, 0x0e},
    {0x3632, 0xe2},
    {0x3633, 0x12},
    {0x3621, 0xe0},
    {0x3704, 0xa0},
    {0x3703, 0x5a},
    {0x3715, 0x78},
    {0x3717, 0x01},
    {0x370b, 0x60},
    {0x3705, 0x1a},
    {0x3905, 0x02},
    {0x3906, 0x10},
    {0x3901, 0x0a},
    {0x3731, 0x12},
    {0x3600, 0x08},
    {0x3601, 0x33},
    {0x302d, 0x60},
    {0x3620, 0x52},
    {0x371b, 0x20},
    {0x471c, 0x50},
    {0x3a13, 0x43},
    {0x3a18, 0x00},
    {0x3a19, 0x78},
    {0x3635, 0x13},
    {0x3636, 0x03},
    {0x3634, 0x40},
    {0x3622, 0x01},
    {0x3c01, 0x34},
    {0x3c04, 0x28},
    {0x3c05, 0x98},
    {0x3c06, 0x00},
    {0x3c07, 0x08},
    {0x3c08, 0x00},
    {0x3c09, 0x1c},
    {0x3c0a, 0x9c},
    {0x3c0b, 0x40},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3800, 0x00},
    {0x3801, 0x00},
    {0x3802, 0x00},
    {0x3803, 0x04},
    {0x3804, 0x0a},
    {0x3805, 0x3f},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x03},
    {0x3809, 0x20},
    {0x380a, 0x02},
    {0x380b, 0x58},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x03},
    {0x380f, 0xd8},
    {0x3810, 0x00},
    {0x3811, 0x10},
    {0x3812, 0x00},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3708, 0x64},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a08, 0x01},
    {0x3a09, 0x27},
    {0x3a0a, 0x00},
    {0x3a0b, 0xf6},
    {0x3a0e, 0x03},
    {0x3a0d, 0x04},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4001, 0x02},
    {0x4004, 0x02},
    {0x3000, 0x00},
    {0x3002, 0x1c},
    {0x3004, 0xff},
    {0x3006, 0xc3},
    {0x300e, 0x58},
    {0x302e, 0x00},
    {0x4740, 0x20},
    ov5640_settings_yuv422
    {0x501f, 0x00},
    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x440e, 0x00},
    {0x460b, 0x35},
    {0x460c, 0x20},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5000, 0xa7},
    {0x5001, 0xa3},
    {0x5180, 0xff},
    {0x5181, 0xf2},
    {0x5182, 0x00},
    {0x5183, 0x14},
    {0x5184, 0x25},
    {0x5185, 0x24},
    {0x5186, 0x0f},
    {0x5187, 0x0f},
    {0x5188, 0x0f},
    {0x5189, 0x80},
    {0x518a, 0x5d},
    {0x518b, 0xe3},
    {0x518c, 0xa7},
    {0x518d, 0x40},
    {0x518e, 0x33},
    {0x518f, 0x5e},
    {0x5190, 0x4e},
    {0x5191, 0xf8},
    {0x5192, 0x04},
    {0x5193, 0x70},
    {0x5194, 0xf0},
    {0x5195, 0xf0},
    {0x5196, 0x03},
    {0x5197, 0x01},
    {0x5198, 0x06},
    {0x5199, 0xd0},
    {0x519a, 0x04},
    {0x519b, 0x00},
    {0x519c, 0x04},
    {0x519d, 0x87},
    {0x519e, 0x38},
    {0x5381, 0x27},
    {0x5382, 0x41},
    {0x5383, 0x18},
    {0x5384, 0x0d},
    {0x5385, 0x59},
    {0x5386, 0x66},
    {0x5387, 0x63},
    {0x5388, 0x55},
    {0x5389, 0x0f},
    {0x538a, 0x01},
    {0x538b, 0x98},
    {0x5300, 0x08},
    {0x5301, 0x30},
    {0x5302, 0x10},
    {0x5303, 0x00},
    {0x5304, 0x08},
    {0x5305, 0x30},
    {0x5306, 0x08},
    {0x5307, 0x16},
    {0x5309, 0x08},
    {0x530a, 0x30},
    {0x530b, 0x04},
    {0x530c, 0x06},
    {0x5480, 0x01},
    {0x5481, 0x08},
    {0x5482, 0x14},
    {0x5483, 0x28},
    {0x5484, 0x51},
    {0x5485, 0x65},
    {0x5486, 0x71},
    {0x5487, 0x7d},
    {0x5488, 0x87},
    {0x5489, 0x91},
    {0x548a, 0x9a},
    {0x548b, 0xaa},
    {0x548c, 0xb8},
    {0x548d, 0xcd},
    {0x548e, 0xdd},
    {0x548f, 0xea},
    {0x5490, 0x1d},

    {0x5580, 0x02},
    {0x5583, 0x40},
    {0x5584, 0x10},
    {0x5589, 0x10},
    {0x558a, 0x00},
    {0x558b, 0xf8},
    {0x5800, 0x23},
    {0x5801, 0x14},
    {0x5802, 0x0f},
    {0x5803, 0x0f},
    {0x5804, 0x12},
    {0x5805, 0x26},
    {0x5806, 0x0c},
    {0x5807, 0x08},
    {0x5808, 0x05},
    {0x5809, 0x05},
    {0x580a, 0x08},
    {0x580b, 0x0d},
    {0x580c, 0x08},
    {0x580d, 0x03},
    {0x580e, 0x00},
    {0x580f, 0x00},
    {0x5810, 0x03},
    {0x5811, 0x09},
    {0x5812, 0x07},
    {0x5813, 0x03},
    {0x5814, 0x00},
    {0x5815, 0x01},
    {0x5816, 0x03},
    {0x5817, 0x08},
    {0x5818, 0x0d},
    {0x5819, 0x08},
    {0x581a, 0x05},
    {0x581b, 0x06},
    {0x581c, 0x08},
    {0x581d, 0x0e},
    {0x581e, 0x29},
    {0x581f, 0x17},
    {0x5820, 0x11},
    {0x5821, 0x11},
    {0x5822, 0x15},
    {0x5823, 0x28},
    {0x5824, 0x46},
    {0x5825, 0x26},
    {0x5826, 0x08},
    {0x5827, 0x26},
    {0x5828, 0x64},
    {0x5829, 0x26},
    {0x582a, 0x24},
    {0x582b, 0x22},
    {0x582c, 0x24},
    {0x582d, 0x24},
    {0x582e, 0x06},
    {0x582f, 0x22},
    {0x5830, 0x40},
    {0x5831, 0x42},
    {0x5832, 0x24},
    {0x5833, 0x26},
    {0x5834, 0x24},
    {0x5835, 0x22},
    {0x5836, 0x22},
    {0x5837, 0x26},
    {0x5838, 0x44},
    {0x5839, 0x24},
    {0x583a, 0x26},
    {0x583b, 0x28},
    {0x583c, 0x42},
    {0x583d, 0xce},
    {0x5025, 0x00},
    {0x3a0f, 0x30},
    {0x3a10, 0x28},
    {0x3a1b, 0x30},
    {0x3a1e, 0x26},
    {0x3a11, 0x60},
    {0x3a1f, 0x14},

    {0x3503, 0x00},
    {0x3c07, 0x08},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3803, 0x04},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x03},
    {0x3809, 0x20},
    {0x380a, 0x02},
    {0x380b, 0x58},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x04},
    {0x380f, 0x0a},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a08, 0x00},
    {0x3a09, 0x94},
    {0x3a0a, 0x00},
    {0x3a0b, 0x7b},
    {0x3a0e, 0x06},
    {0x3a0d, 0x07},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4004, 0x02},
    {0x3002, 0x1c},
    {0x4713, 0x03},
    {0x3035, 0x21},
    {0x3036, 0x46},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5001, 0xa3},

    {0x4005, 0x1a},

    // test
    {0x3503, 0x00},
    {0x3a00, 0x78},
    {0x3c07, 0x08},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3803, 0x04},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x03},
    {0x3809, 0x20},
    {0x380a, 0x02},
    {0x380b, 0x58},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x04},
    {0x380f, 0x0a},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x08},
    {0x3a03, 0x14},
    {0x3a08, 0x00},
    {0x3a09, 0x94},
    {0x3a0a, 0x00},
    {0x3a0b, 0x7b},
    {0x3a0e, 0x06},
    {0x3a0d, 0x07},
    {0x3a14, 0x08},
    {0x3a15, 0x14},
    {0x4004, 0x02},
    {0x3002, 0x1c},
    {0x4713, 0x03},
    {0x3035, 0x21},
    {0x3036, 0x46},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5001, 0xa3},
    {OV5640_REG_END, 0x00},
};

static const ov5640_reginfo_t ov5640_dvp_rgb565_svga_10fps[] = {
    {0x3103, 0x03},
    {0x3017, 0xff},
    {0x3018, 0xff},
    {0x3034, 0x1a},
    {0x3035, 0x21},
    {0x3036, 0x46},
    {0x3037, 0x13},
    {0x3108, 0x01},
    {0x3630, 0x36},
    {0x3631, 0x0e},
    {0x3632, 0xe2},
    {0x3633, 0x12},
    {0x3621, 0xe0},
    {0x3704, 0xa0},
    {0x3703, 0x5a},
    {0x3715, 0x78},
    {0x3717, 0x01},
    {0x370b, 0x60},
    {0x3705, 0x1a},
    {0x3905, 0x02},
    {0x3906, 0x10},
    {0x3901, 0x0a},
    {0x3731, 0x12},
    {0x3600, 0x08},
    {0x3601, 0x33},
    {0x302d, 0x60},
    {0x3620, 0x52},
    {0x371b, 0x20},
    {0x471c, 0x50},
    {0x3a13, 0x43},
    {0x3a18, 0x00},
    {0x3a19, 0x78},
    {0x3635, 0x13},
    {0x3636, 0x03},
    {0x3634, 0x40},
    {0x3622, 0x01},
    {0x3c01, 0x34},
    {0x3c04, 0x28},
    {0x3c05, 0x98},
    {0x3c06, 0x00},
    {0x3c07, 0x08},
    {0x3c08, 0x00},
    {0x3c09, 0x1c},
    {0x3c0a, 0x9c},
    {0x3c0b, 0x40},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3800, 0x00},
    {0x3801, 0x00},
    {0x3802, 0x00},
    {0x3803, 0x04},
    {0x3804, 0x0a},
    {0x3805, 0x3f},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x03},
    {0x3809, 0x20},
    {0x380a, 0x02},
    {0x380b, 0x58},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x03},
    {0x380f, 0xd8},
    {0x3810, 0x00},
    {0x3811, 0x10},
    {0x3812, 0x00},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3708, 0x64},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a08, 0x01},
    {0x3a09, 0x27},
    {0x3a0a, 0x00},
    {0x3a0b, 0xf6},
    {0x3a0e, 0x03},
    {0x3a0d, 0x04},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4001, 0x02},
    {0x4004, 0x02},
    {0x3000, 0x00},
    {0x3002, 0x1c},
    {0x3004, 0xff},
    {0x3006, 0xc3},
    {0x300e, 0x58},
    {0x302e, 0x00},
    {0x4740, 0x20},
    ov5640_settings_rgb565
    {0x4713, 0x03},
    {0x4407, 0x04},
    {0x440e, 0x00},
    {0x460b, 0x35},
    {0x460c, 0x20},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5000, 0xa7},
    {0x5001, 0xa3},
    {0x5180, 0xff},
    {0x5181, 0xf2},
    {0x5182, 0x00},
    {0x5183, 0x14},
    {0x5184, 0x25},
    {0x5185, 0x24},
    {0x5186, 0x0f},
    {0x5187, 0x0f},
    {0x5188, 0x0f},
    {0x5189, 0x80},
    {0x518a, 0x5d},
    {0x518b, 0xe3},
    {0x518c, 0xa7},
    {0x518d, 0x40},
    {0x518e, 0x33},
    {0x518f, 0x5e},
    {0x5190, 0x4e},
    {0x5191, 0xf8},
    {0x5192, 0x04},
    {0x5193, 0x70},
    {0x5194, 0xf0},
    {0x5195, 0xf0},
    {0x5196, 0x03},
    {0x5197, 0x01},
    {0x5198, 0x06},
    {0x5199, 0xd0},
    {0x519a, 0x04},
    {0x519b, 0x00},
    {0x519c, 0x04},
    {0x519d, 0x87},
    {0x519e, 0x38},
    {0x5381, 0x27},
    {0x5382, 0x41},
    {0x5383, 0x18},
    {0x5384, 0x0d},
    {0x5385, 0x59},
    {0x5386, 0x66},
    {0x5387, 0x63},
    {0x5388, 0x55},
    {0x5389, 0x0f},
    {0x538a, 0x01},
    {0x538b, 0x98},
    {0x5300, 0x08},
    {0x5301, 0x30},
    {0x5302, 0x10},
    {0x5303, 0x00},
    {0x5304, 0x08},
    {0x5305, 0x30},
    {0x5306, 0x08},
    {0x5307, 0x16},
    {0x5309, 0x08},
    {0x530a, 0x30},
    {0x530b, 0x04},
    {0x530c, 0x06},
    {0x5480, 0x01},
    {0x5481, 0x08},
    {0x5482, 0x14},
    {0x5483, 0x28},
    {0x5484, 0x51},
    {0x5485, 0x65},
    {0x5486, 0x71},
    {0x5487, 0x7d},
    {0x5488, 0x87},
    {0x5489, 0x91},
    {0x548a, 0x9a},
    {0x548b, 0xaa},
    {0x548c, 0xb8},
    {0x548d, 0xcd},
    {0x548e, 0xdd},
    {0x548f, 0xea},
    {0x5490, 0x1d},

    {0x5580, 0x02},
    {0x5583, 0x40},
    {0x5584, 0x10},
    {0x5589, 0x10},
    {0x558a, 0x00},
    {0x558b, 0xf8},
    {0x5800, 0x23},
    {0x5801, 0x14},
    {0x5802, 0x0f},
    {0x5803, 0x0f},
    {0x5804, 0x12},
    {0x5805, 0x26},
    {0x5806, 0x0c},
    {0x5807, 0x08},
    {0x5808, 0x05},
    {0x5809, 0x05},
    {0x580a, 0x08},
    {0x580b, 0x0d},
    {0x580c, 0x08},
    {0x580d, 0x03},
    {0x580e, 0x00},
    {0x580f, 0x00},
    {0x5810, 0x03},
    {0x5811, 0x09},
    {0x5812, 0x07},
    {0x5813, 0x03},
    {0x5814, 0x00},
    {0x5815, 0x01},
    {0x5816, 0x03},
    {0x5817, 0x08},
    {0x5818, 0x0d},
    {0x5819, 0x08},
    {0x581a, 0x05},
    {0x581b, 0x06},
    {0x581c, 0x08},
    {0x581d, 0x0e},
    {0x581e, 0x29},
    {0x581f, 0x17},
    {0x5820, 0x11},
    {0x5821, 0x11},
    {0x5822, 0x15},
    {0x5823, 0x28},
    {0x5824, 0x46},
    {0x5825, 0x26},
    {0x5826, 0x08},
    {0x5827, 0x26},
    {0x5828, 0x64},
    {0x5829, 0x26},
    {0x582a, 0x24},
    {0x582b, 0x22},
    {0x582c, 0x24},
    {0x582d, 0x24},
    {0x582e, 0x06},
    {0x582f, 0x22},
    {0x5830, 0x40},
    {0x5831, 0x42},
    {0x5832, 0x24},
    {0x5833, 0x26},
    {0x5834, 0x24},
    {0x5835, 0x22},
    {0x5836, 0x22},
    {0x5837, 0x26},
    {0x5838, 0x44},
    {0x5839, 0x24},
    {0x583a, 0x26},
    {0x583b, 0x28},
    {0x583c, 0x42},
    {0x583d, 0xce},
    {0x5025, 0x00},
    {0x3a0f, 0x30},
    {0x3a10, 0x28},
    {0x3a1b, 0x30},
    {0x3a1e, 0x26},
    {0x3a11, 0x60},
    {0x3a1f, 0x14},

    {0x3503, 0x00},
    {0x3c07, 0x08},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3803, 0x04},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x03},
    {0x3809, 0x20},
    {0x380a, 0x02},
    {0x380b, 0x58},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x04},
    {0x380f, 0x0a},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x03},
    {0x3a03, 0xd8},
    {0x3a08, 0x00},
    {0x3a09, 0x94},
    {0x3a0a, 0x00},
    {0x3a0b, 0x7b},
    {0x3a0e, 0x06},
    {0x3a0d, 0x07},
    {0x3a14, 0x03},
    {0x3a15, 0xd8},
    {0x4004, 0x02},
    {0x3002, 0x1c},
    {0x4713, 0x03},
    {0x3035, 0x21},
    {0x3036, 0x46},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5001, 0xa3},

    {0x4005, 0x1a},

    // test
    {0x3503, 0x00},
    {0x3a00, 0x78},
    {0x3c07, 0x08},
    {0x3820, 0x41},
    {0x3821, 0x07},
    {0x3814, 0x31},
    {0x3815, 0x31},
    {0x3803, 0x04},
    {0x3806, 0x07},
    {0x3807, 0x9b},
    {0x3808, 0x03},
    {0x3809, 0x20},
    {0x380a, 0x02},
    {0x380b, 0x58},
    {0x380c, 0x07},
    {0x380d, 0x68},
    {0x380e, 0x04},
    {0x380f, 0x0a},
    {0x3813, 0x06},
    {0x3618, 0x00},
    {0x3612, 0x29},
    {0x3709, 0x52},
    {0x370c, 0x03},
    {0x3a02, 0x08},
    {0x3a03, 0x14},
    {0x3a08, 0x00},
    {0x3a09, 0x94},
    {0x3a0a, 0x00},
    {0x3a0b, 0x7b},
    {0x3a0e, 0x06},
    {0x3a0d, 0x07},
    {0x3a14, 0x08},
    {0x3a15, 0x14},
    {0x4004, 0x02},
    {0x3002, 0x1c},
    {0x4713, 0x03},
    {0x3035, 0x21},
    {0x3036, 0x46},
    {0x4837, 0x22},
    {0x3824, 0x02},
    {0x5001, 0xa3},
    {OV5640_REG_END, 0x00},
};

#endif

#ifdef __cplusplus
}
#endif
