/*
 * SPDX-FileCopyrightText: 2024-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once

#include <stdio.h>
#include <stdint.h>
#include <sdkconfig.h>
#include "sc030iot_regs.h"
#include "sc030iot_types.h"

#ifdef __cplusplus
extern "C" {
#endif

#if CONFIG_SOC_LCDCAM_CAM_SUPPORTED

#if CONFIG_CAMERA_SENSOR_SWAP_PIXEL_BYTE_ORDER
#define SC030IOT_YUV422_FMT 0xa8
#else
#define SC030IOT_YUV422_FMT 0x88
#endif

static const sc030iot_reginfo_t DVP_8bit_20Minput_640x480_yuv422_26fps[] = {
    {0xf0, 0x30},
    {0x01, 0xff},
    {0x02, 0xff},
    {0x22, 0x07},
    {0x19, 0xff},
    {0x3f, 0x82},
    {0x30, 0x02},
    {0xf0, 0x01},
    {0x70, 0x00},
    {0x71, 0x80},
    {0x72, 0x20},
    {0x73, 0x00},
    {0x74, 0xe0},
    {0x75, 0x10},
    {0x76, 0x81},
    {0x77, SC030IOT_YUV422_FMT},// CbYCrY seq
    {0x78, 0xe1},
    {0x79, 0x01},
    {0xf5, 0x01},
    {0xf4, 0x0a},
    {0xf0, 0x36},
    {0x37, 0x79},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x33},
    {0x02, 0x12},
    {0x7c, 0x02},
    {0x7d, 0x0e},
    {0xa2, 0x04},
    {0x5e, 0x06},
    {0x5f, 0x0a},
    {0x0b, 0x58},
    {0x06, 0x38},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x39},
    {0x02, 0x70},
    {0xf0, 0x45},
    {0x09, 0x1c},
    {0xf0, 0x37},
    {0x22, 0x0d},
    {0xf0, 0x33},
    {0x33, 0x10},
    {0xb1, 0x80},
    {0x34, 0x40},
    {0x0b, 0x54},
    {0xb2, 0x78},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xf0, 0x30},
    {0x38, 0x44},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x01, 0x10},
    {0x0b, 0x6c},
    {0x06, 0x24},
    {0xf0, 0x36},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x34},
    {0x9f, 0x02},
    {0xa6, 0x40},
    {0xa7, 0x47},
    {0xe8, 0x5f},
    {0xa8, 0x51},
    {0xa9, 0x44},
    {0xe9, 0x36},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x64, 0x17},
    {0x90, 0x01},
    {0x91, 0x03},
    {0x92, 0x07},
    {0x01, 0x10},
    {0x93, 0x10},
    {0x94, 0x10},
    {0x95, 0x10},
    {0x96, 0x01},
    {0x97, 0x07},
    {0x98, 0x1f},
    {0x99, 0x10},
    {0x9a, 0x20},
    {0x9b, 0x28},
    {0x9c, 0x28},
    {0xf0, 0x36},
    {0x70, 0x54},
    {0xb6, 0x40},
    {0xb7, 0x41},
    {0xb8, 0x43},
    {0xb9, 0x47},
    {0xba, 0x4f},
    {0xb0, 0x8b},
    {0xb1, 0x8b},
    {0xb2, 0x8b},
    {0xb3, 0x9b},
    {0xb4, 0xb8},
    {0xb5, 0xf0},
    {0x7e, 0x41},
    {0x7f, 0x47},
    {0x77, 0x80},
    {0x78, 0x84},
    {0x79, 0x8a},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x43},
    {0x97, 0x44},
    {0x98, 0x54},
    {0xf0, 0x00},
    {0xf0, 0x01},
    {0x73, 0x00},
    {0x74, 0xe0},
    {0x70, 0x00},
    {0x71, 0x80},
    {0xf0, 0x36},
    {0x37, 0x74},
    {0xf0, 0x3f},
    {0x03, 0xa1},
    {0xf0, 0x36},// cvbs_off
    {0x11, 0x80},
    {0xf0, 0x01},
    {0x79, 0xc1},
    {0xf0, 0x37},
    {0x24, 0x21},
    {0xf0, 0x36},
    {0x41, 0x00},
    {0xea, 0x09},
    {0xeb, 0x03},
    {0xec, 0x19},
    {0xed, 0x38},
    {0xe9, 0x30},
    {0xf0, 0x33},
    {0x33, 0x00},
    {0x34, 0x00},
    {0xb1, 0x00},
    {0xf0, 0x00},
    {0xe0, 0x04},
    {0xf0, 0x01},
    {0x73, 0x00},
    {0x74, 0xe0},
    {0x70, 0x00},
    {0x71, 0x80},
    {0xf0, 0x36},
    {0x32, 0x44},
    {0xf0, 0x36},
    {0x3e, 0xe0},
    {0x70, 0x56},
    {0x7c, 0x43},
    {0x7d, 0x47},
    {0x74, 0x00},
    {0x75, 0x00},
    {0x76, 0x00},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x22},
    {0x97, 0x22},
    {0x98, 0x22},
    {0xf0, 0x00},
    {0x72, 0x38},
    {0x7a, 0x80},
    {0x85, 0x18},
    {0x9b, 0x35},
    {0x9e, 0x20},
    {0xd0, 0x66},
    {0xd1, 0x34},
    {0Xd3, 0x44},
    {0xd6, 0x44},
    {0xb0, 0x41},
    {0xb2, 0x48},
    {0xb3, 0xf4},
    {0xb4, 0x0b},
    {0xb5, 0x78},
    {0xba, 0xff},
    {0xbb, 0xc0},
    {0xbc, 0x90},
    {0xbd, 0x3a},
    {0xc1, 0x67},
    {0xf0, 0x01},
    {0x20, 0x11},
    {0x23, 0x90},
    {0x24, 0x15},
    {0x25, 0x87},
    {0xbc, 0x9f},
    {0xbd, 0x3a},
    {0x48, 0xe6},
    {0x49, 0xc0},
    {0x4a, 0xd0},
    {0x4b, 0x48},

    // [cvbs_on]
    {0xf0, 0x36},
    {0x11, 0x00},
    {0xf0, 0x01},
    {0x79, 0xf1},

    // [cvbs_off]
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xf0, 0x01},
    {0x79, 0xc1},

    {0xf0, 0x31},
    {0x00, 0x00}, // sleep mode enable
};

static const sc030iot_reginfo_t DVP_8bit_20Minput_640x480_raw8_26fps[] = {
    {0xf0, 0x30},
    {0x01, 0xff},
    {0x02, 0xff},
    {0x22, 0x07},
    {0x19, 0xff},
    {0x3f, 0x84},
    {0xf0, 0x39},
    {0x02, 0xc5},
    {0xf0, 0x00},
    {0x53, 0x00},
    {0x70, 0x5c},
    {0x72, 0xc0},
    {0x8b, 0x00},
    {0x8d, 0x04},
    {0x8e, 0x16},
    {0x9e, 0x10},
    {0xb0, 0xc0},
    {0xc8, 0x10},
    {0xc9, 0x10},
    {0xc6, 0x00},
    {0xe0, 0x40},
    {0xde, 0x80},
    {0xf0, 0x01},
    {0x70, 0x02},
    {0x71, 0x82},
    {0x72, 0x20},
    {0x73, 0x08},
    {0x74, 0xe8},
    {0x75, 0x10},
    {0x76, 0x81},
    {0x77, 0x89},
    {0x78, 0x81},
    {0x79, 0x01},
    {0xf0, 0x36},
    {0x37, 0x79},
    {0xf4, 0x0a},
    {0xf5, 0xff},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x33},
    {0x02, 0x12},
    {0x7c, 0x02},
    {0x7d, 0x0e},
    {0xa2, 0x04},
    {0x5e, 0x06},
    {0x5f, 0x0a},
    {0x0b, 0x58},
    {0x06, 0x38},
    {0xf0, 0x39},
    {0x02, 0x70},
    {0xf0, 0x45},
    {0x09, 0x1c},
    {0xf0, 0x37},
    {0x22, 0x0d},
    {0xf0, 0x33},
    {0x33, 0x10},
    {0xf0, 0x33},
    {0xb1, 0x80},
    {0xf0, 0x33},
    {0x34, 0x40},
    {0x0b, 0x54},
    {0xb2, 0x78},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xe9, 0x2c},
    {0xf0, 0x30},
    {0x38, 0x44},
    {0xf0, 0x00},
    {0x8b, 0x00},
    {0x70, 0x4c},
    {0x9e, 0x10},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x01, 0x10},
    {0x0b, 0x6c},
    {0x06, 0x24},
    {0xf0, 0x36},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x34},
    {0x9f, 0x02},
    {0xa6, 0x40},
    {0xa7, 0x47},
    {0xe8, 0x5f},
    {0xa8, 0x51},
    {0xa9, 0x44},
    {0xe9, 0x36},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x64, 0x17},
    {0x90, 0x01},
    {0x91, 0x03},
    {0x92, 0x07},
    {0x01, 0x10},
    {0x93, 0x10},
    {0x94, 0x10},
    {0x95, 0x10},
    {0x96, 0x01},
    {0x97, 0x07},
    {0x98, 0x1f},
    {0x99, 0x10},
    {0x9a, 0x20},
    {0x9b, 0x28},
    {0x9c, 0x28},
    {0xf0, 0x36},
    {0x70, 0x54},
    {0xb6, 0x40},
    {0xb7, 0x41},
    {0xb8, 0x43},
    {0xb9, 0x47},
    {0xba, 0x4f},
    {0xb0, 0x8b},
    {0xb1, 0x8b},
    {0xb2, 0x8b},
    {0xb3, 0x9b},
    {0xb4, 0xb8},
    {0xb5, 0xf0},
    {0x7e, 0x41},
    {0x7f, 0x47},
    {0x77, 0x83},
    {0x78, 0x84},
    {0x79, 0x8a},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x43},
    {0x97, 0x44},
    {0x98, 0x54},
    {0xf0, 0x3f},
    {0x03, 0x91},
    {0xf0, 0x00},
    {0xe0, 0x04},
    {0xf0, 0x36},
    {0x37, 0x74},
    {0xf0, 0x37},
    {0x24, 0x21},
    {0xf0, 0x36},
    {0x41, 0x00},
    {0xf0, 0x33},
    {0x33, 0x00},
    {0x34, 0x00},
    {0xb1, 0x00},
    {0xf0, 0x00},
    {0xe0, 0xc0},
    {0xf0, 0x01},
    {0x73, 0x08},
    {0x74, 0xe8},
    {0x70, 0x02},
    {0x71, 0x82},
    {0xf0, 0x36},
    {0x32, 0x44},
    {0xf0, 0x36},
    {0x3e, 0xe0},
    {0x70, 0x56},
    {0x7c, 0x43},
    {0x7d, 0x47},
    {0x74, 0x00},
    {0x75, 0x00},
    {0x76, 0x00},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x22},
    {0x97, 0x22},
    {0x98, 0x22},
    {0xf0, 0x00},
    {0x71, 0x92},
    {0x7c, 0x03},
    {0x84, 0xb4},
    {0xf0, 0x33},
    {0x14, 0x95},
    {0xf0, 0x3f},
    {0x03, 0xca},
    {0xf0, 0x36},
    {0xe9, 0x30},
    {0xea, 0x09},
    {0xeb, 0x03},
    {0xec, 0x19},
    {0xed, 0x38},

    {0xf0, 0x31},
    {0x00, 0x00}, // sleep mode enable
};
#endif

#if CONFIG_SOC_MIPI_CSI_SUPPORTED
static const sc030iot_reginfo_t MIPI_1lane_24Minput_480p_yuv422_25fps[] = {
    {0xf0, 0x30},
    {0x01, 0x00},
    {0x02, 0x00},
    {0x22, 0x00},
    {0x19, 0x00},
    {0x3f, 0x82},
    {0x30, 0x02},
    {0x31, 0x08},
    {0x37, 0x00},
    {0xf0, 0x01},
    {0x76, 0x81},
    {0x77, 0xac}, // YUV seq
    {0x78, 0xe1},
    {0x79, 0xc1},
    {0xf4, 0x0a},
    {0xf0, 0x36},
    {0x37, 0x79},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x33},
    {0x02, 0x12},
    {0x7c, 0x02},
    {0x7d, 0x0e},
    {0xa2, 0x04},
    {0x5e, 0x06},
    {0x5f, 0x0a},
    {0x0b, 0x58},
    {0x06, 0x38},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x39},
    {0x02, 0x70},
    {0xf0, 0x45},
    {0x09, 0x1c},
    {0xf0, 0x37},
    {0x22, 0x0d},
    {0xf0, 0x33},
    {0x33, 0x10},
    {0xb1, 0x80},
    {0x34, 0x40},
    {0x0b, 0x54},
    {0xb2, 0x78},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xf0, 0x30},
    {0x38, 0x44},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x01, 0x10},
    {0x0b, 0x6c},
    {0x06, 0x24},
    {0xf0, 0x36},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x34},
    {0x9f, 0x02},
    {0xa6, 0x40},
    {0xa7, 0x47},
    {0xe8, 0x5f},
    {0xa8, 0x51},
    {0xa9, 0x44},
    {0xe9, 0x36},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x64, 0x17},
    {0x90, 0x01},
    {0x91, 0x03},
    {0x92, 0x07},
    {0x01, 0x10},
    {0x93, 0x10},
    {0x94, 0x10},
    {0x95, 0x10},
    {0x96, 0x01},
    {0x97, 0x07},
    {0x98, 0x1f},
    {0x99, 0x10},
    {0x9a, 0x20},
    {0x9b, 0x28},
    {0x9c, 0x28},
    {0xf0, 0x36},
    {0x70, 0x54},
    {0xb6, 0x40},
    {0xb7, 0x41},
    {0xb8, 0x43},
    {0xb9, 0x47},
    {0xba, 0x4f},
    {0xb0, 0x8b},
    {0xb1, 0x8b},
    {0xb2, 0x8b},
    {0xb3, 0x9b},
    {0xb4, 0xb8},
    {0xb5, 0xf0},
    {0x7e, 0x41},
    {0x7f, 0x47},
    {0x77, 0x83},
    {0x78, 0x84},
    {0x79, 0x8a},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x43},
    {0x97, 0x44},
    {0x98, 0x54},
    {0xf0, 0x00},
    {0xf0, 0x01},
    {0x73, 0x00},
    {0x74, 0xe0},
    {0x70, 0x00},
    {0x71, 0x80},
    {0xf0, 0x36},
    {0x37, 0x74},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xf0, 0x01},
    {0x79, 0xc1},
    {0xf0, 0x37},
    {0x24, 0x21},
    {0xf0, 0x36},
    {0x41, 0x60},
    {0xf0, 0x3f},
    {0x03, 0xb8},
    {0xf0, 0x32},
    {0x0c, 0x07},
    {0x0d, 0x08},
    {0x0e, 0x01},
    {0x0f, 0xf4},
    {0xf0, 0x36},
    {0xea, 0x06},
    {0xeb, 0x03},
    {0xec, 0x19},
    {0xed, 0x28},
    {0xe9, 0x00},
    {0xf0, 0x00},
    {0xf4, 0x08},
    {0x7c, 0x38},
    {0x72, 0x38},
    {0x7a, 0x80},
    {0x85, 0x18},
    {0x9b, 0x35},
    {0x9e, 0x20},
    {0xd0, 0x66},
    {0xd1, 0x34},
    {0xd3, 0x44},
    {0xd6, 0x44},
    {0xb0, 0x41},
    {0xb2, 0x48},
    {0xb3, 0xf4},
    {0xb4, 0x0b},
    {0xb5, 0x78},
    {0xba, 0xff},
    {0xbb, 0xc0},
    {0xbc, 0x90},
    {0xbd, 0x3a},
    {0xc1, 0x67},
    {0xf0, 0x01},
    {0x20, 0x11},
    {0x23, 0x90},
    {0x24, 0x15},
    {0x25, 0x87},
    {0xbc, 0x9f},
    {0xbd, 0x3a},
    {0x48, 0xe6},
    {0x49, 0xc0},
    {0x4a, 0xd0},
    {0x4b, 0x48},
    {0xf0, 0x00},
    {0x71, 0x92},
    {0x7c, 0x03},
    {0x84, 0xb4},
    {0xf0, 0x33},
    {0x14, 0x95},
    {0xf4, 0x00},
    {0xf0, 0x00},
    {0x87, 0x65},
    {0x7c, 0xf5},

    {0xf0, 0x31},
    {0x00, 0x00}, // sleep mode enable
};

static const sc030iot_reginfo_t MIPI_1lane_24Minput_480p_yuv422_50fps[] = {
    {0xf0, 0x30},
    {0x01, 0x00},
    {0x02, 0x00},
    {0x22, 0x00},
    {0x19, 0x00},
    {0x3f, 0x82},
    {0x30, 0x02},
    {0x31, 0x08},
    {0x37, 0x00},
    {0xf0, 0x01},
    {0x76, 0x81},
    {0x77, 0xac}, // YUV seq
    {0x78, 0xe1},
    {0x79, 0xc1},
    {0xf4, 0x0a},
    {0xf0, 0x36},
    {0x37, 0x79},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x33},
    {0x02, 0x12},
    {0x7c, 0x02},
    {0x7d, 0x0e},
    {0xa2, 0x04},
    {0x5e, 0x06},
    {0x5f, 0x0a},
    {0x0b, 0x58},
    {0x06, 0x38},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x39},
    {0x02, 0x70},
    {0xf0, 0x45},
    {0x09, 0x1c},
    {0xf0, 0x37},
    {0x22, 0x0d},
    {0xf0, 0x33},
    {0x33, 0x10},
    {0xb1, 0x80},
    {0x34, 0x40},
    {0x0b, 0x54},
    {0xb2, 0x78},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xf0, 0x30},
    {0x38, 0x44},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x01, 0x10},
    {0x0b, 0x6c},
    {0x06, 0x24},
    {0xf0, 0x36},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x34},
    {0x9f, 0x02},
    {0xa6, 0x40},
    {0xa7, 0x47},
    {0xe8, 0x5f},
    {0xa8, 0x51},
    {0xa9, 0x44},
    {0xe9, 0x36},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x64, 0x17},
    {0x90, 0x01},
    {0x91, 0x03},
    {0x92, 0x07},
    {0x01, 0x10},
    {0x93, 0x10},
    {0x94, 0x10},
    {0x95, 0x10},
    {0x96, 0x01},
    {0x97, 0x07},
    {0x98, 0x1f},
    {0x99, 0x10},
    {0x9a, 0x20},
    {0x9b, 0x28},
    {0x9c, 0x28},
    {0xf0, 0x36},
    {0x70, 0x54},
    {0xb6, 0x40},
    {0xb7, 0x41},
    {0xb8, 0x43},
    {0xb9, 0x47},
    {0xba, 0x4f},
    {0xb0, 0x8b},
    {0xb1, 0x8b},
    {0xb2, 0x8b},
    {0xb3, 0x9b},
    {0xb4, 0xb8},
    {0xb5, 0xf0},
    {0x7e, 0x41},
    {0x7f, 0x47},
    {0x77, 0x83},
    {0x78, 0x84},
    {0x79, 0x8a},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x43},
    {0x97, 0x44},
    {0x98, 0x54},
    {0xf0, 0x00},
    {0xf0, 0x01},
    {0x73, 0x00},
    {0x74, 0xe0},
    {0x70, 0x00},
    {0x71, 0x80},
    {0xf0, 0x36},
    {0x37, 0x74},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xf0, 0x01},
    {0x79, 0xc1},
    {0xf0, 0x37},
    {0x24, 0x21},
    {0xf0, 0x36},
    {0x41, 0x60},
    {0xf0, 0x3f},
    {0x03, 0xb8},
    {0xf0, 0x32},
    {0x0c, 0x03},
    {0x0d, 0x84},
    {0x0e, 0x01},
    {0x0f, 0xf4},
    {0xf0, 0x36},
    {0xea, 0x06},
    {0xeb, 0x03},
    {0xec, 0x19},
    {0xed, 0x28},
    {0xe9, 0x00},
    {0xf0, 0x00},
    {0xf4, 0x08},
    {0x7c, 0x38},
    {0x72, 0x38},
    {0x7a, 0x80},
    {0x85, 0x18},
    {0x9b, 0x35},
    {0x9e, 0x20},
    {0xd0, 0x66},
    {0xd1, 0x34},
    {0xd3, 0x44},
    {0xd6, 0x44},
    {0xb0, 0x41},
    {0xb2, 0x48},
    {0xb3, 0xf4},
    {0xb4, 0x0b},
    {0xb5, 0x78},
    {0xba, 0xff},
    {0xbb, 0xc0},
    {0xbc, 0x90},
    {0xbd, 0x3a},
    {0xc1, 0x67},
    {0xf0, 0x01},
    {0x20, 0x11},
    {0x23, 0x90},
    {0x24, 0x15},
    {0x25, 0x87},
    {0xbc, 0x9f},
    {0xbd, 0x3a},
    {0x48, 0xe6},
    {0x49, 0xc0},
    {0x4a, 0xd0},
    {0x4b, 0x48},
    {0xf0, 0x00},
    {0x71, 0x92},
    {0x7c, 0x03},
    {0x84, 0xb4},
    {0xf0, 0x33},
    {0x14, 0x95},
    {0xf4, 0x00},
    {0xf0, 0x00},
    {0x87, 0x65},
    {0x7c, 0xf5},

    {0xf0, 0x31},
    {0x00, 0x00}, // sleep mode enable
};

static const sc030iot_reginfo_t MIPI_1lane_24Minput_480p_raw8_60fps[] = {
    {0xf0, 0x30},
    {0x01, 0x00},
    {0x02, 0x00},
    {0x22, 0x00},
    {0x19, 0x00},
    {0x31, 0x08},
    {0x3f, 0x84},
    {0x37, 0x00},
    {0xf0, 0x00},
    {0x53, 0x00},
    {0x70, 0x5c},
    {0x72, 0xc0},
    {0x8b, 0x00},
    {0x8d, 0x04},
    {0x8e, 0x16},
    {0x9e, 0x10},
    {0xb0, 0xc0},
    {0xc8, 0x10},
    {0xc9, 0x10},
    {0xc6, 0x00},
    {0xe0, 0x40},
    {0xde, 0x80},
    {0xf0, 0x01},
    {0x70, 0x02},
    {0x71, 0x82},
    {0x72, 0x20},
    {0x73, 0x08},
    {0x74, 0xe8},
    {0x75, 0x10},
    {0x76, 0x81},
    {0x77, 0x89},
    {0x78, 0x81},
    {0x79, 0xc1},
    {0xf0, 0x33},
    {0x02, 0x12},
    {0x7c, 0x02},
    {0x7d, 0x0e},
    {0xa2, 0x04},
    {0x5e, 0x06},
    {0x5f, 0x0a},
    {0x0b, 0x58},
    {0x06, 0x38},
    {0xf0, 0x32},
    {0x48, 0x02},
    {0xf0, 0x39},
    {0x02, 0x70},
    {0xf0, 0x45},
    {0x09, 0x1c},
    {0xf0, 0x37},
    {0x22, 0x0d},
    {0xf0, 0x33},
    {0x33, 0x10},
    {0xb1, 0x80},
    {0x34, 0x40},
    {0x0b, 0x54},
    {0xb2, 0x78},
    {0xf0, 0x36},
    {0x11, 0x80},
    {0xea, 0x08},
    {0xec, 0x29},
    {0xed, 0x18},
    {0xf0, 0x48},
    {0x19, 0x04},
    {0x1B, 0x03},
    {0x1D, 0x08},
    {0x1F, 0x02},
    {0x21, 0x07},
    {0x23, 0x02},
    {0x25, 0x02},
    {0x27, 0x02},
    {0x29, 0x03},
    {0xf4, 0x0a},
    {0xf5, 0xff},
    {0xf0, 0x30},
    {0x38, 0x44},
    {0xf0, 0x00},
    {0x8b, 0x00},
    {0x70, 0x4c},
    {0x9e, 0x10},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x01, 0x10},
    {0x0b, 0x6c},
    {0x06, 0x24},
    {0xf0, 0x36},
    {0x31, 0x82},
    {0x3e, 0x60},
    {0x30, 0xf0},
    {0x33, 0x33},
    {0xf0, 0x34},
    {0x9f, 0x02},
    {0xa6, 0x40},
    {0xa7, 0x47},
    {0xe8, 0x5f},
    {0xa8, 0x51},
    {0xa9, 0x44},
    {0xe9, 0x36},
    {0xf0, 0x33},
    {0xb3, 0x51},
    {0x64, 0x17},
    {0x90, 0x01},
    {0x91, 0x03},
    {0x92, 0x07},
    {0x01, 0x10},
    {0x93, 0x10},
    {0x94, 0x10},
    {0x95, 0x10},
    {0x96, 0x01},
    {0x97, 0x07},
    {0x98, 0x1f},
    {0x99, 0x10},
    {0x9a, 0x20},
    {0x9b, 0x28},
    {0x9c, 0x28},
    {0xf0, 0x36},
    {0x70, 0x54},
    {0xb6, 0x40},
    {0xb7, 0x41},
    {0xb8, 0x43},
    {0xb9, 0x47},
    {0xba, 0x4f},
    {0xb0, 0x8b},
    {0xb1, 0x8b},
    {0xb2, 0x8b},
    {0xb3, 0x9b},
    {0xb4, 0xb8},
    {0xb5, 0xf0},
    {0x7e, 0x41},
    {0x7f, 0x47},
    {0x77, 0x83},
    {0x78, 0x84},
    {0x79, 0x8a},
    {0xa0, 0x47},
    {0xa1, 0x5f},
    {0x96, 0x43},
    {0x97, 0x44},
    {0x98, 0x54},
    {0xf0, 0x00},
    {0xe0, 0x04},
    {0xf0, 0x01},
    {0x73, 0x00},
    {0x74, 0xe0},
    {0x70, 0x00},
    {0x71, 0x80},
    {0xf0, 0x36},
    {0x37, 0x74},
    {0xf0, 0x37},
    {0x24, 0x21},
    {0xf0, 0x36},
    {0x41, 0x60},
    {0xf0, 0x00},
    {0x71, 0x92},
    {0x7c, 0x03},
    {0x84, 0xb4},
    {0xf0, 0x33},
    {0x14, 0x95},
    {0xf0, 0x36},
    {0xea, 0x09},
    {0xf0, 0x3f},
    {0x03, 0xd5},
    {0xf0, 0x32},
    {0x0c, 0x03},
    {0x0d, 0x84},
    {0x0e, 0x01},
    {0x0f, 0xf4},
    {0xf0, 0x00},
    {0x8d, 0x03},
    {0x8e, 0xe0},

    {0xf0, 0x31},
    {0x00, 0x00}, // sleep mode enable
};
#endif

#ifdef __cplusplus
}
#endif
