/*
 * SPDX-FileCopyrightText: 2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: CC0-1.0
 */

#include <inttypes.h>
#include "driver/i2c_master.h"
#include "driver/gpio.h"
#include "esp_log.h"
#include "unity.h"
#include "unity_test_runner.h"

#include "esp_lcd_touch_cst816s.h"

#define TEST_TOUCH_I2C_NUM       (0)
#define TEST_TOUCH_I2C_CLK_HZ    (400000)

#define TEST_LCD_H_RES              (240)
#define TEST_LCD_V_RES              (240)

/* LCD touch pins */
#define TEST_TOUCH_I2C_SCL       (GPIO_NUM_18)
#define TEST_TOUCH_I2C_SDA       (GPIO_NUM_8)
#define TEST_TOUCH_GPIO_INT      (GPIO_NUM_3)

TEST_CASE("test cst816s to initialize touch", "[cst816s][i2c]")
{
    /* Initilize I2C */
    i2c_master_bus_handle_t i2c_handle = NULL;
    const i2c_master_bus_config_t i2c_config = {
        .i2c_port = TEST_TOUCH_I2C_NUM,
        .sda_io_num = TEST_TOUCH_I2C_SDA,
        .scl_io_num = TEST_TOUCH_I2C_SCL,
        .clk_source = I2C_CLK_SRC_DEFAULT,
    };
    TEST_ESP_OK(i2c_new_master_bus(&i2c_config, &i2c_handle));

    /* Initialize touch HW */
    const esp_lcd_touch_config_t tp_cfg = {
        .x_max = TEST_LCD_H_RES,
        .y_max = TEST_LCD_V_RES,
        .rst_gpio_num = GPIO_NUM_NC, // Shared with LCD reset
        .int_gpio_num = TEST_TOUCH_GPIO_INT,
        .levels = {
            .reset = 0,
            .interrupt = 0,
        },
        .flags = {
            .swap_xy = 0,
            .mirror_x = 1,
            .mirror_y = 0,
        },
    };

    esp_lcd_touch_handle_t touch_handle;
    esp_lcd_panel_io_handle_t tp_io_handle = NULL;
    esp_lcd_panel_io_i2c_config_t tp_io_config = ESP_LCD_TOUCH_IO_I2C_CST816S_CONFIG();
    tp_io_config.scl_speed_hz = TEST_TOUCH_I2C_CLK_HZ;
    TEST_ESP_OK(esp_lcd_new_panel_io_i2c(i2c_handle, &tp_io_config, &tp_io_handle));
    TEST_ESP_OK(esp_lcd_touch_new_i2c_cst816s(tp_io_handle, &tp_cfg, &touch_handle));
}

void app_main(void)
{
    printf("CST816S Test\r\n");
    unity_run_menu();
}
