# ESP LCD Touch GT911 Controller

[![Component Registry](https://components.espressif.com/components/espressif/esp_lcd_touch_gt911/badge.svg)](https://components.espressif.com/components/espressif/esp_lcd_touch_gt911)

Implementation of the GT911 touch controller with esp_lcd_touch component.

| Touch controller | Communication interface | Component name | Link to datasheet |
| :--------------: | :---------------------: | :------------: | :---------------: |
| GT911            | I2C                     | esp_lcd_touch_gt911 | [WIKI](https://www.waveshare.com/wiki/7inch-Capacitive-Touch-LCD-C_Datasheets) |

## Add to project

Packages from this repository are uploaded to [Espressif's component service](https://components.espressif.com/).
You can add them to your project via `idf.py add-dependancy`, e.g.
```
    idf.py add-dependency esp_lcd_touch_gt911==1.1.1
```

Alternatively, you can create `idf_component.yml`. More is in [Espressif's documentation](https://docs.espressif.com/projects/esp-idf/en/latest/esp32/api-guides/tools/idf-component-manager.html).

## Example use

Initialization of the touch component.

``` c
    esp_lcd_panel_io_i2c_config_t io_config = ESP_LCD_TOUCH_IO_I2C_GT911_CONFIG();

    esp_lcd_touch_io_gt911_config_t tp_gt911_config = {
        .dev_addr = io_config.dev_addr,
    };

    esp_lcd_touch_config_t tp_cfg = {
        .x_max = CONFIG_LCD_HRES,
        .y_max = CONFIG_LCD_VRES,
        .rst_gpio_num = -1,
        .int_gpio_num = -1,
        .levels = {
            .reset = 0,
            .interrupt = 0,
        },
        .flags = {
            .swap_xy = 0,
            .mirror_x = 0,
            .mirror_y = 0,
        },
        .driver_data = &tp_gt911_config,
    };

    esp_lcd_touch_handle_t tp;
    esp_lcd_touch_new_i2c_gt911(io_handle, &tp_cfg, &tp);
```

Read data from the touch controller and store it in RAM memory. It should be called regularly in poll.

``` c
    esp_lcd_touch_read_data(tp);
```

Get attributes of a single touch point.

``` c
    esp_lcd_touch_point_data_t touch_point_data[1];
    uint8_t touch_cnt = 0;

    ESP_ERROR_CHECK(esp_lcd_touch_get_data(tp, touch_point_data, &touch_cnt, 1));
```
