## 1.3.1

- Fix array bounds check failure in destroy_sccb_device() when compile option is PTIMIZATION_SIZE

## 1.3.0

- Add RISC-V software swap byte function for DVP video device
- Add the customized video class to call esp_cam_sensor ioctl commands directly
- Add the second SPI video device
- Add camera sensor exposure parameter to statistics
- Improve AEC controller time precision
- Fix the CSI video device initializes twice when starting up
- Update to use esp_cam_sensor v1.4.x
- Update to use esp_ipa v1.2.x
- Update to use newer version of usb_host_uvc 2.3.x

## 1.2.0

- Add multiple camera web server
- Add multiple camera sensor option in menuconfig
- Add FPS calculation to DVP and SPI video device
- Add support for USB UVC streams
  - The USB camera should be plugged in before the APPs call the function to open the USB UVC video device, and should be unplugged after the APPs call the function to close the UVC video device
- Example encode function supports multiple resolutions
- Example simple_video_server uses a new web interface to display and control camera streams
- Fix compilation error when enabling DVP and MIPI-CSI detection of one sensor
- Fix MIPI-CSI video device RAW Bayer order mapping issue
- Fix sdkconfig.default.esp32s3 for better image bandwidth
- Modify GPIO pin type from int8_t to gpio_num_t
- Compatible with ESP-IDF v5.4.x(x ≥ 3), v5.5.1, and the later versions of the ESP-IDF DVP CAM driver
- Initialize the video device first in the web example to avoid sensor detection failure.

## 1.1.0

- Add SPI video device and board-level configuration
- Add ESP32-S3/C3/C5/C6/C61 platforms
- Fix open function crashes after failing to initialize the video device
- Fix video buffer sequence error
- Fix esp_video_deinit error when using a sensor that has an internal ISP
- Enhance the clarity and readability of prompt and help descriptions in Kconfig file

### Enhancements

- ESP32-C3/C5/C6/C61 only support SPI video device
- ESP32-S3 supports the SPI and LCD_CAM DVP video devices, but only IDF v6.0.0 and later versions support LCD_CAM DVP for ESP32-S3

## 1.0.0

- Add statistics region configuration to ISP pipeline controller
- Add byte swap functionality for DVP video device to swap RGB565 pixel byte sequence
- Add example common component to simplify the esp_video board-level configuration and initialization
- Add camera motor control to ISP pipeline controller to implement auto-focus
- Add V4L2 command VIDIOC_S_PARM and VIDIOC_G_PARM
- Add software frame skipping to MIPI-CSI video device
- Fix the esp_video_deinit function issue when esp_video initialize with application I2C handle
- Fix the esp_video close issue when one video device is open and closed multiple times
- Fix the issue that the V4L2 command VIDIOC_ENUM_FMT can't get the correct value by input index when the sensor output format is RAW10
- Change AE sample point to AFTER_DEMOSAIC
- Update to use esp_cam_sensor v1.1.x

## 0.9.1

- Add a new port for stream url in simple web example
- V4L2 command VIDIOC_S_FMT returns -1 when the APP sets an invalid resolution(width or height is invalid)

## 0.9.0

- Add esp_video_deinit to free esp_video resource
- Add option ISP_PIPELINE_CONTROLLER_TASK_STACK_USE_PSRAM to make ISP controller task use PSRAM as task stack
- Add LSC auto-configuration in the ISP controller
- Add sensor AE target auto-configuration in the ISP controller
- Add autofocus(AF) ioctl command
- Add auto white balance(AWB) statistics ioctl command
- Add video owner to free video buffer when CSI video device is closed by users
- Add I2C initialization in the capture example
- Add image storage examples, including SD card and USB MSC device
- Add short data swapping feature for ESP32-P4 MIPI-CSI video device
- ISP supports output RAW10 and RAW12 stream
- esp_video v0.9.x is fixed to using esp_cam_sensor v1.0.x and esp_ipa v0.3.x

## 0.8.0~1

- esp-video v0.8.x is fixed to using esp_cam_sensor v0.8.x and esp_ipa v0.2.x

## 0.8.0

- Supported enabling multiple camera sensors in menuconfig
- Supported getting sensor statistics by "ioctl"
- Supported setting sensor AE level by "ioctl"
- Supported searching and loading sensors' configuration parameters generated by JSON configuration files automatically
- Supported getting and setting LSC by "ioctl"
- Supported checking and set bayer order into ISP automatically
- Supported using Wi-Fi in web camera example
- Fixed ISP bypass mode issues
- Fixed stream breaking issue in web camera example
- Fixed UVC example reopening issue
- Fixed compiling error by fixing the tinyusb version on 0.15.0~10
- Increased TCP throughput by modifying configuration parameters
- Enabled JPEG hardware video device in UVC example by default
- Modified ESP-IDF version from v5.3 to v5.4 to support full ISP modules

## 0.7.0

- Add ISP pipeline controller
- ISP video device supports capturing statistics of sensor's outputting picture
- Apply image process algorithms(esp_ipa) for ISP
- Fix YUV encode and quantization error

### Enhancements

ISP pipeline controller and esp_ipa integrate and apply the following algorithms:

- Auto white balance
- Auto gain control
- Auto denoising control
- Auto enhancement control
- Color correction matrix

## 0.6.0~1

- Add USB video class(UVC) example
- Add video HTTP web server example
- Add setting customized camera sensor configuration example
- Fix capture stream example device path error

### Enhancements

- UVC supports output JPEG or H.264 format stream
- Video HTTP web server supports output JPEG format stream

## 0.6.0

- Add ISP video device
- Add V4L2 command VIDIOC_QUERYMENU to query the enumeration item
- Add setting/getting RGB2YUV standard
- Fix read/write control ID issues

### Enhancements

- ISP video device supports following features:
    - Red balance(red channel gain)
    - Blue balance(blue channel gain)
    - BF(bayer filter)
    - CCM(color correction matrix)
    - Sharpen
    - GAMMA
    - Demosaic
    - Brightness
    - Contrast
    - Saturation
    - Hue

- RGB2YUV encode items are as follows:
    - V4L2_YCBCR_ENC_601(V4L2_YCBCR_ENC_DEFAULT)
    - V4L2_YCBCR_ENC_709

- RGB2YUV quantization items are as follows
    - V4L2_QUANTIZATION_LIM_RANGE
    - V4L2_QUANTIZATION_FULL_RANGE(V4L2_QUANTIZATION_DEFAULT)

## 0.5.1

- Fix sensor initialization failed when bring up power
- Fix abnormal crash when setting CPU cache line size to be 128 bytes
- Fix other compiling error

## 0.5.0

- Support multiple opening and controlling video device
- DVP video device supports gray format and using external XTAL
- Add more V4L2 control IDs
- Add video buffer flag V4L2_BUF_FLAG_ERROR when the video process has an error
- Add extended command to set or get sensor format
- Bind video device to specific index name, for more details refer to README.md
- Video device drops all buffer after calling the command VIDIOC_STREAMOFF
- Fix V4L2 control value checking error
- Optimize video core API parameters checking

### Enhancements

- Added V4L2 control IDs:
    ```
    V4L2_CID_GAIN
    V4L2_CID_EXPOSURE_ABSOLUTE
    V4L2_CID_EXPOSURE
    V4L2_CID_TEST_PATTERN
    ```
- Added extended commands:
    ```
    VIDIOC_S_SENSOR_FMT
    VIDIOC_G_SENSOR_FMT
    ```

## 0.4.0

- Support H.264 hardware encode video device
- Support JPEG hardware encode video device
- CSI video device supports to receive data directly from sensor, such RGB, YUV and so on
- Add option ESP_VIDEO_DISABLE_MIPI_CSI_DRIVER_BACKUP_BUFFER to disable MIPI-CSI driver backup buffer

## 0.3.0

- Support ESP32-P4 LCD_CAM DVP video device

## 0.2.0

- Support V4L2 `V4L2_MEMORY_USERPTR`
- Fix CSI video device stop issue
- Fix I2C clock frequency can't be used when input I2C handle

## 0.1.2

- Update the API and macro to support ESP-IDF new version

## 0.1.1

- Modify API `esp_video_create` and put camera device management from video core to hardware device driver

## 0.1.0

- Initial version for esp_video component

### Enhancements

- MIPI CSI video device
- Virtual file system to control video device
- Linux V4L2 commands mainly includes(actually not support commands' full features):

```
    VIDIOC_QUERYCAP

    VIDIOC_STREAMON
    VIDIOC_STREAMOFF

    VIDIOC_ENUM_FMT
    VIDIOC_G_FMT
    VIDIOC_S_FMT

    VIDIOC_REQBUFS
    VIDIOC_QUERYBUF
    VIDIOC_QBUF
    VIDIOC_DQBUF

    VIDIOC_G_EXT_CTRLS
    VIDIOC_S_EXT_CTRLS
    VIDIOC_QUERY_EXT_CTRL
```
