/*
 * SPDX-FileCopyrightText: 2024-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#pragma once
#include <array>
#include "usb/uvc_host.h"

constexpr uvc_host_stream_format_t logo_jpg_format = {
    .h_res = 46,
    .v_res = 46,
    .fps = 15,
    .format = UVC_VS_FORMAT_MJPEG,
};

std::array<unsigned char, 7561> logo_jpg = {
    0xff, 0xd8, 0xff, 0xe0, 0x00, 0x10, 0x4a, 0x46, 0x49, 0x46, 0x00, 0x01,
    0x01, 0x01, 0x00, 0x48, 0x00, 0x48, 0x00, 0x00, 0xff, 0xe2, 0x0c, 0x58,
    0x49, 0x43, 0x43, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x00,
    0x01, 0x01, 0x00, 0x00, 0x0c, 0x48, 0x4c, 0x69, 0x6e, 0x6f, 0x02, 0x10,
    0x00, 0x00, 0x6d, 0x6e, 0x74, 0x72, 0x52, 0x47, 0x42, 0x20, 0x58, 0x59,
    0x5a, 0x20, 0x07, 0xce, 0x00, 0x02, 0x00, 0x09, 0x00, 0x06, 0x00, 0x31,
    0x00, 0x00, 0x61, 0x63, 0x73, 0x70, 0x4d, 0x53, 0x46, 0x54, 0x00, 0x00,
    0x00, 0x00, 0x49, 0x45, 0x43, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf6, 0xd6, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0xd3, 0x2d, 0x48, 0x50,
    0x20, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x11, 0x63, 0x70, 0x72, 0x74, 0x00, 0x00, 0x01, 0x50, 0x00, 0x00,
    0x00, 0x33, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x01, 0x84, 0x00, 0x00,
    0x00, 0x6c, 0x77, 0x74, 0x70, 0x74, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00,
    0x00, 0x14, 0x62, 0x6b, 0x70, 0x74, 0x00, 0x00, 0x02, 0x04, 0x00, 0x00,
    0x00, 0x14, 0x72, 0x58, 0x59, 0x5a, 0x00, 0x00, 0x02, 0x18, 0x00, 0x00,
    0x00, 0x14, 0x67, 0x58, 0x59, 0x5a, 0x00, 0x00, 0x02, 0x2c, 0x00, 0x00,
    0x00, 0x14, 0x62, 0x58, 0x59, 0x5a, 0x00, 0x00, 0x02, 0x40, 0x00, 0x00,
    0x00, 0x14, 0x64, 0x6d, 0x6e, 0x64, 0x00, 0x00, 0x02, 0x54, 0x00, 0x00,
    0x00, 0x70, 0x64, 0x6d, 0x64, 0x64, 0x00, 0x00, 0x02, 0xc4, 0x00, 0x00,
    0x00, 0x88, 0x76, 0x75, 0x65, 0x64, 0x00, 0x00, 0x03, 0x4c, 0x00, 0x00,
    0x00, 0x86, 0x76, 0x69, 0x65, 0x77, 0x00, 0x00, 0x03, 0xd4, 0x00, 0x00,
    0x00, 0x24, 0x6c, 0x75, 0x6d, 0x69, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00,
    0x00, 0x14, 0x6d, 0x65, 0x61, 0x73, 0x00, 0x00, 0x04, 0x0c, 0x00, 0x00,
    0x00, 0x24, 0x74, 0x65, 0x63, 0x68, 0x00, 0x00, 0x04, 0x30, 0x00, 0x00,
    0x00, 0x0c, 0x72, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3c, 0x00, 0x00,
    0x08, 0x0c, 0x67, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3c, 0x00, 0x00,
    0x08, 0x0c, 0x62, 0x54, 0x52, 0x43, 0x00, 0x00, 0x04, 0x3c, 0x00, 0x00,
    0x08, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x00, 0x00, 0x00, 0x00, 0x43, 0x6f,
    0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x28, 0x63, 0x29, 0x20,
    0x31, 0x39, 0x39, 0x38, 0x20, 0x48, 0x65, 0x77, 0x6c, 0x65, 0x74, 0x74,
    0x2d, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x72, 0x64, 0x20, 0x43, 0x6f, 0x6d,
    0x70, 0x61, 0x6e, 0x79, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x73, 0x52, 0x47, 0x42, 0x20, 0x49,
    0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2d, 0x32, 0x2e, 0x31, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x73,
    0x52, 0x47, 0x42, 0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36,
    0x2d, 0x32, 0x2e, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x59, 0x5a, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xf3, 0x51, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
    0x16, 0xcc, 0x58, 0x59, 0x5a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x59,
    0x5a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6f, 0xa2, 0x00, 0x00,
    0x38, 0xf5, 0x00, 0x00, 0x03, 0x90, 0x58, 0x59, 0x5a, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x62, 0x99, 0x00, 0x00, 0xb7, 0x85, 0x00, 0x00,
    0x18, 0xda, 0x58, 0x59, 0x5a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x24, 0xa0, 0x00, 0x00, 0x0f, 0x84, 0x00, 0x00, 0xb6, 0xcf, 0x64, 0x65,
    0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49, 0x45,
    0x43, 0x20, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77,
    0x2e, 0x69, 0x65, 0x63, 0x2e, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x49, 0x45, 0x43, 0x20, 0x68,
    0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x65,
    0x63, 0x2e, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x2e, 0x49, 0x45, 0x43, 0x20, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2d,
    0x32, 0x2e, 0x31, 0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x20,
    0x52, 0x47, 0x42, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x75, 0x72, 0x20, 0x73,
    0x70, 0x61, 0x63, 0x65, 0x20, 0x2d, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0x49,
    0x45, 0x43, 0x20, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2d, 0x32, 0x2e, 0x31,
    0x20, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x20, 0x52, 0x47, 0x42,
    0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x75, 0x72, 0x20, 0x73, 0x70, 0x61, 0x63,
    0x65, 0x20, 0x2d, 0x20, 0x73, 0x52, 0x47, 0x42, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x65, 0x73, 0x63, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x2c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
    0x6e, 0x63, 0x65, 0x20, 0x56, 0x69, 0x65, 0x77, 0x69, 0x6e, 0x67, 0x20,
    0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e,
    0x20, 0x49, 0x45, 0x43, 0x36, 0x31, 0x39, 0x36, 0x36, 0x2d, 0x32, 0x2e,
    0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x2c, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x56,
    0x69, 0x65, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x43, 0x6f, 0x6e, 0x64, 0x69,
    0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x49, 0x45, 0x43, 0x36,
    0x31, 0x39, 0x36, 0x36, 0x2d, 0x32, 0x2e, 0x31, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x76, 0x69,
    0x65, 0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0xa4, 0xfe, 0x00, 0x14,
    0x5f, 0x2e, 0x00, 0x10, 0xcf, 0x14, 0x00, 0x03, 0xed, 0xcc, 0x00, 0x04,
    0x13, 0x0b, 0x00, 0x03, 0x5c, 0x9e, 0x00, 0x00, 0x00, 0x01, 0x58, 0x59,
    0x5a, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x09, 0x56, 0x00, 0x50,
    0x00, 0x00, 0x00, 0x57, 0x1f, 0xe7, 0x6d, 0x65, 0x61, 0x73, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x02, 0x8f, 0x00, 0x00, 0x00, 0x02, 0x73, 0x69, 0x67, 0x20, 0x00, 0x00,
    0x00, 0x00, 0x43, 0x52, 0x54, 0x20, 0x63, 0x75, 0x72, 0x76, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x0a,
    0x00, 0x0f, 0x00, 0x14, 0x00, 0x19, 0x00, 0x1e, 0x00, 0x23, 0x00, 0x28,
    0x00, 0x2d, 0x00, 0x32, 0x00, 0x37, 0x00, 0x3b, 0x00, 0x40, 0x00, 0x45,
    0x00, 0x4a, 0x00, 0x4f, 0x00, 0x54, 0x00, 0x59, 0x00, 0x5e, 0x00, 0x63,
    0x00, 0x68, 0x00, 0x6d, 0x00, 0x72, 0x00, 0x77, 0x00, 0x7c, 0x00, 0x81,
    0x00, 0x86, 0x00, 0x8b, 0x00, 0x90, 0x00, 0x95, 0x00, 0x9a, 0x00, 0x9f,
    0x00, 0xa4, 0x00, 0xa9, 0x00, 0xae, 0x00, 0xb2, 0x00, 0xb7, 0x00, 0xbc,
    0x00, 0xc1, 0x00, 0xc6, 0x00, 0xcb, 0x00, 0xd0, 0x00, 0xd5, 0x00, 0xdb,
    0x00, 0xe0, 0x00, 0xe5, 0x00, 0xeb, 0x00, 0xf0, 0x00, 0xf6, 0x00, 0xfb,
    0x01, 0x01, 0x01, 0x07, 0x01, 0x0d, 0x01, 0x13, 0x01, 0x19, 0x01, 0x1f,
    0x01, 0x25, 0x01, 0x2b, 0x01, 0x32, 0x01, 0x38, 0x01, 0x3e, 0x01, 0x45,
    0x01, 0x4c, 0x01, 0x52, 0x01, 0x59, 0x01, 0x60, 0x01, 0x67, 0x01, 0x6e,
    0x01, 0x75, 0x01, 0x7c, 0x01, 0x83, 0x01, 0x8b, 0x01, 0x92, 0x01, 0x9a,
    0x01, 0xa1, 0x01, 0xa9, 0x01, 0xb1, 0x01, 0xb9, 0x01, 0xc1, 0x01, 0xc9,
    0x01, 0xd1, 0x01, 0xd9, 0x01, 0xe1, 0x01, 0xe9, 0x01, 0xf2, 0x01, 0xfa,
    0x02, 0x03, 0x02, 0x0c, 0x02, 0x14, 0x02, 0x1d, 0x02, 0x26, 0x02, 0x2f,
    0x02, 0x38, 0x02, 0x41, 0x02, 0x4b, 0x02, 0x54, 0x02, 0x5d, 0x02, 0x67,
    0x02, 0x71, 0x02, 0x7a, 0x02, 0x84, 0x02, 0x8e, 0x02, 0x98, 0x02, 0xa2,
    0x02, 0xac, 0x02, 0xb6, 0x02, 0xc1, 0x02, 0xcb, 0x02, 0xd5, 0x02, 0xe0,
    0x02, 0xeb, 0x02, 0xf5, 0x03, 0x00, 0x03, 0x0b, 0x03, 0x16, 0x03, 0x21,
    0x03, 0x2d, 0x03, 0x38, 0x03, 0x43, 0x03, 0x4f, 0x03, 0x5a, 0x03, 0x66,
    0x03, 0x72, 0x03, 0x7e, 0x03, 0x8a, 0x03, 0x96, 0x03, 0xa2, 0x03, 0xae,
    0x03, 0xba, 0x03, 0xc7, 0x03, 0xd3, 0x03, 0xe0, 0x03, 0xec, 0x03, 0xf9,
    0x04, 0x06, 0x04, 0x13, 0x04, 0x20, 0x04, 0x2d, 0x04, 0x3b, 0x04, 0x48,
    0x04, 0x55, 0x04, 0x63, 0x04, 0x71, 0x04, 0x7e, 0x04, 0x8c, 0x04, 0x9a,
    0x04, 0xa8, 0x04, 0xb6, 0x04, 0xc4, 0x04, 0xd3, 0x04, 0xe1, 0x04, 0xf0,
    0x04, 0xfe, 0x05, 0x0d, 0x05, 0x1c, 0x05, 0x2b, 0x05, 0x3a, 0x05, 0x49,
    0x05, 0x58, 0x05, 0x67, 0x05, 0x77, 0x05, 0x86, 0x05, 0x96, 0x05, 0xa6,
    0x05, 0xb5, 0x05, 0xc5, 0x05, 0xd5, 0x05, 0xe5, 0x05, 0xf6, 0x06, 0x06,
    0x06, 0x16, 0x06, 0x27, 0x06, 0x37, 0x06, 0x48, 0x06, 0x59, 0x06, 0x6a,
    0x06, 0x7b, 0x06, 0x8c, 0x06, 0x9d, 0x06, 0xaf, 0x06, 0xc0, 0x06, 0xd1,
    0x06, 0xe3, 0x06, 0xf5, 0x07, 0x07, 0x07, 0x19, 0x07, 0x2b, 0x07, 0x3d,
    0x07, 0x4f, 0x07, 0x61, 0x07, 0x74, 0x07, 0x86, 0x07, 0x99, 0x07, 0xac,
    0x07, 0xbf, 0x07, 0xd2, 0x07, 0xe5, 0x07, 0xf8, 0x08, 0x0b, 0x08, 0x1f,
    0x08, 0x32, 0x08, 0x46, 0x08, 0x5a, 0x08, 0x6e, 0x08, 0x82, 0x08, 0x96,
    0x08, 0xaa, 0x08, 0xbe, 0x08, 0xd2, 0x08, 0xe7, 0x08, 0xfb, 0x09, 0x10,
    0x09, 0x25, 0x09, 0x3a, 0x09, 0x4f, 0x09, 0x64, 0x09, 0x79, 0x09, 0x8f,
    0x09, 0xa4, 0x09, 0xba, 0x09, 0xcf, 0x09, 0xe5, 0x09, 0xfb, 0x0a, 0x11,
    0x0a, 0x27, 0x0a, 0x3d, 0x0a, 0x54, 0x0a, 0x6a, 0x0a, 0x81, 0x0a, 0x98,
    0x0a, 0xae, 0x0a, 0xc5, 0x0a, 0xdc, 0x0a, 0xf3, 0x0b, 0x0b, 0x0b, 0x22,
    0x0b, 0x39, 0x0b, 0x51, 0x0b, 0x69, 0x0b, 0x80, 0x0b, 0x98, 0x0b, 0xb0,
    0x0b, 0xc8, 0x0b, 0xe1, 0x0b, 0xf9, 0x0c, 0x12, 0x0c, 0x2a, 0x0c, 0x43,
    0x0c, 0x5c, 0x0c, 0x75, 0x0c, 0x8e, 0x0c, 0xa7, 0x0c, 0xc0, 0x0c, 0xd9,
    0x0c, 0xf3, 0x0d, 0x0d, 0x0d, 0x26, 0x0d, 0x40, 0x0d, 0x5a, 0x0d, 0x74,
    0x0d, 0x8e, 0x0d, 0xa9, 0x0d, 0xc3, 0x0d, 0xde, 0x0d, 0xf8, 0x0e, 0x13,
    0x0e, 0x2e, 0x0e, 0x49, 0x0e, 0x64, 0x0e, 0x7f, 0x0e, 0x9b, 0x0e, 0xb6,
    0x0e, 0xd2, 0x0e, 0xee, 0x0f, 0x09, 0x0f, 0x25, 0x0f, 0x41, 0x0f, 0x5e,
    0x0f, 0x7a, 0x0f, 0x96, 0x0f, 0xb3, 0x0f, 0xcf, 0x0f, 0xec, 0x10, 0x09,
    0x10, 0x26, 0x10, 0x43, 0x10, 0x61, 0x10, 0x7e, 0x10, 0x9b, 0x10, 0xb9,
    0x10, 0xd7, 0x10, 0xf5, 0x11, 0x13, 0x11, 0x31, 0x11, 0x4f, 0x11, 0x6d,
    0x11, 0x8c, 0x11, 0xaa, 0x11, 0xc9, 0x11, 0xe8, 0x12, 0x07, 0x12, 0x26,
    0x12, 0x45, 0x12, 0x64, 0x12, 0x84, 0x12, 0xa3, 0x12, 0xc3, 0x12, 0xe3,
    0x13, 0x03, 0x13, 0x23, 0x13, 0x43, 0x13, 0x63, 0x13, 0x83, 0x13, 0xa4,
    0x13, 0xc5, 0x13, 0xe5, 0x14, 0x06, 0x14, 0x27, 0x14, 0x49, 0x14, 0x6a,
    0x14, 0x8b, 0x14, 0xad, 0x14, 0xce, 0x14, 0xf0, 0x15, 0x12, 0x15, 0x34,
    0x15, 0x56, 0x15, 0x78, 0x15, 0x9b, 0x15, 0xbd, 0x15, 0xe0, 0x16, 0x03,
    0x16, 0x26, 0x16, 0x49, 0x16, 0x6c, 0x16, 0x8f, 0x16, 0xb2, 0x16, 0xd6,
    0x16, 0xfa, 0x17, 0x1d, 0x17, 0x41, 0x17, 0x65, 0x17, 0x89, 0x17, 0xae,
    0x17, 0xd2, 0x17, 0xf7, 0x18, 0x1b, 0x18, 0x40, 0x18, 0x65, 0x18, 0x8a,
    0x18, 0xaf, 0x18, 0xd5, 0x18, 0xfa, 0x19, 0x20, 0x19, 0x45, 0x19, 0x6b,
    0x19, 0x91, 0x19, 0xb7, 0x19, 0xdd, 0x1a, 0x04, 0x1a, 0x2a, 0x1a, 0x51,
    0x1a, 0x77, 0x1a, 0x9e, 0x1a, 0xc5, 0x1a, 0xec, 0x1b, 0x14, 0x1b, 0x3b,
    0x1b, 0x63, 0x1b, 0x8a, 0x1b, 0xb2, 0x1b, 0xda, 0x1c, 0x02, 0x1c, 0x2a,
    0x1c, 0x52, 0x1c, 0x7b, 0x1c, 0xa3, 0x1c, 0xcc, 0x1c, 0xf5, 0x1d, 0x1e,
    0x1d, 0x47, 0x1d, 0x70, 0x1d, 0x99, 0x1d, 0xc3, 0x1d, 0xec, 0x1e, 0x16,
    0x1e, 0x40, 0x1e, 0x6a, 0x1e, 0x94, 0x1e, 0xbe, 0x1e, 0xe9, 0x1f, 0x13,
    0x1f, 0x3e, 0x1f, 0x69, 0x1f, 0x94, 0x1f, 0xbf, 0x1f, 0xea, 0x20, 0x15,
    0x20, 0x41, 0x20, 0x6c, 0x20, 0x98, 0x20, 0xc4, 0x20, 0xf0, 0x21, 0x1c,
    0x21, 0x48, 0x21, 0x75, 0x21, 0xa1, 0x21, 0xce, 0x21, 0xfb, 0x22, 0x27,
    0x22, 0x55, 0x22, 0x82, 0x22, 0xaf, 0x22, 0xdd, 0x23, 0x0a, 0x23, 0x38,
    0x23, 0x66, 0x23, 0x94, 0x23, 0xc2, 0x23, 0xf0, 0x24, 0x1f, 0x24, 0x4d,
    0x24, 0x7c, 0x24, 0xab, 0x24, 0xda, 0x25, 0x09, 0x25, 0x38, 0x25, 0x68,
    0x25, 0x97, 0x25, 0xc7, 0x25, 0xf7, 0x26, 0x27, 0x26, 0x57, 0x26, 0x87,
    0x26, 0xb7, 0x26, 0xe8, 0x27, 0x18, 0x27, 0x49, 0x27, 0x7a, 0x27, 0xab,
    0x27, 0xdc, 0x28, 0x0d, 0x28, 0x3f, 0x28, 0x71, 0x28, 0xa2, 0x28, 0xd4,
    0x29, 0x06, 0x29, 0x38, 0x29, 0x6b, 0x29, 0x9d, 0x29, 0xd0, 0x2a, 0x02,
    0x2a, 0x35, 0x2a, 0x68, 0x2a, 0x9b, 0x2a, 0xcf, 0x2b, 0x02, 0x2b, 0x36,
    0x2b, 0x69, 0x2b, 0x9d, 0x2b, 0xd1, 0x2c, 0x05, 0x2c, 0x39, 0x2c, 0x6e,
    0x2c, 0xa2, 0x2c, 0xd7, 0x2d, 0x0c, 0x2d, 0x41, 0x2d, 0x76, 0x2d, 0xab,
    0x2d, 0xe1, 0x2e, 0x16, 0x2e, 0x4c, 0x2e, 0x82, 0x2e, 0xb7, 0x2e, 0xee,
    0x2f, 0x24, 0x2f, 0x5a, 0x2f, 0x91, 0x2f, 0xc7, 0x2f, 0xfe, 0x30, 0x35,
    0x30, 0x6c, 0x30, 0xa4, 0x30, 0xdb, 0x31, 0x12, 0x31, 0x4a, 0x31, 0x82,
    0x31, 0xba, 0x31, 0xf2, 0x32, 0x2a, 0x32, 0x63, 0x32, 0x9b, 0x32, 0xd4,
    0x33, 0x0d, 0x33, 0x46, 0x33, 0x7f, 0x33, 0xb8, 0x33, 0xf1, 0x34, 0x2b,
    0x34, 0x65, 0x34, 0x9e, 0x34, 0xd8, 0x35, 0x13, 0x35, 0x4d, 0x35, 0x87,
    0x35, 0xc2, 0x35, 0xfd, 0x36, 0x37, 0x36, 0x72, 0x36, 0xae, 0x36, 0xe9,
    0x37, 0x24, 0x37, 0x60, 0x37, 0x9c, 0x37, 0xd7, 0x38, 0x14, 0x38, 0x50,
    0x38, 0x8c, 0x38, 0xc8, 0x39, 0x05, 0x39, 0x42, 0x39, 0x7f, 0x39, 0xbc,
    0x39, 0xf9, 0x3a, 0x36, 0x3a, 0x74, 0x3a, 0xb2, 0x3a, 0xef, 0x3b, 0x2d,
    0x3b, 0x6b, 0x3b, 0xaa, 0x3b, 0xe8, 0x3c, 0x27, 0x3c, 0x65, 0x3c, 0xa4,
    0x3c, 0xe3, 0x3d, 0x22, 0x3d, 0x61, 0x3d, 0xa1, 0x3d, 0xe0, 0x3e, 0x20,
    0x3e, 0x60, 0x3e, 0xa0, 0x3e, 0xe0, 0x3f, 0x21, 0x3f, 0x61, 0x3f, 0xa2,
    0x3f, 0xe2, 0x40, 0x23, 0x40, 0x64, 0x40, 0xa6, 0x40, 0xe7, 0x41, 0x29,
    0x41, 0x6a, 0x41, 0xac, 0x41, 0xee, 0x42, 0x30, 0x42, 0x72, 0x42, 0xb5,
    0x42, 0xf7, 0x43, 0x3a, 0x43, 0x7d, 0x43, 0xc0, 0x44, 0x03, 0x44, 0x47,
    0x44, 0x8a, 0x44, 0xce, 0x45, 0x12, 0x45, 0x55, 0x45, 0x9a, 0x45, 0xde,
    0x46, 0x22, 0x46, 0x67, 0x46, 0xab, 0x46, 0xf0, 0x47, 0x35, 0x47, 0x7b,
    0x47, 0xc0, 0x48, 0x05, 0x48, 0x4b, 0x48, 0x91, 0x48, 0xd7, 0x49, 0x1d,
    0x49, 0x63, 0x49, 0xa9, 0x49, 0xf0, 0x4a, 0x37, 0x4a, 0x7d, 0x4a, 0xc4,
    0x4b, 0x0c, 0x4b, 0x53, 0x4b, 0x9a, 0x4b, 0xe2, 0x4c, 0x2a, 0x4c, 0x72,
    0x4c, 0xba, 0x4d, 0x02, 0x4d, 0x4a, 0x4d, 0x93, 0x4d, 0xdc, 0x4e, 0x25,
    0x4e, 0x6e, 0x4e, 0xb7, 0x4f, 0x00, 0x4f, 0x49, 0x4f, 0x93, 0x4f, 0xdd,
    0x50, 0x27, 0x50, 0x71, 0x50, 0xbb, 0x51, 0x06, 0x51, 0x50, 0x51, 0x9b,
    0x51, 0xe6, 0x52, 0x31, 0x52, 0x7c, 0x52, 0xc7, 0x53, 0x13, 0x53, 0x5f,
    0x53, 0xaa, 0x53, 0xf6, 0x54, 0x42, 0x54, 0x8f, 0x54, 0xdb, 0x55, 0x28,
    0x55, 0x75, 0x55, 0xc2, 0x56, 0x0f, 0x56, 0x5c, 0x56, 0xa9, 0x56, 0xf7,
    0x57, 0x44, 0x57, 0x92, 0x57, 0xe0, 0x58, 0x2f, 0x58, 0x7d, 0x58, 0xcb,
    0x59, 0x1a, 0x59, 0x69, 0x59, 0xb8, 0x5a, 0x07, 0x5a, 0x56, 0x5a, 0xa6,
    0x5a, 0xf5, 0x5b, 0x45, 0x5b, 0x95, 0x5b, 0xe5, 0x5c, 0x35, 0x5c, 0x86,
    0x5c, 0xd6, 0x5d, 0x27, 0x5d, 0x78, 0x5d, 0xc9, 0x5e, 0x1a, 0x5e, 0x6c,
    0x5e, 0xbd, 0x5f, 0x0f, 0x5f, 0x61, 0x5f, 0xb3, 0x60, 0x05, 0x60, 0x57,
    0x60, 0xaa, 0x60, 0xfc, 0x61, 0x4f, 0x61, 0xa2, 0x61, 0xf5, 0x62, 0x49,
    0x62, 0x9c, 0x62, 0xf0, 0x63, 0x43, 0x63, 0x97, 0x63, 0xeb, 0x64, 0x40,
    0x64, 0x94, 0x64, 0xe9, 0x65, 0x3d, 0x65, 0x92, 0x65, 0xe7, 0x66, 0x3d,
    0x66, 0x92, 0x66, 0xe8, 0x67, 0x3d, 0x67, 0x93, 0x67, 0xe9, 0x68, 0x3f,
    0x68, 0x96, 0x68, 0xec, 0x69, 0x43, 0x69, 0x9a, 0x69, 0xf1, 0x6a, 0x48,
    0x6a, 0x9f, 0x6a, 0xf7, 0x6b, 0x4f, 0x6b, 0xa7, 0x6b, 0xff, 0x6c, 0x57,
    0x6c, 0xaf, 0x6d, 0x08, 0x6d, 0x60, 0x6d, 0xb9, 0x6e, 0x12, 0x6e, 0x6b,
    0x6e, 0xc4, 0x6f, 0x1e, 0x6f, 0x78, 0x6f, 0xd1, 0x70, 0x2b, 0x70, 0x86,
    0x70, 0xe0, 0x71, 0x3a, 0x71, 0x95, 0x71, 0xf0, 0x72, 0x4b, 0x72, 0xa6,
    0x73, 0x01, 0x73, 0x5d, 0x73, 0xb8, 0x74, 0x14, 0x74, 0x70, 0x74, 0xcc,
    0x75, 0x28, 0x75, 0x85, 0x75, 0xe1, 0x76, 0x3e, 0x76, 0x9b, 0x76, 0xf8,
    0x77, 0x56, 0x77, 0xb3, 0x78, 0x11, 0x78, 0x6e, 0x78, 0xcc, 0x79, 0x2a,
    0x79, 0x89, 0x79, 0xe7, 0x7a, 0x46, 0x7a, 0xa5, 0x7b, 0x04, 0x7b, 0x63,
    0x7b, 0xc2, 0x7c, 0x21, 0x7c, 0x81, 0x7c, 0xe1, 0x7d, 0x41, 0x7d, 0xa1,
    0x7e, 0x01, 0x7e, 0x62, 0x7e, 0xc2, 0x7f, 0x23, 0x7f, 0x84, 0x7f, 0xe5,
    0x80, 0x47, 0x80, 0xa8, 0x81, 0x0a, 0x81, 0x6b, 0x81, 0xcd, 0x82, 0x30,
    0x82, 0x92, 0x82, 0xf4, 0x83, 0x57, 0x83, 0xba, 0x84, 0x1d, 0x84, 0x80,
    0x84, 0xe3, 0x85, 0x47, 0x85, 0xab, 0x86, 0x0e, 0x86, 0x72, 0x86, 0xd7,
    0x87, 0x3b, 0x87, 0x9f, 0x88, 0x04, 0x88, 0x69, 0x88, 0xce, 0x89, 0x33,
    0x89, 0x99, 0x89, 0xfe, 0x8a, 0x64, 0x8a, 0xca, 0x8b, 0x30, 0x8b, 0x96,
    0x8b, 0xfc, 0x8c, 0x63, 0x8c, 0xca, 0x8d, 0x31, 0x8d, 0x98, 0x8d, 0xff,
    0x8e, 0x66, 0x8e, 0xce, 0x8f, 0x36, 0x8f, 0x9e, 0x90, 0x06, 0x90, 0x6e,
    0x90, 0xd6, 0x91, 0x3f, 0x91, 0xa8, 0x92, 0x11, 0x92, 0x7a, 0x92, 0xe3,
    0x93, 0x4d, 0x93, 0xb6, 0x94, 0x20, 0x94, 0x8a, 0x94, 0xf4, 0x95, 0x5f,
    0x95, 0xc9, 0x96, 0x34, 0x96, 0x9f, 0x97, 0x0a, 0x97, 0x75, 0x97, 0xe0,
    0x98, 0x4c, 0x98, 0xb8, 0x99, 0x24, 0x99, 0x90, 0x99, 0xfc, 0x9a, 0x68,
    0x9a, 0xd5, 0x9b, 0x42, 0x9b, 0xaf, 0x9c, 0x1c, 0x9c, 0x89, 0x9c, 0xf7,
    0x9d, 0x64, 0x9d, 0xd2, 0x9e, 0x40, 0x9e, 0xae, 0x9f, 0x1d, 0x9f, 0x8b,
    0x9f, 0xfa, 0xa0, 0x69, 0xa0, 0xd8, 0xa1, 0x47, 0xa1, 0xb6, 0xa2, 0x26,
    0xa2, 0x96, 0xa3, 0x06, 0xa3, 0x76, 0xa3, 0xe6, 0xa4, 0x56, 0xa4, 0xc7,
    0xa5, 0x38, 0xa5, 0xa9, 0xa6, 0x1a, 0xa6, 0x8b, 0xa6, 0xfd, 0xa7, 0x6e,
    0xa7, 0xe0, 0xa8, 0x52, 0xa8, 0xc4, 0xa9, 0x37, 0xa9, 0xa9, 0xaa, 0x1c,
    0xaa, 0x8f, 0xab, 0x02, 0xab, 0x75, 0xab, 0xe9, 0xac, 0x5c, 0xac, 0xd0,
    0xad, 0x44, 0xad, 0xb8, 0xae, 0x2d, 0xae, 0xa1, 0xaf, 0x16, 0xaf, 0x8b,
    0xb0, 0x00, 0xb0, 0x75, 0xb0, 0xea, 0xb1, 0x60, 0xb1, 0xd6, 0xb2, 0x4b,
    0xb2, 0xc2, 0xb3, 0x38, 0xb3, 0xae, 0xb4, 0x25, 0xb4, 0x9c, 0xb5, 0x13,
    0xb5, 0x8a, 0xb6, 0x01, 0xb6, 0x79, 0xb6, 0xf0, 0xb7, 0x68, 0xb7, 0xe0,
    0xb8, 0x59, 0xb8, 0xd1, 0xb9, 0x4a, 0xb9, 0xc2, 0xba, 0x3b, 0xba, 0xb5,
    0xbb, 0x2e, 0xbb, 0xa7, 0xbc, 0x21, 0xbc, 0x9b, 0xbd, 0x15, 0xbd, 0x8f,
    0xbe, 0x0a, 0xbe, 0x84, 0xbe, 0xff, 0xbf, 0x7a, 0xbf, 0xf5, 0xc0, 0x70,
    0xc0, 0xec, 0xc1, 0x67, 0xc1, 0xe3, 0xc2, 0x5f, 0xc2, 0xdb, 0xc3, 0x58,
    0xc3, 0xd4, 0xc4, 0x51, 0xc4, 0xce, 0xc5, 0x4b, 0xc5, 0xc8, 0xc6, 0x46,
    0xc6, 0xc3, 0xc7, 0x41, 0xc7, 0xbf, 0xc8, 0x3d, 0xc8, 0xbc, 0xc9, 0x3a,
    0xc9, 0xb9, 0xca, 0x38, 0xca, 0xb7, 0xcb, 0x36, 0xcb, 0xb6, 0xcc, 0x35,
    0xcc, 0xb5, 0xcd, 0x35, 0xcd, 0xb5, 0xce, 0x36, 0xce, 0xb6, 0xcf, 0x37,
    0xcf, 0xb8, 0xd0, 0x39, 0xd0, 0xba, 0xd1, 0x3c, 0xd1, 0xbe, 0xd2, 0x3f,
    0xd2, 0xc1, 0xd3, 0x44, 0xd3, 0xc6, 0xd4, 0x49, 0xd4, 0xcb, 0xd5, 0x4e,
    0xd5, 0xd1, 0xd6, 0x55, 0xd6, 0xd8, 0xd7, 0x5c, 0xd7, 0xe0, 0xd8, 0x64,
    0xd8, 0xe8, 0xd9, 0x6c, 0xd9, 0xf1, 0xda, 0x76, 0xda, 0xfb, 0xdb, 0x80,
    0xdc, 0x05, 0xdc, 0x8a, 0xdd, 0x10, 0xdd, 0x96, 0xde, 0x1c, 0xde, 0xa2,
    0xdf, 0x29, 0xdf, 0xaf, 0xe0, 0x36, 0xe0, 0xbd, 0xe1, 0x44, 0xe1, 0xcc,
    0xe2, 0x53, 0xe2, 0xdb, 0xe3, 0x63, 0xe3, 0xeb, 0xe4, 0x73, 0xe4, 0xfc,
    0xe5, 0x84, 0xe6, 0x0d, 0xe6, 0x96, 0xe7, 0x1f, 0xe7, 0xa9, 0xe8, 0x32,
    0xe8, 0xbc, 0xe9, 0x46, 0xe9, 0xd0, 0xea, 0x5b, 0xea, 0xe5, 0xeb, 0x70,
    0xeb, 0xfb, 0xec, 0x86, 0xed, 0x11, 0xed, 0x9c, 0xee, 0x28, 0xee, 0xb4,
    0xef, 0x40, 0xef, 0xcc, 0xf0, 0x58, 0xf0, 0xe5, 0xf1, 0x72, 0xf1, 0xff,
    0xf2, 0x8c, 0xf3, 0x19, 0xf3, 0xa7, 0xf4, 0x34, 0xf4, 0xc2, 0xf5, 0x50,
    0xf5, 0xde, 0xf6, 0x6d, 0xf6, 0xfb, 0xf7, 0x8a, 0xf8, 0x19, 0xf8, 0xa8,
    0xf9, 0x38, 0xf9, 0xc7, 0xfa, 0x57, 0xfa, 0xe7, 0xfb, 0x77, 0xfc, 0x07,
    0xfc, 0x98, 0xfd, 0x29, 0xfd, 0xba, 0xfe, 0x4b, 0xfe, 0xdc, 0xff, 0x6d,
    0xff, 0xff, 0xff, 0xdb, 0x00, 0x43, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01,
    0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03,
    0x03, 0x02, 0x02, 0x03, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x02, 0x03, 0x05, 0x05, 0x04, 0x04, 0x05, 0x04, 0x04, 0x04, 0x04, 0xff,
    0xdb, 0x00, 0x43, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01,
    0x01, 0x02, 0x04, 0x03, 0x02, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0xff, 0xc0, 0x00, 0x11,
    0x08, 0x00, 0x2e, 0x00, 0x2e, 0x03, 0x01, 0x11, 0x00, 0x02, 0x11, 0x01,
    0x03, 0x11, 0x01, 0xff, 0xc4, 0x00, 0x1c, 0x00, 0x00, 0x01, 0x04, 0x03,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x09, 0x05, 0x07, 0x08, 0x0a, 0x01, 0x02, 0x06, 0x03, 0xff, 0xc4, 0x00,
    0x31, 0x10, 0x00, 0x00, 0x06, 0x02, 0x01, 0x03, 0x03, 0x03, 0x03, 0x02,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
    0x07, 0x08, 0x11, 0x00, 0x09, 0x12, 0x13, 0x14, 0x21, 0x22, 0x31, 0x41,
    0x15, 0x23, 0x32, 0x16, 0x19, 0x35, 0x42, 0x52, 0x61, 0x74, 0x91, 0xb3,
    0xff, 0xc4, 0x00, 0x1e, 0x01, 0x00, 0x02, 0x01, 0x04, 0x03, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x08, 0x05,
    0x01, 0x04, 0x06, 0x09, 0x02, 0x03, 0x0a, 0x00, 0xff, 0xc4, 0x00, 0x39,
    0x11, 0x00, 0x02, 0x01, 0x03, 0x03, 0x03, 0x02, 0x04, 0x03, 0x05, 0x07,
    0x05, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x11, 0x06,
    0x12, 0x21, 0x00, 0x07, 0x31, 0x08, 0x13, 0x22, 0x32, 0x41, 0x51, 0x14,
    0x23, 0x61, 0x15, 0x42, 0x62, 0x81, 0xb1, 0x09, 0x17, 0x18, 0x24, 0x33,
    0x34, 0x71, 0x52, 0x72, 0x91, 0xa1, 0xd1, 0xff, 0xda, 0x00, 0x0c, 0x03,
    0x01, 0x00, 0x02, 0x11, 0x03, 0x11, 0x00, 0x3f, 0x00, 0x1c, 0x6e, 0xdd,
    0xae, 0x9a, 0xce, 0x4c, 0x77, 0x6b, 0x11, 0x34, 0x94, 0x39, 0x8e, 0xa2,
    0x8e, 0x4c, 0x05, 0x21, 0x4a, 0x22, 0x22, 0x63, 0x18, 0x47, 0xec, 0x00,
    0x1c, 0x88, 0x88, 0xfe, 0x3e, 0x7a, 0xd4, 0xdb, 0x33, 0xef, 0x20, 0x13,
    0xe7, 0xaf, 0x5e, 0x50, 0xc3, 0x1b, 0xa2, 0x05, 0x40, 0x49, 0x03, 0x80,
    0x07, 0x93, 0xf6, 0x03, 0xff, 0x00, 0x40, 0x74, 0xb3, 0x53, 0xae, 0x5e,
    0x6f, 0xd6, 0xa8, 0x5a, 0x1d, 0x0e, 0xb1, 0x71, 0xba, 0xde, 0xec, 0x6e,
    0x45, 0xa4, 0x05, 0x26, 0xb1, 0x0c, 0xee, 0x5e, 0xd7, 0x2c, 0xa1, 0x4b,
    0xe6, 0x72, 0xa4, 0xc4, 0x85, 0xf5, 0x40, 0x0a, 0x41, 0x03, 0x98, 0xe7,
    0x02, 0x90, 0x85, 0x10, 0x31, 0x8c, 0x50, 0x10, 0x11, 0xbd, 0xa0, 0xb6,
    0xdd, 0x2e, 0x95, 0x8b, 0x41, 0x6e, 0x85, 0xe4, 0x99, 0x8e, 0x02, 0xa8,
    0x2c, 0xc7, 0xf9, 0x0c, 0x9f, 0xb9, 0xe3, 0xe8, 0x09, 0xf0, 0x0f, 0x51,
    0xf7, 0x9b, 0xae, 0x9e, 0xd3, 0x76, 0x79, 0xf5, 0x1e, 0xa2, 0xab, 0x82,
    0x96, 0xdd, 0x00, 0xdd, 0x25, 0x44, 0xd2, 0x22, 0x42, 0x80, 0x9c, 0x02,
    0x64, 0x27, 0x6e, 0x49, 0xe0, 0x00, 0x4b, 0x31, 0xc8, 0x00, 0x90, 0x47,
    0x4e, 0x93, 0x0c, 0x13, 0x90, 0x22, 0x32, 0x9d, 0x73, 0x16, 0x67, 0xb7,
    0x32, 0x7a, 0x87, 0xfd, 0x40, 0xba, 0xed, 0x57, 0xc8, 0x3b, 0x23, 0x4e,
    0xb0, 0x54, 0x68, 0xd0, 0x0a, 0x22, 0x82, 0x8a, 0xa6, 0x47, 0x0b, 0x15,
    0xb8, 0x8a, 0x82, 0xb9, 0xc8, 0x54, 0x08, 0x64, 0x44, 0x48, 0x53, 0x28,
    0x06, 0x50, 0xe4, 0x21, 0x4c, 0x60, 0xc8, 0x68, 0xf4, 0x7d, 0xdc, 0x5e,
    0x21, 0xb5, 0x5f, 0xc1, 0xa2, 0x57, 0x24, 0x6f, 0x9d, 0x64, 0x40, 0x30,
    0x09, 0xe7, 0xe0, 0x2d, 0x83, 0x8c, 0x67, 0x6e, 0x39, 0x04, 0x90, 0x32,
    0x46, 0x1d, 0x55, 0xdc, 0x7d, 0x33, 0x59, 0xa3, 0xaa, 0xb5, 0x87, 0x6e,
    0x55, 0x35, 0x27, 0xb2, 0x14, 0x8a, 0x6b, 0x54, 0xf4, 0xd3, 0xd4, 0x48,
    0x19, 0x82, 0x92, 0xa0, 0xc9, 0x85, 0xd8, 0x0e, 0xf6, 0x0c, 0x03, 0x10,
    0x36, 0xa2, 0xb3, 0x90, 0x3a, 0x20, 0x39, 0x0f, 0xb2, 0xae, 0xf0, 0x56,
    0x29, 0x6d, 0x72, 0x36, 0x28, 0x96, 0xc3, 0xbb, 0x51, 0x48, 0x7b, 0x1a,
    0x33, 0x0c, 0xa5, 0x30, 0x3e, 0x41, 0x33, 0x99, 0x49, 0x66, 0xc0, 0x26,
    0x0f, 0x52, 0x39, 0xab, 0xd2, 0x24, 0x83, 0xde, 0x7c, 0x47, 0x80, 0x6a,
    0xe9, 0x43, 0x1b, 0x81, 0x02, 0x94, 0xc3, 0xf1, 0xd1, 0x06, 0xe5, 0xd8,
    0x5d, 0x69, 0x05, 0x17, 0xed, 0x2b, 0x3c, 0xb0, 0xd6, 0x40, 0x40, 0x2a,
    0x61, 0x93, 0x71, 0x23, 0x3c, 0x91, 0xb8, 0x20, 0x60, 0x07, 0x20, 0x26,
    0xe2, 0x7c, 0x01, 0x9e, 0x96, 0xbd, 0x33, 0xeb, 0xe3, 0xd3, 0xed, 0xda,
    0xfc, 0xfa, 0x5b, 0x59, 0x43, 0x5d, 0xa7, 0xee, 0x0a, 0xfb, 0x19, 0x2e,
    0x34, 0xc0, 0x22, 0x3f, 0x1c, 0x4a, 0xf0, 0xb3, 0xbc, 0x3e, 0x79, 0x32,
    0x42, 0xa0, 0x79, 0x24, 0x0e, 0x7a, 0x13, 0x32, 0x4d, 0xe7, 0x61, 0x25,
    0xa5, 0xab, 0xf3, 0xec, 0x67, 0x6b, 0xd6, 0x2a, 0xfc, 0x82, 0x91, 0x36,
    0x0a, 0xe5, 0x81, 0x8b, 0x98, 0x3b, 0x04, 0x03, 0xb4, 0x87, 0x85, 0x1b,
    0x3d, 0x64, 0xb9, 0x48, 0xb2, 0x0a, 0x94, 0x7e, 0xe4, 0x50, 0xa0, 0x3c,
    0x70, 0x21, 0xc8, 0x08, 0x08, 0x85, 0xaa, 0xa9, 0xeb, 0x68, 0x67, 0x6a,
    0x5a, 0xd4, 0x68, 0xe5, 0x5f, 0x2a, 0xc0, 0x86, 0x07, 0xec, 0x41, 0xe4,
    0x11, 0xe0, 0x8f, 0x20, 0xe4, 0x1e, 0x41, 0xe9, 0xd0, 0xa4, 0x96, 0xdd,
    0x71, 0xa2, 0x86, 0xe7, 0x6d, 0x92, 0x39, 0xa9, 0x66, 0x50, 0xf1, 0x4b,
    0x13, 0x24, 0x91, 0x48, 0x87, 0xc3, 0xc7, 0x22, 0x12, 0x8e, 0xa7, 0xee,
    0xa4, 0xfd, 0x8f, 0x3c, 0x74, 0xa3, 0x5e, 0x5d, 0xc2, 0x8f, 0xd4, 0x29,
    0x9c, 0xba, 0x00, 0xf6, 0x67, 0x37, 0xd0, 0xe9, 0x44, 0x87, 0xf9, 0xa5,
    0xf9, 0x01, 0x01, 0xfc, 0xfd, 0xba, 0xa5, 0x33, 0x31, 0x97, 0x19, 0x3e,
    0x0f, 0xd4, 0xfd, 0xc7, 0x56, 0xf7, 0x24, 0x8d, 0x29, 0xc1, 0x08, 0x3e,
    0x61, 0xe4, 0x03, 0xf4, 0x3f, 0x71, 0xd4, 0xaf, 0xd4, 0x1c, 0x73, 0x8e,
    0x9d, 0xcb, 0xe6, 0x7d, 0x9c, 0xcf, 0x30, 0x49, 0xd9, 0xb5, 0xeb, 0x4e,
    0x2a, 0x6d, 0xf2, 0x55, 0xb6, 0x9a, 0xe8, 0xe5, 0x49, 0x86, 0x5c, 0xb7,
    0x49, 0xbe, 0x33, 0x0a, 0x15, 0x29, 0x73, 0x9b, 0x90, 0xf6, 0xef, 0xa4,
    0x13, 0x33, 0x87, 0x60, 0x24, 0x50, 0xbe, 0xdd, 0x88, 0x11, 0x42, 0x0a,
    0x6b, 0x1f, 0xa2, 0x1f, 0x6f, 0x6c, 0xd4, 0x13, 0x4f, 0x5b, 0xaa, 0x6f,
    0x51, 0xfb, 0x94, 0x54, 0x2a, 0x1c, 0xc6, 0x79, 0x12, 0xca, 0xe7, 0x6c,
    0x31, 0x37, 0x04, 0x85, 0x77, 0xe5, 0x8e, 0xd6, 0x1b, 0x12, 0x40, 0x47,
    0x82, 0x02, 0xfd, 0xef, 0xd5, 0x3a, 0xa2, 0x0a, 0x1b, 0x0f, 0x69, 0x7b,
    0x73, 0x52, 0x60, 0xd4, 0xda, 0x9a, 0x67, 0xa4, 0x82, 0x71, 0x92, 0xd4,
    0x54, 0x50, 0xc7, 0xee, 0x5c, 0xab, 0xd4, 0x0c, 0x7e, 0x64, 0x30, 0x10,
    0x90, 0x61, 0x95, 0xbd, 0xd9, 0x37, 0x23, 0x07, 0x41, 0xd1, 0x7a, 0xed,
    0xc9, 0x96, 0xfb, 0x81, 0x63, 0x9b, 0x76, 0xc3, 0x6d, 0xe6, 0x44, 0xed,
    0xf1, 0x98, 0x76, 0x4a, 0xd5, 0xb5, 0x4f, 0x20, 0xe7, 0x8d, 0x93, 0x62,
    0x1c, 0x41, 0xe2, 0xb9, 0x88, 0x78, 0xd6, 0x08, 0x39, 0x21, 0x58, 0x42,
    0x46, 0xc9, 0x01, 0x5f, 0xab, 0x14, 0xa2, 0x4a, 0x47, 0x11, 0xba, 0x64,
    0x2a, 0x65, 0x14, 0xa2, 0x9b, 0x09, 0x85, 0x51, 0x02, 0x9c, 0x0e, 0x3d,
    0xb9, 0xba, 0xeb, 0xfa, 0x3a, 0xeb, 0x8e, 0xae, 0xb9, 0x58, 0xa4, 0xa9,
    0x7a, 0xd2, 0x84, 0x49, 0x91, 0x1b, 0xaa, 0xae, 0xee, 0x15, 0x4a, 0x92,
    0xca, 0xc0, 0xa6, 0x36, 0x9d, 0xb8, 0x45, 0xc1, 0x23, 0x18, 0x48, 0xbd,
    0x52, 0xe8, 0xaf, 0x4d, 0x5a, 0xa2, 0xc9, 0xa6, 0x7b, 0x23, 0xa5, 0xfb,
    0x99, 0x45, 0x63, 0xa3, 0xd3, 0xcb, 0x51, 0x1f, 0xe1, 0x1c, 0x54, 0x56,
    0x24, 0x92, 0xc8, 0xc8, 0x4c, 0x95, 0x13, 0x41, 0x98, 0x16, 0xa5, 0x58,
    0x4a, 0x65, 0x66, 0x2c, 0x77, 0xcd, 0x20, 0x50, 0x83, 0x2a, 0x4a, 0xdd,
    0x7f, 0xb9, 0xe6, 0xa0, 0x66, 0x09, 0x84, 0xb5, 0xef, 0x6d, 0xb1, 0x8d,
    0xe7, 0x59, 0x6e, 0x96, 0xd1, 0xfd, 0x38, 0x31, 0x5e, 0xe9, 0xe2, 0xe4,
    0xa0, 0x29, 0x76, 0xd5, 0x04, 0xe0, 0x90, 0x24, 0xd2, 0x59, 0x70, 0x5a,
    0x25, 0xc1, 0x4d, 0xea, 0x90, 0x08, 0x2b, 0x28, 0x97, 0x98, 0xa8, 0x00,
    0x50, 0x11, 0xf8, 0xe8, 0xb1, 0x07, 0x71, 0x74, 0x9d, 0xe6, 0x4f, 0xd8,
    0x3a, 0xa6, 0x99, 0xe9, 0x64, 0x7e, 0x3d, 0xaa, 0xc8, 0xb6, 0xa3, 0xfd,
    0x0e, 0x0b, 0x65, 0x4a, 0xf3, 0x80, 0x5c, 0x28, 0x39, 0xe3, 0x39, 0x19,
    0x4d, 0x2e, 0x5e, 0x92, 0x3b, 0xdf, 0xa1, 0xe8, 0x4f, 0x73, 0x3b, 0x2b,
    0x77, 0xa7, 0xbe, 0xd0, 0x53, 0x7c, 0x5f, 0x8c, 0xb0, 0xd6, 0x19, 0x67,
    0x84, 0x60, 0xb6, 0x5e, 0x14, 0xf6, 0xea, 0x50, 0x8d, 0xa7, 0x70, 0x45,
    0x7d, 0xa0, 0x65, 0x88, 0x1c, 0xf4, 0xdd, 0x64, 0x1d, 0x15, 0xcc, 0x3a,
    0x43, 0x2d, 0x35, 0xb0, 0xbd, 0xad, 0x64, 0x9c, 0x23, 0x09, 0xe6, 0x13,
    0xd9, 0x4b, 0x42, 0x6d, 0x13, 0x2b, 0xc9, 0x61, 0x9c, 0xb4, 0xd0, 0x82,
    0x2a, 0xbc, 0x5a, 0x9e, 0xa2, 0xa7, 0x39, 0xe1, 0x66, 0x4c, 0x4e, 0x45,
    0x1f, 0x44, 0x45, 0x25, 0x4d, 0xe0, 0x42, 0xf0, 0x42, 0xfb, 0x65, 0xec,
    0x6b, 0xf4, 0x6d, 0xd7, 0x48, 0x4a, 0xd7, 0xee, 0xdc, 0xb9, 0xf6, 0xf3,
    0xba, 0x5a, 0x36, 0x25, 0xa3, 0x94, 0x7d, 0x4c, 0x79, 0x24, 0xab, 0xe3,
    0xc0, 0x07, 0xec, 0x14, 0x80, 0x3d, 0xb7, 0xc9, 0xb4, 0xc7, 0xa8, 0x6d,
    0x0f, 0xea, 0x02, 0x8a, 0x9f, 0xb6, 0x1e, 0xaf, 0x61, 0x06, 0x7e, 0x63,
    0xa4, 0xd4, 0x70, 0xa2, 0xa5, 0x75, 0x13, 0x9c, 0x04, 0x5a, 0xd0, 0xa1,
    0x56, 0xae, 0x94, 0x1f, 0x9f, 0x70, 0xdc, 0xa3, 0x2c, 0x72, 0xe7, 0xde,
    0x8a, 0x3c, 0x6e, 0x06, 0x0a, 0xc0, 0xfd, 0xdf, 0xb5, 0x11, 0xde, 0xe4,
    0x6b, 0x14, 0x1a, 0x90, 0x7b, 0x49, 0x8a, 0xa2, 0x5d, 0xb1, 0x98, 0xac,
    0x3f, 0x62, 0x10, 0xf7, 0xf7, 0xcf, 0x21, 0x12, 0xf5, 0x26, 0xb1, 0xb5,
    0xc1, 0xa8, 0x07, 0x91, 0x9f, 0x22, 0x5f, 0x21, 0x8e, 0x5d, 0x42, 0x89,
    0x88, 0xa9, 0x9b, 0x89, 0x0e, 0x0d, 0xdc, 0x28, 0x06, 0xc5, 0x75, 0xc6,
    0x9c, 0xb0, 0xf7, 0x73, 0x48, 0x3e, 0xa8, 0xb1, 0x47, 0xb6, 0xe5, 0x00,
    0x39, 0x5c, 0x7e, 0x66, 0x54, 0x65, 0xa1, 0x70, 0x3e, 0x66, 0xc7, 0x31,
    0x93, 0xe7, 0x81, 0x95, 0x0d, 0x95, 0x28, 0x76, 0x3b, 0xb8, 0xbd, 0xc6,
    0xf4, 0x45, 0xde, 0xc4, 0xec, 0x5f, 0x76, 0xaa, 0x44, 0xda, 0x3e, 0xe2,
    0xe8, 0xd1, 0xcc, 0xad, 0xee, 0x53, 0x2a, 0x4e, 0x71, 0x05, 0xd6, 0x89,
    0xc9, 0xc0, 0x85, 0x8f, 0x15, 0x48, 0xa4, 0x06, 0x41, 0x20, 0x65, 0x33,
    0x44, 0x98, 0xa9, 0xed, 0x49, 0xc2, 0x4e, 0xdc, 0x91, 0xca, 0x22, 0x61,
    0x49, 0xc4, 0x68, 0xac, 0x9f, 0x99, 0x05, 0x33, 0xf0, 0x63, 0x22, 0x20,
    0x06, 0x28, 0xfc, 0x80, 0xfc, 0xfc, 0x80, 0xfc, 0x80, 0xf2, 0x1d, 0x25,
    0x74, 0xc0, 0xac, 0xe5, 0x4f, 0x90, 0x0f, 0xeb, 0xf5, 0x1d, 0x6e, 0x82,
    0xf3, 0x1b, 0xc3, 0x11, 0x89, 0xfe, 0x65, 0x7c, 0x1f, 0xe4, 0x1b, 0xff,
    0x00, 0x23, 0xf5, 0xe8, 0xe4, 0x76, 0xe3, 0xa4, 0xd1, 0x6d, 0x38, 0xb7,
    0x4d, 0xe8, 0x77, 0x68, 0xa8, 0x97, 0x95, 0x8c, 0xe3, 0xdd, 0x46, 0xcb,
    0x66, 0xbe, 0x92, 0x58, 0xa0, 0x78, 0xeb, 0x31, 0xb1, 0xbe, 0x33, 0x5d,
    0xdd, 0x52, 0x11, 0xf2, 0x46, 0xfd, 0xb5, 0xd0, 0x3c, 0x92, 0x89, 0xac,
    0x0d, 0x95, 0x03, 0x11, 0x55, 0x38, 0x28, 0x94, 0xc0, 0x3c, 0x0b, 0x27,
    0xda, 0xda, 0x0a, 0x2a, 0x9b, 0x1d, 0xa2, 0xdf, 0x70, 0x50, 0x62, 0x9e,
    0xe5, 0x23, 0xb1, 0x3e, 0x0f, 0xb1, 0x4e, 0x1a, 0x28, 0xdb, 0xe8, 0xca,
    0xcf, 0x23, 0x7c, 0x24, 0x1c, 0x96, 0xc1, 0xeb, 0x5e, 0x7e, 0xa9, 0xef,
    0xda, 0x86, 0xcf, 0xac, 0x75, 0xd6, 0xa2, 0xb0, 0x4c, 0xe9, 0x57, 0x6a,
    0xd1, 0xf4, 0x90, 0xd3, 0x6c, 0xf9, 0xa2, 0xfd, 0xa9, 0x76, 0x54, 0xad,
    0xa8, 0x8c, 0x8f, 0x89, 0x24, 0x14, 0xe0, 0xa9, 0x91, 0x08, 0x64, 0x5c,
    0x90, 0x41, 0x19, 0x16, 0x66, 0xda, 0xcc, 0xeb, 0xb4, 0x98, 0x59, 0xf5,
    0x2d, 0xe6, 0x05, 0xd3, 0x59, 0x5d, 0xab, 0xaa, 0x48, 0x36, 0x7a, 0xe3,
    0x21, 0x3d, 0xae, 0xe6, 0x18, 0x6c, 0x7d, 0x67, 0xa7, 0x9d, 0x13, 0x20,
    0x0c, 0xd1, 0x67, 0x16, 0xf5, 0x33, 0x1d, 0xf0, 0xae, 0x53, 0xb8, 0x38,
    0x99, 0x23, 0x00, 0x17, 0xdb, 0x81, 0x04, 0x39, 0x39, 0x47, 0xa6, 0x73,
    0x54, 0x5f, 0x35, 0x35, 0x9a, 0x48, 0x5a, 0xc5, 0x68, 0x35, 0xb1, 0x1c,
    0xfb, 0x84, 0x4c, 0xb1, 0x94, 0xc7, 0x8c, 0x29, 0x56, 0x67, 0xcf, 0xf0,
    0x83, 0xf6, 0xe3, 0xcf, 0x5a, 0x97, 0xec, 0xd7, 0x6e, 0xbb, 0x3f, 0xaf,
    0xa9, 0xae, 0x10, 0xf7, 0x1f, 0x5d, 0xa6, 0x9f, 0xad, 0x43, 0x18, 0xa6,
    0x59, 0x68, 0x67, 0xaa, 0x8a, 0x70, 0xc1, 0xb7, 0xb3, 0xcd, 0x0b, 0x05,
    0x87, 0x61, 0x0a, 0x30, 0xe3, 0x9d, 0xdb, 0x81, 0xc2, 0x9e, 0x98, 0x0c,
    0x73, 0xb4, 0x5a, 0x6d, 0xdc, 0x99, 0x9d, 0xbf, 0x55, 0xb3, 0x9e, 0x22,
    0x95, 0xab, 0xe5, 0x88, 0xa6, 0x2a, 0x39, 0xbb, 0xea, 0x9e, 0xcf, 0x52,
    0xbf, 0xa6, 0x72, 0x2c, 0x72, 0x69, 0x7d, 0x2a, 0x49, 0x42, 0x98, 0xc3,
    0xfb, 0xe5, 0x4c, 0x40, 0x4e, 0x47, 0xb1, 0x8b, 0x15, 0x74, 0x8a, 0x05,
    0x50, 0x41, 0x20, 0x12, 0x98, 0x61, 0x2d, 0xfa, 0x97, 0x49, 0xf7, 0x05,
    0x24, 0xd3, 0x97, 0x9a, 0x53, 0x1d, 0x48, 0xf9, 0xa9, 0xea, 0x13, 0x6c,
    0x83, 0xf8, 0x90, 0xf9, 0xc8, 0x1c, 0x82, 0xa5, 0x64, 0x51, 0x86, 0x21,
    0x7a, 0x25, 0x6a, 0x9e, 0xd0, 0xf7, 0xd3, 0xd2, 0xac, 0xf4, 0x5d, 0xe0,
    0xed, 0xed, 0xed, 0x2a, 0x2c, 0xb2, 0x30, 0x10, 0x5e, 0x2d, 0x33, 0xfb,
    0xb4, 0xac, 0x5b, 0x91, 0x14, 0xe0, 0x7c, 0x85, 0xbc, 0x34, 0x33, 0xa1,
    0x89, 0xce, 0x53, 0x2e, 0x43, 0x00, 0xc5, 0x61, 0xe9, 0x9c, 0x8b, 0xda,
    0xe7, 0x61, 0xb1, 0xce, 0xa7, 0xe5, 0x0b, 0xb4, 0xfe, 0x47, 0xd1, 0x6d,
    0x89, 0x9f, 0x3d, 0x53, 0x53, 0x32, 0xad, 0xd6, 0x40, 0xd2, 0x76, 0xcc,
    0x03, 0x6a, 0x30, 0x7a, 0x8d, 0xb1, 0xcc, 0xeb, 0xf3, 0x7c, 0xac, 0xc1,
    0xe1, 0x79, 0x2c, 0x62, 0xe7, 0xe0, 0x4a, 0x62, 0x81, 0x0a, 0x50, 0x21,
    0x17, 0x14, 0x61, 0x2d, 0x73, 0xd7, 0x76, 0xda, 0xfd, 0x4f, 0xa6, 0x2e,
    0x12, 0x34, 0xb6, 0x6a, 0xa3, 0xb2, 0x9a, 0x46, 0xe4, 0xc3, 0x27, 0xd2,
    0x17, 0x3f, 0xf4, 0x9e, 0x02, 0xf1, 0x8e, 0x41, 0x50, 0x14, 0x49, 0xb4,
    0x87, 0xae, 0x28, 0x34, 0xbf, 0xab, 0xee, 0xd8, 0xdd, 0x3b, 0xcb, 0xa4,
    0x68, 0x23, 0xa1, 0xee, 0x1d, 0x96, 0x31, 0x35, 0xe6, 0x8e, 0x9d, 0x76,
    0xc3, 0x72, 0xa3, 0x1c, 0x3d, 0xd2, 0x9e, 0x31, 0xf2, 0xcd, 0x11, 0xe6,
    0xad, 0x06, 0x72, 0x32, 0xcc, 0x77, 0xb4, 0x42, 0x45, 0x8d, 0x8b, 0x88,
    0x0e, 0xdf, 0xfb, 0xd3, 0x8b, 0xf7, 0x22, 0x98, 0x51, 0x86, 0xd7, 0xcd,
    0xc5, 0xb8, 0xc7, 0x6b, 0xde, 0xe4, 0xd5, 0x99, 0x94, 0x1b, 0x57, 0xa1,
    0xed, 0x0f, 0x45, 0x42, 0x53, 0x32, 0x08, 0xa2, 0x50, 0xf1, 0x4d, 0x61,
    0x5c, 0x55, 0x68, 0xf9, 0x7e, 0x00, 0xa2, 0x45, 0x14, 0x31, 0xbc, 0xd6,
    0x74, 0x63, 0xf5, 0xcb, 0x50, 0x42, 0x34, 0x26, 0xb5, 0xa6, 0xd5, 0x94,
    0x63, 0x6d, 0x05, 0x7b, 0x88, 0x2a, 0xd4, 0x70, 0xa2, 0x43, 0x93, 0x1c,
    0xde, 0x70, 0x3f, 0x79, 0x9d, 0x88, 0xe3, 0x0f, 0xe5, 0xe6, 0xcf, 0x56,
    0x3d, 0xae, 0xae, 0xff, 0x00, 0x12, 0x9e, 0x9e, 0x6e, 0xfd, 0x8d, 0xbf,
    0x7e, 0x6e, 0xa6, 0xd3, 0x30, 0x4b, 0x73, 0xb1, 0xcc, 0xdc, 0xca, 0xf4,
    0x91, 0xe0, 0xd7, 0x5b, 0x72, 0x79, 0x65, 0xd9, 0xb6, 0x4a, 0x74, 0xc9,
    0x3b, 0x82, 0xa8, 0xdb, 0x14, 0x01, 0x7a, 0xa9, 0xa6, 0xca, 0x53, 0x61,
    0x31, 0xd6, 0xe4, 0x6d, 0x65, 0x06, 0xb2, 0x44, 0x93, 0xad, 0xd4, 0xb3,
    0xcd, 0xbe, 0x32, 0x05, 0x24, 0x04, 0xa6, 0x41, 0x06, 0xa7, 0x9a, 0x3b,
    0xb4, 0x91, 0x20, 0x97, 0xe9, 0xf1, 0x48, 0x1c, 0xfa, 0x40, 0x01, 0xf6,
    0xf4, 0xf8, 0xf8, 0xe3, 0x8e, 0x93, 0x0d, 0x65, 0x43, 0x15, 0xbb, 0x5b,
    0xdc, 0xe8, 0xe9, 0xc8, 0xf6, 0xd2, 0x69, 0x42, 0x81, 0x8c, 0x05, 0x12,
    0x10, 0xa3, 0x8f, 0xb0, 0x00, 0x75, 0xba, 0x6e, 0xd4, 0x5f, 0x6e, 0x1a,
    0x9f, 0xb1, 0x9a, 0x37, 0x51, 0xdd, 0x89, 0x35, 0x55, 0x36, 0xda, 0x17,
    0x90, 0x9c, 0xe4, 0xb8, 0xa7, 0x08, 0xcc, 0x73, 0xce, 0x5b, 0x6e, 0xee,
    0x7c, 0xe7, 0x3f, 0x5e, 0x9f, 0x5c, 0x41, 0x2b, 0x3b, 0x7e, 0xd0, 0x5d,
    0x88, 0xa2, 0x52, 0x25, 0x5f, 0x43, 0x65, 0xcd, 0x33, 0xd8, 0xea, 0xfe,
    0xfa, 0x63, 0xf7, 0xd5, 0xb7, 0x0e, 0x1a, 0x5d, 0x9a, 0x57, 0x9d, 0x34,
    0x2d, 0x5e, 0xd9, 0x25, 0x16, 0xaa, 0x40, 0x22, 0x51, 0x85, 0x70, 0x84,
    0x64, 0xaa, 0xa7, 0x1f, 0xe0, 0x51, 0x20, 0x8f, 0x20, 0x22, 0x03, 0x97,
    0x69, 0x9a, 0x9a, 0xaa, 0xfe, 0xde, 0xd7, 0xdb, 0xed, 0x4e, 0x56, 0xb6,
    0x82, 0xa1, 0x2b, 0x53, 0x1f, 0x3b, 0x21, 0x1e, 0xd4, 0x9b, 0x79, 0xca,
    0xac, 0x67, 0xd9, 0x76, 0x6e, 0x36, 0xf2, 0xc0, 0xf1, 0xd0, 0xe7, 0x5c,
    0xd1, 0x5b, 0xb4, 0xdf, 0xa9, 0x2d, 0x31, 0xa8, 0xf5, 0x04, 0x2b, 0x2d,
    0x97, 0x53, 0xda, 0xaa, 0x74, 0xe5, 0x4a, 0xca, 0x15, 0xa9, 0xcd, 0x52,
    0x39, 0xac, 0xa3, 0x8a, 0x60, 0xde, 0x7f, 0x16, 0x8d, 0x2d, 0x32, 0x0f,
    0xde, 0x3b, 0x87, 0x07, 0x07, 0xa2, 0xbb, 0x82, 0x7b, 0xd2, 0xef, 0xfc,
    0x26, 0x15, 0x8c, 0xcd, 0x79, 0xa7, 0x48, 0x24, 0x33, 0x66, 0xbf, 0x56,
    0xcc, 0x2c, 0x6e, 0x1b, 0x29, 0x8e, 0x90, 0x75, 0x8f, 0x82, 0x4d, 0x04,
    0x16, 0x16, 0xae, 0x64, 0xc1, 0x8a, 0x89, 0x2c, 0xc5, 0x4f, 0x49, 0x5e,
    0x48, 0xab, 0x86, 0xfe, 0x83, 0x11, 0x51, 0x33, 0x97, 0xd4, 0x6f, 0xf3,
    0xe0, 0x63, 0xd3, 0x7d, 0xe6, 0xd7, 0x22, 0xc0, 0x97, 0xcb, 0xe5, 0x99,
    0xa6, 0xa3, 0x53, 0x86, 0x9d, 0x15, 0x93, 0x20, 0x70, 0x5f, 0xe5, 0x64,
    0x38, 0x3c, 0x36, 0xd0, 0xab, 0xbb, 0x2b, 0xf0, 0x9e, 0x93, 0x3e, 0xe3,
    0x7a, 0x09, 0xf4, 0xd5, 0x70, 0xd7, 0xd3, 0x68, 0x2d, 0x05, 0xdc, 0x05,
    0xb5, 0x6a, 0x59, 0xfe, 0x28, 0x2d, 0x55, 0x45, 0x2a, 0x76, 0x33, 0x2e,
    0xf4, 0x8b, 0xdc, 0x0d, 0x1c, 0xcb, 0xb9, 0x79, 0x44, 0x7f, 0x72, 0xa3,
    0x69, 0x0d, 0xb6, 0x4e, 0x37, 0x12, 0x8d, 0xbb, 0xc5, 0xf8, 0xdf, 0xb8,
    0x56, 0xa0, 0x52, 0xb7, 0x27, 0x58, 0xa6, 0xd4, 0x89, 0xce, 0xd8, 0xd2,
    0xa0, 0x7c, 0xf3, 0xa9, 0xb9, 0xa6, 0x29, 0xb7, 0xe9, 0x17, 0x58, 0x77,
    0xf1, 0x40, 0xab, 0xc7, 0x35, 0x99, 0x01, 0x00, 0x13, 0x19, 0x07, 0x4a,
    0x36, 0x77, 0x1c, 0xe9, 0x82, 0xc2, 0x74, 0x93, 0x73, 0xc9, 0x84, 0xa6,
    0x02, 0x18, 0xa7, 0x25, 0x6a, 0xba, 0x0b, 0x7e, 0xbb, 0xd2, 0x31, 0xea,
    0xed, 0x38, 0xe5, 0x6b, 0x21, 0x43, 0x35, 0x3c, 0xab, 0x8d, 0xe0, 0xa6,
    0x4b, 0x44, 0x7c, 0x8c, 0xe5, 0x59, 0x70, 0x49, 0x55, 0x90, 0x67, 0x90,
    0x18, 0x32, 0xa1, 0xd9, 0x4d, 0x5b, 0xaa, 0xbd, 0x33, 0x77, 0xba, 0xbf,
    0xb1, 0x3d, 0xdb, 0x80, 0x49, 0xa7, 0x6b, 0xa7, 0x16, 0xeb, 0xcd, 0x03,
    0x9d, 0xf4, 0xef, 0x1c, 0xd8, 0x44, 0xab, 0x8f, 0xc0, 0x0f, 0x1a, 0xba,
    0x4f, 0x14, 0xc9, 0xb5, 0xda, 0x1e, 0x01, 0x52, 0xca, 0x57, 0x39, 0x89,
    0xc4, 0x3f, 0x73, 0x5e, 0xd0, 0x72, 0x19, 0x19, 0x28, 0xf4, 0x62, 0x2d,
    0x19, 0x03, 0x01, 0x06, 0x65, 0xa9, 0x99, 0x98, 0x98, 0x8b, 0x53, 0x2f,
    0x15, 0x74, 0x95, 0x7e, 0x5f, 0xd3, 0xd7, 0x01, 0xf5, 0x13, 0xf4, 0xa5,
    0x22, 0xdd, 0x34, 0x05, 0x4a, 0x20, 0x71, 0x41, 0x63, 0x80, 0xff, 0x00,
    0x23, 0x07, 0x5c, 0x6f, 0x2d, 0x17, 0x70, 0xfb, 0x4e, 0xf7, 0x17, 0x41,
    0xef, 0x34, 0x26, 0x50, 0x17, 0xf7, 0x67, 0x87, 0x3b, 0x82, 0x13, 0xc8,
    0x05, 0xd1, 0xa3, 0xcf, 0x9d, 0x8c, 0x73, 0xe4, 0xf5, 0xf6, 0x87, 0x8a,
    0xb7, 0xd2, 0x77, 0xad, 0xc8, 0xf4, 0xb3, 0x4a, 0x64, 0xa3, 0xa4, 0xb9,
    0x7e, 0x06, 0x6d, 0xc0, 0x11, 0x3d, 0xbe, 0xb0, 0x88, 0xff, 0x00, 0x35,
    0x48, 0xda, 0xc5, 0xa9, 0xa6, 0x49, 0x4a, 0x91, 0xb4, 0x48, 0xaa, 0x47,
    0x80, 0x7a, 0x48, 0xcc, 0x76, 0x98, 0x8d, 0xdc, 0xec, 0x8f, 0x64, 0xc9,
    0x37, 0x99, 0x18, 0xa8, 0x87, 0xb7, 0xcd, 0x42, 0x4b, 0x26, 0x4a, 0x4e,
    0x4c, 0xb9, 0x49, 0xab, 0x18, 0xbb, 0x3d, 0x79, 0x92, 0x72, 0x62, 0xe0,
    0xab, 0x08, 0x00, 0x26, 0x3f, 0xab, 0x44, 0x89, 0x48, 0x21, 0xc0, 0xfe,
    0xe0, 0x14, 0x3e, 0xfc, 0x75, 0xd1, 0x7c, 0x9e, 0x3d, 0x5d, 0xd9, 0x89,
    0xab, 0x6e, 0x25, 0x4b, 0xb5, 0x2f, 0xb8, 0xc4, 0xf0, 0x0c, 0xb0, 0x8d,
    0xc7, 0xfe, 0x03, 0x4a, 0x98, 0x03, 0xec, 0x71, 0xce, 0x71, 0xd5, 0xf6,
    0x84, 0xb4, 0xd6, 0xf6, 0x07, 0xfb, 0x40, 0x29, 0x34, 0xb6, 0x9d, 0x89,
    0xe4, 0x8e, 0x92, 0xf6, 0x69, 0x12, 0x34, 0x04, 0xb3, 0xd1, 0xd5, 0x48,
    0x61, 0x0a, 0x54, 0x64, 0xb7, 0xf9, 0x59, 0xb2, 0xd9, 0xc8, 0xe0, 0x9e,
    0xa9, 0x27, 0x51, 0x50, 0x55, 0x70, 0x9a, 0xa2, 0x45, 0x13, 0x15, 0x63,
    0x05, 0x53, 0x26, 0xb0, 0x88, 0xac, 0x41, 0x39, 0x91, 0x30, 0x81, 0xc4,
    0x7e, 0x7c, 0xb9, 0x11, 0xe4, 0x47, 0xe7, 0x9e, 0x79, 0xe9, 0x00, 0xa6,
    0x18, 0x98, 0xe7, 0xec, 0x7c, 0x7f, 0xc8, 0xeb, 0xd0, 0x15, 0xe9, 0x76,
    0x46, 0x53, 0x20, 0xe1, 0xf1, 0x91, 0xe3, 0x80, 0xc3, 0x8f, 0xd3, 0xed,
    0xfa, 0x74, 0xe7, 0x60, 0xcc, 0xe3, 0x75, 0xd6, 0xec, 0xcf, 0x59, 0xcc,
    0xd4, 0x14, 0x22, 0xe4, 0xe6, 0x2b, 0x0e, 0x9d, 0xb0, 0x99, 0xa9, 0xd8,
    0x52, 0x2b, 0xaa, 0x9e, 0x45, 0x82, 0x91, 0x48, 0xed, 0x26, 0xeb, 0x53,
    0x28, 0x18, 0xa6, 0x2a, 0x8c, 0xa4, 0x5b, 0x1c, 0xe9, 0x1b, 0xc8, 0xa6,
    0xf4, 0xd4, 0x2a, 0x0b, 0x14, 0x3c, 0x92, 0x2f, 0x53, 0xba, 0x63, 0x52,
    0x55, 0xe9, 0x5b, 0xe4, 0x77, 0x6a, 0x50, 0x18, 0x02, 0x43, 0xa3, 0x72,
    0xb2, 0x23, 0x02, 0xae, 0x8e, 0xa7, 0x86, 0x56, 0x52, 0x41, 0x07, 0xef,
    0x91, 0x86, 0xc3, 0x0c, 0x43, 0xb8, 0x7d, 0xbd, 0xb0, 0x77, 0x57, 0x42,
    0x55, 0xe8, 0x4d, 0x48, 0xcf, 0x1c, 0x13, 0x84, 0x68, 0xe6, 0x88, 0xe2,
    0x6a, 0x5a, 0x88, 0x88, 0x7a, 0x7a, 0xb8, 0x18, 0x10, 0x56, 0x58, 0x24,
    0x01, 0x86, 0x08, 0xde, 0xa5, 0xe3, 0x3f, 0x0b, 0x9e, 0xac, 0xbf, 0x6b,
    0xdf, 0xf8, 0x6f, 0xed, 0x9f, 0x31, 0x5a, 0xd1, 0x3d, 0x76, 0xb2, 0x66,
    0x2c, 0x73, 0x1d, 0x87, 0x9e, 0xe1, 0xdb, 0x04, 0x3a, 0x73, 0x68, 0x4f,
    0xdc, 0xb5, 0x45, 0x07, 0xec, 0x97, 0x66, 0x76, 0x37, 0x4a, 0x92, 0x65,
    0x3c, 0xa3, 0xb6, 0xcd, 0x1a, 0x2a, 0xeb, 0xda, 0xca, 0xb4, 0x2a, 0xec,
    0x9d, 0xa6, 0xd0, 0x86, 0x5d, 0xc2, 0x7f, 0x59, 0xce, 0xda, 0x56, 0x6b,
    0xa8, 0xa5, 0xed, 0xac, 0x94, 0xba, 0x1e, 0x81, 0xaa, 0xa9, 0x8c, 0x2d,
    0x11, 0xf8, 0xc3, 0x3d, 0x38, 0x70, 0x54, 0x89, 0x63, 0x20, 0xbb, 0x05,
    0x05, 0xb6, 0xc9, 0x82, 0x8c, 0x14, 0xfb, 0x8c, 0x08, 0x20, 0xea, 0x76,
    0xcd, 0xe9, 0xaa, 0xb8, 0x7a, 0xb0, 0x82, 0xef, 0xea, 0x23, 0x53, 0xc5,
    0x6c, 0xba, 0x3d, 0x74, 0x75, 0xd1, 0x3f, 0xb6, 0xd1, 0x53, 0xde, 0x5a,
    0x39, 0x16, 0x41, 0x25, 0x05, 0x69, 0x2b, 0x4d, 0x14, 0x92, 0xca, 0xa8,
    0x26, 0xa6, 0x94, 0xc7, 0x3c, 0x2d, 0x21, 0x58, 0xa2, 0x6f, 0x84, 0x2b,
    0xd3, 0xdb, 0x5f, 0x35, 0xeb, 0x7e, 0xb5, 0xf6, 0x87, 0x88, 0x97, 0x6d,
    0x9e, 0xf1, 0xed, 0xf1, 0x7c, 0x61, 0x8a, 0x6c, 0xd9, 0x13, 0x22, 0xc4,
    0x30, 0xb2, 0x24, 0x69, 0xda, 0xcc, 0xc4, 0x8a, 0xaf, 0xe5, 0x14, 0xad,
    0x2d, 0x14, 0xb0, 0x95, 0xe2, 0x4e, 0x51, 0x59, 0xd2, 0x2c, 0x0a, 0x45,
    0x12, 0x0f, 0x70, 0xb7, 0xd6, 0x97, 0x9a, 0x6b, 0x26, 0x63, 0x4d, 0x76,
    0xf6, 0xf7, 0xa7, 0xf4, 0xf7, 0x6a, 0x04, 0xc2, 0xba, 0x39, 0x5e, 0x38,
    0xa4, 0x95, 0xd4, 0x30, 0x0c, 0xae, 0xe5, 0x9c, 0x47, 0xb0, 0x90, 0x43,
    0x65, 0x95, 0x06, 0x46, 0x1d, 0x8e, 0xe5, 0xca, 0xb0, 0x3d, 0x60, 0x3e,
    0xaa, 0xf4, 0x0f, 0x74, 0xfb, 0xaf, 0xeb, 0x6e, 0x6a, 0x29, 0x34, 0xdd,
    0x4d, 0x22, 0x57, 0xd6, 0x52, 0x52, 0xd2, 0xc8, 0xd1, 0x37, 0xb7, 0x34,
    0x11, 0x2c, 0x70, 0x8a, 0xa5, 0x99, 0x73, 0x13, 0x46, 0xc8, 0x8d, 0x39,
    0x2a, 0xe7, 0xda, 0x4f, 0x82, 0x4d, 0xaf, 0x1b, 0x01, 0xc5, 0xe8, 0xd6,
    0xd4, 0x6a, 0xfe, 0xb7, 0x76, 0x79, 0xc7, 0x70, 0x37, 0x5d, 0x84, 0xc4,
    0xc7, 0xbc, 0xa3, 0x8a, 0x6d, 0x48, 0x2b, 0x8f, 0x98, 0xdc, 0xda, 0x49,
    0x5e, 0x97, 0xb1, 0xce, 0x38, 0x9a, 0x94, 0x46, 0xb0, 0xda, 0x05, 0x33,
    0x19, 0xf9, 0xde, 0x90, 0xf2, 0x2d, 0xdb, 0x19, 0xba, 0x68, 0x9b, 0xc4,
    0xe2, 0x3f, 0x22, 0x4e, 0x0e, 0x36, 0x3a, 0x1b, 0x52, 0x69, 0x7d, 0x3d,
    0xda, 0x48, 0xe8, 0x9a, 0xe3, 0x13, 0xcc, 0x23, 0x9c, 0x84, 0x12, 0x06,
    0x90, 0xb4, 0x8d, 0x23, 0xaa, 0x6c, 0xce, 0xfd, 0xd8, 0x75, 0x07, 0x8c,
    0x0c, 0xe7, 0x38, 0xe7, 0xa9, 0xef, 0x50, 0xbd, 0x9f, 0xee, 0xf7, 0x75,
    0x3d, 0x71, 0x5c, 0xee, 0x76, 0x2d, 0x33, 0x5a, 0x2d, 0xe6, 0xb2, 0x8c,
    0x8a, 0x96, 0x81, 0xd6, 0x9c, 0x52, 0xd3, 0xa4, 0x10, 0xb5, 0x5b, 0x54,
    0xb0, 0x10, 0x88, 0x48, 0x89, 0xa4, 0x12, 0x19, 0x06, 0x57, 0xf8, 0xb2,
    0x3a, 0x05, 0x77, 0x94, 0x77, 0x2b, 0x1f, 0xf6, 0xf5, 0xa9, 0x62, 0x3d,
    0xa6, 0xce, 0x6a, 0x60, 0xfc, 0x5a, 0xa3, 0x38, 0x77, 0x5a, 0xe9, 0xa5,
    0x93, 0xf5, 0x16, 0xa8, 0xe5, 0xfc, 0xd8, 0x8b, 0x79, 0x5f, 0x74, 0xf5,
    0xfc, 0xca, 0x2d, 0x48, 0x49, 0x18, 0x98, 0x36, 0x2b, 0x19, 0xc3, 0xd4,
    0x55, 0x9d, 0x30, 0x91, 0xcb, 0x86, 0x88, 0x90, 0x5b, 0x97, 0x86, 0xe2,
    0x60, 0x65, 0xf2, 0x3d, 0x67, 0x6c, 0xd0, 0x0d, 0x6e, 0xd4, 0xd7, 0x3f,
    0xc3, 0x52, 0x96, 0x06, 0x9e, 0x91, 0x91, 0x7d, 0xc9, 0x94, 0xb9, 0x62,
    0x5b, 0x68, 0x12, 0x22, 0x29, 0x2c, 0xca, 0x65, 0xc8, 0x2c, 0xa3, 0x6a,
    0xe4, 0x23, 0x8d, 0x88, 0xe9, 0xd7, 0xec, 0x56, 0xa5, 0xf5, 0x33, 0x59,
    0xad, 0x3b, 0x3f, 0xa7, 0x45, 0xd6, 0xee, 0x1a, 0x75, 0xba, 0x5f, 0xa2,
    0x9d, 0xcd, 0x0d, 0xbd, 0x9a, 0x1d, 0x91, 0xc7, 0x03, 0x48, 0x5a, 0x0a,
    0xaa, 0xc9, 0x94, 0x24, 0x2e, 0xb4, 0x60, 0x34, 0x51, 0x3b, 0x37, 0xb8,
    0x7f, 0x34, 0x01, 0xf1, 0x5b, 0xff, 0x00, 0x11, 0x53, 0xfe, 0x11, 0xff,
    0x00, 0xf4, 0x4b, 0xa0, 0xad, 0x2f, 0xfa, 0xbf, 0xc8, 0xff, 0x00, 0x51,
    0xd3, 0x39, 0x74, 0xff, 0x00, 0x6c, 0x3f, 0xee, 0x1f, 0xd0, 0xf5, 0x87,
    0x30, 0x8f, 0x3d, 0xc2, 0xfe, 0x47, 0x6c, 0x06, 0x15, 0x8c, 0x26, 0x02,
    0xa8, 0x73, 0x14, 0x07, 0x91, 0xf8, 0x01, 0xf1, 0x0e, 0x7f, 0xeb, 0xaa,
    0xb4, 0x0d, 0xb8, 0xe4, 0xf5, 0x58, 0x6b, 0xa1, 0x31, 0x29, 0x50, 0x71,
    0x81, 0xf4, 0x1f, 0xfd, 0xeb, 0xa7, 0xa0, 0x59, 0x72, 0x56, 0x26, 0xb8,
    0xc6, 0xe4, 0x3c, 0x53, 0x7e, 0xb2, 0xe3, 0x3b, 0xf4, 0x3a, 0x66, 0x42,
    0x36, 0xe3, 0x46, 0x9f, 0x71, 0x5e, 0x9f, 0x41, 0x23, 0xf2, 0x0a, 0x37,
    0x3a, 0xa9, 0x87, 0x0b, 0x20, 0xa0, 0x09, 0x80, 0xed, 0x97, 0x2a, 0x88,
    0x9c, 0x0c, 0x20, 0x64, 0xcd, 0xcf, 0x52, 0x56, 0x8b, 0x9d, 0xda, 0xc3,
    0x5a, 0xb7, 0x0b, 0x45, 0x43, 0x45, 0x32, 0xf8, 0x65, 0x25, 0x4f, 0x38,
    0xc8, 0xe0, 0x8e, 0x0e, 0x00, 0x23, 0xea, 0x38, 0x3c, 0x75, 0x13, 0xa9,
    0x6c, 0xfa, 0x57, 0x5a, 0x58, 0xe5, 0xd3, 0x1a, 0xca, 0xdb, 0x15, 0x7d,
    0xb6, 0x52, 0x0b, 0xc1, 0x51, 0x1a, 0xcb, 0x19, 0x61, 0xe1, 0x82, 0xb7,
    0x28, 0xeb, 0xe5, 0x64, 0x42, 0xae, 0xa4, 0x0d, 0xac, 0x3a, 0x99, 0x6e,
    0xf7, 0xc2, 0xff, 0x00, 0x72, 0x59, 0xd4, 0x9e, 0x7d, 0xd5, 0xfd, 0x0e,
    0xd9, 0xbb, 0x5b, 0xd5, 0x81, 0x67, 0x99, 0x17, 0x29, 0x6b, 0xab, 0x7a,
    0xfe, 0x4e, 0x92, 0x31, 0x43, 0xf9, 0x3d, 0x99, 0x84, 0x59, 0x97, 0xb8,
    0x30, 0xf2, 0x22, 0x22, 0xa2, 0x3f, 0x71, 0x11, 0xfb, 0x88, 0xf2, 0x41,
    0xfe, 0xf4, 0xae, 0x95, 0x23, 0x37, 0xab, 0x6d, 0x15, 0x54, 0xad, 0xcb,
    0xcb, 0x24, 0x01, 0x64, 0x63, 0xf7, 0x2d, 0x09, 0x8b, 0x3f, 0xae, 0xec,
    0x9f, 0xd7, 0xa0, 0x44, 0x5e, 0x9c, 0x34, 0xd5, 0x8d, 0x12, 0x97, 0xb6,
    0xfa, 0xbb, 0x51, 0xd8, 0x68, 0xd0, 0x61, 0x69, 0x68, 0xee, 0x8d, 0x2d,
    0x22, 0x0f, 0xb4, 0x70, 0x56, 0x25, 0x46, 0xc0, 0x3c, 0x0d, 0xaf, 0xe3,
    0x8e, 0xb5, 0x2e, 0xfc, 0x65, 0xfa, 0xa0, 0xfa, 0xda, 0xf3, 0x83, 0xb4,
    0xc7, 0x51, 0xa5, 0xce, 0xc9, 0x68, 0xe5, 0x6e, 0xda, 0xff, 0x00, 0xaf,
    0x2c, 0x10, 0xca, 0x7e, 0x8a, 0xe4, 0x14, 0xd4, 0x2a, 0x56, 0x69, 0x63,
    0x3e, 0x72, 0x90, 0xf8, 0x88, 0x80, 0x19, 0x12, 0x90, 0x4b, 0xf7, 0x28,
    0x94, 0xdf, 0x3d, 0x51, 0xbb, 0xa7, 0x7b, 0x80, 0x03, 0x64, 0xa1, 0xa3,
    0xa2, 0x90, 0x64, 0x09, 0x20, 0x80, 0x7b, 0x9b, 0x4f, 0xcc, 0x37, 0xc9,
    0xee, 0x38, 0xcf, 0x8c, 0xab, 0x29, 0x1e, 0x47, 0x23, 0xaa, 0x9f, 0x4d,
    0x7a, 0x22, 0xf1, 0x94, 0xee, 0x66, 0xa1, 0xbf, 0x6a, 0x38, 0x37, 0x2b,
    0x8a, 0x7b, 0x9d, 0xd2, 0x43, 0x47, 0xb9, 0x4e, 0x46, 0x69, 0x29, 0x45,
    0x3c, 0x6c, 0x33, 0xc9, 0x0c, 0x58, 0x1f, 0x0d, 0x91, 0xc7, 0x50, 0x82,
    0xc6, 0xbd, 0xbe, 0xe7, 0x64, 0x9a, 0xba, 0x5d, 0xad, 0x33, 0x57, 0x5b,
    0x9d, 0x95, 0xd7, 0xbe, 0xb1, 0xdc, 0x2d, 0xf3, 0xae, 0xec, 0x96, 0x79,
    0xd5, 0xbf, 0xd6, 0xe9, 0xf2, 0xe2, 0x75, 0x4f, 0xc7, 0xf9, 0x4a, 0x26,
    0xf1, 0x20, 0x0f, 0x05, 0x29, 0x43, 0xe3, 0xa1, 0xc5, 0xc2, 0xaa, 0xe1,
    0x75, 0xaa, 0x6a, 0xdb, 0x94, 0xed, 0x2c, 0xac, 0x72, 0x59, 0x89, 0x62,
    0x4f, 0xdc, 0x93, 0xc9, 0x38, 0x03, 0x93, 0xc9, 0xc0, 0xcf, 0x4c, 0x15,
    0xaa, 0x0b, 0x25, 0x86, 0xd5, 0x4f, 0x61, 0xb0, 0x51, 0xc7, 0x4b, 0x41,
    0x00, 0xdb, 0x14, 0x10, 0x46, 0x91, 0x43, 0x1a, 0xfd, 0x92, 0x34, 0xc2,
    0x8f, 0xd4, 0xe3, 0x27, 0xcb, 0x12, 0x79, 0xeb, 0xd6, 0xbd, 0x0a, 0xfc,
    0x24, 0x0f, 0xe9, 0x0b, 0x43, 0x9b, 0xd9, 0x9f, 0x90, 0x51, 0x73, 0xa6,
    0x5e, 0x3c, 0xd2, 0xfc, 0x81, 0x07, 0xfd, 0xbf, 0x1d, 0x74, 0xd3, 0x40,
    0xfe, 0xef, 0xc3, 0x8f, 0x07, 0xfa, 0x8e, 0xb8, 0xdc, 0xeb, 0xa9, 0xc5,
    0x30, 0xdf, 0xbb, 0x1b, 0x87, 0x80, 0x0f, 0xd0, 0xfe, 0xa3, 0xaf, 0xff,
    0xd9
};
