#include "mnist_coefficient.hpp"
using namespace dl;

namespace mnist_coefficient
{
    const static __attribute__((aligned(16))) int16_t l1_filter_element[] = {
           473,   2626,  -5975,   4910,   4711,   3669,   5372,   3680,   -741,    988,  -6865,   4911,   3045,   4446,   3744,   1776,    996,    158,  -6316,   4341,   4609,   4423,   5207,   3034,    393,  -7736,  -3732,   3276,    261,     38,    171,    171,   -193,  -7559,  -4348,   2992,   1903,   -207,   1570,   1986,    771,  -8373,  -4468,   2018,   1411,  -1566,   1135,    445,   -609, -26630,   2700,  -2511,   1645,  -4284,  -5342,  -3138,   -164, -26230,   1938,  -3730,    194,  -4435,  -4230,  -3930,   -532, -24623,     69,  -3681,    850,  -2996,  -5611,  -4608,  -1891,    182,  -3139,   2480,   2655,   5412,   4051,   5234,    201,   1164,  -1650,   3290,   3531,   6413,   3519,   5567,   -415,    994,  -2778,   3263,   3225,   6634,   1322,   6622,    295,  -4740,   1003,   2961,   5240,   1855,  -6604,   2533,   2553,  -5217,    983,   1839,   3720,   1934,  -6352,    150,    925,  -2345,    454,    913,   6146,   1611,  -5585,    125,   2820,  -4340,   2861,  -2333,   2431,  -5724,   1386,  -5033,   3682,  -5195,   4006,  -1372,   3471,  -5891,   2384,  -4988,   3412,  -4957,   1891,   -382,    840,  -4391,   1519,  -5016,    260,   5036,    993,   3180,   1011,   3893,  -4340,   4193,   1464,   3799,    182,   1277,   1750,   1981,  -2169,   5538,    306,   3462,   1050,   2129,    246,   4413,  -4218,   5349,   3318,   2420,   2736,   3717,   5156,  -1348, -21991,  -2884,   2815,   3871,   3539,   2632,   5588,   -723, -22748,  -2815,   3765,   4060,   2719,   2494,   4816,   -895, -21253,  -3164,   1230,   1096,    429,   -412,   2280,  -2154,   3209,   -175,   4281,   1350,   1962,   1007,    560,  -2261,   1910,  -1855,   3659,   1588,   2915,   1831,   2304,  -1364,   1296,  -1524,   1838,  -1317,   2778,  -5529,   5431,     87, -22423,   2775,   1565,  -1033,    171,  -5762,   4595,   -758, -24080,   3415,   -891,  -1061,   2718,  -5523,   3275,  -1287, -21751,   3144,  -5131,  -5735,   2977,  -7234,   2662,   -207, -11115,   4456,  -4227,  -5728,   5293,  -8849,   1660,    -63, -10457,   1759,  -5160,  -4849,   3837,  -8325,   2167,   -558, -10748,   2470,  -2765,  -7537,    416,  -1005,  -1164,   -485,   -604,   4598,  -5323,  -5900,    683,  -1230,    788,  -1539,  -1412,   3780,  -4062,  -8497,   -433,   -885,    -45,   -659,   -715,   4901,   1388,   2359,  -1955,  -2485,  -2892,   -797,   -218,  -2534,   1533,    495,  -2006,    324,  -1722,   1130,    263,  -2039,    117,   2733,  -2286,  -1461,  -1359,    470,   -449,   -821,   1304,   2113,   4844,  -7504,  -8984,   -814,  -1418,  -1822,    247,   1459,   6579,  -6280,  -9053,   -382,  -2893,   -231,   2767,   2803,   4847,  -7656,  -7279,    684,    -28,   -644,   4479,   1496,    542,   -919,  -5540,   -924,   4903,   7009,   4673,   3843,    -87,  -1206,  -5978,    257,   3167,   9006,   6191,   4205,  -1797,  -2323,  -5467,   -628,   2440,   8059,   2135,    535,  -3156,   4322,     78,  -1034,    719,  -2188,   -536,   1696,  -5402,   6417,  -2226,   -529,   1364,  -2588,   1150,    586,  -3601,   6125,    -95,  -1451,   1001,  -1803,   2292,   1263,   8128,    -62,   -336,    272,   3016,   -217,    355,    685,   8356,   -568,   -701,    367,   3401,  -1258,   1808,   3037,   9020,    892,  -1791,  -1494,   1263,  -1578,   5564,   3297,  -2143,  -8006,  -4016,   -291,   2526,   5940,   5541,   1547,    178,  -7437,  -4466,   -701,    243,   5967,   5354,   2491,  -1503,  -8087,  -3203,   -401,   1702,   5536};

    const static Filter<int16_t> l1_filter(l1_filter_element, -13, {3, 3, 3, 16}, {1, 1});
    const Filter<int16_t> *get_l1_filter()
    {
    	return &l1_filter;
    }

    const static __attribute__((aligned(16))) int16_t l1_bias_element[] = {
             2,      6,      1,      3,     -5,      8,      6,     11,     -4,      2,      1,      0,      4,     23,     10,     -4};

    const static Bias<int16_t> l1_bias(l1_bias_element, -2, {16,});
    const Bias<int16_t> *get_l1_bias()
    {
    	return &l1_bias;
    }

    const static Activation<int16_t> l1_activation(ReLU);
    const Activation<int16_t> *get_l1_activation()
    {
    	return &l1_activation;
    }

    const static __attribute__((aligned(16))) int16_t l2_depth_filter_element[] = {
           173,   4668,    573,   -619,  -9737,   -419,  -4354,   1380,   2338,   3220,  -2040,  -1215,  -4874,   4765,   7828,  -5541,  -1067,   2572,   -149,  -3262,    861,  -4668,   7911,   4077,   4052,   3958,   3538,  -6011,  -3990,   -842,   5257,   1165,   5197,   8306,   6239,   2530,  -8315,   6073,   8685,  -7310,  -2490,   1442,   1034,   1188,   -357,  -4875,   7101,   5639,   1355,  -9142,  -5836,  -2408,   3038,    423,   3264,   -647,   1108,  -2330,   3880,   2908,    639,   -130,   3200,    231,  -3312,   -484,    183,   3637,   2929,   -400,  -3808,    929,  -3188,  -1540,  -3297,   6685,  -1120,  19608,  -1754,  -4693,  -3073,   -178,   -213,   4145,  -2850,   9667,   5293,  -2660,    -16,   -309,  -2945,   3871,  -4356,   3041,   4578,  -4913,  -6057,  -4686,  -6077,   7496,  -4897,  25133,  -4769,  -8184,   -560,  -4812,   5881,   -394,   3773,  19491,   4974,   2749,  -6593,  -7932,  -2710,    -12,  -1359,   -495,   7032,  -4086,  -7022,    940,     82,   3746,   2119,  16105,    929,  -2468,   -248,   4542,   2640,    850,   5167,    961,   -725,   4341,   4125,    140,  -2991,   6394,  -4529,   1705,  -2949,     83};

    const static Filter<int16_t> l2_depth_filter(l2_depth_filter_element, -13, {3, 3, 16, 1}, {1, 1});
    const Filter<int16_t> *get_l2_depth_filter()
    {
    	return &l2_depth_filter;
    }

    const static Activation<int16_t> l2_depth_activation(ReLU);
    const Activation<int16_t> *get_l2_depth_activation()
    {
    	return &l2_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l2_compress_filter_element[] = {
         -2148,   8895,  -1870,  -7231,   -901,  -3406,   -407,    554,   4038,   5329,   5998,   3357,  -6767,   2938,  -2804,  -6624,  -5762,  -2603,  -2948,   1134,   2728,   7769,   5854,   3415,    735,   2759,   1578,    791,  -4713,  -2682,  -1798,  -3358,   1524,  -3607,    279,   -930,    849,   1740,  14048,  -6545,   -957,  -2832,   1474,   4459,   4570,   1495,  -1464,   1293,  -8800,   1146,  -1741,  12095,   7698,   4559,  -9246,   3115,   4946,    556,  -3406,   1703,   2739,   2077,  -2368,  -6059,   -603,    393,   3859,  -3178,   5346,  -3424,   6166,     91,  -2948,   5909,  -5850,  -3618,  -3410,  -1004,     22,   6118,  -5752,  -3883,  -2220,   2300,  -2299,   -845,  -1186,  -5856,   5166,   2053,  -8634,  -4472,  -6794,  -1691,   6480,   2009,  -6811,  -3809,    350,   4614,   1460,   1143,  -3966,   1214,   7015, -29479,  -1251,   4982,  16284,  -3814,   3583,   8612,   1730,  -2352,   9111,   -612,   6053,    890,  -1110,   1177,  -5967,   3739,   1314,   2070,  -1966,   -487,   2206,   1772,  -7332,    374,   -125,   5224,    574,  -1481,   -160,  -1656,     57,  -9634,  -1642,    476,  -5320,  12514,   9508,   3865,   2878,  -2353,  -2428,   7412,    103,  -3380,   -418,   3020,    788,   1965,   -464,  -2823,  -3013,  -8250,  -3249,    -78,  -2281,  -4072,   2917,   4463,   2607,  -1855,  -2538,   4608,   -455,   1892,   6170,   3322,   2698,    815,   -338,   2967,    875,  13838,  -9117,  -2546,   7767,   1889,  -1038,   2800,   2327,  -2404,   2055,    321,   5422,  -1357,   -541,   -761,   2989,   1597,   1881,   7454,  -1351,    263,  -7874,   2196,   -461,   1758,  -6284,   5062,  -5435,  -2071,    923,  -2914,   5159,  -4999,   7462,  -3384,  -3319,   2674,   1050,   2914,   -946,  -9362,  -5684,    609,  -9164,  -1788,    374,  -8637,   4778,   1385,   2567,   2004,   -603,   5052,   3268,   1514,   3050,  -2053,  -3619,   -650,   1055,  -1923,   1980,  -3768,    612,  -3548,  -1091,  -6837,   -584,  -4273,  -7425,   6509,   8183,  -5134,   3506,   4321, -10513,  -4196, -11058,   1606,   4042,    850,   -404,   -755,   1791,   2584,   5236,    -68,     26,  -2444, -10217,  -3578,   2832,    940,  -4498,   -444,    243, -13098,    866,   4711,  -3286,  -4809,  -1673,  -1807,   3913,   2159,   1559,   4305,  -1289,   3928,  -1510,  -6632,    648,   5954,  -6660,   3116,   -628,  -6625,  -8822,  -2767,   7009,   2269,   5514,  12694,   2419,   1176,   3976,   7609,  -2024,  -4624,    359,   1046,  -4105,    450,   3730,  -5342,   -433,  -1723,   4223,  11478,  -9831,  -1868,   2774,    695,   3786,  -4217,  -4556,   2369,  -1652,  -3852,  -4097,    -74,   3120,   -469,  -1550,  -4451,  -1440,   4601,  -2444,  -3120,    368,   -630,   -253,   8148,  -3253,  -4225,  -2179,  -2927,   4786,   6637,   3643,  -2138,  -7762,   6790,   1934,  -4624,  -2270,   3200,   2922,    254,  -3130,   2950,   -805,  -4270, -13297,   8845,  -5262,  -5125,   3784,   1402,  -5115,   5764,  -1604,  -3474,  -8887,   5163,   5731,    187,   -624,  -1748,  -4090,    802,   -827,   3061,  -1837, -10962,    981,  -9381,   2167,   8767,  -1871,    628,   2018,    887,  -5193,   1732,  -7106,  -2029,  -1495,   6329,   -865,  -3031,   7734,  -9689,  -2771,   6244,   -999, -12199,   1972,    589,   -269,   2400,   -542,     92,    353,  -3054,   -950,   4198,  -4383,   4774,  -3312,    908,  -2149,  -1167,   2637,  -4033,  -2243,  -2543,    859,   4295,  -1644,  -2918,   -643,   5228,    407,    190,   3025,   2140,    472,  -4942,  -2148,     70,   2492,   6336,   4567,    212,    387,  -3310,    495,   2462,   1186,  -1081,   1855,   3811,  -2987,  -5650,  -6990,   4876,   5896,   -842,  -8288,   3347,    -55,  -9693,   1006,   5442,   -136,   3557,   3094,   3011,   -211,  -3780,  -8549,   9208,  -3718,   3768,  -6090,  -3328,   1163,  -6443,  -3769,   7041,   2498,  -7078,   -240,  -1437,  -2964,   3151,  -1788,  -4063,   1236,  -3634,    206, -16690,  -3539,   1174,  -9657,  -8723,   9551,    947, -10293,  11140,    454,   5759,  -1811,  -2072,  -5097,  -1772,   1769,   1394,    259,  -1128,  -2997,   1826,  -5877,   2016,
          4096,   -342,  -2528,   7118,   3860,    575,    186,   8175,   1755,   7188,  -4225,   7027,    872,   1984,    985,  -1340,   -126,  -3626,   4383,  -1433,   4559,  -1300,   3206,   -736,   1479,  -6989,   4183,   4987,  -6434,   1723,   2890,   8747,   3042,    779,  -1293,  -2100,   1734,  -6312,   4868,  -1570,  -2468,   4425,  -3685,   1471,   -640,    536,   7044,   4556,   3178,  -1996,   2984,   2292,   6956,   8757,   -269,    668,   7382,   -959,  -1179,    367,  -4180,  -7658,  -2453,    808,  -3064,   -325,    164,   9556,   6091,  -5969,   2835,  -4983,   3530,   -532,   3124,   2283,   7444,      6,    -59,   4082,   2942,  -8742,   1262,   3642,   4256,   5257,  -4945,   1793,   1856,   -634,   8241,   2662,  -5673,  -2175,  -4725,  -3515,   -808,   5423,    -42,  -9805,   6662,   2472, -11079, -11997,  -6850,   8581,  -3415,  -7641,  -3350,   5065,  -2039, -13183,  -8223,    920,   3259,   4549,   4928,    148,    383,   1881,  -3049,  -5135,  -6781,   1957,  -1434,   -437,   4855,   1447,   -414,  -5671,    905,   1768,   2116,   -402,  -1812,   1511,  -4604,   -273,  -4265,  -2247,   3479,   1717,   9301,  -1853,  -6084,    330,   -431,   3621,    -39,   2029,  -2062,   -498,   3574,  -1606,   1130,   3419,   2571,    504,   -761,   5456,  -2299,   3331,  -5206,   1521,    661,   2214,   4168,  -3739,   4910,   -936,   8696,  -5044,  -7634,  -6588,   1179,   7044,   1190,   5524,   4284,  -2397,  -3685,  -6214,  12559,  -3052,   2068,   2446,    910,    655, -11399,  -5718,   -873,  -1322,   3060,  -5139,   2332,  -3949,  -8320,  -1842,   6838,    721,   -731,  -4338,   -181,   7165,  -1634,   2270,   9262,   1974,    863,   -560,   3021,  -4570,  -5280,  -7137,  -3873,   6183,   7628,  -1150,   -775,  -2707,  -1256,  -4728,  -1206,  -2126,  -3542,   4348,   5228,   2114,  -1812,  -3655,  -3626,  -5887,   2521,   1895, -14930,   5568,  -8228,   2081,  -3891,  -7420,  -6025,   4458,  -2658,   2644,  -3775,  -2189,   -869,   -903,  -2387,  -2267,   2237,   2123,  -2917,  -3264,  -9114,   5869,  -5148,   2250,   3208,   5701,  -2882,   2077,   1278,  -6049,  -3145,   6263,  -1442,   6573,   3739,   1538,  -8158,   1915,  -3300,  -5584,   2252,   8694,   7005,   2303,  -8791,   3648,  -8071,   3355,  -3193,   3651,   1957,  -3447,    514,  -2401,  -4249,  -2165,    687,     93,    795,  -1511,  -6031,  -4333,   -359,   2964,  -7153,   3058,   1841,     78,    546,    350,   2268,  -1932,   2222,  -2535,   2501,   3123,  -3700,   2339,  -4356,  -4065,  -5853,   2331,    632,  -4700,  -1173,  -2089,   1814,  -5112,   1530,   8832,   1428,   3184,   -868,    420,  -5394,    -16,   1791,  -3187,   1930,  -5679,   -564,   4116,  -6430,  -1479,  -6396,    991,   2656,  -4882,   -564,   4322,   7184,  -3674,  -2377,  -8152,   4526,   -551,  -3402,  -9206,   5320,  -6458,   3153,  -3824,   4663,  -1823,  -3951,   3800,  16002,  -5271, -10345,  -7398,  11792,  10565,  -1768,  11147,   4637,  -4384,   -385,  -6234,  -3036,   9934,  -3893,  -7464,  -1565,   -656,    786,   1092,  -1019,   -499,  -8007,  -1245,   6844,  -1436,  -4876,   1733,  -3943,   1704,   4166,    970,   -987,   3263,  -1458,    922,    504,    115,   1634,   2278,  -3014,   -906,  -4532,   4873,   -300,   3542,     -1,  -5937,  -8661,   1491,   2847,  -1489,    296,  -2878,   2145,  -2958,   -418,  -1550,   4288,   1471,   4176,  -2291,   2342,  -5322,   2169,   1612,   3744,  -9489,   4487,   3042,    863,    883,  -1116,   7413,   7356,  -8196,   8111,   5175,   2547, -14010,  -1870,  -8207,   1659, -10115,   2086,    791,   2140,   -493,  -4524,    712,  -7735,  -7130,  -1126,  -5434,  -3400,    -56,   -807,  -4665,  -5893,   7526,  -4318,   4762,  -1293,  -1804,  -1377,  -8692,   4231,   1543,   7341,   1377,  -3616,   1560,   -220, -12559,   2222,  -8230,    541,   6135,  -6850,   7151,    442,   2679,    612,  -3319,    998,  -4626,  -4299,  -4661,  -3559,   8934,   2101,  -7104,   2836,  -3500,  -8293,  -3833,  -1407,  -3874,  -2003,   4969,   5130,  -4484,  -1577,   3676,   2213,  -3192,    440,   1418,    172,    -62,   3980,   1273};

    const static Filter<int16_t> l2_compress_filter(l2_compress_filter_element, -13, {1, 1, 16, 64}, {1, 1});
    const Filter<int16_t> *get_l2_compress_filter()
    {
    	return &l2_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l2_compress_bias_element[] = {
            -4,     -7,      5,      6,     -3,      4,      1,      3,      7,     -1,      7,    -10,      0,      1,     -2,      1,    -13,      2,     16,    -19,     -1,     -1,      1,      1,     11,    -10,     -2,      7,     -2,     -5,      0,      6,     -1,      3,      4,     -6,      3,      5,     -5,    -17,      9,     -7,     -9,     11,      4,     -5,     -6,     -4,     22,      1,     -4,     -8,     -1,      1,      2,      7,      2,      3,      1,     15,     -9,     -3,     -4,      3};

    const static Bias<int16_t> l2_compress_bias(l2_compress_bias_element, -3, {64,});
    const Bias<int16_t> *get_l2_compress_bias()
    {
    	return &l2_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l3_a_depth_filter_element[] = {
          1572,   7011,   4610,   6397,  -1201,  -1275,   2782,    721,   1859,   1697,  -8181,   1640,  -4121,   8529,  -3358,   -307,   3611,   -554,   -445,   3658,   3964,    739,  -3983,   1920,   4627,    441,  -2509,   3885,    421,  -4881,  -6021,  -3060,   -481,  -1396,   1973,   2206,  -2998,  -4304,   3957,    965,   2100,   -840,   -233,  -1234,   1190,    215,   1323,   2617,   5150,  -8579,    537,   3237,   3205,  -1846,  -1168,   7586,   6394,    424,   2799,  -1139,  -5701,   2684,   4140,  -4171,  -2244,   1779,   -320,  -5432,    607,    211,   1401,   -748,    334,   1017,  -2743,  -2332,   9852,   2789,   7861,   1938,  -1689,    841,   2385,  -1915,  -2166,   3699,   2755,   1404,   9647,  -1421,    873,  -1594,   1566,  -7420,   4946,   5792,   -287,  -1087,  -3256,  -2159,    767,    371,   2778,    -93,  -1069,    946,  -1159,  -1318,   -747,   3144,  -1896,    340,    490,   -476,  -2243,  -3802,     54,  -2504,  -1987,   2567,   2080,   4066,   7405,  -1119,   -194,  -1067,    575,   -233,  -4383,   5635,  -2519, -12593,   -435,  -3202,   3760,    591,  -5597,   4573,   -411,   3947,   1097,   4369,  -2443,   1275,  -4722,   -931,   4123,   3483,  -4080,  -4750,  -3546,  -2535,  -8112,   5209,   2102,   1309,   6159,   1165,  -5160,  -2430,  -4185,  -5088,  -3962,     58,  -3791,  -4375,    796,   4175,   -483,   1984,  -1906, -16956,   1790,   -484,   2269,    844, -11352,  -5143,  -2049,  -1679,  -1136,   2711,   -574,   3528,  -7538,   -103,   2867,   -739,   3854,  -1613,  -4375,   -377,  -7236,   1723,  -5446, -26215,   1164,   1658,   5480,  -2739,   -815,  -2379,   3859,   1247,  -1850,   1109,  -4872,   1214,  -1934,   -968,   1546,   2221,   -878,  -3011,    745,  -5618,    690,    670,    854,   6395,   -784,  -4587,    499,  -1267,  -1463,  -1481,    428,  -3952,   1004,   5404,   6912,    404,   1769,   5290,     94,   2699,  -3543,  -5672,    176,   1087,   -911,   -763,   1316,   3029,   1464,   1709,   -767,   2357,   3044,   2077,    512,   1198,  -1741,  -1981,  -1240,   2452,    -17,   2719,   1387,   2371,   1828,  -5510,  -1838,   3149,    833,    947,   1016,    754,    956,    818,   -434,   4866,   2625,   -147,    932,   3064,   5035,  -2572,  10997,   1188,  -8010, -10305,    537,  -7076,    813,   2128,   2306,   2728,  -8095,  -2362,   1420,  -1666,    174,    739,  -2035,   -678,   -338,  -3838,   1606,   3874,   3743,   1921,    719, -11647,  -2132,   3433,  -2001,  -2426,   2888,   1263,   1408,  -1463,   -830,    480,   2416,  -1380,   5791,   1075,  -1190,   1415,   -770,   4453,   2005,   -711,    169,  -1455,   -754,  -7319,  -5763,     20,  -2276,   7880,  -3133,     91,   -906,  -1429,  -5831,    249,   1124, -17623,  -2558,  10754,   6974,   3330,   1811,   1694,   -354,  -9783,  -3146,  -1571,  -2043,  -4071,   5103,  -2176,  -5236,  -6764,   4015,   3492,  -2254,   2537,   1764,   5162,  -2721,   -827,   -814,   6127,  -4537,   -181,   3839,   8364,   1926,  -5091,  -3982,   8494,   2395,    178,   1469,   5324,   -823,  -1645,    752,  -1311,    483,   4994,  -1783,   -518,   3986,  -1712,   -417,   -728,   1345,    597,  -4239,  -2184,   4146,   1113,  -2360,   4774,  -2404,  -1238,  -1608,   2867,    871,    705,   2877,  -3885,    269,   1475,   4646,   3384,  -5137,   2840,   1435,  -1690,   -499,    117,  -4743,  -3960,  -4504,   3470,  11396,   2312,  -2152,   1520,   1569,   -792,   1950,    762,   1869,    983,  -6336,  -8045,  -1264,   5277,   -319,  -7241,  -3973,   5710,  -4657,  -2956,  -1375,   -728,  -1177,   3414,      1,   1249,   2000,   1523,  -3228,   -798,  -3883,  -3845,   -331,    157,   7798,   -171,  -2194,  -3118,   -849,  -5837,  -1961,   -476,   4340,  -4448,   -323,   -247,  -1374,    786,   4380,   3184,  -1126,   6234,   2245,   2116,   5162,   3922,  -2674,  -2526,  -4213,  -2786,  -1483,  -5222,    952,   2309,   6142,   2000,   3755,   4394,   2175,   -587,   6476, -11127,  -1657,  -1444,  -4853,   3986,  17254,    859,   3089,   1936,  -2823,   3199,    997,  -3449,  -2939,   4109,   5115,   2319,   2697,   1928,   4497,   1382,
          1872,    956,   1028,    886,  -2193,  -2065,  -1907,   3433,   4316,   6481,  -5489,   6804,  -2407,  -5117,  -6309,  -3372,   2456,  -2878,   3690,  -2300,  -1890,   4753,   1052,  -2578,  -1708,    143,   2248,  -1261,  -1785,  -1749,    785,  -5059,   -948,   2117,    561,   9372,   3121,  -2246,  -2643,   5589,   5029,   -372,    864,   -814,  -4318,   2540,   -331,   5663,   -494,  -1296,  -1673,  -4468,    993,  -3002,   2531,    615,  -9510,   2069,   2654,   2683,    624,    449,   1256,  -4868};

    const static Filter<int16_t> l3_a_depth_filter(l3_a_depth_filter_element, -13, {3, 3, 64, 1}, {1, 1});
    const Filter<int16_t> *get_l3_a_depth_filter()
    {
    	return &l3_a_depth_filter;
    }

    const static Activation<int16_t> l3_a_depth_activation(ReLU);
    const Activation<int16_t> *get_l3_a_depth_activation()
    {
    	return &l3_a_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l3_a_compress_filter_element[] = {
         -5889,   3109,  -4564,   2633,   5087,   2365,   -666,   1209, -10224,   6318,  -4897,   3061,  -6276,  -7961,  -5009,   1707,  12326,  -6163,  -3121,   -224,    815,  -5795,   1915,   6360,    250,   9006,   2203,   7442,   5988,  -3555,   2524,   3800,  -8403,   1645,  -1115,   3381,   5625,  -1014,   6283,   -389,  -1830,   7973,  -1615, -11340,   5482,   8131,  -4352,   2710,  -3325,  -1042,  -1063,   -179,  -5924,   1757,  -1404, -14853,   6667,  -6978,  -3100,    656,   -338,   4057,  -4074,  -5661,  -1636,  17641,  -2022,   6892,  -1159,   2912,  -3960,    801,   5292,   7258,  -3862,   -892,   2641,   -667,   4335,   1156, -11896,   7993,   2903, -10279,   1441,   5806,   3011,    407,  -7155,   2187,   5351, -14192,   8061,   7136,   7817,  -1984,   2736,    736,  -2200,   -520,  -1064,  -3028,   2702,   5411,   4588,   3138,    216,   5680,  -3203,  -4108,  -1872,   6824,  -5942,   9479,   7810,   6017,  -4724,   3662,  -1815,  -4623,  -2670,  -8524,   1250,   6990,    579,  -3581,   2583,   2910,  12709,    880,   3053, -11904,   3795,  -5743,   3448,    631,  -2003,  -4569,  -3777,   6895,    890,  -7476,   4955,   2261,   1668,   1488,   -610,  -1465,   1047,   4384,   -582,   -230,  -1532,   1274,  -6884,  -6542,  -8051,   1597,  -6072,  -6575,  -5891,    385,  -4779,   9541,   5065,   4465,    285,   3157,  -6859,  -3471,  -1743,   1363,   1357,   -996,     33,   6800,  -1169,  -1368,  -1172,  -1390,   2108,    938,   -677,    -98,  -1508,     53,   5677,  -1262,   3304,  -6430,  -4764,   2510,   3631,    421,   4333,   -595,   2334,   -195,   1155,  -3437,  -4656,   1008,  12728,  -5915,  -8012,  -9856,   7114,   1957,  -1306,    391,  -1284,   -585,   1689,   -382,   2061,   -626,   3109,  -5359,  -8141,  -3674,  -2117,  -1839,   1370,   5663,   3722,   2522,  -2391,  -2840,   3709,   6601,  -5412,   -385,  -1459,  -7650,  -2447,   4987,   -659,   5367,    736,   -484,  -2648,   1125,   8857,  -2979,  -8619,  -5199,  -5982,   1932,   1399,    636,  -1910,  -1947,   5573,   -917,  -3474,    990,   6686,  -1386,   1725,   1744,   4777,  -5546,  -1987,  -2876,   2058,   1917,   7787,    791,   2868,    451,  -4423,  -5404,  -2109,   3607,  -8110,  -5636,   2766,  -5874,   3565,  -9754,  15122,  -5012,  -7672,  -4501,   4244,   1226,  -5201,  -7668,   4887,   3964,   4624,  -1693,   2693,  -3986,  -4782,   -892,  -2389,  -3205,   3049,   9184,   6975,    349,   -683,  -3286,  -1442,  -4949,  -2996,    374,   5665,   3935,  -5305,  -4306,   6253,   6822,  13550,  -5304, -14665,   3771,  -1031,  10266,  -1426,   1796,   8051,  -6959,  -2522,   2175,  -2650,   8440,  -5936,  -1758,   4446,   4278, -10967,  -3419,   -911,   2300,  -2988,   8902,   1041,  -2256,  -7420,   4913,  -2833,   2119,  -2676,   3141,   2556,  -6315,  -4457,   8077,   2958,  -1001,   1122,  -1477,   4571,  -6774,  -1544,   3198,  -4571,   5938,    473,   6445,  -1167,  -8439,  -7291,   1052,  -5055,   -127,   -901,  -1125, -10019,  11343,   6020,   4055,  -2375,  -4682,    893,    295,  -1370,   1698,  -4028,   -170,   8840,   6500,   1002,   1735,   9799,  -2720,  -7029,  -9308,   2617,  -1790,  -1311,    575,  -3887,  -4572,  -5371,   1472,  -5254,  -3688,    286,   7672,  -2485,    898,  -6723,   3049,   6936,   5889,   4480, -17884,   1625,   1515,  -5887,  -2404,   1711,   3310,   2833,  -5301,  -5967,   -950,    716,  -2839, -10975,  -1777,  10611,   5011,   3394,   2654,    959,  -4332,  -6578,   1052,   6271,  -4307,  -4625,  -5834,  -6288,  -5005,   3869,  -3734,  -1303,  -3024, -10914,   -163,   -422,  -8559,  -4298,   1225,   1780,  -1418,   4790,  -3521,   4115,    107,  -6756,  -2206,  -9203,   1727,  -1791,  -2207,     18,   -431,   3313,  -6335,  -4954,  -9612,  -1739,  -7911,   1008,  -2601,  -1797,   -426,   2210,  -9444, -11719,  -2618,   2844,   -432,   5172,     19,   1489,   7226,    432,    -77,   2365,    996,   4190,   -672,  -6099,   1667,   3033,  10389,  -8389,   1200,   -724,   1051,  -2068,   2592,  -3438,   5377,   2619,   1331,  -3996,  -3450,   1374,  -8200,    463,  -3102,  -4230, -11791,  -6865,   1815,
          4683,  -5161,  -4126,  -1426,    243,  -2817,  -3613,    704,  11851,  -5565,   6639,  -2897,    578,   2079,  -1056,  -3433,  -4143,   2025,  -5559,   9064,   -453,   2319,   3897,   -515,   1543,    944,    -36,  -4253,  -5568,   1892,   7431,   -669,   -247,  -2255,   1189,   4823,    822,   7348,    509,  -4616,  -3253,  13687,   6443,    501,  -3526,  -8242,   -603,   1901,  -3218,   6116,   7916,  -4622,    719,   3674,   7542, -10972,  -9363,   4533,   3767,  -7181,   5800,   1143,   1999,  -3509,  -7233,  -7414,  -5868,   3174,  -2413,  -4434,  -4390,   2328,    462,  -4736,  -2069,  -4223,   2485,  -1924,   4497,   -835,   3860,  -8985,   4840,   7157,  -7205,   6524,    189,   5970,   -974,   7918,  -3480,   3265,   4760,    233,   3747,  -2791,    264,   -403,  -5465,  -6218,  -1616,  -5867,   1104,  -6784,  -1409,   -533,   1699,   9508,   1198,   2124,     84,   4699,  -6733,  -4667,   6725,  -1087,   4533,   6363,  -4933,   4868,  -4060,   7558,   1667,    382,   1864,  -3814,   4869,   1404, -13761,  -3288, -10352,   5205,  13768,  -4932,  -6547,     60,  -4079,    986,  10393,  -2376,  -2241,    367,   7257,   9561,    379,  10601,   3353,  -5359,   5784,  -6465,   7508,  -8700,  -2995,  -4968,  -1166, -13399,   8153, -12482,    308,   6472,  -3057,  -4765,  -5671,   1461,  -1738,    465, -10180,  -4346,  -1799,  -3584,   9334,  -3563,  -1122,   7032,    686,   3694,  -3821,  -6040,   8834,   -453,  -3985,   1243,   4976,  -4313,    110,   5145,  -5369,   1660,   2934,  -1814,  -5583,   2912,   -876,  -1291,  -9570,   1084,   3045,  -3644,  -1143,   4152,   2985,   4325,   3338,   4921,  -2111,   2485,   7774,   3109,   1486,  -2228,   -983,   -679,    410,  -3246,   -861,   2362,  -4766,  -7998,   1264,   3930,   2324,  -6696,   5873,  -1166,   5054,  -4666,  -2938,  -2837,  -2313,  -4581,  -2379,   1120,   -678,  -1572,   3104,   3694,   1662,   5476,  -8599,  10023,    846,   5018,  -5838,  -7712,   9731,   1946,  -5132,   4694,  -2409,  -3145,  12144,  -4998,  -4159,   4898,   3738,  -6614,   -204,   1892,  -7773,  12977,   3743,   1845,    535,    778,  -6467,   2677,  -4203,   2488,   3438,  -4242,   -961,  -4473,   1696,   2466,  -7190,  -4878,   -933,   5315,  -7914,  -9694,   6571,  -6233, -19832,   7794,   3436,  22768,  -2823,  -9320,  -6274,  13248,   2813, -12166,  -3388,   -611,   2712,  -1819,   1140,   -776,  -7254,  -6457,  -8403,   6780,  -2115,   7801,  -3724,  -6326,  -2650,  -2342,   -474,  -1010,  -2863,   5577, -13269,  -4498,   4744,   4864,  10987,   3067,   3358,   9723,    344,  -3152,   6543,  -7496,  -4130,   -120,  -3727,   6619,  -1426,   7175,   4775,  -1675,   6418, -10036,  -4346,   -962,   1103,  -8135,   4468,    780,   1642,  -6139,   8090,  -2981,  -4280,   2889,  -5523,  -5585,   3562,  -4368,  -1388,  -1515, -10589,    463,   2219,  -2144,    184,  -3344,   6409,   1270,  -4451,   2899,  13677,  -8303,  -3608,   -526,  -2303,   3138,    242,   7494,  -2332,  -5033,    285,   2131,   1083,  -7722,   4352,  -8944,    934,   8619,   3713,  -9867,  -2506,   8242,    756,  -7917,   6970,  -1400,  -3813,  -6910,   -220,   6835,  -2223,  -7434,  -2484,  -1990,  -3194,  -6150,    561,  -3778,  -7925,   -191, -10090,    641,   3487,  -1891,  -2186,  -4695,   5684,    335,    911,  13736,  -3974,   -724,  -2077,   2026,   2346,   5312,  -3415,  -3968,  -4333,  -1666,  -4568,   -972,   -163,   1927,  -2954,   1460,   8282,  -7932,  -4128,  -2087,   3822,  -1549,  10686,   6228,   1665,   3366,  11903,   2966,   1500,   5580,   3941,  -1207,  -4936,   4834,    322,  -5017,  -3781,  -1555,   -822,    415,   5192,   2360,    858,  -4887,  -3213,    415,    995,  -5372,  -6114,  -5069,   5777,   -475,  -1667,  -3229,   1752,  -3387,  -6204,   2485,   1263,    367,  -2217,   1415,   9461,  -2412,  -7359,   7752,   2585,  -4584,   2777,  -9373,  -1898,   -153,    509, -17738,   -950,  -6403,   1490,  -6007,  -7868,    888,   3319,  -4493,   4759,  -2764,   5113,   2219,  -8920,  -1892,    781,  -6924,  -3635,  -4181,   5100,   8747,  -1599,  -2472,     56, -10871,  17331,  -2104,
         -6073,   4999,   3412,   3534,   -975,   -957,   6957,    176,  11733,   9107,  -5837,    201,   -483,   9924,    -33,   1011,   5637,  -7817,  -5575,   4770, -10311,  -5773,   6033,    268,   -276,  -4861,   4626,  -5936,   3503,   2871,   9548, -10532,   5235,   1893,  -4356,  -3621, -11802,   3787,  -3793,  -1896,  -1133,  -7295,   -197,  -2012,    775,  -2868,   3351,   2382,   2361,   1593,  -8063,   3141, -12795,   -325,   6623,   -219,   4134,   -808,    688,  -1126,  -8666,   1972,   1076,  -2304,  -1720,  -3956,  -3352,  -6069,  -7039,   4388,   -586,  -5663,   -945,   3774,   4297,  -4039,   -299,   1324,   6968,  -6872,   -473,  -6139,  -6609,   1242,  -4266,  -1972,  -2970,  -4721,   4078,   5331,  -4212,  -8222,  -8571,   3660, -13243,  -9153,   6453,   2014,  -2198,   -961,   2423,   5330,  -8305,   2206,  -2523,    599,   3655,  12912,    341,   1170,   -922,   5454,  -5806,  11860,   7920,  -1396,   5106,  -1292,  -5204,  -1319,   2201,   5893,  -4809,   3602,  -1374,   -869,   3642,   -254, -11535, -21596,   4860,   1476,  -4240,   1706,  -3563,   8458,  -5909,  -1025,  -5319,    915,  -1327,  10441,  -2310,  -4908,  -4151,    568,   7238,  -3477,    -45,    396,   -898,   3501,  -2016,   3746,   2308,   6465,  19945,  -4111,  -6081,  -9092,   5461,   9413,   4586,  -2605,   4590,  -5378,   5508, -10359,  -3449,   9527,    -49,   -319,   3073,  -3518,   5270,  -8100,   -713, -10325,   1786,   3642,  -2178,  -2848,   4144, -11275,   2243,   4335,  -1789,   2504,  10265,  -2866,  -6005,    586,   3659,    799,  -2733,   4817,   3154,   3212,   7112,   -264,   4491,  12526,  -5718,   5070,  -6420,   2018,    394,  -6713,   -107,    985,   2049,  -2223,   1280,  -2888,  -1385,  -4261,   5938,   2367,  -7507,  10586,  12725,   -729,  -3392,    997,  -2172,   -134,   2483,  -5019,  -6949,  -1412,    241,   6702,  12786,   1958,  -5719,   2913,   4199,  -3919,   2224,   1553,  -2423,  10544,   2379,   4356, -11030,  -4985,  -6414,   7071,  -3715,   3153,    591,   1971,  -3861,    275,  -5052,  -6113,  12556,  -9152,  -2243,   2811,  -3655,   4566,   3984,  -6607,   -576,   5599,  -8171,  -3315,  -1553,  -5718,   3962,      8,  -8215,   3329,  -1650,   2664,   -334,   1204,  -5465,   2404,   4849,   1835,  11126,   8022, -16070,   5016,   9549,  -1979,    442,  -6390,   1570,  -4690,   3538,    -88,  -2821,   3088,  -4422,   1408,  -4903,   7390,  -3049,   1331, -12272, -10543,    214,   -487,  -1734,   7924,  -2120,    772,   -110,   3309,   1678,   5927,    454,   3388,   4768, -11772,   6539,  -3678,   -443,  -3741,  -3568,   2074,   8181,   -245,   -310,   2400,  -1746,   -306,  -8084,    514,   5167,    271,   5437,  -6783,  -3373,  -3603,   4808, -15542,   5411,  -5318,   -914,   5153,  -2709,  -4074,   3304,  -1928,   7086,   2594,    470,   3955,  -6735,   4878,   7733,  -1087,   7284,   -690,  -1209,  -2363,  -1934,    -48,   -924,  -1778,  11845,   5840,   1489,    970,  -9615,   -415,   1415,  -2602,   4132,   4842,  10722,  -3773,   -743,   7275,   5852,  11296,  -4525,  -4679,   -111,   3989,   -262,  -1248,   1063,   9311,  -8979,   7410,   1180,   -853,   5772,   3517,   2547,  -2126,   6317,  -2996,    932,   5063,   -146,   2676,   3776,  -2122,  -1752,   7767,  -3131,  -6234,   3521,   1054,  -7453,  -2560, -17455,  -1271,   6332,   2070,  -7010,  -1895,  -1367,  -4543,   2537,   5556,   3862,   1873,   -473,   1057,  -2122,  -1032,   7853,  -4535,  -5151,   3555,  -6319,   7286, -13863,  -5758,   3645,  -2074,   6352, -10710,   8398,   6304,   2950,   3906,  -2633,  -2710,   4488,   -777,  -7470,   2503,   -369,  -3704,   3230, -12152,  -7298, -10961,   1060,   9595,  -5336,   2524,  -5072,   2009,  11256,   2528,  -6227,  -1447,   5336,  -4093,  -5813,  -1418,    911,   5214,   8438,   6329,   2708,  -6319,  -5856,  -6590,  -8012,   -896,  -1992,   -238,    -98,   -196,   1069,  -5076,    173,    192,  -3452,   1329,   1274,  -1336,   9605,  -2018,  -4971,  -2583,    717,   2313,   1536,  -4457,   9746,   -139,   1161,   4323,  -8963,  -5012,  -9340,   7644,  -4607,   8243,  -9463,  -3180,
          6226,   3933,  -1695,  -1646,   5785,  -3598,   3335,  -5266,   7814,   3994, -12969,   8333,  11327,  -9357,  -4795,    813,  -1985,  -4632,   4609,   2157,  -3019,  -1127,   2734,  -5743,   9179,  -1938,  -5127,  -6380,  -9986,   3485,    410,  -2137,   1405,   2190,    911,  -1008,  -1228,  -9658,   -661, -11036,   3354,  -5234,    276,    346,   9694,   2070,    989,   2391,   5534,   -950,  -2429,   3189,    866,   3070,   1984,   4352,  -9838, -11222,  -6860,  -5763,   -445,   7128,   2601,   2247,  -2180, -12251,    574, -12724,   2697,   1112,   2768,  11945,   -777,  -2734,   4715,   4817,  -4215,  -3302,   5008,   1216,  -8646,  -7010,   3705,   1446,   1579,  -1912,  -3829,  -4203,  -3925,  13462,  -5500,   2154,   6744,  -2189,   3307,  -4642,   1139,  -8351,   1031,   1587,   4173,   1800,  -8442,  -1212,  -4863,   -461,  10573,  -1193,  -5209,   3547,   3931,   6089,   7619,  -1621,  -6437,  -8161,  -2962,   6002,  11045,  -1524,   1723, -18035,  -1961,   4966,  -1767,  -3194,   4545,  -2075,   1249,  -6241,   7331, -13285,   9766,  -1940,   5469,     23,    566,  -5142,    511,   5486,  -6580,  -6643,  -5437,   2940,   6584,   7098,   -472,  13282,    857,   3025,   7026,   4630,    -95,   1824,   3187,   -193,   9583,   2881,   1090,   7630,   1565,   2669,   2348,   4421,  -4659,   2486,   5653,   2310,   9503,  -3194,   -622,    305,   2329,    792,   1360,    -19,    222,   2022,  -1842,   4353,   2639,     40,   9859,  -3917,  11948,   7929,   5632,  -4239,    704,  -4184,  -1822,    -78,   2197,  -5138,   -940,  -2094,  -5610,  -1424,   2661,    -56,  -4117,   3743,  14980,  -2581,   2600,   6757,  -2512,  -2434,  -2047,   -678,     39,  -1919,  -1163,   -887,  -2838,  -1026,   4808,   4190,   7789,    471,   3736,   3232,   8903,   2360,   2429,  -4359,  -4132,  -1507,   5009,    394,   4400,  -2911,   -322,   6095,   6080,  -4329,    823,  -4892,  -4833,   2825,   3724,  12964,  -3610,  -1469,   9373,    212,   5068,   2036,  -1880,  -3581,   5339,   -453,   1159,   2103,  -1137,   4298,   2536,  -5168,   6509, -12766,   2769,  -1097,   8926,   7392,   8719,  -1146,   1063,   3409,  -2885,  -1485,   2879,  -5678,   5165,   1537,  -4747,    815,    729,  -1373,    709,  -1482,   4275,   7145, -18864,    915,  11061,  -3996,  -8268,  12438,   2207,  -4707,  -3764,  -4527,  -3714,  -4327,   3412,  -9235,  -9307,   -104,  -2172,  -5632,  -2411,  -3305,   -553,   5869,  -5083,  -3601,   5855,   2154,   1303,  -4946,    -23,   6114,  -6997,   5252,   5323, -12356,   -717,   2612,  12139,   1820,   1724,  -3937,  -5140,   -212,  -4085,   2660,   -877,  -8912,  -3627,  -1871,  13879,  -6056,  -7272,    866,  10752,   3861,  -3864, -10746,   1861,  -8844,  -4690,  -3586,    748,  -7055,   6213,   4724,      3,    524,   -189,   2974,   -315,  -5094,   1325,   6342,     36,  -3688,   4872,   4778,   4420,   6500,  -6585,   6254,   3027,  -2623,   7746,   2968,   2440,  -4648,   8124,   -786,   2414,   -269,   2389,   -758,   6657,  -5490,  -1895,    441,   5583,  -7866,   -384,  -1523,  -8782,  -1286,  -1782,   3551,  16667,  -5292,   4942,  -1579,  -4225,   -594,   9361,    617,   -516,   3946,  -1822,    867,  -4489,  -2102,  -2102,   2258,   5869,  -8419,   7177,    918,  -1434,   6123,  -9448,    -65,   6870,   4586,  -3634,  -2748,  18822,  -5944,  -2582,   5612,  -2356,  -2112,   4937,   1848,  -2799,  -3031,  -4960,  -4740,  -5749,   1613,  -4201,   -418,    967,    384,   6718,   2172,  -1544,  -1794,  -4345,   2782,  -2171, -11114,   8011,  -7134,  -1772,  -1065,  -1329,   7507,  -1743,   6781,  -1782,  -3781,   -478,  -3115,  -1353,   2942,   3738,    402,  -7031,   -205,  -3423,   6907,   2564,   3388,   -327,    680,   1032,   6622,   2983,   -727,   4658,   1847,  -3348,  -9630,    152,  -4768,   2035,  -2509,   9049,   9114,  -3691,   1195,   2800,  -3640,    433,  -2966,   1998,   2165,  -4393,    -92,  -3007,  10546,   1153,  -6155,   5418,   -158,   3172,   9493,   7098,  -1003,  -5901,   -356,  -2791,  -4377,  -4402,   2490,  -8277,  -4255,   5089,  -2269,   2070,   -178,  -7333, -11188,
         -5302,   5394,  11398,   3924,  -7797,   1885,  -7738,  -5980,    364,  -1295,   1292,    974,   7049,   8246,   1669,  -9685,  -8786,   3106,   -267,  -2547,  -1350,   6647,   1112,   -480,   3548,   2298,  -6806,  -1839,   8202,   1010,   6918,  -1330,   -889,  -5352,    616,     57,   -420,   3844,  -7846,    985,  -3271,     35,  -6026,   3217,   1682,    581,   4746,   6481,   3463,   7325,  10699,  -4095,  -4526,    468,  -1072,   4039,  -3093,  -3473,  14806,   -101,  -3397,  -2502,  -1858,   -578,   -561,   -882,    257,   3609,   2843,   1888,   5816,   6380,    867,  -4840,   3109,   -772,  -1434,  -6098,   3229,   4893,  -4086,  -1570, -11426,  -2556,   -300,   2041,  -5636,   5296,   -745,   1416, -10179,   8871,   2865, -11907,   2870,   5289,   3621,  -3271,  -1175,   -712,  -6350,   4463,   3334,  -2711, -12592,  -3498,  -1505,  -1673,   2970,   2990,    961,  -2461,  -3671,  -3327,   2921,  -2624,   9225,  -1551,  -3767,  -3352,  -8698,   7177,    438,   1004,   2681,  -2135,  -1731,  -6098, -11502,    789, -13352,    174,   5127,   -739,  -5180,   2791,   1872,   3058,   4676,   4113,  -2115,  -2190,    771,   4321,   -951,  -5276,  -2846,  -2140,   4715,    410,   2827,  -9278,   -663,  -8731,   7275,  10265,   4836,     95,   5336,   5865,  -4454,   8331,   5535,   1249,   7044,   2489,    505,  -2424,  -3371,  -5820,   1058,   3076,    331,  -6537,   1300,    837,  -5154,  -2311,    147,   1775,  -4168,   2890,  -6440,  -1446,   4406,   3628,  -3034,   -573,   2025,   5066,  -1975,   -346,   -418,   5334,    -55,   -797,  -4723,   1876,  -2456,   2949,    105,  -7467,   -477, -10384,  -3111,   -928,  -7062,   4362,  -1248,  -1509,   -298,  -3717,   -422,   1718,  -1155,     -3, -12066,   2533,   5405,   4147,  -3547,    363,    472,  -5049,   -489,   2899,    -22,    -99,   -224,   1986,    805,  -1770,   7050,  -6858,    876,   4446,  -4591,   -470,   3638,    834,  -1614,   2776,   1677,  -2187,   2135,    453,   3741,  -1588,  -5508,    665,   3176,   1945,   2849,  -3741,   4787,   2656,  -4902,   3554,   7158,    376,  -2095,  -5188,  -2314,   2198,   2015,    -52,  -6406,  -1649,  -1495,   1491,  -2861,  -3405,    813,     54,  -6144,  -5608,   1071,   3016,   1876,   4385,   -832,   6319,  13897,   5325,  -4710,   3641,   -986, -15384,   4293,   9363,  -3981,   2242,   2065,   4330,  -4384,   5714,   6106,   2622,  -1656,   -291,  -1532,   1104,  -1788,   2340,    566,   5649,  -3568,  -4706,   1907,   3526,  -7421,    -46,   2136,  -4424,   4043,   5377,  -6861,   2724,   1189,    753,   1310,  -3548,   4101,  -1397,  -1125,   3674,  -1659,   9237,   8455,   6046, -11229,  -8492,   1421,  -2126,  -7432,  -9137,   4778,  -3065,   2967,  -1094,  -2559,   7218,   1627,   3327,   3055,  -3082,    510,   2603,   2069,   -237,   5720,   8491,  -6499,  -9879,   6174,  10930,   -449,   6358,   2237,   5110,   5432,  -1443,  -7936,  -3794,   -954,  -5317,  -8561,   1694,   1618,  -1235,   4097,   -812,   2595,   4495,  -4654,   2066,   6581,    753,   -960,  -4024,    745,   1256,   -554,  -4975,   2142,  -4764,   3044,  -4760,  -2364,  -5428,   -533,   -446,   6698,  -4506,  -7489,   -199,   6537,   3881,    708, -10389,  -9463,  -7210,   1125,  -5067,   5777,    457,   6004,   4939, -10684,   8824,  -4971, -10213,   1669,  -6769,   2383,  10607,   -747,   3251,   2796,  -1333,   4915,   2366,   3980,   2177,  -7903,   4081,   5156,   1364,  -3228,    706,    438,   -521,  -3234,  -4862,  19091,  -6145,   -857,    764,  -2921,   4156,  -8349,   -804,   1301,   4154,    780,   6966,   4386,   2952,  -7236,   3632,  -3397,  -1394,  -2054,  -6708,  -2022,   -412,   3689,   5101,   8360,  -1128,   -556,   -718,   2356,   3761,   2299,  12969,   4821,   3460,   4458,   1524,  -5102,  -4431,  -4819, -11251,  -8951,   6381,   4067,  -1507,  -4360,  -1046,    931,  -1043,    575,    -74,   1008,  -4420,    356,    455,  -6684,  -1667,   1263,   6038,   2957,   3562,    961,  -2719,   4931,  -5231,  -1577,   1079,   -384,   5938,   4911,   2145,  10021,   8835,   4077,   -805,   2740,  -2886,  -2222,  -4522,
            22,   6273,  -4241,   3505,  -7993,   1334,  -6860,  -2508,   -272,  13474,  -1005,   -697,   6549,  -4564,  -6373,   7449,    675,   -508,   2783,   7481,   3833,  -3847,    112,  -1753,  -7038,   1738,   8549,   4040,  -8184,   1288,   4048,   6079,   8554,   1509,  -1918,   -210,  -3951,   1764,  -5951,  -5696,  -1518,    605,   3185,  -9838,  -8875,   2990,   1445,  -6980,  -1014,    261,    901,   -957,   3745,   8357,    351,   6499,   -119,   -233,  -3740,   3276,  -3442,  -7015,  -4167,  -5351,  -5305,  -3795,    207,  -6649,  -4523,   -327,  -1079,  -2461,   -391,    546, -14336,  -2040,   4692,   3895,   2532,   3617,  -3067,   3183,   3761,  -2622,  10489,   1857,   4354,  11258,  -6977,    -93,   8542,   1573,   6026,  -3152,    293,    302,  -4020,   4424,  -3184,  -7621, -12047,    884,   5953,   1509,   2299,  -1584,  -8684,   -975,   4120,   3552, -10170, -10268,   3448,    772,  -1571,  -3646,  -4986,  -5032,   -439,   2725,   2341,   2228,    809,   1767,  -1547,    985,    183,    129,  -3192,  -8730,  -5726,  -6994,  -5692,  -1896,  -1918,  -4215,   2469,   4306,  -6240,   6986,   9427,  -4504,  -4880,   6339,    202,   -442,   7024,  -3479,   6621,   4707,  -1030,  -1897, -10119,  -9783,   5581,   2922,  16380,  -4900,   3187,   4714,    121,   -974,  -5985,  -1563,   1169,    658,  -3350,  -1022,  -3705,  -3015,   3822,    502,   3365,    617,  -2004,  -5483,  -3559,    181,   -901,  -8150,     63,    388,    492,   8643,   5013,    201,   9064,   4023,  -8318,  -7309,   -160,   3780,   2281,   -354,  -2427,   7302,  -4158,  -7103,    346, -10113,  -4173,   5094,   7798,   5728,   2189,  -7458,   -192,   1442,   1160,   1648,  -1630,  -1464,   -794,    476,   2254,  -1284,  -5419,  -1118,   -541,  -4483,   3807,  -5143, -15232,   8146,   -349,  -1226,   -747,  -1340,  -4803,   2809,  -3123,   4976,  -4722,    600,   2772,  -1462,  -1090,  -2182,  -7661,  -4431,   -324,   2555,  -6645,  -4829,  -5214,   1760,  -7618,  -8002,   -157,  -2272,  -5337,  -8865,  -2929,   1705,    181,   -466,  -2901,  -1109,    556,   7681,   2532,  -4649,  -9663,  -2646,  -2704,    555,   5522,   -824,  -3669,  -3765,  -1326,   2563,   5204,   -740,     28,  -1561,   5619,   -606,     73,   -764,  -4355,   6540,  -7013,   3811,  -6306,    907,   2844,     36,  -1166,  10811,  -2841,  -1014,  -6424,  -1185,   1042,   5336,  -3198,  -3068,   5223,   1918,  -6664,  -6258,   5915,   -103,   4905,   3292,    876,   1628,   3672,   3328,  -1275,  -5003,  -3759,  -6668,    672,   1528, -11581,  -3811,  -3276,   9888,   5776,  -2743,  -3563,   7373, -13743,   7797,   -534,   3727,  -4344,   4063,   2248,  -3714,    -14,   3635,   7028,  -1702,  -5661,   -639,   6254,    439,  -4912,  -1580,  -5462,    564,  -1667,   1723,   3496,   4434,  -4825,   4785,  -4347,  -1982,  -9534,   5455,  -7206,  -1948,   2099,   2481,    762,   2864,   4362,    -67,  -2911,   2181,  -9033,   3813,    311,  -2208,   -733,    588,  -4302,   5035,   -154,   -692,    798,  -2583,   1097,    303,   4038,   3279, -13255,   -765,  -1997,   -336,  -6550,   2506,   6306,  -5687,   9784,  -5704,  -1713,  11392,   8815,   5465,   -700,  -7031,   3292,   3010,  -8841,    748,  -9053,  -3475,   5279,   1484,   -546,   -995,  -4787,   1904,  -5114,   1574,   7604,  -7086,  -5791,   4375, -10639,   1020,  -3238,   2754,   4244,  -5356,    535,  -6928,  -6053,    911,   1450,   4068,    365,   7958,  -4169,   -981,    -26,  -2168,    386,   1869,  -1724,  -8769,   1019,   5569,   7608,  -2525,   1703,   3339,    990,  -2148,  -3311,   1864,  -7976,   8715,  -1531,   1866,  -2129,  -2624,   2463,   2268,   4479,   4318,  -8582,   3019,  -3162, -11945,  -4481,    255,   1032,    168,  -1618,  -5226,   7554,   3755,   1179,   -422,   3271,    429,   1716,   -390,    597,   -477,  -2900,    373,   8815,    288,   1870,   -729,  -2597,   2303,    911,   4363,   5418,   -280,    541,  -5544,  -7170,   2068,   4471, -11420,   2557,    905,   1460,     38,   -321,  -3976, -12216,  -9063,   2420,  -7994,  -3956,   5181,  -3199,  -2681,   -528,   4452,    486,   6915,
          7175,   4363,  -3058,  -6635,    881,   6274,  13727,  -7969,   2852,  -3580,   -533,  -3902,  -3978,  -5923,   8418,  -3249,  -4393,   6960,   3498,   9348,   6989,   -633,  -4706,    -68,  -4085,  -1579,   -213,   -266,   4389,   -352,  -6941,   2398,   1870,   -485,  -4472,   -585,  -2686, -12835,  -9054,   5429,   1363,   -113,   6481,   5555,  13174,    687,   8210,   3451,  -3690,  -9104,   1615,   7312,   7701,  10565,  -3684,    635,   2218,   3887,   3266,  -4091,  -3143,  -4805,   5945,  -2540,     79,  -3049,  -8108,    896,    555,   3595,  -8885,   4773,    855,   -119,  -3480,   5928,   2831,  -1366,  -1012,  -6668,   4441,   2109,   1532,   2370,   -559,   1266,  -3167,  -1391,   1931,  -7080,  -9458,  -2764,  -4029,  -4186,  14235,  -3924,    718, -12909,   2184,  12663,   3813,  -1452,  -7031,   -847,   4709,   6649,  11385,  -4851,   4221,  -5788,   3834,   2387,    472,   1241,  -9655,  -3634,  -3594,  -5250,   1650,  -4655,   4776,   3419,   1793,   2021,   2441,    782,   1079,     77,  13003,  -2723,  -9462,   -457,  -7556,   2158,   2915,  -1156,  -1189,   -835,   2479,   3801,   1337,   3973,   2732,  -1564,  -7012,   8858,  -2723,   4122,   9686,   3149,   6785,   1865,  12056,  -2999,  11934,  -1579,  -4337,  -1124,   7345,  -2625,   1714,    385, -14686,   1138,   1068,   8440,  -3110,    -78,  -8934,   -807,  11575,   5480,   3779,   -172,    734,   -483,   1325, -10618,   -603,   5679,   9365,  -1200,   9341,  -1312,   -672,   1718,  11120,   -216,  -4995,   -165,  -6778,  -1097,   2876,  -1835,  13286,    -52,  10883,   3869,  -9685,   4290,  -2463,   5313,   1687,   6110,  -7393,   2156,  -2853,   -343,  -1209,   -142,  -2421,   1521,  -1656,  -1865,   2975,    291,   2571,   2573,  -8716,   5548,  12439,   1914,  -7557,  -4739,  -8938,   2339, -13416,  -1156,   -125,   -871,  -2610,    724,   8753,  -5619,   4210,  -5051,    330,  -4638,    686,  -4418,  15672,   3836,   -834,  -9487,   1787,  -6198,   2683,  -2184,   -302,   -849,  -8876,   1684,   1113, -10989,    248,  -1967,  -4793,   5990,  -7838,   -834,   4347,   4901,   3384,  -4781,  -9197,   4421,    565,   2064,  -8596,   2816,  -1125,  -2788,  -3530,  -6562,   3865,  -3430,  -4840,  -1912,  -3052,   -230,   6913,   -399,  -7700,   8372,   3348, -22631,  -6695,  -8871,   5317,   1832,   5544,  -4948,  -2314,   3637,    934,  -6648,  -9960,   4958,   2979,  -9755,  11724,  -4087,   -214,  -1879,  -6597,   2586,   -877,  -4101,  -3002,  -1360,   2916,  -1888,  -9751,   -795,   3794, -10135,  -1480,  -6048,   1981,  -2180,   3176,   6076,  -8426,   8942,  -3636,   1365,    608,   1434,   9519,    294,    -72,  -1332,   4748,   5816, -11270,   3829,  -2034,   -647,   -305,  -2661,    580,  -1146,  -2083,    374,   1979,  -6298,   2458,   5765,  -3160,  -2485,  -5506,   -882,  -9351,  -1696,   7994,   1001,  -2374,  -2324,   6388,  -1807,  -2876,  -5297,   4732,   5154,  -1948,   1460,  -3558,     99,  -1957,   -169, -10442,  -6020,   2214,    588,   1333,  -1737,    734, -11162,  -5736,   7473,   1481,  -1278,  -8055,  -3393,  -9512, -10132, -16997,    975,    525,   8680,   6997,    190,  -5894,    553,   5439,   2582,  -9418,   2651,  -2551,  -2445,  -6088,  -2041, -11851,   4576,  -1394,  -9773,  -9354,   2384,   5113,   1386, -11470, -12407,   2462,   -348,   1182,  -4553,  -7945,   2428,  -3133,  -3384,  -6857,  -7089,  -2343,   3012,  -9492,  -3834,  -3395,   4534,   -772,   6781,   7086,    176,  -1297,   6726,  -2332,   2821,  -2045,   2227,   1867,   4815,  -2429,   8068,   5524,  -3998,   5108,  -4803,   3426,    995, -12200,    787,  11048,   1338,  -3851,   5783,   9821,  -4797,   3038,  -4595,   7261,  -4962,   5336,  -6141,   1645,   1936,   -890,   1427,   -293,  -4257,  -9353,  -2120,   2429,   -756,  -4533,   6656,   5625,   1922,   8699, -11489,  -1792,   5172,  -5723,  -4749,  -5244,   4861,  -2555,   2265,   4523,   1941,  -1397,   3007,  -5578,  -5043,  -2260,    315,   4034,   -725,  -2982,   2261,   -497,    589,  -3895,   -633,  -5967,  -5562,  -1164,    746,    960,  -5994,  -3184,   6088,    238,   2225,
          2098,   -578,   3516,   7137,  13066,  -3255,    404,  -5094,   5006,  10296,   6833,   -488,   1078,   3096,   8257,   1677,     31,  -9646,   7187,   4392,  -3145,   4723,  -1637,   -846,  -2854,   4218,  -1222, -13105,   5917,     27,   2327,   2197,    596,   6812,    602,   -799,   2610,   4637,   3652,    706,   2648, -10672,  -2389,  -3457,   8627,   1437,  -5774,  -3499,  -3595,   4833,   4129,  11637,   2342,  -2792,   2602,  -2913,   2237,   2319,  -4815,   5850,    966,  -2888,   1449,  -4049,   4096,   -957,  -1319, -17863,  -2746,   4168,   4252,   3540,  -9517,   -327,   1145,  -1383,   -962,    805,   -188,   7354,   4553,   3702,   1736,   5159,  -1623,   8144,    188, -15228,   9965, -15773,   6940,   2198,   8722,  -3883,  -6777,  -6028,   1891,   1938,  -1091,   2190,   1935,   4509,   7364,  -4673,   2388,  -9091,  -1599,   2635,  -2241,    894,  -7307,   2192,  -1141,   2086,   -594,   -515,   2848,   -794,  -5881,   4134,  -6868,  -4561,   3508,     37,   8538,  -4197,   2341,  -3319,   5360, -13454,   5910,   6889,  -6359,  -3539, -16456,   9689,  -3948,  -2347,  -2495,    916,   4279,   6357,  -1050,  -1358,  -1573,    592,   -718,   6907,  -1511,  -2588,   -160,   3370,   2184,  -2184,    665,  -7492,   6046, -20266,  -6369,   6117,   3687,   8512,  -5926,  -1927,  -6021,  -4409,   4084,  -3831,    794,  -4255,   7289,  -6266,  -7546,   2010,     -6,   -452,  -4366, -10948,   8597,   7961,   4293,   1425,  -4493,    827,  -2707,  -5520,  -4507,   7879,   4148,    868,   7058,   2822,    217,   4514,  -1418,   4611,   8527,   3448,   2358,   4943,  13307,  -1114, -17518,  -1175,   2724,  -3187,   4160,   5359,   1453,   2900,   1128,   1280,    985,   1251,   -434,  -2635,  -7463,   1447,  -2112,  -4488, -11692,  -6055,   2623,  -9110,   -830,    598,   -565,  -8085,   2146,    844,   1420,    992,   2196,  -4059,   6925,  -3410,  -2908,   2470,  -2200,  -3646,     79,   -222,  -1172,  -1224,   -774,   3029,  -3741,   5142,  -2122,  -4899,   1814,  -2391,  -4309,  -7229,  -2811,   2011,    682,   -838,  -5914,   1487,   -827,   1512,   -691,  12911,   5255,  -3702,   4040,    257,   1780,    170,   8748,   2141,    596,  -2657,  -5261,   2661,   3589,   5418,  -1217,   7262,  -1033, -12507,    845,  10235,   4528,   -264,   1751,   4494,   4336,   -846,   5369,  -1098,   4555,  -3784,   -405,  -8585,     69,   1166,    202,  -4737,   6235,  -8577,   8122,   2461,   4100,    438,   -578,   3757,  -2081,   6991,   6053,   9686,   4557,   1128,   2077,    -21,  -4768,  -1289,  -1916,   2857,   -627,  -3436,   1216,   1428,  -4603,    112,    709,  -2864,   2539,  -1721,   2498,  -1037,   9773,   2787,   3333,   5196,   2434,  -2103,   2287,   3497,  -8523,   1323,   3824,  -5600,  -3280,   7425,  -3015,   -213,   4147,   2289,   3794,   2582,  -2677,    925,  -1399,  -8534,   1345,  -6665,  -5675,   7691,   2187,   1373,  -2077, -10460,    363,    177,   2643,  11753,   1786,   2536,  -3490, -11191,   3512,  -2692,   2559,  -9150,     69,   4126, -11504,   1385,  -1977,   5768,  -4866,  -3732,   4509,  -2513,  -5048,  -5322,   1758,   4737,   1542,   8121,  -1687,  -4816,  -4990,    343,  -2510,   2269,   6230,  -4439,  -1716,  -1540,  -6023,  -6199,   5820,   2662,    792,   4610,   -968,  -1560,  -3291,  -1562,   6012,   1218,  10101,   4005,  -3300,   6019,  -2793,  -4238,  -1262,   8660,   3411,   5713,    944,   3917,  -1099,  -4336,  10059,  -3943,  -1138,   2094,   2565,   6348,  -1260,   8326,  -4031,  -2206,  -8643,   6203,  -4437,  -3774,  -2091,  -4258,    211,   2228,  -6044,  -1891,    438,  -7242,  -4458,    768,  -4367,   3121,  -7818,  15383,   -513,  -2485,   3809,  -7998,    784,   3567,     -3,  -3840,  -2852,   1350,    491,   5302,  -1320,   3034,  -4345,  -5443,   7927,   4757,   1554,   1585,   2309,   3590,   -207,  -2329,    609,  -6044,     57,  -6147,   -402,  -3070,  -1902,   4616,   5105,  -5921,   4846,   3842,   2091,   1317,  -1637,   3665,   6398,   8381,  -1447,  -2471,   2937,   -985,   4243,  -3370,  -6032,   7983,  -2299,   1547,  -2330,   -933,   3115,   4068};

    const static Filter<int16_t> l3_a_compress_filter(l3_a_compress_filter_element, -23, {1, 1, 64, 64}, {1, 1});
    const Filter<int16_t> *get_l3_a_compress_filter()
    {
    	return &l3_a_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l3_a_compress_bias_element[] = {
           216,  -1574,    518,    725,   -113,   3840,   2126,   -403,   2585,    873,  -1265,   1800,   1399,   2760,  -1127,   1811,   1750,  -3172,   2378,    -57,    518,   -101,    101,   3779,  -1849,   3651,  -1541,   2290,   -934,   -252,  -1079,    213,   1856,    -60,   -876,    -51,  -1547,  -2829,   -371,  -2101,   2121,  -2422,   -216,   1841,   3027,    242,   1072,  -1474,   3295,   -101,    586,  -1383,   -526,   1475,    377,    424,  -1381,   1694,   2347,   1726,  -2005,    972,  -1005,  -1456};

    const static Bias<int16_t> l3_a_compress_bias(l3_a_compress_bias_element, -12, {64,});
    const Bias<int16_t> *get_l3_a_compress_bias()
    {
    	return &l3_a_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l3_b_depth_filter_element[] = {
          6583,  -8431,   -510,  -5443,  -5628,   -608, -10144,  -2165,   -261,  -1781,   6963, -10390,   9360,   1687,  10816,  -5733, -16272,   3553,  -1723,  -4201,   7054,   5766,  -6769,  -7861,   1066, -13915,  -1115,   5891, -10234,   -667,   -872,   5740,  -1404, -16582,  -5910,    706,   1146,  -7507,  -3973,   4407,  -6751,  -6755,  -9424,  -1203,    348,   6885,  -1899,  12563,  -4197,   5713,  -9970,   4963,  11135,   4129,  14875,   7078,    353, -15972,   5779,  12004,  -1783,  -2377,  -4810,  -3576,  -6344,  -3792,   4048,   6531,   1167,   5434,  10951,   5586,    336,   -243,   3494,  -9431,  -2351,  -2298,   9380,   3551,   1912,    369,   8657,  -7227,  10328,   7815,  -6563,   3120,   6023, -10126,  10899,   5598, -12673,  -9489,   4597,   4653,   7450,  -2060,   -908,  -8459,    649,   5309, -10925, -16563,   6103,   4496,   -283,   3850,  -6522,   3557,     15,     45,   1678,  20470,   1024,    461,   2391,  -5594,  -1872,   8113,  -6289,  -1676,  -2629,  13706,   -797,  -8638,  -5336,  11193,  -5166,   -246,   1671,   3476,   4276,  13180,   1110,   2189,  12353, -15518,   1114,  -3638,  -5869,  -5642,  -1775,  -5750,   1516,   6730,   -970,   2315,   -503,   2787,  -6793,  21521,   -522,   4224,   3514,   1457, -10872,   4476,  -2013,   7919, -14208,   5084,  -6490,   1375,     92,  -1730,  11902,   -322,    904,  -7928,   9412,   6512,  -1286,   1524,  -3201,  -3230,   6038,   8118,   6761,   1207,  13403,  -8236,   6134,   6695,   1610,   2585,   6962,   3019,   3908,   5104,  -8682,  -2816,   1483,  11680,  11138, -14160,  -3352,  10176,   -760,  -7668,   1676,   5508,   6970, -20237,  17934, -12718,   7885,   3287,   8314,  11310,  12406,  -2197,  -4989,   3161,   4393,  -4307,  -5100,   2362,   1833,   5061, -11613,   -556,  -3661,  -1095,  12701,   7212,    463,  -7797,   1882,   8615,   1660, -12327,  11700,  -3279,   1085,  12893,   3622,   6658,  -7716,  11241,   2013,   1463,   2180,   9733,  -2684,   5020,  -3819,  -1046,   8676,   5424,   2071,  -1603,   -991,   1363,   1021,   4526,  -4484,     -4,   1577,  -4022,  -4944,   1148,  -6618, -13217,   1178, -17990,   2606,  19039,  -7824,   1370,   3581,   4738,   4355, -10272,   1248,  -2986,    183, -12645,  11490,  -7073,   3056, -24338,    561,   2980,   -248,   6789,  -3881,   5771,  -5481,  -7199,  11060,   2063,  -2754,  -2298, -20228, -18600, -12361,  11769,   2255,  -1558,  18779,   2172,  -4879, -10488,  -4068,  -7982,  -2515,  -7246, -11603, -11683,   4967,   3688,   -957,   3213,  -3763,   5912,      2,  14409,  -2614,   6074,   1386,  -1490,   1940,  -3013,   3358,     50,   -254,    140,  -1384,   8285,   6628,   6783,   -726,   -211,   1323,    370,   1665,  11905,   2189,  -1611,  -4429,  -3441,   8906,   8839, -16182,  -6755,  11441,   9100,   4557,    992,   8435,   8136,   4008,   5404,   4352,   2294,   -656,  -3920,  -7856,   1847,   2119,  -6208, -16640,  -2921,  -1080,  -8677, -13117, -11371,   4238,  -7894,  -2471,  15402,    823,   1301,  -7196,   2389,  -4500,   6276,   7378,  -1620,   1229,   1276,   3214,   2241,   9587,  -2267,  -5389,    653,   -708,  -7343,   3699,   6094,   1233,    649,   -613,   5625,  12188,  -7041,   -894,   4582,   3730,   4925,  -6773,   2510,  -3089,  -3833,  -2254,  -3184,   5674,   3764,  -1818,   2431, -11451, -11551, -11868,   8095,    543,  -9227,   1202,   1383,  20389,   -823,   9705,   3500,   3719,   -188,   1688,   2077,  -4417,    159,  -1678,  -5596,   -136,   5600,   8027,   1535,   6986,  -4851,  -5526,   -584,    471,   -711,   2413,  -4140,   3177, -14953,  -8213,   9053,  -6459,   5186,  -3602, -11566,  -4852,   5265,   8076,   9235,   -927,   6238,  -9265,   -962,   6197,  14204,   7851,   6922,  13942,  -5544,  -6065,  -7931,    508,   3723,    812,  -2082,  11843, -10108,   5463,   -239,   5001,   6789,   1911,   9892,   4507,   9973,  -8085,   3744,   2907,  -9164,   7010,   -197,   2461,  -5024,  -4097, -20437,   -910,   3944,   3981,   2203,   4785,   2643,  -8595,  -3283,   8439,  -2393,  -1380,   3695,   -918,   4176,   4180,  -1652,  -1322,   3427,   2683,   2000,
         -6838,  11628,  -8993,  17856,  -3841,  -1970,   2516,  12186,  19183,  -8438,  -5809,  -7756, -13869,  10115,   7838,   2074,   1920,    652,  -2707,   3725,   1157,   2657,  -2591,   3091,   9646,   6262,  -3568,   6546,  -2554,  -1236,  -6121,  -5576,   4159,  -7727,   4203,  -1341,  -4835,    466,  -3243,   -640,   1652,  -1779,  -2714,   8866,  -8441,    731,   -819,  -5511,   -455,  -5232,  12009,  15619,   7764,  -4129,  -3184,   6684,  -8086,  16913,   -510,   6540,  -4376,  -8173,   1325,  11769};

    const static Filter<int16_t> l3_b_depth_filter(l3_b_depth_filter_element, -14, {3, 3, 64, 1}, {1, 1});
    const Filter<int16_t> *get_l3_b_depth_filter()
    {
    	return &l3_b_depth_filter;
    }

    const static Activation<int16_t> l3_b_depth_activation(ReLU);
    const Activation<int16_t> *get_l3_b_depth_activation()
    {
    	return &l3_b_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l3_b_compress_filter_element[] = {
          1778,  -1186,   2312,  -2446,  -3373,   1314,  -8440,   2642,   2769,   4766,  14310,   -743,   3183,   3450,  -1683,  -1761,  10115,   3111,   4506,   7455,  -3389,   1358,   -118,  -1490,  -2063,   5766,    535,   3739,   5280,  -1139,   -502,    809,  -3270,   7908,   5491,  -5700,   4477,   2434,  -1600,  -7939,    -26,  -3604,   -110,  -1987,  -1060,  -1461,   -609,  -2200,  -6140,  -6816,   9624,   1730,   7852,   3648,  -2441,   1787,   3344,   -525,   1984,  -9067,  -4020,    916,    764,   3800,   5066,  -3620,    -31,  -6390,   3937,   9587,  -3025,  -1199,   8639,    156,  -1257,   4622,  -7897,   3902,   4396,   1283,    285,    943,   7071,    879,   2520,  -1165,  -2671,  -7451,   5404,  -1013,   7280,  11664,  -1783,   7722,  -1080,    110,   1395,   7352,   4319,   6318,   -661,   2196,  -2370,    768,   9044,   1288,   7992,   6007,  -8124,  -3198,   1324,   3760,  -5045,  -4725,   5950,   2928,   5986,   5182,   2421,  -2042,   2503,   2957,  -9101,    459,  -3989,  -2792,   4452,  -1401,  -2424,  -1391,  -3250,   1094,   -753,   1566,   3143,  -7351,   9984,    332,  -3987,  -6171,   2483,   1113,  -6850,  -6974,   5529,    172,   1336,    -78,  -5267, -14026,    890,  -3037,   1745,  -7992,   6722,   2275,   -413,  -2681,   1062,    618,    554,  -1703,  -2673,  10921,   1338,   3836,  -4274,  -2340,   3408,   8017,    598,    884,   7686,   4658,  -3533,  -7284,  -6187,  -4630,  -5441,  -4525,   1312,     79,  -3223,  -3473,  -2433,  -3252,   9198,   5814,   2157,  -8502,  -4139,   -884,  -2547,   2341,   1016,   1397,  -1066,   -696,  -5852,  -2773,  -5978, -10030,  -1676,   1342,   1593,   5097,   4365,  -6996,  -1187,    542,   -367,    567,   1217,  -1023,   -556,   1443,    474,    283,  -9554,   1497,   2662,  -1775,  -3310,   6272,  -4820,  -1982,    212,   4821,   -846,   2986,   1708,  -1629,  -3023,   3603,   7306,   2016,   6154,  -2665,  -1088,    153,   1103,  12458,   9289,    586,    -96,  -2074,  -2876,   2457,   6346,   1975,   3852,   2935,   2893,  -4372,   6824,    604,   9626,  -1669,   1790,  -2993,    517,   -823,  -1609,    324,   3652,   6057,  12178,  10387,  10693,   5379,    843,  -3333,  -2373,   2440,  -8825,   2957,  -1419,    403,  -1254,  -2022,  -6584,  -2175,     16,  -1837,  -1903,  -1128,   -623,  -7325,   1781,  -1865,   6211,   -716,  -5952,  -3015,  -1165,  -2577,   2714,  -1016,   4258,   2862,   -878,    853,   1738,  -2609,  -6176,   8306,  -1814,   2740,  -3408,   -726,   2247,  -1965,   -545, -10858,   6020,  -3212,   4449,   6212,  -4384,  -3471,   3158,  -2044,  -1281,   3398,  -8338,  -6659,   -859,  -3887,   1128,  -9964,   2216,  -4300,  -4777,  -4424,    747,  -3296,   1819,  -2674,  -6154, -10529,   1363,  -3203,  -2372,    -16,  -9080,  -5644,  -1930,  -2997,  -1760,  -2163,  -7512,    614,  -1200,  -2185,   9404,    403,   1273,   5509,  -1299,   6655,  -5385,    901,   7589,   9603,  -1537,   -537,   1977, -10913,    203,    668,   2559,  14257,  -5905,  -4316,   2094,  -1538,  -2241,   2034,  -1244,   7125,   -414,   6099,  -4223,  -2738,  -9299,  -3964,   3674,  -2130,   1185,   7181,  -2979,  -4017,   2194,  -1181,  -3430,   4952,   -635,   -296,   4866,  -2744,  -8018,   -152,   5531,  -5485,   4407,   3017,   1740,  -9203,   2913,  -8403,   -505,   5025,  -3964,     55,  -3297,   4307,  -4946,   -319,    618,  -1834,   4583,   5426,   2372,  -5395,   2391,  -3701,   4427,  -3534,  -4271,  -2423,  -7866,  -4556,   3015,  -1411,  -1696,  -2531,   1694,   -771,  -3433,   2445,   2352,   -153,   -138,   2205,  -2544,   2079,  -2337,   4582,   9730,   2542,  -1626,   2693,  -5764,  -8126, -12766,    -18,   4344,   1204,  -3047,  -4612,    316,   6541,   3497,   -416,   1387,   1557,    266,   4779,  -2482,  -8956,  -1712,  -1147,   2082,  -5382,   1346,  -4931,  -8139,  -3270,   1987,   4899,  12807,   3409,    737,  -2497,  -9512,  -1422,  -4351,   -219,   3433,    334,   1528,   3071,   2952,  -4653,   -697,  -1462,   1835,   2068,     60,    369,  -2691,  -2135,   -636,   -219,  -2002,   1460,   1139,   1019,   3157,  -5436,  -2935,   -174,
         -5054,   -477,   6029,    918,  -1088,  -2768,   5798,  -1859,  11544,   1993,  -5981, -11567,  -1103,   1980,   -386,  -2477,   2634,   4490,   3319,    679,  -5326,    432,  -3240,   3809,  -3068,  -8234,  -1827,   4131,   5365,  -7413, -13010,   3904,   1630,   -459,   3883,  -6842,   9849,   1173,  -5008,  -3144,  -5711,   2053,   -206,  -6234,   1958,   3064,   3327,   -440, -11183,  12998,   8350,   -727,   -732,  -4079, -10386,   2224,   7835,  -1447,  -4696,  -2106,  -4806,  -2448,  -2415,   -427,  -1818,   2597,    140,  10642,   3283,   7411,   9647,  -1383,   3734,    348,   3106,   3371,  -9157, -10749,  -4029,  10754,   2683,  -1281,    365,  -8098,   1029,   2696,   7152,  -2891,   1386,   2052,   3056,  -1147,  -1580,   1027,  -2765,   5684,   8259,   4446,   6439,   -325,  -5343,  -2924,   5467,   1434,   7151,  -8720,   1707,   -871,  -6985,  -2479,   6527,   2625,   7531,   -397,   8760,   2956,  -2272,  -9720,   3586,   2634,   4603,   8103,  -2891,  -9296,  -2867,  -3308,  -4560,  -1895,   6897,  -2801,  -7024,  -1220,  -9199,  -7545,  -1160,  -4745,   9915,   4856,  -9914,   1343,   1096,   8303,   3306,   6545,   7994,  -6068,  -1565,   3198,  -3648,   3762,   4466,  -3783,    810,   9632,  -2186,   6549,    802,   1031,  -7804,   4593,   3981,  -2841,   6973,   9100, -10885,   3623,   2652,   4864,   1675,  -2890,  -3083,  -4080,   2567,   4848,  -5011,   3243,  -2358,  -3473,   1706,   2387,   2289,   3863,  -4621,   6080,  -4173,   3972,   2141,   8700,  -4236,  -2490,   6013,  -1154,  -1859,  -4429,  -2804,  -5250,   3589,   1061,   -273,   5691,   -198,   3340, -13523,  -2882,   4182,   1445,   5218,   3270,    248,   -873,   1407,   1922,     57,  -1272,   -196,    331,  -3869,    103,  -9702,   3178,    383,   3122,   1587,   2436,  -7214,  -2102,   6281,  -1907,  -2953,  -3190,  -4022,   2418,   1292,  -4986,   -825,  -2965,  -4819,  -1068,   1951,   -486,   4576,  -3960,   1707,    -72,  -6066,   3560,  -5641,  -1676,  -1381,   5218,   7448,  -3945, -11328,  -1988,   4156,  -2448,    572,  -8548,   4248,  -9054,    417,   1007,   -262,   2547,  -1466,  -1052,  -2221, -10349,  -1542,  -3083,  -2243,  -6819,  -1887,  -6548,   3635,  -7430,  -4528,   7111,  -3765,   1843,   2179,    298,  -1645,  -5831,  -1039,  -5934,   9890,   2173,    175,   -879,   3703, -17909,   8926,  -5794,  -3351,   3134,    767,  -5059,  -5686,  -5304,   5895,    785,  -4068,   2720,   5200,  -5670,    973,    577,  -1939,   2197,   -373,  -1433,   2696,   8228,   5799,   1345,   2328,   8341,    842,   2862,   4347,  -3207,    981,  -3647,  -3359,   1199,  -3103,  -3700,  -5009,   6179,    182, -11611,   1734,  -5062,    601,   -560,  -9799,  -4749,   9014,  10312,   5461,  -4229,  -3019,   3147,    -62,    866,   1966,   2157,    106,   -182,  -2956,   3256,  -1971,   5381,  10268,  -4354,  -1207,  -4589,   4565,  -3953,  -1731,   5738,   3418,  -3896,  -2162,  -6300,   2097,  -3790,   1679,  -3057,   8027,  -5192,  -2530,  -4806,  -2913,   9900,   7548,  -1009,   -241,   3785,   -818,   1565,   7675,   1029,   8774,   3439,   2588,   8663,  -2124,   4442,  -2402,  -2432,  -1793,  -5906,   4830,  -8889,   2205,     40,   -881,   5213,  -6852,    291,  -1275,   4539,   1922,   8403,  -2443,   -975,  11967,  -6212,   7725,  -3037,  -1480,   4780,   -535,    643,   4182,  -6558,    -84,   5909,  -7176,   -826,  -2487,   5035,  13560,  -2454,  -5931,  15785,   -624,    226,   7101,   4985,   -366,   -875,  -2068,   4581,   5678,   9997,  -1217,  -3025,  -7277,   4360,   7330,  12623,  -1486,    269,   3126,   3990,   4943,   2473,   2887,   7571, -11001,   4899,  -6482,   4710,  -5793,  -2735, -10943,   -141, -11590,   5622,  -7320,   -714,   7357,  -2098,   2109, -13062,  -5254,   1632,  -7605,   7988,  -4102,  10644,  12354,  -1501,    561,  -1069, -14411,   4538,   5587,  -1920,    750,  -3441,  -3367,   4323,   2396,   4523,  -6607,   8061,   8193,   -911,  -4242,   -784,  -1438,   2021,  -3113,    133,   3099,   -503,  -1372,   4192,   2922,   3053,  -4362,   9646,   -856, -10185,  -9429,  -1318,  -4394,  -1773,
         -5595,  -7509,   1469,    -78,   1553,  -6071,   4840,   4565,   3893,  -3367,   4362,   7858,   5858,   1542,  -1704,   1141,   3319,  -6052,   1734,   6042,  -4480,   3039,  -2100,  -1518,  -2535,  -8318,   2425,  -2279,   6493,  -4156,   2988,  -3016,  -5242,   1692,   2393,  -4500,  -2033,  -1026,   -337,  -2744,  -1253,  -3277,   1374,   -497,   -379,  -1490,    699,   6726,  -2795,  -4493,   1186,    235,   4647,   2730,    -50,  -5714,   4327,    195,   -545,  -3594,  -2900,  -8856,   8637,   4290,   3323,   2649,   2839,   4228,  -6983,  -6288,  -5492,  -3719,   4991,  -7823,   -403,   3269,   3100,  -1415,     15,  16446,  -5370,  -1897,    884,  -4509,  -1623,  -3622,  -4097,  -1411,    216,   -449,  -3543,  -3252,  -2871,   8427,  -7378,   5827,  -5135,  -6624,   4618,   4984,   4070,  -3171,  -3806,    117,  -1480,  -5914,   2229,   5872,   -927,  -2017,  -6986,   -992,  -1958,  -5973,   1797,  -2506,   1977,   2498,   3052,   1433,  -1939,  -5538,   -344,   4098,  -2287,  -2783,   -173,   6518,   2069,   3932,  -1160,   5687,   2858,   4255,   -612,  -2691,   5850,  -2106,  -1059,    707,  -5915,   2957,   4296,    870,   3432,  -6093,  -6828,  -2129,  -4856,  -1402,     58,  11047,  -4266,   6274,   2528,    464,   -286,  -1510,  -2259,  -5485,   4222,   1587,   1479,   6248,   -573,   7804,  -7681,  -4835,    196,  -6919,  -4333,   5360,   4781,  -5037,   -434,   -969,   3325,   4036,  -3047,  -9008,   4262,  -4615,   -846,   8065, -14886,  -8912,   5200,   4825,   2840,  -7199,  -5587,  -1054,   6213,   3792,  -2713, -10766,  -9849,  -7254,   3662,   4493,  -4009,    778,   2789,   5305,   1526,   3305,   -432,  -5885,  -1329,   2418,  -3018,   -491,  -3065,   1314,   1073,  -1187,   8532,   4176,   8786,   4064,  -7062,  -1397,   3375,   4077,   2159,   1093,  -8222,   3254,   3847,   -272,   4443,   2496,   1732,   2653,    697,   1442,  -5014, -14042,  -5405,  -2541,  -1072,  -2738,  -1535,   2773,  -2384,  -2197,   7340,   1379,  -5236,  -3490,    282,   6493,    741,  -9602,  -4671,  -4129,   2368,   7442,   2428,   3690,  -1524,   1416,    504,   5172, -10837,  -2619,  -5063,   1836,   3353,   4965,  -5886,   3125,  -2069,   7882, -10202,    591,  -2714,  -7479,   2304,   2882,  -1312,   3982,  -2014,   3069,  -3187,   7099,  -1436,   2557,  -3905,   5501,  -5016,    769,   2038,  -1815,  -7692,     12,   5977,  -5606,  -8963,  -1067,  -8808,  -2830,  -1387,    291,    698,   1034,   1167,  -5084,   2345,  11228,  -7949, -11278,  -2909,  -7784,    841,  -9780,   3237,   8983,  -9007,   -718,   1774,  -4413,  -3500,   2349,  -4363,  -2125,   -930,   6174,   1679,   1647,   1625,   3168,  -6987,   1612,  -4557,   2441,  -2101,  -6169,    779,  -5336,   5941,  -3641,  -1407,   4618,   5421,   2999,    236,  -3918,  -3584,   1501,  -1159,   4330,   7573,  -7213,   4556,  10252,    525,   1663,  -1341,    929,   4044,  -3614,  -7039,   3816,  -4518,   -453,   2051,   2228,  -3107,  -2661,   6659,  -2316,   1982,   1897,  -2915,   -800,   6102, -13826,  -4577,  -3876,  -1193,   2352,  -5044,     74,  -4288,   5920,    632,   5707,      6,  -2381,  -3590,   5021,   6337,  -1931,   2154,   3950,   3761,  -2157,  11996,  -2770,  -2147,    761,  -5313,   4484,   3009,  -5963,  -5354,   2691,   3273,  -8595,  -1924,  -5477,   -496,   5390,  -6552,  -1388,   3902,  -2901,   -872,  -1042,   5498,   -215,   2020,   5560,   8554,   2974,   1605,  -8847,  -5150,  -2907,   2024,   1539,   1680,  -5571,   2224,  -6350,   -690,  -4705,   -829,  -7181,  -6468,   6116,  -4456,    420,   1941,   -876,  -1787,     35,   2863,  -3167,   2516,  -3551,  -1423,   2807,  -1114,   4014,   -308,  -8985,  -2283,   2274,   6557,   -584,   -907,   4479,   1079,  -4478,   3007,    260,  -3514,   1337,   5864,   1100,    430,   1493,   3738,   1111,  -2656,   9029,   2936,   -469,   7380,  -3465,   7066,   1627,  -1468,   4917,    391,  -1635,   3496,   3988,    306,  -2582,  -6362,  -1369,  -1081,  -1060,   2592,    896,    330,   -838,  -1159,  -4245,   3922,   1576,  -8764,  -1291,   1877,  -3505,  -1106,   5271,   2325, -10996,
          2705,   1897,   -114,  13754,  -1996,   -911,  13173,   -482,  13906,   2995,   1616,  -5082,  -5744,  -1410,    171,  -5305,  -5485,   4917,   2093,  -3603,    143,   -980,   6720,  -4647,   7628,     41,   1502,    223,  -2509,   6280,   2654,   9561,  -1831,   -689,  -2786,  -2052,   2419,   4659,  13553,  -2454,  12665,   5816,   2075,   6372,   5410,   -993,   2461,   -133,   -732,  -5179, -10089,  -9663,   8071,  -1026,   2047,    577,   2793,   5109,   7310,   4324,   1515,  -2602,    895,  -4792,  -2654,   2357,    -18,  -1329,  -4535,   -320,   -493,   5317,   6045,   6310,    662,   6168,   7268, -11523,   1588,  -7159,   5322,    418,  -1808,  -5379,   3806,   1817,  -5331,   5097,  -7546,  -6519,  -6171,  -3749,    853,  -9283,  -2857,  -7551,   2592,   5323,  -2092,  -8233,   9879,  -3003,    217,   6601,  -1823,  -6907,   4297,    166,   2851,   -730,   7115,   1075,  -2470,  -3987,  -6837,  -2854,   1558,  -6802,  -2851,  -3114,   7737,  -2962,   1444,   7020,   2621, -10930,  -2264,  -3784,  -3920,   1008,  -9966,   -526,   1318,  -8856,   7079,   -663,  -3947,   3294,   5167,  -2938,  -6520,  -2844,   -828,   5686,  -3865,  -1858,   4520,  -3489,   7680,   -739,  -5983,  -1855,  -1758,    868,  -5161,  -3799,  -1824,  -3105,   5967,  -3690,   -181,  -2167,  -1533,  -5575,  -7003,   2633,   2792,  -5745,   4104,  -3142,  11050,   3252,   3905,   2165,  -3279,    826,   8598,   3424,  -2680,  -3016,  -8264,  -6773,  -7280,  -3616,   3558,  -2457,   -680,  -5620, -12266,   5533,   1391,  -4010,  11918,   3455,  -1070,  -8552,  -6900,   3073,  -5074,  -1348,  -4120,    599,  -8054,   3571,   7621,   3582,   7699, -11618,    295,    702,  -2401,     11,   3001,   -314,    206,  -1693,    924,   8478,   6986,  -2145,   3366,  -2189,  -5486,   9006,   9555,  -2707,  -1281,  -2444,  -2215,  -2387,  -3848,  -1869,   4427,   6048,  -3783,  -4623,  -6966,  -5189,   1084,  10057,   5601,   6897,  -1048,  -3051,  -7506,   4004,  -1092,   4212, -14954,  -1233,   9541,   1038,   4171,  -1903,   2982,  -7023,  -7032,   2717,  -1783,   5707,   4682,  -7866,  -4498,  -8527,  -4538,  -4935,  -7054,   5789,   4621,  -5298,   -551,   -895,   1491,    253,  -2155,  -4664,  -3803,      2,   3191,  -4276,  -5030,  -2419,  -4066,   2429,   1017,    584,   8535,   4278,  -7401,  -6734,   1340,  -8022,  -5589,  -2336,   4687,  -9339,  -4680,  -3424,   2768,  -9413,  -4401,  -1662,  -3480,  -2192,   2648,  -8472,  -4857,  -5952,  -4136,   3813,  -1246, -13071,    177,   3430,  -8121,   1776,  -3077,  -6708,   3927,  -6072,  -3158,    517,    -64,     43,   7991,   -145,  -2319,  -5229,  -3684,   -545,  -3478,  -3541,  -1322,     94,   3973,  -3169,   4253,  -1382,   4772,   -398,  -2216,   4861,    159,    -76,   9880,  -3849,  -1631,  -3807,   1915,  -2553,  -4777, -11250,   3457,    841,   1487,    372,   8006,  -9916,   1992,    894,   4198,   2034,   2566,    575,  -1102,    964,  -1156,  -2239,  -4769,  -5211,  -9265,  -4103,   3748,   4781,   6226,   5820,  -3933,  -1404,   4931,   1236,   7113,    188,  -1719,  -9941,  -3008,  -2225,    832,   2886,  -4573,    550,   3664,   1730,   -680,   2823,   1766,  -2801,  11322,   2895,  -5420,  -1621,  -2149,    -21,   2423, -10671,  -4619,   1840,   1573,   2944,  -5793,   1498,    937,  -5432,   4242,  -2152,   2607,  -3419,   1411,  -1396,  -2476,   1975,   -667,  -5170,   -474,   -693,   1272,  -4193,  -4214,    -84,   8799,   3744,   -197,  -2673,   6937,   4171,  -6321,   4251,  -3471,  -2773,  -7309,  -2373,  -5714,   3197,  -4509,   3589,    471,   -722,  -6216,   2500,   2101,   7073,  -7905,   4388,   -470,  -1746,  -7208,   2568,  -5199,  11048,   7247,   6877,   9963,   9517,  -1419,  -9718,   9297,   3816,  -3669,  -2092,  -3482,  -1076,  -1221,    922,   4640,  -5185,  -8753,  -2911,  -9162,  -6487,  -5470,  -6018,    698,   3613,   1435,  -4907,  -5539,  -2530,  -2268,   2258,   -972,    789,   1690,   -198,  -9558,    455,  -4959,  -6529,   3718,   2235,  -3473,     82,  -5934,  -1041,  -2465,   3630,  -3385,   2479,  -3468,  -9162,  -1784,  -5654,   -427,   -902};

    const static Filter<int16_t> l3_b_compress_filter(l3_b_compress_filter_element, -23, {1, 1, 64, 32}, {1, 1});
    const Filter<int16_t> *get_l3_b_compress_filter()
    {
    	return &l3_b_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l3_b_compress_bias_element[] = {
          -834,   2463,  -6511,  -3362,   2253,    108,   7202,   6804,  -4329,   1196,  -3287,   2572,   5995,    391,   1533,  -4319,  -2642,   5159,   1240,   -701,   1876,   1126,   3492,  -4233,  -5534,  -3583,   4383,   2399,   2269,   5148,   -210,   3462};

    const static Bias<int16_t> l3_b_compress_bias(l3_b_compress_bias_element, -12, {32,});
    const Bias<int16_t> *get_l3_b_compress_bias()
    {
    	return &l3_b_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l3_c_depth_filter_element[] = {
          4123,  -3669,  -4285,   -917,   6980,   8441,   2322,   4620,  -3682,    337,  -7983,   -115,   4102,   2678,  -7198,   4312,  -6794,  -6839,   4956, -10949,   -608,   7616,   4396,  -9816,   1887,   -727, -11594,   8054,   4118,   9298,   3910,  17132,  -3848,   5513,  -7428,  -6183,   6820,   9677,  -2110,  14787,  -7992,  -4062,  11680, -13045,  -1777,   9866,  15679,    355,  -1387, -10772,  -3066,   4146,   -197,   2741,  -2007,   2896,   5712,  15759,  -5959,  -5898,  -6137,   -201,  -2299,   8492,  10192,  -4408,  -7424,  -5893,  -6693,   5043, -11068,   4367,  -1794, -10276, -11104,   7040,  -2375,  -5078,   4241,  -2158,   8549,   3437,  -3616,  -4159,   6487,  -9704,  -1831,  -3709,   1563,   7819,  -2729, -11885,  11360,   4307,    782,  -6124, -12795,  -1240,   5250,  -2001, -12416,  -2181,   7837,  -3443, -10302,  -2832,   5080,   3010,  -2743,  -5359,   3128, -19986,  -7903,  -7413, -14009,   9519,   8988,   1947,  -6483,  -6140,   7171,  -7504,  -2855,   2021,    855,  -8709,   8422,   9906,   2351,  -4088,   2477,   6709,  -3829,   7306,  -5216,  -4057,   5440,  -8856,  -5762,   7162,  11857,   5972,   8209,    361,  -6875,   5012,   3616,  -9932,   6081,  -2218,  -8984,  -2278,   1222,   5341,  15474,  -7745,  -1730,   1119,  -2707,  -6192,  -7601,   6045,   6545,   9891,   7281,  -6510,  15427,   5499,  -2859,   9480,  -2978,   1730,   1436,   4909,  -2463,   6985,  -5318,  -2664,  -2452,  -3707,   4169,   1329,   8891,  -7218,  -2228, -13791,   1435,  -7135,   8167,  -8484,  -7357,    412, -10055,  -4196,  -9441,   2465,  -3775,   3494,  -1364,  -4702, -10123,   -283,  -5125,  -5315,   4642,   9623,   4211,   6982,  -7348,  12784, -11547,   4673,  -5138,  -3743,  -1761, -19736,  -9228,   4424,  12339,   1225,    959,   2600,  -2441,   9067, -14596,   2175,   5156,  10035,   -676,   5667, -14512,  -1555,  13086,   2229,  -5424,  16503,   8843,  -2599,   3400,   1018,   8215,   1714,  10327,   2929,   5432,  -7702,  -1837,  12558,   -854,   2176,   8818,   6065,  -8403,   3656,   2642,  -5079,     22,   -140,   1033,    837,  -6172,   3091,  -1569,   5011,  -7116,  -8578,   -477, -13172,   2464,   4725,  -7640,   5874,   2589,  -9122,   9654,  -2829,   5528,   3219,   4383,    891,   -741,   6135,   3083,   -573,  13408,   -737,  -6521, -12623};

    const static Filter<int16_t> l3_c_depth_filter(l3_c_depth_filter_element, -14, {3, 3, 32, 1}, {1, 1});
    const Filter<int16_t> *get_l3_c_depth_filter()
    {
    	return &l3_c_depth_filter;
    }

    const static Activation<int16_t> l3_c_depth_activation(ReLU);
    const Activation<int16_t> *get_l3_c_depth_activation()
    {
    	return &l3_c_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l3_c_compress_filter_element[] = {
          -250,   3143,  -1935,   7998,   -176,    193,   2332,  -2909,  -2935,  -1100,  -5008,   5208,   5574,   -900,   1335,   2734,   4742, -14953,  -2269,  10984,   1275,   2414,   2592,  10382,  -8191,  -4014,   6287, -10731,   -346,  -3590,  -5778,   -304,  -2275,   3752,  -1846,   7999,   1995,  -6062,  -4884,  -6539,   4297,   2331,   4805,   6499,   -907,  -5935,  -5623,  -9608,  -4126,  -7802,   4187,   1301,    281,   3744, -14530,  -3952,   5242,    424,   -503,  -1125,    553,  -2861, -12591,   2453,  -5563,  -4038,  -2790,  -2473,   3435,  -9992,  -1327,   2920,  -1047,   1612,  -4363,   5776,   1005,  10843,  -2613,    253,   1140,    712,   1954,   1922,  -1439,  -8380,  -7626,  -5568,  13514,   5882,      5,  -6665,   1081,    704,   9397,   -490,  -4886,   9981,   4970,  -2419,  -1293,   1496,  11657,  -2111,  -7250,   5339,  -5754,  -1407,  -1835,  -9101,   5784,   3455,  -3666,  -2377,  -4109,  -3674,   -955,   -241,  -9519,   2726,   4193,   8286,   1484, -10711,   5245,   8033,  12985,   -966,   5037,    153,  -5638, -13344,  -3372,  -1509,    523,  -1753,  -1633,  -2919,    -93,  -3130,  -1332,  -3618,  12450,   1274,    657,  -5585,  -1502,  10647,  -1664,    699,  -6744,  -1032,  -9566,   6700,   5335,  -1207,  12248,  -2832,   -108,  -2672,   4604,  -3549,   5124,  -4559,  -4290,  -6454,  -4316,  -5413,  -7719,     59,  -4173,   8558,    827,  -8305,   3580,  -6498,  -9119,  -2424,  -7030,   -330,   -415,   1068,   -533,  -4242,  -7986,  -7476,  -6002,    992,  -2626, -10379,   6785,  -1185,   2806,   6724, -18686,    209,  -6522,  -8896,   6397,   2832,  -4479,    358,    -37,   8770,  -3838,  -7801,  -6002,  -2502,   -471, -20459,    103,  -3478,  -4195,    497,  -2511,   6950,   3315,   1478,    535,  -1803,  -8738,  -4379,   7572,   4544,  -8044,   4212,  -2754,   3497,   1208,   6127,  -9460,  -3250,  -8710,  -6833,  -3679,  -1007,   5512,  -4074,   1615,  -3217,  10342,   -331,   -966,  -3471,  10058,  -1842,  -1561,  -2211,  -3448,  15557,    700,   5681,  -4885,  -3572,  -4292,  -5122,  -8162,    377,   6488,   4362,  -2861,  -6428,   5236,  -2721,   1715,  -5530,   6244,   -497,   5761,  11508,   7857,   5607,   5274,    643,  -3646,  11195,  -8390,  -4062,  -6138,   3577,  -1092,   1453,   -344,  -4245,   5347,  -9357,  -2349,   -420,  -7847,  -7110,     82,  -2099,   4027,  -6498,  -5310,  -1026,  -1585,   3509,   1107,  -8591,   6254,   4356,  -2778,  -5063,   3889,   1550,  -8628,   2378,  -3320,  -9567,  -7993,   2170,   8063,    561,   6925,  15880,  -1460,  -4836,   5189,  -8856,   4381,   7615,  -2526, -11980,  -2796, -11372,   7556,  -8629,   5605,  -1752,   6911,  -8280,  -7136,    959,  -3730,   -684,   6713,   6435,   1720,  -1737,  -3032, -12903,  -5439, -15194,   2662,  -3000,    368,   8164,   -564,  -6751,   -601,  -1635,  -4509,  -1474,  -2155,   9321,   6387,   1960,    775,    130,    774,  10123,   2018,   3772,    575, -16108, -12176,   1301,  -5601,  13285,  -5173,  -2372,  -3408,  -6465,   4252,   5653,  -1748,   1376,    857,  -5685,    -43,  -5504,  -1416,    278,   -867, -12333,  -9915,   2448,   5594,  -2867,   -926,   -934,   -564,  13670,   7187,   4295, -10284,   6063,  -1974,  -2075,  -7241,     25,  -2413,   -395,  -2744,   5253,  -1638,   1038,   4844,  -7207,   1449,    612,   6249,    468,    382,   6264,  -3053,  -2885,  -2353,  -4017,   5352,   2341,   -334,  -2539,   5028,   8297,      0,  -5705,    337,  -5752,  10017,  -4186,  -4072,  -5178,    491,  -2456,  -4636,   6582,   3542,  11974,  -3075,  14802,   2054,  -1502,  -1501,   1991,    128,  -8953, -10196,   4170,  -8853,  12232,  -4483,  -2077, -10665,   1906,   4726,  -6493,   5254,   3294,   2350,     92,  -1958,  -6941,  -5733,  -3027,   -738,  -2242,  -2855,   2245,   5773,   6785,  -9267,  -8002, -10628,  -5589,  -6174,   4859,  -1764,  -5355,   1987,   3806,   1630,   1017,   8129,   6179,   6555,  -8621,   2442,  -8343,   1492,  -2362,   1064,   3170,  12992,   2640,   4861,  -4576,   2663,  -2407,  -1913,  -6503,  -6384,   2477,   2347,   3078,   3006, -12234,  -5286,  10588,  -3749,  -3009,
         -9205,   4504,  -4169,  12603,   -863,   2772,   1640, -11309,  -1402,    903,   4221,   7262,   3081, -15879,   7597,   5221,  -2197,   6230,  -8827,   9532,   2098,  -2948,   8319,  -4506,  -3423,   1006,   -936,  -6575,  -2231,  -3942,  17281,   1779,    249,  -1382,  -2711,   -555,  -3336,   5355,  -2202,  -4946,   7416,  -5560,    237,   -300,   -559,  -5075,  15067,  -4323,    -84,   2218,   7207,   5057,   7942,  -3708,  -1156,   7952,  11267,  18418,   3670,   2454,    346,   9735,  -4909,  -2528,   3247,   9592,  -3276,  -4071,  -8073,   8919,   4685,   9658, -15645,    742,  -5628,  -4496,  14150,  -2658,   2832,  -3537,   2281,  -3185,    954,   1255,   2229,   2928,  -6653,  -9535,  12220,  -1356,  -3141,   -682,     65,   -488,  -4787,  13572,  -4435,   8168,  -5852,  -4813,   1283,   6913,   5041,   6093,  -3556,   8673,   7411,  -6400,   3976,   9616,   3843,    680,   5445,   8187,  -3843,   5917,    141,   6200,  -8966,  -3821,   -616,   7048,  -1554,   8240,   5992,   1385,  -9366, -15439,   6950,  -2430,  -3726,   -648,   4918,  -2741,  -5527,   8536,  -1815,  -7252,   6226,  15357, -11986,  -6567,  11402,   8105,    518,  -5757, -11924,   7746,  15166,  14086,   7494,   5836,   8471,  -3601,   2270,  -1127,   9051,  -9674,  -9690,   6244,   7517,  -4183,   -313,  -6764,   1559,  -6432,   1054,   5529,   4350,  -2883,   3062,  -7063,   4673,  -1278,   7812,    535,  -3909,   2417,    175,  -4420,    513,  -3570,  12728, -20891,   -925,   9453,  -3594,   5210,  11010,   -765,   1691,  -4955,    561,    689,   -378,  16988,  -2167,   5252,  -8493,   5041,   9164,   4473,  -5629,  -8618,   1292,  -1183,    280,  -7685,  -7303,   2031,   4380,   3945,  -3610,   -369,   2381,  -3894,   3810,   3455,   5228,  12445,   1105,  -2646,  -5294,   6527,  -7814,  -7689,    926,   3900,  -4869,  -2841,   1181,   7270,  -1678,    192,   6795,   2862,    270,  -1040,   2275,    696,   3021,   1988,   8541,    492,  13630,   -657, -15242,   5405,   2159,   -865,   7353,  -3755,     49,   7782,  -4754,  -1921,  -2404,  -4515,   1422,   4821,   4858, -10031,   3133,   5340,  -7868,   6789,  -7240,  -3663,   4719,  13896,   4729,  -6806,  -9676,     -6,  -8501,   -243,   3506,  -8986,  -3020,  -6089,   1884,   6158,  -8706,   -605,   2030,   6957,   9999,  -7941,    596,   -144,  -7586, -14442,  -1587,   1166,    -68,    885,   5269,  -8917,  -2902,    521,    116,  -2389,  -1408,  -6278,   9642,   2675,   -917,   1247,  -2017,   5223,   3155,  12199,   7609,  -3512,    783,  10545,  -2153,   1040,   5952,  -8102,    556,   2955, -13230,    140,  -9969,   5533,   3103,  -5976,   2226,  -1245,   2908,   1707,   8394,   -529,   1965,  -3825,   2274,   3441,  14148,   -554,    674,   4607,   5944,  -2362,   5096,  -3604,   5725,   7467,  -2031,    -72,  -7886,  -3399,  -3738,    108,   6374, -10804,  -2388,   6149,   8989, -15531,   -850,  -3749,  -1359,   4128,   4908,  -3463,  -1302, -10897,   3523,  -1136,   6054,  -3944,    901,  -2680,  -1242,   8586,   -226,    807,   3963,  -8749,  -6257,    244,   7412, -13695,   8315,  -6110,   4815,   6301,   1707,    -50,  -6335,   1245,   1118,  -7188,   8779,   5133,   4940,   8568,  -6147,   9052,  -1773,  -4885,   2609,   9188,  10697,  -1969,  -7679,  -5365,  -5109, -11011,   -460,   2105,   2394,   -696,  -3491,    965,   9940, -12377,   -271,   1865,   2205,  -2433,  -6141,   7493,    735,  -4132,  -4453,   7890,   9539,  -1355,  -1189,  -1787,  -9990,  -5419,  -4609,   6750,   7245,  -5846,   3485,  -3564,  -2519,   2201,  -5898,   3588,  10973,  -1710,  -6552,  16618,   2201,  -5731,   1988,   -243,   1632,   4350,  -2645,  -1787,   1830,    955,  -5157,   2838,   6618,  -5486,  -1470,   1572,  10707,   6033,  -6113, -10251,  13727,  -4724,   4673,  17520,  -6806,   8987, -11642, -15127,   3524,   4257,   4587,   2865,   2805,  17327, -11146,  -6012,   8762,  -6132,   4009,   4850,    -60,  -2551,   2745,    977,   6956,  -4238,    819,  -2744,  -4402, -11482,   4980,  -7654,   3093,   4669,    168,   2945,  -2812,  11655,  -5379,   3290,   9748,   3645,   2186,  12565};

    const static Filter<int16_t> l3_c_compress_filter(l3_c_compress_filter_element, -15, {1, 1, 32, 32}, {1, 1});
    const Filter<int16_t> *get_l3_c_compress_filter()
    {
    	return &l3_c_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l3_c_compress_bias_element[] = {
          1740,   -505,   2221,   1399,    321,   3158,   1361,   -593,   -607,   -491,   -307,  -2789,    810,   3575,   -260,    745,  -1350,  -2902,   -328,  -2789,  -3492,  -1167,  -1114,    -60,   -395,   1811,   1805,   -864,  -3998,   -903,  -2046,   1744};

    const static Bias<int16_t> l3_c_compress_bias(l3_c_compress_bias_element, -12, {32,});
    const Bias<int16_t> *get_l3_c_compress_bias()
    {
    	return &l3_c_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l3_d_depth_filter_element[] = {
         -6273,  10263,  -8522,  -7171,   9562,   4342,  -1642,   3486,  -6040,   -771,   2122,   6596,   5425,  -1580,  -4016,   8465,  -5770,  -1636,  11886,  -1024,  -6979,  -1775,  -7446,  -8243,  -4297,  -5196,  11462, -15575,  10538,  10662,  -8599,  -1463,   3193,  -8865,  -2878,  -4185,   4393,   9426, -14790,  -3365,   1598,  -6686,   2489,  -8138,   -250,   1774,  -4175,   3964,  -6754,   5185,  -7757,   1590,  -2735,   9813,   -805,   2431,  14414,  12765,  -3521,   7588,   1035,   6704,  -8261,  -4504,   3421,   5405,  -7860,   3625,   2097,   1018,   3489,  15525, -13666, -10561,   2909,   5858,    151,   1924,   5878,  -1254,   3528,   7074, -12582,  -4881,  -8716,  -7043,    553,   6463, -10002,  -8134,   1558,   -414,   6572,   6452,  -2589,   2005,   2231,  -1587,   5916,  13036,  -5615,   2642,   3518,   7549,    792,   -610,  -8286,  -8863,  -6175,   -276,  16784,    499,  -3329,  -3275,  10996,   5913,  10770,   5906,  -1393,    576,   2170, -10291,  -3640, -13538,   3449,   2958,  -6964,   6494,   7433,  -6517,  -5400,   8960,   1930,   2552,  -7152, -16345,  -6672,    943,   -202,   1613,  -5112,   -458,  -2367,   1012, -14808,  -9289,  -8439,    544,  18564,   -253,  -9299,  -2261,   6495,  11755,  -9272,  -5470,   2093, -10451,  -1223,  -3942,   1241,  13126,  -1866,  13889,  -6475,  -8073,  -1323,   4743,   3919,  10782,  -9498,  -2666,  -5474,   7726,  -4043,   5073,  -3434,  -6027,   1039,  -4479,    -19,  -5164,  -7349,  -8301,    -40,  -6967,   5177,  12878,   -463,   4393,   7346,  -9402,   4523,    603,    281,   7049,  -1451, -13484,  -2345,    785,   9127,  -1889,   4572,  -7162,   4046,    992,  -2505, -10875,  -5404,  -4822,  -1817,  -4397,   2799,   -703,   7916, -13662,   8086,  -3716,  11490,    927,   8341,  13767,   3861,  10568,   7468,  -7376,   8101,   4214,   3593,   4738,  -6226,  10179,  -2464,  15964,   -743,   9597,  -5730,   7621,  10474,  -6887,   1909,  -3907,  -9187,  -1431,   7845,  -7775,  -1670,   4888,  -7108,   4529,  -5707,   3303, -11136,   5691,  15678,   7972,  -9271,   4978,  -1604,  14539,   -173,   5696,    101,  -6847,  -9018,    733, -11814,   1165,  -3009,  -4412,  -4949,  -4456,   2566,   7628,   3030,  -8997,   7079,   5097,  -5110,  -1495,  13729,   2517,   2451,   2078,   7804,   8953,  -8663,    786};

    const static Filter<int16_t> l3_d_depth_filter(l3_d_depth_filter_element, -14, {3, 3, 32, 1}, {1, 1});
    const Filter<int16_t> *get_l3_d_depth_filter()
    {
    	return &l3_d_depth_filter;
    }

    const static Activation<int16_t> l3_d_depth_activation(ReLU);
    const Activation<int16_t> *get_l3_d_depth_activation()
    {
    	return &l3_d_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l3_d_compress_filter_element[] = {
          5327,  -7655,  -3368,   4934,  -2825,  15456,   4587,  -6093,  -6959,  10369,   7059,  -3362,    210,   2553, -12084,   -235,   5920,   8076,  -6861,   7675,  -6017,  -5028,  16216,  -6049, -13657,    805, -11649,  -5444, -12247,   7867,  -5255,  -5222,  -1291, -12717,  -5111,  15238,    153, -16110, -10029,  -3708,     85,  -9514,   8011,   8248,   4105, -11725,   9434,  -9425,  -5587,   7478,  -8431,  12748,  -4723,  -7121,  -1945, -12952,   2937,  -9711,    655,  -8336,   3238,   5654,   9796,   3151,   9283,  -7988,  -2423,   2791,  -3011,  -1005,   8314,  -9578,   7591,  13667,  -1263,  -7809,   4575,  10518,  -6571,   3915,  10110,   -690,  -5726,   7992,  -1913,  -2177, -10046,  -6908,   2265,  -4635,  -1821,  -6253, -14661,    827,  10122,  10233,  -7730,   3512, -16330,  -2427,   5251,  -2710,  -2176,   6938,  -2218,  -3977,   6582,   -941,  -9289,   8790,  -8613,   2074,   4542,  12804,  -9352,  -2629,   2920,    -77,   6657, -23540, -13468,   -482,   4626,  -8319,  -6860,  -1517,  -3699,   2193,  -7096, -11961, -13205,  -7877,  -2287,  -6078,   -993,   5836,  12414,   3630,   4619, -13545,  14437,  20856, -13700,   3982,   1126,   1724,  -5935,   -875,   3291,    995,  -9045,   9859,  10844,  -2476,   9859,   2232,   5209,  -6728,  21316,  -5670,  10223,  -6690, -10455,   7100,   3217, -11287,  -9136,    961, -14546,  12616,   2759,   7745,  -2108,  -7577,  -1975,   3231,  14922,  -7734,  -3159,     11,   5008,  -1305,  -2543, -17109,  13058,   4375,   3836, -10566, -11156,   2146,  15236,  -9166,   9131,  16311,   3155,  -2768,  21758,  10091,   4264,    149,   -175,   7447,  -5886,    585,  -3281,   8105, -16669,  -1392,    871,  -7205,   2767,  -2328,   2860,  -5040,  10229, -19687,   3247,    252, -16209, -13590,  16591,  16310, -17896,  -2055, -12052,  -6509,  -5958,  -9607,  -5196, -16466, -11608,   8065,  21440,   3348,   7986,   2300, -10899, -10760,  -2890, -19832,  17895,  15250,   1814,   -369,    695,   1544,   4416,  16029, -10997,  -3096,   -688,  17479, -22882,   1024,  -6102,  -5787,  -6706,   3592,   5751,  -8596,  -4161, -17402,   1330,  -8629,  -5597, -17601,    262,   2370, -11529,  21018, -17606,   -260,  -7308,    859,  -5496,  -6216,    672,  -4424, -12844,  16092,    -42,  -2386,   -300,   2886,  -8320,  -7412,   5165,   2188,  -1221,  -1891,  -5514,  -2744,   4468,   -831,  -3503,  12544,  -4583,   1812,  -5177,  -9061,   6580,  -1732,   5748,   7156, -10121,   3286,   4391,  -2013,  -1924, -18252,    428,   2992, -12465,   -495,   4237,  14050,   -193,  11056, -20919,  -8471, -22299,  -4988,   7722,  17963,   2392,  -2825,   4747,   -455,   -459,    415,   4296,   6236,   6394,   9429,   3478,  -7426,  -7982,   8671,   -507,   2113,   9110, -13051,   6221,  12748,  -7919,  10482,   2961,   4257,  21844,   6997,  -3802,  16928, -14131,  -7326,    974,  -2284,  -1311,   8735, -12595,  10274,   -790,   2563,  -4335,  -2330,  -7387,  -7592,  -2375,   2919,  -3118,    667,  -5574,   -903,  -1583,  15541,  -9601,  -2498,  -5064,  -5438,  11305,  16960,  -4677,   -639,   4531,  17918, -13082, -12879,   1526,   7489,   4550,  -1849, -10008,   1348,  -5347,  11412,   7885,  -3863, -11711,  -1120,  -9944,  -8677,   9717,    329,  -2905,   9961,   7148, -15193, -12394,  -9732,  -3283,  -7700,  -9959,   1583,   2803,    115,  10744,  23615, -13351,  -4533,   -627,  11243,  -7785,  -7244, -19529,  14218,  -5355,  12253,  -6549,  -1523,  -3171,   1376,  -2783,  -3688, -10903,  -1851,    331,  -1025,   8266,  -6067,   8300,  -5240,  -5573,   3603,   5225,   3657,   4416,   6585, -25947,  -1795, -14960,  -1241,   3082,   9629,  -7194,   5963,  -1164,   1560,   7858, -12378,  -5721, -11771,   3897,   6903,  -5496,   2089,   9624,   5597,    523, -14967,     61,   9718,  -3825, -10318,   7487,   8551,   3421,  -4831,   9869,  -1660,  12137,  -3099,  -8987,    -31,   4545,   3194,   1265, -12990,   1947,   6601,  -3215,   2316,  10167, -15034,   9558,  -3389,  -4215,  -1052, -12139,   1222, -11197,  10596,   -644,   6968,   -660,    682,  -4395,   4272,   -491,  -4119,   8339, -12186,  -4601,   6229,
         -8054,  -4071,  -3103,   7695,   7279,  -2763,   2911, -12873,    466,   9468,  -5700,   2887,  11453,  -2343,  -1341,  -3989, -11358,   9420,  -9216, -21793,  -3786,  -9107, -18697,  -5772,     91, -13229,   6609,   6043,  12456,  -2348,   1426, -23529,  -1819,  -6642,   4013,    218,  12817,   -428,  -7698,   1979,   8710,  10954,   6832,  -1976,  16011,  -4390,  -9508, -10104,  -6372,  10529, -11476,  -7456,  10512,    -16,  -8737, -11566,    585,   -500,   -806,    450,  -1559,  -2647,   4897,  10801,    540, -16933,  10331,   7863,   6639,   -810,  -3306,   7085,  -7649,   8673, -13429,     80,   1065,   5130,   6298,   5013,   4081,  -7413,   4147,   7488,   -987,  -2806,  -8122,  15202,  10308,  -9092, -15478,  -4375,  -8631,   2518,   8382,  -3897,   7931,  -2650,  -2901,  -8421,  -5254,  11030,   2415,   -906,  -3325,   8379,    960,   5705,   8665,  -8783,  -1603,  -3647, -11434,    617,  13556,    723,   3831,  -4865, -11790,   2943, -13592,  -6305,   2312,   9365,    137,   4173,   -606,   8058, -10087,  -7713,   6558,     -8,  -2618,   -282,  -4814,  -2232,   2641,   7208,  11153,  -4871,   5001,   2318, -12747, -12050,  -4501,  15227,   7848,  -1990,   2238,   8186,  -3371, -10922,  -6651,   9603,    184,  -9134,   1313,  10268,  -5854, -11620,   2448,  -1986,  12264,   9504,   -708,   5264,  -2263,  14977, -11557,  15279, -14822, -10291,   9175,  -7403,   2758,  12531,   1033,   -206,  -3491,   2309,   4351,  -3212, -24226,  -1424,   9604,  -1218,  12218,   1135,  -7736,   1871,  -2410,  15981, -11736,   3310,  11559,  -9319,  -5427,    -20,  10147,   1115,   3259,   7611,   2706,  -7158,  24720, -10917,  -1639,  -1718,  -4676,  -3861, -10172,  -8359,   -522,   -758,  -4420,  13126,   1179,    168,  10120,   4277, -10773,  -5162,  -4501,   2534,   2587,   4549,  -1186,   -180,   -278, -12671,  -1594,   7166,   3709,  -8450,   1372,   4189,  -7900,  10730,  -1754,   1097,   3693,   7849,   8873,  -8340,   5592,  -6749,  -9798,  10092,   -851,   5727, -13706,   9554,   2231,   2646,    357,  22583,   5895, -19103, -10383, -11781,  12651,   5625,   9317,  -1667,   7552,  12910,   -703, -11050,   4088,    151, -11856,  -3334,  -2522,  -5842,  -4344,  13856,  -1175,   2576,  -8016,  -4094,  -2227,   2829,  -9099, -15205,   4705,   3566, -13697,   3539,   9780,  -3673,   6351,   5182,   2387,   6898,  -4527,   -909,  15140,  -6393,   -664,   -697,  -2618,   2742, -12834,  -5448,   1476, -16235, -15193,  -2758,  -7895,  -3480,  -4233,  -3265,   2198,  -1301, -14346,   8041,  -2195,  -5657, -14681,  -9144,   2052,  -1020, -14210,   8483,   2158,  -2155,   2026, -13735,    -33,  -8515,   4547, -26993,  -2978,  -8865, -10975,  -5435,  10834, -10074, -25342,   -391,   9015,   3788,  10458, -11293,  -4123, -11675,   6391, -10511,   5501,   9279,  17234,   9826,  -1013,   -949,    -30,  -9973,  -8304,   5597,   9494,   5702,   -809,  -7917,  -7391,   2546,  -2046,   4552,  -2066, -12417,   6347, -10610, -11084,  -7076,  -2624,  16408,   3129,   3779,   1094,    452,   4576, -10623,  -1414,  -2606, -15072,  -2924,  13168, -11687,    493,  -3086,   2451,  11732,  14403,   1190,   4937,  -2936,  -8899,  -5858,  -7811,  11700,  11406,   8137,   7751,  -9454,   3381,   5026,  -6485,  -3560,   5232,   3710,  -4643,   5099,  -5332,   8663,   1749,  -2459,  16542, -11951,  17796,   7663,   8100,  -9146,    328,  -2818,   6983,   3242,  -4470,    442,  -2281,  18533, -24163,  -7487,  -7339,   -497,   1623,   -601,   1709,   4224,   2121,   8035,   1930,   3990,   3666,  -3424,   1891,  -9438,  12750,  -1483,  -2354,   3983,  -4943,  20530,  -4068,   3902, -26117,   9171, -15585,   -858,  12323,  -2509,   7301,   8203, -14604,   1469,  -7048,  -7583,  -4198,  -4490, -21046, -11403,   -591,  -1196, -13114,    365,   1457,   4313,   -721,  -1955,   -509, -11240,     83,   2650,  -3264,   -355,   -296,  -1059,  -5581,  20128,  -8444,   -366,  -2290,   1197, -16625,  -6546,   -263,  -8452,   -140,   3513,   3075, -11154,   2308,   1109,  -3821,  21255,   1575, -22702,  -6864,  -9765, -11604,  11591,   2597,  -5808,  -4791,    482};

    const static Filter<int16_t> l3_d_compress_filter(l3_d_compress_filter_element, -15, {1, 1, 32, 32}, {1, 1});
    const Filter<int16_t> *get_l3_d_compress_filter()
    {
    	return &l3_d_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l3_d_compress_bias_element[] = {
         -1656,   -826,   1857,    580,    337,    746,    -42,   1681,   4211,    952,    643,   -552,  -2165,   1219,   1883,  -2935,    925,   -602,   -631,   1373,  -1857,    523,   4599,   -194,  -1229,   2308,   3982,   2379,   1550,  -1698,   1177,   1252};

    const static Bias<int16_t> l3_d_compress_bias(l3_d_compress_bias_element, -11, {32,});
    const Bias<int16_t> *get_l3_d_compress_bias()
    {
    	return &l3_d_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l3_e_depth_filter_element[] = {
         14981,   3472,  -7001,  -5163,   7502,  -9555, -19918,   1164,  -8870, -11027,   8087,   3174,   6680, -13374,   4259,   -173, -10201,  -3105,   3189,   7506,   8120, -11507,   5227,   1040,   5359,  -5272,  -3127,   3400,  -3634,   1495,   1628,  10061,   5548,   1184,  14006, -13154,  -2584,  10418,   2565,    787,   3750,  -2170,   2308,   2345,  -4076,   1767,   2991, -15664,  -7014,  -6793,   5914,  -3701,  -4907,   2585,  -2287,   8098,   5978, -12358,   1326, -13612,  10647,    204,  -1414,   7707,    939,   -296,    348,   4641,   7738,   5212,   3015,   2133,   7932,  -8090,  -3033,  -8600,   8173,  -1949,  -1212,   1184,   4284,  -5171,   2272,  -2625,  -3018,   6217,  11420,    552,  15505,  -9331,   -284,  -6383,     12,   5285,  10862,  -5190,   2511,   -189,  -8922,  -2159,   9289,  -7285,  -6704,   1609,   8418,   7447,   -935,  -9813, -13047,  -2615,  -2955,  -2830,  -1334,   5666,    208,   7449,   3028,  -2278,  -7329, -14360,   4745,  -7201,  -7132,  -5700,  -3288,  -5606,   6139, -15361,   3893,   4979,   9611,    840,  -3109,  16177,  -2158,  -1928, -11128,   2275,  -3980,   8756,   6521,  -3611,   7932,  -9238,   8150,  -3201,   3026,   5197,  -1135,  10283, -20255,  -5796,   5073,  13112,   9877,  -5577,  -9228,   2812,   6414,   2251,  -5684,  -4884,  -8003,  -7802,  -9494,  -2756,  -6085,   9590,   8113,    132,  -3366,  -6008,  -1882,  -3904,  -6678,   5449,   9663,  -1870, -13673,  -3991, -10779,  12729,   3043,   4812,   2985,  -8320,   1696,   2436, -12363,  -7686,  -3285,  13457,  -3023,  -7326,   9511,   9783,   5625,   1536,   5752,  -6646,  -5391,  -6302,   9838,   7186,   3109,   -223,   1471,  -1336,   7802,  -6386,   2526,    289,  -6009,  -4072,  -3498, -10982,  -4308,  -3594,  13168,   5418,   5947,  -3041,   1950,   1805,   -193,   5350,  -4376,  -4264,   4334, -16202, -11278,   7883, -14255,  -5009,   3924,   -837,   9501,   -724,  -4370,   -572,   1576,  11517,  -3938,   3903,  -2701,  -3008,   3910,   7631,   4623,  14619,   1860, -10584,   7048, -12496,  11060,  -2068,   1503,  -1487,   3646,   9029,  -1830,  -9692,   2622,   1088,  -8444,  -1345,   -491,  -8640,   1675,   3506,   6820,  14396,   9540,   2706,   3591, -11505,  -7638,  -3608,  13049,   9449,    305,  -6608,  16020,  -3554,   7206,  -6504,      1,    269};

    const static Filter<int16_t> l3_e_depth_filter(l3_e_depth_filter_element, -14, {3, 3, 32, 1}, {1, 1});
    const Filter<int16_t> *get_l3_e_depth_filter()
    {
    	return &l3_e_depth_filter;
    }

    const static Activation<int16_t> l3_e_depth_activation(ReLU);
    const Activation<int16_t> *get_l3_e_depth_activation()
    {
    	return &l3_e_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l3_e_compress_filter_element[] = {
         10637,   7394,  -6909,  -8244,  -4048,   9577,   3439,  -3189,  -3114,  -3305,  -5109,  -5518,   3873,  -2062,    227,  -1689,   9284,   3397,   1790,  -8362,   8594,  -2908,    544,   3139,  -6465,   1659, -11393,    -33,  -4897,  10380,  -2766,     59,   -414,  -1006,  -8564,  -1039,  -2360,  -1636,  -6740,  -4984,   7074,  -3873,  -7076,   1417,    608,   4581,   3405,  -6615,  -6363,  -8468,  -5540, -11070,   1470,  -2035,  -1253,   7120,   4916,    700,  -2827,    -19,  -4231,  -1816,   3020, -10450, -11186,   6169,   5059,   7282,  -4907,  -1863,   1118,   4496,   6077,   3265,   2084,  15440,  -1585,  -6202,  -4735,   6652,   3438,   3218,   2372,  -3594,   4114,   1631,  -4566,    104,   3539,   1078,   3927, -12989,  -3397,  -2765,   4694,   1703,  -1211,   9609, -11120,   1127,   -128,   3759,   8811,   4564,  -8442,  -5320,  -6052,  -6790,  12030,   4899,   5879,  -3567,   4538,   5625,   8985, -10651,   2329,    932,  -5370,   1396,  -6358,  -2630,  -7051,    258,  -1704,   3028,   2350,  -2511,  -7343,   -780,  -7971,  -4982,   7950,  -2703,   2882,   2998,  -3640,   2759,   2408,  -4304,   3547,  -6413,    216,   2540,   3460,  -3524,  -8078,   4544,   3229,  11597,   -433,   2885,   8266,  -4898,   4203,  -3368,  -1316,   2636,   3177,  -7535,   5012,   6723,    147,   4791,   8207, -10461,   8561,   4356,   2460,   4736,   9744,  -1225,  10371,   7103,  -9395,  -2010,  -6196,  -3591,   5513, -13227,   4898,  -6870,  10251,   6656,  -2417,   5218,    759,    980,   7000,   8834, -10262,   -928,  -1264,   5088,   5162,  -4562,   5246,  -4905,    910,   1872,    349,   4602,    192,   6879,   4549,  -5099,   9456,   5739,   9968,  -2943,   -479,  -1748,   4828,   1333,  -1277,  -5254,  -3105,   6877,   2792,  -3692,   2960,  -1484,  -9067,  -1736,  -3249,   5300,   4233,   3829,   4146,  -1135,   2849,   7556,  -4242,   3404,   6718,  -9763,    572,   6391,  -1412,  -5756,  -2050,  -2476,   7157,  -8749,   1815,  -2225,   3539,  -6712,  -1316,   1167,   5565,     53,  -6335,  -2127,  -3395,    119,    109,  -5100,  -3826,   3525,  -1678,   6098,   5049,   -853,  -5799,  -4093,    695,  -7692,   5679,  -7623,  -4339,   6779,   -206,   5923,   3410,  -1360,     17,   6491,   3556,  -8964,   4984,   4775,  -7062,  -6830,  -1729,  -1344,  -6433,   8484,   3848,  -5334,  -3120,   8042,   6168,  -7533,  -3690,  -2178,    714,   9294,    250,  -2115,   1046,   7882,  -4777,  10621,   8038,   4799,   1090,  -7070,   -817,   2241,   4557,   3077,   1023,   5752,   4208,  -3585,  -1132,   -831,  -2568,     38,  -4970,  -2593,   5023,  -1345,  12633,  -2242,   9450,   2348,  -8730,   1136,  -3927,   5941,   4079,   2151,   2905,   -333,   1195,   4998,  -7311,   4139,  -4905,  -2138,  -8658,  -4032,  -3150,  -8538,  -1174,    525,  11321,   -318,  -2898,  -4575,  -5263,   1973,   -474,  -6100,  -1331,  -5305,   3454,  -8197,   3040,   6484,  -1217,  -4774,   9207,   2880,  -3904,   9902,  -5327,  -2703,  11902,   1221,  -2857,  12719,  -5488,  -4411,   1395,   1955,  -2761,  -6696,   2739,  -7617,  -7479,   5316,  -7323,   4958,  -9418,   4576, -10281,   4227,  -7601,   2657,   1786,   1782,  -4427,  -8814,   -453,   9308,   5278,  -6159,   5347,  -8920,   2391,  -9440,    546, -13345,   3081,   4154,   6256,   -126,  -6027,  -8201,     79, -12654,   4236,   4949,  -2281,  -1739,  -1855,   3665,  -4261,  -4024,   2789,  -1482,    758,   3737,  -4180,   2355,    268,  -5674,    154,   1325,   1741,   1437,   6945,   1527,   4656,   4532,  -3821,   1642, -11984,  -3634,   1128,   2515,   4248,   1478,   -453,   -271,   6074,  -1145,  -6340,  -3216,  -1861,   9064,   1453,   1396,   1413,   3337,  -3770,  -3334,    236,   1492,   5524, -18930,   1467,   1450,  -9269,  -6167,   -535,   5294,   2024,   6615,  -1312,   2672,  -6815,  -2303,  -1994,   3995,  -4191,  -1600,  -5155,   4327,   1021,  -3473,  -6066,   5476,   5191,   7748,   1898,    -68,  17140,   2500,  -3306,   6471, -11986,  -4206, -13345,    194,  -1752,  -2006,  -5086,   3938,   1496,  -5212,  -5240,  -8406,   -312,  -4436,    141,   -719,    316,   2613,
          2440,   4027,  11837,   2465,  -4506,  -3753,  -3336,  -7368,   5714,   7764,    249,   1556,    -42, -12639,  -1301,   7060,   3770,   3024,   1979, -11105,  -3148,   6707,  -6588,  -2440,  -9323,   2322,  -6623,  -4721,   5990,   2840,   2912,   -975,   -171,   1461,   1167,   4885,  -1874,  -1186,   5414,  -8258,  -4024,   3695,  -4595,  -5093,    636,  -4205,   -456,   7771,   6438,  -5239,   2357,  -7083, -18557,   -634,  -5400,  -4049,   2319,  13465,  -2407,   2742,  -3341,  -3626,  15076,   7226, -11307,   2645,   7095,   7507,   3870,   2856,   -700,   -852,  -1673,  -4766,  -6483,   -407,   3626,  -3677,    -17,   5741,   2660,   4313,   5844,  -7339,   7241,   4093,   6020,   1566,   -383,    781,   4389,  -5597,   9306,  -1970,  -7561,   1499,  -3556,    369,   6153,  -5666,   3457,    584,   3910,  -4442,  -4731,   2266,  -7407,  -8185,  -1642,  11701,  -1635,  -2047,   1476,   2463,  -5952,  -1640, -12261,  -7666,   8651,  -2240,  -2109,  -5824,  -9765,   4551,   -473,   5130,   1076,   8283,   6965,  -5449,   1225,    105,  -7814,   9252,    133,   -468, -11979,  -1201,   6895,  -4906,   8035, -13276,  -1276,   8070,   -411,  -6815,   1985,   1861,   6873,  -9566,   1962,  -6834,    348,  -9630,   1810,  -6709,   -414,  -5467,  -1772,   6469,  -9248,   6777,   5779,  -6928,   3438,    187,   -730,   4405,   7228,   3777,  -2259,    855, -11455,   2839,  -3759,     62, -10728,  -2810,    945, -12107,   5137,  -4364,  -2401,  -1233, -13877,   -985,   7856,   -747,   -314, -11211,  -4217,  -8407,    433,   6749,   3536,  -8980,  -3105,  -4316,   6202,  -2400,    925,  -3797,   4406,  -2980,   2520,  -1866,  -1234,   2772,   6756,   7626,   1237,   8746,   4595,  -4961,  -4111,  -6224, -13472,   -370,   1636,   6229,  -7693,   2845,   5566,   3639,   4757,    372,  -1902,    700,  -2779,   2140,   6789,   -999,  -7317,   7507,  -4979,  -8907,  -8841,  -1906,  -4063,  -1740,   3435, -12196,   4095,   -773,  -7780,  -7394,  -9989,   1525,  -2985,    189,   7131,  -4488,  -7548,   3852,   1409,   5900,  -5406,   5267,   4013,    450,   4862,  -2635, -14802,  13775,  -2705,   6046,    548,   2106,   1162,   2364,   1886,  -6760,    579,    684,   -521,   7327,   -261,  14795,  -8087,  -4343,   2792,  10630,   4487,   5184,  -3846,  -5010,   5246,  -2579,  -5780,   9532,  -9529,   3081,  -1335,  -5512,   -596,  -9641,  -1223,  18862,  -6756,   -553,  -2681,  13700,  -5689,   3421,   -653,  -1863,  -2949,   2386,   -137,  -2078,  -6419,   8203,   8120,  -3157,   8053,  -9413,    -61,   5456,   -681,   9644,   2039,   2193,   9360,  -1035,  -8974,   2262,  -9681,   5214,   4814, -11471,   2901,  -7686,  -5155,   5828,  -2482,     84,   1296,   1570,   1052,   8823,  -1031,  -7599,   2329,  -4484,   2094,   1527,  -4745,   7055,    811,   -207,  -5603,   7259,   2059, -10328,    622,  -3547,   5046,   5720,  -1632,   5925,   1944,    553,   -468,   -429,  -3067,  11084,     68,   1458,  -1253,  -2280,    634,   5594,   3551,   2254,   8427,  -8496,  -4423,   6161,  -5136, -11070,  -3902,  11005,    -97,  10718,   9820,    822,   2186,   1904,    714,   6051,   -530,    793,   4714,  -1031,   2396,   -151,  -4016,  -6301,   6251,   4266,   -959,  -3220,   1893,   4333,   8478,  -6417,   9404,    938,  -1057,   3094,  -3786,     72,   6446,    -47,   1938,   5481,   9196,  -6463,   5828,    594,   4123,  -4386,   6171,  -9987,    334,    808,  -2886,   7478,   2753,   5553,   2633,   6022,   1638,    277,  -4235,  -5253,   7320,   1521,   1887,   5063,   1467,  -5523,   8380,  -2669,   3303,   4369,    158,  -5609,   8618,   -643,   8559,   5721,   1835,  -3738,  -4824,    431,  -3984,  -7059,  -2620,  -5192,  13491,   5323,  -7718,   3428,  -6484,   4009, -10608,   -994,   2290,   9842, -11697,   2242,   8071, -11230,   7940,   7164,   2457,  -8172,   2909,  -4482,   6032,  -4298,  -1301,  -2753,  -8730,   8179,   3099,    892,  -3659,   8677,  -3013,   4836,   6413,   2511,   2624,   3304,   1402,   1480,   4664,  -7419,   2979,   -263,  -8445,  -4621,    262,  -5541,   5808,  -1043,   2333,  -7787,  11031,  10018};

    const static Filter<int16_t> l3_e_compress_filter(l3_e_compress_filter_element, -15, {1, 1, 32, 32}, {1, 1});
    const Filter<int16_t> *get_l3_e_compress_filter()
    {
    	return &l3_e_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l3_e_compress_bias_element[] = {
           786,  -3150,   1555,   4632,  -2795,  -1463,  -1935,    147,   2457,  -1301,   1738,   3577,   -654,  -1577,    209,    351,   2856,     51,  -3305,   3007,   2295,   3070,   1376,     89,  -1999,      3,  -3288,   1530,  -1268,  -5125,   1736,  -1694};

    const static Bias<int16_t> l3_e_compress_bias(l3_e_compress_bias_element, -12, {32,});
    const Bias<int16_t> *get_l3_e_compress_bias()
    {
    	return &l3_e_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l4_depth_filter_element[] = {
        -10979,  -2278,  -3525,  -7838,   7702,  -4476,   5308,  -1037,   1823,   4863,   9710,  -9267, -10130,  -1882,   4891,     95,  -4969,  -6805,   -187,   3664,    -24, -10423,  -3919,   7316,  -6094,   4527,    967,  -2215,  -3284,   -690, -13650,  -8048,   2252,  -5760,    483,  -1260,   -441,  -6325,   2959,   5796,  -1937, -12372,  13637,  -5402,  -4842,   -204,  -4043,   9007,  -5539,   1934,   9455,   5334,   6112,   3818,   5620,  -6129,   4565,   9768,   6445, -10293,  10090,  -5191,   2355,  -2925,   3937,  -2181,   1694,  -4107,  -4129,  -8972,   9237,   2102,  -8473,  -6702,   4164,   1499,  -5727,   7510,   5918,   1247,  -1576,  -3160,   6305,   8587,  -1393,   1116,   4670,   7763,  12348,   -137,  -3282,   8276,   1004,  -7544,   6338,   1027,   7447,  -2537,   -407,   2567,    113,    826,  -3011,  -6471,  -5443,  -3854,   2968,   5470,  -6187,   -891,  -3785,   3896,   6134,   2695,  15402,  -2086,   1994,   3165, -10032,   7204,    284,  -5841,  -6670,  -1102, -12134,  -8797,  -6474,  -4830,  -6608,  10837,  -5783,   8068,    127,   -851,  -9488,   2158,  -2476, -12075,  -2256,   7622,   7023,  17987,  -7234,   9390,  -4833,  12581,   -626,  -3948,  -4757,    542,   9673,  10136,   8605,  -6141,    356,   8923,  -6108,  -2161,   5630,  -5426,   4835,   1266,  -9810,   9931,  -9048,   4206,   4395,   3138,   2758,   3591,  -5108,  -4200,   8873,    209,   4877,   4080,   7153,   3681,  -7665,  -8871,   5764,  10412,  -2200,   4710,  -1189, -11689,  -8304,   4452,   4959,   2267,   4070,    637,  -8411,    930,   3718,   6438,  -5474, -13358,  -1137, -12096,  -4545,  -1354,  -6200,   1869,  -4871,   1289,   1462,   1794,  -5588,   9108,   2668,   6496,  -3629,  -7974, -11069,  -9871,   5322,  -4797,   5414,   6641, -13362,   9227,  -7157,   4703,  -4663,   9197,   -934,  -6914,  -2401,  -1043,  -3257,  15770, -10555,  12419,   4222,   1326,  -8115,  -1272, -12007,  -2232, -14454,  -7054,  -3011,   2209,  -6470,  -9682,   4431,  -7075,   1637,   -701,   -206,  -1161,    311,   8568,  -3184,  -1498,   2607,   7017,  10612,   5092,   6992,  -4625,   9697,   -844,  -5684,  -4349,  -6261,   8699,  -4984,   6937,  -6178,     63,   4705,  -1529, -12551,   5341,  -3664,   5678,  -7486,   -769,  -2714,  -6603,   1722,   5851,  -3494,    -88,   1484,  -3672,  -4582,   2019,  -1082,  -3047,  -4868,   4715,  -4396,   5489,   7672,  -6466,  -1409,  -3717,   6981,    708,   1202,   4580,   7118,   2988,   5762,  -5274,  -4299,    487, -10315,   2699,   4616,   -545,  -1619,   4891,  -6746,  -1697,   2552,  -3240,   5581,  -1507,   3535,  -2550,   2727,    758,   1081, -11504,   1821,  -8246,  -6537,   -962,  -2868,   3393,   1719,  -5907,  10651,  -1101, -13729,  14765,  -5697,   5906,   9480,   9237,  -1536,  -4966,   9699,   6118, -11198,  -6635,   7513,  -2949,  -7660,  -7477,  -3416,  -4037,   5350, -13553,  -5586,   4284,   2436,    231,  -2518,  -8048,   3312,  -2767,   8816,   -359,   1367,   2980,   5822,   9368,  -1241, -12564,  12309,   5536,  13340,  -8109, -10267,  -5199,  13873,  -3656,   2065,   2862,  -2960,    209,  -4457,  10651,    974,  11501,   4356,  -1585,  -1162,  11339,   1661,   5434,   7744,  -1644,  -1170,  -6480,   3050,   1230,  -6545,   -749,   7612,   1905,   -682,    280,  -9061,   4051,  -5729,  -9531,   2068,   3441,   -606,   4865,  -6039,  -6038,   7160,   1400,  -5421,  -1677,  -7967,   -732,   -163,  -9619,   1059,    111,   -248,   9783,    380, -17994,  -6338, -10173,  -9352, -13185,   -338,   1630,  -5327,  -6103,   4576,   8046,   4948,  -3597,  -9754,   5139,   -103,   1654,   -939,   5163,   -408,   7022, -12485,   1386,  11002,  -2343,   8539,   1600,   2513,   4060,  -5509,   7181,   4115,   8186,  -4250,  -5096,   2762,  -4281,  -3090,  -1762,  -3840,   5663,   3142,   3003,   2909,   4272,   -870, -16659,  -1466,  -8187, -10623,     44,  11391,   9217,   4568,    573,  11099,  -7414,   2529,   7807,  10062,  -6588,  -4773,   3968,  -5875,   2634,  11748,  -6383,  -4748,  -6508,    477,  -1076,   -669,   7433,  -3465,    477,  -4472,   9891, -11919,  -3554, -14016,    569,
         -1493,  -1488,   5687,   1837,    723,   7817,   3469,    812, -13469,  12786,   7707,   4561, -12141,    -78,    911,   1104,  -3954,  -6111,   6165,   2179,   6119,  -7585,   1230,  -5029,  -5266,  -2187,    132,   3113,   2496,   1123,  -9224,    813,  -1588,  -6552,  -9208,  10022,     85,  -4548,    695,  -3995,   5373,   5864,   7520,    327,    -67,   2865,    210, -16263,  -1889,  -8951,   7578,  13043,   -440,   4911,  -1984,  -5056,  -6819,   2115,  -4491,   2287,  -5517, -13632,   -567,    473,   2121,   1939,  -1996,   9566,  -4481,   1042,   4091,   5975,  -5677,  -7166,  -9758,  -3134,   5326,  -1023,  13098,   3639,   4408,  -4447,   2657,   5191,   7732,  -2051,  -6084,  -4839,   -826,   1587,  -7334,  -6645,   2457,   5213,   5284,   6731,   1382,    290,  -3473, -10969, -11578,  -4409,  -5387,   7201,  -9642,   6564,   6187,   2821,  -4230,  -4438,  -6390,  -3095,  -9298,  15978,   6061,  -3505,   -462, -11276,  -9226,   3857,   6091,   5771,   6117,  -5695,    966,  -6053,   1244,   1898,  10649,  -2308,  -4483,    888,  -7346,  -3486,   8669,  -1653,    512,   3083,  -8749,  11342,   5069,     74,   -457,   7472,   8170,  -7429,   2712,   -820,   7987,     17,  -3404,   9666,  11331,  -4066,  -6033,   4517,  -3137,   1063,   4441,    511,  -6293,    956,  -7769,   -892,   1369,  -6993,  -4250, -11110,  -2834,  -3610,   3002,   6024,   2248,  -2807,  -3874,   1889,   1063,  -9958,   1485,    696,   3024,  -7151,  13168,   5576,  -8984,  -3897,   3362,  -5082, -10100,  -9221,  -3929,  -4813,  -3598,   9860,  10689,  -9925,  -2617,  -3277,  -1737,  -1294,  -3429,  -1907,   2206,   6144,   5185,   8390,   2771,   2544,  -4099,   5042,  -5817,   1472,  -2190,  -6028,  -1395,   -753,  -5018,  -3620,  -3629,  -8480,   9948,   4435,   3871,   3794,   1525,  -6633,   3817,  -5502,   2759,   8989,  -2537,   9914,   1682,   -244,   6253,  -1733,  -9590,   3374,   5848, -15560,   -970,  -3143,   -779,   7944,  -7213,  -1035,     47,  -5770,   2151,  -3072, -10043,  -7631,    -50,   3580,   7165,  -1744,  -9664, -13506,   4093,  -6974,   6752,   5149,   3919,   1775,  -4368,  -3834,   4764,   7727,   5727,   5921,  -1057,   -554,  -8220,    832,  -5421,   1110,   6376,   7435,  15832,   3744,  -8546,  -4466,    831,    408,   2324,   4487,  -1570,   1838,  -8612,  -1653,   1507,   -378,  -6756,   1162,  -2922,  -3621,   7004,  -8869, -10737,   9907,   2805,   3332,  -3485,  -3489,   -809,  -3366,   4151,   4359,     25,   2476,   1253,  -2907,   3879,  -2810,  -2374,   7470,  -2150,   4846,   1767,  -9431,   6688,   1926,  -5498,   5783,  -5683, -11494,   7469,   5981,  -7305,  -2248,  -5763,   1533,   3072,   5069,   4187,    881,  -1576,    519,  -2806,   4545,   3104,   3148,  -3901,  -7866,   7340, -11873,  -6192,  -9903, -12839,  -5682,   9804,   9539,  -3714,   3107,   4871,   4868,   -325,   2822,   6492,   2922,   -480,   2640,  -5550,      4,   5466,   4604,   6638,    330,    375,   4565,  -2012,  -2944,  -9250,    840,   7124,   8991,  -2109,  13325,   3035, -10379,   6287,  12505,  -6548,  -1196,  -5071,   -127,   1342,  -3598,   -684,   4602,  -6871,  -2251,  15547,    860,  -9839,  -2824, -15445,  -9346,    204,  -1770,  -4180,   3414,   7024,  -3417,  -2745,   1239, -10324,  -9546,   -567,  -5013,    262,  -7731,    784,   2616,   4615,    -47,  -6581,  -1737,  -9449,  -6589,   5118,   7248,    300,  10613,  -7793,   -648,  -2409,   9440,  10189,   2914,  -4836,  -3249, -10288,  -5452,   4217,   8168,  -3930,   7231,  -3808,   2057,  -5874,  -2397,  14359,   -992,    720,   8666,  11871,  -5569,   3032,  -3722,   1651,   6044,   -781,   -581,  -8062,    391,    646,   2316,   9721,   3196,   4763,   2242,   4012,  -5764,  -5020,   7859,  -2560,   4978, -10104,  -9814,   3137,  -9482,   3718,   3437,  -4242, -10478,  -1693,   2376,  -2592,  -8837,  -1165,   7665,    716,   3264,  -7782,  -1621,    174,  -4189,   -593,  -8664,  -6058,    435,   1875,  -8236,   5224,   7199,   8523,  -7458,   1910,   1799,   8148, -11775,   -932,  -4953,  -8757,  -2104,  -6942,  -2742,  -1095,   4964,   2469,  -5953,
          6611,  -9231,  10884,  10504, -10876,   9044,  -1807,  -5377,   1615,  -3024,   7328,   5115,   1464,   -984,  -5475,  -1171,  -1163,   7427,   5476,   2638,  -5541,   3127,  -2742,  -8422,   3433,   7434,   4468,   7748,  -4562,   8004,  -6312,  -1739,   2402,  -1758,  -8570,   1165,  -3200,   -615,  -9109,   7298,   5554,   -198,   9211,   5182,   1328,  -3123,   8021,    737, -12987,   9252,   1662,   -293,   9241,  -4197,  11529,  -2752,   -407,  -1934,  -7778, -10784,   4586,  -8010,   2647, -10936,   6615, -11679,   -308,  -2928,  -1199,  -1141,   5492,  -3635,  -4636,     66,  -5129,  -5137,   7493,   8501,  10309,   5640,   4432,  -2291,   2348,  -7272,   1781,   6461,  -5667, -13955,   4115,  -2634,   6334,  -5745,  -1583,  -9758,   3794,   4282, -10986,  -9303,   1306,   -701,   8238,  -1014,   1932,   3431,  -6539,   5517,  -2215,  -1746,  -8484,  11155,  -1898,  -2550,   3493,  -4743,  11235,   5408,  -3360,  -1747, -12039,  -4847,    638,  -3207,   4593,   5009,  -9698,   2382,  10272,   2025};

    const static Filter<int16_t> l4_depth_filter(l4_depth_filter_element, -14, {3, 3, 128, 1}, {1, 1});
    const Filter<int16_t> *get_l4_depth_filter()
    {
    	return &l4_depth_filter;
    }

    const static __attribute__((aligned(16))) int16_t l4_depth_activation_element[] = {
         22745};

    const static Activation<int16_t> l4_depth_activation(LeakyReLU, l4_depth_activation_element, -17, {1,});
    const Activation<int16_t> *get_l4_depth_activation()
    {
    	return &l4_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l4_compress_filter_element[] = {
         -9065,   3160,  -1363, -12469,  -4586,    342,  -3800,   4964,  -1220,  -6191,   6641,   5794,   2767,   7632,  14418,  -8098,   1656,  -7340,   -451,  -2428,  -4589,   2096,   -676,  -8805,   4290,   3334,   2684,   4133,   8062,  -1245,  -5739, -15082,  -8070, -10657,   8264,  -9850,   6296,   3380,  -5092,  -8885, -10336,   5821,   4940,  -3793,   -158,   1075,  -5771,  -9955,  -9480,  -3777,  -8352,  -6890, -10953,  -4899,   -416,  -2605,  -4023,   1114,    985,  -3603,   4315,   -249,  13665,   2876,  15190,   8777,  -2326,   1693, -10511,   9090,   4692,  -1898,   -209, -12599,   -400, -12258,   7548,  -6027,  -2588,  -2580,  16093,   2940,    -77,  -6869,  -8662,    630,   7073,  -2960,  -2855,   1656,   3608,   9050,  -6083,   -908,  11642, -11271,    180,   2744,   -958,  -1596,  -7427,   4724,  -5271,   3246, -13177,  -2204,  -7548, -12747,  16102,  10566,  13406,   2957,   4508,   5407,   4631,   4788,   -120,  -6536,  11182,   3394,  -7922, -13178, -11579,   -860,  13438,   5138,  11999,  -4997,   1397,   4343,   1190,  -3422,  -8899,  -6036,  -1016,   1998, -11279,    415,   3396,  -7202,  -3368,  -3104, -14253,  -4761,  -7842,   8766,    476,   4868,  -7108,    200,   8543,   1829,  -9278,  -4258,   3403,   9143,   5218,   7246,   4889,  -7682,   -866,  -7253,   7867,  -6611,  -4848,  -6086,   3271,  -6676,   5851,   7402,  14405,  -2275,  -3359,  -7403,   1364,   9435,   8018,   4385,  -2210,   3113, -11902, -11868,  -1555,   6524,   6179, -12293,  -4628,   8397,  -4993,  -1942,  -1020,  -7663,   3758,   4898,   5698,  -4641,  11767,  10750,   -246,    729,  17185,   3067,   1735,   5471,   5107,  -2501,   8787,   3023, -12877,   -170,  -1068,   2711,  -4885,   -887,   7736,  -6663, -12348,   6259,    419,   7850,   8854,   5443,   1057,   1505,  -2809,    949,  -4898,  -1332,   4435,   3544,   3458,  12020,   6509,   -522,  -8727,  -1595, -11609,    -32,  -8127, -10442,  -1563,   2917,   9653,   2540,   9321, -12340,   -679, -15594,  -4935,  -2323,    543,   4540,   8187,   8773,   6027,   -812,   4745,   8770,   -868,  -1460,  13917,  -7985,   4047,  -5024,   2038,    878,  -4564,   1526,  -6921,   -238,  -7351,    521,   3928,  -3947, -11325,  -2388,  -1845,   1344,  -3127,     28,  -9595,   7519,  -5067,   1265,  -3695,  -4281,  -3658,  -8069,    168, -13651,   4597,   4876,  -1383,  -2440,   6971,    956,  -3118,  15286, -12475,  -8128,   4942,    864,  -8116, -16829,   8294,  -3659,  -7865,   5104,   2094,  -8265,  -8098,  -7824,   1465,   7164,  -3070,   2488, -10984, -14914,  -3236,   1920,  19065,  -1371,  -7724,   6845,  -5477,   8668, -12040,  -4208,  11707,   7185,   7415,   4121,   4831,  -3203,   1540,   7564,   -908,   6016,  -9135,   4176,  -9060,   3193, -10667, -14100,  -7753,   8113, -11147,   6634,   3588,   -979,  14540,  -7287, -13719,  -5501,  10102,  -2022,  -4727,   7365,  -3305, -10638,  -4454,   5044,    -91,   3592,  -3418,   4651,   1562,  -2662,   5367,   8370,   8741,   8445,  16669,   1589,  -8013,  -5025,   9254,  -1574,  12645,  -3590,   5121, -11028,  15614,   2467,   3406, -10224,  22126,  -5649,   2608,  -7129,  -1031,   -817,    307,   8657,   5776,   5441,  -4778,  10617,   4357,   9681,  -7098,    148, -14189,  -4842,  -1040,  11146,  13770,   5012,  -1685,  -7570,  -2583,   6107,  14321,  -5558,   2987,  17696,   7335,   -931,   5410,   6337,  -2582,  -6540,   3975,  -5917,  12493,  -4070,  14394,    316,  -5543,   4708,   9659,  -3012,  -3573,   5692,   8773,   3743,   7736,   5184,  14218,   2546,   6309, -15399,   4801,  -4459,  -9450,  -2540,   -743,  -4328,  -1802,  -7075,  -7906,  -4456,   2780,    537,    818,  17392,   2482,   9249,    963, -12852,   -393,   -596, -16104,  -7678,  -8719,   9101, -10867,  -2008, -15776,  -3634,  -3556,  -2011,   -657,  -2937,   5706,    894,   2733,  -7138,  14155,  -5847,  -4741,   6818,   8234, -12867,  10449,   -533,  -8395,  -7097,  11076,   8524,   1960,   5342,  -9181,  -4431,     38,   5143,   3418,   5017,    929,   7252,   6961,   8233,  -5072,   -906,  -3819,  10974,   9730,  -4249,  10327,   3410,   7757,  -2688,
         13090,    908,   3942,  -7222,  -8826,  -3992,    503,   -925,  -8587,  -1318, -15681,  -7852,  -2390,  -6494,  -2486,   4322,  -6132,  -5247,  -6661,   8100,  -3610,  -6420,  -7604,  -8918,   6843, -11178,   3814,  -7793,  -2303,  -2799,  -9874,   4417,   4473,  -9211,  -2636,   1867,   6947,  -2639,  -6026,  -1431,   3735,  12296,   1282,  -7161, -11627,   5940, -12887,  -3115,  -7759,  -2162, -10948,   4028,  -5992, -20041,  14835,   -465,  -6284,  -6471,   3116,  -2520,   5742,  -6228,   5444,  -6976,   -768,  10432,  -2796,   -626,   9169,   8612,  -7293,   2997,  -1403,  -9476,   1290,   6594,   1625,   -257,    616,   2411,  10274,  -6092,   6952,   1681,   6289, -11452, -16943,   1961,    394,  -7516,   3780,  -3098,  -9083,  -8652,  -6408,  -8282,   6046,  16810,     70,   -851,   4210,  10218,   6672,  14444,   6585,  11918,   3291,    -35,   7115,  -4296,  -2938,    755,  -8149,   -902,   2556, -12542,  -1926,   2033, -12672,   3841,  -6203,  -4938,  -2498,   1827,   3523,  -8392,  -5780,  -9544,  -8652,  -5595,  11857,   7761,   4356,   2465,   4028,   5475,  -5111,  11396,  -3779,  -1158,   3735,  -1975,  -4818,    729,   6086,  -4555,  -6810,   6619,   1930,  -7158,  -6368, -10323,  -1793,   2429,   3708,  -5097,  -3320,   1990,  10855,  -4396,  -3326,  -4526,  11013,   -795,  -5828,  -3113,    333,   -802,  -2819, -17658,   9698,  -6396,  -1756,  -5644,   -118,   1865,    -52,   4325,  -3014,   5629,  -6332,    684, -10615,   2586,  -4205,   5583,  -5466,  10955,   -134,   2332,  -3007,  -8481,   1401, -12409,   3292,   6641,   1020,    814,   5233,  -1938,   4017,   5020,  -7985,   4145,  -5099,  -2441,   -238,  -6165,  -3557,  -5202,   7947,   2736, -12306,   4253,  11766,   2776,   -780,  -5192,  -7772,  -8137,   8018,   1177,   5959, -14030,   6463,  -4849,  -3629,  -7339,   5955,   4428,   1389,   7045,   3844,  -8104,  -3125,   4373,  -2875,  -7674,  -6956,  15328,  -2897,  -4835,   2964,   1212,  -7392,    691,   2121,  10592,   -763,  -9024,  -2316,  -6689,   3703,  12101,   1500,   7338,   3943,   9124,   1971,  -9395,  11246,    579,   -177,  -7562,  -6591,  -1966,  -7790,  -4412,   4539,   1363,  -7287,   5000,  -7723,  -4884,  -2141,   8356,   5790,  -6143,   5536,  -3366,  -3089,   7380,  11048,   1669,  -9338,  -8256,  -3477,  -1171,   7861, -10343,  -1554,  -2930,  -1397,   2797,  -2562,  11801,  -5700, -10164,  -3236,   2070, -14507, -10312,  -6586,   5788,   -918, -15930,   -652,  10352,  12018,  17251,  -5611,   2675,   1345,    920,   -225,   4623, -11591, -10845,  -1800,   8087,   6061,   1788,  -2839,  -7444,   -628,  -9719,  -1505, -11666,   3333,    -48, -12153,   2164,    -42, -13527,    -70,  -6928,  -5849,  -5571,  -5596,   2063,  -4145,   2007,  -5856,  -3765, -14812,   4668,   5496,   1189,  -4935,  -4047,   4184,  -8634,  -2196,  -2474,   2931,   2440,  -7760,    887,   9237,  -3009,   7861,    852,  -7306,  -6687,  -2333,   1758,  -1243,  -6426,   1014,  -4191,   1875,  -4971,  -9264,   2747,  -2390,   8144,  -3415,  -4682,   1746,  -2027,   8909,  11263,  -3875,   1052,   9955,   4442,  -2878,  14786,  -3585,   5225, -10550,  -3451,  -3733, -13795,  11541,   -381,  10168,   6761,   6662,   1264,  -2651,   9291,  -8070,  -3021, -12327, -11364,   2717,  -2945,    921,   9657,  -6453,  -6314,   7657,   -826,  -3264,    408,   4233,   7134, -12333,   9724,  11298,    456,  -4461,  -8556,   6799,  -5764,   8591,  15455,   5922,  -1955,   7604, -10018,   8012,   8424,  -8263,   7571,  -4214,   1488,   5319,  -5908,   -998,   1421,   8410,  -5394,  -1954,  -6942,  -8139,  -1521,   8827,   5316,   1771,  -4126,   2643,   -669,   2914,  -8512,  -2464,  -6372,   -544,   8829,  -7301,  -1121,   -623,   2133,  -3190,   -640,  11221,   -377,  -7661,  -2408,   2727,  -4314,   -414,   2199,   2574,   1480,   -266,  -3569,  -3165,  -9920,  11350,  -8483, -16119,   4466,  -4022,  11707,   6711,  -3727,  -3663,  -3169,  -9858, -12658,   7046,  -9981,  11372,  -3517,   3789,    860,    572,   -891,  -9702,  -7481,  -4124,   1026,  -7099, -14933,    460,  -5369,   2701,   6958,  -3563,    972,
         -8581,   6952,   -724,  -4329,  12228,   9836,   2620,  -4451,     -6,  -7325,   2112,  10000, -10767,   7779,  -5002,  -1995,  -2830,   5481,   8678,  14691,  -6786, -14582, -10844,  12083,  -6108,  10366,   7604,   1549,   -163,   -680,   3227,  -1879,     47,  14098,  -3366,   1206,   -153,   7869,  -2786,   4113,   6620,   7994,    381,   -810,  -4867,  11586,   3864,   8741,  17609,   8884,  -1494,   5149,   -169,   6193,  -6474, -10564,   4381,   5619,  -7461,   -139,    318,  12886,  -7597,   -237,  -1137,  -2815, -22583,  -9441,  -6935,  -5515,  -2683,   6342,    266,  -1989,  -2243, -17835,  -4750, -11213,  -2984,   -111,  -5686,   8498,  -1002,   2003,  -1588,    972,  -3847,   4747,   8198,   3016, -21520,   4429, -12840,   3810,   6132,  -7595,   -130, -10128,  -2228,  19060,  14357,  -1708,   2534,   -181,  -9913,   1018,  -1576, -11767,    646,  12217,   1266,  -8292, -11744,  12165, -11557,  -2690,   7944,   4787,  -2727,  -9034,  -4088,   8861,  -1875,   9642,   -681,   7171, -11955,  -1744,   7510,   2961, -10310,   6619,    -65,   7677,  -7734,   8457,   5705,  -1455,   8480, -10989,  10628,   2210,   2254,  -3415,    611,   3146,  -6985,  -7603, -12283,   6286,    911,   8112,  -1632,  10658,   7660,   6901,   6861,   9413,  -2795,  -3718,  -4775,   4281,   7063,  -2621,    210,  -1468,   4167,   -335,   4407, -13785,  -2046,   1520,  -2840,  -3442,  16611,   4833,  -2720,  -3744,  -4426,   8024,  -6604,   3338,    -69,  -4923,   6068,  -3547,  11425,   4779,  -2616,   -812,   9092,   7681,   5793,    732, -20436, -10465,  -4313,  13147,  10760,   6126,  11461,  -7083,  -9334,   1368,   7387,  -9520,  -4025,  16508,   3647,  13213,   4865,    703,  10499,   3976,  -3728, -11501,   2963,  -3016,   8339,   1178,  -3904,  -7926,   3419,   -534,   7932, -12334,  -6740,  -6606,  -2830,   4934,   4620,   5340,  -8145,  12500, -12134,  -6133,  -5318,  -8031,   9644,   6026,  -2207,  -3606,   6191,   6453,   6641,  -7116,  -6193, -10949, -10266,  10660,   6314,   6785,  -5733,   1705,  16436,  -2186,  -7508,   1717,  -6024,   8004,   7400, -22372,  -6842,   7413,  -7464,  12704,   5369,   1418,   2133,   9254, -19577,   1832,  -6857,    738,   6177,  17056,  10869,  -1504,   5699,  15327,    610,   9460,   -297,   2297,   4682,  -3714,    232,  -4335,   6897,  -1900, -12796,  -7290,  -3300,   8227,  11996,   7903,   7117,   -458,   1387,   8420,  -6242,   1750, -14091,  -9439,   8552,  -2675,   1341,   5712,   1912,   3258,  -7785, -12134,   2161,  -9076,    952,  -6397,  -3885,  -1471,  12207,  -6762,   8156,  -8530,  -1026,   5495,   1270,   4164,   5689,   3735,    854,  -7787,  -4187,  12672,   6584,  -3293,   4646,   2057,   7478,  -9114,   -504,  -2314,  12859,   3155,  -1282,   1099,  -5060,  -9260,   -960,   4325,  -4468, -15036,  -5476,   8452,  -3437,  -2848,  -2072,   4314,  -8396,  -7105,   -719,   9488,   9967, -23579,  -9265,   1480,   7753,  12304,   2299,  -6489,   5913,  -7273,  -3630,   1626,  -4861,  -4864,   3546, -10627,   2018,  -9358,  -4800,   8613,  10149,   -367,   2766,  -6721,   2241,  -9479, -14446,  14658, -11683,   5381,  -1526,   7452, -11176,   1405,  -6088,  -7489,   5082,   5364,  -9777,  -8179,  -2175,  -2346,  -1082,  -9681,   3759,  -7510,   4407,  -2034,    978,   6640,   4780,  -1787,  -8038,   7083,  -2158,  -1696,   2104,  -2954,   3803,   5126,   1173, -14003,   3181,  -7586,  -3074,  -4093, -12030,  -3239,  -6283,   -191,   1572,  -5971,   4395,   6167,   4985,   -598,   5850,   3202,   5982,    645,   7329,   4820,   -257,  -2270,   4778,  -4845,   4549,  -8916,   2565, -10299,   9131,  -1751,  -2928,   3434,   9355,   -885,   -530,  -6032, -12250,    645,  -8622,  -1351, -26475,  -7152,  -7305,   4535,  -2707,  -4831,  -5724,   2520,  -4291,   7849,   5656,    699,  -6762, -13701,  -5891,  -3022,   6957,  15031,   4532,   8490,  -3074,    499,   3937, -10100,   6599,   -426,  -1796, -13962,   4756,  12000, -16502,   9002,  10781,  -7864,  -4385,  16954,  -2758,  -1814, -12222,    560,  -5387,   7501,  -6947, -10423,  -2081,   1765,  14301,   6895,  -5516,  -1125,
         11466,  -7305,  -8041,   6437,   6061,  -9951,   5240, -16556,   1466,  -9338,    234,   2023,  -8597,   1137,    818,  -1983, -14358,   3528,   1557,    736,  -7488,  -9447,  10978,  -7715,   5307,  -7569, -11995,   -717,   9479,  17371,   6113,   4745,  -3154,   7520,  -3128,  -6654,  -5337,   2320,  -3394,   8026,  -4344,   2404,   5296,   6192,  -5299,   8613,   1610,  17696, -18935,   3595,   9720, -11278,   6017,   -117,   4117, -10456,   2173,    431,  21781,   3009,   4687,  -2189,   1333,   5589,   2531,   -622,   -864, -19562,  -8580,   9869,   5457,  -4367,   6061,   6361,  12978,  -9456,  -7821,  -2470,   -470,   5753,   4574,   1806,   8749,   7534,   3458,   7564,  12509,  -2614,  13390,    202,   1291,   5700,  -5986, -13092,  -5783,  12211,   2097,  -5808,  -7900,   7582,  -3587,  -6592,  -1655,  -1522,  -9946,  -2693,  -6700,   1142,  -4601,   8063,  -2729,  -5211,   3785,  -2032,  11611,   4273,  -7962,   3637,   4322,   4249,  -9187,   7904,  18430,  -3878,  -2651,  -5312,  -1701,  -4443,  -9100,  -4000,  -4229,  -5444,  17189,   5941, -17060,  -3295,  -9401,    638,  -8708,  -4506,   6994,   1728,   6465,  14529,  -8635,  15793, -14202,   2603,    893,   2775,  -2616,  13625,  12552,  -3883,   9088, -11397,  -5855,    363,   7483,    935,  -2477,  13156,   2567,  -8256,   -363,   3163,  -4657,   2502,   4380,  -2216,   3757,  -2630,   7709, -11542,  -5609,   3345,  -8865, -10103,   3281,  -4116,  -3315,    996,   3151,   5676,   2001,  10448,   6313,  -1923,   1788,  -4727, -16511,   3447,   2559,  15115,   3828,  -4708,   9681,  -2107,    175,  10412,  -8873,  -8649,  -8852,   3531,  -5140,   3729,   -239,  14514,   2614,  -8582,  11764,   3554,  -6951,   7486,   5827, -13872,     36,  10052,  -1912,   3292, -13866,  -5377,  -4574,   5319,   7918,    -31,   7224,   2944,  -4696,  12954,   6455,   9781,   3481,  -6005,  -3149,   4371,   7626,  -2334,  11015,   1813,  17709,  -5431,   9197,  -1718,   4747,  14046,   4187,  -6079,    739,   2392,   -169,  -6568,   5183,   4758,   4238,  -7927,  -1595, -10866,   6301,  -1426,    722, -10657, -18126,  -9267,  -5354,   4260,   -682,   -236,   6148,   -226,   5691,  -2001,   4827,   5675,   3663,  21550,  -7769,  -5886,  11475,  -4213,  10897,   4234,   1452,  -8014,    848,  -1836,  -3580,   7448,  -6040,   1227,    -23,   2593,  -3050, -21413, -10152,    -95,   7544,  -2778,   -974, -10737,   5342,  -5380,  11386,   8271,  10577,  -9285,   8116,   5174,   6770,   8986,   7619,   2232,   6587,  -5676,   5757,   7283,  10600,   3588,  10509,  -4351,  -4978,  -5553, -11943,  12111,   1938,   4052, -11130,  -7894,   4091,  -3401,   1031,   -317,  -5805,   1081,   6045,  -3695,  -5174,  -2704,  -1079, -16522,  -4071,  12872,   7041,  -4388,   2944,  -1008,   4013, -12679,    971, -11627,   1439,  -3292,   -395,   9324,  -5557,  -1895,   9689,   1545,   2349,  -3155,  -3155,   4177,  -6227,  -3489,   6031,   7012,  13438,  -2597,   4739,    549,   1840,   6251,    692,  -2004,   1468,   2183,  -3674,  12339,  -6130,   1711,   4555,   -268,   3258,  -5532, -17668, -15695,  -6282,   4161,  -4261,  -9633,  -1077,   2627,   6898,  -4795,   6860,   2680,    444,    239,  -3399,   7546,   5895,   1205,  -6632,  -1001,  -3985,  -9695,    282,   6447,  -6788,   -255,   9842,  10067, -12509,  -7784,   2377,  -3767,  -1570,   6277,  -2154,  -5810,   2961,   8317,   2545,  -1759,  -3091,   6895,   8413,  -9940,   8801,   3204,   9415,  -6724,  -2385,  10259,  -8746,  -4556,   3356,  -8091,   5313,  -4209,  10004,  -1538,   -298, -10003,  -1506,   3536,  12977,   2886,  -6640,   1986,   4312,  -8466,  -7460,   8269, -15485,  -4068, -12679,  -3617,   1430,   7617,   4336,  -6647,  -5837,   6271,  -5638,   3983,  -1154,  -2128,   -634,  16161, -10113,    453,  12131,   1760,   -211,   6501,  -5536, -11782,  -7166,   6250,  -5904,   7873,  -5059,   5003,   8734,  -5090,  -6914,   9724,  -3346,   4768,  10057,  -7799,   -704,   6519,   4060,  21767,  -2757,   4591,   6209,    911,  14547,  -8834,  -6160,  10686,   4298,  -1696,  -3219,  -3757,  -2178,   5584,   -128,  -9520,
         -5824,   -107,  -6017,  -8271,  -2734,   2009,  -6259,   3848,   4952,    409,  -2192,  12469,  -2646,   2974,   2050,   7302,    -85,  -4042,   5006,   7933, -14788,   3215,   4662,   4692,  -2764,  -4607,    593,  -5598,  -2503,  -4757, -14382,  11520,   2116,   3645,   6187,  -6012,  -6879,  16224,   9285,  -3065,   2643,  14598,  19110,   1427,    226,   2187,    752,  -2304, -11179,  -6954,   2773,   4057,   7402,  -1030,  18130,  15838,   1895,   3034,  -3562,   -491,   4033,   4313,   1886,  -3226,   5592,   1862,   3100,   5365,  -9308,  -3764, -12591,  -3317,  -2717,   5683,  -6368, -10345,   5469,  -7558,   6673,   8236, -11353,   -551,  12128,  -5277,  -3853,  -3703,  -4271,  -1563,   8665,  -6847,  -2220,  11843,   2174,  -8024,  10927,   5132, -11359, -11166,    102,  -3479,  -1160,  10436,   3753,  -7205,  -1593,  13281,   3066,   4752,   1042,   3519,  -7827,  -1964,   2903,    952,  10592, -12676,  -4287,   3510,  -5989,  -2883,  -1174,  -6255,   8177,   2010,  -6354,  10536,   8541,  -3374,  -6190,   1970,   2008,  -3193,  -7045,  -1176,   4384,  -8925,   -774,  -6247,   6326,  -6811,  -8084,   8569,  -3725,   9097,  -4321,   6145,   8127,   5112, -10369,   5530,    956,   2797,   8095,  -6665,  11565,  12755, -11438,  -4671,   9736,  -8478,  -1576,  -2557,   5690,    109,  -5837,  -6339,   4416,   6346,  -3919,   8839,   4248,  -6558,   3340,   2298,  17888,  -3290,   2366,   7869,    -72,     19,  -5718,  -5813,    476,  -9923,  11916,   5306,  -1038,   3779,   1133,   2092,   5394,  -3386,   9622,  -3329,  -3866,  10605,   2149,  -4113,   5737,   5840,   2694,   -182,  -6179,  -1889,   5767,   3279,  -8119,  -1788,   5884,  -2049,   7728,    861,  -2285,   8169,   3403,  -2784,  -1610,  -5360, -13027,   -351,   3196,   8244,  -5482,    951,   5974,   -894,   6930,   4822,   4730,   -262,   5945,  -8550,  -3489, -16714,  -3593,  -3072,  -5985,  -4678,  -4416,  14633, -16851,  -3925,  -1861,  -5567,  -4016,   6679,   2356,  -2089,  -1056,  11151, -17253,   8964,   6454,   4396, -10429,  -4645,  -1851, -11258,  10269,   -143,   -590,   1906, -16521,   4843,   3105,   3570,  -4412, -13219,   4510, -10586,  -1580,    763,    503,    117,   6119,  -5349,  -7919,    789,    587,  -5530,  -2233,    134,  12801,   2135,   -128,   3900,  -3391,  -4779,   4787,   3108,  -3528,  11754,  -8046,   1575,  -8827,   1143,   2153,  -8510,  -2811,   1158,   -156,    402,   2105,  -9633,  -7615,  -7001,   9472,  -2430,   4165,   -597,  -4120,  -1268,   6866,  10163,  -9045,   7168,   7675,  16750,   2717,  -7328,  -4858,  -4197,   1412,   4749,   9181, -13271,   -751,   5030,  -9400,    896,    898, -11688,  11708,   -634,  18086,  -6832,   2727,    134,  -7739, -10636,  14749,   6007,   8048,   2520,   2849,   2423, -10137,  -1215,    999,   5222,  -1045, -14689,    779, -11277,   6940,   -652,   1690,  -8513,  -5754,  -1185,    921,   3188,  -7039,  -3806,   -324,  -3259,   7377,  -9680,  -5380,   2837,   9623, -12309,  -1907,   7685, -18080,   7979,   1010,  -2523,    346,  -1543,  -3999,   5181,   -521,   -976,  -2458,  -5151,   4198,  -7110,   1363,    219,   5233, -10691, -12923,   7344, -14494,   8120,   4770,  -6814,   9062,  -5854, -10080,   5467,  -8722,  -2888,  -3097,   -166,  -2192,  -2126,    601,  16347,    868,   1895,    604,  -4829,   2255, -24663,  -2656,  -1629,   8413,  -1348,  -9026,   -397,  -5303,   1785,  -2981,   6747,   5553,  -7810,  13698, -11256,   3378,  -5265, -11620,  -4486,   5791,   4108,  -4481,  24547,  12528,  13016,  -8642,  -5315, -10617,   9861,  -1251,   3869,   6074,   -892,   5550,   -103, -15932,   2360,   7230,  -5520,   7563,  -4974,  17577,   5511,  -5092,  -7530,   4705,  -3673, -10714,  -3314,  -1048, -10612,  12014,  -1920,  -3750,  -3484,   4887,   5045,   6904,  -5742,    387,  10124,  -7468,  -2593,  -4717,   6891,  -6507, -13587,  -7196,  -4636,   -668,  -5469,   2814,  -2479, -20530,   4154,  -7464,   6220,   2912,   2228,  10142,  -3402,  -4308,  -2273, -13754,   2777,  -5108,  -8750,  -6361,   1296,   4693,  -3739,   2127,  12379,   5404,   7546, -10254,   3136,
         15255, -12053,  12044,  -4986,   3168,   2026,   6616,  -6366,   4678, -15504,    504,   1284,  -2681, -10066,   9538,   3503,   4101,   1008,   5412,  -1593, -12088,   5267,   3856,   -639,   6667,    227,  -8875,  -5924,  -8914,    -59,   7219,   -863,   7162,   2824,   4710,  -3904,  -5013,  -3035,   3738,  -5973,   1389,   5968,   1011,   5023,   8347,  -7852,   6074,  -8851,  -6022,   8175,   7941,  10980,  -3551,  -5137,   3148,   1630,   1298,  -2345,  -5284,  -3589,  -1463,   1126,   1907,  -7009,  12170,   5238,   -678,   6604,  -9439,   8194,  22282,  10335,  -4498,   2450,    914,   4401, -20830,  -7483,  -4682,   5174,   -986,   -183,    180,  -7998,   1180,  -9454,  -1488,   8273,  14578,  -3774,   -386,  -5312,  -6306,   2618,  -2143,   2707,  -7725,   7159,   4555,   3703,   4039,  -3516,  -3113,   3266,   7347,   9879, -12816,  -3303,   3696, -12001,  -2965,  -9012,   4304,  -6626,   4608,  -2732,   7801,  -9604, -10160,  -5130,  11148,  -1265,  -9191,  -9470,  -7697, -14401,  -5084,  -7965,  -2280,  -2698,   3628,  -9222,  -2405,  12524,  -4838,   4175,    404,  -4982,  -4843,   8486,   7070,   3642,   -624,  -7928,  -5230,  -7648,  14867,  -2401,  -8298,  11173,  -1000,  10872,  -6109,   3599,    972,    115,  -7986,  -1673,  -8168,  -5460,   4654,   4332, -12488,  -9239,    846,  -5234,   7194, -11102,   8273,  -3471,   6426,  -3034,  -1997,   5693,   3892,   7071,  -4578,   9245,   -569,   2081,   7833,   2914, -11983,  -8770,  -5560,  -6211,   9152,  -2153,  14179,  -2596,  -8021,  -3648,   -166,  -5167,  -1874,   3963,   3186,   5271,  -1055,   1322,   -723,   3914,  -1108,  11173,   3335,  -6776,   2784,   3833,   -616,  14175,  -5297,   1337,  -7645,  -6236,  -3981, -18718,   3074,  12721,  -1982,  -1880,   7193,  -1909,  -3631,   9176,  -4433,  -4681, -10373,  11109,   6015,  -7410,   4657,   6475,   3528,   -912,   4653,  -5565, -16071,  -3127,   8040,    224,   1050,    938,  -1298,  -7486,   7346,   2158, -10565,  -5985,   2648,   3941,  -2245,  -4304,    341,  -2660,   8611,  -2410,   1736,   -443,  -1033,   5084,  -2142,  -5774,  -4766,  12686,   3145,  -8786,     -3,   1169,  -6033,  -3362,   8990,   6122,  -8084,  -3563,   -233,  12348,   -214,   4403,   8567,   -694,  -1494,   5745,   3071,  -4195,  -9308,   -659,   1640,  -6249,  -1207,  10119, -10645,   -730, -12597,   -467,  -2532,  -3368,    602,   2283,  15783,  -8938,   1974,  -1352,  11108,   9156,  -2416,   5970,   2865,  -1722,   -117,   1906,  -3090,   9415,  -7941,  -7405,    431,  -2101,   8271,  -3199,  12252,   -149, -13632,  -3695,  -1569,  -2077,   7800,   8583,   3509, -17468,   6909,  -4945,    212,  -8280,  10117,   9978,  -1299,    955,  -4251,  12416,  -2128,   5076, -11707,  -7156,  -2224,  -4790,  -2748,  -1826,  -3361, -12875,  14481,  -7887,  -1419, -15737,   -333,  -9632,   8499,  -3801,  13491,   3697,  -4687,   9726,  -1081,   -208,   6864,   -729,  -9019,  -6978,   5000,   5237,  -5969, -13160,   6625,   3116,   2803,  -7056,  21321,    809,    392,   1225,  -4384,  -1099,  -4649,   1669,  -1569,  -2535,  -1918,  -7031, -15897,   4053,  -4743,  -1374,   3820,   5401,  -5639,  13432,   8671,  -5356,  -6707,  13555,  -6189,   1227,   -804,  -2892,   7019,   9874,  -2128,   9813,  11585,     93,  -6836,  -6294,  -9411,   8611,   -724,   1314,   -390,  -1892,   -233,   7291,   2200,   2988,   -796,  -9599,    626,  11419,   1082,   6338,   3078,   -895,   5803,    870,   -561,   5870,  -5896,  -5150,   7590,   4759,    234,   7961,   3821,  -3733,  -3242,  -3085,   6005,   3063,   6569,  -4539,   6896,   4287,  -2372,  11413,   1238,  -4425, -12022,   6810,    -41, -15138,   4924, -10577,  -1838,    845,  10638,   -496,    452,   -745,  -8744,  -6359,  -3144,  -3257,   3855,  -1025,   1886,   -255,  -3532,   2757,    267, -14151,  -6520,  10284, -12700,  -3252,   2584,  12617,   5113,   2654,  -7572,   6836,  -2582,  10878,  -2010,    552,   2424,   -854,   7174,  -6269,   7461,   5310,  -6901,  11829,  -9999,  -2745,  -5800,  11379,  -2195,   1196,  11293,   2227,  -3384,  13470,   -888,   8185,   7927, -12573,
         -5200,  -2077, -11401,  -9619,    230, -12413, -13985,   4407,   8028,  -5033,  -3788,  -3162,    193,   6391,   9319,     64,   6811,   9542,  10510,  -3642,  -3926,  12488,  -2947,   -809,  -1477,   1023,   1428, -11444, -15277,    363,   3580,   6631,  -3302,   3534,  -8882,  -5796,  -8748,   8466, -14595,  16694,   -373,  -3882,  -5166,  -4299,  -1057,  10808,  -2275,   1616,   5287,  -2454,   5982,  13702,   2559,   2995,  -7284,   2634,  13932,  -3371,   3648,   -302,  -4056, -12264,  -5170, -11306, -12076,  10443,    663,  -9761,   3682,   -894,  -7866,  13489,   2329,  -4866,    122,   1232,  -4690, -10047,  -4696,  -1463, -20187,  -3328,  -1718, -11147,  -2879,  -1399,   6539,  -9359,   5825,   5742,   5381,  -2295,   5360, -13426,  -5768, -12700,    960,   4431, -14331,  -4416,  -8533,  -8898,  -2299,   5192,   5485,   2785,   8855,  -4127,   1050,   7811,  14745,  15269, -10708,   7937,  -3357,  -3057,  -1808,  -4679,   2817,   9030,  -2423, -13764, -11091,  -5697,   3940,   2884,  -7082,   2942,   1690,  -4370,  20325,  -6957,  -4888, -12232,   4485,   7891,   4999,    364,   1420,   9803,  -8174, -25618,  21110,   3477,    227,   5028,  -4984,   1523,  11441,   7313,  -6640,   4450,   8408, -10681,  -5585,  -9411,  -5517,   -587,   8853,   2076,   4533,  -5890,  -8301,  -3301,  -2014,  14356,   5362, -14491,  -1775,  -7468,   3905,   9478,   6265,   7440,  -2689,   1163,  -2601,   4673,  -7609,   -914,  12904,   6683,  -7468,  -9113,  13587,   8633,   3809, -11172,  21115,   5809,  -5403,  13907,   6030,  -4945,   8431,   -816,  -7499,  10582,   8023, -11592,  -5266,  -1196,  -2154,  -3071,  -2409,   8523,  -2915,  -1036,  -4479, -17266,  -8020,  -1653,  -1696,   4114, -12261,   2228,  -5558,   2451,   3596,   3269,   4739,  -7386,   8155,   3727,   9078,  -2504, -13719,  12542,   9761,   5800,   1405,  -2149,  -1618,  -3166,   5830,  -3885,  -1286,  -1776,   5980,  17440,   2220,  11256,  -2972,   2464, -15964,  -8050,  -8833,  -3083,   5299,   -929, -13944,  -4958,   9678,  -5286,  -3705,   5125,   7290,   5922,  -3828,   2661,  -7349,   4228,   -414,    384,   2704,   1233,  11350, -11673,   -341,  -5102,  -8170,   5790,  -7281,   1945,   -203,   8572,    868, -10980,   8986,  13940,  -5323,  -5374,   -105,  10023,   4975,  16676, -10966,  13773,  -1380,    224,   9198,  11171,  -2258,  -1057,   4952,  -2666,  -4607,  -9408,  -3388,   4959,   7122,  -7108, -14352,   -889,   -775,   2712,  -4263,  -4032,   4230,   7815,   6793,  -1529,   9479,  -4791,   9052,  -1312,  -6273,   5177,   4728,  -2107,  -7363, -10682,  -4298, -13998,  -1163,  -1622,   1884,   1650, -11173,  -7333,     61,  -7309,   2626,  -1886,   1290,  -3360,  -6565,    560,   8601,   6016,  -2224, -12055,   5265,   2783,  -5877,  10193,   3494,    614,   2036,  -2071,  -5477,   9076, -11000,  -5528,  -7101,  -5904,  -5109,  -2125,  -3887,  -2533,   -342,   1215,   8470,   5894,  -7750,  -9882,  -4265,   1359,   7894,   7623,   3837,  -5906, -12434,    650,  -1433,   6920,  -2793,   2676,   4783,  -9940,  -7929,  -2038,   1607,  -2166,  -2494,  -3644,  -9814,   -152,   3705, -11997,   7417,   1189,   -266,   5134,   3537,   7100,    755,   2347,  -8800, -12114,  -6666,  -8130,   5271,    988,   3776,    250,   1369,    391, -12969,  -5420,    630, -11947,   2713,    549,  -3544,  -9158,  -1193,  14874,  -1862,    -81, -18870, -13729,   -551,   6376,  13223,    188,   6228,   4214,  -1628,   2216,   9008,  -4122,   -921, -11259,  -1679,   7285,  -6445,   6635,  -7105,   -812,   1108,  11427,   5934,   3814,  -7087,  11667,   8259, -16533,  -4663,  -5973,  -2005,  17572,   3372,   4815,   8507,  -1436,    986,   4546,   3144,  -1323,   7329,  -3077,  -4804,   5141,  -4280,  -7703,  -3420,    707,   5926,   8713,  -5593,   6685,  -2397,   9142,  13927,   2048,  -5533,   1678,  13397, -10513,   7009,   5361,  -8009,  11666, -16150,   2502,  -6138,  -2902,  -4498,  -3429,  -2303,  -2774,  -5903, -12142,  -1059,  -3264,  -2086,   4757,  16304,  -3080,  10246,  -8678,   5199,   3534,  -7132,  -7011, -15867,   4582,  -5716,    239,  -4878,   2827,
          9004, -22942,  -3156,   5693,  18249,   9926,  -2491, -10120,   -771,  -4013,  10141,    131,  -3403,  -2719,   2677,   -524,    341,   1851,  -7431,   2988,   4170,   4337,    259,   4523,   4572,  -3459,    522,   5718,   7456, -11726,  -6849, -11680, -13329,  -2714,   7009,   7826,   3452,   5052,   2597,  -5879,  -1419,  -8383,   1724, -11793,   6413,   6663,  -1983,   3901,  10131,   2621,  -5865,   3413,  -9705,  -6984,   1792,  -3379,  -4961,   4941,   4958,  -8587,  -1411,  -8193,   3714,    649,  -2031,    693,  11121,  -8274, -11312,   6833,  -7493,   9456, -14740,  12942,   -630,   2591,  -8135,  -5989,    690,  -1417,   1107,   -358,   6987,   2639,  -5296,   2206,    696,   1808,   -907,  -5163,   6735,  -7427,  -7965,   1639,  -3706,  -2135,   1692,    421,   4213,  -1910,   1941,   4921,   -596,  -3437,  -3051,  -2372,  -1491,  -9397,   9140,  -7616,   5538,  -4621,  -5539,   -830,   2479,   1441, -14327, -13082,  10134,  -4705,   -926,   4659,  -4849,  -1294,  -1831,  -4494,  15621,   6636,   4731,   3295,  -7576,    728,    892,  -4581,   3906,   7427,    150,   6426,   -365,  10540,  -5481,  12639, -15521,  12965,   5499,   1269,  -1655,  -8434,   2100,  -5253,  -4486,    288,   1232, -11750,   4610, -12168,    617,    371,  -7994,  -3930,   5200,  -1777,  -1514,   3201,  -5270, -10263,  -1200,   1161,   2636, -10525,  -9821, -22331,  -9637, -14911,  -5861,   4757,   8602,  -9255,   8551, -10800,  14337,  14000,  -5252,   -147,  -2582,   1038,  -7237,  -2694,  -4593,    208,    308,    120,   -560,   3610,  -1643,  16830,   5433,  -2309,  -9217,    368,  -1534,  -2637,   2737,  -4454,   4570,   4838,  -1817,  -3856,   2436, -12405,   -603,    853,   8184,   2265,  -1111,  -1075,   -336,    -93,   4392,  -7002, -20908,   3472,   7000,   5368,  -7646,   1837,   1716,  -2659, -13011,  12645,  -4343,   -968,  -5152,  -2869,   3914,    157,   3180,   -421,  -6743,   6909,    336,  -2964,   -901,  -2462,   9481,  -6994,   4662,   3697,  -4503, -15229, -12812,  10004,  -1918,   2892,  12307,  11424,   1968,   -551,  -4755,   4716, -10758,  -9818,  -3187,  11081,  10367,   5606,  -3944,   1137,   4364,   3224,   4630,   3759,   5906, -14541,  -6975,  15582,   7557,  -6866,   2661,   5394,   1155,   5326,   3642,     92,  15168,   9650,   7026,  14932,  -7046,  -3849,    274,    770,   9353,  -7417,   -902,  13297,  10898,   4641,  15382,  -6728,   4422,   1374,  -5566,  15660,   5540,  -9900,   5485,   3063,   7060, -14050,  -7995,  -1204,  -1669,   7074,   1809,  -3975,   4755,  -2756,  -3477,  10979,  11984,  -3682,  -2889,   5907,  -6019,  -4118, -12704,  -2680,   5960,  12129,  -7193,   2702,    579,  13916,  -6944,  -1787,  -3935,   4613,   2066,  -1044,  -1474,   1607,   -654,   1015,  -4315,   7248,   6499,  14793,   7890,   9038,   5836,    533,  -2199,   2689,  -9147,  -1848,  -3941,  -5381,  -1158,  -5584,  11293,  -1174,   9512,  -4875,   8344,  -2754,    363,  -6812,   2895,  -5450,   2559,  -1833,   5006,   -289,   2469,   2332,  -3355,  -4376,   2950,   5039,  -8217, -12675,    447,    961,  16732,   9993,   4154,    -89,  -1639,   7242,   4653,   3849,  -5639,   -575,   -286,  -1426,   4428,  -8253,  -1588,  -1935,   4328, -10478,   3394,     95,  -5576,  -4363,   1968,   8466,  -1881,  -9500,  -3337,    691,  -1143,  -2198,  -1817,  -3114,   8743,   7925,   4191,  -1884,   7557,  12278,   3288,  -5315,   3607,   6502,   8045,   3300,   8409,  10716,   7483,   -328,   2185,  -7841,  -2721,   5922,   -724,   5398,  -1344,   3817,  -1258,   5495,   2336,   2497,    213,   4716,   1417,   7243,  -4662,  -7651,  -6183,  -2129,  -2807,    -40,  12445,   7929,  -1461,   1947,  -2210,   -710, -10835,  -3864,   2187,   -232, -17716,     76,  -3230,  -4469,  -2732,   3200,   3954,   3681,   6079,  -5256,   -998,   3852,  -4872,  -9647,   4314,  -8774,  11498,   5086,   -887,   3988,  -3387,  -8968,  -9926,     80,  -4518,   -593,  -2871,  -2997,   -833,   5059,  12394,  -7736,   5351,   2514,   8327,    349,  -8767,  -8295,   4947,  15303, -10507,   1986,  -3174,  11273,  -2720,  -6554,    536,   1654,
         13032,  13201,  -4123,  -7931,   8237,   -460,  -5286,   6939,  -1481,  -4934,   5235,  -3709,  -3161, -17184,  -2742,   9938,  -9786,   4909,  -1049,   1071,   5341,    644,  -2878,  -1068, -13822,  -5037,   2503,  -3453, -11564,   1248,   7858,   -477,   -510,   5391, -12310,  -3516,   6425,   8433,  -8030,   4272, -12264,   7321,   4866,   1923,  10734,   2910,   1744,  -4887,  -7905,  -1160,   2798,   5700,   4752,   3203,   4712,   1615,  13367,   8001,  -2329,  -2903,    106,  -3596,  -3008,   1171,   4127,  -3607,   2549,   6452,   2071,   5118,  -3709,  -1741,  -8273,   6757,   -847,  -4899,   5419,  -4114,  -2534,  -6874,   7552,   3234,   6538,    944,  -8141,   -773,   3881,    377,   2135,  -1329,  -4489,   6591,   3187,   5226,  -3839,   8368,   1298, -13666,   3441,  -4354,  -2554,   3990, -10636,  -6101,  13131,   8508,  11903,   1891,  -1730,  -6856,  -1217,  -6177,  -7394,  -1195,  -2257,  -7784,  -8476,    788,  -3783,  -2014,  -6213,  -1522,   -970, -10028,   5489,    -78,  -3236,   8161,  14050,   4088, -16792,  10779,    130,  -5180,  -5862,  -2215,  -1993,   4356, -10459,   -510,   8383,    822,   3036,  -2402,  -4575,   9417,   4302,   3880,  -3435,   7106,  -1891,  -1201,  -1514,  18330,  -2205,  11671,  -1167,   1654,   1561,   -582,  -7569, -10192,    999,  15767,   4215,   2992,  -3928,   -297,   -825,   6203, -15732,   1825,  10207,   8475,   8857,  -1992,  -1657,  -6768,  -6341,    388,   3943,   1172,   3078,   3658,  -6026, -10827,  -5090,  10738,    253,  -3979,   5719,  -4937,   -406,   5636,  -2269,  13904,  -9636,  -3636,   1168,   6026, -10919,  -9673,   2437,   6845,   -342,   3135,  15057,  -4976,  -2561,  -2827,   1695,    618,  -6599,   7342,  -2461,  14648,   6314,  -7536,   8669, -12272,   -446,   4841,  -5749,   2790,  -7043, -20886,  -2791,   4030, -10668,  -4111,  -8531,  -6117,    213,    178,  -6440,   9144,   -840,   3309, -13293,   4832,  -7191,  11162, -12626,  -2673,   9893,  -7065,   2243,    874,   7961,    -51,    884,   9667,  -2176,  -3265,   6558,   9255,  -5999,  -8791,  -2650,  -7711, -13637,  -5304, -11868,  -6342,  -2466,     75,   3282,  -7955,   6536,   6938,   5416,    256,   8044,  11897,  18522,  -2765,  16869,  -3811,  -7699,   3341,   7718,   5640,    700,   7987,   -751,  11476,   3651,   5674,  -4491, -12601,    845,  -7448,  -7314,  -2826,   6618,   2117,   5215,  -2340,  -7417, -10471,    703,   -474,   8272,   6129,  -1663,    193,  19680,  -4953,  -1477,   4177,   6569,  -1110,  10006,  -8622,  10890,   7852,  -3631,  -1269,  -4767,  -6092,   -245,     70,   -299,  -6228,  -3043, -10478,   -932,  -9565,   3400, -12437,  -9334,    379,   -850,   6583,   1218,  -1702,   3807,  -7326,  -1385,  -3564, -13370,   -727,  18855, -10753,   4414,  13233,     85, -11694,  -5130,   8676,   9883,  -6983,    798, -10909,   -444,    -16,   7880,   8470,   6465,  -2992,  16350, -10789, -11856,    949,  -1386,  10403,   6124,  12918,  -1201,   2350,   6220,  -9272,   4256, -13094,  -3239,  -4387,    -85,   9165,   8838,   6221,   5677,   8936,   4633,   7261,   3529,  -5995,  17992,  -5883,   1615,   3446, -11914, -12118,  -2091,   5192, -17324, -12731,   2828,   9264,  13580,    725,  -8855,  -1132,  -2528,  18374, -10916,  -7986,  -6182,   5385,   6416,    750,  -2868,  -4573,  -4671,  -2544, -14237,  -8877,  -1110,  -1449,   7267,  -8986,   4456,   5961,   1570,  -3461,  -3845,   1559,   6010,  -2447,   4416, -14297,    122,  -4708,  -3059,  -8301,   7473,   4075,  13991,  10291,  14879,  -4597,   -754,  -2803,   1252,   -246,  -3807,   7452,   3668,   7220,   5685,   9790,   6187,   7230,  -3265,  -7104,   -509,  -6453,  -4720,    899,   -540,   6496,  -4086, -12998,  -6786,    273,   5944,   6867,   3132,   6034,  -3406,  -1373,  -5775,  11635,  -6970,  -2635,  -1102,  -4536,   4400,   1923,  -2131,   3666,    700, -15225, -10865,   1216,  -5941,  -3956,   5520,   7490,  -7689,  -8035,  -6520,  -1081,  15877, -16286,  -4061,  -9705,  -2621,   5128,   9896,  -3031,  -5344,   5241,  -5846,  -1806,  -5988,   -285,  -5428,   4678,    330,   -635,   1106,  13781,
          7005,   4174,   6166,   2857,    489,  -9069,  -3082,   1952,   4526,  20523,  20014,  -1026,   1043,  -6089,  -7009,  -2193,   6688,   2496,   7719,   8200,  -2152,   3675,   7805,   7979,  -1807,   4938,  -3392, -17280,  -2695,   3979,  17928,   -426,  18276,   4829,   4725,  13255,  -4702,  -8239,   4393,   3172,   7787,   5066,   2998,   5736,  -1900, -10790,  15613,  -1355,  -1810, -11973,    735,  12895,   2592,  -2754,    602,  17108,   5148,   4788,   -570,  -8897,  10662,   5437,   6678,   2119,   4383,   7781,   6220,  11781,  -8470,    642,  -1573,  -5900,  -3574,    656,  11663,   1495,   -983,   4321,   3419,  -3388, -13594,   7130,  -6062,   4770,  -2719,  21266,  -6036,  -8587,   -296,    876,  -5136,    -22,   3715,  10179,  12644,   2915,  -2832,  -7528, -10788,  12630,  -5016,  -6271,     59,  -2888,   -667,  -2423,   5900,   6682,  -4175,   9735,   9274,   -857,   -689, -11570,   6395,   4094,   2923,  -1557,  -1714,  -7040,   9390,   4928,  -3630,  11685,  -8664,   1540,   3532, -10818,  -4001,  -2826,  -4661,  -4877,   -509,   9723,  -4044,   3919,   -998,  12329,  -1344,  11772,   6851,  -6075, -11355,  -2422,    -52,   2954,   1769,  -6659,   7624,  -1676,   4064,  -3897,   1345,   5631,   6602,   6624,  -4929,  -3200,  10025,   4033,  16945,   -484,   2112,  17981,   4433,  13038,   1560,   3231,    819,   -790,  -1639,  16666,  15623,   6673,   9337,   4771,  -1295,  -4288,   4017,   8246,  -3626,  -6859,  -4460,   -235,  -3047, -11156,   5034,   6698,   9293,    357,   6760,  -2905,  -1265,  -6370,   4815,  -4559,  16520,  -5305,  -6355,   6360,   9768,  -6979,   4628,  11324,  -1593,   4356,  -1278,   2732,   2114,   1922,   4865,   6263,    258, -11879,   4296,   -823,   2297,   8430,  -6008,   6638,  11699,   2564,   1082,   -208,  -3358,   3262,  -1281,   2095,  -6801,  -1608,  -5357,  -1211,   6714,   8819,  -1654,  -8113,  -6425,  -1444,   1664,  -7757,   1408,  -1146,   6934,  -7584,   1704,  10602,    225,  -9697,  17072,  -3721,   9720,   3882,   -996,   2270,  -5349,   6691,  -8099,   7284,  -5028,  -3093,  -2211,  -7659,  -9206, -13383,   2430, -12573,  -2099, -13523,   2178,   2873,   2942,   -303,  -1504,  -1990,   1843,   2774,   -147, -12087,    423,   9148,  -9693,  11674,   1992,  -2483,  -5161,  -4852,  14321,  -4013,    594,  -2953,  -3071,  -1401,   -263,  -7423,   -946, -16650,   -609,   5138,  14030,   4210,   -265,   6382,  17814,    947,  -3917,  -2289,    807,    284,  -6148,   5895,    -30,  -7341,  -3373,  -8136,   6013,   3096,    -59,  -2547,  11551, -12348,  -3507,  -3283,  -6729,  -4458,   1710,   1475, -12443,   -824,  -7716,    507,   8125,   9911,   9675,  -6326,   3876,  -4193,   1850,   3105,   3588,   4628,  -2559,   3846,  -3736,  -8204,   7902,  -2179,   7112, -12106,  -3221,  12317,  -6349,  -2206, -14217,   -697,   9177,    755,  -5693,   7768, -13968,   5332,    305,  -7325,   6792,  -7914,  -2512,   -569,  -5710,   -823,  17913,  -2845,  -5921,   1763,   3894,   6437,   1366,   3037,  21463,   5595,   1758,   2422,  -3287,  14473,    412,  -7987,   7066,   9303,    505,  -3850,   5734,  -4370,  -8980,   6991,  -8407,  14924,  -3806, -12696,   3780,   -184,     16,    708,  13734,  -9314, -14963,   5398,   4916,   8357,   6594,  -4194,   6871,  -1191, -11438,     48,   3211,  -7745, -16708,   -310,  -2980,  -6559,   3412,  -7253,  -2207,  -3604,  -2734,  10656,  -4292,   7196,  -3550, -13241,  -7220,  -8720,    201,  -2350,   8056, -18131,   4037,   1533,   6744,   -559,   2683,   2668,  -9541,   1633,   -172,  14669,   2763,   6722,   4097,  -9650,   5427,  -3232, -13218,   -402,   7740,  -6008, -10890,  -1681,   6063,   6058, -10046,   4280,  -4838,  15233,   -637,  -5752,    863,  -5453,  -7177, -15024,   7017,  -5264,    578,   3114,   -129,  -4483,  10079, -10780,   4715,  -4523,  -8572,    860,  -1369,  -5163,   2559,    394,   3210, -16464,  -1454,   3536,   6163,    -92,   2358,  -3775,  -1458,  -4565,    820,  16162, -17743,  -2713, -12202,  -9211,    689,  -7339,   4411,   -693,  11632,  -3559,  -9887, -16592,    585,  -7617,    523,  -3176,
         -2543,  10627,   5961,   2559,  -8038,   5210,   7447,  -1830,  -3777,  -9133,   5980,   6197,   -485, -14839,  -5872,  -4823,  -2441,   1170,   2733,   3862,  21302,   3589,   -703,  19250,  -4485,   2831,  -7617, -14138,   8103,   -444,   -144,  -3561,   8759,  -1407, -10339,   5280,  -1939,  -1742,   2622,   1285,  -1415,   6071, -12124,   4119,  11484,    329,   7914,    737,  -1028,  -5629,   2883,  -9379,    101,  -8357,  11892,  -5056,  -1593,    631,   6304,   8422,    997,   6361,   3771,   5043,   2176,   4183,  -8159,   4041,  -7478,  -8895,   2626,  -6956,  16605,  -6565,  -6987,   2750,  -5000,   -613,    -76,  -6558,    864,  17513,   1737,   3288,  -2521,  -4857,  -5424,  -2890, -10226,  -8260,   -421,  10359,   1605,  -2947,  -4086,  -5228,  -2581,  -2820,  -4849,   6178,  -5908,    740,   6380,   4285,  -1411,   4180,  -2060, -10760,    722,   1983,  13176,   3724,   6043,  -6596,  11578,   -898,  -1753,  -5830,  -6725,  -8029,   -103,   4009,   6613,   7390,   5170,   5933,  -9447,  -1474,   5196,  -8396,   4816,    973, -12710,   9700, -10623,   2147,   6847,    957,   4448,   3043,  -4231,  -6161,   4925,   2869,   2331,   6037,  -8925,  -5070,   5267,  -2669,   4130,  -3085,   1380,   2922,  -4792,  -3074,  14542,  -1018,  -8980,  -1666,   1645,   4695,  -2021,   4108,   7100, -12709,   7727,   1560,  -3115, -12161,  -6791,   2311,   8529,   5641,   1291,   3807,   7006,   -829,   3056,    615,  -9423,  -8299,   9654,  -5072, -12986, -15728, -22197,  -4285,  -2639,   2824,   -813, -15526,   -295,   -622,  -5786,  -3015,    613,   5312,  -2917, -13447,   2938,  -7382,  -1930, -12522, -10602,   8254,   1699,   5277,  11021,   1409,   4247,  -1710,     11,   6177,  -7693,  12972,   6661,   2369,  -4695,  17046,   7636,  -3388,  -7174,  -7055,  -2944,  -7977,   4166,  13662, -15231,   4540,  -1749,   2768, -18052,  -2611,  -2904,  -4198,  -8765,  11968,  17424,  -1551,   1348, -14550,   3215,   3512,   2048,   2269,  -1261,   4311,   2541,   2602,  -3841,  -2979,    192,   5473,   4759,  -3248,   3704,  -3898,   1761,  -2867,  -5322,  11500,  -2555,  -1888,  -7408,  -6967,   -100,   2346,  -2761,  11192,   2072,    694,    666,    286,   3152,  -1259, -14251,  -1869,   8502,  -5683,   3968,    637,  -5165,  -5845,   6763,  13067,  -2172,  -1104,  -1312,  11955,  -5133, -12459,   7874,   -183,   -233,  -5069,  -6206,   7960,  -5305,  -6471, -10452,  19464,   -988,   2308,  -5097,  -1777,    484,    -10,  -4165,  -5938,   -932,  -2738,   2478,  -5472,  -8447,   1294,    600,   9174,   2566,  -1525, -24879,  -5932,  -7666,  -1755,  -3664,  -1830,  12419,  -1319,  -8286,   7984,   -358,  -3451,  -4812,   3846,  -3204,  -2007,  -7445,   1388,   3683,  -1164,   5181,  10879,    128,   -738, -26225,   7840,    198,   3787,   1271,   3165,  -4008,  -3060,  -2296,   -945, -14482,  10808,  12123,  -3202,  -6170,  15753,    166,  -7756,   1033,  20546, -11570,  14551,  -7571,  -4365, -18955,  -4004,   3466,  -1543,   3017,  -5826,   -640,  17771,    320,   -276,   4520,  -3342,  -2746,  -2571, -14282,  -1613,  -3773,   2226,   3110,  -3389,   -271,  -9091,   1726,  -4672,  -3050,   2685,  -3705,   3638,  -3102,  -6254,   2946,  -5114,  18984,   6276,   4207,   -290, -10327,   4698,   5925,  -5513,   2219,   -480,  -4714,   5454,   1299, -11323,   8756,  10446,   -388,    143,  -3543, -14743,   6602,   7526,  -4174,    780,   -422,  -4894,   1070,  -9381,  -4458,  -1076,   5645,  -3197, -13094,   2842,  -2696,  -7617,   1065,  -4355, -16199,  -5501, -10915,  10233,  -6021,  -8985,   5052,  19654,  -1871,  -8556,   6135,   5487,   -857,  -1887,  -8307,  -7797,    439,  -2892,   9946,  11889,  12434,  -7783, -10755,  -6999,  -5202,    957,   9755,   1065,   2213,  -1785,  -1179,   8719,  -7219,  27067,   9793,  -8026, -11664, -13401,  -1690,  -8423,   -524, -10460,   1335,  -5931,   -233, -15273,  -5073,   6113,  -1871,   7980,   3424,  14034,  -3292,   6743,  -1218,   1270,  -9820,   9005,     13,  -1894,   1073,   7200,   2627,  -6476,   -362,  -4917,  -2424,    911,   4943,   4397,   8602,   3093, -12242,   1407,
         -8035,  -2183,  -2055,  -9102,   6648,   7388,   6103,  -5646,  -8636,  11036,   6868,  -5094,  -9137,   -596,  -6727,   2424,  -8204,   5302,   -957,   4318,  24692,  -6306,  -6400,    967,  -7604, -12564,   6756,   1192,    171,  -2700,  -5721,   -892,   3888,  -3408,  -3720,  12429,   6602,  -1944,   1664, -10034,  -5482,   3031,  -8032,   1809,   3662,   2431,   3828, -12740,  13630,   9753,   2468, -11596,   -375,   2740,   3035,  -8903,   1307, -11217,  -4148,   6915,   4692,   1267,  -4536,  -3082,   8983,   5309,   6442,   6912,   3802,    -24,   2428,    689,   4955,   8030,   3550,   2659,   7874,  -3673,   3924,  -2280,  -1977,   2465,  -1524,   1378,  -6816,  -4017,  19100,   1277,  -5340,  -1391, -10702,   9477,   6547,     51,  -9504,   -707,  -6780,  11777,   8112,   4713,   -498,  -1483,  12337,   6726,   1412,   2964,   3873,    846,    305,   6958,   2209,  -6622,   9462, -13128,   2023,  -7476,  -3389,  -5374,   3947,   2731,  10654,   8326,  -1183,  -2843,   -963,   6245,   4901,   2822,   4157,  -2612,   1349,  -1378,   2159,   3049,    766,  -4473,  -6031,  -3139, -10334,  -2076,  -4178,    167,   7487,   5606,  -1673,   4000,   1165,  -3932,  -3837,    716,   7014,  -6548,   -514,   8446,   -269,   1675,    986,  -9010, -14046,  -1338,    268,   2176,   3410,   7544,   9843,  -3069,  -1752,  -3265,   -235,   1878,  -1623,  -5792,    751,   2347,  -2059,   8512,   3192,  -3920,   4063,  -7673,  -6836,  -1509,   -699,   -534,  -2746,  -5058,  -4993,   1593,  14972,   -975,  -4200,   -655,    444, -17491,  -3754,  -6879,   2965,   4026,   5073,  10036,  -1085,   8759,  -1069,  -6264,  -2167,    -32,   -207,  10170,   1281,   4150,   1145,   3348,    800,   -683,   3781,   -691,   1083,   4883,  -4339,  -3705,   6075,    589,   3101,   2559,   2363,  -2704,   2870,  -2209,  -7020,  -7674,   -748,  -1959,   9323,   5620,  -2471,   2420,   -197,    255,   3238,  -1485,   5262,  -5259,   5010,   6313,   1147,    -18,   -743,  -2122,  11049,   -588,   -900,  -3893,    654, -10909,  -3328,   6131,  -8755,  -2493,    360,  -7345,  -2630,  -7094,   1617,   5070,   4689, -10808,  -1170,   4412,  -1837,   9110,    216,  -2393,  -5821,   5743,   4937,   4188,  -2041,  -3667,  -3705,   3996,   1879,  10895,  -2298, -10695,   1327,   2838,   6993,   2323,  -7824,  -3727,  -1300,   7569,  -6830,  -1171,   -337,    209,   3444,   8638,   6548,   1733,  -1222,  -9249,   1098,   8305,  -3256,  -2554,   3190,  -5073,  -3050,   3792,   7544,  -4900,  -7459,   2904,  -8567,   1491,   7227,    306,  -2705,   1374, -17659, -11252,   4117,   4406, -10714,   5596,  -1052,  -3703,   3188,   8081,   8802,  -6105,   2594,  -5070,  -3749,   5883,   3645,   5532,  -2274,   2659,  -5019,  -6126,   2860, -10259,   2946,   9394,   -242,  14246,   8017,     -3,  -1363, -10567,  14432,   -609,  -7117,   4563,   7561,    -33,   5447, -10056,  11561,  11828,   8697,  -2809,   -900,   6218,  -9657,  -8860,  -4223,   3755, -17510, -14234,   3818,   4522,  -1495,   8348,   -943,   1504,  -7003,   3042,  -1983,   5385,   -589,  -7244, -14330,  -4747,   -204,  -9386,   3317,   6373,  -4084,  -8797,  -8950,  -2519,  -3552,  -8122,  -2450,  -9968,   1995,    974,   4626,  -2024, -22641,   1446,  11181,  -3526,   -880,  -2206,  -3501,   2100,    947,   1814,  -2561,   1152,  -8997,   3317,   8179,   -899,   4574,  13656,  -3409,   6281,   1850,  -3211,   1674,  -9963,  11734,  -9918,   4628,  -8102,  -3589, -16079,   9778,  17076,  -2279,  10013,  -3142, -10134, -11386,   2574,    177,   6092, -11290,  -4733,  14900,  -2217,   5372,   8035,  -9020,  -5235,   2073,   3728,  -2919,   4970,   2844,   5499, -19325, -10653, -10521,  -5322,   7197,   9761,   4918,   1306,  -8691,    377, -12605,    641,   -755,  -7029,   -923,  -6602,  -9924,  -4325,   9670,   1018,  -6224,   -352,   9423,  10892,   3112,  -5799,  -5531,   3872,  -3816,  -6019,   1166,   6711,   4498, -11760,  -1802,  18853,   5509,  -2692,   -237,  -4015,  -1396,   2720,  -1613,  -9360, -13010,  -5758,  -3422, -15475,  -9665,  -3399,  -5436,  10169,   3732, -11898,  -4779,  -1074,
         -5362,    266,   1939,   4668,   3024,  -2843,  -1090,   4595,   5238,   2162,    540,  13164,  19472,   4182, -12437,  -5838,   5566,   5401,  -9354,  15149,  -2119,   1699, -11978,  16199,   7486,   -837,   -554,   8456,  -4583,   6277,  -9918,  -1551,   1723,  -5091,   1856,   1688,  -1405,  -4815,   8109,    -63,  -3254,   8575,  -5647,   2695,  -3982,   1806, -11997,  -3688,  -3654,  -5865,   5735,   1093,  -4669,   4741,   -957,   8365,   -638,  10699,  -7260,   3382, -18317,  -8212,   4461,  15235,  -7209,   7387,   1056,   9632,  11868,  -1911,   5326,  -5541,  -7697,  -4398,  -1949,   3360,  -7828,   8288,  -5413,  -7793,  -3690,  -2553, -11222,   9097,   5702,   1841,  14694,   -820,   6375,  -1868, -10859,   1750,   1228,   4713,   3755,   1271,  -3363,  -5947,  -9101,   8054,   8263,   1577,   9626,   3047,  -2730,  -7821,  11759,  11139,    341,  -1064,    425,   5532,   1328,   1862,   6499,  -6920,  11119,  -4313,  14111,   -168,   -342,   5306,    108,   1907,   4415,  -5839,   7040,  -1112,   7288,  -7704,   7355,   1233,  -3935, -10281,   6492,   7516, -10995,   2767,   1228,   3418,  -5084,  -5485,  -9904,  -1908,   5907,   7182,   2209,   4139,  -4550,  -5512, -10128, -11153,  -9782,   7380, -18054,   5019,  10062,  -3529,  -7457,  -5906,   3640,   5968,  -2885,   8995, -11586,   6799,  -7891,    174,   3738,   6936,  -2215,  -5803,  -1493,  13045,    -70,   4478,  16031,   5417, -13660,  -2462,   4231,   -323,   2998,  -4086,  -2713, -14479,  -4214,   4720, -10378,  -1971, -11919,   4826,  18669,   4470,   1321,  -7665,   2328,   6472,  -9127,    499,  -6564,  -5310, -12545,   6220,   4060,   6028,  -7960,   2303,   6229,   7303,  -4529,    352,  10682,  -6342,   -716,  -1221,     20,   -986,   8138,   5334,   3015,  -6823,   1079,   3093,  -1885,  -3556,   4043,  -6646,   5237,  -1332,  12629, -12387,   5707,  -6300,  16579,   -403,  10526,  -3069,   4245,   5141,  -4057,    821,  -6237,  15518,  -7220,  -6563,   4944,  12669,  -1112,  -2004,   -738,    801,   1277,   1150,  -2329, -23411,   3453,  -3254,  -4374,  16952,    234,    130,   2074,   -989,   1211,  -3749,  -7082,  -3934,   4160,  15391,  -1384,  -4067,  -7412,  -3417,  -1537,   1118,   6996,  -9389,   3394,   -401,   6605,  12649,  -2133,   5772,   3912,  -1427, -16064,   -650,  12788,   4860,  -1634,   7458,  -1505,   5974,  -1554,  -3932,   5739,   5207,   2878,   4852,  -5404,   2838,   -817,   -858,  -4243,    345,  -4059,   2808,   1038,  -1717,  -7969, -15508,   -143,   1177,   9829,  -5364,  -1909,   6064,  -5349,   3289,  -6690,   1154,  -1086,   6204, -10009,   -787, -15007,   3553,  -3442,   1001,  -7688,  -4464,    963,   5142,   8697,  -4858,   1694,  -2130,    914,   5814,  -6146, -12272,  -7930,  10757,  -2037,  -1590,  -3052,  -6021,  -4755,  -1867,  -5807,  -4479,  -7801,   3166,  -3349,   -409,  13453, -10589,  -9883,  -7896,  -5558,  -2648,   6328,   3672,   7110,   -299,  13448,  -1235,  -8964,  -7230,   6161,  -4649,   2747,   -734,  -4563,   7494,   8993, -11533,  -1056,  -6939,   6799,   -902,  10014,  -3883,  -9364,  -8037,   5301,   5159,  11151,   1910,  16464,   3841, -14501,  -5023,   2727,   6524,   7128,   6058,  -5020,   1507,   1531,    185,  11931,   3654,   2722,  -1974,  11186,    114,   1656, -15048,  17810,   1036,   1766,   1460,  -1368,  -8169,   8079,  -7826,   1471,  12827,   2114,  -4826,    746,  -6111,   2652,    749,  10557,  -3275,  -4167,   6216,   6494,  -3549,   8246,   6216,  -8616,  -5146,   2714,   3499,  -4152,   6614,    813,   4825,  -3363,   8701,   1920,  14215,  -6470,   2271, -16772,   6140,   8820, -10845,   5515,   4720,   7139,  -8199,      6,  -3147,  -3078,   3786,  -7513,   9198,   5943,   5868,  12596,   3437,  -6451,  -9460,  -9399,    194, -15119,  -3841,   8847,  -3117,   9638,  10434,  -2405,   1941,  -5601,   6662,   5898,   2175,  -1451,   1009,  -1445,    523, -10347,  -5381,  -1475,   2574, -10194,   -862,  -2997,  11059,  -1429,   1439,  -2754,  -1056,   5032,  -8625, -10172,    992,  -7974, -12000, -10725,  -3251,   -376,  -2531,   8923,  -1749,   2671,  -7917,
         -2744,  -2114,   6757,   -938,  -2081,   7149,   9467,   8556,   9066, -10364,  -9620,   -868,  -5485,  -8708,  -3436,   6279, -13120,   6348,   4971,  15627,   1460,  -5638,    -32,  -9275,   8920,   -882,  -6545,   2342,   4233,  10607,   3062,  -8363,   -956,   -299,  -1634,  11306, -10168,   3500,   4856,   5545,   5252,  -3393,   5366,   1603,  -2301,   1766,  -1592,  -2665,   8034,   8675,  -1392,   3719,    824,  -2669,   1058,   4311, -11597,   -405,    532,   3777,   6487,  -2744,   5510,  -3355,   -384,  -9207,   2674,   3670,  -8008,   7909,   6302,  -5387,  -2789,   2643,  -9212,   -447,   5828,   5081,  -4195,     32,   2938,  -2758,   4810, -12571,   -116,  12354,  -1470,  -4632,   1477, -12448, -17643,   1854,   3253,   1395,  10923,  -2662,   3745,    592,  -1669,  -5683, -10342,   2061,  -3148,  -8598,  -2910,  -9419,   6686,  -7174,  -1093,  11176,   4023,  -5890,   7971,  -2762,  -5685,  -3606,   1648,   3480,   -175,  -8182,   4309,    396,   1967,  -3235, -10534, -10479,   9569,  -4578,  -6721,   3311,  -5538,   2537,  -2154,     25,   5013,  -3946,    114,   6627,  -9521,     12, -16577,  -9337,  -6155,   1601,    219,   3609,   4723,   3146,   8097,  -3962,   1479,   -799,  -1760,  -7812,   2240,   4159, -11112,  -2195,   4807,  17660, -11066,  -7830,   1303,  -9439,   -927,  -8010,   2524,  11620,   9067,  -6765,   4216,  -6554,   -464,   7216,    933,   6652,  14011,   5635,   -220,   -147,  -2181,   2739,   6681,   8563,  -6799,   3253,  -7747, -15925,   9819,  -2593,  16108,  11240,  -3820,   -306,  -6605,  -6406,  -1623,   7190,  -3807,   2886,   3488,  -3854,   8964, -13238,  -8373,  -3193,   1273,  -2843,   6428,  -1097,  -6816,   4022,    686,   7437,   5925,   7302,  -1407,   -560,     51,   2251, -14407,   2994,   9761,  -3825,   1551,  -2781,  -4410,   -863,   6202,  -2091,  -7430,  -1355,   8860,   3327,   1358,   2974,   7526,   6169,   8755,  -6659,  -3855,   6112,  -7992,  -8254,   1799,   4433,   4414,  -1428,   -865,  -6098,   7298,  -7111,  -7522,   5440,   9926,  -6491,  -9670,  -7958,   8650,   -610,  16584,  -5170, -17863, -11527,   4498,  -9131,  -1805,    -35,    389, -12455,  -2244,   5987, -18869,   7779,   7600,  -4421,    362, -15934,   2116,   9197,   1075,  -2070,   1601, -10687,   4178, -16163,   2677,   7872,  -4360,  -5980,  -4274,   2392,   3550,  17345,  -3036,  -6326,  -1263,  -5130,  -1387,   3043,   3012,  -6708,  -2043,  -8493,   5480,   5125,   3417,   -641,  -7570,  -9512, -10124,   -215,  -6256,   -709,   2053,   -930,  -9340,  -1765,  12029,  -7120,   7490,  -5703,  -5816,  -3334,   4204,  -6980,  -7665, -11230,  -3093,   6735,   2244,  -9129,   1106,     31,  12030,   2161, -18753,  -4912,  -2967,   6125,  -5417,   1246,  -3661, -13858,   2392,   4048,  -7207,  15841,  -2160,  -5572,   1301,  -7273,     47,   6234, -15458,   5103, -12649,   6311, -12619,   2468, -15040,   -110,  -9307,   -598,  -7756,  -7005,   2544,   5827,  -2090,   3665,   9596,   4649,  -1293, -11738,  -8384,  -3063, -12895,   -769,   6152,   7977,   5254,   -877,  -3107,  -4764,   2774,   2299,   9698,   -645,   7906,  -2412,   -348,   7201,  -3574,   7672,   8490,   8827,   9708,   4729,  -5382,   5147,   8323,   8221,  -4146,  -1907,   9401, -15523,  -3827, -10278,   8456,  -2551,  -5866,   9337,  -2341,   5154,  -3021,  13268,  -9191,   6447, -10396,   5611,   1544,   3861,     33,   1954,   3585,   4102,   6455,   -522,   5955,   8712,  -5261,  -5647, -11352,  14995,    863,   4080,   4916,  -6752,  -2197,  -4804,  -6460,   2913,  -4084,   3857,    -36,  -5298,    757,  -4349, -10402,  -6763,   1807,   9136,  14244,    292,   7014,   1192,   7583,  -2097,  -3705,   7532,   5937,  -4429,    -63,   2467,  -3463,    -63,   1266,  17234,   1528,  -3951,  -4488,   6031,  -2059,  -4809,   4538,  -2740,  14073,   -915,   1172,   7921,   2904,   7019,   5440,  -2345,  -4948,  -3296,  -6835, -10586,    -12,  -8858,  -3422,  10194, -10195, -13373, -11655,    915,   6332,     59,  -1319,    836,  -8523,  -2851,  11845,  13948,  -9720,  -1459,  16526,   9334,   9430,   3497,   5234,  -3298,
           587,  -1461,   7155,  -5003,   1064, -11225,  -1719,  -2885,  11394,   1436, -13322,      0,  -7760,   2009, -11212,   3297,  -9433,  -3382,  -5725,  -5009,   1384,  -3691,   5687,  -1752,   3535, -14679, -12173,  -6935,  -8181,   5425,   2179,  -4535,   3511,   5657, -12769,   -999,   1132,   1355,   2058,  -1417,   4848,  11384,   4380,   4129,  -2862,  10871,  -3364,  10093,  11090,   3336,  19718, -11066,   6293,  13309,  -6759,   9973,  -4232,  -4715,  -7324,  -1349,    178,  -4973,   2395,  -9307,  -6749,   -230,  -3085,  -5372,   -433,  14459,   4120,  -5335,   -837,  -3565,   6171,   4152,  -5554, -27319,    -57,  -1402,   -272,   5272,    287, -16093,  10727,   7929,  19478,  11452,  -1841,   4219,   6708,   6028, -11789,   -276,  -4225,  -9701,   4951,   9929,   7480,   1600,   8670,    527,   8898,   2801,  -4074,   1837,   1665,  15922,  -7291,  10724,  -6155,  -4159,  -7218,  12080,  -1620,  -7070,   3542,  -4129,   3230,  -4777,   1676,   3600,  -7849,  -6712,   1390, -10035,  -5374,   6165,  -2665,   5658,   4212,  -1297,  -5464,   6751,   5073,  -9699,   4731,   2418,  -7335,  -1416,   3932,  -5310,  -8298,  -2648,  13527,  15754,   3251,  -9587,   6799,   7592,   -643,  18410,    915,   8014,  -7585, -10574,   2505,  -4238,  -2004,  -4251,  -6722,   7158,  10321,   2821,   5642,   2952,  -3910,  -6254,  -7158,   9040,  -4096,   -851,  -4423,  11098, -13984,   5418,  -9935,  21536,  -1478,  11472,    -15, -15039,   8315,  -1102,  -4131,   2262,  -1226,  -2995,   3381,  -5957,   9337,   5958,   8110, -10437,  -3117,  -4277,   4498,  -1512,  -1551,  11200, -13796,    328,  -9062,   -120,  -7686,  -8406,    623,  -9232, -11347,   5716,  -8684, -16633,  -3040,   5583,   7752,   -309,   3012,  -2824,   1877,   4740, -15617,  -7722,  -1450,  11404,   2841, -14315,  -8879,  -5656,   3069,  -3685,   -192,   2566,   2789,  -9192,  -6291,   5351,   5311,   4220,  12637,    164,   6066,  -1683,     33,   -637,    886,   7021,  -4998,   2386,   2121,   2517,  -2072,  -2555,   4217,   2926,   6748,  -2382,   5581,  -2625,  -2364,    -24,   4415,  11424,  -4857,  -4982,   -302, -12868,    815,  -3839,   6665,  -6313,   4485,   -570,  -2055,  -2365,  -1922,  -7813,   4178,  -4427,  -4314,  -7433,  -7191,   6125,  -3103,  -2382,  -8099,  12062,   2928,    482,  13458,   7734,   2406,  -8283,  -2353,   8020,    480,  -7929,  -7807,   3811,  15476,  -9810,   -138,  -2972,  14545,   8885, -21109,   4277, -12963,    322,  -8513,   -675,   7818,   4144,   4096,   5661,  -2413,   7043,   -906,    284,   4669,   2017,   3338,  -1523,  -3122,  -3188,    731,   1017,  11314,  -2468,    192,   7516,   2876,  -1014,    -63,  -6934,  12023,  -9619,   6386,  -7398,   6959,   3541,  -9671,  -3079,  -6985,    952, -11870,   9237,   7623,   5902, -10484,  -5210,  27560, -13641,   5274,  -5370,  -7678,  -7821,  -2416,   4336,   2654,  10154,  -1616,   -756,  10114,   5298, -16217,   4196,  10068,   2048,  13248,  -5919,  -1053,   8103,    446,   1371,   6991,    285,   4584,  -7737,  17581,   -806,   -219,  -9589,  -4014,   5862,   3598,  12174, -11635,   2223,   6434,  -8126,   4950,   4208,  -2422,   6674,    792,   2264,  -7374,  -9288,   -630,  -7153,   9240,   8738, -16011, -13509,   9995,  -2834,    506,  -4627,  -3555, -15879,   -406,   3929,    606,   6485,  -2842,    -10,   2330,  -1089,  -4471,  -7044, -12592,  -2722,  15170,  14117,   7593,   1470,   2668,  20592,  -6193,   3447,  -1584, -12344,  12787,  -3006,   6659,  12061,   6906,    831,    236,  -3132,    487,   6328,   1617,   4682,  10582,   6043,   5621,   9063,   5992,  -4916,  -5450,   5517,  -6864,  -4089,  -4590,  16618,   -860,  -7767,  -6145,    303,  -2129,   5949,   5182,  -6907,  -8234,   3703,   7184,  -4908,  -3154,   9675,  -3487,  -4388,  -2555,  -7286,   3021,   5132, -12878,    454,   6747,  -6043,   1227,    991,  -6174,   -980,  -6992, -13695,    930,   6481,   9878,   2867,   1590,   5488,   8190,  -9768,   7795,   5789,  -9631,  -6123,   1274,   2356,  -4767,  12287,   4473,   4493,  11381,  -5491,   6348,  10345,   7443,  -6236, -12545,  -4743,
         -3811,  15140,   7174,    247,   4377,   7081,  -2003,  -2921,  -1993,   5538,  -2646,  -5169, -10960,  -7483,   1518, -14138,   7154,   7165,   1059,  -2222,  -5610,  -7214,   4715,    -10,  -7096,   -941,   5378,   2349,    288,   5798,  -8079,   2557,  -3849,   7094,   2184,   1746,  10184,   8721,  -1330,  -1990,   -323,   3647,  -1181,   4844,   2224,   2806,  -4394,   3448,   2072,  15093,  -5012,  -1838,   1676,  -6704,  -9472,   2734,   6323,   9547,   6427,  -9029,   5683,   2330,  -1465,  -4493,   5296,   8611,  10275,   1510,   -861,   3283, -20830,   -911,  -5389, -15260,  -8461,  -4257,   5131,   9560,   3400,   9268,  -4688, -10029,  -3288,  -4097,   8738,   5411,  -2456,  -2278,   6145,   1222,   6558, -10818,   7304,  -3883,   9828,  -5350,  -4172,    821,   4740,  -3731,   4906,   8689,   1552,  15334,   6789,   5109,  -1423,  -4192,  -6252,   6109,   7057,   3793,   9164,   7543,   2604,  -1933,  -2487,   2283,    520,  13517,  -4533,   4804,   -374,   2064,  -5428,   1114,   3523,  -3065,   4165,   -902,   1429,   8157,   9976,   4495,  -5697,   5827,   5556,  -1882,   1292,   3098,   9375,   3377,   1303,   4123,  -2624,  -1997,  -8973,    398, -10154,   2856, -12247,  -3895,   1235,  13115,  -5866,  -6618,   1880,   4792,    663,  -1890,   -942,  10909,   -954,  -3216,  -2994,  -3634,   1096,  17359,  -7168,   5025,   3718,   4685,  10127,  -1390,  -9422,   -449,   6233,   8641,   7265,  -3177,  16073,   6933,  15215,   7156, -14707,   7417,  12683,    610,  15602,   2929,  -3991,   7841,   4286,   3331,  -1687,  -3254,  -1451,    807,  -5413, -16331,  -1866,  -4436, -16548,  -4814,  -9165,   1940,  -5660,  -8484,   4327,   3781,   7295,   6495,   2047,   1786,   7632,  -6355,  -6712, -10183,  -3133,   2226,  -9550,    938,    835,   9242,  10154,   -620,   3870,  -4463,  12031, -16063,  -4706,  -2486,  -2677,   7118, -11237,  -7784,   -377,   4313,  -1671,   4160,   4613,   2355,   3663,   2548,   2652,  -4606,  -8110,   2439,  -1898,   3341,  -3012,  -1574,    418,  -2092,   9855,   2991,  -1841,   2480,   1311,    376,   -308,  -1251,   6837,   3752,   3532,  18540,  -5658,   -545,    779,  -5365,  -9354,  -2071,    -68,  -2174,    990,  -3449,  -1539,  -3143,  -4051,    956,  -5049,  -6767, -12681,   7097,   1556,  -4347,  11180,   5115,   6678,  -9567,  14721,    853,   1506,   5495,    800,   5771,   2810,   4718,   4931,   4547,  -6288,  -3538,   2142,   1869, -12359,  -7778,  -3406,   -583,  -1345, -13215,   3018,  10031,  -3076,    777,  14579,  12547,  -4319,   3826,  -2059,   -705,   -358,    274,  -8312,   3277,  -4939,  -1134,  16135,   3148,  10519,   7423,   8030,  -3341,   9513,   5139,  -8531, -13330,   8077,  21495,  -2361,   3869,  -2254, -15700,   -572,  16188,  -3825,  12956,   5379,   9756,  -6563,  -6105,   1052,  -1407,    399,  -7768,  -1927,  -4595,   -898,   2775,   2520,   8892,   1603, -11865,    756,  -1433,  -6927, -13661,     38,  -1113,  -3733,   3639,   2016,   2691,  -7329,   2078,   8695,  -2907,   3014,   4635,  -7117,   -477,  -7306,  -7006,  -7714,   5163,  -5981,   6764,   1392,   2365,  13256,  -6915,  -3699,   1471,    890,  -6454,  -4140,   7341,    792,   1480,  15442, -16170, -12847,   2707,   -654, -12059,  -5286,   5091,   6428,  -5631,  -5658,  -9416,  11824,  -4113,   -659,   5900,  -4057,  -1588,  12741,   4841,  -1191, -19107,   1929,  -5019,   1553, -12378,   7876,  -2405,   5623,   3477,  -7191,  -3560,  -9878,  -6948,  11616, -11431,  -5970,  -3216,  -1576, -12073,   2246,  -1073,    763,  -1842,   9938,   2233, -11680,  -2696,  -2993,  -5813,   8071,    708,  -8162,  -4604,   -406,    569, -10678,     28,  -1266,   2895,  -8219,   -247, -11646,  -1782,   -928,  -7879,   1391,  -1484,  -8936,   1536,  -2010,   3992,  -3333,  10207,  -3118,   8146,  -9148,  -3193,   9719,   5970,  13223,   7143,  -6838,   -755, -12605,  -2590,  10048,  -4133,   2456,  -2286,  -1797,  -1040,  -7741,    201,   3548,   3031,  -1586,   7579,   1579,  -2044,   4796,   7869,  10315,   -163,   3952, -17138,   2404,   4318,  -3335,  -1411,  -2689,   5124,  -9803,   5570};

    const static Filter<int16_t> l4_compress_filter(l4_compress_filter_element, -14, {1, 1, 128, 64}, {1, 1});
    const Filter<int16_t> *get_l4_compress_filter()
    {
    	return &l4_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l4_compress_bias_element[] = {
           307,    527,   -284,   -107,     18,    866,   -225,    686,    760,   -399,    764,   1405,   -505,    541,  -1123,    803,   -631,    121,    -73,    147,    203,     10,   -306,   -876,    167,   -439,    968,    160,   1161,    657,    424,    324,   -126,   -701,    307,    530,   -580,    197,   -165,    -75,   -572,   1046,     54,     22,   -297,    533,    277,    281,   -701,   -346,    744,   -761,  -1419,   -614,   -353,    559,    195,  -1885,    220,    648,      5,    -50,    838,   -571};

    const static Bias<int16_t> l4_compress_bias(l4_compress_bias_element, -11, {64,});
    const Bias<int16_t> *get_l4_compress_bias()
    {
    	return &l4_compress_bias;
    }

    const static __attribute__((aligned(16))) int16_t l5_depth_filter_element[] = {
          2527, -19163,  14007,  -8092,  -5036,   -435, -21056, -22181,  10792,  -5710,  -6663,  -2216,  13805,   7838,  14160, -10600,   5595, -15825,   2938,  -3145,  20024,  26860,  13197,   4991,   -427,   9829,  -5358, -15664,  16727,   5277,  10645,   1783,  16242,  -1419,  15620,   6763,  -2152, -14102, -14195,   2940,   7285,  -6788,  15010, -11347,   4694,  -8866,   2680,   2319,  -8186,   7641,   2103, -10505,  -2972,  -3597,   7133, -10829,  17622,   9984, -15014,   8463, -15931,   2214,  15411,  13777,  -5888,   8380, -16856,   8688,   1633,   5328,  13306,  22911,   3784,   -244,  -4086,   3657, -21588,  -8234,   5143, -17537,   6740,    781,   6672,   -613,  -3150, -29261,   5003,   9914,  -3725,   6611,  25458,  -1430,  -3505,   2076,  18527,  -3444,   9164,  -1835,   -840,   3265,  -5504,   -614, -13013, -12931, -20313,   5306,  -7053, -20139,  -5397,  17709,   9145, -13659,  -1110, -13588,  -4085,  -4556, -11141,   -814,  16218,  -2581,  16985,  20452,  -3982,    931, -18496,   1661, -20328,  16188,  15895,  -7200, -18630, -30061, -16906,   4118, -15330,  16534, -13401, -21462, -18574,   3030,  -5901,    -16,  16070,  -2843,  12458,  -4492,  18951,   7426,   7278, -13708, -21435,   6384,  -4453, -16398,  -8971,  13312,  -3355, -14506,  -9367,  27090, -12481,  13072,   3899,   6284,   -816,   -291, -18177,  -4551,  10252,  -7851,   9911,  17686,   6274,  -4271,  -6525,   1133,   -752,   -140,  12144,  -2084,  -6566, -12342,  -9039,  -4126,  -9571,  -8412,  -2841,  13106, -27065,  -1010,  14312,  -2878,  23531,  10352,  -6669,  -3437, -10853,  -8381,   5384,  11420,   8500, -15561, -15322, -13255,  11444,   8705, -17219,   2764,   -773,  -9416, -17669,  16533,     49, -10365,  20329, -12668,   2634, -12762,  -9963,   7014,  -2090,  14808,   5673,   -627,   3648,  26492,   9356,   9423, -22471,  11961,   2373,  12987,  -9328,   5922,  -2844,   9010,  -7243,  24262,   4192,  -6833,  11511,   3184, -26145,   8638,   7928,  -5461,  -5868, -17731, -14202,  -1231,    485,   3341,  -7681,  12991,   3999,  -3137, -18584,  -1041,   9612,  -9282,  -1199,  -6539,  10289,   1022,  -3499,  13603,    405,  -2840,  -9015,  -7895, -29073,   6051, -12824,   5068,  13766,  16867,  22730,   5789,    759, -10556,   6176,   1463, -14927,  -2817,   1601, -17143,  11525, -25969, -10368, -11978,  -3014, -30165, -10515,    275, -17330,   2234, -17473, -11996, -10924,   -531,   1873, -18142,   -714,   4471,   2909,  -5247,   -108,   2822,  14519,  -9652,   9822,   7680,    575,   8437,   -715,   4572,  -1255,  -4849, -15367,  -6246,  13430,  14275,   7991, -14026, -10657,  -2654,  -8212, -14001,  -1411,    -99,   5251,   5008,  -3204,  -9545,   6034,  -3001,   6084,  27356,  21076,   7654,   3132,  -3920, -17886,  -4267, -21741, -10949,   1764,   2254, -13137,    -20,  12166,  21343,  24883, -13021, -23924,  11716,   6811, -23159,   7983,  20133,   5723,  11175,  -4171, -11240,   4403, -15663,   4119,  -2015,  18409,  -5582,  16121,  -7437, -12560,  10035,  -5336, -19786,   4339, -23135,  -5564, -21251,  20498,  -5354,  12075,  23347, -18193,   5820,  -2043,  11419,  -5599,  -5362,  -1779,   3600,  -3304, -14967,  14635,  12258,  -5157,  -2937,  -3993,  -2799,  16345,   3868,  13514,  -5146,  -4887,  -7634,   6863, -14814,  22849,  11800,   3576,  -3279, -22898,   9620, -26667,   2996,  14175,  -8196,  -4915,  -1698,  -9752,  -3503,  -7459, -11561,  -4585,   4196, -19097,  13722,  -8161, -20158,  -8826,    380,  12760,    522,   6269,  -6324,   4325,   3111,  10779,  25325,  10850,  -1100,    -60,  19021, -15679,   5836, -17430, -17740, -16849,  -9693,   8148,   4205, -17895,  15351,   -817,   1898,  -4089, -19926,  -7410,   3764,  19612,  -7196,  -5372,  -3198,  16881,  -2269,  -3702,   5635,   2243,  24662,   4033,   1066, -10610,    653,   3106,  14837,  13369,  -7995,  -2403,  -3510,  -2031, -10235,  12379, -17725,   2906,   8746,  -5517,  10720,   9484,  -6946, -17859,  -4973,   7131,  10281,  20709,  -1757,  11920,   -650,  23369,   -734,  11018, -13077,  14773,    345,   8463,   6306, -21606,  -2313,  17229,  -6920,   3011,  -8504,
          4795, -12801,  15324,   -967,   1883,   7802, -17612,  21256,  11489, -19823,   8354,  11397,  -8436,   9879,   5421,  -6670,   1689,   8003,   -978,  -2277,  -1297, -16101,  -3187, -16357,  -7868,  -4452,  12494,  -5549,   7937,  -6020, -13729,  -4275,   2754,   7214,  -6988,  -4637, -14813,   9120, -25224,   9121,   6906,   9144,  -8093,  -8073,   3417,  10358, -16012,  19284,  18219,  -9749,  -5381,   2172,  20170, -20276,  12145,   2799,   5599,  18960,  17149,  26557,   2403,   7795,  12723, -11854};

    const static Filter<int16_t> l5_depth_filter(l5_depth_filter_element, -15, {3, 3, 64, 1}, {1, 1});
    const Filter<int16_t> *get_l5_depth_filter()
    {
    	return &l5_depth_filter;
    }

    const static __attribute__((aligned(16))) int16_t l5_depth_activation_element[] = {
        -30843};

    const static Activation<int16_t> l5_depth_activation(LeakyReLU, l5_depth_activation_element, -19, {1,});
    const Activation<int16_t> *get_l5_depth_activation()
    {
    	return &l5_depth_activation;
    }

    const static __attribute__((aligned(16))) int16_t l5_compress_filter_element[] = {
         -7559,  -5863,   2009,  -8563,  -9573,  -4371,  -9025,   5809,  -4121,    269,   1504,   6155,  -1025,   3141,  10139,  -4919,   4985,  -4633,  -5909,  -8239,   2190,  -4287,   7078, -17470,  -7754,  -5468, -11132,   6869,   1163,  -4280,   -138,   4104,  -2041,   6908,   7991,   4079,  -8311,  -7986,  -1508,  -5103,   7427,  -5571,   7199,  -4262, -12434,   5648,   2201,  -6606,  -4243,   9420,  -1706,   5612,  -2965,  -1750,  -9897,   5304, -10336,  11357,   2862,  -3346,   5757,    933,  -1790,  -9283,   5049,  -4566,  -9854,   7432,   1371, -15912,   4934,   1188,  -9289,  -2642,   6076, -14932,   5431,   3754,   7756, -12474, -11524,  -1981,  -5236,  10910,  -6829,    971,  -2328,  -2669,  -5254,  10818,  -1670,  -7428,   2334,  -2106,  -3822,  -9980,  -8801, -13165, -15251, -14607, -15793,   5716, -12356,   6633,   2486,  10937,   7430,  -2160,   6370,    206, -10945,  -6353,   8924,   7217,  -6526,   3887, -10409,  10592,  -2558,  -5807,   2423, -17536,   1338,  -6799,   9162, -14681,   2558,  -7195,   6517,   2003,  -8454,  -6375,  -6465,  -8464,   2377,   3450,   2476, -17074,   2954,   3554,   1617, -20707,   2127, -10771,   1807, -18406,   5988,      5,   4990,  -3478,  -6720,  -3844,  -2206, -16872,  -1127, -13462,  -3058,   6290,   -398,   3973,   5124,   2988,  -9532,   2110, -14974,   1960,   5132,  -5550,  -5960,  -7896,  -7973,  -3553,     67,     48, -15650,   6403,  -6628,  13803,   -442,   4044,  -5491,   1327, -10574,  -4390,   8921,  -2945,   4720,  -2647,   3630, -19355,  -1345,  -2415,   5541, -21865,   3489, -13517,  -7398,  -7082,    -34,  -3516, -11627,   5210,   4570,   -872,   7474,  -6828,  -2095,     -1,   5720,  -5031,  -3873,  -7844,   6410,  -7414,  -3954,  -9719,  -2279,   1643,  -3629,   8043,   4368, -10929,   6814,  -6921,    303,  -4073,    683,   6464,    857, -18421,  -8178, -10567,  -1896,  -1249, -15891,   2352,  -2065,   5276, -12604,   7021,  -1466,   -152,   1925, -12641,  -8196,   3047,  -6701,  -7175,    965,  -7313,  -2210,  -2354,   7060,   3711,  -7721,  10654,   9030,  -3080,  11593,  -7187,  -5863,    889,  -8740,   3452,  -3244,   -203,  -2799,   7473,   1542,    560, -10598, -10184,  -8818,  10379,  -4984,   5567,   9147,  -2488,  -3468,   3180,  -5333,  -4433, -11030,   -446,  -2774,  -6616,   5768,  -4846,  -9884,   4485,  -7297,   2272,   4813,  -6938,   -789,    -39,  -7630,  -2549,  -8172,  -7310, -11159,   8531,  -1013,   1459,  -4899,  -7225,  -1735,  -4114,   2508,   7886,   5520, -10982,    714,   1515, -12947,   4871,  -5388,  -6791,   4995,   5676,  -1861,   6773,  -9449,   2275,  -4477,  -4595,  10555,  -7917,  -8547, -10144,   6974,   2467,   6018, -18405,   6741, -15089,  -7404,  -4235,  -5294,  -7613,   2774,  -6266,    493,   1942,  -5617,  11076,    455,  -3361,  -5562,  -1014, -13907,   5341,   1445,  -6412,  -2992,   5737,   2633, -10671,   -877, -13767,   -878,  -6381,  -2815, -12007,   5204,   3372,  -7592,  -6111,   3995, -15230,   3986,   5005,  -3659, -14510,   5186,  -2801,  10349,   6196,  -5330,  -2242, -12264,  -3869,   4685,  -7549, -10477,   2339,   -461,   4417,   2695,   5969, -15850,  -3279, -10072,   4103,   1083,   7656,  -3449, -15579,    411,   3540, -10044, -13695,   4119,   2165,   3267,   6923,   -269, -23189,   4417,    326,  -4931,   7471,   2337,  -1790,  -2114, -19143,   9331,  -5793,   3178, -13361,   1156,  -4503,   5205,  -3993,  10076,  -8221,  -6340,   1579,  -4108, -12407,  -3896,   4578,   1819,  -8713,   3820,   9715,   5683,    620,  -3789,  -4454,   1119,  -4602,   8784,  -5339,  -9437,  -4329,   6413,  -4374,  -4449,   4767,   6864,  -9717,   3784, -22299,   2878,  -6900,   6956,   4838,  -1707, -15545,  -1625,  -6710,   -823,  -4271,  -3356,  -9191,  -5546, -12734,   2645,   1046,   9767,  -7992,   4114,  -3765,  -1903, -17016,   5655,   4707,   2955, -13953,   4700,   3143,   3825,   5984,  -1222, -14030,  -1467, -17521,   4749,  -5105,   9023,  -5437,   3265,  -5684,   6016, -12421,  -3277,  -5371,  12757,  -6559,  -2053, -11375,   5111,   2863,   6097,  -5948,  -1952,   7806, -13948,   6053,   4192,  -9394,
          8348,  -5601,  -1171,   7231,   4125,   3579,  -4769, -19622, -11882,  -6874,  10727,   1188,  -7223,   4840,  -2263,   -774,  -9961, -20665,   2692,  -8500,  -9388, -19283,   6321,  -9437,  -6626,  -9175,  12535,  -4451, -15157,   9145,  -1758,  -5536,  -5592,  11616,   4049,   8868, -11811,   7395,  11504,  -2231,  -8924, -11696,  14082,   1049,  13399,  -6295,  -1773,  -7431,  -9848,   4390, -16054,  -5747,   -512,  11179,  -5915,  -7573,   2090,   7313,  -3669,    166,   9330, -13580,  -9600, -13850,   5734,  -9205,   1282,   2924,  -7690,    147, -16414,  -7005,  -2965, -13193,  -4426,  -9090,   3738,  -6824,  -1915, -13137,   5727,  -4867,  -8935,  -8499, -17833,   5761,   1960,    125,   2460, -12869,  -4764,  -9155,   1641,    240,   9364,  -2619,   5912, -14309,  -1492,   2603,   4698,   3986,  -9605, -18200,  -8802, -10703,   4969,  -5946,   6056,   5838, -12684,   3865,   6453,   3968,    179, -11775,   3028,   6077, -15801, -16828,  -9347,   -169,   6530,   8379, -22522, -12808,  -3676,   -798};

    const static Filter<int16_t> l5_compress_filter(l5_compress_filter_element, -14, {1, 1, 64, 10}, {1, 1});
    const Filter<int16_t> *get_l5_compress_filter()
    {
    	return &l5_compress_filter;
    }

    const static __attribute__((aligned(16))) int16_t l5_compress_bias_element[] = {
            44,   -305,   -120,    -15,    111,   -206,    122,     94,    100,   -486};

    const static Bias<int16_t> l5_compress_bias(l5_compress_bias_element, -9, {10,});
    const Bias<int16_t> *get_l5_compress_bias()
    {
    	return &l5_compress_bias;
    }

}
