from machine import Pin, PWM
import utime

# 初始化 PWM 控制器
LED = PWM(Pin(1))
# 设置 PWM 频率和占空比
LED.freq(1000)  # 设置 PWM 频率为 1000Hz
LED_duty = 0  # 设置占空比
LED_direction = 1

while True:
    LED_duty += LED_direction
    if LED_duty >= 100:
        LED_duty = 100
        LED_direction = -1
    elif LED_duty <= 0:
        LED_duty = 0
        LED_direction = 1
    LED.duty_u16(int(LED_duty * 655.36))
    if LED_duty % 5 == 0:
        print(LED_duty)
    utime.sleep(0.1)
