#ifndef _LCD_GSL3680_H
#define _LCD_GSL3680_H

#include "esp_lcd_touch.h"

#ifdef __cplusplus
extern "C" {
#endif

#define MAX_FINGER_NUM      3
#define TP_MULTI_SUCCESS    0

#define TP_PEN_NONE         0
#define TP_PEN_MOVE         1
#define TP_PEN_UP           2
#define TP_PEN_DOWN         3

#define TG_NO_DETECT        0
#define TG_ZOOM_IN          1
#define TG_ZOOM_OUT         2
#define TG_UNKNOWN_STATE    3

#define TP_UP_MSG           0
#define TP_DOWN_MSG         1
#define TP_MOVE_MSG         1
#define TP_MAX_MSG          0

typedef unsigned int DAWORD;
typedef unsigned short WORD;
typedef unsigned char BYTE;

typedef int s32;
typedef short s16;
typedef char s8;

typedef DAWORD uint32;
typedef BYTE uint8;
typedef WORD uint16;
typedef s32 int32;
typedef s16 int16;
typedef BYTE TP_STATE_E;
typedef BYTE TG_STATE_E;
typedef DAWORD TP_IOCTL_CMD_E;

typedef struct _XY_DATA_T{
	WORD x_position,y_position;
	BYTE finger_id;
}XY_DATA_T;

typedef struct _TPDSVR_SIG_T{
	WORD x_key, y_key;
	BYTE cur_index;
	TG_STATE_E gesture_type;
	WORD num_of_point;
	BYTE SignalCode;
	XY_DATA_T xy_position[3];
}TPDSVR_SIG_T;

esp_err_t esp_lcd_touch_new_i2c_gsl3680(esp_lcd_panel_io_handle_t io, const esp_lcd_touch_config_t *config, esp_lcd_touch_handle_t *out_touch);
esp_err_t esp_while_read();

#define ESP_LCD_TOUCH_IO_I2C_GSL3680_ADDRESS          (0x40)

typedef struct {
    uint8_t dev_addr;  /*!< I2C device address */
} esp_lcd_touch_io_gsl3680_config_t;

struct fw_data
{
	char offset;
	uint32_t val;
};

/**
 * @brief Touch IO configuration structure
 *
 */
#define ESP_LCD_TOUCH_IO_I2C_GSL3680_CONFIG()           \
    {                                       \
        .dev_addr = ESP_LCD_TOUCH_IO_I2C_GSL3680_ADDRESS, \
        .control_phase_bytes = 1,           \
        .dc_bit_offset = 0,                 \
        .lcd_cmd_bits = 8,                 \
        .flags =                            \
        {                                   \
            .disable_control_phase = 1,     \
        }                                   \
    }


    
static const struct fw_data GSLX680_FW[] = {

    {0xf0,0x2},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x000000b0},
    {0x64,0xf801000b},
    {0x68,0x00066414},
    {0x6c,0x1001020a},
    {0x70,0x00000fff},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x0e1a0e1a},
    {0xf0,0x3},
    {0x00,0x930ac1d6},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00005100},
    {0x28,0x00008e00},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x000000cd},
    {0x54,0x0000008c},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x1a0ac00a},
    {0x68,0x00000002},
    {0x6c,0x0000000f},
    {0x70,0x00000000},
    {0x74,0xffffffff},
    {0x78,0xffffffec},
    {0x7c,0x00000000},
    {0xf0,0x4},
    {0x00,0x00000000},
    {0x04,0x0001660b},
    {0x08,0x00000064},
    {0x0c,0x00000000},
    {0x10,0xfe0cff06},
    {0x14,0x07d00000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00010000},
    {0x34,0x00000fff},
    {0x38,0x0000000a},
    {0x3c,0x00000258},
    {0x40,0x00000000},
    {0x44,0x04020a00},
    {0x48,0x0014012c},
    {0x4c,0xc0040003},
    {0x50,0x00000000},
    {0x54,0x00010203},
    {0x58,0x04050607},
    {0x5c,0x08090a0b},
    {0x60,0x0c0d0e0f},
    {0x64,0x10111213},
    {0x68,0x14151617},
    {0x6c,0x18191a1b},
    {0x70,0x1c1d1e1f},
    {0x74,0x0014000a},
    {0x78,0x80808080},
    {0x7c,0xcba981f4},
    {0xf0,0x5},
    {0x00,0x00000000},
    {0x04,0x0000000a},
    {0x08,0x000000b4},
    {0x0c,0x404d4040},
    {0x10,0x0000000a},
    {0x14,0x00000000},
    {0x18,0x00000fff},
    {0x1c,0x10170002},
    {0x20,0x10110000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000400},
    {0x30,0x80808080},
    {0x34,0x80808080},
    {0x38,0x80808080},
    {0x3c,0x80808080},
    {0x40,0x80808080},
    {0x44,0x80808080},
    {0x48,0x80808080},
    {0x4c,0x80808000},
    {0x50,0xffffffff},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000220},
    {0x78,0x0000001a},
    {0x7c,0x0000000e},
    {0xf0,0x6},
    {0x00,0x0000001a},
    {0x04,0x00000000},
    {0x08,0x0000000e},
    {0x0c,0x04030402},
    {0x10,0x00000032},
    {0x14,0x1414010a},
    {0x18,0x00000000},
    {0x1c,0x00000001},
    {0x20,0x00002904},
    {0x24,0x00000320},
    {0x28,0x00000500},
    {0x2c,0xf801000b},
    {0x30,0xf8010005},
    {0x34,0x00000003},
    {0x38,0x00000003},
    {0x3c,0x00000fff},
    {0x40,0x80000000},
    {0x44,0x00180018},
    {0x48,0x00000fff},
    {0x4c,0x04040402},
    {0x50,0x00020001},
    {0x54,0x00000e10},
    {0x58,0x000a012c},
    {0x5c,0x00806410},
    {0x60,0x10200800},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x0000014a},
    {0x78,0x000a003c},
    {0x7c,0x00000000},
    {0xf0,0x7},
    {0x00,0x01060009},
    {0x04,0x0308020b},
    {0x08,0x050a040d},
    {0x0c,0x070c0610},
    {0x10,0x09130812},
    {0x14,0x00123456},
    {0x18,0x00000000},
    {0x1c,0x000a0078},
    {0x20,0x00001081},
    {0x24,0xff080010},
    {0x28,0xff080120},
    {0x2c,0xff080140},
    {0x30,0xff080160},
    {0x34,0x002100f0},
    {0x38,0x001c00d0},
    {0x3c,0x001700b0},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x40000d00},
    {0x4c,0x320f0f03},
    {0x50,0x00000000},
    {0x54,0x00000004},
    {0x58,0x00000000},
    {0x5c,0x000c0001},
    {0x60,0x0018000d},
    {0x64,0x00190019},
    {0x68,0x00000000},
    {0x6c,0x000b0000},
    {0x70,0x000b0000},
    {0x74,0x00000000},
    {0x78,0x00012345},
    {0x7c,0x006789ab},
    {0xf0,0x8},
    {0x00,0x020f222f},
    {0x04,0x224f226f},
    {0x08,0x228f22af},
    {0x0c,0x22cf22ef},
    {0x10,0x230f232f},
    {0x14,0x234f236f},
    {0x18,0x238f41f0},
    {0x1c,0x41f141f2},
    {0x20,0x41f341f4},
    {0x24,0x41f541f6},
    {0x28,0x41f741f8},
    {0x2c,0x41f941fa},
    {0x30,0x41fb71fc},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x01030507},
    {0x44,0x090b0d00},
    {0x48,0x00000000},
    {0x4c,0x02040608},
    {0x50,0x0a0c0e00},
    {0x54,0x00000000},
    {0x58,0x00060005},
    {0x5c,0x00000008},
    {0x60,0x000001c2},
    {0x64,0x00000201},
    {0x68,0x00000804},
    {0x6c,0x006600cd},
    {0x70,0x000000cd},
    {0x74,0x0000008c},
    {0x78,0x00000000},
    {0x7c,0x0000000e},
    {0xf0,0x9},
    {0x00,0xff080094},
    {0x04,0x00070011},
    {0x08,0xff080090},
    {0x0c,0x00040000},
    {0x10,0xff080068},
    {0x14,0x00030000},
    {0x18,0xff080064},
    {0x1c,0x01002582},
    {0x20,0xff080060},
    {0x24,0x00200000},
    {0x28,0xff08004c},
    {0x2c,0x00197fff},
    {0x30,0xfffffff0},
    {0x34,0x00000000},
    {0x38,0xfffffff0},
    {0x3c,0x00000000},
    {0x40,0xfffffff0},
    {0x44,0x00000000},
    {0x48,0xfffffff0},
    {0x4c,0x00000000},
    {0x50,0xfffffff0},
    {0x54,0x00000000},
    {0x58,0xfffffff0},
    {0x5c,0x00000000},
    {0x60,0xfffffff0},
    {0x64,0x00000000},
    {0x68,0xfffffff0},
    {0x6c,0x00000000},
    {0x70,0xfffffff0},
    {0x74,0x00000000},
    {0x78,0xfffffff0},
    {0x7c,0x00000000},
    /*
    {0xf0,0xe0},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x006401f4},
    {0x44,0x00640064},
    {0x48,0x01900064},
    {0x4c,0x00500190},
    {0x50,0x00500050},
    {0x54,0x012c0050},
    {0x58,0x012c012c},
    {0x5c,0x003c012c},
    {0x60,0x00640014},
    {0x64,0x00640064},
    {0x68,0x00000032},
    {0x6c,0x00500000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0xe1},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000002},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0xe2},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0xe3},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0xe4},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0xe5},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0xe6},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    */
    
    
    
    {0xf0,0x1e},
    {0x00,0x5a5a0f00},
    {0x04,0x00002bdc},
    {0x08,0x00002c50},
    {0x0c,0x00002cd0},
    {0x10,0x00002e10},
    {0x14,0x00002f0c},
    {0x18,0x000030c0},
    {0x1c,0x00003254},
    {0x20,0x00003270},
    {0x24,0x00003418},
    {0x28,0x00003550},
    {0x2c,0x00003600},
    {0x30,0x00003970},
    {0x34,0x00003a70},
    {0x38,0x00003ce8},
    {0x3c,0x00003d60},
    {0x40,0x00003dd8},
    {0x44,0x00003f68},
    {0x48,0x00004250},
    {0x4c,0x00004608},
    {0x50,0x0000469c},
    {0x54,0x00004700},
    {0x58,0x00004874},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0x1f},
    {0x00,0x00000000},
    {0x04,0x00000000},
    {0x08,0x00000000},
    {0x0c,0x00000000},
    {0x10,0x00000000},
    {0x14,0x00000000},
    {0x18,0x00000000},
    {0x1c,0x00000000},
    {0x20,0x00000000},
    {0x24,0x00000000},
    {0x28,0x00000000},
    {0x2c,0x00000000},
    {0x30,0x00000000},
    {0x34,0x00000000},
    {0x38,0x00000000},
    {0x3c,0x00002470},
    {0x40,0x00002620},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x000026a0},
    {0x50,0x00002760},
    {0x54,0x00000000},
    {0x58,0x00002810},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00002944},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00002a28},
    {0x78,0x0000493c},
    {0x7c,0x5a5a0ffc},
    {0xf0,0x0},
    {0x00,0x01000000},
    {0x04,0x01000000},
    {0x08,0x01000000},
    {0x0c,0x233fc0c0},
    {0x10,0xa2146004},
    {0x14,0xa4102000},
    {0x18,0xe4244000},
    {0x1c,0x233fc0c0},
    {0x20,0xa2146010},
    {0x24,0x2500003f},
    {0x28,0xa414a3ff},
    {0x2c,0xe4244000},
    {0x30,0x01000000},
    {0x34,0x821020e0},
    {0x38,0x81880001},
    {0x3c,0x01000000},
    {0x40,0x01000000},
    {0x44,0xa410200f},
    {0x48,0xe4a00040},
    {0x4c,0x01000000},
    {0x50,0xa0100000},
    {0x54,0xa2100000},
    {0x58,0xa4100000},
    {0x5c,0xa6100000},
    {0x60,0xa8100000},
    {0x64,0xaa100000},
    {0x68,0xac100000},
    {0x6c,0xae100000},
    {0x70,0x90100000},
    {0x74,0x92100000},
    {0x78,0x94100000},
    {0x7c,0x96100000},
    {0xf0,0x1},
    {0x00,0x98100000},
    {0x04,0x9a100000},
    {0x08,0x9c100000},
    {0x0c,0x9e100000},
    {0x10,0x84100000},
    {0x14,0x01000000},
    {0x18,0x01000000},
    {0x1c,0x82100000},
    {0x20,0x81900001},
    {0x24,0x82100000},
    {0x28,0x81980001},
    {0x2c,0x81800000},
    {0x30,0x01000000},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0xbc102cfc},
    {0x40,0x9c102cf8},
    {0x44,0x01000000},
    {0x48,0x01000000},
    {0x4c,0x27001040},
    {0x50,0xa614e00f},
    {0x54,0xe6a00040},
    {0x58,0x01000000},
    {0x5c,0x40000309},
    {0x60,0x01000000},
    {0x64,0x01000000},
    {0x68,0x10bfffff},
    {0x6c,0x01000000},
    {0x70,0x03169684},
    {0x74,0x82106053},
    {0x78,0x0329694d},
    {0x7c,0x82106270},
    {0xf0,0x1a},
    {0x00,0x9de3bf98},
    {0x04,0x40000010},
    {0x08,0x01000000},
    {0x0c,0x40000007},
    {0x10,0x01000000},
    {0x14,0x40000334},
    {0x18,0x01000000},
    {0x1c,0x40000015},
    {0x20,0x01000000},
    {0x24,0x30bffffe},
    {0x28,0x82102001},
    {0x2c,0x81904000},
    {0x30,0x01000000},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0x81c3e008},
    {0x40,0x01000000},
    {0x44,0x03000008},
    {0x48,0x82106342},
    {0x4c,0xa3804000},
    {0x50,0x03000004},
    {0x54,0x82106000},
    {0x58,0x81984000},
    {0x5c,0x01000000},
    {0x60,0x01000000},
    {0x64,0x01000000},
    {0x68,0x81c3e008},
    {0x6c,0x01000000},
    {0x70,0x01000000},
    {0x74,0x01000000},
    {0x78,0x01000000},
    {0x7c,0xa7800000},
    {0xf0,0x1b},
    {0x00,0x01000000},
    {0x04,0x01000000},
    {0x08,0x01000000},
    {0x0c,0x81c3e008},
    {0x10,0x01000000},
    {0x14,0x80a22000},
    {0x18,0x02800006},
    {0x1c,0x01000000},
    {0x20,0x01000000},
    {0x24,0x90823fff},
    {0x28,0x12bffffe},
    {0x2c,0x01000000},
    {0x30,0x81c3e008},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0x05001040},
    {0x40,0x8410a00f},
    {0x44,0xc4a00040},
    {0x48,0x01000000},
    {0x4c,0x81c3e008},
    {0x50,0x01000000},
    {0x54,0x9de3bec8},
    {0x58,0xb2067fff},
    {0x5c,0x96100018},
    {0x60,0xf227bf2c},
    {0x64,0xc027bf28},
    {0x68,0x98102000},
    {0x6c,0xb007bff8},
    {0x70,0xd4063f30},
    {0x74,0xda063f34},
    {0x78,0xb810000a},
    {0x7c,0x98033fff},
    {0xf0,0x1c},
    {0x00,0xb0063ff8},
    {0x04,0x80a2800d},
    {0x08,0x16800031},
    {0x0c,0xb610000d},
    {0x10,0xbb2aa002},
    {0x14,0x832b6002},
    {0x18,0xb207400b},
    {0x1c,0xb400400b},
    {0x20,0xde02c01d},
    {0x24,0x80a7001b},
    {0x28,0x1680001c},
    {0x2c,0x01000000},
    {0x30,0xc2068000},
    {0x34,0x80a0400f},
    {0x38,0x04800005},
    {0x3c,0x80a7001b},
    {0x40,0xb606ffff},
    {0x44,0x10bffff8},
    {0x48,0xb406bffc},
    {0x4c,0x16800013},
    {0x50,0x80a7001b},
    {0x54,0xc2068000},
    {0x58,0xc2264000},
    {0x5c,0xb8072001},
    {0x60,0x80a7001b},
    {0x64,0x1680000d},
    {0x68,0xb2066004},
    {0x6c,0xc2064000},
    {0x70,0x80a0400f},
    {0x74,0x26bffffb},
    {0x78,0xb8072001},
    {0x7c,0x80a7001b},
    {0xf0,0x1d},
    {0x00,0x16800006},
    {0x04,0x01000000},
    {0x08,0xc2268000},
    {0x0c,0xb606ffff},
    {0x10,0xb406bffc},
    {0x14,0x80a7001b},
    {0x18,0x12bfffe4},
    {0x1c,0x80a7001b},
    {0x20,0xb0062008},
    {0x24,0x82073fff},
    {0x28,0xc2263f34},
    {0x2c,0xd4263f30},
    {0x30,0x832f2002},
    {0x34,0xb0062008},
    {0x38,0xde22c001},
    {0x3c,0xba072001},
    {0x40,0xfa263f30},
    {0x44,0xda263f34},
    {0x48,0x98032002},
    {0x4c,0x80a33fff},
    {0x50,0x34bfffc9},
    {0x54,0xd4063f30},
    {0x58,0x81c7e008},
    {0x5c,0x81e80000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0x20},
    {0x00,0x83580000},
    {0x04,0x82086ff0},
    {0x08,0x83306004},
    {0x0c,0x80a06005},
    {0x10,0x02800027},
    {0x14,0x01000000},
    {0x18,0x80a06006},
    {0x1c,0x0280003c},
    {0x20,0x01000000},
    {0x24,0x80a06015},
    {0x28,0x02800054},
    {0x2c,0x01000000},
    {0x30,0x80a0602a},
    {0x34,0x02800090},
    {0x38,0x01000000},
    {0x3c,0x80a06018},
    {0x40,0x02800085},
    {0x44,0x01000000},
    {0x48,0x073fc180},
    {0x4c,0x8610e03c},
    {0x50,0x05169680},
    {0x54,0x84004002},
    {0x58,0xc420c000},
    {0x5c,0x073fc000},
    {0x60,0x8610e020},
    {0x64,0x84102001},
    {0x68,0xc420c000},
    {0x6c,0x0500000c},
    {0x70,0x01000000},
    {0x74,0x01000000},
    {0x78,0x8480bfff},
    {0x7c,0x12bffffe},
    {0xf0,0x21},
    {0x00,0x01000000},
    {0x04,0x01000000},
    {0x08,0x073fc000},
    {0x0c,0x8610e020},
    {0x10,0x84102000},
    {0x14,0xc420c000},
    {0x18,0x01000000},
    {0x1c,0x01000000},
    {0x20,0x81c44000},
    {0x24,0x81cc8000},
    {0x28,0x01000000},
    {0x2c,0xa7500000},
    {0x30,0xa92ce002},
    {0x34,0xa734e001},
    {0x38,0xa614c014},
    {0x3c,0xa60ce007},
    {0x40,0x81900000},
    {0x44,0x01000000},
    {0x48,0x01000000},
    {0x4c,0x81e00000},
    {0x50,0xe03ba000},
    {0x54,0xe43ba008},
    {0x58,0xe83ba010},
    {0x5c,0xec3ba018},
    {0x60,0xf03ba020},
    {0x64,0xf43ba028},
    {0x68,0xf83ba030},
    {0x6c,0xfc3ba038},
    {0x70,0x81e80000},
    {0x74,0x8194c000},
    {0x78,0x01000000},
    {0x7c,0x01000000},
    {0xf0,0x22},
    {0x00,0x81c44000},
    {0x04,0x81cc8000},
    {0x08,0x01000000},
    {0x0c,0xa7500000},
    {0x10,0xa934e002},
    {0x14,0xa72ce001},
    {0x18,0xa614c014},
    {0x1c,0xa60ce007},
    {0x20,0x81900000},
    {0x24,0x01000000},
    {0x28,0x01000000},
    {0x2c,0x81e80000},
    {0x30,0x81e80000},
    {0x34,0xe01ba000},
    {0x38,0xe41ba008},
    {0x3c,0xe81ba010},
    {0x40,0xec1ba018},
    {0x44,0xf01ba020},
    {0x48,0xf41ba028},
    {0x4c,0xf81ba030},
    {0x50,0xfc1ba038},
    {0x54,0x81e00000},
    {0x58,0x81e00000},
    {0x5c,0x8194c000},
    {0x60,0x01000000},
    {0x64,0x01000000},
    {0x68,0x81c44000},
    {0x6c,0x81cc8000},
    {0x70,0x01000000},
    {0x74,0x01000000},
    {0x78,0x82102010},
    {0x7c,0x273fc0c0},
    {0xf0,0x23},
    {0x00,0xa614e010},
    {0x04,0xc224c000},
    {0x08,0x01000000},
    {0x0c,0x033fc0c0},
    {0x10,0x82106004},
    {0x14,0xa6102000},
    {0x18,0xe6204000},
    {0x1c,0x01000000},
    {0x20,0x01000000},
    {0x24,0x01000000},
    {0x28,0xa6102020},
    {0x2c,0x83480000},
    {0x30,0x82104013},
    {0x34,0x81884000},
    {0x38,0x01000000},
    {0x3c,0x4000043a},
    {0x40,0x01000000},
    {0x44,0x01000000},
    {0x48,0x01000000},
    {0x4c,0xa7500000},
    {0x50,0xa934e002},
    {0x54,0xa72ce001},
    {0x58,0xa614c014},
    {0x5c,0xa60ce007},
    {0x60,0x81900000},
    {0x64,0x01000000},
    {0x68,0x81e80000},
    {0x6c,0xe01ba000},
    {0x70,0xe41ba008},
    {0x74,0xe81ba010},
    {0x78,0xec1ba018},
    {0x7c,0xf01ba020},
    {0xf0,0x24},
    {0x00,0xf41ba028},
    {0x04,0xf81ba030},
    {0x08,0xfc1ba038},
    {0x0c,0x81e00000},
    {0x10,0x8194c000},
    {0x14,0x01000000},
    {0x18,0xa6102020},
    {0x1c,0x83480000},
    {0x20,0x82284013},
    {0x24,0x81884000},
    {0x28,0x01000000},
    {0x2c,0x033fc0c0},
    {0x30,0x82106004},
    {0x34,0xa6103fff},
    {0x38,0xe6204000},
    {0x3c,0x01000000},
    {0x40,0x01000000},
    {0x44,0x01000000},
    {0x48,0x81c44000},
    {0x4c,0x81cc8000},
    {0x50,0x01000000},
    {0x54,0x82102080},
    {0x58,0x273fc0c0},
    {0x5c,0xa614e010},
    {0x60,0xc224c000},
    {0x64,0x01000000},
    {0x68,0x81c44000},
    {0x6c,0x81cc8000},
    {0x70,0x01000000},
    {0x74,0x81c48000},
    {0x78,0x81cca004},
    {0x7c,0x01000000},
    {0xf0,0x25},
    {0x00,0x033fc200},
    {0x04,0xda0021fc},
    {0x08,0x9210608c},
    {0x0c,0x96106084},
    {0x10,0x94106088},
    {0x14,0x825a000d},
    {0x18,0x80a36000},
    {0x1c,0x02800003},
    {0x20,0x82006800},
    {0x24,0x9130600c},
    {0x28,0x992a2010},
    {0x2c,0x82022001},
    {0x30,0x9b2a2004},
    {0x34,0x83286010},
    {0x38,0x9a03000d},
    {0x3c,0xda22c000},
    {0x40,0x82004008},
    {0x44,0x82006002},
    {0x48,0xd8228000},
    {0x4c,0x81c3e008},
    {0x50,0xc2224000},
    {0x54,0x1b3fc140},
    {0x58,0x82136048},
    {0x5c,0xc2104000},
    {0x60,0x82006003},
    {0x64,0x82086003},
    {0x68,0x83286002},
    {0x6c,0x9a136080},
    {0x70,0x81c3e008},
    {0x74,0xd000400d},
    {0x78,0x94102000},
    {0x7c,0x96102000},
    {0xf0,0x26},
    {0x00,0x832ae002},
    {0x04,0xd20063a4},
    {0x08,0x98102000},
    {0x0c,0x832b2002},
    {0x10,0x9b2aa002},
    {0x14,0xda02000d},
    {0x18,0x98032001},
    {0x1c,0xda224001},
    {0x20,0x80a32005},
    {0x24,0x04bffffa},
    {0x28,0x9402a001},
    {0x2c,0x9602e001},
    {0x30,0x80a2e003},
    {0x34,0x04bffff4},
    {0x38,0x832ae002},
    {0x3c,0x81c3e008},
    {0x40,0x01000000},
    {0x44,0x82020008},
    {0x48,0x82004008},
    {0x4c,0x9b326002},
    {0x50,0x82004001},
    {0x54,0x8200400d},
    {0x58,0x83286002},
    {0x5c,0x920a6003},
    {0x60,0x932a6003},
    {0x64,0xd00065b0},
    {0x68,0x91320009},
    {0x6c,0x81c3e008},
    {0x70,0x900a20ff},
    {0x74,0x9a020008},
    {0x78,0x9a034008},
    {0x7c,0x97326002},
    {0xf0,0x27},
    {0x00,0x9a03400d},
    {0x04,0x9a03400b},
    {0x08,0x920a6003},
    {0x0c,0x9b2b6002},
    {0x10,0x932a6003},
    {0x14,0x821020ff},
    {0x18,0xd80365b0},
    {0x1c,0x83284009},
    {0x20,0x822b0001},
    {0x24,0x952a8009},
    {0x28,0x8210400a},
    {0x2c,0xc22365b0},
    {0x30,0x912a2002},
    {0x34,0xda0223a4},
    {0x38,0x972ae002},
    {0x3c,0x81c3e008},
    {0x40,0xc223400b},
    {0x44,0x9a102005},
    {0x48,0x8210200b},
    {0x4c,0x9a234008},
    {0x50,0x82204008},
    {0x54,0x9b2b6002},
    {0x58,0x80a22005},
    {0x5c,0x14800007},
    {0x60,0x99286002},
    {0x64,0x033fc200},
    {0x68,0x8210600c},
    {0x6c,0xc2004000},
    {0x70,0x10800006},
    {0x74,0x8330400d},
    {0x78,0x033fc200},
    {0x7c,0x82106008},
    {0xf0,0x28},
    {0x00,0xc2004000},
    {0x04,0x8330400c},
    {0x08,0x81c3e008},
    {0x0c,0x9008600f},
    {0x10,0x9de3bf30},
    {0x14,0xa12e2002},
    {0x18,0xda1423da},
    {0x1c,0xd61423d8},
    {0x20,0xc200247c},
    {0x24,0xb022c00d},
    {0x28,0x825b4001},
    {0x2c,0xb21e6001},
    {0x30,0x92862001},
    {0x34,0x0280000c},
    {0x38,0x9a004019},
    {0x3c,0xb0100009},
    {0x40,0x9807bf90},
    {0x44,0x8203400d},
    {0x48,0xc2168001},
    {0x4c,0xc2230000},
    {0x50,0xc200247c},
    {0x54,0x9a034001},
    {0x58,0xb0863fff},
    {0x5c,0x12bffffa},
    {0x60,0x98032004},
    {0x64,0x7ffffe5c},
    {0x68,0x9007bf90},
    {0x6c,0xda1423ea},
    {0x70,0xd61423e8},
    {0x74,0x80a3400b},
    {0x78,0x92102000},
    {0x7c,0x1880000b},
    {0xf0,0x29},
    {0x00,0xb010000d},
    {0x04,0x832b6002},
    {0x08,0x8200401e},
    {0x0c,0x98007f90},
    {0x10,0xc2030000},
    {0x14,0xb0062001},
    {0x18,0x92024001},
    {0x1c,0x80a6000b},
    {0x20,0x08bffffc},
    {0x24,0x98032004},
    {0x28,0xb022c00d},
    {0x2c,0xb0062001},
    {0x30,0x81800000},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0x01000000},
    {0x40,0xb0724018},
    {0x44,0x81c7e008},
    {0x48,0x81e80000},
    {0x4c,0x033fc200},
    {0x50,0x961060a0},
    {0x54,0x98102000},
    {0x58,0x832b2002},
    {0x5c,0x9a03000c},
    {0x60,0xda136400},
    {0x64,0x98032001},
    {0x68,0x80a32019},
    {0x6c,0x04bffffb},
    {0x70,0xda20400b},
    {0x74,0x81c3e008},
    {0x78,0x01000000},
    {0x7c,0x9de3bf98},
    {0xf0,0x2a},
    {0x00,0xc200247c},
    {0x04,0x83306001},
    {0x08,0x80a60001},
    {0x0c,0x1a800006},
    {0x10,0x90100018},
    {0x14,0x7fffffac},
    {0x18,0x01000000},
    {0x1c,0x10800006},
    {0x20,0xb0020008},
    {0x24,0x7fffffa8},
    {0x28,0x90260001},
    {0x2c,0x90020008},
    {0x30,0xb0022001},
    {0x34,0x81c7e008},
    {0x38,0x81e80000},
    {0x3c,0x9de3bf98},
    {0x40,0xa6102000},
    {0x44,0xc20023d4},
    {0x48,0x80a4c001},
    {0x4c,0x1a800059},
    {0x50,0xe2002348},
    {0x54,0xaa102000},
    {0x58,0xc200247c},
    {0x5c,0x80a54001},
    {0x60,0x3a800050},
    {0x64,0xa604e001},
    {0x68,0xa92ce002},
    {0x6c,0x03000018},
    {0x70,0x821060e0},
    {0x74,0xae050001},
    {0x78,0x7fffffe1},
    {0x7c,0x90100015},
    {0xf0,0x2b},
    {0x00,0xac100008},
    {0x04,0x90100013},
    {0x08,0x7fffff6f},
    {0x0c,0x92100016},
    {0x10,0x80a62000},
    {0x14,0x12800004},
    {0x18,0xa0100008},
    {0x1c,0x1080000b},
    {0x20,0xa0102000},
    {0x24,0x7fffff4c},
    {0x28,0x01000000},
    {0x2c,0x94100008},
    {0x30,0x90100013},
    {0x34,0x7fffff97},
    {0x38,0x92100015},
    {0x3c,0x80a62007},
    {0x40,0x1880000f},
    {0x44,0xa4100008},
    {0x48,0x80a48011},
    {0x4c,0x04800008},
    {0x50,0x9a102007},
    {0x54,0x9a102008},
    {0x58,0x9a234018},
    {0x5c,0x82102001},
    {0x60,0x8328400d},
    {0x64,0xa02c0001},
    {0x68,0x9a102007},
    {0x6c,0x9a234018},
    {0x70,0x82102001},
    {0x74,0x8328400d},
    {0x78,0xa0140001},
    {0x7c,0x80a62009},
    {0xf0,0x2c},
    {0x00,0x0280000b},
    {0x04,0x821e2008},
    {0x08,0x80a00001},
    {0x0c,0x9a603fff},
    {0x10,0x80a48011},
    {0x14,0x14800003},
    {0x18,0x82102001},
    {0x1c,0x82102000},
    {0x20,0x808b4001},
    {0x24,0x0280000f},
    {0x28,0x80a62008},
    {0x2c,0xc205c000},
    {0x30,0x80a04011},
    {0x34,0x18800003},
    {0x38,0x9a204011},
    {0x3c,0x9a244001},
    {0x40,0x80a48011},
    {0x44,0x14800003},
    {0x48,0x82248011},
    {0x4c,0x82244012},
    {0x50,0x80a34001},
    {0x54,0xa0642000},
    {0x58,0x10800007},
    {0x5c,0xa4102000},
    {0x60,0x32800006},
    {0x64,0xe425c000},
    {0x68,0x80a420fe},
    {0x6c,0x24800002},
    {0x70,0xa0042001},
    {0x74,0xe425c000},
    {0x78,0x92100016},
    {0x7c,0x94100010},
    {0xf0,0x2d},
    {0x00,0x7fffff3d},
    {0x04,0x90100013},
    {0x08,0xaa056001},
    {0x0c,0xc200247c},
    {0x10,0x80a54001},
    {0x14,0x0abfffb6},
    {0x18,0xa8052010},
    {0x1c,0xa604e001},
    {0x20,0xc20023d4},
    {0x24,0x80a4c001},
    {0x28,0x0abfffac},
    {0x2c,0xaa102000},
    {0x30,0x81c7e008},
    {0x34,0x81e80000},
    {0x38,0x98102000},
    {0x3c,0x9610201e},
    {0x40,0x80a22000},
    {0x44,0x12800003},
    {0x48,0x8210000c},
    {0x4c,0x8222c00c},
    {0x50,0x83286002},
    {0x54,0xda006480},
    {0x58,0x80a37ff0},
    {0x5c,0x02800006},
    {0x60,0x98032002},
    {0x64,0xc2006484},
    {0x68,0x80a3201f},
    {0x6c,0x04bffff5},
    {0x70,0xc2234000},
    {0x74,0x81c3e008},
    {0x78,0x01000000},
    {0x7c,0x9de3bf98},
    {0xf0,0x2e},
    {0x00,0xda002508},
    {0x04,0x033fc000},
    {0x08,0x9a0b4001},
    {0x0c,0x173fc180},
    {0x10,0x03202020},
    {0x14,0x82106080},
    {0x18,0x9812e038},
    {0x1c,0xc2230000},
    {0x20,0x03168000},
    {0x24,0x80a34001},
    {0x28,0xc022c000},
    {0x2c,0xa6102000},
    {0x30,0x1280000b},
    {0x34,0xa8102000},
    {0x38,0x0300003f},
    {0x3c,0xda002548},
    {0x40,0x821063ff},
    {0x44,0x9a0b4001},
    {0x48,0xd8002508},
    {0x4c,0x033fffc0},
    {0x50,0x980b0001},
    {0x54,0x9a13400c},
    {0x58,0xda202548},
    {0x5c,0x80a62000},
    {0x60,0x1680002b},
    {0x64,0x1b296956},
    {0x68,0x1b3fc040},
    {0x6c,0xc2002548},
    {0x70,0x8208400d},
    {0x74,0x1b168040},
    {0x78,0x80a0400d},
    {0x7c,0x22800002},
    {0xf0,0x2f},
    {0x00,0xa6102001},
    {0x04,0xda002654},
    {0x08,0xc20021dc},
    {0x0c,0x80a34001},
    {0x10,0x1a80001f},
    {0x14,0x1b296956},
    {0x18,0x031696a9},
    {0x1c,0xda00250c},
    {0x20,0x821061a5},
    {0x24,0x80a34001},
    {0x28,0x02800006},
    {0x2c,0x03296956},
    {0x30,0x8210625a},
    {0x34,0x80a34001},
    {0x38,0x12800015},
    {0x3c,0x1b296956},
    {0x40,0xc200254c},
    {0x44,0x80886004},
    {0x48,0x32800002},
    {0x4c,0xa8102001},
    {0x50,0x11000016},
    {0x54,0x13000017},
    {0x58,0x90122330},
    {0x5c,0x40000156},
    {0x60,0x92126208},
    {0x64,0x03000018},
    {0x68,0x96106260},
    {0x6c,0x98102000},
    {0x70,0x9b2b2002},
    {0x74,0x98032001},
    {0x78,0xc20365b0},
    {0x7c,0x80a32017},
    {0xf0,0x30},
    {0x00,0x08bffffc},
    {0x04,0xc223400b},
    {0x08,0x1b296956},
    {0x0c,0x80a00013},
    {0x10,0x82380018},
    {0x14,0xa413625a},
    {0x18,0x92402000},
    {0x1c,0x8330601f},
    {0x20,0x1b1696a9},
    {0x24,0xa21361a5},
    {0x28,0x90104009},
    {0x2c,0xde00254c},
    {0x30,0xe0002548},
    {0x34,0x98102500},
    {0x38,0xc200250c},
    {0x3c,0x96033a50},
    {0x40,0x941b250c},
    {0x44,0x80a04012},
    {0x48,0x02800007},
    {0x4c,0x9a184011},
    {0x50,0x80a0000d},
    {0x54,0x82603fff},
    {0x58,0x80904009},
    {0x5c,0x0280000a},
    {0x60,0x80a22000},
    {0x64,0x80a2e0e0},
    {0x68,0x9a402000},
    {0x6c,0x80a0000a},
    {0x70,0x82603fff},
    {0x74,0x80934001},
    {0x78,0x3280000a},
    {0x7c,0x98032004},
    {0xf0,0x31},
    {0x00,0x80a22000},
    {0x04,0x02800005},
    {0x08,0x82033970},
    {0x0c,0x80a0603f},
    {0x10,0x28800004},
    {0x14,0x98032004},
    {0x18,0xc0230000},
    {0x1c,0x98032004},
    {0x20,0x80a32867},
    {0x24,0x28bfffe6},
    {0x28,0xc200250c},
    {0x2c,0x80a62000},
    {0x30,0x06800006},
    {0x34,0x0300003f},
    {0x38,0x821063ff},
    {0x3c,0x820bc001},
    {0x40,0x10800006},
    {0x44,0xc220254c},
    {0x48,0xc21022d4},
    {0x4c,0x83286010},
    {0x50,0xc2202690},
    {0x54,0x80a62000},
    {0x58,0x36800008},
    {0x5c,0xc2002548},
    {0x60,0xc200254c},
    {0x64,0x9a050014},
    {0x68,0x82087ffd},
    {0x6c,0x8210400d},
    {0x70,0xc220254c},
    {0x74,0xc2002548},
    {0x78,0xd8002334},
    {0x7c,0xda0023c8},
    {0xf0,0x32},
    {0x00,0x98032001},
    {0x04,0x92087dff},
    {0x08,0x9b336012},
    {0x0c,0x9a0b6200},
    {0x10,0x83332001},
    {0x14,0x9212400d},
    {0x18,0x113fc200},
    {0x1c,0x82030001},
    {0x20,0xda002344},
    {0x24,0x96122030},
    {0x28,0xc220258c},
    {0x2c,0xda22c000},
    {0x30,0x95342018},
    {0x34,0xda20257c},
    {0x38,0x80a2a05a},
    {0x3c,0xd8202554},
    {0x40,0xd8202588},
    {0x44,0xd2202548},
    {0x48,0x12800009},
    {0x4c,0xda202570},
    {0x50,0x0300003f},
    {0x54,0x821063ff},
    {0x58,0x1b3fffc0},
    {0x5c,0x820a4001},
    {0x60,0x9a0c000d},
    {0x64,0x8210400d},
    {0x68,0xc2202548},
    {0x6c,0x80a4e001},
    {0x70,0x1280000c},
    {0x74,0x03296956},
    {0x78,0xc2002548},
    {0x7c,0x83306012},
    {0xf0,0x33},
    {0x00,0x80886001},
    {0x04,0x32800010},
    {0x08,0x82102029},
    {0x0c,0x9a122074},
    {0x10,0xc2002330},
    {0x14,0xc2234000},
    {0x18,0x1080000b},
    {0x1c,0x82102029},
    {0x20,0xda00250c},
    {0x24,0x8210625a},
    {0x28,0x80a34001},
    {0x2c,0x1280000b},
    {0x30,0x01000000},
    {0x34,0xc200254c},
    {0x38,0x80886002},
    {0x3c,0x12800007},
    {0x40,0x82102015},
    {0x44,0xc2202500},
    {0x48,0x7ffffe4c},
    {0x4c,0x901025b0},
    {0x50,0x7ffffebf},
    {0x54,0x81e80000},
    {0x58,0x01000000},
    {0x5c,0x81c7e008},
    {0x60,0x81e80000},
    {0x64,0x9de3bf98},
    {0x68,0x40000213},
    {0x6c,0x90102000},
    {0x70,0x213fc140},
    {0x74,0xda00247c},
    {0x78,0x98142040},
    {0x7c,0xfa030000},
    {0xf0,0x34},
    {0x00,0xc20022f8},
    {0x04,0x9b336001},
    {0x08,0x825b4001},
    {0x0c,0xba0f7800},
    {0x10,0xba174001},
    {0x14,0xfa230000},
    {0x18,0x82142004},
    {0x1c,0xfa004000},
    {0x20,0xba0f7fe0},
    {0x24,0x393fc200},
    {0x28,0xba17400d},
    {0x2c,0xfa204000},
    {0x30,0x94172080},
    {0x34,0xfa028000},
    {0x38,0xba0f7fe0},
    {0x3c,0xba17400d},
    {0x40,0x033fc0c0},
    {0x44,0xfa228000},
    {0x48,0xb6106004},
    {0x4c,0xc2002298},
    {0x50,0x9a172070},
    {0x54,0xc2234000},
    {0x58,0x033fc000},
    {0x5c,0xda002338},
    {0x60,0x82106030},
    {0x64,0xda204000},
    {0x68,0xc200232c},
    {0x6c,0x9e172074},
    {0x70,0xc223c000},
    {0x74,0x0300003f},
    {0x78,0xa6142058},
    {0x7c,0x821063ff},
    {0xf0,0x35},
    {0x00,0x17000015},
    {0x04,0xc224c000},
    {0x08,0x9612e180},
    {0x0c,0x92142088},
    {0x10,0x19000016},
    {0x14,0xd6224000},
    {0x18,0x98132058},
    {0x1c,0x9014208c},
    {0x20,0xd8220000},
    {0x24,0xc20023f8},
    {0x28,0xa217200c},
    {0x2c,0xc2244000},
    {0x30,0xc20023fc},
    {0x34,0x35200040},
    {0x38,0xa4172008},
    {0x3c,0xc2248000},
    {0x40,0xae16a101},
    {0x44,0xee270000},
    {0x48,0xa814205c},
    {0x4c,0xc0250000},
    {0x50,0xaa142080},
    {0x54,0xd6254000},
    {0x58,0xac142084},
    {0x5c,0xd8258000},
    {0x60,0x7ffffe7b},
    {0x64,0xc026c000},
    {0x68,0x9a17207c},
    {0x6c,0xfa034000},
    {0x70,0x033ff000},
    {0x74,0xba2f4001},
    {0x78,0xfa234000},
    {0x7c,0x033fc1c0},
    {0xf0,0x36},
    {0x00,0xda002340},
    {0x04,0x82106064},
    {0x08,0xda204000},
    {0x0c,0x0300007f},
    {0x10,0x96142010},
    {0x14,0x821063ff},
    {0x18,0xc222c000},
    {0x1c,0x1907ffc0},
    {0x20,0x94142030},
    {0x24,0xd8228000},
    {0x28,0xa0142014},
    {0x2c,0xd8240000},
    {0x30,0x7ffffdd4},
    {0x34,0xd0002374},
    {0x38,0x173fc080},
    {0x3c,0xc2002174},
    {0x40,0x90103fff},
    {0x44,0x80a06000},
    {0x48,0x02800006},
    {0x4c,0x9812e008},
    {0x50,0xc2082174},
    {0x54,0xda082177},
    {0x58,0xc2230000},
    {0x5c,0xda22c000},
    {0x60,0x7ffffee7},
    {0x64,0x01000000},
    {0x68,0x7ffffed4},
    {0x6c,0x90102001},
    {0x70,0x82103fff},
    {0x74,0xc226c000},
    {0x78,0xf4270000},
    {0x7c,0x81c7e008},
    {0xf0,0x37},
    {0x00,0x81e80000},
    {0x04,0x9de3bf98},
    {0x08,0xc2002508},
    {0x0c,0x808860ff},
    {0x10,0x0280001c},
    {0x14,0x01000000},
    {0x18,0xc2002508},
    {0x1c,0x820860ff},
    {0x20,0x80a04018},
    {0x24,0x213c0000},
    {0x28,0x12800014},
    {0x2c,0x033fc180},
    {0x30,0x7ffffc82},
    {0x34,0x01000000},
    {0x38,0x1b002000},
    {0x3c,0x033fc180},
    {0x40,0x9a2c000d},
    {0x44,0x82106034},
    {0x48,0xda204000},
    {0x4c,0x033fc040},
    {0x50,0x8210600c},
    {0x54,0x1100000a},
    {0x58,0xc0204000},
    {0x5c,0x7ffffc6e},
    {0x60,0x90122104},
    {0x64,0xc2002508},
    {0x68,0x820860ff},
    {0x6c,0x80a04018},
    {0x70,0x10bfffee},
    {0x74,0xa0042001},
    {0x78,0x8210603c},
    {0x7c,0xc0204000},
    {0xf0,0x38},
    {0x00,0x81c7e008},
    {0x04,0x81e80000},
    {0x08,0x9a102000},
    {0x0c,0x832b6002},
    {0x10,0x9a036001},
    {0x14,0x80a360b5},
    {0x18,0x08bffffd},
    {0x1c,0xc0220001},
    {0x20,0x81c3e008},
    {0x24,0x01000000},
    {0x28,0xc20022f8},
    {0x2c,0xda00247c},
    {0x30,0x8258400d},
    {0x34,0x83306001},
    {0x38,0x96102000},
    {0x3c,0x80a2c001},
    {0x40,0x1a80003b},
    {0x44,0x0300003f},
    {0x48,0x941063ff},
    {0x4c,0x98102000},
    {0x50,0x80a26001},
    {0x54,0x0280002e},
    {0x58,0x80a26004},
    {0x5c,0x12800008},
    {0x60,0x80a26008},
    {0x64,0xc2030008},
    {0x68,0x9a08400a},
    {0x6c,0x83306012},
    {0x70,0x83286010},
    {0x74,0x10800014},
    {0x78,0x9b336002},
    {0x7c,0x28800015},
    {0xf0,0x39},
    {0x00,0xda02000c},
    {0x04,0xda030008},
    {0x08,0x83336010},
    {0x0c,0x82004001},
    {0x10,0x9a0b400a},
    {0x14,0x81800000},
    {0x18,0x01000000},
    {0x1c,0x01000000},
    {0x20,0x01000000},
    {0x24,0x82704009},
    {0x28,0x9a03400d},
    {0x2c,0x83286010},
    {0x30,0x81800000},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0x01000000},
    {0x40,0x9a734009},
    {0x44,0x8200400d},
    {0x48,0x10800011},
    {0x4c,0xc2230008},
    {0x50,0x83336010},
    {0x54,0x81800000},
    {0x58,0x01000000},
    {0x5c,0x01000000},
    {0x60,0x01000000},
    {0x64,0x82704009},
    {0x68,0x9a0b400a},
    {0x6c,0x83286010},
    {0x70,0x81800000},
    {0x74,0x01000000},
    {0x78,0x01000000},
    {0x7c,0x01000000},
    {0xf0,0x3a},
    {0x00,0x9a734009},
    {0x04,0x8200400d},
    {0x08,0xc222000c},
    {0x0c,0xc20022f8},
    {0x10,0xda00247c},
    {0x14,0x8258400d},
    {0x18,0x9602e001},
    {0x1c,0x83306001},
    {0x20,0x80a2c001},
    {0x24,0x0abfffcb},
    {0x28,0x98032004},
    {0x2c,0x81c3e008},
    {0x30,0x01000000},
    {0x34,0x98102000},
    {0x38,0x9b2b2002},
    {0x3c,0x98032001},
    {0x40,0xc202000d},
    {0x44,0x80a320b5},
    {0x48,0x04bffffc},
    {0x4c,0xc222400d},
    {0x50,0x81c3e008},
    {0x54,0x01000000},
    {0x58,0xd6020000},
    {0x5c,0xd8024000},
    {0x60,0x9132e010},
    {0x64,0x95332010},
    {0x68,0x900a2fff},
    {0x6c,0x940aafff},
    {0x70,0x03000007},
    {0x74,0x9a22000a},
    {0x78,0x821063ff},
    {0x7c,0x940b0001},
    {0xf0,0x3b},
    {0x00,0x900ac001},
    {0x04,0x9022000a},
    {0x08,0x9a5b400d},
    {0x0c,0x905a0008},
    {0x10,0x81c3e008},
    {0x14,0x90034008},
    {0x18,0x9de3bf88},
    {0x1c,0x832e6004},
    {0x20,0x82004018},
    {0x24,0x3b000018},
    {0x28,0xba1760e0},
    {0x2c,0x83286002},
    {0x30,0xf400401d},
    {0x34,0x033fc000},
    {0x38,0x82106001},
    {0x3c,0xc227bfe8},
    {0x40,0x03000040},
    {0x44,0xc227bfec},
    {0x48,0x033fc040},
    {0x4c,0x821061fe},
    {0x50,0xc227bff0},
    {0x54,0x0300bf80},
    {0x58,0x82106101},
    {0x5c,0xc227bff4},
    {0x60,0x9e10001d},
    {0x64,0xb6102000},
    {0x68,0x9a07bff8},
    {0x6c,0xba06c00d},
    {0x70,0xc24f7ff0},
    {0x74,0xb0060001},
    {0x78,0xc24f7ff8},
    {0x7c,0xb2064001},
    {0xf0,0x3c},
    {0x00,0x82067fff},
    {0x04,0x82164001},
    {0x08,0x80a62000},
    {0x0c,0x0480001c},
    {0x10,0xbb30601f},
    {0x14,0xc2002308},
    {0x18,0x80a04018},
    {0x1c,0x82402000},
    {0x20,0x8090401d},
    {0x24,0x32800017},
    {0x28,0xb606e001},
    {0x2c,0xc2002300},
    {0x30,0x80a64001},
    {0x34,0x18800012},
    {0x38,0xbb2e6004},
    {0x3c,0x82074018},
    {0x40,0x80a6e003},
    {0x44,0x14800008},
    {0x48,0xb9286002},
    {0x4c,0xc207000f},
    {0x50,0x80a0401a},
    {0x54,0x2680000b},
    {0x58,0xb606e001},
    {0x5c,0x1080000d},
    {0x60,0xb0102000},
    {0x64,0xc207000f},
    {0x68,0x80a0401a},
    {0x6c,0x24800005},
    {0x70,0xb606e001},
    {0x74,0x10800007},
    {0x78,0xb0102000},
    {0x7c,0xb606e001},
    {0xf0,0x3d},
    {0x00,0x80a6e007},
    {0x04,0x04bfffdb},
    {0x08,0xba06c00d},
    {0x0c,0xb0102001},
    {0x10,0x81c7e008},
    {0x14,0x81e80000},
    {0x18,0xc020255c},
    {0x1c,0xc0202514},
    {0x20,0x9a102000},
    {0x24,0x832b6002},
    {0x28,0x9a036001},
    {0x2c,0xc0206738},
    {0x30,0x80a36009},
    {0x34,0x04bffffc},
    {0x38,0xc0206710},
    {0x3c,0x81c3e008},
    {0x40,0x01000000},
    {0x44,0x9de3bf88},
    {0x48,0x82063fff},
    {0x4c,0xb8067fff},
    {0x50,0x82160001},
    {0x54,0xba16401c},
    {0x58,0x80974001},
    {0x5c,0xa410001a},
    {0x60,0x0680007c},
    {0x64,0xa210001b},
    {0x68,0xc2002308},
    {0x6c,0x80a60001},
    {0x70,0x38800079},
    {0x74,0xb0102000},
    {0x78,0xc2002300},
    {0x7c,0x80a64001},
    {0xf0,0x3e},
    {0x00,0x38800075},
    {0x04,0xb0102000},
    {0x08,0x96062001},
    {0x0c,0x98066001},
    {0x10,0xa007bff8},
    {0x14,0x8207bfe8},
    {0x18,0xb0102003},
    {0x1c,0xc0204000},
    {0x20,0xb0863fff},
    {0x24,0x1cbffffe},
    {0x28,0x82006004},
    {0x2c,0xc2002160},
    {0x30,0x80886004},
    {0x34,0x0280000f},
    {0x38,0xb0102004},
    {0x3c,0x80a66001},
    {0x40,0x0280000b},
    {0x44,0x821021ff},
    {0x48,0xc2002308},
    {0x4c,0x80a60001},
    {0x50,0x02800007},
    {0x54,0x821021ff},
    {0x58,0xc2002300},
    {0x5c,0x80a64001},
    {0x60,0x12800005},
    {0x64,0x80a7000c},
    {0x68,0x821021ff},
    {0x6c,0xc227bff4},
    {0x70,0x80a7000c},
    {0x74,0x14800030},
    {0x78,0xb210001c},
    {0x7c,0x8207001c},
    {0xf0,0x3f},
    {0x00,0xba03000c},
    {0x04,0xba07400c},
    {0x08,0x8200401c},
    {0x0c,0x8220401d},
    {0x10,0x3b000018},
    {0x14,0x901760e0},
    {0x18,0x9a20400b},
    {0x1c,0xb002fffe},
    {0x20,0x832e6004},
    {0x24,0x82004018},
    {0x28,0x83286002},
    {0x2c,0xba06000d},
    {0x30,0xb4004008},
    {0x34,0xb6076008},
    {0x38,0x92102001},
    {0x3c,0x952a401b},
    {0x40,0x9e102000},
    {0x44,0xb92be002},
    {0x48,0xfa072520},
    {0x4c,0xba5f4011},
    {0x50,0x833f601f},
    {0x54,0x83306018},
    {0x58,0xba074001},
    {0x5c,0xc2068000},
    {0x60,0x82204012},
    {0x64,0xbb3f6008},
    {0x68,0x9e03e001},
    {0x6c,0x80a0401d},
    {0x70,0x04800005},
    {0x74,0xb8070010},
    {0x78,0xc2073ff0},
    {0x7c,0x8210400a},
    {0xf0,0x40},
    {0x00,0xc2273ff0},
    {0x04,0x80a3e003},
    {0x08,0x08bffff0},
    {0x0c,0xb92be002},
    {0x10,0xb0062001},
    {0x14,0xb606e001},
    {0x18,0x80a6000b},
    {0x1c,0x04bfffe8},
    {0x20,0xb406a004},
    {0x24,0xb2066001},
    {0x28,0x80a6400c},
    {0x2c,0x04bfffdc},
    {0x30,0x9a036003},
    {0x34,0xc207bfe8},
    {0x38,0x80886010},
    {0x3c,0x0280000a},
    {0x40,0xfa07bfec},
    {0x44,0xc207bff4},
    {0x48,0x80886082},
    {0x4c,0x02800007},
    {0x50,0x808f6010},
    {0x54,0x80886028},
    {0x58,0x1280001f},
    {0x5c,0xb0102003},
    {0x60,0xfa07bfec},
    {0x64,0x808f6010},
    {0x68,0x02800012},
    {0x6c,0xc207bff0},
    {0x70,0x808f6082},
    {0x74,0x02800007},
    {0x78,0x808f6028},
    {0x7c,0xc207bff4},
    {0xf0,0x41},
    {0x00,0x80886028},
    {0x04,0x32800014},
    {0x08,0xb0102002},
    {0x0c,0x808f6028},
    {0x10,0x02800008},
    {0x14,0xc207bff0},
    {0x18,0xc207bff4},
    {0x1c,0x80886082},
    {0x20,0x02800004},
    {0x24,0xc207bff0},
    {0x28,0x1080000b},
    {0x2c,0xb0102002},
    {0x30,0x80886010},
    {0x34,0x02800008},
    {0x38,0xb0102000},
    {0x3c,0x80886082},
    {0x40,0x02800005},
    {0x44,0x80886028},
    {0x48,0x12800003},
    {0x4c,0xb0102001},
    {0x50,0xb0102000},
    {0x54,0x81c7e008},
    {0x58,0x81e80000},
    {0x5c,0x94102000},
    {0x60,0xc2002514},
    {0x64,0x80a28001},
    {0x68,0x96102000},
    {0x6c,0x1a80000e},
    {0x70,0x9b2ae002},
    {0x74,0xc2036710},
    {0x78,0x9602e001},
    {0x7c,0x80a06000},
    {0xf0,0x42},
    {0x00,0x02800006},
    {0x04,0x992aa002},
    {0x08,0xc2232710},
    {0x0c,0xc2036738},
    {0x10,0x9402a001},
    {0x14,0xc2232738},
    {0x18,0xc2002514},
    {0x1c,0x10bffff4},
    {0x20,0x80a2c001},
    {0x24,0x81c3e008},
    {0x28,0xd4202514},
    {0x2c,0xd4020000},
    {0x30,0x03000016},
    {0x34,0x9802800a},
    {0x38,0x82106330},
    {0x3c,0xda530001},
    {0x40,0xc2002590},
    {0x44,0xc250400c},
    {0x48,0x96a0400d},
    {0x4c,0x02800016},
    {0x50,0x03000016},
    {0x54,0x80a2e000},
    {0x58,0x04800009},
    {0x5c,0x82102001},
    {0x60,0xda022004},
    {0x64,0x8328400d},
    {0x68,0x80a2c001},
    {0x6c,0x3480000d},
    {0x70,0x973ac00d},
    {0x74,0x1080000b},
    {0x78,0x96102001},
    {0x7c,0x1680000a},
    {0xf0,0x43},
    {0x00,0x03000016},
    {0x04,0xda022008},
    {0x08,0x82103fff},
    {0x0c,0x8328400d},
    {0x10,0x80a2c001},
    {0x14,0x36800003},
    {0x18,0x96103fff},
    {0x1c,0x973ac00d},
    {0x20,0x03000016},
    {0x24,0x92106330},
    {0x28,0x8202800a},
    {0x2c,0xc2504009},
    {0x30,0x9602c001},
    {0x34,0x808aa001},
    {0x38,0x0280000f},
    {0x3c,0x9b3aa01f},
    {0x40,0x9b33601f},
    {0x44,0x9a02800d},
    {0x48,0x9b3b6001},
    {0x4c,0x9b2b6002},
    {0x50,0xd8034009},
    {0x54,0x033fffc0},
    {0x58,0x980b0001},
    {0x5c,0x0300003f},
    {0x60,0x821063ff},
    {0x64,0x820ac001},
    {0x68,0x98030001},
    {0x6c,0x1080000d},
    {0x70,0xd8234009},
    {0x74,0x9b33601f},
    {0x78,0x9a02800d},
    {0x7c,0x9b3b6001},
    {0xf0,0x44},
    {0x00,0x9b2b6002},
    {0x04,0x0300003f},
    {0x08,0xd8034009},
    {0x0c,0x821063ff},
    {0x10,0x980b0001},
    {0x14,0x832ae010},
    {0x18,0x8200400c},
    {0x1c,0xc2234009},
    {0x20,0xc2020000},
    {0x24,0xda00247c},
    {0x28,0x8200400d},
    {0x2c,0x81c3e008},
    {0x30,0xc2220000},
    {0x34,0x9de3bf98},
    {0x38,0x833e201f},
    {0x3c,0xd0002320},
    {0x40,0x82204018},
    {0x44,0x80a22000},
    {0x48,0x02800015},
    {0x4c,0x9b30601f},
    {0x50,0x033fc000},
    {0x54,0xa0106020},
    {0x58,0xc200231c},
    {0x5c,0x80a00001},
    {0x60,0x82402000},
    {0x64,0x8088400d},
    {0x68,0xc2002318},
    {0x6c,0x02800009},
    {0x70,0xb01e0001},
    {0x74,0x80a00001},
    {0x78,0x82603fff},
    {0x7c,0x7ffffac6},
    {0xf0,0x45},
    {0x00,0xc2240000},
    {0x04,0xc2002318},
    {0x08,0x10800005},
    {0x0c,0xc2240000},
    {0x10,0x033fc000},
    {0x14,0x82106020},
    {0x18,0xf0204000},
    {0x1c,0x81c7e008},
    {0x20,0x81e80000},
    {0x24,0x9de3bf98},
    {0x28,0x7ffffac4},
    {0x2c,0x01000000},
    {0x30,0xe0002500},
    {0x34,0x80a42028},
    {0x38,0x08800013},
    {0x3c,0x80a42000},
    {0x40,0xc0202584},
    {0x44,0xa2102000},
    {0x48,0x832c6002},
    {0x4c,0xc2006f04},
    {0x50,0x80a06000},
    {0x54,0x02800056},
    {0x58,0xa2046001},
    {0x5c,0x9fc04000},
    {0x60,0x01000000},
    {0x64,0xc2002584},
    {0x68,0x80a06000},
    {0x6c,0x12800050},
    {0x70,0x80a4603b},
    {0x74,0x24bffff6},
    {0x78,0x832c6002},
    {0x7c,0x1080004d},
    {0xf0,0x46},
    {0x00,0xc2002500},
    {0x04,0x1280000d},
    {0x08,0x80a42014},
    {0x0c,0xc2002fcc},
    {0x10,0x9fc04000},
    {0x14,0x01000000},
    {0x18,0x7ffffcf9},
    {0x1c,0x90102000},
    {0x20,0x7ffffce6},
    {0x24,0x90102001},
    {0x28,0xc200254c},
    {0x2c,0x82087ffb},
    {0x30,0x1080003f},
    {0x34,0xc220254c},
    {0x38,0x1880000c},
    {0x3c,0x80a42015},
    {0x40,0x808c2001},
    {0x44,0x3280003b},
    {0x48,0xc2002500},
    {0x4c,0x90043ffe},
    {0x50,0x7ffffc7b},
    {0x54,0x91322001},
    {0x58,0x7ffffc5d},
    {0x5c,0x01000000},
    {0x60,0x10800034},
    {0x64,0xc2002500},
    {0x68,0x18800011},
    {0x6c,0x80a42018},
    {0x70,0x033fc180},
    {0x74,0xda0025b0},
    {0x78,0x82106038},
    {0x7c,0xda204000},
    {0xf0,0x47},
    {0x00,0x033fc200},
    {0x04,0x82106074},
    {0x08,0xda00232c},
    {0x0c,0xda204000},
    {0x10,0x7ffffcca},
    {0x14,0x90102000},
    {0x18,0xc200254c},
    {0x1c,0x82106004},
    {0x20,0xc220254c},
    {0x24,0x10800020},
    {0x28,0xc2002fcc},
    {0x2c,0x1880000c},
    {0x30,0x80a42028},
    {0x34,0x90102000},
    {0x38,0x92102000},
    {0x3c,0xc2002fc0},
    {0x40,0x9fc04000},
    {0x44,0x94102000},
    {0x48,0x11000016},
    {0x4c,0x7ffffe0f},
    {0x50,0x90122330},
    {0x54,0x10800017},
    {0x58,0xc2002500},
    {0x5c,0x38800015},
    {0x60,0xc2002500},
    {0x64,0x7ffffbbc},
    {0x68,0x23000016},
    {0x6c,0x92146330},
    {0x70,0xc2002fc0},
    {0x74,0x9fc04000},
    {0x78,0x94043fe8},
    {0x7c,0x80a42028},
    {0xf0,0x48},
    {0x00,0x3280000c},
    {0x04,0xc2002500},
    {0x08,0x90146330},
    {0x0c,0x7ffffe07},
    {0x10,0x92102008},
    {0x14,0xc2002fd8},
    {0x18,0x80a06000},
    {0x1c,0x22800005},
    {0x20,0xc2002500},
    {0x24,0x9fc04000},
    {0x28,0x01000000},
    {0x2c,0xc2002500},
    {0x30,0x80a40001},
    {0x34,0x1280000b},
    {0x38,0x031fffff},
    {0x3c,0x821063f0},
    {0x40,0x80a40001},
    {0x44,0x38800003},
    {0x48,0x21040000},
    {0x4c,0xa0042001},
    {0x50,0x033fc180},
    {0x54,0x82106034},
    {0x58,0xe0204000},
    {0x5c,0xe0202500},
    {0x60,0x81c7e008},
    {0x64,0x81e80000},
    {0x68,0x81c3e008},
    {0x6c,0x01000000},
    {0x70,0x9de3bf60},
    {0x74,0x1b00003f},
    {0x78,0xc2002350},
    {0x7c,0x9a1363ff},
    {0xf0,0x49},
    {0x00,0xae08400d},
    {0x04,0xa6102001},
    {0x08,0xda002300},
    {0x0c,0x80a4c00d},
    {0x10,0x18800062},
    {0x14,0xa3306010},
    {0x18,0xa4102010},
    {0x1c,0xac102000},
    {0x20,0xaa102000},
    {0x24,0xa8102000},
    {0x28,0x80a46000},
    {0x2c,0x0280002c},
    {0x30,0xa0102000},
    {0x34,0x03000018},
    {0x38,0x961060e0},
    {0x3c,0x92102000},
    {0x40,0x9807bfc0},
    {0x44,0x82050009},
    {0x48,0xda086440},
    {0x4c,0x8204800d},
    {0x50,0x80a36000},
    {0x54,0x02800008},
    {0x58,0x83286002},
    {0x5c,0xc200400b},
    {0x60,0xc2230000},
    {0x64,0x92026001},
    {0x68,0x80a2600b},
    {0x6c,0x04bffff6},
    {0x70,0x98032004},
    {0x74,0x7ffffa38},
    {0x78,0x9007bfc0},
    {0x7c,0x80a5c011},
    {0xf0,0x4a},
    {0x00,0x1480000b},
    {0x04,0x92100017},
    {0x08,0x832de002},
    {0x0c,0x8200401e},
    {0x10,0x9a007fc0},
    {0x14,0xc2034000},
    {0x18,0x92026001},
    {0x1c,0xa0040001},
    {0x20,0x80a24011},
    {0x24,0x04bffffc},
    {0x28,0x9a036004},
    {0x2c,0x82244017},
    {0x30,0x82006001},
    {0x34,0x9b3c201f},
    {0x38,0x81836000},
    {0x3c,0x01000000},
    {0x40,0x01000000},
    {0x44,0x01000000},
    {0x48,0xa07c0001},
    {0x4c,0xc25021ae},
    {0x50,0x80a40001},
    {0x54,0x26800002},
    {0x58,0xa0100001},
    {0x5c,0x03000018},
    {0x60,0x941060e0},
    {0x64,0x92102000},
    {0x68,0x82054009},
    {0x6c,0xda086440},
    {0x70,0x8204800d},
    {0x74,0x99286002},
    {0x78,0x80a36000},
    {0x7c,0x0280001d},
    {0xf0,0x4b},
    {0x00,0x9610000c},
    {0x04,0x80a42000},
    {0x08,0x2480000c},
    {0x0c,0xc202c00a},
    {0x10,0xc203000a},
    {0x14,0x80a04010},
    {0x18,0x16800007},
    {0x1c,0x98102000},
    {0x20,0x80a06000},
    {0x24,0x24800006},
    {0x28,0x98100001},
    {0x2c,0x10800005},
    {0x30,0x8204800d},
    {0x34,0xc202c00a},
    {0x38,0x98204010},
    {0x3c,0x8204800d},
    {0x40,0x9b286002},
    {0x44,0xc20023c8},
    {0x48,0x83306011},
    {0x4c,0x80886001},
    {0x50,0x02800005},
    {0x54,0x92026001},
    {0x58,0xc20ce2af},
    {0x5c,0x825b0001},
    {0x60,0x99386007},
    {0x64,0x80a2600b},
    {0x68,0x04bfffe0},
    {0x6c,0xd823400a},
    {0x70,0xac05a001},
    {0x74,0xa805200c},
    {0x78,0x80a5a001},
    {0x7c,0x04bfffab},
    {0xf0,0x4c},
    {0x00,0xaa05600c},
    {0x04,0xa604e001},
    {0x08,0xc2002300},
    {0x0c,0x80a4c001},
    {0x10,0x08bfffa3},
    {0x14,0xa404a010},
    {0x18,0x81c7e008},
    {0x1c,0x81e80000},
    {0x20,0x9de3bf98},
    {0x24,0x9e100018},
    {0x28,0x80a66000},
    {0x2c,0x0280001b},
    {0x30,0xb010001a},
    {0x34,0x031fffdf},
    {0x38,0xb41063ff},
    {0x3c,0x82102000},
    {0x40,0xbb286002},
    {0x44,0x80a62009},
    {0x48,0xb6006001},
    {0x4c,0x12800006},
    {0x50,0xb810001d},
    {0x54,0xc206401d},
    {0x58,0x83306001},
    {0x5c,0x8208401a},
    {0x60,0xc226401d},
    {0x64,0x80a62008},
    {0x68,0x08800006},
    {0x6c,0xc206401c},
    {0x70,0xfa03c01c},
    {0x74,0xbb376001},
    {0x78,0x10800003},
    {0x7c,0xba0f401a},
    {0xf0,0x4d},
    {0x00,0xfa03c01c},
    {0x04,0x8200401d},
    {0x08,0xc226401c},
    {0x0c,0x80a6e0b5},
    {0x10,0x08bfffec},
    {0x14,0x8210001b},
    {0x18,0x81c7e008},
    {0x1c,0x81e80000},
    {0x20,0x03169696},
    {0x24,0xda002180},
    {0x28,0x8210625a},
    {0x2c,0x80a34001},
    {0x30,0x94102000},
    {0x34,0x12800006},
    {0x38,0x96102000},
    {0x3c,0x033fc180},
    {0x40,0x82106030},
    {0x44,0x10800024},
    {0x48,0xda204000},
    {0x4c,0xc202c000},
    {0x50,0x9602e004},
    {0x54,0x80a2e4ff},
    {0x58,0x08bffffd},
    {0x5c,0x94028001},
    {0x60,0x96102d00},
    {0x64,0xd2002ff8},
    {0x68,0x03000019},
    {0x6c,0x80a2c009},
    {0x70,0x1a80000b},
    {0x74,0x901063ff},
    {0x78,0xd802c000},
    {0x7c,0x9602e004},
    {0xf0,0x4e},
    {0x00,0x80a2c009},
    {0x04,0x9a402000},
    {0x08,0x80a2000b},
    {0x0c,0x82603fff},
    {0x10,0x808b4001},
    {0x14,0x12bffff9},
    {0x18,0x9402800c},
    {0x1c,0xc20021fc},
    {0x20,0x94228001},
    {0x24,0xc2002200},
    {0x28,0x94228001},
    {0x2c,0x03169696},
    {0x30,0x8210625a},
    {0x34,0x80a28001},
    {0x38,0x033fc180},
    {0x3c,0x82106030},
    {0x40,0x02800005},
    {0x44,0xd4204000},
    {0x48,0x03000008},
    {0x4c,0x81c06234},
    {0x50,0x90102001},
    {0x54,0x01000000},
    {0x58,0x81c3e008},
    {0x5c,0x01000000},
    {0x60,0x9de3bf98},
    {0x64,0x9e100018},
    {0x68,0x03000018},
    {0x6c,0xb0100019},
    {0x70,0xba1060e0},
    {0x74,0xb6102000},
    {0x78,0x832ee002},
    {0x7c,0xb606e001},
    {0xf0,0x4f},
    {0x00,0x80a6e1bf},
    {0x04,0x08bffffd},
    {0x08,0xc020401d},
    {0x0c,0xb6102000},
    {0x10,0xc20022fc},
    {0x14,0x80a6c001},
    {0x18,0x1a80001c},
    {0x1c,0x03000018},
    {0x20,0xb2106124},
    {0x24,0xb4102000},
    {0x28,0xc20022f8},
    {0x2c,0x80a68001},
    {0x30,0x1a800011},
    {0x34,0x832ee002},
    {0x38,0xb8004019},
    {0x3c,0xc200247c},
    {0x40,0xfa0ee380},
    {0x44,0x825e8001},
    {0x48,0x8200401d},
    {0x4c,0x82004001},
    {0x50,0xfa160001},
    {0x54,0xc213c001},
    {0x58,0x8220401d},
    {0x5c,0xc2270000},
    {0x60,0xb406a001},
    {0x64,0xc20022f8},
    {0x68,0x80a68001},
    {0x6c,0x0abffff4},
    {0x70,0xb8072040},
    {0x74,0xb606e001},
    {0x78,0xc20022fc},
    {0x7c,0x80a6c001},
    {0xf0,0x50},
    {0x00,0x0abfffea},
    {0x04,0xb4102000},
    {0x08,0x81c7e008},
    {0x0c,0x81e80000},
    {0x10,0x9de3bf98},
    {0x14,0x11000016},
    {0x18,0xc2002fe4},
    {0x1c,0x9fc04000},
    {0x20,0x90122330},
    {0x24,0xc200259c},
    {0x28,0xd800254c},
    {0x2c,0x808b2002},
    {0x30,0x02800034},
    {0x34,0xc2202550},
    {0x38,0xda002654},
    {0x3c,0x8203400d},
    {0x40,0x8200400d},
    {0x44,0xda00259c},
    {0x48,0xb20362d8},
    {0x4c,0x82004001},
    {0x50,0x9a102061},
    {0x54,0x9a234001},
    {0x58,0x832e6007},
    {0x5c,0x9738601f},
    {0x60,0x8182e000},
    {0x64,0x01000000},
    {0x68,0x01000000},
    {0x6c,0x01000000},
    {0x70,0xb278400d},
    {0x74,0x980b3ffd},
    {0x78,0x11000017},
    {0x7c,0xd820254c},
    {0xf0,0x51},
    {0x00,0xc2002fe4},
    {0x04,0x9fc04000},
    {0x08,0x90122208},
    {0x0c,0x11000014},
    {0x10,0xe000259c},
    {0x14,0xc2002fe4},
    {0x18,0x9fc04000},
    {0x1c,0x901222a8},
    {0x20,0x80a64010},
    {0x24,0x9a603fff},
    {0x28,0xc200259c},
    {0x2c,0x80a64001},
    {0x30,0x82603fff},
    {0x34,0x80934001},
    {0x38,0x22800012},
    {0x3c,0xc020250c},
    {0x40,0x21000018},
    {0x44,0x7ffffa8d},
    {0x48,0x90142260},
    {0x4c,0xa0142260},
    {0x50,0xb2102000},
    {0x54,0x9b2e6002},
    {0x58,0xb2066001},
    {0x5c,0xc2034010},
    {0x60,0x80a66017},
    {0x64,0x04bffffc},
    {0x68,0xc22365b0},
    {0x6c,0x7ffffaf8},
    {0x70,0x01000000},
    {0x74,0x82102015},
    {0x78,0x10800010},
    {0x7c,0xc2202500},
    {0xf0,0x52},
    {0x00,0xc200250c},
    {0x04,0x80a06000},
    {0x08,0x1280000c},
    {0x0c,0x031696a9},
    {0x10,0x821061a5},
    {0x14,0x31000016},
    {0x18,0x33000014},
    {0x1c,0xc220250c},
    {0x20,0xc0202658},
    {0x24,0xc0202654},
    {0x28,0xb0162330},
    {0x2c,0xb21662a8},
    {0x30,0x7ffffd01},
    {0x34,0x81e80000},
    {0x38,0x01000000},
    {0x3c,0x81c7e008},
    {0x40,0x81e80000},
    {0x44,0x9de3bf30},
    {0x48,0xc2102548},
    {0x4c,0x80886001},
    {0x50,0x94100018},
    {0x54,0x9a102000},
    {0x58,0x96102000},
    {0x5c,0x02800004},
    {0x60,0x98102000},
    {0x64,0xc020259c},
    {0x68,0x3080002e},
    {0x6c,0x9e102000},
    {0x70,0x8203000f},
    {0x74,0xf6086441},
    {0x78,0x80a6e000},
    {0x7c,0x02800024},
    {0xf0,0x53},
    {0x00,0xf4086440},
    {0x04,0xc208217d},
    {0x08,0x80807fff},
    {0x0c,0xf40ea37f},
    {0x10,0xf60ee37f},
    {0x14,0x0c80001a},
    {0x18,0xb2102000},
    {0x1c,0xb007bff8},
    {0x20,0xc200247c},
    {0x24,0x82584019},
    {0x28,0xba06c001},
    {0x2c,0x82068001},
    {0x30,0x82004001},
    {0x34,0xf8528001},
    {0x38,0xba07401d},
    {0x3c,0xc252801d},
    {0x40,0xb8270001},
    {0x44,0x80a66000},
    {0x48,0x02800007},
    {0x4c,0xf8263f98},
    {0x50,0xc2063f94},
    {0x54,0x82a70001},
    {0x58,0x2c800003},
    {0x5c,0x9a234001},
    {0x60,0x9a034001},
    {0x64,0xc208217d},
    {0x68,0xb2066001},
    {0x6c,0x82007fff},
    {0x70,0x80a64001},
    {0x74,0x04bfffeb},
    {0x78,0xb0062004},
    {0x7c,0x9e03e001},
    {0xf0,0x54},
    {0x00,0x80a3e00a},
    {0x04,0x04bfffdc},
    {0x08,0x8203000f},
    {0x0c,0x9602e001},
    {0x10,0x80a2e001},
    {0x14,0x04bfffd6},
    {0x18,0x9803200c},
    {0x1c,0xda20259c},
    {0x20,0x81c7e008},
    {0x24,0x81e80000},
    {0x28,0x9de3bf58},
    {0x2c,0xc208224d},
    {0x30,0x80a06000},
    {0x34,0x12800004},
    {0x38,0x94067ffe},
    {0x3c,0xc020259c},
    {0x40,0x30800065},
    {0x44,0xa6066002},
    {0x48,0x80a28013},
    {0x4c,0x1480003f},
    {0x50,0x90102000},
    {0x54,0xa0062002},
    {0x58,0x96063ffe},
    {0x5c,0x80a2c010},
    {0x60,0x14800036},
    {0x64,0x833aa01f},
    {0x68,0x8220400a},
    {0x6c,0x9a064019},
    {0x70,0x9a23400a},
    {0x74,0x992a2002},
    {0x78,0xab30601f},
    {0x7c,0x9803001e},
    {0xf0,0x55},
    {0x00,0x03000018},
    {0x04,0xa92b6004},
    {0x08,0xac1060e0},
    {0x0c,0x98033fb8},
    {0x10,0xa4063fff},
    {0x14,0xa2062001},
    {0x18,0x9a067fff},
    {0x1c,0x82060018},
    {0x20,0x8220400b},
    {0x24,0x82050001},
    {0x28,0x80a2c012},
    {0x2c,0x0680000b},
    {0x30,0x9f286002},
    {0x34,0x80a2c011},
    {0x38,0x14800009},
    {0x3c,0x80a2e000},
    {0x40,0x80a2800d},
    {0x44,0x06800005},
    {0x48,0x82066001},
    {0x4c,0x80a28001},
    {0x50,0x24800017},
    {0x54,0x9602e001},
    {0x58,0x80a2e000},
    {0x5c,0x24800010},
    {0x60,0xc203c016},
    {0x64,0xc2002308},
    {0x68,0x80a0400b},
    {0x6c,0x82603fff},
    {0x70,0x80884015},
    {0x74,0x2280000a},
    {0x78,0xc203c016},
    {0x7c,0x832aa004},
    {0xf0,0x56},
    {0x00,0x8200400b},
    {0x04,0x93286002},
    {0x08,0xc2002300},
    {0x0c,0x80a28001},
    {0x10,0x38800003},
    {0x14,0xc203c016},
    {0x18,0xc2024016},
    {0x1c,0xc2230000},
    {0x20,0x90022001},
    {0x24,0x98032004},
    {0x28,0x9602e001},
    {0x2c,0x80a2c010},
    {0x30,0x04bfffdc},
    {0x34,0x82060018},
    {0x38,0x9402a001},
    {0x3c,0x80a28013},
    {0x40,0x04bfffc7},
    {0x44,0x96063ffe},
    {0x48,0x9007bfb8},
    {0x4c,0x7ffff8a2},
    {0x50,0x92102010},
    {0x54,0xd608224f},
    {0x58,0xb00ae0ff},
    {0x5c,0xd808224d},
    {0x60,0x80a6000c},
    {0x64,0x1480000b},
    {0x68,0x90102000},
    {0x6c,0x832e2002},
    {0x70,0x8200401e},
    {0x74,0x9a007fb8},
    {0x78,0xc2034000},
    {0x7c,0xb0062001},
    {0xf0,0x57},
    {0x00,0x90020001},
    {0x04,0x80a6000c},
    {0x08,0x04bffffc},
    {0x0c,0x9a036004},
    {0x10,0x820ae0ff},
    {0x14,0xda08224d},
    {0x18,0x9a234001},
    {0x1c,0xc208224c},
    {0x20,0x9a036001},
    {0x24,0x825a0001},
    {0x28,0x9938601f},
    {0x2c,0x81832000},
    {0x30,0x01000000},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0x8278400d},
    {0x40,0x9b38601f},
    {0x44,0x9b336019},
    {0x48,0x8200400d},
    {0x4c,0x83386007},
    {0x50,0xc220259c},
    {0x54,0x81c7e008},
    {0x58,0x81e80000},
    {0x5c,0x9de3bf98},
    {0x60,0xc2002540},
    {0x64,0x82006001},
    {0x68,0xc2202540},
    {0x6c,0xc2002588},
    {0x70,0x80a06000},
    {0x74,0x02800014},
    {0x78,0x11000017},
    {0x7c,0xc2002594},
    {0xf0,0x58},
    {0x00,0x80a06000},
    {0x04,0x12800004},
    {0x08,0x90122208},
    {0x0c,0x7ffffbff},
    {0x10,0x01000000},
    {0x14,0xda002588},
    {0x18,0xc2002594},
    {0x1c,0x82006001},
    {0x20,0x9a037fff},
    {0x24,0xc2202594},
    {0x28,0x7ffff9ab},
    {0x2c,0xda202588},
    {0x30,0x13000017},
    {0x34,0x92126208},
    {0x38,0xc2002fc0},
    {0x3c,0x9fc04000},
    {0x40,0xd4002594},
    {0x44,0x01000000},
    {0x48,0x81c7e008},
    {0x4c,0x81e80000},
    {0x50,0xc2002588},
    {0x54,0x80a06001},
    {0x58,0x1280001a},
    {0x5c,0xda002298},
    {0x60,0xc2102548},
    {0x64,0x80886001},
    {0x68,0x22800009},
    {0x6c,0xc2002208},
    {0x70,0xc2002170},
    {0x74,0x80a06000},
    {0x78,0x22800005},
    {0x7c,0xc2002208},
    {0xf0,0x59},
    {0x00,0xc0202598},
    {0x04,0x1080000f},
    {0x08,0x9a100001},
    {0x0c,0x80a06000},
    {0x10,0x22800009},
    {0x14,0xc2002598},
    {0x18,0xc2002558},
    {0x1c,0x80a06000},
    {0x20,0x32800005},
    {0x24,0xc2002598},
    {0x28,0xc0202598},
    {0x2c,0x10800005},
    {0x30,0xda002234},
    {0x34,0x80a06000},
    {0x38,0x22800002},
    {0x3c,0xda00233c},
    {0x40,0x033fc200},
    {0x44,0x82106070},
    {0x48,0x81c3e008},
    {0x4c,0xda204000},
    {0x50,0x9de3bf98},
    {0x54,0xc2002588},
    {0x58,0x80a06000},
    {0x5c,0x02800010},
    {0x60,0x11000017},
    {0x64,0xd8002548},
    {0x68,0x83332010},
    {0x6c,0x80886001},
    {0x70,0x22800010},
    {0x74,0xc200258c},
    {0x78,0xc2002558},
    {0x7c,0x80a06000},
    {0xf0,0x5a},
    {0x00,0x3280000c},
    {0x04,0xc200258c},
    {0x08,0xc2002594},
    {0x0c,0x80a06001},
    {0x10,0x32800008},
    {0x14,0xc200258c},
    {0x18,0x11000017},
    {0x1c,0x90122208},
    {0x20,0xd0202590},
    {0x24,0xc0202588},
    {0x28,0x1080001a},
    {0x2c,0xd2002594},
    {0x30,0x80a06000},
    {0x34,0x12800015},
    {0x38,0x82102001},
    {0x3c,0xda002554},
    {0x40,0xc2002598},
    {0x44,0x80a0400d},
    {0x48,0x1a800007},
    {0x4c,0x03000014},
    {0x50,0x82102001},
    {0x54,0xda20258c},
    {0x58,0xc2202584},
    {0x5c,0x1080002b},
    {0x60,0xc0202598},
    {0x64,0x808b2400},
    {0x68,0x12800004},
    {0x6c,0x821062a8},
    {0x70,0x03000013},
    {0x74,0x821063d0},
    {0x78,0xc2202590},
    {0x7c,0xd2002598},
    {0xf0,0x5b},
    {0x00,0x10800004},
    {0x04,0xd0002590},
    {0x08,0x10800020},
    {0x0c,0xc2202584},
    {0x10,0x7ffffba6},
    {0x14,0x01000000},
    {0x18,0x13000016},
    {0x1c,0xc2002fd0},
    {0x20,0x92126330},
    {0x24,0x9fc04000},
    {0x28,0xd0002590},
    {0x2c,0xc2002690},
    {0x30,0x82087dff},
    {0x34,0xc2202690},
    {0x38,0x82102080},
    {0x3c,0xc220256c},
    {0x40,0xc2002200},
    {0x44,0x80a06000},
    {0x48,0x32800008},
    {0x4c,0xc2002548},
    {0x50,0xda002548},
    {0x54,0x83336010},
    {0x58,0x80886001},
    {0x5c,0x22800006},
    {0x60,0x03000004},
    {0x64,0xc2002548},
    {0x68,0x1b000004},
    {0x6c,0x10800003},
    {0x70,0x8210400d},
    {0x74,0x822b4001},
    {0x78,0xc2202548},
    {0x7c,0xc2002548},
    {0xf0,0x5c},
    {0x00,0x82087fbf},
    {0x04,0xc2202548},
    {0x08,0x81c7e008},
    {0x0c,0x81e80000},
    {0x10,0xda002508},
    {0x14,0x033fc000},
    {0x18,0x960b4001},
    {0x1c,0x808b7f00},
    {0x20,0x0280001a},
    {0x24,0x901020a5},
    {0x28,0x1500003f},
    {0x2c,0x8212a300},
    {0x30,0x980b4001},
    {0x34,0x03294000},
    {0x38,0x80a2c001},
    {0x3c,0x02800013},
    {0x40,0x01000000},
    {0x44,0xc200254c},
    {0x48,0x8210400c},
    {0x4c,0xc220254c},
    {0x50,0xc2002500},
    {0x54,0x80a06028},
    {0x58,0xc0202508},
    {0x5c,0x0880000b},
    {0x60,0x033fffc0},
    {0x64,0x9a0b4001},
    {0x68,0x03168000},
    {0x6c,0x80a2c001},
    {0x70,0x12800006},
    {0x74,0x9812a3ff},
    {0x78,0xc2002548},
    {0x7c,0x8208400c},
    {0xf0,0x5d},
    {0x00,0x8210400d},
    {0x04,0xc2202548},
    {0x08,0x03000006},
    {0x0c,0x81c06384},
    {0x10,0x01000000},
    {0x14,0x01000000},
    {0x18,0xda00247c},
    {0x1c,0xc20022f8},
    {0x20,0x8258400d},
    {0x24,0x83306001},
    {0x28,0x9a102000},
    {0x2c,0x80a34001},
    {0x30,0x1a800015},
    {0x34,0x031fffdf},
    {0x38,0x961063ff},
    {0x3c,0x98036001},
    {0x40,0x80a26008},
    {0x44,0x04800006},
    {0x48,0x9b2b6002},
    {0x4c,0xc202000d},
    {0x50,0x83306001},
    {0x54,0x10800003},
    {0x58,0x8208400b},
    {0x5c,0xc202000d},
    {0x60,0x82584009},
    {0x64,0xc222000d},
    {0x68,0xda00247c},
    {0x6c,0xc20022f8},
    {0x70,0x8258400d},
    {0x74,0x83306001},
    {0x78,0x80a30001},
    {0x7c,0x0abffff0},
    {0xf0,0x5e},
    {0x00,0x9a10000c},
    {0x04,0x81c3e008},
    {0x08,0x01000000},
    {0x0c,0x9de3bf98},
    {0x10,0xc2102548},
    {0x14,0x80886001},
    {0x18,0x12800068},
    {0x1c,0x01000000},
    {0x20,0xe6002460},
    {0x24,0x80a4e000},
    {0x28,0x02800064},
    {0x2c,0x01000000},
    {0x30,0xc2002588},
    {0x34,0xda002594},
    {0x38,0x9800400d},
    {0x3c,0xc2002554},
    {0x40,0x80a30001},
    {0x44,0x1280005d},
    {0x48,0x01000000},
    {0x4c,0xda002598},
    {0x50,0xc200258c},
    {0x54,0x8200400d},
    {0x58,0x80a0400c},
    {0x5c,0x02800004},
    {0x60,0x80a36000},
    {0x64,0x12800055},
    {0x68,0x01000000},
    {0x6c,0x96102001},
    {0x70,0xc208217e},
    {0x74,0x80a2c001},
    {0x78,0x1480002e},
    {0x7c,0x9e102000},
    {0xf0,0x5f},
    {0x00,0xa4100001},
    {0x04,0xe208217f},
    {0x08,0x13000018},
    {0x0c,0x94102001},
    {0x10,0x80a28011},
    {0x14,0x14800020},
    {0x18,0xa0102000},
    {0x1c,0x832ae002},
    {0x20,0x98006040},
    {0x24,0xac1260e0},
    {0x28,0xaa1260a0},
    {0x2c,0xa8126120},
    {0x30,0xd008217f},
    {0x34,0xda030016},
    {0x38,0x80a34013},
    {0x3c,0x26800013},
    {0x40,0x9402a001},
    {0x44,0x80a2a001},
    {0x48,0x22800007},
    {0x4c,0xc208217f},
    {0x50,0xc2030015},
    {0x54,0x80a34001},
    {0x58,0x2480000c},
    {0x5c,0x9402a001},
    {0x60,0xc208217f},
    {0x64,0x80a28001},
    {0x68,0x22800007},
    {0x6c,0xa0042001},
    {0x70,0xc2030014},
    {0x74,0x80a34001},
    {0x78,0x26800004},
    {0x7c,0x9402a001},
    {0xf0,0x60},
    {0x00,0xa0042001},
    {0x04,0x9402a001},
    {0x08,0x80a28008},
    {0x0c,0x04bfffea},
    {0x10,0x98032040},
    {0x14,0x80a4000f},
    {0x18,0x34800002},
    {0x1c,0x9e100010},
    {0x20,0x9602e001},
    {0x24,0x80a2c012},
    {0x28,0x24bfffda},
    {0x2c,0x94102001},
    {0x30,0x96102000},
    {0x34,0xc20ae464},
    {0x38,0x80a06000},
    {0x3c,0x22800006},
    {0x40,0x9602e001},
    {0x44,0x80a3c001},
    {0x48,0x34800007},
    {0x4c,0xc20ae278},
    {0x50,0x9602e001},
    {0x54,0x80a2e003},
    {0x58,0x24bffff8},
    {0x5c,0xc20ae464},
    {0x60,0x30800016},
    {0x64,0xda00256c},
    {0x68,0x8258400d},
    {0x6c,0x83306007},
    {0x70,0xc220256c},
    {0x74,0xe00ae468},
    {0x78,0x80a42000},
    {0x7c,0x0280000f},
    {0xf0,0x61},
    {0x00,0x82102001},
    {0x04,0xc2202584},
    {0x08,0xd0002590},
    {0x0c,0x7fffff83},
    {0x10,0xd2002554},
    {0x14,0xc2002588},
    {0x18,0x82004010},
    {0x1c,0xc2202588},
    {0x20,0xda00258c},
    {0x24,0xc2002554},
    {0x28,0x80a34001},
    {0x2c,0x18800003},
    {0x30,0x82034010},
    {0x34,0xc220258c},
    {0x38,0x81c7e008},
    {0x3c,0x81e80000},
    {0x40,0x9de3bf98},
    {0x44,0xc2002588},
    {0x48,0x80a06000},
    {0x4c,0x12800060},
    {0x50,0x01000000},
    {0x54,0xc20026f4},
    {0x58,0x82006001},
    {0x5c,0xda002310},
    {0x60,0x80a0400d},
    {0x64,0x0a80005a},
    {0x68,0xc22026f4},
    {0x6c,0xd800227c},
    {0x70,0x80a32000},
    {0x74,0x02800032},
    {0x78,0xc02026f4},
    {0x7c,0xda0022f8},
    {0xf0,0x62},
    {0x00,0xc200247c},
    {0x04,0x965b4001},
    {0x08,0x03000007},
    {0x0c,0x821063ff},
    {0x10,0x9b33200d},
    {0x14,0xa2102000},
    {0x18,0x920b4001},
    {0x1c,0x80a4400b},
    {0x20,0x900b0001},
    {0x24,0x94102000},
    {0x28,0x1a800015},
    {0x2c,0xa0102000},
    {0x30,0x03000017},
    {0x34,0xa4106208},
    {0x38,0x82007c00},
    {0x3c,0x9e106330},
    {0x40,0x9a040010},
    {0x44,0xc2134012},
    {0x48,0x80a24001},
    {0x4c,0xa2400011},
    {0x50,0xc253400f},
    {0x54,0x80a04008},
    {0x58,0x0a800005},
    {0x5c,0xa0042001},
    {0x60,0x80a04009},
    {0x64,0x08800004},
    {0x68,0x80a4000b},
    {0x6c,0x9402a001},
    {0x70,0x80a4000b},
    {0x74,0x0abffff4},
    {0x78,0x9a040010},
    {0x7c,0xa133201a},
    {0xf0,0x63},
    {0x00,0x80a44010},
    {0x04,0x14800003},
    {0x08,0x9a102001},
    {0x0c,0x9a102000},
    {0x10,0x80a28010},
    {0x14,0x14800003},
    {0x18,0x82102001},
    {0x1c,0x82102000},
    {0x20,0x80934001},
    {0x24,0x22800007},
    {0x28,0xc2002274},
    {0x2c,0x033fc180},
    {0x30,0x1b008000},
    {0x34,0x8210603c},
    {0x38,0xda204000},
    {0x3c,0xc2002274},
    {0x40,0x80a06000},
    {0x44,0x02800022},
    {0x48,0xa2102000},
    {0x4c,0xc20023d4},
    {0x50,0x80a44001},
    {0x54,0xa4102000},
    {0x58,0x1a800016},
    {0x5c,0xa0102000},
    {0x60,0xc200247c},
    {0x64,0x80a40001},
    {0x68,0x3a80000f},
    {0x6c,0xa404a001},
    {0x70,0x7ffff8c3},
    {0x74,0x90100010},
    {0x78,0x92100008},
    {0x7c,0x7ffff852},
    {0xf0,0x64},
    {0x00,0x90100012},
    {0x04,0x0300003f},
    {0x08,0xda002274},
    {0x0c,0x821063ff},
    {0x10,0x9a0b4001},
    {0x14,0x80a2000d},
    {0x18,0xa2400011},
    {0x1c,0x10bffff1},
    {0x20,0xa0042001},
    {0x24,0xc20023d4},
    {0x28,0x10bfffec},
    {0x2c,0x80a48001},
    {0x30,0xc2102274},
    {0x34,0x80a44001},
    {0x38,0x08800005},
    {0x3c,0x033fc180},
    {0x40,0x1b004000},
    {0x44,0x8210603c},
    {0x48,0xda204000},
    {0x4c,0x81c7e008},
    {0x50,0x81e80000},
    {0x54,0x9de3bf98},
    {0x58,0xc2002fbc},
    {0x5c,0x9fc04000},
    {0x60,0x01000000},
    {0x64,0x01000000},
    {0x68,0x81c7e008},
    {0x6c,0x81e80000},
    {0x70,0x9de3bf30},
    {0x74,0xe2502458},
    {0x78,0x80a46000},
    {0x7c,0x02800065},
    {0xf0,0x65},
    {0x00,0x01000000},
    {0x04,0xc208217f},
    {0x08,0x80a44001},
    {0x0c,0x16800061},
    {0x10,0xa0102001},
    {0x14,0xc208217e},
    {0x18,0x80a40001},
    {0x1c,0x1480005d},
    {0x20,0xe450245a},
    {0x24,0x96102001},
    {0x28,0xc208217f},
    {0x2c,0x80a2c001},
    {0x30,0x1480000f},
    {0x34,0x03000018},
    {0x38,0x9b2c2002},
    {0x3c,0x821060e0},
    {0x40,0x9a034001},
    {0x44,0x9a036040},
    {0x48,0x9807bf90},
    {0x4c,0xc2034000},
    {0x50,0xc2230000},
    {0x54,0x9602e001},
    {0x58,0xc208217f},
    {0x5c,0x80a2c001},
    {0x60,0x9a036040},
    {0x64,0x04bffffa},
    {0x68,0x98032004},
    {0x6c,0x9007bf90},
    {0x70,0x7ffff6b9},
    {0x74,0xd208217f},
    {0x78,0x96100012},
    {0x7c,0x80a48011},
    {0xf0,0x66},
    {0x00,0x1480000b},
    {0x04,0x94102000},
    {0x08,0x832ca002},
    {0x0c,0x8200401e},
    {0x10,0x9a007f90},
    {0x14,0xc2034000},
    {0x18,0x9602e001},
    {0x1c,0x94028001},
    {0x20,0x80a2c011},
    {0x24,0x04bffffc},
    {0x28,0x9a036004},
    {0x2c,0x82244012},
    {0x30,0x82006001},
    {0x34,0x9b3aa01f},
    {0x38,0x81836000},
    {0x3c,0x01000000},
    {0x40,0x01000000},
    {0x44,0x01000000},
    {0x48,0x947a8001},
    {0x4c,0xc25021ac},
    {0x50,0x80a28001},
    {0x54,0x26800002},
    {0x58,0x94100001},
    {0x5c,0x96102001},
    {0x60,0xc208217f},
    {0x64,0x80a2c001},
    {0x68,0x14800025},
    {0x6c,0x832c2002},
    {0x70,0x11000018},
    {0x74,0x98006040},
    {0x78,0x921220e0},
    {0x7c,0x80a2a000},
    {0xf0,0x67},
    {0x00,0x0480000b},
    {0x04,0x9a1220e0},
    {0x08,0xc203000d},
    {0x0c,0x80a0400a},
    {0x10,0x36800008},
    {0x14,0xc2030009},
    {0x18,0x80a06000},
    {0x1c,0x34800007},
    {0x20,0xc023000d},
    {0x24,0x10800006},
    {0x28,0xc20023c8},
    {0x2c,0xc2030009},
    {0x30,0x8220400a},
    {0x34,0xc2230009},
    {0x38,0xc20023c8},
    {0x3c,0x83306012},
    {0x40,0x80886001},
    {0x44,0x0280000a},
    {0x48,0x9602e001},
    {0x4c,0xda0c22af},
    {0x50,0xc2030009},
    {0x54,0x8258400d},
    {0x58,0x9b38601f},
    {0x5c,0x9b336019},
    {0x60,0x8200400d},
    {0x64,0x83386007},
    {0x68,0xc2230009},
    {0x6c,0xc208217f},
    {0x70,0x80a2c001},
    {0x74,0x04bfffe2},
    {0x78,0x98032040},
    {0x7c,0xa0042001},
    {0xf0,0x68},
    {0x00,0xc208217e},
    {0x04,0x80a40001},
    {0x08,0x04bfffa8},
    {0x0c,0x96102001},
    {0x10,0x81c7e008},
    {0x14,0x81e80000},
    {0x18,0x9de3bf98},
    {0x1c,0xc25023c6},
    {0x20,0x80a06000},
    {0x24,0x02800049},
    {0x28,0xb0102001},
    {0x2c,0xc208217e},
    {0x30,0x80a60001},
    {0x34,0x14800045},
    {0x38,0x1b000018},
    {0x3c,0x821360e0},
    {0x40,0x9e006004},
    {0x44,0xc208217f},
    {0x48,0x80a06000},
    {0x4c,0xba102000},
    {0x50,0x02800039},
    {0x54,0xb4102000},
    {0x58,0xb8100001},
    {0x5c,0xf25023c4},
    {0x60,0x8203e040},
    {0x64,0xf6004000},
    {0x68,0x80a6c019},
    {0x6c,0x06800004},
    {0x70,0x82006040},
    {0x74,0xba07401b},
    {0x78,0xb406a001},
    {0x7c,0xb8873fff},
    {0xf0,0x69},
    {0x00,0x32bffffa},
    {0x04,0xf6004000},
    {0x08,0x80a6a000},
    {0x0c,0x2280002b},
    {0x10,0xb0062001},
    {0x14,0xc21023c4},
    {0x18,0x80886001},
    {0x1c,0xc21023c6},
    {0x20,0x0280000a},
    {0x24,0xf808217f},
    {0x28,0x83286010},
    {0x2c,0x83386010},
    {0x30,0x825f4001},
    {0x34,0xbb38601f},
    {0x38,0xbb376016},
    {0x3c,0x8200401d},
    {0x40,0x1080000f},
    {0x44,0xbb38600a},
    {0x48,0x83286010},
    {0x4c,0x83386010},
    {0x50,0x993f601f},
    {0x54,0x81832000},
    {0x58,0x01000000},
    {0x5c,0x01000000},
    {0x60,0x01000000},
    {0x64,0xba7f401a},
    {0x68,0xba5f4001},
    {0x6c,0x833f601f},
    {0x70,0x83306016},
    {0x74,0xba074001},
    {0x78,0xbb3f600a},
    {0x7c,0x80a72000},
    {0xf0,0x6a},
    {0x00,0x0280000d},
    {0x04,0xb8102001},
    {0x08,0x832e2002},
    {0x0c,0xb6006040},
    {0x10,0xb41360e0},
    {0x14,0xc206c01a},
    {0x18,0x8220401d},
    {0x1c,0xc226c01a},
    {0x20,0xb8072001},
    {0x24,0xc208217f},
    {0x28,0x80a70001},
    {0x2c,0x04bffffa},
    {0x30,0xb606e040},
    {0x34,0xb0062001},
    {0x38,0xc208217e},
    {0x3c,0x80a60001},
    {0x40,0x04bfffc1},
    {0x44,0x9e03e004},
    {0x48,0x81c7e008},
    {0x4c,0x81e80000},
    {0x50,0xc2082573},
    {0x54,0xda00256c},
    {0x58,0x82006001},
    {0x5c,0xd808257f},
    {0x60,0x9a5b4001},
    {0x64,0x98032001},
    {0x68,0x81800000},
    {0x6c,0x01000000},
    {0x70,0x01000000},
    {0x74,0x01000000},
    {0x78,0x9a73400c},
    {0x7c,0xda20256c},
    {0xf0,0x6b},
    {0x00,0x96102000},
    {0x04,0x832ae002},
    {0x08,0xd800256c},
    {0x0c,0xda1063b6},
    {0x10,0x9a5b400c},
    {0x14,0x9b336007},
    {0x18,0x9602e001},
    {0x1c,0x80a2e003},
    {0x20,0x04bffff9},
    {0x24,0xda206520},
    {0x28,0xc20023c0},
    {0x2c,0x80a06000},
    {0x30,0x02800007},
    {0x34,0x82103000},
    {0x38,0xc2002200},
    {0x3c,0x80a06000},
    {0x40,0x22800005},
    {0x44,0xc200255c},
    {0x48,0x82103000},
    {0x4c,0xc220252c},
    {0x50,0xc200255c},
    {0x54,0x80a06000},
    {0x58,0x02800005},
    {0x5c,0xc2002288},
    {0x60,0x9b306001},
    {0x64,0x83306002},
    {0x68,0x8200400d},
    {0x6c,0xc220251c},
    {0x70,0x03000007},
    {0x74,0x81c06298},
    {0x78,0x01000000},
    {0x7c,0x01000000},
    {0xf0,0x6c},
    {0x00,0x9de3bf98},
    {0x04,0xc2002548},
    {0x08,0x80886100},
    {0x0c,0xaa102000},
    {0x10,0x128000cb},
    {0x14,0xa6102000},
    {0x18,0xc20026e4},
    {0x1c,0x80a06000},
    {0x20,0x02800004},
    {0x24,0xa2102001},
    {0x28,0x82007fff},
    {0x2c,0xc22026e4},
    {0x30,0xc2002300},
    {0x34,0x80a44001},
    {0x38,0x388000a5},
    {0x3c,0xda002530},
    {0x40,0xa4102001},
    {0x44,0xc2002308},
    {0x48,0x80a48001},
    {0x4c,0x1880008f},
    {0x50,0x03000050},
    {0x54,0xa8044001},
    {0x58,0xc2002514},
    {0x5c,0x80a06009},
    {0x60,0x1880009a},
    {0x64,0x9b2c6004},
    {0x68,0x9a034012},
    {0x6c,0x03000018},
    {0x70,0x821060e0},
    {0x74,0x9b2b6002},
    {0x78,0xda034001},
    {0x7c,0xc2002474},
    {0xf0,0x6d},
    {0x00,0x80a34001},
    {0x04,0x0680007b},
    {0x08,0x03000040},
    {0x0c,0x90100012},
    {0x10,0x7ffff9c2},
    {0x14,0x92100011},
    {0x18,0x80a22000},
    {0x1c,0x02800075},
    {0x20,0x03000040},
    {0x24,0xc2002ff0},
    {0x28,0x80a06000},
    {0x2c,0x2280000a},
    {0x30,0xc2002fe0},
    {0x34,0x90100012},
    {0x38,0x9fc04000},
    {0x3c,0x92100011},
    {0x40,0xc200259c},
    {0x44,0x80a06000},
    {0x48,0x1280006a},
    {0x4c,0x03000040},
    {0x50,0xc2002fe0},
    {0x54,0x80a06000},
    {0x58,0x2280000b},
    {0x5c,0xc2002ff4},
    {0x60,0x90100012},
    {0x64,0x92100011},
    {0x68,0x9fc04000},
    {0x6c,0xd4082473},
    {0x70,0xc200259c},
    {0x74,0x80a06000},
    {0x78,0x1280005e},
    {0x7c,0x03000040},
    {0xf0,0x6e},
    {0x00,0xc2002ff4},
    {0x04,0x80a06000},
    {0x08,0x02800006},
    {0x0c,0xa0102000},
    {0x10,0x90100012},
    {0x14,0x9fc04000},
    {0x18,0x92100011},
    {0x1c,0xe000259c},
    {0x20,0x90100012},
    {0x24,0x92100011},
    {0x28,0x94100010},
    {0x2c,0x7ffff9e6},
    {0x30,0xd6082473},
    {0x34,0x80a22000},
    {0x38,0x0280004e},
    {0x3c,0x03000040},
    {0x40,0xc2002fe0},
    {0x44,0x80a06000},
    {0x48,0x02800007},
    {0x4c,0x90100012},
    {0x50,0x92100011},
    {0x54,0x9fc04000},
    {0x58,0x94102100},
    {0x5c,0x10800004},
    {0x60,0x94100010},
    {0x64,0xc020259c},
    {0x68,0x94100010},
    {0x6c,0x90100012},
    {0x70,0x92100011},
    {0x74,0x7ffff9d4},
    {0x78,0x96102100},
    {0x7c,0x80a22000},
    {0xf0,0x6f},
    {0x00,0x22800011},
    {0x04,0xc2002514},
    {0x08,0xc200259c},
    {0x0c,0x80a06000},
    {0x10,0x3280000d},
    {0x14,0xc2002514},
    {0x18,0xc2002280},
    {0x1c,0xd8002514},
    {0x20,0xc22026e4},
    {0x24,0x9b2ca010},
    {0x28,0x832b2002},
    {0x2c,0x9a034011},
    {0x30,0xda206710},
    {0x34,0x98032001},
    {0x38,0xd8202514},
    {0x3c,0x10800006},
    {0x40,0xaa056001},
    {0x44,0x9b286002},
    {0x48,0xe8236710},
    {0x4c,0x82006001},
    {0x50,0xc2202514},
    {0x54,0xc2002514},
    {0x58,0x80a0600a},
    {0x5c,0x12800025},
    {0x60,0x03000040},
    {0x64,0x03000018},
    {0x68,0x9e1060e0},
    {0x6c,0xe6002710},
    {0x70,0x90102001},
    {0x74,0x932a2002},
    {0x78,0xd4026710},
    {0x7c,0x820aafff},
    {0xf0,0x70},
    {0x00,0x9932a010},
    {0x04,0x980b2fff},
    {0x08,0x9a0cefff},
    {0x0c,0x9734e010},
    {0x10,0x83286004},
    {0x14,0x8200400c},
    {0x18,0x960aefff},
    {0x1c,0x9b2b6004},
    {0x20,0x83286002},
    {0x24,0x9a03400b},
    {0x28,0xd800400f},
    {0x2c,0x9b2b6002},
    {0x30,0xc203400f},
    {0x34,0x80a30001},
    {0x38,0x36800004},
    {0x3c,0xd422670c},
    {0x40,0xe622670c},
    {0x44,0xa610000a},
    {0x48,0x90022001},
    {0x4c,0xc2002514},
    {0x50,0x80a20001},
    {0x54,0x2abfffe9},
    {0x58,0x932a2002},
    {0x5c,0x82007fff},
    {0x60,0xc2202514},
    {0x64,0x83286002},
    {0x68,0xc0206710},
    {0x6c,0x03000040},
    {0x70,0xa8050001},
    {0x74,0xa404a001},
    {0x78,0xc2002308},
    {0x7c,0x80a48001},
    {0xf0,0x71},
    {0x00,0x28bfff77},
    {0x04,0xc2002514},
    {0x08,0xa2046001},
    {0x0c,0xc2002300},
    {0x10,0x80a44001},
    {0x14,0x28bfff6c},
    {0x18,0xa4102001},
    {0x1c,0x80a4e000},
    {0x20,0x2280000b},
    {0x24,0xda002530},
    {0x28,0xda002514},
    {0x2c,0x80a36009},
    {0x30,0x38800007},
    {0x34,0xda002530},
    {0x38,0x832b6002},
    {0x3c,0xe6206710},
    {0x40,0x82036001},
    {0x44,0xc2202514},
    {0x48,0xda002530},
    {0x4c,0x80a5400d},
    {0x50,0x14800006},
    {0x54,0x82100015},
    {0x58,0xc2002514},
    {0x5c,0x80a34001},
    {0x60,0x28800002},
    {0x64,0x8210000d},
    {0x68,0x80a56000},
    {0x6c,0x02800004},
    {0x70,0xc2202530},
    {0x74,0x1080000a},
    {0x78,0xc20021f8},
    {0x7c,0x80a06000},
    {0xf0,0x72},
    {0x00,0x22800009},
    {0x04,0xc2002530},
    {0x08,0xc20026f8},
    {0x0c,0x80a06000},
    {0x10,0x22800004},
    {0x14,0xc0202530},
    {0x18,0x82006001},
    {0x1c,0xc22026f8},
    {0x20,0xc2002530},
    {0x24,0x80a06000},
    {0x28,0x02800005},
    {0x2c,0x01000000},
    {0x30,0xc2002548},
    {0x34,0x82106040},
    {0x38,0xc2202548},
    {0x3c,0x81c7e008},
    {0x40,0x81e80000},
    {0x44,0x82220009},
    {0x48,0x9a58400a},
    {0x4c,0x833b601f},
    {0x50,0x80a20009},
    {0x54,0x83306019},
    {0x58,0x04800004},
    {0x5c,0x90102000},
    {0x60,0x82034001},
    {0x64,0x91386007},
    {0x68,0x81c3e008},
    {0x6c,0x01000000},
    {0x70,0x9de3bf98},
    {0x74,0x7ffff9da},
    {0x78,0xa6102001},
    {0x7c,0xc208217f},
    {0xf0,0x73},
    {0x00,0x80a07fff},
    {0x04,0x2280001d},
    {0x08,0xa6102001},
    {0x0c,0x23000018},
    {0x10,0xa12ce006},
    {0x14,0x821460e8},
    {0x18,0xa41460e4},
    {0x1c,0xd2040001},
    {0x20,0xd408228c},
    {0x24,0x7fffffe8},
    {0x28,0xd0040012},
    {0x2c,0x9a1460e0},
    {0x30,0xd024000d},
    {0x34,0xc2002308},
    {0x38,0xa12ce004},
    {0x3c,0xa0040001},
    {0x40,0xa12c2002},
    {0x44,0xa21460dc},
    {0x48,0xd004000d},
    {0x4c,0xd2040011},
    {0x50,0x7fffffdd},
    {0x54,0xd408228d},
    {0x58,0xd0240012},
    {0x5c,0xc208217f},
    {0x60,0xa604e001},
    {0x64,0x82006001},
    {0x68,0x80a4c001},
    {0x6c,0x08bfffe9},
    {0x70,0x23000018},
    {0x74,0xa6102001},
    {0x78,0xc2002308},
    {0x7c,0x80a4c001},
    {0xf0,0x74},
    {0x00,0x1880001a},
    {0x04,0x23000018},
    {0x08,0xa12ce002},
    {0x0c,0x82146160},
    {0x10,0xa4146120},
    {0x14,0xd2040001},
    {0x18,0xd408228e},
    {0x1c,0x7fffffca},
    {0x20,0xd0040012},
    {0x24,0x821460e0},
    {0x28,0xd0240001},
    {0x2c,0xe0002300},
    {0x30,0xa12c2004},
    {0x34,0xa0040013},
    {0x38,0xa12c2002},
    {0x3c,0xa21460a0},
    {0x40,0xd0040001},
    {0x44,0xd2040011},
    {0x48,0x7fffffbf},
    {0x4c,0xd408228f},
    {0x50,0xd0240012},
    {0x54,0xa604e001},
    {0x58,0xc2002308},
    {0x5c,0x80a4c001},
    {0x60,0x08bfffea},
    {0x64,0x23000018},
    {0x68,0x81c7e008},
    {0x6c,0x81e80000},
    {0x70,0x9de3bf88},
    {0x74,0xc2002fe4},
    {0x78,0x9fc04000},
    {0x7c,0xd0002590},
    {0xf0,0x75},
    {0x00,0xda002550},
    {0x04,0x832b6004},
    {0x08,0x8220400d},
    {0x0c,0xe000259c},
    {0x10,0x82040001},
    {0x14,0x83306004},
    {0x18,0xc2202550},
    {0x1c,0x11000016},
    {0x20,0xc2002fe4},
    {0x24,0x9fc04000},
    {0x28,0x90122330},
    {0x2c,0xc208217c},
    {0x30,0xda08217d},
    {0x34,0x9a5b4001},
    {0x38,0xc200259c},
    {0x3c,0x8200400d},
    {0x40,0xc220259c},
    {0x44,0xda00259c},
    {0x48,0xc2002550},
    {0x4c,0x80a34001},
    {0x50,0x28800011},
    {0x54,0xc2002548},
    {0x58,0xc200259c},
    {0x5c,0x80a04010},
    {0x60,0x0880000d},
    {0x64,0xc2002548},
    {0x68,0x80a42000},
    {0x6c,0x0280000a},
    {0x70,0x01000000},
    {0x74,0x82087f7f},
    {0x78,0xc2202548},
    {0x7c,0xc2002658},
    {0xf0,0x76},
    {0x00,0x80a06000},
    {0x04,0x26800006},
    {0x08,0xc0202658},
    {0x0c,0x10800005},
    {0x10,0xc208254e},
    {0x14,0x82106080},
    {0x18,0xc2202548},
    {0x1c,0xc208254e},
    {0x20,0x80a00001},
    {0x24,0x82602000},
    {0x28,0xa0087ffe},
    {0x2c,0xd8002548},
    {0x30,0x83332010},
    {0x34,0x80886001},
    {0x38,0x02800012},
    {0x3c,0xa0042003},
    {0x40,0x03000180},
    {0x44,0x820b0001},
    {0x48,0x1b000080},
    {0x4c,0x80a0400d},
    {0x50,0x22800064},
    {0x54,0xc02026d4},
    {0x58,0xc2002160},
    {0x5c,0x80886040},
    {0x60,0x0280002f},
    {0x64,0xa0102000},
    {0x68,0xc2002558},
    {0x6c,0x80a06000},
    {0x70,0x0280002b},
    {0x74,0xa0102002},
    {0x78,0x10800029},
    {0x7c,0xa0102000},
    {0xf0,0x77},
    {0x00,0x033fc200},
    {0x04,0x82106030},
    {0x08,0xda004000},
    {0x0c,0xc2002570},
    {0x10,0x80a34001},
    {0x14,0x32800053},
    {0x18,0xc02026d4},
    {0x1c,0xc2002200},
    {0x20,0x80a06000},
    {0x24,0x3280004f},
    {0x28,0xc02026d4},
    {0x2c,0xda002690},
    {0x30,0x03000007},
    {0x34,0x808b4001},
    {0x38,0x3280004a},
    {0x3c,0xc02026d4},
    {0x40,0x808b2001},
    {0x44,0x32800047},
    {0x48,0xc02026d4},
    {0x4c,0xda002654},
    {0x50,0xc20021dc},
    {0x54,0x80a34001},
    {0x58,0x2a800008},
    {0x5c,0xc2002514},
    {0x60,0xc200254c},
    {0x64,0x8330600e},
    {0x68,0x80886001},
    {0x6c,0x1280000a},
    {0x70,0x808b2040},
    {0x74,0xc2002514},
    {0x78,0x80a06000},
    {0x7c,0x22800009},
    {0xf0,0x78},
    {0x00,0xc20c2314},
    {0x04,0x808b2080},
    {0x08,0x22800006},
    {0x0c,0xc20c2314},
    {0x10,0x808b2040},
    {0x14,0x32800033},
    {0x18,0xc02026d4},
    {0x1c,0xc20c2314},
    {0x20,0x80a06000},
    {0x24,0x2280002f},
    {0x28,0xc02026d4},
    {0x2c,0xc20026d4},
    {0x30,0x98006001},
    {0x34,0xc2002700},
    {0x38,0xda082169},
    {0x3c,0xd82026d4},
    {0x40,0x80a0400d},
    {0x44,0x0480000a},
    {0x48,0xc20c2314},
    {0x4c,0x820860ff},
    {0x50,0xda082168},
    {0x54,0x8258400d},
    {0x58,0x80a30001},
    {0x5c,0x06800021},
    {0x60,0x01000000},
    {0x64,0x10800007},
    {0x68,0xc02026d4},
    {0x6c,0x820860ff},
    {0x70,0x80a30001},
    {0x74,0x0680001b},
    {0x78,0x01000000},
    {0x7c,0xc02026d4},
    {0xf0,0x79},
    {0x00,0xc20c234c},
    {0x04,0xc227bfec},
    {0x08,0xc20c230c},
    {0x0c,0xc227bff0},
    {0x10,0xa0102000},
    {0x14,0xc208217c},
    {0x18,0x80a40001},
    {0x1c,0x1a800011},
    {0x20,0x01000000},
    {0x24,0xc20c2380},
    {0x28,0xc227bfe8},
    {0x2c,0xa2102000},
    {0x30,0xc208217d},
    {0x34,0x80a44001},
    {0x38,0x3a800006},
    {0x3c,0xa0042001},
    {0x40,0x7ffff91b},
    {0x44,0x9007bfe8},
    {0x48,0x10bffffa},
    {0x4c,0xa2046001},
    {0x50,0xc208217c},
    {0x54,0x80a40001},
    {0x58,0x2abffff4},
    {0x5c,0xc20c2380},
    {0x60,0x81c7e008},
    {0x64,0x81e80000},
    {0x68,0xd2002208},
    {0x6c,0x80a26000},
    {0x70,0x0280001a},
    {0x74,0x01000000},
    {0x78,0xc2102548},
    {0x7c,0x80886001},
    {0xf0,0x7a},
    {0x00,0x12800016},
    {0x04,0x01000000},
    {0x08,0xc2002514},
    {0x0c,0x80a06000},
    {0x10,0x12800007},
    {0x14,0xc2002558},
    {0x18,0x80a06000},
    {0x1c,0x0280000f},
    {0x20,0x9a007fff},
    {0x24,0x1080000d},
    {0x28,0xda202558},
    {0x2c,0x15200040},
    {0x30,0x1b3fc200},
    {0x34,0x9812a001},
    {0x38,0x80a06000},
    {0x3c,0x12800006},
    {0x40,0x96136070},
    {0x44,0xd8234000},
    {0x48,0xc2002298},
    {0x4c,0xc222c000},
    {0x50,0xd4234000},
    {0x54,0xd2202558},
    {0x58,0x81c3e008},
    {0x5c,0x01000000},
    {0x60,0x92102000},
    {0x64,0xc2002514},
    {0x68,0x80a24001},
    {0x6c,0x1a800019},
    {0x70,0x912a6002},
    {0x74,0xd4022710},
    {0x78,0x820aafff},
    {0x7c,0x9732a010},
    {0xf0,0x7b},
    {0x00,0x98006001},
    {0x04,0x960aefff},
    {0x08,0x82007fff},
    {0x0c,0x83286018},
    {0x10,0x992b2010},
    {0x14,0x9a02ffff},
    {0x18,0x8200400c},
    {0x1c,0x9b2b6008},
    {0x20,0x8200400d},
    {0x24,0x8200400b},
    {0x28,0x9532a00c},
    {0x2c,0x92026001},
    {0x30,0x808aa001},
    {0x34,0x12800003},
    {0x38,0x82006001},
    {0x3c,0xc2222738},
    {0x40,0xc2002514},
    {0x44,0x80a24001},
    {0x48,0x0abfffeb},
    {0x4c,0x912a6002},
    {0x50,0x81c3e008},
    {0x54,0x01000000},
    {0x58,0x9de3bf98},
    {0x5c,0x94102000},
    {0x60,0xc2002514},
    {0x64,0x80a28001},
    {0x68,0x1a80005d},
    {0x6c,0x96102000},
    {0x70,0xbb2aa002},
    {0x74,0xf20f6738},
    {0x78,0xc20f6739},
    {0x7c,0x80a64001},
    {0xf0,0x7c},
    {0x00,0x98102000},
    {0x04,0x9e102000},
    {0x08,0x14800020},
    {0x0c,0x9a102000},
    {0x10,0x03000018},
    {0x14,0x921060e0},
    {0x18,0xc20f673b},
    {0x1c,0xf60f673a},
    {0x20,0x80a6c001},
    {0x24,0x14800013},
    {0x28,0x832e6004},
    {0x2c,0x8200401b},
    {0x30,0x83286002},
    {0x34,0x82004009},
    {0x38,0xf80ae73b},
    {0x3c,0xfa004000},
    {0x40,0xb05f401b},
    {0x44,0x82006004},
    {0x48,0xb606e001},
    {0x4c,0x80a76000},
    {0x50,0x04800005},
    {0x54,0xb45f4019},
    {0x58,0x9e03c01a},
    {0x5c,0x9a034018},
    {0x60,0x9803001d},
    {0x64,0x80a6c01c},
    {0x68,0x24bffff6},
    {0x6c,0xfa004000},
    {0x70,0xbb2aa002},
    {0x74,0xb2066001},
    {0x78,0xc20f6739},
    {0x7c,0x80a64001},
    {0xf0,0x7d},
    {0x00,0x24bfffe7},
    {0x04,0xc20f673b},
    {0x08,0xbb2b6006},
    {0x0c,0xb92be006},
    {0x10,0xc202e710},
    {0x14,0x9b3f201f},
    {0x18,0x81836000},
    {0x1c,0x01000000},
    {0x20,0x01000000},
    {0x24,0x01000000},
    {0x28,0xb87f000c},
    {0x2c,0x9b3f601f},
    {0x30,0x81836000},
    {0x34,0x01000000},
    {0x38,0x01000000},
    {0x3c,0x01000000},
    {0x40,0xba7f400c},
    {0x44,0x8330600c},
    {0x48,0x80886001},
    {0x4c,0x9e073fe0},
    {0x50,0x02800007},
    {0x54,0x9a077fe0},
    {0x58,0xc200237c},
    {0x5c,0x80a06000},
    {0x60,0x22800003},
    {0x64,0x9e073fa0},
    {0x68,0x9a077fa0},
    {0x6c,0x80a3e000},
    {0x70,0x24800002},
    {0x74,0x9e102001},
    {0x78,0x80a36000},
    {0x7c,0x24800002},
    {0xf0,0x7e},
    {0x00,0x9a102001},
    {0x04,0xc208217f},
    {0x08,0x83286006},
    {0x0c,0x80a3c001},
    {0x10,0x36800002},
    {0x14,0x9e007fff},
    {0x18,0xc208217e},
    {0x1c,0x83286006},
    {0x20,0x80a34001},
    {0x24,0x36800002},
    {0x28,0x9a007fff},
    {0x2c,0xfa02e710},
    {0x30,0x832be010},
    {0x34,0x393c003c},
    {0x38,0x8200400d},
    {0x3c,0xba0f401c},
    {0x40,0x8200401d},
    {0x44,0xc222e710},
    {0x48,0x9402a001},
    {0x4c,0xc2002514},
    {0x50,0x80a28001},
    {0x54,0x0abfffa7},
    {0x58,0x9602e004},
    {0x5c,0x7ffff70a},
    {0x60,0x91e8205a},
    {0x64,0x01000000},
    {0x68,0x9de3bf98},
    {0x6c,0xd8002548},
    {0x70,0x8333200c},
    {0x74,0x80886001},
    {0x78,0x12800081},
    {0x7c,0x01000000},
    {0xf0,0x7f},
    {0x00,0xc208254d},
    {0x04,0x80a06000},
    {0x08,0x1280007d},
    {0x0c,0x01000000},
    {0x10,0xc208254e},
    {0x14,0x80a06000},
    {0x18,0x02800079},
    {0x1c,0x01000000},
    {0x20,0xc2002554},
    {0x24,0x825860fa},
    {0x28,0xda002500},
    {0x2c,0x80a34001},
    {0x30,0x0a800073},
    {0x34,0x01000000},
    {0x38,0xd6002658},
    {0x3c,0x80a2e000},
    {0x40,0x1480001c},
    {0x44,0x8202ffff},
    {0x48,0xc2002514},
    {0x4c,0x80a06001},
    {0x50,0x3280006b},
    {0x54,0xc0202658},
    {0x58,0xc2002710},
    {0x5c,0x80a06000},
    {0x60,0x12800004},
    {0x64,0x808b2040},
    {0x68,0x10800065},
    {0x6c,0xc0202658},
    {0x70,0x32800006},
    {0x74,0xd800239c},
    {0x78,0x80a2e000},
    {0x7c,0x0680000d},
    {0xf0,0x80},
    {0x00,0x8202e001},
    {0x04,0xd800239c},
    {0x08,0x0300003f},
    {0x0c,0x9b332010},
    {0x10,0x821063ff},
    {0x14,0x980b0001},
    {0x18,0x9a38000d},
    {0x1c,0x9a23400c},
    {0x20,0x80a2c00d},
    {0x24,0x06800005},
    {0x28,0x03296956},
    {0x2c,0x8202ffff},
    {0x30,0x10800053},
    {0x34,0xc2202658},
    {0x38,0x9a10625a},
    {0x3c,0xc200250c},
    {0x40,0x80a0400d},
    {0x44,0x02800004},
    {0x48,0xa0102000},
    {0x4c,0xda20250c},
    {0x50,0xc0202654},
    {0x54,0x832c2002},
    {0x58,0x92006610},
    {0x5c,0xc2006610},
    {0x60,0x90102710},
    {0x64,0x80a06000},
    {0x68,0x0280000d},
    {0x6c,0xa0042001},
    {0x70,0x7ffff73a},
    {0x74,0x01000000},
    {0x78,0xc2002300},
    {0x7c,0xda002308},
    {0xf0,0x81},
    {0x00,0x82584001},
    {0x04,0x9a5b400d},
    {0x08,0x8200400d},
    {0x0c,0x83286006},
    {0x10,0x80a20001},
    {0x14,0x0a80003a},
    {0x18,0x01000000},
    {0x1c,0x80a4200f},
    {0x20,0x08bfffee},
    {0x24,0x832c2002},
    {0x28,0x030041eb},
    {0x2c,0xc2202658},
    {0x30,0xa010200f},
    {0x34,0x9b2c2002},
    {0x38,0xc203660c},
    {0x3c,0xa0843fff},
    {0x40,0x12bffffd},
    {0x44,0xc2236610},
    {0x48,0xda002654},
    {0x4c,0xc2002710},
    {0x50,0xc2202610},
    {0x54,0x80a3600f},
    {0x58,0x14800003},
    {0x5c,0x9010200f},
    {0x60,0x9010000d},
    {0x64,0x03000014},
    {0x68,0x9e1062a8},
    {0x6c,0x82006800},
    {0x70,0xa2106330},
    {0x74,0x0300003f},
    {0x78,0xa61063ff},
    {0x7c,0x92022001},
    {0xf0,0x82},
    {0x00,0xa0102000},
    {0x04,0xa410000f},
    {0x08,0x972c2002},
    {0x0c,0x8203c00b},
    {0x10,0xda106002},
    {0x14,0x9804400b},
    {0x18,0xd4132002},
    {0x1c,0xc213c00b},
    {0x20,0xd814400b},
    {0x24,0x82584008},
    {0x28,0x9a5b4008},
    {0x2c,0x8200400c},
    {0x30,0x9a03400a},
    {0x34,0x81800000},
    {0x38,0x01000000},
    {0x3c,0x01000000},
    {0x40,0x01000000},
    {0x44,0x82704009},
    {0x48,0x81800000},
    {0x4c,0x01000000},
    {0x50,0x01000000},
    {0x54,0x01000000},
    {0x58,0x9a734009},
    {0x5c,0x83286010},
    {0x60,0x9a0b4013},
    {0x64,0x8200400d},
    {0x68,0xa0042001},
    {0x6c,0x80a420b5},
    {0x70,0x08bfffe6},
    {0x74,0xc222c012},
    {0x78,0xd2202654},
    {0x7c,0x81c7e008},
    {0xf0,0x83},
    {0x00,0x81e80000},
    {0x04,0x9de3bf98},
    {0x08,0xa2102000},
    {0x0c,0xc2002514},
    {0x10,0x80a44001},
    {0x14,0xa0102000},
    {0x18,0x1a800012},
    {0x1c,0x832c2002},
    {0x20,0x92006710},
    {0x24,0xc2006710},
    {0x28,0x80a06000},
    {0x2c,0x02800009},
    {0x30,0x90100018},
    {0x34,0x7ffff6e9},
    {0x38,0x01000000},
    {0x3c,0x82102001},
    {0x40,0x80a20019},
    {0x44,0x1a800003},
    {0x48,0x83284010},
    {0x4c,0xa2144001},
    {0x50,0xa0042001},
    {0x54,0xc2002514},
    {0x58,0x10bffff0},
    {0x5c,0x80a40001},
    {0x60,0x81c7e008},
    {0x64,0x91e80011},
    {0x68,0x9de3bf90},
    {0x6c,0x03003fc0},
    {0x70,0x82106001},
    {0x74,0xc227bff0},
    {0x78,0xc027bff4},
    {0x7c,0xa0102000},
    {0xf0,0x84},
    {0x00,0x8207bff8},
    {0x04,0x82040001},
    {0x08,0xd2487ff9},
    {0x0c,0xd0487ff8},
    {0x10,0x90060008},
    {0x14,0x92064009},
    {0x18,0x94102000},
    {0x1c,0x7ffff72a},
    {0x20,0x9610001a},
    {0x24,0x80a22000},
    {0x28,0x02800004},
    {0x2c,0xa0042001},
    {0x30,0x10800006},
    {0x34,0xb0102001},
    {0x38,0x80a42004},
    {0x3c,0x04bffff2},
    {0x40,0x8207bff8},
    {0x44,0xb0102000},
    {0x48,0x81c7e008},
    {0x4c,0x81e80000},
    {0x50,0x9de3bf98},
    {0x54,0xc2102548},
    {0x58,0x80886001},
    {0x5c,0xb8102000},
    {0x60,0xba102000},
    {0x64,0x02800004},
    {0x68,0xae102000},
    {0x6c,0x10800029},
    {0x70,0xec002354},
    {0x74,0xc200254c},
    {0x78,0x80886200},
    {0x7c,0x32800010},
    {0xf0,0x85},
    {0x00,0xc2002690},
    {0x04,0x03296956},
    {0x08,0xda00250c},
    {0x0c,0x8210625a},
    {0x10,0x80a34001},
    {0x14,0x12800006},
    {0x18,0xc20023c8},
    {0x1c,0x80886800},
    {0x20,0x32800007},
    {0x24,0xc2002690},
    {0x28,0xc20023c8},
    {0x2c,0x80886400},
    {0x30,0x22800018},
    {0x34,0xec0022ac},
    {0x38,0xc2002690},
    {0x3c,0x80886200},
    {0x40,0x1280000d},
    {0x44,0xb8102001},
    {0x48,0x13000014},
    {0x4c,0x921262a8},
    {0x50,0xc2002fd0},
    {0x54,0x9fc04000},
    {0x58,0xd0002590},
    {0x5c,0xc2002fbc},
    {0x60,0x9fc04000},
    {0x64,0x01000000},
    {0x68,0xc2002690},
    {0x6c,0x82106200},
    {0x70,0xc2202690},
    {0x74,0x10800007},
    {0x78,0xec0023a0},
    {0x7c,0xc200254c},
    {0xf0,0x86},
    {0x00,0x1b000080},
    {0x04,0x8210400d},
    {0x08,0x10800084},
    {0x0c,0xc220254c},
    {0x10,0x7ffff61d},
    {0x14,0x901020aa},
    {0x18,0xda002500},
    {0x1c,0xc20022d0},
    {0x20,0x80a34001},
    {0x24,0x3880000f},
    {0x28,0xba102001},
    {0x2c,0xc2002200},
    {0x30,0x80a00001},
    {0x34,0x9a402000},
    {0x38,0x80a00016},
    {0x3c,0x82603fff},
    {0x40,0x80934001},
    {0x44,0x32800007},
    {0x48,0xba102001},
    {0x4c,0xc2002548},
    {0x50,0x80886001},
    {0x54,0x02800004},
    {0x58,0xaa102000},
    {0x5c,0xba102001},
    {0x60,0xaa102000},
    {0x64,0xa52d6003},
    {0x68,0xc204a760},
    {0x6c,0x80a06000},
    {0x70,0x22800067},
    {0x74,0xaa056001},
    {0x78,0x80a56000},
    {0x7c,0x12800008},
    {0xf0,0x87},
    {0x00,0x80a76000},
    {0x04,0xc200255c},
    {0x08,0x80a06000},
    {0x0c,0x1280000c},
    {0x10,0x29200000},
    {0x14,0x1080000a},
    {0x18,0xa8102000},
    {0x1c,0x02800005},
    {0x20,0x9004a760},
    {0x24,0xc024a764},
    {0x28,0x10800058},
    {0x2c,0xc024a760},
    {0x30,0x7fffff75},
    {0x34,0x92100016},
    {0x38,0xa8100008},
    {0x3c,0x80a52000},
    {0x40,0x02800050},
    {0x44,0xae15c014},
    {0x48,0xc214a766},
    {0x4c,0x80a06000},
    {0x50,0x0280000a},
    {0x54,0x80a56000},
    {0x58,0xc204a764},
    {0x5c,0x82007fff},
    {0x60,0xc224a764},
    {0x64,0xc214a766},
    {0x68,0x80a06000},
    {0x6c,0x32800048},
    {0x70,0xaa056001},
    {0x74,0x80a56000},
    {0x78,0x12800006},
    {0x7c,0x1b004000},
    {0xf0,0x88},
    {0x00,0xc200254c},
    {0x04,0x8210400d},
    {0x08,0x10800040},
    {0x0c,0xc220254c},
    {0x10,0xc2102548},
    {0x14,0x80886001},
    {0x18,0x02800006},
    {0x1c,0x82103fff},
    {0x20,0xc024a764},
    {0x24,0xc024a760},
    {0x28,0x10800038},
    {0x2c,0xc2202700},
    {0x30,0x80a72000},
    {0x34,0x02bfffb2},
    {0x38,0xa6102000},
    {0x3c,0xc2002514},
    {0x40,0x80a4c001},
    {0x44,0x1a80002c},
    {0x48,0x83350013},
    {0x4c,0x80886001},
    {0x50,0x02800027},
    {0x54,0x9b2ce002},
    {0x58,0xe0036710},
    {0x5c,0xa3342016},
    {0x60,0xa00c2fff},
    {0x64,0xa13c2006},
    {0x68,0xa20c603f},
    {0x6c,0xa0042001},
    {0x70,0xa2046001},
    {0x74,0x92100011},
    {0x78,0xd410246e},
    {0x7c,0x7fffff5b},
    {0xf0,0x89},
    {0x00,0x90100010},
    {0x04,0x80a22000},
    {0x08,0x92100011},
    {0x0c,0x1280000f},
    {0x10,0x90100010},
    {0x14,0xc210246c},
    {0x18,0x94906000},
    {0x1c,0x2280000f},
    {0x20,0xc200254c},
    {0x24,0xc2002548},
    {0x28,0x80886080},
    {0x2c,0x2280000b},
    {0x30,0xc200254c},
    {0x34,0x7fffff4d},
    {0x38,0x01000000},
    {0x3c,0x80a22000},
    {0x40,0x22800006},
    {0x44,0xc200254c},
    {0x48,0x82102001},
    {0x4c,0x83284013},
    {0x50,0x10800007},
    {0x54,0xa82d0001},
    {0x58,0x1b000080},
    {0x5c,0x8210400d},
    {0x60,0xc220254c},
    {0x64,0x10800004},
    {0x68,0xc02026e8},
    {0x6c,0x10bfffd4},
    {0x70,0xa604e001},
    {0x74,0x80a52000},
    {0x78,0x32800005},
    {0x7c,0xaa056001},
    {0xf0,0x8a},
    {0x00,0xc024a764},
    {0x04,0xc024a760},
    {0x08,0xaa056001},
    {0x0c,0x80a56013},
    {0x10,0x04bfff96},
    {0x14,0xa52d6003},
    {0x18,0x80a5e000},
    {0x1c,0x22800002},
    {0x20,0xc02026e8},
    {0x24,0xc200255c},
    {0x28,0x80a06000},
    {0x2c,0x0280000a},
    {0x30,0x80a76000},
    {0x34,0xc2002760},
    {0x38,0x80a06000},
    {0x3c,0x12800006},
    {0x40,0x80a76000},
    {0x44,0x03000004},
    {0x48,0xc2202760},
    {0x4c,0xc2002248},
    {0x50,0xc2202764},
    {0x54,0x1280002b},
    {0x58,0xaa102000},
    {0x5c,0xc2002514},
    {0x60,0x80a54001},
    {0x64,0x1a800027},
    {0x68,0x96102001},
    {0x6c,0x992d6002},
    {0x70,0xc2032710},
    {0x74,0x8330600c},
    {0x78,0x80886001},
    {0x7c,0x3280001d},
    {0xf0,0x8b},
    {0x00,0xaa056001},
    {0x04,0x832ac015},
    {0x08,0x808dc001},
    {0x0c,0x32800019},
    {0x10,0xaa056001},
    {0x14,0xa6102001},
    {0x18,0x9b2ce003},
    {0x1c,0xc2036760},
    {0x20,0x80a06000},
    {0x24,0x1280000f},
    {0x28,0xa604e001},
    {0x2c,0xc2032710},
    {0x30,0xc2236760},
    {0x34,0xc2102548},
    {0x38,0x80886001},
    {0x3c,0x02800004},
    {0x40,0x80a72000},
    {0x44,0x10800005},
    {0x48,0xc2002358},
    {0x4c,0x22800003},
    {0x50,0xc2002378},
    {0x54,0xc200239c},
    {0x58,0x10800005},
    {0x5c,0xc2236764},
    {0x60,0x80a4e013},
    {0x64,0x04bfffee},
    {0x68,0x9b2ce003},
    {0x6c,0xaa056001},
    {0x70,0xc2002514},
    {0x74,0x80a54001},
    {0x78,0x0abfffde},
    {0x7c,0x992d6002},
    {0xf0,0x8c},
    {0x00,0x81c7e008},
    {0x04,0x81e80000},
    {0x08,0x9de3bf98},
    {0x0c,0x7ffff6b4},
    {0x10,0x01000000},
    {0x14,0xda002548},
    {0x18,0x83336010},
    {0x1c,0x80886001},
    {0x20,0x1280001d},
    {0x24,0x8333600c},
    {0x28,0x80886001},
    {0x2c,0x1280001a},
    {0x30,0x01000000},
    {0x34,0xc208254d},
    {0x38,0x80a06000},
    {0x3c,0x02800016},
    {0x40,0x033fc180},
    {0x44,0xc0204000},
    {0x48,0xa0102002},
    {0x4c,0x7ffff6fa},
    {0x50,0x90102001},
    {0x54,0x11000099},
    {0x58,0x7ffff1cf},
    {0x5c,0x9012233c},
    {0x60,0xa0843fff},
    {0x64,0x1cbffffa},
    {0x68,0x01000000},
    {0x6c,0x7ffff6f2},
    {0x70,0x90102000},
    {0x74,0xc210254c},
    {0x78,0x80886001},
    {0x7c,0x32800002},
    {0xf0,0x8d},
    {0x00,0xc020250c},
    {0x04,0x7ffff41e},
    {0x08,0x90102015},
    {0x0c,0x82102001},
    {0x10,0xc2202584},
    {0x14,0x81c7e008},
    {0x18,0x81e80000},
    {0x1c,0xc2002588},
    {0x20,0x80a06000},
    {0x24,0x32800006},
    {0x28,0xc200258c},
    {0x2c,0xc2002554},
    {0x30,0xc2202588},
    {0x34,0xc0202594},
    {0x38,0xc200258c},
    {0x3c,0x80a06000},
    {0x40,0x32800006},
    {0x44,0xc2102548},
    {0x48,0xc2002554},
    {0x4c,0xc220258c},
    {0x50,0xc0202598},
    {0x54,0xc2102548},
    {0x58,0x80886001},
    {0x5c,0x02800007},
    {0x60,0x01000000},
    {0x64,0xc2002558},
    {0x68,0x80a06001},
    {0x6c,0x18800003},
    {0x70,0x82102001},
    {0x74,0xc2202584},
    {0x78,0x81c3e008},
    {0x7c,0x01000000},
    {0xf0,0x8e},
    {0x00,0xc2002548},
    {0x04,0x8330600e},
    {0x08,0x80886001},
    {0x0c,0x12800058},
    {0x10,0x98102000},
    {0x14,0xc2002514},
    {0x18,0x80a30001},
    {0x1c,0x1a80000b},
    {0x20,0x033fc180},
    {0x24,0x96106004},
    {0x28,0x832b2002},
    {0x2c,0xda006710},
    {0x30,0xda20400b},
    {0x34,0x98032001},
    {0x38,0xc2002514},
    {0x3c,0x80a30001},
    {0x40,0x0abffffb},
    {0x44,0x832b2002},
    {0x48,0xda00254c},
    {0x4c,0x808b6001},
    {0x50,0x32800008},
    {0x54,0xc208254e},
    {0x58,0xc2002514},
    {0x5c,0x9a136001},
    {0x60,0x82106100},
    {0x64,0xda20254c},
    {0x68,0xc2202514},
    {0x6c,0xc208254e},
    {0x70,0x80a06000},
    {0x74,0x3280000b},
    {0x78,0xc2082517},
    {0x7c,0xc20023c8},
    {0xf0,0x8f},
    {0x00,0x83306016},
    {0x04,0x80886001},
    {0x08,0x22800006},
    {0x0c,0xc2082517},
    {0x10,0xc2002514},
    {0x14,0x82106200},
    {0x18,0xc2202514},
    {0x1c,0xc2082517},
    {0x20,0x80a06000},
    {0x24,0x2280001d},
    {0x28,0xda002514},
    {0x2c,0xc2002548},
    {0x30,0x80886800},
    {0x34,0x22800006},
    {0x38,0xd80023c8},
    {0x3c,0xc2002514},
    {0x40,0x82106400},
    {0x44,0xc2202514},
    {0x48,0xd80023c8},
    {0x4c,0x80a32000},
    {0x50,0x16800007},
    {0x54,0x8333200c},
    {0x58,0xc2002514},
    {0x5c,0x1b000004},
    {0x60,0x8210400d},
    {0x64,0xc2202514},
    {0x68,0x8333200c},
    {0x6c,0x80886001},
    {0x70,0x2280000a},
    {0x74,0xda002514},
    {0x78,0xc2002540},
    {0x7c,0x1b164020},
    {0xf0,0x90},
    {0x00,0x83286010},
    {0x04,0x8200400d},
    {0x08,0xda002514},
    {0x0c,0x9a134001},
    {0x10,0xda202514},
    {0x14,0xda002514},
    {0x18,0x03000020},
    {0x1c,0x808b4001},
    {0x20,0x1280000e},
    {0x24,0xc0202540},
    {0x28,0xc2082517},
    {0x2c,0x80a06000},
    {0x30,0x32800007},
    {0x34,0xc2002500},
    {0x38,0xc2002560},
    {0x3c,0x80a06000},
    {0x40,0x22800007},
    {0x44,0xd8082517},
    {0x48,0xc2002500},
    {0x4c,0x83286010},
    {0x50,0x82134001},
    {0x54,0xc2202514},
    {0x58,0xd8082517},
    {0x5c,0xda002514},
    {0x60,0x033fc180},
    {0x64,0xda204000},
    {0x68,0xd8202568},
    {0x6c,0x81c3e008},
    {0x70,0x01000000},
    {0x74,0x9de3bf98},
    {0x78,0xd8002548},
    {0x7c,0x8333200e},
    {0xf0,0x91},
    {0x00,0x80886001},
    {0x04,0x22800006},
    {0x08,0xc2102516},
    {0x0c,0x03000010},
    {0x10,0x822b0001},
    {0x14,0x10800022},
    {0x18,0xc2202548},
    {0x1c,0x80a06000},
    {0x20,0x0280000a},
    {0x24,0x9b332003},
    {0x28,0x808b2004},
    {0x2c,0x2280000e},
    {0x30,0xc200231c},
    {0x34,0xc2002160},
    {0x38,0x80886400},
    {0x3c,0x3280000a},
    {0x40,0xc200231c},
    {0x44,0x9b332003},
    {0x48,0x83332002},
    {0x4c,0x82086001},
    {0x50,0x9a0b6001},
    {0x54,0x80a0400d},
    {0x58,0x2280000a},
    {0x5c,0xc2002560},
    {0x60,0xc200231c},
    {0x64,0x80a06000},
    {0x68,0x22800003},
    {0x6c,0xc2082360},
    {0x70,0x82102005},
    {0x74,0xc2202560},
    {0x78,0x10800007},
    {0x7c,0x90102001},
    {0xf0,0x92},
    {0x00,0x80a06000},
    {0x04,0x02800004},
    {0x08,0x90102000},
    {0x0c,0x10bffffa},
    {0x10,0x82007fff},
    {0x14,0x7ffff648},
    {0x18,0x01000000},
    {0x1c,0xc2002548},
    {0x20,0x9a004001},
    {0x24,0x9a0b6008},
    {0x28,0x82087ff7},
    {0x2c,0x8210400d},
    {0x30,0xc2202548},
    {0x34,0x81c7e008},
    {0x38,0x81e80000},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x00000000},
    {0x6c,0x00000000},
    {0x70,0x00000000},
    {0x74,0x00000000},
    {0x78,0x00000000},
    {0x7c,0x00000000},
    {0xf0,0x93},
    {0x00,0x00003670},
    {0x04,0xa5010503},
    {0x08,0xa5000022},
    {0x0c,0x00000000},
    {0x10,0x4c494348},
    {0x14,0x49444449},
    {0x18,0x80cb88ec},
    {0x1c,0xbdae39cf},
    {0x20,0x864880cd},
    {0x24,0xc96fbe71},
    {0x28,0x924380d1},
    {0x2c,0xc471cce5},
    {0x30,0xc9e5c400},
    {0x34,0xbc0dbc43},
    {0x38,0xc643bd13},
    {0x3c,0x00000000},
    {0x40,0x00000000},
    {0x44,0x00000000},
    {0x48,0x00000000},
    {0x4c,0x00000000},
    {0x50,0x00000000},
    {0x54,0x00000000},
    {0x58,0x00000000},
    {0x5c,0x00000000},
    {0x60,0x00000000},
    {0x64,0x00000000},
    {0x68,0x4a616e20},
    {0x6c,0x20382032},
    {0x70,0x30313800},
    {0x74,0x00000000},
    {0x78,0x31343a32},
    {0x7c,0x343a3439},
    
    
    };
    
    
    

#ifdef __cplusplus
}
#endif


#endif




